/*
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, you can obtain one at http://mozilla.org/MPL/2.0/.
 */

package org.mozilla.gecko.util;

import java.util.regex.Pattern;

/**
 * Utilities for UUIDs.
 */
public class UUIDUtil {
    private UUIDUtil() {}

    public static final String UUID_REGEX = "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}";
    public static final Pattern UUID_PATTERN = Pattern.compile(UUID_REGEX);
}
