#include <stdio.h>


#define INTERVAL_MAX_INTEGER ((1<<30)-1)

/*-------------------------------------------------------------------------*/
/* MOST_SIGNIFICANT_BIT                                                    */
/*                                                                         */
/*-------------------------------------------------------------------------*/
int Most_Significant_Bit(unsigned x)

{
 int bit=31;

 if (x>>(16)==0)         bit-=16, x <<= 16;
 if (x>>(16+8)==0)       bit-= 8, x <<=  8;
 if (x>>(16+8+4)==0)     bit-= 4, x <<=  4;
 if (x>>(16+8+4+2)==0)   bit-= 2, x <<=  2;
 if (x>>(16+8+4+2+1)==0) bit-= 1;

 return bit;
}


/*-------------------------------------------------------------------------*/
/* POWER                                                                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/
unsigned Power(unsigned x,unsigned n)

{
 unsigned xn,xp;

 if (x==0)
     return 0;

 xn=1;
 xp=x;

 while(n)
    {
     if (n&1)
         xn*=xp;
     xp*=xp;
     n>>=1;
    }

 return (xn) ? xn : INTERVAL_MAX_INTEGER;
}




/*-------------------------------------------------------------------------*/
/* NTH_ROOT_DN                                                             */
/*                                                                         */
/*-------------------------------------------------------------------------*/
unsigned Nth_Root_Dn(unsigned x,unsigned n)

{
 unsigned old,new;
 unsigned n1=n-1;
 unsigned oldn1;
 int      bit,nb;

 if (x==0)
    return 0;

 if (n>=sizeof(unsigned)*8)
     return 1;

 bit=Most_Significant_Bit(x);

 if (bit+1<n)
     return 1;

 nb=bit/n;
 new=1<<nb;

 old=new;
 oldn1=Power(old,n1);
 new=(n1*old + x/oldn1) / n;

 do
    {
     old=new;
     oldn1=Power(old,n1);
     new=(n1*old + x/oldn1) / n;
    }
 while(new<old);

 return old;
}




/*-------------------------------------------------------------------------*/
/* NTH_ROOT_UP                                                             */
/*                                                                         */
/*-------------------------------------------------------------------------*/
unsigned Nth_Root_Up(unsigned x,unsigned n)

{
 unsigned r;

 r=Nth_Root_Dn(x,n);
 if (Power(r,n)!=x)
     r++;

 return r;
}




/*-------------------------------------------------------------------------*/
/* SQRT_DN                                                                 */
/*                                                                         */
/*-------------------------------------------------------------------------*/
unsigned Sqrt_Dn(unsigned x)

{
 unsigned old,new;

 if (x==0)
    return 0;

 new=x;
 do
    {
     old=new;
     new=(old + x/old)>>1;
    }
 while(new<old);

 return old;
}




/*-------------------------------------------------------------------------*/
/* SQRT_UP                                                                 */
/*                                                                         */
/*-------------------------------------------------------------------------*/
unsigned Sqrt_Up(unsigned x)

{
 unsigned r;

 r=Sqrt_Dn(x);
 if (r*r!=x)
     r++;

 return r;
}




/*-------------------------------------------------------------------------*/
/* MAIN                                                                    */
/*                                                                         */
/*-------------------------------------------------------------------------*/
int main()

{
 unsigned n,x;
 unsigned r1,r2;
 unsigned p1,p2;


 for(;;)
    {
     printf("Enter x and n:");
     scanf("%u %u",&x,&n);

  
     r1=(n==2) ? Sqrt_Up(x) : Nth_Root_Up(x,n);
     r2=(n==2) ? Sqrt_Dn(x) : Nth_Root_Dn(x,n);

     p1=Power(r1,n);
     p2=Power(r2,n);

     printf("Res: %u..%u   Power  %u..%u\n",r1,r2,p1,p2);

     if (!(p1<=x && x<=p2 || p2<p1))
         printf("ERROR\n");
    }

 return 0;
}
