.\" -*- nroff -*-
.ds g \" empty
.ds G \" empty
.\" Like TP, but if specified indent is more than half
.\" the current line-length - indent, use the default indent.
.de Tp
.ie \\n(.$=0:((0\\$1)*2u>(\\n(.lu-\\n(.iu)) .TP
.el .TP "\\$1"
..
.TH LKBIB @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
lkbib \- search bibliographic databases
.SH SYNOPSIS
.B lkbib
[
.B \-v
]
[
.BI \-i fields
]
[
.BI \-p filename
]
[
.BI \-t n
]
.IR key \|.\|.\|.
.SH DESCRIPTION
.B lkbib
searches bibliographic databases for references that contain the keys
.IR key \|.\|.\|.
and prints any references found on the standard output.
.B lkbib
will search any databases given by
.B \-p
options, and then a default database.
The default database is taken from the
.SB REFER
environment variable if it is set,
otherwise it is
.BR @DEFAULT_INDEX@ .
For each database
.I filename
to be searched,
if an index
.IB filename @INDEX_SUFFIX@
created by
.BR @g@indxbib (@MAN1EXT@)
exists, then it will be searched instead;
each index can cover multiple databases.
.SH OPTIONS
.TP
.B \-v
Print the version number.
.TP
.BI \-p filename
Search
.IR filename .
Multiple
.B \-p
options can be used.
.TP
.BI \-i string
When searching files for which no index exists,
ignore the contents of fields whose names are in
.IR string .
.TP
.BI \-t n
Only require the first
.I n
characters of keys to be given.
Initially
.I n
is 6.
.SH ENVIRONMENT
.TP \w'\fBREFER'u+2n
.SB REFER
Default database.
.SH FILES
.Tp \w'\fB@DEFAULT_INDEX@'u+2n
.B @DEFAULT_INDEX@
Default database to be used if the
.SB REFER
environment variable is not set.
.IB filename @INDEX_SUFFIX@
Index files.
.SH "SEE ALSO"
.BR @g@refer (@MAN1EXT@),
.BR @g@lookbib (@MAN1EXT@),
.BR @g@indxbib (@MAN1EXT@)
