.ig \"-*- nroff -*-
Copyright (C) 1999-2000 Free Software Foundation, Inc.

Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
..
.\" Like TP, but if specified indent is more than half
.\" the current line-length - indent, use the default indent.
.de Tp
.ie \\n(.$=0:((0\\$1)*2u>(\\n(.lu-\\n(.iu)) .TP
.el .TP "\\$1"
..
.TH GROHTML @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
grohtml \- html driver for groff
.SH SYNOPSIS
.nr a \n(.j
.ad l
.nr i \n(.i
.in +\w'\fBgrohtml 'u
.ti \niu
.B grohtml
.de OP
.ie \\n(.$-1 .RI "[\ \fB\\$1\fP" "\\$2" "\ ]"
.el .RB "[\ " "\\$1" "\ ]"
..
.OP \-atTvdgm?
.OP \-F dir
.OP \-I imagetype
.OP \-r resolution
.RI "[\ " files\|.\|.\|. "\ ]"
.br
.ad \na
.PP
It is possible to have whitespace between a command line option and its
parameter.
.SH DESCRIPTION
.B grohtml
translates the output of GNU
.B troff
to html.
Normally
.B grohtml
should be invoked by using the groff command with a
.B \-Thtml
option.
If no files are given,
.B grohtml
will read the standard input.
A filename of
.B \-
will also cause
.B grohtml
to read the standard input.
Html output is written to the standard output.
When
.B grohtml
is run by
.B groff
options can be passed to
.B grohtml
using the
.B groff
.B \-P
option.
.SH OPTIONS
.TP
.B \-a
force
.B grohtml
to generate html line breaks in the same position as troff dictates.
Without this option
.B grohtml
generates text in paragraphs which is formatted by the html browser.
.TP
.B \-d
turn on internal debugging.
.TP
.B \-g
tell
.B grohtml
not to try and guess titles and headings.
By using this flag together with the -m and -a flag
.B grohtml
will treat the html browser as a printer, not as a formatter.
.TP
.B \-m
leave margins alone.
.B grohtml
will not remove left margins.
.TP
.B \-t
forbids
.B grohtml
from generating html tables when implementing indentation and tabular text.
.B grohtml
can implement .IP by tables or html indents.
However if .2C is used it can only be sensibly converted to html using a
table structure.
As a few known bugs still exist with the html table code this option is
present to supress execution of this development code.
The default in
.B grohtml
is that html tables are generated when appropriate.
.TP
.B \-T
forbids
.B grohtml
from generating images when processing output from tbl.
This is useful when simple textual tables are being produced.
.TP
.BI \-F dir
Search the directory
.IB dir /dev name
for font and device description files;
.I name
is the name of the device, usually
.BR html .
.TP
.BI \-I imagetype
select the type of image generated when grohtml encounters an equation,
table, or picture.
By default this is png256.
Legal image types are: gif and any of the png formats which are supported by
ghostscript gs(1).
.TP
.BI \-r resolution
select the resolution for all images.
By default this is 80 pixels per inch.
Example: -r100 indicates 100 pixels per inch.
.TP
.B \-v
Print the version number.
.TP
.B \-?
Display usage.
.SH USAGE
There are styles called
.BR R ,
.BR I ,
.BR B ,
and
.B BI
mounted at font positions 1 to 4.
It is advisable to invoke groff with the -mhtml macro set, which turns off
headers, footers, and hyphenation; additionally, it will right justify text.
.SH DEPENDENCIES
.B grohtml
is dependent upon grops and gs.
If
.B grohtml
has been configured to generate gif files then it is further dependent upon,
ppmtogif, and ppmquant.
However if it has been configured to generate png files (the default) then
it is dependent upon gs having a png output device.
Images are generated whenever a table, picture, equation or line is
encountered.
.SH BUGS
This is still very alpha.
At least three major bugs remain:
Firstly,
.B grohtml
sometimes miscalculates the end of an html table resulting in text which
appears twice.
Secondly equation numbers are not handled correctly.
Thirdly equation macros and pic macros can confuse
.BR grohtml .
.SH "SEE ALSO"
.BR afmtodit (@MAN1EXT@),
.BR groff (@MAN1EXT@),
.BR @g@troff (@MAN1EXT@),
.BR psbb (@MAN1EXT@),
.BR groff_out (@MAN5EXT@),
.BR groff_font (@MAN5EXT@),
.BR groff_char (@MAN7EXT@)
