.\" t                      -*- nroff -*- 
.ig
roff.7

This file is part of groff, the GNU roff type-setting system.

Copyright (C) 2000 Free Software Foundation, Inc.
written by Bernd Warken <bwarken@mayn.de>

Last update: 17 May 2000

Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.1 or
any later version published by the Free Software Foundation; with the
Invariant Sections being this .ig-section and AUTHOR, with no
Front-Cover Texts, and with no Back-Cover Texts.

A copy of the Free Documentation License is included as a file called
FDL in the main directory of the groff source package.
..
.
.\" --------------------------------------------------------------------
.\" Setup
.\" --------------------------------------------------------------------
.
.if n \{\
.  mso tty-char.tmac
.  ftr CR R
.  ftr CI I
.  ftr CB B
.\}
.
.\" text lines in macro definitions or bracketed sections \{...\}
.de text
.  if 1 \&\\$*\&
..
.
.de option
.  ds @tmp@ \f(CB\\$1\fP
.  shift 1
.  text \\*[@tmp@]\\$*
.  rm @tmp@
..
.
.de 'char
.  ds @tmp@ `\f(CB\\$1\fP'
.  shift
.  text \\*[@tmp@]\\$*
.  rm @tmp@
..
.
.de esc
.  ds @tmp@ \f(CB\e\\$1\fP
.  shift
.  text \\*[@tmp@]\\$*
.  rm @tmp@
..
.
.de argname
.  ds @tmp@ \f(CI\\$1\fP
.  shift 1
.  text \\*[@tmp@]\\$*
.  rm @tmp@
..
.
.de prefixednumber
.  ds @tmp@ \&\\$1\ \f(CR\\$2\fP
.  shift 2
.  text \\*[@tmp@]\\$*
.  rm @tmp@
..
.
.de TQ
.br
.ns
.TP \\$1
..
.
.\" --------------------------------------------------------------------
.\" Title
.\" --------------------------------------------------------------------
.TH ROFF @MAN7EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
roff \- a survey of the roff typesetting system
.\" --------------------------------------------------------------------
.SH DESCRIPTION
.\" --------------------------------------------------------------------
.I roff
is the general name for a set of type-setting programs, known under
names like
.IR troff ,
.IR nroff ,
.IR groff ,
etc.
.LP
The roff type-setting system consists of a formatting language, macro
packages, preprocessors, postprocessors for output devices, user
front-end programs, and conversion tools.
.LP
The most common roff system today is the free software implementation
.I groff
(from `GNU\ roff').
The pre-groff implementations are referred to as `classical' (dating
back as long as 1973).
.LP
.I groff
is backward-compatible to its classical ancestors, but has many
extensions, and is still evolving.
As it is available for almost every computer system it is the de-facto
roff standard today.
.LP
In spite of its age, roff is in wide use today, e.g., the manual pages
on UNIX systems
.RI ( man-pages )
are written in roff.
The roff output for text devices is still unmatched, and its graphical
output has the same quality as the other free type-setting programs and
is better than some of the commercial systems.
.LP
This document gives only an overview and provides pointers to further
documentation.

This document is not maintained and might be out of date.  For the real
documentation refer to the groff info file that contains the detailed,
actual and concise reference information.
.\" --------------------------------------------------------------------
.SH "FORMATTING LANGUAGE"
.\" --------------------------------------------------------------------
There are three terms that refer to the language of the
.I roff
system.
The term
.I troff language
is used when the classical aspects of
.I roff
are stressed, the term
.I groff language
includes the GNU extensions, whereas
.I roff language
is the general term.
.LP
The main source of documentation for all aspects of the
.I groff language
is the groff info file.  The manual page
.BR groff (@MAN7EXT@)
gives a short description of all predefined language elements.
.LP
Documents using roff are normal text files decorated by formatting
elements.
It is very easy to write high-quality documents by using one of the
macro packages.
These are like high-level programming languages, while the bare roff
language compares to a low-level language like C or assembler.
.LP
The roff language is a full programming language providing low-level
requests, definition of macros, escape sequences, string variables,
number or size registers, and C-like flow controls.
.ig /
In the 1980s, it was even possible to write the common utilities for
system administration by only using troff.
There were contests on writing the most unreadable program fake by
exclusively using troff.
Because of security impacts, these dangerous features were removed in
.IR groff .
./
.LP
Some clarification on the language elements seems to be wanted.
Requests are basic formatting commands defined by programming languages
like C, C++, etc., whereas macros are formatting commands that are
written in the roff language.
A document writer will not note any difference in usage for requests or
macros, both are written on a line on their own starting with a dot
.'char . .
But the user may define her own macros if desired.
.LP
Escape sequences are in-line elements starting with a backslash
.'char \e .
They are used to implement various features, including the insertion of
non-ASCII characters with
.esc ( ,
the content of strings with
.esc *
and register variables with
.esc n ,
font changes with
.esc f ,
in-line comments with
.esc \(dq ,
the escaping of special control characters like
.esc \e ,
and many other features.
.\" --------------------------------------------------------------------
.SH FORMATTERS
.\" --------------------------------------------------------------------
Formatters are the front-end programs that analyze a groff document and
translate it into a form that is suitable for a special device.
The traditional
.I roff
had two formatters,
.B nroff
for text devices and
.B troff
for graphical devices.
.LP
These programs still exist in the
.I groff
implementation, but usually they are accessed through a program called
.BR groff .
This combined and extended the old functionality into a single program.
It has many command-line options, most of them herited from
.BR troff .
To ease the option jungle, the user-friendly utility
.B grog
(from `groff guess') was created.
It tries to guess from the document which arguments should be used and
displays a suitable command line.
Though not being perfect, it is a good starting point.
.\" --------------------------------------------------------------------
.SH PREPROCESSORS
.\" --------------------------------------------------------------------
The classical preprocessors that are still available in groff.
.RS
.LP
.PD 0
.TP
.I eqn
for including mathematical equations.
.TP
.I grap
for constructing graphical elements (this preprocessor doesn't come with
groff; it is an extra package).
.TP
.I grn
for including gremlin pictures.
.TP
.I pic
for creating diagrams.
.TP
.I refer
for bibliographic references.
.TP
.I soelim
for including other roff files.
.TP
.I tbl
for rectangular tables.
.PD
.RE
.LP
Each of these preprocessors defines its own language that is translated
into roff code when run through the preprocessor program.
So parts written in these languages may be included within a roff
document.
Such an enhanced document is run through one or more corresponding
preprocessors before it is fed into the actual formatter.
.LP
The preprocessor programs extract and transform the document parts
determined for them.
They can be called either in a UNIX pipeline with their program name or
automatically with a groff option.
.LP
.TS
center, box, tab (@);
C | C
CfCB | CfCB.
preprocessor@groff option
=
eqn@\-e
grap@\-G
grn@\-g
pic@\-p
refer@\-R
tbl@\-r
soelim@\-s
.TE
.LP
.
.\" --------------------------------------------------------------------
.SH "MACRO PACKAGES"
.\" --------------------------------------------------------------------
Macro packages are collections of macros that are suitable to format a
special kind of documents in a convenient way.
This greatly eases the usage of roff.
The macro definitions of a package are kept in a file called
.IB name .tmac
(or
.BI tmac. name\c
) where
.I name
is the internal roff name for this package.
All tmac files are stored in a single or few directories at standard
positions.
.LP
A macro package that is used in a document is specified by the command line
option
.option \-m
for the formatter like
.option "troff\ \-m"
.argname name
or
.option "groff\ \-m"
.argname name .
General details on the naming of macro packages and their placement is
found in
.BR groff_tmac (@MAN5EXT@).
.LP
Famous classical macro packages are
.IR man ,
.IR mandoc ,
and
.I mdoc
for manual pages and
.IR me ,
.IR ms ,
and
.I mm
for books, articles, and letters.
Besides these collections, groff provides an increasing number of new
macro packages for various applications, for example integration of or
conversion into other file formats.
.\" --------------------------------------------------------------------
.SH "FILE NAME EXTENSIONS"
.\" --------------------------------------------------------------------
Manual pages (man-pages) take the section number as a file name
extension, e.g., the filename for this document is
.IR roff.7 ,
i.e., it is kept in
.prefixednumber section 7
of the man-pages.
.LP
The classical macro packages take the package name as an extension, e.g.
.IB file. me
for a document using the
.I me
macro package,
.IB file. mm
for
.IR mm ,
.IB file. ms
for
.IR ms ,
.IB file. pic
for
.I pic
files,
etc.
.ig
.LP
But there is no general naming scheme for roff documents, though
.IB file. roff
or
.IB file. rof
seems to be a good choice.
.LP
File name extensions can be very handy in conjunction with the
.BR less (1)
pager.
It provides the possibility to feed all input into a command-line pipe that
is specified in the shell environment variable
.B LESSOPEN
This process is not well documented, so here an example
.B LESSOPEN='|lesspipe %s'
where
.B lesspipe
is either a system supplied command or a shell script of your own.
..
.\" --------------------------------------------------------------------
.SH EDITING
.\" --------------------------------------------------------------------
Most text editors provide support for editing documents using roff.
Especially useful is the
.B nroff-mode
in all flavors of the Emacs editor.
.\" --------------------------------------------------------------------
.SH ENVIRONMENT
.\" --------------------------------------------------------------------
.TP
.SM
.B GROFF_TMAC_PATH
A colon separated list of directories in which to search for
macro files, see
.BR groff_tmac (@MAN5EXT@).
.TP
.SM
.B GROFF_TYPESETTER
Default device.
.TP
.SM
.B GROFF_FONT_PATH
A colon separated list of directories in which to search for the
.BI dev name
directory.
.B troff
will first search in directories given with the
.option \-F
command line option, then in
.BR GROFF_FONT_PATH ,
and finally in the standard directories
.RB ( @FONTPATH@ ).
.\" --------------------------------------------------------------------
.SH FILES
.\" --------------------------------------------------------------------
By default,
.I groff
installs all of its data files in subdirectories of
.I @FONTDIR@
and in
.I @MACRODIR@
(except wrapper files for system-specific macro packages which will be
in
.IR @SYSTEMMACRODIR@ ).
These locations might vary for different systems.
In the following, the former is referred to as
.IR <groff_font_dir> ,
the latter as
.IR <groff_macro_dir> .
.TP
.IB <groff_macro_dir> /troffrc
Initialization file for troff.
.TP
.IB <groff_macro_dir> / name .tmac
.TQ
.IB <groff_macro_dir> /tmac. name
Macro files.
.TP
.IB <groff_font_dir> /dev name /DESC
Device description file for device
.IR name .
.TP
.IB <groff_font_dir> /dev name / F
Font file for font
.I F
of device
.IR name .
.LP
Finally, a local macro directory
.I @LOCALMACRODIR@
is provided for site-specific macros and packages; by default, it will be
searched before the main macro directory.
.\" --------------------------------------------------------------------
.SH BUGS
.\" --------------------------------------------------------------------
The groff documentation is in evolution at the moment.
It is possible that small inconsistencies between different documents exist
temporarily.
.\" --------------------------------------------------------------------
.SH AUTHOR
.\" --------------------------------------------------------------------
This document is part of groff, the GNU roff distribution.  It was
written by Bernd Warken <bwarken@mayn.de>.
.LP
It is distributed under the terms of the FDL (GNU Free Documentation
License) version 1.1 or later.  You should have received a copy of the
FDL on your system, it is also available on-line under
.RS
.LP
.IR <http://www.gnu.org/copyleft/fdl.html> .
.RE
.\" --------------------------------------------------------------------
.SH "SEE ALSO"
.\" --------------------------------------------------------------------
The main source of information is the
.I groff
.BR info (1)
file.
.LP
The predefined elements of the
.I groff
language are also documented in the manual page
.BR groff (@MAN7EXT@).
.LP
Formatters and their wrappers:
.BR groff (@MAN1EXT@),
.BR grog (@MAN1EXT@),
.BR nroff (@MAN1EXT@),
and
.BR troff (@MAN1EXT@).
.LP
Postprocessors for the output devices:
.BR grodvi (@MAN1EXT@),
.BR grohtml (@MAN1EXT@),
.BR grolbp (@MAN1EXT@),
.BR grolj4 (@MAN1EXT@),
.BR grops (@MAN1EXT@),
and
.BR grotty (@MAN1EXT@).
.LP
Standard preprocessors:
.BR eqn (@MAN1EXT@),
.BR grn (@MAN1EXT@),
.BR grap (1),
.BR pic (@MAN1EXT@),
.BR refer (@MAN1EXT@),
.BR soelim (@MAN1EXT@),
and
.BR tbl (@MAN1EXT@).
.LP
The man pages for macro packages include
.BR groff_tmac (@MAN5EXT@),
.BR groff_man (@MAN7EXT@),
.BR groff_markup (@MAN7EXT@),
.BR groff_mdoc (@MAN7EXT@),
.BR groff_mdoc.samples (@MAN7EXT@),
.BR groff_me (@MAN7EXT@),
.BR groff_mm (@MAN7EXT@),
.BR groff_mmroff (@MAN7EXT@),
and
.BR groff_ms (@MAN7EXT@).
.LP
The following utilities are available:
.BR addftinfo (@MAN1EXT@),
.BR afmtodif (@MAN1EXT@),
.BR hpftodit (@MAN1EXT@),
.BR indxbib (@MAN1EXT@),
.BR lookbib (@MAN1EXT@),
.BR pfbtops (@MAN1EXT@),
.BR tfmtodit (@MAN1EXT@),
and
.BR gxditview (@MAN1EXT@).
.LP
For details on the GNU implementation of the
.I roff
system see
.BR groff_char (@MAN7EXT@),
.BR groff_font (@MAN7EXT@),
.BR groff_out (@MAN7EXT@),
and the file
.I README
in the main directory of the groff source distribution.
These also give details on how to contact or join the
.I groff
developer group.
.LP
Many classical
.troff
documents are still available on-line.
Especially informative are the original Bell Labs proceedings for the old,
free UNIX 7 found at
.I http://cm.bell-labs.com/cm/cs/cstr.html
and the collection of the late Richard S. Stevens at 
.IR http://www.kohala.com/start/troff/ .
