/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Instrumentation;
import android.graphics.PointF;
import android.os.SystemClock;
import android.view.MotionEvent;

class Tapper {
    private final Instrumentation _instrument;
    public static final int GESTURE_DURATION_MS = 1000;
    public static final int EVENT_TIME_INTERVAL_MS = 10;

    public Tapper(Instrumentation inst) {
        this._instrument = inst;
    }

    public void generateTapGesture(int numTaps, PointF ... points) {
        long downTime = SystemClock.uptimeMillis();
        long eventTime = SystemClock.uptimeMillis();
        float x1 = points[0].x;
        float y1 = points[0].y;
        float x2 = 0.0f;
        float y2 = 0.0f;
        if (points.length == 2) {
            x2 = points[1].x;
            y2 = points[1].y;
        }
        MotionEvent.PointerCoords[] pointerCoords = new MotionEvent.PointerCoords[points.length];
        MotionEvent.PointerCoords pc1 = new MotionEvent.PointerCoords();
        pc1.x = x1;
        pc1.y = y1;
        pc1.pressure = 1.0f;
        pc1.size = 1.0f;
        pointerCoords[0] = pc1;
        MotionEvent.PointerCoords pc2 = new MotionEvent.PointerCoords();
        if (points.length == 2) {
            pc2.x = x2;
            pc2.y = y2;
            pc2.pressure = 1.0f;
            pc2.size = 1.0f;
            pointerCoords[1] = pc2;
        }
        MotionEvent.PointerProperties[] pointerProperties = new MotionEvent.PointerProperties[points.length];
        MotionEvent.PointerProperties pp1 = new MotionEvent.PointerProperties();
        pp1.id = 0;
        pp1.toolType = 1;
        pointerProperties[0] = pp1;
        MotionEvent.PointerProperties pp2 = new MotionEvent.PointerProperties();
        if (points.length == 2) {
            pp2.id = 1;
            pp2.toolType = 1;
            pointerProperties[1] = pp2;
        }
        for (int i = 0; i != numTaps; ++i) {
            MotionEvent event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)0, (int)points.length, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)4098, (int)0);
            this._instrument.sendPointerSync(event);
            if (points.length == 2) {
                event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)(5 + (pp2.id << 8)), (int)points.length, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)4098, (int)0);
                this._instrument.sendPointerSync(event);
                event = MotionEvent.obtain((long)downTime, (long)(eventTime += 10L), (int)(6 + (pp2.id << 8)), (int)points.length, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)4098, (int)0);
                this._instrument.sendPointerSync(event);
            }
            event = MotionEvent.obtain((long)downTime, (long)(eventTime += 10L), (int)1, (int)points.length, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)4098, (int)0);
            this._instrument.sendPointerSync(event);
        }
    }
}

