/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.Library;
import java.lang.reflect.Member;
import junit.framework.TestCase;

public class LibraryTest
extends TestCase {
    Library ll;
    Class math;

    public LibraryTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        this.math = Class.forName("java.lang.Math");
        Class[] sl = new Class[]{this.math};
        this.ll = new Library(sl, null, null, null, null);
    }

    @Override
    public void tearDown() throws Exception {
    }

    public void testRoundDBL() throws Exception {
        Class[] par = new Class[]{Double.TYPE};
        Member mf = this.ll.getMember(null, "round", par);
        LibraryTest.assertTrue(mf != null && mf.equals(this.math.getMethod("round", par)));
    }

    public void testRoundFLT() throws Exception {
        Class[] par = new Class[]{Float.TYPE};
        Member mf = this.ll.getMember(null, "round", par);
        LibraryTest.assertTrue(mf != null && mf.equals(this.math.getMethod("round", par)));
    }

    public void testRoundINT() throws Exception {
        Class[] par = new Class[]{Float.TYPE};
        Member mf = this.ll.getMember(null, "round", par);
        Class[] par1 = new Class[]{Float.TYPE};
        LibraryTest.assertTrue(mf != null && mf.equals(this.math.getMethod("round", par1)));
    }

    public void testAbsINT() throws Exception {
        Class[] par = new Class[]{Integer.TYPE};
        Member mf = this.ll.getMember(null, "abs", par);
        Class[] par1 = new Class[]{Integer.TYPE};
        LibraryTest.assertTrue(mf != null && mf.equals(this.math.getMethod("abs", par1)));
    }

    public void testAbsBYTE() throws Exception {
        Class[] par = new Class[]{Byte.TYPE};
        Member mf = this.ll.getMember(null, "abs", par);
        Class[] par1 = new Class[]{Integer.TYPE};
        LibraryTest.assertTrue(mf != null && mf.equals(this.math.getMethod("abs", par1)));
    }

    public void testAbsCHAR() throws Exception {
        Class[] par = new Class[]{Character.TYPE};
        Member mf = this.ll.getMember(null, "abs", par);
        Class[] par1 = new Class[]{Integer.TYPE};
        LibraryTest.assertTrue(mf != null && mf.equals(this.math.getMethod("abs", par1)));
    }

    public void testMinINT_FLOAT() throws Exception {
        Class[] par = new Class[]{Integer.TYPE, Float.TYPE};
        Member mf = this.ll.getMember(null, "min", par);
        Class[] par1 = new Class[]{Float.TYPE, Float.TYPE};
        LibraryTest.assertTrue(mf != null && mf.equals(this.math.getMethod("min", par1)));
    }

    public void testPI() throws Exception {
        Class[] par = new Class[0];
        Member f = this.ll.getMember(null, "PI", par);
        LibraryTest.assertTrue(f != null && f.getName().equals("PI"));
    }

    public void testStateDep() throws Exception {
        this.ll.markStateDependent("random", null);
        LibraryTest.assertTrue(!this.ll.isStateless(this.ll.getMember(null, "random", null)));
    }
}

