
(add-hook 'find-file-hook 'd-outline-mode-hook)
(defun d-outline-mode-hook ()
  (interactive)
  (if (and (buffer-file-name) (string-match "\\.log$" (buffer-file-name)))
      (progn
        ;;(d-foo)
        (goto-char (point-min))
        (while (re-search-forward "^\\*+\\([-+]\\)" nil t)
          (replace-match "" nil nil nil 1))
        (save-buffer)
        (goto-char (point-min))
    ))
  )

(setq auto-mode-alist
      (append '(("\\.log$"  . outline-mode))
              auto-mode-alist))

(setq auto-mode-alist
      (cons '("^log$" . outline-mode)
            auto-mode-alist))

(eval-after-load "outline"
  '(progn
     (progn
       (defvar d-outline-toggle nil)
       (make-local-variable 'd-outline-toggle)
       (define-key outline-mode-map [f5] 'd-outline-f5)
       (define-key outline-mode-map [(shift f5)] 'd-outline-shift-f5)

       (define-key outline-mode-map [(meta up)] 'outline-backward-same-level)
       (define-key outline-mode-map [(meta down)]
         (function
          (lambda () (interactive)
            ;;           (call-interactively 'outline-up-heading)
            (call-interactively 'outline-forward-same-level)
            )))

       )))


;;(defun d-outline-f5 ()
;;  (interactive)
;;  (if d-outline-toggle
;;      (progn
;;        (setq d-outline-toggle nil)
;;        (show-children))
;;    (progn
;;      (setq d-outline-toggle t)
;;      (hide-subtree))))

;;      (define-key outline-mode-map [(shift f5)]
;;        (function
;;         (lambda () (interactive)
;;           (if (save-excursion
;;                 (beginning-of-line)
;;                 (looking-at "\\+"))
;;;;               d-outline-toggle
;;               (progn
;;;;                 (setq d-outline-toggle nil)
;;                 (show-subtree))
;;             (progn
;;;;               (setq d-outline-toggle t)
;;               (hide-subtree))
;;             ))))

(defun d-outline-f5 ()
  (interactive)
  (if (save-excursion
        (beginning-of-line)
        (skip-chars-forward "*")
        (looking-at "\\+"))
      (progn
        (save-excursion
          (beginning-of-line)
          (skip-chars-forward "*")
          (delete-char 1)
          (insert "-"))
        (show-children))
    (if (save-excursion
          (beginning-of-line)
          (skip-chars-forward "*")
          (looking-at "\\-"))
        (progn
          (save-excursion
            (beginning-of-line)
            (skip-chars-forward "*")
            (delete-char 1)
            (insert "+"))
          (hide-subtree))
      (progn
        (save-excursion
          (beginning-of-line)
          (skip-chars-forward "*")
          (insert "+")))))
  )

(defun d-outline-shift-f5 ()
  (interactive)
  (if (save-excursion
        (beginning-of-line)
        (skip-chars-forward "*")
        (looking-at "\\+"))
      (progn
        (save-excursion
          (beginning-of-line)
          (skip-chars-forward "*")
          (delete-char 1)
          (insert "-"))
        (show-subtree))
    (if (save-excursion
          (beginning-of-line)
          (skip-chars-forward "*")
          (looking-at "\\-"))
        (progn
          (save-excursion
            (beginning-of-line)
            (skip-chars-forward "*")
            (delete-char 1)
            (insert "+"))
          (hide-subtree))
      (progn
        (save-excursion
          (beginning-of-line)
          (skip-chars-forward "*")
          (insert "+")))))
  )

(provide 'd-outline)
