(define-syntax (and-let* form)
  (syntax-case form ()
    ((and-let* (claw ...) arg1 . rest)
     #`(and-let* (claw ... ((begin arg1 . rest)))))
    ((and-let* ((var expr)))
     #`(let ((var expr)) var))
    ((and-let* ((expr)))
     #`expr)
    ((and-let* (var))
     (if (identifier? #`var)
	 #`var
	 (report-syntax-error #`var "expected a variable name")))
    ((and-let* ((var expr) . claws))
     #`(let ((var expr))
	 (and var (and-let* claws))))
    ((and-let* ((expr) . claws))
     #`(and expr (and-let* claws)))
    ((and-let* (var . claws))
     (if (identifier? #`var)
	 #`(and var (and-let* claws))
	 (report-syntax-error #`var "expected a variable name")))
    ((and-let* ())
     #`#t)))
