/* Mapping tables for GBK handling.
   Copyright (C) 1999, 2000 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   Contributed by Sean Chen <seanc@turbolinux.com.cn>, 1999.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* 	This file is added for supporting gb18030-2000 code.
	by Wang ShouHua & Wu Jian
	Redflag Linux company
	www.redflag-linux.com
*/


#include <dlfcn.h>
#include <gconv.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <wchar.h>
#include <assert.h>

static const uint16_t __gb18030_to_ucs[] =
{
  [0x0000] = 0x0081, [0x0001] = 0x0082, [0x0002] = 0x0083, [0x0003] = 0x0084,
  [0x0004] = 0x0085, [0x0005] = 0x0086, [0x0006] = 0x0087, [0x0007] = 0x0088,
  [0x0008] = 0x0089, [0x0009] = 0x008a, [0x000a] = 0x008b, [0x000b] = 0x008c,
  [0x000c] = 0x008d, [0x000d] = 0x008e, [0x000e] = 0x008f, [0x000f] = 0x0090,
  [0x0010] = 0x0091, [0x0011] = 0x0092, [0x0012] = 0x0093, [0x0013] = 0x0094,
  [0x0014] = 0x0095, [0x0015] = 0x0096, [0x0016] = 0x0097, [0x0017] = 0x0098,
  [0x0018] = 0x0099, [0x0019] = 0x009a, [0x001a] = 0x009b, [0x001b] = 0x009c,
  [0x001c] = 0x009d, [0x001d] = 0x009e, [0x001e] = 0x009f, [0x001f] = 0x00a0,
  [0x0020] = 0x00a1, [0x0021] = 0x00a2, [0x0022] = 0x00a3, [0x0023] = 0x00a5,
  [0x0024] = 0x00a6, [0x0025] = 0x00a9, [0x0026] = 0x00aa, [0x0027] = 0x00ab,
  [0x0028] = 0x00ac, [0x0029] = 0x00ad, [0x002a] = 0x00ae, [0x002b] = 0x00af,
  [0x002c] = 0x00b2, [0x002d] = 0x00b3, [0x002e] = 0x00b4, [0x002f] = 0x00b5,
  [0x0030] = 0x00b6, [0x0031] = 0x00b8, [0x0032] = 0x00b9, [0x0033] = 0x00ba,
  [0x0034] = 0x00bb, [0x0035] = 0x00bc, [0x0036] = 0x00bd, [0x0037] = 0x00be,
  [0x0038] = 0x00bf, [0x0039] = 0x00c0, [0x003a] = 0x00c1, [0x003b] = 0x00c2,
  [0x003c] = 0x00c3, [0x003d] = 0x00c4, [0x003e] = 0x00c5, [0x003f] = 0x00c6,
  [0x0040] = 0x00c7, [0x0041] = 0x00c8, [0x0042] = 0x00c9, [0x0043] = 0x00ca,
  [0x0044] = 0x00cb, [0x0045] = 0x00cc, [0x0046] = 0x00cd, [0x0047] = 0x00ce,
  [0x0048] = 0x00cf, [0x0049] = 0x00d0, [0x004a] = 0x00d1, [0x004b] = 0x00d2,
  [0x004c] = 0x00d3, [0x004d] = 0x00d4, [0x004e] = 0x00d5, [0x004f] = 0x00d6,
  [0x0050] = 0x00d8, [0x0051] = 0x00d9, [0x0052] = 0x00da, [0x0053] = 0x00db,
  [0x0054] = 0x00dc, [0x0055] = 0x00dd, [0x0056] = 0x00de, [0x0057] = 0x00df,
  [0x0058] = 0x00e2, [0x0059] = 0x00e3, [0x005a] = 0x00e4, [0x005b] = 0x00e5,
  [0x005c] = 0x00e6, [0x005d] = 0x00e7, [0x005e] = 0x00eb, [0x005f] = 0x00ee,
  [0x0060] = 0x00ef, [0x0061] = 0x00f0, [0x0062] = 0x00f1, [0x0063] = 0x00f4,
  [0x0064] = 0x00f5, [0x0065] = 0x00f6, [0x0066] = 0x00f8, [0x0067] = 0x00fb,
  [0x0068] = 0x00fd, [0x0069] = 0x00fe, [0x006a] = 0x00ff, [0x006b] = 0x0100,
  [0x006c] = 0x0102, [0x006d] = 0x0103, [0x006e] = 0x0104, [0x006f] = 0x0105,
  [0x0070] = 0x0106, [0x0071] = 0x0107, [0x0072] = 0x0108, [0x0073] = 0x0109,
  [0x0074] = 0x010a, [0x0075] = 0x010b, [0x0076] = 0x010c, [0x0077] = 0x010d,
  [0x0078] = 0x010e, [0x0079] = 0x010f, [0x007a] = 0x0110, [0x007b] = 0x0111,
  [0x007c] = 0x0112, [0x007d] = 0x0114, [0x007e] = 0x0115, [0x007f] = 0x0116,
  [0x0080] = 0x0117, [0x0081] = 0x0118, [0x0082] = 0x0119, [0x0083] = 0x011a,
  [0x0084] = 0x011c, [0x0085] = 0x011d, [0x0086] = 0x011e, [0x0087] = 0x011f,
  [0x0088] = 0x0120, [0x0089] = 0x0121, [0x008a] = 0x0122, [0x008b] = 0x0123,
  [0x008c] = 0x0124, [0x008d] = 0x0125, [0x008e] = 0x0126, [0x008f] = 0x0127,
  [0x0090] = 0x0128, [0x0091] = 0x0129, [0x0092] = 0x012a, [0x0093] = 0x012c,
  [0x0094] = 0x012d, [0x0095] = 0x012e, [0x0096] = 0x012f, [0x0097] = 0x0130,
  [0x0098] = 0x0131, [0x0099] = 0x0132, [0x009a] = 0x0133, [0x009b] = 0x0134,
  [0x009c] = 0x0135, [0x009d] = 0x0136, [0x009e] = 0x0137, [0x009f] = 0x0138,
  [0x00a0] = 0x0139, [0x00a1] = 0x013a, [0x00a2] = 0x013b, [0x00a3] = 0x013c,
  [0x00a4] = 0x013d, [0x00a5] = 0x013e, [0x00a6] = 0x013f, [0x00a7] = 0x0140,
  [0x00a8] = 0x0141, [0x00a9] = 0x0142, [0x00aa] = 0x0143, [0x00ab] = 0x0145,
  [0x00ac] = 0x0146, [0x00ad] = 0x0147, [0x00ae] = 0x0149, [0x00af] = 0x014a,
  [0x00b0] = 0x014b, [0x00b1] = 0x014c, [0x00b2] = 0x014e, [0x00b3] = 0x014f,
  [0x00b4] = 0x0150, [0x00b5] = 0x0151, [0x00b6] = 0x0152, [0x00b7] = 0x0153,
  [0x00b8] = 0x0154, [0x00b9] = 0x0155, [0x00ba] = 0x0156, [0x00bb] = 0x0157,
  [0x00bc] = 0x0158, [0x00bd] = 0x0159, [0x00be] = 0x015a, [0x00bf] = 0x015b,
  [0x00c0] = 0x015c, [0x00c1] = 0x015d, [0x00c2] = 0x015e, [0x00c3] = 0x015f,
  [0x00c4] = 0x0160, [0x00c5] = 0x0161, [0x00c6] = 0x0162, [0x00c7] = 0x0163,
  [0x00c8] = 0x0164, [0x00c9] = 0x0165, [0x00ca] = 0x0166, [0x00cb] = 0x0167,
  [0x00cc] = 0x0168, [0x00cd] = 0x0169, [0x00ce] = 0x016a, [0x00cf] = 0x016c,
  [0x00d0] = 0x016d, [0x00d1] = 0x016e, [0x00d2] = 0x016f, [0x00d3] = 0x0170,
  [0x00d4] = 0x0171, [0x00d5] = 0x0172, [0x00d6] = 0x0173, [0x00d7] = 0x0174,
  [0x00d8] = 0x0175, [0x00d9] = 0x0176, [0x00da] = 0x0177, [0x00db] = 0x0178,
  [0x00dc] = 0x0179, [0x00dd] = 0x017a, [0x00de] = 0x017b, [0x00df] = 0x017c,
  [0x00e0] = 0x017d, [0x00e1] = 0x017e, [0x00e2] = 0x017f, [0x00e3] = 0x0180,
  [0x00e4] = 0x0181, [0x00e5] = 0x0182, [0x00e6] = 0x0183, [0x00e7] = 0x0184,
  [0x00e8] = 0x0185, [0x00e9] = 0x0186, [0x00ea] = 0x0187, [0x00eb] = 0x0188,
  [0x00ec] = 0x0189, [0x00ed] = 0x018a, [0x00ee] = 0x018b, [0x00ef] = 0x018c,
  [0x00f0] = 0x018d, [0x00f1] = 0x018e, [0x00f2] = 0x018f, [0x00f3] = 0x0190,
  [0x00f4] = 0x0191, [0x00f5] = 0x0192, [0x00f6] = 0x0193, [0x00f7] = 0x0194,
  [0x00f8] = 0x0195, [0x00f9] = 0x0196, [0x00fa] = 0x0197, [0x00fb] = 0x0198,
  [0x00fc] = 0x0199, [0x00fd] = 0x019a, [0x00fe] = 0x019b, [0x00ff] = 0x019c,
  [0x0100] = 0x019d, [0x0101] = 0x019e, [0x0102] = 0x019f, [0x0103] = 0x01a0,
  [0x0104] = 0x01a1, [0x0105] = 0x01a2, [0x0106] = 0x01a3, [0x0107] = 0x01a4,
  [0x0108] = 0x01a5, [0x0109] = 0x01a6, [0x010a] = 0x01a7, [0x010b] = 0x01a8,
  [0x010c] = 0x01a9, [0x010d] = 0x01aa, [0x010e] = 0x01ab, [0x010f] = 0x01ac,
  [0x0110] = 0x01ad, [0x0111] = 0x01ae, [0x0112] = 0x01af, [0x0113] = 0x01b0,
  [0x0114] = 0x01b1, [0x0115] = 0x01b2, [0x0116] = 0x01b3, [0x0117] = 0x01b4,
  [0x0118] = 0x01b5, [0x0119] = 0x01b6, [0x011a] = 0x01b7, [0x011b] = 0x01b8,
  [0x011c] = 0x01b9, [0x011d] = 0x01ba, [0x011e] = 0x01bb, [0x011f] = 0x01bc,
  [0x0120] = 0x01bd, [0x0121] = 0x01be, [0x0122] = 0x01bf, [0x0123] = 0x01c0,
  [0x0124] = 0x01c1, [0x0125] = 0x01c2, [0x0126] = 0x01c3, [0x0127] = 0x01c4,
  [0x0128] = 0x01c5, [0x0129] = 0x01c6, [0x012a] = 0x01c7, [0x012b] = 0x01c8,
  [0x012c] = 0x01c9, [0x012d] = 0x01ca, [0x012e] = 0x01cb, [0x012f] = 0x01cc,
  [0x0130] = 0x01cd, [0x0131] = 0x01cf, [0x0132] = 0x01d1, [0x0133] = 0x01d3,
  [0x0134] = 0x01d5, [0x0135] = 0x01d7, [0x0136] = 0x01d9, [0x0137] = 0x01db,
  [0x0138] = 0x01dd, [0x0139] = 0x01de, [0x013a] = 0x01df, [0x013b] = 0x01e0,
  [0x013c] = 0x01e1, [0x013d] = 0x01e2, [0x013e] = 0x01e3, [0x013f] = 0x01e4,
  [0x0140] = 0x01e5, [0x0141] = 0x01e6, [0x0142] = 0x01e7, [0x0143] = 0x01e8,
  [0x0144] = 0x01e9, [0x0145] = 0x01ea, [0x0146] = 0x01eb, [0x0147] = 0x01ec,
  [0x0148] = 0x01ed, [0x0149] = 0x01ee, [0x014a] = 0x01ef, [0x014b] = 0x01f0,
  [0x014c] = 0x01f1, [0x014d] = 0x01f2, [0x014e] = 0x01f3, [0x014f] = 0x01f4,
  [0x0150] = 0x01f5, [0x0151] = 0x01f6, [0x0152] = 0x01f7, [0x0153] = 0x01f8,
  [0x0154] = 0x01fa, [0x0155] = 0x01fb, [0x0156] = 0x01fc, [0x0157] = 0x01fd,
  [0x0158] = 0x01fe, [0x0159] = 0x01ff, [0x015a] = 0x0200, [0x015b] = 0x0201,
  [0x015c] = 0x0202, [0x015d] = 0x0203, [0x015e] = 0x0204, [0x015f] = 0x0205,
  [0x0160] = 0x0206, [0x0161] = 0x0207, [0x0162] = 0x0208, [0x0163] = 0x0209,
  [0x0164] = 0x020a, [0x0165] = 0x020b, [0x0166] = 0x020c, [0x0167] = 0x020d,
  [0x0168] = 0x020e, [0x0169] = 0x020f, [0x016a] = 0x0210, [0x016b] = 0x0211,
  [0x016c] = 0x0212, [0x016d] = 0x0213, [0x016e] = 0x0214, [0x016f] = 0x0215,
  [0x0170] = 0x0216, [0x0171] = 0x0217, [0x0172] = 0x0218, [0x0173] = 0x0219,
  [0x0174] = 0x021a, [0x0175] = 0x021b, [0x0176] = 0x021c, [0x0177] = 0x021d,
  [0x0178] = 0x021e, [0x0179] = 0x021f,
  [0x017c] = 0x0222, [0x017d] = 0x0223, [0x017e] = 0x0224, [0x017f] = 0x0225,
  [0x0180] = 0x0226, [0x0181] = 0x0227, [0x0182] = 0x0228, [0x0183] = 0x0229,
  [0x0184] = 0x022a, [0x0185] = 0x022b, [0x0186] = 0x022c, [0x0187] = 0x022d,
  [0x0188] = 0x022e, [0x0189] = 0x022f, [0x018a] = 0x0230, [0x018b] = 0x0231,
  [0x018c] = 0x0232, [0x018d] = 0x0233, [0x01aa] = 0x0250, [0x01ab] = 0x0252,
  [0x01ac] = 0x0253, [0x01ad] = 0x0254, [0x01ae] = 0x0255, [0x01af] = 0x0256,
  [0x01b0] = 0x0257, [0x01b1] = 0x0258, [0x01b2] = 0x0259, [0x01b3] = 0x025a,
  [0x01b4] = 0x025b, [0x01b5] = 0x025c, [0x01b6] = 0x025d, [0x01b7] = 0x025e,
  [0x01b8] = 0x025f, [0x01b9] = 0x0260, [0x01ba] = 0x0262, [0x01bb] = 0x0263,
  [0x01bc] = 0x0264, [0x01bd] = 0x0265, [0x01be] = 0x0266, [0x01bf] = 0x0267,
  [0x01c0] = 0x0268, [0x01c1] = 0x0269, [0x01c2] = 0x026a, [0x01c3] = 0x026b,
  [0x01c4] = 0x026c, [0x01c5] = 0x026d, [0x01c6] = 0x026e, [0x01c7] = 0x026f,
  [0x01c8] = 0x0270, [0x01c9] = 0x0271, [0x01ca] = 0x0272, [0x01cb] = 0x0273,
  [0x01cc] = 0x0274, [0x01cd] = 0x0275, [0x01ce] = 0x0276, [0x01cf] = 0x0277,
  [0x01d0] = 0x0278, [0x01d1] = 0x0279, [0x01d2] = 0x027a, [0x01d3] = 0x027b,
  [0x01d4] = 0x027c, [0x01d5] = 0x027d, [0x01d6] = 0x027e, [0x01d7] = 0x027f,
  [0x01d8] = 0x0280, [0x01d9] = 0x0281, [0x01da] = 0x0282, [0x01db] = 0x0283,
  [0x01dc] = 0x0284, [0x01dd] = 0x0285, [0x01de] = 0x0286, [0x01df] = 0x0287,
  [0x01e0] = 0x0288, [0x01e1] = 0x0289, [0x01e2] = 0x028a, [0x01e3] = 0x028b,
  [0x01e4] = 0x028c, [0x01e5] = 0x028d, [0x01e6] = 0x028e, [0x01e7] = 0x028f,
  [0x01e8] = 0x0290, [0x01e9] = 0x0291, [0x01ea] = 0x0292, [0x01eb] = 0x0293,
  [0x01ec] = 0x0294, [0x01ed] = 0x0295, [0x01ee] = 0x0296, [0x01ef] = 0x0297,
  [0x01f0] = 0x0298, [0x01f1] = 0x0299, [0x01f2] = 0x029a, [0x01f3] = 0x029b,
  [0x01f4] = 0x029c, [0x01f5] = 0x029d, [0x01f6] = 0x029e, [0x01f7] = 0x029f,
  [0x01f8] = 0x02a0, [0x01f9] = 0x02a1, [0x01fa] = 0x02a2, [0x01fb] = 0x02a3,
  [0x01fc] = 0x02a4, [0x01fd] = 0x02a5, [0x01fe] = 0x02a6, [0x01ff] = 0x02a7,
  [0x0200] = 0x02a8, [0x0201] = 0x02a9, [0x0202] = 0x02aa, [0x0203] = 0x02ab,
  [0x0204] = 0x02ac, [0x0205] = 0x02ad,
  [0x0208] = 0x02b0, [0x0209] = 0x02b1, [0x020a] = 0x02b2, [0x020b] = 0x02b3,
  [0x020c] = 0x02b4, [0x020d] = 0x02b5, [0x020e] = 0x02b6, [0x020f] = 0x02b7,
  [0x0210] = 0x02b8, [0x0211] = 0x02b9, [0x0212] = 0x02ba, [0x0213] = 0x02bb,
  [0x0214] = 0x02bc, [0x0215] = 0x02bd, [0x0216] = 0x02be, [0x0217] = 0x02bf,
  [0x0218] = 0x02c0, [0x0219] = 0x02c1, [0x021a] = 0x02c2, [0x021b] = 0x02c3,
  [0x021c] = 0x02c4, [0x021d] = 0x02c5, [0x021e] = 0x02c6, [0x021f] = 0x02c8,
  [0x0220] = 0x02cc, [0x0221] = 0x02cd, [0x0222] = 0x02ce, [0x0223] = 0x02cf,
  [0x0224] = 0x02d0, [0x0225] = 0x02d1, [0x0226] = 0x02d2, [0x0227] = 0x02d3,
  [0x0228] = 0x02d4, [0x0229] = 0x02d5, [0x022a] = 0x02d6, [0x022b] = 0x02d7,
  [0x022c] = 0x02d8, [0x022d] = 0x02da, [0x022e] = 0x02db, [0x022f] = 0x02dc,
  [0x0230] = 0x02dd, [0x0231] = 0x02de, [0x0232] = 0x02df, [0x0233] = 0x02e0,
  [0x0234] = 0x02e1, [0x0235] = 0x02e2, [0x0236] = 0x02e3, [0x0237] = 0x02e4,
  [0x0238] = 0x02e5, [0x0239] = 0x02e6, [0x023a] = 0x02e7, [0x023b] = 0x02e8,
  [0x023c] = 0x02e9, [0x023d] = 0x02ea, [0x023e] = 0x02eb, [0x023f] = 0x02ec,
  [0x0240] = 0x02ed, [0x0241] = 0x02ee, [0x0253] = 0x0300,
  [0x0254] = 0x0301, [0x0255] = 0x0302, [0x0256] = 0x0303, [0x0257] = 0x0304,
  [0x0258] = 0x0305, [0x0259] = 0x0306, [0x025a] = 0x0307, [0x025b] = 0x0308,
  [0x025c] = 0x0309, [0x025d] = 0x030a, [0x025e] = 0x030b, [0x025f] = 0x030c,
  [0x0260] = 0x030d, [0x0261] = 0x030e, [0x0262] = 0x030f, [0x0263] = 0x0310,
  [0x0264] = 0x0311, [0x0265] = 0x0312, [0x0266] = 0x0313, [0x0267] = 0x0314,
  [0x0268] = 0x0315, [0x0269] = 0x0316, [0x026a] = 0x0317, [0x026b] = 0x0318,
  [0x026c] = 0x0319, [0x026d] = 0x031a, [0x026e] = 0x031b, [0x026f] = 0x031c,
  [0x0270] = 0x031d, [0x0271] = 0x031e, [0x0272] = 0x031f, [0x0273] = 0x0320,
  [0x0274] = 0x0321, [0x0275] = 0x0322, [0x0276] = 0x0323, [0x0277] = 0x0324,
  [0x0278] = 0x0325, [0x0279] = 0x0326, [0x027a] = 0x0327, [0x027b] = 0x0328,
  [0x027c] = 0x0329, [0x027d] = 0x032a, [0x027e] = 0x032b, [0x027f] = 0x032c,
  [0x0280] = 0x032d, [0x0281] = 0x032e, [0x0282] = 0x032f, [0x0283] = 0x0330,
  [0x0284] = 0x0331, [0x0285] = 0x0332, [0x0286] = 0x0333, [0x0287] = 0x0334,
  [0x0288] = 0x0335, [0x0289] = 0x0336, [0x028a] = 0x0337, [0x028b] = 0x0338,
  [0x028c] = 0x0339, [0x028d] = 0x033a, [0x028e] = 0x033b, [0x028f] = 0x033c,
  [0x0290] = 0x033d, [0x0291] = 0x033e, [0x0292] = 0x033f, [0x0293] = 0x0340,
  [0x0294] = 0x0341, [0x0295] = 0x0342, [0x0296] = 0x0343, [0x0297] = 0x0344,
  [0x0298] = 0x0345, [0x0299] = 0x0346, [0x029a] = 0x0347, [0x029b] = 0x0348,
  [0x029c] = 0x0349, [0x029d] = 0x034a, [0x029e] = 0x034b, [0x029f] = 0x034c,
  [0x02a0] = 0x034d, [0x02a1] = 0x034e, [0x02b3] = 0x0360,
  [0x02b4] = 0x0361, [0x02b5] = 0x0362, [0x02c7] = 0x0374,
  [0x02c8] = 0x0375, [0x02cd] = 0x037a, [0x02d1] = 0x037e, [0x02d7] = 0x0384,
  [0x02d8] = 0x0385, [0x02d9] = 0x0386, [0x02da] = 0x0387, [0x02db] = 0x0388,
  [0x02dc] = 0x0389, [0x02dd] = 0x038a, [0x02df] = 0x038c,
  [0x02e1] = 0x038e, [0x02e2] = 0x038f, [0x02e3] = 0x0390,
  [0x02e5] = 0x03aa, [0x02e6] = 0x03ab, [0x02e7] = 0x03ac,
  [0x02e8] = 0x03ad, [0x02e9] = 0x03ae, [0x02ea] = 0x03af, [0x02eb] = 0x03b0,
  [0x02ec] = 0x03c2, [0x02ed] = 0x03ca, [0x02ee] = 0x03cb, [0x02ef] = 0x03cc,
  [0x02f0] = 0x03cd, [0x02f1] = 0x03ce, [0x02f3] = 0x03d0,
  [0x02f4] = 0x03d1, [0x02f5] = 0x03d2, [0x02f6] = 0x03d3, [0x02f7] = 0x03d4,
  [0x02f8] = 0x03d5, [0x02f9] = 0x03d6, [0x02fa] = 0x03d7,
  [0x02fd] = 0x03da, [0x02fe] = 0x03db, [0x02ff] = 0x03dc,
  [0x0300] = 0x03dd, [0x0301] = 0x03de, [0x0302] = 0x03df, [0x0303] = 0x03e0,
  [0x0304] = 0x03e1, [0x0305] = 0x03e2, [0x0306] = 0x03e3, [0x0307] = 0x03e4,
  [0x0308] = 0x03e5, [0x0309] = 0x03e6, [0x030a] = 0x03e7, [0x030b] = 0x03e8,
  [0x030c] = 0x03e9, [0x030d] = 0x03ea, [0x030e] = 0x03eb, [0x030f] = 0x03ec,
  [0x0310] = 0x03ed, [0x0311] = 0x03ee, [0x0312] = 0x03ef, [0x0313] = 0x03f0,
  [0x0314] = 0x03f1, [0x0315] = 0x03f2, [0x0316] = 0x03f3, [0x0323] = 0x0400,
  [0x0324] = 0x0402, [0x0325] = 0x0403, [0x0326] = 0x0404, [0x0327] = 0x0405,
  [0x0328] = 0x0406, [0x0329] = 0x0407, [0x032a] = 0x0408, [0x032b] = 0x0409,
  [0x032c] = 0x040a, [0x032d] = 0x040b, [0x032e] = 0x040c, [0x032f] = 0x040d,
  [0x0330] = 0x040e, [0x0331] = 0x040f, [0x0332] = 0x0450, [0x0333] = 0x0452,
  [0x0334] = 0x0453, [0x0335] = 0x0454, [0x0336] = 0x0455, [0x0337] = 0x0456,
  [0x0338] = 0x0457, [0x0339] = 0x0458, [0x033a] = 0x0459, [0x033b] = 0x045a,
  [0x033c] = 0x045b, [0x033d] = 0x045c, [0x033e] = 0x045d, [0x033f] = 0x045e,
  [0x0340] = 0x045f, [0x0341] = 0x0460, [0x0342] = 0x0461, [0x0343] = 0x0462,
  [0x0344] = 0x0463, [0x0345] = 0x0464, [0x0346] = 0x0465, [0x0347] = 0x0466,
  [0x0348] = 0x0467, [0x0349] = 0x0468, [0x034a] = 0x0469, [0x034b] = 0x046a,
  [0x034c] = 0x046b, [0x034d] = 0x046c, [0x034e] = 0x046d, [0x034f] = 0x046e,
  [0x0350] = 0x046f, [0x0351] = 0x0470, [0x0352] = 0x0471, [0x0353] = 0x0472,
  [0x0354] = 0x0473, [0x0355] = 0x0474, [0x0356] = 0x0475, [0x0357] = 0x0476,
  [0x0358] = 0x0477, [0x0359] = 0x0478, [0x035a] = 0x0479, [0x035b] = 0x047a,
  [0x035c] = 0x047b, [0x035d] = 0x047c, [0x035e] = 0x047d, [0x035f] = 0x047e,
  [0x0360] = 0x047f, [0x0361] = 0x0480, [0x0362] = 0x0481, [0x0363] = 0x0482,
  [0x0364] = 0x0483, [0x0365] = 0x0484, [0x0366] = 0x0485, [0x0367] = 0x0486,
  [0x0369] = 0x0488, [0x036a] = 0x0489,
  [0x036d] = 0x048c, [0x036e] = 0x048d, [0x036f] = 0x048e,
  [0x0370] = 0x048f, [0x0371] = 0x0490, [0x0372] = 0x0491, [0x0373] = 0x0492,
  [0x0374] = 0x0493, [0x0375] = 0x0494, [0x0376] = 0x0495, [0x0377] = 0x0496,
  [0x0378] = 0x0497, [0x0379] = 0x0498, [0x037a] = 0x0499, [0x037b] = 0x049a,
  [0x037c] = 0x049b, [0x037d] = 0x049c, [0x037e] = 0x049d, [0x037f] = 0x049e,
  [0x0380] = 0x049f, [0x0381] = 0x04a0, [0x0382] = 0x04a1, [0x0383] = 0x04a2,
  [0x0384] = 0x04a3, [0x0385] = 0x04a4, [0x0386] = 0x04a5, [0x0387] = 0x04a6,
  [0x0388] = 0x04a7, [0x0389] = 0x04a8, [0x038a] = 0x04a9, [0x038b] = 0x04aa,
  [0x038c] = 0x04ab, [0x038d] = 0x04ac, [0x038e] = 0x04ad, [0x038f] = 0x04ae,
  [0x0390] = 0x04af, [0x0391] = 0x04b0, [0x0392] = 0x04b1, [0x0393] = 0x04b2,
  [0x0394] = 0x04b3, [0x0395] = 0x04b4, [0x0396] = 0x04b5, [0x0397] = 0x04b6,
  [0x0398] = 0x04b7, [0x0399] = 0x04b8, [0x039a] = 0x04b9, [0x039b] = 0x04ba,
  [0x039c] = 0x04bb, [0x039d] = 0x04bc, [0x039e] = 0x04bd, [0x039f] = 0x04be,
  [0x03a0] = 0x04bf, [0x03a1] = 0x04c0, [0x03a2] = 0x04c1, [0x03a3] = 0x04c2,
  [0x03a4] = 0x04c3, [0x03a5] = 0x04c4, [0x03a8] = 0x04c7, [0x03a9] = 0x04c8,
  [0x03ac] = 0x04cb, [0x03ad] = 0x04cc,
  [0x03b1] = 0x04d0, [0x03b2] = 0x04d1, [0x03b3] = 0x04d2,
  [0x03b4] = 0x04d3, [0x03b5] = 0x04d4, [0x03b6] = 0x04d5, [0x03b7] = 0x04d6,
  [0x03b8] = 0x04d7, [0x03b9] = 0x04d8, [0x03ba] = 0x04d9, [0x03bb] = 0x04da,
  [0x03bc] = 0x04db, [0x03bd] = 0x04dc, [0x03be] = 0x04dd, [0x03bf] = 0x04de,
  [0x03c0] = 0x04df, [0x03c1] = 0x04e0, [0x03c2] = 0x04e1, [0x03c3] = 0x04e2,
  [0x03c4] = 0x04e3, [0x03c5] = 0x04e4, [0x03c6] = 0x04e5, [0x03c7] = 0x04e6,
  [0x03c8] = 0x04e7, [0x03c9] = 0x04e8, [0x03ca] = 0x04e9, [0x03cb] = 0x04ea,
  [0x03cc] = 0x04eb, [0x03cd] = 0x04ec, [0x03ce] = 0x04ed, [0x03cf] = 0x04ee,
  [0x03d0] = 0x04ef, [0x03d1] = 0x04f0, [0x03d2] = 0x04f1, [0x03d3] = 0x04f2,
  [0x03d4] = 0x04f3, [0x03d5] = 0x04f4, [0x03d6] = 0x04f5,
  [0x03d9] = 0x04f8, [0x03da] = 0x04f9, [0x0412] = 0x0531, [0x0413] = 0x0532,
  [0x0414] = 0x0533, [0x0415] = 0x0534, [0x0416] = 0x0535, [0x0417] = 0x0536,
  [0x0418] = 0x0537, [0x0419] = 0x0538, [0x041a] = 0x0539, [0x041b] = 0x053a,
  [0x041c] = 0x053b, [0x041d] = 0x053c, [0x041e] = 0x053d, [0x041f] = 0x053e,
  [0x0420] = 0x053f, [0x0421] = 0x0540, [0x0422] = 0x0541, [0x0423] = 0x0542,
  [0x0424] = 0x0543, [0x0425] = 0x0544, [0x0426] = 0x0545, [0x0427] = 0x0546,
  [0x0428] = 0x0547, [0x0429] = 0x0548, [0x042a] = 0x0549, [0x042b] = 0x054a,
  [0x042c] = 0x054b, [0x042d] = 0x054c, [0x042e] = 0x054d, [0x042f] = 0x054e,
  [0x0430] = 0x054f, [0x0431] = 0x0550, [0x0432] = 0x0551, [0x0433] = 0x0552,
  [0x0434] = 0x0553, [0x0435] = 0x0554, [0x0436] = 0x0555, [0x0437] = 0x0556,
  [0x043a] = 0x0559, [0x043b] = 0x055a,
  [0x043c] = 0x055b, [0x043d] = 0x055c, [0x043e] = 0x055d, [0x043f] = 0x055e,
  [0x0440] = 0x055f, [0x0442] = 0x0561, [0x0443] = 0x0562,
  [0x0444] = 0x0563, [0x0445] = 0x0564, [0x0446] = 0x0565, [0x0447] = 0x0566,
  [0x0448] = 0x0567, [0x0449] = 0x0568, [0x044a] = 0x0569, [0x044b] = 0x056a,
  [0x044c] = 0x056b, [0x044d] = 0x056c, [0x044e] = 0x056d, [0x044f] = 0x056e,
  [0x0450] = 0x056f, [0x0451] = 0x0570, [0x0452] = 0x0571, [0x0453] = 0x0572,
  [0x0454] = 0x0573, [0x0455] = 0x0574, [0x0456] = 0x0575, [0x0457] = 0x0576,
  [0x0458] = 0x0577, [0x0459] = 0x0578, [0x045a] = 0x0579, [0x045b] = 0x057a,
  [0x045c] = 0x057b, [0x045d] = 0x057c, [0x045e] = 0x057d, [0x045f] = 0x057e,
  [0x0460] = 0x057f, [0x0461] = 0x0580, [0x0462] = 0x0581, [0x0463] = 0x0582,
  [0x0464] = 0x0583, [0x0465] = 0x0584, [0x0466] = 0x0585, [0x0467] = 0x0586,
  [0x0468] = 0x0587, [0x046a] = 0x0589, [0x046b] = 0x058a,
  [0x0472] = 0x0591, [0x0473] = 0x0592,
  [0x0474] = 0x0593, [0x0475] = 0x0594, [0x0476] = 0x0595, [0x0477] = 0x0596,
  [0x0478] = 0x0597, [0x0479] = 0x0598, [0x047a] = 0x0599, [0x047b] = 0x059a,
  [0x047c] = 0x059b, [0x047d] = 0x059c, [0x047e] = 0x059d, [0x047f] = 0x059e,
  [0x0480] = 0x059f, [0x0481] = 0x05a0, [0x0482] = 0x05a1,
  [0x0484] = 0x05a3, [0x0485] = 0x05a4, [0x0486] = 0x05a5, [0x0487] = 0x05a6,
  [0x0488] = 0x05a7, [0x0489] = 0x05a8, [0x048a] = 0x05a9, [0x048b] = 0x05aa,
  [0x048c] = 0x05ab, [0x048d] = 0x05ac, [0x048e] = 0x05ad, [0x048f] = 0x05ae,
  [0x0490] = 0x05af, [0x0491] = 0x05b0, [0x0492] = 0x05b1, [0x0493] = 0x05b2,
  [0x0494] = 0x05b3, [0x0495] = 0x05b4, [0x0496] = 0x05b5, [0x0497] = 0x05b6,
  [0x0498] = 0x05b7, [0x0499] = 0x05b8, [0x049a] = 0x05b9,
  [0x049c] = 0x05bb, [0x049d] = 0x05bc, [0x049e] = 0x05bd, [0x049f] = 0x05be,
  [0x04a0] = 0x05bf, [0x04a1] = 0x05c0, [0x04a2] = 0x05c1, [0x04a3] = 0x05c2,
  [0x04a4] = 0x05c3, [0x04a5] = 0x05c4,
  [0x04b1] = 0x05d0, [0x04b2] = 0x05d1, [0x04b3] = 0x05d2,
  [0x04b4] = 0x05d3, [0x04b5] = 0x05d4, [0x04b6] = 0x05d5, [0x04b7] = 0x05d6,
  [0x04b8] = 0x05d7, [0x04b9] = 0x05d8, [0x04ba] = 0x05d9, [0x04bb] = 0x05da,
  [0x04bc] = 0x05db, [0x04bd] = 0x05dc, [0x04be] = 0x05dd, [0x04bf] = 0x05de,
  [0x04c0] = 0x05df, [0x04c1] = 0x05e0, [0x04c2] = 0x05e1, [0x04c3] = 0x05e2,
  [0x04c4] = 0x05e3, [0x04c5] = 0x05e4, [0x04c6] = 0x05e5, [0x04c7] = 0x05e6,
  [0x04c8] = 0x05e7, [0x04c9] = 0x05e8, [0x04ca] = 0x05e9, [0x04cb] = 0x05ea,
  [0x04d1] = 0x05f0, [0x04d2] = 0x05f1, [0x04d3] = 0x05f2,
  [0x04d4] = 0x05f3, [0x04d5] = 0x05f4,
  [0x04ed] = 0x060c, [0x04fc] = 0x061b,
  [0x0500] = 0x061f, [0x0502] = 0x0621, [0x0503] = 0x0622,
  [0x0504] = 0x0623, [0x0505] = 0x0624, [0x0506] = 0x0625, [0x0507] = 0x0626,
  [0x0508] = 0x0627, [0x0509] = 0x0628, [0x050a] = 0x0629, [0x050b] = 0x062a,
  [0x050c] = 0x062b, [0x050d] = 0x062c, [0x050e] = 0x062d, [0x050f] = 0x062e,
  [0x0510] = 0x062f, [0x0511] = 0x0630, [0x0512] = 0x0631, [0x0513] = 0x0632,
  [0x0514] = 0x0633, [0x0515] = 0x0634, [0x0516] = 0x0635, [0x0517] = 0x0636,
  [0x0518] = 0x0637, [0x0519] = 0x0638, [0x051a] = 0x0639, [0x051b] = 0x063a,
  [0x0521] = 0x0640, [0x0522] = 0x0641, [0x0523] = 0x0642,
  [0x0524] = 0x0643, [0x0525] = 0x0644, [0x0526] = 0x0645, [0x0527] = 0x0646,
  [0x0528] = 0x0647, [0x0529] = 0x0648, [0x052a] = 0x0649, [0x052b] = 0x064a,
  [0x052c] = 0x064b, [0x052d] = 0x064c, [0x052e] = 0x064d, [0x052f] = 0x064e,
  [0x0530] = 0x064f, [0x0531] = 0x0650, [0x0532] = 0x0651, [0x0533] = 0x0652,
  [0x0534] = 0x0653, [0x0535] = 0x0654, [0x0536] = 0x0655,
  [0x0541] = 0x0660, [0x0542] = 0x0661, [0x0543] = 0x0662,
  [0x0544] = 0x0663, [0x0545] = 0x0664, [0x0546] = 0x0665, [0x0547] = 0x0666,
  [0x0548] = 0x0667, [0x0549] = 0x0668, [0x054a] = 0x0669, [0x054b] = 0x066a,
  [0x054c] = 0x066b, [0x054d] = 0x066c, [0x054e] = 0x066d,
  [0x0551] = 0x0670, [0x0552] = 0x0671, [0x0553] = 0x0672,
  [0x0554] = 0x0673, [0x0555] = 0x0674, [0x0556] = 0x0675, [0x0557] = 0x0676,
  [0x0558] = 0x0677, [0x0559] = 0x0678, [0x055a] = 0x0679, [0x055b] = 0x067a,
  [0x055c] = 0x067b, [0x055d] = 0x067c, [0x055e] = 0x067d, [0x055f] = 0x067e,
  [0x0560] = 0x067f, [0x0561] = 0x0680, [0x0562] = 0x0681, [0x0563] = 0x0682,
  [0x0564] = 0x0683, [0x0565] = 0x0684, [0x0566] = 0x0685, [0x0567] = 0x0686,
  [0x0568] = 0x0687, [0x0569] = 0x0688, [0x056a] = 0x0689, [0x056b] = 0x068a,
  [0x056c] = 0x068b, [0x056d] = 0x068c, [0x056e] = 0x068d, [0x056f] = 0x068e,
  [0x0570] = 0x068f, [0x0571] = 0x0690, [0x0572] = 0x0691, [0x0573] = 0x0692,
  [0x0574] = 0x0693, [0x0575] = 0x0694, [0x0576] = 0x0695, [0x0577] = 0x0696,
  [0x0578] = 0x0697, [0x0579] = 0x0698, [0x057a] = 0x0699, [0x057b] = 0x069a,
  [0x057c] = 0x069b, [0x057d] = 0x069c, [0x057e] = 0x069d, [0x057f] = 0x069e,
  [0x0580] = 0x069f, [0x0581] = 0x06a0, [0x0582] = 0x06a1, [0x0583] = 0x06a2,
  [0x0584] = 0x06a3, [0x0585] = 0x06a4, [0x0586] = 0x06a5, [0x0587] = 0x06a6,
  [0x0588] = 0x06a7, [0x0589] = 0x06a8, [0x058a] = 0x06a9, [0x058b] = 0x06aa,
  [0x058c] = 0x06ab, [0x058d] = 0x06ac, [0x058e] = 0x06ad, [0x058f] = 0x06ae,
  [0x0590] = 0x06af, [0x0591] = 0x06b0, [0x0592] = 0x06b1, [0x0593] = 0x06b2,
  [0x0594] = 0x06b3, [0x0595] = 0x06b4, [0x0596] = 0x06b5, [0x0597] = 0x06b6,
  [0x0598] = 0x06b7, [0x0599] = 0x06b8, [0x059a] = 0x06b9, [0x059b] = 0x06ba,
  [0x059c] = 0x06bb, [0x059d] = 0x06bc, [0x059e] = 0x06bd, [0x059f] = 0x06be,
  [0x05a0] = 0x06bf, [0x05a1] = 0x06c0, [0x05a2] = 0x06c1, [0x05a3] = 0x06c2,
  [0x05a4] = 0x06c3, [0x05a5] = 0x06c4, [0x05a6] = 0x06c5, [0x05a7] = 0x06c6,
  [0x05a8] = 0x06c7, [0x05a9] = 0x06c8, [0x05aa] = 0x06c9, [0x05ab] = 0x06ca,
  [0x05ac] = 0x06cb, [0x05ad] = 0x06cc, [0x05ae] = 0x06cd, [0x05af] = 0x06ce,
  [0x05b0] = 0x06cf, [0x05b1] = 0x06d0, [0x05b2] = 0x06d1, [0x05b3] = 0x06d2,
  [0x05b4] = 0x06d3, [0x05b5] = 0x06d4, [0x05b6] = 0x06d5, [0x05b7] = 0x06d6,
  [0x05b8] = 0x06d7, [0x05b9] = 0x06d8, [0x05ba] = 0x06d9, [0x05bb] = 0x06da,
  [0x05bc] = 0x06db, [0x05bd] = 0x06dc, [0x05be] = 0x06dd, [0x05bf] = 0x06de,
  [0x05c0] = 0x06df, [0x05c1] = 0x06e0, [0x05c2] = 0x06e1, [0x05c3] = 0x06e2,
  [0x05c4] = 0x06e3, [0x05c5] = 0x06e4, [0x05c6] = 0x06e5, [0x05c7] = 0x06e6,
  [0x05c8] = 0x06e7, [0x05c9] = 0x06e8, [0x05ca] = 0x06e9, [0x05cb] = 0x06ea,
  [0x05cc] = 0x06eb, [0x05cd] = 0x06ec, [0x05ce] = 0x06ed,
  [0x05d1] = 0x06f0, [0x05d2] = 0x06f1, [0x05d3] = 0x06f2,
  [0x05d4] = 0x06f3, [0x05d5] = 0x06f4, [0x05d6] = 0x06f5, [0x05d7] = 0x06f6,
  [0x05d8] = 0x06f7, [0x05d9] = 0x06f8, [0x05da] = 0x06f9, [0x05db] = 0x06fa,
  [0x05dc] = 0x06fb, [0x05dd] = 0x06fc, [0x05de] = 0x06fd, [0x05df] = 0x06fe,
  [0x05e1] = 0x0700, [0x05e2] = 0x0701, [0x05e3] = 0x0702,
  [0x05e4] = 0x0703, [0x05e5] = 0x0704, [0x05e6] = 0x0705, [0x05e7] = 0x0706,
  [0x05e8] = 0x0707, [0x05e9] = 0x0708, [0x05ea] = 0x0709, [0x05eb] = 0x070a,
  [0x05ec] = 0x070b, [0x05ed] = 0x070c, [0x05ee] = 0x070d,
  [0x05f0] = 0x070f, [0x05f1] = 0x0710, [0x05f2] = 0x0711, [0x05f3] = 0x0712,
  [0x05f4] = 0x0713, [0x05f5] = 0x0714, [0x05f6] = 0x0715, [0x05f7] = 0x0716,
  [0x05f8] = 0x0717, [0x05f9] = 0x0718, [0x05fa] = 0x0719, [0x05fb] = 0x071a,
  [0x05fc] = 0x071b, [0x05fd] = 0x071c, [0x05fe] = 0x071d, [0x05ff] = 0x071e,
  [0x0600] = 0x071f, [0x0601] = 0x0720, [0x0602] = 0x0721, [0x0603] = 0x0722,
  [0x0604] = 0x0723, [0x0605] = 0x0724, [0x0606] = 0x0725, [0x0607] = 0x0726,
  [0x0608] = 0x0727, [0x0609] = 0x0728, [0x060a] = 0x0729, [0x060b] = 0x072a,
  [0x060c] = 0x072b, [0x060d] = 0x072c,
  [0x0611] = 0x0730, [0x0612] = 0x0731, [0x0613] = 0x0732,
  [0x0614] = 0x0733, [0x0615] = 0x0734, [0x0616] = 0x0735, [0x0617] = 0x0736,
  [0x0618] = 0x0737, [0x0619] = 0x0738, [0x061a] = 0x0739, [0x061b] = 0x073a,
  [0x061c] = 0x073b, [0x061d] = 0x073c, [0x061e] = 0x073d, [0x061f] = 0x073e,
  [0x0620] = 0x073f, [0x0621] = 0x0740, [0x0622] = 0x0741, [0x0623] = 0x0742,
  [0x0624] = 0x0743, [0x0625] = 0x0744, [0x0626] = 0x0745, [0x0627] = 0x0746,
  [0x0628] = 0x0747, [0x0629] = 0x0748, [0x062a] = 0x0749, [0x062b] = 0x074a,
  [0x0661] = 0x0780, [0x0662] = 0x0781, [0x0663] = 0x0782,
  [0x0664] = 0x0783, [0x0665] = 0x0784, [0x0666] = 0x0785, [0x0667] = 0x0786,
  [0x0668] = 0x0787, [0x0669] = 0x0788, [0x066a] = 0x0789, [0x066b] = 0x078a,
  [0x066c] = 0x078b, [0x066d] = 0x078c, [0x066e] = 0x078d, [0x066f] = 0x078e,
  [0x0670] = 0x078f, [0x0671] = 0x0790, [0x0672] = 0x0791, [0x0673] = 0x0792,
  [0x0674] = 0x0793, [0x0675] = 0x0794, [0x0676] = 0x0795, [0x0677] = 0x0796,
  [0x0678] = 0x0797, [0x0679] = 0x0798, [0x067a] = 0x0799, [0x067b] = 0x079a,
  [0x067c] = 0x079b, [0x067d] = 0x079c, [0x067e] = 0x079d, [0x067f] = 0x079e,
  [0x0680] = 0x079f, [0x0681] = 0x07a0, [0x0682] = 0x07a1, [0x0683] = 0x07a2,
  [0x0684] = 0x07a3, [0x0685] = 0x07a4, [0x0686] = 0x07a5, [0x0687] = 0x07a6,
  [0x0688] = 0x07a7, [0x0689] = 0x07a8, [0x068a] = 0x07a9, [0x068b] = 0x07aa,
  [0x068c] = 0x07ab, [0x068d] = 0x07ac, [0x068e] = 0x07ad, [0x068f] = 0x07ae,
  [0x0690] = 0x07af, [0x0691] = 0x07b0,
  [0x07e2] = 0x0901, [0x07e3] = 0x0902,
  [0x07e4] = 0x0903, [0x07e6] = 0x0905, [0x07e7] = 0x0906,
  [0x07e8] = 0x0907, [0x07e9] = 0x0908, [0x07ea] = 0x0909, [0x07eb] = 0x090a,
  [0x07ec] = 0x090b, [0x07ed] = 0x090c, [0x07ee] = 0x090d, [0x07ef] = 0x090e,
  [0x07f0] = 0x090f, [0x07f1] = 0x0910, [0x07f2] = 0x0911, [0x07f3] = 0x0912,
  [0x07f4] = 0x0913, [0x07f5] = 0x0914, [0x07f6] = 0x0915, [0x07f7] = 0x0916,
  [0x07f8] = 0x0917, [0x07f9] = 0x0918, [0x07fa] = 0x0919, [0x07fb] = 0x091a,
  [0x07fc] = 0x091b, [0x07fd] = 0x091c, [0x07fe] = 0x091d, [0x07ff] = 0x091e,
  [0x0800] = 0x091f, [0x0801] = 0x0920, [0x0802] = 0x0921, [0x0803] = 0x0922,
  [0x0804] = 0x0923, [0x0805] = 0x0924, [0x0806] = 0x0925, [0x0807] = 0x0926,
  [0x0808] = 0x0927, [0x0809] = 0x0928, [0x080a] = 0x0929, [0x080b] = 0x092a,
  [0x080c] = 0x092b, [0x080d] = 0x092c, [0x080e] = 0x092d, [0x080f] = 0x092e,
  [0x0810] = 0x092f, [0x0811] = 0x0930, [0x0812] = 0x0931, [0x0813] = 0x0932,
  [0x0814] = 0x0933, [0x0815] = 0x0934, [0x0816] = 0x0935, [0x0817] = 0x0936,
  [0x0818] = 0x0937, [0x0819] = 0x0938, [0x081a] = 0x0939,
  [0x081d] = 0x093c, [0x081e] = 0x093d, [0x081f] = 0x093e,
  [0x0820] = 0x093f, [0x0821] = 0x0940, [0x0822] = 0x0941, [0x0823] = 0x0942,
  [0x0824] = 0x0943, [0x0825] = 0x0944, [0x0826] = 0x0945, [0x0827] = 0x0946,
  [0x0828] = 0x0947, [0x0829] = 0x0948, [0x082a] = 0x0949, [0x082b] = 0x094a,
  [0x082c] = 0x094b, [0x082d] = 0x094c, [0x082e] = 0x094d,
  [0x0831] = 0x0950, [0x0832] = 0x0951, [0x0833] = 0x0952,
  [0x0834] = 0x0953, [0x0835] = 0x0954,
  [0x0839] = 0x0958, [0x083a] = 0x0959, [0x083b] = 0x095a,
  [0x083c] = 0x095b, [0x083d] = 0x095c, [0x083e] = 0x095d, [0x083f] = 0x095e,
  [0x0840] = 0x095f, [0x0841] = 0x0960, [0x0842] = 0x0961, [0x0843] = 0x0962,
  [0x0844] = 0x0963, [0x0845] = 0x0964, [0x0846] = 0x0965, [0x0847] = 0x0966,
  [0x0848] = 0x0967, [0x0849] = 0x0968, [0x084a] = 0x0969, [0x084b] = 0x096a,
  [0x084c] = 0x096b, [0x084d] = 0x096c, [0x084e] = 0x096d, [0x084f] = 0x096e,
  [0x0850] = 0x096f, [0x0851] = 0x0970, [0x0862] = 0x0981, [0x0863] = 0x0982,
  [0x0864] = 0x0983, [0x0866] = 0x0985, [0x0867] = 0x0986,
  [0x0868] = 0x0987, [0x0869] = 0x0988, [0x086a] = 0x0989, [0x086b] = 0x098a,
  [0x086c] = 0x098b, [0x086d] = 0x098c, [0x0870] = 0x098f, [0x0871] = 0x0990,
  [0x0874] = 0x0993, [0x0875] = 0x0994, [0x0876] = 0x0995, [0x0877] = 0x0996,
  [0x0878] = 0x0997, [0x0879] = 0x0998, [0x087a] = 0x0999, [0x087b] = 0x099a,
  [0x087c] = 0x099b, [0x087d] = 0x099c, [0x087e] = 0x099d, [0x087f] = 0x099e,
  [0x0880] = 0x099f, [0x0881] = 0x09a0, [0x0882] = 0x09a1, [0x0883] = 0x09a2,
  [0x0884] = 0x09a3, [0x0885] = 0x09a4, [0x0886] = 0x09a5, [0x0887] = 0x09a6,
  [0x0888] = 0x09a7, [0x0889] = 0x09a8, [0x088b] = 0x09aa,
  [0x088c] = 0x09ab, [0x088d] = 0x09ac, [0x088e] = 0x09ad, [0x088f] = 0x09ae,
  [0x0890] = 0x09af, [0x0891] = 0x09b0, [0x0893] = 0x09b2, [0x0897] = 0x09b6,
  [0x0898] = 0x09b7, [0x0899] = 0x09b8, [0x089a] = 0x09b9,
  [0x089d] = 0x09bc, [0x089f] = 0x09be,
  [0x08a0] = 0x09bf, [0x08a1] = 0x09c0, [0x08a2] = 0x09c1, [0x08a3] = 0x09c2,
  [0x08a4] = 0x09c3, [0x08a5] = 0x09c4, [0x08a8] = 0x09c7, [0x08a9] = 0x09c8,
  [0x08ac] = 0x09cb, [0x08ad] = 0x09cc, [0x08ae] = 0x09cd, [0x08b8] = 0x09d7,
  [0x08bd] = 0x09dc, [0x08be] = 0x09dd,
  [0x08c0] = 0x09df, [0x08c1] = 0x09e0, [0x08c2] = 0x09e1, [0x08c3] = 0x09e2,
  [0x08c4] = 0x09e3, [0x08c7] = 0x09e6,
  [0x08c8] = 0x09e7, [0x08c9] = 0x09e8, [0x08ca] = 0x09e9, [0x08cb] = 0x09ea,
  [0x08cc] = 0x09eb, [0x08cd] = 0x09ec, [0x08ce] = 0x09ed, [0x08cf] = 0x09ee,
  [0x08d0] = 0x09ef, [0x08d1] = 0x09f0, [0x08d2] = 0x09f1, [0x08d3] = 0x09f2,
  [0x08d4] = 0x09f3, [0x08d5] = 0x09f4, [0x08d6] = 0x09f5, [0x08d7] = 0x09f6,
  [0x08d8] = 0x09f7, [0x08d9] = 0x09f8, [0x08da] = 0x09f9, [0x08db] = 0x09fa,
  [0x08e3] = 0x0a02, [0x08e6] = 0x0a05, [0x08e7] = 0x0a06,
  [0x08e8] = 0x0a07, [0x08e9] = 0x0a08, [0x08ea] = 0x0a09, [0x08eb] = 0x0a0a,
  [0x08f0] = 0x0a0f, [0x08f1] = 0x0a10,
  [0x08f4] = 0x0a13, [0x08f5] = 0x0a14, [0x08f6] = 0x0a15, [0x08f7] = 0x0a16,
  [0x08f8] = 0x0a17, [0x08f9] = 0x0a18, [0x08fa] = 0x0a19, [0x08fb] = 0x0a1a,
  [0x08fc] = 0x0a1b, [0x08fd] = 0x0a1c, [0x08fe] = 0x0a1d, [0x08ff] = 0x0a1e,
  [0x0900] = 0x0a1f, [0x0901] = 0x0a20, [0x0902] = 0x0a21, [0x0903] = 0x0a22,
  [0x0904] = 0x0a23, [0x0905] = 0x0a24, [0x0906] = 0x0a25, [0x0907] = 0x0a26,
  [0x0908] = 0x0a27, [0x0909] = 0x0a28, [0x090b] = 0x0a2a,
  [0x090c] = 0x0a2b, [0x090d] = 0x0a2c, [0x090e] = 0x0a2d, [0x090f] = 0x0a2e,
  [0x0910] = 0x0a2f, [0x0911] = 0x0a30, [0x0913] = 0x0a32,
  [0x0914] = 0x0a33, [0x0916] = 0x0a35, [0x0917] = 0x0a36,
  [0x0919] = 0x0a38, [0x091a] = 0x0a39, [0x091d] = 0x0a3c, [0x091f] = 0x0a3e,
  [0x0920] = 0x0a3f, [0x0921] = 0x0a40, [0x0922] = 0x0a41, [0x0923] = 0x0a42,
  [0x0928] = 0x0a47, [0x0929] = 0x0a48,
  [0x092c] = 0x0a4b, [0x092d] = 0x0a4c, [0x092e] = 0x0a4d,
  [0x093a] = 0x0a59, [0x093b] = 0x0a5a,
  [0x093c] = 0x0a5b, [0x093d] = 0x0a5c, [0x093f] = 0x0a5e, [0x0947] = 0x0a66,
  [0x0948] = 0x0a67, [0x0949] = 0x0a68, [0x094a] = 0x0a69, [0x094b] = 0x0a6a,
  [0x094c] = 0x0a6b, [0x094d] = 0x0a6c, [0x094e] = 0x0a6d, [0x094f] = 0x0a6e,
  [0x0950] = 0x0a6f, [0x0951] = 0x0a70, [0x0952] = 0x0a71, [0x0953] = 0x0a72,
  [0x0954] = 0x0a73, [0x0955] = 0x0a74, [0x0962] = 0x0a81, [0x0963] = 0x0a82,
  [0x0964] = 0x0a83, [0x0966] = 0x0a85, [0x0967] = 0x0a86,
  [0x0968] = 0x0a87, [0x0969] = 0x0a88, [0x096a] = 0x0a89, [0x096b] = 0x0a8a,
  [0x096c] = 0x0a8b, [0x096e] = 0x0a8d,
  [0x0970] = 0x0a8f, [0x0971] = 0x0a90, [0x0972] = 0x0a91,
  [0x0974] = 0x0a93, [0x0975] = 0x0a94, [0x0976] = 0x0a95, [0x0977] = 0x0a96,
  [0x0978] = 0x0a97, [0x0979] = 0x0a98, [0x097a] = 0x0a99, [0x097b] = 0x0a9a,
  [0x097c] = 0x0a9b, [0x097d] = 0x0a9c, [0x097e] = 0x0a9d, [0x097f] = 0x0a9e,
  [0x0980] = 0x0a9f, [0x0981] = 0x0aa0, [0x0982] = 0x0aa1, [0x0983] = 0x0aa2,
  [0x0984] = 0x0aa3, [0x0985] = 0x0aa4, [0x0986] = 0x0aa5, [0x0987] = 0x0aa6,
  [0x0988] = 0x0aa7, [0x0989] = 0x0aa8, [0x098b] = 0x0aaa,
  [0x098c] = 0x0aab, [0x098d] = 0x0aac, [0x098e] = 0x0aad, [0x098f] = 0x0aae,
  [0x0990] = 0x0aaf, [0x0991] = 0x0ab0, [0x0993] = 0x0ab2,
  [0x0994] = 0x0ab3, [0x0996] = 0x0ab5, [0x0997] = 0x0ab6,
  [0x0998] = 0x0ab7, [0x0999] = 0x0ab8, [0x099a] = 0x0ab9,
  [0x099d] = 0x0abc, [0x099e] = 0x0abd, [0x099f] = 0x0abe,
  [0x09a0] = 0x0abf, [0x09a1] = 0x0ac0, [0x09a2] = 0x0ac1, [0x09a3] = 0x0ac2,
  [0x09a4] = 0x0ac3, [0x09a5] = 0x0ac4, [0x09a6] = 0x0ac5,
  [0x09a8] = 0x0ac7, [0x09a9] = 0x0ac8, [0x09aa] = 0x0ac9,
  [0x09ac] = 0x0acb, [0x09ad] = 0x0acc, [0x09ae] = 0x0acd, [0x09b1] = 0x0ad0,
  [0x09c1] = 0x0ae0, [0x09c7] = 0x0ae6,
  [0x09c8] = 0x0ae7, [0x09c9] = 0x0ae8, [0x09ca] = 0x0ae9, [0x09cb] = 0x0aea,
  [0x09cc] = 0x0aeb, [0x09cd] = 0x0aec, [0x09ce] = 0x0aed, [0x09cf] = 0x0aee,
  [0x09d0] = 0x0aef, [0x09e2] = 0x0b01, [0x09e3] = 0x0b02,
  [0x09e4] = 0x0b03, [0x09e6] = 0x0b05, [0x09e7] = 0x0b06,
  [0x09e8] = 0x0b07, [0x09e9] = 0x0b08, [0x09ea] = 0x0b09, [0x09eb] = 0x0b0a,
  [0x09ec] = 0x0b0b, [0x09ed] = 0x0b0c, [0x09f0] = 0x0b0f, [0x09f1] = 0x0b10,
  [0x09f4] = 0x0b13, [0x09f5] = 0x0b14, [0x09f6] = 0x0b15, [0x09f7] = 0x0b16,
  [0x09f8] = 0x0b17, [0x09f9] = 0x0b18, [0x09fa] = 0x0b19, [0x09fb] = 0x0b1a,
  [0x09fc] = 0x0b1b, [0x09fd] = 0x0b1c, [0x09fe] = 0x0b1d, [0x09ff] = 0x0b1e,
  [0x0a00] = 0x0b1f, [0x0a01] = 0x0b20, [0x0a02] = 0x0b21, [0x0a03] = 0x0b22,
  [0x0a04] = 0x0b23, [0x0a05] = 0x0b24, [0x0a06] = 0x0b25, [0x0a07] = 0x0b26,
  [0x0a08] = 0x0b27, [0x0a09] = 0x0b28, [0x0a0b] = 0x0b2a,
  [0x0a0c] = 0x0b2b, [0x0a0d] = 0x0b2c, [0x0a0e] = 0x0b2d, [0x0a0f] = 0x0b2e,
  [0x0a10] = 0x0b2f, [0x0a11] = 0x0b30, [0x0a13] = 0x0b32,
  [0x0a14] = 0x0b33, [0x0a17] = 0x0b36,
  [0x0a18] = 0x0b37, [0x0a19] = 0x0b38, [0x0a1a] = 0x0b39,
  [0x0a1d] = 0x0b3c, [0x0a1e] = 0x0b3d, [0x0a1f] = 0x0b3e,
  [0x0a20] = 0x0b3f, [0x0a21] = 0x0b40, [0x0a22] = 0x0b41, [0x0a23] = 0x0b42,
  [0x0a24] = 0x0b43, [0x0a28] = 0x0b47, [0x0a29] = 0x0b48,
  [0x0a2c] = 0x0b4b, [0x0a2d] = 0x0b4c, [0x0a2e] = 0x0b4d, [0x0a37] = 0x0b56,
  [0x0a38] = 0x0b57, [0x0a3d] = 0x0b5c, [0x0a3e] = 0x0b5d,
  [0x0a40] = 0x0b5f, [0x0a41] = 0x0b60, [0x0a42] = 0x0b61, [0x0a47] = 0x0b66,
  [0x0a48] = 0x0b67, [0x0a49] = 0x0b68, [0x0a4a] = 0x0b69, [0x0a4b] = 0x0b6a,
  [0x0a4c] = 0x0b6b, [0x0a4d] = 0x0b6c, [0x0a4e] = 0x0b6d, [0x0a4f] = 0x0b6e,
  [0x0a50] = 0x0b6f, [0x0a51] = 0x0b70, [0x0a63] = 0x0b82,
  [0x0a64] = 0x0b83, [0x0a66] = 0x0b85, [0x0a67] = 0x0b86,
  [0x0a68] = 0x0b87, [0x0a69] = 0x0b88, [0x0a6a] = 0x0b89, [0x0a6b] = 0x0b8a,
  [0x0a6f] = 0x0b8e,
  [0x0a70] = 0x0b8f, [0x0a71] = 0x0b90, [0x0a73] = 0x0b92,
  [0x0a74] = 0x0b93, [0x0a75] = 0x0b94, [0x0a76] = 0x0b95,
  [0x0a7a] = 0x0b99, [0x0a7b] = 0x0b9a, [0x0a7d] = 0x0b9c, [0x0a7f] = 0x0b9e,
  [0x0a80] = 0x0b9f, [0x0a84] = 0x0ba3, [0x0a85] = 0x0ba4,
  [0x0a89] = 0x0ba8, [0x0a8a] = 0x0ba9, [0x0a8b] = 0x0baa, [0x0a8f] = 0x0bae,
  [0x0a90] = 0x0baf, [0x0a91] = 0x0bb0, [0x0a92] = 0x0bb1, [0x0a93] = 0x0bb2,
  [0x0a94] = 0x0bb3, [0x0a95] = 0x0bb4, [0x0a96] = 0x0bb5,
  [0x0a98] = 0x0bb7, [0x0a99] = 0x0bb8, [0x0a9a] = 0x0bb9, [0x0a9f] = 0x0bbe,
  [0x0aa0] = 0x0bbf, [0x0aa1] = 0x0bc0, [0x0aa2] = 0x0bc1, [0x0aa3] = 0x0bc2,
  [0x0aa7] = 0x0bc6, [0x0aa8] = 0x0bc7, [0x0aa9] = 0x0bc8, [0x0aab] = 0x0bca,
  [0x0aac] = 0x0bcb, [0x0aad] = 0x0bcc, [0x0aae] = 0x0bcd,
  [0x0ab8] = 0x0bd7,
  [0x0ac8] = 0x0be7, [0x0ac9] = 0x0be8, [0x0aca] = 0x0be9, [0x0acb] = 0x0bea,
  [0x0acc] = 0x0beb, [0x0acd] = 0x0bec, [0x0ace] = 0x0bed, [0x0acf] = 0x0bee,
  [0x0ad0] = 0x0bef, [0x0ad1] = 0x0bf0, [0x0ad2] = 0x0bf1, [0x0ad3] = 0x0bf2,
  [0x0ae2] = 0x0c01, [0x0ae3] = 0x0c02,
  [0x0ae4] = 0x0c03, [0x0ae6] = 0x0c05, [0x0ae7] = 0x0c06,
  [0x0ae8] = 0x0c07, [0x0ae9] = 0x0c08, [0x0aea] = 0x0c09, [0x0aeb] = 0x0c0a,
  [0x0aec] = 0x0c0b, [0x0aed] = 0x0c0c, [0x0aef] = 0x0c0e,
  [0x0af0] = 0x0c0f, [0x0af1] = 0x0c10, [0x0af3] = 0x0c12,
  [0x0af4] = 0x0c13, [0x0af5] = 0x0c14, [0x0af6] = 0x0c15, [0x0af7] = 0x0c16,
  [0x0af8] = 0x0c17, [0x0af9] = 0x0c18, [0x0afa] = 0x0c19, [0x0afb] = 0x0c1a,
  [0x0afc] = 0x0c1b, [0x0afd] = 0x0c1c, [0x0afe] = 0x0c1d, [0x0aff] = 0x0c1e,
  [0x0b00] = 0x0c1f, [0x0b01] = 0x0c20, [0x0b02] = 0x0c21, [0x0b03] = 0x0c22,
  [0x0b04] = 0x0c23, [0x0b05] = 0x0c24, [0x0b06] = 0x0c25, [0x0b07] = 0x0c26,
  [0x0b08] = 0x0c27, [0x0b09] = 0x0c28, [0x0b0b] = 0x0c2a,
  [0x0b0c] = 0x0c2b, [0x0b0d] = 0x0c2c, [0x0b0e] = 0x0c2d, [0x0b0f] = 0x0c2e,
  [0x0b10] = 0x0c2f, [0x0b11] = 0x0c30, [0x0b12] = 0x0c31, [0x0b13] = 0x0c32,
  [0x0b14] = 0x0c33, [0x0b16] = 0x0c35, [0x0b17] = 0x0c36,
  [0x0b18] = 0x0c37, [0x0b19] = 0x0c38, [0x0b1a] = 0x0c39, [0x0b1f] = 0x0c3e,
  [0x0b20] = 0x0c3f, [0x0b21] = 0x0c40, [0x0b22] = 0x0c41, [0x0b23] = 0x0c42,
  [0x0b24] = 0x0c43, [0x0b25] = 0x0c44, [0x0b27] = 0x0c46,
  [0x0b28] = 0x0c47, [0x0b29] = 0x0c48, [0x0b2b] = 0x0c4a,
  [0x0b2c] = 0x0c4b, [0x0b2d] = 0x0c4c, [0x0b2e] = 0x0c4d,
  [0x0b36] = 0x0c55, [0x0b37] = 0x0c56,
  [0x0b41] = 0x0c60, [0x0b42] = 0x0c61, [0x0b47] = 0x0c66,
  [0x0b48] = 0x0c67, [0x0b49] = 0x0c68, [0x0b4a] = 0x0c69, [0x0b4b] = 0x0c6a,
  [0x0b4c] = 0x0c6b, [0x0b4d] = 0x0c6c, [0x0b4e] = 0x0c6d, [0x0b4f] = 0x0c6e,
  [0x0b50] = 0x0c6f, [0x0b63] = 0x0c82,
  [0x0b64] = 0x0c83, [0x0b66] = 0x0c85, [0x0b67] = 0x0c86,
  [0x0b68] = 0x0c87, [0x0b69] = 0x0c88, [0x0b6a] = 0x0c89, [0x0b6b] = 0x0c8a,
  [0x0b6c] = 0x0c8b, [0x0b6d] = 0x0c8c, [0x0b6f] = 0x0c8e,
  [0x0b70] = 0x0c8f, [0x0b71] = 0x0c90, [0x0b73] = 0x0c92,
  [0x0b74] = 0x0c93, [0x0b75] = 0x0c94, [0x0b76] = 0x0c95, [0x0b77] = 0x0c96,
  [0x0b78] = 0x0c97, [0x0b79] = 0x0c98, [0x0b7a] = 0x0c99, [0x0b7b] = 0x0c9a,
  [0x0b7c] = 0x0c9b, [0x0b7d] = 0x0c9c, [0x0b7e] = 0x0c9d, [0x0b7f] = 0x0c9e,
  [0x0b80] = 0x0c9f, [0x0b81] = 0x0ca0, [0x0b82] = 0x0ca1, [0x0b83] = 0x0ca2,
  [0x0b84] = 0x0ca3, [0x0b85] = 0x0ca4, [0x0b86] = 0x0ca5, [0x0b87] = 0x0ca6,
  [0x0b88] = 0x0ca7, [0x0b89] = 0x0ca8, [0x0b8b] = 0x0caa,
  [0x0b8c] = 0x0cab, [0x0b8d] = 0x0cac, [0x0b8e] = 0x0cad, [0x0b8f] = 0x0cae,
  [0x0b90] = 0x0caf, [0x0b91] = 0x0cb0, [0x0b92] = 0x0cb1, [0x0b93] = 0x0cb2,
  [0x0b94] = 0x0cb3, [0x0b96] = 0x0cb5, [0x0b97] = 0x0cb6,
  [0x0b98] = 0x0cb7, [0x0b99] = 0x0cb8, [0x0b9a] = 0x0cb9, [0x0b9f] = 0x0cbe,
  [0x0ba0] = 0x0cbf, [0x0ba1] = 0x0cc0, [0x0ba2] = 0x0cc1, [0x0ba3] = 0x0cc2,
  [0x0ba4] = 0x0cc3, [0x0ba5] = 0x0cc4, [0x0ba7] = 0x0cc6,
  [0x0ba8] = 0x0cc7, [0x0ba9] = 0x0cc8, [0x0bab] = 0x0cca,
  [0x0bac] = 0x0ccb, [0x0bad] = 0x0ccc, [0x0bae] = 0x0ccd,
  [0x0bb6] = 0x0cd5, [0x0bb7] = 0x0cd6, [0x0bbf] = 0x0cde,
  [0x0bc1] = 0x0ce0, [0x0bc2] = 0x0ce1, [0x0bc7] = 0x0ce6,
  [0x0bc8] = 0x0ce7, [0x0bc9] = 0x0ce8, [0x0bca] = 0x0ce9, [0x0bcb] = 0x0cea,
  [0x0bcc] = 0x0ceb, [0x0bcd] = 0x0cec, [0x0bce] = 0x0ced, [0x0bcf] = 0x0cee,
  [0x0bd0] = 0x0cef, [0x0be3] = 0x0d02,
  [0x0be4] = 0x0d03, [0x0be6] = 0x0d05, [0x0be7] = 0x0d06,
  [0x0be8] = 0x0d07, [0x0be9] = 0x0d08, [0x0bea] = 0x0d09, [0x0beb] = 0x0d0a,
  [0x0bec] = 0x0d0b, [0x0bed] = 0x0d0c, [0x0bef] = 0x0d0e,
  [0x0bf0] = 0x0d0f, [0x0bf1] = 0x0d10, [0x0bf3] = 0x0d12,
  [0x0bf4] = 0x0d13, [0x0bf5] = 0x0d14, [0x0bf6] = 0x0d15, [0x0bf7] = 0x0d16,
  [0x0bf8] = 0x0d17, [0x0bf9] = 0x0d18, [0x0bfa] = 0x0d19, [0x0bfb] = 0x0d1a,
  [0x0bfc] = 0x0d1b, [0x0bfd] = 0x0d1c, [0x0bfe] = 0x0d1d, [0x0bff] = 0x0d1e,
  [0x0c00] = 0x0d1f, [0x0c01] = 0x0d20, [0x0c02] = 0x0d21, [0x0c03] = 0x0d22,
  [0x0c04] = 0x0d23, [0x0c05] = 0x0d24, [0x0c06] = 0x0d25, [0x0c07] = 0x0d26,
  [0x0c08] = 0x0d27, [0x0c09] = 0x0d28, [0x0c0b] = 0x0d2a,
  [0x0c0c] = 0x0d2b, [0x0c0d] = 0x0d2c, [0x0c0e] = 0x0d2d, [0x0c0f] = 0x0d2e,
  [0x0c10] = 0x0d2f, [0x0c11] = 0x0d30, [0x0c12] = 0x0d31, [0x0c13] = 0x0d32,
  [0x0c14] = 0x0d33, [0x0c15] = 0x0d34, [0x0c16] = 0x0d35, [0x0c17] = 0x0d36,
  [0x0c18] = 0x0d37, [0x0c19] = 0x0d38, [0x0c1a] = 0x0d39, [0x0c1f] = 0x0d3e,
  [0x0c20] = 0x0d3f, [0x0c21] = 0x0d40, [0x0c22] = 0x0d41, [0x0c23] = 0x0d42,
  [0x0c24] = 0x0d43, [0x0c27] = 0x0d46,
  [0x0c28] = 0x0d47, [0x0c29] = 0x0d48, [0x0c2b] = 0x0d4a,
  [0x0c2c] = 0x0d4b, [0x0c2d] = 0x0d4c, [0x0c2e] = 0x0d4d,
  [0x0c38] = 0x0d57, [0x0c41] = 0x0d60, [0x0c42] = 0x0d61, [0x0c47] = 0x0d66,
  [0x0c48] = 0x0d67, [0x0c49] = 0x0d68, [0x0c4a] = 0x0d69, [0x0c4b] = 0x0d6a,
  [0x0c4c] = 0x0d6b, [0x0c4d] = 0x0d6c, [0x0c4e] = 0x0d6d, [0x0c4f] = 0x0d6e,
  [0x0c50] = 0x0d6f, [0x0c63] = 0x0d82,
  [0x0c64] = 0x0d83, [0x0c66] = 0x0d85, [0x0c67] = 0x0d86,
  [0x0c68] = 0x0d87, [0x0c69] = 0x0d88, [0x0c6a] = 0x0d89, [0x0c6b] = 0x0d8a,
  [0x0c6c] = 0x0d8b, [0x0c6d] = 0x0d8c, [0x0c6e] = 0x0d8d, [0x0c6f] = 0x0d8e,
  [0x0c70] = 0x0d8f, [0x0c71] = 0x0d90, [0x0c72] = 0x0d91, [0x0c73] = 0x0d92,
  [0x0c74] = 0x0d93, [0x0c75] = 0x0d94, [0x0c76] = 0x0d95, [0x0c77] = 0x0d96,
  [0x0c7b] = 0x0d9a,
  [0x0c7c] = 0x0d9b, [0x0c7d] = 0x0d9c, [0x0c7e] = 0x0d9d, [0x0c7f] = 0x0d9e,
  [0x0c80] = 0x0d9f, [0x0c81] = 0x0da0, [0x0c82] = 0x0da1, [0x0c83] = 0x0da2,
  [0x0c84] = 0x0da3, [0x0c85] = 0x0da4, [0x0c86] = 0x0da5, [0x0c87] = 0x0da6,
  [0x0c88] = 0x0da7, [0x0c89] = 0x0da8, [0x0c8a] = 0x0da9, [0x0c8b] = 0x0daa,
  [0x0c8c] = 0x0dab, [0x0c8d] = 0x0dac, [0x0c8e] = 0x0dad, [0x0c8f] = 0x0dae,
  [0x0c90] = 0x0daf, [0x0c91] = 0x0db0, [0x0c92] = 0x0db1,
  [0x0c94] = 0x0db3, [0x0c95] = 0x0db4, [0x0c96] = 0x0db5, [0x0c97] = 0x0db6,
  [0x0c98] = 0x0db7, [0x0c99] = 0x0db8, [0x0c9a] = 0x0db9, [0x0c9b] = 0x0dba,
  [0x0c9c] = 0x0dbb, [0x0c9e] = 0x0dbd,
  [0x0ca1] = 0x0dc0, [0x0ca2] = 0x0dc1, [0x0ca3] = 0x0dc2,
  [0x0ca4] = 0x0dc3, [0x0ca5] = 0x0dc4, [0x0ca6] = 0x0dc5, [0x0ca7] = 0x0dc6,
  [0x0cab] = 0x0dca,
  [0x0cb0] = 0x0dcf, [0x0cb1] = 0x0dd0, [0x0cb2] = 0x0dd1, [0x0cb3] = 0x0dd2,
  [0x0cb4] = 0x0dd3, [0x0cb5] = 0x0dd4, [0x0cb7] = 0x0dd6,
  [0x0cb9] = 0x0dd8, [0x0cba] = 0x0dd9, [0x0cbb] = 0x0dda,
  [0x0cbc] = 0x0ddb, [0x0cbd] = 0x0ddc, [0x0cbe] = 0x0ddd, [0x0cbf] = 0x0dde,
  [0x0cc0] = 0x0ddf, [0x0cd3] = 0x0df2, [0x0cd4] = 0x0df3, [0x0cd5] = 0x0df4,
  [0x0ce2] = 0x0e01, [0x0ce3] = 0x0e02,
  [0x0ce4] = 0x0e03, [0x0ce5] = 0x0e04, [0x0ce6] = 0x0e05, [0x0ce7] = 0x0e06,
  [0x0ce8] = 0x0e07, [0x0ce9] = 0x0e08, [0x0cea] = 0x0e09, [0x0ceb] = 0x0e0a,
  [0x0cec] = 0x0e0b, [0x0ced] = 0x0e0c, [0x0cee] = 0x0e0d, [0x0cef] = 0x0e0e,
  [0x0cf0] = 0x0e0f, [0x0cf1] = 0x0e10, [0x0cf2] = 0x0e11, [0x0cf3] = 0x0e12,
  [0x0cf4] = 0x0e13, [0x0cf5] = 0x0e14, [0x0cf6] = 0x0e15, [0x0cf7] = 0x0e16,
  [0x0cf8] = 0x0e17, [0x0cf9] = 0x0e18, [0x0cfa] = 0x0e19, [0x0cfb] = 0x0e1a,
  [0x0cfc] = 0x0e1b, [0x0cfd] = 0x0e1c, [0x0cfe] = 0x0e1d, [0x0cff] = 0x0e1e,
  [0x0d00] = 0x0e1f, [0x0d01] = 0x0e20, [0x0d02] = 0x0e21, [0x0d03] = 0x0e22,
  [0x0d04] = 0x0e23, [0x0d05] = 0x0e24, [0x0d06] = 0x0e25, [0x0d07] = 0x0e26,
  [0x0d08] = 0x0e27, [0x0d09] = 0x0e28, [0x0d0a] = 0x0e29, [0x0d0b] = 0x0e2a,
  [0x0d0c] = 0x0e2b, [0x0d0d] = 0x0e2c, [0x0d0e] = 0x0e2d, [0x0d0f] = 0x0e2e,
  [0x0d10] = 0x0e2f, [0x0d11] = 0x0e30, [0x0d12] = 0x0e31, [0x0d13] = 0x0e32,
  [0x0d14] = 0x0e33, [0x0d15] = 0x0e34, [0x0d16] = 0x0e35, [0x0d17] = 0x0e36,
  [0x0d18] = 0x0e37, [0x0d19] = 0x0e38, [0x0d1a] = 0x0e39, [0x0d1b] = 0x0e3a,
  [0x0d20] = 0x0e3f, [0x0d21] = 0x0e40, [0x0d22] = 0x0e41, [0x0d23] = 0x0e42,
  [0x0d24] = 0x0e43, [0x0d25] = 0x0e44, [0x0d26] = 0x0e45, [0x0d27] = 0x0e46,
  [0x0d28] = 0x0e47, [0x0d29] = 0x0e48, [0x0d2a] = 0x0e49, [0x0d2b] = 0x0e4a,
  [0x0d2c] = 0x0e4b, [0x0d2d] = 0x0e4c, [0x0d2e] = 0x0e4d, [0x0d2f] = 0x0e4e,
  [0x0d30] = 0x0e4f, [0x0d31] = 0x0e50, [0x0d32] = 0x0e51, [0x0d33] = 0x0e52,
  [0x0d34] = 0x0e53, [0x0d35] = 0x0e54, [0x0d36] = 0x0e55, [0x0d37] = 0x0e56,
  [0x0d38] = 0x0e57, [0x0d39] = 0x0e58, [0x0d3a] = 0x0e59, [0x0d3b] = 0x0e5a,
  [0x0d3c] = 0x0e5b, [0x0d62] = 0x0e81, [0x0d63] = 0x0e82, [0x0d65] = 0x0e84,
  [0x0d68] = 0x0e87, [0x0d69] = 0x0e88, [0x0d6b] = 0x0e8a, [0x0d6e] = 0x0e8d,
  [0x0d75] = 0x0e94, [0x0d76] = 0x0e95, [0x0d77] = 0x0e96,
  [0x0d78] = 0x0e97, [0x0d7a] = 0x0e99, [0x0d7b] = 0x0e9a,
  [0x0d7c] = 0x0e9b, [0x0d7d] = 0x0e9c, [0x0d7e] = 0x0e9d, [0x0d7f] = 0x0e9e,
  [0x0d80] = 0x0e9f, [0x0d82] = 0x0ea1, [0x0d83] = 0x0ea2,
  [0x0d84] = 0x0ea3, [0x0d86] = 0x0ea5,
  [0x0d88] = 0x0ea7, [0x0d8b] = 0x0eaa,
  [0x0d8c] = 0x0eab, [0x0d8e] = 0x0ead, [0x0d8f] = 0x0eae,
  [0x0d90] = 0x0eaf, [0x0d91] = 0x0eb0, [0x0d92] = 0x0eb1, [0x0d93] = 0x0eb2,
  [0x0d94] = 0x0eb3, [0x0d95] = 0x0eb4, [0x0d96] = 0x0eb5, [0x0d97] = 0x0eb6,
  [0x0d98] = 0x0eb7, [0x0d99] = 0x0eb8, [0x0d9a] = 0x0eb9,
  [0x0d9c] = 0x0ebb, [0x0d9d] = 0x0ebc, [0x0d9e] = 0x0ebd,
  [0x0da1] = 0x0ec0, [0x0da2] = 0x0ec1, [0x0da3] = 0x0ec2,
  [0x0da4] = 0x0ec3, [0x0da5] = 0x0ec4, [0x0da7] = 0x0ec6,
  [0x0da9] = 0x0ec8, [0x0daa] = 0x0ec9, [0x0dab] = 0x0eca,
  [0x0dac] = 0x0ecb, [0x0dad] = 0x0ecc, [0x0dae] = 0x0ecd,
  [0x0db1] = 0x0ed0, [0x0db2] = 0x0ed1, [0x0db3] = 0x0ed2,
  [0x0db4] = 0x0ed3, [0x0db5] = 0x0ed4, [0x0db6] = 0x0ed5, [0x0db7] = 0x0ed6,
  [0x0db8] = 0x0ed7, [0x0db9] = 0x0ed8, [0x0dba] = 0x0ed9,
  [0x0dbd] = 0x0edc, [0x0dbe] = 0x0edd,
  [0x0de1] = 0x0f00, [0x0de2] = 0x0f01, [0x0de3] = 0x0f02,
  [0x0de4] = 0x0f03, [0x0de5] = 0x0f04, [0x0de6] = 0x0f05, [0x0de7] = 0x0f06,
  [0x0de8] = 0x0f07, [0x0de9] = 0x0f08, [0x0dea] = 0x0f09, [0x0deb] = 0x0f0a,
  [0x0dec] = 0x0f0b, [0x0ded] = 0x0f0c, [0x0dee] = 0x0f0d, [0x0def] = 0x0f0e,
  [0x0df0] = 0x0f0f, [0x0df1] = 0x0f10, [0x0df2] = 0x0f11, [0x0df3] = 0x0f12,
  [0x0df4] = 0x0f13, [0x0df5] = 0x0f14, [0x0df6] = 0x0f15, [0x0df7] = 0x0f16,
  [0x0df8] = 0x0f17, [0x0df9] = 0x0f18, [0x0dfa] = 0x0f19, [0x0dfb] = 0x0f1a,
  [0x0dfc] = 0x0f1b, [0x0dfd] = 0x0f1c, [0x0dfe] = 0x0f1d, [0x0dff] = 0x0f1e,
  [0x0e00] = 0x0f1f, [0x0e01] = 0x0f20, [0x0e02] = 0x0f21, [0x0e03] = 0x0f22,
  [0x0e04] = 0x0f23, [0x0e05] = 0x0f24, [0x0e06] = 0x0f25, [0x0e07] = 0x0f26,
  [0x0e08] = 0x0f27, [0x0e09] = 0x0f28, [0x0e0a] = 0x0f29, [0x0e0b] = 0x0f2a,
  [0x0e0c] = 0x0f2b, [0x0e0d] = 0x0f2c, [0x0e0e] = 0x0f2d, [0x0e0f] = 0x0f2e,
  [0x0e10] = 0x0f2f, [0x0e11] = 0x0f30, [0x0e12] = 0x0f31, [0x0e13] = 0x0f32,
  [0x0e14] = 0x0f33, [0x0e15] = 0x0f34, [0x0e16] = 0x0f35, [0x0e17] = 0x0f36,
  [0x0e18] = 0x0f37, [0x0e19] = 0x0f38, [0x0e1a] = 0x0f39, [0x0e1b] = 0x0f3a,
  [0x0e1c] = 0x0f3b, [0x0e1d] = 0x0f3c, [0x0e1e] = 0x0f3d, [0x0e1f] = 0x0f3e,
  [0x0e20] = 0x0f3f, [0x0e21] = 0x0f40, [0x0e22] = 0x0f41, [0x0e23] = 0x0f42,
  [0x0e24] = 0x0f43, [0x0e25] = 0x0f44, [0x0e26] = 0x0f45, [0x0e27] = 0x0f46,
  [0x0e28] = 0x0f47, [0x0e2a] = 0x0f49, [0x0e2b] = 0x0f4a,
  [0x0e2c] = 0x0f4b, [0x0e2d] = 0x0f4c, [0x0e2e] = 0x0f4d, [0x0e2f] = 0x0f4e,
  [0x0e30] = 0x0f4f, [0x0e31] = 0x0f50, [0x0e32] = 0x0f51, [0x0e33] = 0x0f52,
  [0x0e34] = 0x0f53, [0x0e35] = 0x0f54, [0x0e36] = 0x0f55, [0x0e37] = 0x0f56,
  [0x0e38] = 0x0f57, [0x0e39] = 0x0f58, [0x0e3a] = 0x0f59, [0x0e3b] = 0x0f5a,
  [0x0e3c] = 0x0f5b, [0x0e3d] = 0x0f5c, [0x0e3e] = 0x0f5d, [0x0e3f] = 0x0f5e,
  [0x0e40] = 0x0f5f, [0x0e41] = 0x0f60, [0x0e42] = 0x0f61, [0x0e43] = 0x0f62,
  [0x0e44] = 0x0f63, [0x0e45] = 0x0f64, [0x0e46] = 0x0f65, [0x0e47] = 0x0f66,
  [0x0e48] = 0x0f67, [0x0e49] = 0x0f68, [0x0e4a] = 0x0f69, [0x0e4b] = 0x0f6a,
  [0x0e52] = 0x0f71, [0x0e53] = 0x0f72,
  [0x0e54] = 0x0f73, [0x0e55] = 0x0f74, [0x0e56] = 0x0f75, [0x0e57] = 0x0f76,
  [0x0e58] = 0x0f77, [0x0e59] = 0x0f78, [0x0e5a] = 0x0f79, [0x0e5b] = 0x0f7a,
  [0x0e5c] = 0x0f7b, [0x0e5d] = 0x0f7c, [0x0e5e] = 0x0f7d, [0x0e5f] = 0x0f7e,
  [0x0e60] = 0x0f7f, [0x0e61] = 0x0f80, [0x0e62] = 0x0f81, [0x0e63] = 0x0f82,
  [0x0e64] = 0x0f83, [0x0e65] = 0x0f84, [0x0e66] = 0x0f85, [0x0e67] = 0x0f86,
  [0x0e68] = 0x0f87, [0x0e69] = 0x0f88, [0x0e6a] = 0x0f89, [0x0e6b] = 0x0f8a,
  [0x0e6c] = 0x0f8b, [0x0e71] = 0x0f90, [0x0e72] = 0x0f91, [0x0e73] = 0x0f92,
  [0x0e74] = 0x0f93, [0x0e75] = 0x0f94, [0x0e76] = 0x0f95, [0x0e77] = 0x0f96,
  [0x0e78] = 0x0f97, [0x0e7a] = 0x0f99, [0x0e7b] = 0x0f9a,
  [0x0e7c] = 0x0f9b, [0x0e7d] = 0x0f9c, [0x0e7e] = 0x0f9d, [0x0e7f] = 0x0f9e,
  [0x0e80] = 0x0f9f, [0x0e81] = 0x0fa0, [0x0e82] = 0x0fa1, [0x0e83] = 0x0fa2,
  [0x0e84] = 0x0fa3, [0x0e85] = 0x0fa4, [0x0e86] = 0x0fa5, [0x0e87] = 0x0fa6,
  [0x0e88] = 0x0fa7, [0x0e89] = 0x0fa8, [0x0e8a] = 0x0fa9, [0x0e8b] = 0x0faa,
  [0x0e8c] = 0x0fab, [0x0e8d] = 0x0fac, [0x0e8e] = 0x0fad, [0x0e8f] = 0x0fae,
  [0x0e90] = 0x0faf, [0x0e91] = 0x0fb0, [0x0e92] = 0x0fb1, [0x0e93] = 0x0fb2,
  [0x0e94] = 0x0fb3, [0x0e95] = 0x0fb4, [0x0e96] = 0x0fb5, [0x0e97] = 0x0fb6,
  [0x0e98] = 0x0fb7, [0x0e99] = 0x0fb8, [0x0e9a] = 0x0fb9, [0x0e9b] = 0x0fba,
  [0x0e9c] = 0x0fbb, [0x0e9d] = 0x0fbc, [0x0e9f] = 0x0fbe,
  [0x0ea0] = 0x0fbf, [0x0ea1] = 0x0fc0, [0x0ea2] = 0x0fc1, [0x0ea3] = 0x0fc2,
  [0x0ea4] = 0x0fc3, [0x0ea5] = 0x0fc4, [0x0ea6] = 0x0fc5, [0x0ea7] = 0x0fc6,
  [0x0ea8] = 0x0fc7, [0x0ea9] = 0x0fc8, [0x0eaa] = 0x0fc9, [0x0eab] = 0x0fca,
  [0x0eac] = 0x0fcb, [0x0ead] = 0x0fcc, [0x0eb0] = 0x0fcf,
  [0x0ee1] = 0x1000, [0x0ee2] = 0x1001, [0x0ee3] = 0x1002,
  [0x0ee4] = 0x1003, [0x0ee5] = 0x1004, [0x0ee6] = 0x1005, [0x0ee7] = 0x1006,
  [0x0ee8] = 0x1007, [0x0ee9] = 0x1008, [0x0eea] = 0x1009, [0x0eeb] = 0x100a,
  [0x0eec] = 0x100b, [0x0eed] = 0x100c, [0x0eee] = 0x100d, [0x0eef] = 0x100e,
  [0x0ef0] = 0x100f, [0x0ef1] = 0x1010, [0x0ef2] = 0x1011, [0x0ef3] = 0x1012,
  [0x0ef4] = 0x1013, [0x0ef5] = 0x1014, [0x0ef6] = 0x1015, [0x0ef7] = 0x1016,
  [0x0ef8] = 0x1017, [0x0ef9] = 0x1018, [0x0efa] = 0x1019, [0x0efb] = 0x101a,
  [0x0efc] = 0x101b, [0x0efd] = 0x101c, [0x0efe] = 0x101d, [0x0eff] = 0x101e,
  [0x0f00] = 0x101f, [0x0f01] = 0x1020, [0x0f02] = 0x1021,
  [0x0f04] = 0x1023, [0x0f05] = 0x1024, [0x0f06] = 0x1025, [0x0f07] = 0x1026,
  [0x0f08] = 0x1027, [0x0f0a] = 0x1029, [0x0f0b] = 0x102a,
  [0x0f0d] = 0x102c, [0x0f0e] = 0x102d, [0x0f0f] = 0x102e,
  [0x0f10] = 0x102f, [0x0f11] = 0x1030, [0x0f12] = 0x1031, [0x0f13] = 0x1032,
  [0x0f17] = 0x1036,
  [0x0f18] = 0x1037, [0x0f19] = 0x1038, [0x0f1a] = 0x1039,
  [0x0f21] = 0x1040, [0x0f22] = 0x1041, [0x0f23] = 0x1042,
  [0x0f24] = 0x1043, [0x0f25] = 0x1044, [0x0f26] = 0x1045, [0x0f27] = 0x1046,
  [0x0f28] = 0x1047, [0x0f29] = 0x1048, [0x0f2a] = 0x1049, [0x0f2b] = 0x104a,
  [0x0f2c] = 0x104b, [0x0f2d] = 0x104c, [0x0f2e] = 0x104d, [0x0f2f] = 0x104e,
  [0x0f30] = 0x104f, [0x0f31] = 0x1050, [0x0f32] = 0x1051, [0x0f33] = 0x1052,
  [0x0f34] = 0x1053, [0x0f35] = 0x1054, [0x0f36] = 0x1055, [0x0f37] = 0x1056,
  [0x0f38] = 0x1057, [0x0f39] = 0x1058, [0x0f3a] = 0x1059,
  [0x0f81] = 0x10a0, [0x0f82] = 0x10a1, [0x0f83] = 0x10a2,
  [0x0f84] = 0x10a3, [0x0f85] = 0x10a4, [0x0f86] = 0x10a5, [0x0f87] = 0x10a6,
  [0x0f88] = 0x10a7, [0x0f89] = 0x10a8, [0x0f8a] = 0x10a9, [0x0f8b] = 0x10aa,
  [0x0f8c] = 0x10ab, [0x0f8d] = 0x10ac, [0x0f8e] = 0x10ad, [0x0f8f] = 0x10ae,
  [0x0f90] = 0x10af, [0x0f91] = 0x10b0, [0x0f92] = 0x10b1, [0x0f93] = 0x10b2,
  [0x0f94] = 0x10b3, [0x0f95] = 0x10b4, [0x0f96] = 0x10b5, [0x0f97] = 0x10b6,
  [0x0f98] = 0x10b7, [0x0f99] = 0x10b8, [0x0f9a] = 0x10b9, [0x0f9b] = 0x10ba,
  [0x0f9c] = 0x10bb, [0x0f9d] = 0x10bc, [0x0f9e] = 0x10bd, [0x0f9f] = 0x10be,
  [0x0fa0] = 0x10bf, [0x0fa1] = 0x10c0, [0x0fa2] = 0x10c1, [0x0fa3] = 0x10c2,
  [0x0fa4] = 0x10c3, [0x0fa5] = 0x10c4, [0x0fa6] = 0x10c5,
  [0x0fb1] = 0x10d0, [0x0fb2] = 0x10d1, [0x0fb3] = 0x10d2,
  [0x0fb4] = 0x10d3, [0x0fb5] = 0x10d4, [0x0fb6] = 0x10d5, [0x0fb7] = 0x10d6,
  [0x0fb8] = 0x10d7, [0x0fb9] = 0x10d8, [0x0fba] = 0x10d9, [0x0fbb] = 0x10da,
  [0x0fbc] = 0x10db, [0x0fbd] = 0x10dc, [0x0fbe] = 0x10dd, [0x0fbf] = 0x10de,
  [0x0fc0] = 0x10df, [0x0fc1] = 0x10e0, [0x0fc2] = 0x10e1, [0x0fc3] = 0x10e2,
  [0x0fc4] = 0x10e3, [0x0fc5] = 0x10e4, [0x0fc6] = 0x10e5, [0x0fc7] = 0x10e6,
  [0x0fc8] = 0x10e7, [0x0fc9] = 0x10e8, [0x0fca] = 0x10e9, [0x0fcb] = 0x10ea,
  [0x0fcc] = 0x10eb, [0x0fcd] = 0x10ec, [0x0fce] = 0x10ed, [0x0fcf] = 0x10ee,
  [0x0fd0] = 0x10ef, [0x0fd1] = 0x10f0, [0x0fd2] = 0x10f1, [0x0fd3] = 0x10f2,
  [0x0fd4] = 0x10f3, [0x0fd5] = 0x10f4, [0x0fd6] = 0x10f5, [0x0fd7] = 0x10f6,
  [0x0fdc] = 0x10fb, [0x0fe1] = 0x1100, [0x0fe2] = 0x1101, [0x0fe3] = 0x1102,
  [0x0fe4] = 0x1103, [0x0fe5] = 0x1104, [0x0fe6] = 0x1105, [0x0fe7] = 0x1106,
  [0x0fe8] = 0x1107, [0x0fe9] = 0x1108, [0x0fea] = 0x1109, [0x0feb] = 0x110a,
  [0x0fec] = 0x110b, [0x0fed] = 0x110c, [0x0fee] = 0x110d, [0x0fef] = 0x110e,
  [0x0ff0] = 0x110f, [0x0ff1] = 0x1110, [0x0ff2] = 0x1111, [0x0ff3] = 0x1112,
  [0x0ff4] = 0x1113, [0x0ff5] = 0x1114, [0x0ff6] = 0x1115, [0x0ff7] = 0x1116,
  [0x0ff8] = 0x1117, [0x0ff9] = 0x1118, [0x0ffa] = 0x1119, [0x0ffb] = 0x111a,
  [0x0ffc] = 0x111b, [0x0ffd] = 0x111c, [0x0ffe] = 0x111d, [0x0fff] = 0x111e,
  [0x1000] = 0x111f, [0x1001] = 0x1120, [0x1002] = 0x1121, [0x1003] = 0x1122,
  [0x1004] = 0x1123, [0x1005] = 0x1124, [0x1006] = 0x1125, [0x1007] = 0x1126,
  [0x1008] = 0x1127, [0x1009] = 0x1128, [0x100a] = 0x1129, [0x100b] = 0x112a,
  [0x100c] = 0x112b, [0x100d] = 0x112c, [0x100e] = 0x112d, [0x100f] = 0x112e,
  [0x1010] = 0x112f, [0x1011] = 0x1130, [0x1012] = 0x1131, [0x1013] = 0x1132,
  [0x1014] = 0x1133, [0x1015] = 0x1134, [0x1016] = 0x1135, [0x1017] = 0x1136,
  [0x1018] = 0x1137, [0x1019] = 0x1138, [0x101a] = 0x1139, [0x101b] = 0x113a,
  [0x101c] = 0x113b, [0x101d] = 0x113c, [0x101e] = 0x113d, [0x101f] = 0x113e,
  [0x1020] = 0x113f, [0x1021] = 0x1140, [0x1022] = 0x1141, [0x1023] = 0x1142,
  [0x1024] = 0x1143, [0x1025] = 0x1144, [0x1026] = 0x1145, [0x1027] = 0x1146,
  [0x1028] = 0x1147, [0x1029] = 0x1148, [0x102a] = 0x1149, [0x102b] = 0x114a,
  [0x102c] = 0x114b, [0x102d] = 0x114c, [0x102e] = 0x114d, [0x102f] = 0x114e,
  [0x1030] = 0x114f, [0x1031] = 0x1150, [0x1032] = 0x1151, [0x1033] = 0x1152,
  [0x1034] = 0x1153, [0x1035] = 0x1154, [0x1036] = 0x1155, [0x1037] = 0x1156,
  [0x1038] = 0x1157, [0x1039] = 0x1158, [0x103a] = 0x1159,
  [0x1040] = 0x115f, [0x1041] = 0x1160, [0x1042] = 0x1161, [0x1043] = 0x1162,
  [0x1044] = 0x1163, [0x1045] = 0x1164, [0x1046] = 0x1165, [0x1047] = 0x1166,
  [0x1048] = 0x1167, [0x1049] = 0x1168, [0x104a] = 0x1169, [0x104b] = 0x116a,
  [0x104c] = 0x116b, [0x104d] = 0x116c, [0x104e] = 0x116d, [0x104f] = 0x116e,
  [0x1050] = 0x116f, [0x1051] = 0x1170, [0x1052] = 0x1171, [0x1053] = 0x1172,
  [0x1054] = 0x1173, [0x1055] = 0x1174, [0x1056] = 0x1175, [0x1057] = 0x1176,
  [0x1058] = 0x1177, [0x1059] = 0x1178, [0x105a] = 0x1179, [0x105b] = 0x117a,
  [0x105c] = 0x117b, [0x105d] = 0x117c, [0x105e] = 0x117d, [0x105f] = 0x117e,
  [0x1060] = 0x117f, [0x1061] = 0x1180, [0x1062] = 0x1181, [0x1063] = 0x1182,
  [0x1064] = 0x1183, [0x1065] = 0x1184, [0x1066] = 0x1185, [0x1067] = 0x1186,
  [0x1068] = 0x1187, [0x1069] = 0x1188, [0x106a] = 0x1189, [0x106b] = 0x118a,
  [0x106c] = 0x118b, [0x106d] = 0x118c, [0x106e] = 0x118d, [0x106f] = 0x118e,
  [0x1070] = 0x118f, [0x1071] = 0x1190, [0x1072] = 0x1191, [0x1073] = 0x1192,
  [0x1074] = 0x1193, [0x1075] = 0x1194, [0x1076] = 0x1195, [0x1077] = 0x1196,
  [0x1078] = 0x1197, [0x1079] = 0x1198, [0x107a] = 0x1199, [0x107b] = 0x119a,
  [0x107c] = 0x119b, [0x107d] = 0x119c, [0x107e] = 0x119d, [0x107f] = 0x119e,
  [0x1080] = 0x119f, [0x1081] = 0x11a0, [0x1082] = 0x11a1, [0x1083] = 0x11a2,
  [0x1089] = 0x11a8, [0x108a] = 0x11a9, [0x108b] = 0x11aa,
  [0x108c] = 0x11ab, [0x108d] = 0x11ac, [0x108e] = 0x11ad, [0x108f] = 0x11ae,
  [0x1090] = 0x11af, [0x1091] = 0x11b0, [0x1092] = 0x11b1, [0x1093] = 0x11b2,
  [0x1094] = 0x11b3, [0x1095] = 0x11b4, [0x1096] = 0x11b5, [0x1097] = 0x11b6,
  [0x1098] = 0x11b7, [0x1099] = 0x11b8, [0x109a] = 0x11b9, [0x109b] = 0x11ba,
  [0x109c] = 0x11bb, [0x109d] = 0x11bc, [0x109e] = 0x11bd, [0x109f] = 0x11be,
  [0x10a0] = 0x11bf, [0x10a1] = 0x11c0, [0x10a2] = 0x11c1, [0x10a3] = 0x11c2,
  [0x10a4] = 0x11c3, [0x10a5] = 0x11c4, [0x10a6] = 0x11c5, [0x10a7] = 0x11c6,
  [0x10a8] = 0x11c7, [0x10a9] = 0x11c8, [0x10aa] = 0x11c9, [0x10ab] = 0x11ca,
  [0x10ac] = 0x11cb, [0x10ad] = 0x11cc, [0x10ae] = 0x11cd, [0x10af] = 0x11ce,
  [0x10b0] = 0x11cf, [0x10b1] = 0x11d0, [0x10b2] = 0x11d1, [0x10b3] = 0x11d2,
  [0x10b4] = 0x11d3, [0x10b5] = 0x11d4, [0x10b6] = 0x11d5, [0x10b7] = 0x11d6,
  [0x10b8] = 0x11d7, [0x10b9] = 0x11d8, [0x10ba] = 0x11d9, [0x10bb] = 0x11da,
  [0x10bc] = 0x11db, [0x10bd] = 0x11dc, [0x10be] = 0x11dd, [0x10bf] = 0x11de,
  [0x10c0] = 0x11df, [0x10c1] = 0x11e0, [0x10c2] = 0x11e1, [0x10c3] = 0x11e2,
  [0x10c4] = 0x11e3, [0x10c5] = 0x11e4, [0x10c6] = 0x11e5, [0x10c7] = 0x11e6,
  [0x10c8] = 0x11e7, [0x10c9] = 0x11e8, [0x10ca] = 0x11e9, [0x10cb] = 0x11ea,
  [0x10cc] = 0x11eb, [0x10cd] = 0x11ec, [0x10ce] = 0x11ed, [0x10cf] = 0x11ee,
  [0x10d0] = 0x11ef, [0x10d1] = 0x11f0, [0x10d2] = 0x11f1, [0x10d3] = 0x11f2,
  [0x10d4] = 0x11f3, [0x10d5] = 0x11f4, [0x10d6] = 0x11f5, [0x10d7] = 0x11f6,
  [0x10d8] = 0x11f7, [0x10d9] = 0x11f8, [0x10da] = 0x11f9,
  [0x10e1] = 0x1200, [0x10e2] = 0x1201, [0x10e3] = 0x1202,
  [0x10e4] = 0x1203, [0x10e5] = 0x1204, [0x10e6] = 0x1205, [0x10e7] = 0x1206,
  [0x10e9] = 0x1208, [0x10ea] = 0x1209, [0x10eb] = 0x120a,
  [0x10ec] = 0x120b, [0x10ed] = 0x120c, [0x10ee] = 0x120d, [0x10ef] = 0x120e,
  [0x10f0] = 0x120f, [0x10f1] = 0x1210, [0x10f2] = 0x1211, [0x10f3] = 0x1212,
  [0x10f4] = 0x1213, [0x10f5] = 0x1214, [0x10f6] = 0x1215, [0x10f7] = 0x1216,
  [0x10f8] = 0x1217, [0x10f9] = 0x1218, [0x10fa] = 0x1219, [0x10fb] = 0x121a,
  [0x10fc] = 0x121b, [0x10fd] = 0x121c, [0x10fe] = 0x121d, [0x10ff] = 0x121e,
  [0x1100] = 0x121f, [0x1101] = 0x1220, [0x1102] = 0x1221, [0x1103] = 0x1222,
  [0x1104] = 0x1223, [0x1105] = 0x1224, [0x1106] = 0x1225, [0x1107] = 0x1226,
  [0x1108] = 0x1227, [0x1109] = 0x1228, [0x110a] = 0x1229, [0x110b] = 0x122a,
  [0x110c] = 0x122b, [0x110d] = 0x122c, [0x110e] = 0x122d, [0x110f] = 0x122e,
  [0x1110] = 0x122f, [0x1111] = 0x1230, [0x1112] = 0x1231, [0x1113] = 0x1232,
  [0x1114] = 0x1233, [0x1115] = 0x1234, [0x1116] = 0x1235, [0x1117] = 0x1236,
  [0x1118] = 0x1237, [0x1119] = 0x1238, [0x111a] = 0x1239, [0x111b] = 0x123a,
  [0x111c] = 0x123b, [0x111d] = 0x123c, [0x111e] = 0x123d, [0x111f] = 0x123e,
  [0x1120] = 0x123f, [0x1121] = 0x1240, [0x1122] = 0x1241, [0x1123] = 0x1242,
  [0x1124] = 0x1243, [0x1125] = 0x1244, [0x1126] = 0x1245, [0x1127] = 0x1246,
  [0x1129] = 0x1248, [0x112b] = 0x124a,
  [0x112c] = 0x124b, [0x112d] = 0x124c, [0x112e] = 0x124d,
  [0x1131] = 0x1250, [0x1132] = 0x1251, [0x1133] = 0x1252,
  [0x1134] = 0x1253, [0x1135] = 0x1254, [0x1136] = 0x1255, [0x1137] = 0x1256,
  [0x1139] = 0x1258, [0x113b] = 0x125a,
  [0x113c] = 0x125b, [0x113d] = 0x125c, [0x113e] = 0x125d,
  [0x1141] = 0x1260, [0x1142] = 0x1261, [0x1143] = 0x1262,
  [0x1144] = 0x1263, [0x1145] = 0x1264, [0x1146] = 0x1265, [0x1147] = 0x1266,
  [0x1148] = 0x1267, [0x1149] = 0x1268, [0x114a] = 0x1269, [0x114b] = 0x126a,
  [0x114c] = 0x126b, [0x114d] = 0x126c, [0x114e] = 0x126d, [0x114f] = 0x126e,
  [0x1150] = 0x126f, [0x1151] = 0x1270, [0x1152] = 0x1271, [0x1153] = 0x1272,
  [0x1154] = 0x1273, [0x1155] = 0x1274, [0x1156] = 0x1275, [0x1157] = 0x1276,
  [0x1158] = 0x1277, [0x1159] = 0x1278, [0x115a] = 0x1279, [0x115b] = 0x127a,
  [0x115c] = 0x127b, [0x115d] = 0x127c, [0x115e] = 0x127d, [0x115f] = 0x127e,
  [0x1160] = 0x127f, [0x1161] = 0x1280, [0x1162] = 0x1281, [0x1163] = 0x1282,
  [0x1164] = 0x1283, [0x1165] = 0x1284, [0x1166] = 0x1285, [0x1167] = 0x1286,
  [0x1169] = 0x1288, [0x116b] = 0x128a,
  [0x116c] = 0x128b, [0x116d] = 0x128c, [0x116e] = 0x128d,
  [0x1171] = 0x1290, [0x1172] = 0x1291, [0x1173] = 0x1292,
  [0x1174] = 0x1293, [0x1175] = 0x1294, [0x1176] = 0x1295, [0x1177] = 0x1296,
  [0x1178] = 0x1297, [0x1179] = 0x1298, [0x117a] = 0x1299, [0x117b] = 0x129a,
  [0x117c] = 0x129b, [0x117d] = 0x129c, [0x117e] = 0x129d, [0x117f] = 0x129e,
  [0x1180] = 0x129f, [0x1181] = 0x12a0, [0x1182] = 0x12a1, [0x1183] = 0x12a2,
  [0x1184] = 0x12a3, [0x1185] = 0x12a4, [0x1186] = 0x12a5, [0x1187] = 0x12a6,
  [0x1188] = 0x12a7, [0x1189] = 0x12a8, [0x118a] = 0x12a9, [0x118b] = 0x12aa,
  [0x118c] = 0x12ab, [0x118d] = 0x12ac, [0x118e] = 0x12ad, [0x118f] = 0x12ae,
  [0x1191] = 0x12b0, [0x1193] = 0x12b2,
  [0x1194] = 0x12b3, [0x1195] = 0x12b4, [0x1196] = 0x12b5,
  [0x1199] = 0x12b8, [0x119a] = 0x12b9, [0x119b] = 0x12ba,
  [0x119c] = 0x12bb, [0x119d] = 0x12bc, [0x119e] = 0x12bd, [0x119f] = 0x12be,
  [0x11a1] = 0x12c0, [0x11a3] = 0x12c2,
  [0x11a4] = 0x12c3, [0x11a5] = 0x12c4, [0x11a6] = 0x12c5,
  [0x11a9] = 0x12c8, [0x11aa] = 0x12c9, [0x11ab] = 0x12ca,
  [0x11ac] = 0x12cb, [0x11ad] = 0x12cc, [0x11ae] = 0x12cd, [0x11af] = 0x12ce,
  [0x11b1] = 0x12d0, [0x11b2] = 0x12d1, [0x11b3] = 0x12d2,
  [0x11b4] = 0x12d3, [0x11b5] = 0x12d4, [0x11b6] = 0x12d5, [0x11b7] = 0x12d6,
  [0x11b9] = 0x12d8, [0x11ba] = 0x12d9, [0x11bb] = 0x12da,
  [0x11bc] = 0x12db, [0x11bd] = 0x12dc, [0x11be] = 0x12dd, [0x11bf] = 0x12de,
  [0x11c0] = 0x12df, [0x11c1] = 0x12e0, [0x11c2] = 0x12e1, [0x11c3] = 0x12e2,
  [0x11c4] = 0x12e3, [0x11c5] = 0x12e4, [0x11c6] = 0x12e5, [0x11c7] = 0x12e6,
  [0x11c8] = 0x12e7, [0x11c9] = 0x12e8, [0x11ca] = 0x12e9, [0x11cb] = 0x12ea,
  [0x11cc] = 0x12eb, [0x11cd] = 0x12ec, [0x11ce] = 0x12ed, [0x11cf] = 0x12ee,
  [0x11d1] = 0x12f0, [0x11d2] = 0x12f1, [0x11d3] = 0x12f2,
  [0x11d4] = 0x12f3, [0x11d5] = 0x12f4, [0x11d6] = 0x12f5, [0x11d7] = 0x12f6,
  [0x11d8] = 0x12f7, [0x11d9] = 0x12f8, [0x11da] = 0x12f9, [0x11db] = 0x12fa,
  [0x11dc] = 0x12fb, [0x11dd] = 0x12fc, [0x11de] = 0x12fd, [0x11df] = 0x12fe,
  [0x11e0] = 0x12ff, [0x11e1] = 0x1300, [0x11e2] = 0x1301, [0x11e3] = 0x1302,
  [0x11e4] = 0x1303, [0x11e5] = 0x1304, [0x11e6] = 0x1305, [0x11e7] = 0x1306,
  [0x11e8] = 0x1307, [0x11e9] = 0x1308, [0x11ea] = 0x1309, [0x11eb] = 0x130a,
  [0x11ec] = 0x130b, [0x11ed] = 0x130c, [0x11ee] = 0x130d, [0x11ef] = 0x130e,
  [0x11f1] = 0x1310, [0x11f3] = 0x1312,
  [0x11f4] = 0x1313, [0x11f5] = 0x1314, [0x11f6] = 0x1315,
  [0x11f9] = 0x1318, [0x11fa] = 0x1319, [0x11fb] = 0x131a,
  [0x11fc] = 0x131b, [0x11fd] = 0x131c, [0x11fe] = 0x131d, [0x11ff] = 0x131e,
  [0x1201] = 0x1320, [0x1202] = 0x1321, [0x1203] = 0x1322,
  [0x1204] = 0x1323, [0x1205] = 0x1324, [0x1206] = 0x1325, [0x1207] = 0x1326,
  [0x1208] = 0x1327, [0x1209] = 0x1328, [0x120a] = 0x1329, [0x120b] = 0x132a,
  [0x120c] = 0x132b, [0x120d] = 0x132c, [0x120e] = 0x132d, [0x120f] = 0x132e,
  [0x1210] = 0x132f, [0x1211] = 0x1330, [0x1212] = 0x1331, [0x1213] = 0x1332,
  [0x1214] = 0x1333, [0x1215] = 0x1334, [0x1216] = 0x1335, [0x1217] = 0x1336,
  [0x1218] = 0x1337, [0x1219] = 0x1338, [0x121a] = 0x1339, [0x121b] = 0x133a,
  [0x121c] = 0x133b, [0x121d] = 0x133c, [0x121e] = 0x133d, [0x121f] = 0x133e,
  [0x1220] = 0x133f, [0x1221] = 0x1340, [0x1222] = 0x1341, [0x1223] = 0x1342,
  [0x1224] = 0x1343, [0x1225] = 0x1344, [0x1226] = 0x1345, [0x1227] = 0x1346,
  [0x1229] = 0x1348, [0x122a] = 0x1349, [0x122b] = 0x134a,
  [0x122c] = 0x134b, [0x122d] = 0x134c, [0x122e] = 0x134d, [0x122f] = 0x134e,
  [0x1230] = 0x134f, [0x1231] = 0x1350, [0x1232] = 0x1351, [0x1233] = 0x1352,
  [0x1234] = 0x1353, [0x1235] = 0x1354, [0x1236] = 0x1355, [0x1237] = 0x1356,
  [0x1238] = 0x1357, [0x1239] = 0x1358, [0x123a] = 0x1359, [0x123b] = 0x135a,
  [0x1242] = 0x1361, [0x1243] = 0x1362,
  [0x1244] = 0x1363, [0x1245] = 0x1364, [0x1246] = 0x1365, [0x1247] = 0x1366,
  [0x1248] = 0x1367, [0x1249] = 0x1368, [0x124a] = 0x1369, [0x124b] = 0x136a,
  [0x124c] = 0x136b, [0x124d] = 0x136c, [0x124e] = 0x136d, [0x124f] = 0x136e,
  [0x1250] = 0x136f, [0x1251] = 0x1370, [0x1252] = 0x1371, [0x1253] = 0x1372,
  [0x1254] = 0x1373, [0x1255] = 0x1374, [0x1256] = 0x1375, [0x1257] = 0x1376,
  [0x1258] = 0x1377, [0x1259] = 0x1378, [0x125a] = 0x1379, [0x125b] = 0x137a,
  [0x125c] = 0x137b, [0x125d] = 0x137c,
  [0x1281] = 0x13a0, [0x1282] = 0x13a1, [0x1283] = 0x13a2,
  [0x1284] = 0x13a3, [0x1285] = 0x13a4, [0x1286] = 0x13a5, [0x1287] = 0x13a6,
  [0x1288] = 0x13a7, [0x1289] = 0x13a8, [0x128a] = 0x13a9, [0x128b] = 0x13aa,
  [0x128c] = 0x13ab, [0x128d] = 0x13ac, [0x128e] = 0x13ad, [0x128f] = 0x13ae,
  [0x1290] = 0x13af, [0x1291] = 0x13b0, [0x1292] = 0x13b1, [0x1293] = 0x13b2,
  [0x1294] = 0x13b3, [0x1295] = 0x13b4, [0x1296] = 0x13b5, [0x1297] = 0x13b6,
  [0x1298] = 0x13b7, [0x1299] = 0x13b8, [0x129a] = 0x13b9, [0x129b] = 0x13ba,
  [0x129c] = 0x13bb, [0x129d] = 0x13bc, [0x129e] = 0x13bd, [0x129f] = 0x13be,
  [0x12a0] = 0x13bf, [0x12a1] = 0x13c0, [0x12a2] = 0x13c1, [0x12a3] = 0x13c2,
  [0x12a4] = 0x13c3, [0x12a5] = 0x13c4, [0x12a6] = 0x13c5, [0x12a7] = 0x13c6,
  [0x12a8] = 0x13c7, [0x12a9] = 0x13c8, [0x12aa] = 0x13c9, [0x12ab] = 0x13ca,
  [0x12ac] = 0x13cb, [0x12ad] = 0x13cc, [0x12ae] = 0x13cd, [0x12af] = 0x13ce,
  [0x12b0] = 0x13cf, [0x12b1] = 0x13d0, [0x12b2] = 0x13d1, [0x12b3] = 0x13d2,
  [0x12b4] = 0x13d3, [0x12b5] = 0x13d4, [0x12b6] = 0x13d5, [0x12b7] = 0x13d6,
  [0x12b8] = 0x13d7, [0x12b9] = 0x13d8, [0x12ba] = 0x13d9, [0x12bb] = 0x13da,
  [0x12bc] = 0x13db, [0x12bd] = 0x13dc, [0x12be] = 0x13dd, [0x12bf] = 0x13de,
  [0x12c0] = 0x13df, [0x12c1] = 0x13e0, [0x12c2] = 0x13e1, [0x12c3] = 0x13e2,
  [0x12c4] = 0x13e3, [0x12c5] = 0x13e4, [0x12c6] = 0x13e5, [0x12c7] = 0x13e6,
  [0x12c8] = 0x13e7, [0x12c9] = 0x13e8, [0x12ca] = 0x13e9, [0x12cb] = 0x13ea,
  [0x12cc] = 0x13eb, [0x12cd] = 0x13ec, [0x12ce] = 0x13ed, [0x12cf] = 0x13ee,
  [0x12d0] = 0x13ef, [0x12d1] = 0x13f0, [0x12d2] = 0x13f1, [0x12d3] = 0x13f2,
  [0x12d4] = 0x13f3, [0x12d5] = 0x13f4, [0x12e2] = 0x1401, [0x12e3] = 0x1402,
  [0x12e4] = 0x1403, [0x12e5] = 0x1404, [0x12e6] = 0x1405, [0x12e7] = 0x1406,
  [0x12e8] = 0x1407, [0x12e9] = 0x1408, [0x12ea] = 0x1409, [0x12eb] = 0x140a,
  [0x12ec] = 0x140b, [0x12ed] = 0x140c, [0x12ee] = 0x140d, [0x12ef] = 0x140e,
  [0x12f0] = 0x140f, [0x12f1] = 0x1410, [0x12f2] = 0x1411, [0x12f3] = 0x1412,
  [0x12f4] = 0x1413, [0x12f5] = 0x1414, [0x12f6] = 0x1415, [0x12f7] = 0x1416,
  [0x12f8] = 0x1417, [0x12f9] = 0x1418, [0x12fa] = 0x1419, [0x12fb] = 0x141a,
  [0x12fc] = 0x141b, [0x12fd] = 0x141c, [0x12fe] = 0x141d, [0x12ff] = 0x141e,
  [0x1300] = 0x141f, [0x1301] = 0x1420, [0x1302] = 0x1421, [0x1303] = 0x1422,
  [0x1304] = 0x1423, [0x1305] = 0x1424, [0x1306] = 0x1425, [0x1307] = 0x1426,
  [0x1308] = 0x1427, [0x1309] = 0x1428, [0x130a] = 0x1429, [0x130b] = 0x142a,
  [0x130c] = 0x142b, [0x130d] = 0x142c, [0x130e] = 0x142d, [0x130f] = 0x142e,
  [0x1310] = 0x142f, [0x1311] = 0x1430, [0x1312] = 0x1431, [0x1313] = 0x1432,
  [0x1314] = 0x1433, [0x1315] = 0x1434, [0x1316] = 0x1435, [0x1317] = 0x1436,
  [0x1318] = 0x1437, [0x1319] = 0x1438, [0x131a] = 0x1439, [0x131b] = 0x143a,
  [0x131c] = 0x143b, [0x131d] = 0x143c, [0x131e] = 0x143d, [0x131f] = 0x143e,
  [0x1320] = 0x143f, [0x1321] = 0x1440, [0x1322] = 0x1441, [0x1323] = 0x1442,
  [0x1324] = 0x1443, [0x1325] = 0x1444, [0x1326] = 0x1445, [0x1327] = 0x1446,
  [0x1328] = 0x1447, [0x1329] = 0x1448, [0x132a] = 0x1449, [0x132b] = 0x144a,
  [0x132c] = 0x144b, [0x132d] = 0x144c, [0x132e] = 0x144d, [0x132f] = 0x144e,
  [0x1330] = 0x144f, [0x1331] = 0x1450, [0x1332] = 0x1451, [0x1333] = 0x1452,
  [0x1334] = 0x1453, [0x1335] = 0x1454, [0x1336] = 0x1455, [0x1337] = 0x1456,
  [0x1338] = 0x1457, [0x1339] = 0x1458, [0x133a] = 0x1459, [0x133b] = 0x145a,
  [0x133c] = 0x145b, [0x133d] = 0x145c, [0x133e] = 0x145d, [0x133f] = 0x145e,
  [0x1340] = 0x145f, [0x1341] = 0x1460, [0x1342] = 0x1461, [0x1343] = 0x1462,
  [0x1344] = 0x1463, [0x1345] = 0x1464, [0x1346] = 0x1465, [0x1347] = 0x1466,
  [0x1348] = 0x1467, [0x1349] = 0x1468, [0x134a] = 0x1469, [0x134b] = 0x146a,
  [0x134c] = 0x146b, [0x134d] = 0x146c, [0x134e] = 0x146d, [0x134f] = 0x146e,
  [0x1350] = 0x146f, [0x1351] = 0x1470, [0x1352] = 0x1471, [0x1353] = 0x1472,
  [0x1354] = 0x1473, [0x1355] = 0x1474, [0x1356] = 0x1475, [0x1357] = 0x1476,
  [0x1358] = 0x1477, [0x1359] = 0x1478, [0x135a] = 0x1479, [0x135b] = 0x147a,
  [0x135c] = 0x147b, [0x135d] = 0x147c, [0x135e] = 0x147d, [0x135f] = 0x147e,
  [0x1360] = 0x147f, [0x1361] = 0x1480, [0x1362] = 0x1481, [0x1363] = 0x1482,
  [0x1364] = 0x1483, [0x1365] = 0x1484, [0x1366] = 0x1485, [0x1367] = 0x1486,
  [0x1368] = 0x1487, [0x1369] = 0x1488, [0x136a] = 0x1489, [0x136b] = 0x148a,
  [0x136c] = 0x148b, [0x136d] = 0x148c, [0x136e] = 0x148d, [0x136f] = 0x148e,
  [0x1370] = 0x148f, [0x1371] = 0x1490, [0x1372] = 0x1491, [0x1373] = 0x1492,
  [0x1374] = 0x1493, [0x1375] = 0x1494, [0x1376] = 0x1495, [0x1377] = 0x1496,
  [0x1378] = 0x1497, [0x1379] = 0x1498, [0x137a] = 0x1499, [0x137b] = 0x149a,
  [0x137c] = 0x149b, [0x137d] = 0x149c, [0x137e] = 0x149d, [0x137f] = 0x149e,
  [0x1380] = 0x149f, [0x1381] = 0x14a0, [0x1382] = 0x14a1, [0x1383] = 0x14a2,
  [0x1384] = 0x14a3, [0x1385] = 0x14a4, [0x1386] = 0x14a5, [0x1387] = 0x14a6,
  [0x1388] = 0x14a7, [0x1389] = 0x14a8, [0x138a] = 0x14a9, [0x138b] = 0x14aa,
  [0x138c] = 0x14ab, [0x138d] = 0x14ac, [0x138e] = 0x14ad, [0x138f] = 0x14ae,
  [0x1390] = 0x14af, [0x1391] = 0x14b0, [0x1392] = 0x14b1, [0x1393] = 0x14b2,
  [0x1394] = 0x14b3, [0x1395] = 0x14b4, [0x1396] = 0x14b5, [0x1397] = 0x14b6,
  [0x1398] = 0x14b7, [0x1399] = 0x14b8, [0x139a] = 0x14b9, [0x139b] = 0x14ba,
  [0x139c] = 0x14bb, [0x139d] = 0x14bc, [0x139e] = 0x14bd, [0x139f] = 0x14be,
  [0x13a0] = 0x14bf, [0x13a1] = 0x14c0, [0x13a2] = 0x14c1, [0x13a3] = 0x14c2,
  [0x13a4] = 0x14c3, [0x13a5] = 0x14c4, [0x13a6] = 0x14c5, [0x13a7] = 0x14c6,
  [0x13a8] = 0x14c7, [0x13a9] = 0x14c8, [0x13aa] = 0x14c9, [0x13ab] = 0x14ca,
  [0x13ac] = 0x14cb, [0x13ad] = 0x14cc, [0x13ae] = 0x14cd, [0x13af] = 0x14ce,
  [0x13b0] = 0x14cf, [0x13b1] = 0x14d0, [0x13b2] = 0x14d1, [0x13b3] = 0x14d2,
  [0x13b4] = 0x14d3, [0x13b5] = 0x14d4, [0x13b6] = 0x14d5, [0x13b7] = 0x14d6,
  [0x13b8] = 0x14d7, [0x13b9] = 0x14d8, [0x13ba] = 0x14d9, [0x13bb] = 0x14da,
  [0x13bc] = 0x14db, [0x13bd] = 0x14dc, [0x13be] = 0x14dd, [0x13bf] = 0x14de,
  [0x13c0] = 0x14df, [0x13c1] = 0x14e0, [0x13c2] = 0x14e1, [0x13c3] = 0x14e2,
  [0x13c4] = 0x14e3, [0x13c5] = 0x14e4, [0x13c6] = 0x14e5, [0x13c7] = 0x14e6,
  [0x13c8] = 0x14e7, [0x13c9] = 0x14e8, [0x13ca] = 0x14e9, [0x13cb] = 0x14ea,
  [0x13cc] = 0x14eb, [0x13cd] = 0x14ec, [0x13ce] = 0x14ed, [0x13cf] = 0x14ee,
  [0x13d0] = 0x14ef, [0x13d1] = 0x14f0, [0x13d2] = 0x14f1, [0x13d3] = 0x14f2,
  [0x13d4] = 0x14f3, [0x13d5] = 0x14f4, [0x13d6] = 0x14f5, [0x13d7] = 0x14f6,
  [0x13d8] = 0x14f7, [0x13d9] = 0x14f8, [0x13da] = 0x14f9, [0x13db] = 0x14fa,
  [0x13dc] = 0x14fb, [0x13dd] = 0x14fc, [0x13de] = 0x14fd, [0x13df] = 0x14fe,
  [0x13e0] = 0x14ff, [0x13e1] = 0x1500, [0x13e2] = 0x1501, [0x13e3] = 0x1502,
  [0x13e4] = 0x1503, [0x13e5] = 0x1504, [0x13e6] = 0x1505, [0x13e7] = 0x1506,
  [0x13e8] = 0x1507, [0x13e9] = 0x1508, [0x13ea] = 0x1509, [0x13eb] = 0x150a,
  [0x13ec] = 0x150b, [0x13ed] = 0x150c, [0x13ee] = 0x150d, [0x13ef] = 0x150e,
  [0x13f0] = 0x150f, [0x13f1] = 0x1510, [0x13f2] = 0x1511, [0x13f3] = 0x1512,
  [0x13f4] = 0x1513, [0x13f5] = 0x1514, [0x13f6] = 0x1515, [0x13f7] = 0x1516,
  [0x13f8] = 0x1517, [0x13f9] = 0x1518, [0x13fa] = 0x1519, [0x13fb] = 0x151a,
  [0x13fc] = 0x151b, [0x13fd] = 0x151c, [0x13fe] = 0x151d, [0x13ff] = 0x151e,
  [0x1400] = 0x151f, [0x1401] = 0x1520, [0x1402] = 0x1521, [0x1403] = 0x1522,
  [0x1404] = 0x1523, [0x1405] = 0x1524, [0x1406] = 0x1525, [0x1407] = 0x1526,
  [0x1408] = 0x1527, [0x1409] = 0x1528, [0x140a] = 0x1529, [0x140b] = 0x152a,
  [0x140c] = 0x152b, [0x140d] = 0x152c, [0x140e] = 0x152d, [0x140f] = 0x152e,
  [0x1410] = 0x152f, [0x1411] = 0x1530, [0x1412] = 0x1531, [0x1413] = 0x1532,
  [0x1414] = 0x1533, [0x1415] = 0x1534, [0x1416] = 0x1535, [0x1417] = 0x1536,
  [0x1418] = 0x1537, [0x1419] = 0x1538, [0x141a] = 0x1539, [0x141b] = 0x153a,
  [0x141c] = 0x153b, [0x141d] = 0x153c, [0x141e] = 0x153d, [0x141f] = 0x153e,
  [0x1420] = 0x153f, [0x1421] = 0x1540, [0x1422] = 0x1541, [0x1423] = 0x1542,
  [0x1424] = 0x1543, [0x1425] = 0x1544, [0x1426] = 0x1545, [0x1427] = 0x1546,
  [0x1428] = 0x1547, [0x1429] = 0x1548, [0x142a] = 0x1549, [0x142b] = 0x154a,
  [0x142c] = 0x154b, [0x142d] = 0x154c, [0x142e] = 0x154d, [0x142f] = 0x154e,
  [0x1430] = 0x154f, [0x1431] = 0x1550, [0x1432] = 0x1551, [0x1433] = 0x1552,
  [0x1434] = 0x1553, [0x1435] = 0x1554, [0x1436] = 0x1555, [0x1437] = 0x1556,
  [0x1438] = 0x1557, [0x1439] = 0x1558, [0x143a] = 0x1559, [0x143b] = 0x155a,
  [0x143c] = 0x155b, [0x143d] = 0x155c, [0x143e] = 0x155d, [0x143f] = 0x155e,
  [0x1440] = 0x155f, [0x1441] = 0x1560, [0x1442] = 0x1561, [0x1443] = 0x1562,
  [0x1444] = 0x1563, [0x1445] = 0x1564, [0x1446] = 0x1565, [0x1447] = 0x1566,
  [0x1448] = 0x1567, [0x1449] = 0x1568, [0x144a] = 0x1569, [0x144b] = 0x156a,
  [0x144c] = 0x156b, [0x144d] = 0x156c, [0x144e] = 0x156d, [0x144f] = 0x156e,
  [0x1450] = 0x156f, [0x1451] = 0x1570, [0x1452] = 0x1571, [0x1453] = 0x1572,
  [0x1454] = 0x1573, [0x1455] = 0x1574, [0x1456] = 0x1575, [0x1457] = 0x1576,
  [0x1458] = 0x1577, [0x1459] = 0x1578, [0x145a] = 0x1579, [0x145b] = 0x157a,
  [0x145c] = 0x157b, [0x145d] = 0x157c, [0x145e] = 0x157d, [0x145f] = 0x157e,
  [0x1460] = 0x157f, [0x1461] = 0x1580, [0x1462] = 0x1581, [0x1463] = 0x1582,
  [0x1464] = 0x1583, [0x1465] = 0x1584, [0x1466] = 0x1585, [0x1467] = 0x1586,
  [0x1468] = 0x1587, [0x1469] = 0x1588, [0x146a] = 0x1589, [0x146b] = 0x158a,
  [0x146c] = 0x158b, [0x146d] = 0x158c, [0x146e] = 0x158d, [0x146f] = 0x158e,
  [0x1470] = 0x158f, [0x1471] = 0x1590, [0x1472] = 0x1591, [0x1473] = 0x1592,
  [0x1474] = 0x1593, [0x1475] = 0x1594, [0x1476] = 0x1595, [0x1477] = 0x1596,
  [0x1478] = 0x1597, [0x1479] = 0x1598, [0x147a] = 0x1599, [0x147b] = 0x159a,
  [0x147c] = 0x159b, [0x147d] = 0x159c, [0x147e] = 0x159d, [0x147f] = 0x159e,
  [0x1480] = 0x159f, [0x1481] = 0x15a0, [0x1482] = 0x15a1, [0x1483] = 0x15a2,
  [0x1484] = 0x15a3, [0x1485] = 0x15a4, [0x1486] = 0x15a5, [0x1487] = 0x15a6,
  [0x1488] = 0x15a7, [0x1489] = 0x15a8, [0x148a] = 0x15a9, [0x148b] = 0x15aa,
  [0x148c] = 0x15ab, [0x148d] = 0x15ac, [0x148e] = 0x15ad, [0x148f] = 0x15ae,
  [0x1490] = 0x15af, [0x1491] = 0x15b0, [0x1492] = 0x15b1, [0x1493] = 0x15b2,
  [0x1494] = 0x15b3, [0x1495] = 0x15b4, [0x1496] = 0x15b5, [0x1497] = 0x15b6,
  [0x1498] = 0x15b7, [0x1499] = 0x15b8, [0x149a] = 0x15b9, [0x149b] = 0x15ba,
  [0x149c] = 0x15bb, [0x149d] = 0x15bc, [0x149e] = 0x15bd, [0x149f] = 0x15be,
  [0x14a0] = 0x15bf, [0x14a1] = 0x15c0, [0x14a2] = 0x15c1, [0x14a3] = 0x15c2,
  [0x14a4] = 0x15c3, [0x14a5] = 0x15c4, [0x14a6] = 0x15c5, [0x14a7] = 0x15c6,
  [0x14a8] = 0x15c7, [0x14a9] = 0x15c8, [0x14aa] = 0x15c9, [0x14ab] = 0x15ca,
  [0x14ac] = 0x15cb, [0x14ad] = 0x15cc, [0x14ae] = 0x15cd, [0x14af] = 0x15ce,
  [0x14b0] = 0x15cf, [0x14b1] = 0x15d0, [0x14b2] = 0x15d1, [0x14b3] = 0x15d2,
  [0x14b4] = 0x15d3, [0x14b5] = 0x15d4, [0x14b6] = 0x15d5, [0x14b7] = 0x15d6,
  [0x14b8] = 0x15d7, [0x14b9] = 0x15d8, [0x14ba] = 0x15d9, [0x14bb] = 0x15da,
  [0x14bc] = 0x15db, [0x14bd] = 0x15dc, [0x14be] = 0x15dd, [0x14bf] = 0x15de,
  [0x14c0] = 0x15df, [0x14c1] = 0x15e0, [0x14c2] = 0x15e1, [0x14c3] = 0x15e2,
  [0x14c4] = 0x15e3, [0x14c5] = 0x15e4, [0x14c6] = 0x15e5, [0x14c7] = 0x15e6,
  [0x14c8] = 0x15e7, [0x14c9] = 0x15e8, [0x14ca] = 0x15e9, [0x14cb] = 0x15ea,
  [0x14cc] = 0x15eb, [0x14cd] = 0x15ec, [0x14ce] = 0x15ed, [0x14cf] = 0x15ee,
  [0x14d0] = 0x15ef, [0x14d1] = 0x15f0, [0x14d2] = 0x15f1, [0x14d3] = 0x15f2,
  [0x14d4] = 0x15f3, [0x14d5] = 0x15f4, [0x14d6] = 0x15f5, [0x14d7] = 0x15f6,
  [0x14d8] = 0x15f7, [0x14d9] = 0x15f8, [0x14da] = 0x15f9, [0x14db] = 0x15fa,
  [0x14dc] = 0x15fb, [0x14dd] = 0x15fc, [0x14de] = 0x15fd, [0x14df] = 0x15fe,
  [0x14e0] = 0x15ff, [0x14e1] = 0x1600, [0x14e2] = 0x1601, [0x14e3] = 0x1602,
  [0x14e4] = 0x1603, [0x14e5] = 0x1604, [0x14e6] = 0x1605, [0x14e7] = 0x1606,
  [0x14e8] = 0x1607, [0x14e9] = 0x1608, [0x14ea] = 0x1609, [0x14eb] = 0x160a,
  [0x14ec] = 0x160b, [0x14ed] = 0x160c, [0x14ee] = 0x160d, [0x14ef] = 0x160e,
  [0x14f0] = 0x160f, [0x14f1] = 0x1610, [0x14f2] = 0x1611, [0x14f3] = 0x1612,
  [0x14f4] = 0x1613, [0x14f5] = 0x1614, [0x14f6] = 0x1615, [0x14f7] = 0x1616,
  [0x14f8] = 0x1617, [0x14f9] = 0x1618, [0x14fa] = 0x1619, [0x14fb] = 0x161a,
  [0x14fc] = 0x161b, [0x14fd] = 0x161c, [0x14fe] = 0x161d, [0x14ff] = 0x161e,
  [0x1500] = 0x161f, [0x1501] = 0x1620, [0x1502] = 0x1621, [0x1503] = 0x1622,
  [0x1504] = 0x1623, [0x1505] = 0x1624, [0x1506] = 0x1625, [0x1507] = 0x1626,
  [0x1508] = 0x1627, [0x1509] = 0x1628, [0x150a] = 0x1629, [0x150b] = 0x162a,
  [0x150c] = 0x162b, [0x150d] = 0x162c, [0x150e] = 0x162d, [0x150f] = 0x162e,
  [0x1510] = 0x162f, [0x1511] = 0x1630, [0x1512] = 0x1631, [0x1513] = 0x1632,
  [0x1514] = 0x1633, [0x1515] = 0x1634, [0x1516] = 0x1635, [0x1517] = 0x1636,
  [0x1518] = 0x1637, [0x1519] = 0x1638, [0x151a] = 0x1639, [0x151b] = 0x163a,
  [0x151c] = 0x163b, [0x151d] = 0x163c, [0x151e] = 0x163d, [0x151f] = 0x163e,
  [0x1520] = 0x163f, [0x1521] = 0x1640, [0x1522] = 0x1641, [0x1523] = 0x1642,
  [0x1524] = 0x1643, [0x1525] = 0x1644, [0x1526] = 0x1645, [0x1527] = 0x1646,
  [0x1528] = 0x1647, [0x1529] = 0x1648, [0x152a] = 0x1649, [0x152b] = 0x164a,
  [0x152c] = 0x164b, [0x152d] = 0x164c, [0x152e] = 0x164d, [0x152f] = 0x164e,
  [0x1530] = 0x164f, [0x1531] = 0x1650, [0x1532] = 0x1651, [0x1533] = 0x1652,
  [0x1534] = 0x1653, [0x1535] = 0x1654, [0x1536] = 0x1655, [0x1537] = 0x1656,
  [0x1538] = 0x1657, [0x1539] = 0x1658, [0x153a] = 0x1659, [0x153b] = 0x165a,
  [0x153c] = 0x165b, [0x153d] = 0x165c, [0x153e] = 0x165d, [0x153f] = 0x165e,
  [0x1540] = 0x165f, [0x1541] = 0x1660, [0x1542] = 0x1661, [0x1543] = 0x1662,
  [0x1544] = 0x1663, [0x1545] = 0x1664, [0x1546] = 0x1665, [0x1547] = 0x1666,
  [0x1548] = 0x1667, [0x1549] = 0x1668, [0x154a] = 0x1669, [0x154b] = 0x166a,
  [0x154c] = 0x166b, [0x154d] = 0x166c, [0x154e] = 0x166d, [0x154f] = 0x166e,
  [0x1550] = 0x166f, [0x1551] = 0x1670, [0x1552] = 0x1671, [0x1553] = 0x1672,
  [0x1554] = 0x1673, [0x1555] = 0x1674, [0x1556] = 0x1675, [0x1557] = 0x1676,
  [0x1561] = 0x1680, [0x1562] = 0x1681, [0x1563] = 0x1682,
  [0x1564] = 0x1683, [0x1565] = 0x1684, [0x1566] = 0x1685, [0x1567] = 0x1686,
  [0x1568] = 0x1687, [0x1569] = 0x1688, [0x156a] = 0x1689, [0x156b] = 0x168a,
  [0x156c] = 0x168b, [0x156d] = 0x168c, [0x156e] = 0x168d, [0x156f] = 0x168e,
  [0x1570] = 0x168f, [0x1571] = 0x1690, [0x1572] = 0x1691, [0x1573] = 0x1692,
  [0x1574] = 0x1693, [0x1575] = 0x1694, [0x1576] = 0x1695, [0x1577] = 0x1696,
  [0x1578] = 0x1697, [0x1579] = 0x1698, [0x157a] = 0x1699, [0x157b] = 0x169a,
  [0x157c] = 0x169b, [0x157d] = 0x169c,
  [0x1581] = 0x16a0, [0x1582] = 0x16a1, [0x1583] = 0x16a2,
  [0x1584] = 0x16a3, [0x1585] = 0x16a4, [0x1586] = 0x16a5, [0x1587] = 0x16a6,
  [0x1588] = 0x16a7, [0x1589] = 0x16a8, [0x158a] = 0x16a9, [0x158b] = 0x16aa,
  [0x158c] = 0x16ab, [0x158d] = 0x16ac, [0x158e] = 0x16ad, [0x158f] = 0x16ae,
  [0x1590] = 0x16af, [0x1591] = 0x16b0, [0x1592] = 0x16b1, [0x1593] = 0x16b2,
  [0x1594] = 0x16b3, [0x1595] = 0x16b4, [0x1596] = 0x16b5, [0x1597] = 0x16b6,
  [0x1598] = 0x16b7, [0x1599] = 0x16b8, [0x159a] = 0x16b9, [0x159b] = 0x16ba,
  [0x159c] = 0x16bb, [0x159d] = 0x16bc, [0x159e] = 0x16bd, [0x159f] = 0x16be,
  [0x15a0] = 0x16bf, [0x15a1] = 0x16c0, [0x15a2] = 0x16c1, [0x15a3] = 0x16c2,
  [0x15a4] = 0x16c3, [0x15a5] = 0x16c4, [0x15a6] = 0x16c5, [0x15a7] = 0x16c6,
  [0x15a8] = 0x16c7, [0x15a9] = 0x16c8, [0x15aa] = 0x16c9, [0x15ab] = 0x16ca,
  [0x15ac] = 0x16cb, [0x15ad] = 0x16cc, [0x15ae] = 0x16cd, [0x15af] = 0x16ce,
  [0x15b0] = 0x16cf, [0x15b1] = 0x16d0, [0x15b2] = 0x16d1, [0x15b3] = 0x16d2,
  [0x15b4] = 0x16d3, [0x15b5] = 0x16d4, [0x15b6] = 0x16d5, [0x15b7] = 0x16d6,
  [0x15b8] = 0x16d7, [0x15b9] = 0x16d8, [0x15ba] = 0x16d9, [0x15bb] = 0x16da,
  [0x15bc] = 0x16db, [0x15bd] = 0x16dc, [0x15be] = 0x16dd, [0x15bf] = 0x16de,
  [0x15c0] = 0x16df, [0x15c1] = 0x16e0, [0x15c2] = 0x16e1, [0x15c3] = 0x16e2,
  [0x15c4] = 0x16e3, [0x15c5] = 0x16e4, [0x15c6] = 0x16e5, [0x15c7] = 0x16e6,
  [0x15c8] = 0x16e7, [0x15c9] = 0x16e8, [0x15ca] = 0x16e9, [0x15cb] = 0x16ea,
  [0x15cc] = 0x16eb, [0x15cd] = 0x16ec, [0x15ce] = 0x16ed, [0x15cf] = 0x16ee,
  [0x15d0] = 0x16ef, [0x15d1] = 0x16f0,
  [0x1661] = 0x1780, [0x1662] = 0x1781, [0x1663] = 0x1782,
  [0x1664] = 0x1783, [0x1665] = 0x1784, [0x1666] = 0x1785, [0x1667] = 0x1786,
  [0x1668] = 0x1787, [0x1669] = 0x1788, [0x166a] = 0x1789, [0x166b] = 0x178a,
  [0x166c] = 0x178b, [0x166d] = 0x178c, [0x166e] = 0x178d, [0x166f] = 0x178e,
  [0x1670] = 0x178f, [0x1671] = 0x1790, [0x1672] = 0x1791, [0x1673] = 0x1792,
  [0x1674] = 0x1793, [0x1675] = 0x1794, [0x1676] = 0x1795, [0x1677] = 0x1796,
  [0x1678] = 0x1797, [0x1679] = 0x1798, [0x167a] = 0x1799, [0x167b] = 0x179a,
  [0x167c] = 0x179b, [0x167d] = 0x179c, [0x167e] = 0x179d, [0x167f] = 0x179e,
  [0x1680] = 0x179f, [0x1681] = 0x17a0, [0x1682] = 0x17a1, [0x1683] = 0x17a2,
  [0x1684] = 0x17a3, [0x1685] = 0x17a4, [0x1686] = 0x17a5, [0x1687] = 0x17a6,
  [0x1688] = 0x17a7, [0x1689] = 0x17a8, [0x168a] = 0x17a9, [0x168b] = 0x17aa,
  [0x168c] = 0x17ab, [0x168d] = 0x17ac, [0x168e] = 0x17ad, [0x168f] = 0x17ae,
  [0x1690] = 0x17af, [0x1691] = 0x17b0, [0x1692] = 0x17b1, [0x1693] = 0x17b2,
  [0x1694] = 0x17b3, [0x1695] = 0x17b4, [0x1696] = 0x17b5, [0x1697] = 0x17b6,
  [0x1698] = 0x17b7, [0x1699] = 0x17b8, [0x169a] = 0x17b9, [0x169b] = 0x17ba,
  [0x169c] = 0x17bb, [0x169d] = 0x17bc, [0x169e] = 0x17bd, [0x169f] = 0x17be,
  [0x16a0] = 0x17bf, [0x16a1] = 0x17c0, [0x16a2] = 0x17c1, [0x16a3] = 0x17c2,
  [0x16a4] = 0x17c3, [0x16a5] = 0x17c4, [0x16a6] = 0x17c5, [0x16a7] = 0x17c6,
  [0x16a8] = 0x17c7, [0x16a9] = 0x17c8, [0x16aa] = 0x17c9, [0x16ab] = 0x17ca,
  [0x16ac] = 0x17cb, [0x16ad] = 0x17cc, [0x16ae] = 0x17cd, [0x16af] = 0x17ce,
  [0x16b0] = 0x17cf, [0x16b1] = 0x17d0, [0x16b2] = 0x17d1, [0x16b3] = 0x17d2,
  [0x16b4] = 0x17d3, [0x16b5] = 0x17d4, [0x16b6] = 0x17d5, [0x16b7] = 0x17d6,
  [0x16b8] = 0x17d7, [0x16b9] = 0x17d8, [0x16ba] = 0x17d9, [0x16bb] = 0x17da,
  [0x16bc] = 0x17db, [0x16bd] = 0x17dc,
  [0x16c1] = 0x17e0, [0x16c2] = 0x17e1, [0x16c3] = 0x17e2,
  [0x16c4] = 0x17e3, [0x16c5] = 0x17e4, [0x16c6] = 0x17e5, [0x16c7] = 0x17e6,
  [0x16c8] = 0x17e7, [0x16c9] = 0x17e8, [0x16ca] = 0x17e9,
  [0x16e1] = 0x1800, [0x16e2] = 0x1801, [0x16e3] = 0x1802,
  [0x16e4] = 0x1803, [0x16e5] = 0x1804, [0x16e6] = 0x1805, [0x16e7] = 0x1806,
  [0x16e8] = 0x1807, [0x16e9] = 0x1808, [0x16ea] = 0x1809, [0x16eb] = 0x180a,
  [0x16ec] = 0x180b, [0x16ed] = 0x180c, [0x16ee] = 0x180d, [0x16ef] = 0x180e,
  [0x16f1] = 0x1810, [0x16f2] = 0x1811, [0x16f3] = 0x1812,
  [0x16f4] = 0x1813, [0x16f5] = 0x1814, [0x16f6] = 0x1815, [0x16f7] = 0x1816,
  [0x16f8] = 0x1817, [0x16f9] = 0x1818, [0x16fa] = 0x1819,
  [0x1701] = 0x1820, [0x1702] = 0x1821, [0x1703] = 0x1822,
  [0x1704] = 0x1823, [0x1705] = 0x1824, [0x1706] = 0x1825, [0x1707] = 0x1826,
  [0x1708] = 0x1827, [0x1709] = 0x1828, [0x170a] = 0x1829, [0x170b] = 0x182a,
  [0x170c] = 0x182b, [0x170d] = 0x182c, [0x170e] = 0x182d, [0x170f] = 0x182e,
  [0x1710] = 0x182f, [0x1711] = 0x1830, [0x1712] = 0x1831, [0x1713] = 0x1832,
  [0x1714] = 0x1833, [0x1715] = 0x1834, [0x1716] = 0x1835, [0x1717] = 0x1836,
  [0x1718] = 0x1837, [0x1719] = 0x1838, [0x171a] = 0x1839, [0x171b] = 0x183a,
  [0x171c] = 0x183b, [0x171d] = 0x183c, [0x171e] = 0x183d, [0x171f] = 0x183e,
  [0x1720] = 0x183f, [0x1721] = 0x1840, [0x1722] = 0x1841, [0x1723] = 0x1842,
  [0x1724] = 0x1843, [0x1725] = 0x1844, [0x1726] = 0x1845, [0x1727] = 0x1846,
  [0x1728] = 0x1847, [0x1729] = 0x1848, [0x172a] = 0x1849, [0x172b] = 0x184a,
  [0x172c] = 0x184b, [0x172d] = 0x184c, [0x172e] = 0x184d, [0x172f] = 0x184e,
  [0x1730] = 0x184f, [0x1731] = 0x1850, [0x1732] = 0x1851, [0x1733] = 0x1852,
  [0x1734] = 0x1853, [0x1735] = 0x1854, [0x1736] = 0x1855, [0x1737] = 0x1856,
  [0x1738] = 0x1857, [0x1739] = 0x1858, [0x173a] = 0x1859, [0x173b] = 0x185a,
  [0x173c] = 0x185b, [0x173d] = 0x185c, [0x173e] = 0x185d, [0x173f] = 0x185e,
  [0x1740] = 0x185f, [0x1741] = 0x1860, [0x1742] = 0x1861, [0x1743] = 0x1862,
  [0x1744] = 0x1863, [0x1745] = 0x1864, [0x1746] = 0x1865, [0x1747] = 0x1866,
  [0x1748] = 0x1867, [0x1749] = 0x1868, [0x174a] = 0x1869, [0x174b] = 0x186a,
  [0x174c] = 0x186b, [0x174d] = 0x186c, [0x174e] = 0x186d, [0x174f] = 0x186e,
  [0x1750] = 0x186f, [0x1751] = 0x1870, [0x1752] = 0x1871, [0x1753] = 0x1872,
  [0x1754] = 0x1873, [0x1755] = 0x1874, [0x1756] = 0x1875, [0x1757] = 0x1876,
  [0x1758] = 0x1877, [0x1761] = 0x1880, [0x1762] = 0x1881, [0x1763] = 0x1882,
  [0x1764] = 0x1883, [0x1765] = 0x1884, [0x1766] = 0x1885, [0x1767] = 0x1886,
  [0x1768] = 0x1887, [0x1769] = 0x1888, [0x176a] = 0x1889, [0x176b] = 0x188a,
  [0x176c] = 0x188b, [0x176d] = 0x188c, [0x176e] = 0x188d, [0x176f] = 0x188e,
  [0x1770] = 0x188f, [0x1771] = 0x1890, [0x1772] = 0x1891, [0x1773] = 0x1892,
  [0x1774] = 0x1893, [0x1775] = 0x1894, [0x1776] = 0x1895, [0x1777] = 0x1896,
  [0x1778] = 0x1897, [0x1779] = 0x1898, [0x177a] = 0x1899, [0x177b] = 0x189a,
  [0x177c] = 0x189b, [0x177d] = 0x189c, [0x177e] = 0x189d, [0x177f] = 0x189e,
  [0x1780] = 0x189f, [0x1781] = 0x18a0, [0x1782] = 0x18a1, [0x1783] = 0x18a2,
  [0x1784] = 0x18a3, [0x1785] = 0x18a4, [0x1786] = 0x18a5, [0x1787] = 0x18a6,
  [0x1788] = 0x18a7, [0x1789] = 0x18a8, [0x178a] = 0x18a9,
  [0x1ce1] = 0x1e00, [0x1ce2] = 0x1e01, [0x1ce3] = 0x1e02,
  [0x1ce4] = 0x1e03, [0x1ce5] = 0x1e04, [0x1ce6] = 0x1e05, [0x1ce7] = 0x1e06,
  [0x1ce8] = 0x1e07, [0x1ce9] = 0x1e08, [0x1cea] = 0x1e09, [0x1ceb] = 0x1e0a,
  [0x1cec] = 0x1e0b, [0x1ced] = 0x1e0c, [0x1cee] = 0x1e0d, [0x1cef] = 0x1e0e,
  [0x1cf0] = 0x1e0f, [0x1cf1] = 0x1e10, [0x1cf2] = 0x1e11, [0x1cf3] = 0x1e12,
  [0x1cf4] = 0x1e13, [0x1cf5] = 0x1e14, [0x1cf6] = 0x1e15, [0x1cf7] = 0x1e16,
  [0x1cf8] = 0x1e17, [0x1cf9] = 0x1e18, [0x1cfa] = 0x1e19, [0x1cfb] = 0x1e1a,
  [0x1cfc] = 0x1e1b, [0x1cfd] = 0x1e1c, [0x1cfe] = 0x1e1d, [0x1cff] = 0x1e1e,
  [0x1d00] = 0x1e1f, [0x1d01] = 0x1e20, [0x1d02] = 0x1e21, [0x1d03] = 0x1e22,
  [0x1d04] = 0x1e23, [0x1d05] = 0x1e24, [0x1d06] = 0x1e25, [0x1d07] = 0x1e26,
  [0x1d08] = 0x1e27, [0x1d09] = 0x1e28, [0x1d0a] = 0x1e29, [0x1d0b] = 0x1e2a,
  [0x1d0c] = 0x1e2b, [0x1d0d] = 0x1e2c, [0x1d0e] = 0x1e2d, [0x1d0f] = 0x1e2e,
  [0x1d10] = 0x1e2f, [0x1d11] = 0x1e30, [0x1d12] = 0x1e31, [0x1d13] = 0x1e32,
  [0x1d14] = 0x1e33, [0x1d15] = 0x1e34, [0x1d16] = 0x1e35, [0x1d17] = 0x1e36,
  [0x1d18] = 0x1e37, [0x1d19] = 0x1e38, [0x1d1a] = 0x1e39, [0x1d1b] = 0x1e3a,
  [0x1d1c] = 0x1e3b, [0x1d1d] = 0x1e3c, [0x1d1e] = 0x1e3d, [0x1d1f] = 0x1e3e,
  [0x1d20] = 0x1e3f, [0x1d21] = 0x1e40, [0x1d22] = 0x1e41, [0x1d23] = 0x1e42,
  [0x1d24] = 0x1e43, [0x1d25] = 0x1e44, [0x1d26] = 0x1e45, [0x1d27] = 0x1e46,
  [0x1d28] = 0x1e47, [0x1d29] = 0x1e48, [0x1d2a] = 0x1e49, [0x1d2b] = 0x1e4a,
  [0x1d2c] = 0x1e4b, [0x1d2d] = 0x1e4c, [0x1d2e] = 0x1e4d, [0x1d2f] = 0x1e4e,
  [0x1d30] = 0x1e4f, [0x1d31] = 0x1e50, [0x1d32] = 0x1e51, [0x1d33] = 0x1e52,
  [0x1d34] = 0x1e53, [0x1d35] = 0x1e54, [0x1d36] = 0x1e55, [0x1d37] = 0x1e56,
  [0x1d38] = 0x1e57, [0x1d39] = 0x1e58, [0x1d3a] = 0x1e59, [0x1d3b] = 0x1e5a,
  [0x1d3c] = 0x1e5b, [0x1d3d] = 0x1e5c, [0x1d3e] = 0x1e5d, [0x1d3f] = 0x1e5e,
  [0x1d40] = 0x1e5f, [0x1d41] = 0x1e60, [0x1d42] = 0x1e61, [0x1d43] = 0x1e62,
  [0x1d44] = 0x1e63, [0x1d45] = 0x1e64, [0x1d46] = 0x1e65, [0x1d47] = 0x1e66,
  [0x1d48] = 0x1e67, [0x1d49] = 0x1e68, [0x1d4a] = 0x1e69, [0x1d4b] = 0x1e6a,
  [0x1d4c] = 0x1e6b, [0x1d4d] = 0x1e6c, [0x1d4e] = 0x1e6d, [0x1d4f] = 0x1e6e,
  [0x1d50] = 0x1e6f, [0x1d51] = 0x1e70, [0x1d52] = 0x1e71, [0x1d53] = 0x1e72,
  [0x1d54] = 0x1e73, [0x1d55] = 0x1e74, [0x1d56] = 0x1e75, [0x1d57] = 0x1e76,
  [0x1d58] = 0x1e77, [0x1d59] = 0x1e78, [0x1d5a] = 0x1e79, [0x1d5b] = 0x1e7a,
  [0x1d5c] = 0x1e7b, [0x1d5d] = 0x1e7c, [0x1d5e] = 0x1e7d, [0x1d5f] = 0x1e7e,
  [0x1d60] = 0x1e7f, [0x1d61] = 0x1e80, [0x1d62] = 0x1e81, [0x1d63] = 0x1e82,
  [0x1d64] = 0x1e83, [0x1d65] = 0x1e84, [0x1d66] = 0x1e85, [0x1d67] = 0x1e86,
  [0x1d68] = 0x1e87, [0x1d69] = 0x1e88, [0x1d6a] = 0x1e89, [0x1d6b] = 0x1e8a,
  [0x1d6c] = 0x1e8b, [0x1d6d] = 0x1e8c, [0x1d6e] = 0x1e8d, [0x1d6f] = 0x1e8e,
  [0x1d70] = 0x1e8f, [0x1d71] = 0x1e90, [0x1d72] = 0x1e91, [0x1d73] = 0x1e92,
  [0x1d74] = 0x1e93, [0x1d75] = 0x1e94, [0x1d76] = 0x1e95, [0x1d77] = 0x1e96,
  [0x1d78] = 0x1e97, [0x1d79] = 0x1e98, [0x1d7a] = 0x1e99, [0x1d7b] = 0x1e9a,
  [0x1d7c] = 0x1e9b, [0x1d81] = 0x1ea0, [0x1d82] = 0x1ea1, [0x1d83] = 0x1ea2,
  [0x1d84] = 0x1ea3, [0x1d85] = 0x1ea4, [0x1d86] = 0x1ea5, [0x1d87] = 0x1ea6,
  [0x1d88] = 0x1ea7, [0x1d89] = 0x1ea8, [0x1d8a] = 0x1ea9, [0x1d8b] = 0x1eaa,
  [0x1d8c] = 0x1eab, [0x1d8d] = 0x1eac, [0x1d8e] = 0x1ead, [0x1d8f] = 0x1eae,
  [0x1d90] = 0x1eaf, [0x1d91] = 0x1eb0, [0x1d92] = 0x1eb1, [0x1d93] = 0x1eb2,
  [0x1d94] = 0x1eb3, [0x1d95] = 0x1eb4, [0x1d96] = 0x1eb5, [0x1d97] = 0x1eb6,
  [0x1d98] = 0x1eb7, [0x1d99] = 0x1eb8, [0x1d9a] = 0x1eb9, [0x1d9b] = 0x1eba,
  [0x1d9c] = 0x1ebb, [0x1d9d] = 0x1ebc, [0x1d9e] = 0x1ebd, [0x1d9f] = 0x1ebe,
  [0x1da0] = 0x1ebf, [0x1da1] = 0x1ec0, [0x1da2] = 0x1ec1, [0x1da3] = 0x1ec2,
  [0x1da4] = 0x1ec3, [0x1da5] = 0x1ec4, [0x1da6] = 0x1ec5, [0x1da7] = 0x1ec6,
  [0x1da8] = 0x1ec7, [0x1da9] = 0x1ec8, [0x1daa] = 0x1ec9, [0x1dab] = 0x1eca,
  [0x1dac] = 0x1ecb, [0x1dad] = 0x1ecc, [0x1dae] = 0x1ecd, [0x1daf] = 0x1ece,
  [0x1db0] = 0x1ecf, [0x1db1] = 0x1ed0, [0x1db2] = 0x1ed1, [0x1db3] = 0x1ed2,
  [0x1db4] = 0x1ed3, [0x1db5] = 0x1ed4, [0x1db6] = 0x1ed5, [0x1db7] = 0x1ed6,
  [0x1db8] = 0x1ed7, [0x1db9] = 0x1ed8, [0x1dba] = 0x1ed9, [0x1dbb] = 0x1eda,
  [0x1dbc] = 0x1edb, [0x1dbd] = 0x1edc, [0x1dbe] = 0x1edd, [0x1dbf] = 0x1ede,
  [0x1dc0] = 0x1edf, [0x1dc1] = 0x1ee0, [0x1dc2] = 0x1ee1, [0x1dc3] = 0x1ee2,
  [0x1dc4] = 0x1ee3, [0x1dc5] = 0x1ee4, [0x1dc6] = 0x1ee5, [0x1dc7] = 0x1ee6,
  [0x1dc8] = 0x1ee7, [0x1dc9] = 0x1ee8, [0x1dca] = 0x1ee9, [0x1dcb] = 0x1eea,
  [0x1dcc] = 0x1eeb, [0x1dcd] = 0x1eec, [0x1dce] = 0x1eed, [0x1dcf] = 0x1eee,
  [0x1dd0] = 0x1eef, [0x1dd1] = 0x1ef0, [0x1dd2] = 0x1ef1, [0x1dd3] = 0x1ef2,
  [0x1dd4] = 0x1ef3, [0x1dd5] = 0x1ef4, [0x1dd6] = 0x1ef5, [0x1dd7] = 0x1ef6,
  [0x1dd8] = 0x1ef7, [0x1dd9] = 0x1ef8, [0x1dda] = 0x1ef9,
  [0x1de1] = 0x1f00, [0x1de2] = 0x1f01, [0x1de3] = 0x1f02,
  [0x1de4] = 0x1f03, [0x1de5] = 0x1f04, [0x1de6] = 0x1f05, [0x1de7] = 0x1f06,
  [0x1de8] = 0x1f07, [0x1de9] = 0x1f08, [0x1dea] = 0x1f09, [0x1deb] = 0x1f0a,
  [0x1dec] = 0x1f0b, [0x1ded] = 0x1f0c, [0x1dee] = 0x1f0d, [0x1def] = 0x1f0e,
  [0x1df0] = 0x1f0f, [0x1df1] = 0x1f10, [0x1df2] = 0x1f11, [0x1df3] = 0x1f12,
  [0x1df4] = 0x1f13, [0x1df5] = 0x1f14, [0x1df6] = 0x1f15,
  [0x1df9] = 0x1f18, [0x1dfa] = 0x1f19, [0x1dfb] = 0x1f1a,
  [0x1dfc] = 0x1f1b, [0x1dfd] = 0x1f1c, [0x1dfe] = 0x1f1d,
  [0x1e01] = 0x1f20, [0x1e02] = 0x1f21, [0x1e03] = 0x1f22,
  [0x1e04] = 0x1f23, [0x1e05] = 0x1f24, [0x1e06] = 0x1f25, [0x1e07] = 0x1f26,
  [0x1e08] = 0x1f27, [0x1e09] = 0x1f28, [0x1e0a] = 0x1f29, [0x1e0b] = 0x1f2a,
  [0x1e0c] = 0x1f2b, [0x1e0d] = 0x1f2c, [0x1e0e] = 0x1f2d, [0x1e0f] = 0x1f2e,
  [0x1e10] = 0x1f2f, [0x1e11] = 0x1f30, [0x1e12] = 0x1f31, [0x1e13] = 0x1f32,
  [0x1e14] = 0x1f33, [0x1e15] = 0x1f34, [0x1e16] = 0x1f35, [0x1e17] = 0x1f36,
  [0x1e18] = 0x1f37, [0x1e19] = 0x1f38, [0x1e1a] = 0x1f39, [0x1e1b] = 0x1f3a,
  [0x1e1c] = 0x1f3b, [0x1e1d] = 0x1f3c, [0x1e1e] = 0x1f3d, [0x1e1f] = 0x1f3e,
  [0x1e20] = 0x1f3f, [0x1e21] = 0x1f40, [0x1e22] = 0x1f41, [0x1e23] = 0x1f42,
  [0x1e24] = 0x1f43, [0x1e25] = 0x1f44, [0x1e26] = 0x1f45,
  [0x1e29] = 0x1f48, [0x1e2a] = 0x1f49, [0x1e2b] = 0x1f4a,
  [0x1e2c] = 0x1f4b, [0x1e2d] = 0x1f4c, [0x1e2e] = 0x1f4d,
  [0x1e31] = 0x1f50, [0x1e32] = 0x1f51, [0x1e33] = 0x1f52,
  [0x1e34] = 0x1f53, [0x1e35] = 0x1f54, [0x1e36] = 0x1f55, [0x1e37] = 0x1f56,
  [0x1e38] = 0x1f57, [0x1e3a] = 0x1f59, [0x1e3c] = 0x1f5b, [0x1e3e] = 0x1f5d,
  [0x1e40] = 0x1f5f, [0x1e41] = 0x1f60, [0x1e42] = 0x1f61, [0x1e43] = 0x1f62,
  [0x1e44] = 0x1f63, [0x1e45] = 0x1f64, [0x1e46] = 0x1f65, [0x1e47] = 0x1f66,
  [0x1e48] = 0x1f67, [0x1e49] = 0x1f68, [0x1e4a] = 0x1f69, [0x1e4b] = 0x1f6a,
  [0x1e4c] = 0x1f6b, [0x1e4d] = 0x1f6c, [0x1e4e] = 0x1f6d, [0x1e4f] = 0x1f6e,
  [0x1e50] = 0x1f6f, [0x1e51] = 0x1f70, [0x1e52] = 0x1f71, [0x1e53] = 0x1f72,
  [0x1e54] = 0x1f73, [0x1e55] = 0x1f74, [0x1e56] = 0x1f75, [0x1e57] = 0x1f76,
  [0x1e58] = 0x1f77, [0x1e59] = 0x1f78, [0x1e5a] = 0x1f79, [0x1e5b] = 0x1f7a,
  [0x1e5c] = 0x1f7b, [0x1e5d] = 0x1f7c, [0x1e5e] = 0x1f7d,
  [0x1e61] = 0x1f80, [0x1e62] = 0x1f81, [0x1e63] = 0x1f82,
  [0x1e64] = 0x1f83, [0x1e65] = 0x1f84, [0x1e66] = 0x1f85, [0x1e67] = 0x1f86,
  [0x1e68] = 0x1f87, [0x1e69] = 0x1f88, [0x1e6a] = 0x1f89, [0x1e6b] = 0x1f8a,
  [0x1e6c] = 0x1f8b, [0x1e6d] = 0x1f8c, [0x1e6e] = 0x1f8d, [0x1e6f] = 0x1f8e,
  [0x1e70] = 0x1f8f, [0x1e71] = 0x1f90, [0x1e72] = 0x1f91, [0x1e73] = 0x1f92,
  [0x1e74] = 0x1f93, [0x1e75] = 0x1f94, [0x1e76] = 0x1f95, [0x1e77] = 0x1f96,
  [0x1e78] = 0x1f97, [0x1e79] = 0x1f98, [0x1e7a] = 0x1f99, [0x1e7b] = 0x1f9a,
  [0x1e7c] = 0x1f9b, [0x1e7d] = 0x1f9c, [0x1e7e] = 0x1f9d, [0x1e7f] = 0x1f9e,
  [0x1e80] = 0x1f9f, [0x1e81] = 0x1fa0, [0x1e82] = 0x1fa1, [0x1e83] = 0x1fa2,
  [0x1e84] = 0x1fa3, [0x1e85] = 0x1fa4, [0x1e86] = 0x1fa5, [0x1e87] = 0x1fa6,
  [0x1e88] = 0x1fa7, [0x1e89] = 0x1fa8, [0x1e8a] = 0x1fa9, [0x1e8b] = 0x1faa,
  [0x1e8c] = 0x1fab, [0x1e8d] = 0x1fac, [0x1e8e] = 0x1fad, [0x1e8f] = 0x1fae,
  [0x1e90] = 0x1faf, [0x1e91] = 0x1fb0, [0x1e92] = 0x1fb1, [0x1e93] = 0x1fb2,
  [0x1e94] = 0x1fb3, [0x1e95] = 0x1fb4, [0x1e97] = 0x1fb6,
  [0x1e98] = 0x1fb7, [0x1e99] = 0x1fb8, [0x1e9a] = 0x1fb9, [0x1e9b] = 0x1fba,
  [0x1e9c] = 0x1fbb, [0x1e9d] = 0x1fbc, [0x1e9e] = 0x1fbd, [0x1e9f] = 0x1fbe,
  [0x1ea0] = 0x1fbf, [0x1ea1] = 0x1fc0, [0x1ea2] = 0x1fc1, [0x1ea3] = 0x1fc2,
  [0x1ea4] = 0x1fc3, [0x1ea5] = 0x1fc4, [0x1ea7] = 0x1fc6,
  [0x1ea8] = 0x1fc7, [0x1ea9] = 0x1fc8, [0x1eaa] = 0x1fc9, [0x1eab] = 0x1fca,
  [0x1eac] = 0x1fcb, [0x1ead] = 0x1fcc, [0x1eae] = 0x1fcd, [0x1eaf] = 0x1fce,
  [0x1eb0] = 0x1fcf, [0x1eb1] = 0x1fd0, [0x1eb2] = 0x1fd1, [0x1eb3] = 0x1fd2,
  [0x1eb4] = 0x1fd3, [0x1eb7] = 0x1fd6,
  [0x1eb8] = 0x1fd7, [0x1eb9] = 0x1fd8, [0x1eba] = 0x1fd9, [0x1ebb] = 0x1fda,
  [0x1ebc] = 0x1fdb, [0x1ebe] = 0x1fdd, [0x1ebf] = 0x1fde,
  [0x1ec0] = 0x1fdf, [0x1ec1] = 0x1fe0, [0x1ec2] = 0x1fe1, [0x1ec3] = 0x1fe2,
  [0x1ec4] = 0x1fe3, [0x1ec5] = 0x1fe4, [0x1ec6] = 0x1fe5, [0x1ec7] = 0x1fe6,
  [0x1ec8] = 0x1fe7, [0x1ec9] = 0x1fe8, [0x1eca] = 0x1fe9, [0x1ecb] = 0x1fea,
  [0x1ecc] = 0x1feb, [0x1ecd] = 0x1fec, [0x1ece] = 0x1fed, [0x1ecf] = 0x1fee,
  [0x1ed0] = 0x1fef, [0x1ed3] = 0x1ff2,
  [0x1ed4] = 0x1ff3, [0x1ed5] = 0x1ff4, [0x1ed7] = 0x1ff6,
  [0x1ed8] = 0x1ff7, [0x1ed9] = 0x1ff8, [0x1eda] = 0x1ff9, [0x1edb] = 0x1ffa,
  [0x1edc] = 0x1ffb, [0x1edd] = 0x1ffc, [0x1ede] = 0x1ffd, [0x1edf] = 0x1ffe,
  [0x1ee1] = 0x2000, [0x1ee2] = 0x2001, [0x1ee3] = 0x2002,
  [0x1ee4] = 0x2003, [0x1ee5] = 0x2004, [0x1ee6] = 0x2005, [0x1ee7] = 0x2006,
  [0x1ee8] = 0x2007, [0x1ee9] = 0x2008, [0x1eea] = 0x2009, [0x1eeb] = 0x200a,
  [0x1eec] = 0x200b, [0x1eed] = 0x200c, [0x1eee] = 0x200d, [0x1eef] = 0x200e,
  [0x1ef0] = 0x200f, [0x1ef1] = 0x2011, [0x1ef2] = 0x2012, [0x1ef3] = 0x2017,
  [0x1ef4] = 0x201a, [0x1ef5] = 0x201b, [0x1ef6] = 0x201e, [0x1ef7] = 0x201f,
  [0x1ef8] = 0x2020, [0x1ef9] = 0x2021, [0x1efa] = 0x2022, [0x1efb] = 0x2023,
  [0x1efc] = 0x2024, [0x1efd] = 0x2027, [0x1efe] = 0x2028, [0x1eff] = 0x2029,
  [0x1f00] = 0x202a, [0x1f01] = 0x202b, [0x1f02] = 0x202c, [0x1f03] = 0x202d,
  [0x1f04] = 0x202e, [0x1f05] = 0x202f, [0x1f06] = 0x2031, [0x1f07] = 0x2034,
  [0x1f08] = 0x2036, [0x1f09] = 0x2037, [0x1f0a] = 0x2038, [0x1f0b] = 0x2039,
  [0x1f0c] = 0x203a, [0x1f0d] = 0x203c, [0x1f0e] = 0x203d, [0x1f0f] = 0x203e,
  [0x1f10] = 0x203f, [0x1f11] = 0x2040, [0x1f12] = 0x2041, [0x1f13] = 0x2042,
  [0x1f14] = 0x2043, [0x1f15] = 0x2044, [0x1f16] = 0x2045, [0x1f17] = 0x2046,
  [0x1f19] = 0x2048, [0x1f1a] = 0x2049, [0x1f1b] = 0x204a,
  [0x1f1c] = 0x204b, [0x1f1d] = 0x204c, [0x1f1e] = 0x204d, [0x1f3b] = 0x206a,
  [0x1f3c] = 0x206b, [0x1f3d] = 0x206c, [0x1f3e] = 0x206d, [0x1f3f] = 0x206e,
  [0x1f40] = 0x206f, [0x1f41] = 0x2070,
  [0x1f45] = 0x2074, [0x1f46] = 0x2075, [0x1f47] = 0x2076,
  [0x1f48] = 0x2077, [0x1f49] = 0x2078, [0x1f4a] = 0x2079, [0x1f4b] = 0x207a,
  [0x1f4c] = 0x207b, [0x1f4d] = 0x207c, [0x1f4e] = 0x207d, [0x1f4f] = 0x207e,
  [0x1f50] = 0x207f, [0x1f51] = 0x2080, [0x1f52] = 0x2081, [0x1f53] = 0x2082,
  [0x1f54] = 0x2083, [0x1f55] = 0x2084, [0x1f56] = 0x2085, [0x1f57] = 0x2086,
  [0x1f58] = 0x2087, [0x1f59] = 0x2088, [0x1f5a] = 0x2089, [0x1f5b] = 0x208a,
  [0x1f5c] = 0x208b, [0x1f5d] = 0x208c, [0x1f5e] = 0x208d, [0x1f5f] = 0x208e,
  [0x1f71] = 0x20a0, [0x1f72] = 0x20a1, [0x1f73] = 0x20a2,
  [0x1f74] = 0x20a3, [0x1f75] = 0x20a4, [0x1f76] = 0x20a5, [0x1f77] = 0x20a6,
  [0x1f78] = 0x20a7, [0x1f79] = 0x20a8, [0x1f7a] = 0x20a9, [0x1f7b] = 0x20aa,
  [0x1f7c] = 0x20ab, [0x1f7d] = 0x20ad, [0x1f7e] = 0x20ae, [0x1f7f] = 0x20af,
  [0x1fa0] = 0x20d0, [0x1fa1] = 0x20d1, [0x1fa2] = 0x20d2, [0x1fa3] = 0x20d3,
  [0x1fa4] = 0x20d4, [0x1fa5] = 0x20d5, [0x1fa6] = 0x20d6, [0x1fa7] = 0x20d7,
  [0x1fa8] = 0x20d8, [0x1fa9] = 0x20d9, [0x1faa] = 0x20da, [0x1fab] = 0x20db,
  [0x1fac] = 0x20dc, [0x1fad] = 0x20dd, [0x1fae] = 0x20de, [0x1faf] = 0x20df,
  [0x1fb0] = 0x20e0, [0x1fb1] = 0x20e1, [0x1fb2] = 0x20e2, [0x1fb3] = 0x20e3,
  [0x1fd0] = 0x2100, [0x1fd1] = 0x2101, [0x1fd2] = 0x2102, [0x1fd3] = 0x2104,
  [0x1fd4] = 0x2106, [0x1fd5] = 0x2107, [0x1fd6] = 0x2108, [0x1fd7] = 0x210a,
  [0x1fd8] = 0x210b, [0x1fd9] = 0x210c, [0x1fda] = 0x210d, [0x1fdb] = 0x210e,
  [0x1fdc] = 0x210f, [0x1fdd] = 0x2110, [0x1fde] = 0x2111, [0x1fdf] = 0x2112,
  [0x1fe0] = 0x2113, [0x1fe1] = 0x2114, [0x1fe2] = 0x2115, [0x1fe3] = 0x2117,
  [0x1fe4] = 0x2118, [0x1fe5] = 0x2119, [0x1fe6] = 0x211a, [0x1fe7] = 0x211b,
  [0x1fe8] = 0x211c, [0x1fe9] = 0x211d, [0x1fea] = 0x211e, [0x1feb] = 0x211f,
  [0x1fec] = 0x2120, [0x1fed] = 0x2122, [0x1fee] = 0x2123, [0x1fef] = 0x2124,
  [0x1ff0] = 0x2125, [0x1ff1] = 0x2126, [0x1ff2] = 0x2127, [0x1ff3] = 0x2128,
  [0x1ff4] = 0x2129, [0x1ff5] = 0x212a, [0x1ff6] = 0x212b, [0x1ff7] = 0x212c,
  [0x1ff8] = 0x212d, [0x1ff9] = 0x212e, [0x1ffa] = 0x212f, [0x1ffb] = 0x2130,
  [0x1ffc] = 0x2131, [0x1ffd] = 0x2132, [0x1ffe] = 0x2133, [0x1fff] = 0x2134,
  [0x2000] = 0x2135, [0x2001] = 0x2136, [0x2002] = 0x2137, [0x2003] = 0x2138,
  [0x2004] = 0x2139, [0x2005] = 0x213a, [0x201e] = 0x2153, [0x201f] = 0x2154,
  [0x2020] = 0x2155, [0x2021] = 0x2156, [0x2022] = 0x2157, [0x2023] = 0x2158,
  [0x2024] = 0x2159, [0x2025] = 0x215a, [0x2026] = 0x215b, [0x2027] = 0x215c,
  [0x2028] = 0x215d, [0x2029] = 0x215e, [0x202a] = 0x215f, [0x202b] = 0x216c,
  [0x202c] = 0x216d, [0x202d] = 0x216e, [0x202e] = 0x216f, [0x202f] = 0x217a,
  [0x2030] = 0x217b, [0x2031] = 0x217c, [0x2032] = 0x217d, [0x2033] = 0x217e,
  [0x2034] = 0x217f, [0x2035] = 0x2180, [0x2036] = 0x2181, [0x2037] = 0x2182,
  [0x2038] = 0x2183,
  [0x2045] = 0x2194, [0x2046] = 0x2195, [0x2047] = 0x219a,
  [0x2048] = 0x219b, [0x2049] = 0x219c, [0x204a] = 0x219d, [0x204b] = 0x219e,
  [0x204c] = 0x219f, [0x204d] = 0x21a0, [0x204e] = 0x21a1, [0x204f] = 0x21a2,
  [0x2050] = 0x21a3, [0x2051] = 0x21a4, [0x2052] = 0x21a5, [0x2053] = 0x21a6,
  [0x2054] = 0x21a7, [0x2055] = 0x21a8, [0x2056] = 0x21a9, [0x2057] = 0x21aa,
  [0x2058] = 0x21ab, [0x2059] = 0x21ac, [0x205a] = 0x21ad, [0x205b] = 0x21ae,
  [0x205c] = 0x21af, [0x205d] = 0x21b0, [0x205e] = 0x21b1, [0x205f] = 0x21b2,
  [0x2060] = 0x21b3, [0x2061] = 0x21b4, [0x2062] = 0x21b5, [0x2063] = 0x21b6,
  [0x2064] = 0x21b7, [0x2065] = 0x21b8, [0x2066] = 0x21b9, [0x2067] = 0x21ba,
  [0x2068] = 0x21bb, [0x2069] = 0x21bc, [0x206a] = 0x21bd, [0x206b] = 0x21be,
  [0x206c] = 0x21bf, [0x206d] = 0x21c0, [0x206e] = 0x21c1, [0x206f] = 0x21c2,
  [0x2070] = 0x21c3, [0x2071] = 0x21c4, [0x2072] = 0x21c5, [0x2073] = 0x21c6,
  [0x2074] = 0x21c7, [0x2075] = 0x21c8, [0x2076] = 0x21c9, [0x2077] = 0x21ca,
  [0x2078] = 0x21cb, [0x2079] = 0x21cc, [0x207a] = 0x21cd, [0x207b] = 0x21ce,
  [0x207c] = 0x21cf, [0x207d] = 0x21d0, [0x207e] = 0x21d1, [0x207f] = 0x21d2,
  [0x2080] = 0x21d3, [0x2081] = 0x21d4, [0x2082] = 0x21d5, [0x2083] = 0x21d6,
  [0x2084] = 0x21d7, [0x2085] = 0x21d8, [0x2086] = 0x21d9, [0x2087] = 0x21da,
  [0x2088] = 0x21db, [0x2089] = 0x21dc, [0x208a] = 0x21dd, [0x208b] = 0x21de,
  [0x208c] = 0x21df, [0x208d] = 0x21e0, [0x208e] = 0x21e1, [0x208f] = 0x21e2,
  [0x2090] = 0x21e3, [0x2091] = 0x21e4, [0x2092] = 0x21e5, [0x2093] = 0x21e6,
  [0x2094] = 0x21e7, [0x2095] = 0x21e8, [0x2096] = 0x21e9, [0x2097] = 0x21ea,
  [0x2098] = 0x21eb, [0x2099] = 0x21ec, [0x209a] = 0x21ed, [0x209b] = 0x21ee,
  [0x209c] = 0x21ef, [0x209d] = 0x21f0, [0x209e] = 0x21f1, [0x209f] = 0x21f2,
  [0x20a0] = 0x21f3, [0x20ad] = 0x2200, [0x20ae] = 0x2201, [0x20af] = 0x2202,
  [0x20b0] = 0x2203, [0x20b1] = 0x2204, [0x20b2] = 0x2205, [0x20b3] = 0x2206,
  [0x20b4] = 0x2207, [0x20b5] = 0x2209, [0x20b6] = 0x220a, [0x20b7] = 0x220b,
  [0x20b8] = 0x220c, [0x20b9] = 0x220d, [0x20ba] = 0x220e, [0x20bb] = 0x2210,
  [0x20bc] = 0x2212, [0x20bd] = 0x2213, [0x20be] = 0x2214, [0x20bf] = 0x2216,
  [0x20c0] = 0x2217, [0x20c1] = 0x2218, [0x20c2] = 0x2219, [0x20c3] = 0x221b,
  [0x20c4] = 0x221c, [0x20c5] = 0x2221, [0x20c6] = 0x2222, [0x20c7] = 0x2224,
  [0x20c8] = 0x2226, [0x20c9] = 0x222c, [0x20ca] = 0x222d, [0x20cb] = 0x222f,
  [0x20cc] = 0x2230, [0x20cd] = 0x2231, [0x20ce] = 0x2232, [0x20cf] = 0x2233,
  [0x20d0] = 0x2238, [0x20d1] = 0x2239, [0x20d2] = 0x223a, [0x20d3] = 0x223b,
  [0x20d4] = 0x223c, [0x20d5] = 0x223e, [0x20d6] = 0x223f, [0x20d7] = 0x2240,
  [0x20d8] = 0x2241, [0x20d9] = 0x2242, [0x20da] = 0x2243, [0x20db] = 0x2244,
  [0x20dc] = 0x2245, [0x20dd] = 0x2246, [0x20de] = 0x2247, [0x20df] = 0x2249,
  [0x20e0] = 0x224a, [0x20e1] = 0x224b, [0x20e2] = 0x224d, [0x20e3] = 0x224e,
  [0x20e4] = 0x224f, [0x20e5] = 0x2250, [0x20e6] = 0x2251, [0x20e7] = 0x2253,
  [0x20e8] = 0x2254, [0x20e9] = 0x2255, [0x20ea] = 0x2256, [0x20eb] = 0x2257,
  [0x20ec] = 0x2258, [0x20ed] = 0x2259, [0x20ee] = 0x225a, [0x20ef] = 0x225b,
  [0x20f0] = 0x225c, [0x20f1] = 0x225d, [0x20f2] = 0x225e, [0x20f3] = 0x225f,
  [0x20f4] = 0x2262, [0x20f5] = 0x2263, [0x20f6] = 0x2268, [0x20f7] = 0x2269,
  [0x20f8] = 0x226a, [0x20f9] = 0x226b, [0x20fa] = 0x226c, [0x20fb] = 0x226d,
  [0x20fc] = 0x2270, [0x20fd] = 0x2271, [0x20fe] = 0x2272, [0x20ff] = 0x2273,
  [0x2100] = 0x2274, [0x2101] = 0x2275, [0x2102] = 0x2276, [0x2103] = 0x2277,
  [0x2104] = 0x2278, [0x2105] = 0x2279, [0x2106] = 0x227a, [0x2107] = 0x227b,
  [0x2108] = 0x227c, [0x2109] = 0x227d, [0x210a] = 0x227e, [0x210b] = 0x227f,
  [0x210c] = 0x2280, [0x210d] = 0x2281, [0x210e] = 0x2282, [0x210f] = 0x2283,
  [0x2110] = 0x2284, [0x2111] = 0x2285, [0x2112] = 0x2286, [0x2113] = 0x2287,
  [0x2114] = 0x2288, [0x2115] = 0x2289, [0x2116] = 0x228a, [0x2117] = 0x228b,
  [0x2118] = 0x228c, [0x2119] = 0x228d, [0x211a] = 0x228e, [0x211b] = 0x228f,
  [0x211c] = 0x2290, [0x211d] = 0x2291, [0x211e] = 0x2292, [0x211f] = 0x2293,
  [0x2120] = 0x2294, [0x2121] = 0x2296, [0x2122] = 0x2297, [0x2123] = 0x2298,
  [0x2124] = 0x229a, [0x2125] = 0x229b, [0x2126] = 0x229c, [0x2127] = 0x229d,
  [0x2128] = 0x229e, [0x2129] = 0x229f, [0x212a] = 0x22a0, [0x212b] = 0x22a1,
  [0x212c] = 0x22a2, [0x212d] = 0x22a3, [0x212e] = 0x22a4, [0x212f] = 0x22a6,
  [0x2130] = 0x22a7, [0x2131] = 0x22a8, [0x2132] = 0x22a9, [0x2133] = 0x22aa,
  [0x2134] = 0x22ab, [0x2135] = 0x22ac, [0x2136] = 0x22ad, [0x2137] = 0x22ae,
  [0x2138] = 0x22af, [0x2139] = 0x22b0, [0x213a] = 0x22b1, [0x213b] = 0x22b2,
  [0x213c] = 0x22b3, [0x213d] = 0x22b4, [0x213e] = 0x22b5, [0x213f] = 0x22b6,
  [0x2140] = 0x22b7, [0x2141] = 0x22b8, [0x2142] = 0x22b9, [0x2143] = 0x22ba,
  [0x2144] = 0x22bb, [0x2145] = 0x22bc, [0x2146] = 0x22bd, [0x2147] = 0x22be,
  [0x2148] = 0x22c0, [0x2149] = 0x22c1, [0x214a] = 0x22c2, [0x214b] = 0x22c3,
  [0x214c] = 0x22c4, [0x214d] = 0x22c5, [0x214e] = 0x22c6, [0x214f] = 0x22c7,
  [0x2150] = 0x22c8, [0x2151] = 0x22c9, [0x2152] = 0x22ca, [0x2153] = 0x22cb,
  [0x2154] = 0x22cc, [0x2155] = 0x22cd, [0x2156] = 0x22ce, [0x2157] = 0x22cf,
  [0x2158] = 0x22d0, [0x2159] = 0x22d1, [0x215a] = 0x22d2, [0x215b] = 0x22d3,
  [0x215c] = 0x22d4, [0x215d] = 0x22d5, [0x215e] = 0x22d6, [0x215f] = 0x22d7,
  [0x2160] = 0x22d8, [0x2161] = 0x22d9, [0x2162] = 0x22da, [0x2163] = 0x22db,
  [0x2164] = 0x22dc, [0x2165] = 0x22dd, [0x2166] = 0x22de, [0x2167] = 0x22df,
  [0x2168] = 0x22e0, [0x2169] = 0x22e1, [0x216a] = 0x22e2, [0x216b] = 0x22e3,
  [0x216c] = 0x22e4, [0x216d] = 0x22e5, [0x216e] = 0x22e6, [0x216f] = 0x22e7,
  [0x2170] = 0x22e8, [0x2171] = 0x22e9, [0x2172] = 0x22ea, [0x2173] = 0x22eb,
  [0x2174] = 0x22ec, [0x2175] = 0x22ed, [0x2176] = 0x22ee, [0x2177] = 0x22ef,
  [0x2178] = 0x22f0, [0x2179] = 0x22f1,
  [0x2188] = 0x2300, [0x2189] = 0x2301, [0x218a] = 0x2302, [0x218b] = 0x2303,
  [0x218c] = 0x2304, [0x218d] = 0x2305, [0x218e] = 0x2306, [0x218f] = 0x2307,
  [0x2190] = 0x2308, [0x2191] = 0x2309, [0x2192] = 0x230a, [0x2193] = 0x230b,
  [0x2194] = 0x230c, [0x2195] = 0x230d, [0x2196] = 0x230e, [0x2197] = 0x230f,
  [0x2198] = 0x2310, [0x2199] = 0x2311, [0x219a] = 0x2313, [0x219b] = 0x2314,
  [0x219c] = 0x2315, [0x219d] = 0x2316, [0x219e] = 0x2317, [0x219f] = 0x2318,
  [0x21a0] = 0x2319, [0x21a1] = 0x231a, [0x21a2] = 0x231b, [0x21a3] = 0x231c,
  [0x21a4] = 0x231d, [0x21a5] = 0x231e, [0x21a6] = 0x231f, [0x21a7] = 0x2320,
  [0x21a8] = 0x2321, [0x21a9] = 0x2322, [0x21aa] = 0x2323, [0x21ab] = 0x2324,
  [0x21ac] = 0x2325, [0x21ad] = 0x2326, [0x21ae] = 0x2327, [0x21af] = 0x2328,
  [0x21b0] = 0x2329, [0x21b1] = 0x232a, [0x21b2] = 0x232b, [0x21b3] = 0x232c,
  [0x21b4] = 0x232d, [0x21b5] = 0x232e, [0x21b6] = 0x232f, [0x21b7] = 0x2330,
  [0x21b8] = 0x2331, [0x21b9] = 0x2332, [0x21ba] = 0x2333, [0x21bb] = 0x2334,
  [0x21bc] = 0x2335, [0x21bd] = 0x2336, [0x21be] = 0x2337, [0x21bf] = 0x2338,
  [0x21c0] = 0x2339, [0x21c1] = 0x233a, [0x21c2] = 0x233b, [0x21c3] = 0x233c,
  [0x21c4] = 0x233d, [0x21c5] = 0x233e, [0x21c6] = 0x233f, [0x21c7] = 0x2340,
  [0x21c8] = 0x2341, [0x21c9] = 0x2342, [0x21ca] = 0x2343, [0x21cb] = 0x2344,
  [0x21cc] = 0x2345, [0x21cd] = 0x2346, [0x21ce] = 0x2347, [0x21cf] = 0x2348,
  [0x21d0] = 0x2349, [0x21d1] = 0x234a, [0x21d2] = 0x234b, [0x21d3] = 0x234c,
  [0x21d4] = 0x234d, [0x21d5] = 0x234e, [0x21d6] = 0x234f, [0x21d7] = 0x2350,
  [0x21d8] = 0x2351, [0x21d9] = 0x2352, [0x21da] = 0x2353, [0x21db] = 0x2354,
  [0x21dc] = 0x2355, [0x21dd] = 0x2356, [0x21de] = 0x2357, [0x21df] = 0x2358,
  [0x21e0] = 0x2359, [0x21e1] = 0x235a, [0x21e2] = 0x235b, [0x21e3] = 0x235c,
  [0x21e4] = 0x235d, [0x21e5] = 0x235e, [0x21e6] = 0x235f, [0x21e7] = 0x2360,
  [0x21e8] = 0x2361, [0x21e9] = 0x2362, [0x21ea] = 0x2363, [0x21eb] = 0x2364,
  [0x21ec] = 0x2365, [0x21ed] = 0x2366, [0x21ee] = 0x2367, [0x21ef] = 0x2368,
  [0x21f0] = 0x2369, [0x21f1] = 0x236a, [0x21f2] = 0x236b, [0x21f3] = 0x236c,
  [0x21f4] = 0x236d, [0x21f5] = 0x236e, [0x21f6] = 0x236f, [0x21f7] = 0x2370,
  [0x21f8] = 0x2371, [0x21f9] = 0x2372, [0x21fa] = 0x2373, [0x21fb] = 0x2374,
  [0x21fc] = 0x2375, [0x21fd] = 0x2376, [0x21fe] = 0x2377, [0x21ff] = 0x2378,
  [0x2200] = 0x2379, [0x2201] = 0x237a, [0x2202] = 0x237b,
  [0x2204] = 0x237d, [0x2205] = 0x237e, [0x2206] = 0x237f, [0x2207] = 0x2380,
  [0x2208] = 0x2381, [0x2209] = 0x2382, [0x220a] = 0x2383, [0x220b] = 0x2384,
  [0x220c] = 0x2385, [0x220d] = 0x2386, [0x220e] = 0x2387, [0x220f] = 0x2388,
  [0x2210] = 0x2389, [0x2211] = 0x238a, [0x2212] = 0x238b, [0x2213] = 0x238c,
  [0x2214] = 0x238d, [0x2215] = 0x238e, [0x2216] = 0x238f, [0x2217] = 0x2390,
  [0x2218] = 0x2391, [0x2219] = 0x2392, [0x221a] = 0x2393, [0x221b] = 0x2394,
  [0x221c] = 0x2395, [0x221d] = 0x2396, [0x221e] = 0x2397, [0x221f] = 0x2398,
  [0x2220] = 0x2399, [0x2221] = 0x239a, [0x2287] = 0x2400,
  [0x2288] = 0x2401, [0x2289] = 0x2402, [0x228a] = 0x2403, [0x228b] = 0x2404,
  [0x228c] = 0x2405, [0x228d] = 0x2406, [0x228e] = 0x2407, [0x228f] = 0x2408,
  [0x2290] = 0x2409, [0x2291] = 0x240a, [0x2292] = 0x240b, [0x2293] = 0x240c,
  [0x2294] = 0x240d, [0x2295] = 0x240e, [0x2296] = 0x240f, [0x2297] = 0x2410,
  [0x2298] = 0x2411, [0x2299] = 0x2412, [0x229a] = 0x2413, [0x229b] = 0x2414,
  [0x229c] = 0x2415, [0x229d] = 0x2416, [0x229e] = 0x2417, [0x229f] = 0x2418,
  [0x22a0] = 0x2419, [0x22a1] = 0x241a, [0x22a2] = 0x241b, [0x22a3] = 0x241c,
  [0x22a4] = 0x241d, [0x22a5] = 0x241e, [0x22a6] = 0x241f, [0x22a7] = 0x2420,
  [0x22a8] = 0x2421, [0x22a9] = 0x2422, [0x22aa] = 0x2423, [0x22ab] = 0x2424,
  [0x22ac] = 0x2425, [0x22ad] = 0x2426, [0x22c7] = 0x2440,
  [0x22c8] = 0x2441, [0x22c9] = 0x2442, [0x22ca] = 0x2443, [0x22cb] = 0x2444,
  [0x22cc] = 0x2445, [0x22cd] = 0x2446, [0x22ce] = 0x2447, [0x22cf] = 0x2448,
  [0x22d0] = 0x2449, [0x22d1] = 0x244a, [0x22e7] = 0x246a,
  [0x22e8] = 0x246b, [0x22e9] = 0x246c, [0x22ea] = 0x246d, [0x22eb] = 0x246e,
  [0x22ec] = 0x246f, [0x22ed] = 0x2470, [0x22ee] = 0x2471, [0x22ef] = 0x2472,
  [0x22f0] = 0x2473, [0x22f1] = 0x249c, [0x22f2] = 0x249d, [0x22f3] = 0x249e,
  [0x22f4] = 0x249f, [0x22f5] = 0x24a0, [0x22f6] = 0x24a1, [0x22f7] = 0x24a2,
  [0x22f8] = 0x24a3, [0x22f9] = 0x24a4, [0x22fa] = 0x24a5, [0x22fb] = 0x24a6,
  [0x22fc] = 0x24a7, [0x22fd] = 0x24a8, [0x22fe] = 0x24a9, [0x22ff] = 0x24aa,
  [0x2300] = 0x24ab, [0x2301] = 0x24ac, [0x2302] = 0x24ad, [0x2303] = 0x24ae,
  [0x2304] = 0x24af, [0x2305] = 0x24b0, [0x2306] = 0x24b1, [0x2307] = 0x24b2,
  [0x2308] = 0x24b3, [0x2309] = 0x24b4, [0x230a] = 0x24b5, [0x230b] = 0x24b6,
  [0x230c] = 0x24b7, [0x230d] = 0x24b8, [0x230e] = 0x24b9, [0x230f] = 0x24ba,
  [0x2310] = 0x24bb, [0x2311] = 0x24bc, [0x2312] = 0x24bd, [0x2313] = 0x24be,
  [0x2314] = 0x24bf, [0x2315] = 0x24c0, [0x2316] = 0x24c1, [0x2317] = 0x24c2,
  [0x2318] = 0x24c3, [0x2319] = 0x24c4, [0x231a] = 0x24c5, [0x231b] = 0x24c6,
  [0x231c] = 0x24c7, [0x231d] = 0x24c8, [0x231e] = 0x24c9, [0x231f] = 0x24ca,
  [0x2320] = 0x24cb, [0x2321] = 0x24cc, [0x2322] = 0x24cd, [0x2323] = 0x24ce,
  [0x2324] = 0x24cf, [0x2325] = 0x24d0, [0x2326] = 0x24d1, [0x2327] = 0x24d2,
  [0x2328] = 0x24d3, [0x2329] = 0x24d4, [0x232a] = 0x24d5, [0x232b] = 0x24d6,
  [0x232c] = 0x24d7, [0x232d] = 0x24d8, [0x232e] = 0x24d9, [0x232f] = 0x24da,
  [0x2330] = 0x24db, [0x2331] = 0x24dc, [0x2332] = 0x24dd, [0x2333] = 0x24de,
  [0x2334] = 0x24df, [0x2335] = 0x24e0, [0x2336] = 0x24e1, [0x2337] = 0x24e2,
  [0x2338] = 0x24e3, [0x2339] = 0x24e4, [0x233a] = 0x24e5, [0x233b] = 0x24e6,
  [0x233c] = 0x24e7, [0x233d] = 0x24e8, [0x233e] = 0x24e9, [0x233f] = 0x24ea,
  [0x2355] = 0x254c, [0x2356] = 0x254d, [0x2357] = 0x254e,
  [0x2358] = 0x254f, [0x2359] = 0x2574, [0x235a] = 0x2575, [0x235b] = 0x2576,
  [0x235c] = 0x2577, [0x235d] = 0x2578, [0x235e] = 0x2579, [0x235f] = 0x257a,
  [0x2360] = 0x257b, [0x2361] = 0x257c, [0x2362] = 0x257d, [0x2363] = 0x257e,
  [0x2364] = 0x257f, [0x2365] = 0x2580, [0x2366] = 0x2590, [0x2367] = 0x2591,
  [0x2368] = 0x2592, [0x2373] = 0x25a2,
  [0x2374] = 0x25a3, [0x2375] = 0x25a4, [0x2376] = 0x25a5, [0x2377] = 0x25a6,
  [0x2378] = 0x25a7, [0x2379] = 0x25a8, [0x237a] = 0x25a9, [0x237b] = 0x25aa,
  [0x237c] = 0x25ab, [0x237d] = 0x25ac, [0x237e] = 0x25ad, [0x237f] = 0x25ae,
  [0x2380] = 0x25af, [0x2381] = 0x25b0, [0x2382] = 0x25b1, [0x2383] = 0x25b4,
  [0x2384] = 0x25b5, [0x2385] = 0x25b6, [0x2386] = 0x25b7, [0x2387] = 0x25b8,
  [0x2388] = 0x25b9, [0x2389] = 0x25ba, [0x238a] = 0x25bb, [0x238b] = 0x25be,
  [0x238c] = 0x25bf, [0x238d] = 0x25c0, [0x238e] = 0x25c1, [0x238f] = 0x25c2,
  [0x2390] = 0x25c3, [0x2391] = 0x25c4, [0x2392] = 0x25c5, [0x2393] = 0x25c8,
  [0x2394] = 0x25c9, [0x2395] = 0x25ca, [0x2396] = 0x25cc, [0x2397] = 0x25cd,
  [0x2398] = 0x25d0, [0x2399] = 0x25d1, [0x239a] = 0x25d2, [0x239b] = 0x25d3,
  [0x239c] = 0x25d4, [0x239d] = 0x25d5, [0x239e] = 0x25d6, [0x239f] = 0x25d7,
  [0x23a0] = 0x25d8, [0x23a1] = 0x25d9, [0x23a2] = 0x25da, [0x23a3] = 0x25db,
  [0x23a4] = 0x25dc, [0x23a5] = 0x25dd, [0x23a6] = 0x25de, [0x23a7] = 0x25df,
  [0x23a8] = 0x25e0, [0x23a9] = 0x25e1, [0x23aa] = 0x25e6, [0x23ab] = 0x25e7,
  [0x23ac] = 0x25e8, [0x23ad] = 0x25e9, [0x23ae] = 0x25ea, [0x23af] = 0x25eb,
  [0x23b0] = 0x25ec, [0x23b1] = 0x25ed, [0x23b2] = 0x25ee, [0x23b3] = 0x25ef,
  [0x23b4] = 0x25f0, [0x23b5] = 0x25f1, [0x23b6] = 0x25f2, [0x23b7] = 0x25f3,
  [0x23b8] = 0x25f4, [0x23b9] = 0x25f5, [0x23ba] = 0x25f6, [0x23bb] = 0x25f7,
  [0x23c4] = 0x2600, [0x23c5] = 0x2601, [0x23c6] = 0x2602, [0x23c7] = 0x2603,
  [0x23c8] = 0x2604, [0x23c9] = 0x2607, [0x23ca] = 0x2608, [0x23cb] = 0x260a,
  [0x23cc] = 0x260b, [0x23cd] = 0x260c, [0x23ce] = 0x260d, [0x23cf] = 0x260e,
  [0x23d0] = 0x260f, [0x23d1] = 0x2610, [0x23d2] = 0x2611, [0x23d3] = 0x2612,
  [0x23d4] = 0x2613, [0x23da] = 0x2619, [0x23db] = 0x261a,
  [0x23dc] = 0x261b, [0x23dd] = 0x261c, [0x23de] = 0x261d, [0x23df] = 0x261e,
  [0x23e0] = 0x261f, [0x23e1] = 0x2620, [0x23e2] = 0x2621, [0x23e3] = 0x2622,
  [0x23e4] = 0x2623, [0x23e5] = 0x2624, [0x23e6] = 0x2625, [0x23e7] = 0x2626,
  [0x23e8] = 0x2627, [0x23e9] = 0x2628, [0x23ea] = 0x2629, [0x23eb] = 0x262a,
  [0x23ec] = 0x262b, [0x23ed] = 0x262c, [0x23ee] = 0x262d, [0x23ef] = 0x262e,
  [0x23f0] = 0x262f, [0x23f1] = 0x2630, [0x23f2] = 0x2631, [0x23f3] = 0x2632,
  [0x23f4] = 0x2633, [0x23f5] = 0x2634, [0x23f6] = 0x2635, [0x23f7] = 0x2636,
  [0x23f8] = 0x2637, [0x23f9] = 0x2638, [0x23fa] = 0x2639, [0x23fb] = 0x263a,
  [0x23fc] = 0x263b, [0x23fd] = 0x263c, [0x23fe] = 0x263d, [0x23ff] = 0x263e,
  [0x2400] = 0x263f, [0x2401] = 0x2641, [0x2402] = 0x2643, [0x2403] = 0x2644,
  [0x2404] = 0x2645, [0x2405] = 0x2646, [0x2406] = 0x2647, [0x2407] = 0x2648,
  [0x2408] = 0x2649, [0x2409] = 0x264a, [0x240a] = 0x264b, [0x240b] = 0x264c,
  [0x240c] = 0x264d, [0x240d] = 0x264e, [0x240e] = 0x264f, [0x240f] = 0x2650,
  [0x2410] = 0x2651, [0x2411] = 0x2652, [0x2412] = 0x2653, [0x2413] = 0x2654,
  [0x2414] = 0x2655, [0x2415] = 0x2656, [0x2416] = 0x2657, [0x2417] = 0x2658,
  [0x2418] = 0x2659, [0x2419] = 0x265a, [0x241a] = 0x265b, [0x241b] = 0x265c,
  [0x241c] = 0x265d, [0x241d] = 0x265e, [0x241e] = 0x265f, [0x241f] = 0x2660,
  [0x2420] = 0x2661, [0x2421] = 0x2662, [0x2422] = 0x2663, [0x2423] = 0x2664,
  [0x2424] = 0x2665, [0x2425] = 0x2666, [0x2426] = 0x2667, [0x2427] = 0x2668,
  [0x2428] = 0x2669, [0x2429] = 0x266a, [0x242a] = 0x266b, [0x242b] = 0x266c,
  [0x242c] = 0x266d, [0x242d] = 0x266e, [0x242e] = 0x266f, [0x242f] = 0x2670,
  [0x2430] = 0x2671,
  [0x24c0] = 0x2701, [0x24c1] = 0x2702, [0x24c2] = 0x2703, [0x24c3] = 0x2704,
  [0x24c5] = 0x2706, [0x24c6] = 0x2707, [0x24c7] = 0x2708,
  [0x24c8] = 0x2709, [0x24cb] = 0x270c,
  [0x24cc] = 0x270d, [0x24cd] = 0x270e, [0x24ce] = 0x270f, [0x24cf] = 0x2710,
  [0x24d0] = 0x2711, [0x24d1] = 0x2712, [0x24d2] = 0x2713, [0x24d3] = 0x2714,
  [0x24d4] = 0x2715, [0x24d5] = 0x2716, [0x24d6] = 0x2717, [0x24d7] = 0x2718,
  [0x24d8] = 0x2719, [0x24d9] = 0x271a, [0x24da] = 0x271b, [0x24db] = 0x271c,
  [0x24dc] = 0x271d, [0x24dd] = 0x271e, [0x24de] = 0x271f, [0x24df] = 0x2720,
  [0x24e0] = 0x2721, [0x24e1] = 0x2722, [0x24e2] = 0x2723, [0x24e3] = 0x2724,
  [0x24e4] = 0x2725, [0x24e5] = 0x2726, [0x24e6] = 0x2727,
  [0x24e8] = 0x2729, [0x24e9] = 0x272a, [0x24ea] = 0x272b, [0x24eb] = 0x272c,
  [0x24ec] = 0x272d, [0x24ed] = 0x272e, [0x24ee] = 0x272f, [0x24ef] = 0x2730,
  [0x24f0] = 0x2731, [0x24f1] = 0x2732, [0x24f2] = 0x2733, [0x24f3] = 0x2734,
  [0x24f4] = 0x2735, [0x24f5] = 0x2736, [0x24f6] = 0x2737, [0x24f7] = 0x2738,
  [0x24f8] = 0x2739, [0x24f9] = 0x273a, [0x24fa] = 0x273b, [0x24fb] = 0x273c,
  [0x24fc] = 0x273d, [0x24fd] = 0x273e, [0x24fe] = 0x273f, [0x24ff] = 0x2740,
  [0x2500] = 0x2741, [0x2501] = 0x2742, [0x2502] = 0x2743, [0x2503] = 0x2744,
  [0x2504] = 0x2745, [0x2505] = 0x2746, [0x2506] = 0x2747, [0x2507] = 0x2748,
  [0x2508] = 0x2749, [0x2509] = 0x274a, [0x250a] = 0x274b,
  [0x250c] = 0x274d, [0x250e] = 0x274f, [0x250f] = 0x2750,
  [0x2510] = 0x2751, [0x2511] = 0x2752, [0x2515] = 0x2756, [0x2517] = 0x2758,
  [0x2518] = 0x2759, [0x2519] = 0x275a, [0x251a] = 0x275b, [0x251b] = 0x275c,
  [0x251c] = 0x275d, [0x251d] = 0x275e,
  [0x2520] = 0x2761, [0x2521] = 0x2762, [0x2522] = 0x2763, [0x2523] = 0x2764,
  [0x2524] = 0x2765, [0x2525] = 0x2766, [0x2526] = 0x2767,
  [0x2535] = 0x2776, [0x2536] = 0x2777, [0x2537] = 0x2778,
  [0x2538] = 0x2779, [0x2539] = 0x277a, [0x253a] = 0x277b, [0x253b] = 0x277c,
  [0x253c] = 0x277d, [0x253d] = 0x277e, [0x253e] = 0x277f, [0x253f] = 0x2780,
  [0x2540] = 0x2781, [0x2541] = 0x2782, [0x2542] = 0x2783, [0x2543] = 0x2784,
  [0x2544] = 0x2785, [0x2545] = 0x2786, [0x2546] = 0x2787, [0x2547] = 0x2788,
  [0x2548] = 0x2789, [0x2549] = 0x278a, [0x254a] = 0x278b, [0x254b] = 0x278c,
  [0x254c] = 0x278d, [0x254d] = 0x278e, [0x254e] = 0x278f, [0x254f] = 0x2790,
  [0x2550] = 0x2791, [0x2551] = 0x2792, [0x2552] = 0x2793, [0x2553] = 0x2794,
  [0x2557] = 0x2798,
  [0x2558] = 0x2799, [0x2559] = 0x279a, [0x255a] = 0x279b, [0x255b] = 0x279c,
  [0x255c] = 0x279d, [0x255d] = 0x279e, [0x255e] = 0x279f, [0x255f] = 0x27a0,
  [0x2560] = 0x27a1, [0x2561] = 0x27a2, [0x2562] = 0x27a3, [0x2563] = 0x27a4,
  [0x2564] = 0x27a5, [0x2565] = 0x27a6, [0x2566] = 0x27a7, [0x2567] = 0x27a8,
  [0x2568] = 0x27a9, [0x2569] = 0x27aa, [0x256a] = 0x27ab, [0x256b] = 0x27ac,
  [0x256c] = 0x27ad, [0x256d] = 0x27ae, [0x256e] = 0x27af,
  [0x2570] = 0x27b1, [0x2571] = 0x27b2, [0x2572] = 0x27b3, [0x2573] = 0x27b4,
  [0x2574] = 0x27b5, [0x2575] = 0x27b6, [0x2576] = 0x27b7, [0x2577] = 0x27b8,
  [0x2578] = 0x27b9, [0x2579] = 0x27ba, [0x257a] = 0x27bb, [0x257b] = 0x27bc,
  [0x257c] = 0x27bd, [0x257d] = 0x27be, [0x25bf] = 0x2800,
  [0x25c0] = 0x2801, [0x25c1] = 0x2802, [0x25c2] = 0x2803, [0x25c3] = 0x2804,
  [0x25c4] = 0x2805, [0x25c5] = 0x2806, [0x25c6] = 0x2807, [0x25c7] = 0x2808,
  [0x25c8] = 0x2809, [0x25c9] = 0x280a, [0x25ca] = 0x280b, [0x25cb] = 0x280c,
  [0x25cc] = 0x280d, [0x25cd] = 0x280e, [0x25ce] = 0x280f, [0x25cf] = 0x2810,
  [0x25d0] = 0x2811, [0x25d1] = 0x2812, [0x25d2] = 0x2813, [0x25d3] = 0x2814,
  [0x25d4] = 0x2815, [0x25d5] = 0x2816, [0x25d6] = 0x2817, [0x25d7] = 0x2818,
  [0x25d8] = 0x2819, [0x25d9] = 0x281a, [0x25da] = 0x281b, [0x25db] = 0x281c,
  [0x25dc] = 0x281d, [0x25dd] = 0x281e, [0x25de] = 0x281f, [0x25df] = 0x2820,
  [0x25e0] = 0x2821, [0x25e1] = 0x2822, [0x25e2] = 0x2823, [0x25e3] = 0x2824,
  [0x25e4] = 0x2825, [0x25e5] = 0x2826, [0x25e6] = 0x2827, [0x25e7] = 0x2828,
  [0x25e8] = 0x2829, [0x25e9] = 0x282a, [0x25ea] = 0x282b, [0x25eb] = 0x282c,
  [0x25ec] = 0x282d, [0x25ed] = 0x282e, [0x25ee] = 0x282f, [0x25ef] = 0x2830,
  [0x25f0] = 0x2831, [0x25f1] = 0x2832, [0x25f2] = 0x2833, [0x25f3] = 0x2834,
  [0x25f4] = 0x2835, [0x25f5] = 0x2836, [0x25f6] = 0x2837, [0x25f7] = 0x2838,
  [0x25f8] = 0x2839, [0x25f9] = 0x283a, [0x25fa] = 0x283b, [0x25fb] = 0x283c,
  [0x25fc] = 0x283d, [0x25fd] = 0x283e, [0x25fe] = 0x283f, [0x25ff] = 0x2840,
  [0x2600] = 0x2841, [0x2601] = 0x2842, [0x2602] = 0x2843, [0x2603] = 0x2844,
  [0x2604] = 0x2845, [0x2605] = 0x2846, [0x2606] = 0x2847, [0x2607] = 0x2848,
  [0x2608] = 0x2849, [0x2609] = 0x284a, [0x260a] = 0x284b, [0x260b] = 0x284c,
  [0x260c] = 0x284d, [0x260d] = 0x284e, [0x260e] = 0x284f, [0x260f] = 0x2850,
  [0x2610] = 0x2851, [0x2611] = 0x2852, [0x2612] = 0x2853, [0x2613] = 0x2854,
  [0x2614] = 0x2855, [0x2615] = 0x2856, [0x2616] = 0x2857, [0x2617] = 0x2858,
  [0x2618] = 0x2859, [0x2619] = 0x285a, [0x261a] = 0x285b, [0x261b] = 0x285c,
  [0x261c] = 0x285d, [0x261d] = 0x285e, [0x261e] = 0x285f, [0x261f] = 0x2860,
  [0x2620] = 0x2861, [0x2621] = 0x2862, [0x2622] = 0x2863, [0x2623] = 0x2864,
  [0x2624] = 0x2865, [0x2625] = 0x2866, [0x2626] = 0x2867, [0x2627] = 0x2868,
  [0x2628] = 0x2869, [0x2629] = 0x286a, [0x262a] = 0x286b, [0x262b] = 0x286c,
  [0x262c] = 0x286d, [0x262d] = 0x286e, [0x262e] = 0x286f, [0x262f] = 0x2870,
  [0x2630] = 0x2871, [0x2631] = 0x2872, [0x2632] = 0x2873, [0x2633] = 0x2874,
  [0x2634] = 0x2875, [0x2635] = 0x2876, [0x2636] = 0x2877, [0x2637] = 0x2878,
  [0x2638] = 0x2879, [0x2639] = 0x287a, [0x263a] = 0x287b, [0x263b] = 0x287c,
  [0x263c] = 0x287d, [0x263d] = 0x287e, [0x263e] = 0x287f, [0x263f] = 0x2880,
  [0x2640] = 0x2881, [0x2641] = 0x2882, [0x2642] = 0x2883, [0x2643] = 0x2884,
  [0x2644] = 0x2885, [0x2645] = 0x2886, [0x2646] = 0x2887, [0x2647] = 0x2888,
  [0x2648] = 0x2889, [0x2649] = 0x288a, [0x264a] = 0x288b, [0x264b] = 0x288c,
  [0x264c] = 0x288d, [0x264d] = 0x288e, [0x264e] = 0x288f, [0x264f] = 0x2890,
  [0x2650] = 0x2891, [0x2651] = 0x2892, [0x2652] = 0x2893, [0x2653] = 0x2894,
  [0x2654] = 0x2895, [0x2655] = 0x2896, [0x2656] = 0x2897, [0x2657] = 0x2898,
  [0x2658] = 0x2899, [0x2659] = 0x289a, [0x265a] = 0x289b, [0x265b] = 0x289c,
  [0x265c] = 0x289d, [0x265d] = 0x289e, [0x265e] = 0x289f, [0x265f] = 0x28a0,
  [0x2660] = 0x28a1, [0x2661] = 0x28a2, [0x2662] = 0x28a3, [0x2663] = 0x28a4,
  [0x2664] = 0x28a5, [0x2665] = 0x28a6, [0x2666] = 0x28a7, [0x2667] = 0x28a8,
  [0x2668] = 0x28a9, [0x2669] = 0x28aa, [0x266a] = 0x28ab, [0x266b] = 0x28ac,
  [0x266c] = 0x28ad, [0x266d] = 0x28ae, [0x266e] = 0x28af, [0x266f] = 0x28b0,
  [0x2670] = 0x28b1, [0x2671] = 0x28b2, [0x2672] = 0x28b3, [0x2673] = 0x28b4,
  [0x2674] = 0x28b5, [0x2675] = 0x28b6, [0x2676] = 0x28b7, [0x2677] = 0x28b8,
  [0x2678] = 0x28b9, [0x2679] = 0x28ba, [0x267a] = 0x28bb, [0x267b] = 0x28bc,
  [0x267c] = 0x28bd, [0x267d] = 0x28be, [0x267e] = 0x28bf, [0x267f] = 0x28c0,
  [0x2680] = 0x28c1, [0x2681] = 0x28c2, [0x2682] = 0x28c3, [0x2683] = 0x28c4,
  [0x2684] = 0x28c5, [0x2685] = 0x28c6, [0x2686] = 0x28c7, [0x2687] = 0x28c8,
  [0x2688] = 0x28c9, [0x2689] = 0x28ca, [0x268a] = 0x28cb, [0x268b] = 0x28cc,
  [0x268c] = 0x28cd, [0x268d] = 0x28ce, [0x268e] = 0x28cf, [0x268f] = 0x28d0,
  [0x2690] = 0x28d1, [0x2691] = 0x28d2, [0x2692] = 0x28d3, [0x2693] = 0x28d4,
  [0x2694] = 0x28d5, [0x2695] = 0x28d6, [0x2696] = 0x28d7, [0x2697] = 0x28d8,
  [0x2698] = 0x28d9, [0x2699] = 0x28da, [0x269a] = 0x28db, [0x269b] = 0x28dc,
  [0x269c] = 0x28dd, [0x269d] = 0x28de, [0x269e] = 0x28df, [0x269f] = 0x28e0,
  [0x26a0] = 0x28e1, [0x26a1] = 0x28e2, [0x26a2] = 0x28e3, [0x26a3] = 0x28e4,
  [0x26a4] = 0x28e5, [0x26a5] = 0x28e6, [0x26a6] = 0x28e7, [0x26a7] = 0x28e8,
  [0x26a8] = 0x28e9, [0x26a9] = 0x28ea, [0x26aa] = 0x28eb, [0x26ab] = 0x28ec,
  [0x26ac] = 0x28ed, [0x26ad] = 0x28ee, [0x26ae] = 0x28ef, [0x26af] = 0x28f0,
  [0x26b0] = 0x28f1, [0x26b1] = 0x28f2, [0x26b2] = 0x28f3, [0x26b3] = 0x28f4,
  [0x26b4] = 0x28f5, [0x26b5] = 0x28f6, [0x26b6] = 0x28f7, [0x26b7] = 0x28f8,
  [0x26b8] = 0x28f9, [0x26b9] = 0x28fa, [0x26ba] = 0x28fb, [0x26bb] = 0x28fc,
  [0x26bc] = 0x28fd, [0x26bd] = 0x28fe, [0x26be] = 0x28ff,
  [0x2c3f] = 0x2e80,
  [0x2c40] = 0x2e82, [0x2c41] = 0x2e83, [0x2c42] = 0x2e85, [0x2c43] = 0x2e86,
  [0x2c44] = 0x2e87, [0x2c45] = 0x2e89, [0x2c46] = 0x2e8a, [0x2c47] = 0x2e8d,
  [0x2c48] = 0x2e8e, [0x2c49] = 0x2e8f, [0x2c4a] = 0x2e90, [0x2c4b] = 0x2e91,
  [0x2c4c] = 0x2e92, [0x2c4d] = 0x2e93, [0x2c4e] = 0x2e94, [0x2c4f] = 0x2e95,
  [0x2c50] = 0x2e96, [0x2c51] = 0x2e97, [0x2c52] = 0x2e98, [0x2c53] = 0x2e99,
  [0x2c55] = 0x2e9b, [0x2c56] = 0x2e9c, [0x2c57] = 0x2e9d,
  [0x2c58] = 0x2e9e, [0x2c59] = 0x2e9f, [0x2c5a] = 0x2ea0, [0x2c5b] = 0x2ea1,
  [0x2c5c] = 0x2ea2, [0x2c5d] = 0x2ea3, [0x2c5e] = 0x2ea4, [0x2c5f] = 0x2ea5,
  [0x2c60] = 0x2ea6, [0x2c61] = 0x2ea8, [0x2c62] = 0x2ea9, [0x2c63] = 0x2eab,
  [0x2c64] = 0x2eac, [0x2c65] = 0x2ead, [0x2c66] = 0x2eaf, [0x2c67] = 0x2eb0,
  [0x2c68] = 0x2eb1, [0x2c69] = 0x2eb2, [0x2c6a] = 0x2eb4, [0x2c6b] = 0x2eb5,
  [0x2c6c] = 0x2eb8, [0x2c6d] = 0x2eb9, [0x2c6e] = 0x2eba, [0x2c6f] = 0x2ebc,
  [0x2c70] = 0x2ebd, [0x2c71] = 0x2ebe, [0x2c72] = 0x2ebf, [0x2c73] = 0x2ec0,
  [0x2c74] = 0x2ec1, [0x2c75] = 0x2ec2, [0x2c76] = 0x2ec3, [0x2c77] = 0x2ec4,
  [0x2c78] = 0x2ec5, [0x2c79] = 0x2ec6, [0x2c7a] = 0x2ec7, [0x2c7b] = 0x2ec8,
  [0x2c7c] = 0x2ec9, [0x2c7d] = 0x2ecb, [0x2c7e] = 0x2ecc, [0x2c7f] = 0x2ecd,
  [0x2c80] = 0x2ece, [0x2c81] = 0x2ecf, [0x2c82] = 0x2ed0, [0x2c83] = 0x2ed1,
  [0x2c84] = 0x2ed2, [0x2c85] = 0x2ed3, [0x2c86] = 0x2ed4, [0x2c87] = 0x2ed5,
  [0x2c88] = 0x2ed6, [0x2c89] = 0x2ed7, [0x2c8a] = 0x2ed8, [0x2c8b] = 0x2ed9,
  [0x2c8c] = 0x2eda, [0x2c8d] = 0x2edb, [0x2c8e] = 0x2edc, [0x2c8f] = 0x2edd,
  [0x2c90] = 0x2ede, [0x2c91] = 0x2edf, [0x2c92] = 0x2ee0, [0x2c93] = 0x2ee1,
  [0x2c94] = 0x2ee2, [0x2c95] = 0x2ee3, [0x2c96] = 0x2ee4, [0x2c97] = 0x2ee5,
  [0x2c98] = 0x2ee6, [0x2c99] = 0x2ee7, [0x2c9a] = 0x2ee8, [0x2c9b] = 0x2ee9,
  [0x2c9c] = 0x2eea, [0x2c9d] = 0x2eeb, [0x2c9e] = 0x2eec, [0x2c9f] = 0x2eed,
  [0x2ca0] = 0x2eee, [0x2ca1] = 0x2eef, [0x2ca2] = 0x2ef0, [0x2ca3] = 0x2ef1,
  [0x2ca4] = 0x2ef2, [0x2ca5] = 0x2ef3, [0x2cb2] = 0x2f00, [0x2cb3] = 0x2f01,
  [0x2cb4] = 0x2f02, [0x2cb5] = 0x2f03, [0x2cb6] = 0x2f04, [0x2cb7] = 0x2f05,
  [0x2cb8] = 0x2f06, [0x2cb9] = 0x2f07, [0x2cba] = 0x2f08, [0x2cbb] = 0x2f09,
  [0x2cbc] = 0x2f0a, [0x2cbd] = 0x2f0b, [0x2cbe] = 0x2f0c, [0x2cbf] = 0x2f0d,
  [0x2cc0] = 0x2f0e, [0x2cc1] = 0x2f0f, [0x2cc2] = 0x2f10, [0x2cc3] = 0x2f11,
  [0x2cc4] = 0x2f12, [0x2cc5] = 0x2f13, [0x2cc6] = 0x2f14, [0x2cc7] = 0x2f15,
  [0x2cc8] = 0x2f16, [0x2cc9] = 0x2f17, [0x2cca] = 0x2f18, [0x2ccb] = 0x2f19,
  [0x2ccc] = 0x2f1a, [0x2ccd] = 0x2f1b, [0x2cce] = 0x2f1c, [0x2ccf] = 0x2f1d,
  [0x2cd0] = 0x2f1e, [0x2cd1] = 0x2f1f, [0x2cd2] = 0x2f20, [0x2cd3] = 0x2f21,
  [0x2cd4] = 0x2f22, [0x2cd5] = 0x2f23, [0x2cd6] = 0x2f24, [0x2cd7] = 0x2f25,
  [0x2cd8] = 0x2f26, [0x2cd9] = 0x2f27, [0x2cda] = 0x2f28, [0x2cdb] = 0x2f29,
  [0x2cdc] = 0x2f2a, [0x2cdd] = 0x2f2b, [0x2cde] = 0x2f2c, [0x2cdf] = 0x2f2d,
  [0x2ce0] = 0x2f2e, [0x2ce1] = 0x2f2f, [0x2ce2] = 0x2f30, [0x2ce3] = 0x2f31,
  [0x2ce4] = 0x2f32, [0x2ce5] = 0x2f33, [0x2ce6] = 0x2f34, [0x2ce7] = 0x2f35,
  [0x2ce8] = 0x2f36, [0x2ce9] = 0x2f37, [0x2cea] = 0x2f38, [0x2ceb] = 0x2f39,
  [0x2cec] = 0x2f3a, [0x2ced] = 0x2f3b, [0x2cee] = 0x2f3c, [0x2cef] = 0x2f3d,
  [0x2cf0] = 0x2f3e, [0x2cf1] = 0x2f3f, [0x2cf2] = 0x2f40, [0x2cf3] = 0x2f41,
  [0x2cf4] = 0x2f42, [0x2cf5] = 0x2f43, [0x2cf6] = 0x2f44, [0x2cf7] = 0x2f45,
  [0x2cf8] = 0x2f46, [0x2cf9] = 0x2f47, [0x2cfa] = 0x2f48, [0x2cfb] = 0x2f49,
  [0x2cfc] = 0x2f4a, [0x2cfd] = 0x2f4b, [0x2cfe] = 0x2f4c, [0x2cff] = 0x2f4d,
  [0x2d00] = 0x2f4e, [0x2d01] = 0x2f4f, [0x2d02] = 0x2f50, [0x2d03] = 0x2f51,
  [0x2d04] = 0x2f52, [0x2d05] = 0x2f53, [0x2d06] = 0x2f54, [0x2d07] = 0x2f55,
  [0x2d08] = 0x2f56, [0x2d09] = 0x2f57, [0x2d0a] = 0x2f58, [0x2d0b] = 0x2f59,
  [0x2d0c] = 0x2f5a, [0x2d0d] = 0x2f5b, [0x2d0e] = 0x2f5c, [0x2d0f] = 0x2f5d,
  [0x2d10] = 0x2f5e, [0x2d11] = 0x2f5f, [0x2d12] = 0x2f60, [0x2d13] = 0x2f61,
  [0x2d14] = 0x2f62, [0x2d15] = 0x2f63, [0x2d16] = 0x2f64, [0x2d17] = 0x2f65,
  [0x2d18] = 0x2f66, [0x2d19] = 0x2f67, [0x2d1a] = 0x2f68, [0x2d1b] = 0x2f69,
  [0x2d1c] = 0x2f6a, [0x2d1d] = 0x2f6b, [0x2d1e] = 0x2f6c, [0x2d1f] = 0x2f6d,
  [0x2d20] = 0x2f6e, [0x2d21] = 0x2f6f, [0x2d22] = 0x2f70, [0x2d23] = 0x2f71,
  [0x2d24] = 0x2f72, [0x2d25] = 0x2f73, [0x2d26] = 0x2f74, [0x2d27] = 0x2f75,
  [0x2d28] = 0x2f76, [0x2d29] = 0x2f77, [0x2d2a] = 0x2f78, [0x2d2b] = 0x2f79,
  [0x2d2c] = 0x2f7a, [0x2d2d] = 0x2f7b, [0x2d2e] = 0x2f7c, [0x2d2f] = 0x2f7d,
  [0x2d30] = 0x2f7e, [0x2d31] = 0x2f7f, [0x2d32] = 0x2f80, [0x2d33] = 0x2f81,
  [0x2d34] = 0x2f82, [0x2d35] = 0x2f83, [0x2d36] = 0x2f84, [0x2d37] = 0x2f85,
  [0x2d38] = 0x2f86, [0x2d39] = 0x2f87, [0x2d3a] = 0x2f88, [0x2d3b] = 0x2f89,
  [0x2d3c] = 0x2f8a, [0x2d3d] = 0x2f8b, [0x2d3e] = 0x2f8c, [0x2d3f] = 0x2f8d,
  [0x2d40] = 0x2f8e, [0x2d41] = 0x2f8f, [0x2d42] = 0x2f90, [0x2d43] = 0x2f91,
  [0x2d44] = 0x2f92, [0x2d45] = 0x2f93, [0x2d46] = 0x2f94, [0x2d47] = 0x2f95,
  [0x2d48] = 0x2f96, [0x2d49] = 0x2f97, [0x2d4a] = 0x2f98, [0x2d4b] = 0x2f99,
  [0x2d4c] = 0x2f9a, [0x2d4d] = 0x2f9b, [0x2d4e] = 0x2f9c, [0x2d4f] = 0x2f9d,
  [0x2d50] = 0x2f9e, [0x2d51] = 0x2f9f, [0x2d52] = 0x2fa0, [0x2d53] = 0x2fa1,
  [0x2d54] = 0x2fa2, [0x2d55] = 0x2fa3, [0x2d56] = 0x2fa4, [0x2d57] = 0x2fa5,
  [0x2d58] = 0x2fa6, [0x2d59] = 0x2fa7, [0x2d5a] = 0x2fa8, [0x2d5b] = 0x2fa9,
  [0x2d5c] = 0x2faa, [0x2d5d] = 0x2fab, [0x2d5e] = 0x2fac, [0x2d5f] = 0x2fad,
  [0x2d60] = 0x2fae, [0x2d61] = 0x2faf, [0x2d62] = 0x2fb0, [0x2d63] = 0x2fb1,
  [0x2d64] = 0x2fb2, [0x2d65] = 0x2fb3, [0x2d66] = 0x2fb4, [0x2d67] = 0x2fb5,
  [0x2d68] = 0x2fb6, [0x2d69] = 0x2fb7, [0x2d6a] = 0x2fb8, [0x2d6b] = 0x2fb9,
  [0x2d6c] = 0x2fba, [0x2d6d] = 0x2fbb, [0x2d6e] = 0x2fbc, [0x2d6f] = 0x2fbd,
  [0x2d70] = 0x2fbe, [0x2d71] = 0x2fbf, [0x2d72] = 0x2fc0, [0x2d73] = 0x2fc1,
  [0x2d74] = 0x2fc2, [0x2d75] = 0x2fc3, [0x2d76] = 0x2fc4, [0x2d77] = 0x2fc5,
  [0x2d78] = 0x2fc6, [0x2d79] = 0x2fc7, [0x2d7a] = 0x2fc8, [0x2d7b] = 0x2fc9,
  [0x2d7c] = 0x2fca, [0x2d7d] = 0x2fcb, [0x2d7e] = 0x2fcc, [0x2d7f] = 0x2fcd,
  [0x2d80] = 0x2fce, [0x2d81] = 0x2fcf, [0x2d82] = 0x2fd0, [0x2d83] = 0x2fd1,
  [0x2d84] = 0x2fd2, [0x2d85] = 0x2fd3, [0x2d86] = 0x2fd4, [0x2d87] = 0x2fd5,
  [0x2da6] = 0x3004, [0x2da7] = 0x3018,
  [0x2da8] = 0x3019, [0x2da9] = 0x301a, [0x2daa] = 0x301b, [0x2dab] = 0x301c,
  [0x2dac] = 0x301f, [0x2dad] = 0x3020, [0x2dae] = 0x302a, [0x2daf] = 0x302b,
  [0x2db0] = 0x302c, [0x2db1] = 0x302d, [0x2db2] = 0x302e, [0x2db3] = 0x302f,
  [0x2db4] = 0x3030, [0x2db5] = 0x3031, [0x2db6] = 0x3032, [0x2db7] = 0x3033,
  [0x2db8] = 0x3034, [0x2db9] = 0x3035, [0x2dba] = 0x3036, [0x2dbb] = 0x3037,
  [0x2dbc] = 0x3038, [0x2dbd] = 0x3039, [0x2dbe] = 0x303a,
  [0x2dc2] = 0x303e, [0x2dc3] = 0x303f,
  [0x2dc5] = 0x3094, [0x2dca] = 0x3099, [0x2dcb] = 0x309a,
  [0x2dce] = 0x30f7, [0x2dcf] = 0x30f8,
  [0x2dd0] = 0x30f9, [0x2dd1] = 0x30fa, [0x2dd2] = 0x30fb,
  [0x2dd9] = 0x312a, [0x2dda] = 0x312b, [0x2ddb] = 0x312c,
  [0x2de0] = 0x3131, [0x2de1] = 0x3132, [0x2de2] = 0x3133, [0x2de3] = 0x3134,
  [0x2de4] = 0x3135, [0x2de5] = 0x3136, [0x2de6] = 0x3137, [0x2de7] = 0x3138,
  [0x2de8] = 0x3139, [0x2de9] = 0x313a, [0x2dea] = 0x313b, [0x2deb] = 0x313c,
  [0x2dec] = 0x313d, [0x2ded] = 0x313e, [0x2dee] = 0x313f, [0x2def] = 0x3140,
  [0x2df0] = 0x3141, [0x2df1] = 0x3142, [0x2df2] = 0x3143, [0x2df3] = 0x3144,
  [0x2df4] = 0x3145, [0x2df5] = 0x3146, [0x2df6] = 0x3147, [0x2df7] = 0x3148,
  [0x2df8] = 0x3149, [0x2df9] = 0x314a, [0x2dfa] = 0x314b, [0x2dfb] = 0x314c,
  [0x2dfc] = 0x314d, [0x2dfd] = 0x314e, [0x2dfe] = 0x314f, [0x2dff] = 0x3150,
  [0x2e00] = 0x3151, [0x2e01] = 0x3152, [0x2e02] = 0x3153, [0x2e03] = 0x3154,
  [0x2e04] = 0x3155, [0x2e05] = 0x3156, [0x2e06] = 0x3157, [0x2e07] = 0x3158,
  [0x2e08] = 0x3159, [0x2e09] = 0x315a, [0x2e0a] = 0x315b, [0x2e0b] = 0x315c,
  [0x2e0c] = 0x315d, [0x2e0d] = 0x315e, [0x2e0e] = 0x315f, [0x2e0f] = 0x3160,
  [0x2e10] = 0x3161, [0x2e11] = 0x3162, [0x2e12] = 0x3163, [0x2e13] = 0x3164,
  [0x2e14] = 0x3165, [0x2e15] = 0x3166, [0x2e16] = 0x3167, [0x2e17] = 0x3168,
  [0x2e18] = 0x3169, [0x2e19] = 0x316a, [0x2e1a] = 0x316b, [0x2e1b] = 0x316c,
  [0x2e1c] = 0x316d, [0x2e1d] = 0x316e, [0x2e1e] = 0x316f, [0x2e1f] = 0x3170,
  [0x2e20] = 0x3171, [0x2e21] = 0x3172, [0x2e22] = 0x3173, [0x2e23] = 0x3174,
  [0x2e24] = 0x3175, [0x2e25] = 0x3176, [0x2e26] = 0x3177, [0x2e27] = 0x3178,
  [0x2e28] = 0x3179, [0x2e29] = 0x317a, [0x2e2a] = 0x317b, [0x2e2b] = 0x317c,
  [0x2e2c] = 0x317d, [0x2e2d] = 0x317e, [0x2e2e] = 0x317f, [0x2e2f] = 0x3180,
  [0x2e30] = 0x3181, [0x2e31] = 0x3182, [0x2e32] = 0x3183, [0x2e33] = 0x3184,
  [0x2e34] = 0x3185, [0x2e35] = 0x3186, [0x2e36] = 0x3187, [0x2e37] = 0x3188,
  [0x2e38] = 0x3189, [0x2e39] = 0x318a, [0x2e3a] = 0x318b, [0x2e3b] = 0x318c,
  [0x2e3c] = 0x318d, [0x2e3d] = 0x318e, [0x2e3f] = 0x3190,
  [0x2e40] = 0x3191, [0x2e41] = 0x3192, [0x2e42] = 0x3193, [0x2e43] = 0x3194,
  [0x2e44] = 0x3195, [0x2e45] = 0x3196, [0x2e46] = 0x3197, [0x2e47] = 0x3198,
  [0x2e48] = 0x3199, [0x2e49] = 0x319a, [0x2e4a] = 0x319b, [0x2e4b] = 0x319c,
  [0x2e4c] = 0x319d, [0x2e4d] = 0x319e, [0x2e4e] = 0x319f, [0x2e4f] = 0x31a0,
  [0x2e50] = 0x31a1, [0x2e51] = 0x31a2, [0x2e52] = 0x31a3, [0x2e53] = 0x31a4,
  [0x2e54] = 0x31a5, [0x2e55] = 0x31a6, [0x2e56] = 0x31a7, [0x2e57] = 0x31a8,
  [0x2e58] = 0x31a9, [0x2e59] = 0x31aa, [0x2e5a] = 0x31ab, [0x2e5b] = 0x31ac,
  [0x2e5c] = 0x31ad, [0x2e5d] = 0x31ae, [0x2e5e] = 0x31af, [0x2e5f] = 0x31b0,
  [0x2e60] = 0x31b1, [0x2e61] = 0x31b2, [0x2e62] = 0x31b3, [0x2e63] = 0x31b4,
  [0x2e64] = 0x31b5, [0x2e65] = 0x31b6, [0x2e66] = 0x31b7, [0x2eaf] = 0x3200,
  [0x2eb0] = 0x3201, [0x2eb1] = 0x3202, [0x2eb2] = 0x3203, [0x2eb3] = 0x3204,
  [0x2eb4] = 0x3205, [0x2eb5] = 0x3206, [0x2eb6] = 0x3207, [0x2eb7] = 0x3208,
  [0x2eb8] = 0x3209, [0x2eb9] = 0x320a, [0x2eba] = 0x320b, [0x2ebb] = 0x320c,
  [0x2ebc] = 0x320d, [0x2ebd] = 0x320e, [0x2ebe] = 0x320f, [0x2ebf] = 0x3210,
  [0x2ec0] = 0x3211, [0x2ec1] = 0x3212, [0x2ec2] = 0x3213, [0x2ec3] = 0x3214,
  [0x2ec4] = 0x3215, [0x2ec5] = 0x3216, [0x2ec6] = 0x3217, [0x2ec7] = 0x3218,
  [0x2ec8] = 0x3219, [0x2ec9] = 0x321a, [0x2eca] = 0x321b, [0x2ecb] = 0x321c,
  [0x2ecf] = 0x322a,
  [0x2ed0] = 0x322b, [0x2ed1] = 0x322c, [0x2ed2] = 0x322d, [0x2ed3] = 0x322e,
  [0x2ed4] = 0x322f, [0x2ed5] = 0x3230, [0x2ed6] = 0x3232, [0x2ed7] = 0x3233,
  [0x2ed8] = 0x3234, [0x2ed9] = 0x3235, [0x2eda] = 0x3236, [0x2edb] = 0x3237,
  [0x2edc] = 0x3238, [0x2edd] = 0x3239, [0x2ede] = 0x323a, [0x2edf] = 0x323b,
  [0x2ee0] = 0x323c, [0x2ee1] = 0x323d, [0x2ee2] = 0x323e, [0x2ee3] = 0x323f,
  [0x2ee4] = 0x3240, [0x2ee5] = 0x3241, [0x2ee6] = 0x3242, [0x2ee7] = 0x3243,
  [0x2f04] = 0x3260, [0x2f05] = 0x3261, [0x2f06] = 0x3262, [0x2f07] = 0x3263,
  [0x2f08] = 0x3264, [0x2f09] = 0x3265, [0x2f0a] = 0x3266, [0x2f0b] = 0x3267,
  [0x2f0c] = 0x3268, [0x2f0d] = 0x3269, [0x2f0e] = 0x326a, [0x2f0f] = 0x326b,
  [0x2f10] = 0x326c, [0x2f11] = 0x326d, [0x2f12] = 0x326e, [0x2f13] = 0x326f,
  [0x2f14] = 0x3270, [0x2f15] = 0x3271, [0x2f16] = 0x3272, [0x2f17] = 0x3273,
  [0x2f18] = 0x3274, [0x2f19] = 0x3275, [0x2f1a] = 0x3276, [0x2f1b] = 0x3277,
  [0x2f1c] = 0x3278, [0x2f1d] = 0x3279, [0x2f1e] = 0x327a, [0x2f1f] = 0x327b,
  [0x2f23] = 0x327f,
  [0x2f24] = 0x3280, [0x2f25] = 0x3281, [0x2f26] = 0x3282, [0x2f27] = 0x3283,
  [0x2f28] = 0x3284, [0x2f29] = 0x3285, [0x2f2a] = 0x3286, [0x2f2b] = 0x3287,
  [0x2f2c] = 0x3288, [0x2f2d] = 0x3289, [0x2f2e] = 0x328a, [0x2f2f] = 0x328b,
  [0x2f30] = 0x328c, [0x2f31] = 0x328d, [0x2f32] = 0x328e, [0x2f33] = 0x328f,
  [0x2f34] = 0x3290, [0x2f35] = 0x3291, [0x2f36] = 0x3292, [0x2f37] = 0x3293,
  [0x2f38] = 0x3294, [0x2f39] = 0x3295, [0x2f3a] = 0x3296, [0x2f3b] = 0x3297,
  [0x2f3c] = 0x3298, [0x2f3d] = 0x3299, [0x2f3e] = 0x329a, [0x2f3f] = 0x329b,
  [0x2f40] = 0x329c, [0x2f41] = 0x329d, [0x2f42] = 0x329e, [0x2f43] = 0x329f,
  [0x2f44] = 0x32a0, [0x2f45] = 0x32a1, [0x2f46] = 0x32a2, [0x2f47] = 0x32a4,
  [0x2f48] = 0x32a5, [0x2f49] = 0x32a6, [0x2f4a] = 0x32a7, [0x2f4b] = 0x32a8,
  [0x2f4c] = 0x32a9, [0x2f4d] = 0x32aa, [0x2f4e] = 0x32ab, [0x2f4f] = 0x32ac,
  [0x2f50] = 0x32ad, [0x2f51] = 0x32ae, [0x2f52] = 0x32af, [0x2f53] = 0x32b0,
  [0x2f63] = 0x32c0,
  [0x2f64] = 0x32c1, [0x2f65] = 0x32c2, [0x2f66] = 0x32c3, [0x2f67] = 0x32c4,
  [0x2f68] = 0x32c5, [0x2f69] = 0x32c6, [0x2f6a] = 0x32c7, [0x2f6b] = 0x32c8,
  [0x2f6c] = 0x32c9, [0x2f6d] = 0x32ca, [0x2f6e] = 0x32cb, [0x2f73] = 0x32d0,
  [0x2f74] = 0x32d1, [0x2f75] = 0x32d2, [0x2f76] = 0x32d3, [0x2f77] = 0x32d4,
  [0x2f78] = 0x32d5, [0x2f79] = 0x32d6, [0x2f7a] = 0x32d7, [0x2f7b] = 0x32d8,
  [0x2f7c] = 0x32d9, [0x2f7d] = 0x32da, [0x2f7e] = 0x32db, [0x2f7f] = 0x32dc,
  [0x2f80] = 0x32dd, [0x2f81] = 0x32de, [0x2f82] = 0x32df, [0x2f83] = 0x32e0,
  [0x2f84] = 0x32e1, [0x2f85] = 0x32e2, [0x2f86] = 0x32e3, [0x2f87] = 0x32e4,
  [0x2f88] = 0x32e5, [0x2f89] = 0x32e6, [0x2f8a] = 0x32e7, [0x2f8b] = 0x32e8,
  [0x2f8c] = 0x32e9, [0x2f8d] = 0x32ea, [0x2f8e] = 0x32eb, [0x2f8f] = 0x32ec,
  [0x2f90] = 0x32ed, [0x2f91] = 0x32ee, [0x2f92] = 0x32ef, [0x2f93] = 0x32f0,
  [0x2f94] = 0x32f1, [0x2f95] = 0x32f2, [0x2f96] = 0x32f3, [0x2f97] = 0x32f4,
  [0x2f98] = 0x32f5, [0x2f99] = 0x32f6, [0x2f9a] = 0x32f7, [0x2f9b] = 0x32f8,
  [0x2f9c] = 0x32f9, [0x2f9d] = 0x32fa, [0x2f9e] = 0x32fb, [0x2f9f] = 0x32fc,
  [0x2fa0] = 0x32fd, [0x2fa1] = 0x32fe, [0x2fa3] = 0x3300,
  [0x2fa4] = 0x3301, [0x2fa5] = 0x3302, [0x2fa6] = 0x3303, [0x2fa7] = 0x3304,
  [0x2fa8] = 0x3305, [0x2fa9] = 0x3306, [0x2faa] = 0x3307, [0x2fab] = 0x3308,
  [0x2fac] = 0x3309, [0x2fad] = 0x330a, [0x2fae] = 0x330b, [0x2faf] = 0x330c,
  [0x2fb0] = 0x330d, [0x2fb1] = 0x330e, [0x2fb2] = 0x330f, [0x2fb3] = 0x3310,
  [0x2fb4] = 0x3311, [0x2fb5] = 0x3312, [0x2fb6] = 0x3313, [0x2fb7] = 0x3314,
  [0x2fb8] = 0x3315, [0x2fb9] = 0x3316, [0x2fba] = 0x3317, [0x2fbb] = 0x3318,
  [0x2fbc] = 0x3319, [0x2fbd] = 0x331a, [0x2fbe] = 0x331b, [0x2fbf] = 0x331c,
  [0x2fc0] = 0x331d, [0x2fc1] = 0x331e, [0x2fc2] = 0x331f, [0x2fc3] = 0x3320,
  [0x2fc4] = 0x3321, [0x2fc5] = 0x3322, [0x2fc6] = 0x3323, [0x2fc7] = 0x3324,
  [0x2fc8] = 0x3325, [0x2fc9] = 0x3326, [0x2fca] = 0x3327, [0x2fcb] = 0x3328,
  [0x2fcc] = 0x3329, [0x2fcd] = 0x332a, [0x2fce] = 0x332b, [0x2fcf] = 0x332c,
  [0x2fd0] = 0x332d, [0x2fd1] = 0x332e, [0x2fd2] = 0x332f, [0x2fd3] = 0x3330,
  [0x2fd4] = 0x3331, [0x2fd5] = 0x3332, [0x2fd6] = 0x3333, [0x2fd7] = 0x3334,
  [0x2fd8] = 0x3335, [0x2fd9] = 0x3336, [0x2fda] = 0x3337, [0x2fdb] = 0x3338,
  [0x2fdc] = 0x3339, [0x2fdd] = 0x333a, [0x2fde] = 0x333b, [0x2fdf] = 0x333c,
  [0x2fe0] = 0x333d, [0x2fe1] = 0x333e, [0x2fe2] = 0x333f, [0x2fe3] = 0x3340,
  [0x2fe4] = 0x3341, [0x2fe5] = 0x3342, [0x2fe6] = 0x3343, [0x2fe7] = 0x3344,
  [0x2fe8] = 0x3345, [0x2fe9] = 0x3346, [0x2fea] = 0x3347, [0x2feb] = 0x3348,
  [0x2fec] = 0x3349, [0x2fed] = 0x334a, [0x2fee] = 0x334b, [0x2fef] = 0x334c,
  [0x2ff0] = 0x334d, [0x2ff1] = 0x334e, [0x2ff2] = 0x334f, [0x2ff3] = 0x3350,
  [0x2ff4] = 0x3351, [0x2ff5] = 0x3352, [0x2ff6] = 0x3353, [0x2ff7] = 0x3354,
  [0x2ff8] = 0x3355, [0x2ff9] = 0x3356, [0x2ffa] = 0x3357, [0x2ffb] = 0x3358,
  [0x2ffc] = 0x3359, [0x2ffd] = 0x335a, [0x2ffe] = 0x335b, [0x2fff] = 0x335c,
  [0x3000] = 0x335d, [0x3001] = 0x335e, [0x3002] = 0x335f, [0x3003] = 0x3360,
  [0x3004] = 0x3361, [0x3005] = 0x3362, [0x3006] = 0x3363, [0x3007] = 0x3364,
  [0x3008] = 0x3365, [0x3009] = 0x3366, [0x300a] = 0x3367, [0x300b] = 0x3368,
  [0x300c] = 0x3369, [0x300d] = 0x336a, [0x300e] = 0x336b, [0x300f] = 0x336c,
  [0x3010] = 0x336d, [0x3011] = 0x336e, [0x3012] = 0x336f, [0x3013] = 0x3370,
  [0x3014] = 0x3371, [0x3015] = 0x3372, [0x3016] = 0x3373, [0x3017] = 0x3374,
  [0x3018] = 0x3375, [0x3019] = 0x3376, [0x301e] = 0x337b, [0x301f] = 0x337c,
  [0x3020] = 0x337d, [0x3021] = 0x337e, [0x3022] = 0x337f, [0x3023] = 0x3380,
  [0x3024] = 0x3381, [0x3025] = 0x3382, [0x3026] = 0x3383, [0x3027] = 0x3384,
  [0x3028] = 0x3385, [0x3029] = 0x3386, [0x302a] = 0x3387, [0x302b] = 0x3388,
  [0x302c] = 0x3389, [0x302d] = 0x338a, [0x302e] = 0x338b, [0x302f] = 0x338c,
  [0x3030] = 0x338d, [0x3031] = 0x3390, [0x3032] = 0x3391, [0x3033] = 0x3392,
  [0x3034] = 0x3393, [0x3035] = 0x3394, [0x3036] = 0x3395, [0x3037] = 0x3396,
  [0x3038] = 0x3397, [0x3039] = 0x3398, [0x303a] = 0x3399, [0x303b] = 0x339a,
  [0x303c] = 0x339b, [0x303d] = 0x339f, [0x303e] = 0x33a0, [0x303f] = 0x33a2,
  [0x3040] = 0x33a3, [0x3041] = 0x33a4, [0x3042] = 0x33a5, [0x3043] = 0x33a6,
  [0x3044] = 0x33a7, [0x3045] = 0x33a8, [0x3046] = 0x33a9, [0x3047] = 0x33aa,
  [0x3048] = 0x33ab, [0x3049] = 0x33ac, [0x304a] = 0x33ad, [0x304b] = 0x33ae,
  [0x304c] = 0x33af, [0x304d] = 0x33b0, [0x304e] = 0x33b1, [0x304f] = 0x33b2,
  [0x3050] = 0x33b3, [0x3051] = 0x33b4, [0x3052] = 0x33b5, [0x3053] = 0x33b6,
  [0x3054] = 0x33b7, [0x3055] = 0x33b8, [0x3056] = 0x33b9, [0x3057] = 0x33ba,
  [0x3058] = 0x33bb, [0x3059] = 0x33bc, [0x305a] = 0x33bd, [0x305b] = 0x33be,
  [0x305c] = 0x33bf, [0x305d] = 0x33c0, [0x305e] = 0x33c1, [0x305f] = 0x33c2,
  [0x3060] = 0x33c3, [0x3061] = 0x33c5, [0x3062] = 0x33c6, [0x3063] = 0x33c7,
  [0x3064] = 0x33c8, [0x3065] = 0x33c9, [0x3066] = 0x33ca, [0x3067] = 0x33cb,
  [0x3068] = 0x33cc, [0x3069] = 0x33cd, [0x306a] = 0x33cf, [0x306b] = 0x33d0,
  [0x306c] = 0x33d3, [0x306d] = 0x33d4, [0x306e] = 0x33d6, [0x306f] = 0x33d7,
  [0x3070] = 0x33d8, [0x3071] = 0x33d9, [0x3072] = 0x33da, [0x3073] = 0x33db,
  [0x3074] = 0x33dc, [0x3075] = 0x33dd,
  [0x3078] = 0x33e0, [0x3079] = 0x33e1, [0x307a] = 0x33e2, [0x307b] = 0x33e3,
  [0x307c] = 0x33e4, [0x307d] = 0x33e5, [0x307e] = 0x33e6, [0x307f] = 0x33e7,
  [0x3080] = 0x33e8, [0x3081] = 0x33e9, [0x3082] = 0x33ea, [0x3083] = 0x33eb,
  [0x3084] = 0x33ec, [0x3085] = 0x33ed, [0x3086] = 0x33ee, [0x3087] = 0x33ef,
  [0x3088] = 0x33f0, [0x3089] = 0x33f1, [0x308a] = 0x33f2, [0x308b] = 0x33f3,
  [0x308c] = 0x33f4, [0x308d] = 0x33f5, [0x308e] = 0x33f6, [0x308f] = 0x33f7,
  [0x3090] = 0x33f8, [0x3091] = 0x33f9, [0x3092] = 0x33fa, [0x3093] = 0x33fb,
  [0x3094] = 0x33fc, [0x3095] = 0x33fd, [0x3096] = 0x33fe,
  [0x3098] = 0x3400, [0x3099] = 0x3401, [0x309a] = 0x3402, [0x309b] = 0x3403,
  [0x309c] = 0x3404, [0x309d] = 0x3405, [0x309e] = 0x3406, [0x309f] = 0x3407,
  [0x30a0] = 0x3408, [0x30a1] = 0x3409, [0x30a2] = 0x340a, [0x30a3] = 0x340b,
  [0x30a4] = 0x340c, [0x30a5] = 0x340d, [0x30a6] = 0x340e, [0x30a7] = 0x340f,
  [0x30a8] = 0x3410, [0x30a9] = 0x3411, [0x30aa] = 0x3412, [0x30ab] = 0x3413,
  [0x30ac] = 0x3414, [0x30ad] = 0x3415, [0x30ae] = 0x3416, [0x30af] = 0x3417,
  [0x30b0] = 0x3418, [0x30b1] = 0x3419, [0x30b2] = 0x341a, [0x30b3] = 0x341b,
  [0x30b4] = 0x341c, [0x30b5] = 0x341d, [0x30b6] = 0x341e, [0x30b7] = 0x341f,
  [0x30b8] = 0x3420, [0x30b9] = 0x3421, [0x30ba] = 0x3422, [0x30bb] = 0x3423,
  [0x30bc] = 0x3424, [0x30bd] = 0x3425, [0x30be] = 0x3426, [0x30bf] = 0x3427,
  [0x30c0] = 0x3428, [0x30c1] = 0x3429, [0x30c2] = 0x342a, [0x30c3] = 0x342b,
  [0x30c4] = 0x342c, [0x30c5] = 0x342d, [0x30c6] = 0x342e, [0x30c7] = 0x342f,
  [0x30c8] = 0x3430, [0x30c9] = 0x3431, [0x30ca] = 0x3432, [0x30cb] = 0x3433,
  [0x30cc] = 0x3434, [0x30cd] = 0x3435, [0x30ce] = 0x3436, [0x30cf] = 0x3437,
  [0x30d0] = 0x3438, [0x30d1] = 0x3439, [0x30d2] = 0x343a, [0x30d3] = 0x343b,
  [0x30d4] = 0x343c, [0x30d5] = 0x343d, [0x30d6] = 0x343e, [0x30d7] = 0x343f,
  [0x30d8] = 0x3440, [0x30d9] = 0x3441, [0x30da] = 0x3442, [0x30db] = 0x3443,
  [0x30dc] = 0x3444, [0x30dd] = 0x3445, [0x30de] = 0x3446, [0x30df] = 0x3448,
  [0x30e0] = 0x3449, [0x30e1] = 0x344a, [0x30e2] = 0x344b, [0x30e3] = 0x344c,
  [0x30e4] = 0x344d, [0x30e5] = 0x344e, [0x30e6] = 0x344f, [0x30e7] = 0x3450,
  [0x30e8] = 0x3451, [0x30e9] = 0x3452, [0x30ea] = 0x3453, [0x30eb] = 0x3454,
  [0x30ec] = 0x3455, [0x30ed] = 0x3456, [0x30ee] = 0x3457, [0x30ef] = 0x3458,
  [0x30f0] = 0x3459, [0x30f1] = 0x345a, [0x30f2] = 0x345b, [0x30f3] = 0x345c,
  [0x30f4] = 0x345d, [0x30f5] = 0x345e, [0x30f6] = 0x345f, [0x30f7] = 0x3460,
  [0x30f8] = 0x3461, [0x30f9] = 0x3462, [0x30fa] = 0x3463, [0x30fb] = 0x3464,
  [0x30fc] = 0x3465, [0x30fd] = 0x3466, [0x30fe] = 0x3467, [0x30ff] = 0x3468,
  [0x3100] = 0x3469, [0x3101] = 0x346a, [0x3102] = 0x346b, [0x3103] = 0x346c,
  [0x3104] = 0x346d, [0x3105] = 0x346e, [0x3106] = 0x346f, [0x3107] = 0x3470,
  [0x3108] = 0x3471, [0x3109] = 0x3472, [0x310a] = 0x3474, [0x310b] = 0x3475,
  [0x310c] = 0x3476, [0x310d] = 0x3477, [0x310e] = 0x3478, [0x310f] = 0x3479,
  [0x3110] = 0x347a, [0x3111] = 0x347b, [0x3112] = 0x347c, [0x3113] = 0x347d,
  [0x3114] = 0x347e, [0x3115] = 0x347f, [0x3116] = 0x3480, [0x3117] = 0x3481,
  [0x3118] = 0x3482, [0x3119] = 0x3483, [0x311a] = 0x3484, [0x311b] = 0x3485,
  [0x311c] = 0x3486, [0x311d] = 0x3487, [0x311e] = 0x3488, [0x311f] = 0x3489,
  [0x3120] = 0x348a, [0x3121] = 0x348b, [0x3122] = 0x348c, [0x3123] = 0x348d,
  [0x3124] = 0x348e, [0x3125] = 0x348f, [0x3126] = 0x3490, [0x3127] = 0x3491,
  [0x3128] = 0x3492, [0x3129] = 0x3493, [0x312a] = 0x3494, [0x312b] = 0x3495,
  [0x312c] = 0x3496, [0x312d] = 0x3497, [0x312e] = 0x3498, [0x312f] = 0x3499,
  [0x3130] = 0x349a, [0x3131] = 0x349b, [0x3132] = 0x349c, [0x3133] = 0x349d,
  [0x3134] = 0x349e, [0x3135] = 0x349f, [0x3136] = 0x34a0, [0x3137] = 0x34a1,
  [0x3138] = 0x34a2, [0x3139] = 0x34a3, [0x313a] = 0x34a4, [0x313b] = 0x34a5,
  [0x313c] = 0x34a6, [0x313d] = 0x34a7, [0x313e] = 0x34a8, [0x313f] = 0x34a9,
  [0x3140] = 0x34aa, [0x3141] = 0x34ab, [0x3142] = 0x34ac, [0x3143] = 0x34ad,
  [0x3144] = 0x34ae, [0x3145] = 0x34af, [0x3146] = 0x34b0, [0x3147] = 0x34b1,
  [0x3148] = 0x34b2, [0x3149] = 0x34b3, [0x314a] = 0x34b4, [0x314b] = 0x34b5,
  [0x314c] = 0x34b6, [0x314d] = 0x34b7, [0x314e] = 0x34b8, [0x314f] = 0x34b9,
  [0x3150] = 0x34ba, [0x3151] = 0x34bb, [0x3152] = 0x34bc, [0x3153] = 0x34bd,
  [0x3154] = 0x34be, [0x3155] = 0x34bf, [0x3156] = 0x34c0, [0x3157] = 0x34c1,
  [0x3158] = 0x34c2, [0x3159] = 0x34c3, [0x315a] = 0x34c4, [0x315b] = 0x34c5,
  [0x315c] = 0x34c6, [0x315d] = 0x34c7, [0x315e] = 0x34c8, [0x315f] = 0x34c9,
  [0x3160] = 0x34ca, [0x3161] = 0x34cb, [0x3162] = 0x34cc, [0x3163] = 0x34cd,
  [0x3164] = 0x34ce, [0x3165] = 0x34cf, [0x3166] = 0x34d0, [0x3167] = 0x34d1,
  [0x3168] = 0x34d2, [0x3169] = 0x34d3, [0x316a] = 0x34d4, [0x316b] = 0x34d5,
  [0x316c] = 0x34d6, [0x316d] = 0x34d7, [0x316e] = 0x34d8, [0x316f] = 0x34d9,
  [0x3170] = 0x34da, [0x3171] = 0x34db, [0x3172] = 0x34dc, [0x3173] = 0x34dd,
  [0x3174] = 0x34de, [0x3175] = 0x34df, [0x3176] = 0x34e0, [0x3177] = 0x34e1,
  [0x3178] = 0x34e2, [0x3179] = 0x34e3, [0x317a] = 0x34e4, [0x317b] = 0x34e5,
  [0x317c] = 0x34e6, [0x317d] = 0x34e7, [0x317e] = 0x34e8, [0x317f] = 0x34e9,
  [0x3180] = 0x34ea, [0x3181] = 0x34eb, [0x3182] = 0x34ec, [0x3183] = 0x34ed,
  [0x3184] = 0x34ee, [0x3185] = 0x34ef, [0x3186] = 0x34f0, [0x3187] = 0x34f1,
  [0x3188] = 0x34f2, [0x3189] = 0x34f3, [0x318a] = 0x34f4, [0x318b] = 0x34f5,
  [0x318c] = 0x34f6, [0x318d] = 0x34f7, [0x318e] = 0x34f8, [0x318f] = 0x34f9,
  [0x3190] = 0x34fa, [0x3191] = 0x34fb, [0x3192] = 0x34fc, [0x3193] = 0x34fd,
  [0x3194] = 0x34fe, [0x3195] = 0x34ff, [0x3196] = 0x3500, [0x3197] = 0x3501,
  [0x3198] = 0x3502, [0x3199] = 0x3503, [0x319a] = 0x3504, [0x319b] = 0x3505,
  [0x319c] = 0x3506, [0x319d] = 0x3507, [0x319e] = 0x3508, [0x319f] = 0x3509,
  [0x31a0] = 0x350a, [0x31a1] = 0x350b, [0x31a2] = 0x350c, [0x31a3] = 0x350d,
  [0x31a4] = 0x350e, [0x31a5] = 0x350f, [0x31a6] = 0x3510, [0x31a7] = 0x3511,
  [0x31a8] = 0x3512, [0x31a9] = 0x3513, [0x31aa] = 0x3514, [0x31ab] = 0x3515,
  [0x31ac] = 0x3516, [0x31ad] = 0x3517, [0x31ae] = 0x3518, [0x31af] = 0x3519,
  [0x31b0] = 0x351a, [0x31b1] = 0x351b, [0x31b2] = 0x351c, [0x31b3] = 0x351d,
  [0x31b4] = 0x351e, [0x31b5] = 0x351f, [0x31b6] = 0x3520, [0x31b7] = 0x3521,
  [0x31b8] = 0x3522, [0x31b9] = 0x3523, [0x31ba] = 0x3524, [0x31bb] = 0x3525,
  [0x31bc] = 0x3526, [0x31bd] = 0x3527, [0x31be] = 0x3528, [0x31bf] = 0x3529,
  [0x31c0] = 0x352a, [0x31c1] = 0x352b, [0x31c2] = 0x352c, [0x31c3] = 0x352d,
  [0x31c4] = 0x352e, [0x31c5] = 0x352f, [0x31c6] = 0x3530, [0x31c7] = 0x3531,
  [0x31c8] = 0x3532, [0x31c9] = 0x3533, [0x31ca] = 0x3534, [0x31cb] = 0x3535,
  [0x31cc] = 0x3536, [0x31cd] = 0x3537, [0x31ce] = 0x3538, [0x31cf] = 0x3539,
  [0x31d0] = 0x353a, [0x31d1] = 0x353b, [0x31d2] = 0x353c, [0x31d3] = 0x353d,
  [0x31d4] = 0x353e, [0x31d5] = 0x353f, [0x31d6] = 0x3540, [0x31d7] = 0x3541,
  [0x31d8] = 0x3542, [0x31d9] = 0x3543, [0x31da] = 0x3544, [0x31db] = 0x3545,
  [0x31dc] = 0x3546, [0x31dd] = 0x3547, [0x31de] = 0x3548, [0x31df] = 0x3549,
  [0x31e0] = 0x354a, [0x31e1] = 0x354b, [0x31e2] = 0x354c, [0x31e3] = 0x354d,
  [0x31e4] = 0x354e, [0x31e5] = 0x354f, [0x31e6] = 0x3550, [0x31e7] = 0x3551,
  [0x31e8] = 0x3552, [0x31e9] = 0x3553, [0x31ea] = 0x3554, [0x31eb] = 0x3555,
  [0x31ec] = 0x3556, [0x31ed] = 0x3557, [0x31ee] = 0x3558, [0x31ef] = 0x3559,
  [0x31f0] = 0x355a, [0x31f1] = 0x355b, [0x31f2] = 0x355c, [0x31f3] = 0x355d,
  [0x31f4] = 0x355e, [0x31f5] = 0x355f, [0x31f6] = 0x3560, [0x31f7] = 0x3561,
  [0x31f8] = 0x3562, [0x31f9] = 0x3563, [0x31fa] = 0x3564, [0x31fb] = 0x3565,
  [0x31fc] = 0x3566, [0x31fd] = 0x3567, [0x31fe] = 0x3568, [0x31ff] = 0x3569,
  [0x3200] = 0x356a, [0x3201] = 0x356b, [0x3202] = 0x356c, [0x3203] = 0x356d,
  [0x3204] = 0x356e, [0x3205] = 0x356f, [0x3206] = 0x3570, [0x3207] = 0x3571,
  [0x3208] = 0x3572, [0x3209] = 0x3573, [0x320a] = 0x3574, [0x320b] = 0x3575,
  [0x320c] = 0x3576, [0x320d] = 0x3577, [0x320e] = 0x3578, [0x320f] = 0x3579,
  [0x3210] = 0x357a, [0x3211] = 0x357b, [0x3212] = 0x357c, [0x3213] = 0x357d,
  [0x3214] = 0x357e, [0x3215] = 0x357f, [0x3216] = 0x3580, [0x3217] = 0x3581,
  [0x3218] = 0x3582, [0x3219] = 0x3583, [0x321a] = 0x3584, [0x321b] = 0x3585,
  [0x321c] = 0x3586, [0x321d] = 0x3587, [0x321e] = 0x3588, [0x321f] = 0x3589,
  [0x3220] = 0x358a, [0x3221] = 0x358b, [0x3222] = 0x358c, [0x3223] = 0x358d,
  [0x3224] = 0x358e, [0x3225] = 0x358f, [0x3226] = 0x3590, [0x3227] = 0x3591,
  [0x3228] = 0x3592, [0x3229] = 0x3593, [0x322a] = 0x3594, [0x322b] = 0x3595,
  [0x322c] = 0x3596, [0x322d] = 0x3597, [0x322e] = 0x3598, [0x322f] = 0x3599,
  [0x3230] = 0x359a, [0x3231] = 0x359b, [0x3232] = 0x359c, [0x3233] = 0x359d,
  [0x3234] = 0x359f, [0x3235] = 0x35a0, [0x3236] = 0x35a1, [0x3237] = 0x35a2,
  [0x3238] = 0x35a3, [0x3239] = 0x35a4, [0x323a] = 0x35a5, [0x323b] = 0x35a6,
  [0x323c] = 0x35a7, [0x323d] = 0x35a8, [0x323e] = 0x35a9, [0x323f] = 0x35aa,
  [0x3240] = 0x35ab, [0x3241] = 0x35ac, [0x3242] = 0x35ad, [0x3243] = 0x35ae,
  [0x3244] = 0x35af, [0x3245] = 0x35b0, [0x3246] = 0x35b1, [0x3247] = 0x35b2,
  [0x3248] = 0x35b3, [0x3249] = 0x35b4, [0x324a] = 0x35b5, [0x324b] = 0x35b6,
  [0x324c] = 0x35b7, [0x324d] = 0x35b8, [0x324e] = 0x35b9, [0x324f] = 0x35ba,
  [0x3250] = 0x35bb, [0x3251] = 0x35bc, [0x3252] = 0x35bd, [0x3253] = 0x35be,
  [0x3254] = 0x35bf, [0x3255] = 0x35c0, [0x3256] = 0x35c1, [0x3257] = 0x35c2,
  [0x3258] = 0x35c3, [0x3259] = 0x35c4, [0x325a] = 0x35c5, [0x325b] = 0x35c6,
  [0x325c] = 0x35c7, [0x325d] = 0x35c8, [0x325e] = 0x35c9, [0x325f] = 0x35ca,
  [0x3260] = 0x35cb, [0x3261] = 0x35cc, [0x3262] = 0x35cd, [0x3263] = 0x35ce,
  [0x3264] = 0x35cf, [0x3265] = 0x35d0, [0x3266] = 0x35d1, [0x3267] = 0x35d2,
  [0x3268] = 0x35d3, [0x3269] = 0x35d4, [0x326a] = 0x35d5, [0x326b] = 0x35d6,
  [0x326c] = 0x35d7, [0x326d] = 0x35d8, [0x326e] = 0x35d9, [0x326f] = 0x35da,
  [0x3270] = 0x35db, [0x3271] = 0x35dc, [0x3272] = 0x35dd, [0x3273] = 0x35de,
  [0x3274] = 0x35df, [0x3275] = 0x35e0, [0x3276] = 0x35e1, [0x3277] = 0x35e2,
  [0x3278] = 0x35e3, [0x3279] = 0x35e4, [0x327a] = 0x35e5, [0x327b] = 0x35e6,
  [0x327c] = 0x35e7, [0x327d] = 0x35e8, [0x327e] = 0x35e9, [0x327f] = 0x35ea,
  [0x3280] = 0x35eb, [0x3281] = 0x35ec, [0x3282] = 0x35ed, [0x3283] = 0x35ee,
  [0x3284] = 0x35ef, [0x3285] = 0x35f0, [0x3286] = 0x35f1, [0x3287] = 0x35f2,
  [0x3288] = 0x35f3, [0x3289] = 0x35f4, [0x328a] = 0x35f5, [0x328b] = 0x35f6,
  [0x328c] = 0x35f7, [0x328d] = 0x35f8, [0x328e] = 0x35f9, [0x328f] = 0x35fa,
  [0x3290] = 0x35fb, [0x3291] = 0x35fc, [0x3292] = 0x35fd, [0x3293] = 0x35fe,
  [0x3294] = 0x35ff, [0x3295] = 0x3600, [0x3296] = 0x3601, [0x3297] = 0x3602,
  [0x3298] = 0x3603, [0x3299] = 0x3604, [0x329a] = 0x3605, [0x329b] = 0x3606,
  [0x329c] = 0x3607, [0x329d] = 0x3608, [0x329e] = 0x3609, [0x329f] = 0x360a,
  [0x32a0] = 0x360b, [0x32a1] = 0x360c, [0x32a2] = 0x360d, [0x32a3] = 0x360f,
  [0x32a4] = 0x3610, [0x32a5] = 0x3611, [0x32a6] = 0x3612, [0x32a7] = 0x3613,
  [0x32a8] = 0x3614, [0x32a9] = 0x3615, [0x32aa] = 0x3616, [0x32ab] = 0x3617,
  [0x32ac] = 0x3618, [0x32ad] = 0x3619, [0x32ae] = 0x361b, [0x32af] = 0x361c,
  [0x32b0] = 0x361d, [0x32b1] = 0x361e, [0x32b2] = 0x361f, [0x32b3] = 0x3620,
  [0x32b4] = 0x3621, [0x32b5] = 0x3622, [0x32b6] = 0x3623, [0x32b7] = 0x3624,
  [0x32b8] = 0x3625, [0x32b9] = 0x3626, [0x32ba] = 0x3627, [0x32bb] = 0x3628,
  [0x32bc] = 0x3629, [0x32bd] = 0x362a, [0x32be] = 0x362b, [0x32bf] = 0x362c,
  [0x32c0] = 0x362d, [0x32c1] = 0x362e, [0x32c2] = 0x362f, [0x32c3] = 0x3630,
  [0x32c4] = 0x3631, [0x32c5] = 0x3632, [0x32c6] = 0x3633, [0x32c7] = 0x3634,
  [0x32c8] = 0x3635, [0x32c9] = 0x3636, [0x32ca] = 0x3637, [0x32cb] = 0x3638,
  [0x32cc] = 0x3639, [0x32cd] = 0x363a, [0x32ce] = 0x363b, [0x32cf] = 0x363c,
  [0x32d0] = 0x363d, [0x32d1] = 0x363e, [0x32d2] = 0x363f, [0x32d3] = 0x3640,
  [0x32d4] = 0x3641, [0x32d5] = 0x3642, [0x32d6] = 0x3643, [0x32d7] = 0x3644,
  [0x32d8] = 0x3645, [0x32d9] = 0x3646, [0x32da] = 0x3647, [0x32db] = 0x3648,
  [0x32dc] = 0x3649, [0x32dd] = 0x364a, [0x32de] = 0x364b, [0x32df] = 0x364c,
  [0x32e0] = 0x364d, [0x32e1] = 0x364e, [0x32e2] = 0x364f, [0x32e3] = 0x3650,
  [0x32e4] = 0x3651, [0x32e5] = 0x3652, [0x32e6] = 0x3653, [0x32e7] = 0x3654,
  [0x32e8] = 0x3655, [0x32e9] = 0x3656, [0x32ea] = 0x3657, [0x32eb] = 0x3658,
  [0x32ec] = 0x3659, [0x32ed] = 0x365a, [0x32ee] = 0x365b, [0x32ef] = 0x365c,
  [0x32f0] = 0x365d, [0x32f1] = 0x365e, [0x32f2] = 0x365f, [0x32f3] = 0x3660,
  [0x32f4] = 0x3661, [0x32f5] = 0x3662, [0x32f6] = 0x3663, [0x32f7] = 0x3664,
  [0x32f8] = 0x3665, [0x32f9] = 0x3666, [0x32fa] = 0x3667, [0x32fb] = 0x3668,
  [0x32fc] = 0x3669, [0x32fd] = 0x366a, [0x32fe] = 0x366b, [0x32ff] = 0x366c,
  [0x3300] = 0x366d, [0x3301] = 0x366e, [0x3302] = 0x366f, [0x3303] = 0x3670,
  [0x3304] = 0x3671, [0x3305] = 0x3672, [0x3306] = 0x3673, [0x3307] = 0x3674,
  [0x3308] = 0x3675, [0x3309] = 0x3676, [0x330a] = 0x3677, [0x330b] = 0x3678,
  [0x330c] = 0x3679, [0x330d] = 0x367a, [0x330e] = 0x367b, [0x330f] = 0x367c,
  [0x3310] = 0x367d, [0x3311] = 0x367e, [0x3312] = 0x367f, [0x3313] = 0x3680,
  [0x3314] = 0x3681, [0x3315] = 0x3682, [0x3316] = 0x3683, [0x3317] = 0x3684,
  [0x3318] = 0x3685, [0x3319] = 0x3686, [0x331a] = 0x3687, [0x331b] = 0x3688,
  [0x331c] = 0x3689, [0x331d] = 0x368a, [0x331e] = 0x368b, [0x331f] = 0x368c,
  [0x3320] = 0x368d, [0x3321] = 0x368e, [0x3322] = 0x368f, [0x3323] = 0x3690,
  [0x3324] = 0x3691, [0x3325] = 0x3692, [0x3326] = 0x3693, [0x3327] = 0x3694,
  [0x3328] = 0x3695, [0x3329] = 0x3696, [0x332a] = 0x3697, [0x332b] = 0x3698,
  [0x332c] = 0x3699, [0x332d] = 0x369a, [0x332e] = 0x369b, [0x332f] = 0x369c,
  [0x3330] = 0x369d, [0x3331] = 0x369e, [0x3332] = 0x369f, [0x3333] = 0x36a0,
  [0x3334] = 0x36a1, [0x3335] = 0x36a2, [0x3336] = 0x36a3, [0x3337] = 0x36a4,
  [0x3338] = 0x36a5, [0x3339] = 0x36a6, [0x333a] = 0x36a7, [0x333b] = 0x36a8,
  [0x333c] = 0x36a9, [0x333d] = 0x36aa, [0x333e] = 0x36ab, [0x333f] = 0x36ac,
  [0x3340] = 0x36ad, [0x3341] = 0x36ae, [0x3342] = 0x36af, [0x3343] = 0x36b0,
  [0x3344] = 0x36b1, [0x3345] = 0x36b2, [0x3346] = 0x36b3, [0x3347] = 0x36b4,
  [0x3348] = 0x36b5, [0x3349] = 0x36b6, [0x334a] = 0x36b7, [0x334b] = 0x36b8,
  [0x334c] = 0x36b9, [0x334d] = 0x36ba, [0x334e] = 0x36bb, [0x334f] = 0x36bc,
  [0x3350] = 0x36bd, [0x3351] = 0x36be, [0x3352] = 0x36bf, [0x3353] = 0x36c0,
  [0x3354] = 0x36c1, [0x3355] = 0x36c2, [0x3356] = 0x36c3, [0x3357] = 0x36c4,
  [0x3358] = 0x36c5, [0x3359] = 0x36c6, [0x335a] = 0x36c7, [0x335b] = 0x36c8,
  [0x335c] = 0x36c9, [0x335d] = 0x36ca, [0x335e] = 0x36cb, [0x335f] = 0x36cc,
  [0x3360] = 0x36cd, [0x3361] = 0x36ce, [0x3362] = 0x36cf, [0x3363] = 0x36d0,
  [0x3364] = 0x36d1, [0x3365] = 0x36d2, [0x3366] = 0x36d3, [0x3367] = 0x36d4,
  [0x3368] = 0x36d5, [0x3369] = 0x36d6, [0x336a] = 0x36d7, [0x336b] = 0x36d8,
  [0x336c] = 0x36d9, [0x336d] = 0x36da, [0x336e] = 0x36db, [0x336f] = 0x36dc,
  [0x3370] = 0x36dd, [0x3371] = 0x36de, [0x3372] = 0x36df, [0x3373] = 0x36e0,
  [0x3374] = 0x36e1, [0x3375] = 0x36e2, [0x3376] = 0x36e3, [0x3377] = 0x36e4,
  [0x3378] = 0x36e5, [0x3379] = 0x36e6, [0x337a] = 0x36e7, [0x337b] = 0x36e8,
  [0x337c] = 0x36e9, [0x337d] = 0x36ea, [0x337e] = 0x36eb, [0x337f] = 0x36ec,
  [0x3380] = 0x36ed, [0x3381] = 0x36ee, [0x3382] = 0x36ef, [0x3383] = 0x36f0,
  [0x3384] = 0x36f1, [0x3385] = 0x36f2, [0x3386] = 0x36f3, [0x3387] = 0x36f4,
  [0x3388] = 0x36f5, [0x3389] = 0x36f6, [0x338a] = 0x36f7, [0x338b] = 0x36f8,
  [0x338c] = 0x36f9, [0x338d] = 0x36fa, [0x338e] = 0x36fb, [0x338f] = 0x36fc,
  [0x3390] = 0x36fd, [0x3391] = 0x36fe, [0x3392] = 0x36ff, [0x3393] = 0x3700,
  [0x3394] = 0x3701, [0x3395] = 0x3702, [0x3396] = 0x3703, [0x3397] = 0x3704,
  [0x3398] = 0x3705, [0x3399] = 0x3706, [0x339a] = 0x3707, [0x339b] = 0x3708,
  [0x339c] = 0x3709, [0x339d] = 0x370a, [0x339e] = 0x370b, [0x339f] = 0x370c,
  [0x33a0] = 0x370d, [0x33a1] = 0x370e, [0x33a2] = 0x370f, [0x33a3] = 0x3710,
  [0x33a4] = 0x3711, [0x33a5] = 0x3712, [0x33a6] = 0x3713, [0x33a7] = 0x3714,
  [0x33a8] = 0x3715, [0x33a9] = 0x3716, [0x33aa] = 0x3717, [0x33ab] = 0x3718,
  [0x33ac] = 0x3719, [0x33ad] = 0x371a, [0x33ae] = 0x371b, [0x33af] = 0x371c,
  [0x33b0] = 0x371d, [0x33b1] = 0x371e, [0x33b2] = 0x371f, [0x33b3] = 0x3720,
  [0x33b4] = 0x3721, [0x33b5] = 0x3722, [0x33b6] = 0x3723, [0x33b7] = 0x3724,
  [0x33b8] = 0x3725, [0x33b9] = 0x3726, [0x33ba] = 0x3727, [0x33bb] = 0x3728,
  [0x33bc] = 0x3729, [0x33bd] = 0x372a, [0x33be] = 0x372b, [0x33bf] = 0x372c,
  [0x33c0] = 0x372d, [0x33c1] = 0x372e, [0x33c2] = 0x372f, [0x33c3] = 0x3730,
  [0x33c4] = 0x3731, [0x33c5] = 0x3732, [0x33c6] = 0x3733, [0x33c7] = 0x3734,
  [0x33c8] = 0x3735, [0x33c9] = 0x3736, [0x33ca] = 0x3737, [0x33cb] = 0x3738,
  [0x33cc] = 0x3739, [0x33cd] = 0x373a, [0x33ce] = 0x373b, [0x33cf] = 0x373c,
  [0x33d0] = 0x373d, [0x33d1] = 0x373e, [0x33d2] = 0x373f, [0x33d3] = 0x3740,
  [0x33d4] = 0x3741, [0x33d5] = 0x3742, [0x33d6] = 0x3743, [0x33d7] = 0x3744,
  [0x33d8] = 0x3745, [0x33d9] = 0x3746, [0x33da] = 0x3747, [0x33db] = 0x3748,
  [0x33dc] = 0x3749, [0x33dd] = 0x374a, [0x33de] = 0x374b, [0x33df] = 0x374c,
  [0x33e0] = 0x374d, [0x33e1] = 0x374e, [0x33e2] = 0x374f, [0x33e3] = 0x3750,
  [0x33e4] = 0x3751, [0x33e5] = 0x3752, [0x33e6] = 0x3753, [0x33e7] = 0x3754,
  [0x33e8] = 0x3755, [0x33e9] = 0x3756, [0x33ea] = 0x3757, [0x33eb] = 0x3758,
  [0x33ec] = 0x3759, [0x33ed] = 0x375a, [0x33ee] = 0x375b, [0x33ef] = 0x375c,
  [0x33f0] = 0x375d, [0x33f1] = 0x375e, [0x33f2] = 0x375f, [0x33f3] = 0x3760,
  [0x33f4] = 0x3761, [0x33f5] = 0x3762, [0x33f6] = 0x3763, [0x33f7] = 0x3764,
  [0x33f8] = 0x3765, [0x33f9] = 0x3766, [0x33fa] = 0x3767, [0x33fb] = 0x3768,
  [0x33fc] = 0x3769, [0x33fd] = 0x376a, [0x33fe] = 0x376b, [0x33ff] = 0x376c,
  [0x3400] = 0x376d, [0x3401] = 0x376e, [0x3402] = 0x376f, [0x3403] = 0x3770,
  [0x3404] = 0x3771, [0x3405] = 0x3772, [0x3406] = 0x3773, [0x3407] = 0x3774,
  [0x3408] = 0x3775, [0x3409] = 0x3776, [0x340a] = 0x3777, [0x340b] = 0x3778,
  [0x340c] = 0x3779, [0x340d] = 0x377a, [0x340e] = 0x377b, [0x340f] = 0x377c,
  [0x3410] = 0x377d, [0x3411] = 0x377e, [0x3412] = 0x377f, [0x3413] = 0x3780,
  [0x3414] = 0x3781, [0x3415] = 0x3782, [0x3416] = 0x3783, [0x3417] = 0x3784,
  [0x3418] = 0x3785, [0x3419] = 0x3786, [0x341a] = 0x3787, [0x341b] = 0x3788,
  [0x341c] = 0x3789, [0x341d] = 0x378a, [0x341e] = 0x378b, [0x341f] = 0x378c,
  [0x3420] = 0x378d, [0x3421] = 0x378e, [0x3422] = 0x378f, [0x3423] = 0x3790,
  [0x3424] = 0x3791, [0x3425] = 0x3792, [0x3426] = 0x3793, [0x3427] = 0x3794,
  [0x3428] = 0x3795, [0x3429] = 0x3796, [0x342a] = 0x3797, [0x342b] = 0x3798,
  [0x342c] = 0x3799, [0x342d] = 0x379a, [0x342e] = 0x379b, [0x342f] = 0x379c,
  [0x3430] = 0x379d, [0x3431] = 0x379e, [0x3432] = 0x379f, [0x3433] = 0x37a0,
  [0x3434] = 0x37a1, [0x3435] = 0x37a2, [0x3436] = 0x37a3, [0x3437] = 0x37a4,
  [0x3438] = 0x37a5, [0x3439] = 0x37a6, [0x343a] = 0x37a7, [0x343b] = 0x37a8,
  [0x343c] = 0x37a9, [0x343d] = 0x37aa, [0x343e] = 0x37ab, [0x343f] = 0x37ac,
  [0x3440] = 0x37ad, [0x3441] = 0x37ae, [0x3442] = 0x37af, [0x3443] = 0x37b0,
  [0x3444] = 0x37b1, [0x3445] = 0x37b2, [0x3446] = 0x37b3, [0x3447] = 0x37b4,
  [0x3448] = 0x37b5, [0x3449] = 0x37b6, [0x344a] = 0x37b7, [0x344b] = 0x37b8,
  [0x344c] = 0x37b9, [0x344d] = 0x37ba, [0x344e] = 0x37bb, [0x344f] = 0x37bc,
  [0x3450] = 0x37bd, [0x3451] = 0x37be, [0x3452] = 0x37bf, [0x3453] = 0x37c0,
  [0x3454] = 0x37c1, [0x3455] = 0x37c2, [0x3456] = 0x37c3, [0x3457] = 0x37c4,
  [0x3458] = 0x37c5, [0x3459] = 0x37c6, [0x345a] = 0x37c7, [0x345b] = 0x37c8,
  [0x345c] = 0x37c9, [0x345d] = 0x37ca, [0x345e] = 0x37cb, [0x345f] = 0x37cc,
  [0x3460] = 0x37cd, [0x3461] = 0x37ce, [0x3462] = 0x37cf, [0x3463] = 0x37d0,
  [0x3464] = 0x37d1, [0x3465] = 0x37d2, [0x3466] = 0x37d3, [0x3467] = 0x37d4,
  [0x3468] = 0x37d5, [0x3469] = 0x37d6, [0x346a] = 0x37d7, [0x346b] = 0x37d8,
  [0x346c] = 0x37d9, [0x346d] = 0x37da, [0x346e] = 0x37db, [0x346f] = 0x37dc,
  [0x3470] = 0x37dd, [0x3471] = 0x37de, [0x3472] = 0x37df, [0x3473] = 0x37e0,
  [0x3474] = 0x37e1, [0x3475] = 0x37e2, [0x3476] = 0x37e3, [0x3477] = 0x37e4,
  [0x3478] = 0x37e5, [0x3479] = 0x37e6, [0x347a] = 0x37e7, [0x347b] = 0x37e8,
  [0x347c] = 0x37e9, [0x347d] = 0x37ea, [0x347e] = 0x37eb, [0x347f] = 0x37ec,
  [0x3480] = 0x37ed, [0x3481] = 0x37ee, [0x3482] = 0x37ef, [0x3483] = 0x37f0,
  [0x3484] = 0x37f1, [0x3485] = 0x37f2, [0x3486] = 0x37f3, [0x3487] = 0x37f4,
  [0x3488] = 0x37f5, [0x3489] = 0x37f6, [0x348a] = 0x37f7, [0x348b] = 0x37f8,
  [0x348c] = 0x37f9, [0x348d] = 0x37fa, [0x348e] = 0x37fb, [0x348f] = 0x37fc,
  [0x3490] = 0x37fd, [0x3491] = 0x37fe, [0x3492] = 0x37ff, [0x3493] = 0x3800,
  [0x3494] = 0x3801, [0x3495] = 0x3802, [0x3496] = 0x3803, [0x3497] = 0x3804,
  [0x3498] = 0x3805, [0x3499] = 0x3806, [0x349a] = 0x3807, [0x349b] = 0x3808,
  [0x349c] = 0x3809, [0x349d] = 0x380a, [0x349e] = 0x380b, [0x349f] = 0x380c,
  [0x34a0] = 0x380d, [0x34a1] = 0x380e, [0x34a2] = 0x380f, [0x34a3] = 0x3810,
  [0x34a4] = 0x3811, [0x34a5] = 0x3812, [0x34a6] = 0x3813, [0x34a7] = 0x3814,
  [0x34a8] = 0x3815, [0x34a9] = 0x3816, [0x34aa] = 0x3817, [0x34ab] = 0x3818,
  [0x34ac] = 0x3819, [0x34ad] = 0x381a, [0x34ae] = 0x381b, [0x34af] = 0x381c,
  [0x34b0] = 0x381d, [0x34b1] = 0x381e, [0x34b2] = 0x381f, [0x34b3] = 0x3820,
  [0x34b4] = 0x3821, [0x34b5] = 0x3822, [0x34b6] = 0x3823, [0x34b7] = 0x3824,
  [0x34b8] = 0x3825, [0x34b9] = 0x3826, [0x34ba] = 0x3827, [0x34bb] = 0x3828,
  [0x34bc] = 0x3829, [0x34bd] = 0x382a, [0x34be] = 0x382b, [0x34bf] = 0x382c,
  [0x34c0] = 0x382d, [0x34c1] = 0x382e, [0x34c2] = 0x382f, [0x34c3] = 0x3830,
  [0x34c4] = 0x3831, [0x34c5] = 0x3832, [0x34c6] = 0x3833, [0x34c7] = 0x3834,
  [0x34c8] = 0x3835, [0x34c9] = 0x3836, [0x34ca] = 0x3837, [0x34cb] = 0x3838,
  [0x34cc] = 0x3839, [0x34cd] = 0x383a, [0x34ce] = 0x383b, [0x34cf] = 0x383c,
  [0x34d0] = 0x383d, [0x34d1] = 0x383e, [0x34d2] = 0x383f, [0x34d3] = 0x3840,
  [0x34d4] = 0x3841, [0x34d5] = 0x3842, [0x34d6] = 0x3843, [0x34d7] = 0x3844,
  [0x34d8] = 0x3845, [0x34d9] = 0x3846, [0x34da] = 0x3847, [0x34db] = 0x3848,
  [0x34dc] = 0x3849, [0x34dd] = 0x384a, [0x34de] = 0x384b, [0x34df] = 0x384c,
  [0x34e0] = 0x384d, [0x34e1] = 0x384e, [0x34e2] = 0x384f, [0x34e3] = 0x3850,
  [0x34e4] = 0x3851, [0x34e5] = 0x3852, [0x34e6] = 0x3853, [0x34e7] = 0x3854,
  [0x34e8] = 0x3855, [0x34e9] = 0x3856, [0x34ea] = 0x3857, [0x34eb] = 0x3858,
  [0x34ec] = 0x3859, [0x34ed] = 0x385a, [0x34ee] = 0x385b, [0x34ef] = 0x385c,
  [0x34f0] = 0x385d, [0x34f1] = 0x385e, [0x34f2] = 0x385f, [0x34f3] = 0x3860,
  [0x34f4] = 0x3861, [0x34f5] = 0x3862, [0x34f6] = 0x3863, [0x34f7] = 0x3864,
  [0x34f8] = 0x3865, [0x34f9] = 0x3866, [0x34fa] = 0x3867, [0x34fb] = 0x3868,
  [0x34fc] = 0x3869, [0x34fd] = 0x386a, [0x34fe] = 0x386b, [0x34ff] = 0x386c,
  [0x3500] = 0x386d, [0x3501] = 0x386e, [0x3502] = 0x386f, [0x3503] = 0x3870,
  [0x3504] = 0x3871, [0x3505] = 0x3872, [0x3506] = 0x3873, [0x3507] = 0x3874,
  [0x3508] = 0x3875, [0x3509] = 0x3876, [0x350a] = 0x3877, [0x350b] = 0x3878,
  [0x350c] = 0x3879, [0x350d] = 0x387a, [0x350e] = 0x387b, [0x350f] = 0x387c,
  [0x3510] = 0x387d, [0x3511] = 0x387e, [0x3512] = 0x387f, [0x3513] = 0x3880,
  [0x3514] = 0x3881, [0x3515] = 0x3882, [0x3516] = 0x3883, [0x3517] = 0x3884,
  [0x3518] = 0x3885, [0x3519] = 0x3886, [0x351a] = 0x3887, [0x351b] = 0x3888,
  [0x351c] = 0x3889, [0x351d] = 0x388a, [0x351e] = 0x388b, [0x351f] = 0x388c,
  [0x3520] = 0x388d, [0x3521] = 0x388e, [0x3522] = 0x388f, [0x3523] = 0x3890,
  [0x3524] = 0x3891, [0x3525] = 0x3892, [0x3526] = 0x3893, [0x3527] = 0x3894,
  [0x3528] = 0x3895, [0x3529] = 0x3896, [0x352a] = 0x3897, [0x352b] = 0x3898,
  [0x352c] = 0x3899, [0x352d] = 0x389a, [0x352e] = 0x389b, [0x352f] = 0x389c,
  [0x3530] = 0x389d, [0x3531] = 0x389e, [0x3532] = 0x389f, [0x3533] = 0x38a0,
  [0x3534] = 0x38a1, [0x3535] = 0x38a2, [0x3536] = 0x38a3, [0x3537] = 0x38a4,
  [0x3538] = 0x38a5, [0x3539] = 0x38a6, [0x353a] = 0x38a7, [0x353b] = 0x38a8,
  [0x353c] = 0x38a9, [0x353d] = 0x38aa, [0x353e] = 0x38ab, [0x353f] = 0x38ac,
  [0x3540] = 0x38ad, [0x3541] = 0x38ae, [0x3542] = 0x38af, [0x3543] = 0x38b0,
  [0x3544] = 0x38b1, [0x3545] = 0x38b2, [0x3546] = 0x38b3, [0x3547] = 0x38b4,
  [0x3548] = 0x38b5, [0x3549] = 0x38b6, [0x354a] = 0x38b7, [0x354b] = 0x38b8,
  [0x354c] = 0x38b9, [0x354d] = 0x38ba, [0x354e] = 0x38bb, [0x354f] = 0x38bc,
  [0x3550] = 0x38bd, [0x3551] = 0x38be, [0x3552] = 0x38bf, [0x3553] = 0x38c0,
  [0x3554] = 0x38c1, [0x3555] = 0x38c2, [0x3556] = 0x38c3, [0x3557] = 0x38c4,
  [0x3558] = 0x38c5, [0x3559] = 0x38c6, [0x355a] = 0x38c7, [0x355b] = 0x38c8,
  [0x355c] = 0x38c9, [0x355d] = 0x38ca, [0x355e] = 0x38cb, [0x355f] = 0x38cc,
  [0x3560] = 0x38cd, [0x3561] = 0x38ce, [0x3562] = 0x38cf, [0x3563] = 0x38d0,
  [0x3564] = 0x38d1, [0x3565] = 0x38d2, [0x3566] = 0x38d3, [0x3567] = 0x38d4,
  [0x3568] = 0x38d5, [0x3569] = 0x38d6, [0x356a] = 0x38d7, [0x356b] = 0x38d8,
  [0x356c] = 0x38d9, [0x356d] = 0x38da, [0x356e] = 0x38db, [0x356f] = 0x38dc,
  [0x3570] = 0x38dd, [0x3571] = 0x38de, [0x3572] = 0x38df, [0x3573] = 0x38e0,
  [0x3574] = 0x38e1, [0x3575] = 0x38e2, [0x3576] = 0x38e3, [0x3577] = 0x38e4,
  [0x3578] = 0x38e5, [0x3579] = 0x38e6, [0x357a] = 0x38e7, [0x357b] = 0x38e8,
  [0x357c] = 0x38e9, [0x357d] = 0x38ea, [0x357e] = 0x38eb, [0x357f] = 0x38ec,
  [0x3580] = 0x38ed, [0x3581] = 0x38ee, [0x3582] = 0x38ef, [0x3583] = 0x38f0,
  [0x3584] = 0x38f1, [0x3585] = 0x38f2, [0x3586] = 0x38f3, [0x3587] = 0x38f4,
  [0x3588] = 0x38f5, [0x3589] = 0x38f6, [0x358a] = 0x38f7, [0x358b] = 0x38f8,
  [0x358c] = 0x38f9, [0x358d] = 0x38fa, [0x358e] = 0x38fb, [0x358f] = 0x38fc,
  [0x3590] = 0x38fd, [0x3591] = 0x38fe, [0x3592] = 0x38ff, [0x3593] = 0x3900,
  [0x3594] = 0x3901, [0x3595] = 0x3902, [0x3596] = 0x3903, [0x3597] = 0x3904,
  [0x3598] = 0x3905, [0x3599] = 0x3906, [0x359a] = 0x3907, [0x359b] = 0x3908,
  [0x359c] = 0x3909, [0x359d] = 0x390a, [0x359e] = 0x390b, [0x359f] = 0x390c,
  [0x35a0] = 0x390d, [0x35a1] = 0x390e, [0x35a2] = 0x390f, [0x35a3] = 0x3910,
  [0x35a4] = 0x3911, [0x35a5] = 0x3912, [0x35a6] = 0x3913, [0x35a7] = 0x3914,
  [0x35a8] = 0x3915, [0x35a9] = 0x3916, [0x35aa] = 0x3917, [0x35ab] = 0x3919,
  [0x35ac] = 0x391a, [0x35ad] = 0x391b, [0x35ae] = 0x391c, [0x35af] = 0x391d,
  [0x35b0] = 0x391e, [0x35b1] = 0x391f, [0x35b2] = 0x3920, [0x35b3] = 0x3921,
  [0x35b4] = 0x3922, [0x35b5] = 0x3923, [0x35b6] = 0x3924, [0x35b7] = 0x3925,
  [0x35b8] = 0x3926, [0x35b9] = 0x3927, [0x35ba] = 0x3928, [0x35bb] = 0x3929,
  [0x35bc] = 0x392a, [0x35bd] = 0x392b, [0x35be] = 0x392c, [0x35bf] = 0x392d,
  [0x35c0] = 0x392e, [0x35c1] = 0x392f, [0x35c2] = 0x3930, [0x35c3] = 0x3931,
  [0x35c4] = 0x3932, [0x35c5] = 0x3933, [0x35c6] = 0x3934, [0x35c7] = 0x3935,
  [0x35c8] = 0x3936, [0x35c9] = 0x3937, [0x35ca] = 0x3938, [0x35cb] = 0x3939,
  [0x35cc] = 0x393a, [0x35cd] = 0x393b, [0x35ce] = 0x393c, [0x35cf] = 0x393d,
  [0x35d0] = 0x393e, [0x35d1] = 0x393f, [0x35d2] = 0x3940, [0x35d3] = 0x3941,
  [0x35d4] = 0x3942, [0x35d5] = 0x3943, [0x35d6] = 0x3944, [0x35d7] = 0x3945,
  [0x35d8] = 0x3946, [0x35d9] = 0x3947, [0x35da] = 0x3948, [0x35db] = 0x3949,
  [0x35dc] = 0x394a, [0x35dd] = 0x394b, [0x35de] = 0x394c, [0x35df] = 0x394d,
  [0x35e0] = 0x394e, [0x35e1] = 0x394f, [0x35e2] = 0x3950, [0x35e3] = 0x3951,
  [0x35e4] = 0x3952, [0x35e5] = 0x3953, [0x35e6] = 0x3954, [0x35e7] = 0x3955,
  [0x35e8] = 0x3956, [0x35e9] = 0x3957, [0x35ea] = 0x3958, [0x35eb] = 0x3959,
  [0x35ec] = 0x395a, [0x35ed] = 0x395b, [0x35ee] = 0x395c, [0x35ef] = 0x395d,
  [0x35f0] = 0x395e, [0x35f1] = 0x395f, [0x35f2] = 0x3960, [0x35f3] = 0x3961,
  [0x35f4] = 0x3962, [0x35f5] = 0x3963, [0x35f6] = 0x3964, [0x35f7] = 0x3965,
  [0x35f8] = 0x3966, [0x35f9] = 0x3967, [0x35fa] = 0x3968, [0x35fb] = 0x3969,
  [0x35fc] = 0x396a, [0x35fd] = 0x396b, [0x35fe] = 0x396c, [0x35ff] = 0x396d,
  [0x3600] = 0x396f, [0x3601] = 0x3970, [0x3602] = 0x3971, [0x3603] = 0x3972,
  [0x3604] = 0x3973, [0x3605] = 0x3974, [0x3606] = 0x3975, [0x3607] = 0x3976,
  [0x3608] = 0x3977, [0x3609] = 0x3978, [0x360a] = 0x3979, [0x360b] = 0x397a,
  [0x360c] = 0x397b, [0x360d] = 0x397c, [0x360e] = 0x397d, [0x360f] = 0x397e,
  [0x3610] = 0x397f, [0x3611] = 0x3980, [0x3612] = 0x3981, [0x3613] = 0x3982,
  [0x3614] = 0x3983, [0x3615] = 0x3984, [0x3616] = 0x3985, [0x3617] = 0x3986,
  [0x3618] = 0x3987, [0x3619] = 0x3988, [0x361a] = 0x3989, [0x361b] = 0x398a,
  [0x361c] = 0x398b, [0x361d] = 0x398c, [0x361e] = 0x398d, [0x361f] = 0x398e,
  [0x3620] = 0x398f, [0x3621] = 0x3990, [0x3622] = 0x3991, [0x3623] = 0x3992,
  [0x3624] = 0x3993, [0x3625] = 0x3994, [0x3626] = 0x3995, [0x3627] = 0x3996,
  [0x3628] = 0x3997, [0x3629] = 0x3998, [0x362a] = 0x3999, [0x362b] = 0x399a,
  [0x362c] = 0x399b, [0x362d] = 0x399c, [0x362e] = 0x399d, [0x362f] = 0x399e,
  [0x3630] = 0x399f, [0x3631] = 0x39a0, [0x3632] = 0x39a1, [0x3633] = 0x39a2,
  [0x3634] = 0x39a3, [0x3635] = 0x39a4, [0x3636] = 0x39a5, [0x3637] = 0x39a6,
  [0x3638] = 0x39a7, [0x3639] = 0x39a8, [0x363a] = 0x39a9, [0x363b] = 0x39aa,
  [0x363c] = 0x39ab, [0x363d] = 0x39ac, [0x363e] = 0x39ad, [0x363f] = 0x39ae,
  [0x3640] = 0x39af, [0x3641] = 0x39b0, [0x3642] = 0x39b1, [0x3643] = 0x39b2,
  [0x3644] = 0x39b3, [0x3645] = 0x39b4, [0x3646] = 0x39b5, [0x3647] = 0x39b6,
  [0x3648] = 0x39b7, [0x3649] = 0x39b8, [0x364a] = 0x39b9, [0x364b] = 0x39ba,
  [0x364c] = 0x39bb, [0x364d] = 0x39bc, [0x364e] = 0x39bd, [0x364f] = 0x39be,
  [0x3650] = 0x39bf, [0x3651] = 0x39c0, [0x3652] = 0x39c1, [0x3653] = 0x39c2,
  [0x3654] = 0x39c3, [0x3655] = 0x39c4, [0x3656] = 0x39c5, [0x3657] = 0x39c6,
  [0x3658] = 0x39c7, [0x3659] = 0x39c8, [0x365a] = 0x39c9, [0x365b] = 0x39ca,
  [0x365c] = 0x39cb, [0x365d] = 0x39cc, [0x365e] = 0x39cd, [0x365f] = 0x39ce,
  [0x3660] = 0x39d1, [0x3661] = 0x39d2, [0x3662] = 0x39d3, [0x3663] = 0x39d4,
  [0x3664] = 0x39d5, [0x3665] = 0x39d6, [0x3666] = 0x39d7, [0x3667] = 0x39d8,
  [0x3668] = 0x39d9, [0x3669] = 0x39da, [0x366a] = 0x39db, [0x366b] = 0x39dc,
  [0x366c] = 0x39dd, [0x366d] = 0x39de, [0x366e] = 0x39e0, [0x366f] = 0x39e1,
  [0x3670] = 0x39e2, [0x3671] = 0x39e3, [0x3672] = 0x39e4, [0x3673] = 0x39e5,
  [0x3674] = 0x39e6, [0x3675] = 0x39e7, [0x3676] = 0x39e8, [0x3677] = 0x39e9,
  [0x3678] = 0x39ea, [0x3679] = 0x39eb, [0x367a] = 0x39ec, [0x367b] = 0x39ed,
  [0x367c] = 0x39ee, [0x367d] = 0x39ef, [0x367e] = 0x39f0, [0x367f] = 0x39f1,
  [0x3680] = 0x39f2, [0x3681] = 0x39f3, [0x3682] = 0x39f4, [0x3683] = 0x39f5,
  [0x3684] = 0x39f6, [0x3685] = 0x39f7, [0x3686] = 0x39f8, [0x3687] = 0x39f9,
  [0x3688] = 0x39fa, [0x3689] = 0x39fb, [0x368a] = 0x39fc, [0x368b] = 0x39fd,
  [0x368c] = 0x39fe, [0x368d] = 0x39ff, [0x368e] = 0x3a00, [0x368f] = 0x3a01,
  [0x3690] = 0x3a02, [0x3691] = 0x3a03, [0x3692] = 0x3a04, [0x3693] = 0x3a05,
  [0x3694] = 0x3a06, [0x3695] = 0x3a07, [0x3696] = 0x3a08, [0x3697] = 0x3a09,
  [0x3698] = 0x3a0a, [0x3699] = 0x3a0b, [0x369a] = 0x3a0c, [0x369b] = 0x3a0d,
  [0x369c] = 0x3a0e, [0x369d] = 0x3a0f, [0x369e] = 0x3a10, [0x369f] = 0x3a11,
  [0x36a0] = 0x3a12, [0x36a1] = 0x3a13, [0x36a2] = 0x3a14, [0x36a3] = 0x3a15,
  [0x36a4] = 0x3a16, [0x36a5] = 0x3a17, [0x36a6] = 0x3a18, [0x36a7] = 0x3a19,
  [0x36a8] = 0x3a1a, [0x36a9] = 0x3a1b, [0x36aa] = 0x3a1c, [0x36ab] = 0x3a1d,
  [0x36ac] = 0x3a1e, [0x36ad] = 0x3a1f, [0x36ae] = 0x3a20, [0x36af] = 0x3a21,
  [0x36b0] = 0x3a22, [0x36b1] = 0x3a23, [0x36b2] = 0x3a24, [0x36b3] = 0x3a25,
  [0x36b4] = 0x3a26, [0x36b5] = 0x3a27, [0x36b6] = 0x3a28, [0x36b7] = 0x3a29,
  [0x36b8] = 0x3a2a, [0x36b9] = 0x3a2b, [0x36ba] = 0x3a2c, [0x36bb] = 0x3a2d,
  [0x36bc] = 0x3a2e, [0x36bd] = 0x3a2f, [0x36be] = 0x3a30, [0x36bf] = 0x3a31,
  [0x36c0] = 0x3a32, [0x36c1] = 0x3a33, [0x36c2] = 0x3a34, [0x36c3] = 0x3a35,
  [0x36c4] = 0x3a36, [0x36c5] = 0x3a37, [0x36c6] = 0x3a38, [0x36c7] = 0x3a39,
  [0x36c8] = 0x3a3a, [0x36c9] = 0x3a3b, [0x36ca] = 0x3a3c, [0x36cb] = 0x3a3d,
  [0x36cc] = 0x3a3e, [0x36cd] = 0x3a3f, [0x36ce] = 0x3a40, [0x36cf] = 0x3a41,
  [0x36d0] = 0x3a42, [0x36d1] = 0x3a43, [0x36d2] = 0x3a44, [0x36d3] = 0x3a45,
  [0x36d4] = 0x3a46, [0x36d5] = 0x3a47, [0x36d6] = 0x3a48, [0x36d7] = 0x3a49,
  [0x36d8] = 0x3a4a, [0x36d9] = 0x3a4b, [0x36da] = 0x3a4c, [0x36db] = 0x3a4d,
  [0x36dc] = 0x3a4e, [0x36dd] = 0x3a4f, [0x36de] = 0x3a50, [0x36df] = 0x3a51,
  [0x36e0] = 0x3a52, [0x36e1] = 0x3a53, [0x36e2] = 0x3a54, [0x36e3] = 0x3a55,
  [0x36e4] = 0x3a56, [0x36e5] = 0x3a57, [0x36e6] = 0x3a58, [0x36e7] = 0x3a59,
  [0x36e8] = 0x3a5a, [0x36e9] = 0x3a5b, [0x36ea] = 0x3a5c, [0x36eb] = 0x3a5d,
  [0x36ec] = 0x3a5e, [0x36ed] = 0x3a5f, [0x36ee] = 0x3a60, [0x36ef] = 0x3a61,
  [0x36f0] = 0x3a62, [0x36f1] = 0x3a63, [0x36f2] = 0x3a64, [0x36f3] = 0x3a65,
  [0x36f4] = 0x3a66, [0x36f5] = 0x3a67, [0x36f6] = 0x3a68, [0x36f7] = 0x3a69,
  [0x36f8] = 0x3a6a, [0x36f9] = 0x3a6b, [0x36fa] = 0x3a6c, [0x36fb] = 0x3a6d,
  [0x36fc] = 0x3a6e, [0x36fd] = 0x3a6f, [0x36fe] = 0x3a70, [0x36ff] = 0x3a71,
  [0x3700] = 0x3a72, [0x3701] = 0x3a74, [0x3702] = 0x3a75, [0x3703] = 0x3a76,
  [0x3704] = 0x3a77, [0x3705] = 0x3a78, [0x3706] = 0x3a79, [0x3707] = 0x3a7a,
  [0x3708] = 0x3a7b, [0x3709] = 0x3a7c, [0x370a] = 0x3a7d, [0x370b] = 0x3a7e,
  [0x370c] = 0x3a7f, [0x370d] = 0x3a80, [0x370e] = 0x3a81, [0x370f] = 0x3a82,
  [0x3710] = 0x3a83, [0x3711] = 0x3a84, [0x3712] = 0x3a85, [0x3713] = 0x3a86,
  [0x3714] = 0x3a87, [0x3715] = 0x3a88, [0x3716] = 0x3a89, [0x3717] = 0x3a8a,
  [0x3718] = 0x3a8b, [0x3719] = 0x3a8c, [0x371a] = 0x3a8d, [0x371b] = 0x3a8e,
  [0x371c] = 0x3a8f, [0x371d] = 0x3a90, [0x371e] = 0x3a91, [0x371f] = 0x3a92,
  [0x3720] = 0x3a93, [0x3721] = 0x3a94, [0x3722] = 0x3a95, [0x3723] = 0x3a96,
  [0x3724] = 0x3a97, [0x3725] = 0x3a98, [0x3726] = 0x3a99, [0x3727] = 0x3a9a,
  [0x3728] = 0x3a9b, [0x3729] = 0x3a9c, [0x372a] = 0x3a9d, [0x372b] = 0x3a9e,
  [0x372c] = 0x3a9f, [0x372d] = 0x3aa0, [0x372e] = 0x3aa1, [0x372f] = 0x3aa2,
  [0x3730] = 0x3aa3, [0x3731] = 0x3aa4, [0x3732] = 0x3aa5, [0x3733] = 0x3aa6,
  [0x3734] = 0x3aa7, [0x3735] = 0x3aa8, [0x3736] = 0x3aa9, [0x3737] = 0x3aaa,
  [0x3738] = 0x3aab, [0x3739] = 0x3aac, [0x373a] = 0x3aad, [0x373b] = 0x3aae,
  [0x373c] = 0x3aaf, [0x373d] = 0x3ab0, [0x373e] = 0x3ab1, [0x373f] = 0x3ab2,
  [0x3740] = 0x3ab3, [0x3741] = 0x3ab4, [0x3742] = 0x3ab5, [0x3743] = 0x3ab6,
  [0x3744] = 0x3ab7, [0x3745] = 0x3ab8, [0x3746] = 0x3ab9, [0x3747] = 0x3aba,
  [0x3748] = 0x3abb, [0x3749] = 0x3abc, [0x374a] = 0x3abd, [0x374b] = 0x3abe,
  [0x374c] = 0x3abf, [0x374d] = 0x3ac0, [0x374e] = 0x3ac1, [0x374f] = 0x3ac2,
  [0x3750] = 0x3ac3, [0x3751] = 0x3ac4, [0x3752] = 0x3ac5, [0x3753] = 0x3ac6,
  [0x3754] = 0x3ac7, [0x3755] = 0x3ac8, [0x3756] = 0x3ac9, [0x3757] = 0x3aca,
  [0x3758] = 0x3acb, [0x3759] = 0x3acc, [0x375a] = 0x3acd, [0x375b] = 0x3ace,
  [0x375c] = 0x3acf, [0x375d] = 0x3ad0, [0x375e] = 0x3ad1, [0x375f] = 0x3ad2,
  [0x3760] = 0x3ad3, [0x3761] = 0x3ad4, [0x3762] = 0x3ad5, [0x3763] = 0x3ad6,
  [0x3764] = 0x3ad7, [0x3765] = 0x3ad8, [0x3766] = 0x3ad9, [0x3767] = 0x3ada,
  [0x3768] = 0x3adb, [0x3769] = 0x3adc, [0x376a] = 0x3add, [0x376b] = 0x3ade,
  [0x376c] = 0x3adf, [0x376d] = 0x3ae0, [0x376e] = 0x3ae1, [0x376f] = 0x3ae2,
  [0x3770] = 0x3ae3, [0x3771] = 0x3ae4, [0x3772] = 0x3ae5, [0x3773] = 0x3ae6,
  [0x3774] = 0x3ae7, [0x3775] = 0x3ae8, [0x3776] = 0x3ae9, [0x3777] = 0x3aea,
  [0x3778] = 0x3aeb, [0x3779] = 0x3aec, [0x377a] = 0x3aed, [0x377b] = 0x3aee,
  [0x377c] = 0x3aef, [0x377d] = 0x3af0, [0x377e] = 0x3af1, [0x377f] = 0x3af2,
  [0x3780] = 0x3af3, [0x3781] = 0x3af4, [0x3782] = 0x3af5, [0x3783] = 0x3af6,
  [0x3784] = 0x3af7, [0x3785] = 0x3af8, [0x3786] = 0x3af9, [0x3787] = 0x3afa,
  [0x3788] = 0x3afb, [0x3789] = 0x3afc, [0x378a] = 0x3afd, [0x378b] = 0x3afe,
  [0x378c] = 0x3aff, [0x378d] = 0x3b00, [0x378e] = 0x3b01, [0x378f] = 0x3b02,
  [0x3790] = 0x3b03, [0x3791] = 0x3b04, [0x3792] = 0x3b05, [0x3793] = 0x3b06,
  [0x3794] = 0x3b07, [0x3795] = 0x3b08, [0x3796] = 0x3b09, [0x3797] = 0x3b0a,
  [0x3798] = 0x3b0b, [0x3799] = 0x3b0c, [0x379a] = 0x3b0d, [0x379b] = 0x3b0e,
  [0x379c] = 0x3b0f, [0x379d] = 0x3b10, [0x379e] = 0x3b11, [0x379f] = 0x3b12,
  [0x37a0] = 0x3b13, [0x37a1] = 0x3b14, [0x37a2] = 0x3b15, [0x37a3] = 0x3b16,
  [0x37a4] = 0x3b17, [0x37a5] = 0x3b18, [0x37a6] = 0x3b19, [0x37a7] = 0x3b1a,
  [0x37a8] = 0x3b1b, [0x37a9] = 0x3b1c, [0x37aa] = 0x3b1d, [0x37ab] = 0x3b1e,
  [0x37ac] = 0x3b1f, [0x37ad] = 0x3b20, [0x37ae] = 0x3b21, [0x37af] = 0x3b22,
  [0x37b0] = 0x3b23, [0x37b1] = 0x3b24, [0x37b2] = 0x3b25, [0x37b3] = 0x3b26,
  [0x37b4] = 0x3b27, [0x37b5] = 0x3b28, [0x37b6] = 0x3b29, [0x37b7] = 0x3b2a,
  [0x37b8] = 0x3b2b, [0x37b9] = 0x3b2c, [0x37ba] = 0x3b2d, [0x37bb] = 0x3b2e,
  [0x37bc] = 0x3b2f, [0x37bd] = 0x3b30, [0x37be] = 0x3b31, [0x37bf] = 0x3b32,
  [0x37c0] = 0x3b33, [0x37c1] = 0x3b34, [0x37c2] = 0x3b35, [0x37c3] = 0x3b36,
  [0x37c4] = 0x3b37, [0x37c5] = 0x3b38, [0x37c6] = 0x3b39, [0x37c7] = 0x3b3a,
  [0x37c8] = 0x3b3b, [0x37c9] = 0x3b3c, [0x37ca] = 0x3b3d, [0x37cb] = 0x3b3e,
  [0x37cc] = 0x3b3f, [0x37cd] = 0x3b40, [0x37ce] = 0x3b41, [0x37cf] = 0x3b42,
  [0x37d0] = 0x3b43, [0x37d1] = 0x3b44, [0x37d2] = 0x3b45, [0x37d3] = 0x3b46,
  [0x37d4] = 0x3b47, [0x37d5] = 0x3b48, [0x37d6] = 0x3b49, [0x37d7] = 0x3b4a,
  [0x37d8] = 0x3b4b, [0x37d9] = 0x3b4c, [0x37da] = 0x3b4d, [0x37db] = 0x3b4f,
  [0x37dc] = 0x3b50, [0x37dd] = 0x3b51, [0x37de] = 0x3b52, [0x37df] = 0x3b53,
  [0x37e0] = 0x3b54, [0x37e1] = 0x3b55, [0x37e2] = 0x3b56, [0x37e3] = 0x3b57,
  [0x37e4] = 0x3b58, [0x37e5] = 0x3b59, [0x37e6] = 0x3b5a, [0x37e7] = 0x3b5b,
  [0x37e8] = 0x3b5c, [0x37e9] = 0x3b5d, [0x37ea] = 0x3b5e, [0x37eb] = 0x3b5f,
  [0x37ec] = 0x3b60, [0x37ed] = 0x3b61, [0x37ee] = 0x3b62, [0x37ef] = 0x3b63,
  [0x37f0] = 0x3b64, [0x37f1] = 0x3b65, [0x37f2] = 0x3b66, [0x37f3] = 0x3b67,
  [0x37f4] = 0x3b68, [0x37f5] = 0x3b69, [0x37f6] = 0x3b6a, [0x37f7] = 0x3b6b,
  [0x37f8] = 0x3b6c, [0x37f9] = 0x3b6d, [0x37fa] = 0x3b6e, [0x37fb] = 0x3b6f,
  [0x37fc] = 0x3b70, [0x37fd] = 0x3b71, [0x37fe] = 0x3b72, [0x37ff] = 0x3b73,
  [0x3800] = 0x3b74, [0x3801] = 0x3b75, [0x3802] = 0x3b76, [0x3803] = 0x3b77,
  [0x3804] = 0x3b78, [0x3805] = 0x3b79, [0x3806] = 0x3b7a, [0x3807] = 0x3b7b,
  [0x3808] = 0x3b7c, [0x3809] = 0x3b7d, [0x380a] = 0x3b7e, [0x380b] = 0x3b7f,
  [0x380c] = 0x3b80, [0x380d] = 0x3b81, [0x380e] = 0x3b82, [0x380f] = 0x3b83,
  [0x3810] = 0x3b84, [0x3811] = 0x3b85, [0x3812] = 0x3b86, [0x3813] = 0x3b87,
  [0x3814] = 0x3b88, [0x3815] = 0x3b89, [0x3816] = 0x3b8a, [0x3817] = 0x3b8b,
  [0x3818] = 0x3b8c, [0x3819] = 0x3b8d, [0x381a] = 0x3b8e, [0x381b] = 0x3b8f,
  [0x381c] = 0x3b90, [0x381d] = 0x3b91, [0x381e] = 0x3b92, [0x381f] = 0x3b93,
  [0x3820] = 0x3b94, [0x3821] = 0x3b95, [0x3822] = 0x3b96, [0x3823] = 0x3b97,
  [0x3824] = 0x3b98, [0x3825] = 0x3b99, [0x3826] = 0x3b9a, [0x3827] = 0x3b9b,
  [0x3828] = 0x3b9c, [0x3829] = 0x3b9d, [0x382a] = 0x3b9e, [0x382b] = 0x3b9f,
  [0x382c] = 0x3ba0, [0x382d] = 0x3ba1, [0x382e] = 0x3ba2, [0x382f] = 0x3ba3,
  [0x3830] = 0x3ba4, [0x3831] = 0x3ba5, [0x3832] = 0x3ba6, [0x3833] = 0x3ba7,
  [0x3834] = 0x3ba8, [0x3835] = 0x3ba9, [0x3836] = 0x3baa, [0x3837] = 0x3bab,
  [0x3838] = 0x3bac, [0x3839] = 0x3bad, [0x383a] = 0x3bae, [0x383b] = 0x3baf,
  [0x383c] = 0x3bb0, [0x383d] = 0x3bb1, [0x383e] = 0x3bb2, [0x383f] = 0x3bb3,
  [0x3840] = 0x3bb4, [0x3841] = 0x3bb5, [0x3842] = 0x3bb6, [0x3843] = 0x3bb7,
  [0x3844] = 0x3bb8, [0x3845] = 0x3bb9, [0x3846] = 0x3bba, [0x3847] = 0x3bbb,
  [0x3848] = 0x3bbc, [0x3849] = 0x3bbd, [0x384a] = 0x3bbe, [0x384b] = 0x3bbf,
  [0x384c] = 0x3bc0, [0x384d] = 0x3bc1, [0x384e] = 0x3bc2, [0x384f] = 0x3bc3,
  [0x3850] = 0x3bc4, [0x3851] = 0x3bc5, [0x3852] = 0x3bc6, [0x3853] = 0x3bc7,
  [0x3854] = 0x3bc8, [0x3855] = 0x3bc9, [0x3856] = 0x3bca, [0x3857] = 0x3bcb,
  [0x3858] = 0x3bcc, [0x3859] = 0x3bcd, [0x385a] = 0x3bce, [0x385b] = 0x3bcf,
  [0x385c] = 0x3bd0, [0x385d] = 0x3bd1, [0x385e] = 0x3bd2, [0x385f] = 0x3bd3,
  [0x3860] = 0x3bd4, [0x3861] = 0x3bd5, [0x3862] = 0x3bd6, [0x3863] = 0x3bd7,
  [0x3864] = 0x3bd8, [0x3865] = 0x3bd9, [0x3866] = 0x3bda, [0x3867] = 0x3bdb,
  [0x3868] = 0x3bdc, [0x3869] = 0x3bdd, [0x386a] = 0x3bde, [0x386b] = 0x3bdf,
  [0x386c] = 0x3be0, [0x386d] = 0x3be1, [0x386e] = 0x3be2, [0x386f] = 0x3be3,
  [0x3870] = 0x3be4, [0x3871] = 0x3be5, [0x3872] = 0x3be6, [0x3873] = 0x3be7,
  [0x3874] = 0x3be8, [0x3875] = 0x3be9, [0x3876] = 0x3bea, [0x3877] = 0x3beb,
  [0x3878] = 0x3bec, [0x3879] = 0x3bed, [0x387a] = 0x3bee, [0x387b] = 0x3bef,
  [0x387c] = 0x3bf0, [0x387d] = 0x3bf1, [0x387e] = 0x3bf2, [0x387f] = 0x3bf3,
  [0x3880] = 0x3bf4, [0x3881] = 0x3bf5, [0x3882] = 0x3bf6, [0x3883] = 0x3bf7,
  [0x3884] = 0x3bf8, [0x3885] = 0x3bf9, [0x3886] = 0x3bfa, [0x3887] = 0x3bfb,
  [0x3888] = 0x3bfc, [0x3889] = 0x3bfd, [0x388a] = 0x3bfe, [0x388b] = 0x3bff,
  [0x388c] = 0x3c00, [0x388d] = 0x3c01, [0x388e] = 0x3c02, [0x388f] = 0x3c03,
  [0x3890] = 0x3c04, [0x3891] = 0x3c05, [0x3892] = 0x3c06, [0x3893] = 0x3c07,
  [0x3894] = 0x3c08, [0x3895] = 0x3c09, [0x3896] = 0x3c0a, [0x3897] = 0x3c0b,
  [0x3898] = 0x3c0c, [0x3899] = 0x3c0d, [0x389a] = 0x3c0e, [0x389b] = 0x3c0f,
  [0x389c] = 0x3c10, [0x389d] = 0x3c11, [0x389e] = 0x3c12, [0x389f] = 0x3c13,
  [0x38a0] = 0x3c14, [0x38a1] = 0x3c15, [0x38a2] = 0x3c16, [0x38a3] = 0x3c17,
  [0x38a4] = 0x3c18, [0x38a5] = 0x3c19, [0x38a6] = 0x3c1a, [0x38a7] = 0x3c1b,
  [0x38a8] = 0x3c1c, [0x38a9] = 0x3c1d, [0x38aa] = 0x3c1e, [0x38ab] = 0x3c1f,
  [0x38ac] = 0x3c20, [0x38ad] = 0x3c21, [0x38ae] = 0x3c22, [0x38af] = 0x3c23,
  [0x38b0] = 0x3c24, [0x38b1] = 0x3c25, [0x38b2] = 0x3c26, [0x38b3] = 0x3c27,
  [0x38b4] = 0x3c28, [0x38b5] = 0x3c29, [0x38b6] = 0x3c2a, [0x38b7] = 0x3c2b,
  [0x38b8] = 0x3c2c, [0x38b9] = 0x3c2d, [0x38ba] = 0x3c2e, [0x38bb] = 0x3c2f,
  [0x38bc] = 0x3c30, [0x38bd] = 0x3c31, [0x38be] = 0x3c32, [0x38bf] = 0x3c33,
  [0x38c0] = 0x3c34, [0x38c1] = 0x3c35, [0x38c2] = 0x3c36, [0x38c3] = 0x3c37,
  [0x38c4] = 0x3c38, [0x38c5] = 0x3c39, [0x38c6] = 0x3c3a, [0x38c7] = 0x3c3b,
  [0x38c8] = 0x3c3c, [0x38c9] = 0x3c3d, [0x38ca] = 0x3c3e, [0x38cb] = 0x3c3f,
  [0x38cc] = 0x3c40, [0x38cd] = 0x3c41, [0x38ce] = 0x3c42, [0x38cf] = 0x3c43,
  [0x38d0] = 0x3c44, [0x38d1] = 0x3c45, [0x38d2] = 0x3c46, [0x38d3] = 0x3c47,
  [0x38d4] = 0x3c48, [0x38d5] = 0x3c49, [0x38d6] = 0x3c4a, [0x38d7] = 0x3c4b,
  [0x38d8] = 0x3c4c, [0x38d9] = 0x3c4d, [0x38da] = 0x3c4e, [0x38db] = 0x3c4f,
  [0x38dc] = 0x3c50, [0x38dd] = 0x3c51, [0x38de] = 0x3c52, [0x38df] = 0x3c53,
  [0x38e0] = 0x3c54, [0x38e1] = 0x3c55, [0x38e2] = 0x3c56, [0x38e3] = 0x3c57,
  [0x38e4] = 0x3c58, [0x38e5] = 0x3c59, [0x38e6] = 0x3c5a, [0x38e7] = 0x3c5b,
  [0x38e8] = 0x3c5c, [0x38e9] = 0x3c5d, [0x38ea] = 0x3c5e, [0x38eb] = 0x3c5f,
  [0x38ec] = 0x3c60, [0x38ed] = 0x3c61, [0x38ee] = 0x3c62, [0x38ef] = 0x3c63,
  [0x38f0] = 0x3c64, [0x38f1] = 0x3c65, [0x38f2] = 0x3c66, [0x38f3] = 0x3c67,
  [0x38f4] = 0x3c68, [0x38f5] = 0x3c69, [0x38f6] = 0x3c6a, [0x38f7] = 0x3c6b,
  [0x38f8] = 0x3c6c, [0x38f9] = 0x3c6d, [0x38fa] = 0x3c6f, [0x38fb] = 0x3c70,
  [0x38fc] = 0x3c71, [0x38fd] = 0x3c72, [0x38fe] = 0x3c73, [0x38ff] = 0x3c74,
  [0x3900] = 0x3c75, [0x3901] = 0x3c76, [0x3902] = 0x3c77, [0x3903] = 0x3c78,
  [0x3904] = 0x3c79, [0x3905] = 0x3c7a, [0x3906] = 0x3c7b, [0x3907] = 0x3c7c,
  [0x3908] = 0x3c7d, [0x3909] = 0x3c7e, [0x390a] = 0x3c7f, [0x390b] = 0x3c80,
  [0x390c] = 0x3c81, [0x390d] = 0x3c82, [0x390e] = 0x3c83, [0x390f] = 0x3c84,
  [0x3910] = 0x3c85, [0x3911] = 0x3c86, [0x3912] = 0x3c87, [0x3913] = 0x3c88,
  [0x3914] = 0x3c89, [0x3915] = 0x3c8a, [0x3916] = 0x3c8b, [0x3917] = 0x3c8c,
  [0x3918] = 0x3c8d, [0x3919] = 0x3c8e, [0x391a] = 0x3c8f, [0x391b] = 0x3c90,
  [0x391c] = 0x3c91, [0x391d] = 0x3c92, [0x391e] = 0x3c93, [0x391f] = 0x3c94,
  [0x3920] = 0x3c95, [0x3921] = 0x3c96, [0x3922] = 0x3c97, [0x3923] = 0x3c98,
  [0x3924] = 0x3c99, [0x3925] = 0x3c9a, [0x3926] = 0x3c9b, [0x3927] = 0x3c9c,
  [0x3928] = 0x3c9d, [0x3929] = 0x3c9e, [0x392a] = 0x3c9f, [0x392b] = 0x3ca0,
  [0x392c] = 0x3ca1, [0x392d] = 0x3ca2, [0x392e] = 0x3ca3, [0x392f] = 0x3ca4,
  [0x3930] = 0x3ca5, [0x3931] = 0x3ca6, [0x3932] = 0x3ca7, [0x3933] = 0x3ca8,
  [0x3934] = 0x3ca9, [0x3935] = 0x3caa, [0x3936] = 0x3cab, [0x3937] = 0x3cac,
  [0x3938] = 0x3cad, [0x3939] = 0x3cae, [0x393a] = 0x3caf, [0x393b] = 0x3cb0,
  [0x393c] = 0x3cb1, [0x393d] = 0x3cb2, [0x393e] = 0x3cb3, [0x393f] = 0x3cb4,
  [0x3940] = 0x3cb5, [0x3941] = 0x3cb6, [0x3942] = 0x3cb7, [0x3943] = 0x3cb8,
  [0x3944] = 0x3cb9, [0x3945] = 0x3cba, [0x3946] = 0x3cbb, [0x3947] = 0x3cbc,
  [0x3948] = 0x3cbd, [0x3949] = 0x3cbe, [0x394a] = 0x3cbf, [0x394b] = 0x3cc0,
  [0x394c] = 0x3cc1, [0x394d] = 0x3cc2, [0x394e] = 0x3cc3, [0x394f] = 0x3cc4,
  [0x3950] = 0x3cc5, [0x3951] = 0x3cc6, [0x3952] = 0x3cc7, [0x3953] = 0x3cc8,
  [0x3954] = 0x3cc9, [0x3955] = 0x3cca, [0x3956] = 0x3ccb, [0x3957] = 0x3ccc,
  [0x3958] = 0x3ccd, [0x3959] = 0x3cce, [0x395a] = 0x3ccf, [0x395b] = 0x3cd0,
  [0x395c] = 0x3cd1, [0x395d] = 0x3cd2, [0x395e] = 0x3cd3, [0x395f] = 0x3cd4,
  [0x3960] = 0x3cd5, [0x3961] = 0x3cd6, [0x3962] = 0x3cd7, [0x3963] = 0x3cd8,
  [0x3964] = 0x3cd9, [0x3965] = 0x3cda, [0x3966] = 0x3cdb, [0x3967] = 0x3cdc,
  [0x3968] = 0x3cdd, [0x3969] = 0x3cde, [0x396a] = 0x3cdf, [0x396b] = 0x3ce1,
  [0x396c] = 0x3ce2, [0x396d] = 0x3ce3, [0x396e] = 0x3ce4, [0x396f] = 0x3ce5,
  [0x3970] = 0x3ce6, [0x3971] = 0x3ce7, [0x3972] = 0x3ce8, [0x3973] = 0x3ce9,
  [0x3974] = 0x3cea, [0x3975] = 0x3ceb, [0x3976] = 0x3cec, [0x3977] = 0x3ced,
  [0x3978] = 0x3cee, [0x3979] = 0x3cef, [0x397a] = 0x3cf0, [0x397b] = 0x3cf1,
  [0x397c] = 0x3cf2, [0x397d] = 0x3cf3, [0x397e] = 0x3cf4, [0x397f] = 0x3cf5,
  [0x3980] = 0x3cf6, [0x3981] = 0x3cf7, [0x3982] = 0x3cf8, [0x3983] = 0x3cf9,
  [0x3984] = 0x3cfa, [0x3985] = 0x3cfb, [0x3986] = 0x3cfc, [0x3987] = 0x3cfd,
  [0x3988] = 0x3cfe, [0x3989] = 0x3cff, [0x398a] = 0x3d00, [0x398b] = 0x3d01,
  [0x398c] = 0x3d02, [0x398d] = 0x3d03, [0x398e] = 0x3d04, [0x398f] = 0x3d05,
  [0x3990] = 0x3d06, [0x3991] = 0x3d07, [0x3992] = 0x3d08, [0x3993] = 0x3d09,
  [0x3994] = 0x3d0a, [0x3995] = 0x3d0b, [0x3996] = 0x3d0c, [0x3997] = 0x3d0d,
  [0x3998] = 0x3d0e, [0x3999] = 0x3d0f, [0x399a] = 0x3d10, [0x399b] = 0x3d11,
  [0x399c] = 0x3d12, [0x399d] = 0x3d13, [0x399e] = 0x3d14, [0x399f] = 0x3d15,
  [0x39a0] = 0x3d16, [0x39a1] = 0x3d17, [0x39a2] = 0x3d18, [0x39a3] = 0x3d19,
  [0x39a4] = 0x3d1a, [0x39a5] = 0x3d1b, [0x39a6] = 0x3d1c, [0x39a7] = 0x3d1d,
  [0x39a8] = 0x3d1e, [0x39a9] = 0x3d1f, [0x39aa] = 0x3d20, [0x39ab] = 0x3d21,
  [0x39ac] = 0x3d22, [0x39ad] = 0x3d23, [0x39ae] = 0x3d24, [0x39af] = 0x3d25,
  [0x39b0] = 0x3d26, [0x39b1] = 0x3d27, [0x39b2] = 0x3d28, [0x39b3] = 0x3d29,
  [0x39b4] = 0x3d2a, [0x39b5] = 0x3d2b, [0x39b6] = 0x3d2c, [0x39b7] = 0x3d2d,
  [0x39b8] = 0x3d2e, [0x39b9] = 0x3d2f, [0x39ba] = 0x3d30, [0x39bb] = 0x3d31,
  [0x39bc] = 0x3d32, [0x39bd] = 0x3d33, [0x39be] = 0x3d34, [0x39bf] = 0x3d35,
  [0x39c0] = 0x3d36, [0x39c1] = 0x3d37, [0x39c2] = 0x3d38, [0x39c3] = 0x3d39,
  [0x39c4] = 0x3d3a, [0x39c5] = 0x3d3b, [0x39c6] = 0x3d3c, [0x39c7] = 0x3d3d,
  [0x39c8] = 0x3d3e, [0x39c9] = 0x3d3f, [0x39ca] = 0x3d40, [0x39cb] = 0x3d41,
  [0x39cc] = 0x3d42, [0x39cd] = 0x3d43, [0x39ce] = 0x3d44, [0x39cf] = 0x3d45,
  [0x39d0] = 0x3d46, [0x39d1] = 0x3d47, [0x39d2] = 0x3d48, [0x39d3] = 0x3d49,
  [0x39d4] = 0x3d4a, [0x39d5] = 0x3d4b, [0x39d6] = 0x3d4c, [0x39d7] = 0x3d4d,
  [0x39d8] = 0x3d4e, [0x39d9] = 0x3d4f, [0x39da] = 0x3d50, [0x39db] = 0x3d51,
  [0x39dc] = 0x3d52, [0x39dd] = 0x3d53, [0x39de] = 0x3d54, [0x39df] = 0x3d55,
  [0x39e0] = 0x3d56, [0x39e1] = 0x3d57, [0x39e2] = 0x3d58, [0x39e3] = 0x3d59,
  [0x39e4] = 0x3d5a, [0x39e5] = 0x3d5b, [0x39e6] = 0x3d5c, [0x39e7] = 0x3d5d,
  [0x39e8] = 0x3d5e, [0x39e9] = 0x3d5f, [0x39ea] = 0x3d60, [0x39eb] = 0x3d61,
  [0x39ec] = 0x3d62, [0x39ed] = 0x3d63, [0x39ee] = 0x3d64, [0x39ef] = 0x3d65,
  [0x39f0] = 0x3d66, [0x39f1] = 0x3d67, [0x39f2] = 0x3d68, [0x39f3] = 0x3d69,
  [0x39f4] = 0x3d6a, [0x39f5] = 0x3d6b, [0x39f6] = 0x3d6c, [0x39f7] = 0x3d6d,
  [0x39f8] = 0x3d6e, [0x39f9] = 0x3d6f, [0x39fa] = 0x3d70, [0x39fb] = 0x3d71,
  [0x39fc] = 0x3d72, [0x39fd] = 0x3d73, [0x39fe] = 0x3d74, [0x39ff] = 0x3d75,
  [0x3a00] = 0x3d76, [0x3a01] = 0x3d77, [0x3a02] = 0x3d78, [0x3a03] = 0x3d79,
  [0x3a04] = 0x3d7a, [0x3a05] = 0x3d7b, [0x3a06] = 0x3d7c, [0x3a07] = 0x3d7d,
  [0x3a08] = 0x3d7e, [0x3a09] = 0x3d7f, [0x3a0a] = 0x3d80, [0x3a0b] = 0x3d81,
  [0x3a0c] = 0x3d82, [0x3a0d] = 0x3d83, [0x3a0e] = 0x3d84, [0x3a0f] = 0x3d85,
  [0x3a10] = 0x3d86, [0x3a11] = 0x3d87, [0x3a12] = 0x3d88, [0x3a13] = 0x3d89,
  [0x3a14] = 0x3d8a, [0x3a15] = 0x3d8b, [0x3a16] = 0x3d8c, [0x3a17] = 0x3d8d,
  [0x3a18] = 0x3d8e, [0x3a19] = 0x3d8f, [0x3a1a] = 0x3d90, [0x3a1b] = 0x3d91,
  [0x3a1c] = 0x3d92, [0x3a1d] = 0x3d93, [0x3a1e] = 0x3d94, [0x3a1f] = 0x3d95,
  [0x3a20] = 0x3d96, [0x3a21] = 0x3d97, [0x3a22] = 0x3d98, [0x3a23] = 0x3d99,
  [0x3a24] = 0x3d9a, [0x3a25] = 0x3d9b, [0x3a26] = 0x3d9c, [0x3a27] = 0x3d9d,
  [0x3a28] = 0x3d9e, [0x3a29] = 0x3d9f, [0x3a2a] = 0x3da0, [0x3a2b] = 0x3da1,
  [0x3a2c] = 0x3da2, [0x3a2d] = 0x3da3, [0x3a2e] = 0x3da4, [0x3a2f] = 0x3da5,
  [0x3a30] = 0x3da6, [0x3a31] = 0x3da7, [0x3a32] = 0x3da8, [0x3a33] = 0x3da9,
  [0x3a34] = 0x3daa, [0x3a35] = 0x3dab, [0x3a36] = 0x3dac, [0x3a37] = 0x3dad,
  [0x3a38] = 0x3dae, [0x3a39] = 0x3daf, [0x3a3a] = 0x3db0, [0x3a3b] = 0x3db1,
  [0x3a3c] = 0x3db2, [0x3a3d] = 0x3db3, [0x3a3e] = 0x3db4, [0x3a3f] = 0x3db5,
  [0x3a40] = 0x3db6, [0x3a41] = 0x3db7, [0x3a42] = 0x3db8, [0x3a43] = 0x3db9,
  [0x3a44] = 0x3dba, [0x3a45] = 0x3dbb, [0x3a46] = 0x3dbc, [0x3a47] = 0x3dbd,
  [0x3a48] = 0x3dbe, [0x3a49] = 0x3dbf, [0x3a4a] = 0x3dc0, [0x3a4b] = 0x3dc1,
  [0x3a4c] = 0x3dc2, [0x3a4d] = 0x3dc3, [0x3a4e] = 0x3dc4, [0x3a4f] = 0x3dc5,
  [0x3a50] = 0x3dc6, [0x3a51] = 0x3dc7, [0x3a52] = 0x3dc8, [0x3a53] = 0x3dc9,
  [0x3a54] = 0x3dca, [0x3a55] = 0x3dcb, [0x3a56] = 0x3dcc, [0x3a57] = 0x3dcd,
  [0x3a58] = 0x3dce, [0x3a59] = 0x3dcf, [0x3a5a] = 0x3dd0, [0x3a5b] = 0x3dd1,
  [0x3a5c] = 0x3dd2, [0x3a5d] = 0x3dd3, [0x3a5e] = 0x3dd4, [0x3a5f] = 0x3dd5,
  [0x3a60] = 0x3dd6, [0x3a61] = 0x3dd7, [0x3a62] = 0x3dd8, [0x3a63] = 0x3dd9,
  [0x3a64] = 0x3dda, [0x3a65] = 0x3ddb, [0x3a66] = 0x3ddc, [0x3a67] = 0x3ddd,
  [0x3a68] = 0x3dde, [0x3a69] = 0x3ddf, [0x3a6a] = 0x3de0, [0x3a6b] = 0x3de1,
  [0x3a6c] = 0x3de2, [0x3a6d] = 0x3de3, [0x3a6e] = 0x3de4, [0x3a6f] = 0x3de5,
  [0x3a70] = 0x3de6, [0x3a71] = 0x3de7, [0x3a72] = 0x3de8, [0x3a73] = 0x3de9,
  [0x3a74] = 0x3dea, [0x3a75] = 0x3deb, [0x3a76] = 0x3dec, [0x3a77] = 0x3ded,
  [0x3a78] = 0x3dee, [0x3a79] = 0x3def, [0x3a7a] = 0x3df0, [0x3a7b] = 0x3df1,
  [0x3a7c] = 0x3df2, [0x3a7d] = 0x3df3, [0x3a7e] = 0x3df4, [0x3a7f] = 0x3df5,
  [0x3a80] = 0x3df6, [0x3a81] = 0x3df7, [0x3a82] = 0x3df8, [0x3a83] = 0x3df9,
  [0x3a84] = 0x3dfa, [0x3a85] = 0x3dfb, [0x3a86] = 0x3dfc, [0x3a87] = 0x3dfd,
  [0x3a88] = 0x3dfe, [0x3a89] = 0x3dff, [0x3a8a] = 0x3e00, [0x3a8b] = 0x3e01,
  [0x3a8c] = 0x3e02, [0x3a8d] = 0x3e03, [0x3a8e] = 0x3e04, [0x3a8f] = 0x3e05,
  [0x3a90] = 0x3e06, [0x3a91] = 0x3e07, [0x3a92] = 0x3e08, [0x3a93] = 0x3e09,
  [0x3a94] = 0x3e0a, [0x3a95] = 0x3e0b, [0x3a96] = 0x3e0c, [0x3a97] = 0x3e0d,
  [0x3a98] = 0x3e0e, [0x3a99] = 0x3e0f, [0x3a9a] = 0x3e10, [0x3a9b] = 0x3e11,
  [0x3a9c] = 0x3e12, [0x3a9d] = 0x3e13, [0x3a9e] = 0x3e14, [0x3a9f] = 0x3e15,
  [0x3aa0] = 0x3e16, [0x3aa1] = 0x3e17, [0x3aa2] = 0x3e18, [0x3aa3] = 0x3e19,
  [0x3aa4] = 0x3e1a, [0x3aa5] = 0x3e1b, [0x3aa6] = 0x3e1c, [0x3aa7] = 0x3e1d,
  [0x3aa8] = 0x3e1e, [0x3aa9] = 0x3e1f, [0x3aaa] = 0x3e20, [0x3aab] = 0x3e21,
  [0x3aac] = 0x3e22, [0x3aad] = 0x3e23, [0x3aae] = 0x3e24, [0x3aaf] = 0x3e25,
  [0x3ab0] = 0x3e26, [0x3ab1] = 0x3e27, [0x3ab2] = 0x3e28, [0x3ab3] = 0x3e29,
  [0x3ab4] = 0x3e2a, [0x3ab5] = 0x3e2b, [0x3ab6] = 0x3e2c, [0x3ab7] = 0x3e2d,
  [0x3ab8] = 0x3e2e, [0x3ab9] = 0x3e2f, [0x3aba] = 0x3e30, [0x3abb] = 0x3e31,
  [0x3abc] = 0x3e32, [0x3abd] = 0x3e33, [0x3abe] = 0x3e34, [0x3abf] = 0x3e35,
  [0x3ac0] = 0x3e36, [0x3ac1] = 0x3e37, [0x3ac2] = 0x3e38, [0x3ac3] = 0x3e39,
  [0x3ac4] = 0x3e3a, [0x3ac5] = 0x3e3b, [0x3ac6] = 0x3e3c, [0x3ac7] = 0x3e3d,
  [0x3ac8] = 0x3e3e, [0x3ac9] = 0x3e3f, [0x3aca] = 0x3e40, [0x3acb] = 0x3e41,
  [0x3acc] = 0x3e42, [0x3acd] = 0x3e43, [0x3ace] = 0x3e44, [0x3acf] = 0x3e45,
  [0x3ad0] = 0x3e46, [0x3ad1] = 0x3e47, [0x3ad2] = 0x3e48, [0x3ad3] = 0x3e49,
  [0x3ad4] = 0x3e4a, [0x3ad5] = 0x3e4b, [0x3ad6] = 0x3e4c, [0x3ad7] = 0x3e4d,
  [0x3ad8] = 0x3e4e, [0x3ad9] = 0x3e4f, [0x3ada] = 0x3e50, [0x3adb] = 0x3e51,
  [0x3adc] = 0x3e52, [0x3add] = 0x3e53, [0x3ade] = 0x3e54, [0x3adf] = 0x3e55,
  [0x3ae0] = 0x3e56, [0x3ae1] = 0x3e57, [0x3ae2] = 0x3e58, [0x3ae3] = 0x3e59,
  [0x3ae4] = 0x3e5a, [0x3ae5] = 0x3e5b, [0x3ae6] = 0x3e5c, [0x3ae7] = 0x3e5d,
  [0x3ae8] = 0x3e5e, [0x3ae9] = 0x3e5f, [0x3aea] = 0x3e60, [0x3aeb] = 0x3e61,
  [0x3aec] = 0x3e62, [0x3aed] = 0x3e63, [0x3aee] = 0x3e64, [0x3aef] = 0x3e65,
  [0x3af0] = 0x3e66, [0x3af1] = 0x3e67, [0x3af2] = 0x3e68, [0x3af3] = 0x3e69,
  [0x3af4] = 0x3e6a, [0x3af5] = 0x3e6b, [0x3af6] = 0x3e6c, [0x3af7] = 0x3e6d,
  [0x3af8] = 0x3e6e, [0x3af9] = 0x3e6f, [0x3afa] = 0x3e70, [0x3afb] = 0x3e71,
  [0x3afc] = 0x3e72, [0x3afd] = 0x3e73, [0x3afe] = 0x3e74, [0x3aff] = 0x3e75,
  [0x3b00] = 0x3e76, [0x3b01] = 0x3e77, [0x3b02] = 0x3e78, [0x3b03] = 0x3e79,
  [0x3b04] = 0x3e7a, [0x3b05] = 0x3e7b, [0x3b06] = 0x3e7c, [0x3b07] = 0x3e7d,
  [0x3b08] = 0x3e7e, [0x3b09] = 0x3e7f, [0x3b0a] = 0x3e80, [0x3b0b] = 0x3e81,
  [0x3b0c] = 0x3e82, [0x3b0d] = 0x3e83, [0x3b0e] = 0x3e84, [0x3b0f] = 0x3e85,
  [0x3b10] = 0x3e86, [0x3b11] = 0x3e87, [0x3b12] = 0x3e88, [0x3b13] = 0x3e89,
  [0x3b14] = 0x3e8a, [0x3b15] = 0x3e8b, [0x3b16] = 0x3e8c, [0x3b17] = 0x3e8d,
  [0x3b18] = 0x3e8e, [0x3b19] = 0x3e8f, [0x3b1a] = 0x3e90, [0x3b1b] = 0x3e91,
  [0x3b1c] = 0x3e92, [0x3b1d] = 0x3e93, [0x3b1e] = 0x3e94, [0x3b1f] = 0x3e95,
  [0x3b20] = 0x3e96, [0x3b21] = 0x3e97, [0x3b22] = 0x3e98, [0x3b23] = 0x3e99,
  [0x3b24] = 0x3e9a, [0x3b25] = 0x3e9b, [0x3b26] = 0x3e9c, [0x3b27] = 0x3e9d,
  [0x3b28] = 0x3e9e, [0x3b29] = 0x3e9f, [0x3b2a] = 0x3ea0, [0x3b2b] = 0x3ea1,
  [0x3b2c] = 0x3ea2, [0x3b2d] = 0x3ea3, [0x3b2e] = 0x3ea4, [0x3b2f] = 0x3ea5,
  [0x3b30] = 0x3ea6, [0x3b31] = 0x3ea7, [0x3b32] = 0x3ea8, [0x3b33] = 0x3ea9,
  [0x3b34] = 0x3eaa, [0x3b35] = 0x3eab, [0x3b36] = 0x3eac, [0x3b37] = 0x3ead,
  [0x3b38] = 0x3eae, [0x3b39] = 0x3eaf, [0x3b3a] = 0x3eb0, [0x3b3b] = 0x3eb1,
  [0x3b3c] = 0x3eb2, [0x3b3d] = 0x3eb3, [0x3b3e] = 0x3eb4, [0x3b3f] = 0x3eb5,
  [0x3b40] = 0x3eb6, [0x3b41] = 0x3eb7, [0x3b42] = 0x3eb8, [0x3b43] = 0x3eb9,
  [0x3b44] = 0x3eba, [0x3b45] = 0x3ebb, [0x3b46] = 0x3ebc, [0x3b47] = 0x3ebd,
  [0x3b48] = 0x3ebe, [0x3b49] = 0x3ebf, [0x3b4a] = 0x3ec0, [0x3b4b] = 0x3ec1,
  [0x3b4c] = 0x3ec2, [0x3b4d] = 0x3ec3, [0x3b4e] = 0x3ec4, [0x3b4f] = 0x3ec5,
  [0x3b50] = 0x3ec6, [0x3b51] = 0x3ec7, [0x3b52] = 0x3ec8, [0x3b53] = 0x3ec9,
  [0x3b54] = 0x3eca, [0x3b55] = 0x3ecb, [0x3b56] = 0x3ecc, [0x3b57] = 0x3ecd,
  [0x3b58] = 0x3ece, [0x3b59] = 0x3ecf, [0x3b5a] = 0x3ed0, [0x3b5b] = 0x3ed1,
  [0x3b5c] = 0x3ed2, [0x3b5d] = 0x3ed3, [0x3b5e] = 0x3ed4, [0x3b5f] = 0x3ed5,
  [0x3b60] = 0x3ed6, [0x3b61] = 0x3ed7, [0x3b62] = 0x3ed8, [0x3b63] = 0x3ed9,
  [0x3b64] = 0x3eda, [0x3b65] = 0x3edb, [0x3b66] = 0x3edc, [0x3b67] = 0x3edd,
  [0x3b68] = 0x3ede, [0x3b69] = 0x3edf, [0x3b6a] = 0x3ee0, [0x3b6b] = 0x3ee1,
  [0x3b6c] = 0x3ee2, [0x3b6d] = 0x3ee3, [0x3b6e] = 0x3ee4, [0x3b6f] = 0x3ee5,
  [0x3b70] = 0x3ee6, [0x3b71] = 0x3ee7, [0x3b72] = 0x3ee8, [0x3b73] = 0x3ee9,
  [0x3b74] = 0x3eea, [0x3b75] = 0x3eeb, [0x3b76] = 0x3eec, [0x3b77] = 0x3eed,
  [0x3b78] = 0x3eee, [0x3b79] = 0x3eef, [0x3b7a] = 0x3ef0, [0x3b7b] = 0x3ef1,
  [0x3b7c] = 0x3ef2, [0x3b7d] = 0x3ef3, [0x3b7e] = 0x3ef4, [0x3b7f] = 0x3ef5,
  [0x3b80] = 0x3ef6, [0x3b81] = 0x3ef7, [0x3b82] = 0x3ef8, [0x3b83] = 0x3ef9,
  [0x3b84] = 0x3efa, [0x3b85] = 0x3efb, [0x3b86] = 0x3efc, [0x3b87] = 0x3efd,
  [0x3b88] = 0x3efe, [0x3b89] = 0x3eff, [0x3b8a] = 0x3f00, [0x3b8b] = 0x3f01,
  [0x3b8c] = 0x3f02, [0x3b8d] = 0x3f03, [0x3b8e] = 0x3f04, [0x3b8f] = 0x3f05,
  [0x3b90] = 0x3f06, [0x3b91] = 0x3f07, [0x3b92] = 0x3f08, [0x3b93] = 0x3f09,
  [0x3b94] = 0x3f0a, [0x3b95] = 0x3f0b, [0x3b96] = 0x3f0c, [0x3b97] = 0x3f0d,
  [0x3b98] = 0x3f0e, [0x3b99] = 0x3f0f, [0x3b9a] = 0x3f10, [0x3b9b] = 0x3f11,
  [0x3b9c] = 0x3f12, [0x3b9d] = 0x3f13, [0x3b9e] = 0x3f14, [0x3b9f] = 0x3f15,
  [0x3ba0] = 0x3f16, [0x3ba1] = 0x3f17, [0x3ba2] = 0x3f18, [0x3ba3] = 0x3f19,
  [0x3ba4] = 0x3f1a, [0x3ba5] = 0x3f1b, [0x3ba6] = 0x3f1c, [0x3ba7] = 0x3f1d,
  [0x3ba8] = 0x3f1e, [0x3ba9] = 0x3f1f, [0x3baa] = 0x3f20, [0x3bab] = 0x3f21,
  [0x3bac] = 0x3f22, [0x3bad] = 0x3f23, [0x3bae] = 0x3f24, [0x3baf] = 0x3f25,
  [0x3bb0] = 0x3f26, [0x3bb1] = 0x3f27, [0x3bb2] = 0x3f28, [0x3bb3] = 0x3f29,
  [0x3bb4] = 0x3f2a, [0x3bb5] = 0x3f2b, [0x3bb6] = 0x3f2c, [0x3bb7] = 0x3f2d,
  [0x3bb8] = 0x3f2e, [0x3bb9] = 0x3f2f, [0x3bba] = 0x3f30, [0x3bbb] = 0x3f31,
  [0x3bbc] = 0x3f32, [0x3bbd] = 0x3f33, [0x3bbe] = 0x3f34, [0x3bbf] = 0x3f35,
  [0x3bc0] = 0x3f36, [0x3bc1] = 0x3f37, [0x3bc2] = 0x3f38, [0x3bc3] = 0x3f39,
  [0x3bc4] = 0x3f3a, [0x3bc5] = 0x3f3b, [0x3bc6] = 0x3f3c, [0x3bc7] = 0x3f3d,
  [0x3bc8] = 0x3f3e, [0x3bc9] = 0x3f3f, [0x3bca] = 0x3f40, [0x3bcb] = 0x3f41,
  [0x3bcc] = 0x3f42, [0x3bcd] = 0x3f43, [0x3bce] = 0x3f44, [0x3bcf] = 0x3f45,
  [0x3bd0] = 0x3f46, [0x3bd1] = 0x3f47, [0x3bd2] = 0x3f48, [0x3bd3] = 0x3f49,
  [0x3bd4] = 0x3f4a, [0x3bd5] = 0x3f4b, [0x3bd6] = 0x3f4c, [0x3bd7] = 0x3f4d,
  [0x3bd8] = 0x3f4e, [0x3bd9] = 0x3f4f, [0x3bda] = 0x3f50, [0x3bdb] = 0x3f51,
  [0x3bdc] = 0x3f52, [0x3bdd] = 0x3f53, [0x3bde] = 0x3f54, [0x3bdf] = 0x3f55,
  [0x3be0] = 0x3f56, [0x3be1] = 0x3f57, [0x3be2] = 0x3f58, [0x3be3] = 0x3f59,
  [0x3be4] = 0x3f5a, [0x3be5] = 0x3f5b, [0x3be6] = 0x3f5c, [0x3be7] = 0x3f5d,
  [0x3be8] = 0x3f5e, [0x3be9] = 0x3f5f, [0x3bea] = 0x3f60, [0x3beb] = 0x3f61,
  [0x3bec] = 0x3f62, [0x3bed] = 0x3f63, [0x3bee] = 0x3f64, [0x3bef] = 0x3f65,
  [0x3bf0] = 0x3f66, [0x3bf1] = 0x3f67, [0x3bf2] = 0x3f68, [0x3bf3] = 0x3f69,
  [0x3bf4] = 0x3f6a, [0x3bf5] = 0x3f6b, [0x3bf6] = 0x3f6c, [0x3bf7] = 0x3f6d,
  [0x3bf8] = 0x3f6e, [0x3bf9] = 0x3f6f, [0x3bfa] = 0x3f70, [0x3bfb] = 0x3f71,
  [0x3bfc] = 0x3f72, [0x3bfd] = 0x3f73, [0x3bfe] = 0x3f74, [0x3bff] = 0x3f75,
  [0x3c00] = 0x3f76, [0x3c01] = 0x3f77, [0x3c02] = 0x3f78, [0x3c03] = 0x3f79,
  [0x3c04] = 0x3f7a, [0x3c05] = 0x3f7b, [0x3c06] = 0x3f7c, [0x3c07] = 0x3f7d,
  [0x3c08] = 0x3f7e, [0x3c09] = 0x3f7f, [0x3c0a] = 0x3f80, [0x3c0b] = 0x3f81,
  [0x3c0c] = 0x3f82, [0x3c0d] = 0x3f83, [0x3c0e] = 0x3f84, [0x3c0f] = 0x3f85,
  [0x3c10] = 0x3f86, [0x3c11] = 0x3f87, [0x3c12] = 0x3f88, [0x3c13] = 0x3f89,
  [0x3c14] = 0x3f8a, [0x3c15] = 0x3f8b, [0x3c16] = 0x3f8c, [0x3c17] = 0x3f8d,
  [0x3c18] = 0x3f8e, [0x3c19] = 0x3f8f, [0x3c1a] = 0x3f90, [0x3c1b] = 0x3f91,
  [0x3c1c] = 0x3f92, [0x3c1d] = 0x3f93, [0x3c1e] = 0x3f94, [0x3c1f] = 0x3f95,
  [0x3c20] = 0x3f96, [0x3c21] = 0x3f97, [0x3c22] = 0x3f98, [0x3c23] = 0x3f99,
  [0x3c24] = 0x3f9a, [0x3c25] = 0x3f9b, [0x3c26] = 0x3f9c, [0x3c27] = 0x3f9d,
  [0x3c28] = 0x3f9e, [0x3c29] = 0x3f9f, [0x3c2a] = 0x3fa0, [0x3c2b] = 0x3fa1,
  [0x3c2c] = 0x3fa2, [0x3c2d] = 0x3fa3, [0x3c2e] = 0x3fa4, [0x3c2f] = 0x3fa5,
  [0x3c30] = 0x3fa6, [0x3c31] = 0x3fa7, [0x3c32] = 0x3fa8, [0x3c33] = 0x3fa9,
  [0x3c34] = 0x3faa, [0x3c35] = 0x3fab, [0x3c36] = 0x3fac, [0x3c37] = 0x3fad,
  [0x3c38] = 0x3fae, [0x3c39] = 0x3faf, [0x3c3a] = 0x3fb0, [0x3c3b] = 0x3fb1,
  [0x3c3c] = 0x3fb2, [0x3c3d] = 0x3fb3, [0x3c3e] = 0x3fb4, [0x3c3f] = 0x3fb5,
  [0x3c40] = 0x3fb6, [0x3c41] = 0x3fb7, [0x3c42] = 0x3fb8, [0x3c43] = 0x3fb9,
  [0x3c44] = 0x3fba, [0x3c45] = 0x3fbb, [0x3c46] = 0x3fbc, [0x3c47] = 0x3fbd,
  [0x3c48] = 0x3fbe, [0x3c49] = 0x3fbf, [0x3c4a] = 0x3fc0, [0x3c4b] = 0x3fc1,
  [0x3c4c] = 0x3fc2, [0x3c4d] = 0x3fc3, [0x3c4e] = 0x3fc4, [0x3c4f] = 0x3fc5,
  [0x3c50] = 0x3fc6, [0x3c51] = 0x3fc7, [0x3c52] = 0x3fc8, [0x3c53] = 0x3fc9,
  [0x3c54] = 0x3fca, [0x3c55] = 0x3fcb, [0x3c56] = 0x3fcc, [0x3c57] = 0x3fcd,
  [0x3c58] = 0x3fce, [0x3c59] = 0x3fcf, [0x3c5a] = 0x3fd0, [0x3c5b] = 0x3fd1,
  [0x3c5c] = 0x3fd2, [0x3c5d] = 0x3fd3, [0x3c5e] = 0x3fd4, [0x3c5f] = 0x3fd5,
  [0x3c60] = 0x3fd6, [0x3c61] = 0x3fd7, [0x3c62] = 0x3fd8, [0x3c63] = 0x3fd9,
  [0x3c64] = 0x3fda, [0x3c65] = 0x3fdb, [0x3c66] = 0x3fdc, [0x3c67] = 0x3fdd,
  [0x3c68] = 0x3fde, [0x3c69] = 0x3fdf, [0x3c6a] = 0x3fe0, [0x3c6b] = 0x3fe1,
  [0x3c6c] = 0x3fe2, [0x3c6d] = 0x3fe3, [0x3c6e] = 0x3fe4, [0x3c6f] = 0x3fe5,
  [0x3c70] = 0x3fe6, [0x3c71] = 0x3fe7, [0x3c72] = 0x3fe8, [0x3c73] = 0x3fe9,
  [0x3c74] = 0x3fea, [0x3c75] = 0x3feb, [0x3c76] = 0x3fec, [0x3c77] = 0x3fed,
  [0x3c78] = 0x3fee, [0x3c79] = 0x3fef, [0x3c7a] = 0x3ff0, [0x3c7b] = 0x3ff1,
  [0x3c7c] = 0x3ff2, [0x3c7d] = 0x3ff3, [0x3c7e] = 0x3ff4, [0x3c7f] = 0x3ff5,
  [0x3c80] = 0x3ff6, [0x3c81] = 0x3ff7, [0x3c82] = 0x3ff8, [0x3c83] = 0x3ff9,
  [0x3c84] = 0x3ffa, [0x3c85] = 0x3ffb, [0x3c86] = 0x3ffc, [0x3c87] = 0x3ffd,
  [0x3c88] = 0x3ffe, [0x3c89] = 0x3fff, [0x3c8a] = 0x4000, [0x3c8b] = 0x4001,
  [0x3c8c] = 0x4002, [0x3c8d] = 0x4003, [0x3c8e] = 0x4004, [0x3c8f] = 0x4005,
  [0x3c90] = 0x4006, [0x3c91] = 0x4007, [0x3c92] = 0x4008, [0x3c93] = 0x4009,
  [0x3c94] = 0x400a, [0x3c95] = 0x400b, [0x3c96] = 0x400c, [0x3c97] = 0x400d,
  [0x3c98] = 0x400e, [0x3c99] = 0x400f, [0x3c9a] = 0x4010, [0x3c9b] = 0x4011,
  [0x3c9c] = 0x4012, [0x3c9d] = 0x4013, [0x3c9e] = 0x4014, [0x3c9f] = 0x4015,
  [0x3ca0] = 0x4016, [0x3ca1] = 0x4017, [0x3ca2] = 0x4018, [0x3ca3] = 0x4019,
  [0x3ca4] = 0x401a, [0x3ca5] = 0x401b, [0x3ca6] = 0x401c, [0x3ca7] = 0x401d,
  [0x3ca8] = 0x401e, [0x3ca9] = 0x401f, [0x3caa] = 0x4020, [0x3cab] = 0x4021,
  [0x3cac] = 0x4022, [0x3cad] = 0x4023, [0x3cae] = 0x4024, [0x3caf] = 0x4025,
  [0x3cb0] = 0x4026, [0x3cb1] = 0x4027, [0x3cb2] = 0x4028, [0x3cb3] = 0x4029,
  [0x3cb4] = 0x402a, [0x3cb5] = 0x402b, [0x3cb6] = 0x402c, [0x3cb7] = 0x402d,
  [0x3cb8] = 0x402e, [0x3cb9] = 0x402f, [0x3cba] = 0x4030, [0x3cbb] = 0x4031,
  [0x3cbc] = 0x4032, [0x3cbd] = 0x4033, [0x3cbe] = 0x4034, [0x3cbf] = 0x4035,
  [0x3cc0] = 0x4036, [0x3cc1] = 0x4037, [0x3cc2] = 0x4038, [0x3cc3] = 0x4039,
  [0x3cc4] = 0x403a, [0x3cc5] = 0x403b, [0x3cc6] = 0x403c, [0x3cc7] = 0x403d,
  [0x3cc8] = 0x403e, [0x3cc9] = 0x403f, [0x3cca] = 0x4040, [0x3ccb] = 0x4041,
  [0x3ccc] = 0x4042, [0x3ccd] = 0x4043, [0x3cce] = 0x4044, [0x3ccf] = 0x4045,
  [0x3cd0] = 0x4046, [0x3cd1] = 0x4047, [0x3cd2] = 0x4048, [0x3cd3] = 0x4049,
  [0x3cd4] = 0x404a, [0x3cd5] = 0x404b, [0x3cd6] = 0x404c, [0x3cd7] = 0x404d,
  [0x3cd8] = 0x404e, [0x3cd9] = 0x404f, [0x3cda] = 0x4050, [0x3cdb] = 0x4051,
  [0x3cdc] = 0x4052, [0x3cdd] = 0x4053, [0x3cde] = 0x4054, [0x3cdf] = 0x4055,
  [0x3ce0] = 0x4057, [0x3ce1] = 0x4058, [0x3ce2] = 0x4059, [0x3ce3] = 0x405a,
  [0x3ce4] = 0x405b, [0x3ce5] = 0x405c, [0x3ce6] = 0x405d, [0x3ce7] = 0x405e,
  [0x3ce8] = 0x405f, [0x3ce9] = 0x4060, [0x3cea] = 0x4061, [0x3ceb] = 0x4062,
  [0x3cec] = 0x4063, [0x3ced] = 0x4064, [0x3cee] = 0x4065, [0x3cef] = 0x4066,
  [0x3cf0] = 0x4067, [0x3cf1] = 0x4068, [0x3cf2] = 0x4069, [0x3cf3] = 0x406a,
  [0x3cf4] = 0x406b, [0x3cf5] = 0x406c, [0x3cf6] = 0x406d, [0x3cf7] = 0x406e,
  [0x3cf8] = 0x406f, [0x3cf9] = 0x4070, [0x3cfa] = 0x4071, [0x3cfb] = 0x4072,
  [0x3cfc] = 0x4073, [0x3cfd] = 0x4074, [0x3cfe] = 0x4075, [0x3cff] = 0x4076,
  [0x3d00] = 0x4077, [0x3d01] = 0x4078, [0x3d02] = 0x4079, [0x3d03] = 0x407a,
  [0x3d04] = 0x407b, [0x3d05] = 0x407c, [0x3d06] = 0x407d, [0x3d07] = 0x407e,
  [0x3d08] = 0x407f, [0x3d09] = 0x4080, [0x3d0a] = 0x4081, [0x3d0b] = 0x4082,
  [0x3d0c] = 0x4083, [0x3d0d] = 0x4084, [0x3d0e] = 0x4085, [0x3d0f] = 0x4086,
  [0x3d10] = 0x4087, [0x3d11] = 0x4088, [0x3d12] = 0x4089, [0x3d13] = 0x408a,
  [0x3d14] = 0x408b, [0x3d15] = 0x408c, [0x3d16] = 0x408d, [0x3d17] = 0x408e,
  [0x3d18] = 0x408f, [0x3d19] = 0x4090, [0x3d1a] = 0x4091, [0x3d1b] = 0x4092,
  [0x3d1c] = 0x4093, [0x3d1d] = 0x4094, [0x3d1e] = 0x4095, [0x3d1f] = 0x4096,
  [0x3d20] = 0x4097, [0x3d21] = 0x4098, [0x3d22] = 0x4099, [0x3d23] = 0x409a,
  [0x3d24] = 0x409b, [0x3d25] = 0x409c, [0x3d26] = 0x409d, [0x3d27] = 0x409e,
  [0x3d28] = 0x409f, [0x3d29] = 0x40a0, [0x3d2a] = 0x40a1, [0x3d2b] = 0x40a2,
  [0x3d2c] = 0x40a3, [0x3d2d] = 0x40a4, [0x3d2e] = 0x40a5, [0x3d2f] = 0x40a6,
  [0x3d30] = 0x40a7, [0x3d31] = 0x40a8, [0x3d32] = 0x40a9, [0x3d33] = 0x40aa,
  [0x3d34] = 0x40ab, [0x3d35] = 0x40ac, [0x3d36] = 0x40ad, [0x3d37] = 0x40ae,
  [0x3d38] = 0x40af, [0x3d39] = 0x40b0, [0x3d3a] = 0x40b1, [0x3d3b] = 0x40b2,
  [0x3d3c] = 0x40b3, [0x3d3d] = 0x40b4, [0x3d3e] = 0x40b5, [0x3d3f] = 0x40b6,
  [0x3d40] = 0x40b7, [0x3d41] = 0x40b8, [0x3d42] = 0x40b9, [0x3d43] = 0x40ba,
  [0x3d44] = 0x40bb, [0x3d45] = 0x40bc, [0x3d46] = 0x40bd, [0x3d47] = 0x40be,
  [0x3d48] = 0x40bf, [0x3d49] = 0x40c0, [0x3d4a] = 0x40c1, [0x3d4b] = 0x40c2,
  [0x3d4c] = 0x40c3, [0x3d4d] = 0x40c4, [0x3d4e] = 0x40c5, [0x3d4f] = 0x40c6,
  [0x3d50] = 0x40c7, [0x3d51] = 0x40c8, [0x3d52] = 0x40c9, [0x3d53] = 0x40ca,
  [0x3d54] = 0x40cb, [0x3d55] = 0x40cc, [0x3d56] = 0x40cd, [0x3d57] = 0x40ce,
  [0x3d58] = 0x40cf, [0x3d59] = 0x40d0, [0x3d5a] = 0x40d1, [0x3d5b] = 0x40d2,
  [0x3d5c] = 0x40d3, [0x3d5d] = 0x40d4, [0x3d5e] = 0x40d5, [0x3d5f] = 0x40d6,
  [0x3d60] = 0x40d7, [0x3d61] = 0x40d8, [0x3d62] = 0x40d9, [0x3d63] = 0x40da,
  [0x3d64] = 0x40db, [0x3d65] = 0x40dc, [0x3d66] = 0x40dd, [0x3d67] = 0x40de,
  [0x3d68] = 0x40df, [0x3d69] = 0x40e0, [0x3d6a] = 0x40e1, [0x3d6b] = 0x40e2,
  [0x3d6c] = 0x40e3, [0x3d6d] = 0x40e4, [0x3d6e] = 0x40e5, [0x3d6f] = 0x40e6,
  [0x3d70] = 0x40e7, [0x3d71] = 0x40e8, [0x3d72] = 0x40e9, [0x3d73] = 0x40ea,
  [0x3d74] = 0x40eb, [0x3d75] = 0x40ec, [0x3d76] = 0x40ed, [0x3d77] = 0x40ee,
  [0x3d78] = 0x40ef, [0x3d79] = 0x40f0, [0x3d7a] = 0x40f1, [0x3d7b] = 0x40f2,
  [0x3d7c] = 0x40f3, [0x3d7d] = 0x40f4, [0x3d7e] = 0x40f5, [0x3d7f] = 0x40f6,
  [0x3d80] = 0x40f7, [0x3d81] = 0x40f8, [0x3d82] = 0x40f9, [0x3d83] = 0x40fa,
  [0x3d84] = 0x40fb, [0x3d85] = 0x40fc, [0x3d86] = 0x40fd, [0x3d87] = 0x40fe,
  [0x3d88] = 0x40ff, [0x3d89] = 0x4100, [0x3d8a] = 0x4101, [0x3d8b] = 0x4102,
  [0x3d8c] = 0x4103, [0x3d8d] = 0x4104, [0x3d8e] = 0x4105, [0x3d8f] = 0x4106,
  [0x3d90] = 0x4107, [0x3d91] = 0x4108, [0x3d92] = 0x4109, [0x3d93] = 0x410a,
  [0x3d94] = 0x410b, [0x3d95] = 0x410c, [0x3d96] = 0x410d, [0x3d97] = 0x410e,
  [0x3d98] = 0x410f, [0x3d99] = 0x4110, [0x3d9a] = 0x4111, [0x3d9b] = 0x4112,
  [0x3d9c] = 0x4113, [0x3d9d] = 0x4114, [0x3d9e] = 0x4115, [0x3d9f] = 0x4116,
  [0x3da0] = 0x4117, [0x3da1] = 0x4118, [0x3da2] = 0x4119, [0x3da3] = 0x411a,
  [0x3da4] = 0x411b, [0x3da5] = 0x411c, [0x3da6] = 0x411d, [0x3da7] = 0x411e,
  [0x3da8] = 0x411f, [0x3da9] = 0x4120, [0x3daa] = 0x4121, [0x3dab] = 0x4122,
  [0x3dac] = 0x4123, [0x3dad] = 0x4124, [0x3dae] = 0x4125, [0x3daf] = 0x4126,
  [0x3db0] = 0x4127, [0x3db1] = 0x4128, [0x3db2] = 0x4129, [0x3db3] = 0x412a,
  [0x3db4] = 0x412b, [0x3db5] = 0x412c, [0x3db6] = 0x412d, [0x3db7] = 0x412e,
  [0x3db8] = 0x412f, [0x3db9] = 0x4130, [0x3dba] = 0x4131, [0x3dbb] = 0x4132,
  [0x3dbc] = 0x4133, [0x3dbd] = 0x4134, [0x3dbe] = 0x4135, [0x3dbf] = 0x4136,
  [0x3dc0] = 0x4137, [0x3dc1] = 0x4138, [0x3dc2] = 0x4139, [0x3dc3] = 0x413a,
  [0x3dc4] = 0x413b, [0x3dc5] = 0x413c, [0x3dc6] = 0x413d, [0x3dc7] = 0x413e,
  [0x3dc8] = 0x413f, [0x3dc9] = 0x4140, [0x3dca] = 0x4141, [0x3dcb] = 0x4142,
  [0x3dcc] = 0x4143, [0x3dcd] = 0x4144, [0x3dce] = 0x4145, [0x3dcf] = 0x4146,
  [0x3dd0] = 0x4147, [0x3dd1] = 0x4148, [0x3dd2] = 0x4149, [0x3dd3] = 0x414a,
  [0x3dd4] = 0x414b, [0x3dd5] = 0x414c, [0x3dd6] = 0x414d, [0x3dd7] = 0x414e,
  [0x3dd8] = 0x414f, [0x3dd9] = 0x4150, [0x3dda] = 0x4151, [0x3ddb] = 0x4152,
  [0x3ddc] = 0x4153, [0x3ddd] = 0x4154, [0x3dde] = 0x4155, [0x3ddf] = 0x4156,
  [0x3de0] = 0x4157, [0x3de1] = 0x4158, [0x3de2] = 0x4159, [0x3de3] = 0x415a,
  [0x3de4] = 0x415b, [0x3de5] = 0x415c, [0x3de6] = 0x415d, [0x3de7] = 0x415e,
  [0x3de8] = 0x4160, [0x3de9] = 0x4161, [0x3dea] = 0x4162, [0x3deb] = 0x4163,
  [0x3dec] = 0x4164, [0x3ded] = 0x4165, [0x3dee] = 0x4166, [0x3def] = 0x4167,
  [0x3df0] = 0x4168, [0x3df1] = 0x4169, [0x3df2] = 0x416a, [0x3df3] = 0x416b,
  [0x3df4] = 0x416c, [0x3df5] = 0x416d, [0x3df6] = 0x416e, [0x3df7] = 0x416f,
  [0x3df8] = 0x4170, [0x3df9] = 0x4171, [0x3dfa] = 0x4172, [0x3dfb] = 0x4173,
  [0x3dfc] = 0x4174, [0x3dfd] = 0x4175, [0x3dfe] = 0x4176, [0x3dff] = 0x4177,
  [0x3e00] = 0x4178, [0x3e01] = 0x4179, [0x3e02] = 0x417a, [0x3e03] = 0x417b,
  [0x3e04] = 0x417c, [0x3e05] = 0x417d, [0x3e06] = 0x417e, [0x3e07] = 0x417f,
  [0x3e08] = 0x4180, [0x3e09] = 0x4181, [0x3e0a] = 0x4182, [0x3e0b] = 0x4183,
  [0x3e0c] = 0x4184, [0x3e0d] = 0x4185, [0x3e0e] = 0x4186, [0x3e0f] = 0x4187,
  [0x3e10] = 0x4188, [0x3e11] = 0x4189, [0x3e12] = 0x418a, [0x3e13] = 0x418b,
  [0x3e14] = 0x418c, [0x3e15] = 0x418d, [0x3e16] = 0x418e, [0x3e17] = 0x418f,
  [0x3e18] = 0x4190, [0x3e19] = 0x4191, [0x3e1a] = 0x4192, [0x3e1b] = 0x4193,
  [0x3e1c] = 0x4194, [0x3e1d] = 0x4195, [0x3e1e] = 0x4196, [0x3e1f] = 0x4197,
  [0x3e20] = 0x4198, [0x3e21] = 0x4199, [0x3e22] = 0x419a, [0x3e23] = 0x419b,
  [0x3e24] = 0x419c, [0x3e25] = 0x419d, [0x3e26] = 0x419e, [0x3e27] = 0x419f,
  [0x3e28] = 0x41a0, [0x3e29] = 0x41a1, [0x3e2a] = 0x41a2, [0x3e2b] = 0x41a3,
  [0x3e2c] = 0x41a4, [0x3e2d] = 0x41a5, [0x3e2e] = 0x41a6, [0x3e2f] = 0x41a7,
  [0x3e30] = 0x41a8, [0x3e31] = 0x41a9, [0x3e32] = 0x41aa, [0x3e33] = 0x41ab,
  [0x3e34] = 0x41ac, [0x3e35] = 0x41ad, [0x3e36] = 0x41ae, [0x3e37] = 0x41af,
  [0x3e38] = 0x41b0, [0x3e39] = 0x41b1, [0x3e3a] = 0x41b2, [0x3e3b] = 0x41b3,
  [0x3e3c] = 0x41b4, [0x3e3d] = 0x41b5, [0x3e3e] = 0x41b6, [0x3e3f] = 0x41b7,
  [0x3e40] = 0x41b8, [0x3e41] = 0x41b9, [0x3e42] = 0x41ba, [0x3e43] = 0x41bb,
  [0x3e44] = 0x41bc, [0x3e45] = 0x41bd, [0x3e46] = 0x41be, [0x3e47] = 0x41bf,
  [0x3e48] = 0x41c0, [0x3e49] = 0x41c1, [0x3e4a] = 0x41c2, [0x3e4b] = 0x41c3,
  [0x3e4c] = 0x41c4, [0x3e4d] = 0x41c5, [0x3e4e] = 0x41c6, [0x3e4f] = 0x41c7,
  [0x3e50] = 0x41c8, [0x3e51] = 0x41c9, [0x3e52] = 0x41ca, [0x3e53] = 0x41cb,
  [0x3e54] = 0x41cc, [0x3e55] = 0x41cd, [0x3e56] = 0x41ce, [0x3e57] = 0x41cf,
  [0x3e58] = 0x41d0, [0x3e59] = 0x41d1, [0x3e5a] = 0x41d2, [0x3e5b] = 0x41d3,
  [0x3e5c] = 0x41d4, [0x3e5d] = 0x41d5, [0x3e5e] = 0x41d6, [0x3e5f] = 0x41d7,
  [0x3e60] = 0x41d8, [0x3e61] = 0x41d9, [0x3e62] = 0x41da, [0x3e63] = 0x41db,
  [0x3e64] = 0x41dc, [0x3e65] = 0x41dd, [0x3e66] = 0x41de, [0x3e67] = 0x41df,
  [0x3e68] = 0x41e0, [0x3e69] = 0x41e1, [0x3e6a] = 0x41e2, [0x3e6b] = 0x41e3,
  [0x3e6c] = 0x41e4, [0x3e6d] = 0x41e5, [0x3e6e] = 0x41e6, [0x3e6f] = 0x41e7,
  [0x3e70] = 0x41e8, [0x3e71] = 0x41e9, [0x3e72] = 0x41ea, [0x3e73] = 0x41eb,
  [0x3e74] = 0x41ec, [0x3e75] = 0x41ed, [0x3e76] = 0x41ee, [0x3e77] = 0x41ef,
  [0x3e78] = 0x41f0, [0x3e79] = 0x41f1, [0x3e7a] = 0x41f2, [0x3e7b] = 0x41f3,
  [0x3e7c] = 0x41f4, [0x3e7d] = 0x41f5, [0x3e7e] = 0x41f6, [0x3e7f] = 0x41f7,
  [0x3e80] = 0x41f8, [0x3e81] = 0x41f9, [0x3e82] = 0x41fa, [0x3e83] = 0x41fb,
  [0x3e84] = 0x41fc, [0x3e85] = 0x41fd, [0x3e86] = 0x41fe, [0x3e87] = 0x41ff,
  [0x3e88] = 0x4200, [0x3e89] = 0x4201, [0x3e8a] = 0x4202, [0x3e8b] = 0x4203,
  [0x3e8c] = 0x4204, [0x3e8d] = 0x4205, [0x3e8e] = 0x4206, [0x3e8f] = 0x4207,
  [0x3e90] = 0x4208, [0x3e91] = 0x4209, [0x3e92] = 0x420a, [0x3e93] = 0x420b,
  [0x3e94] = 0x420c, [0x3e95] = 0x420d, [0x3e96] = 0x420e, [0x3e97] = 0x420f,
  [0x3e98] = 0x4210, [0x3e99] = 0x4211, [0x3e9a] = 0x4212, [0x3e9b] = 0x4213,
  [0x3e9c] = 0x4214, [0x3e9d] = 0x4215, [0x3e9e] = 0x4216, [0x3e9f] = 0x4217,
  [0x3ea0] = 0x4218, [0x3ea1] = 0x4219, [0x3ea2] = 0x421a, [0x3ea3] = 0x421b,
  [0x3ea4] = 0x421c, [0x3ea5] = 0x421d, [0x3ea6] = 0x421e, [0x3ea7] = 0x421f,
  [0x3ea8] = 0x4220, [0x3ea9] = 0x4221, [0x3eaa] = 0x4222, [0x3eab] = 0x4223,
  [0x3eac] = 0x4224, [0x3ead] = 0x4225, [0x3eae] = 0x4226, [0x3eaf] = 0x4227,
  [0x3eb0] = 0x4228, [0x3eb1] = 0x4229, [0x3eb2] = 0x422a, [0x3eb3] = 0x422b,
  [0x3eb4] = 0x422c, [0x3eb5] = 0x422d, [0x3eb6] = 0x422e, [0x3eb7] = 0x422f,
  [0x3eb8] = 0x4230, [0x3eb9] = 0x4231, [0x3eba] = 0x4232, [0x3ebb] = 0x4233,
  [0x3ebc] = 0x4234, [0x3ebd] = 0x4235, [0x3ebe] = 0x4236, [0x3ebf] = 0x4237,
  [0x3ec0] = 0x4238, [0x3ec1] = 0x4239, [0x3ec2] = 0x423a, [0x3ec3] = 0x423b,
  [0x3ec4] = 0x423c, [0x3ec5] = 0x423d, [0x3ec6] = 0x423e, [0x3ec7] = 0x423f,
  [0x3ec8] = 0x4240, [0x3ec9] = 0x4241, [0x3eca] = 0x4242, [0x3ecb] = 0x4243,
  [0x3ecc] = 0x4244, [0x3ecd] = 0x4245, [0x3ece] = 0x4246, [0x3ecf] = 0x4247,
  [0x3ed0] = 0x4248, [0x3ed1] = 0x4249, [0x3ed2] = 0x424a, [0x3ed3] = 0x424b,
  [0x3ed4] = 0x424c, [0x3ed5] = 0x424d, [0x3ed6] = 0x424e, [0x3ed7] = 0x424f,
  [0x3ed8] = 0x4250, [0x3ed9] = 0x4251, [0x3eda] = 0x4252, [0x3edb] = 0x4253,
  [0x3edc] = 0x4254, [0x3edd] = 0x4255, [0x3ede] = 0x4256, [0x3edf] = 0x4257,
  [0x3ee0] = 0x4258, [0x3ee1] = 0x4259, [0x3ee2] = 0x425a, [0x3ee3] = 0x425b,
  [0x3ee4] = 0x425c, [0x3ee5] = 0x425d, [0x3ee6] = 0x425e, [0x3ee7] = 0x425f,
  [0x3ee8] = 0x4260, [0x3ee9] = 0x4261, [0x3eea] = 0x4262, [0x3eeb] = 0x4263,
  [0x3eec] = 0x4264, [0x3eed] = 0x4265, [0x3eee] = 0x4266, [0x3eef] = 0x4267,
  [0x3ef0] = 0x4268, [0x3ef1] = 0x4269, [0x3ef2] = 0x426a, [0x3ef3] = 0x426b,
  [0x3ef4] = 0x426c, [0x3ef5] = 0x426d, [0x3ef6] = 0x426e, [0x3ef7] = 0x426f,
  [0x3ef8] = 0x4270, [0x3ef9] = 0x4271, [0x3efa] = 0x4272, [0x3efb] = 0x4273,
  [0x3efc] = 0x4274, [0x3efd] = 0x4275, [0x3efe] = 0x4276, [0x3eff] = 0x4277,
  [0x3f00] = 0x4278, [0x3f01] = 0x4279, [0x3f02] = 0x427a, [0x3f03] = 0x427b,
  [0x3f04] = 0x427c, [0x3f05] = 0x427d, [0x3f06] = 0x427e, [0x3f07] = 0x427f,
  [0x3f08] = 0x4280, [0x3f09] = 0x4281, [0x3f0a] = 0x4282, [0x3f0b] = 0x4283,
  [0x3f0c] = 0x4284, [0x3f0d] = 0x4285, [0x3f0e] = 0x4286, [0x3f0f] = 0x4287,
  [0x3f10] = 0x4288, [0x3f11] = 0x4289, [0x3f12] = 0x428a, [0x3f13] = 0x428b,
  [0x3f14] = 0x428c, [0x3f15] = 0x428d, [0x3f16] = 0x428e, [0x3f17] = 0x428f,
  [0x3f18] = 0x4290, [0x3f19] = 0x4291, [0x3f1a] = 0x4292, [0x3f1b] = 0x4293,
  [0x3f1c] = 0x4294, [0x3f1d] = 0x4295, [0x3f1e] = 0x4296, [0x3f1f] = 0x4297,
  [0x3f20] = 0x4298, [0x3f21] = 0x4299, [0x3f22] = 0x429a, [0x3f23] = 0x429b,
  [0x3f24] = 0x429c, [0x3f25] = 0x429d, [0x3f26] = 0x429e, [0x3f27] = 0x429f,
  [0x3f28] = 0x42a0, [0x3f29] = 0x42a1, [0x3f2a] = 0x42a2, [0x3f2b] = 0x42a3,
  [0x3f2c] = 0x42a4, [0x3f2d] = 0x42a5, [0x3f2e] = 0x42a6, [0x3f2f] = 0x42a7,
  [0x3f30] = 0x42a8, [0x3f31] = 0x42a9, [0x3f32] = 0x42aa, [0x3f33] = 0x42ab,
  [0x3f34] = 0x42ac, [0x3f35] = 0x42ad, [0x3f36] = 0x42ae, [0x3f37] = 0x42af,
  [0x3f38] = 0x42b0, [0x3f39] = 0x42b1, [0x3f3a] = 0x42b2, [0x3f3b] = 0x42b3,
  [0x3f3c] = 0x42b4, [0x3f3d] = 0x42b5, [0x3f3e] = 0x42b6, [0x3f3f] = 0x42b7,
  [0x3f40] = 0x42b8, [0x3f41] = 0x42b9, [0x3f42] = 0x42ba, [0x3f43] = 0x42bb,
  [0x3f44] = 0x42bc, [0x3f45] = 0x42bd, [0x3f46] = 0x42be, [0x3f47] = 0x42bf,
  [0x3f48] = 0x42c0, [0x3f49] = 0x42c1, [0x3f4a] = 0x42c2, [0x3f4b] = 0x42c3,
  [0x3f4c] = 0x42c4, [0x3f4d] = 0x42c5, [0x3f4e] = 0x42c6, [0x3f4f] = 0x42c7,
  [0x3f50] = 0x42c8, [0x3f51] = 0x42c9, [0x3f52] = 0x42ca, [0x3f53] = 0x42cb,
  [0x3f54] = 0x42cc, [0x3f55] = 0x42cd, [0x3f56] = 0x42ce, [0x3f57] = 0x42cf,
  [0x3f58] = 0x42d0, [0x3f59] = 0x42d1, [0x3f5a] = 0x42d2, [0x3f5b] = 0x42d3,
  [0x3f5c] = 0x42d4, [0x3f5d] = 0x42d5, [0x3f5e] = 0x42d6, [0x3f5f] = 0x42d7,
  [0x3f60] = 0x42d8, [0x3f61] = 0x42d9, [0x3f62] = 0x42da, [0x3f63] = 0x42db,
  [0x3f64] = 0x42dc, [0x3f65] = 0x42dd, [0x3f66] = 0x42de, [0x3f67] = 0x42df,
  [0x3f68] = 0x42e0, [0x3f69] = 0x42e1, [0x3f6a] = 0x42e2, [0x3f6b] = 0x42e3,
  [0x3f6c] = 0x42e4, [0x3f6d] = 0x42e5, [0x3f6e] = 0x42e6, [0x3f6f] = 0x42e7,
  [0x3f70] = 0x42e8, [0x3f71] = 0x42e9, [0x3f72] = 0x42ea, [0x3f73] = 0x42eb,
  [0x3f74] = 0x42ec, [0x3f75] = 0x42ed, [0x3f76] = 0x42ee, [0x3f77] = 0x42ef,
  [0x3f78] = 0x42f0, [0x3f79] = 0x42f1, [0x3f7a] = 0x42f2, [0x3f7b] = 0x42f3,
  [0x3f7c] = 0x42f4, [0x3f7d] = 0x42f5, [0x3f7e] = 0x42f6, [0x3f7f] = 0x42f7,
  [0x3f80] = 0x42f8, [0x3f81] = 0x42f9, [0x3f82] = 0x42fa, [0x3f83] = 0x42fb,
  [0x3f84] = 0x42fc, [0x3f85] = 0x42fd, [0x3f86] = 0x42fe, [0x3f87] = 0x42ff,
  [0x3f88] = 0x4300, [0x3f89] = 0x4301, [0x3f8a] = 0x4302, [0x3f8b] = 0x4303,
  [0x3f8c] = 0x4304, [0x3f8d] = 0x4305, [0x3f8e] = 0x4306, [0x3f8f] = 0x4307,
  [0x3f90] = 0x4308, [0x3f91] = 0x4309, [0x3f92] = 0x430a, [0x3f93] = 0x430b,
  [0x3f94] = 0x430c, [0x3f95] = 0x430d, [0x3f96] = 0x430e, [0x3f97] = 0x430f,
  [0x3f98] = 0x4310, [0x3f99] = 0x4311, [0x3f9a] = 0x4312, [0x3f9b] = 0x4313,
  [0x3f9c] = 0x4314, [0x3f9d] = 0x4315, [0x3f9e] = 0x4316, [0x3f9f] = 0x4317,
  [0x3fa0] = 0x4318, [0x3fa1] = 0x4319, [0x3fa2] = 0x431a, [0x3fa3] = 0x431b,
  [0x3fa4] = 0x431c, [0x3fa5] = 0x431d, [0x3fa6] = 0x431e, [0x3fa7] = 0x431f,
  [0x3fa8] = 0x4320, [0x3fa9] = 0x4321, [0x3faa] = 0x4322, [0x3fab] = 0x4323,
  [0x3fac] = 0x4324, [0x3fad] = 0x4325, [0x3fae] = 0x4326, [0x3faf] = 0x4327,
  [0x3fb0] = 0x4328, [0x3fb1] = 0x4329, [0x3fb2] = 0x432a, [0x3fb3] = 0x432b,
  [0x3fb4] = 0x432c, [0x3fb5] = 0x432d, [0x3fb6] = 0x432e, [0x3fb7] = 0x432f,
  [0x3fb8] = 0x4330, [0x3fb9] = 0x4331, [0x3fba] = 0x4332, [0x3fbb] = 0x4333,
  [0x3fbc] = 0x4334, [0x3fbd] = 0x4335, [0x3fbe] = 0x4336, [0x3fbf] = 0x4338,
  [0x3fc0] = 0x4339, [0x3fc1] = 0x433a, [0x3fc2] = 0x433b, [0x3fc3] = 0x433c,
  [0x3fc4] = 0x433d, [0x3fc5] = 0x433e, [0x3fc6] = 0x433f, [0x3fc7] = 0x4340,
  [0x3fc8] = 0x4341, [0x3fc9] = 0x4342, [0x3fca] = 0x4343, [0x3fcb] = 0x4344,
  [0x3fcc] = 0x4345, [0x3fcd] = 0x4346, [0x3fce] = 0x4347, [0x3fcf] = 0x4348,
  [0x3fd0] = 0x4349, [0x3fd1] = 0x434a, [0x3fd2] = 0x434b, [0x3fd3] = 0x434c,
  [0x3fd4] = 0x434d, [0x3fd5] = 0x434e, [0x3fd6] = 0x434f, [0x3fd7] = 0x4350,
  [0x3fd8] = 0x4351, [0x3fd9] = 0x4352, [0x3fda] = 0x4353, [0x3fdb] = 0x4354,
  [0x3fdc] = 0x4355, [0x3fdd] = 0x4356, [0x3fde] = 0x4357, [0x3fdf] = 0x4358,
  [0x3fe0] = 0x4359, [0x3fe1] = 0x435a, [0x3fe2] = 0x435b, [0x3fe3] = 0x435c,
  [0x3fe4] = 0x435d, [0x3fe5] = 0x435e, [0x3fe6] = 0x435f, [0x3fe7] = 0x4360,
  [0x3fe8] = 0x4361, [0x3fe9] = 0x4362, [0x3fea] = 0x4363, [0x3feb] = 0x4364,
  [0x3fec] = 0x4365, [0x3fed] = 0x4366, [0x3fee] = 0x4367, [0x3fef] = 0x4368,
  [0x3ff0] = 0x4369, [0x3ff1] = 0x436a, [0x3ff2] = 0x436b, [0x3ff3] = 0x436c,
  [0x3ff4] = 0x436d, [0x3ff5] = 0x436e, [0x3ff6] = 0x436f, [0x3ff7] = 0x4370,
  [0x3ff8] = 0x4371, [0x3ff9] = 0x4372, [0x3ffa] = 0x4373, [0x3ffb] = 0x4374,
  [0x3ffc] = 0x4375, [0x3ffd] = 0x4376, [0x3ffe] = 0x4377, [0x3fff] = 0x4378,
  [0x4000] = 0x4379, [0x4001] = 0x437a, [0x4002] = 0x437b, [0x4003] = 0x437c,
  [0x4004] = 0x437d, [0x4005] = 0x437e, [0x4006] = 0x437f, [0x4007] = 0x4380,
  [0x4008] = 0x4381, [0x4009] = 0x4382, [0x400a] = 0x4383, [0x400b] = 0x4384,
  [0x400c] = 0x4385, [0x400d] = 0x4386, [0x400e] = 0x4387, [0x400f] = 0x4388,
  [0x4010] = 0x4389, [0x4011] = 0x438a, [0x4012] = 0x438b, [0x4013] = 0x438c,
  [0x4014] = 0x438d, [0x4015] = 0x438e, [0x4016] = 0x438f, [0x4017] = 0x4390,
  [0x4018] = 0x4391, [0x4019] = 0x4392, [0x401a] = 0x4393, [0x401b] = 0x4394,
  [0x401c] = 0x4395, [0x401d] = 0x4396, [0x401e] = 0x4397, [0x401f] = 0x4398,
  [0x4020] = 0x4399, [0x4021] = 0x439a, [0x4022] = 0x439b, [0x4023] = 0x439c,
  [0x4024] = 0x439d, [0x4025] = 0x439e, [0x4026] = 0x439f, [0x4027] = 0x43a0,
  [0x4028] = 0x43a1, [0x4029] = 0x43a2, [0x402a] = 0x43a3, [0x402b] = 0x43a4,
  [0x402c] = 0x43a5, [0x402d] = 0x43a6, [0x402e] = 0x43a7, [0x402f] = 0x43a8,
  [0x4030] = 0x43a9, [0x4031] = 0x43aa, [0x4032] = 0x43ab, [0x4033] = 0x43ad,
  [0x4034] = 0x43ae, [0x4035] = 0x43af, [0x4036] = 0x43b0, [0x4037] = 0x43b2,
  [0x4038] = 0x43b3, [0x4039] = 0x43b4, [0x403a] = 0x43b5, [0x403b] = 0x43b6,
  [0x403c] = 0x43b7, [0x403d] = 0x43b8, [0x403e] = 0x43b9, [0x403f] = 0x43ba,
  [0x4040] = 0x43bb, [0x4041] = 0x43bc, [0x4042] = 0x43bd, [0x4043] = 0x43be,
  [0x4044] = 0x43bf, [0x4045] = 0x43c0, [0x4046] = 0x43c1, [0x4047] = 0x43c2,
  [0x4048] = 0x43c3, [0x4049] = 0x43c4, [0x404a] = 0x43c5, [0x404b] = 0x43c6,
  [0x404c] = 0x43c7, [0x404d] = 0x43c8, [0x404e] = 0x43c9, [0x404f] = 0x43ca,
  [0x4050] = 0x43cb, [0x4051] = 0x43cc, [0x4052] = 0x43cd, [0x4053] = 0x43ce,
  [0x4054] = 0x43cf, [0x4055] = 0x43d0, [0x4056] = 0x43d1, [0x4057] = 0x43d2,
  [0x4058] = 0x43d3, [0x4059] = 0x43d4, [0x405a] = 0x43d5, [0x405b] = 0x43d6,
  [0x405c] = 0x43d7, [0x405d] = 0x43d8, [0x405e] = 0x43d9, [0x405f] = 0x43da,
  [0x4060] = 0x43db, [0x4061] = 0x43dc, [0x4062] = 0x43de, [0x4063] = 0x43df,
  [0x4064] = 0x43e0, [0x4065] = 0x43e1, [0x4066] = 0x43e2, [0x4067] = 0x43e3,
  [0x4068] = 0x43e4, [0x4069] = 0x43e5, [0x406a] = 0x43e6, [0x406b] = 0x43e7,
  [0x406c] = 0x43e8, [0x406d] = 0x43e9, [0x406e] = 0x43ea, [0x406f] = 0x43eb,
  [0x4070] = 0x43ec, [0x4071] = 0x43ed, [0x4072] = 0x43ee, [0x4073] = 0x43ef,
  [0x4074] = 0x43f0, [0x4075] = 0x43f1, [0x4076] = 0x43f2, [0x4077] = 0x43f3,
  [0x4078] = 0x43f4, [0x4079] = 0x43f5, [0x407a] = 0x43f6, [0x407b] = 0x43f7,
  [0x407c] = 0x43f8, [0x407d] = 0x43f9, [0x407e] = 0x43fa, [0x407f] = 0x43fb,
  [0x4080] = 0x43fc, [0x4081] = 0x43fd, [0x4082] = 0x43fe, [0x4083] = 0x43ff,
  [0x4084] = 0x4400, [0x4085] = 0x4401, [0x4086] = 0x4402, [0x4087] = 0x4403,
  [0x4088] = 0x4404, [0x4089] = 0x4405, [0x408a] = 0x4406, [0x408b] = 0x4407,
  [0x408c] = 0x4408, [0x408d] = 0x4409, [0x408e] = 0x440a, [0x408f] = 0x440b,
  [0x4090] = 0x440c, [0x4091] = 0x440d, [0x4092] = 0x440e, [0x4093] = 0x440f,
  [0x4094] = 0x4410, [0x4095] = 0x4411, [0x4096] = 0x4412, [0x4097] = 0x4413,
  [0x4098] = 0x4414, [0x4099] = 0x4415, [0x409a] = 0x4416, [0x409b] = 0x4417,
  [0x409c] = 0x4418, [0x409d] = 0x4419, [0x409e] = 0x441a, [0x409f] = 0x441b,
  [0x40a0] = 0x441c, [0x40a1] = 0x441d, [0x40a2] = 0x441e, [0x40a3] = 0x441f,
  [0x40a4] = 0x4420, [0x40a5] = 0x4421, [0x40a6] = 0x4422, [0x40a7] = 0x4423,
  [0x40a8] = 0x4424, [0x40a9] = 0x4425, [0x40aa] = 0x4426, [0x40ab] = 0x4427,
  [0x40ac] = 0x4428, [0x40ad] = 0x4429, [0x40ae] = 0x442a, [0x40af] = 0x442b,
  [0x40b0] = 0x442c, [0x40b1] = 0x442d, [0x40b2] = 0x442e, [0x40b3] = 0x442f,
  [0x40b4] = 0x4430, [0x40b5] = 0x4431, [0x40b6] = 0x4432, [0x40b7] = 0x4433,
  [0x40b8] = 0x4434, [0x40b9] = 0x4435, [0x40ba] = 0x4436, [0x40bb] = 0x4437,
  [0x40bc] = 0x4438, [0x40bd] = 0x4439, [0x40be] = 0x443a, [0x40bf] = 0x443b,
  [0x40c0] = 0x443c, [0x40c1] = 0x443d, [0x40c2] = 0x443e, [0x40c3] = 0x443f,
  [0x40c4] = 0x4440, [0x40c5] = 0x4441, [0x40c6] = 0x4442, [0x40c7] = 0x4443,
  [0x40c8] = 0x4444, [0x40c9] = 0x4445, [0x40ca] = 0x4446, [0x40cb] = 0x4447,
  [0x40cc] = 0x4448, [0x40cd] = 0x4449, [0x40ce] = 0x444a, [0x40cf] = 0x444b,
  [0x40d0] = 0x444c, [0x40d1] = 0x444d, [0x40d2] = 0x444e, [0x40d3] = 0x444f,
  [0x40d4] = 0x4450, [0x40d5] = 0x4451, [0x40d6] = 0x4452, [0x40d7] = 0x4453,
  [0x40d8] = 0x4454, [0x40d9] = 0x4455, [0x40da] = 0x4456, [0x40db] = 0x4457,
  [0x40dc] = 0x4458, [0x40dd] = 0x4459, [0x40de] = 0x445a, [0x40df] = 0x445b,
  [0x40e0] = 0x445c, [0x40e1] = 0x445d, [0x40e2] = 0x445e, [0x40e3] = 0x445f,
  [0x40e4] = 0x4460, [0x40e5] = 0x4461, [0x40e6] = 0x4462, [0x40e7] = 0x4463,
  [0x40e8] = 0x4464, [0x40e9] = 0x4465, [0x40ea] = 0x4466, [0x40eb] = 0x4467,
  [0x40ec] = 0x4468, [0x40ed] = 0x4469, [0x40ee] = 0x446a, [0x40ef] = 0x446b,
  [0x40f0] = 0x446c, [0x40f1] = 0x446d, [0x40f2] = 0x446e, [0x40f3] = 0x446f,
  [0x40f4] = 0x4470, [0x40f5] = 0x4471, [0x40f6] = 0x4472, [0x40f7] = 0x4473,
  [0x40f8] = 0x4474, [0x40f9] = 0x4475, [0x40fa] = 0x4476, [0x40fb] = 0x4477,
  [0x40fc] = 0x4478, [0x40fd] = 0x4479, [0x40fe] = 0x447a, [0x40ff] = 0x447b,
  [0x4100] = 0x447c, [0x4101] = 0x447d, [0x4102] = 0x447e, [0x4103] = 0x447f,
  [0x4104] = 0x4480, [0x4105] = 0x4481, [0x4106] = 0x4482, [0x4107] = 0x4483,
  [0x4108] = 0x4484, [0x4109] = 0x4485, [0x410a] = 0x4486, [0x410b] = 0x4487,
  [0x410c] = 0x4488, [0x410d] = 0x4489, [0x410e] = 0x448a, [0x410f] = 0x448b,
  [0x4110] = 0x448c, [0x4111] = 0x448d, [0x4112] = 0x448e, [0x4113] = 0x448f,
  [0x4114] = 0x4490, [0x4115] = 0x4491, [0x4116] = 0x4492, [0x4117] = 0x4493,
  [0x4118] = 0x4494, [0x4119] = 0x4495, [0x411a] = 0x4496, [0x411b] = 0x4497,
  [0x411c] = 0x4498, [0x411d] = 0x4499, [0x411e] = 0x449a, [0x411f] = 0x449b,
  [0x4120] = 0x449c, [0x4121] = 0x449d, [0x4122] = 0x449e, [0x4123] = 0x449f,
  [0x4124] = 0x44a0, [0x4125] = 0x44a1, [0x4126] = 0x44a2, [0x4127] = 0x44a3,
  [0x4128] = 0x44a4, [0x4129] = 0x44a5, [0x412a] = 0x44a6, [0x412b] = 0x44a7,
  [0x412c] = 0x44a8, [0x412d] = 0x44a9, [0x412e] = 0x44aa, [0x412f] = 0x44ab,
  [0x4130] = 0x44ac, [0x4131] = 0x44ad, [0x4132] = 0x44ae, [0x4133] = 0x44af,
  [0x4134] = 0x44b0, [0x4135] = 0x44b1, [0x4136] = 0x44b2, [0x4137] = 0x44b3,
  [0x4138] = 0x44b4, [0x4139] = 0x44b5, [0x413a] = 0x44b6, [0x413b] = 0x44b7,
  [0x413c] = 0x44b8, [0x413d] = 0x44b9, [0x413e] = 0x44ba, [0x413f] = 0x44bb,
  [0x4140] = 0x44bc, [0x4141] = 0x44bd, [0x4142] = 0x44be, [0x4143] = 0x44bf,
  [0x4144] = 0x44c0, [0x4145] = 0x44c1, [0x4146] = 0x44c2, [0x4147] = 0x44c3,
  [0x4148] = 0x44c4, [0x4149] = 0x44c5, [0x414a] = 0x44c6, [0x414b] = 0x44c7,
  [0x414c] = 0x44c8, [0x414d] = 0x44c9, [0x414e] = 0x44ca, [0x414f] = 0x44cb,
  [0x4150] = 0x44cc, [0x4151] = 0x44cd, [0x4152] = 0x44ce, [0x4153] = 0x44cf,
  [0x4154] = 0x44d0, [0x4155] = 0x44d1, [0x4156] = 0x44d2, [0x4157] = 0x44d3,
  [0x4158] = 0x44d4, [0x4159] = 0x44d5, [0x415a] = 0x44d7, [0x415b] = 0x44d8,
  [0x415c] = 0x44d9, [0x415d] = 0x44da, [0x415e] = 0x44db, [0x415f] = 0x44dc,
  [0x4160] = 0x44dd, [0x4161] = 0x44de, [0x4162] = 0x44df, [0x4163] = 0x44e0,
  [0x4164] = 0x44e1, [0x4165] = 0x44e2, [0x4166] = 0x44e3, [0x4167] = 0x44e4,
  [0x4168] = 0x44e5, [0x4169] = 0x44e6, [0x416a] = 0x44e7, [0x416b] = 0x44e8,
  [0x416c] = 0x44e9, [0x416d] = 0x44ea, [0x416e] = 0x44eb, [0x416f] = 0x44ec,
  [0x4170] = 0x44ed, [0x4171] = 0x44ee, [0x4172] = 0x44ef, [0x4173] = 0x44f0,
  [0x4174] = 0x44f1, [0x4175] = 0x44f2, [0x4176] = 0x44f3, [0x4177] = 0x44f4,
  [0x4178] = 0x44f5, [0x4179] = 0x44f6, [0x417a] = 0x44f7, [0x417b] = 0x44f8,
  [0x417c] = 0x44f9, [0x417d] = 0x44fa, [0x417e] = 0x44fb, [0x417f] = 0x44fc,
  [0x4180] = 0x44fd, [0x4181] = 0x44fe, [0x4182] = 0x44ff, [0x4183] = 0x4500,
  [0x4184] = 0x4501, [0x4185] = 0x4502, [0x4186] = 0x4503, [0x4187] = 0x4504,
  [0x4188] = 0x4505, [0x4189] = 0x4506, [0x418a] = 0x4507, [0x418b] = 0x4508,
  [0x418c] = 0x4509, [0x418d] = 0x450a, [0x418e] = 0x450b, [0x418f] = 0x450c,
  [0x4190] = 0x450d, [0x4191] = 0x450e, [0x4192] = 0x450f, [0x4193] = 0x4510,
  [0x4194] = 0x4511, [0x4195] = 0x4512, [0x4196] = 0x4513, [0x4197] = 0x4514,
  [0x4198] = 0x4515, [0x4199] = 0x4516, [0x419a] = 0x4517, [0x419b] = 0x4518,
  [0x419c] = 0x4519, [0x419d] = 0x451a, [0x419e] = 0x451b, [0x419f] = 0x451c,
  [0x41a0] = 0x451d, [0x41a1] = 0x451e, [0x41a2] = 0x451f, [0x41a3] = 0x4520,
  [0x41a4] = 0x4521, [0x41a5] = 0x4522, [0x41a6] = 0x4523, [0x41a7] = 0x4524,
  [0x41a8] = 0x4525, [0x41a9] = 0x4526, [0x41aa] = 0x4527, [0x41ab] = 0x4528,
  [0x41ac] = 0x4529, [0x41ad] = 0x452a, [0x41ae] = 0x452b, [0x41af] = 0x452c,
  [0x41b0] = 0x452d, [0x41b1] = 0x452e, [0x41b2] = 0x452f, [0x41b3] = 0x4530,
  [0x41b4] = 0x4531, [0x41b5] = 0x4532, [0x41b6] = 0x4533, [0x41b7] = 0x4534,
  [0x41b8] = 0x4535, [0x41b9] = 0x4536, [0x41ba] = 0x4537, [0x41bb] = 0x4538,
  [0x41bc] = 0x4539, [0x41bd] = 0x453a, [0x41be] = 0x453b, [0x41bf] = 0x453c,
  [0x41c0] = 0x453d, [0x41c1] = 0x453e, [0x41c2] = 0x453f, [0x41c3] = 0x4540,
  [0x41c4] = 0x4541, [0x41c5] = 0x4542, [0x41c6] = 0x4543, [0x41c7] = 0x4544,
  [0x41c8] = 0x4545, [0x41c9] = 0x4546, [0x41ca] = 0x4547, [0x41cb] = 0x4548,
  [0x41cc] = 0x4549, [0x41cd] = 0x454a, [0x41ce] = 0x454b, [0x41cf] = 0x454c,
  [0x41d0] = 0x454d, [0x41d1] = 0x454e, [0x41d2] = 0x454f, [0x41d3] = 0x4550,
  [0x41d4] = 0x4551, [0x41d5] = 0x4552, [0x41d6] = 0x4553, [0x41d7] = 0x4554,
  [0x41d8] = 0x4555, [0x41d9] = 0x4556, [0x41da] = 0x4557, [0x41db] = 0x4558,
  [0x41dc] = 0x4559, [0x41dd] = 0x455a, [0x41de] = 0x455b, [0x41df] = 0x455c,
  [0x41e0] = 0x455d, [0x41e1] = 0x455e, [0x41e2] = 0x455f, [0x41e3] = 0x4560,
  [0x41e4] = 0x4561, [0x41e5] = 0x4562, [0x41e6] = 0x4563, [0x41e7] = 0x4564,
  [0x41e8] = 0x4565, [0x41e9] = 0x4566, [0x41ea] = 0x4567, [0x41eb] = 0x4568,
  [0x41ec] = 0x4569, [0x41ed] = 0x456a, [0x41ee] = 0x456b, [0x41ef] = 0x456c,
  [0x41f0] = 0x456d, [0x41f1] = 0x456e, [0x41f2] = 0x456f, [0x41f3] = 0x4570,
  [0x41f4] = 0x4571, [0x41f5] = 0x4572, [0x41f6] = 0x4573, [0x41f7] = 0x4574,
  [0x41f8] = 0x4575, [0x41f9] = 0x4576, [0x41fa] = 0x4577, [0x41fb] = 0x4578,
  [0x41fc] = 0x4579, [0x41fd] = 0x457a, [0x41fe] = 0x457b, [0x41ff] = 0x457c,
  [0x4200] = 0x457d, [0x4201] = 0x457e, [0x4202] = 0x457f, [0x4203] = 0x4580,
  [0x4204] = 0x4581, [0x4205] = 0x4582, [0x4206] = 0x4583, [0x4207] = 0x4584,
  [0x4208] = 0x4585, [0x4209] = 0x4586, [0x420a] = 0x4587, [0x420b] = 0x4588,
  [0x420c] = 0x4589, [0x420d] = 0x458a, [0x420e] = 0x458b, [0x420f] = 0x458c,
  [0x4210] = 0x458d, [0x4211] = 0x458e, [0x4212] = 0x458f, [0x4213] = 0x4590,
  [0x4214] = 0x4591, [0x4215] = 0x4592, [0x4216] = 0x4593, [0x4217] = 0x4594,
  [0x4218] = 0x4595, [0x4219] = 0x4596, [0x421a] = 0x4597, [0x421b] = 0x4598,
  [0x421c] = 0x4599, [0x421d] = 0x459a, [0x421e] = 0x459b, [0x421f] = 0x459c,
  [0x4220] = 0x459d, [0x4221] = 0x459e, [0x4222] = 0x459f, [0x4223] = 0x45a0,
  [0x4224] = 0x45a1, [0x4225] = 0x45a2, [0x4226] = 0x45a3, [0x4227] = 0x45a4,
  [0x4228] = 0x45a5, [0x4229] = 0x45a6, [0x422a] = 0x45a7, [0x422b] = 0x45a8,
  [0x422c] = 0x45a9, [0x422d] = 0x45aa, [0x422e] = 0x45ab, [0x422f] = 0x45ac,
  [0x4230] = 0x45ad, [0x4231] = 0x45ae, [0x4232] = 0x45af, [0x4233] = 0x45b0,
  [0x4234] = 0x45b1, [0x4235] = 0x45b2, [0x4236] = 0x45b3, [0x4237] = 0x45b4,
  [0x4238] = 0x45b5, [0x4239] = 0x45b6, [0x423a] = 0x45b7, [0x423b] = 0x45b8,
  [0x423c] = 0x45b9, [0x423d] = 0x45ba, [0x423e] = 0x45bb, [0x423f] = 0x45bc,
  [0x4240] = 0x45bd, [0x4241] = 0x45be, [0x4242] = 0x45bf, [0x4243] = 0x45c0,
  [0x4244] = 0x45c1, [0x4245] = 0x45c2, [0x4246] = 0x45c3, [0x4247] = 0x45c4,
  [0x4248] = 0x45c5, [0x4249] = 0x45c6, [0x424a] = 0x45c7, [0x424b] = 0x45c8,
  [0x424c] = 0x45c9, [0x424d] = 0x45ca, [0x424e] = 0x45cb, [0x424f] = 0x45cc,
  [0x4250] = 0x45cd, [0x4251] = 0x45ce, [0x4252] = 0x45cf, [0x4253] = 0x45d0,
  [0x4254] = 0x45d1, [0x4255] = 0x45d2, [0x4256] = 0x45d3, [0x4257] = 0x45d4,
  [0x4258] = 0x45d5, [0x4259] = 0x45d6, [0x425a] = 0x45d7, [0x425b] = 0x45d8,
  [0x425c] = 0x45d9, [0x425d] = 0x45da, [0x425e] = 0x45db, [0x425f] = 0x45dc,
  [0x4260] = 0x45dd, [0x4261] = 0x45de, [0x4262] = 0x45df, [0x4263] = 0x45e0,
  [0x4264] = 0x45e1, [0x4265] = 0x45e2, [0x4266] = 0x45e3, [0x4267] = 0x45e4,
  [0x4268] = 0x45e5, [0x4269] = 0x45e6, [0x426a] = 0x45e7, [0x426b] = 0x45e8,
  [0x426c] = 0x45e9, [0x426d] = 0x45ea, [0x426e] = 0x45eb, [0x426f] = 0x45ec,
  [0x4270] = 0x45ed, [0x4271] = 0x45ee, [0x4272] = 0x45ef, [0x4273] = 0x45f0,
  [0x4274] = 0x45f1, [0x4275] = 0x45f2, [0x4276] = 0x45f3, [0x4277] = 0x45f4,
  [0x4278] = 0x45f5, [0x4279] = 0x45f6, [0x427a] = 0x45f7, [0x427b] = 0x45f8,
  [0x427c] = 0x45f9, [0x427d] = 0x45fa, [0x427e] = 0x45fb, [0x427f] = 0x45fc,
  [0x4280] = 0x45fd, [0x4281] = 0x45fe, [0x4282] = 0x45ff, [0x4283] = 0x4600,
  [0x4284] = 0x4601, [0x4285] = 0x4602, [0x4286] = 0x4603, [0x4287] = 0x4604,
  [0x4288] = 0x4605, [0x4289] = 0x4606, [0x428a] = 0x4607, [0x428b] = 0x4608,
  [0x428c] = 0x4609, [0x428d] = 0x460a, [0x428e] = 0x460b, [0x428f] = 0x460c,
  [0x4290] = 0x460d, [0x4291] = 0x460e, [0x4292] = 0x460f, [0x4293] = 0x4610,
  [0x4294] = 0x4611, [0x4295] = 0x4612, [0x4296] = 0x4613, [0x4297] = 0x4614,
  [0x4298] = 0x4615, [0x4299] = 0x4616, [0x429a] = 0x4617, [0x429b] = 0x4618,
  [0x429c] = 0x4619, [0x429d] = 0x461a, [0x429e] = 0x461b, [0x429f] = 0x461c,
  [0x42a0] = 0x461d, [0x42a1] = 0x461e, [0x42a2] = 0x461f, [0x42a3] = 0x4620,
  [0x42a4] = 0x4621, [0x42a5] = 0x4622, [0x42a6] = 0x4623, [0x42a7] = 0x4624,
  [0x42a8] = 0x4625, [0x42a9] = 0x4626, [0x42aa] = 0x4627, [0x42ab] = 0x4628,
  [0x42ac] = 0x4629, [0x42ad] = 0x462a, [0x42ae] = 0x462b, [0x42af] = 0x462c,
  [0x42b0] = 0x462d, [0x42b1] = 0x462e, [0x42b2] = 0x462f, [0x42b3] = 0x4630,
  [0x42b4] = 0x4631, [0x42b5] = 0x4632, [0x42b6] = 0x4633, [0x42b7] = 0x4634,
  [0x42b8] = 0x4635, [0x42b9] = 0x4636, [0x42ba] = 0x4637, [0x42bb] = 0x4638,
  [0x42bc] = 0x4639, [0x42bd] = 0x463a, [0x42be] = 0x463b, [0x42bf] = 0x463c,
  [0x42c0] = 0x463d, [0x42c1] = 0x463e, [0x42c2] = 0x463f, [0x42c3] = 0x4640,
  [0x42c4] = 0x4641, [0x42c5] = 0x4642, [0x42c6] = 0x4643, [0x42c7] = 0x4644,
  [0x42c8] = 0x4645, [0x42c9] = 0x4646, [0x42ca] = 0x4647, [0x42cb] = 0x4648,
  [0x42cc] = 0x4649, [0x42cd] = 0x464a, [0x42ce] = 0x464b, [0x42cf] = 0x464d,
  [0x42d0] = 0x464e, [0x42d1] = 0x464f, [0x42d2] = 0x4650, [0x42d3] = 0x4651,
  [0x42d4] = 0x4652, [0x42d5] = 0x4653, [0x42d6] = 0x4654, [0x42d7] = 0x4655,
  [0x42d8] = 0x4656, [0x42d9] = 0x4657, [0x42da] = 0x4658, [0x42db] = 0x4659,
  [0x42dc] = 0x465a, [0x42dd] = 0x465b, [0x42de] = 0x465c, [0x42df] = 0x465d,
  [0x42e0] = 0x465e, [0x42e1] = 0x465f, [0x42e2] = 0x4660, [0x42e3] = 0x4662,
  [0x42e4] = 0x4663, [0x42e5] = 0x4664, [0x42e6] = 0x4665, [0x42e7] = 0x4666,
  [0x42e8] = 0x4667, [0x42e9] = 0x4668, [0x42ea] = 0x4669, [0x42eb] = 0x466a,
  [0x42ec] = 0x466b, [0x42ed] = 0x466c, [0x42ee] = 0x466d, [0x42ef] = 0x466e,
  [0x42f0] = 0x466f, [0x42f1] = 0x4670, [0x42f2] = 0x4671, [0x42f3] = 0x4672,
  [0x42f4] = 0x4673, [0x42f5] = 0x4674, [0x42f6] = 0x4675, [0x42f7] = 0x4676,
  [0x42f8] = 0x4677, [0x42f9] = 0x4678, [0x42fa] = 0x4679, [0x42fb] = 0x467a,
  [0x42fc] = 0x467b, [0x42fd] = 0x467c, [0x42fe] = 0x467d, [0x42ff] = 0x467e,
  [0x4300] = 0x467f, [0x4301] = 0x4680, [0x4302] = 0x4681, [0x4303] = 0x4682,
  [0x4304] = 0x4683, [0x4305] = 0x4684, [0x4306] = 0x4685, [0x4307] = 0x4686,
  [0x4308] = 0x4687, [0x4309] = 0x4688, [0x430a] = 0x4689, [0x430b] = 0x468a,
  [0x430c] = 0x468b, [0x430d] = 0x468c, [0x430e] = 0x468d, [0x430f] = 0x468e,
  [0x4310] = 0x468f, [0x4311] = 0x4690, [0x4312] = 0x4691, [0x4313] = 0x4692,
  [0x4314] = 0x4693, [0x4315] = 0x4694, [0x4316] = 0x4695, [0x4317] = 0x4696,
  [0x4318] = 0x4697, [0x4319] = 0x4698, [0x431a] = 0x4699, [0x431b] = 0x469a,
  [0x431c] = 0x469b, [0x431d] = 0x469c, [0x431e] = 0x469d, [0x431f] = 0x469e,
  [0x4320] = 0x469f, [0x4321] = 0x46a0, [0x4322] = 0x46a1, [0x4323] = 0x46a2,
  [0x4324] = 0x46a3, [0x4325] = 0x46a4, [0x4326] = 0x46a5, [0x4327] = 0x46a6,
  [0x4328] = 0x46a7, [0x4329] = 0x46a8, [0x432a] = 0x46a9, [0x432b] = 0x46aa,
  [0x432c] = 0x46ab, [0x432d] = 0x46ac, [0x432e] = 0x46ad, [0x432f] = 0x46ae,
  [0x4330] = 0x46af, [0x4331] = 0x46b0, [0x4332] = 0x46b1, [0x4333] = 0x46b2,
  [0x4334] = 0x46b3, [0x4335] = 0x46b4, [0x4336] = 0x46b5, [0x4337] = 0x46b6,
  [0x4338] = 0x46b7, [0x4339] = 0x46b8, [0x433a] = 0x46b9, [0x433b] = 0x46ba,
  [0x433c] = 0x46bb, [0x433d] = 0x46bc, [0x433e] = 0x46bd, [0x433f] = 0x46be,
  [0x4340] = 0x46bf, [0x4341] = 0x46c0, [0x4342] = 0x46c1, [0x4343] = 0x46c2,
  [0x4344] = 0x46c3, [0x4345] = 0x46c4, [0x4346] = 0x46c5, [0x4347] = 0x46c6,
  [0x4348] = 0x46c7, [0x4349] = 0x46c8, [0x434a] = 0x46c9, [0x434b] = 0x46ca,
  [0x434c] = 0x46cb, [0x434d] = 0x46cc, [0x434e] = 0x46cd, [0x434f] = 0x46ce,
  [0x4350] = 0x46cf, [0x4351] = 0x46d0, [0x4352] = 0x46d1, [0x4353] = 0x46d2,
  [0x4354] = 0x46d3, [0x4355] = 0x46d4, [0x4356] = 0x46d5, [0x4357] = 0x46d6,
  [0x4358] = 0x46d7, [0x4359] = 0x46d8, [0x435a] = 0x46d9, [0x435b] = 0x46da,
  [0x435c] = 0x46db, [0x435d] = 0x46dc, [0x435e] = 0x46dd, [0x435f] = 0x46de,
  [0x4360] = 0x46df, [0x4361] = 0x46e0, [0x4362] = 0x46e1, [0x4363] = 0x46e2,
  [0x4364] = 0x46e3, [0x4365] = 0x46e4, [0x4366] = 0x46e5, [0x4367] = 0x46e6,
  [0x4368] = 0x46e7, [0x4369] = 0x46e8, [0x436a] = 0x46e9, [0x436b] = 0x46ea,
  [0x436c] = 0x46eb, [0x436d] = 0x46ec, [0x436e] = 0x46ed, [0x436f] = 0x46ee,
  [0x4370] = 0x46ef, [0x4371] = 0x46f0, [0x4372] = 0x46f1, [0x4373] = 0x46f2,
  [0x4374] = 0x46f3, [0x4375] = 0x46f4, [0x4376] = 0x46f5, [0x4377] = 0x46f6,
  [0x4378] = 0x46f7, [0x4379] = 0x46f8, [0x437a] = 0x46f9, [0x437b] = 0x46fa,
  [0x437c] = 0x46fb, [0x437d] = 0x46fc, [0x437e] = 0x46fd, [0x437f] = 0x46fe,
  [0x4380] = 0x46ff, [0x4381] = 0x4700, [0x4382] = 0x4701, [0x4383] = 0x4702,
  [0x4384] = 0x4703, [0x4385] = 0x4704, [0x4386] = 0x4705, [0x4387] = 0x4706,
  [0x4388] = 0x4707, [0x4389] = 0x4708, [0x438a] = 0x4709, [0x438b] = 0x470a,
  [0x438c] = 0x470b, [0x438d] = 0x470c, [0x438e] = 0x470d, [0x438f] = 0x470e,
  [0x4390] = 0x470f, [0x4391] = 0x4710, [0x4392] = 0x4711, [0x4393] = 0x4712,
  [0x4394] = 0x4713, [0x4395] = 0x4714, [0x4396] = 0x4715, [0x4397] = 0x4716,
  [0x4398] = 0x4717, [0x4399] = 0x4718, [0x439a] = 0x4719, [0x439b] = 0x471a,
  [0x439c] = 0x471b, [0x439d] = 0x471c, [0x439e] = 0x471d, [0x439f] = 0x471e,
  [0x43a0] = 0x471f, [0x43a1] = 0x4720, [0x43a2] = 0x4721, [0x43a3] = 0x4722,
  [0x43a4] = 0x4724, [0x43a5] = 0x4725, [0x43a6] = 0x4726, [0x43a7] = 0x4727,
  [0x43a8] = 0x4728, [0x43a9] = 0x472a, [0x43aa] = 0x472b, [0x43ab] = 0x472c,
  [0x43ac] = 0x472d, [0x43ad] = 0x472e, [0x43ae] = 0x472f, [0x43af] = 0x4730,
  [0x43b0] = 0x4731, [0x43b1] = 0x4732, [0x43b2] = 0x4733, [0x43b3] = 0x4734,
  [0x43b4] = 0x4735, [0x43b5] = 0x4736, [0x43b6] = 0x4737, [0x43b7] = 0x4738,
  [0x43b8] = 0x4739, [0x43b9] = 0x473a, [0x43ba] = 0x473b, [0x43bb] = 0x473c,
  [0x43bc] = 0x473d, [0x43bd] = 0x473e, [0x43be] = 0x473f, [0x43bf] = 0x4740,
  [0x43c0] = 0x4741, [0x43c1] = 0x4742, [0x43c2] = 0x4743, [0x43c3] = 0x4744,
  [0x43c4] = 0x4745, [0x43c5] = 0x4746, [0x43c6] = 0x4747, [0x43c7] = 0x4748,
  [0x43c8] = 0x4749, [0x43c9] = 0x474a, [0x43ca] = 0x474b, [0x43cb] = 0x474c,
  [0x43cc] = 0x474d, [0x43cd] = 0x474e, [0x43ce] = 0x474f, [0x43cf] = 0x4750,
  [0x43d0] = 0x4751, [0x43d1] = 0x4752, [0x43d2] = 0x4753, [0x43d3] = 0x4754,
  [0x43d4] = 0x4755, [0x43d5] = 0x4756, [0x43d6] = 0x4757, [0x43d7] = 0x4758,
  [0x43d8] = 0x4759, [0x43d9] = 0x475a, [0x43da] = 0x475b, [0x43db] = 0x475c,
  [0x43dc] = 0x475d, [0x43dd] = 0x475e, [0x43de] = 0x475f, [0x43df] = 0x4760,
  [0x43e0] = 0x4761, [0x43e1] = 0x4762, [0x43e2] = 0x4763, [0x43e3] = 0x4764,
  [0x43e4] = 0x4765, [0x43e5] = 0x4766, [0x43e6] = 0x4767, [0x43e7] = 0x4768,
  [0x43e8] = 0x4769, [0x43e9] = 0x476a, [0x43ea] = 0x476b, [0x43eb] = 0x476c,
  [0x43ec] = 0x476d, [0x43ed] = 0x476e, [0x43ee] = 0x476f, [0x43ef] = 0x4770,
  [0x43f0] = 0x4771, [0x43f1] = 0x4772, [0x43f2] = 0x4773, [0x43f3] = 0x4774,
  [0x43f4] = 0x4775, [0x43f5] = 0x4776, [0x43f6] = 0x4777, [0x43f7] = 0x4778,
  [0x43f8] = 0x4779, [0x43f9] = 0x477a, [0x43fa] = 0x477b, [0x43fb] = 0x477d,
  [0x43fc] = 0x477e, [0x43fd] = 0x477f, [0x43fe] = 0x4780, [0x43ff] = 0x4781,
  [0x4400] = 0x4782, [0x4401] = 0x4783, [0x4402] = 0x4784, [0x4403] = 0x4785,
  [0x4404] = 0x4786, [0x4405] = 0x4787, [0x4406] = 0x4788, [0x4407] = 0x4789,
  [0x4408] = 0x478a, [0x4409] = 0x478b, [0x440a] = 0x478c, [0x440b] = 0x478e,
  [0x440c] = 0x478f, [0x440d] = 0x4790, [0x440e] = 0x4791, [0x440f] = 0x4792,
  [0x4410] = 0x4793, [0x4411] = 0x4794, [0x4412] = 0x4795, [0x4413] = 0x4796,
  [0x4414] = 0x4797, [0x4415] = 0x4798, [0x4416] = 0x4799, [0x4417] = 0x479a,
  [0x4418] = 0x479b, [0x4419] = 0x479c, [0x441a] = 0x479d, [0x441b] = 0x479e,
  [0x441c] = 0x479f, [0x441d] = 0x47a0, [0x441e] = 0x47a1, [0x441f] = 0x47a2,
  [0x4420] = 0x47a3, [0x4421] = 0x47a4, [0x4422] = 0x47a5, [0x4423] = 0x47a6,
  [0x4424] = 0x47a7, [0x4425] = 0x47a8, [0x4426] = 0x47a9, [0x4427] = 0x47aa,
  [0x4428] = 0x47ab, [0x4429] = 0x47ac, [0x442a] = 0x47ad, [0x442b] = 0x47ae,
  [0x442c] = 0x47af, [0x442d] = 0x47b0, [0x442e] = 0x47b1, [0x442f] = 0x47b2,
  [0x4430] = 0x47b3, [0x4431] = 0x47b4, [0x4432] = 0x47b5, [0x4433] = 0x47b6,
  [0x4434] = 0x47b7, [0x4435] = 0x47b8, [0x4436] = 0x47b9, [0x4437] = 0x47ba,
  [0x4438] = 0x47bb, [0x4439] = 0x47bc, [0x443a] = 0x47bd, [0x443b] = 0x47be,
  [0x443c] = 0x47bf, [0x443d] = 0x47c0, [0x443e] = 0x47c1, [0x443f] = 0x47c2,
  [0x4440] = 0x47c3, [0x4441] = 0x47c4, [0x4442] = 0x47c5, [0x4443] = 0x47c6,
  [0x4444] = 0x47c7, [0x4445] = 0x47c8, [0x4446] = 0x47c9, [0x4447] = 0x47ca,
  [0x4448] = 0x47cb, [0x4449] = 0x47cc, [0x444a] = 0x47cd, [0x444b] = 0x47ce,
  [0x444c] = 0x47cf, [0x444d] = 0x47d0, [0x444e] = 0x47d1, [0x444f] = 0x47d2,
  [0x4450] = 0x47d3, [0x4451] = 0x47d4, [0x4452] = 0x47d5, [0x4453] = 0x47d6,
  [0x4454] = 0x47d7, [0x4455] = 0x47d8, [0x4456] = 0x47d9, [0x4457] = 0x47da,
  [0x4458] = 0x47db, [0x4459] = 0x47dc, [0x445a] = 0x47dd, [0x445b] = 0x47de,
  [0x445c] = 0x47df, [0x445d] = 0x47e0, [0x445e] = 0x47e1, [0x445f] = 0x47e2,
  [0x4460] = 0x47e3, [0x4461] = 0x47e4, [0x4462] = 0x47e5, [0x4463] = 0x47e6,
  [0x4464] = 0x47e7, [0x4465] = 0x47e8, [0x4466] = 0x47e9, [0x4467] = 0x47ea,
  [0x4468] = 0x47eb, [0x4469] = 0x47ec, [0x446a] = 0x47ed, [0x446b] = 0x47ee,
  [0x446c] = 0x47ef, [0x446d] = 0x47f0, [0x446e] = 0x47f1, [0x446f] = 0x47f2,
  [0x4470] = 0x47f3, [0x4471] = 0x47f4, [0x4472] = 0x47f5, [0x4473] = 0x47f6,
  [0x4474] = 0x47f7, [0x4475] = 0x47f8, [0x4476] = 0x47f9, [0x4477] = 0x47fa,
  [0x4478] = 0x47fb, [0x4479] = 0x47fc, [0x447a] = 0x47fd, [0x447b] = 0x47fe,
  [0x447c] = 0x47ff, [0x447d] = 0x4800, [0x447e] = 0x4801, [0x447f] = 0x4802,
  [0x4480] = 0x4803, [0x4481] = 0x4804, [0x4482] = 0x4805, [0x4483] = 0x4806,
  [0x4484] = 0x4807, [0x4485] = 0x4808, [0x4486] = 0x4809, [0x4487] = 0x480a,
  [0x4488] = 0x480b, [0x4489] = 0x480c, [0x448a] = 0x480d, [0x448b] = 0x480e,
  [0x448c] = 0x480f, [0x448d] = 0x4810, [0x448e] = 0x4811, [0x448f] = 0x4812,
  [0x4490] = 0x4813, [0x4491] = 0x4814, [0x4492] = 0x4815, [0x4493] = 0x4816,
  [0x4494] = 0x4817, [0x4495] = 0x4818, [0x4496] = 0x4819, [0x4497] = 0x481a,
  [0x4498] = 0x481b, [0x4499] = 0x481c, [0x449a] = 0x481d, [0x449b] = 0x481e,
  [0x449c] = 0x481f, [0x449d] = 0x4820, [0x449e] = 0x4821, [0x449f] = 0x4822,
  [0x44a0] = 0x4823, [0x44a1] = 0x4824, [0x44a2] = 0x4825, [0x44a3] = 0x4826,
  [0x44a4] = 0x4827, [0x44a5] = 0x4828, [0x44a6] = 0x4829, [0x44a7] = 0x482a,
  [0x44a8] = 0x482b, [0x44a9] = 0x482c, [0x44aa] = 0x482d, [0x44ab] = 0x482e,
  [0x44ac] = 0x482f, [0x44ad] = 0x4830, [0x44ae] = 0x4831, [0x44af] = 0x4832,
  [0x44b0] = 0x4833, [0x44b1] = 0x4834, [0x44b2] = 0x4835, [0x44b3] = 0x4836,
  [0x44b4] = 0x4837, [0x44b5] = 0x4838, [0x44b6] = 0x4839, [0x44b7] = 0x483a,
  [0x44b8] = 0x483b, [0x44b9] = 0x483c, [0x44ba] = 0x483d, [0x44bb] = 0x483e,
  [0x44bc] = 0x483f, [0x44bd] = 0x4840, [0x44be] = 0x4841, [0x44bf] = 0x4842,
  [0x44c0] = 0x4843, [0x44c1] = 0x4844, [0x44c2] = 0x4845, [0x44c3] = 0x4846,
  [0x44c4] = 0x4847, [0x44c5] = 0x4848, [0x44c6] = 0x4849, [0x44c7] = 0x484a,
  [0x44c8] = 0x484b, [0x44c9] = 0x484c, [0x44ca] = 0x484d, [0x44cb] = 0x484e,
  [0x44cc] = 0x484f, [0x44cd] = 0x4850, [0x44ce] = 0x4851, [0x44cf] = 0x4852,
  [0x44d0] = 0x4853, [0x44d1] = 0x4854, [0x44d2] = 0x4855, [0x44d3] = 0x4856,
  [0x44d4] = 0x4857, [0x44d5] = 0x4858, [0x44d6] = 0x4859, [0x44d7] = 0x485a,
  [0x44d8] = 0x485b, [0x44d9] = 0x485c, [0x44da] = 0x485d, [0x44db] = 0x485e,
  [0x44dc] = 0x485f, [0x44dd] = 0x4860, [0x44de] = 0x4861, [0x44df] = 0x4862,
  [0x44e0] = 0x4863, [0x44e1] = 0x4864, [0x44e2] = 0x4865, [0x44e3] = 0x4866,
  [0x44e4] = 0x4867, [0x44e5] = 0x4868, [0x44e6] = 0x4869, [0x44e7] = 0x486a,
  [0x44e8] = 0x486b, [0x44e9] = 0x486c, [0x44ea] = 0x486d, [0x44eb] = 0x486e,
  [0x44ec] = 0x486f, [0x44ed] = 0x4870, [0x44ee] = 0x4871, [0x44ef] = 0x4872,
  [0x44f0] = 0x4873, [0x44f1] = 0x4874, [0x44f2] = 0x4875, [0x44f3] = 0x4876,
  [0x44f4] = 0x4877, [0x44f5] = 0x4878, [0x44f6] = 0x4879, [0x44f7] = 0x487a,
  [0x44f8] = 0x487b, [0x44f9] = 0x487c, [0x44fa] = 0x487d, [0x44fb] = 0x487e,
  [0x44fc] = 0x487f, [0x44fd] = 0x4880, [0x44fe] = 0x4881, [0x44ff] = 0x4882,
  [0x4500] = 0x4883, [0x4501] = 0x4884, [0x4502] = 0x4885, [0x4503] = 0x4886,
  [0x4504] = 0x4887, [0x4505] = 0x4888, [0x4506] = 0x4889, [0x4507] = 0x488a,
  [0x4508] = 0x488b, [0x4509] = 0x488c, [0x450a] = 0x488d, [0x450b] = 0x488e,
  [0x450c] = 0x488f, [0x450d] = 0x4890, [0x450e] = 0x4891, [0x450f] = 0x4892,
  [0x4510] = 0x4893, [0x4511] = 0x4894, [0x4512] = 0x4895, [0x4513] = 0x4896,
  [0x4514] = 0x4897, [0x4515] = 0x4898, [0x4516] = 0x4899, [0x4517] = 0x489a,
  [0x4518] = 0x489b, [0x4519] = 0x489c, [0x451a] = 0x489d, [0x451b] = 0x489e,
  [0x451c] = 0x489f, [0x451d] = 0x48a0, [0x451e] = 0x48a1, [0x451f] = 0x48a2,
  [0x4520] = 0x48a3, [0x4521] = 0x48a4, [0x4522] = 0x48a5, [0x4523] = 0x48a6,
  [0x4524] = 0x48a7, [0x4525] = 0x48a8, [0x4526] = 0x48a9, [0x4527] = 0x48aa,
  [0x4528] = 0x48ab, [0x4529] = 0x48ac, [0x452a] = 0x48ad, [0x452b] = 0x48ae,
  [0x452c] = 0x48af, [0x452d] = 0x48b0, [0x452e] = 0x48b1, [0x452f] = 0x48b2,
  [0x4530] = 0x48b3, [0x4531] = 0x48b4, [0x4532] = 0x48b5, [0x4533] = 0x48b6,
  [0x4534] = 0x48b7, [0x4535] = 0x48b8, [0x4536] = 0x48b9, [0x4537] = 0x48ba,
  [0x4538] = 0x48bb, [0x4539] = 0x48bc, [0x453a] = 0x48bd, [0x453b] = 0x48be,
  [0x453c] = 0x48bf, [0x453d] = 0x48c0, [0x453e] = 0x48c1, [0x453f] = 0x48c2,
  [0x4540] = 0x48c3, [0x4541] = 0x48c4, [0x4542] = 0x48c5, [0x4543] = 0x48c6,
  [0x4544] = 0x48c7, [0x4545] = 0x48c8, [0x4546] = 0x48c9, [0x4547] = 0x48ca,
  [0x4548] = 0x48cb, [0x4549] = 0x48cc, [0x454a] = 0x48cd, [0x454b] = 0x48ce,
  [0x454c] = 0x48cf, [0x454d] = 0x48d0, [0x454e] = 0x48d1, [0x454f] = 0x48d2,
  [0x4550] = 0x48d3, [0x4551] = 0x48d4, [0x4552] = 0x48d5, [0x4553] = 0x48d6,
  [0x4554] = 0x48d7, [0x4555] = 0x48d8, [0x4556] = 0x48d9, [0x4557] = 0x48da,
  [0x4558] = 0x48db, [0x4559] = 0x48dc, [0x455a] = 0x48dd, [0x455b] = 0x48de,
  [0x455c] = 0x48df, [0x455d] = 0x48e0, [0x455e] = 0x48e1, [0x455f] = 0x48e2,
  [0x4560] = 0x48e3, [0x4561] = 0x48e4, [0x4562] = 0x48e5, [0x4563] = 0x48e6,
  [0x4564] = 0x48e7, [0x4565] = 0x48e8, [0x4566] = 0x48e9, [0x4567] = 0x48ea,
  [0x4568] = 0x48eb, [0x4569] = 0x48ec, [0x456a] = 0x48ed, [0x456b] = 0x48ee,
  [0x456c] = 0x48ef, [0x456d] = 0x48f0, [0x456e] = 0x48f1, [0x456f] = 0x48f2,
  [0x4570] = 0x48f3, [0x4571] = 0x48f4, [0x4572] = 0x48f5, [0x4573] = 0x48f6,
  [0x4574] = 0x48f7, [0x4575] = 0x48f8, [0x4576] = 0x48f9, [0x4577] = 0x48fa,
  [0x4578] = 0x48fb, [0x4579] = 0x48fc, [0x457a] = 0x48fd, [0x457b] = 0x48fe,
  [0x457c] = 0x48ff, [0x457d] = 0x4900, [0x457e] = 0x4901, [0x457f] = 0x4902,
  [0x4580] = 0x4903, [0x4581] = 0x4904, [0x4582] = 0x4905, [0x4583] = 0x4906,
  [0x4584] = 0x4907, [0x4585] = 0x4908, [0x4586] = 0x4909, [0x4587] = 0x490a,
  [0x4588] = 0x490b, [0x4589] = 0x490c, [0x458a] = 0x490d, [0x458b] = 0x490e,
  [0x458c] = 0x490f, [0x458d] = 0x4910, [0x458e] = 0x4911, [0x458f] = 0x4912,
  [0x4590] = 0x4913, [0x4591] = 0x4914, [0x4592] = 0x4915, [0x4593] = 0x4916,
  [0x4594] = 0x4917, [0x4595] = 0x4918, [0x4596] = 0x4919, [0x4597] = 0x491a,
  [0x4598] = 0x491b, [0x4599] = 0x491c, [0x459a] = 0x491d, [0x459b] = 0x491e,
  [0x459c] = 0x491f, [0x459d] = 0x4920, [0x459e] = 0x4921, [0x459f] = 0x4922,
  [0x45a0] = 0x4923, [0x45a1] = 0x4924, [0x45a2] = 0x4925, [0x45a3] = 0x4926,
  [0x45a4] = 0x4927, [0x45a5] = 0x4928, [0x45a6] = 0x4929, [0x45a7] = 0x492a,
  [0x45a8] = 0x492b, [0x45a9] = 0x492c, [0x45aa] = 0x492d, [0x45ab] = 0x492e,
  [0x45ac] = 0x492f, [0x45ad] = 0x4930, [0x45ae] = 0x4931, [0x45af] = 0x4932,
  [0x45b0] = 0x4933, [0x45b1] = 0x4934, [0x45b2] = 0x4935, [0x45b3] = 0x4936,
  [0x45b4] = 0x4937, [0x45b5] = 0x4938, [0x45b6] = 0x4939, [0x45b7] = 0x493a,
  [0x45b8] = 0x493b, [0x45b9] = 0x493c, [0x45ba] = 0x493d, [0x45bb] = 0x493e,
  [0x45bc] = 0x493f, [0x45bd] = 0x4940, [0x45be] = 0x4941, [0x45bf] = 0x4942,
  [0x45c0] = 0x4943, [0x45c1] = 0x4944, [0x45c2] = 0x4945, [0x45c3] = 0x4946,
  [0x45c4] = 0x4948, [0x45c5] = 0x4949, [0x45c6] = 0x494a, [0x45c7] = 0x494b,
  [0x45c8] = 0x494c, [0x45c9] = 0x494d, [0x45ca] = 0x494e, [0x45cb] = 0x494f,
  [0x45cc] = 0x4950, [0x45cd] = 0x4951, [0x45ce] = 0x4952, [0x45cf] = 0x4953,
  [0x45d0] = 0x4954, [0x45d1] = 0x4955, [0x45d2] = 0x4956, [0x45d3] = 0x4957,
  [0x45d4] = 0x4958, [0x45d5] = 0x4959, [0x45d6] = 0x495a, [0x45d7] = 0x495b,
  [0x45d8] = 0x495c, [0x45d9] = 0x495d, [0x45da] = 0x495e, [0x45db] = 0x495f,
  [0x45dc] = 0x4960, [0x45dd] = 0x4961, [0x45de] = 0x4962, [0x45df] = 0x4963,
  [0x45e0] = 0x4964, [0x45e1] = 0x4965, [0x45e2] = 0x4966, [0x45e3] = 0x4967,
  [0x45e4] = 0x4968, [0x45e5] = 0x4969, [0x45e6] = 0x496a, [0x45e7] = 0x496b,
  [0x45e8] = 0x496c, [0x45e9] = 0x496d, [0x45ea] = 0x496e, [0x45eb] = 0x496f,
  [0x45ec] = 0x4970, [0x45ed] = 0x4971, [0x45ee] = 0x4972, [0x45ef] = 0x4973,
  [0x45f0] = 0x4974, [0x45f1] = 0x4975, [0x45f2] = 0x4976, [0x45f3] = 0x4977,
  [0x45f4] = 0x4978, [0x45f5] = 0x4979, [0x45f6] = 0x497b, [0x45f7] = 0x497c,
  [0x45f8] = 0x497e, [0x45f9] = 0x497f, [0x45fa] = 0x4980, [0x45fb] = 0x4981,
  [0x45fc] = 0x4984, [0x45fd] = 0x4987, [0x45fe] = 0x4988, [0x45ff] = 0x4989,
  [0x4600] = 0x498a, [0x4601] = 0x498b, [0x4602] = 0x498c, [0x4603] = 0x498d,
  [0x4604] = 0x498e, [0x4605] = 0x498f, [0x4606] = 0x4990, [0x4607] = 0x4991,
  [0x4608] = 0x4992, [0x4609] = 0x4993, [0x460a] = 0x4994, [0x460b] = 0x4995,
  [0x460c] = 0x4996, [0x460d] = 0x4997, [0x460e] = 0x4998, [0x460f] = 0x4999,
  [0x4610] = 0x499a, [0x4611] = 0x499c, [0x4612] = 0x499d, [0x4613] = 0x499e,
  [0x4614] = 0x49a0, [0x4615] = 0x49a1, [0x4616] = 0x49a2, [0x4617] = 0x49a3,
  [0x4618] = 0x49a4, [0x4619] = 0x49a5, [0x461a] = 0x49a6, [0x461b] = 0x49a7,
  [0x461c] = 0x49a8, [0x461d] = 0x49a9, [0x461e] = 0x49aa, [0x461f] = 0x49ab,
  [0x4620] = 0x49ac, [0x4621] = 0x49ad, [0x4622] = 0x49ae, [0x4623] = 0x49af,
  [0x4624] = 0x49b0, [0x4625] = 0x49b1, [0x4626] = 0x49b2, [0x4627] = 0x49b3,
  [0x4628] = 0x49b4, [0x4629] = 0x49b5, [0x462a] = 0x49b8, [0x462b] = 0x49b9,
  [0x462c] = 0x49ba, [0x462d] = 0x49bb, [0x462e] = 0x49bc, [0x462f] = 0x49bd,
  [0x4630] = 0x49be, [0x4631] = 0x49bf, [0x4632] = 0x49c0, [0x4633] = 0x49c1,
  [0x4634] = 0x49c2, [0x4635] = 0x49c3, [0x4636] = 0x49c4, [0x4637] = 0x49c5,
  [0x4638] = 0x49c6, [0x4639] = 0x49c7, [0x463a] = 0x49c8, [0x463b] = 0x49c9,
  [0x463c] = 0x49ca, [0x463d] = 0x49cb, [0x463e] = 0x49cc, [0x463f] = 0x49cd,
  [0x4640] = 0x49ce, [0x4641] = 0x49cf, [0x4642] = 0x49d0, [0x4643] = 0x49d1,
  [0x4644] = 0x49d2, [0x4645] = 0x49d3, [0x4646] = 0x49d4, [0x4647] = 0x49d5,
  [0x4648] = 0x49d6, [0x4649] = 0x49d7, [0x464a] = 0x49d8, [0x464b] = 0x49d9,
  [0x464c] = 0x49da, [0x464d] = 0x49db, [0x464e] = 0x49dc, [0x464f] = 0x49dd,
  [0x4650] = 0x49de, [0x4651] = 0x49df, [0x4652] = 0x49e0, [0x4653] = 0x49e1,
  [0x4654] = 0x49e2, [0x4655] = 0x49e3, [0x4656] = 0x49e4, [0x4657] = 0x49e5,
  [0x4658] = 0x49e6, [0x4659] = 0x49e7, [0x465a] = 0x49e8, [0x465b] = 0x49e9,
  [0x465c] = 0x49ea, [0x465d] = 0x49eb, [0x465e] = 0x49ec, [0x465f] = 0x49ed,
  [0x4660] = 0x49ee, [0x4661] = 0x49ef, [0x4662] = 0x49f0, [0x4663] = 0x49f1,
  [0x4664] = 0x49f2, [0x4665] = 0x49f3, [0x4666] = 0x49f4, [0x4667] = 0x49f5,
  [0x4668] = 0x49f6, [0x4669] = 0x49f7, [0x466a] = 0x49f8, [0x466b] = 0x49f9,
  [0x466c] = 0x49fa, [0x466d] = 0x49fb, [0x466e] = 0x49fc, [0x466f] = 0x49fd,
  [0x4670] = 0x49fe, [0x4671] = 0x49ff, [0x4672] = 0x4a00, [0x4673] = 0x4a01,
  [0x4674] = 0x4a02, [0x4675] = 0x4a03, [0x4676] = 0x4a04, [0x4677] = 0x4a05,
  [0x4678] = 0x4a06, [0x4679] = 0x4a07, [0x467a] = 0x4a08, [0x467b] = 0x4a09,
  [0x467c] = 0x4a0a, [0x467d] = 0x4a0b, [0x467e] = 0x4a0c, [0x467f] = 0x4a0d,
  [0x4680] = 0x4a0e, [0x4681] = 0x4a0f, [0x4682] = 0x4a10, [0x4683] = 0x4a11,
  [0x4684] = 0x4a12, [0x4685] = 0x4a13, [0x4686] = 0x4a14, [0x4687] = 0x4a15,
  [0x4688] = 0x4a16, [0x4689] = 0x4a17, [0x468a] = 0x4a18, [0x468b] = 0x4a19,
  [0x468c] = 0x4a1a, [0x468d] = 0x4a1b, [0x468e] = 0x4a1c, [0x468f] = 0x4a1d,
  [0x4690] = 0x4a1e, [0x4691] = 0x4a1f, [0x4692] = 0x4a20, [0x4693] = 0x4a21,
  [0x4694] = 0x4a22, [0x4695] = 0x4a23, [0x4696] = 0x4a24, [0x4697] = 0x4a25,
  [0x4698] = 0x4a26, [0x4699] = 0x4a27, [0x469a] = 0x4a28, [0x469b] = 0x4a29,
  [0x469c] = 0x4a2a, [0x469d] = 0x4a2b, [0x469e] = 0x4a2c, [0x469f] = 0x4a2d,
  [0x46a0] = 0x4a2e, [0x46a1] = 0x4a2f, [0x46a2] = 0x4a30, [0x46a3] = 0x4a31,
  [0x46a4] = 0x4a32, [0x46a5] = 0x4a33, [0x46a6] = 0x4a34, [0x46a7] = 0x4a35,
  [0x46a8] = 0x4a36, [0x46a9] = 0x4a37, [0x46aa] = 0x4a38, [0x46ab] = 0x4a39,
  [0x46ac] = 0x4a3a, [0x46ad] = 0x4a3b, [0x46ae] = 0x4a3c, [0x46af] = 0x4a3d,
  [0x46b0] = 0x4a3e, [0x46b1] = 0x4a3f, [0x46b2] = 0x4a40, [0x46b3] = 0x4a41,
  [0x46b4] = 0x4a42, [0x46b5] = 0x4a43, [0x46b6] = 0x4a44, [0x46b7] = 0x4a45,
  [0x46b8] = 0x4a46, [0x46b9] = 0x4a47, [0x46ba] = 0x4a48, [0x46bb] = 0x4a49,
  [0x46bc] = 0x4a4a, [0x46bd] = 0x4a4b, [0x46be] = 0x4a4c, [0x46bf] = 0x4a4d,
  [0x46c0] = 0x4a4e, [0x46c1] = 0x4a4f, [0x46c2] = 0x4a50, [0x46c3] = 0x4a51,
  [0x46c4] = 0x4a52, [0x46c5] = 0x4a53, [0x46c6] = 0x4a54, [0x46c7] = 0x4a55,
  [0x46c8] = 0x4a56, [0x46c9] = 0x4a57, [0x46ca] = 0x4a58, [0x46cb] = 0x4a59,
  [0x46cc] = 0x4a5a, [0x46cd] = 0x4a5b, [0x46ce] = 0x4a5c, [0x46cf] = 0x4a5d,
  [0x46d0] = 0x4a5e, [0x46d1] = 0x4a5f, [0x46d2] = 0x4a60, [0x46d3] = 0x4a61,
  [0x46d4] = 0x4a62, [0x46d5] = 0x4a63, [0x46d6] = 0x4a64, [0x46d7] = 0x4a65,
  [0x46d8] = 0x4a66, [0x46d9] = 0x4a67, [0x46da] = 0x4a68, [0x46db] = 0x4a69,
  [0x46dc] = 0x4a6a, [0x46dd] = 0x4a6b, [0x46de] = 0x4a6c, [0x46df] = 0x4a6d,
  [0x46e0] = 0x4a6e, [0x46e1] = 0x4a6f, [0x46e2] = 0x4a70, [0x46e3] = 0x4a71,
  [0x46e4] = 0x4a72, [0x46e5] = 0x4a73, [0x46e6] = 0x4a74, [0x46e7] = 0x4a75,
  [0x46e8] = 0x4a76, [0x46e9] = 0x4a77, [0x46ea] = 0x4a78, [0x46eb] = 0x4a79,
  [0x46ec] = 0x4a7a, [0x46ed] = 0x4a7b, [0x46ee] = 0x4a7c, [0x46ef] = 0x4a7d,
  [0x46f0] = 0x4a7e, [0x46f1] = 0x4a7f, [0x46f2] = 0x4a80, [0x46f3] = 0x4a81,
  [0x46f4] = 0x4a82, [0x46f5] = 0x4a83, [0x46f6] = 0x4a84, [0x46f7] = 0x4a85,
  [0x46f8] = 0x4a86, [0x46f9] = 0x4a87, [0x46fa] = 0x4a88, [0x46fb] = 0x4a89,
  [0x46fc] = 0x4a8a, [0x46fd] = 0x4a8b, [0x46fe] = 0x4a8c, [0x46ff] = 0x4a8d,
  [0x4700] = 0x4a8e, [0x4701] = 0x4a8f, [0x4702] = 0x4a90, [0x4703] = 0x4a91,
  [0x4704] = 0x4a92, [0x4705] = 0x4a93, [0x4706] = 0x4a94, [0x4707] = 0x4a95,
  [0x4708] = 0x4a96, [0x4709] = 0x4a97, [0x470a] = 0x4a98, [0x470b] = 0x4a99,
  [0x470c] = 0x4a9a, [0x470d] = 0x4a9b, [0x470e] = 0x4a9c, [0x470f] = 0x4a9d,
  [0x4710] = 0x4a9e, [0x4711] = 0x4a9f, [0x4712] = 0x4aa0, [0x4713] = 0x4aa1,
  [0x4714] = 0x4aa2, [0x4715] = 0x4aa3, [0x4716] = 0x4aa4, [0x4717] = 0x4aa5,
  [0x4718] = 0x4aa6, [0x4719] = 0x4aa7, [0x471a] = 0x4aa8, [0x471b] = 0x4aa9,
  [0x471c] = 0x4aaa, [0x471d] = 0x4aab, [0x471e] = 0x4aac, [0x471f] = 0x4aad,
  [0x4720] = 0x4aae, [0x4721] = 0x4aaf, [0x4722] = 0x4ab0, [0x4723] = 0x4ab1,
  [0x4724] = 0x4ab2, [0x4725] = 0x4ab3, [0x4726] = 0x4ab4, [0x4727] = 0x4ab5,
  [0x4728] = 0x4ab6, [0x4729] = 0x4ab7, [0x472a] = 0x4ab8, [0x472b] = 0x4ab9,
  [0x472c] = 0x4aba, [0x472d] = 0x4abb, [0x472e] = 0x4abc, [0x472f] = 0x4abd,
  [0x4730] = 0x4abe, [0x4731] = 0x4abf, [0x4732] = 0x4ac0, [0x4733] = 0x4ac1,
  [0x4734] = 0x4ac2, [0x4735] = 0x4ac3, [0x4736] = 0x4ac4, [0x4737] = 0x4ac5,
  [0x4738] = 0x4ac6, [0x4739] = 0x4ac7, [0x473a] = 0x4ac8, [0x473b] = 0x4ac9,
  [0x473c] = 0x4aca, [0x473d] = 0x4acb, [0x473e] = 0x4acc, [0x473f] = 0x4acd,
  [0x4740] = 0x4ace, [0x4741] = 0x4acf, [0x4742] = 0x4ad0, [0x4743] = 0x4ad1,
  [0x4744] = 0x4ad2, [0x4745] = 0x4ad3, [0x4746] = 0x4ad4, [0x4747] = 0x4ad5,
  [0x4748] = 0x4ad6, [0x4749] = 0x4ad7, [0x474a] = 0x4ad8, [0x474b] = 0x4ad9,
  [0x474c] = 0x4ada, [0x474d] = 0x4adb, [0x474e] = 0x4adc, [0x474f] = 0x4add,
  [0x4750] = 0x4ade, [0x4751] = 0x4adf, [0x4752] = 0x4ae0, [0x4753] = 0x4ae1,
  [0x4754] = 0x4ae2, [0x4755] = 0x4ae3, [0x4756] = 0x4ae4, [0x4757] = 0x4ae5,
  [0x4758] = 0x4ae6, [0x4759] = 0x4ae7, [0x475a] = 0x4ae8, [0x475b] = 0x4ae9,
  [0x475c] = 0x4aea, [0x475d] = 0x4aeb, [0x475e] = 0x4aec, [0x475f] = 0x4aed,
  [0x4760] = 0x4aee, [0x4761] = 0x4aef, [0x4762] = 0x4af0, [0x4763] = 0x4af1,
  [0x4764] = 0x4af2, [0x4765] = 0x4af3, [0x4766] = 0x4af4, [0x4767] = 0x4af5,
  [0x4768] = 0x4af6, [0x4769] = 0x4af7, [0x476a] = 0x4af8, [0x476b] = 0x4af9,
  [0x476c] = 0x4afa, [0x476d] = 0x4afb, [0x476e] = 0x4afc, [0x476f] = 0x4afd,
  [0x4770] = 0x4afe, [0x4771] = 0x4aff, [0x4772] = 0x4b00, [0x4773] = 0x4b01,
  [0x4774] = 0x4b02, [0x4775] = 0x4b03, [0x4776] = 0x4b04, [0x4777] = 0x4b05,
  [0x4778] = 0x4b06, [0x4779] = 0x4b07, [0x477a] = 0x4b08, [0x477b] = 0x4b09,
  [0x477c] = 0x4b0a, [0x477d] = 0x4b0b, [0x477e] = 0x4b0c, [0x477f] = 0x4b0d,
  [0x4780] = 0x4b0e, [0x4781] = 0x4b0f, [0x4782] = 0x4b10, [0x4783] = 0x4b11,
  [0x4784] = 0x4b12, [0x4785] = 0x4b13, [0x4786] = 0x4b14, [0x4787] = 0x4b15,
  [0x4788] = 0x4b16, [0x4789] = 0x4b17, [0x478a] = 0x4b18, [0x478b] = 0x4b19,
  [0x478c] = 0x4b1a, [0x478d] = 0x4b1b, [0x478e] = 0x4b1c, [0x478f] = 0x4b1d,
  [0x4790] = 0x4b1e, [0x4791] = 0x4b1f, [0x4792] = 0x4b20, [0x4793] = 0x4b21,
  [0x4794] = 0x4b22, [0x4795] = 0x4b23, [0x4796] = 0x4b24, [0x4797] = 0x4b25,
  [0x4798] = 0x4b26, [0x4799] = 0x4b27, [0x479a] = 0x4b28, [0x479b] = 0x4b29,
  [0x479c] = 0x4b2a, [0x479d] = 0x4b2b, [0x479e] = 0x4b2c, [0x479f] = 0x4b2d,
  [0x47a0] = 0x4b2e, [0x47a1] = 0x4b2f, [0x47a2] = 0x4b30, [0x47a3] = 0x4b31,
  [0x47a4] = 0x4b32, [0x47a5] = 0x4b33, [0x47a6] = 0x4b34, [0x47a7] = 0x4b35,
  [0x47a8] = 0x4b36, [0x47a9] = 0x4b37, [0x47aa] = 0x4b38, [0x47ab] = 0x4b39,
  [0x47ac] = 0x4b3a, [0x47ad] = 0x4b3b, [0x47ae] = 0x4b3c, [0x47af] = 0x4b3d,
  [0x47b0] = 0x4b3e, [0x47b1] = 0x4b3f, [0x47b2] = 0x4b40, [0x47b3] = 0x4b41,
  [0x47b4] = 0x4b42, [0x47b5] = 0x4b43, [0x47b6] = 0x4b44, [0x47b7] = 0x4b45,
  [0x47b8] = 0x4b46, [0x47b9] = 0x4b47, [0x47ba] = 0x4b48, [0x47bb] = 0x4b49,
  [0x47bc] = 0x4b4a, [0x47bd] = 0x4b4b, [0x47be] = 0x4b4c, [0x47bf] = 0x4b4d,
  [0x47c0] = 0x4b4e, [0x47c1] = 0x4b4f, [0x47c2] = 0x4b50, [0x47c3] = 0x4b51,
  [0x47c4] = 0x4b52, [0x47c5] = 0x4b53, [0x47c6] = 0x4b54, [0x47c7] = 0x4b55,
  [0x47c8] = 0x4b56, [0x47c9] = 0x4b57, [0x47ca] = 0x4b58, [0x47cb] = 0x4b59,
  [0x47cc] = 0x4b5a, [0x47cd] = 0x4b5b, [0x47ce] = 0x4b5c, [0x47cf] = 0x4b5d,
  [0x47d0] = 0x4b5e, [0x47d1] = 0x4b5f, [0x47d2] = 0x4b60, [0x47d3] = 0x4b61,
  [0x47d4] = 0x4b62, [0x47d5] = 0x4b63, [0x47d6] = 0x4b64, [0x47d7] = 0x4b65,
  [0x47d8] = 0x4b66, [0x47d9] = 0x4b67, [0x47da] = 0x4b68, [0x47db] = 0x4b69,
  [0x47dc] = 0x4b6a, [0x47dd] = 0x4b6b, [0x47de] = 0x4b6c, [0x47df] = 0x4b6d,
  [0x47e0] = 0x4b6e, [0x47e1] = 0x4b6f, [0x47e2] = 0x4b70, [0x47e3] = 0x4b71,
  [0x47e4] = 0x4b72, [0x47e5] = 0x4b73, [0x47e6] = 0x4b74, [0x47e7] = 0x4b75,
  [0x47e8] = 0x4b76, [0x47e9] = 0x4b77, [0x47ea] = 0x4b78, [0x47eb] = 0x4b79,
  [0x47ec] = 0x4b7a, [0x47ed] = 0x4b7b, [0x47ee] = 0x4b7c, [0x47ef] = 0x4b7d,
  [0x47f0] = 0x4b7e, [0x47f1] = 0x4b7f, [0x47f2] = 0x4b80, [0x47f3] = 0x4b81,
  [0x47f4] = 0x4b82, [0x47f5] = 0x4b83, [0x47f6] = 0x4b84, [0x47f7] = 0x4b85,
  [0x47f8] = 0x4b86, [0x47f9] = 0x4b87, [0x47fa] = 0x4b88, [0x47fb] = 0x4b89,
  [0x47fc] = 0x4b8a, [0x47fd] = 0x4b8b, [0x47fe] = 0x4b8c, [0x47ff] = 0x4b8d,
  [0x4800] = 0x4b8e, [0x4801] = 0x4b8f, [0x4802] = 0x4b90, [0x4803] = 0x4b91,
  [0x4804] = 0x4b92, [0x4805] = 0x4b93, [0x4806] = 0x4b94, [0x4807] = 0x4b95,
  [0x4808] = 0x4b96, [0x4809] = 0x4b97, [0x480a] = 0x4b98, [0x480b] = 0x4b99,
  [0x480c] = 0x4b9a, [0x480d] = 0x4b9b, [0x480e] = 0x4b9c, [0x480f] = 0x4b9d,
  [0x4810] = 0x4b9e, [0x4811] = 0x4b9f, [0x4812] = 0x4ba0, [0x4813] = 0x4ba1,
  [0x4814] = 0x4ba2, [0x4815] = 0x4ba3, [0x4816] = 0x4ba4, [0x4817] = 0x4ba5,
  [0x4818] = 0x4ba6, [0x4819] = 0x4ba7, [0x481a] = 0x4ba8, [0x481b] = 0x4ba9,
  [0x481c] = 0x4baa, [0x481d] = 0x4bab, [0x481e] = 0x4bac, [0x481f] = 0x4bad,
  [0x4820] = 0x4bae, [0x4821] = 0x4baf, [0x4822] = 0x4bb0, [0x4823] = 0x4bb1,
  [0x4824] = 0x4bb2, [0x4825] = 0x4bb3, [0x4826] = 0x4bb4, [0x4827] = 0x4bb5,
  [0x4828] = 0x4bb6, [0x4829] = 0x4bb7, [0x482a] = 0x4bb8, [0x482b] = 0x4bb9,
  [0x482c] = 0x4bba, [0x482d] = 0x4bbb, [0x482e] = 0x4bbc, [0x482f] = 0x4bbd,
  [0x4830] = 0x4bbe, [0x4831] = 0x4bbf, [0x4832] = 0x4bc0, [0x4833] = 0x4bc1,
  [0x4834] = 0x4bc2, [0x4835] = 0x4bc3, [0x4836] = 0x4bc4, [0x4837] = 0x4bc5,
  [0x4838] = 0x4bc6, [0x4839] = 0x4bc7, [0x483a] = 0x4bc8, [0x483b] = 0x4bc9,
  [0x483c] = 0x4bca, [0x483d] = 0x4bcb, [0x483e] = 0x4bcc, [0x483f] = 0x4bcd,
  [0x4840] = 0x4bce, [0x4841] = 0x4bcf, [0x4842] = 0x4bd0, [0x4843] = 0x4bd1,
  [0x4844] = 0x4bd2, [0x4845] = 0x4bd3, [0x4846] = 0x4bd4, [0x4847] = 0x4bd5,
  [0x4848] = 0x4bd6, [0x4849] = 0x4bd7, [0x484a] = 0x4bd8, [0x484b] = 0x4bd9,
  [0x484c] = 0x4bda, [0x484d] = 0x4bdb, [0x484e] = 0x4bdc, [0x484f] = 0x4bdd,
  [0x4850] = 0x4bde, [0x4851] = 0x4bdf, [0x4852] = 0x4be0, [0x4853] = 0x4be1,
  [0x4854] = 0x4be2, [0x4855] = 0x4be3, [0x4856] = 0x4be4, [0x4857] = 0x4be5,
  [0x4858] = 0x4be6, [0x4859] = 0x4be7, [0x485a] = 0x4be8, [0x485b] = 0x4be9,
  [0x485c] = 0x4bea, [0x485d] = 0x4beb, [0x485e] = 0x4bec, [0x485f] = 0x4bed,
  [0x4860] = 0x4bee, [0x4861] = 0x4bef, [0x4862] = 0x4bf0, [0x4863] = 0x4bf1,
  [0x4864] = 0x4bf2, [0x4865] = 0x4bf3, [0x4866] = 0x4bf4, [0x4867] = 0x4bf5,
  [0x4868] = 0x4bf6, [0x4869] = 0x4bf7, [0x486a] = 0x4bf8, [0x486b] = 0x4bf9,
  [0x486c] = 0x4bfa, [0x486d] = 0x4bfb, [0x486e] = 0x4bfc, [0x486f] = 0x4bfd,
  [0x4870] = 0x4bfe, [0x4871] = 0x4bff, [0x4872] = 0x4c00, [0x4873] = 0x4c01,
  [0x4874] = 0x4c02, [0x4875] = 0x4c03, [0x4876] = 0x4c04, [0x4877] = 0x4c05,
  [0x4878] = 0x4c06, [0x4879] = 0x4c07, [0x487a] = 0x4c08, [0x487b] = 0x4c09,
  [0x487c] = 0x4c0a, [0x487d] = 0x4c0b, [0x487e] = 0x4c0c, [0x487f] = 0x4c0d,
  [0x4880] = 0x4c0e, [0x4881] = 0x4c0f, [0x4882] = 0x4c10, [0x4883] = 0x4c11,
  [0x4884] = 0x4c12, [0x4885] = 0x4c13, [0x4886] = 0x4c14, [0x4887] = 0x4c15,
  [0x4888] = 0x4c16, [0x4889] = 0x4c17, [0x488a] = 0x4c18, [0x488b] = 0x4c19,
  [0x488c] = 0x4c1a, [0x488d] = 0x4c1b, [0x488e] = 0x4c1c, [0x488f] = 0x4c1d,
  [0x4890] = 0x4c1e, [0x4891] = 0x4c1f, [0x4892] = 0x4c20, [0x4893] = 0x4c21,
  [0x4894] = 0x4c22, [0x4895] = 0x4c23, [0x4896] = 0x4c24, [0x4897] = 0x4c25,
  [0x4898] = 0x4c26, [0x4899] = 0x4c27, [0x489a] = 0x4c28, [0x489b] = 0x4c29,
  [0x489c] = 0x4c2a, [0x489d] = 0x4c2b, [0x489e] = 0x4c2c, [0x489f] = 0x4c2d,
  [0x48a0] = 0x4c2e, [0x48a1] = 0x4c2f, [0x48a2] = 0x4c30, [0x48a3] = 0x4c31,
  [0x48a4] = 0x4c32, [0x48a5] = 0x4c33, [0x48a6] = 0x4c34, [0x48a7] = 0x4c35,
  [0x48a8] = 0x4c36, [0x48a9] = 0x4c37, [0x48aa] = 0x4c38, [0x48ab] = 0x4c39,
  [0x48ac] = 0x4c3a, [0x48ad] = 0x4c3b, [0x48ae] = 0x4c3c, [0x48af] = 0x4c3d,
  [0x48b0] = 0x4c3e, [0x48b1] = 0x4c3f, [0x48b2] = 0x4c40, [0x48b3] = 0x4c41,
  [0x48b4] = 0x4c42, [0x48b5] = 0x4c43, [0x48b6] = 0x4c44, [0x48b7] = 0x4c45,
  [0x48b8] = 0x4c46, [0x48b9] = 0x4c47, [0x48ba] = 0x4c48, [0x48bb] = 0x4c49,
  [0x48bc] = 0x4c4a, [0x48bd] = 0x4c4b, [0x48be] = 0x4c4c, [0x48bf] = 0x4c4d,
  [0x48c0] = 0x4c4e, [0x48c1] = 0x4c4f, [0x48c2] = 0x4c50, [0x48c3] = 0x4c51,
  [0x48c4] = 0x4c52, [0x48c5] = 0x4c53, [0x48c6] = 0x4c54, [0x48c7] = 0x4c55,
  [0x48c8] = 0x4c56, [0x48c9] = 0x4c57, [0x48ca] = 0x4c58, [0x48cb] = 0x4c59,
  [0x48cc] = 0x4c5a, [0x48cd] = 0x4c5b, [0x48ce] = 0x4c5c, [0x48cf] = 0x4c5d,
  [0x48d0] = 0x4c5e, [0x48d1] = 0x4c5f, [0x48d2] = 0x4c60, [0x48d3] = 0x4c61,
  [0x48d4] = 0x4c62, [0x48d5] = 0x4c63, [0x48d6] = 0x4c64, [0x48d7] = 0x4c65,
  [0x48d8] = 0x4c66, [0x48d9] = 0x4c67, [0x48da] = 0x4c68, [0x48db] = 0x4c69,
  [0x48dc] = 0x4c6a, [0x48dd] = 0x4c6b, [0x48de] = 0x4c6c, [0x48df] = 0x4c6d,
  [0x48e0] = 0x4c6e, [0x48e1] = 0x4c6f, [0x48e2] = 0x4c70, [0x48e3] = 0x4c71,
  [0x48e4] = 0x4c72, [0x48e5] = 0x4c73, [0x48e6] = 0x4c74, [0x48e7] = 0x4c75,
  [0x48e8] = 0x4c76, [0x48e9] = 0x4c78, [0x48ea] = 0x4c79, [0x48eb] = 0x4c7a,
  [0x48ec] = 0x4c7b, [0x48ed] = 0x4c7c, [0x48ee] = 0x4c7d, [0x48ef] = 0x4c7e,
  [0x48f0] = 0x4c7f, [0x48f1] = 0x4c80, [0x48f2] = 0x4c81, [0x48f3] = 0x4c82,
  [0x48f4] = 0x4c83, [0x48f5] = 0x4c84, [0x48f6] = 0x4c85, [0x48f7] = 0x4c86,
  [0x48f8] = 0x4c87, [0x48f9] = 0x4c88, [0x48fa] = 0x4c89, [0x48fb] = 0x4c8a,
  [0x48fc] = 0x4c8b, [0x48fd] = 0x4c8c, [0x48fe] = 0x4c8d, [0x48ff] = 0x4c8e,
  [0x4900] = 0x4c8f, [0x4901] = 0x4c90, [0x4902] = 0x4c91, [0x4903] = 0x4c92,
  [0x4904] = 0x4c93, [0x4905] = 0x4c94, [0x4906] = 0x4c95, [0x4907] = 0x4c96,
  [0x4908] = 0x4c97, [0x4909] = 0x4c98, [0x490a] = 0x4c99, [0x490b] = 0x4c9a,
  [0x490c] = 0x4c9b, [0x490d] = 0x4c9c, [0x490e] = 0x4c9d, [0x490f] = 0x4c9e,
  [0x4910] = 0x4ca4, [0x4911] = 0x4ca5, [0x4912] = 0x4ca6, [0x4913] = 0x4ca7,
  [0x4914] = 0x4ca8, [0x4915] = 0x4ca9, [0x4916] = 0x4caa, [0x4917] = 0x4cab,
  [0x4918] = 0x4cac, [0x4919] = 0x4cad, [0x491a] = 0x4cae, [0x491b] = 0x4caf,
  [0x491c] = 0x4cb0, [0x491d] = 0x4cb1, [0x491e] = 0x4cb2, [0x491f] = 0x4cb3,
  [0x4920] = 0x4cb4, [0x4921] = 0x4cb5, [0x4922] = 0x4cb6, [0x4923] = 0x4cb7,
  [0x4924] = 0x4cb8, [0x4925] = 0x4cb9, [0x4926] = 0x4cba, [0x4927] = 0x4cbb,
  [0x4928] = 0x4cbc, [0x4929] = 0x4cbd, [0x492a] = 0x4cbe, [0x492b] = 0x4cbf,
  [0x492c] = 0x4cc0, [0x492d] = 0x4cc1, [0x492e] = 0x4cc2, [0x492f] = 0x4cc3,
  [0x4930] = 0x4cc4, [0x4931] = 0x4cc5, [0x4932] = 0x4cc6, [0x4933] = 0x4cc7,
  [0x4934] = 0x4cc8, [0x4935] = 0x4cc9, [0x4936] = 0x4cca, [0x4937] = 0x4ccb,
  [0x4938] = 0x4ccc, [0x4939] = 0x4ccd, [0x493a] = 0x4cce, [0x493b] = 0x4ccf,
  [0x493c] = 0x4cd0, [0x493d] = 0x4cd1, [0x493e] = 0x4cd2, [0x493f] = 0x4cd3,
  [0x4940] = 0x4cd4, [0x4941] = 0x4cd5, [0x4942] = 0x4cd6, [0x4943] = 0x4cd7,
  [0x4944] = 0x4cd8, [0x4945] = 0x4cd9, [0x4946] = 0x4cda, [0x4947] = 0x4cdb,
  [0x4948] = 0x4cdc, [0x4949] = 0x4cdd, [0x494a] = 0x4cde, [0x494b] = 0x4cdf,
  [0x494c] = 0x4ce0, [0x494d] = 0x4ce1, [0x494e] = 0x4ce2, [0x494f] = 0x4ce3,
  [0x4950] = 0x4ce4, [0x4951] = 0x4ce5, [0x4952] = 0x4ce6, [0x4953] = 0x4ce7,
  [0x4954] = 0x4ce8, [0x4955] = 0x4ce9, [0x4956] = 0x4cea, [0x4957] = 0x4ceb,
  [0x4958] = 0x4cec, [0x4959] = 0x4ced, [0x495a] = 0x4cee, [0x495b] = 0x4cef,
  [0x495c] = 0x4cf0, [0x495d] = 0x4cf1, [0x495e] = 0x4cf2, [0x495f] = 0x4cf3,
  [0x4960] = 0x4cf4, [0x4961] = 0x4cf5, [0x4962] = 0x4cf6, [0x4963] = 0x4cf7,
  [0x4964] = 0x4cf8, [0x4965] = 0x4cf9, [0x4966] = 0x4cfa, [0x4967] = 0x4cfb,
  [0x4968] = 0x4cfc, [0x4969] = 0x4cfd, [0x496a] = 0x4cfe, [0x496b] = 0x4cff,
  [0x496c] = 0x4d00, [0x496d] = 0x4d01, [0x496e] = 0x4d02, [0x496f] = 0x4d03,
  [0x4970] = 0x4d04, [0x4971] = 0x4d05, [0x4972] = 0x4d06, [0x4973] = 0x4d07,
  [0x4974] = 0x4d08, [0x4975] = 0x4d09, [0x4976] = 0x4d0a, [0x4977] = 0x4d0b,
  [0x4978] = 0x4d0c, [0x4979] = 0x4d0d, [0x497a] = 0x4d0e, [0x497b] = 0x4d0f,
  [0x497c] = 0x4d10, [0x497d] = 0x4d11, [0x497e] = 0x4d12, [0x497f] = 0x4d1a,
  [0x4980] = 0x4d1b, [0x4981] = 0x4d1c, [0x4982] = 0x4d1d, [0x4983] = 0x4d1e,
  [0x4984] = 0x4d1f, [0x4985] = 0x4d20, [0x4986] = 0x4d21, [0x4987] = 0x4d22,
  [0x4988] = 0x4d23, [0x4989] = 0x4d24, [0x498a] = 0x4d25, [0x498b] = 0x4d26,
  [0x498c] = 0x4d27, [0x498d] = 0x4d28, [0x498e] = 0x4d29, [0x498f] = 0x4d2a,
  [0x4990] = 0x4d2b, [0x4991] = 0x4d2c, [0x4992] = 0x4d2d, [0x4993] = 0x4d2e,
  [0x4994] = 0x4d2f, [0x4995] = 0x4d30, [0x4996] = 0x4d31, [0x4997] = 0x4d32,
  [0x4998] = 0x4d33, [0x4999] = 0x4d34, [0x499a] = 0x4d35, [0x499b] = 0x4d36,
  [0x499c] = 0x4d37, [0x499d] = 0x4d38, [0x499e] = 0x4d39, [0x499f] = 0x4d3a,
  [0x49a0] = 0x4d3b, [0x49a1] = 0x4d3c, [0x49a2] = 0x4d3d, [0x49a3] = 0x4d3e,
  [0x49a4] = 0x4d3f, [0x49a5] = 0x4d40, [0x49a6] = 0x4d41, [0x49a7] = 0x4d42,
  [0x49a8] = 0x4d43, [0x49a9] = 0x4d44, [0x49aa] = 0x4d45, [0x49ab] = 0x4d46,
  [0x49ac] = 0x4d47, [0x49ad] = 0x4d48, [0x49ae] = 0x4d49, [0x49af] = 0x4d4a,
  [0x49b0] = 0x4d4b, [0x49b1] = 0x4d4c, [0x49b2] = 0x4d4d, [0x49b3] = 0x4d4e,
  [0x49b4] = 0x4d4f, [0x49b5] = 0x4d50, [0x49b6] = 0x4d51, [0x49b7] = 0x4d52,
  [0x49b8] = 0x4d53, [0x49b9] = 0x4d54, [0x49ba] = 0x4d55, [0x49bb] = 0x4d56,
  [0x49bc] = 0x4d57, [0x49bd] = 0x4d58, [0x49be] = 0x4d59, [0x49bf] = 0x4d5a,
  [0x49c0] = 0x4d5b, [0x49c1] = 0x4d5c, [0x49c2] = 0x4d5d, [0x49c3] = 0x4d5e,
  [0x49c4] = 0x4d5f, [0x49c5] = 0x4d60, [0x49c6] = 0x4d61, [0x49c7] = 0x4d62,
  [0x49c8] = 0x4d63, [0x49c9] = 0x4d64, [0x49ca] = 0x4d65, [0x49cb] = 0x4d66,
  [0x49cc] = 0x4d67, [0x49cd] = 0x4d68, [0x49ce] = 0x4d69, [0x49cf] = 0x4d6a,
  [0x49d0] = 0x4d6b, [0x49d1] = 0x4d6c, [0x49d2] = 0x4d6d, [0x49d3] = 0x4d6e,
  [0x49d4] = 0x4d6f, [0x49d5] = 0x4d70, [0x49d6] = 0x4d71, [0x49d7] = 0x4d72,
  [0x49d8] = 0x4d73, [0x49d9] = 0x4d74, [0x49da] = 0x4d75, [0x49db] = 0x4d76,
  [0x49dc] = 0x4d77, [0x49dd] = 0x4d78, [0x49de] = 0x4d79, [0x49df] = 0x4d7a,
  [0x49e0] = 0x4d7b, [0x49e1] = 0x4d7c, [0x49e2] = 0x4d7d, [0x49e3] = 0x4d7e,
  [0x49e4] = 0x4d7f, [0x49e5] = 0x4d80, [0x49e6] = 0x4d81, [0x49e7] = 0x4d82,
  [0x49e8] = 0x4d83, [0x49e9] = 0x4d84, [0x49ea] = 0x4d85, [0x49eb] = 0x4d86,
  [0x49ec] = 0x4d87, [0x49ed] = 0x4d88, [0x49ee] = 0x4d89, [0x49ef] = 0x4d8a,
  [0x49f0] = 0x4d8b, [0x49f1] = 0x4d8c, [0x49f2] = 0x4d8d, [0x49f3] = 0x4d8e,
  [0x49f4] = 0x4d8f, [0x49f5] = 0x4d90, [0x49f6] = 0x4d91, [0x49f7] = 0x4d92,
  [0x49f8] = 0x4d93, [0x49f9] = 0x4d94, [0x49fa] = 0x4d95, [0x49fb] = 0x4d96,
  [0x49fc] = 0x4d97, [0x49fd] = 0x4d98, [0x49fe] = 0x4d99, [0x49ff] = 0x4d9a,
  [0x4a00] = 0x4d9b, [0x4a01] = 0x4d9c, [0x4a02] = 0x4d9d, [0x4a03] = 0x4d9e,
  [0x4a04] = 0x4d9f, [0x4a05] = 0x4da0, [0x4a06] = 0x4da1, [0x4a07] = 0x4da2,
  [0x4a08] = 0x4da3, [0x4a09] = 0x4da4, [0x4a0a] = 0x4da5, [0x4a0b] = 0x4da6,
  [0x4a0c] = 0x4da7, [0x4a0d] = 0x4da8, [0x4a0e] = 0x4da9, [0x4a0f] = 0x4daa,
  [0x4a10] = 0x4dab, [0x4a11] = 0x4dac, [0x4a12] = 0x4dad, [0x4a13] = 0x4daf,
  [0x4a14] = 0x4db0, [0x4a15] = 0x4db1, [0x4a16] = 0x4db2, [0x4a17] = 0x4db3,
  [0x4a18] = 0x4db4, [0x4a19] = 0x4db5,
  [0x4abe] = 0xa000, [0x4abf] = 0xa001,
  [0x4ac0] = 0xa002, [0x4ac1] = 0xa003, [0x4ac2] = 0xa004, [0x4ac3] = 0xa005,
  [0x4ac4] = 0xa006, [0x4ac5] = 0xa007, [0x4ac6] = 0xa008, [0x4ac7] = 0xa009,
  [0x4ac8] = 0xa00a, [0x4ac9] = 0xa00b, [0x4aca] = 0xa00c, [0x4acb] = 0xa00d,
  [0x4acc] = 0xa00e, [0x4acd] = 0xa00f, [0x4ace] = 0xa010, [0x4acf] = 0xa011,
  [0x4ad0] = 0xa012, [0x4ad1] = 0xa013, [0x4ad2] = 0xa014, [0x4ad3] = 0xa015,
  [0x4ad4] = 0xa016, [0x4ad5] = 0xa017, [0x4ad6] = 0xa018, [0x4ad7] = 0xa019,
  [0x4ad8] = 0xa01a, [0x4ad9] = 0xa01b, [0x4ada] = 0xa01c, [0x4adb] = 0xa01d,
  [0x4adc] = 0xa01e, [0x4add] = 0xa01f, [0x4ade] = 0xa020, [0x4adf] = 0xa021,
  [0x4ae0] = 0xa022, [0x4ae1] = 0xa023, [0x4ae2] = 0xa024, [0x4ae3] = 0xa025,
  [0x4ae4] = 0xa026, [0x4ae5] = 0xa027, [0x4ae6] = 0xa028, [0x4ae7] = 0xa029,
  [0x4ae8] = 0xa02a, [0x4ae9] = 0xa02b, [0x4aea] = 0xa02c, [0x4aeb] = 0xa02d,
  [0x4aec] = 0xa02e, [0x4aed] = 0xa02f, [0x4aee] = 0xa030, [0x4aef] = 0xa031,
  [0x4af0] = 0xa032, [0x4af1] = 0xa033, [0x4af2] = 0xa034, [0x4af3] = 0xa035,
  [0x4af4] = 0xa036, [0x4af5] = 0xa037, [0x4af6] = 0xa038, [0x4af7] = 0xa039,
  [0x4af8] = 0xa03a, [0x4af9] = 0xa03b, [0x4afa] = 0xa03c, [0x4afb] = 0xa03d,
  [0x4afc] = 0xa03e, [0x4afd] = 0xa03f, [0x4afe] = 0xa040, [0x4aff] = 0xa041,
  [0x4b00] = 0xa042, [0x4b01] = 0xa043, [0x4b02] = 0xa044, [0x4b03] = 0xa045,
  [0x4b04] = 0xa046, [0x4b05] = 0xa047, [0x4b06] = 0xa048, [0x4b07] = 0xa049,
  [0x4b08] = 0xa04a, [0x4b09] = 0xa04b, [0x4b0a] = 0xa04c, [0x4b0b] = 0xa04d,
  [0x4b0c] = 0xa04e, [0x4b0d] = 0xa04f, [0x4b0e] = 0xa050, [0x4b0f] = 0xa051,
  [0x4b10] = 0xa052, [0x4b11] = 0xa053, [0x4b12] = 0xa054, [0x4b13] = 0xa055,
  [0x4b14] = 0xa056, [0x4b15] = 0xa057, [0x4b16] = 0xa058, [0x4b17] = 0xa059,
  [0x4b18] = 0xa05a, [0x4b19] = 0xa05b, [0x4b1a] = 0xa05c, [0x4b1b] = 0xa05d,
  [0x4b1c] = 0xa05e, [0x4b1d] = 0xa05f, [0x4b1e] = 0xa060, [0x4b1f] = 0xa061,
  [0x4b20] = 0xa062, [0x4b21] = 0xa063, [0x4b22] = 0xa064, [0x4b23] = 0xa065,
  [0x4b24] = 0xa066, [0x4b25] = 0xa067, [0x4b26] = 0xa068, [0x4b27] = 0xa069,
  [0x4b28] = 0xa06a, [0x4b29] = 0xa06b, [0x4b2a] = 0xa06c, [0x4b2b] = 0xa06d,
  [0x4b2c] = 0xa06e, [0x4b2d] = 0xa06f, [0x4b2e] = 0xa070, [0x4b2f] = 0xa071,
  [0x4b30] = 0xa072, [0x4b31] = 0xa073, [0x4b32] = 0xa074, [0x4b33] = 0xa075,
  [0x4b34] = 0xa076, [0x4b35] = 0xa077, [0x4b36] = 0xa078, [0x4b37] = 0xa079,
  [0x4b38] = 0xa07a, [0x4b39] = 0xa07b, [0x4b3a] = 0xa07c, [0x4b3b] = 0xa07d,
  [0x4b3c] = 0xa07e, [0x4b3d] = 0xa07f, [0x4b3e] = 0xa080, [0x4b3f] = 0xa081,
  [0x4b40] = 0xa082, [0x4b41] = 0xa083, [0x4b42] = 0xa084, [0x4b43] = 0xa085,
  [0x4b44] = 0xa086, [0x4b45] = 0xa087, [0x4b46] = 0xa088, [0x4b47] = 0xa089,
  [0x4b48] = 0xa08a, [0x4b49] = 0xa08b, [0x4b4a] = 0xa08c, [0x4b4b] = 0xa08d,
  [0x4b4c] = 0xa08e, [0x4b4d] = 0xa08f, [0x4b4e] = 0xa090, [0x4b4f] = 0xa091,
  [0x4b50] = 0xa092, [0x4b51] = 0xa093, [0x4b52] = 0xa094, [0x4b53] = 0xa095,
  [0x4b54] = 0xa096, [0x4b55] = 0xa097, [0x4b56] = 0xa098, [0x4b57] = 0xa099,
  [0x4b58] = 0xa09a, [0x4b59] = 0xa09b, [0x4b5a] = 0xa09c, [0x4b5b] = 0xa09d,
  [0x4b5c] = 0xa09e, [0x4b5d] = 0xa09f, [0x4b5e] = 0xa0a0, [0x4b5f] = 0xa0a1,
  [0x4b60] = 0xa0a2, [0x4b61] = 0xa0a3, [0x4b62] = 0xa0a4, [0x4b63] = 0xa0a5,
  [0x4b64] = 0xa0a6, [0x4b65] = 0xa0a7, [0x4b66] = 0xa0a8, [0x4b67] = 0xa0a9,
  [0x4b68] = 0xa0aa, [0x4b69] = 0xa0ab, [0x4b6a] = 0xa0ac, [0x4b6b] = 0xa0ad,
  [0x4b6c] = 0xa0ae, [0x4b6d] = 0xa0af, [0x4b6e] = 0xa0b0, [0x4b6f] = 0xa0b1,
  [0x4b70] = 0xa0b2, [0x4b71] = 0xa0b3, [0x4b72] = 0xa0b4, [0x4b73] = 0xa0b5,
  [0x4b74] = 0xa0b6, [0x4b75] = 0xa0b7, [0x4b76] = 0xa0b8, [0x4b77] = 0xa0b9,
  [0x4b78] = 0xa0ba, [0x4b79] = 0xa0bb, [0x4b7a] = 0xa0bc, [0x4b7b] = 0xa0bd,
  [0x4b7c] = 0xa0be, [0x4b7d] = 0xa0bf, [0x4b7e] = 0xa0c0, [0x4b7f] = 0xa0c1,
  [0x4b80] = 0xa0c2, [0x4b81] = 0xa0c3, [0x4b82] = 0xa0c4, [0x4b83] = 0xa0c5,
  [0x4b84] = 0xa0c6, [0x4b85] = 0xa0c7, [0x4b86] = 0xa0c8, [0x4b87] = 0xa0c9,
  [0x4b88] = 0xa0ca, [0x4b89] = 0xa0cb, [0x4b8a] = 0xa0cc, [0x4b8b] = 0xa0cd,
  [0x4b8c] = 0xa0ce, [0x4b8d] = 0xa0cf, [0x4b8e] = 0xa0d0, [0x4b8f] = 0xa0d1,
  [0x4b90] = 0xa0d2, [0x4b91] = 0xa0d3, [0x4b92] = 0xa0d4, [0x4b93] = 0xa0d5,
  [0x4b94] = 0xa0d6, [0x4b95] = 0xa0d7, [0x4b96] = 0xa0d8, [0x4b97] = 0xa0d9,
  [0x4b98] = 0xa0da, [0x4b99] = 0xa0db, [0x4b9a] = 0xa0dc, [0x4b9b] = 0xa0dd,
  [0x4b9c] = 0xa0de, [0x4b9d] = 0xa0df, [0x4b9e] = 0xa0e0, [0x4b9f] = 0xa0e1,
  [0x4ba0] = 0xa0e2, [0x4ba1] = 0xa0e3, [0x4ba2] = 0xa0e4, [0x4ba3] = 0xa0e5,
  [0x4ba4] = 0xa0e6, [0x4ba5] = 0xa0e7, [0x4ba6] = 0xa0e8, [0x4ba7] = 0xa0e9,
  [0x4ba8] = 0xa0ea, [0x4ba9] = 0xa0eb, [0x4baa] = 0xa0ec, [0x4bab] = 0xa0ed,
  [0x4bac] = 0xa0ee, [0x4bad] = 0xa0ef, [0x4bae] = 0xa0f0, [0x4baf] = 0xa0f1,
  [0x4bb0] = 0xa0f2, [0x4bb1] = 0xa0f3, [0x4bb2] = 0xa0f4, [0x4bb3] = 0xa0f5,
  [0x4bb4] = 0xa0f6, [0x4bb5] = 0xa0f7, [0x4bb6] = 0xa0f8, [0x4bb7] = 0xa0f9,
  [0x4bb8] = 0xa0fa, [0x4bb9] = 0xa0fb, [0x4bba] = 0xa0fc, [0x4bbb] = 0xa0fd,
  [0x4bbc] = 0xa0fe, [0x4bbd] = 0xa0ff, [0x4bbe] = 0xa100, [0x4bbf] = 0xa101,
  [0x4bc0] = 0xa102, [0x4bc1] = 0xa103, [0x4bc2] = 0xa104, [0x4bc3] = 0xa105,
  [0x4bc4] = 0xa106, [0x4bc5] = 0xa107, [0x4bc6] = 0xa108, [0x4bc7] = 0xa109,
  [0x4bc8] = 0xa10a, [0x4bc9] = 0xa10b, [0x4bca] = 0xa10c, [0x4bcb] = 0xa10d,
  [0x4bcc] = 0xa10e, [0x4bcd] = 0xa10f, [0x4bce] = 0xa110, [0x4bcf] = 0xa111,
  [0x4bd0] = 0xa112, [0x4bd1] = 0xa113, [0x4bd2] = 0xa114, [0x4bd3] = 0xa115,
  [0x4bd4] = 0xa116, [0x4bd5] = 0xa117, [0x4bd6] = 0xa118, [0x4bd7] = 0xa119,
  [0x4bd8] = 0xa11a, [0x4bd9] = 0xa11b, [0x4bda] = 0xa11c, [0x4bdb] = 0xa11d,
  [0x4bdc] = 0xa11e, [0x4bdd] = 0xa11f, [0x4bde] = 0xa120, [0x4bdf] = 0xa121,
  [0x4be0] = 0xa122, [0x4be1] = 0xa123, [0x4be2] = 0xa124, [0x4be3] = 0xa125,
  [0x4be4] = 0xa126, [0x4be5] = 0xa127, [0x4be6] = 0xa128, [0x4be7] = 0xa129,
  [0x4be8] = 0xa12a, [0x4be9] = 0xa12b, [0x4bea] = 0xa12c, [0x4beb] = 0xa12d,
  [0x4bec] = 0xa12e, [0x4bed] = 0xa12f, [0x4bee] = 0xa130, [0x4bef] = 0xa131,
  [0x4bf0] = 0xa132, [0x4bf1] = 0xa133, [0x4bf2] = 0xa134, [0x4bf3] = 0xa135,
  [0x4bf4] = 0xa136, [0x4bf5] = 0xa137, [0x4bf6] = 0xa138, [0x4bf7] = 0xa139,
  [0x4bf8] = 0xa13a, [0x4bf9] = 0xa13b, [0x4bfa] = 0xa13c, [0x4bfb] = 0xa13d,
  [0x4bfc] = 0xa13e, [0x4bfd] = 0xa13f, [0x4bfe] = 0xa140, [0x4bff] = 0xa141,
  [0x4c00] = 0xa142, [0x4c01] = 0xa143, [0x4c02] = 0xa144, [0x4c03] = 0xa145,
  [0x4c04] = 0xa146, [0x4c05] = 0xa147, [0x4c06] = 0xa148, [0x4c07] = 0xa149,
  [0x4c08] = 0xa14a, [0x4c09] = 0xa14b, [0x4c0a] = 0xa14c, [0x4c0b] = 0xa14d,
  [0x4c0c] = 0xa14e, [0x4c0d] = 0xa14f, [0x4c0e] = 0xa150, [0x4c0f] = 0xa151,
  [0x4c10] = 0xa152, [0x4c11] = 0xa153, [0x4c12] = 0xa154, [0x4c13] = 0xa155,
  [0x4c14] = 0xa156, [0x4c15] = 0xa157, [0x4c16] = 0xa158, [0x4c17] = 0xa159,
  [0x4c18] = 0xa15a, [0x4c19] = 0xa15b, [0x4c1a] = 0xa15c, [0x4c1b] = 0xa15d,
  [0x4c1c] = 0xa15e, [0x4c1d] = 0xa15f, [0x4c1e] = 0xa160, [0x4c1f] = 0xa161,
  [0x4c20] = 0xa162, [0x4c21] = 0xa163, [0x4c22] = 0xa164, [0x4c23] = 0xa165,
  [0x4c24] = 0xa166, [0x4c25] = 0xa167, [0x4c26] = 0xa168, [0x4c27] = 0xa169,
  [0x4c28] = 0xa16a, [0x4c29] = 0xa16b, [0x4c2a] = 0xa16c, [0x4c2b] = 0xa16d,
  [0x4c2c] = 0xa16e, [0x4c2d] = 0xa16f, [0x4c2e] = 0xa170, [0x4c2f] = 0xa171,
  [0x4c30] = 0xa172, [0x4c31] = 0xa173, [0x4c32] = 0xa174, [0x4c33] = 0xa175,
  [0x4c34] = 0xa176, [0x4c35] = 0xa177, [0x4c36] = 0xa178, [0x4c37] = 0xa179,
  [0x4c38] = 0xa17a, [0x4c39] = 0xa17b, [0x4c3a] = 0xa17c, [0x4c3b] = 0xa17d,
  [0x4c3c] = 0xa17e, [0x4c3d] = 0xa17f, [0x4c3e] = 0xa180, [0x4c3f] = 0xa181,
  [0x4c40] = 0xa182, [0x4c41] = 0xa183, [0x4c42] = 0xa184, [0x4c43] = 0xa185,
  [0x4c44] = 0xa186, [0x4c45] = 0xa187, [0x4c46] = 0xa188, [0x4c47] = 0xa189,
  [0x4c48] = 0xa18a, [0x4c49] = 0xa18b, [0x4c4a] = 0xa18c, [0x4c4b] = 0xa18d,
  [0x4c4c] = 0xa18e, [0x4c4d] = 0xa18f, [0x4c4e] = 0xa190, [0x4c4f] = 0xa191,
  [0x4c50] = 0xa192, [0x4c51] = 0xa193, [0x4c52] = 0xa194, [0x4c53] = 0xa195,
  [0x4c54] = 0xa196, [0x4c55] = 0xa197, [0x4c56] = 0xa198, [0x4c57] = 0xa199,
  [0x4c58] = 0xa19a, [0x4c59] = 0xa19b, [0x4c5a] = 0xa19c, [0x4c5b] = 0xa19d,
  [0x4c5c] = 0xa19e, [0x4c5d] = 0xa19f, [0x4c5e] = 0xa1a0, [0x4c5f] = 0xa1a1,
  [0x4c60] = 0xa1a2, [0x4c61] = 0xa1a3, [0x4c62] = 0xa1a4, [0x4c63] = 0xa1a5,
  [0x4c64] = 0xa1a6, [0x4c65] = 0xa1a7, [0x4c66] = 0xa1a8, [0x4c67] = 0xa1a9,
  [0x4c68] = 0xa1aa, [0x4c69] = 0xa1ab, [0x4c6a] = 0xa1ac, [0x4c6b] = 0xa1ad,
  [0x4c6c] = 0xa1ae, [0x4c6d] = 0xa1af, [0x4c6e] = 0xa1b0, [0x4c6f] = 0xa1b1,
  [0x4c70] = 0xa1b2, [0x4c71] = 0xa1b3, [0x4c72] = 0xa1b4, [0x4c73] = 0xa1b5,
  [0x4c74] = 0xa1b6, [0x4c75] = 0xa1b7, [0x4c76] = 0xa1b8, [0x4c77] = 0xa1b9,
  [0x4c78] = 0xa1ba, [0x4c79] = 0xa1bb, [0x4c7a] = 0xa1bc, [0x4c7b] = 0xa1bd,
  [0x4c7c] = 0xa1be, [0x4c7d] = 0xa1bf, [0x4c7e] = 0xa1c0, [0x4c7f] = 0xa1c1,
  [0x4c80] = 0xa1c2, [0x4c81] = 0xa1c3, [0x4c82] = 0xa1c4, [0x4c83] = 0xa1c5,
  [0x4c84] = 0xa1c6, [0x4c85] = 0xa1c7, [0x4c86] = 0xa1c8, [0x4c87] = 0xa1c9,
  [0x4c88] = 0xa1ca, [0x4c89] = 0xa1cb, [0x4c8a] = 0xa1cc, [0x4c8b] = 0xa1cd,
  [0x4c8c] = 0xa1ce, [0x4c8d] = 0xa1cf, [0x4c8e] = 0xa1d0, [0x4c8f] = 0xa1d1,
  [0x4c90] = 0xa1d2, [0x4c91] = 0xa1d3, [0x4c92] = 0xa1d4, [0x4c93] = 0xa1d5,
  [0x4c94] = 0xa1d6, [0x4c95] = 0xa1d7, [0x4c96] = 0xa1d8, [0x4c97] = 0xa1d9,
  [0x4c98] = 0xa1da, [0x4c99] = 0xa1db, [0x4c9a] = 0xa1dc, [0x4c9b] = 0xa1dd,
  [0x4c9c] = 0xa1de, [0x4c9d] = 0xa1df, [0x4c9e] = 0xa1e0, [0x4c9f] = 0xa1e1,
  [0x4ca0] = 0xa1e2, [0x4ca1] = 0xa1e3, [0x4ca2] = 0xa1e4, [0x4ca3] = 0xa1e5,
  [0x4ca4] = 0xa1e6, [0x4ca5] = 0xa1e7, [0x4ca6] = 0xa1e8, [0x4ca7] = 0xa1e9,
  [0x4ca8] = 0xa1ea, [0x4ca9] = 0xa1eb, [0x4caa] = 0xa1ec, [0x4cab] = 0xa1ed,
  [0x4cac] = 0xa1ee, [0x4cad] = 0xa1ef, [0x4cae] = 0xa1f0, [0x4caf] = 0xa1f1,
  [0x4cb0] = 0xa1f2, [0x4cb1] = 0xa1f3, [0x4cb2] = 0xa1f4, [0x4cb3] = 0xa1f5,
  [0x4cb4] = 0xa1f6, [0x4cb5] = 0xa1f7, [0x4cb6] = 0xa1f8, [0x4cb7] = 0xa1f9,
  [0x4cb8] = 0xa1fa, [0x4cb9] = 0xa1fb, [0x4cba] = 0xa1fc, [0x4cbb] = 0xa1fd,
  [0x4cbc] = 0xa1fe, [0x4cbd] = 0xa1ff, [0x4cbe] = 0xa200, [0x4cbf] = 0xa201,
  [0x4cc0] = 0xa202, [0x4cc1] = 0xa203, [0x4cc2] = 0xa204, [0x4cc3] = 0xa205,
  [0x4cc4] = 0xa206, [0x4cc5] = 0xa207, [0x4cc6] = 0xa208, [0x4cc7] = 0xa209,
  [0x4cc8] = 0xa20a, [0x4cc9] = 0xa20b, [0x4cca] = 0xa20c, [0x4ccb] = 0xa20d,
  [0x4ccc] = 0xa20e, [0x4ccd] = 0xa20f, [0x4cce] = 0xa210, [0x4ccf] = 0xa211,
  [0x4cd0] = 0xa212, [0x4cd1] = 0xa213, [0x4cd2] = 0xa214, [0x4cd3] = 0xa215,
  [0x4cd4] = 0xa216, [0x4cd5] = 0xa217, [0x4cd6] = 0xa218, [0x4cd7] = 0xa219,
  [0x4cd8] = 0xa21a, [0x4cd9] = 0xa21b, [0x4cda] = 0xa21c, [0x4cdb] = 0xa21d,
  [0x4cdc] = 0xa21e, [0x4cdd] = 0xa21f, [0x4cde] = 0xa220, [0x4cdf] = 0xa221,
  [0x4ce0] = 0xa222, [0x4ce1] = 0xa223, [0x4ce2] = 0xa224, [0x4ce3] = 0xa225,
  [0x4ce4] = 0xa226, [0x4ce5] = 0xa227, [0x4ce6] = 0xa228, [0x4ce7] = 0xa229,
  [0x4ce8] = 0xa22a, [0x4ce9] = 0xa22b, [0x4cea] = 0xa22c, [0x4ceb] = 0xa22d,
  [0x4cec] = 0xa22e, [0x4ced] = 0xa22f, [0x4cee] = 0xa230, [0x4cef] = 0xa231,
  [0x4cf0] = 0xa232, [0x4cf1] = 0xa233, [0x4cf2] = 0xa234, [0x4cf3] = 0xa235,
  [0x4cf4] = 0xa236, [0x4cf5] = 0xa237, [0x4cf6] = 0xa238, [0x4cf7] = 0xa239,
  [0x4cf8] = 0xa23a, [0x4cf9] = 0xa23b, [0x4cfa] = 0xa23c, [0x4cfb] = 0xa23d,
  [0x4cfc] = 0xa23e, [0x4cfd] = 0xa23f, [0x4cfe] = 0xa240, [0x4cff] = 0xa241,
  [0x4d00] = 0xa242, [0x4d01] = 0xa243, [0x4d02] = 0xa244, [0x4d03] = 0xa245,
  [0x4d04] = 0xa246, [0x4d05] = 0xa247, [0x4d06] = 0xa248, [0x4d07] = 0xa249,
  [0x4d08] = 0xa24a, [0x4d09] = 0xa24b, [0x4d0a] = 0xa24c, [0x4d0b] = 0xa24d,
  [0x4d0c] = 0xa24e, [0x4d0d] = 0xa24f, [0x4d0e] = 0xa250, [0x4d0f] = 0xa251,
  [0x4d10] = 0xa252, [0x4d11] = 0xa253, [0x4d12] = 0xa254, [0x4d13] = 0xa255,
  [0x4d14] = 0xa256, [0x4d15] = 0xa257, [0x4d16] = 0xa258, [0x4d17] = 0xa259,
  [0x4d18] = 0xa25a, [0x4d19] = 0xa25b, [0x4d1a] = 0xa25c, [0x4d1b] = 0xa25d,
  [0x4d1c] = 0xa25e, [0x4d1d] = 0xa25f, [0x4d1e] = 0xa260, [0x4d1f] = 0xa261,
  [0x4d20] = 0xa262, [0x4d21] = 0xa263, [0x4d22] = 0xa264, [0x4d23] = 0xa265,
  [0x4d24] = 0xa266, [0x4d25] = 0xa267, [0x4d26] = 0xa268, [0x4d27] = 0xa269,
  [0x4d28] = 0xa26a, [0x4d29] = 0xa26b, [0x4d2a] = 0xa26c, [0x4d2b] = 0xa26d,
  [0x4d2c] = 0xa26e, [0x4d2d] = 0xa26f, [0x4d2e] = 0xa270, [0x4d2f] = 0xa271,
  [0x4d30] = 0xa272, [0x4d31] = 0xa273, [0x4d32] = 0xa274, [0x4d33] = 0xa275,
  [0x4d34] = 0xa276, [0x4d35] = 0xa277, [0x4d36] = 0xa278, [0x4d37] = 0xa279,
  [0x4d38] = 0xa27a, [0x4d39] = 0xa27b, [0x4d3a] = 0xa27c, [0x4d3b] = 0xa27d,
  [0x4d3c] = 0xa27e, [0x4d3d] = 0xa27f, [0x4d3e] = 0xa280, [0x4d3f] = 0xa281,
  [0x4d40] = 0xa282, [0x4d41] = 0xa283, [0x4d42] = 0xa284, [0x4d43] = 0xa285,
  [0x4d44] = 0xa286, [0x4d45] = 0xa287, [0x4d46] = 0xa288, [0x4d47] = 0xa289,
  [0x4d48] = 0xa28a, [0x4d49] = 0xa28b, [0x4d4a] = 0xa28c, [0x4d4b] = 0xa28d,
  [0x4d4c] = 0xa28e, [0x4d4d] = 0xa28f, [0x4d4e] = 0xa290, [0x4d4f] = 0xa291,
  [0x4d50] = 0xa292, [0x4d51] = 0xa293, [0x4d52] = 0xa294, [0x4d53] = 0xa295,
  [0x4d54] = 0xa296, [0x4d55] = 0xa297, [0x4d56] = 0xa298, [0x4d57] = 0xa299,
  [0x4d58] = 0xa29a, [0x4d59] = 0xa29b, [0x4d5a] = 0xa29c, [0x4d5b] = 0xa29d,
  [0x4d5c] = 0xa29e, [0x4d5d] = 0xa29f, [0x4d5e] = 0xa2a0, [0x4d5f] = 0xa2a1,
  [0x4d60] = 0xa2a2, [0x4d61] = 0xa2a3, [0x4d62] = 0xa2a4, [0x4d63] = 0xa2a5,
  [0x4d64] = 0xa2a6, [0x4d65] = 0xa2a7, [0x4d66] = 0xa2a8, [0x4d67] = 0xa2a9,
  [0x4d68] = 0xa2aa, [0x4d69] = 0xa2ab, [0x4d6a] = 0xa2ac, [0x4d6b] = 0xa2ad,
  [0x4d6c] = 0xa2ae, [0x4d6d] = 0xa2af, [0x4d6e] = 0xa2b0, [0x4d6f] = 0xa2b1,
  [0x4d70] = 0xa2b2, [0x4d71] = 0xa2b3, [0x4d72] = 0xa2b4, [0x4d73] = 0xa2b5,
  [0x4d74] = 0xa2b6, [0x4d75] = 0xa2b7, [0x4d76] = 0xa2b8, [0x4d77] = 0xa2b9,
  [0x4d78] = 0xa2ba, [0x4d79] = 0xa2bb, [0x4d7a] = 0xa2bc, [0x4d7b] = 0xa2bd,
  [0x4d7c] = 0xa2be, [0x4d7d] = 0xa2bf, [0x4d7e] = 0xa2c0, [0x4d7f] = 0xa2c1,
  [0x4d80] = 0xa2c2, [0x4d81] = 0xa2c3, [0x4d82] = 0xa2c4, [0x4d83] = 0xa2c5,
  [0x4d84] = 0xa2c6, [0x4d85] = 0xa2c7, [0x4d86] = 0xa2c8, [0x4d87] = 0xa2c9,
  [0x4d88] = 0xa2ca, [0x4d89] = 0xa2cb, [0x4d8a] = 0xa2cc, [0x4d8b] = 0xa2cd,
  [0x4d8c] = 0xa2ce, [0x4d8d] = 0xa2cf, [0x4d8e] = 0xa2d0, [0x4d8f] = 0xa2d1,
  [0x4d90] = 0xa2d2, [0x4d91] = 0xa2d3, [0x4d92] = 0xa2d4, [0x4d93] = 0xa2d5,
  [0x4d94] = 0xa2d6, [0x4d95] = 0xa2d7, [0x4d96] = 0xa2d8, [0x4d97] = 0xa2d9,
  [0x4d98] = 0xa2da, [0x4d99] = 0xa2db, [0x4d9a] = 0xa2dc, [0x4d9b] = 0xa2dd,
  [0x4d9c] = 0xa2de, [0x4d9d] = 0xa2df, [0x4d9e] = 0xa2e0, [0x4d9f] = 0xa2e1,
  [0x4da0] = 0xa2e2, [0x4da1] = 0xa2e3, [0x4da2] = 0xa2e4, [0x4da3] = 0xa2e5,
  [0x4da4] = 0xa2e6, [0x4da5] = 0xa2e7, [0x4da6] = 0xa2e8, [0x4da7] = 0xa2e9,
  [0x4da8] = 0xa2ea, [0x4da9] = 0xa2eb, [0x4daa] = 0xa2ec, [0x4dab] = 0xa2ed,
  [0x4dac] = 0xa2ee, [0x4dad] = 0xa2ef, [0x4dae] = 0xa2f0, [0x4daf] = 0xa2f1,
  [0x4db0] = 0xa2f2, [0x4db1] = 0xa2f3, [0x4db2] = 0xa2f4, [0x4db3] = 0xa2f5,
  [0x4db4] = 0xa2f6, [0x4db5] = 0xa2f7, [0x4db6] = 0xa2f8, [0x4db7] = 0xa2f9,
  [0x4db8] = 0xa2fa, [0x4db9] = 0xa2fb, [0x4dba] = 0xa2fc, [0x4dbb] = 0xa2fd,
  [0x4dbc] = 0xa2fe, [0x4dbd] = 0xa2ff, [0x4dbe] = 0xa300, [0x4dbf] = 0xa301,
  [0x4dc0] = 0xa302, [0x4dc1] = 0xa303, [0x4dc2] = 0xa304, [0x4dc3] = 0xa305,
  [0x4dc4] = 0xa306, [0x4dc5] = 0xa307, [0x4dc6] = 0xa308, [0x4dc7] = 0xa309,
  [0x4dc8] = 0xa30a, [0x4dc9] = 0xa30b, [0x4dca] = 0xa30c, [0x4dcb] = 0xa30d,
  [0x4dcc] = 0xa30e, [0x4dcd] = 0xa30f, [0x4dce] = 0xa310, [0x4dcf] = 0xa311,
  [0x4dd0] = 0xa312, [0x4dd1] = 0xa313, [0x4dd2] = 0xa314, [0x4dd3] = 0xa315,
  [0x4dd4] = 0xa316, [0x4dd5] = 0xa317, [0x4dd6] = 0xa318, [0x4dd7] = 0xa319,
  [0x4dd8] = 0xa31a, [0x4dd9] = 0xa31b, [0x4dda] = 0xa31c, [0x4ddb] = 0xa31d,
  [0x4ddc] = 0xa31e, [0x4ddd] = 0xa31f, [0x4dde] = 0xa320, [0x4ddf] = 0xa321,
  [0x4de0] = 0xa322, [0x4de1] = 0xa323, [0x4de2] = 0xa324, [0x4de3] = 0xa325,
  [0x4de4] = 0xa326, [0x4de5] = 0xa327, [0x4de6] = 0xa328, [0x4de7] = 0xa329,
  [0x4de8] = 0xa32a, [0x4de9] = 0xa32b, [0x4dea] = 0xa32c, [0x4deb] = 0xa32d,
  [0x4dec] = 0xa32e, [0x4ded] = 0xa32f, [0x4dee] = 0xa330, [0x4def] = 0xa331,
  [0x4df0] = 0xa332, [0x4df1] = 0xa333, [0x4df2] = 0xa334, [0x4df3] = 0xa335,
  [0x4df4] = 0xa336, [0x4df5] = 0xa337, [0x4df6] = 0xa338, [0x4df7] = 0xa339,
  [0x4df8] = 0xa33a, [0x4df9] = 0xa33b, [0x4dfa] = 0xa33c, [0x4dfb] = 0xa33d,
  [0x4dfc] = 0xa33e, [0x4dfd] = 0xa33f, [0x4dfe] = 0xa340, [0x4dff] = 0xa341,
  [0x4e00] = 0xa342, [0x4e01] = 0xa343, [0x4e02] = 0xa344, [0x4e03] = 0xa345,
  [0x4e04] = 0xa346, [0x4e05] = 0xa347, [0x4e06] = 0xa348, [0x4e07] = 0xa349,
  [0x4e08] = 0xa34a, [0x4e09] = 0xa34b, [0x4e0a] = 0xa34c, [0x4e0b] = 0xa34d,
  [0x4e0c] = 0xa34e, [0x4e0d] = 0xa34f, [0x4e0e] = 0xa350, [0x4e0f] = 0xa351,
  [0x4e10] = 0xa352, [0x4e11] = 0xa353, [0x4e12] = 0xa354, [0x4e13] = 0xa355,
  [0x4e14] = 0xa356, [0x4e15] = 0xa357, [0x4e16] = 0xa358, [0x4e17] = 0xa359,
  [0x4e18] = 0xa35a, [0x4e19] = 0xa35b, [0x4e1a] = 0xa35c, [0x4e1b] = 0xa35d,
  [0x4e1c] = 0xa35e, [0x4e1d] = 0xa35f, [0x4e1e] = 0xa360, [0x4e1f] = 0xa361,
  [0x4e20] = 0xa362, [0x4e21] = 0xa363, [0x4e22] = 0xa364, [0x4e23] = 0xa365,
  [0x4e24] = 0xa366, [0x4e25] = 0xa367, [0x4e26] = 0xa368, [0x4e27] = 0xa369,
  [0x4e28] = 0xa36a, [0x4e29] = 0xa36b, [0x4e2a] = 0xa36c, [0x4e2b] = 0xa36d,
  [0x4e2c] = 0xa36e, [0x4e2d] = 0xa36f, [0x4e2e] = 0xa370, [0x4e2f] = 0xa371,
  [0x4e30] = 0xa372, [0x4e31] = 0xa373, [0x4e32] = 0xa374, [0x4e33] = 0xa375,
  [0x4e34] = 0xa376, [0x4e35] = 0xa377, [0x4e36] = 0xa378, [0x4e37] = 0xa379,
  [0x4e38] = 0xa37a, [0x4e39] = 0xa37b, [0x4e3a] = 0xa37c, [0x4e3b] = 0xa37d,
  [0x4e3c] = 0xa37e, [0x4e3d] = 0xa37f, [0x4e3e] = 0xa380, [0x4e3f] = 0xa381,
  [0x4e40] = 0xa382, [0x4e41] = 0xa383, [0x4e42] = 0xa384, [0x4e43] = 0xa385,
  [0x4e44] = 0xa386, [0x4e45] = 0xa387, [0x4e46] = 0xa388, [0x4e47] = 0xa389,
  [0x4e48] = 0xa38a, [0x4e49] = 0xa38b, [0x4e4a] = 0xa38c, [0x4e4b] = 0xa38d,
  [0x4e4c] = 0xa38e, [0x4e4d] = 0xa38f, [0x4e4e] = 0xa390, [0x4e4f] = 0xa391,
  [0x4e50] = 0xa392, [0x4e51] = 0xa393, [0x4e52] = 0xa394, [0x4e53] = 0xa395,
  [0x4e54] = 0xa396, [0x4e55] = 0xa397, [0x4e56] = 0xa398, [0x4e57] = 0xa399,
  [0x4e58] = 0xa39a, [0x4e59] = 0xa39b, [0x4e5a] = 0xa39c, [0x4e5b] = 0xa39d,
  [0x4e5c] = 0xa39e, [0x4e5d] = 0xa39f, [0x4e5e] = 0xa3a0, [0x4e5f] = 0xa3a1,
  [0x4e60] = 0xa3a2, [0x4e61] = 0xa3a3, [0x4e62] = 0xa3a4, [0x4e63] = 0xa3a5,
  [0x4e64] = 0xa3a6, [0x4e65] = 0xa3a7, [0x4e66] = 0xa3a8, [0x4e67] = 0xa3a9,
  [0x4e68] = 0xa3aa, [0x4e69] = 0xa3ab, [0x4e6a] = 0xa3ac, [0x4e6b] = 0xa3ad,
  [0x4e6c] = 0xa3ae, [0x4e6d] = 0xa3af, [0x4e6e] = 0xa3b0, [0x4e6f] = 0xa3b1,
  [0x4e70] = 0xa3b2, [0x4e71] = 0xa3b3, [0x4e72] = 0xa3b4, [0x4e73] = 0xa3b5,
  [0x4e74] = 0xa3b6, [0x4e75] = 0xa3b7, [0x4e76] = 0xa3b8, [0x4e77] = 0xa3b9,
  [0x4e78] = 0xa3ba, [0x4e79] = 0xa3bb, [0x4e7a] = 0xa3bc, [0x4e7b] = 0xa3bd,
  [0x4e7c] = 0xa3be, [0x4e7d] = 0xa3bf, [0x4e7e] = 0xa3c0, [0x4e7f] = 0xa3c1,
  [0x4e80] = 0xa3c2, [0x4e81] = 0xa3c3, [0x4e82] = 0xa3c4, [0x4e83] = 0xa3c5,
  [0x4e84] = 0xa3c6, [0x4e85] = 0xa3c7, [0x4e86] = 0xa3c8, [0x4e87] = 0xa3c9,
  [0x4e88] = 0xa3ca, [0x4e89] = 0xa3cb, [0x4e8a] = 0xa3cc, [0x4e8b] = 0xa3cd,
  [0x4e8c] = 0xa3ce, [0x4e8d] = 0xa3cf, [0x4e8e] = 0xa3d0, [0x4e8f] = 0xa3d1,
  [0x4e90] = 0xa3d2, [0x4e91] = 0xa3d3, [0x4e92] = 0xa3d4, [0x4e93] = 0xa3d5,
  [0x4e94] = 0xa3d6, [0x4e95] = 0xa3d7, [0x4e96] = 0xa3d8, [0x4e97] = 0xa3d9,
  [0x4e98] = 0xa3da, [0x4e99] = 0xa3db, [0x4e9a] = 0xa3dc, [0x4e9b] = 0xa3dd,
  [0x4e9c] = 0xa3de, [0x4e9d] = 0xa3df, [0x4e9e] = 0xa3e0, [0x4e9f] = 0xa3e1,
  [0x4ea0] = 0xa3e2, [0x4ea1] = 0xa3e3, [0x4ea2] = 0xa3e4, [0x4ea3] = 0xa3e5,
  [0x4ea4] = 0xa3e6, [0x4ea5] = 0xa3e7, [0x4ea6] = 0xa3e8, [0x4ea7] = 0xa3e9,
  [0x4ea8] = 0xa3ea, [0x4ea9] = 0xa3eb, [0x4eaa] = 0xa3ec, [0x4eab] = 0xa3ed,
  [0x4eac] = 0xa3ee, [0x4ead] = 0xa3ef, [0x4eae] = 0xa3f0, [0x4eaf] = 0xa3f1,
  [0x4eb0] = 0xa3f2, [0x4eb1] = 0xa3f3, [0x4eb2] = 0xa3f4, [0x4eb3] = 0xa3f5,
  [0x4eb4] = 0xa3f6, [0x4eb5] = 0xa3f7, [0x4eb6] = 0xa3f8, [0x4eb7] = 0xa3f9,
  [0x4eb8] = 0xa3fa, [0x4eb9] = 0xa3fb, [0x4eba] = 0xa3fc, [0x4ebb] = 0xa3fd,
  [0x4ebc] = 0xa3fe, [0x4ebd] = 0xa3ff, [0x4ebe] = 0xa400, [0x4ebf] = 0xa401,
  [0x4ec0] = 0xa402, [0x4ec1] = 0xa403, [0x4ec2] = 0xa404, [0x4ec3] = 0xa405,
  [0x4ec4] = 0xa406, [0x4ec5] = 0xa407, [0x4ec6] = 0xa408, [0x4ec7] = 0xa409,
  [0x4ec8] = 0xa40a, [0x4ec9] = 0xa40b, [0x4eca] = 0xa40c, [0x4ecb] = 0xa40d,
  [0x4ecc] = 0xa40e, [0x4ecd] = 0xa40f, [0x4ece] = 0xa410, [0x4ecf] = 0xa411,
  [0x4ed0] = 0xa412, [0x4ed1] = 0xa413, [0x4ed2] = 0xa414, [0x4ed3] = 0xa415,
  [0x4ed4] = 0xa416, [0x4ed5] = 0xa417, [0x4ed6] = 0xa418, [0x4ed7] = 0xa419,
  [0x4ed8] = 0xa41a, [0x4ed9] = 0xa41b, [0x4eda] = 0xa41c, [0x4edb] = 0xa41d,
  [0x4edc] = 0xa41e, [0x4edd] = 0xa41f, [0x4ede] = 0xa420, [0x4edf] = 0xa421,
  [0x4ee0] = 0xa422, [0x4ee1] = 0xa423, [0x4ee2] = 0xa424, [0x4ee3] = 0xa425,
  [0x4ee4] = 0xa426, [0x4ee5] = 0xa427, [0x4ee6] = 0xa428, [0x4ee7] = 0xa429,
  [0x4ee8] = 0xa42a, [0x4ee9] = 0xa42b, [0x4eea] = 0xa42c, [0x4eeb] = 0xa42d,
  [0x4eec] = 0xa42e, [0x4eed] = 0xa42f, [0x4eee] = 0xa430, [0x4eef] = 0xa431,
  [0x4ef0] = 0xa432, [0x4ef1] = 0xa433, [0x4ef2] = 0xa434, [0x4ef3] = 0xa435,
  [0x4ef4] = 0xa436, [0x4ef5] = 0xa437, [0x4ef6] = 0xa438, [0x4ef7] = 0xa439,
  [0x4ef8] = 0xa43a, [0x4ef9] = 0xa43b, [0x4efa] = 0xa43c, [0x4efb] = 0xa43d,
  [0x4efc] = 0xa43e, [0x4efd] = 0xa43f, [0x4efe] = 0xa440, [0x4eff] = 0xa441,
  [0x4f00] = 0xa442, [0x4f01] = 0xa443, [0x4f02] = 0xa444, [0x4f03] = 0xa445,
  [0x4f04] = 0xa446, [0x4f05] = 0xa447, [0x4f06] = 0xa448, [0x4f07] = 0xa449,
  [0x4f08] = 0xa44a, [0x4f09] = 0xa44b, [0x4f0a] = 0xa44c, [0x4f0b] = 0xa44d,
  [0x4f0c] = 0xa44e, [0x4f0d] = 0xa44f, [0x4f0e] = 0xa450, [0x4f0f] = 0xa451,
  [0x4f10] = 0xa452, [0x4f11] = 0xa453, [0x4f12] = 0xa454, [0x4f13] = 0xa455,
  [0x4f14] = 0xa456, [0x4f15] = 0xa457, [0x4f16] = 0xa458, [0x4f17] = 0xa459,
  [0x4f18] = 0xa45a, [0x4f19] = 0xa45b, [0x4f1a] = 0xa45c, [0x4f1b] = 0xa45d,
  [0x4f1c] = 0xa45e, [0x4f1d] = 0xa45f, [0x4f1e] = 0xa460, [0x4f1f] = 0xa461,
  [0x4f20] = 0xa462, [0x4f21] = 0xa463, [0x4f22] = 0xa464, [0x4f23] = 0xa465,
  [0x4f24] = 0xa466, [0x4f25] = 0xa467, [0x4f26] = 0xa468, [0x4f27] = 0xa469,
  [0x4f28] = 0xa46a, [0x4f29] = 0xa46b, [0x4f2a] = 0xa46c, [0x4f2b] = 0xa46d,
  [0x4f2c] = 0xa46e, [0x4f2d] = 0xa46f, [0x4f2e] = 0xa470, [0x4f2f] = 0xa471,
  [0x4f30] = 0xa472, [0x4f31] = 0xa473, [0x4f32] = 0xa474, [0x4f33] = 0xa475,
  [0x4f34] = 0xa476, [0x4f35] = 0xa477, [0x4f36] = 0xa478, [0x4f37] = 0xa479,
  [0x4f38] = 0xa47a, [0x4f39] = 0xa47b, [0x4f3a] = 0xa47c, [0x4f3b] = 0xa47d,
  [0x4f3c] = 0xa47e, [0x4f3d] = 0xa47f, [0x4f3e] = 0xa480, [0x4f3f] = 0xa481,
  [0x4f40] = 0xa482, [0x4f41] = 0xa483, [0x4f42] = 0xa484, [0x4f43] = 0xa485,
  [0x4f44] = 0xa486, [0x4f45] = 0xa487, [0x4f46] = 0xa488, [0x4f47] = 0xa489,
  [0x4f48] = 0xa48a, [0x4f49] = 0xa48b, [0x4f4a] = 0xa48c,
  [0x4f4e] = 0xa490, [0x4f4f] = 0xa491,
  [0x4f50] = 0xa492, [0x4f51] = 0xa493, [0x4f52] = 0xa494, [0x4f53] = 0xa495,
  [0x4f54] = 0xa496, [0x4f55] = 0xa497, [0x4f56] = 0xa498, [0x4f57] = 0xa499,
  [0x4f58] = 0xa49a, [0x4f59] = 0xa49b, [0x4f5a] = 0xa49c, [0x4f5b] = 0xa49d,
  [0x4f5c] = 0xa49e, [0x4f5d] = 0xa49f, [0x4f5e] = 0xa4a0, [0x4f5f] = 0xa4a1,
  [0x4f62] = 0xa4a4, [0x4f63] = 0xa4a5,
  [0x4f64] = 0xa4a6, [0x4f65] = 0xa4a7, [0x4f66] = 0xa4a8, [0x4f67] = 0xa4a9,
  [0x4f68] = 0xa4aa, [0x4f69] = 0xa4ab, [0x4f6a] = 0xa4ac, [0x4f6b] = 0xa4ad,
  [0x4f6c] = 0xa4ae, [0x4f6d] = 0xa4af, [0x4f6e] = 0xa4b0, [0x4f6f] = 0xa4b1,
  [0x4f70] = 0xa4b2, [0x4f71] = 0xa4b3, [0x4f73] = 0xa4b5,
  [0x4f74] = 0xa4b6, [0x4f75] = 0xa4b7, [0x4f76] = 0xa4b8, [0x4f77] = 0xa4b9,
  [0x4f78] = 0xa4ba, [0x4f79] = 0xa4bb, [0x4f7a] = 0xa4bc, [0x4f7b] = 0xa4bd,
  [0x4f7c] = 0xa4be, [0x4f7d] = 0xa4bf, [0x4f7e] = 0xa4c0,
  [0x4f80] = 0xa4c2, [0x4f81] = 0xa4c3, [0x4f82] = 0xa4c4,
  [0x4f84] = 0xa4c6, [0x56be] = 0xac00, [0x56bf] = 0xac01,
  [0x56c0] = 0xac02, [0x56c1] = 0xac03, [0x56c2] = 0xac04, [0x56c3] = 0xac05,
  [0x56c4] = 0xac06, [0x56c5] = 0xac07, [0x56c6] = 0xac08, [0x56c7] = 0xac09,
  [0x56c8] = 0xac0a, [0x56c9] = 0xac0b, [0x56ca] = 0xac0c, [0x56cb] = 0xac0d,
  [0x56cc] = 0xac0e, [0x56cd] = 0xac0f, [0x56ce] = 0xac10, [0x56cf] = 0xac11,
  [0x56d0] = 0xac12, [0x56d1] = 0xac13, [0x56d2] = 0xac14, [0x56d3] = 0xac15,
  [0x56d4] = 0xac16, [0x56d5] = 0xac17, [0x56d6] = 0xac18, [0x56d7] = 0xac19,
  [0x56d8] = 0xac1a, [0x56d9] = 0xac1b, [0x56da] = 0xac1c, [0x56db] = 0xac1d,
  [0x56dc] = 0xac1e, [0x56dd] = 0xac1f, [0x56de] = 0xac20, [0x56df] = 0xac21,
  [0x56e0] = 0xac22, [0x56e1] = 0xac23, [0x56e2] = 0xac24, [0x56e3] = 0xac25,
  [0x56e4] = 0xac26, [0x56e5] = 0xac27, [0x56e6] = 0xac28, [0x56e7] = 0xac29,
  [0x56e8] = 0xac2a, [0x56e9] = 0xac2b, [0x56ea] = 0xac2c, [0x56eb] = 0xac2d,
  [0x56ec] = 0xac2e, [0x56ed] = 0xac2f, [0x56ee] = 0xac30, [0x56ef] = 0xac31,
  [0x56f0] = 0xac32, [0x56f1] = 0xac33, [0x56f2] = 0xac34, [0x56f3] = 0xac35,
  [0x56f4] = 0xac36, [0x56f5] = 0xac37, [0x56f6] = 0xac38, [0x56f7] = 0xac39,
  [0x56f8] = 0xac3a, [0x56f9] = 0xac3b, [0x56fa] = 0xac3c, [0x56fb] = 0xac3d,
  [0x56fc] = 0xac3e, [0x56fd] = 0xac3f, [0x56fe] = 0xac40, [0x56ff] = 0xac41,
  [0x5700] = 0xac42, [0x5701] = 0xac43, [0x5702] = 0xac44, [0x5703] = 0xac45,
  [0x5704] = 0xac46, [0x5705] = 0xac47, [0x5706] = 0xac48, [0x5707] = 0xac49,
  [0x5708] = 0xac4a, [0x5709] = 0xac4b, [0x570a] = 0xac4c, [0x570b] = 0xac4d,
  [0x570c] = 0xac4e, [0x570d] = 0xac4f, [0x570e] = 0xac50, [0x570f] = 0xac51,
  [0x5710] = 0xac52, [0x5711] = 0xac53, [0x5712] = 0xac54, [0x5713] = 0xac55,
  [0x5714] = 0xac56, [0x5715] = 0xac57, [0x5716] = 0xac58, [0x5717] = 0xac59,
  [0x5718] = 0xac5a, [0x5719] = 0xac5b, [0x571a] = 0xac5c, [0x571b] = 0xac5d,
  [0x571c] = 0xac5e, [0x571d] = 0xac5f, [0x571e] = 0xac60, [0x571f] = 0xac61,
  [0x5720] = 0xac62, [0x5721] = 0xac63, [0x5722] = 0xac64, [0x5723] = 0xac65,
  [0x5724] = 0xac66, [0x5725] = 0xac67, [0x5726] = 0xac68, [0x5727] = 0xac69,
  [0x5728] = 0xac6a, [0x5729] = 0xac6b, [0x572a] = 0xac6c, [0x572b] = 0xac6d,
  [0x572c] = 0xac6e, [0x572d] = 0xac6f, [0x572e] = 0xac70, [0x572f] = 0xac71,
  [0x5730] = 0xac72, [0x5731] = 0xac73, [0x5732] = 0xac74, [0x5733] = 0xac75,
  [0x5734] = 0xac76, [0x5735] = 0xac77, [0x5736] = 0xac78, [0x5737] = 0xac79,
  [0x5738] = 0xac7a, [0x5739] = 0xac7b, [0x573a] = 0xac7c, [0x573b] = 0xac7d,
  [0x573c] = 0xac7e, [0x573d] = 0xac7f, [0x573e] = 0xac80, [0x573f] = 0xac81,
  [0x5740] = 0xac82, [0x5741] = 0xac83, [0x5742] = 0xac84, [0x5743] = 0xac85,
  [0x5744] = 0xac86, [0x5745] = 0xac87, [0x5746] = 0xac88, [0x5747] = 0xac89,
  [0x5748] = 0xac8a, [0x5749] = 0xac8b, [0x574a] = 0xac8c, [0x574b] = 0xac8d,
  [0x574c] = 0xac8e, [0x574d] = 0xac8f, [0x574e] = 0xac90, [0x574f] = 0xac91,
  [0x5750] = 0xac92, [0x5751] = 0xac93, [0x5752] = 0xac94, [0x5753] = 0xac95,
  [0x5754] = 0xac96, [0x5755] = 0xac97, [0x5756] = 0xac98, [0x5757] = 0xac99,
  [0x5758] = 0xac9a, [0x5759] = 0xac9b, [0x575a] = 0xac9c, [0x575b] = 0xac9d,
  [0x575c] = 0xac9e, [0x575d] = 0xac9f, [0x575e] = 0xaca0, [0x575f] = 0xaca1,
  [0x5760] = 0xaca2, [0x5761] = 0xaca3, [0x5762] = 0xaca4, [0x5763] = 0xaca5,
  [0x5764] = 0xaca6, [0x5765] = 0xaca7, [0x5766] = 0xaca8, [0x5767] = 0xaca9,
  [0x5768] = 0xacaa, [0x5769] = 0xacab, [0x576a] = 0xacac, [0x576b] = 0xacad,
  [0x576c] = 0xacae, [0x576d] = 0xacaf, [0x576e] = 0xacb0, [0x576f] = 0xacb1,
  [0x5770] = 0xacb2, [0x5771] = 0xacb3, [0x5772] = 0xacb4, [0x5773] = 0xacb5,
  [0x5774] = 0xacb6, [0x5775] = 0xacb7, [0x5776] = 0xacb8, [0x5777] = 0xacb9,
  [0x5778] = 0xacba, [0x5779] = 0xacbb, [0x577a] = 0xacbc, [0x577b] = 0xacbd,
  [0x577c] = 0xacbe, [0x577d] = 0xacbf, [0x577e] = 0xacc0, [0x577f] = 0xacc1,
  [0x5780] = 0xacc2, [0x5781] = 0xacc3, [0x5782] = 0xacc4, [0x5783] = 0xacc5,
  [0x5784] = 0xacc6, [0x5785] = 0xacc7, [0x5786] = 0xacc8, [0x5787] = 0xacc9,
  [0x5788] = 0xacca, [0x5789] = 0xaccb, [0x578a] = 0xaccc, [0x578b] = 0xaccd,
  [0x578c] = 0xacce, [0x578d] = 0xaccf, [0x578e] = 0xacd0, [0x578f] = 0xacd1,
  [0x5790] = 0xacd2, [0x5791] = 0xacd3, [0x5792] = 0xacd4, [0x5793] = 0xacd5,
  [0x5794] = 0xacd6, [0x5795] = 0xacd7, [0x5796] = 0xacd8, [0x5797] = 0xacd9,
  [0x5798] = 0xacda, [0x5799] = 0xacdb, [0x579a] = 0xacdc, [0x579b] = 0xacdd,
  [0x579c] = 0xacde, [0x579d] = 0xacdf, [0x579e] = 0xace0, [0x579f] = 0xace1,
  [0x57a0] = 0xace2, [0x57a1] = 0xace3, [0x57a2] = 0xace4, [0x57a3] = 0xace5,
  [0x57a4] = 0xace6, [0x57a5] = 0xace7, [0x57a6] = 0xace8, [0x57a7] = 0xace9,
  [0x57a8] = 0xacea, [0x57a9] = 0xaceb, [0x57aa] = 0xacec, [0x57ab] = 0xaced,
  [0x57ac] = 0xacee, [0x57ad] = 0xacef, [0x57ae] = 0xacf0, [0x57af] = 0xacf1,
  [0x57b0] = 0xacf2, [0x57b1] = 0xacf3, [0x57b2] = 0xacf4, [0x57b3] = 0xacf5,
  [0x57b4] = 0xacf6, [0x57b5] = 0xacf7, [0x57b6] = 0xacf8, [0x57b7] = 0xacf9,
  [0x57b8] = 0xacfa, [0x57b9] = 0xacfb, [0x57ba] = 0xacfc, [0x57bb] = 0xacfd,
  [0x57bc] = 0xacfe, [0x57bd] = 0xacff, [0x57be] = 0xad00, [0x57bf] = 0xad01,
  [0x57c0] = 0xad02, [0x57c1] = 0xad03, [0x57c2] = 0xad04, [0x57c3] = 0xad05,
  [0x57c4] = 0xad06, [0x57c5] = 0xad07, [0x57c6] = 0xad08, [0x57c7] = 0xad09,
  [0x57c8] = 0xad0a, [0x57c9] = 0xad0b, [0x57ca] = 0xad0c, [0x57cb] = 0xad0d,
  [0x57cc] = 0xad0e, [0x57cd] = 0xad0f, [0x57ce] = 0xad10, [0x57cf] = 0xad11,
  [0x57d0] = 0xad12, [0x57d1] = 0xad13, [0x57d2] = 0xad14, [0x57d3] = 0xad15,
  [0x57d4] = 0xad16, [0x57d5] = 0xad17, [0x57d6] = 0xad18, [0x57d7] = 0xad19,
  [0x57d8] = 0xad1a, [0x57d9] = 0xad1b, [0x57da] = 0xad1c, [0x57db] = 0xad1d,
  [0x57dc] = 0xad1e, [0x57dd] = 0xad1f, [0x57de] = 0xad20, [0x57df] = 0xad21,
  [0x57e0] = 0xad22, [0x57e1] = 0xad23, [0x57e2] = 0xad24, [0x57e3] = 0xad25,
  [0x57e4] = 0xad26, [0x57e5] = 0xad27, [0x57e6] = 0xad28, [0x57e7] = 0xad29,
  [0x57e8] = 0xad2a, [0x57e9] = 0xad2b, [0x57ea] = 0xad2c, [0x57eb] = 0xad2d,
  [0x57ec] = 0xad2e, [0x57ed] = 0xad2f, [0x57ee] = 0xad30, [0x57ef] = 0xad31,
  [0x57f0] = 0xad32, [0x57f1] = 0xad33, [0x57f2] = 0xad34, [0x57f3] = 0xad35,
  [0x57f4] = 0xad36, [0x57f5] = 0xad37, [0x57f6] = 0xad38, [0x57f7] = 0xad39,
  [0x57f8] = 0xad3a, [0x57f9] = 0xad3b, [0x57fa] = 0xad3c, [0x57fb] = 0xad3d,
  [0x57fc] = 0xad3e, [0x57fd] = 0xad3f, [0x57fe] = 0xad40, [0x57ff] = 0xad41,
  [0x5800] = 0xad42, [0x5801] = 0xad43, [0x5802] = 0xad44, [0x5803] = 0xad45,
  [0x5804] = 0xad46, [0x5805] = 0xad47, [0x5806] = 0xad48, [0x5807] = 0xad49,
  [0x5808] = 0xad4a, [0x5809] = 0xad4b, [0x580a] = 0xad4c, [0x580b] = 0xad4d,
  [0x580c] = 0xad4e, [0x580d] = 0xad4f, [0x580e] = 0xad50, [0x580f] = 0xad51,
  [0x5810] = 0xad52, [0x5811] = 0xad53, [0x5812] = 0xad54, [0x5813] = 0xad55,
  [0x5814] = 0xad56, [0x5815] = 0xad57, [0x5816] = 0xad58, [0x5817] = 0xad59,
  [0x5818] = 0xad5a, [0x5819] = 0xad5b, [0x581a] = 0xad5c, [0x581b] = 0xad5d,
  [0x581c] = 0xad5e, [0x581d] = 0xad5f, [0x581e] = 0xad60, [0x581f] = 0xad61,
  [0x5820] = 0xad62, [0x5821] = 0xad63, [0x5822] = 0xad64, [0x5823] = 0xad65,
  [0x5824] = 0xad66, [0x5825] = 0xad67, [0x5826] = 0xad68, [0x5827] = 0xad69,
  [0x5828] = 0xad6a, [0x5829] = 0xad6b, [0x582a] = 0xad6c, [0x582b] = 0xad6d,
  [0x582c] = 0xad6e, [0x582d] = 0xad6f, [0x582e] = 0xad70, [0x582f] = 0xad71,
  [0x5830] = 0xad72, [0x5831] = 0xad73, [0x5832] = 0xad74, [0x5833] = 0xad75,
  [0x5834] = 0xad76, [0x5835] = 0xad77, [0x5836] = 0xad78, [0x5837] = 0xad79,
  [0x5838] = 0xad7a, [0x5839] = 0xad7b, [0x583a] = 0xad7c, [0x583b] = 0xad7d,
  [0x583c] = 0xad7e, [0x583d] = 0xad7f, [0x583e] = 0xad80, [0x583f] = 0xad81,
  [0x5840] = 0xad82, [0x5841] = 0xad83, [0x5842] = 0xad84, [0x5843] = 0xad85,
  [0x5844] = 0xad86, [0x5845] = 0xad87, [0x5846] = 0xad88, [0x5847] = 0xad89,
  [0x5848] = 0xad8a, [0x5849] = 0xad8b, [0x584a] = 0xad8c, [0x584b] = 0xad8d,
  [0x584c] = 0xad8e, [0x584d] = 0xad8f, [0x584e] = 0xad90, [0x584f] = 0xad91,
  [0x5850] = 0xad92, [0x5851] = 0xad93, [0x5852] = 0xad94, [0x5853] = 0xad95,
  [0x5854] = 0xad96, [0x5855] = 0xad97, [0x5856] = 0xad98, [0x5857] = 0xad99,
  [0x5858] = 0xad9a, [0x5859] = 0xad9b, [0x585a] = 0xad9c, [0x585b] = 0xad9d,
  [0x585c] = 0xad9e, [0x585d] = 0xad9f, [0x585e] = 0xada0, [0x585f] = 0xada1,
  [0x5860] = 0xada2, [0x5861] = 0xada3, [0x5862] = 0xada4, [0x5863] = 0xada5,
  [0x5864] = 0xada6, [0x5865] = 0xada7, [0x5866] = 0xada8, [0x5867] = 0xada9,
  [0x5868] = 0xadaa, [0x5869] = 0xadab, [0x586a] = 0xadac, [0x586b] = 0xadad,
  [0x586c] = 0xadae, [0x586d] = 0xadaf, [0x586e] = 0xadb0, [0x586f] = 0xadb1,
  [0x5870] = 0xadb2, [0x5871] = 0xadb3, [0x5872] = 0xadb4, [0x5873] = 0xadb5,
  [0x5874] = 0xadb6, [0x5875] = 0xadb7, [0x5876] = 0xadb8, [0x5877] = 0xadb9,
  [0x5878] = 0xadba, [0x5879] = 0xadbb, [0x587a] = 0xadbc, [0x587b] = 0xadbd,
  [0x587c] = 0xadbe, [0x587d] = 0xadbf, [0x587e] = 0xadc0, [0x587f] = 0xadc1,
  [0x5880] = 0xadc2, [0x5881] = 0xadc3, [0x5882] = 0xadc4, [0x5883] = 0xadc5,
  [0x5884] = 0xadc6, [0x5885] = 0xadc7, [0x5886] = 0xadc8, [0x5887] = 0xadc9,
  [0x5888] = 0xadca, [0x5889] = 0xadcb, [0x588a] = 0xadcc, [0x588b] = 0xadcd,
  [0x588c] = 0xadce, [0x588d] = 0xadcf, [0x588e] = 0xadd0, [0x588f] = 0xadd1,
  [0x5890] = 0xadd2, [0x5891] = 0xadd3, [0x5892] = 0xadd4, [0x5893] = 0xadd5,
  [0x5894] = 0xadd6, [0x5895] = 0xadd7, [0x5896] = 0xadd8, [0x5897] = 0xadd9,
  [0x5898] = 0xadda, [0x5899] = 0xaddb, [0x589a] = 0xaddc, [0x589b] = 0xaddd,
  [0x589c] = 0xadde, [0x589d] = 0xaddf, [0x589e] = 0xade0, [0x589f] = 0xade1,
  [0x58a0] = 0xade2, [0x58a1] = 0xade3, [0x58a2] = 0xade4, [0x58a3] = 0xade5,
  [0x58a4] = 0xade6, [0x58a5] = 0xade7, [0x58a6] = 0xade8, [0x58a7] = 0xade9,
  [0x58a8] = 0xadea, [0x58a9] = 0xadeb, [0x58aa] = 0xadec, [0x58ab] = 0xaded,
  [0x58ac] = 0xadee, [0x58ad] = 0xadef, [0x58ae] = 0xadf0, [0x58af] = 0xadf1,
  [0x58b0] = 0xadf2, [0x58b1] = 0xadf3, [0x58b2] = 0xadf4, [0x58b3] = 0xadf5,
  [0x58b4] = 0xadf6, [0x58b5] = 0xadf7, [0x58b6] = 0xadf8, [0x58b7] = 0xadf9,
  [0x58b8] = 0xadfa, [0x58b9] = 0xadfb, [0x58ba] = 0xadfc, [0x58bb] = 0xadfd,
  [0x58bc] = 0xadfe, [0x58bd] = 0xadff, [0x58be] = 0xae00, [0x58bf] = 0xae01,
  [0x58c0] = 0xae02, [0x58c1] = 0xae03, [0x58c2] = 0xae04, [0x58c3] = 0xae05,
  [0x58c4] = 0xae06, [0x58c5] = 0xae07, [0x58c6] = 0xae08, [0x58c7] = 0xae09,
  [0x58c8] = 0xae0a, [0x58c9] = 0xae0b, [0x58ca] = 0xae0c, [0x58cb] = 0xae0d,
  [0x58cc] = 0xae0e, [0x58cd] = 0xae0f, [0x58ce] = 0xae10, [0x58cf] = 0xae11,
  [0x58d0] = 0xae12, [0x58d1] = 0xae13, [0x58d2] = 0xae14, [0x58d3] = 0xae15,
  [0x58d4] = 0xae16, [0x58d5] = 0xae17, [0x58d6] = 0xae18, [0x58d7] = 0xae19,
  [0x58d8] = 0xae1a, [0x58d9] = 0xae1b, [0x58da] = 0xae1c, [0x58db] = 0xae1d,
  [0x58dc] = 0xae1e, [0x58dd] = 0xae1f, [0x58de] = 0xae20, [0x58df] = 0xae21,
  [0x58e0] = 0xae22, [0x58e1] = 0xae23, [0x58e2] = 0xae24, [0x58e3] = 0xae25,
  [0x58e4] = 0xae26, [0x58e5] = 0xae27, [0x58e6] = 0xae28, [0x58e7] = 0xae29,
  [0x58e8] = 0xae2a, [0x58e9] = 0xae2b, [0x58ea] = 0xae2c, [0x58eb] = 0xae2d,
  [0x58ec] = 0xae2e, [0x58ed] = 0xae2f, [0x58ee] = 0xae30, [0x58ef] = 0xae31,
  [0x58f0] = 0xae32, [0x58f1] = 0xae33, [0x58f2] = 0xae34, [0x58f3] = 0xae35,
  [0x58f4] = 0xae36, [0x58f5] = 0xae37, [0x58f6] = 0xae38, [0x58f7] = 0xae39,
  [0x58f8] = 0xae3a, [0x58f9] = 0xae3b, [0x58fa] = 0xae3c, [0x58fb] = 0xae3d,
  [0x58fc] = 0xae3e, [0x58fd] = 0xae3f, [0x58fe] = 0xae40, [0x58ff] = 0xae41,
  [0x5900] = 0xae42, [0x5901] = 0xae43, [0x5902] = 0xae44, [0x5903] = 0xae45,
  [0x5904] = 0xae46, [0x5905] = 0xae47, [0x5906] = 0xae48, [0x5907] = 0xae49,
  [0x5908] = 0xae4a, [0x5909] = 0xae4b, [0x590a] = 0xae4c, [0x590b] = 0xae4d,
  [0x590c] = 0xae4e, [0x590d] = 0xae4f, [0x590e] = 0xae50, [0x590f] = 0xae51,
  [0x5910] = 0xae52, [0x5911] = 0xae53, [0x5912] = 0xae54, [0x5913] = 0xae55,
  [0x5914] = 0xae56, [0x5915] = 0xae57, [0x5916] = 0xae58, [0x5917] = 0xae59,
  [0x5918] = 0xae5a, [0x5919] = 0xae5b, [0x591a] = 0xae5c, [0x591b] = 0xae5d,
  [0x591c] = 0xae5e, [0x591d] = 0xae5f, [0x591e] = 0xae60, [0x591f] = 0xae61,
  [0x5920] = 0xae62, [0x5921] = 0xae63, [0x5922] = 0xae64, [0x5923] = 0xae65,
  [0x5924] = 0xae66, [0x5925] = 0xae67, [0x5926] = 0xae68, [0x5927] = 0xae69,
  [0x5928] = 0xae6a, [0x5929] = 0xae6b, [0x592a] = 0xae6c, [0x592b] = 0xae6d,
  [0x592c] = 0xae6e, [0x592d] = 0xae6f, [0x592e] = 0xae70, [0x592f] = 0xae71,
  [0x5930] = 0xae72, [0x5931] = 0xae73, [0x5932] = 0xae74, [0x5933] = 0xae75,
  [0x5934] = 0xae76, [0x5935] = 0xae77, [0x5936] = 0xae78, [0x5937] = 0xae79,
  [0x5938] = 0xae7a, [0x5939] = 0xae7b, [0x593a] = 0xae7c, [0x593b] = 0xae7d,
  [0x593c] = 0xae7e, [0x593d] = 0xae7f, [0x593e] = 0xae80, [0x593f] = 0xae81,
  [0x5940] = 0xae82, [0x5941] = 0xae83, [0x5942] = 0xae84, [0x5943] = 0xae85,
  [0x5944] = 0xae86, [0x5945] = 0xae87, [0x5946] = 0xae88, [0x5947] = 0xae89,
  [0x5948] = 0xae8a, [0x5949] = 0xae8b, [0x594a] = 0xae8c, [0x594b] = 0xae8d,
  [0x594c] = 0xae8e, [0x594d] = 0xae8f, [0x594e] = 0xae90, [0x594f] = 0xae91,
  [0x5950] = 0xae92, [0x5951] = 0xae93, [0x5952] = 0xae94, [0x5953] = 0xae95,
  [0x5954] = 0xae96, [0x5955] = 0xae97, [0x5956] = 0xae98, [0x5957] = 0xae99,
  [0x5958] = 0xae9a, [0x5959] = 0xae9b, [0x595a] = 0xae9c, [0x595b] = 0xae9d,
  [0x595c] = 0xae9e, [0x595d] = 0xae9f, [0x595e] = 0xaea0, [0x595f] = 0xaea1,
  [0x5960] = 0xaea2, [0x5961] = 0xaea3, [0x5962] = 0xaea4, [0x5963] = 0xaea5,
  [0x5964] = 0xaea6, [0x5965] = 0xaea7, [0x5966] = 0xaea8, [0x5967] = 0xaea9,
  [0x5968] = 0xaeaa, [0x5969] = 0xaeab, [0x596a] = 0xaeac, [0x596b] = 0xaead,
  [0x596c] = 0xaeae, [0x596d] = 0xaeaf, [0x596e] = 0xaeb0, [0x596f] = 0xaeb1,
  [0x5970] = 0xaeb2, [0x5971] = 0xaeb3, [0x5972] = 0xaeb4, [0x5973] = 0xaeb5,
  [0x5974] = 0xaeb6, [0x5975] = 0xaeb7, [0x5976] = 0xaeb8, [0x5977] = 0xaeb9,
  [0x5978] = 0xaeba, [0x5979] = 0xaebb, [0x597a] = 0xaebc, [0x597b] = 0xaebd,
  [0x597c] = 0xaebe, [0x597d] = 0xaebf, [0x597e] = 0xaec0, [0x597f] = 0xaec1,
  [0x5980] = 0xaec2, [0x5981] = 0xaec3, [0x5982] = 0xaec4, [0x5983] = 0xaec5,
  [0x5984] = 0xaec6, [0x5985] = 0xaec7, [0x5986] = 0xaec8, [0x5987] = 0xaec9,
  [0x5988] = 0xaeca, [0x5989] = 0xaecb, [0x598a] = 0xaecc, [0x598b] = 0xaecd,
  [0x598c] = 0xaece, [0x598d] = 0xaecf, [0x598e] = 0xaed0, [0x598f] = 0xaed1,
  [0x5990] = 0xaed2, [0x5991] = 0xaed3, [0x5992] = 0xaed4, [0x5993] = 0xaed5,
  [0x5994] = 0xaed6, [0x5995] = 0xaed7, [0x5996] = 0xaed8, [0x5997] = 0xaed9,
  [0x5998] = 0xaeda, [0x5999] = 0xaedb, [0x599a] = 0xaedc, [0x599b] = 0xaedd,
  [0x599c] = 0xaede, [0x599d] = 0xaedf, [0x599e] = 0xaee0, [0x599f] = 0xaee1,
  [0x59a0] = 0xaee2, [0x59a1] = 0xaee3, [0x59a2] = 0xaee4, [0x59a3] = 0xaee5,
  [0x59a4] = 0xaee6, [0x59a5] = 0xaee7, [0x59a6] = 0xaee8, [0x59a7] = 0xaee9,
  [0x59a8] = 0xaeea, [0x59a9] = 0xaeeb, [0x59aa] = 0xaeec, [0x59ab] = 0xaeed,
  [0x59ac] = 0xaeee, [0x59ad] = 0xaeef, [0x59ae] = 0xaef0, [0x59af] = 0xaef1,
  [0x59b0] = 0xaef2, [0x59b1] = 0xaef3, [0x59b2] = 0xaef4, [0x59b3] = 0xaef5,
  [0x59b4] = 0xaef6, [0x59b5] = 0xaef7, [0x59b6] = 0xaef8, [0x59b7] = 0xaef9,
  [0x59b8] = 0xaefa, [0x59b9] = 0xaefb, [0x59ba] = 0xaefc, [0x59bb] = 0xaefd,
  [0x59bc] = 0xaefe, [0x59bd] = 0xaeff, [0x59be] = 0xaf00, [0x59bf] = 0xaf01,
  [0x59c0] = 0xaf02, [0x59c1] = 0xaf03, [0x59c2] = 0xaf04, [0x59c3] = 0xaf05,
  [0x59c4] = 0xaf06, [0x59c5] = 0xaf07, [0x59c6] = 0xaf08, [0x59c7] = 0xaf09,
  [0x59c8] = 0xaf0a, [0x59c9] = 0xaf0b, [0x59ca] = 0xaf0c, [0x59cb] = 0xaf0d,
  [0x59cc] = 0xaf0e, [0x59cd] = 0xaf0f, [0x59ce] = 0xaf10, [0x59cf] = 0xaf11,
  [0x59d0] = 0xaf12, [0x59d1] = 0xaf13, [0x59d2] = 0xaf14, [0x59d3] = 0xaf15,
  [0x59d4] = 0xaf16, [0x59d5] = 0xaf17, [0x59d6] = 0xaf18, [0x59d7] = 0xaf19,
  [0x59d8] = 0xaf1a, [0x59d9] = 0xaf1b, [0x59da] = 0xaf1c, [0x59db] = 0xaf1d,
  [0x59dc] = 0xaf1e, [0x59dd] = 0xaf1f, [0x59de] = 0xaf20, [0x59df] = 0xaf21,
  [0x59e0] = 0xaf22, [0x59e1] = 0xaf23, [0x59e2] = 0xaf24, [0x59e3] = 0xaf25,
  [0x59e4] = 0xaf26, [0x59e5] = 0xaf27, [0x59e6] = 0xaf28, [0x59e7] = 0xaf29,
  [0x59e8] = 0xaf2a, [0x59e9] = 0xaf2b, [0x59ea] = 0xaf2c, [0x59eb] = 0xaf2d,
  [0x59ec] = 0xaf2e, [0x59ed] = 0xaf2f, [0x59ee] = 0xaf30, [0x59ef] = 0xaf31,
  [0x59f0] = 0xaf32, [0x59f1] = 0xaf33, [0x59f2] = 0xaf34, [0x59f3] = 0xaf35,
  [0x59f4] = 0xaf36, [0x59f5] = 0xaf37, [0x59f6] = 0xaf38, [0x59f7] = 0xaf39,
  [0x59f8] = 0xaf3a, [0x59f9] = 0xaf3b, [0x59fa] = 0xaf3c, [0x59fb] = 0xaf3d,
  [0x59fc] = 0xaf3e, [0x59fd] = 0xaf3f, [0x59fe] = 0xaf40, [0x59ff] = 0xaf41,
  [0x5a00] = 0xaf42, [0x5a01] = 0xaf43, [0x5a02] = 0xaf44, [0x5a03] = 0xaf45,
  [0x5a04] = 0xaf46, [0x5a05] = 0xaf47, [0x5a06] = 0xaf48, [0x5a07] = 0xaf49,
  [0x5a08] = 0xaf4a, [0x5a09] = 0xaf4b, [0x5a0a] = 0xaf4c, [0x5a0b] = 0xaf4d,
  [0x5a0c] = 0xaf4e, [0x5a0d] = 0xaf4f, [0x5a0e] = 0xaf50, [0x5a0f] = 0xaf51,
  [0x5a10] = 0xaf52, [0x5a11] = 0xaf53, [0x5a12] = 0xaf54, [0x5a13] = 0xaf55,
  [0x5a14] = 0xaf56, [0x5a15] = 0xaf57, [0x5a16] = 0xaf58, [0x5a17] = 0xaf59,
  [0x5a18] = 0xaf5a, [0x5a19] = 0xaf5b, [0x5a1a] = 0xaf5c, [0x5a1b] = 0xaf5d,
  [0x5a1c] = 0xaf5e, [0x5a1d] = 0xaf5f, [0x5a1e] = 0xaf60, [0x5a1f] = 0xaf61,
  [0x5a20] = 0xaf62, [0x5a21] = 0xaf63, [0x5a22] = 0xaf64, [0x5a23] = 0xaf65,
  [0x5a24] = 0xaf66, [0x5a25] = 0xaf67, [0x5a26] = 0xaf68, [0x5a27] = 0xaf69,
  [0x5a28] = 0xaf6a, [0x5a29] = 0xaf6b, [0x5a2a] = 0xaf6c, [0x5a2b] = 0xaf6d,
  [0x5a2c] = 0xaf6e, [0x5a2d] = 0xaf6f, [0x5a2e] = 0xaf70, [0x5a2f] = 0xaf71,
  [0x5a30] = 0xaf72, [0x5a31] = 0xaf73, [0x5a32] = 0xaf74, [0x5a33] = 0xaf75,
  [0x5a34] = 0xaf76, [0x5a35] = 0xaf77, [0x5a36] = 0xaf78, [0x5a37] = 0xaf79,
  [0x5a38] = 0xaf7a, [0x5a39] = 0xaf7b, [0x5a3a] = 0xaf7c, [0x5a3b] = 0xaf7d,
  [0x5a3c] = 0xaf7e, [0x5a3d] = 0xaf7f, [0x5a3e] = 0xaf80, [0x5a3f] = 0xaf81,
  [0x5a40] = 0xaf82, [0x5a41] = 0xaf83, [0x5a42] = 0xaf84, [0x5a43] = 0xaf85,
  [0x5a44] = 0xaf86, [0x5a45] = 0xaf87, [0x5a46] = 0xaf88, [0x5a47] = 0xaf89,
  [0x5a48] = 0xaf8a, [0x5a49] = 0xaf8b, [0x5a4a] = 0xaf8c, [0x5a4b] = 0xaf8d,
  [0x5a4c] = 0xaf8e, [0x5a4d] = 0xaf8f, [0x5a4e] = 0xaf90, [0x5a4f] = 0xaf91,
  [0x5a50] = 0xaf92, [0x5a51] = 0xaf93, [0x5a52] = 0xaf94, [0x5a53] = 0xaf95,
  [0x5a54] = 0xaf96, [0x5a55] = 0xaf97, [0x5a56] = 0xaf98, [0x5a57] = 0xaf99,
  [0x5a58] = 0xaf9a, [0x5a59] = 0xaf9b, [0x5a5a] = 0xaf9c, [0x5a5b] = 0xaf9d,
  [0x5a5c] = 0xaf9e, [0x5a5d] = 0xaf9f, [0x5a5e] = 0xafa0, [0x5a5f] = 0xafa1,
  [0x5a60] = 0xafa2, [0x5a61] = 0xafa3, [0x5a62] = 0xafa4, [0x5a63] = 0xafa5,
  [0x5a64] = 0xafa6, [0x5a65] = 0xafa7, [0x5a66] = 0xafa8, [0x5a67] = 0xafa9,
  [0x5a68] = 0xafaa, [0x5a69] = 0xafab, [0x5a6a] = 0xafac, [0x5a6b] = 0xafad,
  [0x5a6c] = 0xafae, [0x5a6d] = 0xafaf, [0x5a6e] = 0xafb0, [0x5a6f] = 0xafb1,
  [0x5a70] = 0xafb2, [0x5a71] = 0xafb3, [0x5a72] = 0xafb4, [0x5a73] = 0xafb5,
  [0x5a74] = 0xafb6, [0x5a75] = 0xafb7, [0x5a76] = 0xafb8, [0x5a77] = 0xafb9,
  [0x5a78] = 0xafba, [0x5a79] = 0xafbb, [0x5a7a] = 0xafbc, [0x5a7b] = 0xafbd,
  [0x5a7c] = 0xafbe, [0x5a7d] = 0xafbf, [0x5a7e] = 0xafc0, [0x5a7f] = 0xafc1,
  [0x5a80] = 0xafc2, [0x5a81] = 0xafc3, [0x5a82] = 0xafc4, [0x5a83] = 0xafc5,
  [0x5a84] = 0xafc6, [0x5a85] = 0xafc7, [0x5a86] = 0xafc8, [0x5a87] = 0xafc9,
  [0x5a88] = 0xafca, [0x5a89] = 0xafcb, [0x5a8a] = 0xafcc, [0x5a8b] = 0xafcd,
  [0x5a8c] = 0xafce, [0x5a8d] = 0xafcf, [0x5a8e] = 0xafd0, [0x5a8f] = 0xafd1,
  [0x5a90] = 0xafd2, [0x5a91] = 0xafd3, [0x5a92] = 0xafd4, [0x5a93] = 0xafd5,
  [0x5a94] = 0xafd6, [0x5a95] = 0xafd7, [0x5a96] = 0xafd8, [0x5a97] = 0xafd9,
  [0x5a98] = 0xafda, [0x5a99] = 0xafdb, [0x5a9a] = 0xafdc, [0x5a9b] = 0xafdd,
  [0x5a9c] = 0xafde, [0x5a9d] = 0xafdf, [0x5a9e] = 0xafe0, [0x5a9f] = 0xafe1,
  [0x5aa0] = 0xafe2, [0x5aa1] = 0xafe3, [0x5aa2] = 0xafe4, [0x5aa3] = 0xafe5,
  [0x5aa4] = 0xafe6, [0x5aa5] = 0xafe7, [0x5aa6] = 0xafe8, [0x5aa7] = 0xafe9,
  [0x5aa8] = 0xafea, [0x5aa9] = 0xafeb, [0x5aaa] = 0xafec, [0x5aab] = 0xafed,
  [0x5aac] = 0xafee, [0x5aad] = 0xafef, [0x5aae] = 0xaff0, [0x5aaf] = 0xaff1,
  [0x5ab0] = 0xaff2, [0x5ab1] = 0xaff3, [0x5ab2] = 0xaff4, [0x5ab3] = 0xaff5,
  [0x5ab4] = 0xaff6, [0x5ab5] = 0xaff7, [0x5ab6] = 0xaff8, [0x5ab7] = 0xaff9,
  [0x5ab8] = 0xaffa, [0x5ab9] = 0xaffb, [0x5aba] = 0xaffc, [0x5abb] = 0xaffd,
  [0x5abc] = 0xaffe, [0x5abd] = 0xafff, [0x5abe] = 0xb000, [0x5abf] = 0xb001,
  [0x5ac0] = 0xb002, [0x5ac1] = 0xb003, [0x5ac2] = 0xb004, [0x5ac3] = 0xb005,
  [0x5ac4] = 0xb006, [0x5ac5] = 0xb007, [0x5ac6] = 0xb008, [0x5ac7] = 0xb009,
  [0x5ac8] = 0xb00a, [0x5ac9] = 0xb00b, [0x5aca] = 0xb00c, [0x5acb] = 0xb00d,
  [0x5acc] = 0xb00e, [0x5acd] = 0xb00f, [0x5ace] = 0xb010, [0x5acf] = 0xb011,
  [0x5ad0] = 0xb012, [0x5ad1] = 0xb013, [0x5ad2] = 0xb014, [0x5ad3] = 0xb015,
  [0x5ad4] = 0xb016, [0x5ad5] = 0xb017, [0x5ad6] = 0xb018, [0x5ad7] = 0xb019,
  [0x5ad8] = 0xb01a, [0x5ad9] = 0xb01b, [0x5ada] = 0xb01c, [0x5adb] = 0xb01d,
  [0x5adc] = 0xb01e, [0x5add] = 0xb01f, [0x5ade] = 0xb020, [0x5adf] = 0xb021,
  [0x5ae0] = 0xb022, [0x5ae1] = 0xb023, [0x5ae2] = 0xb024, [0x5ae3] = 0xb025,
  [0x5ae4] = 0xb026, [0x5ae5] = 0xb027, [0x5ae6] = 0xb028, [0x5ae7] = 0xb029,
  [0x5ae8] = 0xb02a, [0x5ae9] = 0xb02b, [0x5aea] = 0xb02c, [0x5aeb] = 0xb02d,
  [0x5aec] = 0xb02e, [0x5aed] = 0xb02f, [0x5aee] = 0xb030, [0x5aef] = 0xb031,
  [0x5af0] = 0xb032, [0x5af1] = 0xb033, [0x5af2] = 0xb034, [0x5af3] = 0xb035,
  [0x5af4] = 0xb036, [0x5af5] = 0xb037, [0x5af6] = 0xb038, [0x5af7] = 0xb039,
  [0x5af8] = 0xb03a, [0x5af9] = 0xb03b, [0x5afa] = 0xb03c, [0x5afb] = 0xb03d,
  [0x5afc] = 0xb03e, [0x5afd] = 0xb03f, [0x5afe] = 0xb040, [0x5aff] = 0xb041,
  [0x5b00] = 0xb042, [0x5b01] = 0xb043, [0x5b02] = 0xb044, [0x5b03] = 0xb045,
  [0x5b04] = 0xb046, [0x5b05] = 0xb047, [0x5b06] = 0xb048, [0x5b07] = 0xb049,
  [0x5b08] = 0xb04a, [0x5b09] = 0xb04b, [0x5b0a] = 0xb04c, [0x5b0b] = 0xb04d,
  [0x5b0c] = 0xb04e, [0x5b0d] = 0xb04f, [0x5b0e] = 0xb050, [0x5b0f] = 0xb051,
  [0x5b10] = 0xb052, [0x5b11] = 0xb053, [0x5b12] = 0xb054, [0x5b13] = 0xb055,
  [0x5b14] = 0xb056, [0x5b15] = 0xb057, [0x5b16] = 0xb058, [0x5b17] = 0xb059,
  [0x5b18] = 0xb05a, [0x5b19] = 0xb05b, [0x5b1a] = 0xb05c, [0x5b1b] = 0xb05d,
  [0x5b1c] = 0xb05e, [0x5b1d] = 0xb05f, [0x5b1e] = 0xb060, [0x5b1f] = 0xb061,
  [0x5b20] = 0xb062, [0x5b21] = 0xb063, [0x5b22] = 0xb064, [0x5b23] = 0xb065,
  [0x5b24] = 0xb066, [0x5b25] = 0xb067, [0x5b26] = 0xb068, [0x5b27] = 0xb069,
  [0x5b28] = 0xb06a, [0x5b29] = 0xb06b, [0x5b2a] = 0xb06c, [0x5b2b] = 0xb06d,
  [0x5b2c] = 0xb06e, [0x5b2d] = 0xb06f, [0x5b2e] = 0xb070, [0x5b2f] = 0xb071,
  [0x5b30] = 0xb072, [0x5b31] = 0xb073, [0x5b32] = 0xb074, [0x5b33] = 0xb075,
  [0x5b34] = 0xb076, [0x5b35] = 0xb077, [0x5b36] = 0xb078, [0x5b37] = 0xb079,
  [0x5b38] = 0xb07a, [0x5b39] = 0xb07b, [0x5b3a] = 0xb07c, [0x5b3b] = 0xb07d,
  [0x5b3c] = 0xb07e, [0x5b3d] = 0xb07f, [0x5b3e] = 0xb080, [0x5b3f] = 0xb081,
  [0x5b40] = 0xb082, [0x5b41] = 0xb083, [0x5b42] = 0xb084, [0x5b43] = 0xb085,
  [0x5b44] = 0xb086, [0x5b45] = 0xb087, [0x5b46] = 0xb088, [0x5b47] = 0xb089,
  [0x5b48] = 0xb08a, [0x5b49] = 0xb08b, [0x5b4a] = 0xb08c, [0x5b4b] = 0xb08d,
  [0x5b4c] = 0xb08e, [0x5b4d] = 0xb08f, [0x5b4e] = 0xb090, [0x5b4f] = 0xb091,
  [0x5b50] = 0xb092, [0x5b51] = 0xb093, [0x5b52] = 0xb094, [0x5b53] = 0xb095,
  [0x5b54] = 0xb096, [0x5b55] = 0xb097, [0x5b56] = 0xb098, [0x5b57] = 0xb099,
  [0x5b58] = 0xb09a, [0x5b59] = 0xb09b, [0x5b5a] = 0xb09c, [0x5b5b] = 0xb09d,
  [0x5b5c] = 0xb09e, [0x5b5d] = 0xb09f, [0x5b5e] = 0xb0a0, [0x5b5f] = 0xb0a1,
  [0x5b60] = 0xb0a2, [0x5b61] = 0xb0a3, [0x5b62] = 0xb0a4, [0x5b63] = 0xb0a5,
  [0x5b64] = 0xb0a6, [0x5b65] = 0xb0a7, [0x5b66] = 0xb0a8, [0x5b67] = 0xb0a9,
  [0x5b68] = 0xb0aa, [0x5b69] = 0xb0ab, [0x5b6a] = 0xb0ac, [0x5b6b] = 0xb0ad,
  [0x5b6c] = 0xb0ae, [0x5b6d] = 0xb0af, [0x5b6e] = 0xb0b0, [0x5b6f] = 0xb0b1,
  [0x5b70] = 0xb0b2, [0x5b71] = 0xb0b3, [0x5b72] = 0xb0b4, [0x5b73] = 0xb0b5,
  [0x5b74] = 0xb0b6, [0x5b75] = 0xb0b7, [0x5b76] = 0xb0b8, [0x5b77] = 0xb0b9,
  [0x5b78] = 0xb0ba, [0x5b79] = 0xb0bb, [0x5b7a] = 0xb0bc, [0x5b7b] = 0xb0bd,
  [0x5b7c] = 0xb0be, [0x5b7d] = 0xb0bf, [0x5b7e] = 0xb0c0, [0x5b7f] = 0xb0c1,
  [0x5b80] = 0xb0c2, [0x5b81] = 0xb0c3, [0x5b82] = 0xb0c4, [0x5b83] = 0xb0c5,
  [0x5b84] = 0xb0c6, [0x5b85] = 0xb0c7, [0x5b86] = 0xb0c8, [0x5b87] = 0xb0c9,
  [0x5b88] = 0xb0ca, [0x5b89] = 0xb0cb, [0x5b8a] = 0xb0cc, [0x5b8b] = 0xb0cd,
  [0x5b8c] = 0xb0ce, [0x5b8d] = 0xb0cf, [0x5b8e] = 0xb0d0, [0x5b8f] = 0xb0d1,
  [0x5b90] = 0xb0d2, [0x5b91] = 0xb0d3, [0x5b92] = 0xb0d4, [0x5b93] = 0xb0d5,
  [0x5b94] = 0xb0d6, [0x5b95] = 0xb0d7, [0x5b96] = 0xb0d8, [0x5b97] = 0xb0d9,
  [0x5b98] = 0xb0da, [0x5b99] = 0xb0db, [0x5b9a] = 0xb0dc, [0x5b9b] = 0xb0dd,
  [0x5b9c] = 0xb0de, [0x5b9d] = 0xb0df, [0x5b9e] = 0xb0e0, [0x5b9f] = 0xb0e1,
  [0x5ba0] = 0xb0e2, [0x5ba1] = 0xb0e3, [0x5ba2] = 0xb0e4, [0x5ba3] = 0xb0e5,
  [0x5ba4] = 0xb0e6, [0x5ba5] = 0xb0e7, [0x5ba6] = 0xb0e8, [0x5ba7] = 0xb0e9,
  [0x5ba8] = 0xb0ea, [0x5ba9] = 0xb0eb, [0x5baa] = 0xb0ec, [0x5bab] = 0xb0ed,
  [0x5bac] = 0xb0ee, [0x5bad] = 0xb0ef, [0x5bae] = 0xb0f0, [0x5baf] = 0xb0f1,
  [0x5bb0] = 0xb0f2, [0x5bb1] = 0xb0f3, [0x5bb2] = 0xb0f4, [0x5bb3] = 0xb0f5,
  [0x5bb4] = 0xb0f6, [0x5bb5] = 0xb0f7, [0x5bb6] = 0xb0f8, [0x5bb7] = 0xb0f9,
  [0x5bb8] = 0xb0fa, [0x5bb9] = 0xb0fb, [0x5bba] = 0xb0fc, [0x5bbb] = 0xb0fd,
  [0x5bbc] = 0xb0fe, [0x5bbd] = 0xb0ff, [0x5bbe] = 0xb100, [0x5bbf] = 0xb101,
  [0x5bc0] = 0xb102, [0x5bc1] = 0xb103, [0x5bc2] = 0xb104, [0x5bc3] = 0xb105,
  [0x5bc4] = 0xb106, [0x5bc5] = 0xb107, [0x5bc6] = 0xb108, [0x5bc7] = 0xb109,
  [0x5bc8] = 0xb10a, [0x5bc9] = 0xb10b, [0x5bca] = 0xb10c, [0x5bcb] = 0xb10d,
  [0x5bcc] = 0xb10e, [0x5bcd] = 0xb10f, [0x5bce] = 0xb110, [0x5bcf] = 0xb111,
  [0x5bd0] = 0xb112, [0x5bd1] = 0xb113, [0x5bd2] = 0xb114, [0x5bd3] = 0xb115,
  [0x5bd4] = 0xb116, [0x5bd5] = 0xb117, [0x5bd6] = 0xb118, [0x5bd7] = 0xb119,
  [0x5bd8] = 0xb11a, [0x5bd9] = 0xb11b, [0x5bda] = 0xb11c, [0x5bdb] = 0xb11d,
  [0x5bdc] = 0xb11e, [0x5bdd] = 0xb11f, [0x5bde] = 0xb120, [0x5bdf] = 0xb121,
  [0x5be0] = 0xb122, [0x5be1] = 0xb123, [0x5be2] = 0xb124, [0x5be3] = 0xb125,
  [0x5be4] = 0xb126, [0x5be5] = 0xb127, [0x5be6] = 0xb128, [0x5be7] = 0xb129,
  [0x5be8] = 0xb12a, [0x5be9] = 0xb12b, [0x5bea] = 0xb12c, [0x5beb] = 0xb12d,
  [0x5bec] = 0xb12e, [0x5bed] = 0xb12f, [0x5bee] = 0xb130, [0x5bef] = 0xb131,
  [0x5bf0] = 0xb132, [0x5bf1] = 0xb133, [0x5bf2] = 0xb134, [0x5bf3] = 0xb135,
  [0x5bf4] = 0xb136, [0x5bf5] = 0xb137, [0x5bf6] = 0xb138, [0x5bf7] = 0xb139,
  [0x5bf8] = 0xb13a, [0x5bf9] = 0xb13b, [0x5bfa] = 0xb13c, [0x5bfb] = 0xb13d,
  [0x5bfc] = 0xb13e, [0x5bfd] = 0xb13f, [0x5bfe] = 0xb140, [0x5bff] = 0xb141,
  [0x5c00] = 0xb142, [0x5c01] = 0xb143, [0x5c02] = 0xb144, [0x5c03] = 0xb145,
  [0x5c04] = 0xb146, [0x5c05] = 0xb147, [0x5c06] = 0xb148, [0x5c07] = 0xb149,
  [0x5c08] = 0xb14a, [0x5c09] = 0xb14b, [0x5c0a] = 0xb14c, [0x5c0b] = 0xb14d,
  [0x5c0c] = 0xb14e, [0x5c0d] = 0xb14f, [0x5c0e] = 0xb150, [0x5c0f] = 0xb151,
  [0x5c10] = 0xb152, [0x5c11] = 0xb153, [0x5c12] = 0xb154, [0x5c13] = 0xb155,
  [0x5c14] = 0xb156, [0x5c15] = 0xb157, [0x5c16] = 0xb158, [0x5c17] = 0xb159,
  [0x5c18] = 0xb15a, [0x5c19] = 0xb15b, [0x5c1a] = 0xb15c, [0x5c1b] = 0xb15d,
  [0x5c1c] = 0xb15e, [0x5c1d] = 0xb15f, [0x5c1e] = 0xb160, [0x5c1f] = 0xb161,
  [0x5c20] = 0xb162, [0x5c21] = 0xb163, [0x5c22] = 0xb164, [0x5c23] = 0xb165,
  [0x5c24] = 0xb166, [0x5c25] = 0xb167, [0x5c26] = 0xb168, [0x5c27] = 0xb169,
  [0x5c28] = 0xb16a, [0x5c29] = 0xb16b, [0x5c2a] = 0xb16c, [0x5c2b] = 0xb16d,
  [0x5c2c] = 0xb16e, [0x5c2d] = 0xb16f, [0x5c2e] = 0xb170, [0x5c2f] = 0xb171,
  [0x5c30] = 0xb172, [0x5c31] = 0xb173, [0x5c32] = 0xb174, [0x5c33] = 0xb175,
  [0x5c34] = 0xb176, [0x5c35] = 0xb177, [0x5c36] = 0xb178, [0x5c37] = 0xb179,
  [0x5c38] = 0xb17a, [0x5c39] = 0xb17b, [0x5c3a] = 0xb17c, [0x5c3b] = 0xb17d,
  [0x5c3c] = 0xb17e, [0x5c3d] = 0xb17f, [0x5c3e] = 0xb180, [0x5c3f] = 0xb181,
  [0x5c40] = 0xb182, [0x5c41] = 0xb183, [0x5c42] = 0xb184, [0x5c43] = 0xb185,
  [0x5c44] = 0xb186, [0x5c45] = 0xb187, [0x5c46] = 0xb188, [0x5c47] = 0xb189,
  [0x5c48] = 0xb18a, [0x5c49] = 0xb18b, [0x5c4a] = 0xb18c, [0x5c4b] = 0xb18d,
  [0x5c4c] = 0xb18e, [0x5c4d] = 0xb18f, [0x5c4e] = 0xb190, [0x5c4f] = 0xb191,
  [0x5c50] = 0xb192, [0x5c51] = 0xb193, [0x5c52] = 0xb194, [0x5c53] = 0xb195,
  [0x5c54] = 0xb196, [0x5c55] = 0xb197, [0x5c56] = 0xb198, [0x5c57] = 0xb199,
  [0x5c58] = 0xb19a, [0x5c59] = 0xb19b, [0x5c5a] = 0xb19c, [0x5c5b] = 0xb19d,
  [0x5c5c] = 0xb19e, [0x5c5d] = 0xb19f, [0x5c5e] = 0xb1a0, [0x5c5f] = 0xb1a1,
  [0x5c60] = 0xb1a2, [0x5c61] = 0xb1a3, [0x5c62] = 0xb1a4, [0x5c63] = 0xb1a5,
  [0x5c64] = 0xb1a6, [0x5c65] = 0xb1a7, [0x5c66] = 0xb1a8, [0x5c67] = 0xb1a9,
  [0x5c68] = 0xb1aa, [0x5c69] = 0xb1ab, [0x5c6a] = 0xb1ac, [0x5c6b] = 0xb1ad,
  [0x5c6c] = 0xb1ae, [0x5c6d] = 0xb1af, [0x5c6e] = 0xb1b0, [0x5c6f] = 0xb1b1,
  [0x5c70] = 0xb1b2, [0x5c71] = 0xb1b3, [0x5c72] = 0xb1b4, [0x5c73] = 0xb1b5,
  [0x5c74] = 0xb1b6, [0x5c75] = 0xb1b7, [0x5c76] = 0xb1b8, [0x5c77] = 0xb1b9,
  [0x5c78] = 0xb1ba, [0x5c79] = 0xb1bb, [0x5c7a] = 0xb1bc, [0x5c7b] = 0xb1bd,
  [0x5c7c] = 0xb1be, [0x5c7d] = 0xb1bf, [0x5c7e] = 0xb1c0, [0x5c7f] = 0xb1c1,
  [0x5c80] = 0xb1c2, [0x5c81] = 0xb1c3, [0x5c82] = 0xb1c4, [0x5c83] = 0xb1c5,
  [0x5c84] = 0xb1c6, [0x5c85] = 0xb1c7, [0x5c86] = 0xb1c8, [0x5c87] = 0xb1c9,
  [0x5c88] = 0xb1ca, [0x5c89] = 0xb1cb, [0x5c8a] = 0xb1cc, [0x5c8b] = 0xb1cd,
  [0x5c8c] = 0xb1ce, [0x5c8d] = 0xb1cf, [0x5c8e] = 0xb1d0, [0x5c8f] = 0xb1d1,
  [0x5c90] = 0xb1d2, [0x5c91] = 0xb1d3, [0x5c92] = 0xb1d4, [0x5c93] = 0xb1d5,
  [0x5c94] = 0xb1d6, [0x5c95] = 0xb1d7, [0x5c96] = 0xb1d8, [0x5c97] = 0xb1d9,
  [0x5c98] = 0xb1da, [0x5c99] = 0xb1db, [0x5c9a] = 0xb1dc, [0x5c9b] = 0xb1dd,
  [0x5c9c] = 0xb1de, [0x5c9d] = 0xb1df, [0x5c9e] = 0xb1e0, [0x5c9f] = 0xb1e1,
  [0x5ca0] = 0xb1e2, [0x5ca1] = 0xb1e3, [0x5ca2] = 0xb1e4, [0x5ca3] = 0xb1e5,
  [0x5ca4] = 0xb1e6, [0x5ca5] = 0xb1e7, [0x5ca6] = 0xb1e8, [0x5ca7] = 0xb1e9,
  [0x5ca8] = 0xb1ea, [0x5ca9] = 0xb1eb, [0x5caa] = 0xb1ec, [0x5cab] = 0xb1ed,
  [0x5cac] = 0xb1ee, [0x5cad] = 0xb1ef, [0x5cae] = 0xb1f0, [0x5caf] = 0xb1f1,
  [0x5cb0] = 0xb1f2, [0x5cb1] = 0xb1f3, [0x5cb2] = 0xb1f4, [0x5cb3] = 0xb1f5,
  [0x5cb4] = 0xb1f6, [0x5cb5] = 0xb1f7, [0x5cb6] = 0xb1f8, [0x5cb7] = 0xb1f9,
  [0x5cb8] = 0xb1fa, [0x5cb9] = 0xb1fb, [0x5cba] = 0xb1fc, [0x5cbb] = 0xb1fd,
  [0x5cbc] = 0xb1fe, [0x5cbd] = 0xb1ff, [0x5cbe] = 0xb200, [0x5cbf] = 0xb201,
  [0x5cc0] = 0xb202, [0x5cc1] = 0xb203, [0x5cc2] = 0xb204, [0x5cc3] = 0xb205,
  [0x5cc4] = 0xb206, [0x5cc5] = 0xb207, [0x5cc6] = 0xb208, [0x5cc7] = 0xb209,
  [0x5cc8] = 0xb20a, [0x5cc9] = 0xb20b, [0x5cca] = 0xb20c, [0x5ccb] = 0xb20d,
  [0x5ccc] = 0xb20e, [0x5ccd] = 0xb20f, [0x5cce] = 0xb210, [0x5ccf] = 0xb211,
  [0x5cd0] = 0xb212, [0x5cd1] = 0xb213, [0x5cd2] = 0xb214, [0x5cd3] = 0xb215,
  [0x5cd4] = 0xb216, [0x5cd5] = 0xb217, [0x5cd6] = 0xb218, [0x5cd7] = 0xb219,
  [0x5cd8] = 0xb21a, [0x5cd9] = 0xb21b, [0x5cda] = 0xb21c, [0x5cdb] = 0xb21d,
  [0x5cdc] = 0xb21e, [0x5cdd] = 0xb21f, [0x5cde] = 0xb220, [0x5cdf] = 0xb221,
  [0x5ce0] = 0xb222, [0x5ce1] = 0xb223, [0x5ce2] = 0xb224, [0x5ce3] = 0xb225,
  [0x5ce4] = 0xb226, [0x5ce5] = 0xb227, [0x5ce6] = 0xb228, [0x5ce7] = 0xb229,
  [0x5ce8] = 0xb22a, [0x5ce9] = 0xb22b, [0x5cea] = 0xb22c, [0x5ceb] = 0xb22d,
  [0x5cec] = 0xb22e, [0x5ced] = 0xb22f, [0x5cee] = 0xb230, [0x5cef] = 0xb231,
  [0x5cf0] = 0xb232, [0x5cf1] = 0xb233, [0x5cf2] = 0xb234, [0x5cf3] = 0xb235,
  [0x5cf4] = 0xb236, [0x5cf5] = 0xb237, [0x5cf6] = 0xb238, [0x5cf7] = 0xb239,
  [0x5cf8] = 0xb23a, [0x5cf9] = 0xb23b, [0x5cfa] = 0xb23c, [0x5cfb] = 0xb23d,
  [0x5cfc] = 0xb23e, [0x5cfd] = 0xb23f, [0x5cfe] = 0xb240, [0x5cff] = 0xb241,
  [0x5d00] = 0xb242, [0x5d01] = 0xb243, [0x5d02] = 0xb244, [0x5d03] = 0xb245,
  [0x5d04] = 0xb246, [0x5d05] = 0xb247, [0x5d06] = 0xb248, [0x5d07] = 0xb249,
  [0x5d08] = 0xb24a, [0x5d09] = 0xb24b, [0x5d0a] = 0xb24c, [0x5d0b] = 0xb24d,
  [0x5d0c] = 0xb24e, [0x5d0d] = 0xb24f, [0x5d0e] = 0xb250, [0x5d0f] = 0xb251,
  [0x5d10] = 0xb252, [0x5d11] = 0xb253, [0x5d12] = 0xb254, [0x5d13] = 0xb255,
  [0x5d14] = 0xb256, [0x5d15] = 0xb257, [0x5d16] = 0xb258, [0x5d17] = 0xb259,
  [0x5d18] = 0xb25a, [0x5d19] = 0xb25b, [0x5d1a] = 0xb25c, [0x5d1b] = 0xb25d,
  [0x5d1c] = 0xb25e, [0x5d1d] = 0xb25f, [0x5d1e] = 0xb260, [0x5d1f] = 0xb261,
  [0x5d20] = 0xb262, [0x5d21] = 0xb263, [0x5d22] = 0xb264, [0x5d23] = 0xb265,
  [0x5d24] = 0xb266, [0x5d25] = 0xb267, [0x5d26] = 0xb268, [0x5d27] = 0xb269,
  [0x5d28] = 0xb26a, [0x5d29] = 0xb26b, [0x5d2a] = 0xb26c, [0x5d2b] = 0xb26d,
  [0x5d2c] = 0xb26e, [0x5d2d] = 0xb26f, [0x5d2e] = 0xb270, [0x5d2f] = 0xb271,
  [0x5d30] = 0xb272, [0x5d31] = 0xb273, [0x5d32] = 0xb274, [0x5d33] = 0xb275,
  [0x5d34] = 0xb276, [0x5d35] = 0xb277, [0x5d36] = 0xb278, [0x5d37] = 0xb279,
  [0x5d38] = 0xb27a, [0x5d39] = 0xb27b, [0x5d3a] = 0xb27c, [0x5d3b] = 0xb27d,
  [0x5d3c] = 0xb27e, [0x5d3d] = 0xb27f, [0x5d3e] = 0xb280, [0x5d3f] = 0xb281,
  [0x5d40] = 0xb282, [0x5d41] = 0xb283, [0x5d42] = 0xb284, [0x5d43] = 0xb285,
  [0x5d44] = 0xb286, [0x5d45] = 0xb287, [0x5d46] = 0xb288, [0x5d47] = 0xb289,
  [0x5d48] = 0xb28a, [0x5d49] = 0xb28b, [0x5d4a] = 0xb28c, [0x5d4b] = 0xb28d,
  [0x5d4c] = 0xb28e, [0x5d4d] = 0xb28f, [0x5d4e] = 0xb290, [0x5d4f] = 0xb291,
  [0x5d50] = 0xb292, [0x5d51] = 0xb293, [0x5d52] = 0xb294, [0x5d53] = 0xb295,
  [0x5d54] = 0xb296, [0x5d55] = 0xb297, [0x5d56] = 0xb298, [0x5d57] = 0xb299,
  [0x5d58] = 0xb29a, [0x5d59] = 0xb29b, [0x5d5a] = 0xb29c, [0x5d5b] = 0xb29d,
  [0x5d5c] = 0xb29e, [0x5d5d] = 0xb29f, [0x5d5e] = 0xb2a0, [0x5d5f] = 0xb2a1,
  [0x5d60] = 0xb2a2, [0x5d61] = 0xb2a3, [0x5d62] = 0xb2a4, [0x5d63] = 0xb2a5,
  [0x5d64] = 0xb2a6, [0x5d65] = 0xb2a7, [0x5d66] = 0xb2a8, [0x5d67] = 0xb2a9,
  [0x5d68] = 0xb2aa, [0x5d69] = 0xb2ab, [0x5d6a] = 0xb2ac, [0x5d6b] = 0xb2ad,
  [0x5d6c] = 0xb2ae, [0x5d6d] = 0xb2af, [0x5d6e] = 0xb2b0, [0x5d6f] = 0xb2b1,
  [0x5d70] = 0xb2b2, [0x5d71] = 0xb2b3, [0x5d72] = 0xb2b4, [0x5d73] = 0xb2b5,
  [0x5d74] = 0xb2b6, [0x5d75] = 0xb2b7, [0x5d76] = 0xb2b8, [0x5d77] = 0xb2b9,
  [0x5d78] = 0xb2ba, [0x5d79] = 0xb2bb, [0x5d7a] = 0xb2bc, [0x5d7b] = 0xb2bd,
  [0x5d7c] = 0xb2be, [0x5d7d] = 0xb2bf, [0x5d7e] = 0xb2c0, [0x5d7f] = 0xb2c1,
  [0x5d80] = 0xb2c2, [0x5d81] = 0xb2c3, [0x5d82] = 0xb2c4, [0x5d83] = 0xb2c5,
  [0x5d84] = 0xb2c6, [0x5d85] = 0xb2c7, [0x5d86] = 0xb2c8, [0x5d87] = 0xb2c9,
  [0x5d88] = 0xb2ca, [0x5d89] = 0xb2cb, [0x5d8a] = 0xb2cc, [0x5d8b] = 0xb2cd,
  [0x5d8c] = 0xb2ce, [0x5d8d] = 0xb2cf, [0x5d8e] = 0xb2d0, [0x5d8f] = 0xb2d1,
  [0x5d90] = 0xb2d2, [0x5d91] = 0xb2d3, [0x5d92] = 0xb2d4, [0x5d93] = 0xb2d5,
  [0x5d94] = 0xb2d6, [0x5d95] = 0xb2d7, [0x5d96] = 0xb2d8, [0x5d97] = 0xb2d9,
  [0x5d98] = 0xb2da, [0x5d99] = 0xb2db, [0x5d9a] = 0xb2dc, [0x5d9b] = 0xb2dd,
  [0x5d9c] = 0xb2de, [0x5d9d] = 0xb2df, [0x5d9e] = 0xb2e0, [0x5d9f] = 0xb2e1,
  [0x5da0] = 0xb2e2, [0x5da1] = 0xb2e3, [0x5da2] = 0xb2e4, [0x5da3] = 0xb2e5,
  [0x5da4] = 0xb2e6, [0x5da5] = 0xb2e7, [0x5da6] = 0xb2e8, [0x5da7] = 0xb2e9,
  [0x5da8] = 0xb2ea, [0x5da9] = 0xb2eb, [0x5daa] = 0xb2ec, [0x5dab] = 0xb2ed,
  [0x5dac] = 0xb2ee, [0x5dad] = 0xb2ef, [0x5dae] = 0xb2f0, [0x5daf] = 0xb2f1,
  [0x5db0] = 0xb2f2, [0x5db1] = 0xb2f3, [0x5db2] = 0xb2f4, [0x5db3] = 0xb2f5,
  [0x5db4] = 0xb2f6, [0x5db5] = 0xb2f7, [0x5db6] = 0xb2f8, [0x5db7] = 0xb2f9,
  [0x5db8] = 0xb2fa, [0x5db9] = 0xb2fb, [0x5dba] = 0xb2fc, [0x5dbb] = 0xb2fd,
  [0x5dbc] = 0xb2fe, [0x5dbd] = 0xb2ff, [0x5dbe] = 0xb300, [0x5dbf] = 0xb301,
  [0x5dc0] = 0xb302, [0x5dc1] = 0xb303, [0x5dc2] = 0xb304, [0x5dc3] = 0xb305,
  [0x5dc4] = 0xb306, [0x5dc5] = 0xb307, [0x5dc6] = 0xb308, [0x5dc7] = 0xb309,
  [0x5dc8] = 0xb30a, [0x5dc9] = 0xb30b, [0x5dca] = 0xb30c, [0x5dcb] = 0xb30d,
  [0x5dcc] = 0xb30e, [0x5dcd] = 0xb30f, [0x5dce] = 0xb310, [0x5dcf] = 0xb311,
  [0x5dd0] = 0xb312, [0x5dd1] = 0xb313, [0x5dd2] = 0xb314, [0x5dd3] = 0xb315,
  [0x5dd4] = 0xb316, [0x5dd5] = 0xb317, [0x5dd6] = 0xb318, [0x5dd7] = 0xb319,
  [0x5dd8] = 0xb31a, [0x5dd9] = 0xb31b, [0x5dda] = 0xb31c, [0x5ddb] = 0xb31d,
  [0x5ddc] = 0xb31e, [0x5ddd] = 0xb31f, [0x5dde] = 0xb320, [0x5ddf] = 0xb321,
  [0x5de0] = 0xb322, [0x5de1] = 0xb323, [0x5de2] = 0xb324, [0x5de3] = 0xb325,
  [0x5de4] = 0xb326, [0x5de5] = 0xb327, [0x5de6] = 0xb328, [0x5de7] = 0xb329,
  [0x5de8] = 0xb32a, [0x5de9] = 0xb32b, [0x5dea] = 0xb32c, [0x5deb] = 0xb32d,
  [0x5dec] = 0xb32e, [0x5ded] = 0xb32f, [0x5dee] = 0xb330, [0x5def] = 0xb331,
  [0x5df0] = 0xb332, [0x5df1] = 0xb333, [0x5df2] = 0xb334, [0x5df3] = 0xb335,
  [0x5df4] = 0xb336, [0x5df5] = 0xb337, [0x5df6] = 0xb338, [0x5df7] = 0xb339,
  [0x5df8] = 0xb33a, [0x5df9] = 0xb33b, [0x5dfa] = 0xb33c, [0x5dfb] = 0xb33d,
  [0x5dfc] = 0xb33e, [0x5dfd] = 0xb33f, [0x5dfe] = 0xb340, [0x5dff] = 0xb341,
  [0x5e00] = 0xb342, [0x5e01] = 0xb343, [0x5e02] = 0xb344, [0x5e03] = 0xb345,
  [0x5e04] = 0xb346, [0x5e05] = 0xb347, [0x5e06] = 0xb348, [0x5e07] = 0xb349,
  [0x5e08] = 0xb34a, [0x5e09] = 0xb34b, [0x5e0a] = 0xb34c, [0x5e0b] = 0xb34d,
  [0x5e0c] = 0xb34e, [0x5e0d] = 0xb34f, [0x5e0e] = 0xb350, [0x5e0f] = 0xb351,
  [0x5e10] = 0xb352, [0x5e11] = 0xb353, [0x5e12] = 0xb354, [0x5e13] = 0xb355,
  [0x5e14] = 0xb356, [0x5e15] = 0xb357, [0x5e16] = 0xb358, [0x5e17] = 0xb359,
  [0x5e18] = 0xb35a, [0x5e19] = 0xb35b, [0x5e1a] = 0xb35c, [0x5e1b] = 0xb35d,
  [0x5e1c] = 0xb35e, [0x5e1d] = 0xb35f, [0x5e1e] = 0xb360, [0x5e1f] = 0xb361,
  [0x5e20] = 0xb362, [0x5e21] = 0xb363, [0x5e22] = 0xb364, [0x5e23] = 0xb365,
  [0x5e24] = 0xb366, [0x5e25] = 0xb367, [0x5e26] = 0xb368, [0x5e27] = 0xb369,
  [0x5e28] = 0xb36a, [0x5e29] = 0xb36b, [0x5e2a] = 0xb36c, [0x5e2b] = 0xb36d,
  [0x5e2c] = 0xb36e, [0x5e2d] = 0xb36f, [0x5e2e] = 0xb370, [0x5e2f] = 0xb371,
  [0x5e30] = 0xb372, [0x5e31] = 0xb373, [0x5e32] = 0xb374, [0x5e33] = 0xb375,
  [0x5e34] = 0xb376, [0x5e35] = 0xb377, [0x5e36] = 0xb378, [0x5e37] = 0xb379,
  [0x5e38] = 0xb37a, [0x5e39] = 0xb37b, [0x5e3a] = 0xb37c, [0x5e3b] = 0xb37d,
  [0x5e3c] = 0xb37e, [0x5e3d] = 0xb37f, [0x5e3e] = 0xb380, [0x5e3f] = 0xb381,
  [0x5e40] = 0xb382, [0x5e41] = 0xb383, [0x5e42] = 0xb384, [0x5e43] = 0xb385,
  [0x5e44] = 0xb386, [0x5e45] = 0xb387, [0x5e46] = 0xb388, [0x5e47] = 0xb389,
  [0x5e48] = 0xb38a, [0x5e49] = 0xb38b, [0x5e4a] = 0xb38c, [0x5e4b] = 0xb38d,
  [0x5e4c] = 0xb38e, [0x5e4d] = 0xb38f, [0x5e4e] = 0xb390, [0x5e4f] = 0xb391,
  [0x5e50] = 0xb392, [0x5e51] = 0xb393, [0x5e52] = 0xb394, [0x5e53] = 0xb395,
  [0x5e54] = 0xb396, [0x5e55] = 0xb397, [0x5e56] = 0xb398, [0x5e57] = 0xb399,
  [0x5e58] = 0xb39a, [0x5e59] = 0xb39b, [0x5e5a] = 0xb39c, [0x5e5b] = 0xb39d,
  [0x5e5c] = 0xb39e, [0x5e5d] = 0xb39f, [0x5e5e] = 0xb3a0, [0x5e5f] = 0xb3a1,
  [0x5e60] = 0xb3a2, [0x5e61] = 0xb3a3, [0x5e62] = 0xb3a4, [0x5e63] = 0xb3a5,
  [0x5e64] = 0xb3a6, [0x5e65] = 0xb3a7, [0x5e66] = 0xb3a8, [0x5e67] = 0xb3a9,
  [0x5e68] = 0xb3aa, [0x5e69] = 0xb3ab, [0x5e6a] = 0xb3ac, [0x5e6b] = 0xb3ad,
  [0x5e6c] = 0xb3ae, [0x5e6d] = 0xb3af, [0x5e6e] = 0xb3b0, [0x5e6f] = 0xb3b1,
  [0x5e70] = 0xb3b2, [0x5e71] = 0xb3b3, [0x5e72] = 0xb3b4, [0x5e73] = 0xb3b5,
  [0x5e74] = 0xb3b6, [0x5e75] = 0xb3b7, [0x5e76] = 0xb3b8, [0x5e77] = 0xb3b9,
  [0x5e78] = 0xb3ba, [0x5e79] = 0xb3bb, [0x5e7a] = 0xb3bc, [0x5e7b] = 0xb3bd,
  [0x5e7c] = 0xb3be, [0x5e7d] = 0xb3bf, [0x5e7e] = 0xb3c0, [0x5e7f] = 0xb3c1,
  [0x5e80] = 0xb3c2, [0x5e81] = 0xb3c3, [0x5e82] = 0xb3c4, [0x5e83] = 0xb3c5,
  [0x5e84] = 0xb3c6, [0x5e85] = 0xb3c7, [0x5e86] = 0xb3c8, [0x5e87] = 0xb3c9,
  [0x5e88] = 0xb3ca, [0x5e89] = 0xb3cb, [0x5e8a] = 0xb3cc, [0x5e8b] = 0xb3cd,
  [0x5e8c] = 0xb3ce, [0x5e8d] = 0xb3cf, [0x5e8e] = 0xb3d0, [0x5e8f] = 0xb3d1,
  [0x5e90] = 0xb3d2, [0x5e91] = 0xb3d3, [0x5e92] = 0xb3d4, [0x5e93] = 0xb3d5,
  [0x5e94] = 0xb3d6, [0x5e95] = 0xb3d7, [0x5e96] = 0xb3d8, [0x5e97] = 0xb3d9,
  [0x5e98] = 0xb3da, [0x5e99] = 0xb3db, [0x5e9a] = 0xb3dc, [0x5e9b] = 0xb3dd,
  [0x5e9c] = 0xb3de, [0x5e9d] = 0xb3df, [0x5e9e] = 0xb3e0, [0x5e9f] = 0xb3e1,
  [0x5ea0] = 0xb3e2, [0x5ea1] = 0xb3e3, [0x5ea2] = 0xb3e4, [0x5ea3] = 0xb3e5,
  [0x5ea4] = 0xb3e6, [0x5ea5] = 0xb3e7, [0x5ea6] = 0xb3e8, [0x5ea7] = 0xb3e9,
  [0x5ea8] = 0xb3ea, [0x5ea9] = 0xb3eb, [0x5eaa] = 0xb3ec, [0x5eab] = 0xb3ed,
  [0x5eac] = 0xb3ee, [0x5ead] = 0xb3ef, [0x5eae] = 0xb3f0, [0x5eaf] = 0xb3f1,
  [0x5eb0] = 0xb3f2, [0x5eb1] = 0xb3f3, [0x5eb2] = 0xb3f4, [0x5eb3] = 0xb3f5,
  [0x5eb4] = 0xb3f6, [0x5eb5] = 0xb3f7, [0x5eb6] = 0xb3f8, [0x5eb7] = 0xb3f9,
  [0x5eb8] = 0xb3fa, [0x5eb9] = 0xb3fb, [0x5eba] = 0xb3fc, [0x5ebb] = 0xb3fd,
  [0x5ebc] = 0xb3fe, [0x5ebd] = 0xb3ff, [0x5ebe] = 0xb400, [0x5ebf] = 0xb401,
  [0x5ec0] = 0xb402, [0x5ec1] = 0xb403, [0x5ec2] = 0xb404, [0x5ec3] = 0xb405,
  [0x5ec4] = 0xb406, [0x5ec5] = 0xb407, [0x5ec6] = 0xb408, [0x5ec7] = 0xb409,
  [0x5ec8] = 0xb40a, [0x5ec9] = 0xb40b, [0x5eca] = 0xb40c, [0x5ecb] = 0xb40d,
  [0x5ecc] = 0xb40e, [0x5ecd] = 0xb40f, [0x5ece] = 0xb410, [0x5ecf] = 0xb411,
  [0x5ed0] = 0xb412, [0x5ed1] = 0xb413, [0x5ed2] = 0xb414, [0x5ed3] = 0xb415,
  [0x5ed4] = 0xb416, [0x5ed5] = 0xb417, [0x5ed6] = 0xb418, [0x5ed7] = 0xb419,
  [0x5ed8] = 0xb41a, [0x5ed9] = 0xb41b, [0x5eda] = 0xb41c, [0x5edb] = 0xb41d,
  [0x5edc] = 0xb41e, [0x5edd] = 0xb41f, [0x5ede] = 0xb420, [0x5edf] = 0xb421,
  [0x5ee0] = 0xb422, [0x5ee1] = 0xb423, [0x5ee2] = 0xb424, [0x5ee3] = 0xb425,
  [0x5ee4] = 0xb426, [0x5ee5] = 0xb427, [0x5ee6] = 0xb428, [0x5ee7] = 0xb429,
  [0x5ee8] = 0xb42a, [0x5ee9] = 0xb42b, [0x5eea] = 0xb42c, [0x5eeb] = 0xb42d,
  [0x5eec] = 0xb42e, [0x5eed] = 0xb42f, [0x5eee] = 0xb430, [0x5eef] = 0xb431,
  [0x5ef0] = 0xb432, [0x5ef1] = 0xb433, [0x5ef2] = 0xb434, [0x5ef3] = 0xb435,
  [0x5ef4] = 0xb436, [0x5ef5] = 0xb437, [0x5ef6] = 0xb438, [0x5ef7] = 0xb439,
  [0x5ef8] = 0xb43a, [0x5ef9] = 0xb43b, [0x5efa] = 0xb43c, [0x5efb] = 0xb43d,
  [0x5efc] = 0xb43e, [0x5efd] = 0xb43f, [0x5efe] = 0xb440, [0x5eff] = 0xb441,
  [0x5f00] = 0xb442, [0x5f01] = 0xb443, [0x5f02] = 0xb444, [0x5f03] = 0xb445,
  [0x5f04] = 0xb446, [0x5f05] = 0xb447, [0x5f06] = 0xb448, [0x5f07] = 0xb449,
  [0x5f08] = 0xb44a, [0x5f09] = 0xb44b, [0x5f0a] = 0xb44c, [0x5f0b] = 0xb44d,
  [0x5f0c] = 0xb44e, [0x5f0d] = 0xb44f, [0x5f0e] = 0xb450, [0x5f0f] = 0xb451,
  [0x5f10] = 0xb452, [0x5f11] = 0xb453, [0x5f12] = 0xb454, [0x5f13] = 0xb455,
  [0x5f14] = 0xb456, [0x5f15] = 0xb457, [0x5f16] = 0xb458, [0x5f17] = 0xb459,
  [0x5f18] = 0xb45a, [0x5f19] = 0xb45b, [0x5f1a] = 0xb45c, [0x5f1b] = 0xb45d,
  [0x5f1c] = 0xb45e, [0x5f1d] = 0xb45f, [0x5f1e] = 0xb460, [0x5f1f] = 0xb461,
  [0x5f20] = 0xb462, [0x5f21] = 0xb463, [0x5f22] = 0xb464, [0x5f23] = 0xb465,
  [0x5f24] = 0xb466, [0x5f25] = 0xb467, [0x5f26] = 0xb468, [0x5f27] = 0xb469,
  [0x5f28] = 0xb46a, [0x5f29] = 0xb46b, [0x5f2a] = 0xb46c, [0x5f2b] = 0xb46d,
  [0x5f2c] = 0xb46e, [0x5f2d] = 0xb46f, [0x5f2e] = 0xb470, [0x5f2f] = 0xb471,
  [0x5f30] = 0xb472, [0x5f31] = 0xb473, [0x5f32] = 0xb474, [0x5f33] = 0xb475,
  [0x5f34] = 0xb476, [0x5f35] = 0xb477, [0x5f36] = 0xb478, [0x5f37] = 0xb479,
  [0x5f38] = 0xb47a, [0x5f39] = 0xb47b, [0x5f3a] = 0xb47c, [0x5f3b] = 0xb47d,
  [0x5f3c] = 0xb47e, [0x5f3d] = 0xb47f, [0x5f3e] = 0xb480, [0x5f3f] = 0xb481,
  [0x5f40] = 0xb482, [0x5f41] = 0xb483, [0x5f42] = 0xb484, [0x5f43] = 0xb485,
  [0x5f44] = 0xb486, [0x5f45] = 0xb487, [0x5f46] = 0xb488, [0x5f47] = 0xb489,
  [0x5f48] = 0xb48a, [0x5f49] = 0xb48b, [0x5f4a] = 0xb48c, [0x5f4b] = 0xb48d,
  [0x5f4c] = 0xb48e, [0x5f4d] = 0xb48f, [0x5f4e] = 0xb490, [0x5f4f] = 0xb491,
  [0x5f50] = 0xb492, [0x5f51] = 0xb493, [0x5f52] = 0xb494, [0x5f53] = 0xb495,
  [0x5f54] = 0xb496, [0x5f55] = 0xb497, [0x5f56] = 0xb498, [0x5f57] = 0xb499,
  [0x5f58] = 0xb49a, [0x5f59] = 0xb49b, [0x5f5a] = 0xb49c, [0x5f5b] = 0xb49d,
  [0x5f5c] = 0xb49e, [0x5f5d] = 0xb49f, [0x5f5e] = 0xb4a0, [0x5f5f] = 0xb4a1,
  [0x5f60] = 0xb4a2, [0x5f61] = 0xb4a3, [0x5f62] = 0xb4a4, [0x5f63] = 0xb4a5,
  [0x5f64] = 0xb4a6, [0x5f65] = 0xb4a7, [0x5f66] = 0xb4a8, [0x5f67] = 0xb4a9,
  [0x5f68] = 0xb4aa, [0x5f69] = 0xb4ab, [0x5f6a] = 0xb4ac, [0x5f6b] = 0xb4ad,
  [0x5f6c] = 0xb4ae, [0x5f6d] = 0xb4af, [0x5f6e] = 0xb4b0, [0x5f6f] = 0xb4b1,
  [0x5f70] = 0xb4b2, [0x5f71] = 0xb4b3, [0x5f72] = 0xb4b4, [0x5f73] = 0xb4b5,
  [0x5f74] = 0xb4b6, [0x5f75] = 0xb4b7, [0x5f76] = 0xb4b8, [0x5f77] = 0xb4b9,
  [0x5f78] = 0xb4ba, [0x5f79] = 0xb4bb, [0x5f7a] = 0xb4bc, [0x5f7b] = 0xb4bd,
  [0x5f7c] = 0xb4be, [0x5f7d] = 0xb4bf, [0x5f7e] = 0xb4c0, [0x5f7f] = 0xb4c1,
  [0x5f80] = 0xb4c2, [0x5f81] = 0xb4c3, [0x5f82] = 0xb4c4, [0x5f83] = 0xb4c5,
  [0x5f84] = 0xb4c6, [0x5f85] = 0xb4c7, [0x5f86] = 0xb4c8, [0x5f87] = 0xb4c9,
  [0x5f88] = 0xb4ca, [0x5f89] = 0xb4cb, [0x5f8a] = 0xb4cc, [0x5f8b] = 0xb4cd,
  [0x5f8c] = 0xb4ce, [0x5f8d] = 0xb4cf, [0x5f8e] = 0xb4d0, [0x5f8f] = 0xb4d1,
  [0x5f90] = 0xb4d2, [0x5f91] = 0xb4d3, [0x5f92] = 0xb4d4, [0x5f93] = 0xb4d5,
  [0x5f94] = 0xb4d6, [0x5f95] = 0xb4d7, [0x5f96] = 0xb4d8, [0x5f97] = 0xb4d9,
  [0x5f98] = 0xb4da, [0x5f99] = 0xb4db, [0x5f9a] = 0xb4dc, [0x5f9b] = 0xb4dd,
  [0x5f9c] = 0xb4de, [0x5f9d] = 0xb4df, [0x5f9e] = 0xb4e0, [0x5f9f] = 0xb4e1,
  [0x5fa0] = 0xb4e2, [0x5fa1] = 0xb4e3, [0x5fa2] = 0xb4e4, [0x5fa3] = 0xb4e5,
  [0x5fa4] = 0xb4e6, [0x5fa5] = 0xb4e7, [0x5fa6] = 0xb4e8, [0x5fa7] = 0xb4e9,
  [0x5fa8] = 0xb4ea, [0x5fa9] = 0xb4eb, [0x5faa] = 0xb4ec, [0x5fab] = 0xb4ed,
  [0x5fac] = 0xb4ee, [0x5fad] = 0xb4ef, [0x5fae] = 0xb4f0, [0x5faf] = 0xb4f1,
  [0x5fb0] = 0xb4f2, [0x5fb1] = 0xb4f3, [0x5fb2] = 0xb4f4, [0x5fb3] = 0xb4f5,
  [0x5fb4] = 0xb4f6, [0x5fb5] = 0xb4f7, [0x5fb6] = 0xb4f8, [0x5fb7] = 0xb4f9,
  [0x5fb8] = 0xb4fa, [0x5fb9] = 0xb4fb, [0x5fba] = 0xb4fc, [0x5fbb] = 0xb4fd,
  [0x5fbc] = 0xb4fe, [0x5fbd] = 0xb4ff, [0x5fbe] = 0xb500, [0x5fbf] = 0xb501,
  [0x5fc0] = 0xb502, [0x5fc1] = 0xb503, [0x5fc2] = 0xb504, [0x5fc3] = 0xb505,
  [0x5fc4] = 0xb506, [0x5fc5] = 0xb507, [0x5fc6] = 0xb508, [0x5fc7] = 0xb509,
  [0x5fc8] = 0xb50a, [0x5fc9] = 0xb50b, [0x5fca] = 0xb50c, [0x5fcb] = 0xb50d,
  [0x5fcc] = 0xb50e, [0x5fcd] = 0xb50f, [0x5fce] = 0xb510, [0x5fcf] = 0xb511,
  [0x5fd0] = 0xb512, [0x5fd1] = 0xb513, [0x5fd2] = 0xb514, [0x5fd3] = 0xb515,
  [0x5fd4] = 0xb516, [0x5fd5] = 0xb517, [0x5fd6] = 0xb518, [0x5fd7] = 0xb519,
  [0x5fd8] = 0xb51a, [0x5fd9] = 0xb51b, [0x5fda] = 0xb51c, [0x5fdb] = 0xb51d,
  [0x5fdc] = 0xb51e, [0x5fdd] = 0xb51f, [0x5fde] = 0xb520, [0x5fdf] = 0xb521,
  [0x5fe0] = 0xb522, [0x5fe1] = 0xb523, [0x5fe2] = 0xb524, [0x5fe3] = 0xb525,
  [0x5fe4] = 0xb526, [0x5fe5] = 0xb527, [0x5fe6] = 0xb528, [0x5fe7] = 0xb529,
  [0x5fe8] = 0xb52a, [0x5fe9] = 0xb52b, [0x5fea] = 0xb52c, [0x5feb] = 0xb52d,
  [0x5fec] = 0xb52e, [0x5fed] = 0xb52f, [0x5fee] = 0xb530, [0x5fef] = 0xb531,
  [0x5ff0] = 0xb532, [0x5ff1] = 0xb533, [0x5ff2] = 0xb534, [0x5ff3] = 0xb535,
  [0x5ff4] = 0xb536, [0x5ff5] = 0xb537, [0x5ff6] = 0xb538, [0x5ff7] = 0xb539,
  [0x5ff8] = 0xb53a, [0x5ff9] = 0xb53b, [0x5ffa] = 0xb53c, [0x5ffb] = 0xb53d,
  [0x5ffc] = 0xb53e, [0x5ffd] = 0xb53f, [0x5ffe] = 0xb540, [0x5fff] = 0xb541,
  [0x6000] = 0xb542, [0x6001] = 0xb543, [0x6002] = 0xb544, [0x6003] = 0xb545,
  [0x6004] = 0xb546, [0x6005] = 0xb547, [0x6006] = 0xb548, [0x6007] = 0xb549,
  [0x6008] = 0xb54a, [0x6009] = 0xb54b, [0x600a] = 0xb54c, [0x600b] = 0xb54d,
  [0x600c] = 0xb54e, [0x600d] = 0xb54f, [0x600e] = 0xb550, [0x600f] = 0xb551,
  [0x6010] = 0xb552, [0x6011] = 0xb553, [0x6012] = 0xb554, [0x6013] = 0xb555,
  [0x6014] = 0xb556, [0x6015] = 0xb557, [0x6016] = 0xb558, [0x6017] = 0xb559,
  [0x6018] = 0xb55a, [0x6019] = 0xb55b, [0x601a] = 0xb55c, [0x601b] = 0xb55d,
  [0x601c] = 0xb55e, [0x601d] = 0xb55f, [0x601e] = 0xb560, [0x601f] = 0xb561,
  [0x6020] = 0xb562, [0x6021] = 0xb563, [0x6022] = 0xb564, [0x6023] = 0xb565,
  [0x6024] = 0xb566, [0x6025] = 0xb567, [0x6026] = 0xb568, [0x6027] = 0xb569,
  [0x6028] = 0xb56a, [0x6029] = 0xb56b, [0x602a] = 0xb56c, [0x602b] = 0xb56d,
  [0x602c] = 0xb56e, [0x602d] = 0xb56f, [0x602e] = 0xb570, [0x602f] = 0xb571,
  [0x6030] = 0xb572, [0x6031] = 0xb573, [0x6032] = 0xb574, [0x6033] = 0xb575,
  [0x6034] = 0xb576, [0x6035] = 0xb577, [0x6036] = 0xb578, [0x6037] = 0xb579,
  [0x6038] = 0xb57a, [0x6039] = 0xb57b, [0x603a] = 0xb57c, [0x603b] = 0xb57d,
  [0x603c] = 0xb57e, [0x603d] = 0xb57f, [0x603e] = 0xb580, [0x603f] = 0xb581,
  [0x6040] = 0xb582, [0x6041] = 0xb583, [0x6042] = 0xb584, [0x6043] = 0xb585,
  [0x6044] = 0xb586, [0x6045] = 0xb587, [0x6046] = 0xb588, [0x6047] = 0xb589,
  [0x6048] = 0xb58a, [0x6049] = 0xb58b, [0x604a] = 0xb58c, [0x604b] = 0xb58d,
  [0x604c] = 0xb58e, [0x604d] = 0xb58f, [0x604e] = 0xb590, [0x604f] = 0xb591,
  [0x6050] = 0xb592, [0x6051] = 0xb593, [0x6052] = 0xb594, [0x6053] = 0xb595,
  [0x6054] = 0xb596, [0x6055] = 0xb597, [0x6056] = 0xb598, [0x6057] = 0xb599,
  [0x6058] = 0xb59a, [0x6059] = 0xb59b, [0x605a] = 0xb59c, [0x605b] = 0xb59d,
  [0x605c] = 0xb59e, [0x605d] = 0xb59f, [0x605e] = 0xb5a0, [0x605f] = 0xb5a1,
  [0x6060] = 0xb5a2, [0x6061] = 0xb5a3, [0x6062] = 0xb5a4, [0x6063] = 0xb5a5,
  [0x6064] = 0xb5a6, [0x6065] = 0xb5a7, [0x6066] = 0xb5a8, [0x6067] = 0xb5a9,
  [0x6068] = 0xb5aa, [0x6069] = 0xb5ab, [0x606a] = 0xb5ac, [0x606b] = 0xb5ad,
  [0x606c] = 0xb5ae, [0x606d] = 0xb5af, [0x606e] = 0xb5b0, [0x606f] = 0xb5b1,
  [0x6070] = 0xb5b2, [0x6071] = 0xb5b3, [0x6072] = 0xb5b4, [0x6073] = 0xb5b5,
  [0x6074] = 0xb5b6, [0x6075] = 0xb5b7, [0x6076] = 0xb5b8, [0x6077] = 0xb5b9,
  [0x6078] = 0xb5ba, [0x6079] = 0xb5bb, [0x607a] = 0xb5bc, [0x607b] = 0xb5bd,
  [0x607c] = 0xb5be, [0x607d] = 0xb5bf, [0x607e] = 0xb5c0, [0x607f] = 0xb5c1,
  [0x6080] = 0xb5c2, [0x6081] = 0xb5c3, [0x6082] = 0xb5c4, [0x6083] = 0xb5c5,
  [0x6084] = 0xb5c6, [0x6085] = 0xb5c7, [0x6086] = 0xb5c8, [0x6087] = 0xb5c9,
  [0x6088] = 0xb5ca, [0x6089] = 0xb5cb, [0x608a] = 0xb5cc, [0x608b] = 0xb5cd,
  [0x608c] = 0xb5ce, [0x608d] = 0xb5cf, [0x608e] = 0xb5d0, [0x608f] = 0xb5d1,
  [0x6090] = 0xb5d2, [0x6091] = 0xb5d3, [0x6092] = 0xb5d4, [0x6093] = 0xb5d5,
  [0x6094] = 0xb5d6, [0x6095] = 0xb5d7, [0x6096] = 0xb5d8, [0x6097] = 0xb5d9,
  [0x6098] = 0xb5da, [0x6099] = 0xb5db, [0x609a] = 0xb5dc, [0x609b] = 0xb5dd,
  [0x609c] = 0xb5de, [0x609d] = 0xb5df, [0x609e] = 0xb5e0, [0x609f] = 0xb5e1,
  [0x60a0] = 0xb5e2, [0x60a1] = 0xb5e3, [0x60a2] = 0xb5e4, [0x60a3] = 0xb5e5,
  [0x60a4] = 0xb5e6, [0x60a5] = 0xb5e7, [0x60a6] = 0xb5e8, [0x60a7] = 0xb5e9,
  [0x60a8] = 0xb5ea, [0x60a9] = 0xb5eb, [0x60aa] = 0xb5ec, [0x60ab] = 0xb5ed,
  [0x60ac] = 0xb5ee, [0x60ad] = 0xb5ef, [0x60ae] = 0xb5f0, [0x60af] = 0xb5f1,
  [0x60b0] = 0xb5f2, [0x60b1] = 0xb5f3, [0x60b2] = 0xb5f4, [0x60b3] = 0xb5f5,
  [0x60b4] = 0xb5f6, [0x60b5] = 0xb5f7, [0x60b6] = 0xb5f8, [0x60b7] = 0xb5f9,
  [0x60b8] = 0xb5fa, [0x60b9] = 0xb5fb, [0x60ba] = 0xb5fc, [0x60bb] = 0xb5fd,
  [0x60bc] = 0xb5fe, [0x60bd] = 0xb5ff, [0x60be] = 0xb600, [0x60bf] = 0xb601,
  [0x60c0] = 0xb602, [0x60c1] = 0xb603, [0x60c2] = 0xb604, [0x60c3] = 0xb605,
  [0x60c4] = 0xb606, [0x60c5] = 0xb607, [0x60c6] = 0xb608, [0x60c7] = 0xb609,
  [0x60c8] = 0xb60a, [0x60c9] = 0xb60b, [0x60ca] = 0xb60c, [0x60cb] = 0xb60d,
  [0x60cc] = 0xb60e, [0x60cd] = 0xb60f, [0x60ce] = 0xb610, [0x60cf] = 0xb611,
  [0x60d0] = 0xb612, [0x60d1] = 0xb613, [0x60d2] = 0xb614, [0x60d3] = 0xb615,
  [0x60d4] = 0xb616, [0x60d5] = 0xb617, [0x60d6] = 0xb618, [0x60d7] = 0xb619,
  [0x60d8] = 0xb61a, [0x60d9] = 0xb61b, [0x60da] = 0xb61c, [0x60db] = 0xb61d,
  [0x60dc] = 0xb61e, [0x60dd] = 0xb61f, [0x60de] = 0xb620, [0x60df] = 0xb621,
  [0x60e0] = 0xb622, [0x60e1] = 0xb623, [0x60e2] = 0xb624, [0x60e3] = 0xb625,
  [0x60e4] = 0xb626, [0x60e5] = 0xb627, [0x60e6] = 0xb628, [0x60e7] = 0xb629,
  [0x60e8] = 0xb62a, [0x60e9] = 0xb62b, [0x60ea] = 0xb62c, [0x60eb] = 0xb62d,
  [0x60ec] = 0xb62e, [0x60ed] = 0xb62f, [0x60ee] = 0xb630, [0x60ef] = 0xb631,
  [0x60f0] = 0xb632, [0x60f1] = 0xb633, [0x60f2] = 0xb634, [0x60f3] = 0xb635,
  [0x60f4] = 0xb636, [0x60f5] = 0xb637, [0x60f6] = 0xb638, [0x60f7] = 0xb639,
  [0x60f8] = 0xb63a, [0x60f9] = 0xb63b, [0x60fa] = 0xb63c, [0x60fb] = 0xb63d,
  [0x60fc] = 0xb63e, [0x60fd] = 0xb63f, [0x60fe] = 0xb640, [0x60ff] = 0xb641,
  [0x6100] = 0xb642, [0x6101] = 0xb643, [0x6102] = 0xb644, [0x6103] = 0xb645,
  [0x6104] = 0xb646, [0x6105] = 0xb647, [0x6106] = 0xb648, [0x6107] = 0xb649,
  [0x6108] = 0xb64a, [0x6109] = 0xb64b, [0x610a] = 0xb64c, [0x610b] = 0xb64d,
  [0x610c] = 0xb64e, [0x610d] = 0xb64f, [0x610e] = 0xb650, [0x610f] = 0xb651,
  [0x6110] = 0xb652, [0x6111] = 0xb653, [0x6112] = 0xb654, [0x6113] = 0xb655,
  [0x6114] = 0xb656, [0x6115] = 0xb657, [0x6116] = 0xb658, [0x6117] = 0xb659,
  [0x6118] = 0xb65a, [0x6119] = 0xb65b, [0x611a] = 0xb65c, [0x611b] = 0xb65d,
  [0x611c] = 0xb65e, [0x611d] = 0xb65f, [0x611e] = 0xb660, [0x611f] = 0xb661,
  [0x6120] = 0xb662, [0x6121] = 0xb663, [0x6122] = 0xb664, [0x6123] = 0xb665,
  [0x6124] = 0xb666, [0x6125] = 0xb667, [0x6126] = 0xb668, [0x6127] = 0xb669,
  [0x6128] = 0xb66a, [0x6129] = 0xb66b, [0x612a] = 0xb66c, [0x612b] = 0xb66d,
  [0x612c] = 0xb66e, [0x612d] = 0xb66f, [0x612e] = 0xb670, [0x612f] = 0xb671,
  [0x6130] = 0xb672, [0x6131] = 0xb673, [0x6132] = 0xb674, [0x6133] = 0xb675,
  [0x6134] = 0xb676, [0x6135] = 0xb677, [0x6136] = 0xb678, [0x6137] = 0xb679,
  [0x6138] = 0xb67a, [0x6139] = 0xb67b, [0x613a] = 0xb67c, [0x613b] = 0xb67d,
  [0x613c] = 0xb67e, [0x613d] = 0xb67f, [0x613e] = 0xb680, [0x613f] = 0xb681,
  [0x6140] = 0xb682, [0x6141] = 0xb683, [0x6142] = 0xb684, [0x6143] = 0xb685,
  [0x6144] = 0xb686, [0x6145] = 0xb687, [0x6146] = 0xb688, [0x6147] = 0xb689,
  [0x6148] = 0xb68a, [0x6149] = 0xb68b, [0x614a] = 0xb68c, [0x614b] = 0xb68d,
  [0x614c] = 0xb68e, [0x614d] = 0xb68f, [0x614e] = 0xb690, [0x614f] = 0xb691,
  [0x6150] = 0xb692, [0x6151] = 0xb693, [0x6152] = 0xb694, [0x6153] = 0xb695,
  [0x6154] = 0xb696, [0x6155] = 0xb697, [0x6156] = 0xb698, [0x6157] = 0xb699,
  [0x6158] = 0xb69a, [0x6159] = 0xb69b, [0x615a] = 0xb69c, [0x615b] = 0xb69d,
  [0x615c] = 0xb69e, [0x615d] = 0xb69f, [0x615e] = 0xb6a0, [0x615f] = 0xb6a1,
  [0x6160] = 0xb6a2, [0x6161] = 0xb6a3, [0x6162] = 0xb6a4, [0x6163] = 0xb6a5,
  [0x6164] = 0xb6a6, [0x6165] = 0xb6a7, [0x6166] = 0xb6a8, [0x6167] = 0xb6a9,
  [0x6168] = 0xb6aa, [0x6169] = 0xb6ab, [0x616a] = 0xb6ac, [0x616b] = 0xb6ad,
  [0x616c] = 0xb6ae, [0x616d] = 0xb6af, [0x616e] = 0xb6b0, [0x616f] = 0xb6b1,
  [0x6170] = 0xb6b2, [0x6171] = 0xb6b3, [0x6172] = 0xb6b4, [0x6173] = 0xb6b5,
  [0x6174] = 0xb6b6, [0x6175] = 0xb6b7, [0x6176] = 0xb6b8, [0x6177] = 0xb6b9,
  [0x6178] = 0xb6ba, [0x6179] = 0xb6bb, [0x617a] = 0xb6bc, [0x617b] = 0xb6bd,
  [0x617c] = 0xb6be, [0x617d] = 0xb6bf, [0x617e] = 0xb6c0, [0x617f] = 0xb6c1,
  [0x6180] = 0xb6c2, [0x6181] = 0xb6c3, [0x6182] = 0xb6c4, [0x6183] = 0xb6c5,
  [0x6184] = 0xb6c6, [0x6185] = 0xb6c7, [0x6186] = 0xb6c8, [0x6187] = 0xb6c9,
  [0x6188] = 0xb6ca, [0x6189] = 0xb6cb, [0x618a] = 0xb6cc, [0x618b] = 0xb6cd,
  [0x618c] = 0xb6ce, [0x618d] = 0xb6cf, [0x618e] = 0xb6d0, [0x618f] = 0xb6d1,
  [0x6190] = 0xb6d2, [0x6191] = 0xb6d3, [0x6192] = 0xb6d4, [0x6193] = 0xb6d5,
  [0x6194] = 0xb6d6, [0x6195] = 0xb6d7, [0x6196] = 0xb6d8, [0x6197] = 0xb6d9,
  [0x6198] = 0xb6da, [0x6199] = 0xb6db, [0x619a] = 0xb6dc, [0x619b] = 0xb6dd,
  [0x619c] = 0xb6de, [0x619d] = 0xb6df, [0x619e] = 0xb6e0, [0x619f] = 0xb6e1,
  [0x61a0] = 0xb6e2, [0x61a1] = 0xb6e3, [0x61a2] = 0xb6e4, [0x61a3] = 0xb6e5,
  [0x61a4] = 0xb6e6, [0x61a5] = 0xb6e7, [0x61a6] = 0xb6e8, [0x61a7] = 0xb6e9,
  [0x61a8] = 0xb6ea, [0x61a9] = 0xb6eb, [0x61aa] = 0xb6ec, [0x61ab] = 0xb6ed,
  [0x61ac] = 0xb6ee, [0x61ad] = 0xb6ef, [0x61ae] = 0xb6f0, [0x61af] = 0xb6f1,
  [0x61b0] = 0xb6f2, [0x61b1] = 0xb6f3, [0x61b2] = 0xb6f4, [0x61b3] = 0xb6f5,
  [0x61b4] = 0xb6f6, [0x61b5] = 0xb6f7, [0x61b6] = 0xb6f8, [0x61b7] = 0xb6f9,
  [0x61b8] = 0xb6fa, [0x61b9] = 0xb6fb, [0x61ba] = 0xb6fc, [0x61bb] = 0xb6fd,
  [0x61bc] = 0xb6fe, [0x61bd] = 0xb6ff, [0x61be] = 0xb700, [0x61bf] = 0xb701,
  [0x61c0] = 0xb702, [0x61c1] = 0xb703, [0x61c2] = 0xb704, [0x61c3] = 0xb705,
  [0x61c4] = 0xb706, [0x61c5] = 0xb707, [0x61c6] = 0xb708, [0x61c7] = 0xb709,
  [0x61c8] = 0xb70a, [0x61c9] = 0xb70b, [0x61ca] = 0xb70c, [0x61cb] = 0xb70d,
  [0x61cc] = 0xb70e, [0x61cd] = 0xb70f, [0x61ce] = 0xb710, [0x61cf] = 0xb711,
  [0x61d0] = 0xb712, [0x61d1] = 0xb713, [0x61d2] = 0xb714, [0x61d3] = 0xb715,
  [0x61d4] = 0xb716, [0x61d5] = 0xb717, [0x61d6] = 0xb718, [0x61d7] = 0xb719,
  [0x61d8] = 0xb71a, [0x61d9] = 0xb71b, [0x61da] = 0xb71c, [0x61db] = 0xb71d,
  [0x61dc] = 0xb71e, [0x61dd] = 0xb71f, [0x61de] = 0xb720, [0x61df] = 0xb721,
  [0x61e0] = 0xb722, [0x61e1] = 0xb723, [0x61e2] = 0xb724, [0x61e3] = 0xb725,
  [0x61e4] = 0xb726, [0x61e5] = 0xb727, [0x61e6] = 0xb728, [0x61e7] = 0xb729,
  [0x61e8] = 0xb72a, [0x61e9] = 0xb72b, [0x61ea] = 0xb72c, [0x61eb] = 0xb72d,
  [0x61ec] = 0xb72e, [0x61ed] = 0xb72f, [0x61ee] = 0xb730, [0x61ef] = 0xb731,
  [0x61f0] = 0xb732, [0x61f1] = 0xb733, [0x61f2] = 0xb734, [0x61f3] = 0xb735,
  [0x61f4] = 0xb736, [0x61f5] = 0xb737, [0x61f6] = 0xb738, [0x61f7] = 0xb739,
  [0x61f8] = 0xb73a, [0x61f9] = 0xb73b, [0x61fa] = 0xb73c, [0x61fb] = 0xb73d,
  [0x61fc] = 0xb73e, [0x61fd] = 0xb73f, [0x61fe] = 0xb740, [0x61ff] = 0xb741,
  [0x6200] = 0xb742, [0x6201] = 0xb743, [0x6202] = 0xb744, [0x6203] = 0xb745,
  [0x6204] = 0xb746, [0x6205] = 0xb747, [0x6206] = 0xb748, [0x6207] = 0xb749,
  [0x6208] = 0xb74a, [0x6209] = 0xb74b, [0x620a] = 0xb74c, [0x620b] = 0xb74d,
  [0x620c] = 0xb74e, [0x620d] = 0xb74f, [0x620e] = 0xb750, [0x620f] = 0xb751,
  [0x6210] = 0xb752, [0x6211] = 0xb753, [0x6212] = 0xb754, [0x6213] = 0xb755,
  [0x6214] = 0xb756, [0x6215] = 0xb757, [0x6216] = 0xb758, [0x6217] = 0xb759,
  [0x6218] = 0xb75a, [0x6219] = 0xb75b, [0x621a] = 0xb75c, [0x621b] = 0xb75d,
  [0x621c] = 0xb75e, [0x621d] = 0xb75f, [0x621e] = 0xb760, [0x621f] = 0xb761,
  [0x6220] = 0xb762, [0x6221] = 0xb763, [0x6222] = 0xb764, [0x6223] = 0xb765,
  [0x6224] = 0xb766, [0x6225] = 0xb767, [0x6226] = 0xb768, [0x6227] = 0xb769,
  [0x6228] = 0xb76a, [0x6229] = 0xb76b, [0x622a] = 0xb76c, [0x622b] = 0xb76d,
  [0x622c] = 0xb76e, [0x622d] = 0xb76f, [0x622e] = 0xb770, [0x622f] = 0xb771,
  [0x6230] = 0xb772, [0x6231] = 0xb773, [0x6232] = 0xb774, [0x6233] = 0xb775,
  [0x6234] = 0xb776, [0x6235] = 0xb777, [0x6236] = 0xb778, [0x6237] = 0xb779,
  [0x6238] = 0xb77a, [0x6239] = 0xb77b, [0x623a] = 0xb77c, [0x623b] = 0xb77d,
  [0x623c] = 0xb77e, [0x623d] = 0xb77f, [0x623e] = 0xb780, [0x623f] = 0xb781,
  [0x6240] = 0xb782, [0x6241] = 0xb783, [0x6242] = 0xb784, [0x6243] = 0xb785,
  [0x6244] = 0xb786, [0x6245] = 0xb787, [0x6246] = 0xb788, [0x6247] = 0xb789,
  [0x6248] = 0xb78a, [0x6249] = 0xb78b, [0x624a] = 0xb78c, [0x624b] = 0xb78d,
  [0x624c] = 0xb78e, [0x624d] = 0xb78f, [0x624e] = 0xb790, [0x624f] = 0xb791,
  [0x6250] = 0xb792, [0x6251] = 0xb793, [0x6252] = 0xb794, [0x6253] = 0xb795,
  [0x6254] = 0xb796, [0x6255] = 0xb797, [0x6256] = 0xb798, [0x6257] = 0xb799,
  [0x6258] = 0xb79a, [0x6259] = 0xb79b, [0x625a] = 0xb79c, [0x625b] = 0xb79d,
  [0x625c] = 0xb79e, [0x625d] = 0xb79f, [0x625e] = 0xb7a0, [0x625f] = 0xb7a1,
  [0x6260] = 0xb7a2, [0x6261] = 0xb7a3, [0x6262] = 0xb7a4, [0x6263] = 0xb7a5,
  [0x6264] = 0xb7a6, [0x6265] = 0xb7a7, [0x6266] = 0xb7a8, [0x6267] = 0xb7a9,
  [0x6268] = 0xb7aa, [0x6269] = 0xb7ab, [0x626a] = 0xb7ac, [0x626b] = 0xb7ad,
  [0x626c] = 0xb7ae, [0x626d] = 0xb7af, [0x626e] = 0xb7b0, [0x626f] = 0xb7b1,
  [0x6270] = 0xb7b2, [0x6271] = 0xb7b3, [0x6272] = 0xb7b4, [0x6273] = 0xb7b5,
  [0x6274] = 0xb7b6, [0x6275] = 0xb7b7, [0x6276] = 0xb7b8, [0x6277] = 0xb7b9,
  [0x6278] = 0xb7ba, [0x6279] = 0xb7bb, [0x627a] = 0xb7bc, [0x627b] = 0xb7bd,
  [0x627c] = 0xb7be, [0x627d] = 0xb7bf, [0x627e] = 0xb7c0, [0x627f] = 0xb7c1,
  [0x6280] = 0xb7c2, [0x6281] = 0xb7c3, [0x6282] = 0xb7c4, [0x6283] = 0xb7c5,
  [0x6284] = 0xb7c6, [0x6285] = 0xb7c7, [0x6286] = 0xb7c8, [0x6287] = 0xb7c9,
  [0x6288] = 0xb7ca, [0x6289] = 0xb7cb, [0x628a] = 0xb7cc, [0x628b] = 0xb7cd,
  [0x628c] = 0xb7ce, [0x628d] = 0xb7cf, [0x628e] = 0xb7d0, [0x628f] = 0xb7d1,
  [0x6290] = 0xb7d2, [0x6291] = 0xb7d3, [0x6292] = 0xb7d4, [0x6293] = 0xb7d5,
  [0x6294] = 0xb7d6, [0x6295] = 0xb7d7, [0x6296] = 0xb7d8, [0x6297] = 0xb7d9,
  [0x6298] = 0xb7da, [0x6299] = 0xb7db, [0x629a] = 0xb7dc, [0x629b] = 0xb7dd,
  [0x629c] = 0xb7de, [0x629d] = 0xb7df, [0x629e] = 0xb7e0, [0x629f] = 0xb7e1,
  [0x62a0] = 0xb7e2, [0x62a1] = 0xb7e3, [0x62a2] = 0xb7e4, [0x62a3] = 0xb7e5,
  [0x62a4] = 0xb7e6, [0x62a5] = 0xb7e7, [0x62a6] = 0xb7e8, [0x62a7] = 0xb7e9,
  [0x62a8] = 0xb7ea, [0x62a9] = 0xb7eb, [0x62aa] = 0xb7ec, [0x62ab] = 0xb7ed,
  [0x62ac] = 0xb7ee, [0x62ad] = 0xb7ef, [0x62ae] = 0xb7f0, [0x62af] = 0xb7f1,
  [0x62b0] = 0xb7f2, [0x62b1] = 0xb7f3, [0x62b2] = 0xb7f4, [0x62b3] = 0xb7f5,
  [0x62b4] = 0xb7f6, [0x62b5] = 0xb7f7, [0x62b6] = 0xb7f8, [0x62b7] = 0xb7f9,
  [0x62b8] = 0xb7fa, [0x62b9] = 0xb7fb, [0x62ba] = 0xb7fc, [0x62bb] = 0xb7fd,
  [0x62bc] = 0xb7fe, [0x62bd] = 0xb7ff, [0x62be] = 0xb800, [0x62bf] = 0xb801,
  [0x62c0] = 0xb802, [0x62c1] = 0xb803, [0x62c2] = 0xb804, [0x62c3] = 0xb805,
  [0x62c4] = 0xb806, [0x62c5] = 0xb807, [0x62c6] = 0xb808, [0x62c7] = 0xb809,
  [0x62c8] = 0xb80a, [0x62c9] = 0xb80b, [0x62ca] = 0xb80c, [0x62cb] = 0xb80d,
  [0x62cc] = 0xb80e, [0x62cd] = 0xb80f, [0x62ce] = 0xb810, [0x62cf] = 0xb811,
  [0x62d0] = 0xb812, [0x62d1] = 0xb813, [0x62d2] = 0xb814, [0x62d3] = 0xb815,
  [0x62d4] = 0xb816, [0x62d5] = 0xb817, [0x62d6] = 0xb818, [0x62d7] = 0xb819,
  [0x62d8] = 0xb81a, [0x62d9] = 0xb81b, [0x62da] = 0xb81c, [0x62db] = 0xb81d,
  [0x62dc] = 0xb81e, [0x62dd] = 0xb81f, [0x62de] = 0xb820, [0x62df] = 0xb821,
  [0x62e0] = 0xb822, [0x62e1] = 0xb823, [0x62e2] = 0xb824, [0x62e3] = 0xb825,
  [0x62e4] = 0xb826, [0x62e5] = 0xb827, [0x62e6] = 0xb828, [0x62e7] = 0xb829,
  [0x62e8] = 0xb82a, [0x62e9] = 0xb82b, [0x62ea] = 0xb82c, [0x62eb] = 0xb82d,
  [0x62ec] = 0xb82e, [0x62ed] = 0xb82f, [0x62ee] = 0xb830, [0x62ef] = 0xb831,
  [0x62f0] = 0xb832, [0x62f1] = 0xb833, [0x62f2] = 0xb834, [0x62f3] = 0xb835,
  [0x62f4] = 0xb836, [0x62f5] = 0xb837, [0x62f6] = 0xb838, [0x62f7] = 0xb839,
  [0x62f8] = 0xb83a, [0x62f9] = 0xb83b, [0x62fa] = 0xb83c, [0x62fb] = 0xb83d,
  [0x62fc] = 0xb83e, [0x62fd] = 0xb83f, [0x62fe] = 0xb840, [0x62ff] = 0xb841,
  [0x6300] = 0xb842, [0x6301] = 0xb843, [0x6302] = 0xb844, [0x6303] = 0xb845,
  [0x6304] = 0xb846, [0x6305] = 0xb847, [0x6306] = 0xb848, [0x6307] = 0xb849,
  [0x6308] = 0xb84a, [0x6309] = 0xb84b, [0x630a] = 0xb84c, [0x630b] = 0xb84d,
  [0x630c] = 0xb84e, [0x630d] = 0xb84f, [0x630e] = 0xb850, [0x630f] = 0xb851,
  [0x6310] = 0xb852, [0x6311] = 0xb853, [0x6312] = 0xb854, [0x6313] = 0xb855,
  [0x6314] = 0xb856, [0x6315] = 0xb857, [0x6316] = 0xb858, [0x6317] = 0xb859,
  [0x6318] = 0xb85a, [0x6319] = 0xb85b, [0x631a] = 0xb85c, [0x631b] = 0xb85d,
  [0x631c] = 0xb85e, [0x631d] = 0xb85f, [0x631e] = 0xb860, [0x631f] = 0xb861,
  [0x6320] = 0xb862, [0x6321] = 0xb863, [0x6322] = 0xb864, [0x6323] = 0xb865,
  [0x6324] = 0xb866, [0x6325] = 0xb867, [0x6326] = 0xb868, [0x6327] = 0xb869,
  [0x6328] = 0xb86a, [0x6329] = 0xb86b, [0x632a] = 0xb86c, [0x632b] = 0xb86d,
  [0x632c] = 0xb86e, [0x632d] = 0xb86f, [0x632e] = 0xb870, [0x632f] = 0xb871,
  [0x6330] = 0xb872, [0x6331] = 0xb873, [0x6332] = 0xb874, [0x6333] = 0xb875,
  [0x6334] = 0xb876, [0x6335] = 0xb877, [0x6336] = 0xb878, [0x6337] = 0xb879,
  [0x6338] = 0xb87a, [0x6339] = 0xb87b, [0x633a] = 0xb87c, [0x633b] = 0xb87d,
  [0x633c] = 0xb87e, [0x633d] = 0xb87f, [0x633e] = 0xb880, [0x633f] = 0xb881,
  [0x6340] = 0xb882, [0x6341] = 0xb883, [0x6342] = 0xb884, [0x6343] = 0xb885,
  [0x6344] = 0xb886, [0x6345] = 0xb887, [0x6346] = 0xb888, [0x6347] = 0xb889,
  [0x6348] = 0xb88a, [0x6349] = 0xb88b, [0x634a] = 0xb88c, [0x634b] = 0xb88d,
  [0x634c] = 0xb88e, [0x634d] = 0xb88f, [0x634e] = 0xb890, [0x634f] = 0xb891,
  [0x6350] = 0xb892, [0x6351] = 0xb893, [0x6352] = 0xb894, [0x6353] = 0xb895,
  [0x6354] = 0xb896, [0x6355] = 0xb897, [0x6356] = 0xb898, [0x6357] = 0xb899,
  [0x6358] = 0xb89a, [0x6359] = 0xb89b, [0x635a] = 0xb89c, [0x635b] = 0xb89d,
  [0x635c] = 0xb89e, [0x635d] = 0xb89f, [0x635e] = 0xb8a0, [0x635f] = 0xb8a1,
  [0x6360] = 0xb8a2, [0x6361] = 0xb8a3, [0x6362] = 0xb8a4, [0x6363] = 0xb8a5,
  [0x6364] = 0xb8a6, [0x6365] = 0xb8a7, [0x6366] = 0xb8a8, [0x6367] = 0xb8a9,
  [0x6368] = 0xb8aa, [0x6369] = 0xb8ab, [0x636a] = 0xb8ac, [0x636b] = 0xb8ad,
  [0x636c] = 0xb8ae, [0x636d] = 0xb8af, [0x636e] = 0xb8b0, [0x636f] = 0xb8b1,
  [0x6370] = 0xb8b2, [0x6371] = 0xb8b3, [0x6372] = 0xb8b4, [0x6373] = 0xb8b5,
  [0x6374] = 0xb8b6, [0x6375] = 0xb8b7, [0x6376] = 0xb8b8, [0x6377] = 0xb8b9,
  [0x6378] = 0xb8ba, [0x6379] = 0xb8bb, [0x637a] = 0xb8bc, [0x637b] = 0xb8bd,
  [0x637c] = 0xb8be, [0x637d] = 0xb8bf, [0x637e] = 0xb8c0, [0x637f] = 0xb8c1,
  [0x6380] = 0xb8c2, [0x6381] = 0xb8c3, [0x6382] = 0xb8c4, [0x6383] = 0xb8c5,
  [0x6384] = 0xb8c6, [0x6385] = 0xb8c7, [0x6386] = 0xb8c8, [0x6387] = 0xb8c9,
  [0x6388] = 0xb8ca, [0x6389] = 0xb8cb, [0x638a] = 0xb8cc, [0x638b] = 0xb8cd,
  [0x638c] = 0xb8ce, [0x638d] = 0xb8cf, [0x638e] = 0xb8d0, [0x638f] = 0xb8d1,
  [0x6390] = 0xb8d2, [0x6391] = 0xb8d3, [0x6392] = 0xb8d4, [0x6393] = 0xb8d5,
  [0x6394] = 0xb8d6, [0x6395] = 0xb8d7, [0x6396] = 0xb8d8, [0x6397] = 0xb8d9,
  [0x6398] = 0xb8da, [0x6399] = 0xb8db, [0x639a] = 0xb8dc, [0x639b] = 0xb8dd,
  [0x639c] = 0xb8de, [0x639d] = 0xb8df, [0x639e] = 0xb8e0, [0x639f] = 0xb8e1,
  [0x63a0] = 0xb8e2, [0x63a1] = 0xb8e3, [0x63a2] = 0xb8e4, [0x63a3] = 0xb8e5,
  [0x63a4] = 0xb8e6, [0x63a5] = 0xb8e7, [0x63a6] = 0xb8e8, [0x63a7] = 0xb8e9,
  [0x63a8] = 0xb8ea, [0x63a9] = 0xb8eb, [0x63aa] = 0xb8ec, [0x63ab] = 0xb8ed,
  [0x63ac] = 0xb8ee, [0x63ad] = 0xb8ef, [0x63ae] = 0xb8f0, [0x63af] = 0xb8f1,
  [0x63b0] = 0xb8f2, [0x63b1] = 0xb8f3, [0x63b2] = 0xb8f4, [0x63b3] = 0xb8f5,
  [0x63b4] = 0xb8f6, [0x63b5] = 0xb8f7, [0x63b6] = 0xb8f8, [0x63b7] = 0xb8f9,
  [0x63b8] = 0xb8fa, [0x63b9] = 0xb8fb, [0x63ba] = 0xb8fc, [0x63bb] = 0xb8fd,
  [0x63bc] = 0xb8fe, [0x63bd] = 0xb8ff, [0x63be] = 0xb900, [0x63bf] = 0xb901,
  [0x63c0] = 0xb902, [0x63c1] = 0xb903, [0x63c2] = 0xb904, [0x63c3] = 0xb905,
  [0x63c4] = 0xb906, [0x63c5] = 0xb907, [0x63c6] = 0xb908, [0x63c7] = 0xb909,
  [0x63c8] = 0xb90a, [0x63c9] = 0xb90b, [0x63ca] = 0xb90c, [0x63cb] = 0xb90d,
  [0x63cc] = 0xb90e, [0x63cd] = 0xb90f, [0x63ce] = 0xb910, [0x63cf] = 0xb911,
  [0x63d0] = 0xb912, [0x63d1] = 0xb913, [0x63d2] = 0xb914, [0x63d3] = 0xb915,
  [0x63d4] = 0xb916, [0x63d5] = 0xb917, [0x63d6] = 0xb918, [0x63d7] = 0xb919,
  [0x63d8] = 0xb91a, [0x63d9] = 0xb91b, [0x63da] = 0xb91c, [0x63db] = 0xb91d,
  [0x63dc] = 0xb91e, [0x63dd] = 0xb91f, [0x63de] = 0xb920, [0x63df] = 0xb921,
  [0x63e0] = 0xb922, [0x63e1] = 0xb923, [0x63e2] = 0xb924, [0x63e3] = 0xb925,
  [0x63e4] = 0xb926, [0x63e5] = 0xb927, [0x63e6] = 0xb928, [0x63e7] = 0xb929,
  [0x63e8] = 0xb92a, [0x63e9] = 0xb92b, [0x63ea] = 0xb92c, [0x63eb] = 0xb92d,
  [0x63ec] = 0xb92e, [0x63ed] = 0xb92f, [0x63ee] = 0xb930, [0x63ef] = 0xb931,
  [0x63f0] = 0xb932, [0x63f1] = 0xb933, [0x63f2] = 0xb934, [0x63f3] = 0xb935,
  [0x63f4] = 0xb936, [0x63f5] = 0xb937, [0x63f6] = 0xb938, [0x63f7] = 0xb939,
  [0x63f8] = 0xb93a, [0x63f9] = 0xb93b, [0x63fa] = 0xb93c, [0x63fb] = 0xb93d,
  [0x63fc] = 0xb93e, [0x63fd] = 0xb93f, [0x63fe] = 0xb940, [0x63ff] = 0xb941,
  [0x6400] = 0xb942, [0x6401] = 0xb943, [0x6402] = 0xb944, [0x6403] = 0xb945,
  [0x6404] = 0xb946, [0x6405] = 0xb947, [0x6406] = 0xb948, [0x6407] = 0xb949,
  [0x6408] = 0xb94a, [0x6409] = 0xb94b, [0x640a] = 0xb94c, [0x640b] = 0xb94d,
  [0x640c] = 0xb94e, [0x640d] = 0xb94f, [0x640e] = 0xb950, [0x640f] = 0xb951,
  [0x6410] = 0xb952, [0x6411] = 0xb953, [0x6412] = 0xb954, [0x6413] = 0xb955,
  [0x6414] = 0xb956, [0x6415] = 0xb957, [0x6416] = 0xb958, [0x6417] = 0xb959,
  [0x6418] = 0xb95a, [0x6419] = 0xb95b, [0x641a] = 0xb95c, [0x641b] = 0xb95d,
  [0x641c] = 0xb95e, [0x641d] = 0xb95f, [0x641e] = 0xb960, [0x641f] = 0xb961,
  [0x6420] = 0xb962, [0x6421] = 0xb963, [0x6422] = 0xb964, [0x6423] = 0xb965,
  [0x6424] = 0xb966, [0x6425] = 0xb967, [0x6426] = 0xb968, [0x6427] = 0xb969,
  [0x6428] = 0xb96a, [0x6429] = 0xb96b, [0x642a] = 0xb96c, [0x642b] = 0xb96d,
  [0x642c] = 0xb96e, [0x642d] = 0xb96f, [0x642e] = 0xb970, [0x642f] = 0xb971,
  [0x6430] = 0xb972, [0x6431] = 0xb973, [0x6432] = 0xb974, [0x6433] = 0xb975,
  [0x6434] = 0xb976, [0x6435] = 0xb977, [0x6436] = 0xb978, [0x6437] = 0xb979,
  [0x6438] = 0xb97a, [0x6439] = 0xb97b, [0x643a] = 0xb97c, [0x643b] = 0xb97d,
  [0x643c] = 0xb97e, [0x643d] = 0xb97f, [0x643e] = 0xb980, [0x643f] = 0xb981,
  [0x6440] = 0xb982, [0x6441] = 0xb983, [0x6442] = 0xb984, [0x6443] = 0xb985,
  [0x6444] = 0xb986, [0x6445] = 0xb987, [0x6446] = 0xb988, [0x6447] = 0xb989,
  [0x6448] = 0xb98a, [0x6449] = 0xb98b, [0x644a] = 0xb98c, [0x644b] = 0xb98d,
  [0x644c] = 0xb98e, [0x644d] = 0xb98f, [0x644e] = 0xb990, [0x644f] = 0xb991,
  [0x6450] = 0xb992, [0x6451] = 0xb993, [0x6452] = 0xb994, [0x6453] = 0xb995,
  [0x6454] = 0xb996, [0x6455] = 0xb997, [0x6456] = 0xb998, [0x6457] = 0xb999,
  [0x6458] = 0xb99a, [0x6459] = 0xb99b, [0x645a] = 0xb99c, [0x645b] = 0xb99d,
  [0x645c] = 0xb99e, [0x645d] = 0xb99f, [0x645e] = 0xb9a0, [0x645f] = 0xb9a1,
  [0x6460] = 0xb9a2, [0x6461] = 0xb9a3, [0x6462] = 0xb9a4, [0x6463] = 0xb9a5,
  [0x6464] = 0xb9a6, [0x6465] = 0xb9a7, [0x6466] = 0xb9a8, [0x6467] = 0xb9a9,
  [0x6468] = 0xb9aa, [0x6469] = 0xb9ab, [0x646a] = 0xb9ac, [0x646b] = 0xb9ad,
  [0x646c] = 0xb9ae, [0x646d] = 0xb9af, [0x646e] = 0xb9b0, [0x646f] = 0xb9b1,
  [0x6470] = 0xb9b2, [0x6471] = 0xb9b3, [0x6472] = 0xb9b4, [0x6473] = 0xb9b5,
  [0x6474] = 0xb9b6, [0x6475] = 0xb9b7, [0x6476] = 0xb9b8, [0x6477] = 0xb9b9,
  [0x6478] = 0xb9ba, [0x6479] = 0xb9bb, [0x647a] = 0xb9bc, [0x647b] = 0xb9bd,
  [0x647c] = 0xb9be, [0x647d] = 0xb9bf, [0x647e] = 0xb9c0, [0x647f] = 0xb9c1,
  [0x6480] = 0xb9c2, [0x6481] = 0xb9c3, [0x6482] = 0xb9c4, [0x6483] = 0xb9c5,
  [0x6484] = 0xb9c6, [0x6485] = 0xb9c7, [0x6486] = 0xb9c8, [0x6487] = 0xb9c9,
  [0x6488] = 0xb9ca, [0x6489] = 0xb9cb, [0x648a] = 0xb9cc, [0x648b] = 0xb9cd,
  [0x648c] = 0xb9ce, [0x648d] = 0xb9cf, [0x648e] = 0xb9d0, [0x648f] = 0xb9d1,
  [0x6490] = 0xb9d2, [0x6491] = 0xb9d3, [0x6492] = 0xb9d4, [0x6493] = 0xb9d5,
  [0x6494] = 0xb9d6, [0x6495] = 0xb9d7, [0x6496] = 0xb9d8, [0x6497] = 0xb9d9,
  [0x6498] = 0xb9da, [0x6499] = 0xb9db, [0x649a] = 0xb9dc, [0x649b] = 0xb9dd,
  [0x649c] = 0xb9de, [0x649d] = 0xb9df, [0x649e] = 0xb9e0, [0x649f] = 0xb9e1,
  [0x64a0] = 0xb9e2, [0x64a1] = 0xb9e3, [0x64a2] = 0xb9e4, [0x64a3] = 0xb9e5,
  [0x64a4] = 0xb9e6, [0x64a5] = 0xb9e7, [0x64a6] = 0xb9e8, [0x64a7] = 0xb9e9,
  [0x64a8] = 0xb9ea, [0x64a9] = 0xb9eb, [0x64aa] = 0xb9ec, [0x64ab] = 0xb9ed,
  [0x64ac] = 0xb9ee, [0x64ad] = 0xb9ef, [0x64ae] = 0xb9f0, [0x64af] = 0xb9f1,
  [0x64b0] = 0xb9f2, [0x64b1] = 0xb9f3, [0x64b2] = 0xb9f4, [0x64b3] = 0xb9f5,
  [0x64b4] = 0xb9f6, [0x64b5] = 0xb9f7, [0x64b6] = 0xb9f8, [0x64b7] = 0xb9f9,
  [0x64b8] = 0xb9fa, [0x64b9] = 0xb9fb, [0x64ba] = 0xb9fc, [0x64bb] = 0xb9fd,
  [0x64bc] = 0xb9fe, [0x64bd] = 0xb9ff, [0x64be] = 0xba00, [0x64bf] = 0xba01,
  [0x64c0] = 0xba02, [0x64c1] = 0xba03, [0x64c2] = 0xba04, [0x64c3] = 0xba05,
  [0x64c4] = 0xba06, [0x64c5] = 0xba07, [0x64c6] = 0xba08, [0x64c7] = 0xba09,
  [0x64c8] = 0xba0a, [0x64c9] = 0xba0b, [0x64ca] = 0xba0c, [0x64cb] = 0xba0d,
  [0x64cc] = 0xba0e, [0x64cd] = 0xba0f, [0x64ce] = 0xba10, [0x64cf] = 0xba11,
  [0x64d0] = 0xba12, [0x64d1] = 0xba13, [0x64d2] = 0xba14, [0x64d3] = 0xba15,
  [0x64d4] = 0xba16, [0x64d5] = 0xba17, [0x64d6] = 0xba18, [0x64d7] = 0xba19,
  [0x64d8] = 0xba1a, [0x64d9] = 0xba1b, [0x64da] = 0xba1c, [0x64db] = 0xba1d,
  [0x64dc] = 0xba1e, [0x64dd] = 0xba1f, [0x64de] = 0xba20, [0x64df] = 0xba21,
  [0x64e0] = 0xba22, [0x64e1] = 0xba23, [0x64e2] = 0xba24, [0x64e3] = 0xba25,
  [0x64e4] = 0xba26, [0x64e5] = 0xba27, [0x64e6] = 0xba28, [0x64e7] = 0xba29,
  [0x64e8] = 0xba2a, [0x64e9] = 0xba2b, [0x64ea] = 0xba2c, [0x64eb] = 0xba2d,
  [0x64ec] = 0xba2e, [0x64ed] = 0xba2f, [0x64ee] = 0xba30, [0x64ef] = 0xba31,
  [0x64f0] = 0xba32, [0x64f1] = 0xba33, [0x64f2] = 0xba34, [0x64f3] = 0xba35,
  [0x64f4] = 0xba36, [0x64f5] = 0xba37, [0x64f6] = 0xba38, [0x64f7] = 0xba39,
  [0x64f8] = 0xba3a, [0x64f9] = 0xba3b, [0x64fa] = 0xba3c, [0x64fb] = 0xba3d,
  [0x64fc] = 0xba3e, [0x64fd] = 0xba3f, [0x64fe] = 0xba40, [0x64ff] = 0xba41,
  [0x6500] = 0xba42, [0x6501] = 0xba43, [0x6502] = 0xba44, [0x6503] = 0xba45,
  [0x6504] = 0xba46, [0x6505] = 0xba47, [0x6506] = 0xba48, [0x6507] = 0xba49,
  [0x6508] = 0xba4a, [0x6509] = 0xba4b, [0x650a] = 0xba4c, [0x650b] = 0xba4d,
  [0x650c] = 0xba4e, [0x650d] = 0xba4f, [0x650e] = 0xba50, [0x650f] = 0xba51,
  [0x6510] = 0xba52, [0x6511] = 0xba53, [0x6512] = 0xba54, [0x6513] = 0xba55,
  [0x6514] = 0xba56, [0x6515] = 0xba57, [0x6516] = 0xba58, [0x6517] = 0xba59,
  [0x6518] = 0xba5a, [0x6519] = 0xba5b, [0x651a] = 0xba5c, [0x651b] = 0xba5d,
  [0x651c] = 0xba5e, [0x651d] = 0xba5f, [0x651e] = 0xba60, [0x651f] = 0xba61,
  [0x6520] = 0xba62, [0x6521] = 0xba63, [0x6522] = 0xba64, [0x6523] = 0xba65,
  [0x6524] = 0xba66, [0x6525] = 0xba67, [0x6526] = 0xba68, [0x6527] = 0xba69,
  [0x6528] = 0xba6a, [0x6529] = 0xba6b, [0x652a] = 0xba6c, [0x652b] = 0xba6d,
  [0x652c] = 0xba6e, [0x652d] = 0xba6f, [0x652e] = 0xba70, [0x652f] = 0xba71,
  [0x6530] = 0xba72, [0x6531] = 0xba73, [0x6532] = 0xba74, [0x6533] = 0xba75,
  [0x6534] = 0xba76, [0x6535] = 0xba77, [0x6536] = 0xba78, [0x6537] = 0xba79,
  [0x6538] = 0xba7a, [0x6539] = 0xba7b, [0x653a] = 0xba7c, [0x653b] = 0xba7d,
  [0x653c] = 0xba7e, [0x653d] = 0xba7f, [0x653e] = 0xba80, [0x653f] = 0xba81,
  [0x6540] = 0xba82, [0x6541] = 0xba83, [0x6542] = 0xba84, [0x6543] = 0xba85,
  [0x6544] = 0xba86, [0x6545] = 0xba87, [0x6546] = 0xba88, [0x6547] = 0xba89,
  [0x6548] = 0xba8a, [0x6549] = 0xba8b, [0x654a] = 0xba8c, [0x654b] = 0xba8d,
  [0x654c] = 0xba8e, [0x654d] = 0xba8f, [0x654e] = 0xba90, [0x654f] = 0xba91,
  [0x6550] = 0xba92, [0x6551] = 0xba93, [0x6552] = 0xba94, [0x6553] = 0xba95,
  [0x6554] = 0xba96, [0x6555] = 0xba97, [0x6556] = 0xba98, [0x6557] = 0xba99,
  [0x6558] = 0xba9a, [0x6559] = 0xba9b, [0x655a] = 0xba9c, [0x655b] = 0xba9d,
  [0x655c] = 0xba9e, [0x655d] = 0xba9f, [0x655e] = 0xbaa0, [0x655f] = 0xbaa1,
  [0x6560] = 0xbaa2, [0x6561] = 0xbaa3, [0x6562] = 0xbaa4, [0x6563] = 0xbaa5,
  [0x6564] = 0xbaa6, [0x6565] = 0xbaa7, [0x6566] = 0xbaa8, [0x6567] = 0xbaa9,
  [0x6568] = 0xbaaa, [0x6569] = 0xbaab, [0x656a] = 0xbaac, [0x656b] = 0xbaad,
  [0x656c] = 0xbaae, [0x656d] = 0xbaaf, [0x656e] = 0xbab0, [0x656f] = 0xbab1,
  [0x6570] = 0xbab2, [0x6571] = 0xbab3, [0x6572] = 0xbab4, [0x6573] = 0xbab5,
  [0x6574] = 0xbab6, [0x6575] = 0xbab7, [0x6576] = 0xbab8, [0x6577] = 0xbab9,
  [0x6578] = 0xbaba, [0x6579] = 0xbabb, [0x657a] = 0xbabc, [0x657b] = 0xbabd,
  [0x657c] = 0xbabe, [0x657d] = 0xbabf, [0x657e] = 0xbac0, [0x657f] = 0xbac1,
  [0x6580] = 0xbac2, [0x6581] = 0xbac3, [0x6582] = 0xbac4, [0x6583] = 0xbac5,
  [0x6584] = 0xbac6, [0x6585] = 0xbac7, [0x6586] = 0xbac8, [0x6587] = 0xbac9,
  [0x6588] = 0xbaca, [0x6589] = 0xbacb, [0x658a] = 0xbacc, [0x658b] = 0xbacd,
  [0x658c] = 0xbace, [0x658d] = 0xbacf, [0x658e] = 0xbad0, [0x658f] = 0xbad1,
  [0x6590] = 0xbad2, [0x6591] = 0xbad3, [0x6592] = 0xbad4, [0x6593] = 0xbad5,
  [0x6594] = 0xbad6, [0x6595] = 0xbad7, [0x6596] = 0xbad8, [0x6597] = 0xbad9,
  [0x6598] = 0xbada, [0x6599] = 0xbadb, [0x659a] = 0xbadc, [0x659b] = 0xbadd,
  [0x659c] = 0xbade, [0x659d] = 0xbadf, [0x659e] = 0xbae0, [0x659f] = 0xbae1,
  [0x65a0] = 0xbae2, [0x65a1] = 0xbae3, [0x65a2] = 0xbae4, [0x65a3] = 0xbae5,
  [0x65a4] = 0xbae6, [0x65a5] = 0xbae7, [0x65a6] = 0xbae8, [0x65a7] = 0xbae9,
  [0x65a8] = 0xbaea, [0x65a9] = 0xbaeb, [0x65aa] = 0xbaec, [0x65ab] = 0xbaed,
  [0x65ac] = 0xbaee, [0x65ad] = 0xbaef, [0x65ae] = 0xbaf0, [0x65af] = 0xbaf1,
  [0x65b0] = 0xbaf2, [0x65b1] = 0xbaf3, [0x65b2] = 0xbaf4, [0x65b3] = 0xbaf5,
  [0x65b4] = 0xbaf6, [0x65b5] = 0xbaf7, [0x65b6] = 0xbaf8, [0x65b7] = 0xbaf9,
  [0x65b8] = 0xbafa, [0x65b9] = 0xbafb, [0x65ba] = 0xbafc, [0x65bb] = 0xbafd,
  [0x65bc] = 0xbafe, [0x65bd] = 0xbaff, [0x65be] = 0xbb00, [0x65bf] = 0xbb01,
  [0x65c0] = 0xbb02, [0x65c1] = 0xbb03, [0x65c2] = 0xbb04, [0x65c3] = 0xbb05,
  [0x65c4] = 0xbb06, [0x65c5] = 0xbb07, [0x65c6] = 0xbb08, [0x65c7] = 0xbb09,
  [0x65c8] = 0xbb0a, [0x65c9] = 0xbb0b, [0x65ca] = 0xbb0c, [0x65cb] = 0xbb0d,
  [0x65cc] = 0xbb0e, [0x65cd] = 0xbb0f, [0x65ce] = 0xbb10, [0x65cf] = 0xbb11,
  [0x65d0] = 0xbb12, [0x65d1] = 0xbb13, [0x65d2] = 0xbb14, [0x65d3] = 0xbb15,
  [0x65d4] = 0xbb16, [0x65d5] = 0xbb17, [0x65d6] = 0xbb18, [0x65d7] = 0xbb19,
  [0x65d8] = 0xbb1a, [0x65d9] = 0xbb1b, [0x65da] = 0xbb1c, [0x65db] = 0xbb1d,
  [0x65dc] = 0xbb1e, [0x65dd] = 0xbb1f, [0x65de] = 0xbb20, [0x65df] = 0xbb21,
  [0x65e0] = 0xbb22, [0x65e1] = 0xbb23, [0x65e2] = 0xbb24, [0x65e3] = 0xbb25,
  [0x65e4] = 0xbb26, [0x65e5] = 0xbb27, [0x65e6] = 0xbb28, [0x65e7] = 0xbb29,
  [0x65e8] = 0xbb2a, [0x65e9] = 0xbb2b, [0x65ea] = 0xbb2c, [0x65eb] = 0xbb2d,
  [0x65ec] = 0xbb2e, [0x65ed] = 0xbb2f, [0x65ee] = 0xbb30, [0x65ef] = 0xbb31,
  [0x65f0] = 0xbb32, [0x65f1] = 0xbb33, [0x65f2] = 0xbb34, [0x65f3] = 0xbb35,
  [0x65f4] = 0xbb36, [0x65f5] = 0xbb37, [0x65f6] = 0xbb38, [0x65f7] = 0xbb39,
  [0x65f8] = 0xbb3a, [0x65f9] = 0xbb3b, [0x65fa] = 0xbb3c, [0x65fb] = 0xbb3d,
  [0x65fc] = 0xbb3e, [0x65fd] = 0xbb3f, [0x65fe] = 0xbb40, [0x65ff] = 0xbb41,
  [0x6600] = 0xbb42, [0x6601] = 0xbb43, [0x6602] = 0xbb44, [0x6603] = 0xbb45,
  [0x6604] = 0xbb46, [0x6605] = 0xbb47, [0x6606] = 0xbb48, [0x6607] = 0xbb49,
  [0x6608] = 0xbb4a, [0x6609] = 0xbb4b, [0x660a] = 0xbb4c, [0x660b] = 0xbb4d,
  [0x660c] = 0xbb4e, [0x660d] = 0xbb4f, [0x660e] = 0xbb50, [0x660f] = 0xbb51,
  [0x6610] = 0xbb52, [0x6611] = 0xbb53, [0x6612] = 0xbb54, [0x6613] = 0xbb55,
  [0x6614] = 0xbb56, [0x6615] = 0xbb57, [0x6616] = 0xbb58, [0x6617] = 0xbb59,
  [0x6618] = 0xbb5a, [0x6619] = 0xbb5b, [0x661a] = 0xbb5c, [0x661b] = 0xbb5d,
  [0x661c] = 0xbb5e, [0x661d] = 0xbb5f, [0x661e] = 0xbb60, [0x661f] = 0xbb61,
  [0x6620] = 0xbb62, [0x6621] = 0xbb63, [0x6622] = 0xbb64, [0x6623] = 0xbb65,
  [0x6624] = 0xbb66, [0x6625] = 0xbb67, [0x6626] = 0xbb68, [0x6627] = 0xbb69,
  [0x6628] = 0xbb6a, [0x6629] = 0xbb6b, [0x662a] = 0xbb6c, [0x662b] = 0xbb6d,
  [0x662c] = 0xbb6e, [0x662d] = 0xbb6f, [0x662e] = 0xbb70, [0x662f] = 0xbb71,
  [0x6630] = 0xbb72, [0x6631] = 0xbb73, [0x6632] = 0xbb74, [0x6633] = 0xbb75,
  [0x6634] = 0xbb76, [0x6635] = 0xbb77, [0x6636] = 0xbb78, [0x6637] = 0xbb79,
  [0x6638] = 0xbb7a, [0x6639] = 0xbb7b, [0x663a] = 0xbb7c, [0x663b] = 0xbb7d,
  [0x663c] = 0xbb7e, [0x663d] = 0xbb7f, [0x663e] = 0xbb80, [0x663f] = 0xbb81,
  [0x6640] = 0xbb82, [0x6641] = 0xbb83, [0x6642] = 0xbb84, [0x6643] = 0xbb85,
  [0x6644] = 0xbb86, [0x6645] = 0xbb87, [0x6646] = 0xbb88, [0x6647] = 0xbb89,
  [0x6648] = 0xbb8a, [0x6649] = 0xbb8b, [0x664a] = 0xbb8c, [0x664b] = 0xbb8d,
  [0x664c] = 0xbb8e, [0x664d] = 0xbb8f, [0x664e] = 0xbb90, [0x664f] = 0xbb91,
  [0x6650] = 0xbb92, [0x6651] = 0xbb93, [0x6652] = 0xbb94, [0x6653] = 0xbb95,
  [0x6654] = 0xbb96, [0x6655] = 0xbb97, [0x6656] = 0xbb98, [0x6657] = 0xbb99,
  [0x6658] = 0xbb9a, [0x6659] = 0xbb9b, [0x665a] = 0xbb9c, [0x665b] = 0xbb9d,
  [0x665c] = 0xbb9e, [0x665d] = 0xbb9f, [0x665e] = 0xbba0, [0x665f] = 0xbba1,
  [0x6660] = 0xbba2, [0x6661] = 0xbba3, [0x6662] = 0xbba4, [0x6663] = 0xbba5,
  [0x6664] = 0xbba6, [0x6665] = 0xbba7, [0x6666] = 0xbba8, [0x6667] = 0xbba9,
  [0x6668] = 0xbbaa, [0x6669] = 0xbbab, [0x666a] = 0xbbac, [0x666b] = 0xbbad,
  [0x666c] = 0xbbae, [0x666d] = 0xbbaf, [0x666e] = 0xbbb0, [0x666f] = 0xbbb1,
  [0x6670] = 0xbbb2, [0x6671] = 0xbbb3, [0x6672] = 0xbbb4, [0x6673] = 0xbbb5,
  [0x6674] = 0xbbb6, [0x6675] = 0xbbb7, [0x6676] = 0xbbb8, [0x6677] = 0xbbb9,
  [0x6678] = 0xbbba, [0x6679] = 0xbbbb, [0x667a] = 0xbbbc, [0x667b] = 0xbbbd,
  [0x667c] = 0xbbbe, [0x667d] = 0xbbbf, [0x667e] = 0xbbc0, [0x667f] = 0xbbc1,
  [0x6680] = 0xbbc2, [0x6681] = 0xbbc3, [0x6682] = 0xbbc4, [0x6683] = 0xbbc5,
  [0x6684] = 0xbbc6, [0x6685] = 0xbbc7, [0x6686] = 0xbbc8, [0x6687] = 0xbbc9,
  [0x6688] = 0xbbca, [0x6689] = 0xbbcb, [0x668a] = 0xbbcc, [0x668b] = 0xbbcd,
  [0x668c] = 0xbbce, [0x668d] = 0xbbcf, [0x668e] = 0xbbd0, [0x668f] = 0xbbd1,
  [0x6690] = 0xbbd2, [0x6691] = 0xbbd3, [0x6692] = 0xbbd4, [0x6693] = 0xbbd5,
  [0x6694] = 0xbbd6, [0x6695] = 0xbbd7, [0x6696] = 0xbbd8, [0x6697] = 0xbbd9,
  [0x6698] = 0xbbda, [0x6699] = 0xbbdb, [0x669a] = 0xbbdc, [0x669b] = 0xbbdd,
  [0x669c] = 0xbbde, [0x669d] = 0xbbdf, [0x669e] = 0xbbe0, [0x669f] = 0xbbe1,
  [0x66a0] = 0xbbe2, [0x66a1] = 0xbbe3, [0x66a2] = 0xbbe4, [0x66a3] = 0xbbe5,
  [0x66a4] = 0xbbe6, [0x66a5] = 0xbbe7, [0x66a6] = 0xbbe8, [0x66a7] = 0xbbe9,
  [0x66a8] = 0xbbea, [0x66a9] = 0xbbeb, [0x66aa] = 0xbbec, [0x66ab] = 0xbbed,
  [0x66ac] = 0xbbee, [0x66ad] = 0xbbef, [0x66ae] = 0xbbf0, [0x66af] = 0xbbf1,
  [0x66b0] = 0xbbf2, [0x66b1] = 0xbbf3, [0x66b2] = 0xbbf4, [0x66b3] = 0xbbf5,
  [0x66b4] = 0xbbf6, [0x66b5] = 0xbbf7, [0x66b6] = 0xbbf8, [0x66b7] = 0xbbf9,
  [0x66b8] = 0xbbfa, [0x66b9] = 0xbbfb, [0x66ba] = 0xbbfc, [0x66bb] = 0xbbfd,
  [0x66bc] = 0xbbfe, [0x66bd] = 0xbbff, [0x66be] = 0xbc00, [0x66bf] = 0xbc01,
  [0x66c0] = 0xbc02, [0x66c1] = 0xbc03, [0x66c2] = 0xbc04, [0x66c3] = 0xbc05,
  [0x66c4] = 0xbc06, [0x66c5] = 0xbc07, [0x66c6] = 0xbc08, [0x66c7] = 0xbc09,
  [0x66c8] = 0xbc0a, [0x66c9] = 0xbc0b, [0x66ca] = 0xbc0c, [0x66cb] = 0xbc0d,
  [0x66cc] = 0xbc0e, [0x66cd] = 0xbc0f, [0x66ce] = 0xbc10, [0x66cf] = 0xbc11,
  [0x66d0] = 0xbc12, [0x66d1] = 0xbc13, [0x66d2] = 0xbc14, [0x66d3] = 0xbc15,
  [0x66d4] = 0xbc16, [0x66d5] = 0xbc17, [0x66d6] = 0xbc18, [0x66d7] = 0xbc19,
  [0x66d8] = 0xbc1a, [0x66d9] = 0xbc1b, [0x66da] = 0xbc1c, [0x66db] = 0xbc1d,
  [0x66dc] = 0xbc1e, [0x66dd] = 0xbc1f, [0x66de] = 0xbc20, [0x66df] = 0xbc21,
  [0x66e0] = 0xbc22, [0x66e1] = 0xbc23, [0x66e2] = 0xbc24, [0x66e3] = 0xbc25,
  [0x66e4] = 0xbc26, [0x66e5] = 0xbc27, [0x66e6] = 0xbc28, [0x66e7] = 0xbc29,
  [0x66e8] = 0xbc2a, [0x66e9] = 0xbc2b, [0x66ea] = 0xbc2c, [0x66eb] = 0xbc2d,
  [0x66ec] = 0xbc2e, [0x66ed] = 0xbc2f, [0x66ee] = 0xbc30, [0x66ef] = 0xbc31,
  [0x66f0] = 0xbc32, [0x66f1] = 0xbc33, [0x66f2] = 0xbc34, [0x66f3] = 0xbc35,
  [0x66f4] = 0xbc36, [0x66f5] = 0xbc37, [0x66f6] = 0xbc38, [0x66f7] = 0xbc39,
  [0x66f8] = 0xbc3a, [0x66f9] = 0xbc3b, [0x66fa] = 0xbc3c, [0x66fb] = 0xbc3d,
  [0x66fc] = 0xbc3e, [0x66fd] = 0xbc3f, [0x66fe] = 0xbc40, [0x66ff] = 0xbc41,
  [0x6700] = 0xbc42, [0x6701] = 0xbc43, [0x6702] = 0xbc44, [0x6703] = 0xbc45,
  [0x6704] = 0xbc46, [0x6705] = 0xbc47, [0x6706] = 0xbc48, [0x6707] = 0xbc49,
  [0x6708] = 0xbc4a, [0x6709] = 0xbc4b, [0x670a] = 0xbc4c, [0x670b] = 0xbc4d,
  [0x670c] = 0xbc4e, [0x670d] = 0xbc4f, [0x670e] = 0xbc50, [0x670f] = 0xbc51,
  [0x6710] = 0xbc52, [0x6711] = 0xbc53, [0x6712] = 0xbc54, [0x6713] = 0xbc55,
  [0x6714] = 0xbc56, [0x6715] = 0xbc57, [0x6716] = 0xbc58, [0x6717] = 0xbc59,
  [0x6718] = 0xbc5a, [0x6719] = 0xbc5b, [0x671a] = 0xbc5c, [0x671b] = 0xbc5d,
  [0x671c] = 0xbc5e, [0x671d] = 0xbc5f, [0x671e] = 0xbc60, [0x671f] = 0xbc61,
  [0x6720] = 0xbc62, [0x6721] = 0xbc63, [0x6722] = 0xbc64, [0x6723] = 0xbc65,
  [0x6724] = 0xbc66, [0x6725] = 0xbc67, [0x6726] = 0xbc68, [0x6727] = 0xbc69,
  [0x6728] = 0xbc6a, [0x6729] = 0xbc6b, [0x672a] = 0xbc6c, [0x672b] = 0xbc6d,
  [0x672c] = 0xbc6e, [0x672d] = 0xbc6f, [0x672e] = 0xbc70, [0x672f] = 0xbc71,
  [0x6730] = 0xbc72, [0x6731] = 0xbc73, [0x6732] = 0xbc74, [0x6733] = 0xbc75,
  [0x6734] = 0xbc76, [0x6735] = 0xbc77, [0x6736] = 0xbc78, [0x6737] = 0xbc79,
  [0x6738] = 0xbc7a, [0x6739] = 0xbc7b, [0x673a] = 0xbc7c, [0x673b] = 0xbc7d,
  [0x673c] = 0xbc7e, [0x673d] = 0xbc7f, [0x673e] = 0xbc80, [0x673f] = 0xbc81,
  [0x6740] = 0xbc82, [0x6741] = 0xbc83, [0x6742] = 0xbc84, [0x6743] = 0xbc85,
  [0x6744] = 0xbc86, [0x6745] = 0xbc87, [0x6746] = 0xbc88, [0x6747] = 0xbc89,
  [0x6748] = 0xbc8a, [0x6749] = 0xbc8b, [0x674a] = 0xbc8c, [0x674b] = 0xbc8d,
  [0x674c] = 0xbc8e, [0x674d] = 0xbc8f, [0x674e] = 0xbc90, [0x674f] = 0xbc91,
  [0x6750] = 0xbc92, [0x6751] = 0xbc93, [0x6752] = 0xbc94, [0x6753] = 0xbc95,
  [0x6754] = 0xbc96, [0x6755] = 0xbc97, [0x6756] = 0xbc98, [0x6757] = 0xbc99,
  [0x6758] = 0xbc9a, [0x6759] = 0xbc9b, [0x675a] = 0xbc9c, [0x675b] = 0xbc9d,
  [0x675c] = 0xbc9e, [0x675d] = 0xbc9f, [0x675e] = 0xbca0, [0x675f] = 0xbca1,
  [0x6760] = 0xbca2, [0x6761] = 0xbca3, [0x6762] = 0xbca4, [0x6763] = 0xbca5,
  [0x6764] = 0xbca6, [0x6765] = 0xbca7, [0x6766] = 0xbca8, [0x6767] = 0xbca9,
  [0x6768] = 0xbcaa, [0x6769] = 0xbcab, [0x676a] = 0xbcac, [0x676b] = 0xbcad,
  [0x676c] = 0xbcae, [0x676d] = 0xbcaf, [0x676e] = 0xbcb0, [0x676f] = 0xbcb1,
  [0x6770] = 0xbcb2, [0x6771] = 0xbcb3, [0x6772] = 0xbcb4, [0x6773] = 0xbcb5,
  [0x6774] = 0xbcb6, [0x6775] = 0xbcb7, [0x6776] = 0xbcb8, [0x6777] = 0xbcb9,
  [0x6778] = 0xbcba, [0x6779] = 0xbcbb, [0x677a] = 0xbcbc, [0x677b] = 0xbcbd,
  [0x677c] = 0xbcbe, [0x677d] = 0xbcbf, [0x677e] = 0xbcc0, [0x677f] = 0xbcc1,
  [0x6780] = 0xbcc2, [0x6781] = 0xbcc3, [0x6782] = 0xbcc4, [0x6783] = 0xbcc5,
  [0x6784] = 0xbcc6, [0x6785] = 0xbcc7, [0x6786] = 0xbcc8, [0x6787] = 0xbcc9,
  [0x6788] = 0xbcca, [0x6789] = 0xbccb, [0x678a] = 0xbccc, [0x678b] = 0xbccd,
  [0x678c] = 0xbcce, [0x678d] = 0xbccf, [0x678e] = 0xbcd0, [0x678f] = 0xbcd1,
  [0x6790] = 0xbcd2, [0x6791] = 0xbcd3, [0x6792] = 0xbcd4, [0x6793] = 0xbcd5,
  [0x6794] = 0xbcd6, [0x6795] = 0xbcd7, [0x6796] = 0xbcd8, [0x6797] = 0xbcd9,
  [0x6798] = 0xbcda, [0x6799] = 0xbcdb, [0x679a] = 0xbcdc, [0x679b] = 0xbcdd,
  [0x679c] = 0xbcde, [0x679d] = 0xbcdf, [0x679e] = 0xbce0, [0x679f] = 0xbce1,
  [0x67a0] = 0xbce2, [0x67a1] = 0xbce3, [0x67a2] = 0xbce4, [0x67a3] = 0xbce5,
  [0x67a4] = 0xbce6, [0x67a5] = 0xbce7, [0x67a6] = 0xbce8, [0x67a7] = 0xbce9,
  [0x67a8] = 0xbcea, [0x67a9] = 0xbceb, [0x67aa] = 0xbcec, [0x67ab] = 0xbced,
  [0x67ac] = 0xbcee, [0x67ad] = 0xbcef, [0x67ae] = 0xbcf0, [0x67af] = 0xbcf1,
  [0x67b0] = 0xbcf2, [0x67b1] = 0xbcf3, [0x67b2] = 0xbcf4, [0x67b3] = 0xbcf5,
  [0x67b4] = 0xbcf6, [0x67b5] = 0xbcf7, [0x67b6] = 0xbcf8, [0x67b7] = 0xbcf9,
  [0x67b8] = 0xbcfa, [0x67b9] = 0xbcfb, [0x67ba] = 0xbcfc, [0x67bb] = 0xbcfd,
  [0x67bc] = 0xbcfe, [0x67bd] = 0xbcff, [0x67be] = 0xbd00, [0x67bf] = 0xbd01,
  [0x67c0] = 0xbd02, [0x67c1] = 0xbd03, [0x67c2] = 0xbd04, [0x67c3] = 0xbd05,
  [0x67c4] = 0xbd06, [0x67c5] = 0xbd07, [0x67c6] = 0xbd08, [0x67c7] = 0xbd09,
  [0x67c8] = 0xbd0a, [0x67c9] = 0xbd0b, [0x67ca] = 0xbd0c, [0x67cb] = 0xbd0d,
  [0x67cc] = 0xbd0e, [0x67cd] = 0xbd0f, [0x67ce] = 0xbd10, [0x67cf] = 0xbd11,
  [0x67d0] = 0xbd12, [0x67d1] = 0xbd13, [0x67d2] = 0xbd14, [0x67d3] = 0xbd15,
  [0x67d4] = 0xbd16, [0x67d5] = 0xbd17, [0x67d6] = 0xbd18, [0x67d7] = 0xbd19,
  [0x67d8] = 0xbd1a, [0x67d9] = 0xbd1b, [0x67da] = 0xbd1c, [0x67db] = 0xbd1d,
  [0x67dc] = 0xbd1e, [0x67dd] = 0xbd1f, [0x67de] = 0xbd20, [0x67df] = 0xbd21,
  [0x67e0] = 0xbd22, [0x67e1] = 0xbd23, [0x67e2] = 0xbd24, [0x67e3] = 0xbd25,
  [0x67e4] = 0xbd26, [0x67e5] = 0xbd27, [0x67e6] = 0xbd28, [0x67e7] = 0xbd29,
  [0x67e8] = 0xbd2a, [0x67e9] = 0xbd2b, [0x67ea] = 0xbd2c, [0x67eb] = 0xbd2d,
  [0x67ec] = 0xbd2e, [0x67ed] = 0xbd2f, [0x67ee] = 0xbd30, [0x67ef] = 0xbd31,
  [0x67f0] = 0xbd32, [0x67f1] = 0xbd33, [0x67f2] = 0xbd34, [0x67f3] = 0xbd35,
  [0x67f4] = 0xbd36, [0x67f5] = 0xbd37, [0x67f6] = 0xbd38, [0x67f7] = 0xbd39,
  [0x67f8] = 0xbd3a, [0x67f9] = 0xbd3b, [0x67fa] = 0xbd3c, [0x67fb] = 0xbd3d,
  [0x67fc] = 0xbd3e, [0x67fd] = 0xbd3f, [0x67fe] = 0xbd40, [0x67ff] = 0xbd41,
  [0x6800] = 0xbd42, [0x6801] = 0xbd43, [0x6802] = 0xbd44, [0x6803] = 0xbd45,
  [0x6804] = 0xbd46, [0x6805] = 0xbd47, [0x6806] = 0xbd48, [0x6807] = 0xbd49,
  [0x6808] = 0xbd4a, [0x6809] = 0xbd4b, [0x680a] = 0xbd4c, [0x680b] = 0xbd4d,
  [0x680c] = 0xbd4e, [0x680d] = 0xbd4f, [0x680e] = 0xbd50, [0x680f] = 0xbd51,
  [0x6810] = 0xbd52, [0x6811] = 0xbd53, [0x6812] = 0xbd54, [0x6813] = 0xbd55,
  [0x6814] = 0xbd56, [0x6815] = 0xbd57, [0x6816] = 0xbd58, [0x6817] = 0xbd59,
  [0x6818] = 0xbd5a, [0x6819] = 0xbd5b, [0x681a] = 0xbd5c, [0x681b] = 0xbd5d,
  [0x681c] = 0xbd5e, [0x681d] = 0xbd5f, [0x681e] = 0xbd60, [0x681f] = 0xbd61,
  [0x6820] = 0xbd62, [0x6821] = 0xbd63, [0x6822] = 0xbd64, [0x6823] = 0xbd65,
  [0x6824] = 0xbd66, [0x6825] = 0xbd67, [0x6826] = 0xbd68, [0x6827] = 0xbd69,
  [0x6828] = 0xbd6a, [0x6829] = 0xbd6b, [0x682a] = 0xbd6c, [0x682b] = 0xbd6d,
  [0x682c] = 0xbd6e, [0x682d] = 0xbd6f, [0x682e] = 0xbd70, [0x682f] = 0xbd71,
  [0x6830] = 0xbd72, [0x6831] = 0xbd73, [0x6832] = 0xbd74, [0x6833] = 0xbd75,
  [0x6834] = 0xbd76, [0x6835] = 0xbd77, [0x6836] = 0xbd78, [0x6837] = 0xbd79,
  [0x6838] = 0xbd7a, [0x6839] = 0xbd7b, [0x683a] = 0xbd7c, [0x683b] = 0xbd7d,
  [0x683c] = 0xbd7e, [0x683d] = 0xbd7f, [0x683e] = 0xbd80, [0x683f] = 0xbd81,
  [0x6840] = 0xbd82, [0x6841] = 0xbd83, [0x6842] = 0xbd84, [0x6843] = 0xbd85,
  [0x6844] = 0xbd86, [0x6845] = 0xbd87, [0x6846] = 0xbd88, [0x6847] = 0xbd89,
  [0x6848] = 0xbd8a, [0x6849] = 0xbd8b, [0x684a] = 0xbd8c, [0x684b] = 0xbd8d,
  [0x684c] = 0xbd8e, [0x684d] = 0xbd8f, [0x684e] = 0xbd90, [0x684f] = 0xbd91,
  [0x6850] = 0xbd92, [0x6851] = 0xbd93, [0x6852] = 0xbd94, [0x6853] = 0xbd95,
  [0x6854] = 0xbd96, [0x6855] = 0xbd97, [0x6856] = 0xbd98, [0x6857] = 0xbd99,
  [0x6858] = 0xbd9a, [0x6859] = 0xbd9b, [0x685a] = 0xbd9c, [0x685b] = 0xbd9d,
  [0x685c] = 0xbd9e, [0x685d] = 0xbd9f, [0x685e] = 0xbda0, [0x685f] = 0xbda1,
  [0x6860] = 0xbda2, [0x6861] = 0xbda3, [0x6862] = 0xbda4, [0x6863] = 0xbda5,
  [0x6864] = 0xbda6, [0x6865] = 0xbda7, [0x6866] = 0xbda8, [0x6867] = 0xbda9,
  [0x6868] = 0xbdaa, [0x6869] = 0xbdab, [0x686a] = 0xbdac, [0x686b] = 0xbdad,
  [0x686c] = 0xbdae, [0x686d] = 0xbdaf, [0x686e] = 0xbdb0, [0x686f] = 0xbdb1,
  [0x6870] = 0xbdb2, [0x6871] = 0xbdb3, [0x6872] = 0xbdb4, [0x6873] = 0xbdb5,
  [0x6874] = 0xbdb6, [0x6875] = 0xbdb7, [0x6876] = 0xbdb8, [0x6877] = 0xbdb9,
  [0x6878] = 0xbdba, [0x6879] = 0xbdbb, [0x687a] = 0xbdbc, [0x687b] = 0xbdbd,
  [0x687c] = 0xbdbe, [0x687d] = 0xbdbf, [0x687e] = 0xbdc0, [0x687f] = 0xbdc1,
  [0x6880] = 0xbdc2, [0x6881] = 0xbdc3, [0x6882] = 0xbdc4, [0x6883] = 0xbdc5,
  [0x6884] = 0xbdc6, [0x6885] = 0xbdc7, [0x6886] = 0xbdc8, [0x6887] = 0xbdc9,
  [0x6888] = 0xbdca, [0x6889] = 0xbdcb, [0x688a] = 0xbdcc, [0x688b] = 0xbdcd,
  [0x688c] = 0xbdce, [0x688d] = 0xbdcf, [0x688e] = 0xbdd0, [0x688f] = 0xbdd1,
  [0x6890] = 0xbdd2, [0x6891] = 0xbdd3, [0x6892] = 0xbdd4, [0x6893] = 0xbdd5,
  [0x6894] = 0xbdd6, [0x6895] = 0xbdd7, [0x6896] = 0xbdd8, [0x6897] = 0xbdd9,
  [0x6898] = 0xbdda, [0x6899] = 0xbddb, [0x689a] = 0xbddc, [0x689b] = 0xbddd,
  [0x689c] = 0xbdde, [0x689d] = 0xbddf, [0x689e] = 0xbde0, [0x689f] = 0xbde1,
  [0x68a0] = 0xbde2, [0x68a1] = 0xbde3, [0x68a2] = 0xbde4, [0x68a3] = 0xbde5,
  [0x68a4] = 0xbde6, [0x68a5] = 0xbde7, [0x68a6] = 0xbde8, [0x68a7] = 0xbde9,
  [0x68a8] = 0xbdea, [0x68a9] = 0xbdeb, [0x68aa] = 0xbdec, [0x68ab] = 0xbded,
  [0x68ac] = 0xbdee, [0x68ad] = 0xbdef, [0x68ae] = 0xbdf0, [0x68af] = 0xbdf1,
  [0x68b0] = 0xbdf2, [0x68b1] = 0xbdf3, [0x68b2] = 0xbdf4, [0x68b3] = 0xbdf5,
  [0x68b4] = 0xbdf6, [0x68b5] = 0xbdf7, [0x68b6] = 0xbdf8, [0x68b7] = 0xbdf9,
  [0x68b8] = 0xbdfa, [0x68b9] = 0xbdfb, [0x68ba] = 0xbdfc, [0x68bb] = 0xbdfd,
  [0x68bc] = 0xbdfe, [0x68bd] = 0xbdff, [0x68be] = 0xbe00, [0x68bf] = 0xbe01,
  [0x68c0] = 0xbe02, [0x68c1] = 0xbe03, [0x68c2] = 0xbe04, [0x68c3] = 0xbe05,
  [0x68c4] = 0xbe06, [0x68c5] = 0xbe07, [0x68c6] = 0xbe08, [0x68c7] = 0xbe09,
  [0x68c8] = 0xbe0a, [0x68c9] = 0xbe0b, [0x68ca] = 0xbe0c, [0x68cb] = 0xbe0d,
  [0x68cc] = 0xbe0e, [0x68cd] = 0xbe0f, [0x68ce] = 0xbe10, [0x68cf] = 0xbe11,
  [0x68d0] = 0xbe12, [0x68d1] = 0xbe13, [0x68d2] = 0xbe14, [0x68d3] = 0xbe15,
  [0x68d4] = 0xbe16, [0x68d5] = 0xbe17, [0x68d6] = 0xbe18, [0x68d7] = 0xbe19,
  [0x68d8] = 0xbe1a, [0x68d9] = 0xbe1b, [0x68da] = 0xbe1c, [0x68db] = 0xbe1d,
  [0x68dc] = 0xbe1e, [0x68dd] = 0xbe1f, [0x68de] = 0xbe20, [0x68df] = 0xbe21,
  [0x68e0] = 0xbe22, [0x68e1] = 0xbe23, [0x68e2] = 0xbe24, [0x68e3] = 0xbe25,
  [0x68e4] = 0xbe26, [0x68e5] = 0xbe27, [0x68e6] = 0xbe28, [0x68e7] = 0xbe29,
  [0x68e8] = 0xbe2a, [0x68e9] = 0xbe2b, [0x68ea] = 0xbe2c, [0x68eb] = 0xbe2d,
  [0x68ec] = 0xbe2e, [0x68ed] = 0xbe2f, [0x68ee] = 0xbe30, [0x68ef] = 0xbe31,
  [0x68f0] = 0xbe32, [0x68f1] = 0xbe33, [0x68f2] = 0xbe34, [0x68f3] = 0xbe35,
  [0x68f4] = 0xbe36, [0x68f5] = 0xbe37, [0x68f6] = 0xbe38, [0x68f7] = 0xbe39,
  [0x68f8] = 0xbe3a, [0x68f9] = 0xbe3b, [0x68fa] = 0xbe3c, [0x68fb] = 0xbe3d,
  [0x68fc] = 0xbe3e, [0x68fd] = 0xbe3f, [0x68fe] = 0xbe40, [0x68ff] = 0xbe41,
  [0x6900] = 0xbe42, [0x6901] = 0xbe43, [0x6902] = 0xbe44, [0x6903] = 0xbe45,
  [0x6904] = 0xbe46, [0x6905] = 0xbe47, [0x6906] = 0xbe48, [0x6907] = 0xbe49,
  [0x6908] = 0xbe4a, [0x6909] = 0xbe4b, [0x690a] = 0xbe4c, [0x690b] = 0xbe4d,
  [0x690c] = 0xbe4e, [0x690d] = 0xbe4f, [0x690e] = 0xbe50, [0x690f] = 0xbe51,
  [0x6910] = 0xbe52, [0x6911] = 0xbe53, [0x6912] = 0xbe54, [0x6913] = 0xbe55,
  [0x6914] = 0xbe56, [0x6915] = 0xbe57, [0x6916] = 0xbe58, [0x6917] = 0xbe59,
  [0x6918] = 0xbe5a, [0x6919] = 0xbe5b, [0x691a] = 0xbe5c, [0x691b] = 0xbe5d,
  [0x691c] = 0xbe5e, [0x691d] = 0xbe5f, [0x691e] = 0xbe60, [0x691f] = 0xbe61,
  [0x6920] = 0xbe62, [0x6921] = 0xbe63, [0x6922] = 0xbe64, [0x6923] = 0xbe65,
  [0x6924] = 0xbe66, [0x6925] = 0xbe67, [0x6926] = 0xbe68, [0x6927] = 0xbe69,
  [0x6928] = 0xbe6a, [0x6929] = 0xbe6b, [0x692a] = 0xbe6c, [0x692b] = 0xbe6d,
  [0x692c] = 0xbe6e, [0x692d] = 0xbe6f, [0x692e] = 0xbe70, [0x692f] = 0xbe71,
  [0x6930] = 0xbe72, [0x6931] = 0xbe73, [0x6932] = 0xbe74, [0x6933] = 0xbe75,
  [0x6934] = 0xbe76, [0x6935] = 0xbe77, [0x6936] = 0xbe78, [0x6937] = 0xbe79,
  [0x6938] = 0xbe7a, [0x6939] = 0xbe7b, [0x693a] = 0xbe7c, [0x693b] = 0xbe7d,
  [0x693c] = 0xbe7e, [0x693d] = 0xbe7f, [0x693e] = 0xbe80, [0x693f] = 0xbe81,
  [0x6940] = 0xbe82, [0x6941] = 0xbe83, [0x6942] = 0xbe84, [0x6943] = 0xbe85,
  [0x6944] = 0xbe86, [0x6945] = 0xbe87, [0x6946] = 0xbe88, [0x6947] = 0xbe89,
  [0x6948] = 0xbe8a, [0x6949] = 0xbe8b, [0x694a] = 0xbe8c, [0x694b] = 0xbe8d,
  [0x694c] = 0xbe8e, [0x694d] = 0xbe8f, [0x694e] = 0xbe90, [0x694f] = 0xbe91,
  [0x6950] = 0xbe92, [0x6951] = 0xbe93, [0x6952] = 0xbe94, [0x6953] = 0xbe95,
  [0x6954] = 0xbe96, [0x6955] = 0xbe97, [0x6956] = 0xbe98, [0x6957] = 0xbe99,
  [0x6958] = 0xbe9a, [0x6959] = 0xbe9b, [0x695a] = 0xbe9c, [0x695b] = 0xbe9d,
  [0x695c] = 0xbe9e, [0x695d] = 0xbe9f, [0x695e] = 0xbea0, [0x695f] = 0xbea1,
  [0x6960] = 0xbea2, [0x6961] = 0xbea3, [0x6962] = 0xbea4, [0x6963] = 0xbea5,
  [0x6964] = 0xbea6, [0x6965] = 0xbea7, [0x6966] = 0xbea8, [0x6967] = 0xbea9,
  [0x6968] = 0xbeaa, [0x6969] = 0xbeab, [0x696a] = 0xbeac, [0x696b] = 0xbead,
  [0x696c] = 0xbeae, [0x696d] = 0xbeaf, [0x696e] = 0xbeb0, [0x696f] = 0xbeb1,
  [0x6970] = 0xbeb2, [0x6971] = 0xbeb3, [0x6972] = 0xbeb4, [0x6973] = 0xbeb5,
  [0x6974] = 0xbeb6, [0x6975] = 0xbeb7, [0x6976] = 0xbeb8, [0x6977] = 0xbeb9,
  [0x6978] = 0xbeba, [0x6979] = 0xbebb, [0x697a] = 0xbebc, [0x697b] = 0xbebd,
  [0x697c] = 0xbebe, [0x697d] = 0xbebf, [0x697e] = 0xbec0, [0x697f] = 0xbec1,
  [0x6980] = 0xbec2, [0x6981] = 0xbec3, [0x6982] = 0xbec4, [0x6983] = 0xbec5,
  [0x6984] = 0xbec6, [0x6985] = 0xbec7, [0x6986] = 0xbec8, [0x6987] = 0xbec9,
  [0x6988] = 0xbeca, [0x6989] = 0xbecb, [0x698a] = 0xbecc, [0x698b] = 0xbecd,
  [0x698c] = 0xbece, [0x698d] = 0xbecf, [0x698e] = 0xbed0, [0x698f] = 0xbed1,
  [0x6990] = 0xbed2, [0x6991] = 0xbed3, [0x6992] = 0xbed4, [0x6993] = 0xbed5,
  [0x6994] = 0xbed6, [0x6995] = 0xbed7, [0x6996] = 0xbed8, [0x6997] = 0xbed9,
  [0x6998] = 0xbeda, [0x6999] = 0xbedb, [0x699a] = 0xbedc, [0x699b] = 0xbedd,
  [0x699c] = 0xbede, [0x699d] = 0xbedf, [0x699e] = 0xbee0, [0x699f] = 0xbee1,
  [0x69a0] = 0xbee2, [0x69a1] = 0xbee3, [0x69a2] = 0xbee4, [0x69a3] = 0xbee5,
  [0x69a4] = 0xbee6, [0x69a5] = 0xbee7, [0x69a6] = 0xbee8, [0x69a7] = 0xbee9,
  [0x69a8] = 0xbeea, [0x69a9] = 0xbeeb, [0x69aa] = 0xbeec, [0x69ab] = 0xbeed,
  [0x69ac] = 0xbeee, [0x69ad] = 0xbeef, [0x69ae] = 0xbef0, [0x69af] = 0xbef1,
  [0x69b0] = 0xbef2, [0x69b1] = 0xbef3, [0x69b2] = 0xbef4, [0x69b3] = 0xbef5,
  [0x69b4] = 0xbef6, [0x69b5] = 0xbef7, [0x69b6] = 0xbef8, [0x69b7] = 0xbef9,
  [0x69b8] = 0xbefa, [0x69b9] = 0xbefb, [0x69ba] = 0xbefc, [0x69bb] = 0xbefd,
  [0x69bc] = 0xbefe, [0x69bd] = 0xbeff, [0x69be] = 0xbf00, [0x69bf] = 0xbf01,
  [0x69c0] = 0xbf02, [0x69c1] = 0xbf03, [0x69c2] = 0xbf04, [0x69c3] = 0xbf05,
  [0x69c4] = 0xbf06, [0x69c5] = 0xbf07, [0x69c6] = 0xbf08, [0x69c7] = 0xbf09,
  [0x69c8] = 0xbf0a, [0x69c9] = 0xbf0b, [0x69ca] = 0xbf0c, [0x69cb] = 0xbf0d,
  [0x69cc] = 0xbf0e, [0x69cd] = 0xbf0f, [0x69ce] = 0xbf10, [0x69cf] = 0xbf11,
  [0x69d0] = 0xbf12, [0x69d1] = 0xbf13, [0x69d2] = 0xbf14, [0x69d3] = 0xbf15,
  [0x69d4] = 0xbf16, [0x69d5] = 0xbf17, [0x69d6] = 0xbf18, [0x69d7] = 0xbf19,
  [0x69d8] = 0xbf1a, [0x69d9] = 0xbf1b, [0x69da] = 0xbf1c, [0x69db] = 0xbf1d,
  [0x69dc] = 0xbf1e, [0x69dd] = 0xbf1f, [0x69de] = 0xbf20, [0x69df] = 0xbf21,
  [0x69e0] = 0xbf22, [0x69e1] = 0xbf23, [0x69e2] = 0xbf24, [0x69e3] = 0xbf25,
  [0x69e4] = 0xbf26, [0x69e5] = 0xbf27, [0x69e6] = 0xbf28, [0x69e7] = 0xbf29,
  [0x69e8] = 0xbf2a, [0x69e9] = 0xbf2b, [0x69ea] = 0xbf2c, [0x69eb] = 0xbf2d,
  [0x69ec] = 0xbf2e, [0x69ed] = 0xbf2f, [0x69ee] = 0xbf30, [0x69ef] = 0xbf31,
  [0x69f0] = 0xbf32, [0x69f1] = 0xbf33, [0x69f2] = 0xbf34, [0x69f3] = 0xbf35,
  [0x69f4] = 0xbf36, [0x69f5] = 0xbf37, [0x69f6] = 0xbf38, [0x69f7] = 0xbf39,
  [0x69f8] = 0xbf3a, [0x69f9] = 0xbf3b, [0x69fa] = 0xbf3c, [0x69fb] = 0xbf3d,
  [0x69fc] = 0xbf3e, [0x69fd] = 0xbf3f, [0x69fe] = 0xbf40, [0x69ff] = 0xbf41,
  [0x6a00] = 0xbf42, [0x6a01] = 0xbf43, [0x6a02] = 0xbf44, [0x6a03] = 0xbf45,
  [0x6a04] = 0xbf46, [0x6a05] = 0xbf47, [0x6a06] = 0xbf48, [0x6a07] = 0xbf49,
  [0x6a08] = 0xbf4a, [0x6a09] = 0xbf4b, [0x6a0a] = 0xbf4c, [0x6a0b] = 0xbf4d,
  [0x6a0c] = 0xbf4e, [0x6a0d] = 0xbf4f, [0x6a0e] = 0xbf50, [0x6a0f] = 0xbf51,
  [0x6a10] = 0xbf52, [0x6a11] = 0xbf53, [0x6a12] = 0xbf54, [0x6a13] = 0xbf55,
  [0x6a14] = 0xbf56, [0x6a15] = 0xbf57, [0x6a16] = 0xbf58, [0x6a17] = 0xbf59,
  [0x6a18] = 0xbf5a, [0x6a19] = 0xbf5b, [0x6a1a] = 0xbf5c, [0x6a1b] = 0xbf5d,
  [0x6a1c] = 0xbf5e, [0x6a1d] = 0xbf5f, [0x6a1e] = 0xbf60, [0x6a1f] = 0xbf61,
  [0x6a20] = 0xbf62, [0x6a21] = 0xbf63, [0x6a22] = 0xbf64, [0x6a23] = 0xbf65,
  [0x6a24] = 0xbf66, [0x6a25] = 0xbf67, [0x6a26] = 0xbf68, [0x6a27] = 0xbf69,
  [0x6a28] = 0xbf6a, [0x6a29] = 0xbf6b, [0x6a2a] = 0xbf6c, [0x6a2b] = 0xbf6d,
  [0x6a2c] = 0xbf6e, [0x6a2d] = 0xbf6f, [0x6a2e] = 0xbf70, [0x6a2f] = 0xbf71,
  [0x6a30] = 0xbf72, [0x6a31] = 0xbf73, [0x6a32] = 0xbf74, [0x6a33] = 0xbf75,
  [0x6a34] = 0xbf76, [0x6a35] = 0xbf77, [0x6a36] = 0xbf78, [0x6a37] = 0xbf79,
  [0x6a38] = 0xbf7a, [0x6a39] = 0xbf7b, [0x6a3a] = 0xbf7c, [0x6a3b] = 0xbf7d,
  [0x6a3c] = 0xbf7e, [0x6a3d] = 0xbf7f, [0x6a3e] = 0xbf80, [0x6a3f] = 0xbf81,
  [0x6a40] = 0xbf82, [0x6a41] = 0xbf83, [0x6a42] = 0xbf84, [0x6a43] = 0xbf85,
  [0x6a44] = 0xbf86, [0x6a45] = 0xbf87, [0x6a46] = 0xbf88, [0x6a47] = 0xbf89,
  [0x6a48] = 0xbf8a, [0x6a49] = 0xbf8b, [0x6a4a] = 0xbf8c, [0x6a4b] = 0xbf8d,
  [0x6a4c] = 0xbf8e, [0x6a4d] = 0xbf8f, [0x6a4e] = 0xbf90, [0x6a4f] = 0xbf91,
  [0x6a50] = 0xbf92, [0x6a51] = 0xbf93, [0x6a52] = 0xbf94, [0x6a53] = 0xbf95,
  [0x6a54] = 0xbf96, [0x6a55] = 0xbf97, [0x6a56] = 0xbf98, [0x6a57] = 0xbf99,
  [0x6a58] = 0xbf9a, [0x6a59] = 0xbf9b, [0x6a5a] = 0xbf9c, [0x6a5b] = 0xbf9d,
  [0x6a5c] = 0xbf9e, [0x6a5d] = 0xbf9f, [0x6a5e] = 0xbfa0, [0x6a5f] = 0xbfa1,
  [0x6a60] = 0xbfa2, [0x6a61] = 0xbfa3, [0x6a62] = 0xbfa4, [0x6a63] = 0xbfa5,
  [0x6a64] = 0xbfa6, [0x6a65] = 0xbfa7, [0x6a66] = 0xbfa8, [0x6a67] = 0xbfa9,
  [0x6a68] = 0xbfaa, [0x6a69] = 0xbfab, [0x6a6a] = 0xbfac, [0x6a6b] = 0xbfad,
  [0x6a6c] = 0xbfae, [0x6a6d] = 0xbfaf, [0x6a6e] = 0xbfb0, [0x6a6f] = 0xbfb1,
  [0x6a70] = 0xbfb2, [0x6a71] = 0xbfb3, [0x6a72] = 0xbfb4, [0x6a73] = 0xbfb5,
  [0x6a74] = 0xbfb6, [0x6a75] = 0xbfb7, [0x6a76] = 0xbfb8, [0x6a77] = 0xbfb9,
  [0x6a78] = 0xbfba, [0x6a79] = 0xbfbb, [0x6a7a] = 0xbfbc, [0x6a7b] = 0xbfbd,
  [0x6a7c] = 0xbfbe, [0x6a7d] = 0xbfbf, [0x6a7e] = 0xbfc0, [0x6a7f] = 0xbfc1,
  [0x6a80] = 0xbfc2, [0x6a81] = 0xbfc3, [0x6a82] = 0xbfc4, [0x6a83] = 0xbfc5,
  [0x6a84] = 0xbfc6, [0x6a85] = 0xbfc7, [0x6a86] = 0xbfc8, [0x6a87] = 0xbfc9,
  [0x6a88] = 0xbfca, [0x6a89] = 0xbfcb, [0x6a8a] = 0xbfcc, [0x6a8b] = 0xbfcd,
  [0x6a8c] = 0xbfce, [0x6a8d] = 0xbfcf, [0x6a8e] = 0xbfd0, [0x6a8f] = 0xbfd1,
  [0x6a90] = 0xbfd2, [0x6a91] = 0xbfd3, [0x6a92] = 0xbfd4, [0x6a93] = 0xbfd5,
  [0x6a94] = 0xbfd6, [0x6a95] = 0xbfd7, [0x6a96] = 0xbfd8, [0x6a97] = 0xbfd9,
  [0x6a98] = 0xbfda, [0x6a99] = 0xbfdb, [0x6a9a] = 0xbfdc, [0x6a9b] = 0xbfdd,
  [0x6a9c] = 0xbfde, [0x6a9d] = 0xbfdf, [0x6a9e] = 0xbfe0, [0x6a9f] = 0xbfe1,
  [0x6aa0] = 0xbfe2, [0x6aa1] = 0xbfe3, [0x6aa2] = 0xbfe4, [0x6aa3] = 0xbfe5,
  [0x6aa4] = 0xbfe6, [0x6aa5] = 0xbfe7, [0x6aa6] = 0xbfe8, [0x6aa7] = 0xbfe9,
  [0x6aa8] = 0xbfea, [0x6aa9] = 0xbfeb, [0x6aaa] = 0xbfec, [0x6aab] = 0xbfed,
  [0x6aac] = 0xbfee, [0x6aad] = 0xbfef, [0x6aae] = 0xbff0, [0x6aaf] = 0xbff1,
  [0x6ab0] = 0xbff2, [0x6ab1] = 0xbff3, [0x6ab2] = 0xbff4, [0x6ab3] = 0xbff5,
  [0x6ab4] = 0xbff6, [0x6ab5] = 0xbff7, [0x6ab6] = 0xbff8, [0x6ab7] = 0xbff9,
  [0x6ab8] = 0xbffa, [0x6ab9] = 0xbffb, [0x6aba] = 0xbffc, [0x6abb] = 0xbffd,
  [0x6abc] = 0xbffe, [0x6abd] = 0xbfff, [0x6abe] = 0xc000, [0x6abf] = 0xc001,
  [0x6ac0] = 0xc002, [0x6ac1] = 0xc003, [0x6ac2] = 0xc004, [0x6ac3] = 0xc005,
  [0x6ac4] = 0xc006, [0x6ac5] = 0xc007, [0x6ac6] = 0xc008, [0x6ac7] = 0xc009,
  [0x6ac8] = 0xc00a, [0x6ac9] = 0xc00b, [0x6aca] = 0xc00c, [0x6acb] = 0xc00d,
  [0x6acc] = 0xc00e, [0x6acd] = 0xc00f, [0x6ace] = 0xc010, [0x6acf] = 0xc011,
  [0x6ad0] = 0xc012, [0x6ad1] = 0xc013, [0x6ad2] = 0xc014, [0x6ad3] = 0xc015,
  [0x6ad4] = 0xc016, [0x6ad5] = 0xc017, [0x6ad6] = 0xc018, [0x6ad7] = 0xc019,
  [0x6ad8] = 0xc01a, [0x6ad9] = 0xc01b, [0x6ada] = 0xc01c, [0x6adb] = 0xc01d,
  [0x6adc] = 0xc01e, [0x6add] = 0xc01f, [0x6ade] = 0xc020, [0x6adf] = 0xc021,
  [0x6ae0] = 0xc022, [0x6ae1] = 0xc023, [0x6ae2] = 0xc024, [0x6ae3] = 0xc025,
  [0x6ae4] = 0xc026, [0x6ae5] = 0xc027, [0x6ae6] = 0xc028, [0x6ae7] = 0xc029,
  [0x6ae8] = 0xc02a, [0x6ae9] = 0xc02b, [0x6aea] = 0xc02c, [0x6aeb] = 0xc02d,
  [0x6aec] = 0xc02e, [0x6aed] = 0xc02f, [0x6aee] = 0xc030, [0x6aef] = 0xc031,
  [0x6af0] = 0xc032, [0x6af1] = 0xc033, [0x6af2] = 0xc034, [0x6af3] = 0xc035,
  [0x6af4] = 0xc036, [0x6af5] = 0xc037, [0x6af6] = 0xc038, [0x6af7] = 0xc039,
  [0x6af8] = 0xc03a, [0x6af9] = 0xc03b, [0x6afa] = 0xc03c, [0x6afb] = 0xc03d,
  [0x6afc] = 0xc03e, [0x6afd] = 0xc03f, [0x6afe] = 0xc040, [0x6aff] = 0xc041,
  [0x6b00] = 0xc042, [0x6b01] = 0xc043, [0x6b02] = 0xc044, [0x6b03] = 0xc045,
  [0x6b04] = 0xc046, [0x6b05] = 0xc047, [0x6b06] = 0xc048, [0x6b07] = 0xc049,
  [0x6b08] = 0xc04a, [0x6b09] = 0xc04b, [0x6b0a] = 0xc04c, [0x6b0b] = 0xc04d,
  [0x6b0c] = 0xc04e, [0x6b0d] = 0xc04f, [0x6b0e] = 0xc050, [0x6b0f] = 0xc051,
  [0x6b10] = 0xc052, [0x6b11] = 0xc053, [0x6b12] = 0xc054, [0x6b13] = 0xc055,
  [0x6b14] = 0xc056, [0x6b15] = 0xc057, [0x6b16] = 0xc058, [0x6b17] = 0xc059,
  [0x6b18] = 0xc05a, [0x6b19] = 0xc05b, [0x6b1a] = 0xc05c, [0x6b1b] = 0xc05d,
  [0x6b1c] = 0xc05e, [0x6b1d] = 0xc05f, [0x6b1e] = 0xc060, [0x6b1f] = 0xc061,
  [0x6b20] = 0xc062, [0x6b21] = 0xc063, [0x6b22] = 0xc064, [0x6b23] = 0xc065,
  [0x6b24] = 0xc066, [0x6b25] = 0xc067, [0x6b26] = 0xc068, [0x6b27] = 0xc069,
  [0x6b28] = 0xc06a, [0x6b29] = 0xc06b, [0x6b2a] = 0xc06c, [0x6b2b] = 0xc06d,
  [0x6b2c] = 0xc06e, [0x6b2d] = 0xc06f, [0x6b2e] = 0xc070, [0x6b2f] = 0xc071,
  [0x6b30] = 0xc072, [0x6b31] = 0xc073, [0x6b32] = 0xc074, [0x6b33] = 0xc075,
  [0x6b34] = 0xc076, [0x6b35] = 0xc077, [0x6b36] = 0xc078, [0x6b37] = 0xc079,
  [0x6b38] = 0xc07a, [0x6b39] = 0xc07b, [0x6b3a] = 0xc07c, [0x6b3b] = 0xc07d,
  [0x6b3c] = 0xc07e, [0x6b3d] = 0xc07f, [0x6b3e] = 0xc080, [0x6b3f] = 0xc081,
  [0x6b40] = 0xc082, [0x6b41] = 0xc083, [0x6b42] = 0xc084, [0x6b43] = 0xc085,
  [0x6b44] = 0xc086, [0x6b45] = 0xc087, [0x6b46] = 0xc088, [0x6b47] = 0xc089,
  [0x6b48] = 0xc08a, [0x6b49] = 0xc08b, [0x6b4a] = 0xc08c, [0x6b4b] = 0xc08d,
  [0x6b4c] = 0xc08e, [0x6b4d] = 0xc08f, [0x6b4e] = 0xc090, [0x6b4f] = 0xc091,
  [0x6b50] = 0xc092, [0x6b51] = 0xc093, [0x6b52] = 0xc094, [0x6b53] = 0xc095,
  [0x6b54] = 0xc096, [0x6b55] = 0xc097, [0x6b56] = 0xc098, [0x6b57] = 0xc099,
  [0x6b58] = 0xc09a, [0x6b59] = 0xc09b, [0x6b5a] = 0xc09c, [0x6b5b] = 0xc09d,
  [0x6b5c] = 0xc09e, [0x6b5d] = 0xc09f, [0x6b5e] = 0xc0a0, [0x6b5f] = 0xc0a1,
  [0x6b60] = 0xc0a2, [0x6b61] = 0xc0a3, [0x6b62] = 0xc0a4, [0x6b63] = 0xc0a5,
  [0x6b64] = 0xc0a6, [0x6b65] = 0xc0a7, [0x6b66] = 0xc0a8, [0x6b67] = 0xc0a9,
  [0x6b68] = 0xc0aa, [0x6b69] = 0xc0ab, [0x6b6a] = 0xc0ac, [0x6b6b] = 0xc0ad,
  [0x6b6c] = 0xc0ae, [0x6b6d] = 0xc0af, [0x6b6e] = 0xc0b0, [0x6b6f] = 0xc0b1,
  [0x6b70] = 0xc0b2, [0x6b71] = 0xc0b3, [0x6b72] = 0xc0b4, [0x6b73] = 0xc0b5,
  [0x6b74] = 0xc0b6, [0x6b75] = 0xc0b7, [0x6b76] = 0xc0b8, [0x6b77] = 0xc0b9,
  [0x6b78] = 0xc0ba, [0x6b79] = 0xc0bb, [0x6b7a] = 0xc0bc, [0x6b7b] = 0xc0bd,
  [0x6b7c] = 0xc0be, [0x6b7d] = 0xc0bf, [0x6b7e] = 0xc0c0, [0x6b7f] = 0xc0c1,
  [0x6b80] = 0xc0c2, [0x6b81] = 0xc0c3, [0x6b82] = 0xc0c4, [0x6b83] = 0xc0c5,
  [0x6b84] = 0xc0c6, [0x6b85] = 0xc0c7, [0x6b86] = 0xc0c8, [0x6b87] = 0xc0c9,
  [0x6b88] = 0xc0ca, [0x6b89] = 0xc0cb, [0x6b8a] = 0xc0cc, [0x6b8b] = 0xc0cd,
  [0x6b8c] = 0xc0ce, [0x6b8d] = 0xc0cf, [0x6b8e] = 0xc0d0, [0x6b8f] = 0xc0d1,
  [0x6b90] = 0xc0d2, [0x6b91] = 0xc0d3, [0x6b92] = 0xc0d4, [0x6b93] = 0xc0d5,
  [0x6b94] = 0xc0d6, [0x6b95] = 0xc0d7, [0x6b96] = 0xc0d8, [0x6b97] = 0xc0d9,
  [0x6b98] = 0xc0da, [0x6b99] = 0xc0db, [0x6b9a] = 0xc0dc, [0x6b9b] = 0xc0dd,
  [0x6b9c] = 0xc0de, [0x6b9d] = 0xc0df, [0x6b9e] = 0xc0e0, [0x6b9f] = 0xc0e1,
  [0x6ba0] = 0xc0e2, [0x6ba1] = 0xc0e3, [0x6ba2] = 0xc0e4, [0x6ba3] = 0xc0e5,
  [0x6ba4] = 0xc0e6, [0x6ba5] = 0xc0e7, [0x6ba6] = 0xc0e8, [0x6ba7] = 0xc0e9,
  [0x6ba8] = 0xc0ea, [0x6ba9] = 0xc0eb, [0x6baa] = 0xc0ec, [0x6bab] = 0xc0ed,
  [0x6bac] = 0xc0ee, [0x6bad] = 0xc0ef, [0x6bae] = 0xc0f0, [0x6baf] = 0xc0f1,
  [0x6bb0] = 0xc0f2, [0x6bb1] = 0xc0f3, [0x6bb2] = 0xc0f4, [0x6bb3] = 0xc0f5,
  [0x6bb4] = 0xc0f6, [0x6bb5] = 0xc0f7, [0x6bb6] = 0xc0f8, [0x6bb7] = 0xc0f9,
  [0x6bb8] = 0xc0fa, [0x6bb9] = 0xc0fb, [0x6bba] = 0xc0fc, [0x6bbb] = 0xc0fd,
  [0x6bbc] = 0xc0fe, [0x6bbd] = 0xc0ff, [0x6bbe] = 0xc100, [0x6bbf] = 0xc101,
  [0x6bc0] = 0xc102, [0x6bc1] = 0xc103, [0x6bc2] = 0xc104, [0x6bc3] = 0xc105,
  [0x6bc4] = 0xc106, [0x6bc5] = 0xc107, [0x6bc6] = 0xc108, [0x6bc7] = 0xc109,
  [0x6bc8] = 0xc10a, [0x6bc9] = 0xc10b, [0x6bca] = 0xc10c, [0x6bcb] = 0xc10d,
  [0x6bcc] = 0xc10e, [0x6bcd] = 0xc10f, [0x6bce] = 0xc110, [0x6bcf] = 0xc111,
  [0x6bd0] = 0xc112, [0x6bd1] = 0xc113, [0x6bd2] = 0xc114, [0x6bd3] = 0xc115,
  [0x6bd4] = 0xc116, [0x6bd5] = 0xc117, [0x6bd6] = 0xc118, [0x6bd7] = 0xc119,
  [0x6bd8] = 0xc11a, [0x6bd9] = 0xc11b, [0x6bda] = 0xc11c, [0x6bdb] = 0xc11d,
  [0x6bdc] = 0xc11e, [0x6bdd] = 0xc11f, [0x6bde] = 0xc120, [0x6bdf] = 0xc121,
  [0x6be0] = 0xc122, [0x6be1] = 0xc123, [0x6be2] = 0xc124, [0x6be3] = 0xc125,
  [0x6be4] = 0xc126, [0x6be5] = 0xc127, [0x6be6] = 0xc128, [0x6be7] = 0xc129,
  [0x6be8] = 0xc12a, [0x6be9] = 0xc12b, [0x6bea] = 0xc12c, [0x6beb] = 0xc12d,
  [0x6bec] = 0xc12e, [0x6bed] = 0xc12f, [0x6bee] = 0xc130, [0x6bef] = 0xc131,
  [0x6bf0] = 0xc132, [0x6bf1] = 0xc133, [0x6bf2] = 0xc134, [0x6bf3] = 0xc135,
  [0x6bf4] = 0xc136, [0x6bf5] = 0xc137, [0x6bf6] = 0xc138, [0x6bf7] = 0xc139,
  [0x6bf8] = 0xc13a, [0x6bf9] = 0xc13b, [0x6bfa] = 0xc13c, [0x6bfb] = 0xc13d,
  [0x6bfc] = 0xc13e, [0x6bfd] = 0xc13f, [0x6bfe] = 0xc140, [0x6bff] = 0xc141,
  [0x6c00] = 0xc142, [0x6c01] = 0xc143, [0x6c02] = 0xc144, [0x6c03] = 0xc145,
  [0x6c04] = 0xc146, [0x6c05] = 0xc147, [0x6c06] = 0xc148, [0x6c07] = 0xc149,
  [0x6c08] = 0xc14a, [0x6c09] = 0xc14b, [0x6c0a] = 0xc14c, [0x6c0b] = 0xc14d,
  [0x6c0c] = 0xc14e, [0x6c0d] = 0xc14f, [0x6c0e] = 0xc150, [0x6c0f] = 0xc151,
  [0x6c10] = 0xc152, [0x6c11] = 0xc153, [0x6c12] = 0xc154, [0x6c13] = 0xc155,
  [0x6c14] = 0xc156, [0x6c15] = 0xc157, [0x6c16] = 0xc158, [0x6c17] = 0xc159,
  [0x6c18] = 0xc15a, [0x6c19] = 0xc15b, [0x6c1a] = 0xc15c, [0x6c1b] = 0xc15d,
  [0x6c1c] = 0xc15e, [0x6c1d] = 0xc15f, [0x6c1e] = 0xc160, [0x6c1f] = 0xc161,
  [0x6c20] = 0xc162, [0x6c21] = 0xc163, [0x6c22] = 0xc164, [0x6c23] = 0xc165,
  [0x6c24] = 0xc166, [0x6c25] = 0xc167, [0x6c26] = 0xc168, [0x6c27] = 0xc169,
  [0x6c28] = 0xc16a, [0x6c29] = 0xc16b, [0x6c2a] = 0xc16c, [0x6c2b] = 0xc16d,
  [0x6c2c] = 0xc16e, [0x6c2d] = 0xc16f, [0x6c2e] = 0xc170, [0x6c2f] = 0xc171,
  [0x6c30] = 0xc172, [0x6c31] = 0xc173, [0x6c32] = 0xc174, [0x6c33] = 0xc175,
  [0x6c34] = 0xc176, [0x6c35] = 0xc177, [0x6c36] = 0xc178, [0x6c37] = 0xc179,
  [0x6c38] = 0xc17a, [0x6c39] = 0xc17b, [0x6c3a] = 0xc17c, [0x6c3b] = 0xc17d,
  [0x6c3c] = 0xc17e, [0x6c3d] = 0xc17f, [0x6c3e] = 0xc180, [0x6c3f] = 0xc181,
  [0x6c40] = 0xc182, [0x6c41] = 0xc183, [0x6c42] = 0xc184, [0x6c43] = 0xc185,
  [0x6c44] = 0xc186, [0x6c45] = 0xc187, [0x6c46] = 0xc188, [0x6c47] = 0xc189,
  [0x6c48] = 0xc18a, [0x6c49] = 0xc18b, [0x6c4a] = 0xc18c, [0x6c4b] = 0xc18d,
  [0x6c4c] = 0xc18e, [0x6c4d] = 0xc18f, [0x6c4e] = 0xc190, [0x6c4f] = 0xc191,
  [0x6c50] = 0xc192, [0x6c51] = 0xc193, [0x6c52] = 0xc194, [0x6c53] = 0xc195,
  [0x6c54] = 0xc196, [0x6c55] = 0xc197, [0x6c56] = 0xc198, [0x6c57] = 0xc199,
  [0x6c58] = 0xc19a, [0x6c59] = 0xc19b, [0x6c5a] = 0xc19c, [0x6c5b] = 0xc19d,
  [0x6c5c] = 0xc19e, [0x6c5d] = 0xc19f, [0x6c5e] = 0xc1a0, [0x6c5f] = 0xc1a1,
  [0x6c60] = 0xc1a2, [0x6c61] = 0xc1a3, [0x6c62] = 0xc1a4, [0x6c63] = 0xc1a5,
  [0x6c64] = 0xc1a6, [0x6c65] = 0xc1a7, [0x6c66] = 0xc1a8, [0x6c67] = 0xc1a9,
  [0x6c68] = 0xc1aa, [0x6c69] = 0xc1ab, [0x6c6a] = 0xc1ac, [0x6c6b] = 0xc1ad,
  [0x6c6c] = 0xc1ae, [0x6c6d] = 0xc1af, [0x6c6e] = 0xc1b0, [0x6c6f] = 0xc1b1,
  [0x6c70] = 0xc1b2, [0x6c71] = 0xc1b3, [0x6c72] = 0xc1b4, [0x6c73] = 0xc1b5,
  [0x6c74] = 0xc1b6, [0x6c75] = 0xc1b7, [0x6c76] = 0xc1b8, [0x6c77] = 0xc1b9,
  [0x6c78] = 0xc1ba, [0x6c79] = 0xc1bb, [0x6c7a] = 0xc1bc, [0x6c7b] = 0xc1bd,
  [0x6c7c] = 0xc1be, [0x6c7d] = 0xc1bf, [0x6c7e] = 0xc1c0, [0x6c7f] = 0xc1c1,
  [0x6c80] = 0xc1c2, [0x6c81] = 0xc1c3, [0x6c82] = 0xc1c4, [0x6c83] = 0xc1c5,
  [0x6c84] = 0xc1c6, [0x6c85] = 0xc1c7, [0x6c86] = 0xc1c8, [0x6c87] = 0xc1c9,
  [0x6c88] = 0xc1ca, [0x6c89] = 0xc1cb, [0x6c8a] = 0xc1cc, [0x6c8b] = 0xc1cd,
  [0x6c8c] = 0xc1ce, [0x6c8d] = 0xc1cf, [0x6c8e] = 0xc1d0, [0x6c8f] = 0xc1d1,
  [0x6c90] = 0xc1d2, [0x6c91] = 0xc1d3, [0x6c92] = 0xc1d4, [0x6c93] = 0xc1d5,
  [0x6c94] = 0xc1d6, [0x6c95] = 0xc1d7, [0x6c96] = 0xc1d8, [0x6c97] = 0xc1d9,
  [0x6c98] = 0xc1da, [0x6c99] = 0xc1db, [0x6c9a] = 0xc1dc, [0x6c9b] = 0xc1dd,
  [0x6c9c] = 0xc1de, [0x6c9d] = 0xc1df, [0x6c9e] = 0xc1e0, [0x6c9f] = 0xc1e1,
  [0x6ca0] = 0xc1e2, [0x6ca1] = 0xc1e3, [0x6ca2] = 0xc1e4, [0x6ca3] = 0xc1e5,
  [0x6ca4] = 0xc1e6, [0x6ca5] = 0xc1e7, [0x6ca6] = 0xc1e8, [0x6ca7] = 0xc1e9,
  [0x6ca8] = 0xc1ea, [0x6ca9] = 0xc1eb, [0x6caa] = 0xc1ec, [0x6cab] = 0xc1ed,
  [0x6cac] = 0xc1ee, [0x6cad] = 0xc1ef, [0x6cae] = 0xc1f0, [0x6caf] = 0xc1f1,
  [0x6cb0] = 0xc1f2, [0x6cb1] = 0xc1f3, [0x6cb2] = 0xc1f4, [0x6cb3] = 0xc1f5,
  [0x6cb4] = 0xc1f6, [0x6cb5] = 0xc1f7, [0x6cb6] = 0xc1f8, [0x6cb7] = 0xc1f9,
  [0x6cb8] = 0xc1fa, [0x6cb9] = 0xc1fb, [0x6cba] = 0xc1fc, [0x6cbb] = 0xc1fd,
  [0x6cbc] = 0xc1fe, [0x6cbd] = 0xc1ff, [0x6cbe] = 0xc200, [0x6cbf] = 0xc201,
  [0x6cc0] = 0xc202, [0x6cc1] = 0xc203, [0x6cc2] = 0xc204, [0x6cc3] = 0xc205,
  [0x6cc4] = 0xc206, [0x6cc5] = 0xc207, [0x6cc6] = 0xc208, [0x6cc7] = 0xc209,
  [0x6cc8] = 0xc20a, [0x6cc9] = 0xc20b, [0x6cca] = 0xc20c, [0x6ccb] = 0xc20d,
  [0x6ccc] = 0xc20e, [0x6ccd] = 0xc20f, [0x6cce] = 0xc210, [0x6ccf] = 0xc211,
  [0x6cd0] = 0xc212, [0x6cd1] = 0xc213, [0x6cd2] = 0xc214, [0x6cd3] = 0xc215,
  [0x6cd4] = 0xc216, [0x6cd5] = 0xc217, [0x6cd6] = 0xc218, [0x6cd7] = 0xc219,
  [0x6cd8] = 0xc21a, [0x6cd9] = 0xc21b, [0x6cda] = 0xc21c, [0x6cdb] = 0xc21d,
  [0x6cdc] = 0xc21e, [0x6cdd] = 0xc21f, [0x6cde] = 0xc220, [0x6cdf] = 0xc221,
  [0x6ce0] = 0xc222, [0x6ce1] = 0xc223, [0x6ce2] = 0xc224, [0x6ce3] = 0xc225,
  [0x6ce4] = 0xc226, [0x6ce5] = 0xc227, [0x6ce6] = 0xc228, [0x6ce7] = 0xc229,
  [0x6ce8] = 0xc22a, [0x6ce9] = 0xc22b, [0x6cea] = 0xc22c, [0x6ceb] = 0xc22d,
  [0x6cec] = 0xc22e, [0x6ced] = 0xc22f, [0x6cee] = 0xc230, [0x6cef] = 0xc231,
  [0x6cf0] = 0xc232, [0x6cf1] = 0xc233, [0x6cf2] = 0xc234, [0x6cf3] = 0xc235,
  [0x6cf4] = 0xc236, [0x6cf5] = 0xc237, [0x6cf6] = 0xc238, [0x6cf7] = 0xc239,
  [0x6cf8] = 0xc23a, [0x6cf9] = 0xc23b, [0x6cfa] = 0xc23c, [0x6cfb] = 0xc23d,
  [0x6cfc] = 0xc23e, [0x6cfd] = 0xc23f, [0x6cfe] = 0xc240, [0x6cff] = 0xc241,
  [0x6d00] = 0xc242, [0x6d01] = 0xc243, [0x6d02] = 0xc244, [0x6d03] = 0xc245,
  [0x6d04] = 0xc246, [0x6d05] = 0xc247, [0x6d06] = 0xc248, [0x6d07] = 0xc249,
  [0x6d08] = 0xc24a, [0x6d09] = 0xc24b, [0x6d0a] = 0xc24c, [0x6d0b] = 0xc24d,
  [0x6d0c] = 0xc24e, [0x6d0d] = 0xc24f, [0x6d0e] = 0xc250, [0x6d0f] = 0xc251,
  [0x6d10] = 0xc252, [0x6d11] = 0xc253, [0x6d12] = 0xc254, [0x6d13] = 0xc255,
  [0x6d14] = 0xc256, [0x6d15] = 0xc257, [0x6d16] = 0xc258, [0x6d17] = 0xc259,
  [0x6d18] = 0xc25a, [0x6d19] = 0xc25b, [0x6d1a] = 0xc25c, [0x6d1b] = 0xc25d,
  [0x6d1c] = 0xc25e, [0x6d1d] = 0xc25f, [0x6d1e] = 0xc260, [0x6d1f] = 0xc261,
  [0x6d20] = 0xc262, [0x6d21] = 0xc263, [0x6d22] = 0xc264, [0x6d23] = 0xc265,
  [0x6d24] = 0xc266, [0x6d25] = 0xc267, [0x6d26] = 0xc268, [0x6d27] = 0xc269,
  [0x6d28] = 0xc26a, [0x6d29] = 0xc26b, [0x6d2a] = 0xc26c, [0x6d2b] = 0xc26d,
  [0x6d2c] = 0xc26e, [0x6d2d] = 0xc26f, [0x6d2e] = 0xc270, [0x6d2f] = 0xc271,
  [0x6d30] = 0xc272, [0x6d31] = 0xc273, [0x6d32] = 0xc274, [0x6d33] = 0xc275,
  [0x6d34] = 0xc276, [0x6d35] = 0xc277, [0x6d36] = 0xc278, [0x6d37] = 0xc279,
  [0x6d38] = 0xc27a, [0x6d39] = 0xc27b, [0x6d3a] = 0xc27c, [0x6d3b] = 0xc27d,
  [0x6d3c] = 0xc27e, [0x6d3d] = 0xc27f, [0x6d3e] = 0xc280, [0x6d3f] = 0xc281,
  [0x6d40] = 0xc282, [0x6d41] = 0xc283, [0x6d42] = 0xc284, [0x6d43] = 0xc285,
  [0x6d44] = 0xc286, [0x6d45] = 0xc287, [0x6d46] = 0xc288, [0x6d47] = 0xc289,
  [0x6d48] = 0xc28a, [0x6d49] = 0xc28b, [0x6d4a] = 0xc28c, [0x6d4b] = 0xc28d,
  [0x6d4c] = 0xc28e, [0x6d4d] = 0xc28f, [0x6d4e] = 0xc290, [0x6d4f] = 0xc291,
  [0x6d50] = 0xc292, [0x6d51] = 0xc293, [0x6d52] = 0xc294, [0x6d53] = 0xc295,
  [0x6d54] = 0xc296, [0x6d55] = 0xc297, [0x6d56] = 0xc298, [0x6d57] = 0xc299,
  [0x6d58] = 0xc29a, [0x6d59] = 0xc29b, [0x6d5a] = 0xc29c, [0x6d5b] = 0xc29d,
  [0x6d5c] = 0xc29e, [0x6d5d] = 0xc29f, [0x6d5e] = 0xc2a0, [0x6d5f] = 0xc2a1,
  [0x6d60] = 0xc2a2, [0x6d61] = 0xc2a3, [0x6d62] = 0xc2a4, [0x6d63] = 0xc2a5,
  [0x6d64] = 0xc2a6, [0x6d65] = 0xc2a7, [0x6d66] = 0xc2a8, [0x6d67] = 0xc2a9,
  [0x6d68] = 0xc2aa, [0x6d69] = 0xc2ab, [0x6d6a] = 0xc2ac, [0x6d6b] = 0xc2ad,
  [0x6d6c] = 0xc2ae, [0x6d6d] = 0xc2af, [0x6d6e] = 0xc2b0, [0x6d6f] = 0xc2b1,
  [0x6d70] = 0xc2b2, [0x6d71] = 0xc2b3, [0x6d72] = 0xc2b4, [0x6d73] = 0xc2b5,
  [0x6d74] = 0xc2b6, [0x6d75] = 0xc2b7, [0x6d76] = 0xc2b8, [0x6d77] = 0xc2b9,
  [0x6d78] = 0xc2ba, [0x6d79] = 0xc2bb, [0x6d7a] = 0xc2bc, [0x6d7b] = 0xc2bd,
  [0x6d7c] = 0xc2be, [0x6d7d] = 0xc2bf, [0x6d7e] = 0xc2c0, [0x6d7f] = 0xc2c1,
  [0x6d80] = 0xc2c2, [0x6d81] = 0xc2c3, [0x6d82] = 0xc2c4, [0x6d83] = 0xc2c5,
  [0x6d84] = 0xc2c6, [0x6d85] = 0xc2c7, [0x6d86] = 0xc2c8, [0x6d87] = 0xc2c9,
  [0x6d88] = 0xc2ca, [0x6d89] = 0xc2cb, [0x6d8a] = 0xc2cc, [0x6d8b] = 0xc2cd,
  [0x6d8c] = 0xc2ce, [0x6d8d] = 0xc2cf, [0x6d8e] = 0xc2d0, [0x6d8f] = 0xc2d1,
  [0x6d90] = 0xc2d2, [0x6d91] = 0xc2d3, [0x6d92] = 0xc2d4, [0x6d93] = 0xc2d5,
  [0x6d94] = 0xc2d6, [0x6d95] = 0xc2d7, [0x6d96] = 0xc2d8, [0x6d97] = 0xc2d9,
  [0x6d98] = 0xc2da, [0x6d99] = 0xc2db, [0x6d9a] = 0xc2dc, [0x6d9b] = 0xc2dd,
  [0x6d9c] = 0xc2de, [0x6d9d] = 0xc2df, [0x6d9e] = 0xc2e0, [0x6d9f] = 0xc2e1,
  [0x6da0] = 0xc2e2, [0x6da1] = 0xc2e3, [0x6da2] = 0xc2e4, [0x6da3] = 0xc2e5,
  [0x6da4] = 0xc2e6, [0x6da5] = 0xc2e7, [0x6da6] = 0xc2e8, [0x6da7] = 0xc2e9,
  [0x6da8] = 0xc2ea, [0x6da9] = 0xc2eb, [0x6daa] = 0xc2ec, [0x6dab] = 0xc2ed,
  [0x6dac] = 0xc2ee, [0x6dad] = 0xc2ef, [0x6dae] = 0xc2f0, [0x6daf] = 0xc2f1,
  [0x6db0] = 0xc2f2, [0x6db1] = 0xc2f3, [0x6db2] = 0xc2f4, [0x6db3] = 0xc2f5,
  [0x6db4] = 0xc2f6, [0x6db5] = 0xc2f7, [0x6db6] = 0xc2f8, [0x6db7] = 0xc2f9,
  [0x6db8] = 0xc2fa, [0x6db9] = 0xc2fb, [0x6dba] = 0xc2fc, [0x6dbb] = 0xc2fd,
  [0x6dbc] = 0xc2fe, [0x6dbd] = 0xc2ff, [0x6dbe] = 0xc300, [0x6dbf] = 0xc301,
  [0x6dc0] = 0xc302, [0x6dc1] = 0xc303, [0x6dc2] = 0xc304, [0x6dc3] = 0xc305,
  [0x6dc4] = 0xc306, [0x6dc5] = 0xc307, [0x6dc6] = 0xc308, [0x6dc7] = 0xc309,
  [0x6dc8] = 0xc30a, [0x6dc9] = 0xc30b, [0x6dca] = 0xc30c, [0x6dcb] = 0xc30d,
  [0x6dcc] = 0xc30e, [0x6dcd] = 0xc30f, [0x6dce] = 0xc310, [0x6dcf] = 0xc311,
  [0x6dd0] = 0xc312, [0x6dd1] = 0xc313, [0x6dd2] = 0xc314, [0x6dd3] = 0xc315,
  [0x6dd4] = 0xc316, [0x6dd5] = 0xc317, [0x6dd6] = 0xc318, [0x6dd7] = 0xc319,
  [0x6dd8] = 0xc31a, [0x6dd9] = 0xc31b, [0x6dda] = 0xc31c, [0x6ddb] = 0xc31d,
  [0x6ddc] = 0xc31e, [0x6ddd] = 0xc31f, [0x6dde] = 0xc320, [0x6ddf] = 0xc321,
  [0x6de0] = 0xc322, [0x6de1] = 0xc323, [0x6de2] = 0xc324, [0x6de3] = 0xc325,
  [0x6de4] = 0xc326, [0x6de5] = 0xc327, [0x6de6] = 0xc328, [0x6de7] = 0xc329,
  [0x6de8] = 0xc32a, [0x6de9] = 0xc32b, [0x6dea] = 0xc32c, [0x6deb] = 0xc32d,
  [0x6dec] = 0xc32e, [0x6ded] = 0xc32f, [0x6dee] = 0xc330, [0x6def] = 0xc331,
  [0x6df0] = 0xc332, [0x6df1] = 0xc333, [0x6df2] = 0xc334, [0x6df3] = 0xc335,
  [0x6df4] = 0xc336, [0x6df5] = 0xc337, [0x6df6] = 0xc338, [0x6df7] = 0xc339,
  [0x6df8] = 0xc33a, [0x6df9] = 0xc33b, [0x6dfa] = 0xc33c, [0x6dfb] = 0xc33d,
  [0x6dfc] = 0xc33e, [0x6dfd] = 0xc33f, [0x6dfe] = 0xc340, [0x6dff] = 0xc341,
  [0x6e00] = 0xc342, [0x6e01] = 0xc343, [0x6e02] = 0xc344, [0x6e03] = 0xc345,
  [0x6e04] = 0xc346, [0x6e05] = 0xc347, [0x6e06] = 0xc348, [0x6e07] = 0xc349,
  [0x6e08] = 0xc34a, [0x6e09] = 0xc34b, [0x6e0a] = 0xc34c, [0x6e0b] = 0xc34d,
  [0x6e0c] = 0xc34e, [0x6e0d] = 0xc34f, [0x6e0e] = 0xc350, [0x6e0f] = 0xc351,
  [0x6e10] = 0xc352, [0x6e11] = 0xc353, [0x6e12] = 0xc354, [0x6e13] = 0xc355,
  [0x6e14] = 0xc356, [0x6e15] = 0xc357, [0x6e16] = 0xc358, [0x6e17] = 0xc359,
  [0x6e18] = 0xc35a, [0x6e19] = 0xc35b, [0x6e1a] = 0xc35c, [0x6e1b] = 0xc35d,
  [0x6e1c] = 0xc35e, [0x6e1d] = 0xc35f, [0x6e1e] = 0xc360, [0x6e1f] = 0xc361,
  [0x6e20] = 0xc362, [0x6e21] = 0xc363, [0x6e22] = 0xc364, [0x6e23] = 0xc365,
  [0x6e24] = 0xc366, [0x6e25] = 0xc367, [0x6e26] = 0xc368, [0x6e27] = 0xc369,
  [0x6e28] = 0xc36a, [0x6e29] = 0xc36b, [0x6e2a] = 0xc36c, [0x6e2b] = 0xc36d,
  [0x6e2c] = 0xc36e, [0x6e2d] = 0xc36f, [0x6e2e] = 0xc370, [0x6e2f] = 0xc371,
  [0x6e30] = 0xc372, [0x6e31] = 0xc373, [0x6e32] = 0xc374, [0x6e33] = 0xc375,
  [0x6e34] = 0xc376, [0x6e35] = 0xc377, [0x6e36] = 0xc378, [0x6e37] = 0xc379,
  [0x6e38] = 0xc37a, [0x6e39] = 0xc37b, [0x6e3a] = 0xc37c, [0x6e3b] = 0xc37d,
  [0x6e3c] = 0xc37e, [0x6e3d] = 0xc37f, [0x6e3e] = 0xc380, [0x6e3f] = 0xc381,
  [0x6e40] = 0xc382, [0x6e41] = 0xc383, [0x6e42] = 0xc384, [0x6e43] = 0xc385,
  [0x6e44] = 0xc386, [0x6e45] = 0xc387, [0x6e46] = 0xc388, [0x6e47] = 0xc389,
  [0x6e48] = 0xc38a, [0x6e49] = 0xc38b, [0x6e4a] = 0xc38c, [0x6e4b] = 0xc38d,
  [0x6e4c] = 0xc38e, [0x6e4d] = 0xc38f, [0x6e4e] = 0xc390, [0x6e4f] = 0xc391,
  [0x6e50] = 0xc392, [0x6e51] = 0xc393, [0x6e52] = 0xc394, [0x6e53] = 0xc395,
  [0x6e54] = 0xc396, [0x6e55] = 0xc397, [0x6e56] = 0xc398, [0x6e57] = 0xc399,
  [0x6e58] = 0xc39a, [0x6e59] = 0xc39b, [0x6e5a] = 0xc39c, [0x6e5b] = 0xc39d,
  [0x6e5c] = 0xc39e, [0x6e5d] = 0xc39f, [0x6e5e] = 0xc3a0, [0x6e5f] = 0xc3a1,
  [0x6e60] = 0xc3a2, [0x6e61] = 0xc3a3, [0x6e62] = 0xc3a4, [0x6e63] = 0xc3a5,
  [0x6e64] = 0xc3a6, [0x6e65] = 0xc3a7, [0x6e66] = 0xc3a8, [0x6e67] = 0xc3a9,
  [0x6e68] = 0xc3aa, [0x6e69] = 0xc3ab, [0x6e6a] = 0xc3ac, [0x6e6b] = 0xc3ad,
  [0x6e6c] = 0xc3ae, [0x6e6d] = 0xc3af, [0x6e6e] = 0xc3b0, [0x6e6f] = 0xc3b1,
  [0x6e70] = 0xc3b2, [0x6e71] = 0xc3b3, [0x6e72] = 0xc3b4, [0x6e73] = 0xc3b5,
  [0x6e74] = 0xc3b6, [0x6e75] = 0xc3b7, [0x6e76] = 0xc3b8, [0x6e77] = 0xc3b9,
  [0x6e78] = 0xc3ba, [0x6e79] = 0xc3bb, [0x6e7a] = 0xc3bc, [0x6e7b] = 0xc3bd,
  [0x6e7c] = 0xc3be, [0x6e7d] = 0xc3bf, [0x6e7e] = 0xc3c0, [0x6e7f] = 0xc3c1,
  [0x6e80] = 0xc3c2, [0x6e81] = 0xc3c3, [0x6e82] = 0xc3c4, [0x6e83] = 0xc3c5,
  [0x6e84] = 0xc3c6, [0x6e85] = 0xc3c7, [0x6e86] = 0xc3c8, [0x6e87] = 0xc3c9,
  [0x6e88] = 0xc3ca, [0x6e89] = 0xc3cb, [0x6e8a] = 0xc3cc, [0x6e8b] = 0xc3cd,
  [0x6e8c] = 0xc3ce, [0x6e8d] = 0xc3cf, [0x6e8e] = 0xc3d0, [0x6e8f] = 0xc3d1,
  [0x6e90] = 0xc3d2, [0x6e91] = 0xc3d3, [0x6e92] = 0xc3d4, [0x6e93] = 0xc3d5,
  [0x6e94] = 0xc3d6, [0x6e95] = 0xc3d7, [0x6e96] = 0xc3d8, [0x6e97] = 0xc3d9,
  [0x6e98] = 0xc3da, [0x6e99] = 0xc3db, [0x6e9a] = 0xc3dc, [0x6e9b] = 0xc3dd,
  [0x6e9c] = 0xc3de, [0x6e9d] = 0xc3df, [0x6e9e] = 0xc3e0, [0x6e9f] = 0xc3e1,
  [0x6ea0] = 0xc3e2, [0x6ea1] = 0xc3e3, [0x6ea2] = 0xc3e4, [0x6ea3] = 0xc3e5,
  [0x6ea4] = 0xc3e6, [0x6ea5] = 0xc3e7, [0x6ea6] = 0xc3e8, [0x6ea7] = 0xc3e9,
  [0x6ea8] = 0xc3ea, [0x6ea9] = 0xc3eb, [0x6eaa] = 0xc3ec, [0x6eab] = 0xc3ed,
  [0x6eac] = 0xc3ee, [0x6ead] = 0xc3ef, [0x6eae] = 0xc3f0, [0x6eaf] = 0xc3f1,
  [0x6eb0] = 0xc3f2, [0x6eb1] = 0xc3f3, [0x6eb2] = 0xc3f4, [0x6eb3] = 0xc3f5,
  [0x6eb4] = 0xc3f6, [0x6eb5] = 0xc3f7, [0x6eb6] = 0xc3f8, [0x6eb7] = 0xc3f9,
  [0x6eb8] = 0xc3fa, [0x6eb9] = 0xc3fb, [0x6eba] = 0xc3fc, [0x6ebb] = 0xc3fd,
  [0x6ebc] = 0xc3fe, [0x6ebd] = 0xc3ff, [0x6ebe] = 0xc400, [0x6ebf] = 0xc401,
  [0x6ec0] = 0xc402, [0x6ec1] = 0xc403, [0x6ec2] = 0xc404, [0x6ec3] = 0xc405,
  [0x6ec4] = 0xc406, [0x6ec5] = 0xc407, [0x6ec6] = 0xc408, [0x6ec7] = 0xc409,
  [0x6ec8] = 0xc40a, [0x6ec9] = 0xc40b, [0x6eca] = 0xc40c, [0x6ecb] = 0xc40d,
  [0x6ecc] = 0xc40e, [0x6ecd] = 0xc40f, [0x6ece] = 0xc410, [0x6ecf] = 0xc411,
  [0x6ed0] = 0xc412, [0x6ed1] = 0xc413, [0x6ed2] = 0xc414, [0x6ed3] = 0xc415,
  [0x6ed4] = 0xc416, [0x6ed5] = 0xc417, [0x6ed6] = 0xc418, [0x6ed7] = 0xc419,
  [0x6ed8] = 0xc41a, [0x6ed9] = 0xc41b, [0x6eda] = 0xc41c, [0x6edb] = 0xc41d,
  [0x6edc] = 0xc41e, [0x6edd] = 0xc41f, [0x6ede] = 0xc420, [0x6edf] = 0xc421,
  [0x6ee0] = 0xc422, [0x6ee1] = 0xc423, [0x6ee2] = 0xc424, [0x6ee3] = 0xc425,
  [0x6ee4] = 0xc426, [0x6ee5] = 0xc427, [0x6ee6] = 0xc428, [0x6ee7] = 0xc429,
  [0x6ee8] = 0xc42a, [0x6ee9] = 0xc42b, [0x6eea] = 0xc42c, [0x6eeb] = 0xc42d,
  [0x6eec] = 0xc42e, [0x6eed] = 0xc42f, [0x6eee] = 0xc430, [0x6eef] = 0xc431,
  [0x6ef0] = 0xc432, [0x6ef1] = 0xc433, [0x6ef2] = 0xc434, [0x6ef3] = 0xc435,
  [0x6ef4] = 0xc436, [0x6ef5] = 0xc437, [0x6ef6] = 0xc438, [0x6ef7] = 0xc439,
  [0x6ef8] = 0xc43a, [0x6ef9] = 0xc43b, [0x6efa] = 0xc43c, [0x6efb] = 0xc43d,
  [0x6efc] = 0xc43e, [0x6efd] = 0xc43f, [0x6efe] = 0xc440, [0x6eff] = 0xc441,
  [0x6f00] = 0xc442, [0x6f01] = 0xc443, [0x6f02] = 0xc444, [0x6f03] = 0xc445,
  [0x6f04] = 0xc446, [0x6f05] = 0xc447, [0x6f06] = 0xc448, [0x6f07] = 0xc449,
  [0x6f08] = 0xc44a, [0x6f09] = 0xc44b, [0x6f0a] = 0xc44c, [0x6f0b] = 0xc44d,
  [0x6f0c] = 0xc44e, [0x6f0d] = 0xc44f, [0x6f0e] = 0xc450, [0x6f0f] = 0xc451,
  [0x6f10] = 0xc452, [0x6f11] = 0xc453, [0x6f12] = 0xc454, [0x6f13] = 0xc455,
  [0x6f14] = 0xc456, [0x6f15] = 0xc457, [0x6f16] = 0xc458, [0x6f17] = 0xc459,
  [0x6f18] = 0xc45a, [0x6f19] = 0xc45b, [0x6f1a] = 0xc45c, [0x6f1b] = 0xc45d,
  [0x6f1c] = 0xc45e, [0x6f1d] = 0xc45f, [0x6f1e] = 0xc460, [0x6f1f] = 0xc461,
  [0x6f20] = 0xc462, [0x6f21] = 0xc463, [0x6f22] = 0xc464, [0x6f23] = 0xc465,
  [0x6f24] = 0xc466, [0x6f25] = 0xc467, [0x6f26] = 0xc468, [0x6f27] = 0xc469,
  [0x6f28] = 0xc46a, [0x6f29] = 0xc46b, [0x6f2a] = 0xc46c, [0x6f2b] = 0xc46d,
  [0x6f2c] = 0xc46e, [0x6f2d] = 0xc46f, [0x6f2e] = 0xc470, [0x6f2f] = 0xc471,
  [0x6f30] = 0xc472, [0x6f31] = 0xc473, [0x6f32] = 0xc474, [0x6f33] = 0xc475,
  [0x6f34] = 0xc476, [0x6f35] = 0xc477, [0x6f36] = 0xc478, [0x6f37] = 0xc479,
  [0x6f38] = 0xc47a, [0x6f39] = 0xc47b, [0x6f3a] = 0xc47c, [0x6f3b] = 0xc47d,
  [0x6f3c] = 0xc47e, [0x6f3d] = 0xc47f, [0x6f3e] = 0xc480, [0x6f3f] = 0xc481,
  [0x6f40] = 0xc482, [0x6f41] = 0xc483, [0x6f42] = 0xc484, [0x6f43] = 0xc485,
  [0x6f44] = 0xc486, [0x6f45] = 0xc487, [0x6f46] = 0xc488, [0x6f47] = 0xc489,
  [0x6f48] = 0xc48a, [0x6f49] = 0xc48b, [0x6f4a] = 0xc48c, [0x6f4b] = 0xc48d,
  [0x6f4c] = 0xc48e, [0x6f4d] = 0xc48f, [0x6f4e] = 0xc490, [0x6f4f] = 0xc491,
  [0x6f50] = 0xc492, [0x6f51] = 0xc493, [0x6f52] = 0xc494, [0x6f53] = 0xc495,
  [0x6f54] = 0xc496, [0x6f55] = 0xc497, [0x6f56] = 0xc498, [0x6f57] = 0xc499,
  [0x6f58] = 0xc49a, [0x6f59] = 0xc49b, [0x6f5a] = 0xc49c, [0x6f5b] = 0xc49d,
  [0x6f5c] = 0xc49e, [0x6f5d] = 0xc49f, [0x6f5e] = 0xc4a0, [0x6f5f] = 0xc4a1,
  [0x6f60] = 0xc4a2, [0x6f61] = 0xc4a3, [0x6f62] = 0xc4a4, [0x6f63] = 0xc4a5,
  [0x6f64] = 0xc4a6, [0x6f65] = 0xc4a7, [0x6f66] = 0xc4a8, [0x6f67] = 0xc4a9,
  [0x6f68] = 0xc4aa, [0x6f69] = 0xc4ab, [0x6f6a] = 0xc4ac, [0x6f6b] = 0xc4ad,
  [0x6f6c] = 0xc4ae, [0x6f6d] = 0xc4af, [0x6f6e] = 0xc4b0, [0x6f6f] = 0xc4b1,
  [0x6f70] = 0xc4b2, [0x6f71] = 0xc4b3, [0x6f72] = 0xc4b4, [0x6f73] = 0xc4b5,
  [0x6f74] = 0xc4b6, [0x6f75] = 0xc4b7, [0x6f76] = 0xc4b8, [0x6f77] = 0xc4b9,
  [0x6f78] = 0xc4ba, [0x6f79] = 0xc4bb, [0x6f7a] = 0xc4bc, [0x6f7b] = 0xc4bd,
  [0x6f7c] = 0xc4be, [0x6f7d] = 0xc4bf, [0x6f7e] = 0xc4c0, [0x6f7f] = 0xc4c1,
  [0x6f80] = 0xc4c2, [0x6f81] = 0xc4c3, [0x6f82] = 0xc4c4, [0x6f83] = 0xc4c5,
  [0x6f84] = 0xc4c6, [0x6f85] = 0xc4c7, [0x6f86] = 0xc4c8, [0x6f87] = 0xc4c9,
  [0x6f88] = 0xc4ca, [0x6f89] = 0xc4cb, [0x6f8a] = 0xc4cc, [0x6f8b] = 0xc4cd,
  [0x6f8c] = 0xc4ce, [0x6f8d] = 0xc4cf, [0x6f8e] = 0xc4d0, [0x6f8f] = 0xc4d1,
  [0x6f90] = 0xc4d2, [0x6f91] = 0xc4d3, [0x6f92] = 0xc4d4, [0x6f93] = 0xc4d5,
  [0x6f94] = 0xc4d6, [0x6f95] = 0xc4d7, [0x6f96] = 0xc4d8, [0x6f97] = 0xc4d9,
  [0x6f98] = 0xc4da, [0x6f99] = 0xc4db, [0x6f9a] = 0xc4dc, [0x6f9b] = 0xc4dd,
  [0x6f9c] = 0xc4de, [0x6f9d] = 0xc4df, [0x6f9e] = 0xc4e0, [0x6f9f] = 0xc4e1,
  [0x6fa0] = 0xc4e2, [0x6fa1] = 0xc4e3, [0x6fa2] = 0xc4e4, [0x6fa3] = 0xc4e5,
  [0x6fa4] = 0xc4e6, [0x6fa5] = 0xc4e7, [0x6fa6] = 0xc4e8, [0x6fa7] = 0xc4e9,
  [0x6fa8] = 0xc4ea, [0x6fa9] = 0xc4eb, [0x6faa] = 0xc4ec, [0x6fab] = 0xc4ed,
  [0x6fac] = 0xc4ee, [0x6fad] = 0xc4ef, [0x6fae] = 0xc4f0, [0x6faf] = 0xc4f1,
  [0x6fb0] = 0xc4f2, [0x6fb1] = 0xc4f3, [0x6fb2] = 0xc4f4, [0x6fb3] = 0xc4f5,
  [0x6fb4] = 0xc4f6, [0x6fb5] = 0xc4f7, [0x6fb6] = 0xc4f8, [0x6fb7] = 0xc4f9,
  [0x6fb8] = 0xc4fa, [0x6fb9] = 0xc4fb, [0x6fba] = 0xc4fc, [0x6fbb] = 0xc4fd,
  [0x6fbc] = 0xc4fe, [0x6fbd] = 0xc4ff, [0x6fbe] = 0xc500, [0x6fbf] = 0xc501,
  [0x6fc0] = 0xc502, [0x6fc1] = 0xc503, [0x6fc2] = 0xc504, [0x6fc3] = 0xc505,
  [0x6fc4] = 0xc506, [0x6fc5] = 0xc507, [0x6fc6] = 0xc508, [0x6fc7] = 0xc509,
  [0x6fc8] = 0xc50a, [0x6fc9] = 0xc50b, [0x6fca] = 0xc50c, [0x6fcb] = 0xc50d,
  [0x6fcc] = 0xc50e, [0x6fcd] = 0xc50f, [0x6fce] = 0xc510, [0x6fcf] = 0xc511,
  [0x6fd0] = 0xc512, [0x6fd1] = 0xc513, [0x6fd2] = 0xc514, [0x6fd3] = 0xc515,
  [0x6fd4] = 0xc516, [0x6fd5] = 0xc517, [0x6fd6] = 0xc518, [0x6fd7] = 0xc519,
  [0x6fd8] = 0xc51a, [0x6fd9] = 0xc51b, [0x6fda] = 0xc51c, [0x6fdb] = 0xc51d,
  [0x6fdc] = 0xc51e, [0x6fdd] = 0xc51f, [0x6fde] = 0xc520, [0x6fdf] = 0xc521,
  [0x6fe0] = 0xc522, [0x6fe1] = 0xc523, [0x6fe2] = 0xc524, [0x6fe3] = 0xc525,
  [0x6fe4] = 0xc526, [0x6fe5] = 0xc527, [0x6fe6] = 0xc528, [0x6fe7] = 0xc529,
  [0x6fe8] = 0xc52a, [0x6fe9] = 0xc52b, [0x6fea] = 0xc52c, [0x6feb] = 0xc52d,
  [0x6fec] = 0xc52e, [0x6fed] = 0xc52f, [0x6fee] = 0xc530, [0x6fef] = 0xc531,
  [0x6ff0] = 0xc532, [0x6ff1] = 0xc533, [0x6ff2] = 0xc534, [0x6ff3] = 0xc535,
  [0x6ff4] = 0xc536, [0x6ff5] = 0xc537, [0x6ff6] = 0xc538, [0x6ff7] = 0xc539,
  [0x6ff8] = 0xc53a, [0x6ff9] = 0xc53b, [0x6ffa] = 0xc53c, [0x6ffb] = 0xc53d,
  [0x6ffc] = 0xc53e, [0x6ffd] = 0xc53f, [0x6ffe] = 0xc540, [0x6fff] = 0xc541,
  [0x7000] = 0xc542, [0x7001] = 0xc543, [0x7002] = 0xc544, [0x7003] = 0xc545,
  [0x7004] = 0xc546, [0x7005] = 0xc547, [0x7006] = 0xc548, [0x7007] = 0xc549,
  [0x7008] = 0xc54a, [0x7009] = 0xc54b, [0x700a] = 0xc54c, [0x700b] = 0xc54d,
  [0x700c] = 0xc54e, [0x700d] = 0xc54f, [0x700e] = 0xc550, [0x700f] = 0xc551,
  [0x7010] = 0xc552, [0x7011] = 0xc553, [0x7012] = 0xc554, [0x7013] = 0xc555,
  [0x7014] = 0xc556, [0x7015] = 0xc557, [0x7016] = 0xc558, [0x7017] = 0xc559,
  [0x7018] = 0xc55a, [0x7019] = 0xc55b, [0x701a] = 0xc55c, [0x701b] = 0xc55d,
  [0x701c] = 0xc55e, [0x701d] = 0xc55f, [0x701e] = 0xc560, [0x701f] = 0xc561,
  [0x7020] = 0xc562, [0x7021] = 0xc563, [0x7022] = 0xc564, [0x7023] = 0xc565,
  [0x7024] = 0xc566, [0x7025] = 0xc567, [0x7026] = 0xc568, [0x7027] = 0xc569,
  [0x7028] = 0xc56a, [0x7029] = 0xc56b, [0x702a] = 0xc56c, [0x702b] = 0xc56d,
  [0x702c] = 0xc56e, [0x702d] = 0xc56f, [0x702e] = 0xc570, [0x702f] = 0xc571,
  [0x7030] = 0xc572, [0x7031] = 0xc573, [0x7032] = 0xc574, [0x7033] = 0xc575,
  [0x7034] = 0xc576, [0x7035] = 0xc577, [0x7036] = 0xc578, [0x7037] = 0xc579,
  [0x7038] = 0xc57a, [0x7039] = 0xc57b, [0x703a] = 0xc57c, [0x703b] = 0xc57d,
  [0x703c] = 0xc57e, [0x703d] = 0xc57f, [0x703e] = 0xc580, [0x703f] = 0xc581,
  [0x7040] = 0xc582, [0x7041] = 0xc583, [0x7042] = 0xc584, [0x7043] = 0xc585,
  [0x7044] = 0xc586, [0x7045] = 0xc587, [0x7046] = 0xc588, [0x7047] = 0xc589,
  [0x7048] = 0xc58a, [0x7049] = 0xc58b, [0x704a] = 0xc58c, [0x704b] = 0xc58d,
  [0x704c] = 0xc58e, [0x704d] = 0xc58f, [0x704e] = 0xc590, [0x704f] = 0xc591,
  [0x7050] = 0xc592, [0x7051] = 0xc593, [0x7052] = 0xc594, [0x7053] = 0xc595,
  [0x7054] = 0xc596, [0x7055] = 0xc597, [0x7056] = 0xc598, [0x7057] = 0xc599,
  [0x7058] = 0xc59a, [0x7059] = 0xc59b, [0x705a] = 0xc59c, [0x705b] = 0xc59d,
  [0x705c] = 0xc59e, [0x705d] = 0xc59f, [0x705e] = 0xc5a0, [0x705f] = 0xc5a1,
  [0x7060] = 0xc5a2, [0x7061] = 0xc5a3, [0x7062] = 0xc5a4, [0x7063] = 0xc5a5,
  [0x7064] = 0xc5a6, [0x7065] = 0xc5a7, [0x7066] = 0xc5a8, [0x7067] = 0xc5a9,
  [0x7068] = 0xc5aa, [0x7069] = 0xc5ab, [0x706a] = 0xc5ac, [0x706b] = 0xc5ad,
  [0x706c] = 0xc5ae, [0x706d] = 0xc5af, [0x706e] = 0xc5b0, [0x706f] = 0xc5b1,
  [0x7070] = 0xc5b2, [0x7071] = 0xc5b3, [0x7072] = 0xc5b4, [0x7073] = 0xc5b5,
  [0x7074] = 0xc5b6, [0x7075] = 0xc5b7, [0x7076] = 0xc5b8, [0x7077] = 0xc5b9,
  [0x7078] = 0xc5ba, [0x7079] = 0xc5bb, [0x707a] = 0xc5bc, [0x707b] = 0xc5bd,
  [0x707c] = 0xc5be, [0x707d] = 0xc5bf, [0x707e] = 0xc5c0, [0x707f] = 0xc5c1,
  [0x7080] = 0xc5c2, [0x7081] = 0xc5c3, [0x7082] = 0xc5c4, [0x7083] = 0xc5c5,
  [0x7084] = 0xc5c6, [0x7085] = 0xc5c7, [0x7086] = 0xc5c8, [0x7087] = 0xc5c9,
  [0x7088] = 0xc5ca, [0x7089] = 0xc5cb, [0x708a] = 0xc5cc, [0x708b] = 0xc5cd,
  [0x708c] = 0xc5ce, [0x708d] = 0xc5cf, [0x708e] = 0xc5d0, [0x708f] = 0xc5d1,
  [0x7090] = 0xc5d2, [0x7091] = 0xc5d3, [0x7092] = 0xc5d4, [0x7093] = 0xc5d5,
  [0x7094] = 0xc5d6, [0x7095] = 0xc5d7, [0x7096] = 0xc5d8, [0x7097] = 0xc5d9,
  [0x7098] = 0xc5da, [0x7099] = 0xc5db, [0x709a] = 0xc5dc, [0x709b] = 0xc5dd,
  [0x709c] = 0xc5de, [0x709d] = 0xc5df, [0x709e] = 0xc5e0, [0x709f] = 0xc5e1,
  [0x70a0] = 0xc5e2, [0x70a1] = 0xc5e3, [0x70a2] = 0xc5e4, [0x70a3] = 0xc5e5,
  [0x70a4] = 0xc5e6, [0x70a5] = 0xc5e7, [0x70a6] = 0xc5e8, [0x70a7] = 0xc5e9,
  [0x70a8] = 0xc5ea, [0x70a9] = 0xc5eb, [0x70aa] = 0xc5ec, [0x70ab] = 0xc5ed,
  [0x70ac] = 0xc5ee, [0x70ad] = 0xc5ef, [0x70ae] = 0xc5f0, [0x70af] = 0xc5f1,
  [0x70b0] = 0xc5f2, [0x70b1] = 0xc5f3, [0x70b2] = 0xc5f4, [0x70b3] = 0xc5f5,
  [0x70b4] = 0xc5f6, [0x70b5] = 0xc5f7, [0x70b6] = 0xc5f8, [0x70b7] = 0xc5f9,
  [0x70b8] = 0xc5fa, [0x70b9] = 0xc5fb, [0x70ba] = 0xc5fc, [0x70bb] = 0xc5fd,
  [0x70bc] = 0xc5fe, [0x70bd] = 0xc5ff, [0x70be] = 0xc600, [0x70bf] = 0xc601,
  [0x70c0] = 0xc602, [0x70c1] = 0xc603, [0x70c2] = 0xc604, [0x70c3] = 0xc605,
  [0x70c4] = 0xc606, [0x70c5] = 0xc607, [0x70c6] = 0xc608, [0x70c7] = 0xc609,
  [0x70c8] = 0xc60a, [0x70c9] = 0xc60b, [0x70ca] = 0xc60c, [0x70cb] = 0xc60d,
  [0x70cc] = 0xc60e, [0x70cd] = 0xc60f, [0x70ce] = 0xc610, [0x70cf] = 0xc611,
  [0x70d0] = 0xc612, [0x70d1] = 0xc613, [0x70d2] = 0xc614, [0x70d3] = 0xc615,
  [0x70d4] = 0xc616, [0x70d5] = 0xc617, [0x70d6] = 0xc618, [0x70d7] = 0xc619,
  [0x70d8] = 0xc61a, [0x70d9] = 0xc61b, [0x70da] = 0xc61c, [0x70db] = 0xc61d,
  [0x70dc] = 0xc61e, [0x70dd] = 0xc61f, [0x70de] = 0xc620, [0x70df] = 0xc621,
  [0x70e0] = 0xc622, [0x70e1] = 0xc623, [0x70e2] = 0xc624, [0x70e3] = 0xc625,
  [0x70e4] = 0xc626, [0x70e5] = 0xc627, [0x70e6] = 0xc628, [0x70e7] = 0xc629,
  [0x70e8] = 0xc62a, [0x70e9] = 0xc62b, [0x70ea] = 0xc62c, [0x70eb] = 0xc62d,
  [0x70ec] = 0xc62e, [0x70ed] = 0xc62f, [0x70ee] = 0xc630, [0x70ef] = 0xc631,
  [0x70f0] = 0xc632, [0x70f1] = 0xc633, [0x70f2] = 0xc634, [0x70f3] = 0xc635,
  [0x70f4] = 0xc636, [0x70f5] = 0xc637, [0x70f6] = 0xc638, [0x70f7] = 0xc639,
  [0x70f8] = 0xc63a, [0x70f9] = 0xc63b, [0x70fa] = 0xc63c, [0x70fb] = 0xc63d,
  [0x70fc] = 0xc63e, [0x70fd] = 0xc63f, [0x70fe] = 0xc640, [0x70ff] = 0xc641,
  [0x7100] = 0xc642, [0x7101] = 0xc643, [0x7102] = 0xc644, [0x7103] = 0xc645,
  [0x7104] = 0xc646, [0x7105] = 0xc647, [0x7106] = 0xc648, [0x7107] = 0xc649,
  [0x7108] = 0xc64a, [0x7109] = 0xc64b, [0x710a] = 0xc64c, [0x710b] = 0xc64d,
  [0x710c] = 0xc64e, [0x710d] = 0xc64f, [0x710e] = 0xc650, [0x710f] = 0xc651,
  [0x7110] = 0xc652, [0x7111] = 0xc653, [0x7112] = 0xc654, [0x7113] = 0xc655,
  [0x7114] = 0xc656, [0x7115] = 0xc657, [0x7116] = 0xc658, [0x7117] = 0xc659,
  [0x7118] = 0xc65a, [0x7119] = 0xc65b, [0x711a] = 0xc65c, [0x711b] = 0xc65d,
  [0x711c] = 0xc65e, [0x711d] = 0xc65f, [0x711e] = 0xc660, [0x711f] = 0xc661,
  [0x7120] = 0xc662, [0x7121] = 0xc663, [0x7122] = 0xc664, [0x7123] = 0xc665,
  [0x7124] = 0xc666, [0x7125] = 0xc667, [0x7126] = 0xc668, [0x7127] = 0xc669,
  [0x7128] = 0xc66a, [0x7129] = 0xc66b, [0x712a] = 0xc66c, [0x712b] = 0xc66d,
  [0x712c] = 0xc66e, [0x712d] = 0xc66f, [0x712e] = 0xc670, [0x712f] = 0xc671,
  [0x7130] = 0xc672, [0x7131] = 0xc673, [0x7132] = 0xc674, [0x7133] = 0xc675,
  [0x7134] = 0xc676, [0x7135] = 0xc677, [0x7136] = 0xc678, [0x7137] = 0xc679,
  [0x7138] = 0xc67a, [0x7139] = 0xc67b, [0x713a] = 0xc67c, [0x713b] = 0xc67d,
  [0x713c] = 0xc67e, [0x713d] = 0xc67f, [0x713e] = 0xc680, [0x713f] = 0xc681,
  [0x7140] = 0xc682, [0x7141] = 0xc683, [0x7142] = 0xc684, [0x7143] = 0xc685,
  [0x7144] = 0xc686, [0x7145] = 0xc687, [0x7146] = 0xc688, [0x7147] = 0xc689,
  [0x7148] = 0xc68a, [0x7149] = 0xc68b, [0x714a] = 0xc68c, [0x714b] = 0xc68d,
  [0x714c] = 0xc68e, [0x714d] = 0xc68f, [0x714e] = 0xc690, [0x714f] = 0xc691,
  [0x7150] = 0xc692, [0x7151] = 0xc693, [0x7152] = 0xc694, [0x7153] = 0xc695,
  [0x7154] = 0xc696, [0x7155] = 0xc697, [0x7156] = 0xc698, [0x7157] = 0xc699,
  [0x7158] = 0xc69a, [0x7159] = 0xc69b, [0x715a] = 0xc69c, [0x715b] = 0xc69d,
  [0x715c] = 0xc69e, [0x715d] = 0xc69f, [0x715e] = 0xc6a0, [0x715f] = 0xc6a1,
  [0x7160] = 0xc6a2, [0x7161] = 0xc6a3, [0x7162] = 0xc6a4, [0x7163] = 0xc6a5,
  [0x7164] = 0xc6a6, [0x7165] = 0xc6a7, [0x7166] = 0xc6a8, [0x7167] = 0xc6a9,
  [0x7168] = 0xc6aa, [0x7169] = 0xc6ab, [0x716a] = 0xc6ac, [0x716b] = 0xc6ad,
  [0x716c] = 0xc6ae, [0x716d] = 0xc6af, [0x716e] = 0xc6b0, [0x716f] = 0xc6b1,
  [0x7170] = 0xc6b2, [0x7171] = 0xc6b3, [0x7172] = 0xc6b4, [0x7173] = 0xc6b5,
  [0x7174] = 0xc6b6, [0x7175] = 0xc6b7, [0x7176] = 0xc6b8, [0x7177] = 0xc6b9,
  [0x7178] = 0xc6ba, [0x7179] = 0xc6bb, [0x717a] = 0xc6bc, [0x717b] = 0xc6bd,
  [0x717c] = 0xc6be, [0x717d] = 0xc6bf, [0x717e] = 0xc6c0, [0x717f] = 0xc6c1,
  [0x7180] = 0xc6c2, [0x7181] = 0xc6c3, [0x7182] = 0xc6c4, [0x7183] = 0xc6c5,
  [0x7184] = 0xc6c6, [0x7185] = 0xc6c7, [0x7186] = 0xc6c8, [0x7187] = 0xc6c9,
  [0x7188] = 0xc6ca, [0x7189] = 0xc6cb, [0x718a] = 0xc6cc, [0x718b] = 0xc6cd,
  [0x718c] = 0xc6ce, [0x718d] = 0xc6cf, [0x718e] = 0xc6d0, [0x718f] = 0xc6d1,
  [0x7190] = 0xc6d2, [0x7191] = 0xc6d3, [0x7192] = 0xc6d4, [0x7193] = 0xc6d5,
  [0x7194] = 0xc6d6, [0x7195] = 0xc6d7, [0x7196] = 0xc6d8, [0x7197] = 0xc6d9,
  [0x7198] = 0xc6da, [0x7199] = 0xc6db, [0x719a] = 0xc6dc, [0x719b] = 0xc6dd,
  [0x719c] = 0xc6de, [0x719d] = 0xc6df, [0x719e] = 0xc6e0, [0x719f] = 0xc6e1,
  [0x71a0] = 0xc6e2, [0x71a1] = 0xc6e3, [0x71a2] = 0xc6e4, [0x71a3] = 0xc6e5,
  [0x71a4] = 0xc6e6, [0x71a5] = 0xc6e7, [0x71a6] = 0xc6e8, [0x71a7] = 0xc6e9,
  [0x71a8] = 0xc6ea, [0x71a9] = 0xc6eb, [0x71aa] = 0xc6ec, [0x71ab] = 0xc6ed,
  [0x71ac] = 0xc6ee, [0x71ad] = 0xc6ef, [0x71ae] = 0xc6f0, [0x71af] = 0xc6f1,
  [0x71b0] = 0xc6f2, [0x71b1] = 0xc6f3, [0x71b2] = 0xc6f4, [0x71b3] = 0xc6f5,
  [0x71b4] = 0xc6f6, [0x71b5] = 0xc6f7, [0x71b6] = 0xc6f8, [0x71b7] = 0xc6f9,
  [0x71b8] = 0xc6fa, [0x71b9] = 0xc6fb, [0x71ba] = 0xc6fc, [0x71bb] = 0xc6fd,
  [0x71bc] = 0xc6fe, [0x71bd] = 0xc6ff, [0x71be] = 0xc700, [0x71bf] = 0xc701,
  [0x71c0] = 0xc702, [0x71c1] = 0xc703, [0x71c2] = 0xc704, [0x71c3] = 0xc705,
  [0x71c4] = 0xc706, [0x71c5] = 0xc707, [0x71c6] = 0xc708, [0x71c7] = 0xc709,
  [0x71c8] = 0xc70a, [0x71c9] = 0xc70b, [0x71ca] = 0xc70c, [0x71cb] = 0xc70d,
  [0x71cc] = 0xc70e, [0x71cd] = 0xc70f, [0x71ce] = 0xc710, [0x71cf] = 0xc711,
  [0x71d0] = 0xc712, [0x71d1] = 0xc713, [0x71d2] = 0xc714, [0x71d3] = 0xc715,
  [0x71d4] = 0xc716, [0x71d5] = 0xc717, [0x71d6] = 0xc718, [0x71d7] = 0xc719,
  [0x71d8] = 0xc71a, [0x71d9] = 0xc71b, [0x71da] = 0xc71c, [0x71db] = 0xc71d,
  [0x71dc] = 0xc71e, [0x71dd] = 0xc71f, [0x71de] = 0xc720, [0x71df] = 0xc721,
  [0x71e0] = 0xc722, [0x71e1] = 0xc723, [0x71e2] = 0xc724, [0x71e3] = 0xc725,
  [0x71e4] = 0xc726, [0x71e5] = 0xc727, [0x71e6] = 0xc728, [0x71e7] = 0xc729,
  [0x71e8] = 0xc72a, [0x71e9] = 0xc72b, [0x71ea] = 0xc72c, [0x71eb] = 0xc72d,
  [0x71ec] = 0xc72e, [0x71ed] = 0xc72f, [0x71ee] = 0xc730, [0x71ef] = 0xc731,
  [0x71f0] = 0xc732, [0x71f1] = 0xc733, [0x71f2] = 0xc734, [0x71f3] = 0xc735,
  [0x71f4] = 0xc736, [0x71f5] = 0xc737, [0x71f6] = 0xc738, [0x71f7] = 0xc739,
  [0x71f8] = 0xc73a, [0x71f9] = 0xc73b, [0x71fa] = 0xc73c, [0x71fb] = 0xc73d,
  [0x71fc] = 0xc73e, [0x71fd] = 0xc73f, [0x71fe] = 0xc740, [0x71ff] = 0xc741,
  [0x7200] = 0xc742, [0x7201] = 0xc743, [0x7202] = 0xc744, [0x7203] = 0xc745,
  [0x7204] = 0xc746, [0x7205] = 0xc747, [0x7206] = 0xc748, [0x7207] = 0xc749,
  [0x7208] = 0xc74a, [0x7209] = 0xc74b, [0x720a] = 0xc74c, [0x720b] = 0xc74d,
  [0x720c] = 0xc74e, [0x720d] = 0xc74f, [0x720e] = 0xc750, [0x720f] = 0xc751,
  [0x7210] = 0xc752, [0x7211] = 0xc753, [0x7212] = 0xc754, [0x7213] = 0xc755,
  [0x7214] = 0xc756, [0x7215] = 0xc757, [0x7216] = 0xc758, [0x7217] = 0xc759,
  [0x7218] = 0xc75a, [0x7219] = 0xc75b, [0x721a] = 0xc75c, [0x721b] = 0xc75d,
  [0x721c] = 0xc75e, [0x721d] = 0xc75f, [0x721e] = 0xc760, [0x721f] = 0xc761,
  [0x7220] = 0xc762, [0x7221] = 0xc763, [0x7222] = 0xc764, [0x7223] = 0xc765,
  [0x7224] = 0xc766, [0x7225] = 0xc767, [0x7226] = 0xc768, [0x7227] = 0xc769,
  [0x7228] = 0xc76a, [0x7229] = 0xc76b, [0x722a] = 0xc76c, [0x722b] = 0xc76d,
  [0x722c] = 0xc76e, [0x722d] = 0xc76f, [0x722e] = 0xc770, [0x722f] = 0xc771,
  [0x7230] = 0xc772, [0x7231] = 0xc773, [0x7232] = 0xc774, [0x7233] = 0xc775,
  [0x7234] = 0xc776, [0x7235] = 0xc777, [0x7236] = 0xc778, [0x7237] = 0xc779,
  [0x7238] = 0xc77a, [0x7239] = 0xc77b, [0x723a] = 0xc77c, [0x723b] = 0xc77d,
  [0x723c] = 0xc77e, [0x723d] = 0xc77f, [0x723e] = 0xc780, [0x723f] = 0xc781,
  [0x7240] = 0xc782, [0x7241] = 0xc783, [0x7242] = 0xc784, [0x7243] = 0xc785,
  [0x7244] = 0xc786, [0x7245] = 0xc787, [0x7246] = 0xc788, [0x7247] = 0xc789,
  [0x7248] = 0xc78a, [0x7249] = 0xc78b, [0x724a] = 0xc78c, [0x724b] = 0xc78d,
  [0x724c] = 0xc78e, [0x724d] = 0xc78f, [0x724e] = 0xc790, [0x724f] = 0xc791,
  [0x7250] = 0xc792, [0x7251] = 0xc793, [0x7252] = 0xc794, [0x7253] = 0xc795,
  [0x7254] = 0xc796, [0x7255] = 0xc797, [0x7256] = 0xc798, [0x7257] = 0xc799,
  [0x7258] = 0xc79a, [0x7259] = 0xc79b, [0x725a] = 0xc79c, [0x725b] = 0xc79d,
  [0x725c] = 0xc79e, [0x725d] = 0xc79f, [0x725e] = 0xc7a0, [0x725f] = 0xc7a1,
  [0x7260] = 0xc7a2, [0x7261] = 0xc7a3, [0x7262] = 0xc7a4, [0x7263] = 0xc7a5,
  [0x7264] = 0xc7a6, [0x7265] = 0xc7a7, [0x7266] = 0xc7a8, [0x7267] = 0xc7a9,
  [0x7268] = 0xc7aa, [0x7269] = 0xc7ab, [0x726a] = 0xc7ac, [0x726b] = 0xc7ad,
  [0x726c] = 0xc7ae, [0x726d] = 0xc7af, [0x726e] = 0xc7b0, [0x726f] = 0xc7b1,
  [0x7270] = 0xc7b2, [0x7271] = 0xc7b3, [0x7272] = 0xc7b4, [0x7273] = 0xc7b5,
  [0x7274] = 0xc7b6, [0x7275] = 0xc7b7, [0x7276] = 0xc7b8, [0x7277] = 0xc7b9,
  [0x7278] = 0xc7ba, [0x7279] = 0xc7bb, [0x727a] = 0xc7bc, [0x727b] = 0xc7bd,
  [0x727c] = 0xc7be, [0x727d] = 0xc7bf, [0x727e] = 0xc7c0, [0x727f] = 0xc7c1,
  [0x7280] = 0xc7c2, [0x7281] = 0xc7c3, [0x7282] = 0xc7c4, [0x7283] = 0xc7c5,
  [0x7284] = 0xc7c6, [0x7285] = 0xc7c7, [0x7286] = 0xc7c8, [0x7287] = 0xc7c9,
  [0x7288] = 0xc7ca, [0x7289] = 0xc7cb, [0x728a] = 0xc7cc, [0x728b] = 0xc7cd,
  [0x728c] = 0xc7ce, [0x728d] = 0xc7cf, [0x728e] = 0xc7d0, [0x728f] = 0xc7d1,
  [0x7290] = 0xc7d2, [0x7291] = 0xc7d3, [0x7292] = 0xc7d4, [0x7293] = 0xc7d5,
  [0x7294] = 0xc7d6, [0x7295] = 0xc7d7, [0x7296] = 0xc7d8, [0x7297] = 0xc7d9,
  [0x7298] = 0xc7da, [0x7299] = 0xc7db, [0x729a] = 0xc7dc, [0x729b] = 0xc7dd,
  [0x729c] = 0xc7de, [0x729d] = 0xc7df, [0x729e] = 0xc7e0, [0x729f] = 0xc7e1,
  [0x72a0] = 0xc7e2, [0x72a1] = 0xc7e3, [0x72a2] = 0xc7e4, [0x72a3] = 0xc7e5,
  [0x72a4] = 0xc7e6, [0x72a5] = 0xc7e7, [0x72a6] = 0xc7e8, [0x72a7] = 0xc7e9,
  [0x72a8] = 0xc7ea, [0x72a9] = 0xc7eb, [0x72aa] = 0xc7ec, [0x72ab] = 0xc7ed,
  [0x72ac] = 0xc7ee, [0x72ad] = 0xc7ef, [0x72ae] = 0xc7f0, [0x72af] = 0xc7f1,
  [0x72b0] = 0xc7f2, [0x72b1] = 0xc7f3, [0x72b2] = 0xc7f4, [0x72b3] = 0xc7f5,
  [0x72b4] = 0xc7f6, [0x72b5] = 0xc7f7, [0x72b6] = 0xc7f8, [0x72b7] = 0xc7f9,
  [0x72b8] = 0xc7fa, [0x72b9] = 0xc7fb, [0x72ba] = 0xc7fc, [0x72bb] = 0xc7fd,
  [0x72bc] = 0xc7fe, [0x72bd] = 0xc7ff, [0x72be] = 0xc800, [0x72bf] = 0xc801,
  [0x72c0] = 0xc802, [0x72c1] = 0xc803, [0x72c2] = 0xc804, [0x72c3] = 0xc805,
  [0x72c4] = 0xc806, [0x72c5] = 0xc807, [0x72c6] = 0xc808, [0x72c7] = 0xc809,
  [0x72c8] = 0xc80a, [0x72c9] = 0xc80b, [0x72ca] = 0xc80c, [0x72cb] = 0xc80d,
  [0x72cc] = 0xc80e, [0x72cd] = 0xc80f, [0x72ce] = 0xc810, [0x72cf] = 0xc811,
  [0x72d0] = 0xc812, [0x72d1] = 0xc813, [0x72d2] = 0xc814, [0x72d3] = 0xc815,
  [0x72d4] = 0xc816, [0x72d5] = 0xc817, [0x72d6] = 0xc818, [0x72d7] = 0xc819,
  [0x72d8] = 0xc81a, [0x72d9] = 0xc81b, [0x72da] = 0xc81c, [0x72db] = 0xc81d,
  [0x72dc] = 0xc81e, [0x72dd] = 0xc81f, [0x72de] = 0xc820, [0x72df] = 0xc821,
  [0x72e0] = 0xc822, [0x72e1] = 0xc823, [0x72e2] = 0xc824, [0x72e3] = 0xc825,
  [0x72e4] = 0xc826, [0x72e5] = 0xc827, [0x72e6] = 0xc828, [0x72e7] = 0xc829,
  [0x72e8] = 0xc82a, [0x72e9] = 0xc82b, [0x72ea] = 0xc82c, [0x72eb] = 0xc82d,
  [0x72ec] = 0xc82e, [0x72ed] = 0xc82f, [0x72ee] = 0xc830, [0x72ef] = 0xc831,
  [0x72f0] = 0xc832, [0x72f1] = 0xc833, [0x72f2] = 0xc834, [0x72f3] = 0xc835,
  [0x72f4] = 0xc836, [0x72f5] = 0xc837, [0x72f6] = 0xc838, [0x72f7] = 0xc839,
  [0x72f8] = 0xc83a, [0x72f9] = 0xc83b, [0x72fa] = 0xc83c, [0x72fb] = 0xc83d,
  [0x72fc] = 0xc83e, [0x72fd] = 0xc83f, [0x72fe] = 0xc840, [0x72ff] = 0xc841,
  [0x7300] = 0xc842, [0x7301] = 0xc843, [0x7302] = 0xc844, [0x7303] = 0xc845,
  [0x7304] = 0xc846, [0x7305] = 0xc847, [0x7306] = 0xc848, [0x7307] = 0xc849,
  [0x7308] = 0xc84a, [0x7309] = 0xc84b, [0x730a] = 0xc84c, [0x730b] = 0xc84d,
  [0x730c] = 0xc84e, [0x730d] = 0xc84f, [0x730e] = 0xc850, [0x730f] = 0xc851,
  [0x7310] = 0xc852, [0x7311] = 0xc853, [0x7312] = 0xc854, [0x7313] = 0xc855,
  [0x7314] = 0xc856, [0x7315] = 0xc857, [0x7316] = 0xc858, [0x7317] = 0xc859,
  [0x7318] = 0xc85a, [0x7319] = 0xc85b, [0x731a] = 0xc85c, [0x731b] = 0xc85d,
  [0x731c] = 0xc85e, [0x731d] = 0xc85f, [0x731e] = 0xc860, [0x731f] = 0xc861,
  [0x7320] = 0xc862, [0x7321] = 0xc863, [0x7322] = 0xc864, [0x7323] = 0xc865,
  [0x7324] = 0xc866, [0x7325] = 0xc867, [0x7326] = 0xc868, [0x7327] = 0xc869,
  [0x7328] = 0xc86a, [0x7329] = 0xc86b, [0x732a] = 0xc86c, [0x732b] = 0xc86d,
  [0x732c] = 0xc86e, [0x732d] = 0xc86f, [0x732e] = 0xc870, [0x732f] = 0xc871,
  [0x7330] = 0xc872, [0x7331] = 0xc873, [0x7332] = 0xc874, [0x7333] = 0xc875,
  [0x7334] = 0xc876, [0x7335] = 0xc877, [0x7336] = 0xc878, [0x7337] = 0xc879,
  [0x7338] = 0xc87a, [0x7339] = 0xc87b, [0x733a] = 0xc87c, [0x733b] = 0xc87d,
  [0x733c] = 0xc87e, [0x733d] = 0xc87f, [0x733e] = 0xc880, [0x733f] = 0xc881,
  [0x7340] = 0xc882, [0x7341] = 0xc883, [0x7342] = 0xc884, [0x7343] = 0xc885,
  [0x7344] = 0xc886, [0x7345] = 0xc887, [0x7346] = 0xc888, [0x7347] = 0xc889,
  [0x7348] = 0xc88a, [0x7349] = 0xc88b, [0x734a] = 0xc88c, [0x734b] = 0xc88d,
  [0x734c] = 0xc88e, [0x734d] = 0xc88f, [0x734e] = 0xc890, [0x734f] = 0xc891,
  [0x7350] = 0xc892, [0x7351] = 0xc893, [0x7352] = 0xc894, [0x7353] = 0xc895,
  [0x7354] = 0xc896, [0x7355] = 0xc897, [0x7356] = 0xc898, [0x7357] = 0xc899,
  [0x7358] = 0xc89a, [0x7359] = 0xc89b, [0x735a] = 0xc89c, [0x735b] = 0xc89d,
  [0x735c] = 0xc89e, [0x735d] = 0xc89f, [0x735e] = 0xc8a0, [0x735f] = 0xc8a1,
  [0x7360] = 0xc8a2, [0x7361] = 0xc8a3, [0x7362] = 0xc8a4, [0x7363] = 0xc8a5,
  [0x7364] = 0xc8a6, [0x7365] = 0xc8a7, [0x7366] = 0xc8a8, [0x7367] = 0xc8a9,
  [0x7368] = 0xc8aa, [0x7369] = 0xc8ab, [0x736a] = 0xc8ac, [0x736b] = 0xc8ad,
  [0x736c] = 0xc8ae, [0x736d] = 0xc8af, [0x736e] = 0xc8b0, [0x736f] = 0xc8b1,
  [0x7370] = 0xc8b2, [0x7371] = 0xc8b3, [0x7372] = 0xc8b4, [0x7373] = 0xc8b5,
  [0x7374] = 0xc8b6, [0x7375] = 0xc8b7, [0x7376] = 0xc8b8, [0x7377] = 0xc8b9,
  [0x7378] = 0xc8ba, [0x7379] = 0xc8bb, [0x737a] = 0xc8bc, [0x737b] = 0xc8bd,
  [0x737c] = 0xc8be, [0x737d] = 0xc8bf, [0x737e] = 0xc8c0, [0x737f] = 0xc8c1,
  [0x7380] = 0xc8c2, [0x7381] = 0xc8c3, [0x7382] = 0xc8c4, [0x7383] = 0xc8c5,
  [0x7384] = 0xc8c6, [0x7385] = 0xc8c7, [0x7386] = 0xc8c8, [0x7387] = 0xc8c9,
  [0x7388] = 0xc8ca, [0x7389] = 0xc8cb, [0x738a] = 0xc8cc, [0x738b] = 0xc8cd,
  [0x738c] = 0xc8ce, [0x738d] = 0xc8cf, [0x738e] = 0xc8d0, [0x738f] = 0xc8d1,
  [0x7390] = 0xc8d2, [0x7391] = 0xc8d3, [0x7392] = 0xc8d4, [0x7393] = 0xc8d5,
  [0x7394] = 0xc8d6, [0x7395] = 0xc8d7, [0x7396] = 0xc8d8, [0x7397] = 0xc8d9,
  [0x7398] = 0xc8da, [0x7399] = 0xc8db, [0x739a] = 0xc8dc, [0x739b] = 0xc8dd,
  [0x739c] = 0xc8de, [0x739d] = 0xc8df, [0x739e] = 0xc8e0, [0x739f] = 0xc8e1,
  [0x73a0] = 0xc8e2, [0x73a1] = 0xc8e3, [0x73a2] = 0xc8e4, [0x73a3] = 0xc8e5,
  [0x73a4] = 0xc8e6, [0x73a5] = 0xc8e7, [0x73a6] = 0xc8e8, [0x73a7] = 0xc8e9,
  [0x73a8] = 0xc8ea, [0x73a9] = 0xc8eb, [0x73aa] = 0xc8ec, [0x73ab] = 0xc8ed,
  [0x73ac] = 0xc8ee, [0x73ad] = 0xc8ef, [0x73ae] = 0xc8f0, [0x73af] = 0xc8f1,
  [0x73b0] = 0xc8f2, [0x73b1] = 0xc8f3, [0x73b2] = 0xc8f4, [0x73b3] = 0xc8f5,
  [0x73b4] = 0xc8f6, [0x73b5] = 0xc8f7, [0x73b6] = 0xc8f8, [0x73b7] = 0xc8f9,
  [0x73b8] = 0xc8fa, [0x73b9] = 0xc8fb, [0x73ba] = 0xc8fc, [0x73bb] = 0xc8fd,
  [0x73bc] = 0xc8fe, [0x73bd] = 0xc8ff, [0x73be] = 0xc900, [0x73bf] = 0xc901,
  [0x73c0] = 0xc902, [0x73c1] = 0xc903, [0x73c2] = 0xc904, [0x73c3] = 0xc905,
  [0x73c4] = 0xc906, [0x73c5] = 0xc907, [0x73c6] = 0xc908, [0x73c7] = 0xc909,
  [0x73c8] = 0xc90a, [0x73c9] = 0xc90b, [0x73ca] = 0xc90c, [0x73cb] = 0xc90d,
  [0x73cc] = 0xc90e, [0x73cd] = 0xc90f, [0x73ce] = 0xc910, [0x73cf] = 0xc911,
  [0x73d0] = 0xc912, [0x73d1] = 0xc913, [0x73d2] = 0xc914, [0x73d3] = 0xc915,
  [0x73d4] = 0xc916, [0x73d5] = 0xc917, [0x73d6] = 0xc918, [0x73d7] = 0xc919,
  [0x73d8] = 0xc91a, [0x73d9] = 0xc91b, [0x73da] = 0xc91c, [0x73db] = 0xc91d,
  [0x73dc] = 0xc91e, [0x73dd] = 0xc91f, [0x73de] = 0xc920, [0x73df] = 0xc921,
  [0x73e0] = 0xc922, [0x73e1] = 0xc923, [0x73e2] = 0xc924, [0x73e3] = 0xc925,
  [0x73e4] = 0xc926, [0x73e5] = 0xc927, [0x73e6] = 0xc928, [0x73e7] = 0xc929,
  [0x73e8] = 0xc92a, [0x73e9] = 0xc92b, [0x73ea] = 0xc92c, [0x73eb] = 0xc92d,
  [0x73ec] = 0xc92e, [0x73ed] = 0xc92f, [0x73ee] = 0xc930, [0x73ef] = 0xc931,
  [0x73f0] = 0xc932, [0x73f1] = 0xc933, [0x73f2] = 0xc934, [0x73f3] = 0xc935,
  [0x73f4] = 0xc936, [0x73f5] = 0xc937, [0x73f6] = 0xc938, [0x73f7] = 0xc939,
  [0x73f8] = 0xc93a, [0x73f9] = 0xc93b, [0x73fa] = 0xc93c, [0x73fb] = 0xc93d,
  [0x73fc] = 0xc93e, [0x73fd] = 0xc93f, [0x73fe] = 0xc940, [0x73ff] = 0xc941,
  [0x7400] = 0xc942, [0x7401] = 0xc943, [0x7402] = 0xc944, [0x7403] = 0xc945,
  [0x7404] = 0xc946, [0x7405] = 0xc947, [0x7406] = 0xc948, [0x7407] = 0xc949,
  [0x7408] = 0xc94a, [0x7409] = 0xc94b, [0x740a] = 0xc94c, [0x740b] = 0xc94d,
  [0x740c] = 0xc94e, [0x740d] = 0xc94f, [0x740e] = 0xc950, [0x740f] = 0xc951,
  [0x7410] = 0xc952, [0x7411] = 0xc953, [0x7412] = 0xc954, [0x7413] = 0xc955,
  [0x7414] = 0xc956, [0x7415] = 0xc957, [0x7416] = 0xc958, [0x7417] = 0xc959,
  [0x7418] = 0xc95a, [0x7419] = 0xc95b, [0x741a] = 0xc95c, [0x741b] = 0xc95d,
  [0x741c] = 0xc95e, [0x741d] = 0xc95f, [0x741e] = 0xc960, [0x741f] = 0xc961,
  [0x7420] = 0xc962, [0x7421] = 0xc963, [0x7422] = 0xc964, [0x7423] = 0xc965,
  [0x7424] = 0xc966, [0x7425] = 0xc967, [0x7426] = 0xc968, [0x7427] = 0xc969,
  [0x7428] = 0xc96a, [0x7429] = 0xc96b, [0x742a] = 0xc96c, [0x742b] = 0xc96d,
  [0x742c] = 0xc96e, [0x742d] = 0xc96f, [0x742e] = 0xc970, [0x742f] = 0xc971,
  [0x7430] = 0xc972, [0x7431] = 0xc973, [0x7432] = 0xc974, [0x7433] = 0xc975,
  [0x7434] = 0xc976, [0x7435] = 0xc977, [0x7436] = 0xc978, [0x7437] = 0xc979,
  [0x7438] = 0xc97a, [0x7439] = 0xc97b, [0x743a] = 0xc97c, [0x743b] = 0xc97d,
  [0x743c] = 0xc97e, [0x743d] = 0xc97f, [0x743e] = 0xc980, [0x743f] = 0xc981,
  [0x7440] = 0xc982, [0x7441] = 0xc983, [0x7442] = 0xc984, [0x7443] = 0xc985,
  [0x7444] = 0xc986, [0x7445] = 0xc987, [0x7446] = 0xc988, [0x7447] = 0xc989,
  [0x7448] = 0xc98a, [0x7449] = 0xc98b, [0x744a] = 0xc98c, [0x744b] = 0xc98d,
  [0x744c] = 0xc98e, [0x744d] = 0xc98f, [0x744e] = 0xc990, [0x744f] = 0xc991,
  [0x7450] = 0xc992, [0x7451] = 0xc993, [0x7452] = 0xc994, [0x7453] = 0xc995,
  [0x7454] = 0xc996, [0x7455] = 0xc997, [0x7456] = 0xc998, [0x7457] = 0xc999,
  [0x7458] = 0xc99a, [0x7459] = 0xc99b, [0x745a] = 0xc99c, [0x745b] = 0xc99d,
  [0x745c] = 0xc99e, [0x745d] = 0xc99f, [0x745e] = 0xc9a0, [0x745f] = 0xc9a1,
  [0x7460] = 0xc9a2, [0x7461] = 0xc9a3, [0x7462] = 0xc9a4, [0x7463] = 0xc9a5,
  [0x7464] = 0xc9a6, [0x7465] = 0xc9a7, [0x7466] = 0xc9a8, [0x7467] = 0xc9a9,
  [0x7468] = 0xc9aa, [0x7469] = 0xc9ab, [0x746a] = 0xc9ac, [0x746b] = 0xc9ad,
  [0x746c] = 0xc9ae, [0x746d] = 0xc9af, [0x746e] = 0xc9b0, [0x746f] = 0xc9b1,
  [0x7470] = 0xc9b2, [0x7471] = 0xc9b3, [0x7472] = 0xc9b4, [0x7473] = 0xc9b5,
  [0x7474] = 0xc9b6, [0x7475] = 0xc9b7, [0x7476] = 0xc9b8, [0x7477] = 0xc9b9,
  [0x7478] = 0xc9ba, [0x7479] = 0xc9bb, [0x747a] = 0xc9bc, [0x747b] = 0xc9bd,
  [0x747c] = 0xc9be, [0x747d] = 0xc9bf, [0x747e] = 0xc9c0, [0x747f] = 0xc9c1,
  [0x7480] = 0xc9c2, [0x7481] = 0xc9c3, [0x7482] = 0xc9c4, [0x7483] = 0xc9c5,
  [0x7484] = 0xc9c6, [0x7485] = 0xc9c7, [0x7486] = 0xc9c8, [0x7487] = 0xc9c9,
  [0x7488] = 0xc9ca, [0x7489] = 0xc9cb, [0x748a] = 0xc9cc, [0x748b] = 0xc9cd,
  [0x748c] = 0xc9ce, [0x748d] = 0xc9cf, [0x748e] = 0xc9d0, [0x748f] = 0xc9d1,
  [0x7490] = 0xc9d2, [0x7491] = 0xc9d3, [0x7492] = 0xc9d4, [0x7493] = 0xc9d5,
  [0x7494] = 0xc9d6, [0x7495] = 0xc9d7, [0x7496] = 0xc9d8, [0x7497] = 0xc9d9,
  [0x7498] = 0xc9da, [0x7499] = 0xc9db, [0x749a] = 0xc9dc, [0x749b] = 0xc9dd,
  [0x749c] = 0xc9de, [0x749d] = 0xc9df, [0x749e] = 0xc9e0, [0x749f] = 0xc9e1,
  [0x74a0] = 0xc9e2, [0x74a1] = 0xc9e3, [0x74a2] = 0xc9e4, [0x74a3] = 0xc9e5,
  [0x74a4] = 0xc9e6, [0x74a5] = 0xc9e7, [0x74a6] = 0xc9e8, [0x74a7] = 0xc9e9,
  [0x74a8] = 0xc9ea, [0x74a9] = 0xc9eb, [0x74aa] = 0xc9ec, [0x74ab] = 0xc9ed,
  [0x74ac] = 0xc9ee, [0x74ad] = 0xc9ef, [0x74ae] = 0xc9f0, [0x74af] = 0xc9f1,
  [0x74b0] = 0xc9f2, [0x74b1] = 0xc9f3, [0x74b2] = 0xc9f4, [0x74b3] = 0xc9f5,
  [0x74b4] = 0xc9f6, [0x74b5] = 0xc9f7, [0x74b6] = 0xc9f8, [0x74b7] = 0xc9f9,
  [0x74b8] = 0xc9fa, [0x74b9] = 0xc9fb, [0x74ba] = 0xc9fc, [0x74bb] = 0xc9fd,
  [0x74bc] = 0xc9fe, [0x74bd] = 0xc9ff, [0x74be] = 0xca00, [0x74bf] = 0xca01,
  [0x74c0] = 0xca02, [0x74c1] = 0xca03, [0x74c2] = 0xca04, [0x74c3] = 0xca05,
  [0x74c4] = 0xca06, [0x74c5] = 0xca07, [0x74c6] = 0xca08, [0x74c7] = 0xca09,
  [0x74c8] = 0xca0a, [0x74c9] = 0xca0b, [0x74ca] = 0xca0c, [0x74cb] = 0xca0d,
  [0x74cc] = 0xca0e, [0x74cd] = 0xca0f, [0x74ce] = 0xca10, [0x74cf] = 0xca11,
  [0x74d0] = 0xca12, [0x74d1] = 0xca13, [0x74d2] = 0xca14, [0x74d3] = 0xca15,
  [0x74d4] = 0xca16, [0x74d5] = 0xca17, [0x74d6] = 0xca18, [0x74d7] = 0xca19,
  [0x74d8] = 0xca1a, [0x74d9] = 0xca1b, [0x74da] = 0xca1c, [0x74db] = 0xca1d,
  [0x74dc] = 0xca1e, [0x74dd] = 0xca1f, [0x74de] = 0xca20, [0x74df] = 0xca21,
  [0x74e0] = 0xca22, [0x74e1] = 0xca23, [0x74e2] = 0xca24, [0x74e3] = 0xca25,
  [0x74e4] = 0xca26, [0x74e5] = 0xca27, [0x74e6] = 0xca28, [0x74e7] = 0xca29,
  [0x74e8] = 0xca2a, [0x74e9] = 0xca2b, [0x74ea] = 0xca2c, [0x74eb] = 0xca2d,
  [0x74ec] = 0xca2e, [0x74ed] = 0xca2f, [0x74ee] = 0xca30, [0x74ef] = 0xca31,
  [0x74f0] = 0xca32, [0x74f1] = 0xca33, [0x74f2] = 0xca34, [0x74f3] = 0xca35,
  [0x74f4] = 0xca36, [0x74f5] = 0xca37, [0x74f6] = 0xca38, [0x74f7] = 0xca39,
  [0x74f8] = 0xca3a, [0x74f9] = 0xca3b, [0x74fa] = 0xca3c, [0x74fb] = 0xca3d,
  [0x74fc] = 0xca3e, [0x74fd] = 0xca3f, [0x74fe] = 0xca40, [0x74ff] = 0xca41,
  [0x7500] = 0xca42, [0x7501] = 0xca43, [0x7502] = 0xca44, [0x7503] = 0xca45,
  [0x7504] = 0xca46, [0x7505] = 0xca47, [0x7506] = 0xca48, [0x7507] = 0xca49,
  [0x7508] = 0xca4a, [0x7509] = 0xca4b, [0x750a] = 0xca4c, [0x750b] = 0xca4d,
  [0x750c] = 0xca4e, [0x750d] = 0xca4f, [0x750e] = 0xca50, [0x750f] = 0xca51,
  [0x7510] = 0xca52, [0x7511] = 0xca53, [0x7512] = 0xca54, [0x7513] = 0xca55,
  [0x7514] = 0xca56, [0x7515] = 0xca57, [0x7516] = 0xca58, [0x7517] = 0xca59,
  [0x7518] = 0xca5a, [0x7519] = 0xca5b, [0x751a] = 0xca5c, [0x751b] = 0xca5d,
  [0x751c] = 0xca5e, [0x751d] = 0xca5f, [0x751e] = 0xca60, [0x751f] = 0xca61,
  [0x7520] = 0xca62, [0x7521] = 0xca63, [0x7522] = 0xca64, [0x7523] = 0xca65,
  [0x7524] = 0xca66, [0x7525] = 0xca67, [0x7526] = 0xca68, [0x7527] = 0xca69,
  [0x7528] = 0xca6a, [0x7529] = 0xca6b, [0x752a] = 0xca6c, [0x752b] = 0xca6d,
  [0x752c] = 0xca6e, [0x752d] = 0xca6f, [0x752e] = 0xca70, [0x752f] = 0xca71,
  [0x7530] = 0xca72, [0x7531] = 0xca73, [0x7532] = 0xca74, [0x7533] = 0xca75,
  [0x7534] = 0xca76, [0x7535] = 0xca77, [0x7536] = 0xca78, [0x7537] = 0xca79,
  [0x7538] = 0xca7a, [0x7539] = 0xca7b, [0x753a] = 0xca7c, [0x753b] = 0xca7d,
  [0x753c] = 0xca7e, [0x753d] = 0xca7f, [0x753e] = 0xca80, [0x753f] = 0xca81,
  [0x7540] = 0xca82, [0x7541] = 0xca83, [0x7542] = 0xca84, [0x7543] = 0xca85,
  [0x7544] = 0xca86, [0x7545] = 0xca87, [0x7546] = 0xca88, [0x7547] = 0xca89,
  [0x7548] = 0xca8a, [0x7549] = 0xca8b, [0x754a] = 0xca8c, [0x754b] = 0xca8d,
  [0x754c] = 0xca8e, [0x754d] = 0xca8f, [0x754e] = 0xca90, [0x754f] = 0xca91,
  [0x7550] = 0xca92, [0x7551] = 0xca93, [0x7552] = 0xca94, [0x7553] = 0xca95,
  [0x7554] = 0xca96, [0x7555] = 0xca97, [0x7556] = 0xca98, [0x7557] = 0xca99,
  [0x7558] = 0xca9a, [0x7559] = 0xca9b, [0x755a] = 0xca9c, [0x755b] = 0xca9d,
  [0x755c] = 0xca9e, [0x755d] = 0xca9f, [0x755e] = 0xcaa0, [0x755f] = 0xcaa1,
  [0x7560] = 0xcaa2, [0x7561] = 0xcaa3, [0x7562] = 0xcaa4, [0x7563] = 0xcaa5,
  [0x7564] = 0xcaa6, [0x7565] = 0xcaa7, [0x7566] = 0xcaa8, [0x7567] = 0xcaa9,
  [0x7568] = 0xcaaa, [0x7569] = 0xcaab, [0x756a] = 0xcaac, [0x756b] = 0xcaad,
  [0x756c] = 0xcaae, [0x756d] = 0xcaaf, [0x756e] = 0xcab0, [0x756f] = 0xcab1,
  [0x7570] = 0xcab2, [0x7571] = 0xcab3, [0x7572] = 0xcab4, [0x7573] = 0xcab5,
  [0x7574] = 0xcab6, [0x7575] = 0xcab7, [0x7576] = 0xcab8, [0x7577] = 0xcab9,
  [0x7578] = 0xcaba, [0x7579] = 0xcabb, [0x757a] = 0xcabc, [0x757b] = 0xcabd,
  [0x757c] = 0xcabe, [0x757d] = 0xcabf, [0x757e] = 0xcac0, [0x757f] = 0xcac1,
  [0x7580] = 0xcac2, [0x7581] = 0xcac3, [0x7582] = 0xcac4, [0x7583] = 0xcac5,
  [0x7584] = 0xcac6, [0x7585] = 0xcac7, [0x7586] = 0xcac8, [0x7587] = 0xcac9,
  [0x7588] = 0xcaca, [0x7589] = 0xcacb, [0x758a] = 0xcacc, [0x758b] = 0xcacd,
  [0x758c] = 0xcace, [0x758d] = 0xcacf, [0x758e] = 0xcad0, [0x758f] = 0xcad1,
  [0x7590] = 0xcad2, [0x7591] = 0xcad3, [0x7592] = 0xcad4, [0x7593] = 0xcad5,
  [0x7594] = 0xcad6, [0x7595] = 0xcad7, [0x7596] = 0xcad8, [0x7597] = 0xcad9,
  [0x7598] = 0xcada, [0x7599] = 0xcadb, [0x759a] = 0xcadc, [0x759b] = 0xcadd,
  [0x759c] = 0xcade, [0x759d] = 0xcadf, [0x759e] = 0xcae0, [0x759f] = 0xcae1,
  [0x75a0] = 0xcae2, [0x75a1] = 0xcae3, [0x75a2] = 0xcae4, [0x75a3] = 0xcae5,
  [0x75a4] = 0xcae6, [0x75a5] = 0xcae7, [0x75a6] = 0xcae8, [0x75a7] = 0xcae9,
  [0x75a8] = 0xcaea, [0x75a9] = 0xcaeb, [0x75aa] = 0xcaec, [0x75ab] = 0xcaed,
  [0x75ac] = 0xcaee, [0x75ad] = 0xcaef, [0x75ae] = 0xcaf0, [0x75af] = 0xcaf1,
  [0x75b0] = 0xcaf2, [0x75b1] = 0xcaf3, [0x75b2] = 0xcaf4, [0x75b3] = 0xcaf5,
  [0x75b4] = 0xcaf6, [0x75b5] = 0xcaf7, [0x75b6] = 0xcaf8, [0x75b7] = 0xcaf9,
  [0x75b8] = 0xcafa, [0x75b9] = 0xcafb, [0x75ba] = 0xcafc, [0x75bb] = 0xcafd,
  [0x75bc] = 0xcafe, [0x75bd] = 0xcaff, [0x75be] = 0xcb00, [0x75bf] = 0xcb01,
  [0x75c0] = 0xcb02, [0x75c1] = 0xcb03, [0x75c2] = 0xcb04, [0x75c3] = 0xcb05,
  [0x75c4] = 0xcb06, [0x75c5] = 0xcb07, [0x75c6] = 0xcb08, [0x75c7] = 0xcb09,
  [0x75c8] = 0xcb0a, [0x75c9] = 0xcb0b, [0x75ca] = 0xcb0c, [0x75cb] = 0xcb0d,
  [0x75cc] = 0xcb0e, [0x75cd] = 0xcb0f, [0x75ce] = 0xcb10, [0x75cf] = 0xcb11,
  [0x75d0] = 0xcb12, [0x75d1] = 0xcb13, [0x75d2] = 0xcb14, [0x75d3] = 0xcb15,
  [0x75d4] = 0xcb16, [0x75d5] = 0xcb17, [0x75d6] = 0xcb18, [0x75d7] = 0xcb19,
  [0x75d8] = 0xcb1a, [0x75d9] = 0xcb1b, [0x75da] = 0xcb1c, [0x75db] = 0xcb1d,
  [0x75dc] = 0xcb1e, [0x75dd] = 0xcb1f, [0x75de] = 0xcb20, [0x75df] = 0xcb21,
  [0x75e0] = 0xcb22, [0x75e1] = 0xcb23, [0x75e2] = 0xcb24, [0x75e3] = 0xcb25,
  [0x75e4] = 0xcb26, [0x75e5] = 0xcb27, [0x75e6] = 0xcb28, [0x75e7] = 0xcb29,
  [0x75e8] = 0xcb2a, [0x75e9] = 0xcb2b, [0x75ea] = 0xcb2c, [0x75eb] = 0xcb2d,
  [0x75ec] = 0xcb2e, [0x75ed] = 0xcb2f, [0x75ee] = 0xcb30, [0x75ef] = 0xcb31,
  [0x75f0] = 0xcb32, [0x75f1] = 0xcb33, [0x75f2] = 0xcb34, [0x75f3] = 0xcb35,
  [0x75f4] = 0xcb36, [0x75f5] = 0xcb37, [0x75f6] = 0xcb38, [0x75f7] = 0xcb39,
  [0x75f8] = 0xcb3a, [0x75f9] = 0xcb3b, [0x75fa] = 0xcb3c, [0x75fb] = 0xcb3d,
  [0x75fc] = 0xcb3e, [0x75fd] = 0xcb3f, [0x75fe] = 0xcb40, [0x75ff] = 0xcb41,
  [0x7600] = 0xcb42, [0x7601] = 0xcb43, [0x7602] = 0xcb44, [0x7603] = 0xcb45,
  [0x7604] = 0xcb46, [0x7605] = 0xcb47, [0x7606] = 0xcb48, [0x7607] = 0xcb49,
  [0x7608] = 0xcb4a, [0x7609] = 0xcb4b, [0x760a] = 0xcb4c, [0x760b] = 0xcb4d,
  [0x760c] = 0xcb4e, [0x760d] = 0xcb4f, [0x760e] = 0xcb50, [0x760f] = 0xcb51,
  [0x7610] = 0xcb52, [0x7611] = 0xcb53, [0x7612] = 0xcb54, [0x7613] = 0xcb55,
  [0x7614] = 0xcb56, [0x7615] = 0xcb57, [0x7616] = 0xcb58, [0x7617] = 0xcb59,
  [0x7618] = 0xcb5a, [0x7619] = 0xcb5b, [0x761a] = 0xcb5c, [0x761b] = 0xcb5d,
  [0x761c] = 0xcb5e, [0x761d] = 0xcb5f, [0x761e] = 0xcb60, [0x761f] = 0xcb61,
  [0x7620] = 0xcb62, [0x7621] = 0xcb63, [0x7622] = 0xcb64, [0x7623] = 0xcb65,
  [0x7624] = 0xcb66, [0x7625] = 0xcb67, [0x7626] = 0xcb68, [0x7627] = 0xcb69,
  [0x7628] = 0xcb6a, [0x7629] = 0xcb6b, [0x762a] = 0xcb6c, [0x762b] = 0xcb6d,
  [0x762c] = 0xcb6e, [0x762d] = 0xcb6f, [0x762e] = 0xcb70, [0x762f] = 0xcb71,
  [0x7630] = 0xcb72, [0x7631] = 0xcb73, [0x7632] = 0xcb74, [0x7633] = 0xcb75,
  [0x7634] = 0xcb76, [0x7635] = 0xcb77, [0x7636] = 0xcb78, [0x7637] = 0xcb79,
  [0x7638] = 0xcb7a, [0x7639] = 0xcb7b, [0x763a] = 0xcb7c, [0x763b] = 0xcb7d,
  [0x763c] = 0xcb7e, [0x763d] = 0xcb7f, [0x763e] = 0xcb80, [0x763f] = 0xcb81,
  [0x7640] = 0xcb82, [0x7641] = 0xcb83, [0x7642] = 0xcb84, [0x7643] = 0xcb85,
  [0x7644] = 0xcb86, [0x7645] = 0xcb87, [0x7646] = 0xcb88, [0x7647] = 0xcb89,
  [0x7648] = 0xcb8a, [0x7649] = 0xcb8b, [0x764a] = 0xcb8c, [0x764b] = 0xcb8d,
  [0x764c] = 0xcb8e, [0x764d] = 0xcb8f, [0x764e] = 0xcb90, [0x764f] = 0xcb91,
  [0x7650] = 0xcb92, [0x7651] = 0xcb93, [0x7652] = 0xcb94, [0x7653] = 0xcb95,
  [0x7654] = 0xcb96, [0x7655] = 0xcb97, [0x7656] = 0xcb98, [0x7657] = 0xcb99,
  [0x7658] = 0xcb9a, [0x7659] = 0xcb9b, [0x765a] = 0xcb9c, [0x765b] = 0xcb9d,
  [0x765c] = 0xcb9e, [0x765d] = 0xcb9f, [0x765e] = 0xcba0, [0x765f] = 0xcba1,
  [0x7660] = 0xcba2, [0x7661] = 0xcba3, [0x7662] = 0xcba4, [0x7663] = 0xcba5,
  [0x7664] = 0xcba6, [0x7665] = 0xcba7, [0x7666] = 0xcba8, [0x7667] = 0xcba9,
  [0x7668] = 0xcbaa, [0x7669] = 0xcbab, [0x766a] = 0xcbac, [0x766b] = 0xcbad,
  [0x766c] = 0xcbae, [0x766d] = 0xcbaf, [0x766e] = 0xcbb0, [0x766f] = 0xcbb1,
  [0x7670] = 0xcbb2, [0x7671] = 0xcbb3, [0x7672] = 0xcbb4, [0x7673] = 0xcbb5,
  [0x7674] = 0xcbb6, [0x7675] = 0xcbb7, [0x7676] = 0xcbb8, [0x7677] = 0xcbb9,
  [0x7678] = 0xcbba, [0x7679] = 0xcbbb, [0x767a] = 0xcbbc, [0x767b] = 0xcbbd,
  [0x767c] = 0xcbbe, [0x767d] = 0xcbbf, [0x767e] = 0xcbc0, [0x767f] = 0xcbc1,
  [0x7680] = 0xcbc2, [0x7681] = 0xcbc3, [0x7682] = 0xcbc4, [0x7683] = 0xcbc5,
  [0x7684] = 0xcbc6, [0x7685] = 0xcbc7, [0x7686] = 0xcbc8, [0x7687] = 0xcbc9,
  [0x7688] = 0xcbca, [0x7689] = 0xcbcb, [0x768a] = 0xcbcc, [0x768b] = 0xcbcd,
  [0x768c] = 0xcbce, [0x768d] = 0xcbcf, [0x768e] = 0xcbd0, [0x768f] = 0xcbd1,
  [0x7690] = 0xcbd2, [0x7691] = 0xcbd3, [0x7692] = 0xcbd4, [0x7693] = 0xcbd5,
  [0x7694] = 0xcbd6, [0x7695] = 0xcbd7, [0x7696] = 0xcbd8, [0x7697] = 0xcbd9,
  [0x7698] = 0xcbda, [0x7699] = 0xcbdb, [0x769a] = 0xcbdc, [0x769b] = 0xcbdd,
  [0x769c] = 0xcbde, [0x769d] = 0xcbdf, [0x769e] = 0xcbe0, [0x769f] = 0xcbe1,
  [0x76a0] = 0xcbe2, [0x76a1] = 0xcbe3, [0x76a2] = 0xcbe4, [0x76a3] = 0xcbe5,
  [0x76a4] = 0xcbe6, [0x76a5] = 0xcbe7, [0x76a6] = 0xcbe8, [0x76a7] = 0xcbe9,
  [0x76a8] = 0xcbea, [0x76a9] = 0xcbeb, [0x76aa] = 0xcbec, [0x76ab] = 0xcbed,
  [0x76ac] = 0xcbee, [0x76ad] = 0xcbef, [0x76ae] = 0xcbf0, [0x76af] = 0xcbf1,
  [0x76b0] = 0xcbf2, [0x76b1] = 0xcbf3, [0x76b2] = 0xcbf4, [0x76b3] = 0xcbf5,
  [0x76b4] = 0xcbf6, [0x76b5] = 0xcbf7, [0x76b6] = 0xcbf8, [0x76b7] = 0xcbf9,
  [0x76b8] = 0xcbfa, [0x76b9] = 0xcbfb, [0x76ba] = 0xcbfc, [0x76bb] = 0xcbfd,
  [0x76bc] = 0xcbfe, [0x76bd] = 0xcbff, [0x76be] = 0xcc00, [0x76bf] = 0xcc01,
  [0x76c0] = 0xcc02, [0x76c1] = 0xcc03, [0x76c2] = 0xcc04, [0x76c3] = 0xcc05,
  [0x76c4] = 0xcc06, [0x76c5] = 0xcc07, [0x76c6] = 0xcc08, [0x76c7] = 0xcc09,
  [0x76c8] = 0xcc0a, [0x76c9] = 0xcc0b, [0x76ca] = 0xcc0c, [0x76cb] = 0xcc0d,
  [0x76cc] = 0xcc0e, [0x76cd] = 0xcc0f, [0x76ce] = 0xcc10, [0x76cf] = 0xcc11,
  [0x76d0] = 0xcc12, [0x76d1] = 0xcc13, [0x76d2] = 0xcc14, [0x76d3] = 0xcc15,
  [0x76d4] = 0xcc16, [0x76d5] = 0xcc17, [0x76d6] = 0xcc18, [0x76d7] = 0xcc19,
  [0x76d8] = 0xcc1a, [0x76d9] = 0xcc1b, [0x76da] = 0xcc1c, [0x76db] = 0xcc1d,
  [0x76dc] = 0xcc1e, [0x76dd] = 0xcc1f, [0x76de] = 0xcc20, [0x76df] = 0xcc21,
  [0x76e0] = 0xcc22, [0x76e1] = 0xcc23, [0x76e2] = 0xcc24, [0x76e3] = 0xcc25,
  [0x76e4] = 0xcc26, [0x76e5] = 0xcc27, [0x76e6] = 0xcc28, [0x76e7] = 0xcc29,
  [0x76e8] = 0xcc2a, [0x76e9] = 0xcc2b, [0x76ea] = 0xcc2c, [0x76eb] = 0xcc2d,
  [0x76ec] = 0xcc2e, [0x76ed] = 0xcc2f, [0x76ee] = 0xcc30, [0x76ef] = 0xcc31,
  [0x76f0] = 0xcc32, [0x76f1] = 0xcc33, [0x76f2] = 0xcc34, [0x76f3] = 0xcc35,
  [0x76f4] = 0xcc36, [0x76f5] = 0xcc37, [0x76f6] = 0xcc38, [0x76f7] = 0xcc39,
  [0x76f8] = 0xcc3a, [0x76f9] = 0xcc3b, [0x76fa] = 0xcc3c, [0x76fb] = 0xcc3d,
  [0x76fc] = 0xcc3e, [0x76fd] = 0xcc3f, [0x76fe] = 0xcc40, [0x76ff] = 0xcc41,
  [0x7700] = 0xcc42, [0x7701] = 0xcc43, [0x7702] = 0xcc44, [0x7703] = 0xcc45,
  [0x7704] = 0xcc46, [0x7705] = 0xcc47, [0x7706] = 0xcc48, [0x7707] = 0xcc49,
  [0x7708] = 0xcc4a, [0x7709] = 0xcc4b, [0x770a] = 0xcc4c, [0x770b] = 0xcc4d,
  [0x770c] = 0xcc4e, [0x770d] = 0xcc4f, [0x770e] = 0xcc50, [0x770f] = 0xcc51,
  [0x7710] = 0xcc52, [0x7711] = 0xcc53, [0x7712] = 0xcc54, [0x7713] = 0xcc55,
  [0x7714] = 0xcc56, [0x7715] = 0xcc57, [0x7716] = 0xcc58, [0x7717] = 0xcc59,
  [0x7718] = 0xcc5a, [0x7719] = 0xcc5b, [0x771a] = 0xcc5c, [0x771b] = 0xcc5d,
  [0x771c] = 0xcc5e, [0x771d] = 0xcc5f, [0x771e] = 0xcc60, [0x771f] = 0xcc61,
  [0x7720] = 0xcc62, [0x7721] = 0xcc63, [0x7722] = 0xcc64, [0x7723] = 0xcc65,
  [0x7724] = 0xcc66, [0x7725] = 0xcc67, [0x7726] = 0xcc68, [0x7727] = 0xcc69,
  [0x7728] = 0xcc6a, [0x7729] = 0xcc6b, [0x772a] = 0xcc6c, [0x772b] = 0xcc6d,
  [0x772c] = 0xcc6e, [0x772d] = 0xcc6f, [0x772e] = 0xcc70, [0x772f] = 0xcc71,
  [0x7730] = 0xcc72, [0x7731] = 0xcc73, [0x7732] = 0xcc74, [0x7733] = 0xcc75,
  [0x7734] = 0xcc76, [0x7735] = 0xcc77, [0x7736] = 0xcc78, [0x7737] = 0xcc79,
  [0x7738] = 0xcc7a, [0x7739] = 0xcc7b, [0x773a] = 0xcc7c, [0x773b] = 0xcc7d,
  [0x773c] = 0xcc7e, [0x773d] = 0xcc7f, [0x773e] = 0xcc80, [0x773f] = 0xcc81,
  [0x7740] = 0xcc82, [0x7741] = 0xcc83, [0x7742] = 0xcc84, [0x7743] = 0xcc85,
  [0x7744] = 0xcc86, [0x7745] = 0xcc87, [0x7746] = 0xcc88, [0x7747] = 0xcc89,
  [0x7748] = 0xcc8a, [0x7749] = 0xcc8b, [0x774a] = 0xcc8c, [0x774b] = 0xcc8d,
  [0x774c] = 0xcc8e, [0x774d] = 0xcc8f, [0x774e] = 0xcc90, [0x774f] = 0xcc91,
  [0x7750] = 0xcc92, [0x7751] = 0xcc93, [0x7752] = 0xcc94, [0x7753] = 0xcc95,
  [0x7754] = 0xcc96, [0x7755] = 0xcc97, [0x7756] = 0xcc98, [0x7757] = 0xcc99,
  [0x7758] = 0xcc9a, [0x7759] = 0xcc9b, [0x775a] = 0xcc9c, [0x775b] = 0xcc9d,
  [0x775c] = 0xcc9e, [0x775d] = 0xcc9f, [0x775e] = 0xcca0, [0x775f] = 0xcca1,
  [0x7760] = 0xcca2, [0x7761] = 0xcca3, [0x7762] = 0xcca4, [0x7763] = 0xcca5,
  [0x7764] = 0xcca6, [0x7765] = 0xcca7, [0x7766] = 0xcca8, [0x7767] = 0xcca9,
  [0x7768] = 0xccaa, [0x7769] = 0xccab, [0x776a] = 0xccac, [0x776b] = 0xccad,
  [0x776c] = 0xccae, [0x776d] = 0xccaf, [0x776e] = 0xccb0, [0x776f] = 0xccb1,
  [0x7770] = 0xccb2, [0x7771] = 0xccb3, [0x7772] = 0xccb4, [0x7773] = 0xccb5,
  [0x7774] = 0xccb6, [0x7775] = 0xccb7, [0x7776] = 0xccb8, [0x7777] = 0xccb9,
  [0x7778] = 0xccba, [0x7779] = 0xccbb, [0x777a] = 0xccbc, [0x777b] = 0xccbd,
  [0x777c] = 0xccbe, [0x777d] = 0xccbf, [0x777e] = 0xccc0, [0x777f] = 0xccc1,
  [0x7780] = 0xccc2, [0x7781] = 0xccc3, [0x7782] = 0xccc4, [0x7783] = 0xccc5,
  [0x7784] = 0xccc6, [0x7785] = 0xccc7, [0x7786] = 0xccc8, [0x7787] = 0xccc9,
  [0x7788] = 0xccca, [0x7789] = 0xcccb, [0x778a] = 0xcccc, [0x778b] = 0xcccd,
  [0x778c] = 0xccce, [0x778d] = 0xcccf, [0x778e] = 0xccd0, [0x778f] = 0xccd1,
  [0x7790] = 0xccd2, [0x7791] = 0xccd3, [0x7792] = 0xccd4, [0x7793] = 0xccd5,
  [0x7794] = 0xccd6, [0x7795] = 0xccd7, [0x7796] = 0xccd8, [0x7797] = 0xccd9,
  [0x7798] = 0xccda, [0x7799] = 0xccdb, [0x779a] = 0xccdc, [0x779b] = 0xccdd,
  [0x779c] = 0xccde, [0x779d] = 0xccdf, [0x779e] = 0xcce0, [0x779f] = 0xcce1,
  [0x77a0] = 0xcce2, [0x77a1] = 0xcce3, [0x77a2] = 0xcce4, [0x77a3] = 0xcce5,
  [0x77a4] = 0xcce6, [0x77a5] = 0xcce7, [0x77a6] = 0xcce8, [0x77a7] = 0xcce9,
  [0x77a8] = 0xccea, [0x77a9] = 0xcceb, [0x77aa] = 0xccec, [0x77ab] = 0xcced,
  [0x77ac] = 0xccee, [0x77ad] = 0xccef, [0x77ae] = 0xccf0, [0x77af] = 0xccf1,
  [0x77b0] = 0xccf2, [0x77b1] = 0xccf3, [0x77b2] = 0xccf4, [0x77b3] = 0xccf5,
  [0x77b4] = 0xccf6, [0x77b5] = 0xccf7, [0x77b6] = 0xccf8, [0x77b7] = 0xccf9,
  [0x77b8] = 0xccfa, [0x77b9] = 0xccfb, [0x77ba] = 0xccfc, [0x77bb] = 0xccfd,
  [0x77bc] = 0xccfe, [0x77bd] = 0xccff, [0x77be] = 0xcd00, [0x77bf] = 0xcd01,
  [0x77c0] = 0xcd02, [0x77c1] = 0xcd03, [0x77c2] = 0xcd04, [0x77c3] = 0xcd05,
  [0x77c4] = 0xcd06, [0x77c5] = 0xcd07, [0x77c6] = 0xcd08, [0x77c7] = 0xcd09,
  [0x77c8] = 0xcd0a, [0x77c9] = 0xcd0b, [0x77ca] = 0xcd0c, [0x77cb] = 0xcd0d,
  [0x77cc] = 0xcd0e, [0x77cd] = 0xcd0f, [0x77ce] = 0xcd10, [0x77cf] = 0xcd11,
  [0x77d0] = 0xcd12, [0x77d1] = 0xcd13, [0x77d2] = 0xcd14, [0x77d3] = 0xcd15,
  [0x77d4] = 0xcd16, [0x77d5] = 0xcd17, [0x77d6] = 0xcd18, [0x77d7] = 0xcd19,
  [0x77d8] = 0xcd1a, [0x77d9] = 0xcd1b, [0x77da] = 0xcd1c, [0x77db] = 0xcd1d,
  [0x77dc] = 0xcd1e, [0x77dd] = 0xcd1f, [0x77de] = 0xcd20, [0x77df] = 0xcd21,
  [0x77e0] = 0xcd22, [0x77e1] = 0xcd23, [0x77e2] = 0xcd24, [0x77e3] = 0xcd25,
  [0x77e4] = 0xcd26, [0x77e5] = 0xcd27, [0x77e6] = 0xcd28, [0x77e7] = 0xcd29,
  [0x77e8] = 0xcd2a, [0x77e9] = 0xcd2b, [0x77ea] = 0xcd2c, [0x77eb] = 0xcd2d,
  [0x77ec] = 0xcd2e, [0x77ed] = 0xcd2f, [0x77ee] = 0xcd30, [0x77ef] = 0xcd31,
  [0x77f0] = 0xcd32, [0x77f1] = 0xcd33, [0x77f2] = 0xcd34, [0x77f3] = 0xcd35,
  [0x77f4] = 0xcd36, [0x77f5] = 0xcd37, [0x77f6] = 0xcd38, [0x77f7] = 0xcd39,
  [0x77f8] = 0xcd3a, [0x77f9] = 0xcd3b, [0x77fa] = 0xcd3c, [0x77fb] = 0xcd3d,
  [0x77fc] = 0xcd3e, [0x77fd] = 0xcd3f, [0x77fe] = 0xcd40, [0x77ff] = 0xcd41,
  [0x7800] = 0xcd42, [0x7801] = 0xcd43, [0x7802] = 0xcd44, [0x7803] = 0xcd45,
  [0x7804] = 0xcd46, [0x7805] = 0xcd47, [0x7806] = 0xcd48, [0x7807] = 0xcd49,
  [0x7808] = 0xcd4a, [0x7809] = 0xcd4b, [0x780a] = 0xcd4c, [0x780b] = 0xcd4d,
  [0x780c] = 0xcd4e, [0x780d] = 0xcd4f, [0x780e] = 0xcd50, [0x780f] = 0xcd51,
  [0x7810] = 0xcd52, [0x7811] = 0xcd53, [0x7812] = 0xcd54, [0x7813] = 0xcd55,
  [0x7814] = 0xcd56, [0x7815] = 0xcd57, [0x7816] = 0xcd58, [0x7817] = 0xcd59,
  [0x7818] = 0xcd5a, [0x7819] = 0xcd5b, [0x781a] = 0xcd5c, [0x781b] = 0xcd5d,
  [0x781c] = 0xcd5e, [0x781d] = 0xcd5f, [0x781e] = 0xcd60, [0x781f] = 0xcd61,
  [0x7820] = 0xcd62, [0x7821] = 0xcd63, [0x7822] = 0xcd64, [0x7823] = 0xcd65,
  [0x7824] = 0xcd66, [0x7825] = 0xcd67, [0x7826] = 0xcd68, [0x7827] = 0xcd69,
  [0x7828] = 0xcd6a, [0x7829] = 0xcd6b, [0x782a] = 0xcd6c, [0x782b] = 0xcd6d,
  [0x782c] = 0xcd6e, [0x782d] = 0xcd6f, [0x782e] = 0xcd70, [0x782f] = 0xcd71,
  [0x7830] = 0xcd72, [0x7831] = 0xcd73, [0x7832] = 0xcd74, [0x7833] = 0xcd75,
  [0x7834] = 0xcd76, [0x7835] = 0xcd77, [0x7836] = 0xcd78, [0x7837] = 0xcd79,
  [0x7838] = 0xcd7a, [0x7839] = 0xcd7b, [0x783a] = 0xcd7c, [0x783b] = 0xcd7d,
  [0x783c] = 0xcd7e, [0x783d] = 0xcd7f, [0x783e] = 0xcd80, [0x783f] = 0xcd81,
  [0x7840] = 0xcd82, [0x7841] = 0xcd83, [0x7842] = 0xcd84, [0x7843] = 0xcd85,
  [0x7844] = 0xcd86, [0x7845] = 0xcd87, [0x7846] = 0xcd88, [0x7847] = 0xcd89,
  [0x7848] = 0xcd8a, [0x7849] = 0xcd8b, [0x784a] = 0xcd8c, [0x784b] = 0xcd8d,
  [0x784c] = 0xcd8e, [0x784d] = 0xcd8f, [0x784e] = 0xcd90, [0x784f] = 0xcd91,
  [0x7850] = 0xcd92, [0x7851] = 0xcd93, [0x7852] = 0xcd94, [0x7853] = 0xcd95,
  [0x7854] = 0xcd96, [0x7855] = 0xcd97, [0x7856] = 0xcd98, [0x7857] = 0xcd99,
  [0x7858] = 0xcd9a, [0x7859] = 0xcd9b, [0x785a] = 0xcd9c, [0x785b] = 0xcd9d,
  [0x785c] = 0xcd9e, [0x785d] = 0xcd9f, [0x785e] = 0xcda0, [0x785f] = 0xcda1,
  [0x7860] = 0xcda2, [0x7861] = 0xcda3, [0x7862] = 0xcda4, [0x7863] = 0xcda5,
  [0x7864] = 0xcda6, [0x7865] = 0xcda7, [0x7866] = 0xcda8, [0x7867] = 0xcda9,
  [0x7868] = 0xcdaa, [0x7869] = 0xcdab, [0x786a] = 0xcdac, [0x786b] = 0xcdad,
  [0x786c] = 0xcdae, [0x786d] = 0xcdaf, [0x786e] = 0xcdb0, [0x786f] = 0xcdb1,
  [0x7870] = 0xcdb2, [0x7871] = 0xcdb3, [0x7872] = 0xcdb4, [0x7873] = 0xcdb5,
  [0x7874] = 0xcdb6, [0x7875] = 0xcdb7, [0x7876] = 0xcdb8, [0x7877] = 0xcdb9,
  [0x7878] = 0xcdba, [0x7879] = 0xcdbb, [0x787a] = 0xcdbc, [0x787b] = 0xcdbd,
  [0x787c] = 0xcdbe, [0x787d] = 0xcdbf, [0x787e] = 0xcdc0, [0x787f] = 0xcdc1,
  [0x7880] = 0xcdc2, [0x7881] = 0xcdc3, [0x7882] = 0xcdc4, [0x7883] = 0xcdc5,
  [0x7884] = 0xcdc6, [0x7885] = 0xcdc7, [0x7886] = 0xcdc8, [0x7887] = 0xcdc9,
  [0x7888] = 0xcdca, [0x7889] = 0xcdcb, [0x788a] = 0xcdcc, [0x788b] = 0xcdcd,
  [0x788c] = 0xcdce, [0x788d] = 0xcdcf, [0x788e] = 0xcdd0, [0x788f] = 0xcdd1,
  [0x7890] = 0xcdd2, [0x7891] = 0xcdd3, [0x7892] = 0xcdd4, [0x7893] = 0xcdd5,
  [0x7894] = 0xcdd6, [0x7895] = 0xcdd7, [0x7896] = 0xcdd8, [0x7897] = 0xcdd9,
  [0x7898] = 0xcdda, [0x7899] = 0xcddb, [0x789a] = 0xcddc, [0x789b] = 0xcddd,
  [0x789c] = 0xcdde, [0x789d] = 0xcddf, [0x789e] = 0xcde0, [0x789f] = 0xcde1,
  [0x78a0] = 0xcde2, [0x78a1] = 0xcde3, [0x78a2] = 0xcde4, [0x78a3] = 0xcde5,
  [0x78a4] = 0xcde6, [0x78a5] = 0xcde7, [0x78a6] = 0xcde8, [0x78a7] = 0xcde9,
  [0x78a8] = 0xcdea, [0x78a9] = 0xcdeb, [0x78aa] = 0xcdec, [0x78ab] = 0xcded,
  [0x78ac] = 0xcdee, [0x78ad] = 0xcdef, [0x78ae] = 0xcdf0, [0x78af] = 0xcdf1,
  [0x78b0] = 0xcdf2, [0x78b1] = 0xcdf3, [0x78b2] = 0xcdf4, [0x78b3] = 0xcdf5,
  [0x78b4] = 0xcdf6, [0x78b5] = 0xcdf7, [0x78b6] = 0xcdf8, [0x78b7] = 0xcdf9,
  [0x78b8] = 0xcdfa, [0x78b9] = 0xcdfb, [0x78ba] = 0xcdfc, [0x78bb] = 0xcdfd,
  [0x78bc] = 0xcdfe, [0x78bd] = 0xcdff, [0x78be] = 0xce00, [0x78bf] = 0xce01,
  [0x78c0] = 0xce02, [0x78c1] = 0xce03, [0x78c2] = 0xce04, [0x78c3] = 0xce05,
  [0x78c4] = 0xce06, [0x78c5] = 0xce07, [0x78c6] = 0xce08, [0x78c7] = 0xce09,
  [0x78c8] = 0xce0a, [0x78c9] = 0xce0b, [0x78ca] = 0xce0c, [0x78cb] = 0xce0d,
  [0x78cc] = 0xce0e, [0x78cd] = 0xce0f, [0x78ce] = 0xce10, [0x78cf] = 0xce11,
  [0x78d0] = 0xce12, [0x78d1] = 0xce13, [0x78d2] = 0xce14, [0x78d3] = 0xce15,
  [0x78d4] = 0xce16, [0x78d5] = 0xce17, [0x78d6] = 0xce18, [0x78d7] = 0xce19,
  [0x78d8] = 0xce1a, [0x78d9] = 0xce1b, [0x78da] = 0xce1c, [0x78db] = 0xce1d,
  [0x78dc] = 0xce1e, [0x78dd] = 0xce1f, [0x78de] = 0xce20, [0x78df] = 0xce21,
  [0x78e0] = 0xce22, [0x78e1] = 0xce23, [0x78e2] = 0xce24, [0x78e3] = 0xce25,
  [0x78e4] = 0xce26, [0x78e5] = 0xce27, [0x78e6] = 0xce28, [0x78e7] = 0xce29,
  [0x78e8] = 0xce2a, [0x78e9] = 0xce2b, [0x78ea] = 0xce2c, [0x78eb] = 0xce2d,
  [0x78ec] = 0xce2e, [0x78ed] = 0xce2f, [0x78ee] = 0xce30, [0x78ef] = 0xce31,
  [0x78f0] = 0xce32, [0x78f1] = 0xce33, [0x78f2] = 0xce34, [0x78f3] = 0xce35,
  [0x78f4] = 0xce36, [0x78f5] = 0xce37, [0x78f6] = 0xce38, [0x78f7] = 0xce39,
  [0x78f8] = 0xce3a, [0x78f9] = 0xce3b, [0x78fa] = 0xce3c, [0x78fb] = 0xce3d,
  [0x78fc] = 0xce3e, [0x78fd] = 0xce3f, [0x78fe] = 0xce40, [0x78ff] = 0xce41,
  [0x7900] = 0xce42, [0x7901] = 0xce43, [0x7902] = 0xce44, [0x7903] = 0xce45,
  [0x7904] = 0xce46, [0x7905] = 0xce47, [0x7906] = 0xce48, [0x7907] = 0xce49,
  [0x7908] = 0xce4a, [0x7909] = 0xce4b, [0x790a] = 0xce4c, [0x790b] = 0xce4d,
  [0x790c] = 0xce4e, [0x790d] = 0xce4f, [0x790e] = 0xce50, [0x790f] = 0xce51,
  [0x7910] = 0xce52, [0x7911] = 0xce53, [0x7912] = 0xce54, [0x7913] = 0xce55,
  [0x7914] = 0xce56, [0x7915] = 0xce57, [0x7916] = 0xce58, [0x7917] = 0xce59,
  [0x7918] = 0xce5a, [0x7919] = 0xce5b, [0x791a] = 0xce5c, [0x791b] = 0xce5d,
  [0x791c] = 0xce5e, [0x791d] = 0xce5f, [0x791e] = 0xce60, [0x791f] = 0xce61,
  [0x7920] = 0xce62, [0x7921] = 0xce63, [0x7922] = 0xce64, [0x7923] = 0xce65,
  [0x7924] = 0xce66, [0x7925] = 0xce67, [0x7926] = 0xce68, [0x7927] = 0xce69,
  [0x7928] = 0xce6a, [0x7929] = 0xce6b, [0x792a] = 0xce6c, [0x792b] = 0xce6d,
  [0x792c] = 0xce6e, [0x792d] = 0xce6f, [0x792e] = 0xce70, [0x792f] = 0xce71,
  [0x7930] = 0xce72, [0x7931] = 0xce73, [0x7932] = 0xce74, [0x7933] = 0xce75,
  [0x7934] = 0xce76, [0x7935] = 0xce77, [0x7936] = 0xce78, [0x7937] = 0xce79,
  [0x7938] = 0xce7a, [0x7939] = 0xce7b, [0x793a] = 0xce7c, [0x793b] = 0xce7d,
  [0x793c] = 0xce7e, [0x793d] = 0xce7f, [0x793e] = 0xce80, [0x793f] = 0xce81,
  [0x7940] = 0xce82, [0x7941] = 0xce83, [0x7942] = 0xce84, [0x7943] = 0xce85,
  [0x7944] = 0xce86, [0x7945] = 0xce87, [0x7946] = 0xce88, [0x7947] = 0xce89,
  [0x7948] = 0xce8a, [0x7949] = 0xce8b, [0x794a] = 0xce8c, [0x794b] = 0xce8d,
  [0x794c] = 0xce8e, [0x794d] = 0xce8f, [0x794e] = 0xce90, [0x794f] = 0xce91,
  [0x7950] = 0xce92, [0x7951] = 0xce93, [0x7952] = 0xce94, [0x7953] = 0xce95,
  [0x7954] = 0xce96, [0x7955] = 0xce97, [0x7956] = 0xce98, [0x7957] = 0xce99,
  [0x7958] = 0xce9a, [0x7959] = 0xce9b, [0x795a] = 0xce9c, [0x795b] = 0xce9d,
  [0x795c] = 0xce9e, [0x795d] = 0xce9f, [0x795e] = 0xcea0, [0x795f] = 0xcea1,
  [0x7960] = 0xcea2, [0x7961] = 0xcea3, [0x7962] = 0xcea4, [0x7963] = 0xcea5,
  [0x7964] = 0xcea6, [0x7965] = 0xcea7, [0x7966] = 0xcea8, [0x7967] = 0xcea9,
  [0x7968] = 0xceaa, [0x7969] = 0xceab, [0x796a] = 0xceac, [0x796b] = 0xcead,
  [0x796c] = 0xceae, [0x796d] = 0xceaf, [0x796e] = 0xceb0, [0x796f] = 0xceb1,
  [0x7970] = 0xceb2, [0x7971] = 0xceb3, [0x7972] = 0xceb4, [0x7973] = 0xceb5,
  [0x7974] = 0xceb6, [0x7975] = 0xceb7, [0x7976] = 0xceb8, [0x7977] = 0xceb9,
  [0x7978] = 0xceba, [0x7979] = 0xcebb, [0x797a] = 0xcebc, [0x797b] = 0xcebd,
  [0x797c] = 0xcebe, [0x797d] = 0xcebf, [0x797e] = 0xcec0, [0x797f] = 0xcec1,
  [0x7980] = 0xcec2, [0x7981] = 0xcec3, [0x7982] = 0xcec4, [0x7983] = 0xcec5,
  [0x7984] = 0xcec6, [0x7985] = 0xcec7, [0x7986] = 0xcec8, [0x7987] = 0xcec9,
  [0x7988] = 0xceca, [0x7989] = 0xcecb, [0x798a] = 0xcecc, [0x798b] = 0xcecd,
  [0x798c] = 0xcece, [0x798d] = 0xcecf, [0x798e] = 0xced0, [0x798f] = 0xced1,
  [0x7990] = 0xced2, [0x7991] = 0xced3, [0x7992] = 0xced4, [0x7993] = 0xced5,
  [0x7994] = 0xced6, [0x7995] = 0xced7, [0x7996] = 0xced8, [0x7997] = 0xced9,
  [0x7998] = 0xceda, [0x7999] = 0xcedb, [0x799a] = 0xcedc, [0x799b] = 0xcedd,
  [0x799c] = 0xcede, [0x799d] = 0xcedf, [0x799e] = 0xcee0, [0x799f] = 0xcee1,
  [0x79a0] = 0xcee2, [0x79a1] = 0xcee3, [0x79a2] = 0xcee4, [0x79a3] = 0xcee5,
  [0x79a4] = 0xcee6, [0x79a5] = 0xcee7, [0x79a6] = 0xcee8, [0x79a7] = 0xcee9,
  [0x79a8] = 0xceea, [0x79a9] = 0xceeb, [0x79aa] = 0xceec, [0x79ab] = 0xceed,
  [0x79ac] = 0xceee, [0x79ad] = 0xceef, [0x79ae] = 0xcef0, [0x79af] = 0xcef1,
  [0x79b0] = 0xcef2, [0x79b1] = 0xcef3, [0x79b2] = 0xcef4, [0x79b3] = 0xcef5,
  [0x79b4] = 0xcef6, [0x79b5] = 0xcef7, [0x79b6] = 0xcef8, [0x79b7] = 0xcef9,
  [0x79b8] = 0xcefa, [0x79b9] = 0xcefb, [0x79ba] = 0xcefc, [0x79bb] = 0xcefd,
  [0x79bc] = 0xcefe, [0x79bd] = 0xceff, [0x79be] = 0xcf00, [0x79bf] = 0xcf01,
  [0x79c0] = 0xcf02, [0x79c1] = 0xcf03, [0x79c2] = 0xcf04, [0x79c3] = 0xcf05,
  [0x79c4] = 0xcf06, [0x79c5] = 0xcf07, [0x79c6] = 0xcf08, [0x79c7] = 0xcf09,
  [0x79c8] = 0xcf0a, [0x79c9] = 0xcf0b, [0x79ca] = 0xcf0c, [0x79cb] = 0xcf0d,
  [0x79cc] = 0xcf0e, [0x79cd] = 0xcf0f, [0x79ce] = 0xcf10, [0x79cf] = 0xcf11,
  [0x79d0] = 0xcf12, [0x79d1] = 0xcf13, [0x79d2] = 0xcf14, [0x79d3] = 0xcf15,
  [0x79d4] = 0xcf16, [0x79d5] = 0xcf17, [0x79d6] = 0xcf18, [0x79d7] = 0xcf19,
  [0x79d8] = 0xcf1a, [0x79d9] = 0xcf1b, [0x79da] = 0xcf1c, [0x79db] = 0xcf1d,
  [0x79dc] = 0xcf1e, [0x79dd] = 0xcf1f, [0x79de] = 0xcf20, [0x79df] = 0xcf21,
  [0x79e0] = 0xcf22, [0x79e1] = 0xcf23, [0x79e2] = 0xcf24, [0x79e3] = 0xcf25,
  [0x79e4] = 0xcf26, [0x79e5] = 0xcf27, [0x79e6] = 0xcf28, [0x79e7] = 0xcf29,
  [0x79e8] = 0xcf2a, [0x79e9] = 0xcf2b, [0x79ea] = 0xcf2c, [0x79eb] = 0xcf2d,
  [0x79ec] = 0xcf2e, [0x79ed] = 0xcf2f, [0x79ee] = 0xcf30, [0x79ef] = 0xcf31,
  [0x79f0] = 0xcf32, [0x79f1] = 0xcf33, [0x79f2] = 0xcf34, [0x79f3] = 0xcf35,
  [0x79f4] = 0xcf36, [0x79f5] = 0xcf37, [0x79f6] = 0xcf38, [0x79f7] = 0xcf39,
  [0x79f8] = 0xcf3a, [0x79f9] = 0xcf3b, [0x79fa] = 0xcf3c, [0x79fb] = 0xcf3d,
  [0x79fc] = 0xcf3e, [0x79fd] = 0xcf3f, [0x79fe] = 0xcf40, [0x79ff] = 0xcf41,
  [0x7a00] = 0xcf42, [0x7a01] = 0xcf43, [0x7a02] = 0xcf44, [0x7a03] = 0xcf45,
  [0x7a04] = 0xcf46, [0x7a05] = 0xcf47, [0x7a06] = 0xcf48, [0x7a07] = 0xcf49,
  [0x7a08] = 0xcf4a, [0x7a09] = 0xcf4b, [0x7a0a] = 0xcf4c, [0x7a0b] = 0xcf4d,
  [0x7a0c] = 0xcf4e, [0x7a0d] = 0xcf4f, [0x7a0e] = 0xcf50, [0x7a0f] = 0xcf51,
  [0x7a10] = 0xcf52, [0x7a11] = 0xcf53, [0x7a12] = 0xcf54, [0x7a13] = 0xcf55,
  [0x7a14] = 0xcf56, [0x7a15] = 0xcf57, [0x7a16] = 0xcf58, [0x7a17] = 0xcf59,
  [0x7a18] = 0xcf5a, [0x7a19] = 0xcf5b, [0x7a1a] = 0xcf5c, [0x7a1b] = 0xcf5d,
  [0x7a1c] = 0xcf5e, [0x7a1d] = 0xcf5f, [0x7a1e] = 0xcf60, [0x7a1f] = 0xcf61,
  [0x7a20] = 0xcf62, [0x7a21] = 0xcf63, [0x7a22] = 0xcf64, [0x7a23] = 0xcf65,
  [0x7a24] = 0xcf66, [0x7a25] = 0xcf67, [0x7a26] = 0xcf68, [0x7a27] = 0xcf69,
  [0x7a28] = 0xcf6a, [0x7a29] = 0xcf6b, [0x7a2a] = 0xcf6c, [0x7a2b] = 0xcf6d,
  [0x7a2c] = 0xcf6e, [0x7a2d] = 0xcf6f, [0x7a2e] = 0xcf70, [0x7a2f] = 0xcf71,
  [0x7a30] = 0xcf72, [0x7a31] = 0xcf73, [0x7a32] = 0xcf74, [0x7a33] = 0xcf75,
  [0x7a34] = 0xcf76, [0x7a35] = 0xcf77, [0x7a36] = 0xcf78, [0x7a37] = 0xcf79,
  [0x7a38] = 0xcf7a, [0x7a39] = 0xcf7b, [0x7a3a] = 0xcf7c, [0x7a3b] = 0xcf7d,
  [0x7a3c] = 0xcf7e, [0x7a3d] = 0xcf7f, [0x7a3e] = 0xcf80, [0x7a3f] = 0xcf81,
  [0x7a40] = 0xcf82, [0x7a41] = 0xcf83, [0x7a42] = 0xcf84, [0x7a43] = 0xcf85,
  [0x7a44] = 0xcf86, [0x7a45] = 0xcf87, [0x7a46] = 0xcf88, [0x7a47] = 0xcf89,
  [0x7a48] = 0xcf8a, [0x7a49] = 0xcf8b, [0x7a4a] = 0xcf8c, [0x7a4b] = 0xcf8d,
  [0x7a4c] = 0xcf8e, [0x7a4d] = 0xcf8f, [0x7a4e] = 0xcf90, [0x7a4f] = 0xcf91,
  [0x7a50] = 0xcf92, [0x7a51] = 0xcf93, [0x7a52] = 0xcf94, [0x7a53] = 0xcf95,
  [0x7a54] = 0xcf96, [0x7a55] = 0xcf97, [0x7a56] = 0xcf98, [0x7a57] = 0xcf99,
  [0x7a58] = 0xcf9a, [0x7a59] = 0xcf9b, [0x7a5a] = 0xcf9c, [0x7a5b] = 0xcf9d,
  [0x7a5c] = 0xcf9e, [0x7a5d] = 0xcf9f, [0x7a5e] = 0xcfa0, [0x7a5f] = 0xcfa1,
  [0x7a60] = 0xcfa2, [0x7a61] = 0xcfa3, [0x7a62] = 0xcfa4, [0x7a63] = 0xcfa5,
  [0x7a64] = 0xcfa6, [0x7a65] = 0xcfa7, [0x7a66] = 0xcfa8, [0x7a67] = 0xcfa9,
  [0x7a68] = 0xcfaa, [0x7a69] = 0xcfab, [0x7a6a] = 0xcfac, [0x7a6b] = 0xcfad,
  [0x7a6c] = 0xcfae, [0x7a6d] = 0xcfaf, [0x7a6e] = 0xcfb0, [0x7a6f] = 0xcfb1,
  [0x7a70] = 0xcfb2, [0x7a71] = 0xcfb3, [0x7a72] = 0xcfb4, [0x7a73] = 0xcfb5,
  [0x7a74] = 0xcfb6, [0x7a75] = 0xcfb7, [0x7a76] = 0xcfb8, [0x7a77] = 0xcfb9,
  [0x7a78] = 0xcfba, [0x7a79] = 0xcfbb, [0x7a7a] = 0xcfbc, [0x7a7b] = 0xcfbd,
  [0x7a7c] = 0xcfbe, [0x7a7d] = 0xcfbf, [0x7a7e] = 0xcfc0, [0x7a7f] = 0xcfc1,
  [0x7a80] = 0xcfc2, [0x7a81] = 0xcfc3, [0x7a82] = 0xcfc4, [0x7a83] = 0xcfc5,
  [0x7a84] = 0xcfc6, [0x7a85] = 0xcfc7, [0x7a86] = 0xcfc8, [0x7a87] = 0xcfc9,
  [0x7a88] = 0xcfca, [0x7a89] = 0xcfcb, [0x7a8a] = 0xcfcc, [0x7a8b] = 0xcfcd,
  [0x7a8c] = 0xcfce, [0x7a8d] = 0xcfcf, [0x7a8e] = 0xcfd0, [0x7a8f] = 0xcfd1,
  [0x7a90] = 0xcfd2, [0x7a91] = 0xcfd3, [0x7a92] = 0xcfd4, [0x7a93] = 0xcfd5,
  [0x7a94] = 0xcfd6, [0x7a95] = 0xcfd7, [0x7a96] = 0xcfd8, [0x7a97] = 0xcfd9,
  [0x7a98] = 0xcfda, [0x7a99] = 0xcfdb, [0x7a9a] = 0xcfdc, [0x7a9b] = 0xcfdd,
  [0x7a9c] = 0xcfde, [0x7a9d] = 0xcfdf, [0x7a9e] = 0xcfe0, [0x7a9f] = 0xcfe1,
  [0x7aa0] = 0xcfe2, [0x7aa1] = 0xcfe3, [0x7aa2] = 0xcfe4, [0x7aa3] = 0xcfe5,
  [0x7aa4] = 0xcfe6, [0x7aa5] = 0xcfe7, [0x7aa6] = 0xcfe8, [0x7aa7] = 0xcfe9,
  [0x7aa8] = 0xcfea, [0x7aa9] = 0xcfeb, [0x7aaa] = 0xcfec, [0x7aab] = 0xcfed,
  [0x7aac] = 0xcfee, [0x7aad] = 0xcfef, [0x7aae] = 0xcff0, [0x7aaf] = 0xcff1,
  [0x7ab0] = 0xcff2, [0x7ab1] = 0xcff3, [0x7ab2] = 0xcff4, [0x7ab3] = 0xcff5,
  [0x7ab4] = 0xcff6, [0x7ab5] = 0xcff7, [0x7ab6] = 0xcff8, [0x7ab7] = 0xcff9,
  [0x7ab8] = 0xcffa, [0x7ab9] = 0xcffb, [0x7aba] = 0xcffc, [0x7abb] = 0xcffd,
  [0x7abc] = 0xcffe, [0x7abd] = 0xcfff, [0x7abe] = 0xd000, [0x7abf] = 0xd001,
  [0x7ac0] = 0xd002, [0x7ac1] = 0xd003, [0x7ac2] = 0xd004, [0x7ac3] = 0xd005,
  [0x7ac4] = 0xd006, [0x7ac5] = 0xd007, [0x7ac6] = 0xd008, [0x7ac7] = 0xd009,
  [0x7ac8] = 0xd00a, [0x7ac9] = 0xd00b, [0x7aca] = 0xd00c, [0x7acb] = 0xd00d,
  [0x7acc] = 0xd00e, [0x7acd] = 0xd00f, [0x7ace] = 0xd010, [0x7acf] = 0xd011,
  [0x7ad0] = 0xd012, [0x7ad1] = 0xd013, [0x7ad2] = 0xd014, [0x7ad3] = 0xd015,
  [0x7ad4] = 0xd016, [0x7ad5] = 0xd017, [0x7ad6] = 0xd018, [0x7ad7] = 0xd019,
  [0x7ad8] = 0xd01a, [0x7ad9] = 0xd01b, [0x7ada] = 0xd01c, [0x7adb] = 0xd01d,
  [0x7adc] = 0xd01e, [0x7add] = 0xd01f, [0x7ade] = 0xd020, [0x7adf] = 0xd021,
  [0x7ae0] = 0xd022, [0x7ae1] = 0xd023, [0x7ae2] = 0xd024, [0x7ae3] = 0xd025,
  [0x7ae4] = 0xd026, [0x7ae5] = 0xd027, [0x7ae6] = 0xd028, [0x7ae7] = 0xd029,
  [0x7ae8] = 0xd02a, [0x7ae9] = 0xd02b, [0x7aea] = 0xd02c, [0x7aeb] = 0xd02d,
  [0x7aec] = 0xd02e, [0x7aed] = 0xd02f, [0x7aee] = 0xd030, [0x7aef] = 0xd031,
  [0x7af0] = 0xd032, [0x7af1] = 0xd033, [0x7af2] = 0xd034, [0x7af3] = 0xd035,
  [0x7af4] = 0xd036, [0x7af5] = 0xd037, [0x7af6] = 0xd038, [0x7af7] = 0xd039,
  [0x7af8] = 0xd03a, [0x7af9] = 0xd03b, [0x7afa] = 0xd03c, [0x7afb] = 0xd03d,
  [0x7afc] = 0xd03e, [0x7afd] = 0xd03f, [0x7afe] = 0xd040, [0x7aff] = 0xd041,
  [0x7b00] = 0xd042, [0x7b01] = 0xd043, [0x7b02] = 0xd044, [0x7b03] = 0xd045,
  [0x7b04] = 0xd046, [0x7b05] = 0xd047, [0x7b06] = 0xd048, [0x7b07] = 0xd049,
  [0x7b08] = 0xd04a, [0x7b09] = 0xd04b, [0x7b0a] = 0xd04c, [0x7b0b] = 0xd04d,
  [0x7b0c] = 0xd04e, [0x7b0d] = 0xd04f, [0x7b0e] = 0xd050, [0x7b0f] = 0xd051,
  [0x7b10] = 0xd052, [0x7b11] = 0xd053, [0x7b12] = 0xd054, [0x7b13] = 0xd055,
  [0x7b14] = 0xd056, [0x7b15] = 0xd057, [0x7b16] = 0xd058, [0x7b17] = 0xd059,
  [0x7b18] = 0xd05a, [0x7b19] = 0xd05b, [0x7b1a] = 0xd05c, [0x7b1b] = 0xd05d,
  [0x7b1c] = 0xd05e, [0x7b1d] = 0xd05f, [0x7b1e] = 0xd060, [0x7b1f] = 0xd061,
  [0x7b20] = 0xd062, [0x7b21] = 0xd063, [0x7b22] = 0xd064, [0x7b23] = 0xd065,
  [0x7b24] = 0xd066, [0x7b25] = 0xd067, [0x7b26] = 0xd068, [0x7b27] = 0xd069,
  [0x7b28] = 0xd06a, [0x7b29] = 0xd06b, [0x7b2a] = 0xd06c, [0x7b2b] = 0xd06d,
  [0x7b2c] = 0xd06e, [0x7b2d] = 0xd06f, [0x7b2e] = 0xd070, [0x7b2f] = 0xd071,
  [0x7b30] = 0xd072, [0x7b31] = 0xd073, [0x7b32] = 0xd074, [0x7b33] = 0xd075,
  [0x7b34] = 0xd076, [0x7b35] = 0xd077, [0x7b36] = 0xd078, [0x7b37] = 0xd079,
  [0x7b38] = 0xd07a, [0x7b39] = 0xd07b, [0x7b3a] = 0xd07c, [0x7b3b] = 0xd07d,
  [0x7b3c] = 0xd07e, [0x7b3d] = 0xd07f, [0x7b3e] = 0xd080, [0x7b3f] = 0xd081,
  [0x7b40] = 0xd082, [0x7b41] = 0xd083, [0x7b42] = 0xd084, [0x7b43] = 0xd085,
  [0x7b44] = 0xd086, [0x7b45] = 0xd087, [0x7b46] = 0xd088, [0x7b47] = 0xd089,
  [0x7b48] = 0xd08a, [0x7b49] = 0xd08b, [0x7b4a] = 0xd08c, [0x7b4b] = 0xd08d,
  [0x7b4c] = 0xd08e, [0x7b4d] = 0xd08f, [0x7b4e] = 0xd090, [0x7b4f] = 0xd091,
  [0x7b50] = 0xd092, [0x7b51] = 0xd093, [0x7b52] = 0xd094, [0x7b53] = 0xd095,
  [0x7b54] = 0xd096, [0x7b55] = 0xd097, [0x7b56] = 0xd098, [0x7b57] = 0xd099,
  [0x7b58] = 0xd09a, [0x7b59] = 0xd09b, [0x7b5a] = 0xd09c, [0x7b5b] = 0xd09d,
  [0x7b5c] = 0xd09e, [0x7b5d] = 0xd09f, [0x7b5e] = 0xd0a0, [0x7b5f] = 0xd0a1,
  [0x7b60] = 0xd0a2, [0x7b61] = 0xd0a3, [0x7b62] = 0xd0a4, [0x7b63] = 0xd0a5,
  [0x7b64] = 0xd0a6, [0x7b65] = 0xd0a7, [0x7b66] = 0xd0a8, [0x7b67] = 0xd0a9,
  [0x7b68] = 0xd0aa, [0x7b69] = 0xd0ab, [0x7b6a] = 0xd0ac, [0x7b6b] = 0xd0ad,
  [0x7b6c] = 0xd0ae, [0x7b6d] = 0xd0af, [0x7b6e] = 0xd0b0, [0x7b6f] = 0xd0b1,
  [0x7b70] = 0xd0b2, [0x7b71] = 0xd0b3, [0x7b72] = 0xd0b4, [0x7b73] = 0xd0b5,
  [0x7b74] = 0xd0b6, [0x7b75] = 0xd0b7, [0x7b76] = 0xd0b8, [0x7b77] = 0xd0b9,
  [0x7b78] = 0xd0ba, [0x7b79] = 0xd0bb, [0x7b7a] = 0xd0bc, [0x7b7b] = 0xd0bd,
  [0x7b7c] = 0xd0be, [0x7b7d] = 0xd0bf, [0x7b7e] = 0xd0c0, [0x7b7f] = 0xd0c1,
  [0x7b80] = 0xd0c2, [0x7b81] = 0xd0c3, [0x7b82] = 0xd0c4, [0x7b83] = 0xd0c5,
  [0x7b84] = 0xd0c6, [0x7b85] = 0xd0c7, [0x7b86] = 0xd0c8, [0x7b87] = 0xd0c9,
  [0x7b88] = 0xd0ca, [0x7b89] = 0xd0cb, [0x7b8a] = 0xd0cc, [0x7b8b] = 0xd0cd,
  [0x7b8c] = 0xd0ce, [0x7b8d] = 0xd0cf, [0x7b8e] = 0xd0d0, [0x7b8f] = 0xd0d1,
  [0x7b90] = 0xd0d2, [0x7b91] = 0xd0d3, [0x7b92] = 0xd0d4, [0x7b93] = 0xd0d5,
  [0x7b94] = 0xd0d6, [0x7b95] = 0xd0d7, [0x7b96] = 0xd0d8, [0x7b97] = 0xd0d9,
  [0x7b98] = 0xd0da, [0x7b99] = 0xd0db, [0x7b9a] = 0xd0dc, [0x7b9b] = 0xd0dd,
  [0x7b9c] = 0xd0de, [0x7b9d] = 0xd0df, [0x7b9e] = 0xd0e0, [0x7b9f] = 0xd0e1,
  [0x7ba0] = 0xd0e2, [0x7ba1] = 0xd0e3, [0x7ba2] = 0xd0e4, [0x7ba3] = 0xd0e5,
  [0x7ba4] = 0xd0e6, [0x7ba5] = 0xd0e7, [0x7ba6] = 0xd0e8, [0x7ba7] = 0xd0e9,
  [0x7ba8] = 0xd0ea, [0x7ba9] = 0xd0eb, [0x7baa] = 0xd0ec, [0x7bab] = 0xd0ed,
  [0x7bac] = 0xd0ee, [0x7bad] = 0xd0ef, [0x7bae] = 0xd0f0, [0x7baf] = 0xd0f1,
  [0x7bb0] = 0xd0f2, [0x7bb1] = 0xd0f3, [0x7bb2] = 0xd0f4, [0x7bb3] = 0xd0f5,
  [0x7bb4] = 0xd0f6, [0x7bb5] = 0xd0f7, [0x7bb6] = 0xd0f8, [0x7bb7] = 0xd0f9,
  [0x7bb8] = 0xd0fa, [0x7bb9] = 0xd0fb, [0x7bba] = 0xd0fc, [0x7bbb] = 0xd0fd,
  [0x7bbc] = 0xd0fe, [0x7bbd] = 0xd0ff, [0x7bbe] = 0xd100, [0x7bbf] = 0xd101,
  [0x7bc0] = 0xd102, [0x7bc1] = 0xd103, [0x7bc2] = 0xd104, [0x7bc3] = 0xd105,
  [0x7bc4] = 0xd106, [0x7bc5] = 0xd107, [0x7bc6] = 0xd108, [0x7bc7] = 0xd109,
  [0x7bc8] = 0xd10a, [0x7bc9] = 0xd10b, [0x7bca] = 0xd10c, [0x7bcb] = 0xd10d,
  [0x7bcc] = 0xd10e, [0x7bcd] = 0xd10f, [0x7bce] = 0xd110, [0x7bcf] = 0xd111,
  [0x7bd0] = 0xd112, [0x7bd1] = 0xd113, [0x7bd2] = 0xd114, [0x7bd3] = 0xd115,
  [0x7bd4] = 0xd116, [0x7bd5] = 0xd117, [0x7bd6] = 0xd118, [0x7bd7] = 0xd119,
  [0x7bd8] = 0xd11a, [0x7bd9] = 0xd11b, [0x7bda] = 0xd11c, [0x7bdb] = 0xd11d,
  [0x7bdc] = 0xd11e, [0x7bdd] = 0xd11f, [0x7bde] = 0xd120, [0x7bdf] = 0xd121,
  [0x7be0] = 0xd122, [0x7be1] = 0xd123, [0x7be2] = 0xd124, [0x7be3] = 0xd125,
  [0x7be4] = 0xd126, [0x7be5] = 0xd127, [0x7be6] = 0xd128, [0x7be7] = 0xd129,
  [0x7be8] = 0xd12a, [0x7be9] = 0xd12b, [0x7bea] = 0xd12c, [0x7beb] = 0xd12d,
  [0x7bec] = 0xd12e, [0x7bed] = 0xd12f, [0x7bee] = 0xd130, [0x7bef] = 0xd131,
  [0x7bf0] = 0xd132, [0x7bf1] = 0xd133, [0x7bf2] = 0xd134, [0x7bf3] = 0xd135,
  [0x7bf4] = 0xd136, [0x7bf5] = 0xd137, [0x7bf6] = 0xd138, [0x7bf7] = 0xd139,
  [0x7bf8] = 0xd13a, [0x7bf9] = 0xd13b, [0x7bfa] = 0xd13c, [0x7bfb] = 0xd13d,
  [0x7bfc] = 0xd13e, [0x7bfd] = 0xd13f, [0x7bfe] = 0xd140, [0x7bff] = 0xd141,
  [0x7c00] = 0xd142, [0x7c01] = 0xd143, [0x7c02] = 0xd144, [0x7c03] = 0xd145,
  [0x7c04] = 0xd146, [0x7c05] = 0xd147, [0x7c06] = 0xd148, [0x7c07] = 0xd149,
  [0x7c08] = 0xd14a, [0x7c09] = 0xd14b, [0x7c0a] = 0xd14c, [0x7c0b] = 0xd14d,
  [0x7c0c] = 0xd14e, [0x7c0d] = 0xd14f, [0x7c0e] = 0xd150, [0x7c0f] = 0xd151,
  [0x7c10] = 0xd152, [0x7c11] = 0xd153, [0x7c12] = 0xd154, [0x7c13] = 0xd155,
  [0x7c14] = 0xd156, [0x7c15] = 0xd157, [0x7c16] = 0xd158, [0x7c17] = 0xd159,
  [0x7c18] = 0xd15a, [0x7c19] = 0xd15b, [0x7c1a] = 0xd15c, [0x7c1b] = 0xd15d,
  [0x7c1c] = 0xd15e, [0x7c1d] = 0xd15f, [0x7c1e] = 0xd160, [0x7c1f] = 0xd161,
  [0x7c20] = 0xd162, [0x7c21] = 0xd163, [0x7c22] = 0xd164, [0x7c23] = 0xd165,
  [0x7c24] = 0xd166, [0x7c25] = 0xd167, [0x7c26] = 0xd168, [0x7c27] = 0xd169,
  [0x7c28] = 0xd16a, [0x7c29] = 0xd16b, [0x7c2a] = 0xd16c, [0x7c2b] = 0xd16d,
  [0x7c2c] = 0xd16e, [0x7c2d] = 0xd16f, [0x7c2e] = 0xd170, [0x7c2f] = 0xd171,
  [0x7c30] = 0xd172, [0x7c31] = 0xd173, [0x7c32] = 0xd174, [0x7c33] = 0xd175,
  [0x7c34] = 0xd176, [0x7c35] = 0xd177, [0x7c36] = 0xd178, [0x7c37] = 0xd179,
  [0x7c38] = 0xd17a, [0x7c39] = 0xd17b, [0x7c3a] = 0xd17c, [0x7c3b] = 0xd17d,
  [0x7c3c] = 0xd17e, [0x7c3d] = 0xd17f, [0x7c3e] = 0xd180, [0x7c3f] = 0xd181,
  [0x7c40] = 0xd182, [0x7c41] = 0xd183, [0x7c42] = 0xd184, [0x7c43] = 0xd185,
  [0x7c44] = 0xd186, [0x7c45] = 0xd187, [0x7c46] = 0xd188, [0x7c47] = 0xd189,
  [0x7c48] = 0xd18a, [0x7c49] = 0xd18b, [0x7c4a] = 0xd18c, [0x7c4b] = 0xd18d,
  [0x7c4c] = 0xd18e, [0x7c4d] = 0xd18f, [0x7c4e] = 0xd190, [0x7c4f] = 0xd191,
  [0x7c50] = 0xd192, [0x7c51] = 0xd193, [0x7c52] = 0xd194, [0x7c53] = 0xd195,
  [0x7c54] = 0xd196, [0x7c55] = 0xd197, [0x7c56] = 0xd198, [0x7c57] = 0xd199,
  [0x7c58] = 0xd19a, [0x7c59] = 0xd19b, [0x7c5a] = 0xd19c, [0x7c5b] = 0xd19d,
  [0x7c5c] = 0xd19e, [0x7c5d] = 0xd19f, [0x7c5e] = 0xd1a0, [0x7c5f] = 0xd1a1,
  [0x7c60] = 0xd1a2, [0x7c61] = 0xd1a3, [0x7c62] = 0xd1a4, [0x7c63] = 0xd1a5,
  [0x7c64] = 0xd1a6, [0x7c65] = 0xd1a7, [0x7c66] = 0xd1a8, [0x7c67] = 0xd1a9,
  [0x7c68] = 0xd1aa, [0x7c69] = 0xd1ab, [0x7c6a] = 0xd1ac, [0x7c6b] = 0xd1ad,
  [0x7c6c] = 0xd1ae, [0x7c6d] = 0xd1af, [0x7c6e] = 0xd1b0, [0x7c6f] = 0xd1b1,
  [0x7c70] = 0xd1b2, [0x7c71] = 0xd1b3, [0x7c72] = 0xd1b4, [0x7c73] = 0xd1b5,
  [0x7c74] = 0xd1b6, [0x7c75] = 0xd1b7, [0x7c76] = 0xd1b8, [0x7c77] = 0xd1b9,
  [0x7c78] = 0xd1ba, [0x7c79] = 0xd1bb, [0x7c7a] = 0xd1bc, [0x7c7b] = 0xd1bd,
  [0x7c7c] = 0xd1be, [0x7c7d] = 0xd1bf, [0x7c7e] = 0xd1c0, [0x7c7f] = 0xd1c1,
  [0x7c80] = 0xd1c2, [0x7c81] = 0xd1c3, [0x7c82] = 0xd1c4, [0x7c83] = 0xd1c5,
  [0x7c84] = 0xd1c6, [0x7c85] = 0xd1c7, [0x7c86] = 0xd1c8, [0x7c87] = 0xd1c9,
  [0x7c88] = 0xd1ca, [0x7c89] = 0xd1cb, [0x7c8a] = 0xd1cc, [0x7c8b] = 0xd1cd,
  [0x7c8c] = 0xd1ce, [0x7c8d] = 0xd1cf, [0x7c8e] = 0xd1d0, [0x7c8f] = 0xd1d1,
  [0x7c90] = 0xd1d2, [0x7c91] = 0xd1d3, [0x7c92] = 0xd1d4, [0x7c93] = 0xd1d5,
  [0x7c94] = 0xd1d6, [0x7c95] = 0xd1d7, [0x7c96] = 0xd1d8, [0x7c97] = 0xd1d9,
  [0x7c98] = 0xd1da, [0x7c99] = 0xd1db, [0x7c9a] = 0xd1dc, [0x7c9b] = 0xd1dd,
  [0x7c9c] = 0xd1de, [0x7c9d] = 0xd1df, [0x7c9e] = 0xd1e0, [0x7c9f] = 0xd1e1,
  [0x7ca0] = 0xd1e2, [0x7ca1] = 0xd1e3, [0x7ca2] = 0xd1e4, [0x7ca3] = 0xd1e5,
  [0x7ca4] = 0xd1e6, [0x7ca5] = 0xd1e7, [0x7ca6] = 0xd1e8, [0x7ca7] = 0xd1e9,
  [0x7ca8] = 0xd1ea, [0x7ca9] = 0xd1eb, [0x7caa] = 0xd1ec, [0x7cab] = 0xd1ed,
  [0x7cac] = 0xd1ee, [0x7cad] = 0xd1ef, [0x7cae] = 0xd1f0, [0x7caf] = 0xd1f1,
  [0x7cb0] = 0xd1f2, [0x7cb1] = 0xd1f3, [0x7cb2] = 0xd1f4, [0x7cb3] = 0xd1f5,
  [0x7cb4] = 0xd1f6, [0x7cb5] = 0xd1f7, [0x7cb6] = 0xd1f8, [0x7cb7] = 0xd1f9,
  [0x7cb8] = 0xd1fa, [0x7cb9] = 0xd1fb, [0x7cba] = 0xd1fc, [0x7cbb] = 0xd1fd,
  [0x7cbc] = 0xd1fe, [0x7cbd] = 0xd1ff, [0x7cbe] = 0xd200, [0x7cbf] = 0xd201,
  [0x7cc0] = 0xd202, [0x7cc1] = 0xd203, [0x7cc2] = 0xd204, [0x7cc3] = 0xd205,
  [0x7cc4] = 0xd206, [0x7cc5] = 0xd207, [0x7cc6] = 0xd208, [0x7cc7] = 0xd209,
  [0x7cc8] = 0xd20a, [0x7cc9] = 0xd20b, [0x7cca] = 0xd20c, [0x7ccb] = 0xd20d,
  [0x7ccc] = 0xd20e, [0x7ccd] = 0xd20f, [0x7cce] = 0xd210, [0x7ccf] = 0xd211,
  [0x7cd0] = 0xd212, [0x7cd1] = 0xd213, [0x7cd2] = 0xd214, [0x7cd3] = 0xd215,
  [0x7cd4] = 0xd216, [0x7cd5] = 0xd217, [0x7cd6] = 0xd218, [0x7cd7] = 0xd219,
  [0x7cd8] = 0xd21a, [0x7cd9] = 0xd21b, [0x7cda] = 0xd21c, [0x7cdb] = 0xd21d,
  [0x7cdc] = 0xd21e, [0x7cdd] = 0xd21f, [0x7cde] = 0xd220, [0x7cdf] = 0xd221,
  [0x7ce0] = 0xd222, [0x7ce1] = 0xd223, [0x7ce2] = 0xd224, [0x7ce3] = 0xd225,
  [0x7ce4] = 0xd226, [0x7ce5] = 0xd227, [0x7ce6] = 0xd228, [0x7ce7] = 0xd229,
  [0x7ce8] = 0xd22a, [0x7ce9] = 0xd22b, [0x7cea] = 0xd22c, [0x7ceb] = 0xd22d,
  [0x7cec] = 0xd22e, [0x7ced] = 0xd22f, [0x7cee] = 0xd230, [0x7cef] = 0xd231,
  [0x7cf0] = 0xd232, [0x7cf1] = 0xd233, [0x7cf2] = 0xd234, [0x7cf3] = 0xd235,
  [0x7cf4] = 0xd236, [0x7cf5] = 0xd237, [0x7cf6] = 0xd238, [0x7cf7] = 0xd239,
  [0x7cf8] = 0xd23a, [0x7cf9] = 0xd23b, [0x7cfa] = 0xd23c, [0x7cfb] = 0xd23d,
  [0x7cfc] = 0xd23e, [0x7cfd] = 0xd23f, [0x7cfe] = 0xd240, [0x7cff] = 0xd241,
  [0x7d00] = 0xd242, [0x7d01] = 0xd243, [0x7d02] = 0xd244, [0x7d03] = 0xd245,
  [0x7d04] = 0xd246, [0x7d05] = 0xd247, [0x7d06] = 0xd248, [0x7d07] = 0xd249,
  [0x7d08] = 0xd24a, [0x7d09] = 0xd24b, [0x7d0a] = 0xd24c, [0x7d0b] = 0xd24d,
  [0x7d0c] = 0xd24e, [0x7d0d] = 0xd24f, [0x7d0e] = 0xd250, [0x7d0f] = 0xd251,
  [0x7d10] = 0xd252, [0x7d11] = 0xd253, [0x7d12] = 0xd254, [0x7d13] = 0xd255,
  [0x7d14] = 0xd256, [0x7d15] = 0xd257, [0x7d16] = 0xd258, [0x7d17] = 0xd259,
  [0x7d18] = 0xd25a, [0x7d19] = 0xd25b, [0x7d1a] = 0xd25c, [0x7d1b] = 0xd25d,
  [0x7d1c] = 0xd25e, [0x7d1d] = 0xd25f, [0x7d1e] = 0xd260, [0x7d1f] = 0xd261,
  [0x7d20] = 0xd262, [0x7d21] = 0xd263, [0x7d22] = 0xd264, [0x7d23] = 0xd265,
  [0x7d24] = 0xd266, [0x7d25] = 0xd267, [0x7d26] = 0xd268, [0x7d27] = 0xd269,
  [0x7d28] = 0xd26a, [0x7d29] = 0xd26b, [0x7d2a] = 0xd26c, [0x7d2b] = 0xd26d,
  [0x7d2c] = 0xd26e, [0x7d2d] = 0xd26f, [0x7d2e] = 0xd270, [0x7d2f] = 0xd271,
  [0x7d30] = 0xd272, [0x7d31] = 0xd273, [0x7d32] = 0xd274, [0x7d33] = 0xd275,
  [0x7d34] = 0xd276, [0x7d35] = 0xd277, [0x7d36] = 0xd278, [0x7d37] = 0xd279,
  [0x7d38] = 0xd27a, [0x7d39] = 0xd27b, [0x7d3a] = 0xd27c, [0x7d3b] = 0xd27d,
  [0x7d3c] = 0xd27e, [0x7d3d] = 0xd27f, [0x7d3e] = 0xd280, [0x7d3f] = 0xd281,
  [0x7d40] = 0xd282, [0x7d41] = 0xd283, [0x7d42] = 0xd284, [0x7d43] = 0xd285,
  [0x7d44] = 0xd286, [0x7d45] = 0xd287, [0x7d46] = 0xd288, [0x7d47] = 0xd289,
  [0x7d48] = 0xd28a, [0x7d49] = 0xd28b, [0x7d4a] = 0xd28c, [0x7d4b] = 0xd28d,
  [0x7d4c] = 0xd28e, [0x7d4d] = 0xd28f, [0x7d4e] = 0xd290, [0x7d4f] = 0xd291,
  [0x7d50] = 0xd292, [0x7d51] = 0xd293, [0x7d52] = 0xd294, [0x7d53] = 0xd295,
  [0x7d54] = 0xd296, [0x7d55] = 0xd297, [0x7d56] = 0xd298, [0x7d57] = 0xd299,
  [0x7d58] = 0xd29a, [0x7d59] = 0xd29b, [0x7d5a] = 0xd29c, [0x7d5b] = 0xd29d,
  [0x7d5c] = 0xd29e, [0x7d5d] = 0xd29f, [0x7d5e] = 0xd2a0, [0x7d5f] = 0xd2a1,
  [0x7d60] = 0xd2a2, [0x7d61] = 0xd2a3, [0x7d62] = 0xd2a4, [0x7d63] = 0xd2a5,
  [0x7d64] = 0xd2a6, [0x7d65] = 0xd2a7, [0x7d66] = 0xd2a8, [0x7d67] = 0xd2a9,
  [0x7d68] = 0xd2aa, [0x7d69] = 0xd2ab, [0x7d6a] = 0xd2ac, [0x7d6b] = 0xd2ad,
  [0x7d6c] = 0xd2ae, [0x7d6d] = 0xd2af, [0x7d6e] = 0xd2b0, [0x7d6f] = 0xd2b1,
  [0x7d70] = 0xd2b2, [0x7d71] = 0xd2b3, [0x7d72] = 0xd2b4, [0x7d73] = 0xd2b5,
  [0x7d74] = 0xd2b6, [0x7d75] = 0xd2b7, [0x7d76] = 0xd2b8, [0x7d77] = 0xd2b9,
  [0x7d78] = 0xd2ba, [0x7d79] = 0xd2bb, [0x7d7a] = 0xd2bc, [0x7d7b] = 0xd2bd,
  [0x7d7c] = 0xd2be, [0x7d7d] = 0xd2bf, [0x7d7e] = 0xd2c0, [0x7d7f] = 0xd2c1,
  [0x7d80] = 0xd2c2, [0x7d81] = 0xd2c3, [0x7d82] = 0xd2c4, [0x7d83] = 0xd2c5,
  [0x7d84] = 0xd2c6, [0x7d85] = 0xd2c7, [0x7d86] = 0xd2c8, [0x7d87] = 0xd2c9,
  [0x7d88] = 0xd2ca, [0x7d89] = 0xd2cb, [0x7d8a] = 0xd2cc, [0x7d8b] = 0xd2cd,
  [0x7d8c] = 0xd2ce, [0x7d8d] = 0xd2cf, [0x7d8e] = 0xd2d0, [0x7d8f] = 0xd2d1,
  [0x7d90] = 0xd2d2, [0x7d91] = 0xd2d3, [0x7d92] = 0xd2d4, [0x7d93] = 0xd2d5,
  [0x7d94] = 0xd2d6, [0x7d95] = 0xd2d7, [0x7d96] = 0xd2d8, [0x7d97] = 0xd2d9,
  [0x7d98] = 0xd2da, [0x7d99] = 0xd2db, [0x7d9a] = 0xd2dc, [0x7d9b] = 0xd2dd,
  [0x7d9c] = 0xd2de, [0x7d9d] = 0xd2df, [0x7d9e] = 0xd2e0, [0x7d9f] = 0xd2e1,
  [0x7da0] = 0xd2e2, [0x7da1] = 0xd2e3, [0x7da2] = 0xd2e4, [0x7da3] = 0xd2e5,
  [0x7da4] = 0xd2e6, [0x7da5] = 0xd2e7, [0x7da6] = 0xd2e8, [0x7da7] = 0xd2e9,
  [0x7da8] = 0xd2ea, [0x7da9] = 0xd2eb, [0x7daa] = 0xd2ec, [0x7dab] = 0xd2ed,
  [0x7dac] = 0xd2ee, [0x7dad] = 0xd2ef, [0x7dae] = 0xd2f0, [0x7daf] = 0xd2f1,
  [0x7db0] = 0xd2f2, [0x7db1] = 0xd2f3, [0x7db2] = 0xd2f4, [0x7db3] = 0xd2f5,
  [0x7db4] = 0xd2f6, [0x7db5] = 0xd2f7, [0x7db6] = 0xd2f8, [0x7db7] = 0xd2f9,
  [0x7db8] = 0xd2fa, [0x7db9] = 0xd2fb, [0x7dba] = 0xd2fc, [0x7dbb] = 0xd2fd,
  [0x7dbc] = 0xd2fe, [0x7dbd] = 0xd2ff, [0x7dbe] = 0xd300, [0x7dbf] = 0xd301,
  [0x7dc0] = 0xd302, [0x7dc1] = 0xd303, [0x7dc2] = 0xd304, [0x7dc3] = 0xd305,
  [0x7dc4] = 0xd306, [0x7dc5] = 0xd307, [0x7dc6] = 0xd308, [0x7dc7] = 0xd309,
  [0x7dc8] = 0xd30a, [0x7dc9] = 0xd30b, [0x7dca] = 0xd30c, [0x7dcb] = 0xd30d,
  [0x7dcc] = 0xd30e, [0x7dcd] = 0xd30f, [0x7dce] = 0xd310, [0x7dcf] = 0xd311,
  [0x7dd0] = 0xd312, [0x7dd1] = 0xd313, [0x7dd2] = 0xd314, [0x7dd3] = 0xd315,
  [0x7dd4] = 0xd316, [0x7dd5] = 0xd317, [0x7dd6] = 0xd318, [0x7dd7] = 0xd319,
  [0x7dd8] = 0xd31a, [0x7dd9] = 0xd31b, [0x7dda] = 0xd31c, [0x7ddb] = 0xd31d,
  [0x7ddc] = 0xd31e, [0x7ddd] = 0xd31f, [0x7dde] = 0xd320, [0x7ddf] = 0xd321,
  [0x7de0] = 0xd322, [0x7de1] = 0xd323, [0x7de2] = 0xd324, [0x7de3] = 0xd325,
  [0x7de4] = 0xd326, [0x7de5] = 0xd327, [0x7de6] = 0xd328, [0x7de7] = 0xd329,
  [0x7de8] = 0xd32a, [0x7de9] = 0xd32b, [0x7dea] = 0xd32c, [0x7deb] = 0xd32d,
  [0x7dec] = 0xd32e, [0x7ded] = 0xd32f, [0x7dee] = 0xd330, [0x7def] = 0xd331,
  [0x7df0] = 0xd332, [0x7df1] = 0xd333, [0x7df2] = 0xd334, [0x7df3] = 0xd335,
  [0x7df4] = 0xd336, [0x7df5] = 0xd337, [0x7df6] = 0xd338, [0x7df7] = 0xd339,
  [0x7df8] = 0xd33a, [0x7df9] = 0xd33b, [0x7dfa] = 0xd33c, [0x7dfb] = 0xd33d,
  [0x7dfc] = 0xd33e, [0x7dfd] = 0xd33f, [0x7dfe] = 0xd340, [0x7dff] = 0xd341,
  [0x7e00] = 0xd342, [0x7e01] = 0xd343, [0x7e02] = 0xd344, [0x7e03] = 0xd345,
  [0x7e04] = 0xd346, [0x7e05] = 0xd347, [0x7e06] = 0xd348, [0x7e07] = 0xd349,
  [0x7e08] = 0xd34a, [0x7e09] = 0xd34b, [0x7e0a] = 0xd34c, [0x7e0b] = 0xd34d,
  [0x7e0c] = 0xd34e, [0x7e0d] = 0xd34f, [0x7e0e] = 0xd350, [0x7e0f] = 0xd351,
  [0x7e10] = 0xd352, [0x7e11] = 0xd353, [0x7e12] = 0xd354, [0x7e13] = 0xd355,
  [0x7e14] = 0xd356, [0x7e15] = 0xd357, [0x7e16] = 0xd358, [0x7e17] = 0xd359,
  [0x7e18] = 0xd35a, [0x7e19] = 0xd35b, [0x7e1a] = 0xd35c, [0x7e1b] = 0xd35d,
  [0x7e1c] = 0xd35e, [0x7e1d] = 0xd35f, [0x7e1e] = 0xd360, [0x7e1f] = 0xd361,
  [0x7e20] = 0xd362, [0x7e21] = 0xd363, [0x7e22] = 0xd364, [0x7e23] = 0xd365,
  [0x7e24] = 0xd366, [0x7e25] = 0xd367, [0x7e26] = 0xd368, [0x7e27] = 0xd369,
  [0x7e28] = 0xd36a, [0x7e29] = 0xd36b, [0x7e2a] = 0xd36c, [0x7e2b] = 0xd36d,
  [0x7e2c] = 0xd36e, [0x7e2d] = 0xd36f, [0x7e2e] = 0xd370, [0x7e2f] = 0xd371,
  [0x7e30] = 0xd372, [0x7e31] = 0xd373, [0x7e32] = 0xd374, [0x7e33] = 0xd375,
  [0x7e34] = 0xd376, [0x7e35] = 0xd377, [0x7e36] = 0xd378, [0x7e37] = 0xd379,
  [0x7e38] = 0xd37a, [0x7e39] = 0xd37b, [0x7e3a] = 0xd37c, [0x7e3b] = 0xd37d,
  [0x7e3c] = 0xd37e, [0x7e3d] = 0xd37f, [0x7e3e] = 0xd380, [0x7e3f] = 0xd381,
  [0x7e40] = 0xd382, [0x7e41] = 0xd383, [0x7e42] = 0xd384, [0x7e43] = 0xd385,
  [0x7e44] = 0xd386, [0x7e45] = 0xd387, [0x7e46] = 0xd388, [0x7e47] = 0xd389,
  [0x7e48] = 0xd38a, [0x7e49] = 0xd38b, [0x7e4a] = 0xd38c, [0x7e4b] = 0xd38d,
  [0x7e4c] = 0xd38e, [0x7e4d] = 0xd38f, [0x7e4e] = 0xd390, [0x7e4f] = 0xd391,
  [0x7e50] = 0xd392, [0x7e51] = 0xd393, [0x7e52] = 0xd394, [0x7e53] = 0xd395,
  [0x7e54] = 0xd396, [0x7e55] = 0xd397, [0x7e56] = 0xd398, [0x7e57] = 0xd399,
  [0x7e58] = 0xd39a, [0x7e59] = 0xd39b, [0x7e5a] = 0xd39c, [0x7e5b] = 0xd39d,
  [0x7e5c] = 0xd39e, [0x7e5d] = 0xd39f, [0x7e5e] = 0xd3a0, [0x7e5f] = 0xd3a1,
  [0x7e60] = 0xd3a2, [0x7e61] = 0xd3a3, [0x7e62] = 0xd3a4, [0x7e63] = 0xd3a5,
  [0x7e64] = 0xd3a6, [0x7e65] = 0xd3a7, [0x7e66] = 0xd3a8, [0x7e67] = 0xd3a9,
  [0x7e68] = 0xd3aa, [0x7e69] = 0xd3ab, [0x7e6a] = 0xd3ac, [0x7e6b] = 0xd3ad,
  [0x7e6c] = 0xd3ae, [0x7e6d] = 0xd3af, [0x7e6e] = 0xd3b0, [0x7e6f] = 0xd3b1,
  [0x7e70] = 0xd3b2, [0x7e71] = 0xd3b3, [0x7e72] = 0xd3b4, [0x7e73] = 0xd3b5,
  [0x7e74] = 0xd3b6, [0x7e75] = 0xd3b7, [0x7e76] = 0xd3b8, [0x7e77] = 0xd3b9,
  [0x7e78] = 0xd3ba, [0x7e79] = 0xd3bb, [0x7e7a] = 0xd3bc, [0x7e7b] = 0xd3bd,
  [0x7e7c] = 0xd3be, [0x7e7d] = 0xd3bf, [0x7e7e] = 0xd3c0, [0x7e7f] = 0xd3c1,
  [0x7e80] = 0xd3c2, [0x7e81] = 0xd3c3, [0x7e82] = 0xd3c4, [0x7e83] = 0xd3c5,
  [0x7e84] = 0xd3c6, [0x7e85] = 0xd3c7, [0x7e86] = 0xd3c8, [0x7e87] = 0xd3c9,
  [0x7e88] = 0xd3ca, [0x7e89] = 0xd3cb, [0x7e8a] = 0xd3cc, [0x7e8b] = 0xd3cd,
  [0x7e8c] = 0xd3ce, [0x7e8d] = 0xd3cf, [0x7e8e] = 0xd3d0, [0x7e8f] = 0xd3d1,
  [0x7e90] = 0xd3d2, [0x7e91] = 0xd3d3, [0x7e92] = 0xd3d4, [0x7e93] = 0xd3d5,
  [0x7e94] = 0xd3d6, [0x7e95] = 0xd3d7, [0x7e96] = 0xd3d8, [0x7e97] = 0xd3d9,
  [0x7e98] = 0xd3da, [0x7e99] = 0xd3db, [0x7e9a] = 0xd3dc, [0x7e9b] = 0xd3dd,
  [0x7e9c] = 0xd3de, [0x7e9d] = 0xd3df, [0x7e9e] = 0xd3e0, [0x7e9f] = 0xd3e1,
  [0x7ea0] = 0xd3e2, [0x7ea1] = 0xd3e3, [0x7ea2] = 0xd3e4, [0x7ea3] = 0xd3e5,
  [0x7ea4] = 0xd3e6, [0x7ea5] = 0xd3e7, [0x7ea6] = 0xd3e8, [0x7ea7] = 0xd3e9,
  [0x7ea8] = 0xd3ea, [0x7ea9] = 0xd3eb, [0x7eaa] = 0xd3ec, [0x7eab] = 0xd3ed,
  [0x7eac] = 0xd3ee, [0x7ead] = 0xd3ef, [0x7eae] = 0xd3f0, [0x7eaf] = 0xd3f1,
  [0x7eb0] = 0xd3f2, [0x7eb1] = 0xd3f3, [0x7eb2] = 0xd3f4, [0x7eb3] = 0xd3f5,
  [0x7eb4] = 0xd3f6, [0x7eb5] = 0xd3f7, [0x7eb6] = 0xd3f8, [0x7eb7] = 0xd3f9,
  [0x7eb8] = 0xd3fa, [0x7eb9] = 0xd3fb, [0x7eba] = 0xd3fc, [0x7ebb] = 0xd3fd,
  [0x7ebc] = 0xd3fe, [0x7ebd] = 0xd3ff, [0x7ebe] = 0xd400, [0x7ebf] = 0xd401,
  [0x7ec0] = 0xd402, [0x7ec1] = 0xd403, [0x7ec2] = 0xd404, [0x7ec3] = 0xd405,
  [0x7ec4] = 0xd406, [0x7ec5] = 0xd407, [0x7ec6] = 0xd408, [0x7ec7] = 0xd409,
  [0x7ec8] = 0xd40a, [0x7ec9] = 0xd40b, [0x7eca] = 0xd40c, [0x7ecb] = 0xd40d,
  [0x7ecc] = 0xd40e, [0x7ecd] = 0xd40f, [0x7ece] = 0xd410, [0x7ecf] = 0xd411,
  [0x7ed0] = 0xd412, [0x7ed1] = 0xd413, [0x7ed2] = 0xd414, [0x7ed3] = 0xd415,
  [0x7ed4] = 0xd416, [0x7ed5] = 0xd417, [0x7ed6] = 0xd418, [0x7ed7] = 0xd419,
  [0x7ed8] = 0xd41a, [0x7ed9] = 0xd41b, [0x7eda] = 0xd41c, [0x7edb] = 0xd41d,
  [0x7edc] = 0xd41e, [0x7edd] = 0xd41f, [0x7ede] = 0xd420, [0x7edf] = 0xd421,
  [0x7ee0] = 0xd422, [0x7ee1] = 0xd423, [0x7ee2] = 0xd424, [0x7ee3] = 0xd425,
  [0x7ee4] = 0xd426, [0x7ee5] = 0xd427, [0x7ee6] = 0xd428, [0x7ee7] = 0xd429,
  [0x7ee8] = 0xd42a, [0x7ee9] = 0xd42b, [0x7eea] = 0xd42c, [0x7eeb] = 0xd42d,
  [0x7eec] = 0xd42e, [0x7eed] = 0xd42f, [0x7eee] = 0xd430, [0x7eef] = 0xd431,
  [0x7ef0] = 0xd432, [0x7ef1] = 0xd433, [0x7ef2] = 0xd434, [0x7ef3] = 0xd435,
  [0x7ef4] = 0xd436, [0x7ef5] = 0xd437, [0x7ef6] = 0xd438, [0x7ef7] = 0xd439,
  [0x7ef8] = 0xd43a, [0x7ef9] = 0xd43b, [0x7efa] = 0xd43c, [0x7efb] = 0xd43d,
  [0x7efc] = 0xd43e, [0x7efd] = 0xd43f, [0x7efe] = 0xd440, [0x7eff] = 0xd441,
  [0x7f00] = 0xd442, [0x7f01] = 0xd443, [0x7f02] = 0xd444, [0x7f03] = 0xd445,
  [0x7f04] = 0xd446, [0x7f05] = 0xd447, [0x7f06] = 0xd448, [0x7f07] = 0xd449,
  [0x7f08] = 0xd44a, [0x7f09] = 0xd44b, [0x7f0a] = 0xd44c, [0x7f0b] = 0xd44d,
  [0x7f0c] = 0xd44e, [0x7f0d] = 0xd44f, [0x7f0e] = 0xd450, [0x7f0f] = 0xd451,
  [0x7f10] = 0xd452, [0x7f11] = 0xd453, [0x7f12] = 0xd454, [0x7f13] = 0xd455,
  [0x7f14] = 0xd456, [0x7f15] = 0xd457, [0x7f16] = 0xd458, [0x7f17] = 0xd459,
  [0x7f18] = 0xd45a, [0x7f19] = 0xd45b, [0x7f1a] = 0xd45c, [0x7f1b] = 0xd45d,
  [0x7f1c] = 0xd45e, [0x7f1d] = 0xd45f, [0x7f1e] = 0xd460, [0x7f1f] = 0xd461,
  [0x7f20] = 0xd462, [0x7f21] = 0xd463, [0x7f22] = 0xd464, [0x7f23] = 0xd465,
  [0x7f24] = 0xd466, [0x7f25] = 0xd467, [0x7f26] = 0xd468, [0x7f27] = 0xd469,
  [0x7f28] = 0xd46a, [0x7f29] = 0xd46b, [0x7f2a] = 0xd46c, [0x7f2b] = 0xd46d,
  [0x7f2c] = 0xd46e, [0x7f2d] = 0xd46f, [0x7f2e] = 0xd470, [0x7f2f] = 0xd471,
  [0x7f30] = 0xd472, [0x7f31] = 0xd473, [0x7f32] = 0xd474, [0x7f33] = 0xd475,
  [0x7f34] = 0xd476, [0x7f35] = 0xd477, [0x7f36] = 0xd478, [0x7f37] = 0xd479,
  [0x7f38] = 0xd47a, [0x7f39] = 0xd47b, [0x7f3a] = 0xd47c, [0x7f3b] = 0xd47d,
  [0x7f3c] = 0xd47e, [0x7f3d] = 0xd47f, [0x7f3e] = 0xd480, [0x7f3f] = 0xd481,
  [0x7f40] = 0xd482, [0x7f41] = 0xd483, [0x7f42] = 0xd484, [0x7f43] = 0xd485,
  [0x7f44] = 0xd486, [0x7f45] = 0xd487, [0x7f46] = 0xd488, [0x7f47] = 0xd489,
  [0x7f48] = 0xd48a, [0x7f49] = 0xd48b, [0x7f4a] = 0xd48c, [0x7f4b] = 0xd48d,
  [0x7f4c] = 0xd48e, [0x7f4d] = 0xd48f, [0x7f4e] = 0xd490, [0x7f4f] = 0xd491,
  [0x7f50] = 0xd492, [0x7f51] = 0xd493, [0x7f52] = 0xd494, [0x7f53] = 0xd495,
  [0x7f54] = 0xd496, [0x7f55] = 0xd497, [0x7f56] = 0xd498, [0x7f57] = 0xd499,
  [0x7f58] = 0xd49a, [0x7f59] = 0xd49b, [0x7f5a] = 0xd49c, [0x7f5b] = 0xd49d,
  [0x7f5c] = 0xd49e, [0x7f5d] = 0xd49f, [0x7f5e] = 0xd4a0, [0x7f5f] = 0xd4a1,
  [0x7f60] = 0xd4a2, [0x7f61] = 0xd4a3, [0x7f62] = 0xd4a4, [0x7f63] = 0xd4a5,
  [0x7f64] = 0xd4a6, [0x7f65] = 0xd4a7, [0x7f66] = 0xd4a8, [0x7f67] = 0xd4a9,
  [0x7f68] = 0xd4aa, [0x7f69] = 0xd4ab, [0x7f6a] = 0xd4ac, [0x7f6b] = 0xd4ad,
  [0x7f6c] = 0xd4ae, [0x7f6d] = 0xd4af, [0x7f6e] = 0xd4b0, [0x7f6f] = 0xd4b1,
  [0x7f70] = 0xd4b2, [0x7f71] = 0xd4b3, [0x7f72] = 0xd4b4, [0x7f73] = 0xd4b5,
  [0x7f74] = 0xd4b6, [0x7f75] = 0xd4b7, [0x7f76] = 0xd4b8, [0x7f77] = 0xd4b9,
  [0x7f78] = 0xd4ba, [0x7f79] = 0xd4bb, [0x7f7a] = 0xd4bc, [0x7f7b] = 0xd4bd,
  [0x7f7c] = 0xd4be, [0x7f7d] = 0xd4bf, [0x7f7e] = 0xd4c0, [0x7f7f] = 0xd4c1,
  [0x7f80] = 0xd4c2, [0x7f81] = 0xd4c3, [0x7f82] = 0xd4c4, [0x7f83] = 0xd4c5,
  [0x7f84] = 0xd4c6, [0x7f85] = 0xd4c7, [0x7f86] = 0xd4c8, [0x7f87] = 0xd4c9,
  [0x7f88] = 0xd4ca, [0x7f89] = 0xd4cb, [0x7f8a] = 0xd4cc, [0x7f8b] = 0xd4cd,
  [0x7f8c] = 0xd4ce, [0x7f8d] = 0xd4cf, [0x7f8e] = 0xd4d0, [0x7f8f] = 0xd4d1,
  [0x7f90] = 0xd4d2, [0x7f91] = 0xd4d3, [0x7f92] = 0xd4d4, [0x7f93] = 0xd4d5,
  [0x7f94] = 0xd4d6, [0x7f95] = 0xd4d7, [0x7f96] = 0xd4d8, [0x7f97] = 0xd4d9,
  [0x7f98] = 0xd4da, [0x7f99] = 0xd4db, [0x7f9a] = 0xd4dc, [0x7f9b] = 0xd4dd,
  [0x7f9c] = 0xd4de, [0x7f9d] = 0xd4df, [0x7f9e] = 0xd4e0, [0x7f9f] = 0xd4e1,
  [0x7fa0] = 0xd4e2, [0x7fa1] = 0xd4e3, [0x7fa2] = 0xd4e4, [0x7fa3] = 0xd4e5,
  [0x7fa4] = 0xd4e6, [0x7fa5] = 0xd4e7, [0x7fa6] = 0xd4e8, [0x7fa7] = 0xd4e9,
  [0x7fa8] = 0xd4ea, [0x7fa9] = 0xd4eb, [0x7faa] = 0xd4ec, [0x7fab] = 0xd4ed,
  [0x7fac] = 0xd4ee, [0x7fad] = 0xd4ef, [0x7fae] = 0xd4f0, [0x7faf] = 0xd4f1,
  [0x7fb0] = 0xd4f2, [0x7fb1] = 0xd4f3, [0x7fb2] = 0xd4f4, [0x7fb3] = 0xd4f5,
  [0x7fb4] = 0xd4f6, [0x7fb5] = 0xd4f7, [0x7fb6] = 0xd4f8, [0x7fb7] = 0xd4f9,
  [0x7fb8] = 0xd4fa, [0x7fb9] = 0xd4fb, [0x7fba] = 0xd4fc, [0x7fbb] = 0xd4fd,
  [0x7fbc] = 0xd4fe, [0x7fbd] = 0xd4ff, [0x7fbe] = 0xd500, [0x7fbf] = 0xd501,
  [0x7fc0] = 0xd502, [0x7fc1] = 0xd503, [0x7fc2] = 0xd504, [0x7fc3] = 0xd505,
  [0x7fc4] = 0xd506, [0x7fc5] = 0xd507, [0x7fc6] = 0xd508, [0x7fc7] = 0xd509,
  [0x7fc8] = 0xd50a, [0x7fc9] = 0xd50b, [0x7fca] = 0xd50c, [0x7fcb] = 0xd50d,
  [0x7fcc] = 0xd50e, [0x7fcd] = 0xd50f, [0x7fce] = 0xd510, [0x7fcf] = 0xd511,
  [0x7fd0] = 0xd512, [0x7fd1] = 0xd513, [0x7fd2] = 0xd514, [0x7fd3] = 0xd515,
  [0x7fd4] = 0xd516, [0x7fd5] = 0xd517, [0x7fd6] = 0xd518, [0x7fd7] = 0xd519,
  [0x7fd8] = 0xd51a, [0x7fd9] = 0xd51b, [0x7fda] = 0xd51c, [0x7fdb] = 0xd51d,
  [0x7fdc] = 0xd51e, [0x7fdd] = 0xd51f, [0x7fde] = 0xd520, [0x7fdf] = 0xd521,
  [0x7fe0] = 0xd522, [0x7fe1] = 0xd523, [0x7fe2] = 0xd524, [0x7fe3] = 0xd525,
  [0x7fe4] = 0xd526, [0x7fe5] = 0xd527, [0x7fe6] = 0xd528, [0x7fe7] = 0xd529,
  [0x7fe8] = 0xd52a, [0x7fe9] = 0xd52b, [0x7fea] = 0xd52c, [0x7feb] = 0xd52d,
  [0x7fec] = 0xd52e, [0x7fed] = 0xd52f, [0x7fee] = 0xd530, [0x7fef] = 0xd531,
  [0x7ff0] = 0xd532, [0x7ff1] = 0xd533, [0x7ff2] = 0xd534, [0x7ff3] = 0xd535,
  [0x7ff4] = 0xd536, [0x7ff5] = 0xd537, [0x7ff6] = 0xd538, [0x7ff7] = 0xd539,
  [0x7ff8] = 0xd53a, [0x7ff9] = 0xd53b, [0x7ffa] = 0xd53c, [0x7ffb] = 0xd53d,
  [0x7ffc] = 0xd53e, [0x7ffd] = 0xd53f, [0x7ffe] = 0xd540, [0x7fff] = 0xd541,
  [0x8000] = 0xd542, [0x8001] = 0xd543, [0x8002] = 0xd544, [0x8003] = 0xd545,
  [0x8004] = 0xd546, [0x8005] = 0xd547, [0x8006] = 0xd548, [0x8007] = 0xd549,
  [0x8008] = 0xd54a, [0x8009] = 0xd54b, [0x800a] = 0xd54c, [0x800b] = 0xd54d,
  [0x800c] = 0xd54e, [0x800d] = 0xd54f, [0x800e] = 0xd550, [0x800f] = 0xd551,
  [0x8010] = 0xd552, [0x8011] = 0xd553, [0x8012] = 0xd554, [0x8013] = 0xd555,
  [0x8014] = 0xd556, [0x8015] = 0xd557, [0x8016] = 0xd558, [0x8017] = 0xd559,
  [0x8018] = 0xd55a, [0x8019] = 0xd55b, [0x801a] = 0xd55c, [0x801b] = 0xd55d,
  [0x801c] = 0xd55e, [0x801d] = 0xd55f, [0x801e] = 0xd560, [0x801f] = 0xd561,
  [0x8020] = 0xd562, [0x8021] = 0xd563, [0x8022] = 0xd564, [0x8023] = 0xd565,
  [0x8024] = 0xd566, [0x8025] = 0xd567, [0x8026] = 0xd568, [0x8027] = 0xd569,
  [0x8028] = 0xd56a, [0x8029] = 0xd56b, [0x802a] = 0xd56c, [0x802b] = 0xd56d,
  [0x802c] = 0xd56e, [0x802d] = 0xd56f, [0x802e] = 0xd570, [0x802f] = 0xd571,
  [0x8030] = 0xd572, [0x8031] = 0xd573, [0x8032] = 0xd574, [0x8033] = 0xd575,
  [0x8034] = 0xd576, [0x8035] = 0xd577, [0x8036] = 0xd578, [0x8037] = 0xd579,
  [0x8038] = 0xd57a, [0x8039] = 0xd57b, [0x803a] = 0xd57c, [0x803b] = 0xd57d,
  [0x803c] = 0xd57e, [0x803d] = 0xd57f, [0x803e] = 0xd580, [0x803f] = 0xd581,
  [0x8040] = 0xd582, [0x8041] = 0xd583, [0x8042] = 0xd584, [0x8043] = 0xd585,
  [0x8044] = 0xd586, [0x8045] = 0xd587, [0x8046] = 0xd588, [0x8047] = 0xd589,
  [0x8048] = 0xd58a, [0x8049] = 0xd58b, [0x804a] = 0xd58c, [0x804b] = 0xd58d,
  [0x804c] = 0xd58e, [0x804d] = 0xd58f, [0x804e] = 0xd590, [0x804f] = 0xd591,
  [0x8050] = 0xd592, [0x8051] = 0xd593, [0x8052] = 0xd594, [0x8053] = 0xd595,
  [0x8054] = 0xd596, [0x8055] = 0xd597, [0x8056] = 0xd598, [0x8057] = 0xd599,
  [0x8058] = 0xd59a, [0x8059] = 0xd59b, [0x805a] = 0xd59c, [0x805b] = 0xd59d,
  [0x805c] = 0xd59e, [0x805d] = 0xd59f, [0x805e] = 0xd5a0, [0x805f] = 0xd5a1,
  [0x8060] = 0xd5a2, [0x8061] = 0xd5a3, [0x8062] = 0xd5a4, [0x8063] = 0xd5a5,
  [0x8064] = 0xd5a6, [0x8065] = 0xd5a7, [0x8066] = 0xd5a8, [0x8067] = 0xd5a9,
  [0x8068] = 0xd5aa, [0x8069] = 0xd5ab, [0x806a] = 0xd5ac, [0x806b] = 0xd5ad,
  [0x806c] = 0xd5ae, [0x806d] = 0xd5af, [0x806e] = 0xd5b0, [0x806f] = 0xd5b1,
  [0x8070] = 0xd5b2, [0x8071] = 0xd5b3, [0x8072] = 0xd5b4, [0x8073] = 0xd5b5,
  [0x8074] = 0xd5b6, [0x8075] = 0xd5b7, [0x8076] = 0xd5b8, [0x8077] = 0xd5b9,
  [0x8078] = 0xd5ba, [0x8079] = 0xd5bb, [0x807a] = 0xd5bc, [0x807b] = 0xd5bd,
  [0x807c] = 0xd5be, [0x807d] = 0xd5bf, [0x807e] = 0xd5c0, [0x807f] = 0xd5c1,
  [0x8080] = 0xd5c2, [0x8081] = 0xd5c3, [0x8082] = 0xd5c4, [0x8083] = 0xd5c5,
  [0x8084] = 0xd5c6, [0x8085] = 0xd5c7, [0x8086] = 0xd5c8, [0x8087] = 0xd5c9,
  [0x8088] = 0xd5ca, [0x8089] = 0xd5cb, [0x808a] = 0xd5cc, [0x808b] = 0xd5cd,
  [0x808c] = 0xd5ce, [0x808d] = 0xd5cf, [0x808e] = 0xd5d0, [0x808f] = 0xd5d1,
  [0x8090] = 0xd5d2, [0x8091] = 0xd5d3, [0x8092] = 0xd5d4, [0x8093] = 0xd5d5,
  [0x8094] = 0xd5d6, [0x8095] = 0xd5d7, [0x8096] = 0xd5d8, [0x8097] = 0xd5d9,
  [0x8098] = 0xd5da, [0x8099] = 0xd5db, [0x809a] = 0xd5dc, [0x809b] = 0xd5dd,
  [0x809c] = 0xd5de, [0x809d] = 0xd5df, [0x809e] = 0xd5e0, [0x809f] = 0xd5e1,
  [0x80a0] = 0xd5e2, [0x80a1] = 0xd5e3, [0x80a2] = 0xd5e4, [0x80a3] = 0xd5e5,
  [0x80a4] = 0xd5e6, [0x80a5] = 0xd5e7, [0x80a6] = 0xd5e8, [0x80a7] = 0xd5e9,
  [0x80a8] = 0xd5ea, [0x80a9] = 0xd5eb, [0x80aa] = 0xd5ec, [0x80ab] = 0xd5ed,
  [0x80ac] = 0xd5ee, [0x80ad] = 0xd5ef, [0x80ae] = 0xd5f0, [0x80af] = 0xd5f1,
  [0x80b0] = 0xd5f2, [0x80b1] = 0xd5f3, [0x80b2] = 0xd5f4, [0x80b3] = 0xd5f5,
  [0x80b4] = 0xd5f6, [0x80b5] = 0xd5f7, [0x80b6] = 0xd5f8, [0x80b7] = 0xd5f9,
  [0x80b8] = 0xd5fa, [0x80b9] = 0xd5fb, [0x80ba] = 0xd5fc, [0x80bb] = 0xd5fd,
  [0x80bc] = 0xd5fe, [0x80bd] = 0xd5ff, [0x80be] = 0xd600, [0x80bf] = 0xd601,
  [0x80c0] = 0xd602, [0x80c1] = 0xd603, [0x80c2] = 0xd604, [0x80c3] = 0xd605,
  [0x80c4] = 0xd606, [0x80c5] = 0xd607, [0x80c6] = 0xd608, [0x80c7] = 0xd609,
  [0x80c8] = 0xd60a, [0x80c9] = 0xd60b, [0x80ca] = 0xd60c, [0x80cb] = 0xd60d,
  [0x80cc] = 0xd60e, [0x80cd] = 0xd60f, [0x80ce] = 0xd610, [0x80cf] = 0xd611,
  [0x80d0] = 0xd612, [0x80d1] = 0xd613, [0x80d2] = 0xd614, [0x80d3] = 0xd615,
  [0x80d4] = 0xd616, [0x80d5] = 0xd617, [0x80d6] = 0xd618, [0x80d7] = 0xd619,
  [0x80d8] = 0xd61a, [0x80d9] = 0xd61b, [0x80da] = 0xd61c, [0x80db] = 0xd61d,
  [0x80dc] = 0xd61e, [0x80dd] = 0xd61f, [0x80de] = 0xd620, [0x80df] = 0xd621,
  [0x80e0] = 0xd622, [0x80e1] = 0xd623, [0x80e2] = 0xd624, [0x80e3] = 0xd625,
  [0x80e4] = 0xd626, [0x80e5] = 0xd627, [0x80e6] = 0xd628, [0x80e7] = 0xd629,
  [0x80e8] = 0xd62a, [0x80e9] = 0xd62b, [0x80ea] = 0xd62c, [0x80eb] = 0xd62d,
  [0x80ec] = 0xd62e, [0x80ed] = 0xd62f, [0x80ee] = 0xd630, [0x80ef] = 0xd631,
  [0x80f0] = 0xd632, [0x80f1] = 0xd633, [0x80f2] = 0xd634, [0x80f3] = 0xd635,
  [0x80f4] = 0xd636, [0x80f5] = 0xd637, [0x80f6] = 0xd638, [0x80f7] = 0xd639,
  [0x80f8] = 0xd63a, [0x80f9] = 0xd63b, [0x80fa] = 0xd63c, [0x80fb] = 0xd63d,
  [0x80fc] = 0xd63e, [0x80fd] = 0xd63f, [0x80fe] = 0xd640, [0x80ff] = 0xd641,
  [0x8100] = 0xd642, [0x8101] = 0xd643, [0x8102] = 0xd644, [0x8103] = 0xd645,
  [0x8104] = 0xd646, [0x8105] = 0xd647, [0x8106] = 0xd648, [0x8107] = 0xd649,
  [0x8108] = 0xd64a, [0x8109] = 0xd64b, [0x810a] = 0xd64c, [0x810b] = 0xd64d,
  [0x810c] = 0xd64e, [0x810d] = 0xd64f, [0x810e] = 0xd650, [0x810f] = 0xd651,
  [0x8110] = 0xd652, [0x8111] = 0xd653, [0x8112] = 0xd654, [0x8113] = 0xd655,
  [0x8114] = 0xd656, [0x8115] = 0xd657, [0x8116] = 0xd658, [0x8117] = 0xd659,
  [0x8118] = 0xd65a, [0x8119] = 0xd65b, [0x811a] = 0xd65c, [0x811b] = 0xd65d,
  [0x811c] = 0xd65e, [0x811d] = 0xd65f, [0x811e] = 0xd660, [0x811f] = 0xd661,
  [0x8120] = 0xd662, [0x8121] = 0xd663, [0x8122] = 0xd664, [0x8123] = 0xd665,
  [0x8124] = 0xd666, [0x8125] = 0xd667, [0x8126] = 0xd668, [0x8127] = 0xd669,
  [0x8128] = 0xd66a, [0x8129] = 0xd66b, [0x812a] = 0xd66c, [0x812b] = 0xd66d,
  [0x812c] = 0xd66e, [0x812d] = 0xd66f, [0x812e] = 0xd670, [0x812f] = 0xd671,
  [0x8130] = 0xd672, [0x8131] = 0xd673, [0x8132] = 0xd674, [0x8133] = 0xd675,
  [0x8134] = 0xd676, [0x8135] = 0xd677, [0x8136] = 0xd678, [0x8137] = 0xd679,
  [0x8138] = 0xd67a, [0x8139] = 0xd67b, [0x813a] = 0xd67c, [0x813b] = 0xd67d,
  [0x813c] = 0xd67e, [0x813d] = 0xd67f, [0x813e] = 0xd680, [0x813f] = 0xd681,
  [0x8140] = 0xd682, [0x8141] = 0xd683, [0x8142] = 0xd684, [0x8143] = 0xd685,
  [0x8144] = 0xd686, [0x8145] = 0xd687, [0x8146] = 0xd688, [0x8147] = 0xd689,
  [0x8148] = 0xd68a, [0x8149] = 0xd68b, [0x814a] = 0xd68c, [0x814b] = 0xd68d,
  [0x814c] = 0xd68e, [0x814d] = 0xd68f, [0x814e] = 0xd690, [0x814f] = 0xd691,
  [0x8150] = 0xd692, [0x8151] = 0xd693, [0x8152] = 0xd694, [0x8153] = 0xd695,
  [0x8154] = 0xd696, [0x8155] = 0xd697, [0x8156] = 0xd698, [0x8157] = 0xd699,
  [0x8158] = 0xd69a, [0x8159] = 0xd69b, [0x815a] = 0xd69c, [0x815b] = 0xd69d,
  [0x815c] = 0xd69e, [0x815d] = 0xd69f, [0x815e] = 0xd6a0, [0x815f] = 0xd6a1,
  [0x8160] = 0xd6a2, [0x8161] = 0xd6a3, [0x8162] = 0xd6a4, [0x8163] = 0xd6a5,
  [0x8164] = 0xd6a6, [0x8165] = 0xd6a7, [0x8166] = 0xd6a8, [0x8167] = 0xd6a9,
  [0x8168] = 0xd6aa, [0x8169] = 0xd6ab, [0x816a] = 0xd6ac, [0x816b] = 0xd6ad,
  [0x816c] = 0xd6ae, [0x816d] = 0xd6af, [0x816e] = 0xd6b0, [0x816f] = 0xd6b1,
  [0x8170] = 0xd6b2, [0x8171] = 0xd6b3, [0x8172] = 0xd6b4, [0x8173] = 0xd6b5,
  [0x8174] = 0xd6b6, [0x8175] = 0xd6b7, [0x8176] = 0xd6b8, [0x8177] = 0xd6b9,
  [0x8178] = 0xd6ba, [0x8179] = 0xd6bb, [0x817a] = 0xd6bc, [0x817b] = 0xd6bd,
  [0x817c] = 0xd6be, [0x817d] = 0xd6bf, [0x817e] = 0xd6c0, [0x817f] = 0xd6c1,
  [0x8180] = 0xd6c2, [0x8181] = 0xd6c3, [0x8182] = 0xd6c4, [0x8183] = 0xd6c5,
  [0x8184] = 0xd6c6, [0x8185] = 0xd6c7, [0x8186] = 0xd6c8, [0x8187] = 0xd6c9,
  [0x8188] = 0xd6ca, [0x8189] = 0xd6cb, [0x818a] = 0xd6cc, [0x818b] = 0xd6cd,
  [0x818c] = 0xd6ce, [0x818d] = 0xd6cf, [0x818e] = 0xd6d0, [0x818f] = 0xd6d1,
  [0x8190] = 0xd6d2, [0x8191] = 0xd6d3, [0x8192] = 0xd6d4, [0x8193] = 0xd6d5,
  [0x8194] = 0xd6d6, [0x8195] = 0xd6d7, [0x8196] = 0xd6d8, [0x8197] = 0xd6d9,
  [0x8198] = 0xd6da, [0x8199] = 0xd6db, [0x819a] = 0xd6dc, [0x819b] = 0xd6dd,
  [0x819c] = 0xd6de, [0x819d] = 0xd6df, [0x819e] = 0xd6e0, [0x819f] = 0xd6e1,
  [0x81a0] = 0xd6e2, [0x81a1] = 0xd6e3, [0x81a2] = 0xd6e4, [0x81a3] = 0xd6e5,
  [0x81a4] = 0xd6e6, [0x81a5] = 0xd6e7, [0x81a6] = 0xd6e8, [0x81a7] = 0xd6e9,
  [0x81a8] = 0xd6ea, [0x81a9] = 0xd6eb, [0x81aa] = 0xd6ec, [0x81ab] = 0xd6ed,
  [0x81ac] = 0xd6ee, [0x81ad] = 0xd6ef, [0x81ae] = 0xd6f0, [0x81af] = 0xd6f1,
  [0x81b0] = 0xd6f2, [0x81b1] = 0xd6f3, [0x81b2] = 0xd6f4, [0x81b3] = 0xd6f5,
  [0x81b4] = 0xd6f6, [0x81b5] = 0xd6f7, [0x81b6] = 0xd6f8, [0x81b7] = 0xd6f9,
  [0x81b8] = 0xd6fa, [0x81b9] = 0xd6fb, [0x81ba] = 0xd6fc, [0x81bb] = 0xd6fd,
  [0x81bc] = 0xd6fe, [0x81bd] = 0xd6ff, [0x81be] = 0xd700, [0x81bf] = 0xd701,
  [0x81c0] = 0xd702, [0x81c1] = 0xd703, [0x81c2] = 0xd704, [0x81c3] = 0xd705,
  [0x81c4] = 0xd706, [0x81c5] = 0xd707, [0x81c6] = 0xd708, [0x81c7] = 0xd709,
  [0x81c8] = 0xd70a, [0x81c9] = 0xd70b, [0x81ca] = 0xd70c, [0x81cb] = 0xd70d,
  [0x81cc] = 0xd70e, [0x81cd] = 0xd70f, [0x81ce] = 0xd710, [0x81cf] = 0xd711,
  [0x81d0] = 0xd712, [0x81d1] = 0xd713, [0x81d2] = 0xd714, [0x81d3] = 0xd715,
  [0x81d4] = 0xd716, [0x81d5] = 0xd717, [0x81d6] = 0xd718, [0x81d7] = 0xd719,
  [0x81d8] = 0xd71a, [0x81d9] = 0xd71b, [0x81da] = 0xd71c, [0x81db] = 0xd71d,
  [0x81dc] = 0xd71e, [0x81dd] = 0xd71f, [0x81de] = 0xd720, [0x81df] = 0xd721,
  [0x81e0] = 0xd722, [0x81e1] = 0xd723, [0x81e2] = 0xd724, [0x81e3] = 0xd725,
  [0x81e4] = 0xd726, [0x81e5] = 0xd727, [0x81e6] = 0xd728, [0x81e7] = 0xd729,
  [0x81e8] = 0xd72a, [0x81e9] = 0xd72b, [0x81ea] = 0xd72c, [0x81eb] = 0xd72d,
  [0x81ec] = 0xd72e, [0x81ed] = 0xd72f, [0x81ee] = 0xd730, [0x81ef] = 0xd731,
  [0x81f0] = 0xd732, [0x81f1] = 0xd733, [0x81f2] = 0xd734, [0x81f3] = 0xd735,
  [0x81f4] = 0xd736, [0x81f5] = 0xd737, [0x81f6] = 0xd738, [0x81f7] = 0xd739,
  [0x81f8] = 0xd73a, [0x81f9] = 0xd73b, [0x81fa] = 0xd73c, [0x81fb] = 0xd73d,
  [0x81fc] = 0xd73e, [0x81fd] = 0xd73f, [0x81fe] = 0xd740, [0x81ff] = 0xd741,
  [0x8200] = 0xd742, [0x8201] = 0xd743, [0x8202] = 0xd744, [0x8203] = 0xd745,
  [0x8204] = 0xd746, [0x8205] = 0xd747, [0x8206] = 0xd748, [0x8207] = 0xd749,
  [0x8208] = 0xd74a, [0x8209] = 0xd74b, [0x820a] = 0xd74c, [0x820b] = 0xd74d,
  [0x820c] = 0xd74e, [0x820d] = 0xd74f, [0x820e] = 0xd750, [0x820f] = 0xd751,
  [0x8210] = 0xd752, [0x8211] = 0xd753, [0x8212] = 0xd754, [0x8213] = 0xd755,
  [0x8214] = 0xd756, [0x8215] = 0xd757, [0x8216] = 0xd758, [0x8217] = 0xd759,
  [0x8218] = 0xd75a, [0x8219] = 0xd75b, [0x821a] = 0xd75c, [0x821b] = 0xd75d,
  [0x821c] = 0xd75e, [0x821d] = 0xd75f, [0x821e] = 0xd760, [0x821f] = 0xd761,
  [0x8220] = 0xd762, [0x8221] = 0xd763, [0x8222] = 0xd764, [0x8223] = 0xd765,
  [0x8224] = 0xd766, [0x8225] = 0xd767, [0x8226] = 0xd768, [0x8227] = 0xd769,
  [0x8228] = 0xd76a, [0x8229] = 0xd76b, [0x822a] = 0xd76c, [0x822b] = 0xd76d,
  [0x822c] = 0xd76e, [0x822d] = 0xd76f, [0x822e] = 0xd770, [0x822f] = 0xd771,
  [0x8230] = 0xd772, [0x8231] = 0xd773, [0x8232] = 0xd774, [0x8233] = 0xd775,
  [0x8234] = 0xd776, [0x8235] = 0xd777, [0x8236] = 0xd778, [0x8237] = 0xd779,
  [0x8238] = 0xd77a, [0x8239] = 0xd77b, [0x823a] = 0xd77c, [0x823b] = 0xd77d,
  [0x823c] = 0xd77e, [0x823d] = 0xd77f, [0x823e] = 0xd780, [0x823f] = 0xd781,
  [0x8240] = 0xd782, [0x8241] = 0xd783, [0x8242] = 0xd784, [0x8243] = 0xd785,
  [0x8244] = 0xd786, [0x8245] = 0xd787, [0x8246] = 0xd788, [0x8247] = 0xd789,
  [0x8248] = 0xd78a, [0x8249] = 0xd78b, [0x824a] = 0xd78c, [0x824b] = 0xd78d,
  [0x824c] = 0xd78e, [0x824d] = 0xd78f, [0x824e] = 0xd790, [0x824f] = 0xd791,
  [0x8250] = 0xd792, [0x8251] = 0xd793, [0x8252] = 0xd794, [0x8253] = 0xd795,
  [0x8254] = 0xd796, [0x8255] = 0xd797, [0x8256] = 0xd798, [0x8257] = 0xd799,
  [0x8258] = 0xd79a, [0x8259] = 0xd79b, [0x825a] = 0xd79c, [0x825b] = 0xd79d,
  [0x825c] = 0xd79e, [0x825d] = 0xd79f, [0x825e] = 0xd7a0, [0x825f] = 0xd7a1,
  [0x8260] = 0xd7a2, [0x8261] = 0xd7a3,
#if 0
  [0x8abe] = 0xe865, [0x8abf] = 0xe866,
  [0x8ac0] = 0xe867, [0x8ac1] = 0xe868, [0x8ac2] = 0xe869, [0x8ac3] = 0xe86a,
  [0x8ac4] = 0xe86b, [0x8ac5] = 0xe86c, [0x8ac6] = 0xe86d, [0x8ac7] = 0xe86e,
  [0x8ac8] = 0xe86f, [0x8ac9] = 0xe870, [0x8aca] = 0xe871, [0x8acb] = 0xe872,
  [0x8acc] = 0xe873, [0x8acd] = 0xe874, [0x8ace] = 0xe875, [0x8acf] = 0xe876,
  [0x8ad0] = 0xe877, [0x8ad1] = 0xe878, [0x8ad2] = 0xe879, [0x8ad3] = 0xe87a,
  [0x8ad4] = 0xe87b, [0x8ad5] = 0xe87c, [0x8ad6] = 0xe87d, [0x8ad7] = 0xe87e,
  [0x8ad8] = 0xe87f, [0x8ad9] = 0xe880, [0x8ada] = 0xe881, [0x8adb] = 0xe882,
  [0x8adc] = 0xe883, [0x8add] = 0xe884, [0x8ade] = 0xe885, [0x8adf] = 0xe886,
  [0x8ae0] = 0xe887, [0x8ae1] = 0xe888, [0x8ae2] = 0xe889, [0x8ae3] = 0xe88a,
  [0x8ae4] = 0xe88b, [0x8ae5] = 0xe88c, [0x8ae6] = 0xe88d, [0x8ae7] = 0xe88e,
  [0x8ae8] = 0xe88f, [0x8ae9] = 0xe890, [0x8aea] = 0xe891, [0x8aeb] = 0xe892,
  [0x8aec] = 0xe893, [0x8aed] = 0xe894, [0x8aee] = 0xe895, [0x8aef] = 0xe896,
  [0x8af0] = 0xe897, [0x8af1] = 0xe898, [0x8af2] = 0xe899, [0x8af3] = 0xe89a,
  [0x8af4] = 0xe89b, [0x8af5] = 0xe89c, [0x8af6] = 0xe89d, [0x8af7] = 0xe89e,
  [0x8af8] = 0xe89f, [0x8af9] = 0xe8a0, [0x8afa] = 0xe8a1, [0x8afb] = 0xe8a2,
  [0x8afc] = 0xe8a3, [0x8afd] = 0xe8a4, [0x8afe] = 0xe8a5, [0x8aff] = 0xe8a6,
  [0x8b00] = 0xe8a7, [0x8b01] = 0xe8a8, [0x8b02] = 0xe8a9, [0x8b03] = 0xe8aa,
  [0x8b04] = 0xe8ab, [0x8b05] = 0xe8ac, [0x8b06] = 0xe8ad, [0x8b07] = 0xe8ae,
  [0x8b08] = 0xe8af, [0x8b09] = 0xe8b0, [0x8b0a] = 0xe8b1, [0x8b0b] = 0xe8b2,
  [0x8b0c] = 0xe8b3, [0x8b0d] = 0xe8b4, [0x8b0e] = 0xe8b5, [0x8b0f] = 0xe8b6,
  [0x8b10] = 0xe8b7, [0x8b11] = 0xe8b8, [0x8b12] = 0xe8b9, [0x8b13] = 0xe8ba,
  [0x8b14] = 0xe8bb, [0x8b15] = 0xe8bc, [0x8b16] = 0xe8bd, [0x8b17] = 0xe8be,
  [0x8b18] = 0xe8bf, [0x8b19] = 0xe8c0, [0x8b1a] = 0xe8c1, [0x8b1b] = 0xe8c2,
  [0x8b1c] = 0xe8c3, [0x8b1d] = 0xe8c4, [0x8b1e] = 0xe8c5, [0x8b1f] = 0xe8c6,
  [0x8b20] = 0xe8c7, [0x8b21] = 0xe8c8, [0x8b22] = 0xe8c9, [0x8b23] = 0xe8ca,
  [0x8b24] = 0xe8cb, [0x8b25] = 0xe8cc, [0x8b26] = 0xe8cd, [0x8b27] = 0xe8ce,
  [0x8b28] = 0xe8cf, [0x8b29] = 0xe8d0, [0x8b2a] = 0xe8d1, [0x8b2b] = 0xe8d2,
  [0x8b2c] = 0xe8d3, [0x8b2d] = 0xe8d4, [0x8b2e] = 0xe8d5, [0x8b2f] = 0xe8d6,
  [0x8b30] = 0xe8d7, [0x8b31] = 0xe8d8, [0x8b32] = 0xe8d9, [0x8b33] = 0xe8da,
  [0x8b34] = 0xe8db, [0x8b35] = 0xe8dc, [0x8b36] = 0xe8dd, [0x8b37] = 0xe8de,
  [0x8b38] = 0xe8df, [0x8b39] = 0xe8e0, [0x8b3a] = 0xe8e1, [0x8b3b] = 0xe8e2,
  [0x8b3c] = 0xe8e3, [0x8b3d] = 0xe8e4, [0x8b3e] = 0xe8e5, [0x8b3f] = 0xe8e6,
  [0x8b40] = 0xe8e7, [0x8b41] = 0xe8e8, [0x8b42] = 0xe8e9, [0x8b43] = 0xe8ea,
  [0x8b44] = 0xe8eb, [0x8b45] = 0xe8ec, [0x8b46] = 0xe8ed, [0x8b47] = 0xe8ee,
  [0x8b48] = 0xe8ef, [0x8b49] = 0xe8f0, [0x8b4a] = 0xe8f1, [0x8b4b] = 0xe8f2,
  [0x8b4c] = 0xe8f3, [0x8b4d] = 0xe8f4, [0x8b4e] = 0xe8f5, [0x8b4f] = 0xe8f6,
  [0x8b50] = 0xe8f7, [0x8b51] = 0xe8f8, [0x8b52] = 0xe8f9, [0x8b53] = 0xe8fa,
  [0x8b54] = 0xe8fb, [0x8b55] = 0xe8fc, [0x8b56] = 0xe8fd, [0x8b57] = 0xe8fe,
  [0x8b58] = 0xe8ff, [0x8b59] = 0xe900, [0x8b5a] = 0xe901, [0x8b5b] = 0xe902,
  [0x8b5c] = 0xe903, [0x8b5d] = 0xe904, [0x8b5e] = 0xe905, [0x8b5f] = 0xe906,
  [0x8b60] = 0xe907, [0x8b61] = 0xe908, [0x8b62] = 0xe909, [0x8b63] = 0xe90a,
  [0x8b64] = 0xe90b, [0x8b65] = 0xe90c, [0x8b66] = 0xe90d, [0x8b67] = 0xe90e,
  [0x8b68] = 0xe90f, [0x8b69] = 0xe910, [0x8b6a] = 0xe911, [0x8b6b] = 0xe912,
  [0x8b6c] = 0xe913, [0x8b6d] = 0xe914, [0x8b6e] = 0xe915, [0x8b6f] = 0xe916,
  [0x8b70] = 0xe917, [0x8b71] = 0xe918, [0x8b72] = 0xe919, [0x8b73] = 0xe91a,
  [0x8b74] = 0xe91b, [0x8b75] = 0xe91c, [0x8b76] = 0xe91d, [0x8b77] = 0xe91e,
  [0x8b78] = 0xe91f, [0x8b79] = 0xe920, [0x8b7a] = 0xe921, [0x8b7b] = 0xe922,
  [0x8b7c] = 0xe923, [0x8b7d] = 0xe924, [0x8b7e] = 0xe925, [0x8b7f] = 0xe926,
  [0x8b80] = 0xe927, [0x8b81] = 0xe928, [0x8b82] = 0xe929, [0x8b83] = 0xe92a,
  [0x8b84] = 0xe92b, [0x8b85] = 0xe92c, [0x8b86] = 0xe92d, [0x8b87] = 0xe92e,
  [0x8b88] = 0xe92f, [0x8b89] = 0xe930, [0x8b8a] = 0xe931, [0x8b8b] = 0xe932,
  [0x8b8c] = 0xe933, [0x8b8d] = 0xe934, [0x8b8e] = 0xe935, [0x8b8f] = 0xe936,
  [0x8b90] = 0xe937, [0x8b91] = 0xe938, [0x8b92] = 0xe939, [0x8b93] = 0xe93a,
  [0x8b94] = 0xe93b, [0x8b95] = 0xe93c, [0x8b96] = 0xe93d, [0x8b97] = 0xe93e,
  [0x8b98] = 0xe93f, [0x8b99] = 0xe940, [0x8b9a] = 0xe941, [0x8b9b] = 0xe942,
  [0x8b9c] = 0xe943, [0x8b9d] = 0xe944, [0x8b9e] = 0xe945, [0x8b9f] = 0xe946,
  [0x8ba0] = 0xe947, [0x8ba1] = 0xe948, [0x8ba2] = 0xe949, [0x8ba3] = 0xe94a,
  [0x8ba4] = 0xe94b, [0x8ba5] = 0xe94c, [0x8ba6] = 0xe94d, [0x8ba7] = 0xe94e,
  [0x8ba8] = 0xe94f, [0x8ba9] = 0xe950, [0x8baa] = 0xe951, [0x8bab] = 0xe952,
  [0x8bac] = 0xe953, [0x8bad] = 0xe954, [0x8bae] = 0xe955, [0x8baf] = 0xe956,
  [0x8bb0] = 0xe957, [0x8bb1] = 0xe958, [0x8bb2] = 0xe959, [0x8bb3] = 0xe95a,
  [0x8bb4] = 0xe95b, [0x8bb5] = 0xe95c, [0x8bb6] = 0xe95d, [0x8bb7] = 0xe95e,
  [0x8bb8] = 0xe95f, [0x8bb9] = 0xe960, [0x8bba] = 0xe961, [0x8bbb] = 0xe962,
  [0x8bbc] = 0xe963, [0x8bbd] = 0xe964, [0x8bbe] = 0xe965, [0x8bbf] = 0xe966,
  [0x8bc0] = 0xe967, [0x8bc1] = 0xe968, [0x8bc2] = 0xe969, [0x8bc3] = 0xe96a,
  [0x8bc4] = 0xe96b, [0x8bc5] = 0xe96c, [0x8bc6] = 0xe96d, [0x8bc7] = 0xe96e,
  [0x8bc8] = 0xe96f, [0x8bc9] = 0xe970, [0x8bca] = 0xe971, [0x8bcb] = 0xe972,
  [0x8bcc] = 0xe973, [0x8bcd] = 0xe974, [0x8bce] = 0xe975, [0x8bcf] = 0xe976,
  [0x8bd0] = 0xe977, [0x8bd1] = 0xe978, [0x8bd2] = 0xe979, [0x8bd3] = 0xe97a,
  [0x8bd4] = 0xe97b, [0x8bd5] = 0xe97c, [0x8bd6] = 0xe97d, [0x8bd7] = 0xe97e,
  [0x8bd8] = 0xe97f, [0x8bd9] = 0xe980, [0x8bda] = 0xe981, [0x8bdb] = 0xe982,
  [0x8bdc] = 0xe983, [0x8bdd] = 0xe984, [0x8bde] = 0xe985, [0x8bdf] = 0xe986,
  [0x8be0] = 0xe987, [0x8be1] = 0xe988, [0x8be2] = 0xe989, [0x8be3] = 0xe98a,
  [0x8be4] = 0xe98b, [0x8be5] = 0xe98c, [0x8be6] = 0xe98d, [0x8be7] = 0xe98e,
  [0x8be8] = 0xe98f, [0x8be9] = 0xe990, [0x8bea] = 0xe991, [0x8beb] = 0xe992,
  [0x8bec] = 0xe993, [0x8bed] = 0xe994, [0x8bee] = 0xe995, [0x8bef] = 0xe996,
  [0x8bf0] = 0xe997, [0x8bf1] = 0xe998, [0x8bf2] = 0xe999, [0x8bf3] = 0xe99a,
  [0x8bf4] = 0xe99b, [0x8bf5] = 0xe99c, [0x8bf6] = 0xe99d, [0x8bf7] = 0xe99e,
  [0x8bf8] = 0xe99f, [0x8bf9] = 0xe9a0, [0x8bfa] = 0xe9a1, [0x8bfb] = 0xe9a2,
  [0x8bfc] = 0xe9a3, [0x8bfd] = 0xe9a4, [0x8bfe] = 0xe9a5, [0x8bff] = 0xe9a6,
  [0x8c00] = 0xe9a7, [0x8c01] = 0xe9a8, [0x8c02] = 0xe9a9, [0x8c03] = 0xe9aa,
  [0x8c04] = 0xe9ab, [0x8c05] = 0xe9ac, [0x8c06] = 0xe9ad, [0x8c07] = 0xe9ae,
  [0x8c08] = 0xe9af, [0x8c09] = 0xe9b0, [0x8c0a] = 0xe9b1, [0x8c0b] = 0xe9b2,
  [0x8c0c] = 0xe9b3, [0x8c0d] = 0xe9b4, [0x8c0e] = 0xe9b5, [0x8c0f] = 0xe9b6,
  [0x8c10] = 0xe9b7, [0x8c11] = 0xe9b8, [0x8c12] = 0xe9b9, [0x8c13] = 0xe9ba,
  [0x8c14] = 0xe9bb, [0x8c15] = 0xe9bc, [0x8c16] = 0xe9bd, [0x8c17] = 0xe9be,
  [0x8c18] = 0xe9bf, [0x8c19] = 0xe9c0, [0x8c1a] = 0xe9c1, [0x8c1b] = 0xe9c2,
  [0x8c1c] = 0xe9c3, [0x8c1d] = 0xe9c4, [0x8c1e] = 0xe9c5, [0x8c1f] = 0xe9c6,
  [0x8c20] = 0xe9c7, [0x8c21] = 0xe9c8, [0x8c22] = 0xe9c9, [0x8c23] = 0xe9ca,
  [0x8c24] = 0xe9cb, [0x8c25] = 0xe9cc, [0x8c26] = 0xe9cd, [0x8c27] = 0xe9ce,
  [0x8c28] = 0xe9cf, [0x8c29] = 0xe9d0, [0x8c2a] = 0xe9d1, [0x8c2b] = 0xe9d2,
  [0x8c2c] = 0xe9d3, [0x8c2d] = 0xe9d4, [0x8c2e] = 0xe9d5, [0x8c2f] = 0xe9d6,
  [0x8c30] = 0xe9d7, [0x8c31] = 0xe9d8, [0x8c32] = 0xe9d9, [0x8c33] = 0xe9da,
  [0x8c34] = 0xe9db, [0x8c35] = 0xe9dc, [0x8c36] = 0xe9dd, [0x8c37] = 0xe9de,
  [0x8c38] = 0xe9df, [0x8c39] = 0xe9e0, [0x8c3a] = 0xe9e1, [0x8c3b] = 0xe9e2,
  [0x8c3c] = 0xe9e3, [0x8c3d] = 0xe9e4, [0x8c3e] = 0xe9e5, [0x8c3f] = 0xe9e6,
  [0x8c40] = 0xe9e7, [0x8c41] = 0xe9e8, [0x8c42] = 0xe9e9, [0x8c43] = 0xe9ea,
  [0x8c44] = 0xe9eb, [0x8c45] = 0xe9ec, [0x8c46] = 0xe9ed, [0x8c47] = 0xe9ee,
  [0x8c48] = 0xe9ef, [0x8c49] = 0xe9f0, [0x8c4a] = 0xe9f1, [0x8c4b] = 0xe9f2,
  [0x8c4c] = 0xe9f3, [0x8c4d] = 0xe9f4, [0x8c4e] = 0xe9f5, [0x8c4f] = 0xe9f6,
  [0x8c50] = 0xe9f7, [0x8c51] = 0xe9f8, [0x8c52] = 0xe9f9, [0x8c53] = 0xe9fa,
  [0x8c54] = 0xe9fb, [0x8c55] = 0xe9fc, [0x8c56] = 0xe9fd, [0x8c57] = 0xe9fe,
  [0x8c58] = 0xe9ff, [0x8c59] = 0xea00, [0x8c5a] = 0xea01, [0x8c5b] = 0xea02,
  [0x8c5c] = 0xea03, [0x8c5d] = 0xea04, [0x8c5e] = 0xea05, [0x8c5f] = 0xea06,
  [0x8c60] = 0xea07, [0x8c61] = 0xea08, [0x8c62] = 0xea09, [0x8c63] = 0xea0a,
  [0x8c64] = 0xea0b, [0x8c65] = 0xea0c, [0x8c66] = 0xea0d, [0x8c67] = 0xea0e,
  [0x8c68] = 0xea0f, [0x8c69] = 0xea10, [0x8c6a] = 0xea11, [0x8c6b] = 0xea12,
  [0x8c6c] = 0xea13, [0x8c6d] = 0xea14, [0x8c6e] = 0xea15, [0x8c6f] = 0xea16,
  [0x8c70] = 0xea17, [0x8c71] = 0xea18, [0x8c72] = 0xea19, [0x8c73] = 0xea1a,
  [0x8c74] = 0xea1b, [0x8c75] = 0xea1c, [0x8c76] = 0xea1d, [0x8c77] = 0xea1e,
  [0x8c78] = 0xea1f, [0x8c79] = 0xea20, [0x8c7a] = 0xea21, [0x8c7b] = 0xea22,
  [0x8c7c] = 0xea23, [0x8c7d] = 0xea24, [0x8c7e] = 0xea25, [0x8c7f] = 0xea26,
  [0x8c80] = 0xea27, [0x8c81] = 0xea28, [0x8c82] = 0xea29, [0x8c83] = 0xea2a,
  [0x8c84] = 0xea2b, [0x8c85] = 0xea2c, [0x8c86] = 0xea2d, [0x8c87] = 0xea2e,
  [0x8c88] = 0xea2f, [0x8c89] = 0xea30, [0x8c8a] = 0xea31, [0x8c8b] = 0xea32,
  [0x8c8c] = 0xea33, [0x8c8d] = 0xea34, [0x8c8e] = 0xea35, [0x8c8f] = 0xea36,
  [0x8c90] = 0xea37, [0x8c91] = 0xea38, [0x8c92] = 0xea39, [0x8c93] = 0xea3a,
  [0x8c94] = 0xea3b, [0x8c95] = 0xea3c, [0x8c96] = 0xea3d, [0x8c97] = 0xea3e,
  [0x8c98] = 0xea3f, [0x8c99] = 0xea40, [0x8c9a] = 0xea41, [0x8c9b] = 0xea42,
  [0x8c9c] = 0xea43, [0x8c9d] = 0xea44, [0x8c9e] = 0xea45, [0x8c9f] = 0xea46,
  [0x8ca0] = 0xea47, [0x8ca1] = 0xea48, [0x8ca2] = 0xea49, [0x8ca3] = 0xea4a,
  [0x8ca4] = 0xea4b, [0x8ca5] = 0xea4c, [0x8ca6] = 0xea4d, [0x8ca7] = 0xea4e,
  [0x8ca8] = 0xea4f, [0x8ca9] = 0xea50, [0x8caa] = 0xea51, [0x8cab] = 0xea52,
  [0x8cac] = 0xea53, [0x8cad] = 0xea54, [0x8cae] = 0xea55, [0x8caf] = 0xea56,
  [0x8cb0] = 0xea57, [0x8cb1] = 0xea58, [0x8cb2] = 0xea59, [0x8cb3] = 0xea5a,
  [0x8cb4] = 0xea5b, [0x8cb5] = 0xea5c, [0x8cb6] = 0xea5d, [0x8cb7] = 0xea5e,
  [0x8cb8] = 0xea5f, [0x8cb9] = 0xea60, [0x8cba] = 0xea61, [0x8cbb] = 0xea62,
  [0x8cbc] = 0xea63, [0x8cbd] = 0xea64, [0x8cbe] = 0xea65, [0x8cbf] = 0xea66,
  [0x8cc0] = 0xea67, [0x8cc1] = 0xea68, [0x8cc2] = 0xea69, [0x8cc3] = 0xea6a,
  [0x8cc4] = 0xea6b, [0x8cc5] = 0xea6c, [0x8cc6] = 0xea6d, [0x8cc7] = 0xea6e,
  [0x8cc8] = 0xea6f, [0x8cc9] = 0xea70, [0x8cca] = 0xea71, [0x8ccb] = 0xea72,
  [0x8ccc] = 0xea73, [0x8ccd] = 0xea74, [0x8cce] = 0xea75, [0x8ccf] = 0xea76,
  [0x8cd0] = 0xea77, [0x8cd1] = 0xea78, [0x8cd2] = 0xea79, [0x8cd3] = 0xea7a,
  [0x8cd4] = 0xea7b, [0x8cd5] = 0xea7c, [0x8cd6] = 0xea7d, [0x8cd7] = 0xea7e,
  [0x8cd8] = 0xea7f, [0x8cd9] = 0xea80, [0x8cda] = 0xea81, [0x8cdb] = 0xea82,
  [0x8cdc] = 0xea83, [0x8cdd] = 0xea84, [0x8cde] = 0xea85, [0x8cdf] = 0xea86,
  [0x8ce0] = 0xea87, [0x8ce1] = 0xea88, [0x8ce2] = 0xea89, [0x8ce3] = 0xea8a,
  [0x8ce4] = 0xea8b, [0x8ce5] = 0xea8c, [0x8ce6] = 0xea8d, [0x8ce7] = 0xea8e,
  [0x8ce8] = 0xea8f, [0x8ce9] = 0xea90, [0x8cea] = 0xea91, [0x8ceb] = 0xea92,
  [0x8cec] = 0xea93, [0x8ced] = 0xea94, [0x8cee] = 0xea95, [0x8cef] = 0xea96,
  [0x8cf0] = 0xea97, [0x8cf1] = 0xea98, [0x8cf2] = 0xea99, [0x8cf3] = 0xea9a,
  [0x8cf4] = 0xea9b, [0x8cf5] = 0xea9c, [0x8cf6] = 0xea9d, [0x8cf7] = 0xea9e,
  [0x8cf8] = 0xea9f, [0x8cf9] = 0xeaa0, [0x8cfa] = 0xeaa1, [0x8cfb] = 0xeaa2,
  [0x8cfc] = 0xeaa3, [0x8cfd] = 0xeaa4, [0x8cfe] = 0xeaa5, [0x8cff] = 0xeaa6,
  [0x8d00] = 0xeaa7, [0x8d01] = 0xeaa8, [0x8d02] = 0xeaa9, [0x8d03] = 0xeaaa,
  [0x8d04] = 0xeaab, [0x8d05] = 0xeaac, [0x8d06] = 0xeaad, [0x8d07] = 0xeaae,
  [0x8d08] = 0xeaaf, [0x8d09] = 0xeab0, [0x8d0a] = 0xeab1, [0x8d0b] = 0xeab2,
  [0x8d0c] = 0xeab3, [0x8d0d] = 0xeab4, [0x8d0e] = 0xeab5, [0x8d0f] = 0xeab6,
  [0x8d10] = 0xeab7, [0x8d11] = 0xeab8, [0x8d12] = 0xeab9, [0x8d13] = 0xeaba,
  [0x8d14] = 0xeabb, [0x8d15] = 0xeabc, [0x8d16] = 0xeabd, [0x8d17] = 0xeabe,
  [0x8d18] = 0xeabf, [0x8d19] = 0xeac0, [0x8d1a] = 0xeac1, [0x8d1b] = 0xeac2,
  [0x8d1c] = 0xeac3, [0x8d1d] = 0xeac4, [0x8d1e] = 0xeac5, [0x8d1f] = 0xeac6,
  [0x8d20] = 0xeac7, [0x8d21] = 0xeac8, [0x8d22] = 0xeac9, [0x8d23] = 0xeaca,
  [0x8d24] = 0xeacb, [0x8d25] = 0xeacc, [0x8d26] = 0xeacd, [0x8d27] = 0xeace,
  [0x8d28] = 0xeacf, [0x8d29] = 0xead0, [0x8d2a] = 0xead1, [0x8d2b] = 0xead2,
  [0x8d2c] = 0xead3, [0x8d2d] = 0xead4, [0x8d2e] = 0xead5, [0x8d2f] = 0xead6,
  [0x8d30] = 0xead7, [0x8d31] = 0xead8, [0x8d32] = 0xead9, [0x8d33] = 0xeada,
  [0x8d34] = 0xeadb, [0x8d35] = 0xeadc, [0x8d36] = 0xeadd, [0x8d37] = 0xeade,
  [0x8d38] = 0xeadf, [0x8d39] = 0xeae0, [0x8d3a] = 0xeae1, [0x8d3b] = 0xeae2,
  [0x8d3c] = 0xeae3, [0x8d3d] = 0xeae4, [0x8d3e] = 0xeae5, [0x8d3f] = 0xeae6,
  [0x8d40] = 0xeae7, [0x8d41] = 0xeae8, [0x8d42] = 0xeae9, [0x8d43] = 0xeaea,
  [0x8d44] = 0xeaeb, [0x8d45] = 0xeaec, [0x8d46] = 0xeaed, [0x8d47] = 0xeaee,
  [0x8d48] = 0xeaef, [0x8d49] = 0xeaf0, [0x8d4a] = 0xeaf1, [0x8d4b] = 0xeaf2,
  [0x8d4c] = 0xeaf3, [0x8d4d] = 0xeaf4, [0x8d4e] = 0xeaf5, [0x8d4f] = 0xeaf6,
  [0x8d50] = 0xeaf7, [0x8d51] = 0xeaf8, [0x8d52] = 0xeaf9, [0x8d53] = 0xeafa,
  [0x8d54] = 0xeafb, [0x8d55] = 0xeafc, [0x8d56] = 0xeafd, [0x8d57] = 0xeafe,
  [0x8d58] = 0xeaff, [0x8d59] = 0xeb00, [0x8d5a] = 0xeb01, [0x8d5b] = 0xeb02,
  [0x8d5c] = 0xeb03, [0x8d5d] = 0xeb04, [0x8d5e] = 0xeb05, [0x8d5f] = 0xeb06,
  [0x8d60] = 0xeb07, [0x8d61] = 0xeb08, [0x8d62] = 0xeb09, [0x8d63] = 0xeb0a,
  [0x8d64] = 0xeb0b, [0x8d65] = 0xeb0c, [0x8d66] = 0xeb0d, [0x8d67] = 0xeb0e,
  [0x8d68] = 0xeb0f, [0x8d69] = 0xeb10, [0x8d6a] = 0xeb11, [0x8d6b] = 0xeb12,
  [0x8d6c] = 0xeb13, [0x8d6d] = 0xeb14, [0x8d6e] = 0xeb15, [0x8d6f] = 0xeb16,
  [0x8d70] = 0xeb17, [0x8d71] = 0xeb18, [0x8d72] = 0xeb19, [0x8d73] = 0xeb1a,
  [0x8d74] = 0xeb1b, [0x8d75] = 0xeb1c, [0x8d76] = 0xeb1d, [0x8d77] = 0xeb1e,
  [0x8d78] = 0xeb1f, [0x8d79] = 0xeb20, [0x8d7a] = 0xeb21, [0x8d7b] = 0xeb22,
  [0x8d7c] = 0xeb23, [0x8d7d] = 0xeb24, [0x8d7e] = 0xeb25, [0x8d7f] = 0xeb26,
  [0x8d80] = 0xeb27, [0x8d81] = 0xeb28, [0x8d82] = 0xeb29, [0x8d83] = 0xeb2a,
  [0x8d84] = 0xeb2b, [0x8d85] = 0xeb2c, [0x8d86] = 0xeb2d, [0x8d87] = 0xeb2e,
  [0x8d88] = 0xeb2f, [0x8d89] = 0xeb30, [0x8d8a] = 0xeb31, [0x8d8b] = 0xeb32,
  [0x8d8c] = 0xeb33, [0x8d8d] = 0xeb34, [0x8d8e] = 0xeb35, [0x8d8f] = 0xeb36,
  [0x8d90] = 0xeb37, [0x8d91] = 0xeb38, [0x8d92] = 0xeb39, [0x8d93] = 0xeb3a,
  [0x8d94] = 0xeb3b, [0x8d95] = 0xeb3c, [0x8d96] = 0xeb3d, [0x8d97] = 0xeb3e,
  [0x8d98] = 0xeb3f, [0x8d99] = 0xeb40, [0x8d9a] = 0xeb41, [0x8d9b] = 0xeb42,
  [0x8d9c] = 0xeb43, [0x8d9d] = 0xeb44, [0x8d9e] = 0xeb45, [0x8d9f] = 0xeb46,
  [0x8da0] = 0xeb47, [0x8da1] = 0xeb48, [0x8da2] = 0xeb49, [0x8da3] = 0xeb4a,
  [0x8da4] = 0xeb4b, [0x8da5] = 0xeb4c, [0x8da6] = 0xeb4d, [0x8da7] = 0xeb4e,
  [0x8da8] = 0xeb4f, [0x8da9] = 0xeb50, [0x8daa] = 0xeb51, [0x8dab] = 0xeb52,
  [0x8dac] = 0xeb53, [0x8dad] = 0xeb54, [0x8dae] = 0xeb55, [0x8daf] = 0xeb56,
  [0x8db0] = 0xeb57, [0x8db1] = 0xeb58, [0x8db2] = 0xeb59, [0x8db3] = 0xeb5a,
  [0x8db4] = 0xeb5b, [0x8db5] = 0xeb5c, [0x8db6] = 0xeb5d, [0x8db7] = 0xeb5e,
  [0x8db8] = 0xeb5f, [0x8db9] = 0xeb60, [0x8dba] = 0xeb61, [0x8dbb] = 0xeb62,
  [0x8dbc] = 0xeb63, [0x8dbd] = 0xeb64, [0x8dbe] = 0xeb65, [0x8dbf] = 0xeb66,
  [0x8dc0] = 0xeb67, [0x8dc1] = 0xeb68, [0x8dc2] = 0xeb69, [0x8dc3] = 0xeb6a,
  [0x8dc4] = 0xeb6b, [0x8dc5] = 0xeb6c, [0x8dc6] = 0xeb6d, [0x8dc7] = 0xeb6e,
  [0x8dc8] = 0xeb6f, [0x8dc9] = 0xeb70, [0x8dca] = 0xeb71, [0x8dcb] = 0xeb72,
  [0x8dcc] = 0xeb73, [0x8dcd] = 0xeb74, [0x8dce] = 0xeb75, [0x8dcf] = 0xeb76,
  [0x8dd0] = 0xeb77, [0x8dd1] = 0xeb78, [0x8dd2] = 0xeb79, [0x8dd3] = 0xeb7a,
  [0x8dd4] = 0xeb7b, [0x8dd5] = 0xeb7c, [0x8dd6] = 0xeb7d, [0x8dd7] = 0xeb7e,
  [0x8dd8] = 0xeb7f, [0x8dd9] = 0xeb80, [0x8dda] = 0xeb81, [0x8ddb] = 0xeb82,
  [0x8ddc] = 0xeb83, [0x8ddd] = 0xeb84, [0x8dde] = 0xeb85, [0x8ddf] = 0xeb86,
  [0x8de0] = 0xeb87, [0x8de1] = 0xeb88, [0x8de2] = 0xeb89, [0x8de3] = 0xeb8a,
  [0x8de4] = 0xeb8b, [0x8de5] = 0xeb8c, [0x8de6] = 0xeb8d, [0x8de7] = 0xeb8e,
  [0x8de8] = 0xeb8f, [0x8de9] = 0xeb90, [0x8dea] = 0xeb91, [0x8deb] = 0xeb92,
  [0x8dec] = 0xeb93, [0x8ded] = 0xeb94, [0x8dee] = 0xeb95, [0x8def] = 0xeb96,
  [0x8df0] = 0xeb97, [0x8df1] = 0xeb98, [0x8df2] = 0xeb99, [0x8df3] = 0xeb9a,
  [0x8df4] = 0xeb9b, [0x8df5] = 0xeb9c, [0x8df6] = 0xeb9d, [0x8df7] = 0xeb9e,
  [0x8df8] = 0xeb9f, [0x8df9] = 0xeba0, [0x8dfa] = 0xeba1, [0x8dfb] = 0xeba2,
  [0x8dfc] = 0xeba3, [0x8dfd] = 0xeba4, [0x8dfe] = 0xeba5, [0x8dff] = 0xeba6,
  [0x8e00] = 0xeba7, [0x8e01] = 0xeba8, [0x8e02] = 0xeba9, [0x8e03] = 0xebaa,
  [0x8e04] = 0xebab, [0x8e05] = 0xebac, [0x8e06] = 0xebad, [0x8e07] = 0xebae,
  [0x8e08] = 0xebaf, [0x8e09] = 0xebb0, [0x8e0a] = 0xebb1, [0x8e0b] = 0xebb2,
  [0x8e0c] = 0xebb3, [0x8e0d] = 0xebb4, [0x8e0e] = 0xebb5, [0x8e0f] = 0xebb6,
  [0x8e10] = 0xebb7, [0x8e11] = 0xebb8, [0x8e12] = 0xebb9, [0x8e13] = 0xebba,
  [0x8e14] = 0xebbb, [0x8e15] = 0xebbc, [0x8e16] = 0xebbd, [0x8e17] = 0xebbe,
  [0x8e18] = 0xebbf, [0x8e19] = 0xebc0, [0x8e1a] = 0xebc1, [0x8e1b] = 0xebc2,
  [0x8e1c] = 0xebc3, [0x8e1d] = 0xebc4, [0x8e1e] = 0xebc5, [0x8e1f] = 0xebc6,
  [0x8e20] = 0xebc7, [0x8e21] = 0xebc8, [0x8e22] = 0xebc9, [0x8e23] = 0xebca,
  [0x8e24] = 0xebcb, [0x8e25] = 0xebcc, [0x8e26] = 0xebcd, [0x8e27] = 0xebce,
  [0x8e28] = 0xebcf, [0x8e29] = 0xebd0, [0x8e2a] = 0xebd1, [0x8e2b] = 0xebd2,
  [0x8e2c] = 0xebd3, [0x8e2d] = 0xebd4, [0x8e2e] = 0xebd5, [0x8e2f] = 0xebd6,
  [0x8e30] = 0xebd7, [0x8e31] = 0xebd8, [0x8e32] = 0xebd9, [0x8e33] = 0xebda,
  [0x8e34] = 0xebdb, [0x8e35] = 0xebdc, [0x8e36] = 0xebdd, [0x8e37] = 0xebde,
  [0x8e38] = 0xebdf, [0x8e39] = 0xebe0, [0x8e3a] = 0xebe1, [0x8e3b] = 0xebe2,
  [0x8e3c] = 0xebe3, [0x8e3d] = 0xebe4, [0x8e3e] = 0xebe5, [0x8e3f] = 0xebe6,
  [0x8e40] = 0xebe7, [0x8e41] = 0xebe8, [0x8e42] = 0xebe9, [0x8e43] = 0xebea,
  [0x8e44] = 0xebeb, [0x8e45] = 0xebec, [0x8e46] = 0xebed, [0x8e47] = 0xebee,
  [0x8e48] = 0xebef, [0x8e49] = 0xebf0, [0x8e4a] = 0xebf1, [0x8e4b] = 0xebf2,
  [0x8e4c] = 0xebf3, [0x8e4d] = 0xebf4, [0x8e4e] = 0xebf5, [0x8e4f] = 0xebf6,
  [0x8e50] = 0xebf7, [0x8e51] = 0xebf8, [0x8e52] = 0xebf9, [0x8e53] = 0xebfa,
  [0x8e54] = 0xebfb, [0x8e55] = 0xebfc, [0x8e56] = 0xebfd, [0x8e57] = 0xebfe,
  [0x8e58] = 0xebff, [0x8e59] = 0xec00, [0x8e5a] = 0xec01, [0x8e5b] = 0xec02,
  [0x8e5c] = 0xec03, [0x8e5d] = 0xec04, [0x8e5e] = 0xec05, [0x8e5f] = 0xec06,
  [0x8e60] = 0xec07, [0x8e61] = 0xec08, [0x8e62] = 0xec09, [0x8e63] = 0xec0a,
  [0x8e64] = 0xec0b, [0x8e65] = 0xec0c, [0x8e66] = 0xec0d, [0x8e67] = 0xec0e,
  [0x8e68] = 0xec0f, [0x8e69] = 0xec10, [0x8e6a] = 0xec11, [0x8e6b] = 0xec12,
  [0x8e6c] = 0xec13, [0x8e6d] = 0xec14, [0x8e6e] = 0xec15, [0x8e6f] = 0xec16,
  [0x8e70] = 0xec17, [0x8e71] = 0xec18, [0x8e72] = 0xec19, [0x8e73] = 0xec1a,
  [0x8e74] = 0xec1b, [0x8e75] = 0xec1c, [0x8e76] = 0xec1d, [0x8e77] = 0xec1e,
  [0x8e78] = 0xec1f, [0x8e79] = 0xec20, [0x8e7a] = 0xec21, [0x8e7b] = 0xec22,
  [0x8e7c] = 0xec23, [0x8e7d] = 0xec24, [0x8e7e] = 0xec25, [0x8e7f] = 0xec26,
  [0x8e80] = 0xec27, [0x8e81] = 0xec28, [0x8e82] = 0xec29, [0x8e83] = 0xec2a,
  [0x8e84] = 0xec2b, [0x8e85] = 0xec2c, [0x8e86] = 0xec2d, [0x8e87] = 0xec2e,
  [0x8e88] = 0xec2f, [0x8e89] = 0xec30, [0x8e8a] = 0xec31, [0x8e8b] = 0xec32,
  [0x8e8c] = 0xec33, [0x8e8d] = 0xec34, [0x8e8e] = 0xec35, [0x8e8f] = 0xec36,
  [0x8e90] = 0xec37, [0x8e91] = 0xec38, [0x8e92] = 0xec39, [0x8e93] = 0xec3a,
  [0x8e94] = 0xec3b, [0x8e95] = 0xec3c, [0x8e96] = 0xec3d, [0x8e97] = 0xec3e,
  [0x8e98] = 0xec3f, [0x8e99] = 0xec40, [0x8e9a] = 0xec41, [0x8e9b] = 0xec42,
  [0x8e9c] = 0xec43, [0x8e9d] = 0xec44, [0x8e9e] = 0xec45, [0x8e9f] = 0xec46,
  [0x8ea0] = 0xec47, [0x8ea1] = 0xec48, [0x8ea2] = 0xec49, [0x8ea3] = 0xec4a,
  [0x8ea4] = 0xec4b, [0x8ea5] = 0xec4c, [0x8ea6] = 0xec4d, [0x8ea7] = 0xec4e,
  [0x8ea8] = 0xec4f, [0x8ea9] = 0xec50, [0x8eaa] = 0xec51, [0x8eab] = 0xec52,
  [0x8eac] = 0xec53, [0x8ead] = 0xec54, [0x8eae] = 0xec55, [0x8eaf] = 0xec56,
  [0x8eb0] = 0xec57, [0x8eb1] = 0xec58, [0x8eb2] = 0xec59, [0x8eb3] = 0xec5a,
  [0x8eb4] = 0xec5b, [0x8eb5] = 0xec5c, [0x8eb6] = 0xec5d, [0x8eb7] = 0xec5e,
  [0x8eb8] = 0xec5f, [0x8eb9] = 0xec60, [0x8eba] = 0xec61, [0x8ebb] = 0xec62,
  [0x8ebc] = 0xec63, [0x8ebd] = 0xec64, [0x8ebe] = 0xec65, [0x8ebf] = 0xec66,
  [0x8ec0] = 0xec67, [0x8ec1] = 0xec68, [0x8ec2] = 0xec69, [0x8ec3] = 0xec6a,
  [0x8ec4] = 0xec6b, [0x8ec5] = 0xec6c, [0x8ec6] = 0xec6d, [0x8ec7] = 0xec6e,
  [0x8ec8] = 0xec6f, [0x8ec9] = 0xec70, [0x8eca] = 0xec71, [0x8ecb] = 0xec72,
  [0x8ecc] = 0xec73, [0x8ecd] = 0xec74, [0x8ece] = 0xec75, [0x8ecf] = 0xec76,
  [0x8ed0] = 0xec77, [0x8ed1] = 0xec78, [0x8ed2] = 0xec79, [0x8ed3] = 0xec7a,
  [0x8ed4] = 0xec7b, [0x8ed5] = 0xec7c, [0x8ed6] = 0xec7d, [0x8ed7] = 0xec7e,
  [0x8ed8] = 0xec7f, [0x8ed9] = 0xec80, [0x8eda] = 0xec81, [0x8edb] = 0xec82,
  [0x8edc] = 0xec83, [0x8edd] = 0xec84, [0x8ede] = 0xec85, [0x8edf] = 0xec86,
  [0x8ee0] = 0xec87, [0x8ee1] = 0xec88, [0x8ee2] = 0xec89, [0x8ee3] = 0xec8a,
  [0x8ee4] = 0xec8b, [0x8ee5] = 0xec8c, [0x8ee6] = 0xec8d, [0x8ee7] = 0xec8e,
  [0x8ee8] = 0xec8f, [0x8ee9] = 0xec90, [0x8eea] = 0xec91, [0x8eeb] = 0xec92,
  [0x8eec] = 0xec93, [0x8eed] = 0xec94, [0x8eee] = 0xec95, [0x8eef] = 0xec96,
  [0x8ef0] = 0xec97, [0x8ef1] = 0xec98, [0x8ef2] = 0xec99, [0x8ef3] = 0xec9a,
  [0x8ef4] = 0xec9b, [0x8ef5] = 0xec9c, [0x8ef6] = 0xec9d, [0x8ef7] = 0xec9e,
  [0x8ef8] = 0xec9f, [0x8ef9] = 0xeca0, [0x8efa] = 0xeca1, [0x8efb] = 0xeca2,
  [0x8efc] = 0xeca3, [0x8efd] = 0xeca4, [0x8efe] = 0xeca5, [0x8eff] = 0xeca6,
  [0x8f00] = 0xeca7, [0x8f01] = 0xeca8, [0x8f02] = 0xeca9, [0x8f03] = 0xecaa,
  [0x8f04] = 0xecab, [0x8f05] = 0xecac, [0x8f06] = 0xecad, [0x8f07] = 0xecae,
  [0x8f08] = 0xecaf, [0x8f09] = 0xecb0, [0x8f0a] = 0xecb1, [0x8f0b] = 0xecb2,
  [0x8f0c] = 0xecb3, [0x8f0d] = 0xecb4, [0x8f0e] = 0xecb5, [0x8f0f] = 0xecb6,
  [0x8f10] = 0xecb7, [0x8f11] = 0xecb8, [0x8f12] = 0xecb9, [0x8f13] = 0xecba,
  [0x8f14] = 0xecbb, [0x8f15] = 0xecbc, [0x8f16] = 0xecbd, [0x8f17] = 0xecbe,
  [0x8f18] = 0xecbf, [0x8f19] = 0xecc0, [0x8f1a] = 0xecc1, [0x8f1b] = 0xecc2,
  [0x8f1c] = 0xecc3, [0x8f1d] = 0xecc4, [0x8f1e] = 0xecc5, [0x8f1f] = 0xecc6,
  [0x8f20] = 0xecc7, [0x8f21] = 0xecc8, [0x8f22] = 0xecc9, [0x8f23] = 0xecca,
  [0x8f24] = 0xeccb, [0x8f25] = 0xeccc, [0x8f26] = 0xeccd, [0x8f27] = 0xecce,
  [0x8f28] = 0xeccf, [0x8f29] = 0xecd0, [0x8f2a] = 0xecd1, [0x8f2b] = 0xecd2,
  [0x8f2c] = 0xecd3, [0x8f2d] = 0xecd4, [0x8f2e] = 0xecd5, [0x8f2f] = 0xecd6,
  [0x8f30] = 0xecd7, [0x8f31] = 0xecd8, [0x8f32] = 0xecd9, [0x8f33] = 0xecda,
  [0x8f34] = 0xecdb, [0x8f35] = 0xecdc, [0x8f36] = 0xecdd, [0x8f37] = 0xecde,
  [0x8f38] = 0xecdf, [0x8f39] = 0xece0, [0x8f3a] = 0xece1, [0x8f3b] = 0xece2,
  [0x8f3c] = 0xece3, [0x8f3d] = 0xece4, [0x8f3e] = 0xece5, [0x8f3f] = 0xece6,
  [0x8f40] = 0xece7, [0x8f41] = 0xece8, [0x8f42] = 0xece9, [0x8f43] = 0xecea,
  [0x8f44] = 0xeceb, [0x8f45] = 0xecec, [0x8f46] = 0xeced, [0x8f47] = 0xecee,
  [0x8f48] = 0xecef, [0x8f49] = 0xecf0, [0x8f4a] = 0xecf1, [0x8f4b] = 0xecf2,
  [0x8f4c] = 0xecf3, [0x8f4d] = 0xecf4, [0x8f4e] = 0xecf5, [0x8f4f] = 0xecf6,
  [0x8f50] = 0xecf7, [0x8f51] = 0xecf8, [0x8f52] = 0xecf9, [0x8f53] = 0xecfa,
  [0x8f54] = 0xecfb, [0x8f55] = 0xecfc, [0x8f56] = 0xecfd, [0x8f57] = 0xecfe,
  [0x8f58] = 0xecff, [0x8f59] = 0xed00, [0x8f5a] = 0xed01, [0x8f5b] = 0xed02,
  [0x8f5c] = 0xed03, [0x8f5d] = 0xed04, [0x8f5e] = 0xed05, [0x8f5f] = 0xed06,
  [0x8f60] = 0xed07, [0x8f61] = 0xed08, [0x8f62] = 0xed09, [0x8f63] = 0xed0a,
  [0x8f64] = 0xed0b, [0x8f65] = 0xed0c, [0x8f66] = 0xed0d, [0x8f67] = 0xed0e,
  [0x8f68] = 0xed0f, [0x8f69] = 0xed10, [0x8f6a] = 0xed11, [0x8f6b] = 0xed12,
  [0x8f6c] = 0xed13, [0x8f6d] = 0xed14, [0x8f6e] = 0xed15, [0x8f6f] = 0xed16,
  [0x8f70] = 0xed17, [0x8f71] = 0xed18, [0x8f72] = 0xed19, [0x8f73] = 0xed1a,
  [0x8f74] = 0xed1b, [0x8f75] = 0xed1c, [0x8f76] = 0xed1d, [0x8f77] = 0xed1e,
  [0x8f78] = 0xed1f, [0x8f79] = 0xed20, [0x8f7a] = 0xed21, [0x8f7b] = 0xed22,
  [0x8f7c] = 0xed23, [0x8f7d] = 0xed24, [0x8f7e] = 0xed25, [0x8f7f] = 0xed26,
  [0x8f80] = 0xed27, [0x8f81] = 0xed28, [0x8f82] = 0xed29, [0x8f83] = 0xed2a,
  [0x8f84] = 0xed2b, [0x8f85] = 0xed2c, [0x8f86] = 0xed2d, [0x8f87] = 0xed2e,
  [0x8f88] = 0xed2f, [0x8f89] = 0xed30, [0x8f8a] = 0xed31, [0x8f8b] = 0xed32,
  [0x8f8c] = 0xed33, [0x8f8d] = 0xed34, [0x8f8e] = 0xed35, [0x8f8f] = 0xed36,
  [0x8f90] = 0xed37, [0x8f91] = 0xed38, [0x8f92] = 0xed39, [0x8f93] = 0xed3a,
  [0x8f94] = 0xed3b, [0x8f95] = 0xed3c, [0x8f96] = 0xed3d, [0x8f97] = 0xed3e,
  [0x8f98] = 0xed3f, [0x8f99] = 0xed40, [0x8f9a] = 0xed41, [0x8f9b] = 0xed42,
  [0x8f9c] = 0xed43, [0x8f9d] = 0xed44, [0x8f9e] = 0xed45, [0x8f9f] = 0xed46,
  [0x8fa0] = 0xed47, [0x8fa1] = 0xed48, [0x8fa2] = 0xed49, [0x8fa3] = 0xed4a,
  [0x8fa4] = 0xed4b, [0x8fa5] = 0xed4c, [0x8fa6] = 0xed4d, [0x8fa7] = 0xed4e,
  [0x8fa8] = 0xed4f, [0x8fa9] = 0xed50, [0x8faa] = 0xed51, [0x8fab] = 0xed52,
  [0x8fac] = 0xed53, [0x8fad] = 0xed54, [0x8fae] = 0xed55, [0x8faf] = 0xed56,
  [0x8fb0] = 0xed57, [0x8fb1] = 0xed58, [0x8fb2] = 0xed59, [0x8fb3] = 0xed5a,
  [0x8fb4] = 0xed5b, [0x8fb5] = 0xed5c, [0x8fb6] = 0xed5d, [0x8fb7] = 0xed5e,
  [0x8fb8] = 0xed5f, [0x8fb9] = 0xed60, [0x8fba] = 0xed61, [0x8fbb] = 0xed62,
  [0x8fbc] = 0xed63, [0x8fbd] = 0xed64, [0x8fbe] = 0xed65, [0x8fbf] = 0xed66,
  [0x8fc0] = 0xed67, [0x8fc1] = 0xed68, [0x8fc2] = 0xed69, [0x8fc3] = 0xed6a,
  [0x8fc4] = 0xed6b, [0x8fc5] = 0xed6c, [0x8fc6] = 0xed6d, [0x8fc7] = 0xed6e,
  [0x8fc8] = 0xed6f, [0x8fc9] = 0xed70, [0x8fca] = 0xed71, [0x8fcb] = 0xed72,
  [0x8fcc] = 0xed73, [0x8fcd] = 0xed74, [0x8fce] = 0xed75, [0x8fcf] = 0xed76,
  [0x8fd0] = 0xed77, [0x8fd1] = 0xed78, [0x8fd2] = 0xed79, [0x8fd3] = 0xed7a,
  [0x8fd4] = 0xed7b, [0x8fd5] = 0xed7c, [0x8fd6] = 0xed7d, [0x8fd7] = 0xed7e,
  [0x8fd8] = 0xed7f, [0x8fd9] = 0xed80, [0x8fda] = 0xed81, [0x8fdb] = 0xed82,
  [0x8fdc] = 0xed83, [0x8fdd] = 0xed84, [0x8fde] = 0xed85, [0x8fdf] = 0xed86,
  [0x8fe0] = 0xed87, [0x8fe1] = 0xed88, [0x8fe2] = 0xed89, [0x8fe3] = 0xed8a,
  [0x8fe4] = 0xed8b, [0x8fe5] = 0xed8c, [0x8fe6] = 0xed8d, [0x8fe7] = 0xed8e,
  [0x8fe8] = 0xed8f, [0x8fe9] = 0xed90, [0x8fea] = 0xed91, [0x8feb] = 0xed92,
  [0x8fec] = 0xed93, [0x8fed] = 0xed94, [0x8fee] = 0xed95, [0x8fef] = 0xed96,
  [0x8ff0] = 0xed97, [0x8ff1] = 0xed98, [0x8ff2] = 0xed99, [0x8ff3] = 0xed9a,
  [0x8ff4] = 0xed9b, [0x8ff5] = 0xed9c, [0x8ff6] = 0xed9d, [0x8ff7] = 0xed9e,
  [0x8ff8] = 0xed9f, [0x8ff9] = 0xeda0, [0x8ffa] = 0xeda1, [0x8ffb] = 0xeda2,
  [0x8ffc] = 0xeda3, [0x8ffd] = 0xeda4, [0x8ffe] = 0xeda5, [0x8fff] = 0xeda6,
  [0x9000] = 0xeda7, [0x9001] = 0xeda8, [0x9002] = 0xeda9, [0x9003] = 0xedaa,
  [0x9004] = 0xedab, [0x9005] = 0xedac, [0x9006] = 0xedad, [0x9007] = 0xedae,
  [0x9008] = 0xedaf, [0x9009] = 0xedb0, [0x900a] = 0xedb1, [0x900b] = 0xedb2,
  [0x900c] = 0xedb3, [0x900d] = 0xedb4, [0x900e] = 0xedb5, [0x900f] = 0xedb6,
  [0x9010] = 0xedb7, [0x9011] = 0xedb8, [0x9012] = 0xedb9, [0x9013] = 0xedba,
  [0x9014] = 0xedbb, [0x9015] = 0xedbc, [0x9016] = 0xedbd, [0x9017] = 0xedbe,
  [0x9018] = 0xedbf, [0x9019] = 0xedc0, [0x901a] = 0xedc1, [0x901b] = 0xedc2,
  [0x901c] = 0xedc3, [0x901d] = 0xedc4, [0x901e] = 0xedc5, [0x901f] = 0xedc6,
  [0x9020] = 0xedc7, [0x9021] = 0xedc8, [0x9022] = 0xedc9, [0x9023] = 0xedca,
  [0x9024] = 0xedcb, [0x9025] = 0xedcc, [0x9026] = 0xedcd, [0x9027] = 0xedce,
  [0x9028] = 0xedcf, [0x9029] = 0xedd0, [0x902a] = 0xedd1, [0x902b] = 0xedd2,
  [0x902c] = 0xedd3, [0x902d] = 0xedd4, [0x902e] = 0xedd5, [0x902f] = 0xedd6,
  [0x9030] = 0xedd7, [0x9031] = 0xedd8, [0x9032] = 0xedd9, [0x9033] = 0xedda,
  [0x9034] = 0xeddb, [0x9035] = 0xeddc, [0x9036] = 0xeddd, [0x9037] = 0xedde,
  [0x9038] = 0xeddf, [0x9039] = 0xede0, [0x903a] = 0xede1, [0x903b] = 0xede2,
  [0x903c] = 0xede3, [0x903d] = 0xede4, [0x903e] = 0xede5, [0x903f] = 0xede6,
  [0x9040] = 0xede7, [0x9041] = 0xede8, [0x9042] = 0xede9, [0x9043] = 0xedea,
  [0x9044] = 0xedeb, [0x9045] = 0xedec, [0x9046] = 0xeded, [0x9047] = 0xedee,
  [0x9048] = 0xedef, [0x9049] = 0xedf0, [0x904a] = 0xedf1, [0x904b] = 0xedf2,
  [0x904c] = 0xedf3, [0x904d] = 0xedf4, [0x904e] = 0xedf5, [0x904f] = 0xedf6,
  [0x9050] = 0xedf7, [0x9051] = 0xedf8, [0x9052] = 0xedf9, [0x9053] = 0xedfa,
  [0x9054] = 0xedfb, [0x9055] = 0xedfc, [0x9056] = 0xedfd, [0x9057] = 0xedfe,
  [0x9058] = 0xedff, [0x9059] = 0xee00, [0x905a] = 0xee01, [0x905b] = 0xee02,
  [0x905c] = 0xee03, [0x905d] = 0xee04, [0x905e] = 0xee05, [0x905f] = 0xee06,
  [0x9060] = 0xee07, [0x9061] = 0xee08, [0x9062] = 0xee09, [0x9063] = 0xee0a,
  [0x9064] = 0xee0b, [0x9065] = 0xee0c, [0x9066] = 0xee0d, [0x9067] = 0xee0e,
  [0x9068] = 0xee0f, [0x9069] = 0xee10, [0x906a] = 0xee11, [0x906b] = 0xee12,
  [0x906c] = 0xee13, [0x906d] = 0xee14, [0x906e] = 0xee15, [0x906f] = 0xee16,
  [0x9070] = 0xee17, [0x9071] = 0xee18, [0x9072] = 0xee19, [0x9073] = 0xee1a,
  [0x9074] = 0xee1b, [0x9075] = 0xee1c, [0x9076] = 0xee1d, [0x9077] = 0xee1e,
  [0x9078] = 0xee1f, [0x9079] = 0xee20, [0x907a] = 0xee21, [0x907b] = 0xee22,
  [0x907c] = 0xee23, [0x907d] = 0xee24, [0x907e] = 0xee25, [0x907f] = 0xee26,
  [0x9080] = 0xee27, [0x9081] = 0xee28, [0x9082] = 0xee29, [0x9083] = 0xee2a,
  [0x9084] = 0xee2b, [0x9085] = 0xee2c, [0x9086] = 0xee2d, [0x9087] = 0xee2e,
  [0x9088] = 0xee2f, [0x9089] = 0xee30, [0x908a] = 0xee31, [0x908b] = 0xee32,
  [0x908c] = 0xee33, [0x908d] = 0xee34, [0x908e] = 0xee35, [0x908f] = 0xee36,
  [0x9090] = 0xee37, [0x9091] = 0xee38, [0x9092] = 0xee39, [0x9093] = 0xee3a,
  [0x9094] = 0xee3b, [0x9095] = 0xee3c, [0x9096] = 0xee3d, [0x9097] = 0xee3e,
  [0x9098] = 0xee3f, [0x9099] = 0xee40, [0x909a] = 0xee41, [0x909b] = 0xee42,
  [0x909c] = 0xee43, [0x909d] = 0xee44, [0x909e] = 0xee45, [0x909f] = 0xee46,
  [0x90a0] = 0xee47, [0x90a1] = 0xee48, [0x90a2] = 0xee49, [0x90a3] = 0xee4a,
  [0x90a4] = 0xee4b, [0x90a5] = 0xee4c, [0x90a6] = 0xee4d, [0x90a7] = 0xee4e,
  [0x90a8] = 0xee4f, [0x90a9] = 0xee50, [0x90aa] = 0xee51, [0x90ab] = 0xee52,
  [0x90ac] = 0xee53, [0x90ad] = 0xee54, [0x90ae] = 0xee55, [0x90af] = 0xee56,
  [0x90b0] = 0xee57, [0x90b1] = 0xee58, [0x90b2] = 0xee59, [0x90b3] = 0xee5a,
  [0x90b4] = 0xee5b, [0x90b5] = 0xee5c, [0x90b6] = 0xee5d, [0x90b7] = 0xee5e,
  [0x90b8] = 0xee5f, [0x90b9] = 0xee60, [0x90ba] = 0xee61, [0x90bb] = 0xee62,
  [0x90bc] = 0xee63, [0x90bd] = 0xee64, [0x90be] = 0xee65, [0x90bf] = 0xee66,
  [0x90c0] = 0xee67, [0x90c1] = 0xee68, [0x90c2] = 0xee69, [0x90c3] = 0xee6a,
  [0x90c4] = 0xee6b, [0x90c5] = 0xee6c, [0x90c6] = 0xee6d, [0x90c7] = 0xee6e,
  [0x90c8] = 0xee6f, [0x90c9] = 0xee70, [0x90ca] = 0xee71, [0x90cb] = 0xee72,
  [0x90cc] = 0xee73, [0x90cd] = 0xee74, [0x90ce] = 0xee75, [0x90cf] = 0xee76,
  [0x90d0] = 0xee77, [0x90d1] = 0xee78, [0x90d2] = 0xee79, [0x90d3] = 0xee7a,
  [0x90d4] = 0xee7b, [0x90d5] = 0xee7c, [0x90d6] = 0xee7d, [0x90d7] = 0xee7e,
  [0x90d8] = 0xee7f, [0x90d9] = 0xee80, [0x90da] = 0xee81, [0x90db] = 0xee82,
  [0x90dc] = 0xee83, [0x90dd] = 0xee84, [0x90de] = 0xee85, [0x90df] = 0xee86,
  [0x90e0] = 0xee87, [0x90e1] = 0xee88, [0x90e2] = 0xee89, [0x90e3] = 0xee8a,
  [0x90e4] = 0xee8b, [0x90e5] = 0xee8c, [0x90e6] = 0xee8d, [0x90e7] = 0xee8e,
  [0x90e8] = 0xee8f, [0x90e9] = 0xee90, [0x90ea] = 0xee91, [0x90eb] = 0xee92,
  [0x90ec] = 0xee93, [0x90ed] = 0xee94, [0x90ee] = 0xee95, [0x90ef] = 0xee96,
  [0x90f0] = 0xee97, [0x90f1] = 0xee98, [0x90f2] = 0xee99, [0x90f3] = 0xee9a,
  [0x90f4] = 0xee9b, [0x90f5] = 0xee9c, [0x90f6] = 0xee9d, [0x90f7] = 0xee9e,
  [0x90f8] = 0xee9f, [0x90f9] = 0xeea0, [0x90fa] = 0xeea1, [0x90fb] = 0xeea2,
  [0x90fc] = 0xeea3, [0x90fd] = 0xeea4, [0x90fe] = 0xeea5, [0x90ff] = 0xeea6,
  [0x9100] = 0xeea7, [0x9101] = 0xeea8, [0x9102] = 0xeea9, [0x9103] = 0xeeaa,
  [0x9104] = 0xeeab, [0x9105] = 0xeeac, [0x9106] = 0xeead, [0x9107] = 0xeeae,
  [0x9108] = 0xeeaf, [0x9109] = 0xeeb0, [0x910a] = 0xeeb1, [0x910b] = 0xeeb2,
  [0x910c] = 0xeeb3, [0x910d] = 0xeeb4, [0x910e] = 0xeeb5, [0x910f] = 0xeeb6,
  [0x9110] = 0xeeb7, [0x9111] = 0xeeb8, [0x9112] = 0xeeb9, [0x9113] = 0xeeba,
  [0x9114] = 0xeebb, [0x9115] = 0xeebc, [0x9116] = 0xeebd, [0x9117] = 0xeebe,
  [0x9118] = 0xeebf, [0x9119] = 0xeec0, [0x911a] = 0xeec1, [0x911b] = 0xeec2,
  [0x911c] = 0xeec3, [0x911d] = 0xeec4, [0x911e] = 0xeec5, [0x911f] = 0xeec6,
  [0x9120] = 0xeec7, [0x9121] = 0xeec8, [0x9122] = 0xeec9, [0x9123] = 0xeeca,
  [0x9124] = 0xeecb, [0x9125] = 0xeecc, [0x9126] = 0xeecd, [0x9127] = 0xeece,
  [0x9128] = 0xeecf, [0x9129] = 0xeed0, [0x912a] = 0xeed1, [0x912b] = 0xeed2,
  [0x912c] = 0xeed3, [0x912d] = 0xeed4, [0x912e] = 0xeed5, [0x912f] = 0xeed6,
  [0x9130] = 0xeed7, [0x9131] = 0xeed8, [0x9132] = 0xeed9, [0x9133] = 0xeeda,
  [0x9134] = 0xeedb, [0x9135] = 0xeedc, [0x9136] = 0xeedd, [0x9137] = 0xeede,
  [0x9138] = 0xeedf, [0x9139] = 0xeee0, [0x913a] = 0xeee1, [0x913b] = 0xeee2,
  [0x913c] = 0xeee3, [0x913d] = 0xeee4, [0x913e] = 0xeee5, [0x913f] = 0xeee6,
  [0x9140] = 0xeee7, [0x9141] = 0xeee8, [0x9142] = 0xeee9, [0x9143] = 0xeeea,
  [0x9144] = 0xeeeb, [0x9145] = 0xeeec, [0x9146] = 0xeeed, [0x9147] = 0xeeee,
  [0x9148] = 0xeeef, [0x9149] = 0xeef0, [0x914a] = 0xeef1, [0x914b] = 0xeef2,
  [0x914c] = 0xeef3, [0x914d] = 0xeef4, [0x914e] = 0xeef5, [0x914f] = 0xeef6,
  [0x9150] = 0xeef7, [0x9151] = 0xeef8, [0x9152] = 0xeef9, [0x9153] = 0xeefa,
  [0x9154] = 0xeefb, [0x9155] = 0xeefc, [0x9156] = 0xeefd, [0x9157] = 0xeefe,
  [0x9158] = 0xeeff, [0x9159] = 0xef00, [0x915a] = 0xef01, [0x915b] = 0xef02,
  [0x915c] = 0xef03, [0x915d] = 0xef04, [0x915e] = 0xef05, [0x915f] = 0xef06,
  [0x9160] = 0xef07, [0x9161] = 0xef08, [0x9162] = 0xef09, [0x9163] = 0xef0a,
  [0x9164] = 0xef0b, [0x9165] = 0xef0c, [0x9166] = 0xef0d, [0x9167] = 0xef0e,
  [0x9168] = 0xef0f, [0x9169] = 0xef10, [0x916a] = 0xef11, [0x916b] = 0xef12,
  [0x916c] = 0xef13, [0x916d] = 0xef14, [0x916e] = 0xef15, [0x916f] = 0xef16,
  [0x9170] = 0xef17, [0x9171] = 0xef18, [0x9172] = 0xef19, [0x9173] = 0xef1a,
  [0x9174] = 0xef1b, [0x9175] = 0xef1c, [0x9176] = 0xef1d, [0x9177] = 0xef1e,
  [0x9178] = 0xef1f, [0x9179] = 0xef20, [0x917a] = 0xef21, [0x917b] = 0xef22,
  [0x917c] = 0xef23, [0x917d] = 0xef24, [0x917e] = 0xef25, [0x917f] = 0xef26,
  [0x9180] = 0xef27, [0x9181] = 0xef28, [0x9182] = 0xef29, [0x9183] = 0xef2a,
  [0x9184] = 0xef2b, [0x9185] = 0xef2c, [0x9186] = 0xef2d, [0x9187] = 0xef2e,
  [0x9188] = 0xef2f, [0x9189] = 0xef30, [0x918a] = 0xef31, [0x918b] = 0xef32,
  [0x918c] = 0xef33, [0x918d] = 0xef34, [0x918e] = 0xef35, [0x918f] = 0xef36,
  [0x9190] = 0xef37, [0x9191] = 0xef38, [0x9192] = 0xef39, [0x9193] = 0xef3a,
  [0x9194] = 0xef3b, [0x9195] = 0xef3c, [0x9196] = 0xef3d, [0x9197] = 0xef3e,
  [0x9198] = 0xef3f, [0x9199] = 0xef40, [0x919a] = 0xef41, [0x919b] = 0xef42,
  [0x919c] = 0xef43, [0x919d] = 0xef44, [0x919e] = 0xef45, [0x919f] = 0xef46,
  [0x91a0] = 0xef47, [0x91a1] = 0xef48, [0x91a2] = 0xef49, [0x91a3] = 0xef4a,
  [0x91a4] = 0xef4b, [0x91a5] = 0xef4c, [0x91a6] = 0xef4d, [0x91a7] = 0xef4e,
  [0x91a8] = 0xef4f, [0x91a9] = 0xef50, [0x91aa] = 0xef51, [0x91ab] = 0xef52,
  [0x91ac] = 0xef53, [0x91ad] = 0xef54, [0x91ae] = 0xef55, [0x91af] = 0xef56,
  [0x91b0] = 0xef57, [0x91b1] = 0xef58, [0x91b2] = 0xef59, [0x91b3] = 0xef5a,
  [0x91b4] = 0xef5b, [0x91b5] = 0xef5c, [0x91b6] = 0xef5d, [0x91b7] = 0xef5e,
  [0x91b8] = 0xef5f, [0x91b9] = 0xef60, [0x91ba] = 0xef61, [0x91bb] = 0xef62,
  [0x91bc] = 0xef63, [0x91bd] = 0xef64, [0x91be] = 0xef65, [0x91bf] = 0xef66,
  [0x91c0] = 0xef67, [0x91c1] = 0xef68, [0x91c2] = 0xef69, [0x91c3] = 0xef6a,
  [0x91c4] = 0xef6b, [0x91c5] = 0xef6c, [0x91c6] = 0xef6d, [0x91c7] = 0xef6e,
  [0x91c8] = 0xef6f, [0x91c9] = 0xef70, [0x91ca] = 0xef71, [0x91cb] = 0xef72,
  [0x91cc] = 0xef73, [0x91cd] = 0xef74, [0x91ce] = 0xef75, [0x91cf] = 0xef76,
  [0x91d0] = 0xef77, [0x91d1] = 0xef78, [0x91d2] = 0xef79, [0x91d3] = 0xef7a,
  [0x91d4] = 0xef7b, [0x91d5] = 0xef7c, [0x91d6] = 0xef7d, [0x91d7] = 0xef7e,
  [0x91d8] = 0xef7f, [0x91d9] = 0xef80, [0x91da] = 0xef81, [0x91db] = 0xef82,
  [0x91dc] = 0xef83, [0x91dd] = 0xef84, [0x91de] = 0xef85, [0x91df] = 0xef86,
  [0x91e0] = 0xef87, [0x91e1] = 0xef88, [0x91e2] = 0xef89, [0x91e3] = 0xef8a,
  [0x91e4] = 0xef8b, [0x91e5] = 0xef8c, [0x91e6] = 0xef8d, [0x91e7] = 0xef8e,
  [0x91e8] = 0xef8f, [0x91e9] = 0xef90, [0x91ea] = 0xef91, [0x91eb] = 0xef92,
  [0x91ec] = 0xef93, [0x91ed] = 0xef94, [0x91ee] = 0xef95, [0x91ef] = 0xef96,
  [0x91f0] = 0xef97, [0x91f1] = 0xef98, [0x91f2] = 0xef99, [0x91f3] = 0xef9a,
  [0x91f4] = 0xef9b, [0x91f5] = 0xef9c, [0x91f6] = 0xef9d, [0x91f7] = 0xef9e,
  [0x91f8] = 0xef9f, [0x91f9] = 0xefa0, [0x91fa] = 0xefa1, [0x91fb] = 0xefa2,
  [0x91fc] = 0xefa3, [0x91fd] = 0xefa4, [0x91fe] = 0xefa5, [0x91ff] = 0xefa6,
  [0x9200] = 0xefa7, [0x9201] = 0xefa8, [0x9202] = 0xefa9, [0x9203] = 0xefaa,
  [0x9204] = 0xefab, [0x9205] = 0xefac, [0x9206] = 0xefad, [0x9207] = 0xefae,
  [0x9208] = 0xefaf, [0x9209] = 0xefb0, [0x920a] = 0xefb1, [0x920b] = 0xefb2,
  [0x920c] = 0xefb3, [0x920d] = 0xefb4, [0x920e] = 0xefb5, [0x920f] = 0xefb6,
  [0x9210] = 0xefb7, [0x9211] = 0xefb8, [0x9212] = 0xefb9, [0x9213] = 0xefba,
  [0x9214] = 0xefbb, [0x9215] = 0xefbc, [0x9216] = 0xefbd, [0x9217] = 0xefbe,
  [0x9218] = 0xefbf, [0x9219] = 0xefc0, [0x921a] = 0xefc1, [0x921b] = 0xefc2,
  [0x921c] = 0xefc3, [0x921d] = 0xefc4, [0x921e] = 0xefc5, [0x921f] = 0xefc6,
  [0x9220] = 0xefc7, [0x9221] = 0xefc8, [0x9222] = 0xefc9, [0x9223] = 0xefca,
  [0x9224] = 0xefcb, [0x9225] = 0xefcc, [0x9226] = 0xefcd, [0x9227] = 0xefce,
  [0x9228] = 0xefcf, [0x9229] = 0xefd0, [0x922a] = 0xefd1, [0x922b] = 0xefd2,
  [0x922c] = 0xefd3, [0x922d] = 0xefd4, [0x922e] = 0xefd5, [0x922f] = 0xefd6,
  [0x9230] = 0xefd7, [0x9231] = 0xefd8, [0x9232] = 0xefd9, [0x9233] = 0xefda,
  [0x9234] = 0xefdb, [0x9235] = 0xefdc, [0x9236] = 0xefdd, [0x9237] = 0xefde,
  [0x9238] = 0xefdf, [0x9239] = 0xefe0, [0x923a] = 0xefe1, [0x923b] = 0xefe2,
  [0x923c] = 0xefe3, [0x923d] = 0xefe4, [0x923e] = 0xefe5, [0x923f] = 0xefe6,
  [0x9240] = 0xefe7, [0x9241] = 0xefe8, [0x9242] = 0xefe9, [0x9243] = 0xefea,
  [0x9244] = 0xefeb, [0x9245] = 0xefec, [0x9246] = 0xefed, [0x9247] = 0xefee,
  [0x9248] = 0xefef, [0x9249] = 0xeff0, [0x924a] = 0xeff1, [0x924b] = 0xeff2,
  [0x924c] = 0xeff3, [0x924d] = 0xeff4, [0x924e] = 0xeff5, [0x924f] = 0xeff6,
  [0x9250] = 0xeff7, [0x9251] = 0xeff8, [0x9252] = 0xeff9, [0x9253] = 0xeffa,
  [0x9254] = 0xeffb, [0x9255] = 0xeffc, [0x9256] = 0xeffd, [0x9257] = 0xeffe,
  [0x9258] = 0xefff, [0x9259] = 0xf000, [0x925a] = 0xf001, [0x925b] = 0xf002,
  [0x925c] = 0xf003, [0x925d] = 0xf004, [0x925e] = 0xf005, [0x925f] = 0xf006,
  [0x9260] = 0xf007, [0x9261] = 0xf008, [0x9262] = 0xf009, [0x9263] = 0xf00a,
  [0x9264] = 0xf00b, [0x9265] = 0xf00c, [0x9266] = 0xf00d, [0x9267] = 0xf00e,
  [0x9268] = 0xf00f, [0x9269] = 0xf010, [0x926a] = 0xf011, [0x926b] = 0xf012,
  [0x926c] = 0xf013, [0x926d] = 0xf014, [0x926e] = 0xf015, [0x926f] = 0xf016,
  [0x9270] = 0xf017, [0x9271] = 0xf018, [0x9272] = 0xf019, [0x9273] = 0xf01a,
  [0x9274] = 0xf01b, [0x9275] = 0xf01c, [0x9276] = 0xf01d, [0x9277] = 0xf01e,
  [0x9278] = 0xf01f, [0x9279] = 0xf020, [0x927a] = 0xf021, [0x927b] = 0xf022,
  [0x927c] = 0xf023, [0x927d] = 0xf024, [0x927e] = 0xf025, [0x927f] = 0xf026,
  [0x9280] = 0xf027, [0x9281] = 0xf028, [0x9282] = 0xf029, [0x9283] = 0xf02a,
  [0x9284] = 0xf02b, [0x9285] = 0xf02c, [0x9286] = 0xf02d, [0x9287] = 0xf02e,
  [0x9288] = 0xf02f, [0x9289] = 0xf030, [0x928a] = 0xf031, [0x928b] = 0xf032,
  [0x928c] = 0xf033, [0x928d] = 0xf034, [0x928e] = 0xf035, [0x928f] = 0xf036,
  [0x9290] = 0xf037, [0x9291] = 0xf038, [0x9292] = 0xf039, [0x9293] = 0xf03a,
  [0x9294] = 0xf03b, [0x9295] = 0xf03c, [0x9296] = 0xf03d, [0x9297] = 0xf03e,
  [0x9298] = 0xf03f, [0x9299] = 0xf040, [0x929a] = 0xf041, [0x929b] = 0xf042,
  [0x929c] = 0xf043, [0x929d] = 0xf044, [0x929e] = 0xf045, [0x929f] = 0xf046,
  [0x92a0] = 0xf047, [0x92a1] = 0xf048, [0x92a2] = 0xf049, [0x92a3] = 0xf04a,
  [0x92a4] = 0xf04b, [0x92a5] = 0xf04c, [0x92a6] = 0xf04d, [0x92a7] = 0xf04e,
  [0x92a8] = 0xf04f, [0x92a9] = 0xf050, [0x92aa] = 0xf051, [0x92ab] = 0xf052,
  [0x92ac] = 0xf053, [0x92ad] = 0xf054, [0x92ae] = 0xf055, [0x92af] = 0xf056,
  [0x92b0] = 0xf057, [0x92b1] = 0xf058, [0x92b2] = 0xf059, [0x92b3] = 0xf05a,
  [0x92b4] = 0xf05b, [0x92b5] = 0xf05c, [0x92b6] = 0xf05d, [0x92b7] = 0xf05e,
  [0x92b8] = 0xf05f, [0x92b9] = 0xf060, [0x92ba] = 0xf061, [0x92bb] = 0xf062,
  [0x92bc] = 0xf063, [0x92bd] = 0xf064, [0x92be] = 0xf065, [0x92bf] = 0xf066,
  [0x92c0] = 0xf067, [0x92c1] = 0xf068, [0x92c2] = 0xf069, [0x92c3] = 0xf06a,
  [0x92c4] = 0xf06b, [0x92c5] = 0xf06c, [0x92c6] = 0xf06d, [0x92c7] = 0xf06e,
  [0x92c8] = 0xf06f, [0x92c9] = 0xf070, [0x92ca] = 0xf071, [0x92cb] = 0xf072,
  [0x92cc] = 0xf073, [0x92cd] = 0xf074, [0x92ce] = 0xf075, [0x92cf] = 0xf076,
  [0x92d0] = 0xf077, [0x92d1] = 0xf078, [0x92d2] = 0xf079, [0x92d3] = 0xf07a,
  [0x92d4] = 0xf07b, [0x92d5] = 0xf07c, [0x92d6] = 0xf07d, [0x92d7] = 0xf07e,
  [0x92d8] = 0xf07f, [0x92d9] = 0xf080, [0x92da] = 0xf081, [0x92db] = 0xf082,
  [0x92dc] = 0xf083, [0x92dd] = 0xf084, [0x92de] = 0xf085, [0x92df] = 0xf086,
  [0x92e0] = 0xf087, [0x92e1] = 0xf088, [0x92e2] = 0xf089, [0x92e3] = 0xf08a,
  [0x92e4] = 0xf08b, [0x92e5] = 0xf08c, [0x92e6] = 0xf08d, [0x92e7] = 0xf08e,
  [0x92e8] = 0xf08f, [0x92e9] = 0xf090, [0x92ea] = 0xf091, [0x92eb] = 0xf092,
  [0x92ec] = 0xf093, [0x92ed] = 0xf094, [0x92ee] = 0xf095, [0x92ef] = 0xf096,
  [0x92f0] = 0xf097, [0x92f1] = 0xf098, [0x92f2] = 0xf099, [0x92f3] = 0xf09a,
  [0x92f4] = 0xf09b, [0x92f5] = 0xf09c, [0x92f6] = 0xf09d, [0x92f7] = 0xf09e,
  [0x92f8] = 0xf09f, [0x92f9] = 0xf0a0, [0x92fa] = 0xf0a1, [0x92fb] = 0xf0a2,
  [0x92fc] = 0xf0a3, [0x92fd] = 0xf0a4, [0x92fe] = 0xf0a5, [0x92ff] = 0xf0a6,
  [0x9300] = 0xf0a7, [0x9301] = 0xf0a8, [0x9302] = 0xf0a9, [0x9303] = 0xf0aa,
  [0x9304] = 0xf0ab, [0x9305] = 0xf0ac, [0x9306] = 0xf0ad, [0x9307] = 0xf0ae,
  [0x9308] = 0xf0af, [0x9309] = 0xf0b0, [0x930a] = 0xf0b1, [0x930b] = 0xf0b2,
  [0x930c] = 0xf0b3, [0x930d] = 0xf0b4, [0x930e] = 0xf0b5, [0x930f] = 0xf0b6,
  [0x9310] = 0xf0b7, [0x9311] = 0xf0b8, [0x9312] = 0xf0b9, [0x9313] = 0xf0ba,
  [0x9314] = 0xf0bb, [0x9315] = 0xf0bc, [0x9316] = 0xf0bd, [0x9317] = 0xf0be,
  [0x9318] = 0xf0bf, [0x9319] = 0xf0c0, [0x931a] = 0xf0c1, [0x931b] = 0xf0c2,
  [0x931c] = 0xf0c3, [0x931d] = 0xf0c4, [0x931e] = 0xf0c5, [0x931f] = 0xf0c6,
  [0x9320] = 0xf0c7, [0x9321] = 0xf0c8, [0x9322] = 0xf0c9, [0x9323] = 0xf0ca,
  [0x9324] = 0xf0cb, [0x9325] = 0xf0cc, [0x9326] = 0xf0cd, [0x9327] = 0xf0ce,
  [0x9328] = 0xf0cf, [0x9329] = 0xf0d0, [0x932a] = 0xf0d1, [0x932b] = 0xf0d2,
  [0x932c] = 0xf0d3, [0x932d] = 0xf0d4, [0x932e] = 0xf0d5, [0x932f] = 0xf0d6,
  [0x9330] = 0xf0d7, [0x9331] = 0xf0d8, [0x9332] = 0xf0d9, [0x9333] = 0xf0da,
  [0x9334] = 0xf0db, [0x9335] = 0xf0dc, [0x9336] = 0xf0dd, [0x9337] = 0xf0de,
  [0x9338] = 0xf0df, [0x9339] = 0xf0e0, [0x933a] = 0xf0e1, [0x933b] = 0xf0e2,
  [0x933c] = 0xf0e3, [0x933d] = 0xf0e4, [0x933e] = 0xf0e5, [0x933f] = 0xf0e6,
  [0x9340] = 0xf0e7, [0x9341] = 0xf0e8, [0x9342] = 0xf0e9, [0x9343] = 0xf0ea,
  [0x9344] = 0xf0eb, [0x9345] = 0xf0ec, [0x9346] = 0xf0ed, [0x9347] = 0xf0ee,
  [0x9348] = 0xf0ef, [0x9349] = 0xf0f0, [0x934a] = 0xf0f1, [0x934b] = 0xf0f2,
  [0x934c] = 0xf0f3, [0x934d] = 0xf0f4, [0x934e] = 0xf0f5, [0x934f] = 0xf0f6,
  [0x9350] = 0xf0f7, [0x9351] = 0xf0f8, [0x9352] = 0xf0f9, [0x9353] = 0xf0fa,
  [0x9354] = 0xf0fb, [0x9355] = 0xf0fc, [0x9356] = 0xf0fd, [0x9357] = 0xf0fe,
  [0x9358] = 0xf0ff, [0x9359] = 0xf100, [0x935a] = 0xf101, [0x935b] = 0xf102,
  [0x935c] = 0xf103, [0x935d] = 0xf104, [0x935e] = 0xf105, [0x935f] = 0xf106,
  [0x9360] = 0xf107, [0x9361] = 0xf108, [0x9362] = 0xf109, [0x9363] = 0xf10a,
  [0x9364] = 0xf10b, [0x9365] = 0xf10c, [0x9366] = 0xf10d, [0x9367] = 0xf10e,
  [0x9368] = 0xf10f, [0x9369] = 0xf110, [0x936a] = 0xf111, [0x936b] = 0xf112,
  [0x936c] = 0xf113, [0x936d] = 0xf114, [0x936e] = 0xf115, [0x936f] = 0xf116,
  [0x9370] = 0xf117, [0x9371] = 0xf118, [0x9372] = 0xf119, [0x9373] = 0xf11a,
  [0x9374] = 0xf11b, [0x9375] = 0xf11c, [0x9376] = 0xf11d, [0x9377] = 0xf11e,
  [0x9378] = 0xf11f, [0x9379] = 0xf120, [0x937a] = 0xf121, [0x937b] = 0xf122,
  [0x937c] = 0xf123, [0x937d] = 0xf124, [0x937e] = 0xf125, [0x937f] = 0xf126,
  [0x9380] = 0xf127, [0x9381] = 0xf128, [0x9382] = 0xf129, [0x9383] = 0xf12a,
  [0x9384] = 0xf12b, [0x9385] = 0xf12c, [0x9386] = 0xf12d, [0x9387] = 0xf12e,
  [0x9388] = 0xf12f, [0x9389] = 0xf130, [0x938a] = 0xf131, [0x938b] = 0xf132,
  [0x938c] = 0xf133, [0x938d] = 0xf134, [0x938e] = 0xf135, [0x938f] = 0xf136,
  [0x9390] = 0xf137, [0x9391] = 0xf138, [0x9392] = 0xf139, [0x9393] = 0xf13a,
  [0x9394] = 0xf13b, [0x9395] = 0xf13c, [0x9396] = 0xf13d, [0x9397] = 0xf13e,
  [0x9398] = 0xf13f, [0x9399] = 0xf140, [0x939a] = 0xf141, [0x939b] = 0xf142,
  [0x939c] = 0xf143, [0x939d] = 0xf144, [0x939e] = 0xf145, [0x939f] = 0xf146,
  [0x93a0] = 0xf147, [0x93a1] = 0xf148, [0x93a2] = 0xf149, [0x93a3] = 0xf14a,
  [0x93a4] = 0xf14b, [0x93a5] = 0xf14c, [0x93a6] = 0xf14d, [0x93a7] = 0xf14e,
  [0x93a8] = 0xf14f, [0x93a9] = 0xf150, [0x93aa] = 0xf151, [0x93ab] = 0xf152,
  [0x93ac] = 0xf153, [0x93ad] = 0xf154, [0x93ae] = 0xf155, [0x93af] = 0xf156,
  [0x93b0] = 0xf157, [0x93b1] = 0xf158, [0x93b2] = 0xf159, [0x93b3] = 0xf15a,
  [0x93b4] = 0xf15b, [0x93b5] = 0xf15c, [0x93b6] = 0xf15d, [0x93b7] = 0xf15e,
  [0x93b8] = 0xf15f, [0x93b9] = 0xf160, [0x93ba] = 0xf161, [0x93bb] = 0xf162,
  [0x93bc] = 0xf163, [0x93bd] = 0xf164, [0x93be] = 0xf165, [0x93bf] = 0xf166,
  [0x93c0] = 0xf167, [0x93c1] = 0xf168, [0x93c2] = 0xf169, [0x93c3] = 0xf16a,
  [0x93c4] = 0xf16b, [0x93c5] = 0xf16c, [0x93c6] = 0xf16d, [0x93c7] = 0xf16e,
  [0x93c8] = 0xf16f, [0x93c9] = 0xf170, [0x93ca] = 0xf171, [0x93cb] = 0xf172,
  [0x93cc] = 0xf173, [0x93cd] = 0xf174, [0x93ce] = 0xf175, [0x93cf] = 0xf176,
  [0x93d0] = 0xf177, [0x93d1] = 0xf178, [0x93d2] = 0xf179, [0x93d3] = 0xf17a,
  [0x93d4] = 0xf17b, [0x93d5] = 0xf17c, [0x93d6] = 0xf17d, [0x93d7] = 0xf17e,
  [0x93d8] = 0xf17f, [0x93d9] = 0xf180, [0x93da] = 0xf181, [0x93db] = 0xf182,
  [0x93dc] = 0xf183, [0x93dd] = 0xf184, [0x93de] = 0xf185, [0x93df] = 0xf186,
  [0x93e0] = 0xf187, [0x93e1] = 0xf188, [0x93e2] = 0xf189, [0x93e3] = 0xf18a,
  [0x93e4] = 0xf18b, [0x93e5] = 0xf18c, [0x93e6] = 0xf18d, [0x93e7] = 0xf18e,
  [0x93e8] = 0xf18f, [0x93e9] = 0xf190, [0x93ea] = 0xf191, [0x93eb] = 0xf192,
  [0x93ec] = 0xf193, [0x93ed] = 0xf194, [0x93ee] = 0xf195, [0x93ef] = 0xf196,
  [0x93f0] = 0xf197, [0x93f1] = 0xf198, [0x93f2] = 0xf199, [0x93f3] = 0xf19a,
  [0x93f4] = 0xf19b, [0x93f5] = 0xf19c, [0x93f6] = 0xf19d, [0x93f7] = 0xf19e,
  [0x93f8] = 0xf19f, [0x93f9] = 0xf1a0, [0x93fa] = 0xf1a1, [0x93fb] = 0xf1a2,
  [0x93fc] = 0xf1a3, [0x93fd] = 0xf1a4, [0x93fe] = 0xf1a5, [0x93ff] = 0xf1a6,
  [0x9400] = 0xf1a7, [0x9401] = 0xf1a8, [0x9402] = 0xf1a9, [0x9403] = 0xf1aa,
  [0x9404] = 0xf1ab, [0x9405] = 0xf1ac, [0x9406] = 0xf1ad, [0x9407] = 0xf1ae,
  [0x9408] = 0xf1af, [0x9409] = 0xf1b0, [0x940a] = 0xf1b1, [0x940b] = 0xf1b2,
  [0x940c] = 0xf1b3, [0x940d] = 0xf1b4, [0x940e] = 0xf1b5, [0x940f] = 0xf1b6,
  [0x9410] = 0xf1b7, [0x9411] = 0xf1b8, [0x9412] = 0xf1b9, [0x9413] = 0xf1ba,
  [0x9414] = 0xf1bb, [0x9415] = 0xf1bc, [0x9416] = 0xf1bd, [0x9417] = 0xf1be,
  [0x9418] = 0xf1bf, [0x9419] = 0xf1c0, [0x941a] = 0xf1c1, [0x941b] = 0xf1c2,
  [0x941c] = 0xf1c3, [0x941d] = 0xf1c4, [0x941e] = 0xf1c5, [0x941f] = 0xf1c6,
  [0x9420] = 0xf1c7, [0x9421] = 0xf1c8, [0x9422] = 0xf1c9, [0x9423] = 0xf1ca,
  [0x9424] = 0xf1cb, [0x9425] = 0xf1cc, [0x9426] = 0xf1cd, [0x9427] = 0xf1ce,
  [0x9428] = 0xf1cf, [0x9429] = 0xf1d0, [0x942a] = 0xf1d1, [0x942b] = 0xf1d2,
  [0x942c] = 0xf1d3, [0x942d] = 0xf1d4, [0x942e] = 0xf1d5, [0x942f] = 0xf1d6,
  [0x9430] = 0xf1d7, [0x9431] = 0xf1d8, [0x9432] = 0xf1d9, [0x9433] = 0xf1da,
  [0x9434] = 0xf1db, [0x9435] = 0xf1dc, [0x9436] = 0xf1dd, [0x9437] = 0xf1de,
  [0x9438] = 0xf1df, [0x9439] = 0xf1e0, [0x943a] = 0xf1e1, [0x943b] = 0xf1e2,
  [0x943c] = 0xf1e3, [0x943d] = 0xf1e4, [0x943e] = 0xf1e5, [0x943f] = 0xf1e6,
  [0x9440] = 0xf1e7, [0x9441] = 0xf1e8, [0x9442] = 0xf1e9, [0x9443] = 0xf1ea,
  [0x9444] = 0xf1eb, [0x9445] = 0xf1ec, [0x9446] = 0xf1ed, [0x9447] = 0xf1ee,
  [0x9448] = 0xf1ef, [0x9449] = 0xf1f0, [0x944a] = 0xf1f1, [0x944b] = 0xf1f2,
  [0x944c] = 0xf1f3, [0x944d] = 0xf1f4, [0x944e] = 0xf1f5, [0x944f] = 0xf1f6,
  [0x9450] = 0xf1f7, [0x9451] = 0xf1f8, [0x9452] = 0xf1f9, [0x9453] = 0xf1fa,
  [0x9454] = 0xf1fb, [0x9455] = 0xf1fc, [0x9456] = 0xf1fd, [0x9457] = 0xf1fe,
  [0x9458] = 0xf1ff, [0x9459] = 0xf200, [0x945a] = 0xf201, [0x945b] = 0xf202,
  [0x945c] = 0xf203, [0x945d] = 0xf204, [0x945e] = 0xf205, [0x945f] = 0xf206,
  [0x9460] = 0xf207, [0x9461] = 0xf208, [0x9462] = 0xf209, [0x9463] = 0xf20a,
  [0x9464] = 0xf20b, [0x9465] = 0xf20c, [0x9466] = 0xf20d, [0x9467] = 0xf20e,
  [0x9468] = 0xf20f, [0x9469] = 0xf210, [0x946a] = 0xf211, [0x946b] = 0xf212,
  [0x946c] = 0xf213, [0x946d] = 0xf214, [0x946e] = 0xf215, [0x946f] = 0xf216,
  [0x9470] = 0xf217, [0x9471] = 0xf218, [0x9472] = 0xf219, [0x9473] = 0xf21a,
  [0x9474] = 0xf21b, [0x9475] = 0xf21c, [0x9476] = 0xf21d, [0x9477] = 0xf21e,
  [0x9478] = 0xf21f, [0x9479] = 0xf220, [0x947a] = 0xf221, [0x947b] = 0xf222,
  [0x947c] = 0xf223, [0x947d] = 0xf224, [0x947e] = 0xf225, [0x947f] = 0xf226,
  [0x9480] = 0xf227, [0x9481] = 0xf228, [0x9482] = 0xf229, [0x9483] = 0xf22a,
  [0x9484] = 0xf22b, [0x9485] = 0xf22c, [0x9486] = 0xf22d, [0x9487] = 0xf22e,
  [0x9488] = 0xf22f, [0x9489] = 0xf230, [0x948a] = 0xf231, [0x948b] = 0xf232,
  [0x948c] = 0xf233, [0x948d] = 0xf234, [0x948e] = 0xf235, [0x948f] = 0xf236,
  [0x9490] = 0xf237, [0x9491] = 0xf238, [0x9492] = 0xf239, [0x9493] = 0xf23a,
  [0x9494] = 0xf23b, [0x9495] = 0xf23c, [0x9496] = 0xf23d, [0x9497] = 0xf23e,
  [0x9498] = 0xf23f, [0x9499] = 0xf240, [0x949a] = 0xf241, [0x949b] = 0xf242,
  [0x949c] = 0xf243, [0x949d] = 0xf244, [0x949e] = 0xf245, [0x949f] = 0xf246,
  [0x94a0] = 0xf247, [0x94a1] = 0xf248, [0x94a2] = 0xf249, [0x94a3] = 0xf24a,
  [0x94a4] = 0xf24b, [0x94a5] = 0xf24c, [0x94a6] = 0xf24d, [0x94a7] = 0xf24e,
  [0x94a8] = 0xf24f, [0x94a9] = 0xf250, [0x94aa] = 0xf251, [0x94ab] = 0xf252,
  [0x94ac] = 0xf253, [0x94ad] = 0xf254, [0x94ae] = 0xf255, [0x94af] = 0xf256,
  [0x94b0] = 0xf257, [0x94b1] = 0xf258, [0x94b2] = 0xf259, [0x94b3] = 0xf25a,
  [0x94b4] = 0xf25b, [0x94b5] = 0xf25c, [0x94b6] = 0xf25d, [0x94b7] = 0xf25e,
  [0x94b8] = 0xf25f, [0x94b9] = 0xf260, [0x94ba] = 0xf261, [0x94bb] = 0xf262,
  [0x94bc] = 0xf263, [0x94bd] = 0xf264, [0x94be] = 0xf265, [0x94bf] = 0xf266,
  [0x94c0] = 0xf267, [0x94c1] = 0xf268, [0x94c2] = 0xf269, [0x94c3] = 0xf26a,
  [0x94c4] = 0xf26b, [0x94c5] = 0xf26c, [0x94c6] = 0xf26d, [0x94c7] = 0xf26e,
  [0x94c8] = 0xf26f, [0x94c9] = 0xf270, [0x94ca] = 0xf271, [0x94cb] = 0xf272,
  [0x94cc] = 0xf273, [0x94cd] = 0xf274, [0x94ce] = 0xf275, [0x94cf] = 0xf276,
  [0x94d0] = 0xf277, [0x94d1] = 0xf278, [0x94d2] = 0xf279, [0x94d3] = 0xf27a,
  [0x94d4] = 0xf27b, [0x94d5] = 0xf27c, [0x94d6] = 0xf27d, [0x94d7] = 0xf27e,
  [0x94d8] = 0xf27f, [0x94d9] = 0xf280, [0x94da] = 0xf281, [0x94db] = 0xf282,
  [0x94dc] = 0xf283, [0x94dd] = 0xf284, [0x94de] = 0xf285, [0x94df] = 0xf286,
  [0x94e0] = 0xf287, [0x94e1] = 0xf288, [0x94e2] = 0xf289, [0x94e3] = 0xf28a,
  [0x94e4] = 0xf28b, [0x94e5] = 0xf28c, [0x94e6] = 0xf28d, [0x94e7] = 0xf28e,
  [0x94e8] = 0xf28f, [0x94e9] = 0xf290, [0x94ea] = 0xf291, [0x94eb] = 0xf292,
  [0x94ec] = 0xf293, [0x94ed] = 0xf294, [0x94ee] = 0xf295, [0x94ef] = 0xf296,
  [0x94f0] = 0xf297, [0x94f1] = 0xf298, [0x94f2] = 0xf299, [0x94f3] = 0xf29a,
  [0x94f4] = 0xf29b, [0x94f5] = 0xf29c, [0x94f6] = 0xf29d, [0x94f7] = 0xf29e,
  [0x94f8] = 0xf29f, [0x94f9] = 0xf2a0, [0x94fa] = 0xf2a1, [0x94fb] = 0xf2a2,
  [0x94fc] = 0xf2a3, [0x94fd] = 0xf2a4, [0x94fe] = 0xf2a5, [0x94ff] = 0xf2a6,
  [0x9500] = 0xf2a7, [0x9501] = 0xf2a8, [0x9502] = 0xf2a9, [0x9503] = 0xf2aa,
  [0x9504] = 0xf2ab, [0x9505] = 0xf2ac, [0x9506] = 0xf2ad, [0x9507] = 0xf2ae,
  [0x9508] = 0xf2af, [0x9509] = 0xf2b0, [0x950a] = 0xf2b1, [0x950b] = 0xf2b2,
  [0x950c] = 0xf2b3, [0x950d] = 0xf2b4, [0x950e] = 0xf2b5, [0x950f] = 0xf2b6,
  [0x9510] = 0xf2b7, [0x9511] = 0xf2b8, [0x9512] = 0xf2b9, [0x9513] = 0xf2ba,
  [0x9514] = 0xf2bb, [0x9515] = 0xf2bc, [0x9516] = 0xf2bd, [0x9517] = 0xf2be,
  [0x9518] = 0xf2bf, [0x9519] = 0xf2c0, [0x951a] = 0xf2c1, [0x951b] = 0xf2c2,
  [0x951c] = 0xf2c3, [0x951d] = 0xf2c4, [0x951e] = 0xf2c5, [0x951f] = 0xf2c6,
  [0x9520] = 0xf2c7, [0x9521] = 0xf2c8, [0x9522] = 0xf2c9, [0x9523] = 0xf2ca,
  [0x9524] = 0xf2cb, [0x9525] = 0xf2cc, [0x9526] = 0xf2cd, [0x9527] = 0xf2ce,
  [0x9528] = 0xf2cf, [0x9529] = 0xf2d0, [0x952a] = 0xf2d1, [0x952b] = 0xf2d2,
  [0x952c] = 0xf2d3, [0x952d] = 0xf2d4, [0x952e] = 0xf2d5, [0x952f] = 0xf2d6,
  [0x9530] = 0xf2d7, [0x9531] = 0xf2d8, [0x9532] = 0xf2d9, [0x9533] = 0xf2da,
  [0x9534] = 0xf2db, [0x9535] = 0xf2dc, [0x9536] = 0xf2dd, [0x9537] = 0xf2de,
  [0x9538] = 0xf2df, [0x9539] = 0xf2e0, [0x953a] = 0xf2e1, [0x953b] = 0xf2e2,
  [0x953c] = 0xf2e3, [0x953d] = 0xf2e4, [0x953e] = 0xf2e5, [0x953f] = 0xf2e6,
  [0x9540] = 0xf2e7, [0x9541] = 0xf2e8, [0x9542] = 0xf2e9, [0x9543] = 0xf2ea,
  [0x9544] = 0xf2eb, [0x9545] = 0xf2ec, [0x9546] = 0xf2ed, [0x9547] = 0xf2ee,
  [0x9548] = 0xf2ef, [0x9549] = 0xf2f0, [0x954a] = 0xf2f1, [0x954b] = 0xf2f2,
  [0x954c] = 0xf2f3, [0x954d] = 0xf2f4, [0x954e] = 0xf2f5, [0x954f] = 0xf2f6,
  [0x9550] = 0xf2f7, [0x9551] = 0xf2f8, [0x9552] = 0xf2f9, [0x9553] = 0xf2fa,
  [0x9554] = 0xf2fb, [0x9555] = 0xf2fc, [0x9556] = 0xf2fd, [0x9557] = 0xf2fe,
  [0x9558] = 0xf2ff, [0x9559] = 0xf300, [0x955a] = 0xf301, [0x955b] = 0xf302,
  [0x955c] = 0xf303, [0x955d] = 0xf304, [0x955e] = 0xf305, [0x955f] = 0xf306,
  [0x9560] = 0xf307, [0x9561] = 0xf308, [0x9562] = 0xf309, [0x9563] = 0xf30a,
  [0x9564] = 0xf30b, [0x9565] = 0xf30c, [0x9566] = 0xf30d, [0x9567] = 0xf30e,
  [0x9568] = 0xf30f, [0x9569] = 0xf310, [0x956a] = 0xf311, [0x956b] = 0xf312,
  [0x956c] = 0xf313, [0x956d] = 0xf314, [0x956e] = 0xf315, [0x956f] = 0xf316,
  [0x9570] = 0xf317, [0x9571] = 0xf318, [0x9572] = 0xf319, [0x9573] = 0xf31a,
  [0x9574] = 0xf31b, [0x9575] = 0xf31c, [0x9576] = 0xf31d, [0x9577] = 0xf31e,
  [0x9578] = 0xf31f, [0x9579] = 0xf320, [0x957a] = 0xf321, [0x957b] = 0xf322,
  [0x957c] = 0xf323, [0x957d] = 0xf324, [0x957e] = 0xf325, [0x957f] = 0xf326,
  [0x9580] = 0xf327, [0x9581] = 0xf328, [0x9582] = 0xf329, [0x9583] = 0xf32a,
  [0x9584] = 0xf32b, [0x9585] = 0xf32c, [0x9586] = 0xf32d, [0x9587] = 0xf32e,
  [0x9588] = 0xf32f, [0x9589] = 0xf330, [0x958a] = 0xf331, [0x958b] = 0xf332,
  [0x958c] = 0xf333, [0x958d] = 0xf334, [0x958e] = 0xf335, [0x958f] = 0xf336,
  [0x9590] = 0xf337, [0x9591] = 0xf338, [0x9592] = 0xf339, [0x9593] = 0xf33a,
  [0x9594] = 0xf33b, [0x9595] = 0xf33c, [0x9596] = 0xf33d, [0x9597] = 0xf33e,
  [0x9598] = 0xf33f, [0x9599] = 0xf340, [0x959a] = 0xf341, [0x959b] = 0xf342,
  [0x959c] = 0xf343, [0x959d] = 0xf344, [0x959e] = 0xf345, [0x959f] = 0xf346,
  [0x95a0] = 0xf347, [0x95a1] = 0xf348, [0x95a2] = 0xf349, [0x95a3] = 0xf34a,
  [0x95a4] = 0xf34b, [0x95a5] = 0xf34c, [0x95a6] = 0xf34d, [0x95a7] = 0xf34e,
  [0x95a8] = 0xf34f, [0x95a9] = 0xf350, [0x95aa] = 0xf351, [0x95ab] = 0xf352,
  [0x95ac] = 0xf353, [0x95ad] = 0xf354, [0x95ae] = 0xf355, [0x95af] = 0xf356,
  [0x95b0] = 0xf357, [0x95b1] = 0xf358, [0x95b2] = 0xf359, [0x95b3] = 0xf35a,
  [0x95b4] = 0xf35b, [0x95b5] = 0xf35c, [0x95b6] = 0xf35d, [0x95b7] = 0xf35e,
  [0x95b8] = 0xf35f, [0x95b9] = 0xf360, [0x95ba] = 0xf361, [0x95bb] = 0xf362,
  [0x95bc] = 0xf363, [0x95bd] = 0xf364, [0x95be] = 0xf365, [0x95bf] = 0xf366,
  [0x95c0] = 0xf367, [0x95c1] = 0xf368, [0x95c2] = 0xf369, [0x95c3] = 0xf36a,
  [0x95c4] = 0xf36b, [0x95c5] = 0xf36c, [0x95c6] = 0xf36d, [0x95c7] = 0xf36e,
  [0x95c8] = 0xf36f, [0x95c9] = 0xf370, [0x95ca] = 0xf371, [0x95cb] = 0xf372,
  [0x95cc] = 0xf373, [0x95cd] = 0xf374, [0x95ce] = 0xf375, [0x95cf] = 0xf376,
  [0x95d0] = 0xf377, [0x95d1] = 0xf378, [0x95d2] = 0xf379, [0x95d3] = 0xf37a,
  [0x95d4] = 0xf37b, [0x95d5] = 0xf37c, [0x95d6] = 0xf37d, [0x95d7] = 0xf37e,
  [0x95d8] = 0xf37f, [0x95d9] = 0xf380, [0x95da] = 0xf381, [0x95db] = 0xf382,
  [0x95dc] = 0xf383, [0x95dd] = 0xf384, [0x95de] = 0xf385, [0x95df] = 0xf386,
  [0x95e0] = 0xf387, [0x95e1] = 0xf388, [0x95e2] = 0xf389, [0x95e3] = 0xf38a,
  [0x95e4] = 0xf38b, [0x95e5] = 0xf38c, [0x95e6] = 0xf38d, [0x95e7] = 0xf38e,
  [0x95e8] = 0xf38f, [0x95e9] = 0xf390, [0x95ea] = 0xf391, [0x95eb] = 0xf392,
  [0x95ec] = 0xf393, [0x95ed] = 0xf394, [0x95ee] = 0xf395, [0x95ef] = 0xf396,
  [0x95f0] = 0xf397, [0x95f1] = 0xf398, [0x95f2] = 0xf399, [0x95f3] = 0xf39a,
  [0x95f4] = 0xf39b, [0x95f5] = 0xf39c, [0x95f6] = 0xf39d, [0x95f7] = 0xf39e,
  [0x95f8] = 0xf39f, [0x95f9] = 0xf3a0, [0x95fa] = 0xf3a1, [0x95fb] = 0xf3a2,
  [0x95fc] = 0xf3a3, [0x95fd] = 0xf3a4, [0x95fe] = 0xf3a5, [0x95ff] = 0xf3a6,
  [0x9600] = 0xf3a7, [0x9601] = 0xf3a8, [0x9602] = 0xf3a9, [0x9603] = 0xf3aa,
  [0x9604] = 0xf3ab, [0x9605] = 0xf3ac, [0x9606] = 0xf3ad, [0x9607] = 0xf3ae,
  [0x9608] = 0xf3af, [0x9609] = 0xf3b0, [0x960a] = 0xf3b1, [0x960b] = 0xf3b2,
  [0x960c] = 0xf3b3, [0x960d] = 0xf3b4, [0x960e] = 0xf3b5, [0x960f] = 0xf3b6,
  [0x9610] = 0xf3b7, [0x9611] = 0xf3b8, [0x9612] = 0xf3b9, [0x9613] = 0xf3ba,
  [0x9614] = 0xf3bb, [0x9615] = 0xf3bc, [0x9616] = 0xf3bd, [0x9617] = 0xf3be,
  [0x9618] = 0xf3bf, [0x9619] = 0xf3c0, [0x961a] = 0xf3c1, [0x961b] = 0xf3c2,
  [0x961c] = 0xf3c3, [0x961d] = 0xf3c4, [0x961e] = 0xf3c5, [0x961f] = 0xf3c6,
  [0x9620] = 0xf3c7, [0x9621] = 0xf3c8, [0x9622] = 0xf3c9, [0x9623] = 0xf3ca,
  [0x9624] = 0xf3cb, [0x9625] = 0xf3cc, [0x9626] = 0xf3cd, [0x9627] = 0xf3ce,
  [0x9628] = 0xf3cf, [0x9629] = 0xf3d0, [0x962a] = 0xf3d1, [0x962b] = 0xf3d2,
  [0x962c] = 0xf3d3, [0x962d] = 0xf3d4, [0x962e] = 0xf3d5, [0x962f] = 0xf3d6,
  [0x9630] = 0xf3d7, [0x9631] = 0xf3d8, [0x9632] = 0xf3d9, [0x9633] = 0xf3da,
  [0x9634] = 0xf3db, [0x9635] = 0xf3dc, [0x9636] = 0xf3dd, [0x9637] = 0xf3de,
  [0x9638] = 0xf3df, [0x9639] = 0xf3e0, [0x963a] = 0xf3e1, [0x963b] = 0xf3e2,
  [0x963c] = 0xf3e3, [0x963d] = 0xf3e4, [0x963e] = 0xf3e5, [0x963f] = 0xf3e6,
  [0x9640] = 0xf3e7, [0x9641] = 0xf3e8, [0x9642] = 0xf3e9, [0x9643] = 0xf3ea,
  [0x9644] = 0xf3eb, [0x9645] = 0xf3ec, [0x9646] = 0xf3ed, [0x9647] = 0xf3ee,
  [0x9648] = 0xf3ef, [0x9649] = 0xf3f0, [0x964a] = 0xf3f1, [0x964b] = 0xf3f2,
  [0x964c] = 0xf3f3, [0x964d] = 0xf3f4, [0x964e] = 0xf3f5, [0x964f] = 0xf3f6,
  [0x9650] = 0xf3f7, [0x9651] = 0xf3f8, [0x9652] = 0xf3f9, [0x9653] = 0xf3fa,
  [0x9654] = 0xf3fb, [0x9655] = 0xf3fc, [0x9656] = 0xf3fd, [0x9657] = 0xf3fe,
  [0x9658] = 0xf3ff, [0x9659] = 0xf400, [0x965a] = 0xf401, [0x965b] = 0xf402,
  [0x965c] = 0xf403, [0x965d] = 0xf404, [0x965e] = 0xf405, [0x965f] = 0xf406,
  [0x9660] = 0xf407, [0x9661] = 0xf408, [0x9662] = 0xf409, [0x9663] = 0xf40a,
  [0x9664] = 0xf40b, [0x9665] = 0xf40c, [0x9666] = 0xf40d, [0x9667] = 0xf40e,
  [0x9668] = 0xf40f, [0x9669] = 0xf410, [0x966a] = 0xf411, [0x966b] = 0xf412,
  [0x966c] = 0xf413, [0x966d] = 0xf414, [0x966e] = 0xf415, [0x966f] = 0xf416,
  [0x9670] = 0xf417, [0x9671] = 0xf418, [0x9672] = 0xf419, [0x9673] = 0xf41a,
  [0x9674] = 0xf41b, [0x9675] = 0xf41c, [0x9676] = 0xf41d, [0x9677] = 0xf41e,
  [0x9678] = 0xf41f, [0x9679] = 0xf420, [0x967a] = 0xf421, [0x967b] = 0xf422,
  [0x967c] = 0xf423, [0x967d] = 0xf424, [0x967e] = 0xf425, [0x967f] = 0xf426,
  [0x9680] = 0xf427, [0x9681] = 0xf428, [0x9682] = 0xf429, [0x9683] = 0xf42a,
  [0x9684] = 0xf42b, [0x9685] = 0xf42c, [0x9686] = 0xf42d, [0x9687] = 0xf42e,
  [0x9688] = 0xf42f, [0x9689] = 0xf430, [0x968a] = 0xf431, [0x968b] = 0xf432,
  [0x968c] = 0xf433, [0x968d] = 0xf434, [0x968e] = 0xf435, [0x968f] = 0xf436,
  [0x9690] = 0xf437, [0x9691] = 0xf438, [0x9692] = 0xf439, [0x9693] = 0xf43a,
  [0x9694] = 0xf43b, [0x9695] = 0xf43c, [0x9696] = 0xf43d, [0x9697] = 0xf43e,
  [0x9698] = 0xf43f, [0x9699] = 0xf440, [0x969a] = 0xf441, [0x969b] = 0xf442,
  [0x969c] = 0xf443, [0x969d] = 0xf444, [0x969e] = 0xf445, [0x969f] = 0xf446,
  [0x96a0] = 0xf447, [0x96a1] = 0xf448, [0x96a2] = 0xf449, [0x96a3] = 0xf44a,
  [0x96a4] = 0xf44b, [0x96a5] = 0xf44c, [0x96a6] = 0xf44d, [0x96a7] = 0xf44e,
  [0x96a8] = 0xf44f, [0x96a9] = 0xf450, [0x96aa] = 0xf451, [0x96ab] = 0xf452,
  [0x96ac] = 0xf453, [0x96ad] = 0xf454, [0x96ae] = 0xf455, [0x96af] = 0xf456,
  [0x96b0] = 0xf457, [0x96b1] = 0xf458, [0x96b2] = 0xf459, [0x96b3] = 0xf45a,
  [0x96b4] = 0xf45b, [0x96b5] = 0xf45c, [0x96b6] = 0xf45d, [0x96b7] = 0xf45e,
  [0x96b8] = 0xf45f, [0x96b9] = 0xf460, [0x96ba] = 0xf461, [0x96bb] = 0xf462,
  [0x96bc] = 0xf463, [0x96bd] = 0xf464, [0x96be] = 0xf465, [0x96bf] = 0xf466,
  [0x96c0] = 0xf467, [0x96c1] = 0xf468, [0x96c2] = 0xf469, [0x96c3] = 0xf46a,
  [0x96c4] = 0xf46b, [0x96c5] = 0xf46c, [0x96c6] = 0xf46d, [0x96c7] = 0xf46e,
  [0x96c8] = 0xf46f, [0x96c9] = 0xf470, [0x96ca] = 0xf471, [0x96cb] = 0xf472,
  [0x96cc] = 0xf473, [0x96cd] = 0xf474, [0x96ce] = 0xf475, [0x96cf] = 0xf476,
  [0x96d0] = 0xf477, [0x96d1] = 0xf478, [0x96d2] = 0xf479, [0x96d3] = 0xf47a,
  [0x96d4] = 0xf47b, [0x96d5] = 0xf47c, [0x96d6] = 0xf47d, [0x96d7] = 0xf47e,
  [0x96d8] = 0xf47f, [0x96d9] = 0xf480, [0x96da] = 0xf481, [0x96db] = 0xf482,
  [0x96dc] = 0xf483, [0x96dd] = 0xf484, [0x96de] = 0xf485, [0x96df] = 0xf486,
  [0x96e0] = 0xf487, [0x96e1] = 0xf488, [0x96e2] = 0xf489, [0x96e3] = 0xf48a,
  [0x96e4] = 0xf48b, [0x96e5] = 0xf48c, [0x96e6] = 0xf48d, [0x96e7] = 0xf48e,
  [0x96e8] = 0xf48f, [0x96e9] = 0xf490, [0x96ea] = 0xf491, [0x96eb] = 0xf492,
  [0x96ec] = 0xf493, [0x96ed] = 0xf494, [0x96ee] = 0xf495, [0x96ef] = 0xf496,
  [0x96f0] = 0xf497, [0x96f1] = 0xf498, [0x96f2] = 0xf499, [0x96f3] = 0xf49a,
  [0x96f4] = 0xf49b, [0x96f5] = 0xf49c, [0x96f6] = 0xf49d, [0x96f7] = 0xf49e,
  [0x96f8] = 0xf49f, [0x96f9] = 0xf4a0, [0x96fa] = 0xf4a1, [0x96fb] = 0xf4a2,
  [0x96fc] = 0xf4a3, [0x96fd] = 0xf4a4, [0x96fe] = 0xf4a5, [0x96ff] = 0xf4a6,
  [0x9700] = 0xf4a7, [0x9701] = 0xf4a8, [0x9702] = 0xf4a9, [0x9703] = 0xf4aa,
  [0x9704] = 0xf4ab, [0x9705] = 0xf4ac, [0x9706] = 0xf4ad, [0x9707] = 0xf4ae,
  [0x9708] = 0xf4af, [0x9709] = 0xf4b0, [0x970a] = 0xf4b1, [0x970b] = 0xf4b2,
  [0x970c] = 0xf4b3, [0x970d] = 0xf4b4, [0x970e] = 0xf4b5, [0x970f] = 0xf4b6,
  [0x9710] = 0xf4b7, [0x9711] = 0xf4b8, [0x9712] = 0xf4b9, [0x9713] = 0xf4ba,
  [0x9714] = 0xf4bb, [0x9715] = 0xf4bc, [0x9716] = 0xf4bd, [0x9717] = 0xf4be,
  [0x9718] = 0xf4bf, [0x9719] = 0xf4c0, [0x971a] = 0xf4c1, [0x971b] = 0xf4c2,
  [0x971c] = 0xf4c3, [0x971d] = 0xf4c4, [0x971e] = 0xf4c5, [0x971f] = 0xf4c6,
  [0x9720] = 0xf4c7, [0x9721] = 0xf4c8, [0x9722] = 0xf4c9, [0x9723] = 0xf4ca,
  [0x9724] = 0xf4cb, [0x9725] = 0xf4cc, [0x9726] = 0xf4cd, [0x9727] = 0xf4ce,
  [0x9728] = 0xf4cf, [0x9729] = 0xf4d0, [0x972a] = 0xf4d1, [0x972b] = 0xf4d2,
  [0x972c] = 0xf4d3, [0x972d] = 0xf4d4, [0x972e] = 0xf4d5, [0x972f] = 0xf4d6,
  [0x9730] = 0xf4d7, [0x9731] = 0xf4d8, [0x9732] = 0xf4d9, [0x9733] = 0xf4da,
  [0x9734] = 0xf4db, [0x9735] = 0xf4dc, [0x9736] = 0xf4dd, [0x9737] = 0xf4de,
  [0x9738] = 0xf4df, [0x9739] = 0xf4e0, [0x973a] = 0xf4e1, [0x973b] = 0xf4e2,
  [0x973c] = 0xf4e3, [0x973d] = 0xf4e4, [0x973e] = 0xf4e5, [0x973f] = 0xf4e6,
  [0x9740] = 0xf4e7, [0x9741] = 0xf4e8, [0x9742] = 0xf4e9, [0x9743] = 0xf4ea,
  [0x9744] = 0xf4eb, [0x9745] = 0xf4ec, [0x9746] = 0xf4ed, [0x9747] = 0xf4ee,
  [0x9748] = 0xf4ef, [0x9749] = 0xf4f0, [0x974a] = 0xf4f1, [0x974b] = 0xf4f2,
  [0x974c] = 0xf4f3, [0x974d] = 0xf4f4, [0x974e] = 0xf4f5, [0x974f] = 0xf4f6,
  [0x9750] = 0xf4f7, [0x9751] = 0xf4f8, [0x9752] = 0xf4f9, [0x9753] = 0xf4fa,
  [0x9754] = 0xf4fb, [0x9755] = 0xf4fc, [0x9756] = 0xf4fd, [0x9757] = 0xf4fe,
  [0x9758] = 0xf4ff, [0x9759] = 0xf500, [0x975a] = 0xf501, [0x975b] = 0xf502,
  [0x975c] = 0xf503, [0x975d] = 0xf504, [0x975e] = 0xf505, [0x975f] = 0xf506,
  [0x9760] = 0xf507, [0x9761] = 0xf508, [0x9762] = 0xf509, [0x9763] = 0xf50a,
  [0x9764] = 0xf50b, [0x9765] = 0xf50c, [0x9766] = 0xf50d, [0x9767] = 0xf50e,
  [0x9768] = 0xf50f, [0x9769] = 0xf510, [0x976a] = 0xf511, [0x976b] = 0xf512,
  [0x976c] = 0xf513, [0x976d] = 0xf514, [0x976e] = 0xf515, [0x976f] = 0xf516,
  [0x9770] = 0xf517, [0x9771] = 0xf518, [0x9772] = 0xf519, [0x9773] = 0xf51a,
  [0x9774] = 0xf51b, [0x9775] = 0xf51c, [0x9776] = 0xf51d, [0x9777] = 0xf51e,
  [0x9778] = 0xf51f, [0x9779] = 0xf520, [0x977a] = 0xf521, [0x977b] = 0xf522,
  [0x977c] = 0xf523, [0x977d] = 0xf524, [0x977e] = 0xf525, [0x977f] = 0xf526,
  [0x9780] = 0xf527, [0x9781] = 0xf528, [0x9782] = 0xf529, [0x9783] = 0xf52a,
  [0x9784] = 0xf52b, [0x9785] = 0xf52c, [0x9786] = 0xf52d, [0x9787] = 0xf52e,
  [0x9788] = 0xf52f, [0x9789] = 0xf530, [0x978a] = 0xf531, [0x978b] = 0xf532,
  [0x978c] = 0xf533, [0x978d] = 0xf534, [0x978e] = 0xf535, [0x978f] = 0xf536,
  [0x9790] = 0xf537, [0x9791] = 0xf538, [0x9792] = 0xf539, [0x9793] = 0xf53a,
  [0x9794] = 0xf53b, [0x9795] = 0xf53c, [0x9796] = 0xf53d, [0x9797] = 0xf53e,
  [0x9798] = 0xf53f, [0x9799] = 0xf540, [0x979a] = 0xf541, [0x979b] = 0xf542,
  [0x979c] = 0xf543, [0x979d] = 0xf544, [0x979e] = 0xf545, [0x979f] = 0xf546,
  [0x97a0] = 0xf547, [0x97a1] = 0xf548, [0x97a2] = 0xf549, [0x97a3] = 0xf54a,
  [0x97a4] = 0xf54b, [0x97a5] = 0xf54c, [0x97a6] = 0xf54d, [0x97a7] = 0xf54e,
  [0x97a8] = 0xf54f, [0x97a9] = 0xf550, [0x97aa] = 0xf551, [0x97ab] = 0xf552,
  [0x97ac] = 0xf553, [0x97ad] = 0xf554, [0x97ae] = 0xf555, [0x97af] = 0xf556,
  [0x97b0] = 0xf557, [0x97b1] = 0xf558, [0x97b2] = 0xf559, [0x97b3] = 0xf55a,
  [0x97b4] = 0xf55b, [0x97b5] = 0xf55c, [0x97b6] = 0xf55d, [0x97b7] = 0xf55e,
  [0x97b8] = 0xf55f, [0x97b9] = 0xf560, [0x97ba] = 0xf561, [0x97bb] = 0xf562,
  [0x97bc] = 0xf563, [0x97bd] = 0xf564, [0x97be] = 0xf565, [0x97bf] = 0xf566,
  [0x97c0] = 0xf567, [0x97c1] = 0xf568, [0x97c2] = 0xf569, [0x97c3] = 0xf56a,
  [0x97c4] = 0xf56b, [0x97c5] = 0xf56c, [0x97c6] = 0xf56d, [0x97c7] = 0xf56e,
  [0x97c8] = 0xf56f, [0x97c9] = 0xf570, [0x97ca] = 0xf571, [0x97cb] = 0xf572,
  [0x97cc] = 0xf573, [0x97cd] = 0xf574, [0x97ce] = 0xf575, [0x97cf] = 0xf576,
  [0x97d0] = 0xf577, [0x97d1] = 0xf578, [0x97d2] = 0xf579, [0x97d3] = 0xf57a,
  [0x97d4] = 0xf57b, [0x97d5] = 0xf57c, [0x97d6] = 0xf57d, [0x97d7] = 0xf57e,
  [0x97d8] = 0xf57f, [0x97d9] = 0xf580, [0x97da] = 0xf581, [0x97db] = 0xf582,
  [0x97dc] = 0xf583, [0x97dd] = 0xf584, [0x97de] = 0xf585, [0x97df] = 0xf586,
  [0x97e0] = 0xf587, [0x97e1] = 0xf588, [0x97e2] = 0xf589, [0x97e3] = 0xf58a,
  [0x97e4] = 0xf58b, [0x97e5] = 0xf58c, [0x97e6] = 0xf58d, [0x97e7] = 0xf58e,
  [0x97e8] = 0xf58f, [0x97e9] = 0xf590, [0x97ea] = 0xf591, [0x97eb] = 0xf592,
  [0x97ec] = 0xf593, [0x97ed] = 0xf594, [0x97ee] = 0xf595, [0x97ef] = 0xf596,
  [0x97f0] = 0xf597, [0x97f1] = 0xf598, [0x97f2] = 0xf599, [0x97f3] = 0xf59a,
  [0x97f4] = 0xf59b, [0x97f5] = 0xf59c, [0x97f6] = 0xf59d, [0x97f7] = 0xf59e,
  [0x97f8] = 0xf59f, [0x97f9] = 0xf5a0, [0x97fa] = 0xf5a1, [0x97fb] = 0xf5a2,
  [0x97fc] = 0xf5a3, [0x97fd] = 0xf5a4, [0x97fe] = 0xf5a5, [0x97ff] = 0xf5a6,
  [0x9800] = 0xf5a7, [0x9801] = 0xf5a8, [0x9802] = 0xf5a9, [0x9803] = 0xf5aa,
  [0x9804] = 0xf5ab, [0x9805] = 0xf5ac, [0x9806] = 0xf5ad, [0x9807] = 0xf5ae,
  [0x9808] = 0xf5af, [0x9809] = 0xf5b0, [0x980a] = 0xf5b1, [0x980b] = 0xf5b2,
  [0x980c] = 0xf5b3, [0x980d] = 0xf5b4, [0x980e] = 0xf5b5, [0x980f] = 0xf5b6,
  [0x9810] = 0xf5b7, [0x9811] = 0xf5b8, [0x9812] = 0xf5b9, [0x9813] = 0xf5ba,
  [0x9814] = 0xf5bb, [0x9815] = 0xf5bc, [0x9816] = 0xf5bd, [0x9817] = 0xf5be,
  [0x9818] = 0xf5bf, [0x9819] = 0xf5c0, [0x981a] = 0xf5c1, [0x981b] = 0xf5c2,
  [0x981c] = 0xf5c3, [0x981d] = 0xf5c4, [0x981e] = 0xf5c5, [0x981f] = 0xf5c6,
  [0x9820] = 0xf5c7, [0x9821] = 0xf5c8, [0x9822] = 0xf5c9, [0x9823] = 0xf5ca,
  [0x9824] = 0xf5cb, [0x9825] = 0xf5cc, [0x9826] = 0xf5cd, [0x9827] = 0xf5ce,
  [0x9828] = 0xf5cf, [0x9829] = 0xf5d0, [0x982a] = 0xf5d1, [0x982b] = 0xf5d2,
  [0x982c] = 0xf5d3, [0x982d] = 0xf5d4, [0x982e] = 0xf5d5, [0x982f] = 0xf5d6,
  [0x9830] = 0xf5d7, [0x9831] = 0xf5d8, [0x9832] = 0xf5d9, [0x9833] = 0xf5da,
  [0x9834] = 0xf5db, [0x9835] = 0xf5dc, [0x9836] = 0xf5dd, [0x9837] = 0xf5de,
  [0x9838] = 0xf5df, [0x9839] = 0xf5e0, [0x983a] = 0xf5e1, [0x983b] = 0xf5e2,
  [0x983c] = 0xf5e3, [0x983d] = 0xf5e4, [0x983e] = 0xf5e5, [0x983f] = 0xf5e6,
  [0x9840] = 0xf5e7, [0x9841] = 0xf5e8, [0x9842] = 0xf5e9, [0x9843] = 0xf5ea,
  [0x9844] = 0xf5eb, [0x9845] = 0xf5ec, [0x9846] = 0xf5ed, [0x9847] = 0xf5ee,
  [0x9848] = 0xf5ef, [0x9849] = 0xf5f0, [0x984a] = 0xf5f1, [0x984b] = 0xf5f2,
  [0x984c] = 0xf5f3, [0x984d] = 0xf5f4, [0x984e] = 0xf5f5, [0x984f] = 0xf5f6,
  [0x9850] = 0xf5f7, [0x9851] = 0xf5f8, [0x9852] = 0xf5f9, [0x9853] = 0xf5fa,
  [0x9854] = 0xf5fb, [0x9855] = 0xf5fc, [0x9856] = 0xf5fd, [0x9857] = 0xf5fe,
  [0x9858] = 0xf5ff, [0x9859] = 0xf600, [0x985a] = 0xf601, [0x985b] = 0xf602,
  [0x985c] = 0xf603, [0x985d] = 0xf604, [0x985e] = 0xf605, [0x985f] = 0xf606,
  [0x9860] = 0xf607, [0x9861] = 0xf608, [0x9862] = 0xf609, [0x9863] = 0xf60a,
  [0x9864] = 0xf60b, [0x9865] = 0xf60c, [0x9866] = 0xf60d, [0x9867] = 0xf60e,
  [0x9868] = 0xf60f, [0x9869] = 0xf610, [0x986a] = 0xf611, [0x986b] = 0xf612,
  [0x986c] = 0xf613, [0x986d] = 0xf614, [0x986e] = 0xf615, [0x986f] = 0xf616,
  [0x9870] = 0xf617, [0x9871] = 0xf618, [0x9872] = 0xf619, [0x9873] = 0xf61a,
  [0x9874] = 0xf61b, [0x9875] = 0xf61c, [0x9876] = 0xf61d, [0x9877] = 0xf61e,
  [0x9878] = 0xf61f, [0x9879] = 0xf620, [0x987a] = 0xf621, [0x987b] = 0xf622,
  [0x987c] = 0xf623, [0x987d] = 0xf624, [0x987e] = 0xf625, [0x987f] = 0xf626,
  [0x9880] = 0xf627, [0x9881] = 0xf628, [0x9882] = 0xf629, [0x9883] = 0xf62a,
  [0x9884] = 0xf62b, [0x9885] = 0xf62c, [0x9886] = 0xf62d, [0x9887] = 0xf62e,
  [0x9888] = 0xf62f, [0x9889] = 0xf630, [0x988a] = 0xf631, [0x988b] = 0xf632,
  [0x988c] = 0xf633, [0x988d] = 0xf634, [0x988e] = 0xf635, [0x988f] = 0xf636,
  [0x9890] = 0xf637, [0x9891] = 0xf638, [0x9892] = 0xf639, [0x9893] = 0xf63a,
  [0x9894] = 0xf63b, [0x9895] = 0xf63c, [0x9896] = 0xf63d, [0x9897] = 0xf63e,
  [0x9898] = 0xf63f, [0x9899] = 0xf640, [0x989a] = 0xf641, [0x989b] = 0xf642,
  [0x989c] = 0xf643, [0x989d] = 0xf644, [0x989e] = 0xf645, [0x989f] = 0xf646,
  [0x98a0] = 0xf647, [0x98a1] = 0xf648, [0x98a2] = 0xf649, [0x98a3] = 0xf64a,
  [0x98a4] = 0xf64b, [0x98a5] = 0xf64c, [0x98a6] = 0xf64d, [0x98a7] = 0xf64e,
  [0x98a8] = 0xf64f, [0x98a9] = 0xf650, [0x98aa] = 0xf651, [0x98ab] = 0xf652,
  [0x98ac] = 0xf653, [0x98ad] = 0xf654, [0x98ae] = 0xf655, [0x98af] = 0xf656,
  [0x98b0] = 0xf657, [0x98b1] = 0xf658, [0x98b2] = 0xf659, [0x98b3] = 0xf65a,
  [0x98b4] = 0xf65b, [0x98b5] = 0xf65c, [0x98b6] = 0xf65d, [0x98b7] = 0xf65e,
  [0x98b8] = 0xf65f, [0x98b9] = 0xf660, [0x98ba] = 0xf661, [0x98bb] = 0xf662,
  [0x98bc] = 0xf663, [0x98bd] = 0xf664, [0x98be] = 0xf665, [0x98bf] = 0xf666,
  [0x98c0] = 0xf667, [0x98c1] = 0xf668, [0x98c2] = 0xf669, [0x98c3] = 0xf66a,
  [0x98c4] = 0xf66b, [0x98c5] = 0xf66c, [0x98c6] = 0xf66d, [0x98c7] = 0xf66e,
  [0x98c8] = 0xf66f, [0x98c9] = 0xf670, [0x98ca] = 0xf671, [0x98cb] = 0xf672,
  [0x98cc] = 0xf673, [0x98cd] = 0xf674, [0x98ce] = 0xf675, [0x98cf] = 0xf676,
  [0x98d0] = 0xf677, [0x98d1] = 0xf678, [0x98d2] = 0xf679, [0x98d3] = 0xf67a,
  [0x98d4] = 0xf67b, [0x98d5] = 0xf67c, [0x98d6] = 0xf67d, [0x98d7] = 0xf67e,
  [0x98d8] = 0xf67f, [0x98d9] = 0xf680, [0x98da] = 0xf681, [0x98db] = 0xf682,
  [0x98dc] = 0xf683, [0x98dd] = 0xf684, [0x98de] = 0xf685, [0x98df] = 0xf686,
  [0x98e0] = 0xf687, [0x98e1] = 0xf688, [0x98e2] = 0xf689, [0x98e3] = 0xf68a,
  [0x98e4] = 0xf68b, [0x98e5] = 0xf68c, [0x98e6] = 0xf68d, [0x98e7] = 0xf68e,
  [0x98e8] = 0xf68f, [0x98e9] = 0xf690, [0x98ea] = 0xf691, [0x98eb] = 0xf692,
  [0x98ec] = 0xf693, [0x98ed] = 0xf694, [0x98ee] = 0xf695, [0x98ef] = 0xf696,
  [0x98f0] = 0xf697, [0x98f1] = 0xf698, [0x98f2] = 0xf699, [0x98f3] = 0xf69a,
  [0x98f4] = 0xf69b, [0x98f5] = 0xf69c, [0x98f6] = 0xf69d, [0x98f7] = 0xf69e,
  [0x98f8] = 0xf69f, [0x98f9] = 0xf6a0, [0x98fa] = 0xf6a1, [0x98fb] = 0xf6a2,
  [0x98fc] = 0xf6a3, [0x98fd] = 0xf6a4, [0x98fe] = 0xf6a5, [0x98ff] = 0xf6a6,
  [0x9900] = 0xf6a7, [0x9901] = 0xf6a8, [0x9902] = 0xf6a9, [0x9903] = 0xf6aa,
  [0x9904] = 0xf6ab, [0x9905] = 0xf6ac, [0x9906] = 0xf6ad, [0x9907] = 0xf6ae,
  [0x9908] = 0xf6af, [0x9909] = 0xf6b0, [0x990a] = 0xf6b1, [0x990b] = 0xf6b2,
  [0x990c] = 0xf6b3, [0x990d] = 0xf6b4, [0x990e] = 0xf6b5, [0x990f] = 0xf6b6,
  [0x9910] = 0xf6b7, [0x9911] = 0xf6b8, [0x9912] = 0xf6b9, [0x9913] = 0xf6ba,
  [0x9914] = 0xf6bb, [0x9915] = 0xf6bc, [0x9916] = 0xf6bd, [0x9917] = 0xf6be,
  [0x9918] = 0xf6bf, [0x9919] = 0xf6c0, [0x991a] = 0xf6c1, [0x991b] = 0xf6c2,
  [0x991c] = 0xf6c3, [0x991d] = 0xf6c4, [0x991e] = 0xf6c5, [0x991f] = 0xf6c6,
  [0x9920] = 0xf6c7, [0x9921] = 0xf6c8, [0x9922] = 0xf6c9, [0x9923] = 0xf6ca,
  [0x9924] = 0xf6cb, [0x9925] = 0xf6cc, [0x9926] = 0xf6cd, [0x9927] = 0xf6ce,
  [0x9928] = 0xf6cf, [0x9929] = 0xf6d0, [0x992a] = 0xf6d1, [0x992b] = 0xf6d2,
  [0x992c] = 0xf6d3, [0x992d] = 0xf6d4, [0x992e] = 0xf6d5, [0x992f] = 0xf6d6,
  [0x9930] = 0xf6d7, [0x9931] = 0xf6d8, [0x9932] = 0xf6d9, [0x9933] = 0xf6da,
  [0x9934] = 0xf6db, [0x9935] = 0xf6dc, [0x9936] = 0xf6dd, [0x9937] = 0xf6de,
  [0x9938] = 0xf6df, [0x9939] = 0xf6e0, [0x993a] = 0xf6e1, [0x993b] = 0xf6e2,
  [0x993c] = 0xf6e3, [0x993d] = 0xf6e4, [0x993e] = 0xf6e5, [0x993f] = 0xf6e6,
  [0x9940] = 0xf6e7, [0x9941] = 0xf6e8, [0x9942] = 0xf6e9, [0x9943] = 0xf6ea,
  [0x9944] = 0xf6eb, [0x9945] = 0xf6ec, [0x9946] = 0xf6ed, [0x9947] = 0xf6ee,
  [0x9948] = 0xf6ef, [0x9949] = 0xf6f0, [0x994a] = 0xf6f1, [0x994b] = 0xf6f2,
  [0x994c] = 0xf6f3, [0x994d] = 0xf6f4, [0x994e] = 0xf6f5, [0x994f] = 0xf6f6,
  [0x9950] = 0xf6f7, [0x9951] = 0xf6f8, [0x9952] = 0xf6f9, [0x9953] = 0xf6fa,
  [0x9954] = 0xf6fb, [0x9955] = 0xf6fc, [0x9956] = 0xf6fd, [0x9957] = 0xf6fe,
  [0x9958] = 0xf6ff, [0x9959] = 0xf700, [0x995a] = 0xf701, [0x995b] = 0xf702,
  [0x995c] = 0xf703, [0x995d] = 0xf704, [0x995e] = 0xf705, [0x995f] = 0xf706,
  [0x9960] = 0xf707, [0x9961] = 0xf708, [0x9962] = 0xf709, [0x9963] = 0xf70a,
  [0x9964] = 0xf70b, [0x9965] = 0xf70c, [0x9966] = 0xf70d, [0x9967] = 0xf70e,
  [0x9968] = 0xf70f, [0x9969] = 0xf710, [0x996a] = 0xf711, [0x996b] = 0xf712,
  [0x996c] = 0xf713, [0x996d] = 0xf714, [0x996e] = 0xf715, [0x996f] = 0xf716,
  [0x9970] = 0xf717, [0x9971] = 0xf718, [0x9972] = 0xf719, [0x9973] = 0xf71a,
  [0x9974] = 0xf71b, [0x9975] = 0xf71c, [0x9976] = 0xf71d, [0x9977] = 0xf71e,
  [0x9978] = 0xf71f, [0x9979] = 0xf720, [0x997a] = 0xf721, [0x997b] = 0xf722,
  [0x997c] = 0xf723, [0x997d] = 0xf724, [0x997e] = 0xf725, [0x997f] = 0xf726,
  [0x9980] = 0xf727, [0x9981] = 0xf728, [0x9982] = 0xf729, [0x9983] = 0xf72a,
  [0x9984] = 0xf72b, [0x9985] = 0xf72c, [0x9986] = 0xf72d, [0x9987] = 0xf72e,
  [0x9988] = 0xf72f, [0x9989] = 0xf730, [0x998a] = 0xf731, [0x998b] = 0xf732,
  [0x998c] = 0xf733, [0x998d] = 0xf734, [0x998e] = 0xf735, [0x998f] = 0xf736,
  [0x9990] = 0xf737, [0x9991] = 0xf738, [0x9992] = 0xf739, [0x9993] = 0xf73a,
  [0x9994] = 0xf73b, [0x9995] = 0xf73c, [0x9996] = 0xf73d, [0x9997] = 0xf73e,
  [0x9998] = 0xf73f, [0x9999] = 0xf740, [0x999a] = 0xf741, [0x999b] = 0xf742,
  [0x999c] = 0xf743, [0x999d] = 0xf744, [0x999e] = 0xf745, [0x999f] = 0xf746,
  [0x99a0] = 0xf747, [0x99a1] = 0xf748, [0x99a2] = 0xf749, [0x99a3] = 0xf74a,
  [0x99a4] = 0xf74b, [0x99a5] = 0xf74c, [0x99a6] = 0xf74d, [0x99a7] = 0xf74e,
  [0x99a8] = 0xf74f, [0x99a9] = 0xf750, [0x99aa] = 0xf751, [0x99ab] = 0xf752,
  [0x99ac] = 0xf753, [0x99ad] = 0xf754, [0x99ae] = 0xf755, [0x99af] = 0xf756,
  [0x99b0] = 0xf757, [0x99b1] = 0xf758, [0x99b2] = 0xf759, [0x99b3] = 0xf75a,
  [0x99b4] = 0xf75b, [0x99b5] = 0xf75c, [0x99b6] = 0xf75d, [0x99b7] = 0xf75e,
  [0x99b8] = 0xf75f, [0x99b9] = 0xf760, [0x99ba] = 0xf761, [0x99bb] = 0xf762,
  [0x99bc] = 0xf763, [0x99bd] = 0xf764, [0x99be] = 0xf765, [0x99bf] = 0xf766,
  [0x99c0] = 0xf767, [0x99c1] = 0xf768, [0x99c2] = 0xf769, [0x99c3] = 0xf76a,
  [0x99c4] = 0xf76b, [0x99c5] = 0xf76c, [0x99c6] = 0xf76d, [0x99c7] = 0xf76e,
  [0x99c8] = 0xf76f, [0x99c9] = 0xf770, [0x99ca] = 0xf771, [0x99cb] = 0xf772,
  [0x99cc] = 0xf773, [0x99cd] = 0xf774, [0x99ce] = 0xf775, [0x99cf] = 0xf776,
  [0x99d0] = 0xf777, [0x99d1] = 0xf778, [0x99d2] = 0xf779, [0x99d3] = 0xf77a,
  [0x99d4] = 0xf77b, [0x99d5] = 0xf77c, [0x99d6] = 0xf77d, [0x99d7] = 0xf77e,
  [0x99d8] = 0xf77f, [0x99d9] = 0xf780, [0x99da] = 0xf781, [0x99db] = 0xf782,
  [0x99dc] = 0xf783, [0x99dd] = 0xf784, [0x99de] = 0xf785, [0x99df] = 0xf786,
  [0x99e0] = 0xf787, [0x99e1] = 0xf788, [0x99e2] = 0xf789, [0x99e3] = 0xf78a,
  [0x99e4] = 0xf78b, [0x99e5] = 0xf78c, [0x99e6] = 0xf78d, [0x99e7] = 0xf78e,
  [0x99e8] = 0xf78f, [0x99e9] = 0xf790, [0x99ea] = 0xf791, [0x99eb] = 0xf792,
  [0x99ec] = 0xf793, [0x99ed] = 0xf794, [0x99ee] = 0xf795, [0x99ef] = 0xf796,
  [0x99f0] = 0xf797, [0x99f1] = 0xf798, [0x99f2] = 0xf799, [0x99f3] = 0xf79a,
  [0x99f4] = 0xf79b, [0x99f5] = 0xf79c, [0x99f6] = 0xf79d, [0x99f7] = 0xf79e,
  [0x99f8] = 0xf79f, [0x99f9] = 0xf7a0, [0x99fa] = 0xf7a1, [0x99fb] = 0xf7a2,
  [0x99fc] = 0xf7a3, [0x99fd] = 0xf7a4, [0x99fe] = 0xf7a5, [0x99ff] = 0xf7a6,
  [0x9a00] = 0xf7a7, [0x9a01] = 0xf7a8, [0x9a02] = 0xf7a9, [0x9a03] = 0xf7aa,
  [0x9a04] = 0xf7ab, [0x9a05] = 0xf7ac, [0x9a06] = 0xf7ad, [0x9a07] = 0xf7ae,
  [0x9a08] = 0xf7af, [0x9a09] = 0xf7b0, [0x9a0a] = 0xf7b1, [0x9a0b] = 0xf7b2,
  [0x9a0c] = 0xf7b3, [0x9a0d] = 0xf7b4, [0x9a0e] = 0xf7b5, [0x9a0f] = 0xf7b6,
  [0x9a10] = 0xf7b7, [0x9a11] = 0xf7b8, [0x9a12] = 0xf7b9, [0x9a13] = 0xf7ba,
  [0x9a14] = 0xf7bb, [0x9a15] = 0xf7bc, [0x9a16] = 0xf7bd, [0x9a17] = 0xf7be,
  [0x9a18] = 0xf7bf, [0x9a19] = 0xf7c0, [0x9a1a] = 0xf7c1, [0x9a1b] = 0xf7c2,
  [0x9a1c] = 0xf7c3, [0x9a1d] = 0xf7c4, [0x9a1e] = 0xf7c5, [0x9a1f] = 0xf7c6,
  [0x9a20] = 0xf7c7, [0x9a21] = 0xf7c8, [0x9a22] = 0xf7c9, [0x9a23] = 0xf7ca,
  [0x9a24] = 0xf7cb, [0x9a25] = 0xf7cc, [0x9a26] = 0xf7cd, [0x9a27] = 0xf7ce,
  [0x9a28] = 0xf7cf, [0x9a29] = 0xf7d0, [0x9a2a] = 0xf7d1, [0x9a2b] = 0xf7d2,
  [0x9a2c] = 0xf7d3, [0x9a2d] = 0xf7d4, [0x9a2e] = 0xf7d5, [0x9a2f] = 0xf7d6,
  [0x9a30] = 0xf7d7, [0x9a31] = 0xf7d8, [0x9a32] = 0xf7d9, [0x9a33] = 0xf7da,
  [0x9a34] = 0xf7db, [0x9a35] = 0xf7dc, [0x9a36] = 0xf7dd, [0x9a37] = 0xf7de,
  [0x9a38] = 0xf7df, [0x9a39] = 0xf7e0, [0x9a3a] = 0xf7e1, [0x9a3b] = 0xf7e2,
  [0x9a3c] = 0xf7e3, [0x9a3d] = 0xf7e4, [0x9a3e] = 0xf7e5, [0x9a3f] = 0xf7e6,
  [0x9a40] = 0xf7e7, [0x9a41] = 0xf7e8, [0x9a42] = 0xf7e9, [0x9a43] = 0xf7ea,
  [0x9a44] = 0xf7eb, [0x9a45] = 0xf7ec, [0x9a46] = 0xf7ed, [0x9a47] = 0xf7ee,
  [0x9a48] = 0xf7ef, [0x9a49] = 0xf7f0, [0x9a4a] = 0xf7f1, [0x9a4b] = 0xf7f2,
  [0x9a4c] = 0xf7f3, [0x9a4d] = 0xf7f4, [0x9a4e] = 0xf7f5, [0x9a4f] = 0xf7f6,
  [0x9a50] = 0xf7f7, [0x9a51] = 0xf7f8, [0x9a52] = 0xf7f9, [0x9a53] = 0xf7fa,
  [0x9a54] = 0xf7fb, [0x9a55] = 0xf7fc, [0x9a56] = 0xf7fd, [0x9a57] = 0xf7fe,
  [0x9a58] = 0xf7ff, [0x9a59] = 0xf800, [0x9a5a] = 0xf801, [0x9a5b] = 0xf802,
  [0x9a5c] = 0xf803, [0x9a5d] = 0xf804, [0x9a5e] = 0xf805, [0x9a5f] = 0xf806,
  [0x9a60] = 0xf807, [0x9a61] = 0xf808, [0x9a62] = 0xf809, [0x9a63] = 0xf80a,
  [0x9a64] = 0xf80b, [0x9a65] = 0xf80c, [0x9a66] = 0xf80d, [0x9a67] = 0xf80e,
  [0x9a68] = 0xf80f, [0x9a69] = 0xf810, [0x9a6a] = 0xf811, [0x9a6b] = 0xf812,
  [0x9a6c] = 0xf813, [0x9a6d] = 0xf814, [0x9a6e] = 0xf815, [0x9a6f] = 0xf816,
  [0x9a70] = 0xf817, [0x9a71] = 0xf818, [0x9a72] = 0xf819, [0x9a73] = 0xf81a,
  [0x9a74] = 0xf81b, [0x9a75] = 0xf81c, [0x9a76] = 0xf81d, [0x9a77] = 0xf81e,
  [0x9a78] = 0xf81f, [0x9a79] = 0xf820, [0x9a7a] = 0xf821, [0x9a7b] = 0xf822,
  [0x9a7c] = 0xf823, [0x9a7d] = 0xf824, [0x9a7e] = 0xf825, [0x9a7f] = 0xf826,
  [0x9a80] = 0xf827, [0x9a81] = 0xf828, [0x9a82] = 0xf829, [0x9a83] = 0xf82a,
  [0x9a84] = 0xf82b, [0x9a85] = 0xf82c, [0x9a86] = 0xf82d, [0x9a87] = 0xf82e,
  [0x9a88] = 0xf82f, [0x9a89] = 0xf830, [0x9a8a] = 0xf831, [0x9a8b] = 0xf832,
  [0x9a8c] = 0xf833, [0x9a8d] = 0xf834, [0x9a8e] = 0xf835, [0x9a8f] = 0xf836,
  [0x9a90] = 0xf837, [0x9a91] = 0xf838, [0x9a92] = 0xf839, [0x9a93] = 0xf83a,
  [0x9a94] = 0xf83b, [0x9a95] = 0xf83c, [0x9a96] = 0xf83d, [0x9a97] = 0xf83e,
  [0x9a98] = 0xf83f, [0x9a99] = 0xf840, [0x9a9a] = 0xf841, [0x9a9b] = 0xf842,
  [0x9a9c] = 0xf843, [0x9a9d] = 0xf844, [0x9a9e] = 0xf845, [0x9a9f] = 0xf846,
  [0x9aa0] = 0xf847, [0x9aa1] = 0xf848, [0x9aa2] = 0xf849, [0x9aa3] = 0xf84a,
  [0x9aa4] = 0xf84b, [0x9aa5] = 0xf84c, [0x9aa6] = 0xf84d, [0x9aa7] = 0xf84e,
  [0x9aa8] = 0xf84f, [0x9aa9] = 0xf850, [0x9aaa] = 0xf851, [0x9aab] = 0xf852,
  [0x9aac] = 0xf853, [0x9aad] = 0xf854, [0x9aae] = 0xf855, [0x9aaf] = 0xf856,
  [0x9ab0] = 0xf857, [0x9ab1] = 0xf858, [0x9ab2] = 0xf859, [0x9ab3] = 0xf85a,
  [0x9ab4] = 0xf85b, [0x9ab5] = 0xf85c, [0x9ab6] = 0xf85d, [0x9ab7] = 0xf85e,
  [0x9ab8] = 0xf85f, [0x9ab9] = 0xf860, [0x9aba] = 0xf861, [0x9abb] = 0xf862,
  [0x9abc] = 0xf863, [0x9abd] = 0xf864, [0x9abe] = 0xf865, [0x9abf] = 0xf866,
  [0x9ac0] = 0xf867, [0x9ac1] = 0xf868, [0x9ac2] = 0xf869, [0x9ac3] = 0xf86a,
  [0x9ac4] = 0xf86b, [0x9ac5] = 0xf86c, [0x9ac6] = 0xf86d, [0x9ac7] = 0xf86e,
  [0x9ac8] = 0xf86f, [0x9ac9] = 0xf870, [0x9aca] = 0xf871, [0x9acb] = 0xf872,
  [0x9acc] = 0xf873, [0x9acd] = 0xf874, [0x9ace] = 0xf875, [0x9acf] = 0xf876,
  [0x9ad0] = 0xf877, [0x9ad1] = 0xf878, [0x9ad2] = 0xf879, [0x9ad3] = 0xf87a,
  [0x9ad4] = 0xf87b, [0x9ad5] = 0xf87c, [0x9ad6] = 0xf87d, [0x9ad7] = 0xf87e,
  [0x9ad8] = 0xf87f, [0x9ad9] = 0xf880, [0x9ada] = 0xf881, [0x9adb] = 0xf882,
  [0x9adc] = 0xf883, [0x9add] = 0xf884, [0x9ade] = 0xf885, [0x9adf] = 0xf886,
  [0x9ae0] = 0xf887, [0x9ae1] = 0xf888, [0x9ae2] = 0xf889, [0x9ae3] = 0xf88a,
  [0x9ae4] = 0xf88b, [0x9ae5] = 0xf88c, [0x9ae6] = 0xf88d, [0x9ae7] = 0xf88e,
  [0x9ae8] = 0xf88f, [0x9ae9] = 0xf890, [0x9aea] = 0xf891, [0x9aeb] = 0xf892,
  [0x9aec] = 0xf893, [0x9aed] = 0xf894, [0x9aee] = 0xf895, [0x9aef] = 0xf896,
  [0x9af0] = 0xf897, [0x9af1] = 0xf898, [0x9af2] = 0xf899, [0x9af3] = 0xf89a,
  [0x9af4] = 0xf89b, [0x9af5] = 0xf89c, [0x9af6] = 0xf89d, [0x9af7] = 0xf89e,
  [0x9af8] = 0xf89f, [0x9af9] = 0xf8a0, [0x9afa] = 0xf8a1, [0x9afb] = 0xf8a2,
  [0x9afc] = 0xf8a3, [0x9afd] = 0xf8a4, [0x9afe] = 0xf8a5, [0x9aff] = 0xf8a6,
  [0x9b00] = 0xf8a7, [0x9b01] = 0xf8a8, [0x9b02] = 0xf8a9, [0x9b03] = 0xf8aa,
  [0x9b04] = 0xf8ab, [0x9b05] = 0xf8ac, [0x9b06] = 0xf8ad, [0x9b07] = 0xf8ae,
  [0x9b08] = 0xf8af, [0x9b09] = 0xf8b0, [0x9b0a] = 0xf8b1, [0x9b0b] = 0xf8b2,
  [0x9b0c] = 0xf8b3, [0x9b0d] = 0xf8b4, [0x9b0e] = 0xf8b5, [0x9b0f] = 0xf8b6,
  [0x9b10] = 0xf8b7, [0x9b11] = 0xf8b8, [0x9b12] = 0xf8b9, [0x9b13] = 0xf8ba,
  [0x9b14] = 0xf8bb, [0x9b15] = 0xf8bc, [0x9b16] = 0xf8bd, [0x9b17] = 0xf8be,
  [0x9b18] = 0xf8bf, [0x9b19] = 0xf8c0, [0x9b1a] = 0xf8c1, [0x9b1b] = 0xf8c2,
  [0x9b1c] = 0xf8c3, [0x9b1d] = 0xf8c4, [0x9b1e] = 0xf8c5, [0x9b1f] = 0xf8c6,
  [0x9b20] = 0xf8c7, [0x9b21] = 0xf8c8, [0x9b22] = 0xf8c9, [0x9b23] = 0xf8ca,
  [0x9b24] = 0xf8cb, [0x9b25] = 0xf8cc, [0x9b26] = 0xf8cd, [0x9b27] = 0xf8ce,
  [0x9b28] = 0xf8cf, [0x9b29] = 0xf8d0, [0x9b2a] = 0xf8d1, [0x9b2b] = 0xf8d2,
  [0x9b2c] = 0xf8d3, [0x9b2d] = 0xf8d4, [0x9b2e] = 0xf8d5, [0x9b2f] = 0xf8d6,
  [0x9b30] = 0xf8d7, [0x9b31] = 0xf8d8, [0x9b32] = 0xf8d9, [0x9b33] = 0xf8da,
  [0x9b34] = 0xf8db, [0x9b35] = 0xf8dc, [0x9b36] = 0xf8dd, [0x9b37] = 0xf8de,
  [0x9b38] = 0xf8df, [0x9b39] = 0xf8e0, [0x9b3a] = 0xf8e1, [0x9b3b] = 0xf8e2,
  [0x9b3c] = 0xf8e3, [0x9b3d] = 0xf8e4, [0x9b3e] = 0xf8e5, [0x9b3f] = 0xf8e6,
  [0x9b40] = 0xf8e7, [0x9b41] = 0xf8e8, [0x9b42] = 0xf8e9, [0x9b43] = 0xf8ea,
  [0x9b44] = 0xf8eb, [0x9b45] = 0xf8ec, [0x9b46] = 0xf8ed, [0x9b47] = 0xf8ee,
  [0x9b48] = 0xf8ef, [0x9b49] = 0xf8f0, [0x9b4a] = 0xf8f1, [0x9b4b] = 0xf8f2,
  [0x9b4c] = 0xf8f3, [0x9b4d] = 0xf8f4, [0x9b4e] = 0xf8f5, [0x9b4f] = 0xf8f6,
  [0x9b50] = 0xf8f7, [0x9b51] = 0xf8f8, [0x9b52] = 0xf8f9, [0x9b53] = 0xf8fa,
  [0x9b54] = 0xf8fb, [0x9b55] = 0xf8fc, [0x9b56] = 0xf8fd, [0x9b57] = 0xf8fe,
  [0x9b58] = 0xf8ff,
#endif
  [0x9b59] = 0xf900, [0x9b5a] = 0xf901, [0x9b5b] = 0xf902,
  [0x9b5c] = 0xf903, [0x9b5d] = 0xf904, [0x9b5e] = 0xf905, [0x9b5f] = 0xf906,
  [0x9b60] = 0xf907, [0x9b61] = 0xf908, [0x9b62] = 0xf909, [0x9b63] = 0xf90a,
  [0x9b64] = 0xf90b, [0x9b65] = 0xf90c, [0x9b66] = 0xf90d, [0x9b67] = 0xf90e,
  [0x9b68] = 0xf90f, [0x9b69] = 0xf910, [0x9b6a] = 0xf911, [0x9b6b] = 0xf912,
  [0x9b6c] = 0xf913, [0x9b6d] = 0xf914, [0x9b6e] = 0xf915, [0x9b6f] = 0xf916,
  [0x9b70] = 0xf917, [0x9b71] = 0xf918, [0x9b72] = 0xf919, [0x9b73] = 0xf91a,
  [0x9b74] = 0xf91b, [0x9b75] = 0xf91c, [0x9b76] = 0xf91d, [0x9b77] = 0xf91e,
  [0x9b78] = 0xf91f, [0x9b79] = 0xf920, [0x9b7a] = 0xf921, [0x9b7b] = 0xf922,
  [0x9b7c] = 0xf923, [0x9b7d] = 0xf924, [0x9b7e] = 0xf925, [0x9b7f] = 0xf926,
  [0x9b80] = 0xf927, [0x9b81] = 0xf928, [0x9b82] = 0xf929, [0x9b83] = 0xf92a,
  [0x9b84] = 0xf92b, [0x9b85] = 0xf92d, [0x9b86] = 0xf92e, [0x9b87] = 0xf92f,
  [0x9b88] = 0xf930, [0x9b89] = 0xf931, [0x9b8a] = 0xf932, [0x9b8b] = 0xf933,
  [0x9b8c] = 0xf934, [0x9b8d] = 0xf935, [0x9b8e] = 0xf936, [0x9b8f] = 0xf937,
  [0x9b90] = 0xf938, [0x9b91] = 0xf939, [0x9b92] = 0xf93a, [0x9b93] = 0xf93b,
  [0x9b94] = 0xf93c, [0x9b95] = 0xf93d, [0x9b96] = 0xf93e, [0x9b97] = 0xf93f,
  [0x9b98] = 0xf940, [0x9b99] = 0xf941, [0x9b9a] = 0xf942, [0x9b9b] = 0xf943,
  [0x9b9c] = 0xf944, [0x9b9d] = 0xf945, [0x9b9e] = 0xf946, [0x9b9f] = 0xf947,
  [0x9ba0] = 0xf948, [0x9ba1] = 0xf949, [0x9ba2] = 0xf94a, [0x9ba3] = 0xf94b,
  [0x9ba4] = 0xf94c, [0x9ba5] = 0xf94d, [0x9ba6] = 0xf94e, [0x9ba7] = 0xf94f,
  [0x9ba8] = 0xf950, [0x9ba9] = 0xf951, [0x9baa] = 0xf952, [0x9bab] = 0xf953,
  [0x9bac] = 0xf954, [0x9bad] = 0xf955, [0x9bae] = 0xf956, [0x9baf] = 0xf957,
  [0x9bb0] = 0xf958, [0x9bb1] = 0xf959, [0x9bb2] = 0xf95a, [0x9bb3] = 0xf95b,
  [0x9bb4] = 0xf95c, [0x9bb5] = 0xf95d, [0x9bb6] = 0xf95e, [0x9bb7] = 0xf95f,
  [0x9bb8] = 0xf960, [0x9bb9] = 0xf961, [0x9bba] = 0xf962, [0x9bbb] = 0xf963,
  [0x9bbc] = 0xf964, [0x9bbd] = 0xf965, [0x9bbe] = 0xf966, [0x9bbf] = 0xf967,
  [0x9bc0] = 0xf968, [0x9bc1] = 0xf969, [0x9bc2] = 0xf96a, [0x9bc3] = 0xf96b,
  [0x9bc4] = 0xf96c, [0x9bc5] = 0xf96d, [0x9bc6] = 0xf96e, [0x9bc7] = 0xf96f,
  [0x9bc8] = 0xf970, [0x9bc9] = 0xf971, [0x9bca] = 0xf972, [0x9bcb] = 0xf973,
  [0x9bcc] = 0xf974, [0x9bcd] = 0xf975, [0x9bce] = 0xf976, [0x9bcf] = 0xf977,
  [0x9bd0] = 0xf978, [0x9bd1] = 0xf97a, [0x9bd2] = 0xf97b, [0x9bd3] = 0xf97c,
  [0x9bd4] = 0xf97d, [0x9bd5] = 0xf97e, [0x9bd6] = 0xf97f, [0x9bd7] = 0xf980,
  [0x9bd8] = 0xf981, [0x9bd9] = 0xf982, [0x9bda] = 0xf983, [0x9bdb] = 0xf984,
  [0x9bdc] = 0xf985, [0x9bdd] = 0xf986, [0x9bde] = 0xf987, [0x9bdf] = 0xf988,
  [0x9be0] = 0xf989, [0x9be1] = 0xf98a, [0x9be2] = 0xf98b, [0x9be3] = 0xf98c,
  [0x9be4] = 0xf98d, [0x9be5] = 0xf98e, [0x9be6] = 0xf98f, [0x9be7] = 0xf990,
  [0x9be8] = 0xf991, [0x9be9] = 0xf992, [0x9bea] = 0xf993, [0x9beb] = 0xf994,
  [0x9bec] = 0xf996, [0x9bed] = 0xf997, [0x9bee] = 0xf998, [0x9bef] = 0xf999,
  [0x9bf0] = 0xf99a, [0x9bf1] = 0xf99b, [0x9bf2] = 0xf99c, [0x9bf3] = 0xf99d,
  [0x9bf4] = 0xf99e, [0x9bf5] = 0xf99f, [0x9bf6] = 0xf9a0, [0x9bf7] = 0xf9a1,
  [0x9bf8] = 0xf9a2, [0x9bf9] = 0xf9a3, [0x9bfa] = 0xf9a4, [0x9bfb] = 0xf9a5,
  [0x9bfc] = 0xf9a6, [0x9bfd] = 0xf9a7, [0x9bfe] = 0xf9a8, [0x9bff] = 0xf9a9,
  [0x9c00] = 0xf9aa, [0x9c01] = 0xf9ab, [0x9c02] = 0xf9ac, [0x9c03] = 0xf9ad,
  [0x9c04] = 0xf9ae, [0x9c05] = 0xf9af, [0x9c06] = 0xf9b0, [0x9c07] = 0xf9b1,
  [0x9c08] = 0xf9b2, [0x9c09] = 0xf9b3, [0x9c0a] = 0xf9b4, [0x9c0b] = 0xf9b5,
  [0x9c0c] = 0xf9b6, [0x9c0d] = 0xf9b7, [0x9c0e] = 0xf9b8, [0x9c0f] = 0xf9b9,
  [0x9c10] = 0xf9ba, [0x9c11] = 0xf9bb, [0x9c12] = 0xf9bc, [0x9c13] = 0xf9bd,
  [0x9c14] = 0xf9be, [0x9c15] = 0xf9bf, [0x9c16] = 0xf9c0, [0x9c17] = 0xf9c1,
  [0x9c18] = 0xf9c2, [0x9c19] = 0xf9c3, [0x9c1a] = 0xf9c4, [0x9c1b] = 0xf9c5,
  [0x9c1c] = 0xf9c6, [0x9c1d] = 0xf9c7, [0x9c1e] = 0xf9c8, [0x9c1f] = 0xf9c9,
  [0x9c20] = 0xf9ca, [0x9c21] = 0xf9cb, [0x9c22] = 0xf9cc, [0x9c23] = 0xf9cd,
  [0x9c24] = 0xf9ce, [0x9c25] = 0xf9cf, [0x9c26] = 0xf9d0, [0x9c27] = 0xf9d1,
  [0x9c28] = 0xf9d2, [0x9c29] = 0xf9d3, [0x9c2a] = 0xf9d4, [0x9c2b] = 0xf9d5,
  [0x9c2c] = 0xf9d6, [0x9c2d] = 0xf9d7, [0x9c2e] = 0xf9d8, [0x9c2f] = 0xf9d9,
  [0x9c30] = 0xf9da, [0x9c31] = 0xf9db, [0x9c32] = 0xf9dc, [0x9c33] = 0xf9dd,
  [0x9c34] = 0xf9de, [0x9c35] = 0xf9df, [0x9c36] = 0xf9e0, [0x9c37] = 0xf9e1,
  [0x9c38] = 0xf9e2, [0x9c39] = 0xf9e3, [0x9c3a] = 0xf9e4, [0x9c3b] = 0xf9e5,
  [0x9c3c] = 0xf9e6, [0x9c3d] = 0xf9e8, [0x9c3e] = 0xf9e9, [0x9c3f] = 0xf9ea,
  [0x9c40] = 0xf9eb, [0x9c41] = 0xf9ec, [0x9c42] = 0xf9ed, [0x9c43] = 0xf9ee,
  [0x9c44] = 0xf9ef, [0x9c45] = 0xf9f0, [0x9c46] = 0xf9f2, [0x9c47] = 0xf9f3,
  [0x9c48] = 0xf9f4, [0x9c49] = 0xf9f5, [0x9c4a] = 0xf9f6, [0x9c4b] = 0xf9f7,
  [0x9c4c] = 0xf9f8, [0x9c4d] = 0xf9f9, [0x9c4e] = 0xf9fa, [0x9c4f] = 0xf9fb,
  [0x9c50] = 0xf9fc, [0x9c51] = 0xf9fd, [0x9c52] = 0xf9fe, [0x9c53] = 0xf9ff,
  [0x9c54] = 0xfa00, [0x9c55] = 0xfa01, [0x9c56] = 0xfa02, [0x9c57] = 0xfa03,
  [0x9c58] = 0xfa04, [0x9c59] = 0xfa05, [0x9c5a] = 0xfa06, [0x9c5b] = 0xfa07,
  [0x9c5c] = 0xfa08, [0x9c5d] = 0xfa09, [0x9c5e] = 0xfa0a, [0x9c5f] = 0xfa0b,
  [0x9c60] = 0xfa10, [0x9c61] = 0xfa12, [0x9c62] = 0xfa15, [0x9c63] = 0xfa16,
  [0x9c64] = 0xfa17, [0x9c65] = 0xfa19, [0x9c66] = 0xfa1a, [0x9c67] = 0xfa1b,
  [0x9c68] = 0xfa1c, [0x9c69] = 0xfa1d, [0x9c6a] = 0xfa1e, [0x9c6b] = 0xfa22,
  [0x9c6c] = 0xfa25, [0x9c6d] = 0xfa26, [0x9c6e] = 0xfa2a, [0x9c6f] = 0xfa2b,
  [0x9c70] = 0xfa2c, [0x9c71] = 0xfa2d,
  [0x9d44] = 0xfb00, [0x9d45] = 0xfb01, [0x9d46] = 0xfb02, [0x9d47] = 0xfb03,
  [0x9d48] = 0xfb04, [0x9d49] = 0xfb05, [0x9d4a] = 0xfb06, [0x9d57] = 0xfb13,
  [0x9d58] = 0xfb14, [0x9d59] = 0xfb15, [0x9d5a] = 0xfb16, [0x9d5b] = 0xfb17,
  [0x9d61] = 0xfb1d, [0x9d62] = 0xfb1e, [0x9d63] = 0xfb1f,
  [0x9d64] = 0xfb20, [0x9d65] = 0xfb21, [0x9d66] = 0xfb22, [0x9d67] = 0xfb23,
  [0x9d68] = 0xfb24, [0x9d69] = 0xfb25, [0x9d6a] = 0xfb26, [0x9d6b] = 0xfb27,
  [0x9d6c] = 0xfb28, [0x9d6d] = 0xfb29, [0x9d6e] = 0xfb2a, [0x9d6f] = 0xfb2b,
  [0x9d70] = 0xfb2c, [0x9d71] = 0xfb2d, [0x9d72] = 0xfb2e, [0x9d73] = 0xfb2f,
  [0x9d74] = 0xfb30, [0x9d75] = 0xfb31, [0x9d76] = 0xfb32, [0x9d77] = 0xfb33,
  [0x9d78] = 0xfb34, [0x9d79] = 0xfb35, [0x9d7a] = 0xfb36,
  [0x9d7c] = 0xfb38, [0x9d7d] = 0xfb39, [0x9d7e] = 0xfb3a, [0x9d7f] = 0xfb3b,
  [0x9d80] = 0xfb3c, [0x9d82] = 0xfb3e,
  [0x9d84] = 0xfb40, [0x9d85] = 0xfb41, [0x9d87] = 0xfb43,
  [0x9d88] = 0xfb44, [0x9d8a] = 0xfb46, [0x9d8b] = 0xfb47,
  [0x9d8c] = 0xfb48, [0x9d8d] = 0xfb49, [0x9d8e] = 0xfb4a, [0x9d8f] = 0xfb4b,
  [0x9d90] = 0xfb4c, [0x9d91] = 0xfb4d, [0x9d92] = 0xfb4e, [0x9d93] = 0xfb4f,
  [0x9d94] = 0xfb50, [0x9d95] = 0xfb51, [0x9d96] = 0xfb52, [0x9d97] = 0xfb53,
  [0x9d98] = 0xfb54, [0x9d99] = 0xfb55, [0x9d9a] = 0xfb56, [0x9d9b] = 0xfb57,
  [0x9d9c] = 0xfb58, [0x9d9d] = 0xfb59, [0x9d9e] = 0xfb5a, [0x9d9f] = 0xfb5b,
  [0x9da0] = 0xfb5c, [0x9da1] = 0xfb5d, [0x9da2] = 0xfb5e, [0x9da3] = 0xfb5f,
  [0x9da4] = 0xfb60, [0x9da5] = 0xfb61, [0x9da6] = 0xfb62, [0x9da7] = 0xfb63,
  [0x9da8] = 0xfb64, [0x9da9] = 0xfb65, [0x9daa] = 0xfb66, [0x9dab] = 0xfb67,
  [0x9dac] = 0xfb68, [0x9dad] = 0xfb69, [0x9dae] = 0xfb6a, [0x9daf] = 0xfb6b,
  [0x9db0] = 0xfb6c, [0x9db1] = 0xfb6d, [0x9db2] = 0xfb6e, [0x9db3] = 0xfb6f,
  [0x9db4] = 0xfb70, [0x9db5] = 0xfb71, [0x9db6] = 0xfb72, [0x9db7] = 0xfb73,
  [0x9db8] = 0xfb74, [0x9db9] = 0xfb75, [0x9dba] = 0xfb76, [0x9dbb] = 0xfb77,
  [0x9dbc] = 0xfb78, [0x9dbd] = 0xfb79, [0x9dbe] = 0xfb7a, [0x9dbf] = 0xfb7b,
  [0x9dc0] = 0xfb7c, [0x9dc1] = 0xfb7d, [0x9dc2] = 0xfb7e, [0x9dc3] = 0xfb7f,
  [0x9dc4] = 0xfb80, [0x9dc5] = 0xfb81, [0x9dc6] = 0xfb82, [0x9dc7] = 0xfb83,
  [0x9dc8] = 0xfb84, [0x9dc9] = 0xfb85, [0x9dca] = 0xfb86, [0x9dcb] = 0xfb87,
  [0x9dcc] = 0xfb88, [0x9dcd] = 0xfb89, [0x9dce] = 0xfb8a, [0x9dcf] = 0xfb8b,
  [0x9dd0] = 0xfb8c, [0x9dd1] = 0xfb8d, [0x9dd2] = 0xfb8e, [0x9dd3] = 0xfb8f,
  [0x9dd4] = 0xfb90, [0x9dd5] = 0xfb91, [0x9dd6] = 0xfb92, [0x9dd7] = 0xfb93,
  [0x9dd8] = 0xfb94, [0x9dd9] = 0xfb95, [0x9dda] = 0xfb96, [0x9ddb] = 0xfb97,
  [0x9ddc] = 0xfb98, [0x9ddd] = 0xfb99, [0x9dde] = 0xfb9a, [0x9ddf] = 0xfb9b,
  [0x9de0] = 0xfb9c, [0x9de1] = 0xfb9d, [0x9de2] = 0xfb9e, [0x9de3] = 0xfb9f,
  [0x9de4] = 0xfba0, [0x9de5] = 0xfba1, [0x9de6] = 0xfba2, [0x9de7] = 0xfba3,
  [0x9de8] = 0xfba4, [0x9de9] = 0xfba5, [0x9dea] = 0xfba6, [0x9deb] = 0xfba7,
  [0x9dec] = 0xfba8, [0x9ded] = 0xfba9, [0x9dee] = 0xfbaa, [0x9def] = 0xfbab,
  [0x9df0] = 0xfbac, [0x9df1] = 0xfbad, [0x9df2] = 0xfbae, [0x9df3] = 0xfbaf,
  [0x9df4] = 0xfbb0, [0x9df5] = 0xfbb1, [0x9e17] = 0xfbd3,
  [0x9e18] = 0xfbd4, [0x9e19] = 0xfbd5, [0x9e1a] = 0xfbd6, [0x9e1b] = 0xfbd7,
  [0x9e1c] = 0xfbd8, [0x9e1d] = 0xfbd9, [0x9e1e] = 0xfbda, [0x9e1f] = 0xfbdb,
  [0x9e20] = 0xfbdc, [0x9e21] = 0xfbdd, [0x9e22] = 0xfbde, [0x9e23] = 0xfbdf,
  [0x9e24] = 0xfbe0, [0x9e25] = 0xfbe1, [0x9e26] = 0xfbe2, [0x9e27] = 0xfbe3,
  [0x9e28] = 0xfbe4, [0x9e29] = 0xfbe5, [0x9e2a] = 0xfbe6, [0x9e2b] = 0xfbe7,
  [0x9e2c] = 0xfbe8, [0x9e2d] = 0xfbe9, [0x9e2e] = 0xfbea, [0x9e2f] = 0xfbeb,
  [0x9e30] = 0xfbec, [0x9e31] = 0xfbed, [0x9e32] = 0xfbee, [0x9e33] = 0xfbef,
  [0x9e34] = 0xfbf0, [0x9e35] = 0xfbf1, [0x9e36] = 0xfbf2, [0x9e37] = 0xfbf3,
  [0x9e38] = 0xfbf4, [0x9e39] = 0xfbf5, [0x9e3a] = 0xfbf6, [0x9e3b] = 0xfbf7,
  [0x9e3c] = 0xfbf8, [0x9e3d] = 0xfbf9, [0x9e3e] = 0xfbfa, [0x9e3f] = 0xfbfb,
  [0x9e40] = 0xfbfc, [0x9e41] = 0xfbfd, [0x9e42] = 0xfbfe, [0x9e43] = 0xfbff,
  [0x9e44] = 0xfc00, [0x9e45] = 0xfc01, [0x9e46] = 0xfc02, [0x9e47] = 0xfc03,
  [0x9e48] = 0xfc04, [0x9e49] = 0xfc05, [0x9e4a] = 0xfc06, [0x9e4b] = 0xfc07,
  [0x9e4c] = 0xfc08, [0x9e4d] = 0xfc09, [0x9e4e] = 0xfc0a, [0x9e4f] = 0xfc0b,
  [0x9e50] = 0xfc0c, [0x9e51] = 0xfc0d, [0x9e52] = 0xfc0e, [0x9e53] = 0xfc0f,
  [0x9e54] = 0xfc10, [0x9e55] = 0xfc11, [0x9e56] = 0xfc12, [0x9e57] = 0xfc13,
  [0x9e58] = 0xfc14, [0x9e59] = 0xfc15, [0x9e5a] = 0xfc16, [0x9e5b] = 0xfc17,
  [0x9e5c] = 0xfc18, [0x9e5d] = 0xfc19, [0x9e5e] = 0xfc1a, [0x9e5f] = 0xfc1b,
  [0x9e60] = 0xfc1c, [0x9e61] = 0xfc1d, [0x9e62] = 0xfc1e, [0x9e63] = 0xfc1f,
  [0x9e64] = 0xfc20, [0x9e65] = 0xfc21, [0x9e66] = 0xfc22, [0x9e67] = 0xfc23,
  [0x9e68] = 0xfc24, [0x9e69] = 0xfc25, [0x9e6a] = 0xfc26, [0x9e6b] = 0xfc27,
  [0x9e6c] = 0xfc28, [0x9e6d] = 0xfc29, [0x9e6e] = 0xfc2a, [0x9e6f] = 0xfc2b,
  [0x9e70] = 0xfc2c, [0x9e71] = 0xfc2d, [0x9e72] = 0xfc2e, [0x9e73] = 0xfc2f,
  [0x9e74] = 0xfc30, [0x9e75] = 0xfc31, [0x9e76] = 0xfc32, [0x9e77] = 0xfc33,
  [0x9e78] = 0xfc34, [0x9e79] = 0xfc35, [0x9e7a] = 0xfc36, [0x9e7b] = 0xfc37,
  [0x9e7c] = 0xfc38, [0x9e7d] = 0xfc39, [0x9e7e] = 0xfc3a, [0x9e7f] = 0xfc3b,
  [0x9e80] = 0xfc3c, [0x9e81] = 0xfc3d, [0x9e82] = 0xfc3e, [0x9e83] = 0xfc3f,
  [0x9e84] = 0xfc40, [0x9e85] = 0xfc41, [0x9e86] = 0xfc42, [0x9e87] = 0xfc43,
  [0x9e88] = 0xfc44, [0x9e89] = 0xfc45, [0x9e8a] = 0xfc46, [0x9e8b] = 0xfc47,
  [0x9e8c] = 0xfc48, [0x9e8d] = 0xfc49, [0x9e8e] = 0xfc4a, [0x9e8f] = 0xfc4b,
  [0x9e90] = 0xfc4c, [0x9e91] = 0xfc4d, [0x9e92] = 0xfc4e, [0x9e93] = 0xfc4f,
  [0x9e94] = 0xfc50, [0x9e95] = 0xfc51, [0x9e96] = 0xfc52, [0x9e97] = 0xfc53,
  [0x9e98] = 0xfc54, [0x9e99] = 0xfc55, [0x9e9a] = 0xfc56, [0x9e9b] = 0xfc57,
  [0x9e9c] = 0xfc58, [0x9e9d] = 0xfc59, [0x9e9e] = 0xfc5a, [0x9e9f] = 0xfc5b,
  [0x9ea0] = 0xfc5c, [0x9ea1] = 0xfc5d, [0x9ea2] = 0xfc5e, [0x9ea3] = 0xfc5f,
  [0x9ea4] = 0xfc60, [0x9ea5] = 0xfc61, [0x9ea6] = 0xfc62, [0x9ea7] = 0xfc63,
  [0x9ea8] = 0xfc64, [0x9ea9] = 0xfc65, [0x9eaa] = 0xfc66, [0x9eab] = 0xfc67,
  [0x9eac] = 0xfc68, [0x9ead] = 0xfc69, [0x9eae] = 0xfc6a, [0x9eaf] = 0xfc6b,
  [0x9eb0] = 0xfc6c, [0x9eb1] = 0xfc6d, [0x9eb2] = 0xfc6e, [0x9eb3] = 0xfc6f,
  [0x9eb4] = 0xfc70, [0x9eb5] = 0xfc71, [0x9eb6] = 0xfc72, [0x9eb7] = 0xfc73,
  [0x9eb8] = 0xfc74, [0x9eb9] = 0xfc75, [0x9eba] = 0xfc76, [0x9ebb] = 0xfc77,
  [0x9ebc] = 0xfc78, [0x9ebd] = 0xfc79, [0x9ebe] = 0xfc7a, [0x9ebf] = 0xfc7b,
  [0x9ec0] = 0xfc7c, [0x9ec1] = 0xfc7d, [0x9ec2] = 0xfc7e, [0x9ec3] = 0xfc7f,
  [0x9ec4] = 0xfc80, [0x9ec5] = 0xfc81, [0x9ec6] = 0xfc82, [0x9ec7] = 0xfc83,
  [0x9ec8] = 0xfc84, [0x9ec9] = 0xfc85, [0x9eca] = 0xfc86, [0x9ecb] = 0xfc87,
  [0x9ecc] = 0xfc88, [0x9ecd] = 0xfc89, [0x9ece] = 0xfc8a, [0x9ecf] = 0xfc8b,
  [0x9ed0] = 0xfc8c, [0x9ed1] = 0xfc8d, [0x9ed2] = 0xfc8e, [0x9ed3] = 0xfc8f,
  [0x9ed4] = 0xfc90, [0x9ed5] = 0xfc91, [0x9ed6] = 0xfc92, [0x9ed7] = 0xfc93,
  [0x9ed8] = 0xfc94, [0x9ed9] = 0xfc95, [0x9eda] = 0xfc96, [0x9edb] = 0xfc97,
  [0x9edc] = 0xfc98, [0x9edd] = 0xfc99, [0x9ede] = 0xfc9a, [0x9edf] = 0xfc9b,
  [0x9ee0] = 0xfc9c, [0x9ee1] = 0xfc9d, [0x9ee2] = 0xfc9e, [0x9ee3] = 0xfc9f,
  [0x9ee4] = 0xfca0, [0x9ee5] = 0xfca1, [0x9ee6] = 0xfca2, [0x9ee7] = 0xfca3,
  [0x9ee8] = 0xfca4, [0x9ee9] = 0xfca5, [0x9eea] = 0xfca6, [0x9eeb] = 0xfca7,
  [0x9eec] = 0xfca8, [0x9eed] = 0xfca9, [0x9eee] = 0xfcaa, [0x9eef] = 0xfcab,
  [0x9ef0] = 0xfcac, [0x9ef1] = 0xfcad, [0x9ef2] = 0xfcae, [0x9ef3] = 0xfcaf,
  [0x9ef4] = 0xfcb0, [0x9ef5] = 0xfcb1, [0x9ef6] = 0xfcb2, [0x9ef7] = 0xfcb3,
  [0x9ef8] = 0xfcb4, [0x9ef9] = 0xfcb5, [0x9efa] = 0xfcb6, [0x9efb] = 0xfcb7,
  [0x9efc] = 0xfcb8, [0x9efd] = 0xfcb9, [0x9efe] = 0xfcba, [0x9eff] = 0xfcbb,
  [0x9f00] = 0xfcbc, [0x9f01] = 0xfcbd, [0x9f02] = 0xfcbe, [0x9f03] = 0xfcbf,
  [0x9f04] = 0xfcc0, [0x9f05] = 0xfcc1, [0x9f06] = 0xfcc2, [0x9f07] = 0xfcc3,
  [0x9f08] = 0xfcc4, [0x9f09] = 0xfcc5, [0x9f0a] = 0xfcc6, [0x9f0b] = 0xfcc7,
  [0x9f0c] = 0xfcc8, [0x9f0d] = 0xfcc9, [0x9f0e] = 0xfcca, [0x9f0f] = 0xfccb,
  [0x9f10] = 0xfccc, [0x9f11] = 0xfccd, [0x9f12] = 0xfcce, [0x9f13] = 0xfccf,
  [0x9f14] = 0xfcd0, [0x9f15] = 0xfcd1, [0x9f16] = 0xfcd2, [0x9f17] = 0xfcd3,
  [0x9f18] = 0xfcd4, [0x9f19] = 0xfcd5, [0x9f1a] = 0xfcd6, [0x9f1b] = 0xfcd7,
  [0x9f1c] = 0xfcd8, [0x9f1d] = 0xfcd9, [0x9f1e] = 0xfcda, [0x9f1f] = 0xfcdb,
  [0x9f20] = 0xfcdc, [0x9f21] = 0xfcdd, [0x9f22] = 0xfcde, [0x9f23] = 0xfcdf,
  [0x9f24] = 0xfce0, [0x9f25] = 0xfce1, [0x9f26] = 0xfce2, [0x9f27] = 0xfce3,
  [0x9f28] = 0xfce4, [0x9f29] = 0xfce5, [0x9f2a] = 0xfce6, [0x9f2b] = 0xfce7,
  [0x9f2c] = 0xfce8, [0x9f2d] = 0xfce9, [0x9f2e] = 0xfcea, [0x9f2f] = 0xfceb,
  [0x9f30] = 0xfcec, [0x9f31] = 0xfced, [0x9f32] = 0xfcee, [0x9f33] = 0xfcef,
  [0x9f34] = 0xfcf0, [0x9f35] = 0xfcf1, [0x9f36] = 0xfcf2, [0x9f37] = 0xfcf3,
  [0x9f38] = 0xfcf4, [0x9f39] = 0xfcf5, [0x9f3a] = 0xfcf6, [0x9f3b] = 0xfcf7,
  [0x9f3c] = 0xfcf8, [0x9f3d] = 0xfcf9, [0x9f3e] = 0xfcfa, [0x9f3f] = 0xfcfb,
  [0x9f40] = 0xfcfc, [0x9f41] = 0xfcfd, [0x9f42] = 0xfcfe, [0x9f43] = 0xfcff,
  [0x9f44] = 0xfd00, [0x9f45] = 0xfd01, [0x9f46] = 0xfd02, [0x9f47] = 0xfd03,
  [0x9f48] = 0xfd04, [0x9f49] = 0xfd05, [0x9f4a] = 0xfd06, [0x9f4b] = 0xfd07,
  [0x9f4c] = 0xfd08, [0x9f4d] = 0xfd09, [0x9f4e] = 0xfd0a, [0x9f4f] = 0xfd0b,
  [0x9f50] = 0xfd0c, [0x9f51] = 0xfd0d, [0x9f52] = 0xfd0e, [0x9f53] = 0xfd0f,
  [0x9f54] = 0xfd10, [0x9f55] = 0xfd11, [0x9f56] = 0xfd12, [0x9f57] = 0xfd13,
  [0x9f58] = 0xfd14, [0x9f59] = 0xfd15, [0x9f5a] = 0xfd16, [0x9f5b] = 0xfd17,
  [0x9f5c] = 0xfd18, [0x9f5d] = 0xfd19, [0x9f5e] = 0xfd1a, [0x9f5f] = 0xfd1b,
  [0x9f60] = 0xfd1c, [0x9f61] = 0xfd1d, [0x9f62] = 0xfd1e, [0x9f63] = 0xfd1f,
  [0x9f64] = 0xfd20, [0x9f65] = 0xfd21, [0x9f66] = 0xfd22, [0x9f67] = 0xfd23,
  [0x9f68] = 0xfd24, [0x9f69] = 0xfd25, [0x9f6a] = 0xfd26, [0x9f6b] = 0xfd27,
  [0x9f6c] = 0xfd28, [0x9f6d] = 0xfd29, [0x9f6e] = 0xfd2a, [0x9f6f] = 0xfd2b,
  [0x9f70] = 0xfd2c, [0x9f71] = 0xfd2d, [0x9f72] = 0xfd2e, [0x9f73] = 0xfd2f,
  [0x9f74] = 0xfd30, [0x9f75] = 0xfd31, [0x9f76] = 0xfd32, [0x9f77] = 0xfd33,
  [0x9f78] = 0xfd34, [0x9f79] = 0xfd35, [0x9f7a] = 0xfd36, [0x9f7b] = 0xfd37,
  [0x9f7c] = 0xfd38, [0x9f7d] = 0xfd39, [0x9f7e] = 0xfd3a, [0x9f7f] = 0xfd3b,
  [0x9f80] = 0xfd3c, [0x9f81] = 0xfd3d, [0x9f82] = 0xfd3e, [0x9f83] = 0xfd3f,
  [0x9f94] = 0xfd50, [0x9f95] = 0xfd51, [0x9f96] = 0xfd52, [0x9f97] = 0xfd53,
  [0x9f98] = 0xfd54, [0x9f99] = 0xfd55, [0x9f9a] = 0xfd56, [0x9f9b] = 0xfd57,
  [0x9f9c] = 0xfd58, [0x9f9d] = 0xfd59, [0x9f9e] = 0xfd5a, [0x9f9f] = 0xfd5b,
  [0x9fa0] = 0xfd5c, [0x9fa1] = 0xfd5d, [0x9fa2] = 0xfd5e, [0x9fa3] = 0xfd5f,
  [0x9fa4] = 0xfd60, [0x9fa5] = 0xfd61, [0x9fa6] = 0xfd62, [0x9fa7] = 0xfd63,
  [0x9fa8] = 0xfd64, [0x9fa9] = 0xfd65, [0x9faa] = 0xfd66, [0x9fab] = 0xfd67,
  [0x9fac] = 0xfd68, [0x9fad] = 0xfd69, [0x9fae] = 0xfd6a, [0x9faf] = 0xfd6b,
  [0x9fb0] = 0xfd6c, [0x9fb1] = 0xfd6d, [0x9fb2] = 0xfd6e, [0x9fb3] = 0xfd6f,
  [0x9fb4] = 0xfd70, [0x9fb5] = 0xfd71, [0x9fb6] = 0xfd72, [0x9fb7] = 0xfd73,
  [0x9fb8] = 0xfd74, [0x9fb9] = 0xfd75, [0x9fba] = 0xfd76, [0x9fbb] = 0xfd77,
  [0x9fbc] = 0xfd78, [0x9fbd] = 0xfd79, [0x9fbe] = 0xfd7a, [0x9fbf] = 0xfd7b,
  [0x9fc0] = 0xfd7c, [0x9fc1] = 0xfd7d, [0x9fc2] = 0xfd7e, [0x9fc3] = 0xfd7f,
  [0x9fc4] = 0xfd80, [0x9fc5] = 0xfd81, [0x9fc6] = 0xfd82, [0x9fc7] = 0xfd83,
  [0x9fc8] = 0xfd84, [0x9fc9] = 0xfd85, [0x9fca] = 0xfd86, [0x9fcb] = 0xfd87,
  [0x9fcc] = 0xfd88, [0x9fcd] = 0xfd89, [0x9fce] = 0xfd8a, [0x9fcf] = 0xfd8b,
  [0x9fd0] = 0xfd8c, [0x9fd1] = 0xfd8d, [0x9fd2] = 0xfd8e, [0x9fd3] = 0xfd8f,
  [0x9fd6] = 0xfd92, [0x9fd7] = 0xfd93,
  [0x9fd8] = 0xfd94, [0x9fd9] = 0xfd95, [0x9fda] = 0xfd96, [0x9fdb] = 0xfd97,
  [0x9fdc] = 0xfd98, [0x9fdd] = 0xfd99, [0x9fde] = 0xfd9a, [0x9fdf] = 0xfd9b,
  [0x9fe0] = 0xfd9c, [0x9fe1] = 0xfd9d, [0x9fe2] = 0xfd9e, [0x9fe3] = 0xfd9f,
  [0x9fe4] = 0xfda0, [0x9fe5] = 0xfda1, [0x9fe6] = 0xfda2, [0x9fe7] = 0xfda3,
  [0x9fe8] = 0xfda4, [0x9fe9] = 0xfda5, [0x9fea] = 0xfda6, [0x9feb] = 0xfda7,
  [0x9fec] = 0xfda8, [0x9fed] = 0xfda9, [0x9fee] = 0xfdaa, [0x9fef] = 0xfdab,
  [0x9ff0] = 0xfdac, [0x9ff1] = 0xfdad, [0x9ff2] = 0xfdae, [0x9ff3] = 0xfdaf,
  [0x9ff4] = 0xfdb0, [0x9ff5] = 0xfdb1, [0x9ff6] = 0xfdb2, [0x9ff7] = 0xfdb3,
  [0x9ff8] = 0xfdb4, [0x9ff9] = 0xfdb5, [0x9ffa] = 0xfdb6, [0x9ffb] = 0xfdb7,
  [0x9ffc] = 0xfdb8, [0x9ffd] = 0xfdb9, [0x9ffe] = 0xfdba, [0x9fff] = 0xfdbb,
  [0xa000] = 0xfdbc, [0xa001] = 0xfdbd, [0xa002] = 0xfdbe, [0xa003] = 0xfdbf,
  [0xa004] = 0xfdc0, [0xa005] = 0xfdc1, [0xa006] = 0xfdc2, [0xa007] = 0xfdc3,
  [0xa008] = 0xfdc4, [0xa009] = 0xfdc5, [0xa00a] = 0xfdc6, [0xa00b] = 0xfdc7,
  [0xa034] = 0xfdf0, [0xa035] = 0xfdf1, [0xa036] = 0xfdf2, [0xa037] = 0xfdf3,
  [0xa038] = 0xfdf4, [0xa039] = 0xfdf5, [0xa03a] = 0xfdf6, [0xa03b] = 0xfdf7,
  [0xa03c] = 0xfdf8, [0xa03d] = 0xfdf9, [0xa03e] = 0xfdfa, [0xa03f] = 0xfdfb,
  [0xa064] = 0xfe20, [0xa065] = 0xfe21, [0xa066] = 0xfe22, [0xa067] = 0xfe23,
  [0xa074] = 0xfe32, [0xa07a] = 0xfe58,
  [0xa080] = 0xfe70, [0xa081] = 0xfe71, [0xa082] = 0xfe72,
  [0xa084] = 0xfe74, [0xa086] = 0xfe76, [0xa087] = 0xfe77,
  [0xa088] = 0xfe78, [0xa089] = 0xfe79, [0xa08a] = 0xfe7a, [0xa08b] = 0xfe7b,
  [0xa08c] = 0xfe7c, [0xa08d] = 0xfe7d, [0xa08e] = 0xfe7e, [0xa08f] = 0xfe7f,
  [0xa090] = 0xfe80, [0xa091] = 0xfe81, [0xa092] = 0xfe82, [0xa093] = 0xfe83,
  [0xa094] = 0xfe84, [0xa095] = 0xfe85, [0xa096] = 0xfe86, [0xa097] = 0xfe87,
  [0xa098] = 0xfe88, [0xa099] = 0xfe89, [0xa09a] = 0xfe8a, [0xa09b] = 0xfe8b,
  [0xa09c] = 0xfe8c, [0xa09d] = 0xfe8d, [0xa09e] = 0xfe8e, [0xa09f] = 0xfe8f,
  [0xa0a0] = 0xfe90, [0xa0a1] = 0xfe91, [0xa0a2] = 0xfe92, [0xa0a3] = 0xfe93,
  [0xa0a4] = 0xfe94, [0xa0a5] = 0xfe95, [0xa0a6] = 0xfe96, [0xa0a7] = 0xfe97,
  [0xa0a8] = 0xfe98, [0xa0a9] = 0xfe99, [0xa0aa] = 0xfe9a, [0xa0ab] = 0xfe9b,
  [0xa0ac] = 0xfe9c, [0xa0ad] = 0xfe9d, [0xa0ae] = 0xfe9e, [0xa0af] = 0xfe9f,
  [0xa0b0] = 0xfea0, [0xa0b1] = 0xfea1, [0xa0b2] = 0xfea2, [0xa0b3] = 0xfea3,
  [0xa0b4] = 0xfea4, [0xa0b5] = 0xfea5, [0xa0b6] = 0xfea6, [0xa0b7] = 0xfea7,
  [0xa0b8] = 0xfea8, [0xa0b9] = 0xfea9, [0xa0ba] = 0xfeaa, [0xa0bb] = 0xfeab,
  [0xa0bc] = 0xfeac, [0xa0bd] = 0xfead, [0xa0be] = 0xfeae, [0xa0bf] = 0xfeaf,
  [0xa0c0] = 0xfeb0, [0xa0c1] = 0xfeb1, [0xa0c2] = 0xfeb2, [0xa0c3] = 0xfeb3,
  [0xa0c4] = 0xfeb4, [0xa0c5] = 0xfeb5, [0xa0c6] = 0xfeb6, [0xa0c7] = 0xfeb7,
  [0xa0c8] = 0xfeb8, [0xa0c9] = 0xfeb9, [0xa0ca] = 0xfeba, [0xa0cb] = 0xfebb,
  [0xa0cc] = 0xfebc, [0xa0cd] = 0xfebd, [0xa0ce] = 0xfebe, [0xa0cf] = 0xfebf,
  [0xa0d0] = 0xfec0, [0xa0d1] = 0xfec1, [0xa0d2] = 0xfec2, [0xa0d3] = 0xfec3,
  [0xa0d4] = 0xfec4, [0xa0d5] = 0xfec5, [0xa0d6] = 0xfec6, [0xa0d7] = 0xfec7,
  [0xa0d8] = 0xfec8, [0xa0d9] = 0xfec9, [0xa0da] = 0xfeca, [0xa0db] = 0xfecb,
  [0xa0dc] = 0xfecc, [0xa0dd] = 0xfecd, [0xa0de] = 0xfece, [0xa0df] = 0xfecf,
  [0xa0e0] = 0xfed0, [0xa0e1] = 0xfed1, [0xa0e2] = 0xfed2, [0xa0e3] = 0xfed3,
  [0xa0e4] = 0xfed4, [0xa0e5] = 0xfed5, [0xa0e6] = 0xfed6, [0xa0e7] = 0xfed7,
  [0xa0e8] = 0xfed8, [0xa0e9] = 0xfed9, [0xa0ea] = 0xfeda, [0xa0eb] = 0xfedb,
  [0xa0ec] = 0xfedc, [0xa0ed] = 0xfedd, [0xa0ee] = 0xfede, [0xa0ef] = 0xfedf,
  [0xa0f0] = 0xfee0, [0xa0f1] = 0xfee1, [0xa0f2] = 0xfee2, [0xa0f3] = 0xfee3,
  [0xa0f4] = 0xfee4, [0xa0f5] = 0xfee5, [0xa0f6] = 0xfee6, [0xa0f7] = 0xfee7,
  [0xa0f8] = 0xfee8, [0xa0f9] = 0xfee9, [0xa0fa] = 0xfeea, [0xa0fb] = 0xfeeb,
  [0xa0fc] = 0xfeec, [0xa0fd] = 0xfeed, [0xa0fe] = 0xfeee, [0xa0ff] = 0xfeef,
  [0xa100] = 0xfef0, [0xa101] = 0xfef1, [0xa102] = 0xfef2, [0xa103] = 0xfef3,
  [0xa104] = 0xfef4, [0xa105] = 0xfef5, [0xa106] = 0xfef6, [0xa107] = 0xfef7,
  [0xa108] = 0xfef8, [0xa109] = 0xfef9, [0xa10a] = 0xfefa, [0xa10b] = 0xfefb,
  [0xa10c] = 0xfefc, [0xa10f] = 0xfeff, [0xa113] = 0xff61,
  [0xa114] = 0xff62, [0xa115] = 0xff63, [0xa116] = 0xff64, [0xa117] = 0xff65,
  [0xa118] = 0xff66, [0xa119] = 0xff67, [0xa11a] = 0xff68, [0xa11b] = 0xff69,
  [0xa11c] = 0xff6a, [0xa11d] = 0xff6b, [0xa11e] = 0xff6c, [0xa11f] = 0xff6d,
  [0xa120] = 0xff6e, [0xa121] = 0xff6f, [0xa122] = 0xff70, [0xa123] = 0xff71,
  [0xa124] = 0xff72, [0xa125] = 0xff73, [0xa126] = 0xff74, [0xa127] = 0xff75,
  [0xa128] = 0xff76, [0xa129] = 0xff77, [0xa12a] = 0xff78, [0xa12b] = 0xff79,
  [0xa12c] = 0xff7a, [0xa12d] = 0xff7b, [0xa12e] = 0xff7c, [0xa12f] = 0xff7d,
  [0xa130] = 0xff7e, [0xa131] = 0xff7f, [0xa132] = 0xff80, [0xa133] = 0xff81,
  [0xa134] = 0xff82, [0xa135] = 0xff83, [0xa136] = 0xff84, [0xa137] = 0xff85,
  [0xa138] = 0xff86, [0xa139] = 0xff87, [0xa13a] = 0xff88, [0xa13b] = 0xff89,
  [0xa13c] = 0xff8a, [0xa13d] = 0xff8b, [0xa13e] = 0xff8c, [0xa13f] = 0xff8d,
  [0xa140] = 0xff8e, [0xa141] = 0xff8f, [0xa142] = 0xff90, [0xa143] = 0xff91,
  [0xa144] = 0xff92, [0xa145] = 0xff93, [0xa146] = 0xff94, [0xa147] = 0xff95,
  [0xa148] = 0xff96, [0xa149] = 0xff97, [0xa14a] = 0xff98, [0xa14b] = 0xff99,
  [0xa14c] = 0xff9a, [0xa14d] = 0xff9b, [0xa14e] = 0xff9c, [0xa14f] = 0xff9d,
  [0xa150] = 0xff9e, [0xa151] = 0xff9f, [0xa152] = 0xffa0, [0xa153] = 0xffa1,
  [0xa154] = 0xffa2, [0xa155] = 0xffa3, [0xa156] = 0xffa4, [0xa157] = 0xffa5,
  [0xa158] = 0xffa6, [0xa159] = 0xffa7, [0xa15a] = 0xffa8, [0xa15b] = 0xffa9,
  [0xa15c] = 0xffaa, [0xa15d] = 0xffab, [0xa15e] = 0xffac, [0xa15f] = 0xffad,
  [0xa160] = 0xffae, [0xa161] = 0xffaf, [0xa162] = 0xffb0, [0xa163] = 0xffb1,
  [0xa164] = 0xffb2, [0xa165] = 0xffb3, [0xa166] = 0xffb4, [0xa167] = 0xffb5,
  [0xa168] = 0xffb6, [0xa169] = 0xffb7, [0xa16a] = 0xffb8, [0xa16b] = 0xffb9,
  [0xa16c] = 0xffba, [0xa16d] = 0xffbb, [0xa16e] = 0xffbc, [0xa16f] = 0xffbd,
  [0xa170] = 0xffbe, [0xa174] = 0xffc2, [0xa175] = 0xffc3, [0xa176] = 0xffc4,
  [0xa177] = 0xffc5, [0xa178] = 0xffc6, [0xa179] = 0xffc7,
  [0xa17c] = 0xffca, [0xa17d] = 0xffcb, [0xa17e] = 0xffcc, [0xa17f] = 0xffcd,
  [0xa180] = 0xffce, [0xa181] = 0xffcf,
  [0xa184] = 0xffd2, [0xa185] = 0xffd3, [0xa186] = 0xffd4, [0xa187] = 0xffd5,
  [0xa188] = 0xffd6, [0xa189] = 0xffd7,
  [0xa18c] = 0xffda, [0xa18d] = 0xffdb, [0xa18e] = 0xffdc, [0xa192] = 0xffe6,
  [0xa194] = 0xffe8, [0xa195] = 0xffe9, [0xa196] = 0xffea, [0xa197] = 0xffeb,
  [0xa198] = 0xffec, [0xa199] = 0xffed, [0xa19a] = 0xffee,
  [0xa1a5] = 0xfff9, [0xa1a6] = 0xfffa, [0xa1a7] = 0xfffb,
  [0xa1a8] = 0xfffc, [0xa1a9] = 0xfffd
};

static const uint16_t __gbk_to_ucs[] =
{
  [0x0000] = 0x4e02, [0x0001] = 0x4e04, [0x0002] = 0x4e05, [0x0003] = 0x4e06,
  [0x0004] = 0x4e0f, [0x0005] = 0x4e12, [0x0006] = 0x4e17, [0x0007] = 0x4e1f,
  [0x0008] = 0x4e20, [0x0009] = 0x4e21, [0x000a] = 0x4e23, [0x000b] = 0x4e26,
  [0x000c] = 0x4e29, [0x000d] = 0x4e2e, [0x000e] = 0x4e2f, [0x000f] = 0x4e31,
  [0x0010] = 0x4e33, [0x0011] = 0x4e35, [0x0012] = 0x4e37, [0x0013] = 0x4e3c,
  [0x0014] = 0x4e40, [0x0015] = 0x4e41, [0x0016] = 0x4e42, [0x0017] = 0x4e44,
  [0x0018] = 0x4e46, [0x0019] = 0x4e4a, [0x001a] = 0x4e51, [0x001b] = 0x4e55,
  [0x001c] = 0x4e57, [0x001d] = 0x4e5a, [0x001e] = 0x4e5b, [0x001f] = 0x4e62,
  [0x0020] = 0x4e63, [0x0021] = 0x4e64, [0x0022] = 0x4e65, [0x0023] = 0x4e67,
  [0x0024] = 0x4e68, [0x0025] = 0x4e6a, [0x0026] = 0x4e6b, [0x0027] = 0x4e6c,
  [0x0028] = 0x4e6d, [0x0029] = 0x4e6e, [0x002a] = 0x4e6f, [0x002b] = 0x4e72,
  [0x002c] = 0x4e74, [0x002d] = 0x4e75, [0x002e] = 0x4e76, [0x002f] = 0x4e77,
  [0x0030] = 0x4e78, [0x0031] = 0x4e79, [0x0032] = 0x4e7a, [0x0033] = 0x4e7b,
  [0x0034] = 0x4e7c, [0x0035] = 0x4e7d, [0x0036] = 0x4e7f, [0x0037] = 0x4e80,
  [0x0038] = 0x4e81, [0x0039] = 0x4e82, [0x003a] = 0x4e83, [0x003b] = 0x4e84,
  [0x003c] = 0x4e85, [0x003d] = 0x4e87, [0x003e] = 0x4e8a, [0x0040] = 0x4e90,
  [0x0041] = 0x4e96, [0x0042] = 0x4e97, [0x0043] = 0x4e99, [0x0044] = 0x4e9c,
  [0x0045] = 0x4e9d, [0x0046] = 0x4e9e, [0x0047] = 0x4ea3, [0x0048] = 0x4eaa,
  [0x0049] = 0x4eaf, [0x004a] = 0x4eb0, [0x004b] = 0x4eb1, [0x004c] = 0x4eb4,
  [0x004d] = 0x4eb6, [0x004e] = 0x4eb7, [0x004f] = 0x4eb8, [0x0050] = 0x4eb9,
  [0x0051] = 0x4ebc, [0x0052] = 0x4ebd, [0x0053] = 0x4ebe, [0x0054] = 0x4ec8,
  [0x0055] = 0x4ecc, [0x0056] = 0x4ecf, [0x0057] = 0x4ed0, [0x0058] = 0x4ed2,
  [0x0059] = 0x4eda, [0x005a] = 0x4edb, [0x005b] = 0x4edc, [0x005c] = 0x4ee0,
  [0x005d] = 0x4ee2, [0x005e] = 0x4ee6, [0x005f] = 0x4ee7, [0x0060] = 0x4ee9,
  [0x0061] = 0x4eed, [0x0062] = 0x4eee, [0x0063] = 0x4eef, [0x0064] = 0x4ef1,
  [0x0065] = 0x4ef4, [0x0066] = 0x4ef8, [0x0067] = 0x4ef9, [0x0068] = 0x4efa,
  [0x0069] = 0x4efc, [0x006a] = 0x4efe, [0x006b] = 0x4f00, [0x006c] = 0x4f02,
  [0x006d] = 0x4f03, [0x006e] = 0x4f04, [0x006f] = 0x4f05, [0x0070] = 0x4f06,
  [0x0071] = 0x4f07, [0x0072] = 0x4f08, [0x0073] = 0x4f0b, [0x0074] = 0x4f0c,
  [0x0075] = 0x4f12, [0x0076] = 0x4f13, [0x0077] = 0x4f14, [0x0078] = 0x4f15,
  [0x0079] = 0x4f16, [0x007a] = 0x4f1c, [0x007b] = 0x4f1d, [0x007c] = 0x4f21,
  [0x007d] = 0x4f23, [0x007e] = 0x4f28, [0x007f] = 0x4f29, [0x0080] = 0x4f2c,
  [0x0081] = 0x4f2d, [0x0082] = 0x4f2e, [0x0083] = 0x4f31, [0x0084] = 0x4f33,
  [0x0085] = 0x4f35, [0x0086] = 0x4f37, [0x0087] = 0x4f39, [0x0088] = 0x4f3b,
  [0x0089] = 0x4f3e, [0x008a] = 0x4f3f, [0x008b] = 0x4f40, [0x008c] = 0x4f41,
  [0x008d] = 0x4f42, [0x008e] = 0x4f44, [0x008f] = 0x4f45, [0x0090] = 0x4f47,
  [0x0091] = 0x4f48, [0x0092] = 0x4f49, [0x0093] = 0x4f4a, [0x0094] = 0x4f4b,
  [0x0095] = 0x4f4c, [0x0096] = 0x4f52, [0x0097] = 0x4f54, [0x0098] = 0x4f56,
  [0x0099] = 0x4f61, [0x009a] = 0x4f62, [0x009b] = 0x4f66, [0x009c] = 0x4f68,
  [0x009d] = 0x4f6a, [0x009e] = 0x4f6b, [0x009f] = 0x4f6d, [0x00a0] = 0x4f6e,
  [0x00a1] = 0x4f71, [0x00a2] = 0x4f72, [0x00a3] = 0x4f75, [0x00a4] = 0x4f77,
  [0x00a5] = 0x4f78, [0x00a6] = 0x4f79, [0x00a7] = 0x4f7a, [0x00a8] = 0x4f7d,
  [0x00a9] = 0x4f80, [0x00aa] = 0x4f81, [0x00ab] = 0x4f82, [0x00ac] = 0x4f85,
  [0x00ad] = 0x4f86, [0x00ae] = 0x4f87, [0x00af] = 0x4f8a, [0x00b0] = 0x4f8c,
  [0x00b1] = 0x4f8e, [0x00b2] = 0x4f90, [0x00b3] = 0x4f92, [0x00b4] = 0x4f93,
  [0x00b5] = 0x4f95, [0x00b6] = 0x4f96, [0x00b7] = 0x4f98, [0x00b8] = 0x4f99,
  [0x00b9] = 0x4f9a, [0x00ba] = 0x4f9c, [0x00bb] = 0x4f9e, [0x00bc] = 0x4f9f,
  [0x00bd] = 0x4fa1, [0x00be] = 0x4fa2, [0x00c0] = 0x4fa4, [0x00c1] = 0x4fab,
  [0x00c2] = 0x4fad, [0x00c3] = 0x4fb0, [0x00c4] = 0x4fb1, [0x00c5] = 0x4fb2,
  [0x00c6] = 0x4fb3, [0x00c7] = 0x4fb4, [0x00c8] = 0x4fb6, [0x00c9] = 0x4fb7,
  [0x00ca] = 0x4fb8, [0x00cb] = 0x4fb9, [0x00cc] = 0x4fba, [0x00cd] = 0x4fbb,
  [0x00ce] = 0x4fbc, [0x00cf] = 0x4fbd, [0x00d0] = 0x4fbe, [0x00d1] = 0x4fc0,
  [0x00d2] = 0x4fc1, [0x00d3] = 0x4fc2, [0x00d4] = 0x4fc6, [0x00d5] = 0x4fc7,
  [0x00d6] = 0x4fc8, [0x00d7] = 0x4fc9, [0x00d8] = 0x4fcb, [0x00d9] = 0x4fcc,
  [0x00da] = 0x4fcd, [0x00db] = 0x4fd2, [0x00dc] = 0x4fd3, [0x00dd] = 0x4fd4,
  [0x00de] = 0x4fd5, [0x00df] = 0x4fd6, [0x00e0] = 0x4fd9, [0x00e1] = 0x4fdb,
  [0x00e2] = 0x4fe0, [0x00e3] = 0x4fe2, [0x00e4] = 0x4fe4, [0x00e5] = 0x4fe5,
  [0x00e6] = 0x4fe7, [0x00e7] = 0x4feb, [0x00e8] = 0x4fec, [0x00e9] = 0x4ff0,
  [0x00ea] = 0x4ff2, [0x00eb] = 0x4ff4, [0x00ec] = 0x4ff5, [0x00ed] = 0x4ff6,
  [0x00ee] = 0x4ff7, [0x00ef] = 0x4ff9, [0x00f0] = 0x4ffb, [0x00f1] = 0x4ffc,
  [0x00f2] = 0x4ffd, [0x00f3] = 0x4fff, [0x00f4] = 0x5000, [0x00f5] = 0x5001,
  [0x00f6] = 0x5002, [0x00f7] = 0x5003, [0x00f8] = 0x5004, [0x00f9] = 0x5005,
  [0x00fa] = 0x5006, [0x00fb] = 0x5007, [0x00fc] = 0x5008, [0x00fd] = 0x5009,
  [0x00fe] = 0x500a, [0x0100] = 0x500b, [0x0101] = 0x500e, [0x0102] = 0x5010,
  [0x0103] = 0x5011, [0x0104] = 0x5013, [0x0105] = 0x5015, [0x0106] = 0x5016,
  [0x0107] = 0x5017, [0x0108] = 0x501b, [0x0109] = 0x501d, [0x010a] = 0x501e,
  [0x010b] = 0x5020, [0x010c] = 0x5022, [0x010d] = 0x5023, [0x010e] = 0x5024,
  [0x010f] = 0x5027, [0x0110] = 0x502b, [0x0111] = 0x502f, [0x0112] = 0x5030,
  [0x0113] = 0x5031, [0x0114] = 0x5032, [0x0115] = 0x5033, [0x0116] = 0x5034,
  [0x0117] = 0x5035, [0x0118] = 0x5036, [0x0119] = 0x5037, [0x011a] = 0x5038,
  [0x011b] = 0x5039, [0x011c] = 0x503b, [0x011d] = 0x503d, [0x011e] = 0x503f,
  [0x011f] = 0x5040, [0x0120] = 0x5041, [0x0121] = 0x5042, [0x0122] = 0x5044,
  [0x0123] = 0x5045, [0x0124] = 0x5046, [0x0125] = 0x5049, [0x0126] = 0x504a,
  [0x0127] = 0x504b, [0x0128] = 0x504d, [0x0129] = 0x5050, [0x012a] = 0x5051,
  [0x012b] = 0x5052, [0x012c] = 0x5053, [0x012d] = 0x5054, [0x012e] = 0x5056,
  [0x012f] = 0x5057, [0x0130] = 0x5058, [0x0131] = 0x5059, [0x0132] = 0x505b,
  [0x0133] = 0x505d, [0x0134] = 0x505e, [0x0135] = 0x505f, [0x0136] = 0x5060,
  [0x0137] = 0x5061, [0x0138] = 0x5062, [0x0139] = 0x5063, [0x013a] = 0x5064,
  [0x013b] = 0x5066, [0x013c] = 0x5067, [0x013d] = 0x5068, [0x013e] = 0x5069,
  [0x013f] = 0x506a, [0x0140] = 0x506b, [0x0141] = 0x506d, [0x0142] = 0x506e,
  [0x0143] = 0x506f, [0x0144] = 0x5070, [0x0145] = 0x5071, [0x0146] = 0x5072,
  [0x0147] = 0x5073, [0x0148] = 0x5074, [0x0149] = 0x5075, [0x014a] = 0x5078,
  [0x014b] = 0x5079, [0x014c] = 0x507a, [0x014d] = 0x507c, [0x014e] = 0x507d,
  [0x014f] = 0x5081, [0x0150] = 0x5082, [0x0151] = 0x5083, [0x0152] = 0x5084,
  [0x0153] = 0x5086, [0x0154] = 0x5087, [0x0155] = 0x5089, [0x0156] = 0x508a,
  [0x0157] = 0x508b, [0x0158] = 0x508c, [0x0159] = 0x508e, [0x015a] = 0x508f,
  [0x015b] = 0x5090, [0x015c] = 0x5091, [0x015d] = 0x5092, [0x015e] = 0x5093,
  [0x015f] = 0x5094, [0x0160] = 0x5095, [0x0161] = 0x5096, [0x0162] = 0x5097,
  [0x0163] = 0x5098, [0x0164] = 0x5099, [0x0165] = 0x509a, [0x0166] = 0x509b,
  [0x0167] = 0x509c, [0x0168] = 0x509d, [0x0169] = 0x509e, [0x016a] = 0x509f,
  [0x016b] = 0x50a0, [0x016c] = 0x50a1, [0x016d] = 0x50a2, [0x016e] = 0x50a4,
  [0x016f] = 0x50a6, [0x0170] = 0x50aa, [0x0171] = 0x50ab, [0x0172] = 0x50ad,
  [0x0173] = 0x50ae, [0x0174] = 0x50af, [0x0175] = 0x50b0, [0x0176] = 0x50b1,
  [0x0177] = 0x50b3, [0x0178] = 0x50b4, [0x0179] = 0x50b5, [0x017a] = 0x50b6,
  [0x017b] = 0x50b7, [0x017c] = 0x50b8, [0x017d] = 0x50b9, [0x017e] = 0x50bc,
  [0x0180] = 0x50bd, [0x0181] = 0x50be, [0x0182] = 0x50bf, [0x0183] = 0x50c0,
  [0x0184] = 0x50c1, [0x0185] = 0x50c2, [0x0186] = 0x50c3, [0x0187] = 0x50c4,
  [0x0188] = 0x50c5, [0x0189] = 0x50c6, [0x018a] = 0x50c7, [0x018b] = 0x50c8,
  [0x018c] = 0x50c9, [0x018d] = 0x50ca, [0x018e] = 0x50cb, [0x018f] = 0x50cc,
  [0x0190] = 0x50cd, [0x0191] = 0x50ce, [0x0192] = 0x50d0, [0x0193] = 0x50d1,
  [0x0194] = 0x50d2, [0x0195] = 0x50d3, [0x0196] = 0x50d4, [0x0197] = 0x50d5,
  [0x0198] = 0x50d7, [0x0199] = 0x50d8, [0x019a] = 0x50d9, [0x019b] = 0x50db,
  [0x019c] = 0x50dc, [0x019d] = 0x50dd, [0x019e] = 0x50de, [0x019f] = 0x50df,
  [0x01a0] = 0x50e0, [0x01a1] = 0x50e1, [0x01a2] = 0x50e2, [0x01a3] = 0x50e3,
  [0x01a4] = 0x50e4, [0x01a5] = 0x50e5, [0x01a6] = 0x50e8, [0x01a7] = 0x50e9,
  [0x01a8] = 0x50ea, [0x01a9] = 0x50eb, [0x01aa] = 0x50ef, [0x01ab] = 0x50f0,
  [0x01ac] = 0x50f1, [0x01ad] = 0x50f2, [0x01ae] = 0x50f4, [0x01af] = 0x50f6,
  [0x01b0] = 0x50f7, [0x01b1] = 0x50f8, [0x01b2] = 0x50f9, [0x01b3] = 0x50fa,
  [0x01b4] = 0x50fc, [0x01b5] = 0x50fd, [0x01b6] = 0x50fe, [0x01b7] = 0x50ff,
  [0x01b8] = 0x5100, [0x01b9] = 0x5101, [0x01ba] = 0x5102, [0x01bb] = 0x5103,
  [0x01bc] = 0x5104, [0x01bd] = 0x5105, [0x01be] = 0x5108, [0x01c0] = 0x5109,
  [0x01c1] = 0x510a, [0x01c2] = 0x510c, [0x01c3] = 0x510d, [0x01c4] = 0x510e,
  [0x01c5] = 0x510f, [0x01c6] = 0x5110, [0x01c7] = 0x5111, [0x01c8] = 0x5113,
  [0x01c9] = 0x5114, [0x01ca] = 0x5115, [0x01cb] = 0x5116, [0x01cc] = 0x5117,
  [0x01cd] = 0x5118, [0x01ce] = 0x5119, [0x01cf] = 0x511a, [0x01d0] = 0x511b,
  [0x01d1] = 0x511c, [0x01d2] = 0x511d, [0x01d3] = 0x511e, [0x01d4] = 0x511f,
  [0x01d5] = 0x5120, [0x01d6] = 0x5122, [0x01d7] = 0x5123, [0x01d8] = 0x5124,
  [0x01d9] = 0x5125, [0x01da] = 0x5126, [0x01db] = 0x5127, [0x01dc] = 0x5128,
  [0x01dd] = 0x5129, [0x01de] = 0x512a, [0x01df] = 0x512b, [0x01e0] = 0x512c,
  [0x01e1] = 0x512d, [0x01e2] = 0x512e, [0x01e3] = 0x512f, [0x01e4] = 0x5130,
  [0x01e5] = 0x5131, [0x01e6] = 0x5132, [0x01e7] = 0x5133, [0x01e8] = 0x5134,
  [0x01e9] = 0x5135, [0x01ea] = 0x5136, [0x01eb] = 0x5137, [0x01ec] = 0x5138,
  [0x01ed] = 0x5139, [0x01ee] = 0x513a, [0x01ef] = 0x513b, [0x01f0] = 0x513c,
  [0x01f1] = 0x513d, [0x01f2] = 0x513e, [0x01f3] = 0x5142, [0x01f4] = 0x5147,
  [0x01f5] = 0x514a, [0x01f6] = 0x514c, [0x01f7] = 0x514e, [0x01f8] = 0x514f,
  [0x01f9] = 0x5150, [0x01fa] = 0x5152, [0x01fb] = 0x5153, [0x01fc] = 0x5157,
  [0x01fd] = 0x5158, [0x01fe] = 0x5159, [0x01ff] = 0x515b, [0x0200] = 0x515d,
  [0x0201] = 0x515e, [0x0202] = 0x515f, [0x0203] = 0x5160, [0x0204] = 0x5161,
  [0x0205] = 0x5163, [0x0206] = 0x5164, [0x0207] = 0x5166, [0x0208] = 0x5167,
  [0x0209] = 0x5169, [0x020a] = 0x516a, [0x020b] = 0x516f, [0x020c] = 0x5172,
  [0x020d] = 0x517a, [0x020e] = 0x517e, [0x020f] = 0x517f, [0x0210] = 0x5183,
  [0x0211] = 0x5184, [0x0212] = 0x5186, [0x0213] = 0x5187, [0x0214] = 0x518a,
  [0x0215] = 0x518b, [0x0216] = 0x518e, [0x0217] = 0x518f, [0x0218] = 0x5190,
  [0x0219] = 0x5191, [0x021a] = 0x5193, [0x021b] = 0x5194, [0x021c] = 0x5198,
  [0x021d] = 0x519a, [0x021e] = 0x519d, [0x021f] = 0x519e, [0x0220] = 0x519f,
  [0x0221] = 0x51a1, [0x0222] = 0x51a3, [0x0223] = 0x51a6, [0x0224] = 0x51a7,
  [0x0225] = 0x51a8, [0x0226] = 0x51a9, [0x0227] = 0x51aa, [0x0228] = 0x51ad,
  [0x0229] = 0x51ae, [0x022a] = 0x51b4, [0x022b] = 0x51b8, [0x022c] = 0x51b9,
  [0x022d] = 0x51ba, [0x022e] = 0x51be, [0x022f] = 0x51bf, [0x0230] = 0x51c1,
  [0x0231] = 0x51c2, [0x0232] = 0x51c3, [0x0233] = 0x51c5, [0x0234] = 0x51c8,
  [0x0235] = 0x51ca, [0x0236] = 0x51cd, [0x0237] = 0x51ce, [0x0238] = 0x51d0,
  [0x0239] = 0x51d2, [0x023a] = 0x51d3, [0x023b] = 0x51d4, [0x023c] = 0x51d5,
  [0x023d] = 0x51d6, [0x023e] = 0x51d7, [0x0240] = 0x51d8, [0x0241] = 0x51d9,
  [0x0242] = 0x51da, [0x0243] = 0x51dc, [0x0244] = 0x51de, [0x0245] = 0x51df,
  [0x0246] = 0x51e2, [0x0247] = 0x51e3, [0x0248] = 0x51e5, [0x0249] = 0x51e6,
  [0x024a] = 0x51e7, [0x024b] = 0x51e8, [0x024c] = 0x51e9, [0x024d] = 0x51ea,
  [0x024e] = 0x51ec, [0x024f] = 0x51ee, [0x0250] = 0x51f1, [0x0251] = 0x51f2,
  [0x0252] = 0x51f4, [0x0253] = 0x51f7, [0x0254] = 0x51fe, [0x0255] = 0x5204,
  [0x0256] = 0x5205, [0x0257] = 0x5209, [0x0258] = 0x520b, [0x0259] = 0x520c,
  [0x025a] = 0x520f, [0x025b] = 0x5210, [0x025c] = 0x5213, [0x025d] = 0x5214,
  [0x025e] = 0x5215, [0x025f] = 0x521c, [0x0260] = 0x521e, [0x0261] = 0x521f,
  [0x0262] = 0x5221, [0x0263] = 0x5222, [0x0264] = 0x5223, [0x0265] = 0x5225,
  [0x0266] = 0x5226, [0x0267] = 0x5227, [0x0268] = 0x522a, [0x0269] = 0x522c,
  [0x026a] = 0x522f, [0x026b] = 0x5231, [0x026c] = 0x5232, [0x026d] = 0x5234,
  [0x026e] = 0x5235, [0x026f] = 0x523c, [0x0270] = 0x523e, [0x0271] = 0x5244,
  [0x0272] = 0x5245, [0x0273] = 0x5246, [0x0274] = 0x5247, [0x0275] = 0x5248,
  [0x0276] = 0x5249, [0x0277] = 0x524b, [0x0278] = 0x524e, [0x0279] = 0x524f,
  [0x027a] = 0x5252, [0x027b] = 0x5253, [0x027c] = 0x5255, [0x027d] = 0x5257,
  [0x027e] = 0x5258, [0x0280] = 0x5259, [0x0281] = 0x525a, [0x0282] = 0x525b,
  [0x0283] = 0x525d, [0x0284] = 0x525f, [0x0285] = 0x5260, [0x0286] = 0x5262,
  [0x0287] = 0x5263, [0x0288] = 0x5264, [0x0289] = 0x5266, [0x028a] = 0x5268,
  [0x028b] = 0x526b, [0x028c] = 0x526c, [0x028d] = 0x526d, [0x028e] = 0x526e,
  [0x028f] = 0x5270, [0x0290] = 0x5271, [0x0291] = 0x5273, [0x0292] = 0x5274,
  [0x0293] = 0x5275, [0x0294] = 0x5276, [0x0295] = 0x5277, [0x0296] = 0x5278,
  [0x0297] = 0x5279, [0x0298] = 0x527a, [0x0299] = 0x527b, [0x029a] = 0x527c,
  [0x029b] = 0x527e, [0x029c] = 0x5280, [0x029d] = 0x5283, [0x029e] = 0x5284,
  [0x029f] = 0x5285, [0x02a0] = 0x5286, [0x02a1] = 0x5287, [0x02a2] = 0x5289,
  [0x02a3] = 0x528a, [0x02a4] = 0x528b, [0x02a5] = 0x528c, [0x02a6] = 0x528d,
  [0x02a7] = 0x528e, [0x02a8] = 0x528f, [0x02a9] = 0x5291, [0x02aa] = 0x5292,
  [0x02ab] = 0x5294, [0x02ac] = 0x5295, [0x02ad] = 0x5296, [0x02ae] = 0x5297,
  [0x02af] = 0x5298, [0x02b0] = 0x5299, [0x02b1] = 0x529a, [0x02b2] = 0x529c,
  [0x02b3] = 0x52a4, [0x02b4] = 0x52a5, [0x02b5] = 0x52a6, [0x02b6] = 0x52a7,
  [0x02b7] = 0x52ae, [0x02b8] = 0x52af, [0x02b9] = 0x52b0, [0x02ba] = 0x52b4,
  [0x02bb] = 0x52b5, [0x02bc] = 0x52b6, [0x02bd] = 0x52b7, [0x02be] = 0x52b8,
  [0x02bf] = 0x52b9, [0x02c0] = 0x52ba, [0x02c1] = 0x52bb, [0x02c2] = 0x52bc,
  [0x02c3] = 0x52bd, [0x02c4] = 0x52c0, [0x02c5] = 0x52c1, [0x02c6] = 0x52c2,
  [0x02c7] = 0x52c4, [0x02c8] = 0x52c5, [0x02c9] = 0x52c6, [0x02ca] = 0x52c8,
  [0x02cb] = 0x52ca, [0x02cc] = 0x52cc, [0x02cd] = 0x52cd, [0x02ce] = 0x52ce,
  [0x02cf] = 0x52cf, [0x02d0] = 0x52d1, [0x02d1] = 0x52d3, [0x02d2] = 0x52d4,
  [0x02d3] = 0x52d5, [0x02d4] = 0x52d7, [0x02d5] = 0x52d9, [0x02d6] = 0x52da,
  [0x02d7] = 0x52db, [0x02d8] = 0x52dc, [0x02d9] = 0x52dd, [0x02da] = 0x52de,
  [0x02db] = 0x52e0, [0x02dc] = 0x52e1, [0x02dd] = 0x52e2, [0x02de] = 0x52e3,
  [0x02df] = 0x52e5, [0x02e0] = 0x52e6, [0x02e1] = 0x52e7, [0x02e2] = 0x52e8,
  [0x02e3] = 0x52e9, [0x02e4] = 0x52ea, [0x02e5] = 0x52eb, [0x02e6] = 0x52ec,
  [0x02e7] = 0x52ed, [0x02e8] = 0x52ee, [0x02e9] = 0x52ef, [0x02ea] = 0x52f1,
  [0x02eb] = 0x52f2, [0x02ec] = 0x52f3, [0x02ed] = 0x52f4, [0x02ee] = 0x52f5,
  [0x02ef] = 0x52f6, [0x02f0] = 0x52f7, [0x02f1] = 0x52f8, [0x02f2] = 0x52fb,
  [0x02f3] = 0x52fc, [0x02f4] = 0x52fd, [0x02f5] = 0x5301, [0x02f6] = 0x5302,
  [0x02f7] = 0x5303, [0x02f8] = 0x5304, [0x02f9] = 0x5307, [0x02fa] = 0x5309,
  [0x02fb] = 0x530a, [0x02fc] = 0x530b, [0x02fd] = 0x530c, [0x02fe] = 0x530e,
  [0x0300] = 0x5311, [0x0301] = 0x5312, [0x0302] = 0x5313, [0x0303] = 0x5314,
  [0x0304] = 0x5318, [0x0305] = 0x531b, [0x0306] = 0x531c, [0x0307] = 0x531e,
  [0x0308] = 0x531f, [0x0309] = 0x5322, [0x030a] = 0x5324, [0x030b] = 0x5325,
  [0x030c] = 0x5327, [0x030d] = 0x5328, [0x030e] = 0x5329, [0x030f] = 0x532b,
  [0x0310] = 0x532c, [0x0311] = 0x532d, [0x0312] = 0x532f, [0x0313] = 0x5330,
  [0x0314] = 0x5331, [0x0315] = 0x5332, [0x0316] = 0x5333, [0x0317] = 0x5334,
  [0x0318] = 0x5335, [0x0319] = 0x5336, [0x031a] = 0x5337, [0x031b] = 0x5338,
  [0x031c] = 0x533c, [0x031d] = 0x533d, [0x031e] = 0x5340, [0x031f] = 0x5342,
  [0x0320] = 0x5344, [0x0321] = 0x5346, [0x0322] = 0x534b, [0x0323] = 0x534c,
  [0x0324] = 0x534d, [0x0325] = 0x5350, [0x0326] = 0x5354, [0x0327] = 0x5358,
  [0x0328] = 0x5359, [0x0329] = 0x535b, [0x032a] = 0x535d, [0x032b] = 0x5365,
  [0x032c] = 0x5368, [0x032d] = 0x536a, [0x032e] = 0x536c, [0x032f] = 0x536d,
  [0x0330] = 0x5372, [0x0331] = 0x5376, [0x0332] = 0x5379, [0x0333] = 0x537b,
  [0x0334] = 0x537c, [0x0335] = 0x537d, [0x0336] = 0x537e, [0x0337] = 0x5380,
  [0x0338] = 0x5381, [0x0339] = 0x5383, [0x033a] = 0x5387, [0x033b] = 0x5388,
  [0x033c] = 0x538a, [0x033d] = 0x538e, [0x033e] = 0x538f, [0x0340] = 0x5390,
  [0x0341] = 0x5391, [0x0342] = 0x5392, [0x0343] = 0x5393, [0x0344] = 0x5394,
  [0x0345] = 0x5396, [0x0346] = 0x5397, [0x0347] = 0x5399, [0x0348] = 0x539b,
  [0x0349] = 0x539c, [0x034a] = 0x539e, [0x034b] = 0x53a0, [0x034c] = 0x53a1,
  [0x034d] = 0x53a4, [0x034e] = 0x53a7, [0x034f] = 0x53aa, [0x0350] = 0x53ab,
  [0x0351] = 0x53ac, [0x0352] = 0x53ad, [0x0353] = 0x53af, [0x0354] = 0x53b0,
  [0x0355] = 0x53b1, [0x0356] = 0x53b2, [0x0357] = 0x53b3, [0x0358] = 0x53b4,
  [0x0359] = 0x53b5, [0x035a] = 0x53b7, [0x035b] = 0x53b8, [0x035c] = 0x53b9,
  [0x035d] = 0x53ba, [0x035e] = 0x53bc, [0x035f] = 0x53bd, [0x0360] = 0x53be,
  [0x0361] = 0x53c0, [0x0362] = 0x53c3, [0x0363] = 0x53c4, [0x0364] = 0x53c5,
  [0x0365] = 0x53c6, [0x0366] = 0x53c7, [0x0367] = 0x53ce, [0x0368] = 0x53cf,
  [0x0369] = 0x53d0, [0x036a] = 0x53d2, [0x036b] = 0x53d3, [0x036c] = 0x53d5,
  [0x036d] = 0x53da, [0x036e] = 0x53dc, [0x036f] = 0x53dd, [0x0370] = 0x53de,
  [0x0371] = 0x53e1, [0x0372] = 0x53e2, [0x0373] = 0x53e7, [0x0374] = 0x53f4,
  [0x0375] = 0x53fa, [0x0376] = 0x53fe, [0x0377] = 0x53ff, [0x0378] = 0x5400,
  [0x0379] = 0x5402, [0x037a] = 0x5405, [0x037b] = 0x5407, [0x037c] = 0x540b,
  [0x037d] = 0x5414, [0x037e] = 0x5418, [0x037f] = 0x5419, [0x0380] = 0x541a,
  [0x0381] = 0x541c, [0x0382] = 0x5422, [0x0383] = 0x5424, [0x0384] = 0x5425,
  [0x0385] = 0x542a, [0x0386] = 0x5430, [0x0387] = 0x5433, [0x0388] = 0x5436,
  [0x0389] = 0x5437, [0x038a] = 0x543a, [0x038b] = 0x543d, [0x038c] = 0x543f,
  [0x038d] = 0x5441, [0x038e] = 0x5442, [0x038f] = 0x5444, [0x0390] = 0x5445,
  [0x0391] = 0x5447, [0x0392] = 0x5449, [0x0393] = 0x544c, [0x0394] = 0x544d,
  [0x0395] = 0x544e, [0x0396] = 0x544f, [0x0397] = 0x5451, [0x0398] = 0x545a,
  [0x0399] = 0x545d, [0x039a] = 0x545e, [0x039b] = 0x545f, [0x039c] = 0x5460,
  [0x039d] = 0x5461, [0x039e] = 0x5463, [0x039f] = 0x5465, [0x03a0] = 0x5467,
  [0x03a1] = 0x5469, [0x03a2] = 0x546a, [0x03a3] = 0x546b, [0x03a4] = 0x546c,
  [0x03a5] = 0x546d, [0x03a6] = 0x546e, [0x03a7] = 0x546f, [0x03a8] = 0x5470,
  [0x03a9] = 0x5474, [0x03aa] = 0x5479, [0x03ab] = 0x547a, [0x03ac] = 0x547e,
  [0x03ad] = 0x547f, [0x03ae] = 0x5481, [0x03af] = 0x5483, [0x03b0] = 0x5485,
  [0x03b1] = 0x5487, [0x03b2] = 0x5488, [0x03b3] = 0x5489, [0x03b4] = 0x548a,
  [0x03b5] = 0x548d, [0x03b6] = 0x5491, [0x03b7] = 0x5493, [0x03b8] = 0x5497,
  [0x03b9] = 0x5498, [0x03ba] = 0x549c, [0x03bb] = 0x549e, [0x03bc] = 0x549f,
  [0x03bd] = 0x54a0, [0x03be] = 0x54a1, [0x03c0] = 0x54a2, [0x03c1] = 0x54a5,
  [0x03c2] = 0x54ae, [0x03c3] = 0x54b0, [0x03c4] = 0x54b2, [0x03c5] = 0x54b5,
  [0x03c6] = 0x54b6, [0x03c7] = 0x54b7, [0x03c8] = 0x54b9, [0x03c9] = 0x54ba,
  [0x03ca] = 0x54bc, [0x03cb] = 0x54be, [0x03cc] = 0x54c3, [0x03cd] = 0x54c5,
  [0x03ce] = 0x54ca, [0x03cf] = 0x54cb, [0x03d0] = 0x54d6, [0x03d1] = 0x54d8,
  [0x03d2] = 0x54db, [0x03d3] = 0x54e0, [0x03d4] = 0x54e1, [0x03d5] = 0x54e2,
  [0x03d6] = 0x54e3, [0x03d7] = 0x54e4, [0x03d8] = 0x54eb, [0x03d9] = 0x54ec,
  [0x03da] = 0x54ef, [0x03db] = 0x54f0, [0x03dc] = 0x54f1, [0x03dd] = 0x54f4,
  [0x03de] = 0x54f5, [0x03df] = 0x54f6, [0x03e0] = 0x54f7, [0x03e1] = 0x54f8,
  [0x03e2] = 0x54f9, [0x03e3] = 0x54fb, [0x03e4] = 0x54fe, [0x03e5] = 0x5500,
  [0x03e6] = 0x5502, [0x03e7] = 0x5503, [0x03e8] = 0x5504, [0x03e9] = 0x5505,
  [0x03ea] = 0x5508, [0x03eb] = 0x550a, [0x03ec] = 0x550b, [0x03ed] = 0x550c,
  [0x03ee] = 0x550d, [0x03ef] = 0x550e, [0x03f0] = 0x5512, [0x03f1] = 0x5513,
  [0x03f2] = 0x5515, [0x03f3] = 0x5516, [0x03f4] = 0x5517, [0x03f5] = 0x5518,
  [0x03f6] = 0x5519, [0x03f7] = 0x551a, [0x03f8] = 0x551c, [0x03f9] = 0x551d,
  [0x03fa] = 0x551e, [0x03fb] = 0x551f, [0x03fc] = 0x5521, [0x03fd] = 0x5525,
  [0x03fe] = 0x5526, [0x0400] = 0x5528, [0x0401] = 0x5529, [0x0402] = 0x552b,
  [0x0403] = 0x552d, [0x0404] = 0x5532, [0x0405] = 0x5534, [0x0406] = 0x5535,
  [0x0407] = 0x5536, [0x0408] = 0x5538, [0x0409] = 0x5539, [0x040a] = 0x553a,
  [0x040b] = 0x553b, [0x040c] = 0x553d, [0x040d] = 0x5540, [0x040e] = 0x5542,
  [0x040f] = 0x5545, [0x0410] = 0x5547, [0x0411] = 0x5548, [0x0412] = 0x554b,
  [0x0413] = 0x554c, [0x0414] = 0x554d, [0x0415] = 0x554e, [0x0416] = 0x554f,
  [0x0417] = 0x5551, [0x0418] = 0x5552, [0x0419] = 0x5553, [0x041a] = 0x5554,
  [0x041b] = 0x5557, [0x041c] = 0x5558, [0x041d] = 0x5559, [0x041e] = 0x555a,
  [0x041f] = 0x555b, [0x0420] = 0x555d, [0x0421] = 0x555e, [0x0422] = 0x555f,
  [0x0423] = 0x5560, [0x0424] = 0x5562, [0x0425] = 0x5563, [0x0426] = 0x5568,
  [0x0427] = 0x5569, [0x0428] = 0x556b, [0x0429] = 0x556f, [0x042a] = 0x5570,
  [0x042b] = 0x5571, [0x042c] = 0x5572, [0x042d] = 0x5573, [0x042e] = 0x5574,
  [0x042f] = 0x5579, [0x0430] = 0x557a, [0x0431] = 0x557d, [0x0432] = 0x557f,
  [0x0433] = 0x5585, [0x0434] = 0x5586, [0x0435] = 0x558c, [0x0436] = 0x558d,
  [0x0437] = 0x558e, [0x0438] = 0x5590, [0x0439] = 0x5592, [0x043a] = 0x5593,
  [0x043b] = 0x5595, [0x043c] = 0x5596, [0x043d] = 0x5597, [0x043e] = 0x559a,
  [0x043f] = 0x559b, [0x0440] = 0x559e, [0x0441] = 0x55a0, [0x0442] = 0x55a1,
  [0x0443] = 0x55a2, [0x0444] = 0x55a3, [0x0445] = 0x55a4, [0x0446] = 0x55a5,
  [0x0447] = 0x55a6, [0x0448] = 0x55a8, [0x0449] = 0x55a9, [0x044a] = 0x55aa,
  [0x044b] = 0x55ab, [0x044c] = 0x55ac, [0x044d] = 0x55ad, [0x044e] = 0x55ae,
  [0x044f] = 0x55af, [0x0450] = 0x55b0, [0x0451] = 0x55b2, [0x0452] = 0x55b4,
  [0x0453] = 0x55b6, [0x0454] = 0x55b8, [0x0455] = 0x55ba, [0x0456] = 0x55bc,
  [0x0457] = 0x55bf, [0x0458] = 0x55c0, [0x0459] = 0x55c1, [0x045a] = 0x55c2,
  [0x045b] = 0x55c3, [0x045c] = 0x55c6, [0x045d] = 0x55c7, [0x045e] = 0x55c8,
  [0x045f] = 0x55ca, [0x0460] = 0x55cb, [0x0461] = 0x55ce, [0x0462] = 0x55cf,
  [0x0463] = 0x55d0, [0x0464] = 0x55d5, [0x0465] = 0x55d7, [0x0466] = 0x55d8,
  [0x0467] = 0x55d9, [0x0468] = 0x55da, [0x0469] = 0x55db, [0x046a] = 0x55de,
  [0x046b] = 0x55e0, [0x046c] = 0x55e2, [0x046d] = 0x55e7, [0x046e] = 0x55e9,
  [0x046f] = 0x55ed, [0x0470] = 0x55ee, [0x0471] = 0x55f0, [0x0472] = 0x55f1,
  [0x0473] = 0x55f4, [0x0474] = 0x55f6, [0x0475] = 0x55f8, [0x0476] = 0x55f9,
  [0x0477] = 0x55fa, [0x0478] = 0x55fb, [0x0479] = 0x55fc, [0x047a] = 0x55ff,
  [0x047b] = 0x5602, [0x047c] = 0x5603, [0x047d] = 0x5604, [0x047e] = 0x5605,
  [0x0480] = 0x5606, [0x0481] = 0x5607, [0x0482] = 0x560a, [0x0483] = 0x560b,
  [0x0484] = 0x560d, [0x0485] = 0x5610, [0x0486] = 0x5611, [0x0487] = 0x5612,
  [0x0488] = 0x5613, [0x0489] = 0x5614, [0x048a] = 0x5615, [0x048b] = 0x5616,
  [0x048c] = 0x5617, [0x048d] = 0x5619, [0x048e] = 0x561a, [0x048f] = 0x561c,
  [0x0490] = 0x561d, [0x0491] = 0x5620, [0x0492] = 0x5621, [0x0493] = 0x5622,
  [0x0494] = 0x5625, [0x0495] = 0x5626, [0x0496] = 0x5628, [0x0497] = 0x5629,
  [0x0498] = 0x562a, [0x0499] = 0x562b, [0x049a] = 0x562e, [0x049b] = 0x562f,
  [0x049c] = 0x5630, [0x049d] = 0x5633, [0x049e] = 0x5635, [0x049f] = 0x5637,
  [0x04a0] = 0x5638, [0x04a1] = 0x563a, [0x04a2] = 0x563c, [0x04a3] = 0x563d,
  [0x04a4] = 0x563e, [0x04a5] = 0x5640, [0x04a6] = 0x5641, [0x04a7] = 0x5642,
  [0x04a8] = 0x5643, [0x04a9] = 0x5644, [0x04aa] = 0x5645, [0x04ab] = 0x5646,
  [0x04ac] = 0x5647, [0x04ad] = 0x5648, [0x04ae] = 0x5649, [0x04af] = 0x564a,
  [0x04b0] = 0x564b, [0x04b1] = 0x564f, [0x04b2] = 0x5650, [0x04b3] = 0x5651,
  [0x04b4] = 0x5652, [0x04b5] = 0x5653, [0x04b6] = 0x5655, [0x04b7] = 0x5656,
  [0x04b8] = 0x565a, [0x04b9] = 0x565b, [0x04ba] = 0x565d, [0x04bb] = 0x565e,
  [0x04bc] = 0x565f, [0x04bd] = 0x5660, [0x04be] = 0x5661, [0x04c0] = 0x5663,
  [0x04c1] = 0x5665, [0x04c2] = 0x5666, [0x04c3] = 0x5667, [0x04c4] = 0x566d,
  [0x04c5] = 0x566e, [0x04c6] = 0x566f, [0x04c7] = 0x5670, [0x04c8] = 0x5672,
  [0x04c9] = 0x5673, [0x04ca] = 0x5674, [0x04cb] = 0x5675, [0x04cc] = 0x5677,
  [0x04cd] = 0x5678, [0x04ce] = 0x5679, [0x04cf] = 0x567a, [0x04d0] = 0x567d,
  [0x04d1] = 0x567e, [0x04d2] = 0x567f, [0x04d3] = 0x5680, [0x04d4] = 0x5681,
  [0x04d5] = 0x5682, [0x04d6] = 0x5683, [0x04d7] = 0x5684, [0x04d8] = 0x5687,
  [0x04d9] = 0x5688, [0x04da] = 0x5689, [0x04db] = 0x568a, [0x04dc] = 0x568b,
  [0x04dd] = 0x568c, [0x04de] = 0x568d, [0x04df] = 0x5690, [0x04e0] = 0x5691,
  [0x04e1] = 0x5692, [0x04e2] = 0x5694, [0x04e3] = 0x5695, [0x04e4] = 0x5696,
  [0x04e5] = 0x5697, [0x04e6] = 0x5698, [0x04e7] = 0x5699, [0x04e8] = 0x569a,
  [0x04e9] = 0x569b, [0x04ea] = 0x569c, [0x04eb] = 0x569d, [0x04ec] = 0x569e,
  [0x04ed] = 0x569f, [0x04ee] = 0x56a0, [0x04ef] = 0x56a1, [0x04f0] = 0x56a2,
  [0x04f1] = 0x56a4, [0x04f2] = 0x56a5, [0x04f3] = 0x56a6, [0x04f4] = 0x56a7,
  [0x04f5] = 0x56a8, [0x04f6] = 0x56a9, [0x04f7] = 0x56aa, [0x04f8] = 0x56ab,
  [0x04f9] = 0x56ac, [0x04fa] = 0x56ad, [0x04fb] = 0x56ae, [0x04fc] = 0x56b0,
  [0x04fd] = 0x56b1, [0x04fe] = 0x56b2, [0x04ff] = 0x56b3, [0x0500] = 0x56b4,
  [0x0501] = 0x56b5, [0x0502] = 0x56b6, [0x0503] = 0x56b8, [0x0504] = 0x56b9,
  [0x0505] = 0x56ba, [0x0506] = 0x56bb, [0x0507] = 0x56bd, [0x0508] = 0x56be,
  [0x0509] = 0x56bf, [0x050a] = 0x56c0, [0x050b] = 0x56c1, [0x050c] = 0x56c2,
  [0x050d] = 0x56c3, [0x050e] = 0x56c4, [0x050f] = 0x56c5, [0x0510] = 0x56c6,
  [0x0511] = 0x56c7, [0x0512] = 0x56c8, [0x0513] = 0x56c9, [0x0514] = 0x56cb,
  [0x0515] = 0x56cc, [0x0516] = 0x56cd, [0x0517] = 0x56ce, [0x0518] = 0x56cf,
  [0x0519] = 0x56d0, [0x051a] = 0x56d1, [0x051b] = 0x56d2, [0x051c] = 0x56d3,
  [0x051d] = 0x56d5, [0x051e] = 0x56d6, [0x051f] = 0x56d8, [0x0520] = 0x56d9,
  [0x0521] = 0x56dc, [0x0522] = 0x56e3, [0x0523] = 0x56e5, [0x0524] = 0x56e6,
  [0x0525] = 0x56e7, [0x0526] = 0x56e8, [0x0527] = 0x56e9, [0x0528] = 0x56ea,
  [0x0529] = 0x56ec, [0x052a] = 0x56ee, [0x052b] = 0x56ef, [0x052c] = 0x56f2,
  [0x052d] = 0x56f3, [0x052e] = 0x56f6, [0x052f] = 0x56f7, [0x0530] = 0x56f8,
  [0x0531] = 0x56fb, [0x0532] = 0x56fc, [0x0533] = 0x5700, [0x0534] = 0x5701,
  [0x0535] = 0x5702, [0x0536] = 0x5705, [0x0537] = 0x5707, [0x0538] = 0x570b,
  [0x0539] = 0x570c, [0x053a] = 0x570d, [0x053b] = 0x570e, [0x053c] = 0x570f,
  [0x053d] = 0x5710, [0x053e] = 0x5711, [0x0540] = 0x5712, [0x0541] = 0x5713,
  [0x0542] = 0x5714, [0x0543] = 0x5715, [0x0544] = 0x5716, [0x0545] = 0x5717,
  [0x0546] = 0x5718, [0x0547] = 0x5719, [0x0548] = 0x571a, [0x0549] = 0x571b,
  [0x054a] = 0x571d, [0x054b] = 0x571e, [0x054c] = 0x5720, [0x054d] = 0x5721,
  [0x054e] = 0x5722, [0x054f] = 0x5724, [0x0550] = 0x5725, [0x0551] = 0x5726,
  [0x0552] = 0x5727, [0x0553] = 0x572b, [0x0554] = 0x5731, [0x0555] = 0x5732,
  [0x0556] = 0x5734, [0x0557] = 0x5735, [0x0558] = 0x5736, [0x0559] = 0x5737,
  [0x055a] = 0x5738, [0x055b] = 0x573c, [0x055c] = 0x573d, [0x055d] = 0x573f,
  [0x055e] = 0x5741, [0x055f] = 0x5743, [0x0560] = 0x5744, [0x0561] = 0x5745,
  [0x0562] = 0x5746, [0x0563] = 0x5748, [0x0564] = 0x5749, [0x0565] = 0x574b,
  [0x0566] = 0x5752, [0x0567] = 0x5753, [0x0568] = 0x5754, [0x0569] = 0x5755,
  [0x056a] = 0x5756, [0x056b] = 0x5758, [0x056c] = 0x5759, [0x056d] = 0x5762,
  [0x056e] = 0x5763, [0x056f] = 0x5765, [0x0570] = 0x5767, [0x0571] = 0x576c,
  [0x0572] = 0x576e, [0x0573] = 0x5770, [0x0574] = 0x5771, [0x0575] = 0x5772,
  [0x0576] = 0x5774, [0x0577] = 0x5775, [0x0578] = 0x5778, [0x0579] = 0x5779,
  [0x057a] = 0x577a, [0x057b] = 0x577d, [0x057c] = 0x577e, [0x057d] = 0x577f,
  [0x057e] = 0x5780, [0x0580] = 0x5781, [0x0581] = 0x5787, [0x0582] = 0x5788,
  [0x0583] = 0x5789, [0x0584] = 0x578a, [0x0585] = 0x578d, [0x0586] = 0x578e,
  [0x0587] = 0x578f, [0x0588] = 0x5790, [0x0589] = 0x5791, [0x058a] = 0x5794,
  [0x058b] = 0x5795, [0x058c] = 0x5796, [0x058d] = 0x5797, [0x058e] = 0x5798,
  [0x058f] = 0x5799, [0x0590] = 0x579a, [0x0591] = 0x579c, [0x0592] = 0x579d,
  [0x0593] = 0x579e, [0x0594] = 0x579f, [0x0595] = 0x57a5, [0x0596] = 0x57a8,
  [0x0597] = 0x57aa, [0x0598] = 0x57ac, [0x0599] = 0x57af, [0x059a] = 0x57b0,
  [0x059b] = 0x57b1, [0x059c] = 0x57b3, [0x059d] = 0x57b5, [0x059e] = 0x57b6,
  [0x059f] = 0x57b7, [0x05a0] = 0x57b9, [0x05a1] = 0x57ba, [0x05a2] = 0x57bb,
  [0x05a3] = 0x57bc, [0x05a4] = 0x57bd, [0x05a5] = 0x57be, [0x05a6] = 0x57bf,
  [0x05a7] = 0x57c0, [0x05a8] = 0x57c1, [0x05a9] = 0x57c4, [0x05aa] = 0x57c5,
  [0x05ab] = 0x57c6, [0x05ac] = 0x57c7, [0x05ad] = 0x57c8, [0x05ae] = 0x57c9,
  [0x05af] = 0x57ca, [0x05b0] = 0x57cc, [0x05b1] = 0x57cd, [0x05b2] = 0x57d0,
  [0x05b3] = 0x57d1, [0x05b4] = 0x57d3, [0x05b5] = 0x57d6, [0x05b6] = 0x57d7,
  [0x05b7] = 0x57db, [0x05b8] = 0x57dc, [0x05b9] = 0x57de, [0x05ba] = 0x57e1,
  [0x05bb] = 0x57e2, [0x05bc] = 0x57e3, [0x05bd] = 0x57e5, [0x05be] = 0x57e6,
  [0x05bf] = 0x57e7, [0x05c0] = 0x57e8, [0x05c1] = 0x57e9, [0x05c2] = 0x57ea,
  [0x05c3] = 0x57eb, [0x05c4] = 0x57ec, [0x05c5] = 0x57ee, [0x05c6] = 0x57f0,
  [0x05c7] = 0x57f1, [0x05c8] = 0x57f2, [0x05c9] = 0x57f3, [0x05ca] = 0x57f5,
  [0x05cb] = 0x57f6, [0x05cc] = 0x57f7, [0x05cd] = 0x57fb, [0x05ce] = 0x57fc,
  [0x05cf] = 0x57fe, [0x05d0] = 0x57ff, [0x05d1] = 0x5801, [0x05d2] = 0x5803,
  [0x05d3] = 0x5804, [0x05d4] = 0x5805, [0x05d5] = 0x5808, [0x05d6] = 0x5809,
  [0x05d7] = 0x580a, [0x05d8] = 0x580c, [0x05d9] = 0x580e, [0x05da] = 0x580f,
  [0x05db] = 0x5810, [0x05dc] = 0x5812, [0x05dd] = 0x5813, [0x05de] = 0x5814,
  [0x05df] = 0x5816, [0x05e0] = 0x5817, [0x05e1] = 0x5818, [0x05e2] = 0x581a,
  [0x05e3] = 0x581b, [0x05e4] = 0x581c, [0x05e5] = 0x581d, [0x05e6] = 0x581f,
  [0x05e7] = 0x5822, [0x05e8] = 0x5823, [0x05e9] = 0x5825, [0x05ea] = 0x5826,
  [0x05eb] = 0x5827, [0x05ec] = 0x5828, [0x05ed] = 0x5829, [0x05ee] = 0x582b,
  [0x05ef] = 0x582c, [0x05f0] = 0x582d, [0x05f1] = 0x582e, [0x05f2] = 0x582f,
  [0x05f3] = 0x5831, [0x05f4] = 0x5832, [0x05f5] = 0x5833, [0x05f6] = 0x5834,
  [0x05f7] = 0x5836, [0x05f8] = 0x5837, [0x05f9] = 0x5838, [0x05fa] = 0x5839,
  [0x05fb] = 0x583a, [0x05fc] = 0x583b, [0x05fd] = 0x583c, [0x05fe] = 0x583d,
  [0x0600] = 0x583e, [0x0601] = 0x583f, [0x0602] = 0x5840, [0x0603] = 0x5841,
  [0x0604] = 0x5842, [0x0605] = 0x5843, [0x0606] = 0x5845, [0x0607] = 0x5846,
  [0x0608] = 0x5847, [0x0609] = 0x5848, [0x060a] = 0x5849, [0x060b] = 0x584a,
  [0x060c] = 0x584b, [0x060d] = 0x584e, [0x060e] = 0x584f, [0x060f] = 0x5850,
  [0x0610] = 0x5852, [0x0611] = 0x5853, [0x0612] = 0x5855, [0x0613] = 0x5856,
  [0x0614] = 0x5857, [0x0615] = 0x5859, [0x0616] = 0x585a, [0x0617] = 0x585b,
  [0x0618] = 0x585c, [0x0619] = 0x585d, [0x061a] = 0x585f, [0x061b] = 0x5860,
  [0x061c] = 0x5861, [0x061d] = 0x5862, [0x061e] = 0x5863, [0x061f] = 0x5864,
  [0x0620] = 0x5866, [0x0621] = 0x5867, [0x0622] = 0x5868, [0x0623] = 0x5869,
  [0x0624] = 0x586a, [0x0625] = 0x586d, [0x0626] = 0x586e, [0x0627] = 0x586f,
  [0x0628] = 0x5870, [0x0629] = 0x5871, [0x062a] = 0x5872, [0x062b] = 0x5873,
  [0x062c] = 0x5874, [0x062d] = 0x5875, [0x062e] = 0x5876, [0x062f] = 0x5877,
  [0x0630] = 0x5878, [0x0631] = 0x5879, [0x0632] = 0x587a, [0x0633] = 0x587b,
  [0x0634] = 0x587c, [0x0635] = 0x587d, [0x0636] = 0x587f, [0x0637] = 0x5882,
  [0x0638] = 0x5884, [0x0639] = 0x5886, [0x063a] = 0x5887, [0x063b] = 0x5888,
  [0x063c] = 0x588a, [0x063d] = 0x588b, [0x063e] = 0x588c, [0x0640] = 0x588d,
  [0x0641] = 0x588e, [0x0642] = 0x588f, [0x0643] = 0x5890, [0x0644] = 0x5891,
  [0x0645] = 0x5894, [0x0646] = 0x5895, [0x0647] = 0x5896, [0x0648] = 0x5897,
  [0x0649] = 0x5898, [0x064a] = 0x589b, [0x064b] = 0x589c, [0x064c] = 0x589d,
  [0x064d] = 0x58a0, [0x064e] = 0x58a1, [0x064f] = 0x58a2, [0x0650] = 0x58a3,
  [0x0651] = 0x58a4, [0x0652] = 0x58a5, [0x0653] = 0x58a6, [0x0654] = 0x58a7,
  [0x0655] = 0x58aa, [0x0656] = 0x58ab, [0x0657] = 0x58ac, [0x0658] = 0x58ad,
  [0x0659] = 0x58ae, [0x065a] = 0x58af, [0x065b] = 0x58b0, [0x065c] = 0x58b1,
  [0x065d] = 0x58b2, [0x065e] = 0x58b3, [0x065f] = 0x58b4, [0x0660] = 0x58b5,
  [0x0661] = 0x58b6, [0x0662] = 0x58b7, [0x0663] = 0x58b8, [0x0664] = 0x58b9,
  [0x0665] = 0x58ba, [0x0666] = 0x58bb, [0x0667] = 0x58bd, [0x0668] = 0x58be,
  [0x0669] = 0x58bf, [0x066a] = 0x58c0, [0x066b] = 0x58c2, [0x066c] = 0x58c3,
  [0x066d] = 0x58c4, [0x066e] = 0x58c6, [0x066f] = 0x58c7, [0x0670] = 0x58c8,
  [0x0671] = 0x58c9, [0x0672] = 0x58ca, [0x0673] = 0x58cb, [0x0674] = 0x58cc,
  [0x0675] = 0x58cd, [0x0676] = 0x58ce, [0x0677] = 0x58cf, [0x0678] = 0x58d0,
  [0x0679] = 0x58d2, [0x067a] = 0x58d3, [0x067b] = 0x58d4, [0x067c] = 0x58d6,
  [0x067d] = 0x58d7, [0x067e] = 0x58d8, [0x067f] = 0x58d9, [0x0680] = 0x58da,
  [0x0681] = 0x58db, [0x0682] = 0x58dc, [0x0683] = 0x58dd, [0x0684] = 0x58de,
  [0x0685] = 0x58df, [0x0686] = 0x58e0, [0x0687] = 0x58e1, [0x0688] = 0x58e2,
  [0x0689] = 0x58e3, [0x068a] = 0x58e5, [0x068b] = 0x58e6, [0x068c] = 0x58e7,
  [0x068d] = 0x58e8, [0x068e] = 0x58e9, [0x068f] = 0x58ea, [0x0690] = 0x58ed,
  [0x0691] = 0x58ef, [0x0692] = 0x58f1, [0x0693] = 0x58f2, [0x0694] = 0x58f4,
  [0x0695] = 0x58f5, [0x0696] = 0x58f7, [0x0697] = 0x58f8, [0x0698] = 0x58fa,
  [0x0699] = 0x58fb, [0x069a] = 0x58fc, [0x069b] = 0x58fd, [0x069c] = 0x58fe,
  [0x069d] = 0x58ff, [0x069e] = 0x5900, [0x069f] = 0x5901, [0x06a0] = 0x5903,
  [0x06a1] = 0x5905, [0x06a2] = 0x5906, [0x06a3] = 0x5908, [0x06a4] = 0x5909,
  [0x06a5] = 0x590a, [0x06a6] = 0x590b, [0x06a7] = 0x590c, [0x06a8] = 0x590e,
  [0x06a9] = 0x5910, [0x06aa] = 0x5911, [0x06ab] = 0x5912, [0x06ac] = 0x5913,
  [0x06ad] = 0x5917, [0x06ae] = 0x5918, [0x06af] = 0x591b, [0x06b0] = 0x591d,
  [0x06b1] = 0x591e, [0x06b2] = 0x5920, [0x06b3] = 0x5921, [0x06b4] = 0x5922,
  [0x06b5] = 0x5923, [0x06b6] = 0x5926, [0x06b7] = 0x5928, [0x06b8] = 0x592c,
  [0x06b9] = 0x5930, [0x06ba] = 0x5932, [0x06bb] = 0x5933, [0x06bc] = 0x5935,
  [0x06bd] = 0x5936, [0x06be] = 0x593b, [0x06c0] = 0x593d, [0x06c1] = 0x593e,
  [0x06c2] = 0x593f, [0x06c3] = 0x5940, [0x06c4] = 0x5943, [0x06c5] = 0x5945,
  [0x06c6] = 0x5946, [0x06c7] = 0x594a, [0x06c8] = 0x594c, [0x06c9] = 0x594d,
  [0x06ca] = 0x5950, [0x06cb] = 0x5952, [0x06cc] = 0x5953, [0x06cd] = 0x5959,
  [0x06ce] = 0x595b, [0x06cf] = 0x595c, [0x06d0] = 0x595d, [0x06d1] = 0x595e,
  [0x06d2] = 0x595f, [0x06d3] = 0x5961, [0x06d4] = 0x5963, [0x06d5] = 0x5964,
  [0x06d6] = 0x5966, [0x06d7] = 0x5967, [0x06d8] = 0x5968, [0x06d9] = 0x5969,
  [0x06da] = 0x596a, [0x06db] = 0x596b, [0x06dc] = 0x596c, [0x06dd] = 0x596d,
  [0x06de] = 0x596e, [0x06df] = 0x596f, [0x06e0] = 0x5970, [0x06e1] = 0x5971,
  [0x06e2] = 0x5972, [0x06e3] = 0x5975, [0x06e4] = 0x5977, [0x06e5] = 0x597a,
  [0x06e6] = 0x597b, [0x06e7] = 0x597c, [0x06e8] = 0x597e, [0x06e9] = 0x597f,
  [0x06ea] = 0x5980, [0x06eb] = 0x5985, [0x06ec] = 0x5989, [0x06ed] = 0x598b,
  [0x06ee] = 0x598c, [0x06ef] = 0x598e, [0x06f0] = 0x598f, [0x06f1] = 0x5990,
  [0x06f2] = 0x5991, [0x06f3] = 0x5994, [0x06f4] = 0x5995, [0x06f5] = 0x5998,
  [0x06f6] = 0x599a, [0x06f7] = 0x599b, [0x06f8] = 0x599c, [0x06f9] = 0x599d,
  [0x06fa] = 0x599f, [0x06fb] = 0x59a0, [0x06fc] = 0x59a1, [0x06fd] = 0x59a2,
  [0x06fe] = 0x59a6, [0x0700] = 0x59a7, [0x0701] = 0x59ac, [0x0702] = 0x59ad,
  [0x0703] = 0x59b0, [0x0704] = 0x59b1, [0x0705] = 0x59b3, [0x0706] = 0x59b4,
  [0x0707] = 0x59b5, [0x0708] = 0x59b6, [0x0709] = 0x59b7, [0x070a] = 0x59b8,
  [0x070b] = 0x59ba, [0x070c] = 0x59bc, [0x070d] = 0x59bd, [0x070e] = 0x59bf,
  [0x070f] = 0x59c0, [0x0710] = 0x59c1, [0x0711] = 0x59c2, [0x0712] = 0x59c3,
  [0x0713] = 0x59c4, [0x0714] = 0x59c5, [0x0715] = 0x59c7, [0x0716] = 0x59c8,
  [0x0717] = 0x59c9, [0x0718] = 0x59cc, [0x0719] = 0x59cd, [0x071a] = 0x59ce,
  [0x071b] = 0x59cf, [0x071c] = 0x59d5, [0x071d] = 0x59d6, [0x071e] = 0x59d9,
  [0x071f] = 0x59db, [0x0720] = 0x59de, [0x0721] = 0x59df, [0x0722] = 0x59e0,
  [0x0723] = 0x59e1, [0x0724] = 0x59e2, [0x0725] = 0x59e4, [0x0726] = 0x59e6,
  [0x0727] = 0x59e7, [0x0728] = 0x59e9, [0x0729] = 0x59ea, [0x072a] = 0x59eb,
  [0x072b] = 0x59ed, [0x072c] = 0x59ee, [0x072d] = 0x59ef, [0x072e] = 0x59f0,
  [0x072f] = 0x59f1, [0x0730] = 0x59f2, [0x0731] = 0x59f3, [0x0732] = 0x59f4,
  [0x0733] = 0x59f5, [0x0734] = 0x59f6, [0x0735] = 0x59f7, [0x0736] = 0x59f8,
  [0x0737] = 0x59fa, [0x0738] = 0x59fc, [0x0739] = 0x59fd, [0x073a] = 0x59fe,
  [0x073b] = 0x5a00, [0x073c] = 0x5a02, [0x073d] = 0x5a0a, [0x073e] = 0x5a0b,
  [0x073f] = 0x5a0d, [0x0740] = 0x5a0e, [0x0741] = 0x5a0f, [0x0742] = 0x5a10,
  [0x0743] = 0x5a12, [0x0744] = 0x5a14, [0x0745] = 0x5a15, [0x0746] = 0x5a16,
  [0x0747] = 0x5a17, [0x0748] = 0x5a19, [0x0749] = 0x5a1a, [0x074a] = 0x5a1b,
  [0x074b] = 0x5a1d, [0x074c] = 0x5a1e, [0x074d] = 0x5a21, [0x074e] = 0x5a22,
  [0x074f] = 0x5a24, [0x0750] = 0x5a26, [0x0751] = 0x5a27, [0x0752] = 0x5a28,
  [0x0753] = 0x5a2a, [0x0754] = 0x5a2b, [0x0755] = 0x5a2c, [0x0756] = 0x5a2d,
  [0x0757] = 0x5a2e, [0x0758] = 0x5a2f, [0x0759] = 0x5a30, [0x075a] = 0x5a33,
  [0x075b] = 0x5a35, [0x075c] = 0x5a37, [0x075d] = 0x5a38, [0x075e] = 0x5a39,
  [0x075f] = 0x5a3a, [0x0760] = 0x5a3b, [0x0761] = 0x5a3d, [0x0762] = 0x5a3e,
  [0x0763] = 0x5a3f, [0x0764] = 0x5a41, [0x0765] = 0x5a42, [0x0766] = 0x5a43,
  [0x0767] = 0x5a44, [0x0768] = 0x5a45, [0x0769] = 0x5a47, [0x076a] = 0x5a48,
  [0x076b] = 0x5a4b, [0x076c] = 0x5a4c, [0x076d] = 0x5a4d, [0x076e] = 0x5a4e,
  [0x076f] = 0x5a4f, [0x0770] = 0x5a50, [0x0771] = 0x5a51, [0x0772] = 0x5a52,
  [0x0773] = 0x5a53, [0x0774] = 0x5a54, [0x0775] = 0x5a56, [0x0776] = 0x5a57,
  [0x0777] = 0x5a58, [0x0778] = 0x5a59, [0x0779] = 0x5a5b, [0x077a] = 0x5a5c,
  [0x077b] = 0x5a5d, [0x077c] = 0x5a5e, [0x077d] = 0x5a5f, [0x077e] = 0x5a60,
  [0x0780] = 0x5a61, [0x0781] = 0x5a63, [0x0782] = 0x5a64, [0x0783] = 0x5a65,
  [0x0784] = 0x5a66, [0x0785] = 0x5a68, [0x0786] = 0x5a69, [0x0787] = 0x5a6b,
  [0x0788] = 0x5a6c, [0x0789] = 0x5a6d, [0x078a] = 0x5a6e, [0x078b] = 0x5a6f,
  [0x078c] = 0x5a70, [0x078d] = 0x5a71, [0x078e] = 0x5a72, [0x078f] = 0x5a73,
  [0x0790] = 0x5a78, [0x0791] = 0x5a79, [0x0792] = 0x5a7b, [0x0793] = 0x5a7c,
  [0x0794] = 0x5a7d, [0x0795] = 0x5a7e, [0x0796] = 0x5a80, [0x0797] = 0x5a81,
  [0x0798] = 0x5a82, [0x0799] = 0x5a83, [0x079a] = 0x5a84, [0x079b] = 0x5a85,
  [0x079c] = 0x5a86, [0x079d] = 0x5a87, [0x079e] = 0x5a88, [0x079f] = 0x5a89,
  [0x07a0] = 0x5a8a, [0x07a1] = 0x5a8b, [0x07a2] = 0x5a8c, [0x07a3] = 0x5a8d,
  [0x07a4] = 0x5a8e, [0x07a5] = 0x5a8f, [0x07a6] = 0x5a90, [0x07a7] = 0x5a91,
  [0x07a8] = 0x5a93, [0x07a9] = 0x5a94, [0x07aa] = 0x5a95, [0x07ab] = 0x5a96,
  [0x07ac] = 0x5a97, [0x07ad] = 0x5a98, [0x07ae] = 0x5a99, [0x07af] = 0x5a9c,
  [0x07b0] = 0x5a9d, [0x07b1] = 0x5a9e, [0x07b2] = 0x5a9f, [0x07b3] = 0x5aa0,
  [0x07b4] = 0x5aa1, [0x07b5] = 0x5aa2, [0x07b6] = 0x5aa3, [0x07b7] = 0x5aa4,
  [0x07b8] = 0x5aa5, [0x07b9] = 0x5aa6, [0x07ba] = 0x5aa7, [0x07bb] = 0x5aa8,
  [0x07bc] = 0x5aa9, [0x07bd] = 0x5aab, [0x07be] = 0x5aac, [0x07c0] = 0x5aad,
  [0x07c1] = 0x5aae, [0x07c2] = 0x5aaf, [0x07c3] = 0x5ab0, [0x07c4] = 0x5ab1,
  [0x07c5] = 0x5ab4, [0x07c6] = 0x5ab6, [0x07c7] = 0x5ab7, [0x07c8] = 0x5ab9,
  [0x07c9] = 0x5aba, [0x07ca] = 0x5abb, [0x07cb] = 0x5abc, [0x07cc] = 0x5abd,
  [0x07cd] = 0x5abf, [0x07ce] = 0x5ac0, [0x07cf] = 0x5ac3, [0x07d0] = 0x5ac4,
  [0x07d1] = 0x5ac5, [0x07d2] = 0x5ac6, [0x07d3] = 0x5ac7, [0x07d4] = 0x5ac8,
  [0x07d5] = 0x5aca, [0x07d6] = 0x5acb, [0x07d7] = 0x5acd, [0x07d8] = 0x5ace,
  [0x07d9] = 0x5acf, [0x07da] = 0x5ad0, [0x07db] = 0x5ad1, [0x07dc] = 0x5ad3,
  [0x07dd] = 0x5ad5, [0x07de] = 0x5ad7, [0x07df] = 0x5ad9, [0x07e0] = 0x5ada,
  [0x07e1] = 0x5adb, [0x07e2] = 0x5add, [0x07e3] = 0x5ade, [0x07e4] = 0x5adf,
  [0x07e5] = 0x5ae2, [0x07e6] = 0x5ae4, [0x07e7] = 0x5ae5, [0x07e8] = 0x5ae7,
  [0x07e9] = 0x5ae8, [0x07ea] = 0x5aea, [0x07eb] = 0x5aec, [0x07ec] = 0x5aed,
  [0x07ed] = 0x5aee, [0x07ee] = 0x5aef, [0x07ef] = 0x5af0, [0x07f0] = 0x5af2,
  [0x07f1] = 0x5af3, [0x07f2] = 0x5af4, [0x07f3] = 0x5af5, [0x07f4] = 0x5af6,
  [0x07f5] = 0x5af7, [0x07f6] = 0x5af8, [0x07f7] = 0x5af9, [0x07f8] = 0x5afa,
  [0x07f9] = 0x5afb, [0x07fa] = 0x5afc, [0x07fb] = 0x5afd, [0x07fc] = 0x5afe,
  [0x07fd] = 0x5aff, [0x07fe] = 0x5b00, [0x07ff] = 0x5b01, [0x0800] = 0x5b02,
  [0x0801] = 0x5b03, [0x0802] = 0x5b04, [0x0803] = 0x5b05, [0x0804] = 0x5b06,
  [0x0805] = 0x5b07, [0x0806] = 0x5b08, [0x0807] = 0x5b0a, [0x0808] = 0x5b0b,
  [0x0809] = 0x5b0c, [0x080a] = 0x5b0d, [0x080b] = 0x5b0e, [0x080c] = 0x5b0f,
  [0x080d] = 0x5b10, [0x080e] = 0x5b11, [0x080f] = 0x5b12, [0x0810] = 0x5b13,
  [0x0811] = 0x5b14, [0x0812] = 0x5b15, [0x0813] = 0x5b18, [0x0814] = 0x5b19,
  [0x0815] = 0x5b1a, [0x0816] = 0x5b1b, [0x0817] = 0x5b1c, [0x0818] = 0x5b1d,
  [0x0819] = 0x5b1e, [0x081a] = 0x5b1f, [0x081b] = 0x5b20, [0x081c] = 0x5b21,
  [0x081d] = 0x5b22, [0x081e] = 0x5b23, [0x081f] = 0x5b24, [0x0820] = 0x5b25,
  [0x0821] = 0x5b26, [0x0822] = 0x5b27, [0x0823] = 0x5b28, [0x0824] = 0x5b29,
  [0x0825] = 0x5b2a, [0x0826] = 0x5b2b, [0x0827] = 0x5b2c, [0x0828] = 0x5b2d,
  [0x0829] = 0x5b2e, [0x082a] = 0x5b2f, [0x082b] = 0x5b30, [0x082c] = 0x5b31,
  [0x082d] = 0x5b33, [0x082e] = 0x5b35, [0x082f] = 0x5b36, [0x0830] = 0x5b38,
  [0x0831] = 0x5b39, [0x0832] = 0x5b3a, [0x0833] = 0x5b3b, [0x0834] = 0x5b3c,
  [0x0835] = 0x5b3d, [0x0836] = 0x5b3e, [0x0837] = 0x5b3f, [0x0838] = 0x5b41,
  [0x0839] = 0x5b42, [0x083a] = 0x5b43, [0x083b] = 0x5b44, [0x083c] = 0x5b45,
  [0x083d] = 0x5b46, [0x083e] = 0x5b47, [0x0840] = 0x5b48, [0x0841] = 0x5b49,
  [0x0842] = 0x5b4a, [0x0843] = 0x5b4b, [0x0844] = 0x5b4c, [0x0845] = 0x5b4d,
  [0x0846] = 0x5b4e, [0x0847] = 0x5b4f, [0x0848] = 0x5b52, [0x0849] = 0x5b56,
  [0x084a] = 0x5b5e, [0x084b] = 0x5b60, [0x084c] = 0x5b61, [0x084d] = 0x5b67,
  [0x084e] = 0x5b68, [0x084f] = 0x5b6b, [0x0850] = 0x5b6d, [0x0851] = 0x5b6e,
  [0x0852] = 0x5b6f, [0x0853] = 0x5b72, [0x0854] = 0x5b74, [0x0855] = 0x5b76,
  [0x0856] = 0x5b77, [0x0857] = 0x5b78, [0x0858] = 0x5b79, [0x0859] = 0x5b7b,
  [0x085a] = 0x5b7c, [0x085b] = 0x5b7e, [0x085c] = 0x5b7f, [0x085d] = 0x5b82,
  [0x085e] = 0x5b86, [0x085f] = 0x5b8a, [0x0860] = 0x5b8d, [0x0861] = 0x5b8e,
  [0x0862] = 0x5b90, [0x0863] = 0x5b91, [0x0864] = 0x5b92, [0x0865] = 0x5b94,
  [0x0866] = 0x5b96, [0x0867] = 0x5b9f, [0x0868] = 0x5ba7, [0x0869] = 0x5ba8,
  [0x086a] = 0x5ba9, [0x086b] = 0x5bac, [0x086c] = 0x5bad, [0x086d] = 0x5bae,
  [0x086e] = 0x5baf, [0x086f] = 0x5bb1, [0x0870] = 0x5bb2, [0x0871] = 0x5bb7,
  [0x0872] = 0x5bba, [0x0873] = 0x5bbb, [0x0874] = 0x5bbc, [0x0875] = 0x5bc0,
  [0x0876] = 0x5bc1, [0x0877] = 0x5bc3, [0x0878] = 0x5bc8, [0x0879] = 0x5bc9,
  [0x087a] = 0x5bca, [0x087b] = 0x5bcb, [0x087c] = 0x5bcd, [0x087d] = 0x5bce,
  [0x087e] = 0x5bcf, [0x0880] = 0x5bd1, [0x0881] = 0x5bd4, [0x0882] = 0x5bd5,
  [0x0883] = 0x5bd6, [0x0884] = 0x5bd7, [0x0885] = 0x5bd8, [0x0886] = 0x5bd9,
  [0x0887] = 0x5bda, [0x0888] = 0x5bdb, [0x0889] = 0x5bdc, [0x088a] = 0x5be0,
  [0x088b] = 0x5be2, [0x088c] = 0x5be3, [0x088d] = 0x5be6, [0x088e] = 0x5be7,
  [0x088f] = 0x5be9, [0x0890] = 0x5bea, [0x0891] = 0x5beb, [0x0892] = 0x5bec,
  [0x0893] = 0x5bed, [0x0894] = 0x5bef, [0x0895] = 0x5bf1, [0x0896] = 0x5bf2,
  [0x0897] = 0x5bf3, [0x0898] = 0x5bf4, [0x0899] = 0x5bf5, [0x089a] = 0x5bf6,
  [0x089b] = 0x5bf7, [0x089c] = 0x5bfd, [0x089d] = 0x5bfe, [0x089e] = 0x5c00,
  [0x089f] = 0x5c02, [0x08a0] = 0x5c03, [0x08a1] = 0x5c05, [0x08a2] = 0x5c07,
  [0x08a3] = 0x5c08, [0x08a4] = 0x5c0b, [0x08a5] = 0x5c0c, [0x08a6] = 0x5c0d,
  [0x08a7] = 0x5c0e, [0x08a8] = 0x5c10, [0x08a9] = 0x5c12, [0x08aa] = 0x5c13,
  [0x08ab] = 0x5c17, [0x08ac] = 0x5c19, [0x08ad] = 0x5c1b, [0x08ae] = 0x5c1e,
  [0x08af] = 0x5c1f, [0x08b0] = 0x5c20, [0x08b1] = 0x5c21, [0x08b2] = 0x5c23,
  [0x08b3] = 0x5c26, [0x08b4] = 0x5c28, [0x08b5] = 0x5c29, [0x08b6] = 0x5c2a,
  [0x08b7] = 0x5c2b, [0x08b8] = 0x5c2d, [0x08b9] = 0x5c2e, [0x08ba] = 0x5c2f,
  [0x08bb] = 0x5c30, [0x08bc] = 0x5c32, [0x08bd] = 0x5c33, [0x08be] = 0x5c35,
  [0x08bf] = 0x5c36, [0x08c0] = 0x5c37, [0x08c1] = 0x5c43, [0x08c2] = 0x5c44,
  [0x08c3] = 0x5c46, [0x08c4] = 0x5c47, [0x08c5] = 0x5c4c, [0x08c6] = 0x5c4d,
  [0x08c7] = 0x5c52, [0x08c8] = 0x5c53, [0x08c9] = 0x5c54, [0x08ca] = 0x5c56,
  [0x08cb] = 0x5c57, [0x08cc] = 0x5c58, [0x08cd] = 0x5c5a, [0x08ce] = 0x5c5b,
  [0x08cf] = 0x5c5c, [0x08d0] = 0x5c5d, [0x08d1] = 0x5c5f, [0x08d2] = 0x5c62,
  [0x08d3] = 0x5c64, [0x08d4] = 0x5c67, [0x08d5] = 0x5c68, [0x08d6] = 0x5c69,
  [0x08d7] = 0x5c6a, [0x08d8] = 0x5c6b, [0x08d9] = 0x5c6c, [0x08da] = 0x5c6d,
  [0x08db] = 0x5c70, [0x08dc] = 0x5c72, [0x08dd] = 0x5c73, [0x08de] = 0x5c74,
  [0x08df] = 0x5c75, [0x08e0] = 0x5c76, [0x08e1] = 0x5c77, [0x08e2] = 0x5c78,
  [0x08e3] = 0x5c7b, [0x08e4] = 0x5c7c, [0x08e5] = 0x5c7d, [0x08e6] = 0x5c7e,
  [0x08e7] = 0x5c80, [0x08e8] = 0x5c83, [0x08e9] = 0x5c84, [0x08ea] = 0x5c85,
  [0x08eb] = 0x5c86, [0x08ec] = 0x5c87, [0x08ed] = 0x5c89, [0x08ee] = 0x5c8a,
  [0x08ef] = 0x5c8b, [0x08f0] = 0x5c8e, [0x08f1] = 0x5c8f, [0x08f2] = 0x5c92,
  [0x08f3] = 0x5c93, [0x08f4] = 0x5c95, [0x08f5] = 0x5c9d, [0x08f6] = 0x5c9e,
  [0x08f7] = 0x5c9f, [0x08f8] = 0x5ca0, [0x08f9] = 0x5ca1, [0x08fa] = 0x5ca4,
  [0x08fb] = 0x5ca5, [0x08fc] = 0x5ca6, [0x08fd] = 0x5ca7, [0x08fe] = 0x5ca8,
  [0x0900] = 0x5caa, [0x0901] = 0x5cae, [0x0902] = 0x5caf, [0x0903] = 0x5cb0,
  [0x0904] = 0x5cb2, [0x0905] = 0x5cb4, [0x0906] = 0x5cb6, [0x0907] = 0x5cb9,
  [0x0908] = 0x5cba, [0x0909] = 0x5cbb, [0x090a] = 0x5cbc, [0x090b] = 0x5cbe,
  [0x090c] = 0x5cc0, [0x090d] = 0x5cc2, [0x090e] = 0x5cc3, [0x090f] = 0x5cc5,
  [0x0910] = 0x5cc6, [0x0911] = 0x5cc7, [0x0912] = 0x5cc8, [0x0913] = 0x5cc9,
  [0x0914] = 0x5cca, [0x0915] = 0x5ccc, [0x0916] = 0x5ccd, [0x0917] = 0x5cce,
  [0x0918] = 0x5ccf, [0x0919] = 0x5cd0, [0x091a] = 0x5cd1, [0x091b] = 0x5cd3,
  [0x091c] = 0x5cd4, [0x091d] = 0x5cd5, [0x091e] = 0x5cd6, [0x091f] = 0x5cd7,
  [0x0920] = 0x5cd8, [0x0921] = 0x5cda, [0x0922] = 0x5cdb, [0x0923] = 0x5cdc,
  [0x0924] = 0x5cdd, [0x0925] = 0x5cde, [0x0926] = 0x5cdf, [0x0927] = 0x5ce0,
  [0x0928] = 0x5ce2, [0x0929] = 0x5ce3, [0x092a] = 0x5ce7, [0x092b] = 0x5ce9,
  [0x092c] = 0x5ceb, [0x092d] = 0x5cec, [0x092e] = 0x5cee, [0x092f] = 0x5cef,
  [0x0930] = 0x5cf1, [0x0931] = 0x5cf2, [0x0932] = 0x5cf3, [0x0933] = 0x5cf4,
  [0x0934] = 0x5cf5, [0x0935] = 0x5cf6, [0x0936] = 0x5cf7, [0x0937] = 0x5cf8,
  [0x0938] = 0x5cf9, [0x0939] = 0x5cfa, [0x093a] = 0x5cfc, [0x093b] = 0x5cfd,
  [0x093c] = 0x5cfe, [0x093d] = 0x5cff, [0x093e] = 0x5d00, [0x0940] = 0x5d01,
  [0x0941] = 0x5d04, [0x0942] = 0x5d05, [0x0943] = 0x5d08, [0x0944] = 0x5d09,
  [0x0945] = 0x5d0a, [0x0946] = 0x5d0b, [0x0947] = 0x5d0c, [0x0948] = 0x5d0d,
  [0x0949] = 0x5d0f, [0x094a] = 0x5d10, [0x094b] = 0x5d11, [0x094c] = 0x5d12,
  [0x094d] = 0x5d13, [0x094e] = 0x5d15, [0x094f] = 0x5d17, [0x0950] = 0x5d18,
  [0x0951] = 0x5d19, [0x0952] = 0x5d1a, [0x0953] = 0x5d1c, [0x0954] = 0x5d1d,
  [0x0955] = 0x5d1f, [0x0956] = 0x5d20, [0x0957] = 0x5d21, [0x0958] = 0x5d22,
  [0x0959] = 0x5d23, [0x095a] = 0x5d25, [0x095b] = 0x5d28, [0x095c] = 0x5d2a,
  [0x095d] = 0x5d2b, [0x095e] = 0x5d2c, [0x095f] = 0x5d2f, [0x0960] = 0x5d30,
  [0x0961] = 0x5d31, [0x0962] = 0x5d32, [0x0963] = 0x5d33, [0x0964] = 0x5d35,
  [0x0965] = 0x5d36, [0x0966] = 0x5d37, [0x0967] = 0x5d38, [0x0968] = 0x5d39,
  [0x0969] = 0x5d3a, [0x096a] = 0x5d3b, [0x096b] = 0x5d3c, [0x096c] = 0x5d3f,
  [0x096d] = 0x5d40, [0x096e] = 0x5d41, [0x096f] = 0x5d42, [0x0970] = 0x5d43,
  [0x0971] = 0x5d44, [0x0972] = 0x5d45, [0x0973] = 0x5d46, [0x0974] = 0x5d48,
  [0x0975] = 0x5d49, [0x0976] = 0x5d4d, [0x0977] = 0x5d4e, [0x0978] = 0x5d4f,
  [0x0979] = 0x5d50, [0x097a] = 0x5d51, [0x097b] = 0x5d52, [0x097c] = 0x5d53,
  [0x097d] = 0x5d54, [0x097e] = 0x5d55, [0x097f] = 0x5d56, [0x0980] = 0x5d57,
  [0x0981] = 0x5d59, [0x0982] = 0x5d5a, [0x0983] = 0x5d5c, [0x0984] = 0x5d5e,
  [0x0985] = 0x5d5f, [0x0986] = 0x5d60, [0x0987] = 0x5d61, [0x0988] = 0x5d62,
  [0x0989] = 0x5d63, [0x098a] = 0x5d64, [0x098b] = 0x5d65, [0x098c] = 0x5d66,
  [0x098d] = 0x5d67, [0x098e] = 0x5d68, [0x098f] = 0x5d6a, [0x0990] = 0x5d6d,
  [0x0991] = 0x5d6e, [0x0992] = 0x5d70, [0x0993] = 0x5d71, [0x0994] = 0x5d72,
  [0x0995] = 0x5d73, [0x0996] = 0x5d75, [0x0997] = 0x5d76, [0x0998] = 0x5d77,
  [0x0999] = 0x5d78, [0x099a] = 0x5d79, [0x099b] = 0x5d7a, [0x099c] = 0x5d7b,
  [0x099d] = 0x5d7c, [0x099e] = 0x5d7d, [0x099f] = 0x5d7e, [0x09a0] = 0x5d7f,
  [0x09a1] = 0x5d80, [0x09a2] = 0x5d81, [0x09a3] = 0x5d83, [0x09a4] = 0x5d84,
  [0x09a5] = 0x5d85, [0x09a6] = 0x5d86, [0x09a7] = 0x5d87, [0x09a8] = 0x5d88,
  [0x09a9] = 0x5d89, [0x09aa] = 0x5d8a, [0x09ab] = 0x5d8b, [0x09ac] = 0x5d8c,
  [0x09ad] = 0x5d8d, [0x09ae] = 0x5d8e, [0x09af] = 0x5d8f, [0x09b0] = 0x5d90,
  [0x09b1] = 0x5d91, [0x09b2] = 0x5d92, [0x09b3] = 0x5d93, [0x09b4] = 0x5d94,
  [0x09b5] = 0x5d95, [0x09b6] = 0x5d96, [0x09b7] = 0x5d97, [0x09b8] = 0x5d98,
  [0x09b9] = 0x5d9a, [0x09ba] = 0x5d9b, [0x09bb] = 0x5d9c, [0x09bc] = 0x5d9e,
  [0x09bd] = 0x5d9f, [0x09be] = 0x5da0, [0x09c0] = 0x5da1, [0x09c1] = 0x5da2,
  [0x09c2] = 0x5da3, [0x09c3] = 0x5da4, [0x09c4] = 0x5da5, [0x09c5] = 0x5da6,
  [0x09c6] = 0x5da7, [0x09c7] = 0x5da8, [0x09c8] = 0x5da9, [0x09c9] = 0x5daa,
  [0x09ca] = 0x5dab, [0x09cb] = 0x5dac, [0x09cc] = 0x5dad, [0x09cd] = 0x5dae,
  [0x09ce] = 0x5daf, [0x09cf] = 0x5db0, [0x09d0] = 0x5db1, [0x09d1] = 0x5db2,
  [0x09d2] = 0x5db3, [0x09d3] = 0x5db4, [0x09d4] = 0x5db5, [0x09d5] = 0x5db6,
  [0x09d6] = 0x5db8, [0x09d7] = 0x5db9, [0x09d8] = 0x5dba, [0x09d9] = 0x5dbb,
  [0x09da] = 0x5dbc, [0x09db] = 0x5dbd, [0x09dc] = 0x5dbe, [0x09dd] = 0x5dbf,
  [0x09de] = 0x5dc0, [0x09df] = 0x5dc1, [0x09e0] = 0x5dc2, [0x09e1] = 0x5dc3,
  [0x09e2] = 0x5dc4, [0x09e3] = 0x5dc6, [0x09e4] = 0x5dc7, [0x09e5] = 0x5dc8,
  [0x09e6] = 0x5dc9, [0x09e7] = 0x5dca, [0x09e8] = 0x5dcb, [0x09e9] = 0x5dcc,
  [0x09ea] = 0x5dce, [0x09eb] = 0x5dcf, [0x09ec] = 0x5dd0, [0x09ed] = 0x5dd1,
  [0x09ee] = 0x5dd2, [0x09ef] = 0x5dd3, [0x09f0] = 0x5dd4, [0x09f1] = 0x5dd5,
  [0x09f2] = 0x5dd6, [0x09f3] = 0x5dd7, [0x09f4] = 0x5dd8, [0x09f5] = 0x5dd9,
  [0x09f6] = 0x5dda, [0x09f7] = 0x5ddc, [0x09f8] = 0x5ddf, [0x09f9] = 0x5de0,
  [0x09fa] = 0x5de3, [0x09fb] = 0x5de4, [0x09fc] = 0x5dea, [0x09fd] = 0x5dec,
  [0x09fe] = 0x5ded, [0x0a00] = 0x5df0, [0x0a01] = 0x5df5, [0x0a02] = 0x5df6,
  [0x0a03] = 0x5df8, [0x0a04] = 0x5df9, [0x0a05] = 0x5dfa, [0x0a06] = 0x5dfb,
  [0x0a07] = 0x5dfc, [0x0a08] = 0x5dff, [0x0a09] = 0x5e00, [0x0a0a] = 0x5e04,
  [0x0a0b] = 0x5e07, [0x0a0c] = 0x5e09, [0x0a0d] = 0x5e0a, [0x0a0e] = 0x5e0b,
  [0x0a0f] = 0x5e0d, [0x0a10] = 0x5e0e, [0x0a11] = 0x5e12, [0x0a12] = 0x5e13,
  [0x0a13] = 0x5e17, [0x0a14] = 0x5e1e, [0x0a15] = 0x5e1f, [0x0a16] = 0x5e20,
  [0x0a17] = 0x5e21, [0x0a18] = 0x5e22, [0x0a19] = 0x5e23, [0x0a1a] = 0x5e24,
  [0x0a1b] = 0x5e25, [0x0a1c] = 0x5e28, [0x0a1d] = 0x5e29, [0x0a1e] = 0x5e2a,
  [0x0a1f] = 0x5e2b, [0x0a20] = 0x5e2c, [0x0a21] = 0x5e2f, [0x0a22] = 0x5e30,
  [0x0a23] = 0x5e32, [0x0a24] = 0x5e33, [0x0a25] = 0x5e34, [0x0a26] = 0x5e35,
  [0x0a27] = 0x5e36, [0x0a28] = 0x5e39, [0x0a29] = 0x5e3a, [0x0a2a] = 0x5e3e,
  [0x0a2b] = 0x5e3f, [0x0a2c] = 0x5e40, [0x0a2d] = 0x5e41, [0x0a2e] = 0x5e43,
  [0x0a2f] = 0x5e46, [0x0a30] = 0x5e47, [0x0a31] = 0x5e48, [0x0a32] = 0x5e49,
  [0x0a33] = 0x5e4a, [0x0a34] = 0x5e4b, [0x0a35] = 0x5e4d, [0x0a36] = 0x5e4e,
  [0x0a37] = 0x5e4f, [0x0a38] = 0x5e50, [0x0a39] = 0x5e51, [0x0a3a] = 0x5e52,
  [0x0a3b] = 0x5e53, [0x0a3c] = 0x5e56, [0x0a3d] = 0x5e57, [0x0a3e] = 0x5e58,
  [0x0a3f] = 0x5e59, [0x0a40] = 0x5e5a, [0x0a41] = 0x5e5c, [0x0a42] = 0x5e5d,
  [0x0a43] = 0x5e5f, [0x0a44] = 0x5e60, [0x0a45] = 0x5e63, [0x0a46] = 0x5e64,
  [0x0a47] = 0x5e65, [0x0a48] = 0x5e66, [0x0a49] = 0x5e67, [0x0a4a] = 0x5e68,
  [0x0a4b] = 0x5e69, [0x0a4c] = 0x5e6a, [0x0a4d] = 0x5e6b, [0x0a4e] = 0x5e6c,
  [0x0a4f] = 0x5e6d, [0x0a50] = 0x5e6e, [0x0a51] = 0x5e6f, [0x0a52] = 0x5e70,
  [0x0a53] = 0x5e71, [0x0a54] = 0x5e75, [0x0a55] = 0x5e77, [0x0a56] = 0x5e79,
  [0x0a57] = 0x5e7e, [0x0a58] = 0x5e81, [0x0a59] = 0x5e82, [0x0a5a] = 0x5e83,
  [0x0a5b] = 0x5e85, [0x0a5c] = 0x5e88, [0x0a5d] = 0x5e89, [0x0a5e] = 0x5e8c,
  [0x0a5f] = 0x5e8d, [0x0a60] = 0x5e8e, [0x0a61] = 0x5e92, [0x0a62] = 0x5e98,
  [0x0a63] = 0x5e9b, [0x0a64] = 0x5e9d, [0x0a65] = 0x5ea1, [0x0a66] = 0x5ea2,
  [0x0a67] = 0x5ea3, [0x0a68] = 0x5ea4, [0x0a69] = 0x5ea8, [0x0a6a] = 0x5ea9,
  [0x0a6b] = 0x5eaa, [0x0a6c] = 0x5eab, [0x0a6d] = 0x5eac, [0x0a6e] = 0x5eae,
  [0x0a6f] = 0x5eaf, [0x0a70] = 0x5eb0, [0x0a71] = 0x5eb1, [0x0a72] = 0x5eb2,
  [0x0a73] = 0x5eb4, [0x0a74] = 0x5eba, [0x0a75] = 0x5ebb, [0x0a76] = 0x5ebc,
  [0x0a77] = 0x5ebd, [0x0a78] = 0x5ebf, [0x0a79] = 0x5ec0, [0x0a7a] = 0x5ec1,
  [0x0a7b] = 0x5ec2, [0x0a7c] = 0x5ec3, [0x0a7d] = 0x5ec4, [0x0a7e] = 0x5ec5,
  [0x0a80] = 0x5ec6, [0x0a81] = 0x5ec7, [0x0a82] = 0x5ec8, [0x0a83] = 0x5ecb,
  [0x0a84] = 0x5ecc, [0x0a85] = 0x5ecd, [0x0a86] = 0x5ece, [0x0a87] = 0x5ecf,
  [0x0a88] = 0x5ed0, [0x0a89] = 0x5ed4, [0x0a8a] = 0x5ed5, [0x0a8b] = 0x5ed7,
  [0x0a8c] = 0x5ed8, [0x0a8d] = 0x5ed9, [0x0a8e] = 0x5eda, [0x0a8f] = 0x5edc,
  [0x0a90] = 0x5edd, [0x0a91] = 0x5ede, [0x0a92] = 0x5edf, [0x0a93] = 0x5ee0,
  [0x0a94] = 0x5ee1, [0x0a95] = 0x5ee2, [0x0a96] = 0x5ee3, [0x0a97] = 0x5ee4,
  [0x0a98] = 0x5ee5, [0x0a99] = 0x5ee6, [0x0a9a] = 0x5ee7, [0x0a9b] = 0x5ee9,
  [0x0a9c] = 0x5eeb, [0x0a9d] = 0x5eec, [0x0a9e] = 0x5eed, [0x0a9f] = 0x5eee,
  [0x0aa0] = 0x5eef, [0x0aa1] = 0x5ef0, [0x0aa2] = 0x5ef1, [0x0aa3] = 0x5ef2,
  [0x0aa4] = 0x5ef3, [0x0aa5] = 0x5ef5, [0x0aa6] = 0x5ef8, [0x0aa7] = 0x5ef9,
  [0x0aa8] = 0x5efb, [0x0aa9] = 0x5efc, [0x0aaa] = 0x5efd, [0x0aab] = 0x5f05,
  [0x0aac] = 0x5f06, [0x0aad] = 0x5f07, [0x0aae] = 0x5f09, [0x0aaf] = 0x5f0c,
  [0x0ab0] = 0x5f0d, [0x0ab1] = 0x5f0e, [0x0ab2] = 0x5f10, [0x0ab3] = 0x5f12,
  [0x0ab4] = 0x5f14, [0x0ab5] = 0x5f16, [0x0ab6] = 0x5f19, [0x0ab7] = 0x5f1a,
  [0x0ab8] = 0x5f1c, [0x0ab9] = 0x5f1d, [0x0aba] = 0x5f1e, [0x0abb] = 0x5f21,
  [0x0abc] = 0x5f22, [0x0abd] = 0x5f23, [0x0abe] = 0x5f24, [0x0ac0] = 0x5f28,
  [0x0ac1] = 0x5f2b, [0x0ac2] = 0x5f2c, [0x0ac3] = 0x5f2e, [0x0ac4] = 0x5f30,
  [0x0ac5] = 0x5f32, [0x0ac6] = 0x5f33, [0x0ac7] = 0x5f34, [0x0ac8] = 0x5f35,
  [0x0ac9] = 0x5f36, [0x0aca] = 0x5f37, [0x0acb] = 0x5f38, [0x0acc] = 0x5f3b,
  [0x0acd] = 0x5f3d, [0x0ace] = 0x5f3e, [0x0acf] = 0x5f3f, [0x0ad0] = 0x5f41,
  [0x0ad1] = 0x5f42, [0x0ad2] = 0x5f43, [0x0ad3] = 0x5f44, [0x0ad4] = 0x5f45,
  [0x0ad5] = 0x5f46, [0x0ad6] = 0x5f47, [0x0ad7] = 0x5f48, [0x0ad8] = 0x5f49,
  [0x0ad9] = 0x5f4a, [0x0ada] = 0x5f4b, [0x0adb] = 0x5f4c, [0x0adc] = 0x5f4d,
  [0x0add] = 0x5f4e, [0x0ade] = 0x5f4f, [0x0adf] = 0x5f51, [0x0ae0] = 0x5f54,
  [0x0ae1] = 0x5f59, [0x0ae2] = 0x5f5a, [0x0ae3] = 0x5f5b, [0x0ae4] = 0x5f5c,
  [0x0ae5] = 0x5f5e, [0x0ae6] = 0x5f5f, [0x0ae7] = 0x5f60, [0x0ae8] = 0x5f63,
  [0x0ae9] = 0x5f65, [0x0aea] = 0x5f67, [0x0aeb] = 0x5f68, [0x0aec] = 0x5f6b,
  [0x0aed] = 0x5f6e, [0x0aee] = 0x5f6f, [0x0aef] = 0x5f72, [0x0af0] = 0x5f74,
  [0x0af1] = 0x5f75, [0x0af2] = 0x5f76, [0x0af3] = 0x5f78, [0x0af4] = 0x5f7a,
  [0x0af5] = 0x5f7d, [0x0af6] = 0x5f7e, [0x0af7] = 0x5f7f, [0x0af8] = 0x5f83,
  [0x0af9] = 0x5f86, [0x0afa] = 0x5f8d, [0x0afb] = 0x5f8e, [0x0afc] = 0x5f8f,
  [0x0afd] = 0x5f91, [0x0afe] = 0x5f93, [0x0aff] = 0x5f94, [0x0b00] = 0x5f96,
  [0x0b01] = 0x5f9a, [0x0b02] = 0x5f9b, [0x0b03] = 0x5f9d, [0x0b04] = 0x5f9e,
  [0x0b05] = 0x5f9f, [0x0b06] = 0x5fa0, [0x0b07] = 0x5fa2, [0x0b08] = 0x5fa3,
  [0x0b09] = 0x5fa4, [0x0b0a] = 0x5fa5, [0x0b0b] = 0x5fa6, [0x0b0c] = 0x5fa7,
  [0x0b0d] = 0x5fa9, [0x0b0e] = 0x5fab, [0x0b0f] = 0x5fac, [0x0b10] = 0x5faf,
  [0x0b11] = 0x5fb0, [0x0b12] = 0x5fb1, [0x0b13] = 0x5fb2, [0x0b14] = 0x5fb3,
  [0x0b15] = 0x5fb4, [0x0b16] = 0x5fb6, [0x0b17] = 0x5fb8, [0x0b18] = 0x5fb9,
  [0x0b19] = 0x5fba, [0x0b1a] = 0x5fbb, [0x0b1b] = 0x5fbe, [0x0b1c] = 0x5fbf,
  [0x0b1d] = 0x5fc0, [0x0b1e] = 0x5fc1, [0x0b1f] = 0x5fc2, [0x0b20] = 0x5fc7,
  [0x0b21] = 0x5fc8, [0x0b22] = 0x5fca, [0x0b23] = 0x5fcb, [0x0b24] = 0x5fce,
  [0x0b25] = 0x5fd3, [0x0b26] = 0x5fd4, [0x0b27] = 0x5fd5, [0x0b28] = 0x5fda,
  [0x0b29] = 0x5fdb, [0x0b2a] = 0x5fdc, [0x0b2b] = 0x5fde, [0x0b2c] = 0x5fdf,
  [0x0b2d] = 0x5fe2, [0x0b2e] = 0x5fe3, [0x0b2f] = 0x5fe5, [0x0b30] = 0x5fe6,
  [0x0b31] = 0x5fe8, [0x0b32] = 0x5fe9, [0x0b33] = 0x5fec, [0x0b34] = 0x5fef,
  [0x0b35] = 0x5ff0, [0x0b36] = 0x5ff2, [0x0b37] = 0x5ff3, [0x0b38] = 0x5ff4,
  [0x0b39] = 0x5ff6, [0x0b3a] = 0x5ff7, [0x0b3b] = 0x5ff9, [0x0b3c] = 0x5ffa,
  [0x0b3d] = 0x5ffc, [0x0b3e] = 0x6007, [0x0b40] = 0x6008, [0x0b41] = 0x6009,
  [0x0b42] = 0x600b, [0x0b43] = 0x600c, [0x0b44] = 0x6010, [0x0b45] = 0x6011,
  [0x0b46] = 0x6013, [0x0b47] = 0x6017, [0x0b48] = 0x6018, [0x0b49] = 0x601a,
  [0x0b4a] = 0x601e, [0x0b4b] = 0x601f, [0x0b4c] = 0x6022, [0x0b4d] = 0x6023,
  [0x0b4e] = 0x6024, [0x0b4f] = 0x602c, [0x0b50] = 0x602d, [0x0b51] = 0x602e,
  [0x0b52] = 0x6030, [0x0b53] = 0x6031, [0x0b54] = 0x6032, [0x0b55] = 0x6033,
  [0x0b56] = 0x6034, [0x0b57] = 0x6036, [0x0b58] = 0x6037, [0x0b59] = 0x6038,
  [0x0b5a] = 0x6039, [0x0b5b] = 0x603a, [0x0b5c] = 0x603d, [0x0b5d] = 0x603e,
  [0x0b5e] = 0x6040, [0x0b5f] = 0x6044, [0x0b60] = 0x6045, [0x0b61] = 0x6046,
  [0x0b62] = 0x6047, [0x0b63] = 0x6048, [0x0b64] = 0x6049, [0x0b65] = 0x604a,
  [0x0b66] = 0x604c, [0x0b67] = 0x604e, [0x0b68] = 0x604f, [0x0b69] = 0x6051,
  [0x0b6a] = 0x6053, [0x0b6b] = 0x6054, [0x0b6c] = 0x6056, [0x0b6d] = 0x6057,
  [0x0b6e] = 0x6058, [0x0b6f] = 0x605b, [0x0b70] = 0x605c, [0x0b71] = 0x605e,
  [0x0b72] = 0x605f, [0x0b73] = 0x6060, [0x0b74] = 0x6061, [0x0b75] = 0x6065,
  [0x0b76] = 0x6066, [0x0b77] = 0x606e, [0x0b78] = 0x6071, [0x0b79] = 0x6072,
  [0x0b7a] = 0x6074, [0x0b7b] = 0x6075, [0x0b7c] = 0x6077, [0x0b7d] = 0x607e,
  [0x0b7e] = 0x6080, [0x0b80] = 0x6081, [0x0b81] = 0x6082, [0x0b82] = 0x6085,
  [0x0b83] = 0x6086, [0x0b84] = 0x6087, [0x0b85] = 0x6088, [0x0b86] = 0x608a,
  [0x0b87] = 0x608b, [0x0b88] = 0x608e, [0x0b89] = 0x608f, [0x0b8a] = 0x6090,
  [0x0b8b] = 0x6091, [0x0b8c] = 0x6093, [0x0b8d] = 0x6095, [0x0b8e] = 0x6097,
  [0x0b8f] = 0x6098, [0x0b90] = 0x6099, [0x0b91] = 0x609c, [0x0b92] = 0x609e,
  [0x0b93] = 0x60a1, [0x0b94] = 0x60a2, [0x0b95] = 0x60a4, [0x0b96] = 0x60a5,
  [0x0b97] = 0x60a7, [0x0b98] = 0x60a9, [0x0b99] = 0x60aa, [0x0b9a] = 0x60ae,
  [0x0b9b] = 0x60b0, [0x0b9c] = 0x60b3, [0x0b9d] = 0x60b5, [0x0b9e] = 0x60b6,
  [0x0b9f] = 0x60b7, [0x0ba0] = 0x60b9, [0x0ba1] = 0x60ba, [0x0ba2] = 0x60bd,
  [0x0ba3] = 0x60be, [0x0ba4] = 0x60bf, [0x0ba5] = 0x60c0, [0x0ba6] = 0x60c1,
  [0x0ba7] = 0x60c2, [0x0ba8] = 0x60c3, [0x0ba9] = 0x60c4, [0x0baa] = 0x60c7,
  [0x0bab] = 0x60c8, [0x0bac] = 0x60c9, [0x0bad] = 0x60cc, [0x0bae] = 0x60cd,
  [0x0baf] = 0x60ce, [0x0bb0] = 0x60cf, [0x0bb1] = 0x60d0, [0x0bb2] = 0x60d2,
  [0x0bb3] = 0x60d3, [0x0bb4] = 0x60d4, [0x0bb5] = 0x60d6, [0x0bb6] = 0x60d7,
  [0x0bb7] = 0x60d9, [0x0bb8] = 0x60db, [0x0bb9] = 0x60de, [0x0bba] = 0x60e1,
  [0x0bbb] = 0x60e2, [0x0bbc] = 0x60e3, [0x0bbd] = 0x60e4, [0x0bbe] = 0x60e5,
  [0x0bbf] = 0x60ea, [0x0bc0] = 0x60f1, [0x0bc1] = 0x60f2, [0x0bc2] = 0x60f5,
  [0x0bc3] = 0x60f7, [0x0bc4] = 0x60f8, [0x0bc5] = 0x60fb, [0x0bc6] = 0x60fc,
  [0x0bc7] = 0x60fd, [0x0bc8] = 0x60fe, [0x0bc9] = 0x60ff, [0x0bca] = 0x6102,
  [0x0bcb] = 0x6103, [0x0bcc] = 0x6104, [0x0bcd] = 0x6105, [0x0bce] = 0x6107,
  [0x0bcf] = 0x610a, [0x0bd0] = 0x610b, [0x0bd1] = 0x610c, [0x0bd2] = 0x6110,
  [0x0bd3] = 0x6111, [0x0bd4] = 0x6112, [0x0bd5] = 0x6113, [0x0bd6] = 0x6114,
  [0x0bd7] = 0x6116, [0x0bd8] = 0x6117, [0x0bd9] = 0x6118, [0x0bda] = 0x6119,
  [0x0bdb] = 0x611b, [0x0bdc] = 0x611c, [0x0bdd] = 0x611d, [0x0bde] = 0x611e,
  [0x0bdf] = 0x6121, [0x0be0] = 0x6122, [0x0be1] = 0x6125, [0x0be2] = 0x6128,
  [0x0be3] = 0x6129, [0x0be4] = 0x612a, [0x0be5] = 0x612c, [0x0be6] = 0x612d,
  [0x0be7] = 0x612e, [0x0be8] = 0x612f, [0x0be9] = 0x6130, [0x0bea] = 0x6131,
  [0x0beb] = 0x6132, [0x0bec] = 0x6133, [0x0bed] = 0x6134, [0x0bee] = 0x6135,
  [0x0bef] = 0x6136, [0x0bf0] = 0x6137, [0x0bf1] = 0x6138, [0x0bf2] = 0x6139,
  [0x0bf3] = 0x613a, [0x0bf4] = 0x613b, [0x0bf5] = 0x613c, [0x0bf6] = 0x613d,
  [0x0bf7] = 0x613e, [0x0bf8] = 0x6140, [0x0bf9] = 0x6141, [0x0bfa] = 0x6142,
  [0x0bfb] = 0x6143, [0x0bfc] = 0x6144, [0x0bfd] = 0x6145, [0x0bfe] = 0x6146,
  [0x0c00] = 0x6147, [0x0c01] = 0x6149, [0x0c02] = 0x614b, [0x0c03] = 0x614d,
  [0x0c04] = 0x614f, [0x0c05] = 0x6150, [0x0c06] = 0x6152, [0x0c07] = 0x6153,
  [0x0c08] = 0x6154, [0x0c09] = 0x6156, [0x0c0a] = 0x6157, [0x0c0b] = 0x6158,
  [0x0c0c] = 0x6159, [0x0c0d] = 0x615a, [0x0c0e] = 0x615b, [0x0c0f] = 0x615c,
  [0x0c10] = 0x615e, [0x0c11] = 0x615f, [0x0c12] = 0x6160, [0x0c13] = 0x6161,
  [0x0c14] = 0x6163, [0x0c15] = 0x6164, [0x0c16] = 0x6165, [0x0c17] = 0x6166,
  [0x0c18] = 0x6169, [0x0c19] = 0x616a, [0x0c1a] = 0x616b, [0x0c1b] = 0x616c,
  [0x0c1c] = 0x616d, [0x0c1d] = 0x616e, [0x0c1e] = 0x616f, [0x0c1f] = 0x6171,
  [0x0c20] = 0x6172, [0x0c21] = 0x6173, [0x0c22] = 0x6174, [0x0c23] = 0x6176,
  [0x0c24] = 0x6178, [0x0c25] = 0x6179, [0x0c26] = 0x617a, [0x0c27] = 0x617b,
  [0x0c28] = 0x617c, [0x0c29] = 0x617d, [0x0c2a] = 0x617e, [0x0c2b] = 0x617f,
  [0x0c2c] = 0x6180, [0x0c2d] = 0x6181, [0x0c2e] = 0x6182, [0x0c2f] = 0x6183,
  [0x0c30] = 0x6184, [0x0c31] = 0x6185, [0x0c32] = 0x6186, [0x0c33] = 0x6187,
  [0x0c34] = 0x6188, [0x0c35] = 0x6189, [0x0c36] = 0x618a, [0x0c37] = 0x618c,
  [0x0c38] = 0x618d, [0x0c39] = 0x618f, [0x0c3a] = 0x6190, [0x0c3b] = 0x6191,
  [0x0c3c] = 0x6192, [0x0c3d] = 0x6193, [0x0c3e] = 0x6195, [0x0c40] = 0x6196,
  [0x0c41] = 0x6197, [0x0c42] = 0x6198, [0x0c43] = 0x6199, [0x0c44] = 0x619a,
  [0x0c45] = 0x619b, [0x0c46] = 0x619c, [0x0c47] = 0x619e, [0x0c48] = 0x619f,
  [0x0c49] = 0x61a0, [0x0c4a] = 0x61a1, [0x0c4b] = 0x61a2, [0x0c4c] = 0x61a3,
  [0x0c4d] = 0x61a4, [0x0c4e] = 0x61a5, [0x0c4f] = 0x61a6, [0x0c50] = 0x61aa,
  [0x0c51] = 0x61ab, [0x0c52] = 0x61ad, [0x0c53] = 0x61ae, [0x0c54] = 0x61af,
  [0x0c55] = 0x61b0, [0x0c56] = 0x61b1, [0x0c57] = 0x61b2, [0x0c58] = 0x61b3,
  [0x0c59] = 0x61b4, [0x0c5a] = 0x61b5, [0x0c5b] = 0x61b6, [0x0c5c] = 0x61b8,
  [0x0c5d] = 0x61b9, [0x0c5e] = 0x61ba, [0x0c5f] = 0x61bb, [0x0c60] = 0x61bc,
  [0x0c61] = 0x61bd, [0x0c62] = 0x61bf, [0x0c63] = 0x61c0, [0x0c64] = 0x61c1,
  [0x0c65] = 0x61c3, [0x0c66] = 0x61c4, [0x0c67] = 0x61c5, [0x0c68] = 0x61c6,
  [0x0c69] = 0x61c7, [0x0c6a] = 0x61c9, [0x0c6b] = 0x61cc, [0x0c6c] = 0x61cd,
  [0x0c6d] = 0x61ce, [0x0c6e] = 0x61cf, [0x0c6f] = 0x61d0, [0x0c70] = 0x61d3,
  [0x0c71] = 0x61d5, [0x0c72] = 0x61d6, [0x0c73] = 0x61d7, [0x0c74] = 0x61d8,
  [0x0c75] = 0x61d9, [0x0c76] = 0x61da, [0x0c77] = 0x61db, [0x0c78] = 0x61dc,
  [0x0c79] = 0x61dd, [0x0c7a] = 0x61de, [0x0c7b] = 0x61df, [0x0c7c] = 0x61e0,
  [0x0c7d] = 0x61e1, [0x0c7e] = 0x61e2, [0x0c7f] = 0x61e3, [0x0c80] = 0x61e4,
  [0x0c81] = 0x61e5, [0x0c82] = 0x61e7, [0x0c83] = 0x61e8, [0x0c84] = 0x61e9,
  [0x0c85] = 0x61ea, [0x0c86] = 0x61eb, [0x0c87] = 0x61ec, [0x0c88] = 0x61ed,
  [0x0c89] = 0x61ee, [0x0c8a] = 0x61ef, [0x0c8b] = 0x61f0, [0x0c8c] = 0x61f1,
  [0x0c8d] = 0x61f2, [0x0c8e] = 0x61f3, [0x0c8f] = 0x61f4, [0x0c90] = 0x61f6,
  [0x0c91] = 0x61f7, [0x0c92] = 0x61f8, [0x0c93] = 0x61f9, [0x0c94] = 0x61fa,
  [0x0c95] = 0x61fb, [0x0c96] = 0x61fc, [0x0c97] = 0x61fd, [0x0c98] = 0x61fe,
  [0x0c99] = 0x6200, [0x0c9a] = 0x6201, [0x0c9b] = 0x6202, [0x0c9c] = 0x6203,
  [0x0c9d] = 0x6204, [0x0c9e] = 0x6205, [0x0c9f] = 0x6207, [0x0ca0] = 0x6209,
  [0x0ca1] = 0x6213, [0x0ca2] = 0x6214, [0x0ca3] = 0x6219, [0x0ca4] = 0x621c,
  [0x0ca5] = 0x621d, [0x0ca6] = 0x621e, [0x0ca7] = 0x6220, [0x0ca8] = 0x6223,
  [0x0ca9] = 0x6226, [0x0caa] = 0x6227, [0x0cab] = 0x6228, [0x0cac] = 0x6229,
  [0x0cad] = 0x622b, [0x0cae] = 0x622d, [0x0caf] = 0x622f, [0x0cb0] = 0x6230,
  [0x0cb1] = 0x6231, [0x0cb2] = 0x6232, [0x0cb3] = 0x6235, [0x0cb4] = 0x6236,
  [0x0cb5] = 0x6238, [0x0cb6] = 0x6239, [0x0cb7] = 0x623a, [0x0cb8] = 0x623b,
  [0x0cb9] = 0x623c, [0x0cba] = 0x6242, [0x0cbb] = 0x6244, [0x0cbc] = 0x6245,
  [0x0cbd] = 0x6246, [0x0cbe] = 0x624a, [0x0cc0] = 0x624f, [0x0cc1] = 0x6250,
  [0x0cc2] = 0x6255, [0x0cc3] = 0x6256, [0x0cc4] = 0x6257, [0x0cc5] = 0x6259,
  [0x0cc6] = 0x625a, [0x0cc7] = 0x625c, [0x0cc8] = 0x625d, [0x0cc9] = 0x625e,
  [0x0cca] = 0x625f, [0x0ccb] = 0x6260, [0x0ccc] = 0x6261, [0x0ccd] = 0x6262,
  [0x0cce] = 0x6264, [0x0ccf] = 0x6265, [0x0cd0] = 0x6268, [0x0cd1] = 0x6271,
  [0x0cd2] = 0x6272, [0x0cd3] = 0x6274, [0x0cd4] = 0x6275, [0x0cd5] = 0x6277,
  [0x0cd6] = 0x6278, [0x0cd7] = 0x627a, [0x0cd8] = 0x627b, [0x0cd9] = 0x627d,
  [0x0cda] = 0x6281, [0x0cdb] = 0x6282, [0x0cdc] = 0x6283, [0x0cdd] = 0x6285,
  [0x0cde] = 0x6286, [0x0cdf] = 0x6287, [0x0ce0] = 0x6288, [0x0ce1] = 0x628b,
  [0x0ce2] = 0x628c, [0x0ce3] = 0x628d, [0x0ce4] = 0x628e, [0x0ce5] = 0x628f,
  [0x0ce6] = 0x6290, [0x0ce7] = 0x6294, [0x0ce8] = 0x6299, [0x0ce9] = 0x629c,
  [0x0cea] = 0x629d, [0x0ceb] = 0x629e, [0x0cec] = 0x62a3, [0x0ced] = 0x62a6,
  [0x0cee] = 0x62a7, [0x0cef] = 0x62a9, [0x0cf0] = 0x62aa, [0x0cf1] = 0x62ad,
  [0x0cf2] = 0x62ae, [0x0cf3] = 0x62af, [0x0cf4] = 0x62b0, [0x0cf5] = 0x62b2,
  [0x0cf6] = 0x62b3, [0x0cf7] = 0x62b4, [0x0cf8] = 0x62b6, [0x0cf9] = 0x62b7,
  [0x0cfa] = 0x62b8, [0x0cfb] = 0x62ba, [0x0cfc] = 0x62be, [0x0cfd] = 0x62c0,
  [0x0cfe] = 0x62c1, [0x0d00] = 0x62c3, [0x0d01] = 0x62cb, [0x0d02] = 0x62cf,
  [0x0d03] = 0x62d1, [0x0d04] = 0x62d5, [0x0d05] = 0x62dd, [0x0d06] = 0x62de,
  [0x0d07] = 0x62e0, [0x0d08] = 0x62e1, [0x0d09] = 0x62e4, [0x0d0a] = 0x62ea,
  [0x0d0b] = 0x62eb, [0x0d0c] = 0x62f0, [0x0d0d] = 0x62f2, [0x0d0e] = 0x62f5,
  [0x0d0f] = 0x62f8, [0x0d10] = 0x62f9, [0x0d11] = 0x62fa, [0x0d12] = 0x62fb,
  [0x0d13] = 0x6300, [0x0d14] = 0x6303, [0x0d15] = 0x6304, [0x0d16] = 0x6305,
  [0x0d17] = 0x6306, [0x0d18] = 0x630a, [0x0d19] = 0x630b, [0x0d1a] = 0x630c,
  [0x0d1b] = 0x630d, [0x0d1c] = 0x630f, [0x0d1d] = 0x6310, [0x0d1e] = 0x6312,
  [0x0d1f] = 0x6313, [0x0d20] = 0x6314, [0x0d21] = 0x6315, [0x0d22] = 0x6317,
  [0x0d23] = 0x6318, [0x0d24] = 0x6319, [0x0d25] = 0x631c, [0x0d26] = 0x6326,
  [0x0d27] = 0x6327, [0x0d28] = 0x6329, [0x0d29] = 0x632c, [0x0d2a] = 0x632d,
  [0x0d2b] = 0x632e, [0x0d2c] = 0x6330, [0x0d2d] = 0x6331, [0x0d2e] = 0x6333,
  [0x0d2f] = 0x6334, [0x0d30] = 0x6335, [0x0d31] = 0x6336, [0x0d32] = 0x6337,
  [0x0d33] = 0x6338, [0x0d34] = 0x633b, [0x0d35] = 0x633c, [0x0d36] = 0x633e,
  [0x0d37] = 0x633f, [0x0d38] = 0x6340, [0x0d39] = 0x6341, [0x0d3a] = 0x6344,
  [0x0d3b] = 0x6347, [0x0d3c] = 0x6348, [0x0d3d] = 0x634a, [0x0d3e] = 0x6351,
  [0x0d3f] = 0x6352, [0x0d40] = 0x6353, [0x0d41] = 0x6354, [0x0d42] = 0x6356,
  [0x0d43] = 0x6357, [0x0d44] = 0x6358, [0x0d45] = 0x6359, [0x0d46] = 0x635a,
  [0x0d47] = 0x635b, [0x0d48] = 0x635c, [0x0d49] = 0x635d, [0x0d4a] = 0x6360,
  [0x0d4b] = 0x6364, [0x0d4c] = 0x6365, [0x0d4d] = 0x6366, [0x0d4e] = 0x6368,
  [0x0d4f] = 0x636a, [0x0d50] = 0x636b, [0x0d51] = 0x636c, [0x0d52] = 0x636f,
  [0x0d53] = 0x6370, [0x0d54] = 0x6372, [0x0d55] = 0x6373, [0x0d56] = 0x6374,
  [0x0d57] = 0x6375, [0x0d58] = 0x6378, [0x0d59] = 0x6379, [0x0d5a] = 0x637c,
  [0x0d5b] = 0x637d, [0x0d5c] = 0x637e, [0x0d5d] = 0x637f, [0x0d5e] = 0x6381,
  [0x0d5f] = 0x6383, [0x0d60] = 0x6384, [0x0d61] = 0x6385, [0x0d62] = 0x6386,
  [0x0d63] = 0x638b, [0x0d64] = 0x638d, [0x0d65] = 0x6391, [0x0d66] = 0x6393,
  [0x0d67] = 0x6394, [0x0d68] = 0x6395, [0x0d69] = 0x6397, [0x0d6a] = 0x6399,
  [0x0d6b] = 0x639a, [0x0d6c] = 0x639b, [0x0d6d] = 0x639c, [0x0d6e] = 0x639d,
  [0x0d6f] = 0x639e, [0x0d70] = 0x639f, [0x0d71] = 0x63a1, [0x0d72] = 0x63a4,
  [0x0d73] = 0x63a6, [0x0d74] = 0x63ab, [0x0d75] = 0x63af, [0x0d76] = 0x63b1,
  [0x0d77] = 0x63b2, [0x0d78] = 0x63b5, [0x0d79] = 0x63b6, [0x0d7a] = 0x63b9,
  [0x0d7b] = 0x63bb, [0x0d7c] = 0x63bd, [0x0d7d] = 0x63bf, [0x0d7e] = 0x63c0,
  [0x0d80] = 0x63c1, [0x0d81] = 0x63c2, [0x0d82] = 0x63c3, [0x0d83] = 0x63c5,
  [0x0d84] = 0x63c7, [0x0d85] = 0x63c8, [0x0d86] = 0x63ca, [0x0d87] = 0x63cb,
  [0x0d88] = 0x63cc, [0x0d89] = 0x63d1, [0x0d8a] = 0x63d3, [0x0d8b] = 0x63d4,
  [0x0d8c] = 0x63d5, [0x0d8d] = 0x63d7, [0x0d8e] = 0x63d8, [0x0d8f] = 0x63d9,
  [0x0d90] = 0x63da, [0x0d91] = 0x63db, [0x0d92] = 0x63dc, [0x0d93] = 0x63dd,
  [0x0d94] = 0x63df, [0x0d95] = 0x63e2, [0x0d96] = 0x63e4, [0x0d97] = 0x63e5,
  [0x0d98] = 0x63e6, [0x0d99] = 0x63e7, [0x0d9a] = 0x63e8, [0x0d9b] = 0x63eb,
  [0x0d9c] = 0x63ec, [0x0d9d] = 0x63ee, [0x0d9e] = 0x63ef, [0x0d9f] = 0x63f0,
  [0x0da0] = 0x63f1, [0x0da1] = 0x63f3, [0x0da2] = 0x63f5, [0x0da3] = 0x63f7,
  [0x0da4] = 0x63f9, [0x0da5] = 0x63fa, [0x0da6] = 0x63fb, [0x0da7] = 0x63fc,
  [0x0da8] = 0x63fe, [0x0da9] = 0x6403, [0x0daa] = 0x6404, [0x0dab] = 0x6406,
  [0x0dac] = 0x6407, [0x0dad] = 0x6408, [0x0dae] = 0x6409, [0x0daf] = 0x640a,
  [0x0db0] = 0x640d, [0x0db1] = 0x640e, [0x0db2] = 0x6411, [0x0db3] = 0x6412,
  [0x0db4] = 0x6415, [0x0db5] = 0x6416, [0x0db6] = 0x6417, [0x0db7] = 0x6418,
  [0x0db8] = 0x6419, [0x0db9] = 0x641a, [0x0dba] = 0x641d, [0x0dbb] = 0x641f,
  [0x0dbc] = 0x6422, [0x0dbd] = 0x6423, [0x0dbe] = 0x6424, [0x0dc0] = 0x6425,
  [0x0dc1] = 0x6427, [0x0dc2] = 0x6428, [0x0dc3] = 0x6429, [0x0dc4] = 0x642b,
  [0x0dc5] = 0x642e, [0x0dc6] = 0x642f, [0x0dc7] = 0x6430, [0x0dc8] = 0x6431,
  [0x0dc9] = 0x6432, [0x0dca] = 0x6433, [0x0dcb] = 0x6435, [0x0dcc] = 0x6436,
  [0x0dcd] = 0x6437, [0x0dce] = 0x6438, [0x0dcf] = 0x6439, [0x0dd0] = 0x643b,
  [0x0dd1] = 0x643c, [0x0dd2] = 0x643e, [0x0dd3] = 0x6440, [0x0dd4] = 0x6442,
  [0x0dd5] = 0x6443, [0x0dd6] = 0x6449, [0x0dd7] = 0x644b, [0x0dd8] = 0x644c,
  [0x0dd9] = 0x644d, [0x0dda] = 0x644e, [0x0ddb] = 0x644f, [0x0ddc] = 0x6450,
  [0x0ddd] = 0x6451, [0x0dde] = 0x6453, [0x0ddf] = 0x6455, [0x0de0] = 0x6456,
  [0x0de1] = 0x6457, [0x0de2] = 0x6459, [0x0de3] = 0x645a, [0x0de4] = 0x645b,
  [0x0de5] = 0x645c, [0x0de6] = 0x645d, [0x0de7] = 0x645f, [0x0de8] = 0x6460,
  [0x0de9] = 0x6461, [0x0dea] = 0x6462, [0x0deb] = 0x6463, [0x0dec] = 0x6464,
  [0x0ded] = 0x6465, [0x0dee] = 0x6466, [0x0def] = 0x6468, [0x0df0] = 0x646a,
  [0x0df1] = 0x646b, [0x0df2] = 0x646c, [0x0df3] = 0x646e, [0x0df4] = 0x646f,
  [0x0df5] = 0x6470, [0x0df6] = 0x6471, [0x0df7] = 0x6472, [0x0df8] = 0x6473,
  [0x0df9] = 0x6474, [0x0dfa] = 0x6475, [0x0dfb] = 0x6476, [0x0dfc] = 0x6477,
  [0x0dfd] = 0x647b, [0x0dfe] = 0x647c, [0x0dff] = 0x647d, [0x0e00] = 0x647e,
  [0x0e01] = 0x647f, [0x0e02] = 0x6480, [0x0e03] = 0x6481, [0x0e04] = 0x6483,
  [0x0e05] = 0x6486, [0x0e06] = 0x6488, [0x0e07] = 0x6489, [0x0e08] = 0x648a,
  [0x0e09] = 0x648b, [0x0e0a] = 0x648c, [0x0e0b] = 0x648d, [0x0e0c] = 0x648e,
  [0x0e0d] = 0x648f, [0x0e0e] = 0x6490, [0x0e0f] = 0x6493, [0x0e10] = 0x6494,
  [0x0e11] = 0x6497, [0x0e12] = 0x6498, [0x0e13] = 0x649a, [0x0e14] = 0x649b,
  [0x0e15] = 0x649c, [0x0e16] = 0x649d, [0x0e17] = 0x649f, [0x0e18] = 0x64a0,
  [0x0e19] = 0x64a1, [0x0e1a] = 0x64a2, [0x0e1b] = 0x64a3, [0x0e1c] = 0x64a5,
  [0x0e1d] = 0x64a6, [0x0e1e] = 0x64a7, [0x0e1f] = 0x64a8, [0x0e20] = 0x64aa,
  [0x0e21] = 0x64ab, [0x0e22] = 0x64af, [0x0e23] = 0x64b1, [0x0e24] = 0x64b2,
  [0x0e25] = 0x64b3, [0x0e26] = 0x64b4, [0x0e27] = 0x64b6, [0x0e28] = 0x64b9,
  [0x0e29] = 0x64bb, [0x0e2a] = 0x64bd, [0x0e2b] = 0x64be, [0x0e2c] = 0x64bf,
  [0x0e2d] = 0x64c1, [0x0e2e] = 0x64c3, [0x0e2f] = 0x64c4, [0x0e30] = 0x64c6,
  [0x0e31] = 0x64c7, [0x0e32] = 0x64c8, [0x0e33] = 0x64c9, [0x0e34] = 0x64ca,
  [0x0e35] = 0x64cb, [0x0e36] = 0x64cc, [0x0e37] = 0x64cf, [0x0e38] = 0x64d1,
  [0x0e39] = 0x64d3, [0x0e3a] = 0x64d4, [0x0e3b] = 0x64d5, [0x0e3c] = 0x64d6,
  [0x0e3d] = 0x64d9, [0x0e3e] = 0x64da, [0x0e40] = 0x64db, [0x0e41] = 0x64dc,
  [0x0e42] = 0x64dd, [0x0e43] = 0x64df, [0x0e44] = 0x64e0, [0x0e45] = 0x64e1,
  [0x0e46] = 0x64e3, [0x0e47] = 0x64e5, [0x0e48] = 0x64e7, [0x0e49] = 0x64e8,
  [0x0e4a] = 0x64e9, [0x0e4b] = 0x64ea, [0x0e4c] = 0x64eb, [0x0e4d] = 0x64ec,
  [0x0e4e] = 0x64ed, [0x0e4f] = 0x64ee, [0x0e50] = 0x64ef, [0x0e51] = 0x64f0,
  [0x0e52] = 0x64f1, [0x0e53] = 0x64f2, [0x0e54] = 0x64f3, [0x0e55] = 0x64f4,
  [0x0e56] = 0x64f5, [0x0e57] = 0x64f6, [0x0e58] = 0x64f7, [0x0e59] = 0x64f8,
  [0x0e5a] = 0x64f9, [0x0e5b] = 0x64fa, [0x0e5c] = 0x64fb, [0x0e5d] = 0x64fc,
  [0x0e5e] = 0x64fd, [0x0e5f] = 0x64fe, [0x0e60] = 0x64ff, [0x0e61] = 0x6501,
  [0x0e62] = 0x6502, [0x0e63] = 0x6503, [0x0e64] = 0x6504, [0x0e65] = 0x6505,
  [0x0e66] = 0x6506, [0x0e67] = 0x6507, [0x0e68] = 0x6508, [0x0e69] = 0x650a,
  [0x0e6a] = 0x650b, [0x0e6b] = 0x650c, [0x0e6c] = 0x650d, [0x0e6d] = 0x650e,
  [0x0e6e] = 0x650f, [0x0e6f] = 0x6510, [0x0e70] = 0x6511, [0x0e71] = 0x6513,
  [0x0e72] = 0x6514, [0x0e73] = 0x6515, [0x0e74] = 0x6516, [0x0e75] = 0x6517,
  [0x0e76] = 0x6519, [0x0e77] = 0x651a, [0x0e78] = 0x651b, [0x0e79] = 0x651c,
  [0x0e7a] = 0x651d, [0x0e7b] = 0x651e, [0x0e7c] = 0x651f, [0x0e7d] = 0x6520,
  [0x0e7e] = 0x6521, [0x0e80] = 0x6522, [0x0e81] = 0x6523, [0x0e82] = 0x6524,
  [0x0e83] = 0x6526, [0x0e84] = 0x6527, [0x0e85] = 0x6528, [0x0e86] = 0x6529,
  [0x0e87] = 0x652a, [0x0e88] = 0x652c, [0x0e89] = 0x652d, [0x0e8a] = 0x6530,
  [0x0e8b] = 0x6531, [0x0e8c] = 0x6532, [0x0e8d] = 0x6533, [0x0e8e] = 0x6537,
  [0x0e8f] = 0x653a, [0x0e90] = 0x653c, [0x0e91] = 0x653d, [0x0e92] = 0x6540,
  [0x0e93] = 0x6541, [0x0e94] = 0x6542, [0x0e95] = 0x6543, [0x0e96] = 0x6544,
  [0x0e97] = 0x6546, [0x0e98] = 0x6547, [0x0e99] = 0x654a, [0x0e9a] = 0x654b,
  [0x0e9b] = 0x654d, [0x0e9c] = 0x654e, [0x0e9d] = 0x6550, [0x0e9e] = 0x6552,
  [0x0e9f] = 0x6553, [0x0ea0] = 0x6554, [0x0ea1] = 0x6557, [0x0ea2] = 0x6558,
  [0x0ea3] = 0x655a, [0x0ea4] = 0x655c, [0x0ea5] = 0x655f, [0x0ea6] = 0x6560,
  [0x0ea7] = 0x6561, [0x0ea8] = 0x6564, [0x0ea9] = 0x6565, [0x0eaa] = 0x6567,
  [0x0eab] = 0x6568, [0x0eac] = 0x6569, [0x0ead] = 0x656a, [0x0eae] = 0x656d,
  [0x0eaf] = 0x656e, [0x0eb0] = 0x656f, [0x0eb1] = 0x6571, [0x0eb2] = 0x6573,
  [0x0eb3] = 0x6575, [0x0eb4] = 0x6576, [0x0eb5] = 0x6578, [0x0eb6] = 0x6579,
  [0x0eb7] = 0x657a, [0x0eb8] = 0x657b, [0x0eb9] = 0x657c, [0x0eba] = 0x657d,
  [0x0ebb] = 0x657e, [0x0ebc] = 0x657f, [0x0ebd] = 0x6580, [0x0ebe] = 0x6581,
  [0x0ebf] = 0x6582, [0x0ec0] = 0x6583, [0x0ec1] = 0x6584, [0x0ec2] = 0x6585,
  [0x0ec3] = 0x6586, [0x0ec4] = 0x6588, [0x0ec5] = 0x6589, [0x0ec6] = 0x658a,
  [0x0ec7] = 0x658d, [0x0ec8] = 0x658e, [0x0ec9] = 0x658f, [0x0eca] = 0x6592,
  [0x0ecb] = 0x6594, [0x0ecc] = 0x6595, [0x0ecd] = 0x6596, [0x0ece] = 0x6598,
  [0x0ecf] = 0x659a, [0x0ed0] = 0x659d, [0x0ed1] = 0x659e, [0x0ed2] = 0x65a0,
  [0x0ed3] = 0x65a2, [0x0ed4] = 0x65a3, [0x0ed5] = 0x65a6, [0x0ed6] = 0x65a8,
  [0x0ed7] = 0x65aa, [0x0ed8] = 0x65ac, [0x0ed9] = 0x65ae, [0x0eda] = 0x65b1,
  [0x0edb] = 0x65b2, [0x0edc] = 0x65b3, [0x0edd] = 0x65b4, [0x0ede] = 0x65b5,
  [0x0edf] = 0x65b6, [0x0ee0] = 0x65b7, [0x0ee1] = 0x65b8, [0x0ee2] = 0x65ba,
  [0x0ee3] = 0x65bb, [0x0ee4] = 0x65be, [0x0ee5] = 0x65bf, [0x0ee6] = 0x65c0,
  [0x0ee7] = 0x65c2, [0x0ee8] = 0x65c7, [0x0ee9] = 0x65c8, [0x0eea] = 0x65c9,
  [0x0eeb] = 0x65ca, [0x0eec] = 0x65cd, [0x0eed] = 0x65d0, [0x0eee] = 0x65d1,
  [0x0eef] = 0x65d3, [0x0ef0] = 0x65d4, [0x0ef1] = 0x65d5, [0x0ef2] = 0x65d8,
  [0x0ef3] = 0x65d9, [0x0ef4] = 0x65da, [0x0ef5] = 0x65db, [0x0ef6] = 0x65dc,
  [0x0ef7] = 0x65dd, [0x0ef8] = 0x65de, [0x0ef9] = 0x65df, [0x0efa] = 0x65e1,
  [0x0efb] = 0x65e3, [0x0efc] = 0x65e4, [0x0efd] = 0x65ea, [0x0efe] = 0x65eb,
  [0x0f00] = 0x65f2, [0x0f01] = 0x65f3, [0x0f02] = 0x65f4, [0x0f03] = 0x65f5,
  [0x0f04] = 0x65f8, [0x0f05] = 0x65f9, [0x0f06] = 0x65fb, [0x0f07] = 0x65fc,
  [0x0f08] = 0x65fd, [0x0f09] = 0x65fe, [0x0f0a] = 0x65ff, [0x0f0b] = 0x6601,
  [0x0f0c] = 0x6604, [0x0f0d] = 0x6605, [0x0f0e] = 0x6607, [0x0f0f] = 0x6608,
  [0x0f10] = 0x6609, [0x0f11] = 0x660b, [0x0f12] = 0x660d, [0x0f13] = 0x6610,
  [0x0f14] = 0x6611, [0x0f15] = 0x6612, [0x0f16] = 0x6616, [0x0f17] = 0x6617,
  [0x0f18] = 0x6618, [0x0f19] = 0x661a, [0x0f1a] = 0x661b, [0x0f1b] = 0x661c,
  [0x0f1c] = 0x661e, [0x0f1d] = 0x6621, [0x0f1e] = 0x6622, [0x0f1f] = 0x6623,
  [0x0f20] = 0x6624, [0x0f21] = 0x6626, [0x0f22] = 0x6629, [0x0f23] = 0x662a,
  [0x0f24] = 0x662b, [0x0f25] = 0x662c, [0x0f26] = 0x662e, [0x0f27] = 0x6630,
  [0x0f28] = 0x6632, [0x0f29] = 0x6633, [0x0f2a] = 0x6637, [0x0f2b] = 0x6638,
  [0x0f2c] = 0x6639, [0x0f2d] = 0x663a, [0x0f2e] = 0x663b, [0x0f2f] = 0x663d,
  [0x0f30] = 0x663f, [0x0f31] = 0x6640, [0x0f32] = 0x6642, [0x0f33] = 0x6644,
  [0x0f34] = 0x6645, [0x0f35] = 0x6646, [0x0f36] = 0x6647, [0x0f37] = 0x6648,
  [0x0f38] = 0x6649, [0x0f39] = 0x664a, [0x0f3a] = 0x664d, [0x0f3b] = 0x664e,
  [0x0f3c] = 0x6650, [0x0f3d] = 0x6651, [0x0f3e] = 0x6658, [0x0f40] = 0x6659,
  [0x0f41] = 0x665b, [0x0f42] = 0x665c, [0x0f43] = 0x665d, [0x0f44] = 0x665e,
  [0x0f45] = 0x6660, [0x0f46] = 0x6662, [0x0f47] = 0x6663, [0x0f48] = 0x6665,
  [0x0f49] = 0x6667, [0x0f4a] = 0x6669, [0x0f4b] = 0x666a, [0x0f4c] = 0x666b,
  [0x0f4d] = 0x666c, [0x0f4e] = 0x666d, [0x0f4f] = 0x6671, [0x0f50] = 0x6672,
  [0x0f51] = 0x6673, [0x0f52] = 0x6675, [0x0f53] = 0x6678, [0x0f54] = 0x6679,
  [0x0f55] = 0x667b, [0x0f56] = 0x667c, [0x0f57] = 0x667d, [0x0f58] = 0x667f,
  [0x0f59] = 0x6680, [0x0f5a] = 0x6681, [0x0f5b] = 0x6683, [0x0f5c] = 0x6685,
  [0x0f5d] = 0x6686, [0x0f5e] = 0x6688, [0x0f5f] = 0x6689, [0x0f60] = 0x668a,
  [0x0f61] = 0x668b, [0x0f62] = 0x668d, [0x0f63] = 0x668e, [0x0f64] = 0x668f,
  [0x0f65] = 0x6690, [0x0f66] = 0x6692, [0x0f67] = 0x6693, [0x0f68] = 0x6694,
  [0x0f69] = 0x6695, [0x0f6a] = 0x6698, [0x0f6b] = 0x6699, [0x0f6c] = 0x669a,
  [0x0f6d] = 0x669b, [0x0f6e] = 0x669c, [0x0f6f] = 0x669e, [0x0f70] = 0x669f,
  [0x0f71] = 0x66a0, [0x0f72] = 0x66a1, [0x0f73] = 0x66a2, [0x0f74] = 0x66a3,
  [0x0f75] = 0x66a4, [0x0f76] = 0x66a5, [0x0f77] = 0x66a6, [0x0f78] = 0x66a9,
  [0x0f79] = 0x66aa, [0x0f7a] = 0x66ab, [0x0f7b] = 0x66ac, [0x0f7c] = 0x66ad,
  [0x0f7d] = 0x66af, [0x0f7e] = 0x66b0, [0x0f7f] = 0x66b1, [0x0f80] = 0x66b2,
  [0x0f81] = 0x66b3, [0x0f82] = 0x66b5, [0x0f83] = 0x66b6, [0x0f84] = 0x66b7,
  [0x0f85] = 0x66b8, [0x0f86] = 0x66ba, [0x0f87] = 0x66bb, [0x0f88] = 0x66bc,
  [0x0f89] = 0x66bd, [0x0f8a] = 0x66bf, [0x0f8b] = 0x66c0, [0x0f8c] = 0x66c1,
  [0x0f8d] = 0x66c2, [0x0f8e] = 0x66c3, [0x0f8f] = 0x66c4, [0x0f90] = 0x66c5,
  [0x0f91] = 0x66c6, [0x0f92] = 0x66c7, [0x0f93] = 0x66c8, [0x0f94] = 0x66c9,
  [0x0f95] = 0x66ca, [0x0f96] = 0x66cb, [0x0f97] = 0x66cc, [0x0f98] = 0x66cd,
  [0x0f99] = 0x66ce, [0x0f9a] = 0x66cf, [0x0f9b] = 0x66d0, [0x0f9c] = 0x66d1,
  [0x0f9d] = 0x66d2, [0x0f9e] = 0x66d3, [0x0f9f] = 0x66d4, [0x0fa0] = 0x66d5,
  [0x0fa1] = 0x66d6, [0x0fa2] = 0x66d7, [0x0fa3] = 0x66d8, [0x0fa4] = 0x66da,
  [0x0fa5] = 0x66de, [0x0fa6] = 0x66df, [0x0fa7] = 0x66e0, [0x0fa8] = 0x66e1,
  [0x0fa9] = 0x66e2, [0x0faa] = 0x66e3, [0x0fab] = 0x66e4, [0x0fac] = 0x66e5,
  [0x0fad] = 0x66e7, [0x0fae] = 0x66e8, [0x0faf] = 0x66ea, [0x0fb0] = 0x66eb,
  [0x0fb1] = 0x66ec, [0x0fb2] = 0x66ed, [0x0fb3] = 0x66ee, [0x0fb4] = 0x66ef,
  [0x0fb5] = 0x66f1, [0x0fb6] = 0x66f5, [0x0fb7] = 0x66f6, [0x0fb8] = 0x66f8,
  [0x0fb9] = 0x66fa, [0x0fba] = 0x66fb, [0x0fbb] = 0x66fd, [0x0fbc] = 0x6701,
  [0x0fbd] = 0x6702, [0x0fbe] = 0x6703, [0x0fc0] = 0x6704, [0x0fc1] = 0x6705,
  [0x0fc2] = 0x6706, [0x0fc3] = 0x6707, [0x0fc4] = 0x670c, [0x0fc5] = 0x670e,
  [0x0fc6] = 0x670f, [0x0fc7] = 0x6711, [0x0fc8] = 0x6712, [0x0fc9] = 0x6713,
  [0x0fca] = 0x6716, [0x0fcb] = 0x6718, [0x0fcc] = 0x6719, [0x0fcd] = 0x671a,
  [0x0fce] = 0x671c, [0x0fcf] = 0x671e, [0x0fd0] = 0x6720, [0x0fd1] = 0x6721,
  [0x0fd2] = 0x6722, [0x0fd3] = 0x6723, [0x0fd4] = 0x6724, [0x0fd5] = 0x6725,
  [0x0fd6] = 0x6727, [0x0fd7] = 0x6729, [0x0fd8] = 0x672e, [0x0fd9] = 0x6730,
  [0x0fda] = 0x6732, [0x0fdb] = 0x6733, [0x0fdc] = 0x6736, [0x0fdd] = 0x6737,
  [0x0fde] = 0x6738, [0x0fdf] = 0x6739, [0x0fe0] = 0x673b, [0x0fe1] = 0x673c,
  [0x0fe2] = 0x673e, [0x0fe3] = 0x673f, [0x0fe4] = 0x6741, [0x0fe5] = 0x6744,
  [0x0fe6] = 0x6745, [0x0fe7] = 0x6747, [0x0fe8] = 0x674a, [0x0fe9] = 0x674b,
  [0x0fea] = 0x674d, [0x0feb] = 0x6752, [0x0fec] = 0x6754, [0x0fed] = 0x6755,
  [0x0fee] = 0x6757, [0x0fef] = 0x6758, [0x0ff0] = 0x6759, [0x0ff1] = 0x675a,
  [0x0ff2] = 0x675b, [0x0ff3] = 0x675d, [0x0ff4] = 0x6762, [0x0ff5] = 0x6763,
  [0x0ff6] = 0x6764, [0x0ff7] = 0x6766, [0x0ff8] = 0x6767, [0x0ff9] = 0x676b,
  [0x0ffa] = 0x676c, [0x0ffb] = 0x676e, [0x0ffc] = 0x6771, [0x0ffd] = 0x6774,
  [0x0ffe] = 0x6776, [0x1000] = 0x6778, [0x1001] = 0x6779, [0x1002] = 0x677a,
  [0x1003] = 0x677b, [0x1004] = 0x677d, [0x1005] = 0x6780, [0x1006] = 0x6782,
  [0x1007] = 0x6783, [0x1008] = 0x6785, [0x1009] = 0x6786, [0x100a] = 0x6788,
  [0x100b] = 0x678a, [0x100c] = 0x678c, [0x100d] = 0x678d, [0x100e] = 0x678e,
  [0x100f] = 0x678f, [0x1010] = 0x6791, [0x1011] = 0x6792, [0x1012] = 0x6793,
  [0x1013] = 0x6794, [0x1014] = 0x6796, [0x1015] = 0x6799, [0x1016] = 0x679b,
  [0x1017] = 0x679f, [0x1018] = 0x67a0, [0x1019] = 0x67a1, [0x101a] = 0x67a4,
  [0x101b] = 0x67a6, [0x101c] = 0x67a9, [0x101d] = 0x67ac, [0x101e] = 0x67ae,
  [0x101f] = 0x67b1, [0x1020] = 0x67b2, [0x1021] = 0x67b4, [0x1022] = 0x67b9,
  [0x1023] = 0x67ba, [0x1024] = 0x67bb, [0x1025] = 0x67bc, [0x1026] = 0x67bd,
  [0x1027] = 0x67be, [0x1028] = 0x67bf, [0x1029] = 0x67c0, [0x102a] = 0x67c2,
  [0x102b] = 0x67c5, [0x102c] = 0x67c6, [0x102d] = 0x67c7, [0x102e] = 0x67c8,
  [0x102f] = 0x67c9, [0x1030] = 0x67ca, [0x1031] = 0x67cb, [0x1032] = 0x67cc,
  [0x1033] = 0x67cd, [0x1034] = 0x67ce, [0x1035] = 0x67d5, [0x1036] = 0x67d6,
  [0x1037] = 0x67d7, [0x1038] = 0x67db, [0x1039] = 0x67df, [0x103a] = 0x67e1,
  [0x103b] = 0x67e3, [0x103c] = 0x67e4, [0x103d] = 0x67e6, [0x103e] = 0x67e7,
  [0x103f] = 0x67e8, [0x1040] = 0x67ea, [0x1041] = 0x67eb, [0x1042] = 0x67ed,
  [0x1043] = 0x67ee, [0x1044] = 0x67f2, [0x1045] = 0x67f5, [0x1046] = 0x67f6,
  [0x1047] = 0x67f7, [0x1048] = 0x67f8, [0x1049] = 0x67f9, [0x104a] = 0x67fa,
  [0x104b] = 0x67fb, [0x104c] = 0x67fc, [0x104d] = 0x67fe, [0x104e] = 0x6801,
  [0x104f] = 0x6802, [0x1050] = 0x6803, [0x1051] = 0x6804, [0x1052] = 0x6806,
  [0x1053] = 0x680d, [0x1054] = 0x6810, [0x1055] = 0x6812, [0x1056] = 0x6814,
  [0x1057] = 0x6815, [0x1058] = 0x6818, [0x1059] = 0x6819, [0x105a] = 0x681a,
  [0x105b] = 0x681b, [0x105c] = 0x681c, [0x105d] = 0x681e, [0x105e] = 0x681f,
  [0x105f] = 0x6820, [0x1060] = 0x6822, [0x1061] = 0x6823, [0x1062] = 0x6824,
  [0x1063] = 0x6825, [0x1064] = 0x6826, [0x1065] = 0x6827, [0x1066] = 0x6828,
  [0x1067] = 0x682b, [0x1068] = 0x682c, [0x1069] = 0x682d, [0x106a] = 0x682e,
  [0x106b] = 0x682f, [0x106c] = 0x6830, [0x106d] = 0x6831, [0x106e] = 0x6834,
  [0x106f] = 0x6835, [0x1070] = 0x6836, [0x1071] = 0x683a, [0x1072] = 0x683b,
  [0x1073] = 0x683f, [0x1074] = 0x6847, [0x1075] = 0x684b, [0x1076] = 0x684d,
  [0x1077] = 0x684f, [0x1078] = 0x6852, [0x1079] = 0x6856, [0x107a] = 0x6857,
  [0x107b] = 0x6858, [0x107c] = 0x6859, [0x107d] = 0x685a, [0x107e] = 0x685b,
  [0x1080] = 0x685c, [0x1081] = 0x685d, [0x1082] = 0x685e, [0x1083] = 0x685f,
  [0x1084] = 0x686a, [0x1085] = 0x686c, [0x1086] = 0x686d, [0x1087] = 0x686e,
  [0x1088] = 0x686f, [0x1089] = 0x6870, [0x108a] = 0x6871, [0x108b] = 0x6872,
  [0x108c] = 0x6873, [0x108d] = 0x6875, [0x108e] = 0x6878, [0x108f] = 0x6879,
  [0x1090] = 0x687a, [0x1091] = 0x687b, [0x1092] = 0x687c, [0x1093] = 0x687d,
  [0x1094] = 0x687e, [0x1095] = 0x687f, [0x1096] = 0x6880, [0x1097] = 0x6882,
  [0x1098] = 0x6884, [0x1099] = 0x6887, [0x109a] = 0x6888, [0x109b] = 0x6889,
  [0x109c] = 0x688a, [0x109d] = 0x688b, [0x109e] = 0x688c, [0x109f] = 0x688d,
  [0x10a0] = 0x688e, [0x10a1] = 0x6890, [0x10a2] = 0x6891, [0x10a3] = 0x6892,
  [0x10a4] = 0x6894, [0x10a5] = 0x6895, [0x10a6] = 0x6896, [0x10a7] = 0x6898,
  [0x10a8] = 0x6899, [0x10a9] = 0x689a, [0x10aa] = 0x689b, [0x10ab] = 0x689c,
  [0x10ac] = 0x689d, [0x10ad] = 0x689e, [0x10ae] = 0x689f, [0x10af] = 0x68a0,
  [0x10b0] = 0x68a1, [0x10b1] = 0x68a3, [0x10b2] = 0x68a4, [0x10b3] = 0x68a5,
  [0x10b4] = 0x68a9, [0x10b5] = 0x68aa, [0x10b6] = 0x68ab, [0x10b7] = 0x68ac,
  [0x10b8] = 0x68ae, [0x10b9] = 0x68b1, [0x10ba] = 0x68b2, [0x10bb] = 0x68b4,
  [0x10bc] = 0x68b6, [0x10bd] = 0x68b7, [0x10be] = 0x68b8, [0x10c0] = 0x68b9,
  [0x10c1] = 0x68ba, [0x10c2] = 0x68bb, [0x10c3] = 0x68bc, [0x10c4] = 0x68bd,
  [0x10c5] = 0x68be, [0x10c6] = 0x68bf, [0x10c7] = 0x68c1, [0x10c8] = 0x68c3,
  [0x10c9] = 0x68c4, [0x10ca] = 0x68c5, [0x10cb] = 0x68c6, [0x10cc] = 0x68c7,
  [0x10cd] = 0x68c8, [0x10ce] = 0x68ca, [0x10cf] = 0x68cc, [0x10d0] = 0x68ce,
  [0x10d1] = 0x68cf, [0x10d2] = 0x68d0, [0x10d3] = 0x68d1, [0x10d4] = 0x68d3,
  [0x10d5] = 0x68d4, [0x10d6] = 0x68d6, [0x10d7] = 0x68d7, [0x10d8] = 0x68d9,
  [0x10d9] = 0x68db, [0x10da] = 0x68dc, [0x10db] = 0x68dd, [0x10dc] = 0x68de,
  [0x10dd] = 0x68df, [0x10de] = 0x68e1, [0x10df] = 0x68e2, [0x10e0] = 0x68e4,
  [0x10e1] = 0x68e5, [0x10e2] = 0x68e6, [0x10e3] = 0x68e7, [0x10e4] = 0x68e8,
  [0x10e5] = 0x68e9, [0x10e6] = 0x68ea, [0x10e7] = 0x68eb, [0x10e8] = 0x68ec,
  [0x10e9] = 0x68ed, [0x10ea] = 0x68ef, [0x10eb] = 0x68f2, [0x10ec] = 0x68f3,
  [0x10ed] = 0x68f4, [0x10ee] = 0x68f6, [0x10ef] = 0x68f7, [0x10f0] = 0x68f8,
  [0x10f1] = 0x68fb, [0x10f2] = 0x68fd, [0x10f3] = 0x68fe, [0x10f4] = 0x68ff,
  [0x10f5] = 0x6900, [0x10f6] = 0x6902, [0x10f7] = 0x6903, [0x10f8] = 0x6904,
  [0x10f9] = 0x6906, [0x10fa] = 0x6907, [0x10fb] = 0x6908, [0x10fc] = 0x6909,
  [0x10fd] = 0x690a, [0x10fe] = 0x690c, [0x10ff] = 0x690f, [0x1100] = 0x6911,
  [0x1101] = 0x6913, [0x1102] = 0x6914, [0x1103] = 0x6915, [0x1104] = 0x6916,
  [0x1105] = 0x6917, [0x1106] = 0x6918, [0x1107] = 0x6919, [0x1108] = 0x691a,
  [0x1109] = 0x691b, [0x110a] = 0x691c, [0x110b] = 0x691d, [0x110c] = 0x691e,
  [0x110d] = 0x6921, [0x110e] = 0x6922, [0x110f] = 0x6923, [0x1110] = 0x6925,
  [0x1111] = 0x6926, [0x1112] = 0x6927, [0x1113] = 0x6928, [0x1114] = 0x6929,
  [0x1115] = 0x692a, [0x1116] = 0x692b, [0x1117] = 0x692c, [0x1118] = 0x692e,
  [0x1119] = 0x692f, [0x111a] = 0x6931, [0x111b] = 0x6932, [0x111c] = 0x6933,
  [0x111d] = 0x6935, [0x111e] = 0x6936, [0x111f] = 0x6937, [0x1120] = 0x6938,
  [0x1121] = 0x693a, [0x1122] = 0x693b, [0x1123] = 0x693c, [0x1124] = 0x693e,
  [0x1125] = 0x6940, [0x1126] = 0x6941, [0x1127] = 0x6943, [0x1128] = 0x6944,
  [0x1129] = 0x6945, [0x112a] = 0x6946, [0x112b] = 0x6947, [0x112c] = 0x6948,
  [0x112d] = 0x6949, [0x112e] = 0x694a, [0x112f] = 0x694b, [0x1130] = 0x694c,
  [0x1131] = 0x694d, [0x1132] = 0x694e, [0x1133] = 0x694f, [0x1134] = 0x6950,
  [0x1135] = 0x6951, [0x1136] = 0x6952, [0x1137] = 0x6953, [0x1138] = 0x6955,
  [0x1139] = 0x6956, [0x113a] = 0x6958, [0x113b] = 0x6959, [0x113c] = 0x695b,
  [0x113d] = 0x695c, [0x113e] = 0x695f, [0x1140] = 0x6961, [0x1141] = 0x6962,
  [0x1142] = 0x6964, [0x1143] = 0x6965, [0x1144] = 0x6967, [0x1145] = 0x6968,
  [0x1146] = 0x6969, [0x1147] = 0x696a, [0x1148] = 0x696c, [0x1149] = 0x696d,
  [0x114a] = 0x696f, [0x114b] = 0x6970, [0x114c] = 0x6972, [0x114d] = 0x6973,
  [0x114e] = 0x6974, [0x114f] = 0x6975, [0x1150] = 0x6976, [0x1151] = 0x697a,
  [0x1152] = 0x697b, [0x1153] = 0x697d, [0x1154] = 0x697e, [0x1155] = 0x697f,
  [0x1156] = 0x6981, [0x1157] = 0x6983, [0x1158] = 0x6985, [0x1159] = 0x698a,
  [0x115a] = 0x698b, [0x115b] = 0x698c, [0x115c] = 0x698e, [0x115d] = 0x698f,
  [0x115e] = 0x6990, [0x115f] = 0x6991, [0x1160] = 0x6992, [0x1161] = 0x6993,
  [0x1162] = 0x6996, [0x1163] = 0x6997, [0x1164] = 0x6999, [0x1165] = 0x699a,
  [0x1166] = 0x699d, [0x1167] = 0x699e, [0x1168] = 0x699f, [0x1169] = 0x69a0,
  [0x116a] = 0x69a1, [0x116b] = 0x69a2, [0x116c] = 0x69a3, [0x116d] = 0x69a4,
  [0x116e] = 0x69a5, [0x116f] = 0x69a6, [0x1170] = 0x69a9, [0x1171] = 0x69aa,
  [0x1172] = 0x69ac, [0x1173] = 0x69ae, [0x1174] = 0x69af, [0x1175] = 0x69b0,
  [0x1176] = 0x69b2, [0x1177] = 0x69b3, [0x1178] = 0x69b5, [0x1179] = 0x69b6,
  [0x117a] = 0x69b8, [0x117b] = 0x69b9, [0x117c] = 0x69ba, [0x117d] = 0x69bc,
  [0x117e] = 0x69bd, [0x1180] = 0x69be, [0x1181] = 0x69bf, [0x1182] = 0x69c0,
  [0x1183] = 0x69c2, [0x1184] = 0x69c3, [0x1185] = 0x69c4, [0x1186] = 0x69c5,
  [0x1187] = 0x69c6, [0x1188] = 0x69c7, [0x1189] = 0x69c8, [0x118a] = 0x69c9,
  [0x118b] = 0x69cb, [0x118c] = 0x69cd, [0x118d] = 0x69cf, [0x118e] = 0x69d1,
  [0x118f] = 0x69d2, [0x1190] = 0x69d3, [0x1191] = 0x69d5, [0x1192] = 0x69d6,
  [0x1193] = 0x69d7, [0x1194] = 0x69d8, [0x1195] = 0x69d9, [0x1196] = 0x69da,
  [0x1197] = 0x69dc, [0x1198] = 0x69dd, [0x1199] = 0x69de, [0x119a] = 0x69e1,
  [0x119b] = 0x69e2, [0x119c] = 0x69e3, [0x119d] = 0x69e4, [0x119e] = 0x69e5,
  [0x119f] = 0x69e6, [0x11a0] = 0x69e7, [0x11a1] = 0x69e8, [0x11a2] = 0x69e9,
  [0x11a3] = 0x69ea, [0x11a4] = 0x69eb, [0x11a5] = 0x69ec, [0x11a6] = 0x69ee,
  [0x11a7] = 0x69ef, [0x11a8] = 0x69f0, [0x11a9] = 0x69f1, [0x11aa] = 0x69f3,
  [0x11ab] = 0x69f4, [0x11ac] = 0x69f5, [0x11ad] = 0x69f6, [0x11ae] = 0x69f7,
  [0x11af] = 0x69f8, [0x11b0] = 0x69f9, [0x11b1] = 0x69fa, [0x11b2] = 0x69fb,
  [0x11b3] = 0x69fc, [0x11b4] = 0x69fe, [0x11b5] = 0x6a00, [0x11b6] = 0x6a01,
  [0x11b7] = 0x6a02, [0x11b8] = 0x6a03, [0x11b9] = 0x6a04, [0x11ba] = 0x6a05,
  [0x11bb] = 0x6a06, [0x11bc] = 0x6a07, [0x11bd] = 0x6a08, [0x11be] = 0x6a09,
  [0x11bf] = 0x6a0b, [0x11c0] = 0x6a0c, [0x11c1] = 0x6a0d, [0x11c2] = 0x6a0e,
  [0x11c3] = 0x6a0f, [0x11c4] = 0x6a10, [0x11c5] = 0x6a11, [0x11c6] = 0x6a12,
  [0x11c7] = 0x6a13, [0x11c8] = 0x6a14, [0x11c9] = 0x6a15, [0x11ca] = 0x6a16,
  [0x11cb] = 0x6a19, [0x11cc] = 0x6a1a, [0x11cd] = 0x6a1b, [0x11ce] = 0x6a1c,
  [0x11cf] = 0x6a1d, [0x11d0] = 0x6a1e, [0x11d1] = 0x6a20, [0x11d2] = 0x6a22,
  [0x11d3] = 0x6a23, [0x11d4] = 0x6a24, [0x11d5] = 0x6a25, [0x11d6] = 0x6a26,
  [0x11d7] = 0x6a27, [0x11d8] = 0x6a29, [0x11d9] = 0x6a2b, [0x11da] = 0x6a2c,
  [0x11db] = 0x6a2d, [0x11dc] = 0x6a2e, [0x11dd] = 0x6a30, [0x11de] = 0x6a32,
  [0x11df] = 0x6a33, [0x11e0] = 0x6a34, [0x11e1] = 0x6a36, [0x11e2] = 0x6a37,
  [0x11e3] = 0x6a38, [0x11e4] = 0x6a39, [0x11e5] = 0x6a3a, [0x11e6] = 0x6a3b,
  [0x11e7] = 0x6a3c, [0x11e8] = 0x6a3f, [0x11e9] = 0x6a40, [0x11ea] = 0x6a41,
  [0x11eb] = 0x6a42, [0x11ec] = 0x6a43, [0x11ed] = 0x6a45, [0x11ee] = 0x6a46,
  [0x11ef] = 0x6a48, [0x11f0] = 0x6a49, [0x11f1] = 0x6a4a, [0x11f2] = 0x6a4b,
  [0x11f3] = 0x6a4c, [0x11f4] = 0x6a4d, [0x11f5] = 0x6a4e, [0x11f6] = 0x6a4f,
  [0x11f7] = 0x6a51, [0x11f8] = 0x6a52, [0x11f9] = 0x6a53, [0x11fa] = 0x6a54,
  [0x11fb] = 0x6a55, [0x11fc] = 0x6a56, [0x11fd] = 0x6a57, [0x11fe] = 0x6a5a,
  [0x1200] = 0x6a5c, [0x1201] = 0x6a5d, [0x1202] = 0x6a5e, [0x1203] = 0x6a5f,
  [0x1204] = 0x6a60, [0x1205] = 0x6a62, [0x1206] = 0x6a63, [0x1207] = 0x6a64,
  [0x1208] = 0x6a66, [0x1209] = 0x6a67, [0x120a] = 0x6a68, [0x120b] = 0x6a69,
  [0x120c] = 0x6a6a, [0x120d] = 0x6a6b, [0x120e] = 0x6a6c, [0x120f] = 0x6a6d,
  [0x1210] = 0x6a6e, [0x1211] = 0x6a6f, [0x1212] = 0x6a70, [0x1213] = 0x6a72,
  [0x1214] = 0x6a73, [0x1215] = 0x6a74, [0x1216] = 0x6a75, [0x1217] = 0x6a76,
  [0x1218] = 0x6a77, [0x1219] = 0x6a78, [0x121a] = 0x6a7a, [0x121b] = 0x6a7b,
  [0x121c] = 0x6a7d, [0x121d] = 0x6a7e, [0x121e] = 0x6a7f, [0x121f] = 0x6a81,
  [0x1220] = 0x6a82, [0x1221] = 0x6a83, [0x1222] = 0x6a85, [0x1223] = 0x6a86,
  [0x1224] = 0x6a87, [0x1225] = 0x6a88, [0x1226] = 0x6a89, [0x1227] = 0x6a8a,
  [0x1228] = 0x6a8b, [0x1229] = 0x6a8c, [0x122a] = 0x6a8d, [0x122b] = 0x6a8f,
  [0x122c] = 0x6a92, [0x122d] = 0x6a93, [0x122e] = 0x6a94, [0x122f] = 0x6a95,
  [0x1230] = 0x6a96, [0x1231] = 0x6a98, [0x1232] = 0x6a99, [0x1233] = 0x6a9a,
  [0x1234] = 0x6a9b, [0x1235] = 0x6a9c, [0x1236] = 0x6a9d, [0x1237] = 0x6a9e,
  [0x1238] = 0x6a9f, [0x1239] = 0x6aa1, [0x123a] = 0x6aa2, [0x123b] = 0x6aa3,
  [0x123c] = 0x6aa4, [0x123d] = 0x6aa5, [0x123e] = 0x6aa6, [0x1240] = 0x6aa7,
  [0x1241] = 0x6aa8, [0x1242] = 0x6aaa, [0x1243] = 0x6aad, [0x1244] = 0x6aae,
  [0x1245] = 0x6aaf, [0x1246] = 0x6ab0, [0x1247] = 0x6ab1, [0x1248] = 0x6ab2,
  [0x1249] = 0x6ab3, [0x124a] = 0x6ab4, [0x124b] = 0x6ab5, [0x124c] = 0x6ab6,
  [0x124d] = 0x6ab7, [0x124e] = 0x6ab8, [0x124f] = 0x6ab9, [0x1250] = 0x6aba,
  [0x1251] = 0x6abb, [0x1252] = 0x6abc, [0x1253] = 0x6abd, [0x1254] = 0x6abe,
  [0x1255] = 0x6abf, [0x1256] = 0x6ac0, [0x1257] = 0x6ac1, [0x1258] = 0x6ac2,
  [0x1259] = 0x6ac3, [0x125a] = 0x6ac4, [0x125b] = 0x6ac5, [0x125c] = 0x6ac6,
  [0x125d] = 0x6ac7, [0x125e] = 0x6ac8, [0x125f] = 0x6ac9, [0x1260] = 0x6aca,
  [0x1261] = 0x6acb, [0x1262] = 0x6acc, [0x1263] = 0x6acd, [0x1264] = 0x6ace,
  [0x1265] = 0x6acf, [0x1266] = 0x6ad0, [0x1267] = 0x6ad1, [0x1268] = 0x6ad2,
  [0x1269] = 0x6ad3, [0x126a] = 0x6ad4, [0x126b] = 0x6ad5, [0x126c] = 0x6ad6,
  [0x126d] = 0x6ad7, [0x126e] = 0x6ad8, [0x126f] = 0x6ad9, [0x1270] = 0x6ada,
  [0x1271] = 0x6adb, [0x1272] = 0x6adc, [0x1273] = 0x6add, [0x1274] = 0x6ade,
  [0x1275] = 0x6adf, [0x1276] = 0x6ae0, [0x1277] = 0x6ae1, [0x1278] = 0x6ae2,
  [0x1279] = 0x6ae3, [0x127a] = 0x6ae4, [0x127b] = 0x6ae5, [0x127c] = 0x6ae6,
  [0x127d] = 0x6ae7, [0x127e] = 0x6ae8, [0x127f] = 0x6ae9, [0x1280] = 0x6aea,
  [0x1281] = 0x6aeb, [0x1282] = 0x6aec, [0x1283] = 0x6aed, [0x1284] = 0x6aee,
  [0x1285] = 0x6aef, [0x1286] = 0x6af0, [0x1287] = 0x6af1, [0x1288] = 0x6af2,
  [0x1289] = 0x6af3, [0x128a] = 0x6af4, [0x128b] = 0x6af5, [0x128c] = 0x6af6,
  [0x128d] = 0x6af7, [0x128e] = 0x6af8, [0x128f] = 0x6af9, [0x1290] = 0x6afa,
  [0x1291] = 0x6afb, [0x1292] = 0x6afc, [0x1293] = 0x6afd, [0x1294] = 0x6afe,
  [0x1295] = 0x6aff, [0x1296] = 0x6b00, [0x1297] = 0x6b01, [0x1298] = 0x6b02,
  [0x1299] = 0x6b03, [0x129a] = 0x6b04, [0x129b] = 0x6b05, [0x129c] = 0x6b06,
  [0x129d] = 0x6b07, [0x129e] = 0x6b08, [0x129f] = 0x6b09, [0x12a0] = 0x6b0a,
  [0x12a1] = 0x6b0b, [0x12a2] = 0x6b0c, [0x12a3] = 0x6b0d, [0x12a4] = 0x6b0e,
  [0x12a5] = 0x6b0f, [0x12a6] = 0x6b10, [0x12a7] = 0x6b11, [0x12a8] = 0x6b12,
  [0x12a9] = 0x6b13, [0x12aa] = 0x6b14, [0x12ab] = 0x6b15, [0x12ac] = 0x6b16,
  [0x12ad] = 0x6b17, [0x12ae] = 0x6b18, [0x12af] = 0x6b19, [0x12b0] = 0x6b1a,
  [0x12b1] = 0x6b1b, [0x12b2] = 0x6b1c, [0x12b3] = 0x6b1d, [0x12b4] = 0x6b1e,
  [0x12b5] = 0x6b1f, [0x12b6] = 0x6b25, [0x12b7] = 0x6b26, [0x12b8] = 0x6b28,
  [0x12b9] = 0x6b29, [0x12ba] = 0x6b2a, [0x12bb] = 0x6b2b, [0x12bc] = 0x6b2c,
  [0x12bd] = 0x6b2d, [0x12be] = 0x6b2e, [0x12c0] = 0x6b2f, [0x12c1] = 0x6b30,
  [0x12c2] = 0x6b31, [0x12c3] = 0x6b33, [0x12c4] = 0x6b34, [0x12c5] = 0x6b35,
  [0x12c6] = 0x6b36, [0x12c7] = 0x6b38, [0x12c8] = 0x6b3b, [0x12c9] = 0x6b3c,
  [0x12ca] = 0x6b3d, [0x12cb] = 0x6b3f, [0x12cc] = 0x6b40, [0x12cd] = 0x6b41,
  [0x12ce] = 0x6b42, [0x12cf] = 0x6b44, [0x12d0] = 0x6b45, [0x12d1] = 0x6b48,
  [0x12d2] = 0x6b4a, [0x12d3] = 0x6b4b, [0x12d4] = 0x6b4d, [0x12d5] = 0x6b4e,
  [0x12d6] = 0x6b4f, [0x12d7] = 0x6b50, [0x12d8] = 0x6b51, [0x12d9] = 0x6b52,
  [0x12da] = 0x6b53, [0x12db] = 0x6b54, [0x12dc] = 0x6b55, [0x12dd] = 0x6b56,
  [0x12de] = 0x6b57, [0x12df] = 0x6b58, [0x12e0] = 0x6b5a, [0x12e1] = 0x6b5b,
  [0x12e2] = 0x6b5c, [0x12e3] = 0x6b5d, [0x12e4] = 0x6b5e, [0x12e5] = 0x6b5f,
  [0x12e6] = 0x6b60, [0x12e7] = 0x6b61, [0x12e8] = 0x6b68, [0x12e9] = 0x6b69,
  [0x12ea] = 0x6b6b, [0x12eb] = 0x6b6c, [0x12ec] = 0x6b6d, [0x12ed] = 0x6b6e,
  [0x12ee] = 0x6b6f, [0x12ef] = 0x6b70, [0x12f0] = 0x6b71, [0x12f1] = 0x6b72,
  [0x12f2] = 0x6b73, [0x12f3] = 0x6b74, [0x12f4] = 0x6b75, [0x12f5] = 0x6b76,
  [0x12f6] = 0x6b77, [0x12f7] = 0x6b78, [0x12f8] = 0x6b7a, [0x12f9] = 0x6b7d,
  [0x12fa] = 0x6b7e, [0x12fb] = 0x6b7f, [0x12fc] = 0x6b80, [0x12fd] = 0x6b85,
  [0x12fe] = 0x6b88, [0x1300] = 0x6b8c, [0x1301] = 0x6b8e, [0x1302] = 0x6b8f,
  [0x1303] = 0x6b90, [0x1304] = 0x6b91, [0x1305] = 0x6b94, [0x1306] = 0x6b95,
  [0x1307] = 0x6b97, [0x1308] = 0x6b98, [0x1309] = 0x6b99, [0x130a] = 0x6b9c,
  [0x130b] = 0x6b9d, [0x130c] = 0x6b9e, [0x130d] = 0x6b9f, [0x130e] = 0x6ba0,
  [0x130f] = 0x6ba2, [0x1310] = 0x6ba3, [0x1311] = 0x6ba4, [0x1312] = 0x6ba5,
  [0x1313] = 0x6ba6, [0x1314] = 0x6ba7, [0x1315] = 0x6ba8, [0x1316] = 0x6ba9,
  [0x1317] = 0x6bab, [0x1318] = 0x6bac, [0x1319] = 0x6bad, [0x131a] = 0x6bae,
  [0x131b] = 0x6baf, [0x131c] = 0x6bb0, [0x131d] = 0x6bb1, [0x131e] = 0x6bb2,
  [0x131f] = 0x6bb6, [0x1320] = 0x6bb8, [0x1321] = 0x6bb9, [0x1322] = 0x6bba,
  [0x1323] = 0x6bbb, [0x1324] = 0x6bbc, [0x1325] = 0x6bbd, [0x1326] = 0x6bbe,
  [0x1327] = 0x6bc0, [0x1328] = 0x6bc3, [0x1329] = 0x6bc4, [0x132a] = 0x6bc6,
  [0x132b] = 0x6bc7, [0x132c] = 0x6bc8, [0x132d] = 0x6bc9, [0x132e] = 0x6bca,
  [0x132f] = 0x6bcc, [0x1330] = 0x6bce, [0x1331] = 0x6bd0, [0x1332] = 0x6bd1,
  [0x1333] = 0x6bd8, [0x1334] = 0x6bda, [0x1335] = 0x6bdc, [0x1336] = 0x6bdd,
  [0x1337] = 0x6bde, [0x1338] = 0x6bdf, [0x1339] = 0x6be0, [0x133a] = 0x6be2,
  [0x133b] = 0x6be3, [0x133c] = 0x6be4, [0x133d] = 0x6be5, [0x133e] = 0x6be6,
  [0x133f] = 0x6be7, [0x1340] = 0x6be8, [0x1341] = 0x6be9, [0x1342] = 0x6bec,
  [0x1343] = 0x6bed, [0x1344] = 0x6bee, [0x1345] = 0x6bf0, [0x1346] = 0x6bf1,
  [0x1347] = 0x6bf2, [0x1348] = 0x6bf4, [0x1349] = 0x6bf6, [0x134a] = 0x6bf7,
  [0x134b] = 0x6bf8, [0x134c] = 0x6bfa, [0x134d] = 0x6bfb, [0x134e] = 0x6bfc,
  [0x134f] = 0x6bfe, [0x1350] = 0x6bff, [0x1351] = 0x6c00, [0x1352] = 0x6c01,
  [0x1353] = 0x6c02, [0x1354] = 0x6c03, [0x1355] = 0x6c04, [0x1356] = 0x6c08,
  [0x1357] = 0x6c09, [0x1358] = 0x6c0a, [0x1359] = 0x6c0b, [0x135a] = 0x6c0c,
  [0x135b] = 0x6c0e, [0x135c] = 0x6c12, [0x135d] = 0x6c17, [0x135e] = 0x6c1c,
  [0x135f] = 0x6c1d, [0x1360] = 0x6c1e, [0x1361] = 0x6c20, [0x1362] = 0x6c23,
  [0x1363] = 0x6c25, [0x1364] = 0x6c2b, [0x1365] = 0x6c2c, [0x1366] = 0x6c2d,
  [0x1367] = 0x6c31, [0x1368] = 0x6c33, [0x1369] = 0x6c36, [0x136a] = 0x6c37,
  [0x136b] = 0x6c39, [0x136c] = 0x6c3a, [0x136d] = 0x6c3b, [0x136e] = 0x6c3c,
  [0x136f] = 0x6c3e, [0x1370] = 0x6c3f, [0x1371] = 0x6c43, [0x1372] = 0x6c44,
  [0x1373] = 0x6c45, [0x1374] = 0x6c48, [0x1375] = 0x6c4b, [0x1376] = 0x6c4c,
  [0x1377] = 0x6c4d, [0x1378] = 0x6c4e, [0x1379] = 0x6c4f, [0x137a] = 0x6c51,
  [0x137b] = 0x6c52, [0x137c] = 0x6c53, [0x137d] = 0x6c56, [0x137e] = 0x6c58,
  [0x1380] = 0x6c59, [0x1381] = 0x6c5a, [0x1382] = 0x6c62, [0x1383] = 0x6c63,
  [0x1384] = 0x6c65, [0x1385] = 0x6c66, [0x1386] = 0x6c67, [0x1387] = 0x6c6b,
  [0x1388] = 0x6c6c, [0x1389] = 0x6c6d, [0x138a] = 0x6c6e, [0x138b] = 0x6c6f,
  [0x138c] = 0x6c71, [0x138d] = 0x6c73, [0x138e] = 0x6c75, [0x138f] = 0x6c77,
  [0x1390] = 0x6c78, [0x1391] = 0x6c7a, [0x1392] = 0x6c7b, [0x1393] = 0x6c7c,
  [0x1394] = 0x6c7f, [0x1395] = 0x6c80, [0x1396] = 0x6c84, [0x1397] = 0x6c87,
  [0x1398] = 0x6c8a, [0x1399] = 0x6c8b, [0x139a] = 0x6c8d, [0x139b] = 0x6c8e,
  [0x139c] = 0x6c91, [0x139d] = 0x6c92, [0x139e] = 0x6c95, [0x139f] = 0x6c96,
  [0x13a0] = 0x6c97, [0x13a1] = 0x6c98, [0x13a2] = 0x6c9a, [0x13a3] = 0x6c9c,
  [0x13a4] = 0x6c9d, [0x13a5] = 0x6c9e, [0x13a6] = 0x6ca0, [0x13a7] = 0x6ca2,
  [0x13a8] = 0x6ca8, [0x13a9] = 0x6cac, [0x13aa] = 0x6caf, [0x13ab] = 0x6cb0,
  [0x13ac] = 0x6cb4, [0x13ad] = 0x6cb5, [0x13ae] = 0x6cb6, [0x13af] = 0x6cb7,
  [0x13b0] = 0x6cba, [0x13b1] = 0x6cc0, [0x13b2] = 0x6cc1, [0x13b3] = 0x6cc2,
  [0x13b4] = 0x6cc3, [0x13b5] = 0x6cc6, [0x13b6] = 0x6cc7, [0x13b7] = 0x6cc8,
  [0x13b8] = 0x6ccb, [0x13b9] = 0x6ccd, [0x13ba] = 0x6cce, [0x13bb] = 0x6ccf,
  [0x13bc] = 0x6cd1, [0x13bd] = 0x6cd2, [0x13be] = 0x6cd8, [0x13c0] = 0x6cd9,
  [0x13c1] = 0x6cda, [0x13c2] = 0x6cdc, [0x13c3] = 0x6cdd, [0x13c4] = 0x6cdf,
  [0x13c5] = 0x6ce4, [0x13c6] = 0x6ce6, [0x13c7] = 0x6ce7, [0x13c8] = 0x6ce9,
  [0x13c9] = 0x6cec, [0x13ca] = 0x6ced, [0x13cb] = 0x6cf2, [0x13cc] = 0x6cf4,
  [0x13cd] = 0x6cf9, [0x13ce] = 0x6cff, [0x13cf] = 0x6d00, [0x13d0] = 0x6d02,
  [0x13d1] = 0x6d03, [0x13d2] = 0x6d05, [0x13d3] = 0x6d06, [0x13d4] = 0x6d08,
  [0x13d5] = 0x6d09, [0x13d6] = 0x6d0a, [0x13d7] = 0x6d0d, [0x13d8] = 0x6d0f,
  [0x13d9] = 0x6d10, [0x13da] = 0x6d11, [0x13db] = 0x6d13, [0x13dc] = 0x6d14,
  [0x13dd] = 0x6d15, [0x13de] = 0x6d16, [0x13df] = 0x6d18, [0x13e0] = 0x6d1c,
  [0x13e1] = 0x6d1d, [0x13e2] = 0x6d1f, [0x13e3] = 0x6d20, [0x13e4] = 0x6d21,
  [0x13e5] = 0x6d22, [0x13e6] = 0x6d23, [0x13e7] = 0x6d24, [0x13e8] = 0x6d26,
  [0x13e9] = 0x6d28, [0x13ea] = 0x6d29, [0x13eb] = 0x6d2c, [0x13ec] = 0x6d2d,
  [0x13ed] = 0x6d2f, [0x13ee] = 0x6d30, [0x13ef] = 0x6d34, [0x13f0] = 0x6d36,
  [0x13f1] = 0x6d37, [0x13f2] = 0x6d38, [0x13f3] = 0x6d3a, [0x13f4] = 0x6d3f,
  [0x13f5] = 0x6d40, [0x13f6] = 0x6d42, [0x13f7] = 0x6d44, [0x13f8] = 0x6d49,
  [0x13f9] = 0x6d4c, [0x13fa] = 0x6d50, [0x13fb] = 0x6d55, [0x13fc] = 0x6d56,
  [0x13fd] = 0x6d57, [0x13fe] = 0x6d58, [0x13ff] = 0x6d5b, [0x1400] = 0x6d5d,
  [0x1401] = 0x6d5f, [0x1402] = 0x6d61, [0x1403] = 0x6d62, [0x1404] = 0x6d64,
  [0x1405] = 0x6d65, [0x1406] = 0x6d67, [0x1407] = 0x6d68, [0x1408] = 0x6d6b,
  [0x1409] = 0x6d6c, [0x140a] = 0x6d6d, [0x140b] = 0x6d70, [0x140c] = 0x6d71,
  [0x140d] = 0x6d72, [0x140e] = 0x6d73, [0x140f] = 0x6d75, [0x1410] = 0x6d76,
  [0x1411] = 0x6d79, [0x1412] = 0x6d7a, [0x1413] = 0x6d7b, [0x1414] = 0x6d7d,
  [0x1415] = 0x6d7e, [0x1416] = 0x6d7f, [0x1417] = 0x6d80, [0x1418] = 0x6d81,
  [0x1419] = 0x6d83, [0x141a] = 0x6d84, [0x141b] = 0x6d86, [0x141c] = 0x6d87,
  [0x141d] = 0x6d8a, [0x141e] = 0x6d8b, [0x141f] = 0x6d8d, [0x1420] = 0x6d8f,
  [0x1421] = 0x6d90, [0x1422] = 0x6d92, [0x1423] = 0x6d96, [0x1424] = 0x6d97,
  [0x1425] = 0x6d98, [0x1426] = 0x6d99, [0x1427] = 0x6d9a, [0x1428] = 0x6d9c,
  [0x1429] = 0x6da2, [0x142a] = 0x6da5, [0x142b] = 0x6dac, [0x142c] = 0x6dad,
  [0x142d] = 0x6db0, [0x142e] = 0x6db1, [0x142f] = 0x6db3, [0x1430] = 0x6db4,
  [0x1431] = 0x6db6, [0x1432] = 0x6db7, [0x1433] = 0x6db9, [0x1434] = 0x6dba,
  [0x1435] = 0x6dbb, [0x1436] = 0x6dbc, [0x1437] = 0x6dbd, [0x1438] = 0x6dbe,
  [0x1439] = 0x6dc1, [0x143a] = 0x6dc2, [0x143b] = 0x6dc3, [0x143c] = 0x6dc8,
  [0x143d] = 0x6dc9, [0x143e] = 0x6dca, [0x1440] = 0x6dcd, [0x1441] = 0x6dce,
  [0x1442] = 0x6dcf, [0x1443] = 0x6dd0, [0x1444] = 0x6dd2, [0x1445] = 0x6dd3,
  [0x1446] = 0x6dd4, [0x1447] = 0x6dd5, [0x1448] = 0x6dd7, [0x1449] = 0x6dda,
  [0x144a] = 0x6ddb, [0x144b] = 0x6ddc, [0x144c] = 0x6ddf, [0x144d] = 0x6de2,
  [0x144e] = 0x6de3, [0x144f] = 0x6de5, [0x1450] = 0x6de7, [0x1451] = 0x6de8,
  [0x1452] = 0x6de9, [0x1453] = 0x6dea, [0x1454] = 0x6ded, [0x1455] = 0x6def,
  [0x1456] = 0x6df0, [0x1457] = 0x6df2, [0x1458] = 0x6df4, [0x1459] = 0x6df5,
  [0x145a] = 0x6df6, [0x145b] = 0x6df8, [0x145c] = 0x6dfa, [0x145d] = 0x6dfd,
  [0x145e] = 0x6dfe, [0x145f] = 0x6dff, [0x1460] = 0x6e00, [0x1461] = 0x6e01,
  [0x1462] = 0x6e02, [0x1463] = 0x6e03, [0x1464] = 0x6e04, [0x1465] = 0x6e06,
  [0x1466] = 0x6e07, [0x1467] = 0x6e08, [0x1468] = 0x6e09, [0x1469] = 0x6e0b,
  [0x146a] = 0x6e0f, [0x146b] = 0x6e12, [0x146c] = 0x6e13, [0x146d] = 0x6e15,
  [0x146e] = 0x6e18, [0x146f] = 0x6e19, [0x1470] = 0x6e1b, [0x1471] = 0x6e1c,
  [0x1472] = 0x6e1e, [0x1473] = 0x6e1f, [0x1474] = 0x6e22, [0x1475] = 0x6e26,
  [0x1476] = 0x6e27, [0x1477] = 0x6e28, [0x1478] = 0x6e2a, [0x1479] = 0x6e2c,
  [0x147a] = 0x6e2e, [0x147b] = 0x6e30, [0x147c] = 0x6e31, [0x147d] = 0x6e33,
  [0x147e] = 0x6e35, [0x1480] = 0x6e36, [0x1481] = 0x6e37, [0x1482] = 0x6e39,
  [0x1483] = 0x6e3b, [0x1484] = 0x6e3c, [0x1485] = 0x6e3d, [0x1486] = 0x6e3e,
  [0x1487] = 0x6e3f, [0x1488] = 0x6e40, [0x1489] = 0x6e41, [0x148a] = 0x6e42,
  [0x148b] = 0x6e45, [0x148c] = 0x6e46, [0x148d] = 0x6e47, [0x148e] = 0x6e48,
  [0x148f] = 0x6e49, [0x1490] = 0x6e4a, [0x1491] = 0x6e4b, [0x1492] = 0x6e4c,
  [0x1493] = 0x6e4f, [0x1494] = 0x6e50, [0x1495] = 0x6e51, [0x1496] = 0x6e52,
  [0x1497] = 0x6e55, [0x1498] = 0x6e57, [0x1499] = 0x6e59, [0x149a] = 0x6e5a,
  [0x149b] = 0x6e5c, [0x149c] = 0x6e5d, [0x149d] = 0x6e5e, [0x149e] = 0x6e60,
  [0x149f] = 0x6e61, [0x14a0] = 0x6e62, [0x14a1] = 0x6e63, [0x14a2] = 0x6e64,
  [0x14a3] = 0x6e65, [0x14a4] = 0x6e66, [0x14a5] = 0x6e67, [0x14a6] = 0x6e68,
  [0x14a7] = 0x6e69, [0x14a8] = 0x6e6a, [0x14a9] = 0x6e6c, [0x14aa] = 0x6e6d,
  [0x14ab] = 0x6e6f, [0x14ac] = 0x6e70, [0x14ad] = 0x6e71, [0x14ae] = 0x6e72,
  [0x14af] = 0x6e73, [0x14b0] = 0x6e74, [0x14b1] = 0x6e75, [0x14b2] = 0x6e76,
  [0x14b3] = 0x6e77, [0x14b4] = 0x6e78, [0x14b5] = 0x6e79, [0x14b6] = 0x6e7a,
  [0x14b7] = 0x6e7b, [0x14b8] = 0x6e7c, [0x14b9] = 0x6e7d, [0x14ba] = 0x6e80,
  [0x14bb] = 0x6e81, [0x14bc] = 0x6e82, [0x14bd] = 0x6e84, [0x14be] = 0x6e87,
  [0x14bf] = 0x6e88, [0x14c0] = 0x6e8a, [0x14c1] = 0x6e8b, [0x14c2] = 0x6e8c,
  [0x14c3] = 0x6e8d, [0x14c4] = 0x6e8e, [0x14c5] = 0x6e91, [0x14c6] = 0x6e92,
  [0x14c7] = 0x6e93, [0x14c8] = 0x6e94, [0x14c9] = 0x6e95, [0x14ca] = 0x6e96,
  [0x14cb] = 0x6e97, [0x14cc] = 0x6e99, [0x14cd] = 0x6e9a, [0x14ce] = 0x6e9b,
  [0x14cf] = 0x6e9d, [0x14d0] = 0x6e9e, [0x14d1] = 0x6ea0, [0x14d2] = 0x6ea1,
  [0x14d3] = 0x6ea3, [0x14d4] = 0x6ea4, [0x14d5] = 0x6ea6, [0x14d6] = 0x6ea8,
  [0x14d7] = 0x6ea9, [0x14d8] = 0x6eab, [0x14d9] = 0x6eac, [0x14da] = 0x6ead,
  [0x14db] = 0x6eae, [0x14dc] = 0x6eb0, [0x14dd] = 0x6eb3, [0x14de] = 0x6eb5,
  [0x14df] = 0x6eb8, [0x14e0] = 0x6eb9, [0x14e1] = 0x6ebc, [0x14e2] = 0x6ebe,
  [0x14e3] = 0x6ebf, [0x14e4] = 0x6ec0, [0x14e5] = 0x6ec3, [0x14e6] = 0x6ec4,
  [0x14e7] = 0x6ec5, [0x14e8] = 0x6ec6, [0x14e9] = 0x6ec8, [0x14ea] = 0x6ec9,
  [0x14eb] = 0x6eca, [0x14ec] = 0x6ecc, [0x14ed] = 0x6ecd, [0x14ee] = 0x6ece,
  [0x14ef] = 0x6ed0, [0x14f0] = 0x6ed2, [0x14f1] = 0x6ed6, [0x14f2] = 0x6ed8,
  [0x14f3] = 0x6ed9, [0x14f4] = 0x6edb, [0x14f5] = 0x6edc, [0x14f6] = 0x6edd,
  [0x14f7] = 0x6ee3, [0x14f8] = 0x6ee7, [0x14f9] = 0x6eea, [0x14fa] = 0x6eeb,
  [0x14fb] = 0x6eec, [0x14fc] = 0x6eed, [0x14fd] = 0x6eee, [0x14fe] = 0x6eef,
  [0x1500] = 0x6ef0, [0x1501] = 0x6ef1, [0x1502] = 0x6ef2, [0x1503] = 0x6ef3,
  [0x1504] = 0x6ef5, [0x1505] = 0x6ef6, [0x1506] = 0x6ef7, [0x1507] = 0x6ef8,
  [0x1508] = 0x6efa, [0x1509] = 0x6efb, [0x150a] = 0x6efc, [0x150b] = 0x6efd,
  [0x150c] = 0x6efe, [0x150d] = 0x6eff, [0x150e] = 0x6f00, [0x150f] = 0x6f01,
  [0x1510] = 0x6f03, [0x1511] = 0x6f04, [0x1512] = 0x6f05, [0x1513] = 0x6f07,
  [0x1514] = 0x6f08, [0x1515] = 0x6f0a, [0x1516] = 0x6f0b, [0x1517] = 0x6f0c,
  [0x1518] = 0x6f0d, [0x1519] = 0x6f0e, [0x151a] = 0x6f10, [0x151b] = 0x6f11,
  [0x151c] = 0x6f12, [0x151d] = 0x6f16, [0x151e] = 0x6f17, [0x151f] = 0x6f18,
  [0x1520] = 0x6f19, [0x1521] = 0x6f1a, [0x1522] = 0x6f1b, [0x1523] = 0x6f1c,
  [0x1524] = 0x6f1d, [0x1525] = 0x6f1e, [0x1526] = 0x6f1f, [0x1527] = 0x6f21,
  [0x1528] = 0x6f22, [0x1529] = 0x6f23, [0x152a] = 0x6f25, [0x152b] = 0x6f26,
  [0x152c] = 0x6f27, [0x152d] = 0x6f28, [0x152e] = 0x6f2c, [0x152f] = 0x6f2e,
  [0x1530] = 0x6f30, [0x1531] = 0x6f32, [0x1532] = 0x6f34, [0x1533] = 0x6f35,
  [0x1534] = 0x6f37, [0x1535] = 0x6f38, [0x1536] = 0x6f39, [0x1537] = 0x6f3a,
  [0x1538] = 0x6f3b, [0x1539] = 0x6f3c, [0x153a] = 0x6f3d, [0x153b] = 0x6f3f,
  [0x153c] = 0x6f40, [0x153d] = 0x6f41, [0x153e] = 0x6f42, [0x1540] = 0x6f43,
  [0x1541] = 0x6f44, [0x1542] = 0x6f45, [0x1543] = 0x6f48, [0x1544] = 0x6f49,
  [0x1545] = 0x6f4a, [0x1546] = 0x6f4c, [0x1547] = 0x6f4e, [0x1548] = 0x6f4f,
  [0x1549] = 0x6f50, [0x154a] = 0x6f51, [0x154b] = 0x6f52, [0x154c] = 0x6f53,
  [0x154d] = 0x6f54, [0x154e] = 0x6f55, [0x154f] = 0x6f56, [0x1550] = 0x6f57,
  [0x1551] = 0x6f59, [0x1552] = 0x6f5a, [0x1553] = 0x6f5b, [0x1554] = 0x6f5d,
  [0x1555] = 0x6f5f, [0x1556] = 0x6f60, [0x1557] = 0x6f61, [0x1558] = 0x6f63,
  [0x1559] = 0x6f64, [0x155a] = 0x6f65, [0x155b] = 0x6f67, [0x155c] = 0x6f68,
  [0x155d] = 0x6f69, [0x155e] = 0x6f6a, [0x155f] = 0x6f6b, [0x1560] = 0x6f6c,
  [0x1561] = 0x6f6f, [0x1562] = 0x6f70, [0x1563] = 0x6f71, [0x1564] = 0x6f73,
  [0x1565] = 0x6f75, [0x1566] = 0x6f76, [0x1567] = 0x6f77, [0x1568] = 0x6f79,
  [0x1569] = 0x6f7b, [0x156a] = 0x6f7d, [0x156b] = 0x6f7e, [0x156c] = 0x6f7f,
  [0x156d] = 0x6f80, [0x156e] = 0x6f81, [0x156f] = 0x6f82, [0x1570] = 0x6f83,
  [0x1571] = 0x6f85, [0x1572] = 0x6f86, [0x1573] = 0x6f87, [0x1574] = 0x6f8a,
  [0x1575] = 0x6f8b, [0x1576] = 0x6f8f, [0x1577] = 0x6f90, [0x1578] = 0x6f91,
  [0x1579] = 0x6f92, [0x157a] = 0x6f93, [0x157b] = 0x6f94, [0x157c] = 0x6f95,
  [0x157d] = 0x6f96, [0x157e] = 0x6f97, [0x157f] = 0x6f98, [0x1580] = 0x6f99,
  [0x1581] = 0x6f9a, [0x1582] = 0x6f9b, [0x1583] = 0x6f9d, [0x1584] = 0x6f9e,
  [0x1585] = 0x6f9f, [0x1586] = 0x6fa0, [0x1587] = 0x6fa2, [0x1588] = 0x6fa3,
  [0x1589] = 0x6fa4, [0x158a] = 0x6fa5, [0x158b] = 0x6fa6, [0x158c] = 0x6fa8,
  [0x158d] = 0x6fa9, [0x158e] = 0x6faa, [0x158f] = 0x6fab, [0x1590] = 0x6fac,
  [0x1591] = 0x6fad, [0x1592] = 0x6fae, [0x1593] = 0x6faf, [0x1594] = 0x6fb0,
  [0x1595] = 0x6fb1, [0x1596] = 0x6fb2, [0x1597] = 0x6fb4, [0x1598] = 0x6fb5,
  [0x1599] = 0x6fb7, [0x159a] = 0x6fb8, [0x159b] = 0x6fba, [0x159c] = 0x6fbb,
  [0x159d] = 0x6fbc, [0x159e] = 0x6fbd, [0x159f] = 0x6fbe, [0x15a0] = 0x6fbf,
  [0x15a1] = 0x6fc1, [0x15a2] = 0x6fc3, [0x15a3] = 0x6fc4, [0x15a4] = 0x6fc5,
  [0x15a5] = 0x6fc6, [0x15a6] = 0x6fc7, [0x15a7] = 0x6fc8, [0x15a8] = 0x6fca,
  [0x15a9] = 0x6fcb, [0x15aa] = 0x6fcc, [0x15ab] = 0x6fcd, [0x15ac] = 0x6fce,
  [0x15ad] = 0x6fcf, [0x15ae] = 0x6fd0, [0x15af] = 0x6fd3, [0x15b0] = 0x6fd4,
  [0x15b1] = 0x6fd5, [0x15b2] = 0x6fd6, [0x15b3] = 0x6fd7, [0x15b4] = 0x6fd8,
  [0x15b5] = 0x6fd9, [0x15b6] = 0x6fda, [0x15b7] = 0x6fdb, [0x15b8] = 0x6fdc,
  [0x15b9] = 0x6fdd, [0x15ba] = 0x6fdf, [0x15bb] = 0x6fe2, [0x15bc] = 0x6fe3,
  [0x15bd] = 0x6fe4, [0x15be] = 0x6fe5, [0x15c0] = 0x6fe6, [0x15c1] = 0x6fe7,
  [0x15c2] = 0x6fe8, [0x15c3] = 0x6fe9, [0x15c4] = 0x6fea, [0x15c5] = 0x6feb,
  [0x15c6] = 0x6fec, [0x15c7] = 0x6fed, [0x15c8] = 0x6ff0, [0x15c9] = 0x6ff1,
  [0x15ca] = 0x6ff2, [0x15cb] = 0x6ff3, [0x15cc] = 0x6ff4, [0x15cd] = 0x6ff5,
  [0x15ce] = 0x6ff6, [0x15cf] = 0x6ff7, [0x15d0] = 0x6ff8, [0x15d1] = 0x6ff9,
  [0x15d2] = 0x6ffa, [0x15d3] = 0x6ffb, [0x15d4] = 0x6ffc, [0x15d5] = 0x6ffd,
  [0x15d6] = 0x6ffe, [0x15d7] = 0x6fff, [0x15d8] = 0x7000, [0x15d9] = 0x7001,
  [0x15da] = 0x7002, [0x15db] = 0x7003, [0x15dc] = 0x7004, [0x15dd] = 0x7005,
  [0x15de] = 0x7006, [0x15df] = 0x7007, [0x15e0] = 0x7008, [0x15e1] = 0x7009,
  [0x15e2] = 0x700a, [0x15e3] = 0x700b, [0x15e4] = 0x700c, [0x15e5] = 0x700d,
  [0x15e6] = 0x700e, [0x15e7] = 0x700f, [0x15e8] = 0x7010, [0x15e9] = 0x7012,
  [0x15ea] = 0x7013, [0x15eb] = 0x7014, [0x15ec] = 0x7015, [0x15ed] = 0x7016,
  [0x15ee] = 0x7017, [0x15ef] = 0x7018, [0x15f0] = 0x7019, [0x15f1] = 0x701c,
  [0x15f2] = 0x701d, [0x15f3] = 0x701e, [0x15f4] = 0x701f, [0x15f5] = 0x7020,
  [0x15f6] = 0x7021, [0x15f7] = 0x7022, [0x15f8] = 0x7024, [0x15f9] = 0x7025,
  [0x15fa] = 0x7026, [0x15fb] = 0x7027, [0x15fc] = 0x7028, [0x15fd] = 0x7029,
  [0x15fe] = 0x702a, [0x1600] = 0x702b, [0x1601] = 0x702c, [0x1602] = 0x702d,
  [0x1603] = 0x702e, [0x1604] = 0x702f, [0x1605] = 0x7030, [0x1606] = 0x7031,
  [0x1607] = 0x7032, [0x1608] = 0x7033, [0x1609] = 0x7034, [0x160a] = 0x7036,
  [0x160b] = 0x7037, [0x160c] = 0x7038, [0x160d] = 0x703a, [0x160e] = 0x703b,
  [0x160f] = 0x703c, [0x1610] = 0x703d, [0x1611] = 0x703e, [0x1612] = 0x703f,
  [0x1613] = 0x7040, [0x1614] = 0x7041, [0x1615] = 0x7042, [0x1616] = 0x7043,
  [0x1617] = 0x7044, [0x1618] = 0x7045, [0x1619] = 0x7046, [0x161a] = 0x7047,
  [0x161b] = 0x7048, [0x161c] = 0x7049, [0x161d] = 0x704a, [0x161e] = 0x704b,
  [0x161f] = 0x704d, [0x1620] = 0x704e, [0x1621] = 0x7050, [0x1622] = 0x7051,
  [0x1623] = 0x7052, [0x1624] = 0x7053, [0x1625] = 0x7054, [0x1626] = 0x7055,
  [0x1627] = 0x7056, [0x1628] = 0x7057, [0x1629] = 0x7058, [0x162a] = 0x7059,
  [0x162b] = 0x705a, [0x162c] = 0x705b, [0x162d] = 0x705c, [0x162e] = 0x705d,
  [0x162f] = 0x705f, [0x1630] = 0x7060, [0x1631] = 0x7061, [0x1632] = 0x7062,
  [0x1633] = 0x7063, [0x1634] = 0x7064, [0x1635] = 0x7065, [0x1636] = 0x7066,
  [0x1637] = 0x7067, [0x1638] = 0x7068, [0x1639] = 0x7069, [0x163a] = 0x706a,
  [0x163b] = 0x706e, [0x163c] = 0x7071, [0x163d] = 0x7072, [0x163e] = 0x7073,
  [0x163f] = 0x7074, [0x1640] = 0x7077, [0x1641] = 0x7079, [0x1642] = 0x707a,
  [0x1643] = 0x707b, [0x1644] = 0x707d, [0x1645] = 0x7081, [0x1646] = 0x7082,
  [0x1647] = 0x7083, [0x1648] = 0x7084, [0x1649] = 0x7086, [0x164a] = 0x7087,
  [0x164b] = 0x7088, [0x164c] = 0x708b, [0x164d] = 0x708c, [0x164e] = 0x708d,
  [0x164f] = 0x708f, [0x1650] = 0x7090, [0x1651] = 0x7091, [0x1652] = 0x7093,
  [0x1653] = 0x7097, [0x1654] = 0x7098, [0x1655] = 0x709a, [0x1656] = 0x709b,
  [0x1657] = 0x709e, [0x1658] = 0x709f, [0x1659] = 0x70a0, [0x165a] = 0x70a1,
  [0x165b] = 0x70a2, [0x165c] = 0x70a3, [0x165d] = 0x70a4, [0x165e] = 0x70a5,
  [0x165f] = 0x70a6, [0x1660] = 0x70a7, [0x1661] = 0x70a8, [0x1662] = 0x70a9,
  [0x1663] = 0x70aa, [0x1664] = 0x70b0, [0x1665] = 0x70b2, [0x1666] = 0x70b4,
  [0x1667] = 0x70b5, [0x1668] = 0x70b6, [0x1669] = 0x70ba, [0x166a] = 0x70be,
  [0x166b] = 0x70bf, [0x166c] = 0x70c4, [0x166d] = 0x70c5, [0x166e] = 0x70c6,
  [0x166f] = 0x70c7, [0x1670] = 0x70c9, [0x1671] = 0x70cb, [0x1672] = 0x70cc,
  [0x1673] = 0x70cd, [0x1674] = 0x70ce, [0x1675] = 0x70cf, [0x1676] = 0x70d0,
  [0x1677] = 0x70d1, [0x1678] = 0x70d2, [0x1679] = 0x70d3, [0x167a] = 0x70d4,
  [0x167b] = 0x70d5, [0x167c] = 0x70d6, [0x167d] = 0x70d7, [0x167e] = 0x70da,
  [0x1680] = 0x70dc, [0x1681] = 0x70dd, [0x1682] = 0x70de, [0x1683] = 0x70e0,
  [0x1684] = 0x70e1, [0x1685] = 0x70e2, [0x1686] = 0x70e3, [0x1687] = 0x70e5,
  [0x1688] = 0x70ea, [0x1689] = 0x70ee, [0x168a] = 0x70f0, [0x168b] = 0x70f1,
  [0x168c] = 0x70f2, [0x168d] = 0x70f3, [0x168e] = 0x70f4, [0x168f] = 0x70f5,
  [0x1690] = 0x70f6, [0x1691] = 0x70f8, [0x1692] = 0x70fa, [0x1693] = 0x70fb,
  [0x1694] = 0x70fc, [0x1695] = 0x70fe, [0x1696] = 0x70ff, [0x1697] = 0x7100,
  [0x1698] = 0x7101, [0x1699] = 0x7102, [0x169a] = 0x7103, [0x169b] = 0x7104,
  [0x169c] = 0x7105, [0x169d] = 0x7106, [0x169e] = 0x7107, [0x169f] = 0x7108,
  [0x16a0] = 0x710b, [0x16a1] = 0x710c, [0x16a2] = 0x710d, [0x16a3] = 0x710e,
  [0x16a4] = 0x710f, [0x16a5] = 0x7111, [0x16a6] = 0x7112, [0x16a7] = 0x7114,
  [0x16a8] = 0x7117, [0x16a9] = 0x711b, [0x16aa] = 0x711c, [0x16ab] = 0x711d,
  [0x16ac] = 0x711e, [0x16ad] = 0x711f, [0x16ae] = 0x7120, [0x16af] = 0x7121,
  [0x16b0] = 0x7122, [0x16b1] = 0x7123, [0x16b2] = 0x7124, [0x16b3] = 0x7125,
  [0x16b4] = 0x7127, [0x16b5] = 0x7128, [0x16b6] = 0x7129, [0x16b7] = 0x712a,
  [0x16b8] = 0x712b, [0x16b9] = 0x712c, [0x16ba] = 0x712d, [0x16bb] = 0x712e,
  [0x16bc] = 0x7132, [0x16bd] = 0x7133, [0x16be] = 0x7134, [0x16c0] = 0x7135,
  [0x16c1] = 0x7137, [0x16c2] = 0x7138, [0x16c3] = 0x7139, [0x16c4] = 0x713a,
  [0x16c5] = 0x713b, [0x16c6] = 0x713c, [0x16c7] = 0x713d, [0x16c8] = 0x713e,
  [0x16c9] = 0x713f, [0x16ca] = 0x7140, [0x16cb] = 0x7141, [0x16cc] = 0x7142,
  [0x16cd] = 0x7143, [0x16ce] = 0x7144, [0x16cf] = 0x7146, [0x16d0] = 0x7147,
  [0x16d1] = 0x7148, [0x16d2] = 0x7149, [0x16d3] = 0x714b, [0x16d4] = 0x714d,
  [0x16d5] = 0x714f, [0x16d6] = 0x7150, [0x16d7] = 0x7151, [0x16d8] = 0x7152,
  [0x16d9] = 0x7153, [0x16da] = 0x7154, [0x16db] = 0x7155, [0x16dc] = 0x7156,
  [0x16dd] = 0x7157, [0x16de] = 0x7158, [0x16df] = 0x7159, [0x16e0] = 0x715a,
  [0x16e1] = 0x715b, [0x16e2] = 0x715d, [0x16e3] = 0x715f, [0x16e4] = 0x7160,
  [0x16e5] = 0x7161, [0x16e6] = 0x7162, [0x16e7] = 0x7163, [0x16e8] = 0x7165,
  [0x16e9] = 0x7169, [0x16ea] = 0x716a, [0x16eb] = 0x716b, [0x16ec] = 0x716c,
  [0x16ed] = 0x716d, [0x16ee] = 0x716f, [0x16ef] = 0x7170, [0x16f0] = 0x7171,
  [0x16f1] = 0x7174, [0x16f2] = 0x7175, [0x16f3] = 0x7176, [0x16f4] = 0x7177,
  [0x16f5] = 0x7179, [0x16f6] = 0x717b, [0x16f7] = 0x717c, [0x16f8] = 0x717e,
  [0x16f9] = 0x717f, [0x16fa] = 0x7180, [0x16fb] = 0x7181, [0x16fc] = 0x7182,
  [0x16fd] = 0x7183, [0x16fe] = 0x7185, [0x16ff] = 0x7186, [0x1700] = 0x7187,
  [0x1701] = 0x7188, [0x1702] = 0x7189, [0x1703] = 0x718b, [0x1704] = 0x718c,
  [0x1705] = 0x718d, [0x1706] = 0x718e, [0x1707] = 0x7190, [0x1708] = 0x7191,
  [0x1709] = 0x7192, [0x170a] = 0x7193, [0x170b] = 0x7195, [0x170c] = 0x7196,
  [0x170d] = 0x7197, [0x170e] = 0x719a, [0x170f] = 0x719b, [0x1710] = 0x719c,
  [0x1711] = 0x719d, [0x1712] = 0x719e, [0x1713] = 0x71a1, [0x1714] = 0x71a2,
  [0x1715] = 0x71a3, [0x1716] = 0x71a4, [0x1717] = 0x71a5, [0x1718] = 0x71a6,
  [0x1719] = 0x71a7, [0x171a] = 0x71a9, [0x171b] = 0x71aa, [0x171c] = 0x71ab,
  [0x171d] = 0x71ad, [0x171e] = 0x71ae, [0x171f] = 0x71af, [0x1720] = 0x71b0,
  [0x1721] = 0x71b1, [0x1722] = 0x71b2, [0x1723] = 0x71b4, [0x1724] = 0x71b6,
  [0x1725] = 0x71b7, [0x1726] = 0x71b8, [0x1727] = 0x71ba, [0x1728] = 0x71bb,
  [0x1729] = 0x71bc, [0x172a] = 0x71bd, [0x172b] = 0x71be, [0x172c] = 0x71bf,
  [0x172d] = 0x71c0, [0x172e] = 0x71c1, [0x172f] = 0x71c2, [0x1730] = 0x71c4,
  [0x1731] = 0x71c5, [0x1732] = 0x71c6, [0x1733] = 0x71c7, [0x1734] = 0x71c8,
  [0x1735] = 0x71c9, [0x1736] = 0x71ca, [0x1737] = 0x71cb, [0x1738] = 0x71cc,
  [0x1739] = 0x71cd, [0x173a] = 0x71cf, [0x173b] = 0x71d0, [0x173c] = 0x71d1,
  [0x173d] = 0x71d2, [0x173e] = 0x71d3, [0x1740] = 0x71d6, [0x1741] = 0x71d7,
  [0x1742] = 0x71d8, [0x1743] = 0x71d9, [0x1744] = 0x71da, [0x1745] = 0x71db,
  [0x1746] = 0x71dc, [0x1747] = 0x71dd, [0x1748] = 0x71de, [0x1749] = 0x71df,
  [0x174a] = 0x71e1, [0x174b] = 0x71e2, [0x174c] = 0x71e3, [0x174d] = 0x71e4,
  [0x174e] = 0x71e6, [0x174f] = 0x71e8, [0x1750] = 0x71e9, [0x1751] = 0x71ea,
  [0x1752] = 0x71eb, [0x1753] = 0x71ec, [0x1754] = 0x71ed, [0x1755] = 0x71ef,
  [0x1756] = 0x71f0, [0x1757] = 0x71f1, [0x1758] = 0x71f2, [0x1759] = 0x71f3,
  [0x175a] = 0x71f4, [0x175b] = 0x71f5, [0x175c] = 0x71f6, [0x175d] = 0x71f7,
  [0x175e] = 0x71f8, [0x175f] = 0x71fa, [0x1760] = 0x71fb, [0x1761] = 0x71fc,
  [0x1762] = 0x71fd, [0x1763] = 0x71fe, [0x1764] = 0x71ff, [0x1765] = 0x7200,
  [0x1766] = 0x7201, [0x1767] = 0x7202, [0x1768] = 0x7203, [0x1769] = 0x7204,
  [0x176a] = 0x7205, [0x176b] = 0x7207, [0x176c] = 0x7208, [0x176d] = 0x7209,
  [0x176e] = 0x720a, [0x176f] = 0x720b, [0x1770] = 0x720c, [0x1771] = 0x720d,
  [0x1772] = 0x720e, [0x1773] = 0x720f, [0x1774] = 0x7210, [0x1775] = 0x7211,
  [0x1776] = 0x7212, [0x1777] = 0x7213, [0x1778] = 0x7214, [0x1779] = 0x7215,
  [0x177a] = 0x7216, [0x177b] = 0x7217, [0x177c] = 0x7218, [0x177d] = 0x7219,
  [0x177e] = 0x721a, [0x1780] = 0x721b, [0x1781] = 0x721c, [0x1782] = 0x721e,
  [0x1783] = 0x721f, [0x1784] = 0x7220, [0x1785] = 0x7221, [0x1786] = 0x7222,
  [0x1787] = 0x7223, [0x1788] = 0x7224, [0x1789] = 0x7225, [0x178a] = 0x7226,
  [0x178b] = 0x7227, [0x178c] = 0x7229, [0x178d] = 0x722b, [0x178e] = 0x722d,
  [0x178f] = 0x722e, [0x1790] = 0x722f, [0x1791] = 0x7232, [0x1792] = 0x7233,
  [0x1793] = 0x7234, [0x1794] = 0x723a, [0x1795] = 0x723c, [0x1796] = 0x723e,
  [0x1797] = 0x7240, [0x1798] = 0x7241, [0x1799] = 0x7242, [0x179a] = 0x7243,
  [0x179b] = 0x7244, [0x179c] = 0x7245, [0x179d] = 0x7246, [0x179e] = 0x7249,
  [0x179f] = 0x724a, [0x17a0] = 0x724b, [0x17a1] = 0x724e, [0x17a2] = 0x724f,
  [0x17a3] = 0x7250, [0x17a4] = 0x7251, [0x17a5] = 0x7253, [0x17a6] = 0x7254,
  [0x17a7] = 0x7255, [0x17a8] = 0x7257, [0x17a9] = 0x7258, [0x17aa] = 0x725a,
  [0x17ab] = 0x725c, [0x17ac] = 0x725e, [0x17ad] = 0x7260, [0x17ae] = 0x7263,
  [0x17af] = 0x7264, [0x17b0] = 0x7265, [0x17b1] = 0x7268, [0x17b2] = 0x726a,
  [0x17b3] = 0x726b, [0x17b4] = 0x726c, [0x17b5] = 0x726d, [0x17b6] = 0x7270,
  [0x17b7] = 0x7271, [0x17b8] = 0x7273, [0x17b9] = 0x7274, [0x17ba] = 0x7276,
  [0x17bb] = 0x7277, [0x17bc] = 0x7278, [0x17bd] = 0x727b, [0x17be] = 0x727c,
  [0x17bf] = 0x727d, [0x17c0] = 0x7282, [0x17c1] = 0x7283, [0x17c2] = 0x7285,
  [0x17c3] = 0x7286, [0x17c4] = 0x7287, [0x17c5] = 0x7288, [0x17c6] = 0x7289,
  [0x17c7] = 0x728c, [0x17c8] = 0x728e, [0x17c9] = 0x7290, [0x17ca] = 0x7291,
  [0x17cb] = 0x7293, [0x17cc] = 0x7294, [0x17cd] = 0x7295, [0x17ce] = 0x7296,
  [0x17cf] = 0x7297, [0x17d0] = 0x7298, [0x17d1] = 0x7299, [0x17d2] = 0x729a,
  [0x17d3] = 0x729b, [0x17d4] = 0x729c, [0x17d5] = 0x729d, [0x17d6] = 0x729e,
  [0x17d7] = 0x72a0, [0x17d8] = 0x72a1, [0x17d9] = 0x72a2, [0x17da] = 0x72a3,
  [0x17db] = 0x72a4, [0x17dc] = 0x72a5, [0x17dd] = 0x72a6, [0x17de] = 0x72a7,
  [0x17df] = 0x72a8, [0x17e0] = 0x72a9, [0x17e1] = 0x72aa, [0x17e2] = 0x72ab,
  [0x17e3] = 0x72ae, [0x17e4] = 0x72b1, [0x17e5] = 0x72b2, [0x17e6] = 0x72b3,
  [0x17e7] = 0x72b5, [0x17e8] = 0x72ba, [0x17e9] = 0x72bb, [0x17ea] = 0x72bc,
  [0x17eb] = 0x72bd, [0x17ec] = 0x72be, [0x17ed] = 0x72bf, [0x17ee] = 0x72c0,
  [0x17ef] = 0x72c5, [0x17f0] = 0x72c6, [0x17f1] = 0x72c7, [0x17f2] = 0x72c9,
  [0x17f3] = 0x72ca, [0x17f4] = 0x72cb, [0x17f5] = 0x72cc, [0x17f6] = 0x72cf,
  [0x17f7] = 0x72d1, [0x17f8] = 0x72d3, [0x17f9] = 0x72d4, [0x17fa] = 0x72d5,
  [0x17fb] = 0x72d6, [0x17fc] = 0x72d8, [0x17fd] = 0x72da, [0x17fe] = 0x72db,
  [0x1861] = 0x3000, [0x1862] = 0x3001, [0x1863] = 0x3002, [0x1864] = 0x00b7,
  [0x1865] = 0x02c9, [0x1866] = 0x02c7, [0x1867] = 0x00a8, [0x1868] = 0x3003,
  [0x1869] = 0x3005, [0x186a] = 0x2014, [0x186b] = 0xff5e, [0x186c] = 0x2016,
  [0x186d] = 0x2026, [0x186e] = 0x2018, [0x186f] = 0x2019, [0x1870] = 0x201c,
  [0x1871] = 0x201d, [0x1872] = 0x3014, [0x1873] = 0x3015, [0x1874] = 0x3008,
  [0x1875] = 0x3009, [0x1876] = 0x300a, [0x1877] = 0x300b, [0x1878] = 0x300c,
  [0x1879] = 0x300d, [0x187a] = 0x300e, [0x187b] = 0x300f, [0x187c] = 0x3016,
  [0x187d] = 0x3017, [0x187e] = 0x3010, [0x187f] = 0x3011, [0x1880] = 0x00b1,
  [0x1881] = 0x00d7, [0x1882] = 0x00f7, [0x1883] = 0x2236, [0x1884] = 0x2227,
  [0x1885] = 0x2228, [0x1886] = 0x2211, [0x1887] = 0x220f, [0x1888] = 0x222a,
  [0x1889] = 0x2229, [0x188a] = 0x2208, [0x188b] = 0x2237, [0x188c] = 0x221a,
  [0x188d] = 0x22a5, [0x188e] = 0x2225, [0x188f] = 0x2220, [0x1890] = 0x2312,
  [0x1891] = 0x2299, [0x1892] = 0x222b, [0x1893] = 0x222e, [0x1894] = 0x2261,
  [0x1895] = 0x224c, [0x1896] = 0x2248, [0x1897] = 0x223d, [0x1898] = 0x221d,
  [0x1899] = 0x2260, [0x189a] = 0x226e, [0x189b] = 0x226f, [0x189c] = 0x2264,
  [0x189d] = 0x2265, [0x189e] = 0x221e, [0x189f] = 0x2235, [0x18a0] = 0x2234,
  [0x18a1] = 0x2642, [0x18a2] = 0x2640, [0x18a3] = 0x00b0, [0x18a4] = 0x2032,
  [0x18a5] = 0x2033, [0x18a6] = 0x2103, [0x18a7] = 0xff04, [0x18a8] = 0x00a4,
  [0x18a9] = 0xffe0, [0x18aa] = 0xffe1, [0x18ab] = 0x2030, [0x18ac] = 0x00a7,
  [0x18ad] = 0x2116, [0x18ae] = 0x2606, [0x18af] = 0x2605, [0x18b0] = 0x25cb,
  [0x18b1] = 0x25cf, [0x18b2] = 0x25ce, [0x18b3] = 0x25c7, [0x18b4] = 0x25c6,
  [0x18b5] = 0x25a1, [0x18b6] = 0x25a0, [0x18b7] = 0x25b3, [0x18b8] = 0x25b2,
  [0x18b9] = 0x203b, [0x18ba] = 0x2192, [0x18bb] = 0x2190, [0x18bc] = 0x2191,
  [0x18bd] = 0x2193, [0x18be] = 0x3013, [0x1921] = 0x2170, [0x1922] = 0x2171,
  [0x1923] = 0x2172, [0x1924] = 0x2173, [0x1925] = 0x2174, [0x1926] = 0x2175,
  [0x1927] = 0x2176, [0x1928] = 0x2177, [0x1929] = 0x2178, [0x192a] = 0x2179,
  [0x1931] = 0x2488, [0x1932] = 0x2489, [0x1933] = 0x248a, [0x1934] = 0x248b,
  [0x1935] = 0x248c, [0x1936] = 0x248d, [0x1937] = 0x248e, [0x1938] = 0x248f,
  [0x1939] = 0x2490, [0x193a] = 0x2491, [0x193b] = 0x2492, [0x193c] = 0x2493,
  [0x193d] = 0x2494, [0x193e] = 0x2495, [0x193f] = 0x2496, [0x1940] = 0x2497,
  [0x1941] = 0x2498, [0x1942] = 0x2499, [0x1943] = 0x249a, [0x1944] = 0x249b,
  [0x1945] = 0x2474, [0x1946] = 0x2475, [0x1947] = 0x2476, [0x1948] = 0x2477,
  [0x1949] = 0x2478, [0x194a] = 0x2479, [0x194b] = 0x247a, [0x194c] = 0x247b,
  [0x194d] = 0x247c, [0x194e] = 0x247d, [0x194f] = 0x247e, [0x1950] = 0x247f,
  [0x1951] = 0x2480, [0x1952] = 0x2481, [0x1953] = 0x2482, [0x1954] = 0x2483,
  [0x1955] = 0x2484, [0x1956] = 0x2485, [0x1957] = 0x2486, [0x1958] = 0x2487,
  [0x1959] = 0x2460, [0x195a] = 0x2461, [0x195b] = 0x2462, [0x195c] = 0x2463,
  [0x195d] = 0x2464, [0x195e] = 0x2465, [0x195f] = 0x2466, [0x1960] = 0x2467,
  [0x1961] = 0x2468, [0x1962] = 0x2469, [0x1963] = 0x20ac, [0x1965] = 0x3220,
  [0x1966] = 0x3221, [0x1967] = 0x3222, [0x1968] = 0x3223, [0x1969] = 0x3224,
  [0x196a] = 0x3225, [0x196b] = 0x3226, [0x196c] = 0x3227, [0x196d] = 0x3228,
  [0x196e] = 0x3229, [0x1971] = 0x2160, [0x1972] = 0x2161, [0x1973] = 0x2162,
  [0x1974] = 0x2163, [0x1975] = 0x2164, [0x1976] = 0x2165, [0x1977] = 0x2166,
  [0x1978] = 0x2167, [0x1979] = 0x2168, [0x197a] = 0x2169, [0x197b] = 0x216a,
  [0x197c] = 0x216b, [0x19e1] = 0xff01, [0x19e2] = 0xff02, [0x19e3] = 0xff03,
  [0x19e4] = 0xffe5, [0x19e5] = 0xff05, [0x19e6] = 0xff06, [0x19e7] = 0xff07,
  [0x19e8] = 0xff08, [0x19e9] = 0xff09, [0x19ea] = 0xff0a, [0x19eb] = 0xff0b,
  [0x19ec] = 0xff0c, [0x19ed] = 0xff0d, [0x19ee] = 0xff0e, [0x19ef] = 0xff0f,
  [0x19f0] = 0xff10, [0x19f1] = 0xff11, [0x19f2] = 0xff12, [0x19f3] = 0xff13,
  [0x19f4] = 0xff14, [0x19f5] = 0xff15, [0x19f6] = 0xff16, [0x19f7] = 0xff17,
  [0x19f8] = 0xff18, [0x19f9] = 0xff19, [0x19fa] = 0xff1a, [0x19fb] = 0xff1b,
  [0x19fc] = 0xff1c, [0x19fd] = 0xff1d, [0x19fe] = 0xff1e, [0x19ff] = 0xff1f,
  [0x1a00] = 0xff20, [0x1a01] = 0xff21, [0x1a02] = 0xff22, [0x1a03] = 0xff23,
  [0x1a04] = 0xff24, [0x1a05] = 0xff25, [0x1a06] = 0xff26, [0x1a07] = 0xff27,
  [0x1a08] = 0xff28, [0x1a09] = 0xff29, [0x1a0a] = 0xff2a, [0x1a0b] = 0xff2b,
  [0x1a0c] = 0xff2c, [0x1a0d] = 0xff2d, [0x1a0e] = 0xff2e, [0x1a0f] = 0xff2f,
  [0x1a10] = 0xff30, [0x1a11] = 0xff31, [0x1a12] = 0xff32, [0x1a13] = 0xff33,
  [0x1a14] = 0xff34, [0x1a15] = 0xff35, [0x1a16] = 0xff36, [0x1a17] = 0xff37,
  [0x1a18] = 0xff38, [0x1a19] = 0xff39, [0x1a1a] = 0xff3a, [0x1a1b] = 0xff3b,
  [0x1a1c] = 0xff3c, [0x1a1d] = 0xff3d, [0x1a1e] = 0xff3e, [0x1a1f] = 0xff3f,
  [0x1a20] = 0xff40, [0x1a21] = 0xff41, [0x1a22] = 0xff42, [0x1a23] = 0xff43,
  [0x1a24] = 0xff44, [0x1a25] = 0xff45, [0x1a26] = 0xff46, [0x1a27] = 0xff47,
  [0x1a28] = 0xff48, [0x1a29] = 0xff49, [0x1a2a] = 0xff4a, [0x1a2b] = 0xff4b,
  [0x1a2c] = 0xff4c, [0x1a2d] = 0xff4d, [0x1a2e] = 0xff4e, [0x1a2f] = 0xff4f,
  [0x1a30] = 0xff50, [0x1a31] = 0xff51, [0x1a32] = 0xff52, [0x1a33] = 0xff53,
  [0x1a34] = 0xff54, [0x1a35] = 0xff55, [0x1a36] = 0xff56, [0x1a37] = 0xff57,
  [0x1a38] = 0xff58, [0x1a39] = 0xff59, [0x1a3a] = 0xff5a, [0x1a3b] = 0xff5b,
  [0x1a3c] = 0xff5c, [0x1a3d] = 0xff5d, [0x1a3e] = 0xffe3, [0x1aa1] = 0x3041,
  [0x1aa2] = 0x3042, [0x1aa3] = 0x3043, [0x1aa4] = 0x3044, [0x1aa5] = 0x3045,
  [0x1aa6] = 0x3046, [0x1aa7] = 0x3047, [0x1aa8] = 0x3048, [0x1aa9] = 0x3049,
  [0x1aaa] = 0x304a, [0x1aab] = 0x304b, [0x1aac] = 0x304c, [0x1aad] = 0x304d,
  [0x1aae] = 0x304e, [0x1aaf] = 0x304f, [0x1ab0] = 0x3050, [0x1ab1] = 0x3051,
  [0x1ab2] = 0x3052, [0x1ab3] = 0x3053, [0x1ab4] = 0x3054, [0x1ab5] = 0x3055,
  [0x1ab6] = 0x3056, [0x1ab7] = 0x3057, [0x1ab8] = 0x3058, [0x1ab9] = 0x3059,
  [0x1aba] = 0x305a, [0x1abb] = 0x305b, [0x1abc] = 0x305c, [0x1abd] = 0x305d,
  [0x1abe] = 0x305e, [0x1abf] = 0x305f, [0x1ac0] = 0x3060, [0x1ac1] = 0x3061,
  [0x1ac2] = 0x3062, [0x1ac3] = 0x3063, [0x1ac4] = 0x3064, [0x1ac5] = 0x3065,
  [0x1ac6] = 0x3066, [0x1ac7] = 0x3067, [0x1ac8] = 0x3068, [0x1ac9] = 0x3069,
  [0x1aca] = 0x306a, [0x1acb] = 0x306b, [0x1acc] = 0x306c, [0x1acd] = 0x306d,
  [0x1ace] = 0x306e, [0x1acf] = 0x306f, [0x1ad0] = 0x3070, [0x1ad1] = 0x3071,
  [0x1ad2] = 0x3072, [0x1ad3] = 0x3073, [0x1ad4] = 0x3074, [0x1ad5] = 0x3075,
  [0x1ad6] = 0x3076, [0x1ad7] = 0x3077, [0x1ad8] = 0x3078, [0x1ad9] = 0x3079,
  [0x1ada] = 0x307a, [0x1adb] = 0x307b, [0x1adc] = 0x307c, [0x1add] = 0x307d,
  [0x1ade] = 0x307e, [0x1adf] = 0x307f, [0x1ae0] = 0x3080, [0x1ae1] = 0x3081,
  [0x1ae2] = 0x3082, [0x1ae3] = 0x3083, [0x1ae4] = 0x3084, [0x1ae5] = 0x3085,
  [0x1ae6] = 0x3086, [0x1ae7] = 0x3087, [0x1ae8] = 0x3088, [0x1ae9] = 0x3089,
  [0x1aea] = 0x308a, [0x1aeb] = 0x308b, [0x1aec] = 0x308c, [0x1aed] = 0x308d,
  [0x1aee] = 0x308e, [0x1aef] = 0x308f, [0x1af0] = 0x3090, [0x1af1] = 0x3091,
  [0x1af2] = 0x3092, [0x1af3] = 0x3093, [0x1b61] = 0x30a1, [0x1b62] = 0x30a2,
  [0x1b63] = 0x30a3, [0x1b64] = 0x30a4, [0x1b65] = 0x30a5, [0x1b66] = 0x30a6,
  [0x1b67] = 0x30a7, [0x1b68] = 0x30a8, [0x1b69] = 0x30a9, [0x1b6a] = 0x30aa,
  [0x1b6b] = 0x30ab, [0x1b6c] = 0x30ac, [0x1b6d] = 0x30ad, [0x1b6e] = 0x30ae,
  [0x1b6f] = 0x30af, [0x1b70] = 0x30b0, [0x1b71] = 0x30b1, [0x1b72] = 0x30b2,
  [0x1b73] = 0x30b3, [0x1b74] = 0x30b4, [0x1b75] = 0x30b5, [0x1b76] = 0x30b6,
  [0x1b77] = 0x30b7, [0x1b78] = 0x30b8, [0x1b79] = 0x30b9, [0x1b7a] = 0x30ba,
  [0x1b7b] = 0x30bb, [0x1b7c] = 0x30bc, [0x1b7d] = 0x30bd, [0x1b7e] = 0x30be,
  [0x1b7f] = 0x30bf, [0x1b80] = 0x30c0, [0x1b81] = 0x30c1, [0x1b82] = 0x30c2,
  [0x1b83] = 0x30c3, [0x1b84] = 0x30c4, [0x1b85] = 0x30c5, [0x1b86] = 0x30c6,
  [0x1b87] = 0x30c7, [0x1b88] = 0x30c8, [0x1b89] = 0x30c9, [0x1b8a] = 0x30ca,
  [0x1b8b] = 0x30cb, [0x1b8c] = 0x30cc, [0x1b8d] = 0x30cd, [0x1b8e] = 0x30ce,
  [0x1b8f] = 0x30cf, [0x1b90] = 0x30d0, [0x1b91] = 0x30d1, [0x1b92] = 0x30d2,
  [0x1b93] = 0x30d3, [0x1b94] = 0x30d4, [0x1b95] = 0x30d5, [0x1b96] = 0x30d6,
  [0x1b97] = 0x30d7, [0x1b98] = 0x30d8, [0x1b99] = 0x30d9, [0x1b9a] = 0x30da,
  [0x1b9b] = 0x30db, [0x1b9c] = 0x30dc, [0x1b9d] = 0x30dd, [0x1b9e] = 0x30de,
  [0x1b9f] = 0x30df, [0x1ba0] = 0x30e0, [0x1ba1] = 0x30e1, [0x1ba2] = 0x30e2,
  [0x1ba3] = 0x30e3, [0x1ba4] = 0x30e4, [0x1ba5] = 0x30e5, [0x1ba6] = 0x30e6,
  [0x1ba7] = 0x30e7, [0x1ba8] = 0x30e8, [0x1ba9] = 0x30e9, [0x1baa] = 0x30ea,
  [0x1bab] = 0x30eb, [0x1bac] = 0x30ec, [0x1bad] = 0x30ed, [0x1bae] = 0x30ee,
  [0x1baf] = 0x30ef, [0x1bb0] = 0x30f0, [0x1bb1] = 0x30f1, [0x1bb2] = 0x30f2,
  [0x1bb3] = 0x30f3, [0x1bb4] = 0x30f4, [0x1bb5] = 0x30f5, [0x1bb6] = 0x30f6,
  [0x1c21] = 0x0391, [0x1c22] = 0x0392, [0x1c23] = 0x0393, [0x1c24] = 0x0394,
  [0x1c25] = 0x0395, [0x1c26] = 0x0396, [0x1c27] = 0x0397, [0x1c28] = 0x0398,
  [0x1c29] = 0x0399, [0x1c2a] = 0x039a, [0x1c2b] = 0x039b, [0x1c2c] = 0x039c,
  [0x1c2d] = 0x039d, [0x1c2e] = 0x039e, [0x1c2f] = 0x039f, [0x1c30] = 0x03a0,
  [0x1c31] = 0x03a1, [0x1c32] = 0x03a3, [0x1c33] = 0x03a4, [0x1c34] = 0x03a5,
  [0x1c35] = 0x03a6, [0x1c36] = 0x03a7, [0x1c37] = 0x03a8, [0x1c38] = 0x03a9,
  [0x1c41] = 0x03b1, [0x1c42] = 0x03b2, [0x1c43] = 0x03b3, [0x1c44] = 0x03b4,
  [0x1c45] = 0x03b5, [0x1c46] = 0x03b6, [0x1c47] = 0x03b7, [0x1c48] = 0x03b8,
  [0x1c49] = 0x03b9, [0x1c4a] = 0x03ba, [0x1c4b] = 0x03bb, [0x1c4c] = 0x03bc,
  [0x1c4d] = 0x03bd, [0x1c4e] = 0x03be, [0x1c4f] = 0x03bf, [0x1c50] = 0x03c0,
  [0x1c51] = 0x03c1, [0x1c52] = 0x03c3, [0x1c53] = 0x03c4, [0x1c54] = 0x03c5,
  [0x1c55] = 0x03c6, [0x1c56] = 0x03c7, [0x1c57] = 0x03c8, [0x1c58] = 0x03c9,
  [0x1c60] = 0xfe35, [0x1c61] = 0xfe36, [0x1c62] = 0xfe39, [0x1c63] = 0xfe3a,
  [0x1c64] = 0xfe3f, [0x1c65] = 0xfe40, [0x1c66] = 0xfe3d, [0x1c67] = 0xfe3e,
  [0x1c68] = 0xfe41, [0x1c69] = 0xfe42, [0x1c6a] = 0xfe43, [0x1c6b] = 0xfe44,
  [0x1c6e] = 0xfe3b, [0x1c6f] = 0xfe3c, [0x1c70] = 0xfe37, [0x1c71] = 0xfe38,
  [0x1c72] = 0xfe31, [0x1c74] = 0xfe33, [0x1c75] = 0xfe34, [0x1ce1] = 0x0410,
  [0x1ce2] = 0x0411, [0x1ce3] = 0x0412, [0x1ce4] = 0x0413, [0x1ce5] = 0x0414,
  [0x1ce6] = 0x0415, [0x1ce7] = 0x0401, [0x1ce8] = 0x0416, [0x1ce9] = 0x0417,
  [0x1cea] = 0x0418, [0x1ceb] = 0x0419, [0x1cec] = 0x041a, [0x1ced] = 0x041b,
  [0x1cee] = 0x041c, [0x1cef] = 0x041d, [0x1cf0] = 0x041e, [0x1cf1] = 0x041f,
  [0x1cf2] = 0x0420, [0x1cf3] = 0x0421, [0x1cf4] = 0x0422, [0x1cf5] = 0x0423,
  [0x1cf6] = 0x0424, [0x1cf7] = 0x0425, [0x1cf8] = 0x0426, [0x1cf9] = 0x0427,
  [0x1cfa] = 0x0428, [0x1cfb] = 0x0429, [0x1cfc] = 0x042a, [0x1cfd] = 0x042b,
  [0x1cfe] = 0x042c, [0x1cff] = 0x042d, [0x1d00] = 0x042e, [0x1d01] = 0x042f,
  [0x1d11] = 0x0430, [0x1d12] = 0x0431, [0x1d13] = 0x0432, [0x1d14] = 0x0433,
  [0x1d15] = 0x0434, [0x1d16] = 0x0435, [0x1d17] = 0x0451, [0x1d18] = 0x0436,
  [0x1d19] = 0x0437, [0x1d1a] = 0x0438, [0x1d1b] = 0x0439, [0x1d1c] = 0x043a,
  [0x1d1d] = 0x043b, [0x1d1e] = 0x043c, [0x1d1f] = 0x043d, [0x1d20] = 0x043e,
  [0x1d21] = 0x043f, [0x1d22] = 0x0440, [0x1d23] = 0x0441, [0x1d24] = 0x0442,
  [0x1d25] = 0x0443, [0x1d26] = 0x0444, [0x1d27] = 0x0445, [0x1d28] = 0x0446,
  [0x1d29] = 0x0447, [0x1d2a] = 0x0448, [0x1d2b] = 0x0449, [0x1d2c] = 0x044a,
  [0x1d2d] = 0x044b, [0x1d2e] = 0x044c, [0x1d2f] = 0x044d, [0x1d30] = 0x044e,
  [0x1d31] = 0x044f, [0x1d40] = 0x02ca, [0x1d41] = 0x02cb, [0x1d42] = 0x02d9,
  [0x1d43] = 0x2013, [0x1d44] = 0x2015, [0x1d45] = 0x2025, [0x1d46] = 0x2035,
  [0x1d47] = 0x2105, [0x1d48] = 0x2109, [0x1d49] = 0x2196, [0x1d4a] = 0x2197,
  [0x1d4b] = 0x2198, [0x1d4c] = 0x2199, [0x1d4d] = 0x2215, [0x1d4e] = 0x221f,
  [0x1d4f] = 0x2223, [0x1d50] = 0x2252, [0x1d51] = 0x2266, [0x1d52] = 0x2267,
  [0x1d53] = 0x22bf, [0x1d54] = 0x2550, [0x1d55] = 0x2551, [0x1d56] = 0x2552,
  [0x1d57] = 0x2553, [0x1d58] = 0x2554, [0x1d59] = 0x2555, [0x1d5a] = 0x2556,
  [0x1d5b] = 0x2557, [0x1d5c] = 0x2558, [0x1d5d] = 0x2559, [0x1d5e] = 0x255a,
  [0x1d5f] = 0x255b, [0x1d60] = 0x255c, [0x1d61] = 0x255d, [0x1d62] = 0x255e,
  [0x1d63] = 0x255f, [0x1d64] = 0x2560, [0x1d65] = 0x2561, [0x1d66] = 0x2562,
  [0x1d67] = 0x2563, [0x1d68] = 0x2564, [0x1d69] = 0x2565, [0x1d6a] = 0x2566,
  [0x1d6b] = 0x2567, [0x1d6c] = 0x2568, [0x1d6d] = 0x2569, [0x1d6e] = 0x256a,
  [0x1d6f] = 0x256b, [0x1d70] = 0x256c, [0x1d71] = 0x256d, [0x1d72] = 0x256e,
  [0x1d73] = 0x256f, [0x1d74] = 0x2570, [0x1d75] = 0x2571, [0x1d76] = 0x2572,
  [0x1d77] = 0x2573, [0x1d78] = 0x2581, [0x1d79] = 0x2582, [0x1d7a] = 0x2583,
  [0x1d7b] = 0x2584, [0x1d7c] = 0x2585, [0x1d7d] = 0x2586, [0x1d7e] = 0x2587,
  [0x1d80] = 0x2588, [0x1d81] = 0x2589, [0x1d82] = 0x258a, [0x1d83] = 0x258b,
  [0x1d84] = 0x258c, [0x1d85] = 0x258d, [0x1d86] = 0x258e, [0x1d87] = 0x258f,
  [0x1d88] = 0x2593, [0x1d89] = 0x2594, [0x1d8a] = 0x2595, [0x1d8b] = 0x25bc,
  [0x1d8c] = 0x25bd, [0x1d8d] = 0x25e2, [0x1d8e] = 0x25e3, [0x1d8f] = 0x25e4,
  [0x1d90] = 0x25e5, [0x1d91] = 0x2609, [0x1d92] = 0x2295, [0x1d93] = 0x3012,
  [0x1d94] = 0x301d, [0x1d95] = 0x301e, [0x1da1] = 0x0101, [0x1da2] = 0x00e1,
  [0x1da3] = 0x01ce, [0x1da4] = 0x00e0, [0x1da5] = 0x0113, [0x1da6] = 0x00e9,
  [0x1da7] = 0x011b, [0x1da8] = 0x00e8, [0x1da9] = 0x012b, [0x1daa] = 0x00ed,
  [0x1dab] = 0x01d0, [0x1dac] = 0x00ec, [0x1dad] = 0x014d, [0x1dae] = 0x00f3,
  [0x1daf] = 0x01d2, [0x1db0] = 0x00f2, [0x1db1] = 0x016b, [0x1db2] = 0x00fa,
  [0x1db3] = 0x01d4, [0x1db4] = 0x00f9, [0x1db5] = 0x01d6, [0x1db6] = 0x01d8,
  [0x1db7] = 0x01da, [0x1db8] = 0x01dc, [0x1db9] = 0x00fc, [0x1dba] = 0x00ea,
  [0x1dbb] = 0x0251, [0x1dbd] = 0x0144, [0x1dbe] = 0x0148,
  [0x1dbf] = 0x01f9, [0x1dc0] = 0x0261, [0x1dc5] = 0x3105, [0x1dc6] = 0x3106,
  [0x1dc7] = 0x3107, [0x1dc8] = 0x3108, [0x1dc9] = 0x3109, [0x1dca] = 0x310a,
  [0x1dcb] = 0x310b, [0x1dcc] = 0x310c, [0x1dcd] = 0x310d, [0x1dce] = 0x310e,
  [0x1dcf] = 0x310f, [0x1dd0] = 0x3110, [0x1dd1] = 0x3111, [0x1dd2] = 0x3112,
  [0x1dd3] = 0x3113, [0x1dd4] = 0x3114, [0x1dd5] = 0x3115, [0x1dd6] = 0x3116,
  [0x1dd7] = 0x3117, [0x1dd8] = 0x3118, [0x1dd9] = 0x3119, [0x1dda] = 0x311a,
  [0x1ddb] = 0x311b, [0x1ddc] = 0x311c, [0x1ddd] = 0x311d, [0x1dde] = 0x311e,
  [0x1ddf] = 0x311f, [0x1de0] = 0x3120, [0x1de1] = 0x3121, [0x1de2] = 0x3122,
  [0x1de3] = 0x3123, [0x1de4] = 0x3124, [0x1de5] = 0x3125, [0x1de6] = 0x3126,
  [0x1de7] = 0x3127, [0x1de8] = 0x3128, [0x1de9] = 0x3129, [0x1e00] = 0x3021,
  [0x1e01] = 0x3022, [0x1e02] = 0x3023, [0x1e03] = 0x3024, [0x1e04] = 0x3025,
  [0x1e05] = 0x3026, [0x1e06] = 0x3027, [0x1e07] = 0x3028, [0x1e08] = 0x3029,
  [0x1e09] = 0x32a3, [0x1e0a] = 0x338e, [0x1e0b] = 0x338f, [0x1e0c] = 0x339c,
  [0x1e0d] = 0x339d, [0x1e0e] = 0x339e, [0x1e0f] = 0x33a1, [0x1e10] = 0x33c4,
  [0x1e11] = 0x33ce, [0x1e12] = 0x33d1, [0x1e13] = 0x33d2, [0x1e14] = 0x33d5,
  [0x1e15] = 0xfe30, [0x1e16] = 0xffe2, [0x1e17] = 0xffe4, [0x1e19] = 0x2121,
  [0x1e1a] = 0x3231, [0x1e1c] = 0x2010, [0x1e20] = 0x30fc, [0x1e21] = 0x309b,
  [0x1e22] = 0x309c, [0x1e23] = 0x30fd, [0x1e24] = 0x30fe, [0x1e25] = 0x3006,
  [0x1e26] = 0x309d, [0x1e27] = 0x309e, [0x1e28] = 0xfe49, [0x1e29] = 0xfe4a,
  [0x1e2a] = 0xfe4b, [0x1e2b] = 0xfe4c, [0x1e2c] = 0xfe4d, [0x1e2d] = 0xfe4e,
  [0x1e2e] = 0xfe4f, [0x1e2f] = 0xfe50, [0x1e30] = 0xfe51, [0x1e31] = 0xfe52,
  [0x1e32] = 0xfe54, [0x1e33] = 0xfe55, [0x1e34] = 0xfe56, [0x1e35] = 0xfe57,
  [0x1e36] = 0xfe59, [0x1e37] = 0xfe5a, [0x1e38] = 0xfe5b, [0x1e39] = 0xfe5c,
  [0x1e3a] = 0xfe5d, [0x1e3b] = 0xfe5e, [0x1e3c] = 0xfe5f, [0x1e3d] = 0xfe60,
  [0x1e3e] = 0xfe61, [0x1e40] = 0xfe62, [0x1e41] = 0xfe63, [0x1e42] = 0xfe64,
  [0x1e43] = 0xfe65, [0x1e44] = 0xfe66, [0x1e45] = 0xfe68, [0x1e46] = 0xfe69,
  [0x1e47] = 0xfe6a, [0x1e48] = 0xfe6b, [0x1e4a] = 0x2ff0,
  [0x1e4b] = 0x2ff1, [0x1e4c] = 0x2ff2, [0x1e4d] = 0x2ff3, [0x1e4e] = 0x2ff4,
  [0x1e4f] = 0x2ff5, [0x1e50] = 0x2ff6, [0x1e51] = 0x2ff7, [0x1e52] = 0x2ff8,
  [0x1e53] = 0x2ff9, [0x1e54] = 0x2ffa, [0x1e55] = 0x2ffb, [0x1e56] = 0x3007,
  [0x1e64] = 0x2500, [0x1e65] = 0x2501, [0x1e66] = 0x2502, [0x1e67] = 0x2503,
  [0x1e68] = 0x2504, [0x1e69] = 0x2505, [0x1e6a] = 0x2506, [0x1e6b] = 0x2507,
  [0x1e6c] = 0x2508, [0x1e6d] = 0x2509, [0x1e6e] = 0x250a, [0x1e6f] = 0x250b,
  [0x1e70] = 0x250c, [0x1e71] = 0x250d, [0x1e72] = 0x250e, [0x1e73] = 0x250f,
  [0x1e74] = 0x2510, [0x1e75] = 0x2511, [0x1e76] = 0x2512, [0x1e77] = 0x2513,
  [0x1e78] = 0x2514, [0x1e79] = 0x2515, [0x1e7a] = 0x2516, [0x1e7b] = 0x2517,
  [0x1e7c] = 0x2518, [0x1e7d] = 0x2519, [0x1e7e] = 0x251a, [0x1e7f] = 0x251b,
  [0x1e80] = 0x251c, [0x1e81] = 0x251d, [0x1e82] = 0x251e, [0x1e83] = 0x251f,
  [0x1e84] = 0x2520, [0x1e85] = 0x2521, [0x1e86] = 0x2522, [0x1e87] = 0x2523,
  [0x1e88] = 0x2524, [0x1e89] = 0x2525, [0x1e8a] = 0x2526, [0x1e8b] = 0x2527,
  [0x1e8c] = 0x2528, [0x1e8d] = 0x2529, [0x1e8e] = 0x252a, [0x1e8f] = 0x252b,
  [0x1e90] = 0x252c, [0x1e91] = 0x252d, [0x1e92] = 0x252e, [0x1e93] = 0x252f,
  [0x1e94] = 0x2530, [0x1e95] = 0x2531, [0x1e96] = 0x2532, [0x1e97] = 0x2533,
  [0x1e98] = 0x2534, [0x1e99] = 0x2535, [0x1e9a] = 0x2536, [0x1e9b] = 0x2537,
  [0x1e9c] = 0x2538, [0x1e9d] = 0x2539, [0x1e9e] = 0x253a, [0x1e9f] = 0x253b,
  [0x1ea0] = 0x253c, [0x1ea1] = 0x253d, [0x1ea2] = 0x253e, [0x1ea3] = 0x253f,
  [0x1ea4] = 0x2540, [0x1ea5] = 0x2541, [0x1ea6] = 0x2542, [0x1ea7] = 0x2543,
  [0x1ea8] = 0x2544, [0x1ea9] = 0x2545, [0x1eaa] = 0x2546, [0x1eab] = 0x2547,
  [0x1eac] = 0x2548, [0x1ead] = 0x2549, [0x1eae] = 0x254a, [0x1eaf] = 0x254b,
  [0x1ec0] = 0x72dc, [0x1ec1] = 0x72dd, [0x1ec2] = 0x72df, [0x1ec3] = 0x72e2,
  [0x1ec4] = 0x72e3, [0x1ec5] = 0x72e4, [0x1ec6] = 0x72e5, [0x1ec7] = 0x72e6,
  [0x1ec8] = 0x72e7, [0x1ec9] = 0x72ea, [0x1eca] = 0x72eb, [0x1ecb] = 0x72f5,
  [0x1ecc] = 0x72f6, [0x1ecd] = 0x72f9, [0x1ece] = 0x72fd, [0x1ecf] = 0x72fe,
  [0x1ed0] = 0x72ff, [0x1ed1] = 0x7300, [0x1ed2] = 0x7302, [0x1ed3] = 0x7304,
  [0x1ed4] = 0x7305, [0x1ed5] = 0x7306, [0x1ed6] = 0x7307, [0x1ed7] = 0x7308,
  [0x1ed8] = 0x7309, [0x1ed9] = 0x730b, [0x1eda] = 0x730c, [0x1edb] = 0x730d,
  [0x1edc] = 0x730f, [0x1edd] = 0x7310, [0x1ede] = 0x7311, [0x1edf] = 0x7312,
  [0x1ee0] = 0x7314, [0x1ee1] = 0x7318, [0x1ee2] = 0x7319, [0x1ee3] = 0x731a,
  [0x1ee4] = 0x731f, [0x1ee5] = 0x7320, [0x1ee6] = 0x7323, [0x1ee7] = 0x7324,
  [0x1ee8] = 0x7326, [0x1ee9] = 0x7327, [0x1eea] = 0x7328, [0x1eeb] = 0x732d,
  [0x1eec] = 0x732f, [0x1eed] = 0x7330, [0x1eee] = 0x7332, [0x1eef] = 0x7333,
  [0x1ef0] = 0x7335, [0x1ef1] = 0x7336, [0x1ef2] = 0x733a, [0x1ef3] = 0x733b,
  [0x1ef4] = 0x733c, [0x1ef5] = 0x733d, [0x1ef6] = 0x7340, [0x1ef7] = 0x7341,
  [0x1ef8] = 0x7342, [0x1ef9] = 0x7343, [0x1efa] = 0x7344, [0x1efb] = 0x7345,
  [0x1efc] = 0x7346, [0x1efd] = 0x7347, [0x1efe] = 0x7348, [0x1f00] = 0x7349,
  [0x1f01] = 0x734a, [0x1f02] = 0x734b, [0x1f03] = 0x734c, [0x1f04] = 0x734e,
  [0x1f05] = 0x734f, [0x1f06] = 0x7351, [0x1f07] = 0x7353, [0x1f08] = 0x7354,
  [0x1f09] = 0x7355, [0x1f0a] = 0x7356, [0x1f0b] = 0x7358, [0x1f0c] = 0x7359,
  [0x1f0d] = 0x735a, [0x1f0e] = 0x735b, [0x1f0f] = 0x735c, [0x1f10] = 0x735d,
  [0x1f11] = 0x735e, [0x1f12] = 0x735f, [0x1f13] = 0x7361, [0x1f14] = 0x7362,
  [0x1f15] = 0x7363, [0x1f16] = 0x7364, [0x1f17] = 0x7365, [0x1f18] = 0x7366,
  [0x1f19] = 0x7367, [0x1f1a] = 0x7368, [0x1f1b] = 0x7369, [0x1f1c] = 0x736a,
  [0x1f1d] = 0x736b, [0x1f1e] = 0x736e, [0x1f1f] = 0x7370, [0x1f20] = 0x7371,
  [0x1f80] = 0x7372, [0x1f81] = 0x7373, [0x1f82] = 0x7374, [0x1f83] = 0x7375,
  [0x1f84] = 0x7376, [0x1f85] = 0x7377, [0x1f86] = 0x7378, [0x1f87] = 0x7379,
  [0x1f88] = 0x737a, [0x1f89] = 0x737b, [0x1f8a] = 0x737c, [0x1f8b] = 0x737d,
  [0x1f8c] = 0x737f, [0x1f8d] = 0x7380, [0x1f8e] = 0x7381, [0x1f8f] = 0x7382,
  [0x1f90] = 0x7383, [0x1f91] = 0x7385, [0x1f92] = 0x7386, [0x1f93] = 0x7388,
  [0x1f94] = 0x738a, [0x1f95] = 0x738c, [0x1f96] = 0x738d, [0x1f97] = 0x738f,
  [0x1f98] = 0x7390, [0x1f99] = 0x7392, [0x1f9a] = 0x7393, [0x1f9b] = 0x7394,
  [0x1f9c] = 0x7395, [0x1f9d] = 0x7397, [0x1f9e] = 0x7398, [0x1f9f] = 0x7399,
  [0x1fa0] = 0x739a, [0x1fa1] = 0x739c, [0x1fa2] = 0x739d, [0x1fa3] = 0x739e,
  [0x1fa4] = 0x73a0, [0x1fa5] = 0x73a1, [0x1fa6] = 0x73a3, [0x1fa7] = 0x73a4,
  [0x1fa8] = 0x73a5, [0x1fa9] = 0x73a6, [0x1faa] = 0x73a7, [0x1fab] = 0x73a8,
  [0x1fac] = 0x73aa, [0x1fad] = 0x73ac, [0x1fae] = 0x73ad, [0x1faf] = 0x73b1,
  [0x1fb0] = 0x73b4, [0x1fb1] = 0x73b5, [0x1fb2] = 0x73b6, [0x1fb3] = 0x73b8,
  [0x1fb4] = 0x73b9, [0x1fb5] = 0x73bc, [0x1fb6] = 0x73bd, [0x1fb7] = 0x73be,
  [0x1fb8] = 0x73bf, [0x1fb9] = 0x73c1, [0x1fba] = 0x73c3, [0x1fbb] = 0x73c4,
  [0x1fbc] = 0x73c5, [0x1fbd] = 0x73c6, [0x1fbe] = 0x73c7, [0x1fc0] = 0x73cb,
  [0x1fc1] = 0x73cc, [0x1fc2] = 0x73ce, [0x1fc3] = 0x73d2, [0x1fc4] = 0x73d3,
  [0x1fc5] = 0x73d4, [0x1fc6] = 0x73d5, [0x1fc7] = 0x73d6, [0x1fc8] = 0x73d7,
  [0x1fc9] = 0x73d8, [0x1fca] = 0x73da, [0x1fcb] = 0x73db, [0x1fcc] = 0x73dc,
  [0x1fcd] = 0x73dd, [0x1fce] = 0x73df, [0x1fcf] = 0x73e1, [0x1fd0] = 0x73e2,
  [0x1fd1] = 0x73e3, [0x1fd2] = 0x73e4, [0x1fd3] = 0x73e6, [0x1fd4] = 0x73e8,
  [0x1fd5] = 0x73ea, [0x1fd6] = 0x73eb, [0x1fd7] = 0x73ec, [0x1fd8] = 0x73ee,
  [0x1fd9] = 0x73ef, [0x1fda] = 0x73f0, [0x1fdb] = 0x73f1, [0x1fdc] = 0x73f3,
  [0x1fdd] = 0x73f4, [0x1fde] = 0x73f5, [0x1fdf] = 0x73f6, [0x1fe0] = 0x73f7,
  [0x2040] = 0x73f8, [0x2041] = 0x73f9, [0x2042] = 0x73fa, [0x2043] = 0x73fb,
  [0x2044] = 0x73fc, [0x2045] = 0x73fd, [0x2046] = 0x73fe, [0x2047] = 0x73ff,
  [0x2048] = 0x7400, [0x2049] = 0x7401, [0x204a] = 0x7402, [0x204b] = 0x7404,
  [0x204c] = 0x7407, [0x204d] = 0x7408, [0x204e] = 0x740b, [0x204f] = 0x740c,
  [0x2050] = 0x740d, [0x2051] = 0x740e, [0x2052] = 0x7411, [0x2053] = 0x7412,
  [0x2054] = 0x7413, [0x2055] = 0x7414, [0x2056] = 0x7415, [0x2057] = 0x7416,
  [0x2058] = 0x7417, [0x2059] = 0x7418, [0x205a] = 0x7419, [0x205b] = 0x741c,
  [0x205c] = 0x741d, [0x205d] = 0x741e, [0x205e] = 0x741f, [0x205f] = 0x7420,
  [0x2060] = 0x7421, [0x2061] = 0x7423, [0x2062] = 0x7424, [0x2063] = 0x7427,
  [0x2064] = 0x7429, [0x2065] = 0x742b, [0x2066] = 0x742d, [0x2067] = 0x742f,
  [0x2068] = 0x7431, [0x2069] = 0x7432, [0x206a] = 0x7437, [0x206b] = 0x7438,
  [0x206c] = 0x7439, [0x206d] = 0x743a, [0x206e] = 0x743b, [0x206f] = 0x743d,
  [0x2070] = 0x743e, [0x2071] = 0x743f, [0x2072] = 0x7440, [0x2073] = 0x7442,
  [0x2074] = 0x7443, [0x2075] = 0x7444, [0x2076] = 0x7445, [0x2077] = 0x7446,
  [0x2078] = 0x7447, [0x2079] = 0x7448, [0x207a] = 0x7449, [0x207b] = 0x744a,
  [0x207c] = 0x744b, [0x207d] = 0x744c, [0x207e] = 0x744d, [0x2080] = 0x744e,
  [0x2081] = 0x744f, [0x2082] = 0x7450, [0x2083] = 0x7451, [0x2084] = 0x7452,
  [0x2085] = 0x7453, [0x2086] = 0x7454, [0x2087] = 0x7456, [0x2088] = 0x7458,
  [0x2089] = 0x745d, [0x208a] = 0x7460, [0x208b] = 0x7461, [0x208c] = 0x7462,
  [0x208d] = 0x7463, [0x208e] = 0x7464, [0x208f] = 0x7465, [0x2090] = 0x7466,
  [0x2091] = 0x7467, [0x2092] = 0x7468, [0x2093] = 0x7469, [0x2094] = 0x746a,
  [0x2095] = 0x746b, [0x2096] = 0x746c, [0x2097] = 0x746e, [0x2098] = 0x746f,
  [0x2099] = 0x7471, [0x209a] = 0x7472, [0x209b] = 0x7473, [0x209c] = 0x7474,
  [0x209d] = 0x7475, [0x209e] = 0x7478, [0x209f] = 0x7479, [0x20a0] = 0x747a,
  [0x2100] = 0x747b, [0x2101] = 0x747c, [0x2102] = 0x747d, [0x2103] = 0x747f,
  [0x2104] = 0x7482, [0x2105] = 0x7484, [0x2106] = 0x7485, [0x2107] = 0x7486,
  [0x2108] = 0x7488, [0x2109] = 0x7489, [0x210a] = 0x748a, [0x210b] = 0x748c,
  [0x210c] = 0x748d, [0x210d] = 0x748f, [0x210e] = 0x7491, [0x210f] = 0x7492,
  [0x2110] = 0x7493, [0x2111] = 0x7494, [0x2112] = 0x7495, [0x2113] = 0x7496,
  [0x2114] = 0x7497, [0x2115] = 0x7498, [0x2116] = 0x7499, [0x2117] = 0x749a,
  [0x2118] = 0x749b, [0x2119] = 0x749d, [0x211a] = 0x749f, [0x211b] = 0x74a0,
  [0x211c] = 0x74a1, [0x211d] = 0x74a2, [0x211e] = 0x74a3, [0x211f] = 0x74a4,
  [0x2120] = 0x74a5, [0x2121] = 0x74a6, [0x2122] = 0x74aa, [0x2123] = 0x74ab,
  [0x2124] = 0x74ac, [0x2125] = 0x74ad, [0x2126] = 0x74ae, [0x2127] = 0x74af,
  [0x2128] = 0x74b0, [0x2129] = 0x74b1, [0x212a] = 0x74b2, [0x212b] = 0x74b3,
  [0x212c] = 0x74b4, [0x212d] = 0x74b5, [0x212e] = 0x74b6, [0x212f] = 0x74b7,
  [0x2130] = 0x74b8, [0x2131] = 0x74b9, [0x2132] = 0x74bb, [0x2133] = 0x74bc,
  [0x2134] = 0x74bd, [0x2135] = 0x74be, [0x2136] = 0x74bf, [0x2137] = 0x74c0,
  [0x2138] = 0x74c1, [0x2139] = 0x74c2, [0x213a] = 0x74c3, [0x213b] = 0x74c4,
  [0x213c] = 0x74c5, [0x213d] = 0x74c6, [0x213e] = 0x74c7, [0x2140] = 0x74c8,
  [0x2141] = 0x74c9, [0x2142] = 0x74ca, [0x2143] = 0x74cb, [0x2144] = 0x74cc,
  [0x2145] = 0x74cd, [0x2146] = 0x74ce, [0x2147] = 0x74cf, [0x2148] = 0x74d0,
  [0x2149] = 0x74d1, [0x214a] = 0x74d3, [0x214b] = 0x74d4, [0x214c] = 0x74d5,
  [0x214d] = 0x74d6, [0x214e] = 0x74d7, [0x214f] = 0x74d8, [0x2150] = 0x74d9,
  [0x2151] = 0x74da, [0x2152] = 0x74db, [0x2153] = 0x74dd, [0x2154] = 0x74df,
  [0x2155] = 0x74e1, [0x2156] = 0x74e5, [0x2157] = 0x74e7, [0x2158] = 0x74e8,
  [0x2159] = 0x74e9, [0x215a] = 0x74ea, [0x215b] = 0x74eb, [0x215c] = 0x74ec,
  [0x215d] = 0x74ed, [0x215e] = 0x74f0, [0x215f] = 0x74f1, [0x2160] = 0x74f2,
  [0x21c0] = 0x74f3, [0x21c1] = 0x74f5, [0x21c2] = 0x74f8, [0x21c3] = 0x74f9,
  [0x21c4] = 0x74fa, [0x21c5] = 0x74fb, [0x21c6] = 0x74fc, [0x21c7] = 0x74fd,
  [0x21c8] = 0x74fe, [0x21c9] = 0x7500, [0x21ca] = 0x7501, [0x21cb] = 0x7502,
  [0x21cc] = 0x7503, [0x21cd] = 0x7505, [0x21ce] = 0x7506, [0x21cf] = 0x7507,
  [0x21d0] = 0x7508, [0x21d1] = 0x7509, [0x21d2] = 0x750a, [0x21d3] = 0x750b,
  [0x21d4] = 0x750c, [0x21d5] = 0x750e, [0x21d6] = 0x7510, [0x21d7] = 0x7512,
  [0x21d8] = 0x7514, [0x21d9] = 0x7515, [0x21da] = 0x7516, [0x21db] = 0x7517,
  [0x21dc] = 0x751b, [0x21dd] = 0x751d, [0x21de] = 0x751e, [0x21df] = 0x7520,
  [0x21e0] = 0x7521, [0x21e1] = 0x7522, [0x21e2] = 0x7523, [0x21e3] = 0x7524,
  [0x21e4] = 0x7526, [0x21e5] = 0x7527, [0x21e6] = 0x752a, [0x21e7] = 0x752e,
  [0x21e8] = 0x7534, [0x21e9] = 0x7536, [0x21ea] = 0x7539, [0x21eb] = 0x753c,
  [0x21ec] = 0x753d, [0x21ed] = 0x753f, [0x21ee] = 0x7541, [0x21ef] = 0x7542,
  [0x21f0] = 0x7543, [0x21f1] = 0x7544, [0x21f2] = 0x7546, [0x21f3] = 0x7547,
  [0x21f4] = 0x7549, [0x21f5] = 0x754a, [0x21f6] = 0x754d, [0x21f7] = 0x7550,
  [0x21f8] = 0x7551, [0x21f9] = 0x7552, [0x21fa] = 0x7553, [0x21fb] = 0x7555,
  [0x21fc] = 0x7556, [0x21fd] = 0x7557, [0x21fe] = 0x7558, [0x2200] = 0x755d,
  [0x2201] = 0x755e, [0x2202] = 0x755f, [0x2203] = 0x7560, [0x2204] = 0x7561,
  [0x2205] = 0x7562, [0x2206] = 0x7563, [0x2207] = 0x7564, [0x2208] = 0x7567,
  [0x2209] = 0x7568, [0x220a] = 0x7569, [0x220b] = 0x756b, [0x220c] = 0x756c,
  [0x220d] = 0x756d, [0x220e] = 0x756e, [0x220f] = 0x756f, [0x2210] = 0x7570,
  [0x2211] = 0x7571, [0x2212] = 0x7573, [0x2213] = 0x7575, [0x2214] = 0x7576,
  [0x2215] = 0x7577, [0x2216] = 0x757a, [0x2217] = 0x757b, [0x2218] = 0x757c,
  [0x2219] = 0x757d, [0x221a] = 0x757e, [0x221b] = 0x7580, [0x221c] = 0x7581,
  [0x221d] = 0x7582, [0x221e] = 0x7584, [0x221f] = 0x7585, [0x2220] = 0x7587,
  [0x2280] = 0x7588, [0x2281] = 0x7589, [0x2282] = 0x758a, [0x2283] = 0x758c,
  [0x2284] = 0x758d, [0x2285] = 0x758e, [0x2286] = 0x7590, [0x2287] = 0x7593,
  [0x2288] = 0x7595, [0x2289] = 0x7598, [0x228a] = 0x759b, [0x228b] = 0x759c,
  [0x228c] = 0x759e, [0x228d] = 0x75a2, [0x228e] = 0x75a6, [0x228f] = 0x75a7,
  [0x2290] = 0x75a8, [0x2291] = 0x75a9, [0x2292] = 0x75aa, [0x2293] = 0x75ad,
  [0x2294] = 0x75b6, [0x2295] = 0x75b7, [0x2296] = 0x75ba, [0x2297] = 0x75bb,
  [0x2298] = 0x75bf, [0x2299] = 0x75c0, [0x229a] = 0x75c1, [0x229b] = 0x75c6,
  [0x229c] = 0x75cb, [0x229d] = 0x75cc, [0x229e] = 0x75ce, [0x229f] = 0x75cf,
  [0x22a0] = 0x75d0, [0x22a1] = 0x75d1, [0x22a2] = 0x75d3, [0x22a3] = 0x75d7,
  [0x22a4] = 0x75d9, [0x22a5] = 0x75da, [0x22a6] = 0x75dc, [0x22a7] = 0x75dd,
  [0x22a8] = 0x75df, [0x22a9] = 0x75e0, [0x22aa] = 0x75e1, [0x22ab] = 0x75e5,
  [0x22ac] = 0x75e9, [0x22ad] = 0x75ec, [0x22ae] = 0x75ed, [0x22af] = 0x75ee,
  [0x22b0] = 0x75ef, [0x22b1] = 0x75f2, [0x22b2] = 0x75f3, [0x22b3] = 0x75f5,
  [0x22b4] = 0x75f6, [0x22b5] = 0x75f7, [0x22b6] = 0x75f8, [0x22b7] = 0x75fa,
  [0x22b8] = 0x75fb, [0x22b9] = 0x75fd, [0x22ba] = 0x75fe, [0x22bb] = 0x7602,
  [0x22bc] = 0x7604, [0x22bd] = 0x7606, [0x22be] = 0x7607, [0x22c0] = 0x7608,
  [0x22c1] = 0x7609, [0x22c2] = 0x760b, [0x22c3] = 0x760d, [0x22c4] = 0x760e,
  [0x22c5] = 0x760f, [0x22c6] = 0x7611, [0x22c7] = 0x7612, [0x22c8] = 0x7613,
  [0x22c9] = 0x7614, [0x22ca] = 0x7616, [0x22cb] = 0x761a, [0x22cc] = 0x761c,
  [0x22cd] = 0x761d, [0x22ce] = 0x761e, [0x22cf] = 0x7621, [0x22d0] = 0x7623,
  [0x22d1] = 0x7627, [0x22d2] = 0x7628, [0x22d3] = 0x762c, [0x22d4] = 0x762e,
  [0x22d5] = 0x762f, [0x22d6] = 0x7631, [0x22d7] = 0x7632, [0x22d8] = 0x7636,
  [0x22d9] = 0x7637, [0x22da] = 0x7639, [0x22db] = 0x763a, [0x22dc] = 0x763b,
  [0x22dd] = 0x763d, [0x22de] = 0x7641, [0x22df] = 0x7642, [0x22e0] = 0x7644,
  [0x2340] = 0x7645, [0x2341] = 0x7646, [0x2342] = 0x7647, [0x2343] = 0x7648,
  [0x2344] = 0x7649, [0x2345] = 0x764a, [0x2346] = 0x764b, [0x2347] = 0x764e,
  [0x2348] = 0x764f, [0x2349] = 0x7650, [0x234a] = 0x7651, [0x234b] = 0x7652,
  [0x234c] = 0x7653, [0x234d] = 0x7655, [0x234e] = 0x7657, [0x234f] = 0x7658,
  [0x2350] = 0x7659, [0x2351] = 0x765a, [0x2352] = 0x765b, [0x2353] = 0x765d,
  [0x2354] = 0x765f, [0x2355] = 0x7660, [0x2356] = 0x7661, [0x2357] = 0x7662,
  [0x2358] = 0x7664, [0x2359] = 0x7665, [0x235a] = 0x7666, [0x235b] = 0x7667,
  [0x235c] = 0x7668, [0x235d] = 0x7669, [0x235e] = 0x766a, [0x235f] = 0x766c,
  [0x2360] = 0x766d, [0x2361] = 0x766e, [0x2362] = 0x7670, [0x2363] = 0x7671,
  [0x2364] = 0x7672, [0x2365] = 0x7673, [0x2366] = 0x7674, [0x2367] = 0x7675,
  [0x2368] = 0x7676, [0x2369] = 0x7677, [0x236a] = 0x7679, [0x236b] = 0x767a,
  [0x236c] = 0x767c, [0x236d] = 0x767f, [0x236e] = 0x7680, [0x236f] = 0x7681,
  [0x2370] = 0x7683, [0x2371] = 0x7685, [0x2372] = 0x7689, [0x2373] = 0x768a,
  [0x2374] = 0x768c, [0x2375] = 0x768d, [0x2376] = 0x768f, [0x2377] = 0x7690,
  [0x2378] = 0x7692, [0x2379] = 0x7694, [0x237a] = 0x7695, [0x237b] = 0x7697,
  [0x237c] = 0x7698, [0x237d] = 0x769a, [0x237e] = 0x769b, [0x2380] = 0x769c,
  [0x2381] = 0x769d, [0x2382] = 0x769e, [0x2383] = 0x769f, [0x2384] = 0x76a0,
  [0x2385] = 0x76a1, [0x2386] = 0x76a2, [0x2387] = 0x76a3, [0x2388] = 0x76a5,
  [0x2389] = 0x76a6, [0x238a] = 0x76a7, [0x238b] = 0x76a8, [0x238c] = 0x76a9,
  [0x238d] = 0x76aa, [0x238e] = 0x76ab, [0x238f] = 0x76ac, [0x2390] = 0x76ad,
  [0x2391] = 0x76af, [0x2392] = 0x76b0, [0x2393] = 0x76b3, [0x2394] = 0x76b5,
  [0x2395] = 0x76b6, [0x2396] = 0x76b7, [0x2397] = 0x76b8, [0x2398] = 0x76b9,
  [0x2399] = 0x76ba, [0x239a] = 0x76bb, [0x239b] = 0x76bc, [0x239c] = 0x76bd,
  [0x239d] = 0x76be, [0x239e] = 0x76c0, [0x239f] = 0x76c1, [0x23a0] = 0x76c3,
  [0x23a1] = 0x554a, [0x23a2] = 0x963f, [0x23a3] = 0x57c3, [0x23a4] = 0x6328,
  [0x23a5] = 0x54ce, [0x23a6] = 0x5509, [0x23a7] = 0x54c0, [0x23a8] = 0x7691,
  [0x23a9] = 0x764c, [0x23aa] = 0x853c, [0x23ab] = 0x77ee, [0x23ac] = 0x827e,
  [0x23ad] = 0x788d, [0x23ae] = 0x7231, [0x23af] = 0x9698, [0x23b0] = 0x978d,
  [0x23b1] = 0x6c28, [0x23b2] = 0x5b89, [0x23b3] = 0x4ffa, [0x23b4] = 0x6309,
  [0x23b5] = 0x6697, [0x23b6] = 0x5cb8, [0x23b7] = 0x80fa, [0x23b8] = 0x6848,
  [0x23b9] = 0x80ae, [0x23ba] = 0x6602, [0x23bb] = 0x76ce, [0x23bc] = 0x51f9,
  [0x23bd] = 0x6556, [0x23be] = 0x71ac, [0x23bf] = 0x7ff1, [0x23c0] = 0x8884,
  [0x23c1] = 0x50b2, [0x23c2] = 0x5965, [0x23c3] = 0x61ca, [0x23c4] = 0x6fb3,
  [0x23c5] = 0x82ad, [0x23c6] = 0x634c, [0x23c7] = 0x6252, [0x23c8] = 0x53ed,
  [0x23c9] = 0x5427, [0x23ca] = 0x7b06, [0x23cb] = 0x516b, [0x23cc] = 0x75a4,
  [0x23cd] = 0x5df4, [0x23ce] = 0x62d4, [0x23cf] = 0x8dcb, [0x23d0] = 0x9776,
  [0x23d1] = 0x628a, [0x23d2] = 0x8019, [0x23d3] = 0x575d, [0x23d4] = 0x9738,
  [0x23d5] = 0x7f62, [0x23d6] = 0x7238, [0x23d7] = 0x767d, [0x23d8] = 0x67cf,
  [0x23d9] = 0x767e, [0x23da] = 0x6446, [0x23db] = 0x4f70, [0x23dc] = 0x8d25,
  [0x23dd] = 0x62dc, [0x23de] = 0x7a17, [0x23df] = 0x6591, [0x23e0] = 0x73ed,
  [0x23e1] = 0x642c, [0x23e2] = 0x6273, [0x23e3] = 0x822c, [0x23e4] = 0x9881,
  [0x23e5] = 0x677f, [0x23e6] = 0x7248, [0x23e7] = 0x626e, [0x23e8] = 0x62cc,
  [0x23e9] = 0x4f34, [0x23ea] = 0x74e3, [0x23eb] = 0x534a, [0x23ec] = 0x529e,
  [0x23ed] = 0x7eca, [0x23ee] = 0x90a6, [0x23ef] = 0x5e2e, [0x23f0] = 0x6886,
  [0x23f1] = 0x699c, [0x23f2] = 0x8180, [0x23f3] = 0x7ed1, [0x23f4] = 0x68d2,
  [0x23f5] = 0x78c5, [0x23f6] = 0x868c, [0x23f7] = 0x9551, [0x23f8] = 0x508d,
  [0x23f9] = 0x8c24, [0x23fa] = 0x82de, [0x23fb] = 0x80de, [0x23fc] = 0x5305,
  [0x23fd] = 0x8912, [0x23fe] = 0x5265, [0x2400] = 0x76c4, [0x2401] = 0x76c7,
  [0x2402] = 0x76c9, [0x2403] = 0x76cb, [0x2404] = 0x76cc, [0x2405] = 0x76d3,
  [0x2406] = 0x76d5, [0x2407] = 0x76d9, [0x2408] = 0x76da, [0x2409] = 0x76dc,
  [0x240a] = 0x76dd, [0x240b] = 0x76de, [0x240c] = 0x76e0, [0x240d] = 0x76e1,
  [0x240e] = 0x76e2, [0x240f] = 0x76e3, [0x2410] = 0x76e4, [0x2411] = 0x76e6,
  [0x2412] = 0x76e7, [0x2413] = 0x76e8, [0x2414] = 0x76e9, [0x2415] = 0x76ea,
  [0x2416] = 0x76eb, [0x2417] = 0x76ec, [0x2418] = 0x76ed, [0x2419] = 0x76f0,
  [0x241a] = 0x76f3, [0x241b] = 0x76f5, [0x241c] = 0x76f6, [0x241d] = 0x76f7,
  [0x241e] = 0x76fa, [0x241f] = 0x76fb, [0x2420] = 0x76fd, [0x2421] = 0x76ff,
  [0x2422] = 0x7700, [0x2423] = 0x7702, [0x2424] = 0x7703, [0x2425] = 0x7705,
  [0x2426] = 0x7706, [0x2427] = 0x770a, [0x2428] = 0x770c, [0x2429] = 0x770e,
  [0x242a] = 0x770f, [0x242b] = 0x7710, [0x242c] = 0x7711, [0x242d] = 0x7712,
  [0x242e] = 0x7713, [0x242f] = 0x7714, [0x2430] = 0x7715, [0x2431] = 0x7716,
  [0x2432] = 0x7717, [0x2433] = 0x7718, [0x2434] = 0x771b, [0x2435] = 0x771c,
  [0x2436] = 0x771d, [0x2437] = 0x771e, [0x2438] = 0x7721, [0x2439] = 0x7723,
  [0x243a] = 0x7724, [0x243b] = 0x7725, [0x243c] = 0x7727, [0x243d] = 0x772a,
  [0x243e] = 0x772b, [0x2440] = 0x772c, [0x2441] = 0x772e, [0x2442] = 0x7730,
  [0x2443] = 0x7731, [0x2444] = 0x7732, [0x2445] = 0x7733, [0x2446] = 0x7734,
  [0x2447] = 0x7739, [0x2448] = 0x773b, [0x2449] = 0x773d, [0x244a] = 0x773e,
  [0x244b] = 0x773f, [0x244c] = 0x7742, [0x244d] = 0x7744, [0x244e] = 0x7745,
  [0x244f] = 0x7746, [0x2450] = 0x7748, [0x2451] = 0x7749, [0x2452] = 0x774a,
  [0x2453] = 0x774b, [0x2454] = 0x774c, [0x2455] = 0x774d, [0x2456] = 0x774e,
  [0x2457] = 0x774f, [0x2458] = 0x7752, [0x2459] = 0x7753, [0x245a] = 0x7754,
  [0x245b] = 0x7755, [0x245c] = 0x7756, [0x245d] = 0x7757, [0x245e] = 0x7758,
  [0x245f] = 0x7759, [0x2460] = 0x775c, [0x2461] = 0x8584, [0x2462] = 0x96f9,
  [0x2463] = 0x4fdd, [0x2464] = 0x5821, [0x2465] = 0x9971, [0x2466] = 0x5b9d,
  [0x2467] = 0x62b1, [0x2468] = 0x62a5, [0x2469] = 0x66b4, [0x246a] = 0x8c79,
  [0x246b] = 0x9c8d, [0x246c] = 0x7206, [0x246d] = 0x676f, [0x246e] = 0x7891,
  [0x246f] = 0x60b2, [0x2470] = 0x5351, [0x2471] = 0x5317, [0x2472] = 0x8f88,
  [0x2473] = 0x80cc, [0x2474] = 0x8d1d, [0x2475] = 0x94a1, [0x2476] = 0x500d,
  [0x2477] = 0x72c8, [0x2478] = 0x5907, [0x2479] = 0x60eb, [0x247a] = 0x7119,
  [0x247b] = 0x88ab, [0x247c] = 0x5954, [0x247d] = 0x82ef, [0x247e] = 0x672c,
  [0x247f] = 0x7b28, [0x2480] = 0x5d29, [0x2481] = 0x7ef7, [0x2482] = 0x752d,
  [0x2483] = 0x6cf5, [0x2484] = 0x8e66, [0x2485] = 0x8ff8, [0x2486] = 0x903c,
  [0x2487] = 0x9f3b, [0x2488] = 0x6bd4, [0x2489] = 0x9119, [0x248a] = 0x7b14,
  [0x248b] = 0x5f7c, [0x248c] = 0x78a7, [0x248d] = 0x84d6, [0x248e] = 0x853d,
  [0x248f] = 0x6bd5, [0x2490] = 0x6bd9, [0x2491] = 0x6bd6, [0x2492] = 0x5e01,
  [0x2493] = 0x5e87, [0x2494] = 0x75f9, [0x2495] = 0x95ed, [0x2496] = 0x655d,
  [0x2497] = 0x5f0a, [0x2498] = 0x5fc5, [0x2499] = 0x8f9f, [0x249a] = 0x58c1,
  [0x249b] = 0x81c2, [0x249c] = 0x907f, [0x249d] = 0x965b, [0x249e] = 0x97ad,
  [0x249f] = 0x8fb9, [0x24a0] = 0x7f16, [0x24a1] = 0x8d2c, [0x24a2] = 0x6241,
  [0x24a3] = 0x4fbf, [0x24a4] = 0x53d8, [0x24a5] = 0x535e, [0x24a6] = 0x8fa8,
  [0x24a7] = 0x8fa9, [0x24a8] = 0x8fab, [0x24a9] = 0x904d, [0x24aa] = 0x6807,
  [0x24ab] = 0x5f6a, [0x24ac] = 0x8198, [0x24ad] = 0x8868, [0x24ae] = 0x9cd6,
  [0x24af] = 0x618b, [0x24b0] = 0x522b, [0x24b1] = 0x762a, [0x24b2] = 0x5f6c,
  [0x24b3] = 0x658c, [0x24b4] = 0x6fd2, [0x24b5] = 0x6ee8, [0x24b6] = 0x5bbe,
  [0x24b7] = 0x6448, [0x24b8] = 0x5175, [0x24b9] = 0x51b0, [0x24ba] = 0x67c4,
  [0x24bb] = 0x4e19, [0x24bc] = 0x79c9, [0x24bd] = 0x997c, [0x24be] = 0x70b3,
  [0x24c0] = 0x775d, [0x24c1] = 0x775e, [0x24c2] = 0x775f, [0x24c3] = 0x7760,
  [0x24c4] = 0x7764, [0x24c5] = 0x7767, [0x24c6] = 0x7769, [0x24c7] = 0x776a,
  [0x24c8] = 0x776d, [0x24c9] = 0x776e, [0x24ca] = 0x776f, [0x24cb] = 0x7770,
  [0x24cc] = 0x7771, [0x24cd] = 0x7772, [0x24ce] = 0x7773, [0x24cf] = 0x7774,
  [0x24d0] = 0x7775, [0x24d1] = 0x7776, [0x24d2] = 0x7777, [0x24d3] = 0x7778,
  [0x24d4] = 0x777a, [0x24d5] = 0x777b, [0x24d6] = 0x777c, [0x24d7] = 0x7781,
  [0x24d8] = 0x7782, [0x24d9] = 0x7783, [0x24da] = 0x7786, [0x24db] = 0x7787,
  [0x24dc] = 0x7788, [0x24dd] = 0x7789, [0x24de] = 0x778a, [0x24df] = 0x778b,
  [0x24e0] = 0x778f, [0x24e1] = 0x7790, [0x24e2] = 0x7793, [0x24e3] = 0x7794,
  [0x24e4] = 0x7795, [0x24e5] = 0x7796, [0x24e6] = 0x7797, [0x24e7] = 0x7798,
  [0x24e8] = 0x7799, [0x24e9] = 0x779a, [0x24ea] = 0x779b, [0x24eb] = 0x779c,
  [0x24ec] = 0x779d, [0x24ed] = 0x779e, [0x24ee] = 0x77a1, [0x24ef] = 0x77a3,
  [0x24f0] = 0x77a4, [0x24f1] = 0x77a6, [0x24f2] = 0x77a8, [0x24f3] = 0x77ab,
  [0x24f4] = 0x77ad, [0x24f5] = 0x77ae, [0x24f6] = 0x77af, [0x24f7] = 0x77b1,
  [0x24f8] = 0x77b2, [0x24f9] = 0x77b4, [0x24fa] = 0x77b6, [0x24fb] = 0x77b7,
  [0x24fc] = 0x77b8, [0x24fd] = 0x77b9, [0x24fe] = 0x77ba, [0x2500] = 0x77bc,
  [0x2501] = 0x77be, [0x2502] = 0x77c0, [0x2503] = 0x77c1, [0x2504] = 0x77c2,
  [0x2505] = 0x77c3, [0x2506] = 0x77c4, [0x2507] = 0x77c5, [0x2508] = 0x77c6,
  [0x2509] = 0x77c7, [0x250a] = 0x77c8, [0x250b] = 0x77c9, [0x250c] = 0x77ca,
  [0x250d] = 0x77cb, [0x250e] = 0x77cc, [0x250f] = 0x77ce, [0x2510] = 0x77cf,
  [0x2511] = 0x77d0, [0x2512] = 0x77d1, [0x2513] = 0x77d2, [0x2514] = 0x77d3,
  [0x2515] = 0x77d4, [0x2516] = 0x77d5, [0x2517] = 0x77d6, [0x2518] = 0x77d8,
  [0x2519] = 0x77d9, [0x251a] = 0x77da, [0x251b] = 0x77dd, [0x251c] = 0x77de,
  [0x251d] = 0x77df, [0x251e] = 0x77e0, [0x251f] = 0x77e1, [0x2520] = 0x77e4,
  [0x2521] = 0x75c5, [0x2522] = 0x5e76, [0x2523] = 0x73bb, [0x2524] = 0x83e0,
  [0x2525] = 0x64ad, [0x2526] = 0x62e8, [0x2527] = 0x94b5, [0x2528] = 0x6ce2,
  [0x2529] = 0x535a, [0x252a] = 0x52c3, [0x252b] = 0x640f, [0x252c] = 0x94c2,
  [0x252d] = 0x7b94, [0x252e] = 0x4f2f, [0x252f] = 0x5e1b, [0x2530] = 0x8236,
  [0x2531] = 0x8116, [0x2532] = 0x818a, [0x2533] = 0x6e24, [0x2534] = 0x6cca,
  [0x2535] = 0x9a73, [0x2536] = 0x6355, [0x2537] = 0x535c, [0x2538] = 0x54fa,
  [0x2539] = 0x8865, [0x253a] = 0x57e0, [0x253b] = 0x4e0d, [0x253c] = 0x5e03,
  [0x253d] = 0x6b65, [0x253e] = 0x7c3f, [0x253f] = 0x90e8, [0x2540] = 0x6016,
  [0x2541] = 0x64e6, [0x2542] = 0x731c, [0x2543] = 0x88c1, [0x2544] = 0x6750,
  [0x2545] = 0x624d, [0x2546] = 0x8d22, [0x2547] = 0x776c, [0x2548] = 0x8e29,
  [0x2549] = 0x91c7, [0x254a] = 0x5f69, [0x254b] = 0x83dc, [0x254c] = 0x8521,
  [0x254d] = 0x9910, [0x254e] = 0x53c2, [0x254f] = 0x8695, [0x2550] = 0x6b8b,
  [0x2551] = 0x60ed, [0x2552] = 0x60e8, [0x2553] = 0x707f, [0x2554] = 0x82cd,
  [0x2555] = 0x8231, [0x2556] = 0x4ed3, [0x2557] = 0x6ca7, [0x2558] = 0x85cf,
  [0x2559] = 0x64cd, [0x255a] = 0x7cd9, [0x255b] = 0x69fd, [0x255c] = 0x66f9,
  [0x255d] = 0x8349, [0x255e] = 0x5395, [0x255f] = 0x7b56, [0x2560] = 0x4fa7,
  [0x2561] = 0x518c, [0x2562] = 0x6d4b, [0x2563] = 0x5c42, [0x2564] = 0x8e6d,
  [0x2565] = 0x63d2, [0x2566] = 0x53c9, [0x2567] = 0x832c, [0x2568] = 0x8336,
  [0x2569] = 0x67e5, [0x256a] = 0x78b4, [0x256b] = 0x643d, [0x256c] = 0x5bdf,
  [0x256d] = 0x5c94, [0x256e] = 0x5dee, [0x256f] = 0x8be7, [0x2570] = 0x62c6,
  [0x2571] = 0x67f4, [0x2572] = 0x8c7a, [0x2573] = 0x6400, [0x2574] = 0x63ba,
  [0x2575] = 0x8749, [0x2576] = 0x998b, [0x2577] = 0x8c17, [0x2578] = 0x7f20,
  [0x2579] = 0x94f2, [0x257a] = 0x4ea7, [0x257b] = 0x9610, [0x257c] = 0x98a4,
  [0x257d] = 0x660c, [0x257e] = 0x7316, [0x2580] = 0x77e6, [0x2581] = 0x77e8,
  [0x2582] = 0x77ea, [0x2583] = 0x77ef, [0x2584] = 0x77f0, [0x2585] = 0x77f1,
  [0x2586] = 0x77f2, [0x2587] = 0x77f4, [0x2588] = 0x77f5, [0x2589] = 0x77f7,
  [0x258a] = 0x77f9, [0x258b] = 0x77fa, [0x258c] = 0x77fb, [0x258d] = 0x77fc,
  [0x258e] = 0x7803, [0x258f] = 0x7804, [0x2590] = 0x7805, [0x2591] = 0x7806,
  [0x2592] = 0x7807, [0x2593] = 0x7808, [0x2594] = 0x780a, [0x2595] = 0x780b,
  [0x2596] = 0x780e, [0x2597] = 0x780f, [0x2598] = 0x7810, [0x2599] = 0x7813,
  [0x259a] = 0x7815, [0x259b] = 0x7819, [0x259c] = 0x781b, [0x259d] = 0x781e,
  [0x259e] = 0x7820, [0x259f] = 0x7821, [0x25a0] = 0x7822, [0x25a1] = 0x7824,
  [0x25a2] = 0x7828, [0x25a3] = 0x782a, [0x25a4] = 0x782b, [0x25a5] = 0x782e,
  [0x25a6] = 0x782f, [0x25a7] = 0x7831, [0x25a8] = 0x7832, [0x25a9] = 0x7833,
  [0x25aa] = 0x7835, [0x25ab] = 0x7836, [0x25ac] = 0x783d, [0x25ad] = 0x783f,
  [0x25ae] = 0x7841, [0x25af] = 0x7842, [0x25b0] = 0x7843, [0x25b1] = 0x7844,
  [0x25b2] = 0x7846, [0x25b3] = 0x7848, [0x25b4] = 0x7849, [0x25b5] = 0x784a,
  [0x25b6] = 0x784b, [0x25b7] = 0x784d, [0x25b8] = 0x784f, [0x25b9] = 0x7851,
  [0x25ba] = 0x7853, [0x25bb] = 0x7854, [0x25bc] = 0x7858, [0x25bd] = 0x7859,
  [0x25be] = 0x785a, [0x25c0] = 0x785b, [0x25c1] = 0x785c, [0x25c2] = 0x785e,
  [0x25c3] = 0x785f, [0x25c4] = 0x7860, [0x25c5] = 0x7861, [0x25c6] = 0x7862,
  [0x25c7] = 0x7863, [0x25c8] = 0x7864, [0x25c9] = 0x7865, [0x25ca] = 0x7866,
  [0x25cb] = 0x7867, [0x25cc] = 0x7868, [0x25cd] = 0x7869, [0x25ce] = 0x786f,
  [0x25cf] = 0x7870, [0x25d0] = 0x7871, [0x25d1] = 0x7872, [0x25d2] = 0x7873,
  [0x25d3] = 0x7874, [0x25d4] = 0x7875, [0x25d5] = 0x7876, [0x25d6] = 0x7878,
  [0x25d7] = 0x7879, [0x25d8] = 0x787a, [0x25d9] = 0x787b, [0x25da] = 0x787d,
  [0x25db] = 0x787e, [0x25dc] = 0x787f, [0x25dd] = 0x7880, [0x25de] = 0x7881,
  [0x25df] = 0x7882, [0x25e0] = 0x7883, [0x25e1] = 0x573a, [0x25e2] = 0x5c1d,
  [0x25e3] = 0x5e38, [0x25e4] = 0x957f, [0x25e5] = 0x507f, [0x25e6] = 0x80a0,
  [0x25e7] = 0x5382, [0x25e8] = 0x655e, [0x25e9] = 0x7545, [0x25ea] = 0x5531,
  [0x25eb] = 0x5021, [0x25ec] = 0x8d85, [0x25ed] = 0x6284, [0x25ee] = 0x949e,
  [0x25ef] = 0x671d, [0x25f0] = 0x5632, [0x25f1] = 0x6f6e, [0x25f2] = 0x5de2,
  [0x25f3] = 0x5435, [0x25f4] = 0x7092, [0x25f5] = 0x8f66, [0x25f6] = 0x626f,
  [0x25f7] = 0x64a4, [0x25f8] = 0x63a3, [0x25f9] = 0x5f7b, [0x25fa] = 0x6f88,
  [0x25fb] = 0x90f4, [0x25fc] = 0x81e3, [0x25fd] = 0x8fb0, [0x25fe] = 0x5c18,
  [0x25ff] = 0x6668, [0x2600] = 0x5ff1, [0x2601] = 0x6c89, [0x2602] = 0x9648,
  [0x2603] = 0x8d81, [0x2604] = 0x886c, [0x2605] = 0x6491, [0x2606] = 0x79f0,
  [0x2607] = 0x57ce, [0x2608] = 0x6a59, [0x2609] = 0x6210, [0x260a] = 0x5448,
  [0x260b] = 0x4e58, [0x260c] = 0x7a0b, [0x260d] = 0x60e9, [0x260e] = 0x6f84,
  [0x260f] = 0x8bda, [0x2610] = 0x627f, [0x2611] = 0x901e, [0x2612] = 0x9a8b,
  [0x2613] = 0x79e4, [0x2614] = 0x5403, [0x2615] = 0x75f4, [0x2616] = 0x6301,
  [0x2617] = 0x5319, [0x2618] = 0x6c60, [0x2619] = 0x8fdf, [0x261a] = 0x5f1b,
  [0x261b] = 0x9a70, [0x261c] = 0x803b, [0x261d] = 0x9f7f, [0x261e] = 0x4f88,
  [0x261f] = 0x5c3a, [0x2620] = 0x8d64, [0x2621] = 0x7fc5, [0x2622] = 0x65a5,
  [0x2623] = 0x70bd, [0x2624] = 0x5145, [0x2625] = 0x51b2, [0x2626] = 0x866b,
  [0x2627] = 0x5d07, [0x2628] = 0x5ba0, [0x2629] = 0x62bd, [0x262a] = 0x916c,
  [0x262b] = 0x7574, [0x262c] = 0x8e0c, [0x262d] = 0x7a20, [0x262e] = 0x6101,
  [0x262f] = 0x7b79, [0x2630] = 0x4ec7, [0x2631] = 0x7ef8, [0x2632] = 0x7785,
  [0x2633] = 0x4e11, [0x2634] = 0x81ed, [0x2635] = 0x521d, [0x2636] = 0x51fa,
  [0x2637] = 0x6a71, [0x2638] = 0x53a8, [0x2639] = 0x8e87, [0x263a] = 0x9504,
  [0x263b] = 0x96cf, [0x263c] = 0x6ec1, [0x263d] = 0x9664, [0x263e] = 0x695a,
  [0x2640] = 0x7884, [0x2641] = 0x7885, [0x2642] = 0x7886, [0x2643] = 0x7888,
  [0x2644] = 0x788a, [0x2645] = 0x788b, [0x2646] = 0x788f, [0x2647] = 0x7890,
  [0x2648] = 0x7892, [0x2649] = 0x7894, [0x264a] = 0x7895, [0x264b] = 0x7896,
  [0x264c] = 0x7899, [0x264d] = 0x789d, [0x264e] = 0x789e, [0x264f] = 0x78a0,
  [0x2650] = 0x78a2, [0x2651] = 0x78a4, [0x2652] = 0x78a6, [0x2653] = 0x78a8,
  [0x2654] = 0x78a9, [0x2655] = 0x78aa, [0x2656] = 0x78ab, [0x2657] = 0x78ac,
  [0x2658] = 0x78ad, [0x2659] = 0x78ae, [0x265a] = 0x78af, [0x265b] = 0x78b5,
  [0x265c] = 0x78b6, [0x265d] = 0x78b7, [0x265e] = 0x78b8, [0x265f] = 0x78ba,
  [0x2660] = 0x78bb, [0x2661] = 0x78bc, [0x2662] = 0x78bd, [0x2663] = 0x78bf,
  [0x2664] = 0x78c0, [0x2665] = 0x78c2, [0x2666] = 0x78c3, [0x2667] = 0x78c4,
  [0x2668] = 0x78c6, [0x2669] = 0x78c7, [0x266a] = 0x78c8, [0x266b] = 0x78cc,
  [0x266c] = 0x78cd, [0x266d] = 0x78ce, [0x266e] = 0x78cf, [0x266f] = 0x78d1,
  [0x2670] = 0x78d2, [0x2671] = 0x78d3, [0x2672] = 0x78d6, [0x2673] = 0x78d7,
  [0x2674] = 0x78d8, [0x2675] = 0x78da, [0x2676] = 0x78db, [0x2677] = 0x78dc,
  [0x2678] = 0x78dd, [0x2679] = 0x78de, [0x267a] = 0x78df, [0x267b] = 0x78e0,
  [0x267c] = 0x78e1, [0x267d] = 0x78e2, [0x267e] = 0x78e3, [0x2680] = 0x78e4,
  [0x2681] = 0x78e5, [0x2682] = 0x78e6, [0x2683] = 0x78e7, [0x2684] = 0x78e9,
  [0x2685] = 0x78ea, [0x2686] = 0x78eb, [0x2687] = 0x78ed, [0x2688] = 0x78ee,
  [0x2689] = 0x78ef, [0x268a] = 0x78f0, [0x268b] = 0x78f1, [0x268c] = 0x78f3,
  [0x268d] = 0x78f5, [0x268e] = 0x78f6, [0x268f] = 0x78f8, [0x2690] = 0x78f9,
  [0x2691] = 0x78fb, [0x2692] = 0x78fc, [0x2693] = 0x78fd, [0x2694] = 0x78fe,
  [0x2695] = 0x78ff, [0x2696] = 0x7900, [0x2697] = 0x7902, [0x2698] = 0x7903,
  [0x2699] = 0x7904, [0x269a] = 0x7906, [0x269b] = 0x7907, [0x269c] = 0x7908,
  [0x269d] = 0x7909, [0x269e] = 0x790a, [0x269f] = 0x790b, [0x26a0] = 0x790c,
  [0x26a1] = 0x7840, [0x26a2] = 0x50a8, [0x26a3] = 0x77d7, [0x26a4] = 0x6410,
  [0x26a5] = 0x89e6, [0x26a6] = 0x5904, [0x26a7] = 0x63e3, [0x26a8] = 0x5ddd,
  [0x26a9] = 0x7a7f, [0x26aa] = 0x693d, [0x26ab] = 0x4f20, [0x26ac] = 0x8239,
  [0x26ad] = 0x5598, [0x26ae] = 0x4e32, [0x26af] = 0x75ae, [0x26b0] = 0x7a97,
  [0x26b1] = 0x5e62, [0x26b2] = 0x5e8a, [0x26b3] = 0x95ef, [0x26b4] = 0x521b,
  [0x26b5] = 0x5439, [0x26b6] = 0x708a, [0x26b7] = 0x6376, [0x26b8] = 0x9524,
  [0x26b9] = 0x5782, [0x26ba] = 0x6625, [0x26bb] = 0x693f, [0x26bc] = 0x9187,
  [0x26bd] = 0x5507, [0x26be] = 0x6df3, [0x26bf] = 0x7eaf, [0x26c0] = 0x8822,
  [0x26c1] = 0x6233, [0x26c2] = 0x7ef0, [0x26c3] = 0x75b5, [0x26c4] = 0x8328,
  [0x26c5] = 0x78c1, [0x26c6] = 0x96cc, [0x26c7] = 0x8f9e, [0x26c8] = 0x6148,
  [0x26c9] = 0x74f7, [0x26ca] = 0x8bcd, [0x26cb] = 0x6b64, [0x26cc] = 0x523a,
  [0x26cd] = 0x8d50, [0x26ce] = 0x6b21, [0x26cf] = 0x806a, [0x26d0] = 0x8471,
  [0x26d1] = 0x56f1, [0x26d2] = 0x5306, [0x26d3] = 0x4ece, [0x26d4] = 0x4e1b,
  [0x26d5] = 0x51d1, [0x26d6] = 0x7c97, [0x26d7] = 0x918b, [0x26d8] = 0x7c07,
  [0x26d9] = 0x4fc3, [0x26da] = 0x8e7f, [0x26db] = 0x7be1, [0x26dc] = 0x7a9c,
  [0x26dd] = 0x6467, [0x26de] = 0x5d14, [0x26df] = 0x50ac, [0x26e0] = 0x8106,
  [0x26e1] = 0x7601, [0x26e2] = 0x7cb9, [0x26e3] = 0x6dec, [0x26e4] = 0x7fe0,
  [0x26e5] = 0x6751, [0x26e6] = 0x5b58, [0x26e7] = 0x5bf8, [0x26e8] = 0x78cb,
  [0x26e9] = 0x64ae, [0x26ea] = 0x6413, [0x26eb] = 0x63aa, [0x26ec] = 0x632b,
  [0x26ed] = 0x9519, [0x26ee] = 0x642d, [0x26ef] = 0x8fbe, [0x26f0] = 0x7b54,
  [0x26f1] = 0x7629, [0x26f2] = 0x6253, [0x26f3] = 0x5927, [0x26f4] = 0x5446,
  [0x26f5] = 0x6b79, [0x26f6] = 0x50a3, [0x26f7] = 0x6234, [0x26f8] = 0x5e26,
  [0x26f9] = 0x6b86, [0x26fa] = 0x4ee3, [0x26fb] = 0x8d37, [0x26fc] = 0x888b,
  [0x26fd] = 0x5f85, [0x26fe] = 0x902e, [0x2700] = 0x790d, [0x2701] = 0x790e,
  [0x2702] = 0x790f, [0x2703] = 0x7910, [0x2704] = 0x7911, [0x2705] = 0x7912,
  [0x2706] = 0x7914, [0x2707] = 0x7915, [0x2708] = 0x7916, [0x2709] = 0x7917,
  [0x270a] = 0x7918, [0x270b] = 0x7919, [0x270c] = 0x791a, [0x270d] = 0x791b,
  [0x270e] = 0x791c, [0x270f] = 0x791d, [0x2710] = 0x791f, [0x2711] = 0x7920,
  [0x2712] = 0x7921, [0x2713] = 0x7922, [0x2714] = 0x7923, [0x2715] = 0x7925,
  [0x2716] = 0x7926, [0x2717] = 0x7927, [0x2718] = 0x7928, [0x2719] = 0x7929,
  [0x271a] = 0x792a, [0x271b] = 0x792b, [0x271c] = 0x792c, [0x271d] = 0x792d,
  [0x271e] = 0x792e, [0x271f] = 0x792f, [0x2720] = 0x7930, [0x2721] = 0x7931,
  [0x2722] = 0x7932, [0x2723] = 0x7933, [0x2724] = 0x7935, [0x2725] = 0x7936,
  [0x2726] = 0x7937, [0x2727] = 0x7938, [0x2728] = 0x7939, [0x2729] = 0x793d,
  [0x272a] = 0x793f, [0x272b] = 0x7942, [0x272c] = 0x7943, [0x272d] = 0x7944,
  [0x272e] = 0x7945, [0x272f] = 0x7947, [0x2730] = 0x794a, [0x2731] = 0x794b,
  [0x2732] = 0x794c, [0x2733] = 0x794d, [0x2734] = 0x794e, [0x2735] = 0x794f,
  [0x2736] = 0x7950, [0x2737] = 0x7951, [0x2738] = 0x7952, [0x2739] = 0x7954,
  [0x273a] = 0x7955, [0x273b] = 0x7958, [0x273c] = 0x7959, [0x273d] = 0x7961,
  [0x273e] = 0x7963, [0x2740] = 0x7964, [0x2741] = 0x7966, [0x2742] = 0x7969,
  [0x2743] = 0x796a, [0x2744] = 0x796b, [0x2745] = 0x796c, [0x2746] = 0x796e,
  [0x2747] = 0x7970, [0x2748] = 0x7971, [0x2749] = 0x7972, [0x274a] = 0x7973,
  [0x274b] = 0x7974, [0x274c] = 0x7975, [0x274d] = 0x7976, [0x274e] = 0x7979,
  [0x274f] = 0x797b, [0x2750] = 0x797c, [0x2751] = 0x797d, [0x2752] = 0x797e,
  [0x2753] = 0x797f, [0x2754] = 0x7982, [0x2755] = 0x7983, [0x2756] = 0x7986,
  [0x2757] = 0x7987, [0x2758] = 0x7988, [0x2759] = 0x7989, [0x275a] = 0x798b,
  [0x275b] = 0x798c, [0x275c] = 0x798d, [0x275d] = 0x798e, [0x275e] = 0x7990,
  [0x275f] = 0x7991, [0x2760] = 0x7992, [0x2761] = 0x6020, [0x2762] = 0x803d,
  [0x2763] = 0x62c5, [0x2764] = 0x4e39, [0x2765] = 0x5355, [0x2766] = 0x90f8,
  [0x2767] = 0x63b8, [0x2768] = 0x80c6, [0x2769] = 0x65e6, [0x276a] = 0x6c2e,
  [0x276b] = 0x4f46, [0x276c] = 0x60ee, [0x276d] = 0x6de1, [0x276e] = 0x8bde,
  [0x276f] = 0x5f39, [0x2770] = 0x86cb, [0x2771] = 0x5f53, [0x2772] = 0x6321,
  [0x2773] = 0x515a, [0x2774] = 0x8361, [0x2775] = 0x6863, [0x2776] = 0x5200,
  [0x2777] = 0x6363, [0x2778] = 0x8e48, [0x2779] = 0x5012, [0x277a] = 0x5c9b,
  [0x277b] = 0x7977, [0x277c] = 0x5bfc, [0x277d] = 0x5230, [0x277e] = 0x7a3b,
  [0x277f] = 0x60bc, [0x2780] = 0x9053, [0x2781] = 0x76d7, [0x2782] = 0x5fb7,
  [0x2783] = 0x5f97, [0x2784] = 0x7684, [0x2785] = 0x8e6c, [0x2786] = 0x706f,
  [0x2787] = 0x767b, [0x2788] = 0x7b49, [0x2789] = 0x77aa, [0x278a] = 0x51f3,
  [0x278b] = 0x9093, [0x278c] = 0x5824, [0x278d] = 0x4f4e, [0x278e] = 0x6ef4,
  [0x278f] = 0x8fea, [0x2790] = 0x654c, [0x2791] = 0x7b1b, [0x2792] = 0x72c4,
  [0x2793] = 0x6da4, [0x2794] = 0x7fdf, [0x2795] = 0x5ae1, [0x2796] = 0x62b5,
  [0x2797] = 0x5e95, [0x2798] = 0x5730, [0x2799] = 0x8482, [0x279a] = 0x7b2c,
  [0x279b] = 0x5e1d, [0x279c] = 0x5f1f, [0x279d] = 0x9012, [0x279e] = 0x7f14,
  [0x279f] = 0x98a0, [0x27a0] = 0x6382, [0x27a1] = 0x6ec7, [0x27a2] = 0x7898,
  [0x27a3] = 0x70b9, [0x27a4] = 0x5178, [0x27a5] = 0x975b, [0x27a6] = 0x57ab,
  [0x27a7] = 0x7535, [0x27a8] = 0x4f43, [0x27a9] = 0x7538, [0x27aa] = 0x5e97,
  [0x27ab] = 0x60e6, [0x27ac] = 0x5960, [0x27ad] = 0x6dc0, [0x27ae] = 0x6bbf,
  [0x27af] = 0x7889, [0x27b0] = 0x53fc, [0x27b1] = 0x96d5, [0x27b2] = 0x51cb,
  [0x27b3] = 0x5201, [0x27b4] = 0x6389, [0x27b5] = 0x540a, [0x27b6] = 0x9493,
  [0x27b7] = 0x8c03, [0x27b8] = 0x8dcc, [0x27b9] = 0x7239, [0x27ba] = 0x789f,
  [0x27bb] = 0x8776, [0x27bc] = 0x8fed, [0x27bd] = 0x8c0d, [0x27be] = 0x53e0,
  [0x27c0] = 0x7993, [0x27c1] = 0x7994, [0x27c2] = 0x7995, [0x27c3] = 0x7996,
  [0x27c4] = 0x7997, [0x27c5] = 0x7998, [0x27c6] = 0x7999, [0x27c7] = 0x799b,
  [0x27c8] = 0x799c, [0x27c9] = 0x799d, [0x27ca] = 0x799e, [0x27cb] = 0x799f,
  [0x27cc] = 0x79a0, [0x27cd] = 0x79a1, [0x27ce] = 0x79a2, [0x27cf] = 0x79a3,
  [0x27d0] = 0x79a4, [0x27d1] = 0x79a5, [0x27d2] = 0x79a6, [0x27d3] = 0x79a8,
  [0x27d4] = 0x79a9, [0x27d5] = 0x79aa, [0x27d6] = 0x79ab, [0x27d7] = 0x79ac,
  [0x27d8] = 0x79ad, [0x27d9] = 0x79ae, [0x27da] = 0x79af, [0x27db] = 0x79b0,
  [0x27dc] = 0x79b1, [0x27dd] = 0x79b2, [0x27de] = 0x79b4, [0x27df] = 0x79b5,
  [0x27e0] = 0x79b6, [0x27e1] = 0x79b7, [0x27e2] = 0x79b8, [0x27e3] = 0x79bc,
  [0x27e4] = 0x79bf, [0x27e5] = 0x79c2, [0x27e6] = 0x79c4, [0x27e7] = 0x79c5,
  [0x27e8] = 0x79c7, [0x27e9] = 0x79c8, [0x27ea] = 0x79ca, [0x27eb] = 0x79cc,
  [0x27ec] = 0x79ce, [0x27ed] = 0x79cf, [0x27ee] = 0x79d0, [0x27ef] = 0x79d3,
  [0x27f0] = 0x79d4, [0x27f1] = 0x79d6, [0x27f2] = 0x79d7, [0x27f3] = 0x79d9,
  [0x27f4] = 0x79da, [0x27f5] = 0x79db, [0x27f6] = 0x79dc, [0x27f7] = 0x79dd,
  [0x27f8] = 0x79de, [0x27f9] = 0x79e0, [0x27fa] = 0x79e1, [0x27fb] = 0x79e2,
  [0x27fc] = 0x79e5, [0x27fd] = 0x79e8, [0x27fe] = 0x79ea, [0x2800] = 0x79ec,
  [0x2801] = 0x79ee, [0x2802] = 0x79f1, [0x2803] = 0x79f2, [0x2804] = 0x79f3,
  [0x2805] = 0x79f4, [0x2806] = 0x79f5, [0x2807] = 0x79f6, [0x2808] = 0x79f7,
  [0x2809] = 0x79f9, [0x280a] = 0x79fa, [0x280b] = 0x79fc, [0x280c] = 0x79fe,
  [0x280d] = 0x79ff, [0x280e] = 0x7a01, [0x280f] = 0x7a04, [0x2810] = 0x7a05,
  [0x2811] = 0x7a07, [0x2812] = 0x7a08, [0x2813] = 0x7a09, [0x2814] = 0x7a0a,
  [0x2815] = 0x7a0c, [0x2816] = 0x7a0f, [0x2817] = 0x7a10, [0x2818] = 0x7a11,
  [0x2819] = 0x7a12, [0x281a] = 0x7a13, [0x281b] = 0x7a15, [0x281c] = 0x7a16,
  [0x281d] = 0x7a18, [0x281e] = 0x7a19, [0x281f] = 0x7a1b, [0x2820] = 0x7a1c,
  [0x2821] = 0x4e01, [0x2822] = 0x76ef, [0x2823] = 0x53ee, [0x2824] = 0x9489,
  [0x2825] = 0x9876, [0x2826] = 0x9f0e, [0x2827] = 0x952d, [0x2828] = 0x5b9a,
  [0x2829] = 0x8ba2, [0x282a] = 0x4e22, [0x282b] = 0x4e1c, [0x282c] = 0x51ac,
  [0x282d] = 0x8463, [0x282e] = 0x61c2, [0x282f] = 0x52a8, [0x2830] = 0x680b,
  [0x2831] = 0x4f97, [0x2832] = 0x606b, [0x2833] = 0x51bb, [0x2834] = 0x6d1e,
  [0x2835] = 0x515c, [0x2836] = 0x6296, [0x2837] = 0x6597, [0x2838] = 0x9661,
  [0x2839] = 0x8c46, [0x283a] = 0x9017, [0x283b] = 0x75d8, [0x283c] = 0x90fd,
  [0x283d] = 0x7763, [0x283e] = 0x6bd2, [0x283f] = 0x728a, [0x2840] = 0x72ec,
  [0x2841] = 0x8bfb, [0x2842] = 0x5835, [0x2843] = 0x7779, [0x2844] = 0x8d4c,
  [0x2845] = 0x675c, [0x2846] = 0x9540, [0x2847] = 0x809a, [0x2848] = 0x5ea6,
  [0x2849] = 0x6e21, [0x284a] = 0x5992, [0x284b] = 0x7aef, [0x284c] = 0x77ed,
  [0x284d] = 0x953b, [0x284e] = 0x6bb5, [0x284f] = 0x65ad, [0x2850] = 0x7f0e,
  [0x2851] = 0x5806, [0x2852] = 0x5151, [0x2853] = 0x961f, [0x2854] = 0x5bf9,
  [0x2855] = 0x58a9, [0x2856] = 0x5428, [0x2857] = 0x8e72, [0x2858] = 0x6566,
  [0x2859] = 0x987f, [0x285a] = 0x56e4, [0x285b] = 0x949d, [0x285c] = 0x76fe,
  [0x285d] = 0x9041, [0x285e] = 0x6387, [0x285f] = 0x54c6, [0x2860] = 0x591a,
  [0x2861] = 0x593a, [0x2862] = 0x579b, [0x2863] = 0x8eb2, [0x2864] = 0x6735,
  [0x2865] = 0x8dfa, [0x2866] = 0x8235, [0x2867] = 0x5241, [0x2868] = 0x60f0,
  [0x2869] = 0x5815, [0x286a] = 0x86fe, [0x286b] = 0x5ce8, [0x286c] = 0x9e45,
  [0x286d] = 0x4fc4, [0x286e] = 0x989d, [0x286f] = 0x8bb9, [0x2870] = 0x5a25,
  [0x2871] = 0x6076, [0x2872] = 0x5384, [0x2873] = 0x627c, [0x2874] = 0x904f,
  [0x2875] = 0x9102, [0x2876] = 0x997f, [0x2877] = 0x6069, [0x2878] = 0x800c,
  [0x2879] = 0x513f, [0x287a] = 0x8033, [0x287b] = 0x5c14, [0x287c] = 0x9975,
  [0x287d] = 0x6d31, [0x287e] = 0x4e8c, [0x2880] = 0x7a1d, [0x2881] = 0x7a1f,
  [0x2882] = 0x7a21, [0x2883] = 0x7a22, [0x2884] = 0x7a24, [0x2885] = 0x7a25,
  [0x2886] = 0x7a26, [0x2887] = 0x7a27, [0x2888] = 0x7a28, [0x2889] = 0x7a29,
  [0x288a] = 0x7a2a, [0x288b] = 0x7a2b, [0x288c] = 0x7a2c, [0x288d] = 0x7a2d,
  [0x288e] = 0x7a2e, [0x288f] = 0x7a2f, [0x2890] = 0x7a30, [0x2891] = 0x7a31,
  [0x2892] = 0x7a32, [0x2893] = 0x7a34, [0x2894] = 0x7a35, [0x2895] = 0x7a36,
  [0x2896] = 0x7a38, [0x2897] = 0x7a3a, [0x2898] = 0x7a3e, [0x2899] = 0x7a40,
  [0x289a] = 0x7a41, [0x289b] = 0x7a42, [0x289c] = 0x7a43, [0x289d] = 0x7a44,
  [0x289e] = 0x7a45, [0x289f] = 0x7a47, [0x28a0] = 0x7a48, [0x28a1] = 0x7a49,
  [0x28a2] = 0x7a4a, [0x28a3] = 0x7a4b, [0x28a4] = 0x7a4c, [0x28a5] = 0x7a4d,
  [0x28a6] = 0x7a4e, [0x28a7] = 0x7a4f, [0x28a8] = 0x7a50, [0x28a9] = 0x7a52,
  [0x28aa] = 0x7a53, [0x28ab] = 0x7a54, [0x28ac] = 0x7a55, [0x28ad] = 0x7a56,
  [0x28ae] = 0x7a58, [0x28af] = 0x7a59, [0x28b0] = 0x7a5a, [0x28b1] = 0x7a5b,
  [0x28b2] = 0x7a5c, [0x28b3] = 0x7a5d, [0x28b4] = 0x7a5e, [0x28b5] = 0x7a5f,
  [0x28b6] = 0x7a60, [0x28b7] = 0x7a61, [0x28b8] = 0x7a62, [0x28b9] = 0x7a63,
  [0x28ba] = 0x7a64, [0x28bb] = 0x7a65, [0x28bc] = 0x7a66, [0x28bd] = 0x7a67,
  [0x28be] = 0x7a68, [0x28c0] = 0x7a69, [0x28c1] = 0x7a6a, [0x28c2] = 0x7a6b,
  [0x28c3] = 0x7a6c, [0x28c4] = 0x7a6d, [0x28c5] = 0x7a6e, [0x28c6] = 0x7a6f,
  [0x28c7] = 0x7a71, [0x28c8] = 0x7a72, [0x28c9] = 0x7a73, [0x28ca] = 0x7a75,
  [0x28cb] = 0x7a7b, [0x28cc] = 0x7a7c, [0x28cd] = 0x7a7d, [0x28ce] = 0x7a7e,
  [0x28cf] = 0x7a82, [0x28d0] = 0x7a85, [0x28d1] = 0x7a87, [0x28d2] = 0x7a89,
  [0x28d3] = 0x7a8a, [0x28d4] = 0x7a8b, [0x28d5] = 0x7a8c, [0x28d6] = 0x7a8e,
  [0x28d7] = 0x7a8f, [0x28d8] = 0x7a90, [0x28d9] = 0x7a93, [0x28da] = 0x7a94,
  [0x28db] = 0x7a99, [0x28dc] = 0x7a9a, [0x28dd] = 0x7a9b, [0x28de] = 0x7a9e,
  [0x28df] = 0x7aa1, [0x28e0] = 0x7aa2, [0x28e1] = 0x8d30, [0x28e2] = 0x53d1,
  [0x28e3] = 0x7f5a, [0x28e4] = 0x7b4f, [0x28e5] = 0x4f10, [0x28e6] = 0x4e4f,
  [0x28e7] = 0x9600, [0x28e8] = 0x6cd5, [0x28e9] = 0x73d0, [0x28ea] = 0x85e9,
  [0x28eb] = 0x5e06, [0x28ec] = 0x756a, [0x28ed] = 0x7ffb, [0x28ee] = 0x6a0a,
  [0x28ef] = 0x77fe, [0x28f0] = 0x9492, [0x28f1] = 0x7e41, [0x28f2] = 0x51e1,
  [0x28f3] = 0x70e6, [0x28f4] = 0x53cd, [0x28f5] = 0x8fd4, [0x28f6] = 0x8303,
  [0x28f7] = 0x8d29, [0x28f8] = 0x72af, [0x28f9] = 0x996d, [0x28fa] = 0x6cdb,
  [0x28fb] = 0x574a, [0x28fc] = 0x82b3, [0x28fd] = 0x65b9, [0x28fe] = 0x80aa,
  [0x28ff] = 0x623f, [0x2900] = 0x9632, [0x2901] = 0x59a8, [0x2902] = 0x4eff,
  [0x2903] = 0x8bbf, [0x2904] = 0x7eba, [0x2905] = 0x653e, [0x2906] = 0x83f2,
  [0x2907] = 0x975e, [0x2908] = 0x5561, [0x2909] = 0x98de, [0x290a] = 0x80a5,
  [0x290b] = 0x532a, [0x290c] = 0x8bfd, [0x290d] = 0x5420, [0x290e] = 0x80ba,
  [0x290f] = 0x5e9f, [0x2910] = 0x6cb8, [0x2911] = 0x8d39, [0x2912] = 0x82ac,
  [0x2913] = 0x915a, [0x2914] = 0x5429, [0x2915] = 0x6c1b, [0x2916] = 0x5206,
  [0x2917] = 0x7eb7, [0x2918] = 0x575f, [0x2919] = 0x711a, [0x291a] = 0x6c7e,
  [0x291b] = 0x7c89, [0x291c] = 0x594b, [0x291d] = 0x4efd, [0x291e] = 0x5fff,
  [0x291f] = 0x6124, [0x2920] = 0x7caa, [0x2921] = 0x4e30, [0x2922] = 0x5c01,
  [0x2923] = 0x67ab, [0x2924] = 0x8702, [0x2925] = 0x5cf0, [0x2926] = 0x950b,
  [0x2927] = 0x98ce, [0x2928] = 0x75af, [0x2929] = 0x70fd, [0x292a] = 0x9022,
  [0x292b] = 0x51af, [0x292c] = 0x7f1d, [0x292d] = 0x8bbd, [0x292e] = 0x5949,
  [0x292f] = 0x51e4, [0x2930] = 0x4f5b, [0x2931] = 0x5426, [0x2932] = 0x592b,
  [0x2933] = 0x6577, [0x2934] = 0x80a4, [0x2935] = 0x5b75, [0x2936] = 0x6276,
  [0x2937] = 0x62c2, [0x2938] = 0x8f90, [0x2939] = 0x5e45, [0x293a] = 0x6c1f,
  [0x293b] = 0x7b26, [0x293c] = 0x4f0f, [0x293d] = 0x4fd8, [0x293e] = 0x670d,
  [0x2940] = 0x7aa3, [0x2941] = 0x7aa4, [0x2942] = 0x7aa7, [0x2943] = 0x7aa9,
  [0x2944] = 0x7aaa, [0x2945] = 0x7aab, [0x2946] = 0x7aae, [0x2947] = 0x7aaf,
  [0x2948] = 0x7ab0, [0x2949] = 0x7ab1, [0x294a] = 0x7ab2, [0x294b] = 0x7ab4,
  [0x294c] = 0x7ab5, [0x294d] = 0x7ab6, [0x294e] = 0x7ab7, [0x294f] = 0x7ab8,
  [0x2950] = 0x7ab9, [0x2951] = 0x7aba, [0x2952] = 0x7abb, [0x2953] = 0x7abc,
  [0x2954] = 0x7abd, [0x2955] = 0x7abe, [0x2956] = 0x7ac0, [0x2957] = 0x7ac1,
  [0x2958] = 0x7ac2, [0x2959] = 0x7ac3, [0x295a] = 0x7ac4, [0x295b] = 0x7ac5,
  [0x295c] = 0x7ac6, [0x295d] = 0x7ac7, [0x295e] = 0x7ac8, [0x295f] = 0x7ac9,
  [0x2960] = 0x7aca, [0x2961] = 0x7acc, [0x2962] = 0x7acd, [0x2963] = 0x7ace,
  [0x2964] = 0x7acf, [0x2965] = 0x7ad0, [0x2966] = 0x7ad1, [0x2967] = 0x7ad2,
  [0x2968] = 0x7ad3, [0x2969] = 0x7ad4, [0x296a] = 0x7ad5, [0x296b] = 0x7ad7,
  [0x296c] = 0x7ad8, [0x296d] = 0x7ada, [0x296e] = 0x7adb, [0x296f] = 0x7adc,
  [0x2970] = 0x7add, [0x2971] = 0x7ae1, [0x2972] = 0x7ae2, [0x2973] = 0x7ae4,
  [0x2974] = 0x7ae7, [0x2975] = 0x7ae8, [0x2976] = 0x7ae9, [0x2977] = 0x7aea,
  [0x2978] = 0x7aeb, [0x2979] = 0x7aec, [0x297a] = 0x7aee, [0x297b] = 0x7af0,
  [0x297c] = 0x7af1, [0x297d] = 0x7af2, [0x297e] = 0x7af3, [0x2980] = 0x7af4,
  [0x2981] = 0x7af5, [0x2982] = 0x7af6, [0x2983] = 0x7af7, [0x2984] = 0x7af8,
  [0x2985] = 0x7afb, [0x2986] = 0x7afc, [0x2987] = 0x7afe, [0x2988] = 0x7b00,
  [0x2989] = 0x7b01, [0x298a] = 0x7b02, [0x298b] = 0x7b05, [0x298c] = 0x7b07,
  [0x298d] = 0x7b09, [0x298e] = 0x7b0c, [0x298f] = 0x7b0d, [0x2990] = 0x7b0e,
  [0x2991] = 0x7b10, [0x2992] = 0x7b12, [0x2993] = 0x7b13, [0x2994] = 0x7b16,
  [0x2995] = 0x7b17, [0x2996] = 0x7b18, [0x2997] = 0x7b1a, [0x2998] = 0x7b1c,
  [0x2999] = 0x7b1d, [0x299a] = 0x7b1f, [0x299b] = 0x7b21, [0x299c] = 0x7b22,
  [0x299d] = 0x7b23, [0x299e] = 0x7b27, [0x299f] = 0x7b29, [0x29a0] = 0x7b2d,
  [0x29a1] = 0x6d6e, [0x29a2] = 0x6daa, [0x29a3] = 0x798f, [0x29a4] = 0x88b1,
  [0x29a5] = 0x5f17, [0x29a6] = 0x752b, [0x29a7] = 0x629a, [0x29a8] = 0x8f85,
  [0x29a9] = 0x4fef, [0x29aa] = 0x91dc, [0x29ab] = 0x65a7, [0x29ac] = 0x812f,
  [0x29ad] = 0x8151, [0x29ae] = 0x5e9c, [0x29af] = 0x8150, [0x29b0] = 0x8d74,
  [0x29b1] = 0x526f, [0x29b2] = 0x8986, [0x29b3] = 0x8d4b, [0x29b4] = 0x590d,
  [0x29b5] = 0x5085, [0x29b6] = 0x4ed8, [0x29b7] = 0x961c, [0x29b8] = 0x7236,
  [0x29b9] = 0x8179, [0x29ba] = 0x8d1f, [0x29bb] = 0x5bcc, [0x29bc] = 0x8ba3,
  [0x29bd] = 0x9644, [0x29be] = 0x5987, [0x29bf] = 0x7f1a, [0x29c0] = 0x5490,
  [0x29c1] = 0x5676, [0x29c2] = 0x560e, [0x29c3] = 0x8be5, [0x29c4] = 0x6539,
  [0x29c5] = 0x6982, [0x29c6] = 0x9499, [0x29c7] = 0x76d6, [0x29c8] = 0x6e89,
  [0x29c9] = 0x5e72, [0x29ca] = 0x7518, [0x29cb] = 0x6746, [0x29cc] = 0x67d1,
  [0x29cd] = 0x7aff, [0x29ce] = 0x809d, [0x29cf] = 0x8d76, [0x29d0] = 0x611f,
  [0x29d1] = 0x79c6, [0x29d2] = 0x6562, [0x29d3] = 0x8d63, [0x29d4] = 0x5188,
  [0x29d5] = 0x521a, [0x29d6] = 0x94a2, [0x29d7] = 0x7f38, [0x29d8] = 0x809b,
  [0x29d9] = 0x7eb2, [0x29da] = 0x5c97, [0x29db] = 0x6e2f, [0x29dc] = 0x6760,
  [0x29dd] = 0x7bd9, [0x29de] = 0x768b, [0x29df] = 0x9ad8, [0x29e0] = 0x818f,
  [0x29e1] = 0x7f94, [0x29e2] = 0x7cd5, [0x29e3] = 0x641e, [0x29e4] = 0x9550,
  [0x29e5] = 0x7a3f, [0x29e6] = 0x544a, [0x29e7] = 0x54e5, [0x29e8] = 0x6b4c,
  [0x29e9] = 0x6401, [0x29ea] = 0x6208, [0x29eb] = 0x9e3d, [0x29ec] = 0x80f3,
  [0x29ed] = 0x7599, [0x29ee] = 0x5272, [0x29ef] = 0x9769, [0x29f0] = 0x845b,
  [0x29f1] = 0x683c, [0x29f2] = 0x86e4, [0x29f3] = 0x9601, [0x29f4] = 0x9694,
  [0x29f5] = 0x94ec, [0x29f6] = 0x4e2a, [0x29f7] = 0x5404, [0x29f8] = 0x7ed9,
  [0x29f9] = 0x6839, [0x29fa] = 0x8ddf, [0x29fb] = 0x8015, [0x29fc] = 0x66f4,
  [0x29fd] = 0x5e9a, [0x29fe] = 0x7fb9, [0x2a00] = 0x7b2f, [0x2a01] = 0x7b30,
  [0x2a02] = 0x7b32, [0x2a03] = 0x7b34, [0x2a04] = 0x7b35, [0x2a05] = 0x7b36,
  [0x2a06] = 0x7b37, [0x2a07] = 0x7b39, [0x2a08] = 0x7b3b, [0x2a09] = 0x7b3d,
  [0x2a0a] = 0x7b3f, [0x2a0b] = 0x7b40, [0x2a0c] = 0x7b41, [0x2a0d] = 0x7b42,
  [0x2a0e] = 0x7b43, [0x2a0f] = 0x7b44, [0x2a10] = 0x7b46, [0x2a11] = 0x7b48,
  [0x2a12] = 0x7b4a, [0x2a13] = 0x7b4d, [0x2a14] = 0x7b4e, [0x2a15] = 0x7b53,
  [0x2a16] = 0x7b55, [0x2a17] = 0x7b57, [0x2a18] = 0x7b59, [0x2a19] = 0x7b5c,
  [0x2a1a] = 0x7b5e, [0x2a1b] = 0x7b5f, [0x2a1c] = 0x7b61, [0x2a1d] = 0x7b63,
  [0x2a1e] = 0x7b64, [0x2a1f] = 0x7b65, [0x2a20] = 0x7b66, [0x2a21] = 0x7b67,
  [0x2a22] = 0x7b68, [0x2a23] = 0x7b69, [0x2a24] = 0x7b6a, [0x2a25] = 0x7b6b,
  [0x2a26] = 0x7b6c, [0x2a27] = 0x7b6d, [0x2a28] = 0x7b6f, [0x2a29] = 0x7b70,
  [0x2a2a] = 0x7b73, [0x2a2b] = 0x7b74, [0x2a2c] = 0x7b76, [0x2a2d] = 0x7b78,
  [0x2a2e] = 0x7b7a, [0x2a2f] = 0x7b7c, [0x2a30] = 0x7b7d, [0x2a31] = 0x7b7f,
  [0x2a32] = 0x7b81, [0x2a33] = 0x7b82, [0x2a34] = 0x7b83, [0x2a35] = 0x7b84,
  [0x2a36] = 0x7b86, [0x2a37] = 0x7b87, [0x2a38] = 0x7b88, [0x2a39] = 0x7b89,
  [0x2a3a] = 0x7b8a, [0x2a3b] = 0x7b8b, [0x2a3c] = 0x7b8c, [0x2a3d] = 0x7b8e,
  [0x2a3e] = 0x7b8f, [0x2a40] = 0x7b91, [0x2a41] = 0x7b92, [0x2a42] = 0x7b93,
  [0x2a43] = 0x7b96, [0x2a44] = 0x7b98, [0x2a45] = 0x7b99, [0x2a46] = 0x7b9a,
  [0x2a47] = 0x7b9b, [0x2a48] = 0x7b9e, [0x2a49] = 0x7b9f, [0x2a4a] = 0x7ba0,
  [0x2a4b] = 0x7ba3, [0x2a4c] = 0x7ba4, [0x2a4d] = 0x7ba5, [0x2a4e] = 0x7bae,
  [0x2a4f] = 0x7baf, [0x2a50] = 0x7bb0, [0x2a51] = 0x7bb2, [0x2a52] = 0x7bb3,
  [0x2a53] = 0x7bb5, [0x2a54] = 0x7bb6, [0x2a55] = 0x7bb7, [0x2a56] = 0x7bb9,
  [0x2a57] = 0x7bba, [0x2a58] = 0x7bbb, [0x2a59] = 0x7bbc, [0x2a5a] = 0x7bbd,
  [0x2a5b] = 0x7bbe, [0x2a5c] = 0x7bbf, [0x2a5d] = 0x7bc0, [0x2a5e] = 0x7bc2,
  [0x2a5f] = 0x7bc3, [0x2a60] = 0x7bc4, [0x2a61] = 0x57c2, [0x2a62] = 0x803f,
  [0x2a63] = 0x6897, [0x2a64] = 0x5de5, [0x2a65] = 0x653b, [0x2a66] = 0x529f,
  [0x2a67] = 0x606d, [0x2a68] = 0x9f9a, [0x2a69] = 0x4f9b, [0x2a6a] = 0x8eac,
  [0x2a6b] = 0x516c, [0x2a6c] = 0x5bab, [0x2a6d] = 0x5f13, [0x2a6e] = 0x5de9,
  [0x2a6f] = 0x6c5e, [0x2a70] = 0x62f1, [0x2a71] = 0x8d21, [0x2a72] = 0x5171,
  [0x2a73] = 0x94a9, [0x2a74] = 0x52fe, [0x2a75] = 0x6c9f, [0x2a76] = 0x82df,
  [0x2a77] = 0x72d7, [0x2a78] = 0x57a2, [0x2a79] = 0x6784, [0x2a7a] = 0x8d2d,
  [0x2a7b] = 0x591f, [0x2a7c] = 0x8f9c, [0x2a7d] = 0x83c7, [0x2a7e] = 0x5495,
  [0x2a7f] = 0x7b8d, [0x2a80] = 0x4f30, [0x2a81] = 0x6cbd, [0x2a82] = 0x5b64,
  [0x2a83] = 0x59d1, [0x2a84] = 0x9f13, [0x2a85] = 0x53e4, [0x2a86] = 0x86ca,
  [0x2a87] = 0x9aa8, [0x2a88] = 0x8c37, [0x2a89] = 0x80a1, [0x2a8a] = 0x6545,
  [0x2a8b] = 0x987e, [0x2a8c] = 0x56fa, [0x2a8d] = 0x96c7, [0x2a8e] = 0x522e,
  [0x2a8f] = 0x74dc, [0x2a90] = 0x5250, [0x2a91] = 0x5be1, [0x2a92] = 0x6302,
  [0x2a93] = 0x8902, [0x2a94] = 0x4e56, [0x2a95] = 0x62d0, [0x2a96] = 0x602a,
  [0x2a97] = 0x68fa, [0x2a98] = 0x5173, [0x2a99] = 0x5b98, [0x2a9a] = 0x51a0,
  [0x2a9b] = 0x89c2, [0x2a9c] = 0x7ba1, [0x2a9d] = 0x9986, [0x2a9e] = 0x7f50,
  [0x2a9f] = 0x60ef, [0x2aa0] = 0x704c, [0x2aa1] = 0x8d2f, [0x2aa2] = 0x5149,
  [0x2aa3] = 0x5e7f, [0x2aa4] = 0x901b, [0x2aa5] = 0x7470, [0x2aa6] = 0x89c4,
  [0x2aa7] = 0x572d, [0x2aa8] = 0x7845, [0x2aa9] = 0x5f52, [0x2aaa] = 0x9f9f,
  [0x2aab] = 0x95fa, [0x2aac] = 0x8f68, [0x2aad] = 0x9b3c, [0x2aae] = 0x8be1,
  [0x2aaf] = 0x7678, [0x2ab0] = 0x6842, [0x2ab1] = 0x67dc, [0x2ab2] = 0x8dea,
  [0x2ab3] = 0x8d35, [0x2ab4] = 0x523d, [0x2ab5] = 0x8f8a, [0x2ab6] = 0x6eda,
  [0x2ab7] = 0x68cd, [0x2ab8] = 0x9505, [0x2ab9] = 0x90ed, [0x2aba] = 0x56fd,
  [0x2abb] = 0x679c, [0x2abc] = 0x88f9, [0x2abd] = 0x8fc7, [0x2abe] = 0x54c8,
  [0x2ac0] = 0x7bc5, [0x2ac1] = 0x7bc8, [0x2ac2] = 0x7bc9, [0x2ac3] = 0x7bca,
  [0x2ac4] = 0x7bcb, [0x2ac5] = 0x7bcd, [0x2ac6] = 0x7bce, [0x2ac7] = 0x7bcf,
  [0x2ac8] = 0x7bd0, [0x2ac9] = 0x7bd2, [0x2aca] = 0x7bd4, [0x2acb] = 0x7bd5,
  [0x2acc] = 0x7bd6, [0x2acd] = 0x7bd7, [0x2ace] = 0x7bd8, [0x2acf] = 0x7bdb,
  [0x2ad0] = 0x7bdc, [0x2ad1] = 0x7bde, [0x2ad2] = 0x7bdf, [0x2ad3] = 0x7be0,
  [0x2ad4] = 0x7be2, [0x2ad5] = 0x7be3, [0x2ad6] = 0x7be4, [0x2ad7] = 0x7be7,
  [0x2ad8] = 0x7be8, [0x2ad9] = 0x7be9, [0x2ada] = 0x7beb, [0x2adb] = 0x7bec,
  [0x2adc] = 0x7bed, [0x2add] = 0x7bef, [0x2ade] = 0x7bf0, [0x2adf] = 0x7bf2,
  [0x2ae0] = 0x7bf3, [0x2ae1] = 0x7bf4, [0x2ae2] = 0x7bf5, [0x2ae3] = 0x7bf6,
  [0x2ae4] = 0x7bf8, [0x2ae5] = 0x7bf9, [0x2ae6] = 0x7bfa, [0x2ae7] = 0x7bfb,
  [0x2ae8] = 0x7bfd, [0x2ae9] = 0x7bff, [0x2aea] = 0x7c00, [0x2aeb] = 0x7c01,
  [0x2aec] = 0x7c02, [0x2aed] = 0x7c03, [0x2aee] = 0x7c04, [0x2aef] = 0x7c05,
  [0x2af0] = 0x7c06, [0x2af1] = 0x7c08, [0x2af2] = 0x7c09, [0x2af3] = 0x7c0a,
  [0x2af4] = 0x7c0d, [0x2af5] = 0x7c0e, [0x2af6] = 0x7c10, [0x2af7] = 0x7c11,
  [0x2af8] = 0x7c12, [0x2af9] = 0x7c13, [0x2afa] = 0x7c14, [0x2afb] = 0x7c15,
  [0x2afc] = 0x7c17, [0x2afd] = 0x7c18, [0x2afe] = 0x7c19, [0x2b00] = 0x7c1a,
  [0x2b01] = 0x7c1b, [0x2b02] = 0x7c1c, [0x2b03] = 0x7c1d, [0x2b04] = 0x7c1e,
  [0x2b05] = 0x7c20, [0x2b06] = 0x7c21, [0x2b07] = 0x7c22, [0x2b08] = 0x7c23,
  [0x2b09] = 0x7c24, [0x2b0a] = 0x7c25, [0x2b0b] = 0x7c28, [0x2b0c] = 0x7c29,
  [0x2b0d] = 0x7c2b, [0x2b0e] = 0x7c2c, [0x2b0f] = 0x7c2d, [0x2b10] = 0x7c2e,
  [0x2b11] = 0x7c2f, [0x2b12] = 0x7c30, [0x2b13] = 0x7c31, [0x2b14] = 0x7c32,
  [0x2b15] = 0x7c33, [0x2b16] = 0x7c34, [0x2b17] = 0x7c35, [0x2b18] = 0x7c36,
  [0x2b19] = 0x7c37, [0x2b1a] = 0x7c39, [0x2b1b] = 0x7c3a, [0x2b1c] = 0x7c3b,
  [0x2b1d] = 0x7c3c, [0x2b1e] = 0x7c3d, [0x2b1f] = 0x7c3e, [0x2b20] = 0x7c42,
  [0x2b21] = 0x9ab8, [0x2b22] = 0x5b69, [0x2b23] = 0x6d77, [0x2b24] = 0x6c26,
  [0x2b25] = 0x4ea5, [0x2b26] = 0x5bb3, [0x2b27] = 0x9a87, [0x2b28] = 0x9163,
  [0x2b29] = 0x61a8, [0x2b2a] = 0x90af, [0x2b2b] = 0x97e9, [0x2b2c] = 0x542b,
  [0x2b2d] = 0x6db5, [0x2b2e] = 0x5bd2, [0x2b2f] = 0x51fd, [0x2b30] = 0x558a,
  [0x2b31] = 0x7f55, [0x2b32] = 0x7ff0, [0x2b33] = 0x64bc, [0x2b34] = 0x634d,
  [0x2b35] = 0x65f1, [0x2b36] = 0x61be, [0x2b37] = 0x608d, [0x2b38] = 0x710a,
  [0x2b39] = 0x6c57, [0x2b3a] = 0x6c49, [0x2b3b] = 0x592f, [0x2b3c] = 0x676d,
  [0x2b3d] = 0x822a, [0x2b3e] = 0x58d5, [0x2b3f] = 0x568e, [0x2b40] = 0x8c6a,
  [0x2b41] = 0x6beb, [0x2b42] = 0x90dd, [0x2b43] = 0x597d, [0x2b44] = 0x8017,
  [0x2b45] = 0x53f7, [0x2b46] = 0x6d69, [0x2b47] = 0x5475, [0x2b48] = 0x559d,
  [0x2b49] = 0x8377, [0x2b4a] = 0x83cf, [0x2b4b] = 0x6838, [0x2b4c] = 0x79be,
  [0x2b4d] = 0x548c, [0x2b4e] = 0x4f55, [0x2b4f] = 0x5408, [0x2b50] = 0x76d2,
  [0x2b51] = 0x8c89, [0x2b52] = 0x9602, [0x2b53] = 0x6cb3, [0x2b54] = 0x6db8,
  [0x2b55] = 0x8d6b, [0x2b56] = 0x8910, [0x2b57] = 0x9e64, [0x2b58] = 0x8d3a,
  [0x2b59] = 0x563f, [0x2b5a] = 0x9ed1, [0x2b5b] = 0x75d5, [0x2b5c] = 0x5f88,
  [0x2b5d] = 0x72e0, [0x2b5e] = 0x6068, [0x2b5f] = 0x54fc, [0x2b60] = 0x4ea8,
  [0x2b61] = 0x6a2a, [0x2b62] = 0x8861, [0x2b63] = 0x6052, [0x2b64] = 0x8f70,
  [0x2b65] = 0x54c4, [0x2b66] = 0x70d8, [0x2b67] = 0x8679, [0x2b68] = 0x9e3f,
  [0x2b69] = 0x6d2a, [0x2b6a] = 0x5b8f, [0x2b6b] = 0x5f18, [0x2b6c] = 0x7ea2,
  [0x2b6d] = 0x5589, [0x2b6e] = 0x4faf, [0x2b6f] = 0x7334, [0x2b70] = 0x543c,
  [0x2b71] = 0x539a, [0x2b72] = 0x5019, [0x2b73] = 0x540e, [0x2b74] = 0x547c,
  [0x2b75] = 0x4e4e, [0x2b76] = 0x5ffd, [0x2b77] = 0x745a, [0x2b78] = 0x58f6,
  [0x2b79] = 0x846b, [0x2b7a] = 0x80e1, [0x2b7b] = 0x8774, [0x2b7c] = 0x72d0,
  [0x2b7d] = 0x7cca, [0x2b7e] = 0x6e56, [0x2b80] = 0x7c43, [0x2b81] = 0x7c44,
  [0x2b82] = 0x7c45, [0x2b83] = 0x7c46, [0x2b84] = 0x7c47, [0x2b85] = 0x7c48,
  [0x2b86] = 0x7c49, [0x2b87] = 0x7c4a, [0x2b88] = 0x7c4b, [0x2b89] = 0x7c4c,
  [0x2b8a] = 0x7c4e, [0x2b8b] = 0x7c4f, [0x2b8c] = 0x7c50, [0x2b8d] = 0x7c51,
  [0x2b8e] = 0x7c52, [0x2b8f] = 0x7c53, [0x2b90] = 0x7c54, [0x2b91] = 0x7c55,
  [0x2b92] = 0x7c56, [0x2b93] = 0x7c57, [0x2b94] = 0x7c58, [0x2b95] = 0x7c59,
  [0x2b96] = 0x7c5a, [0x2b97] = 0x7c5b, [0x2b98] = 0x7c5c, [0x2b99] = 0x7c5d,
  [0x2b9a] = 0x7c5e, [0x2b9b] = 0x7c5f, [0x2b9c] = 0x7c60, [0x2b9d] = 0x7c61,
  [0x2b9e] = 0x7c62, [0x2b9f] = 0x7c63, [0x2ba0] = 0x7c64, [0x2ba1] = 0x7c65,
  [0x2ba2] = 0x7c66, [0x2ba3] = 0x7c67, [0x2ba4] = 0x7c68, [0x2ba5] = 0x7c69,
  [0x2ba6] = 0x7c6a, [0x2ba7] = 0x7c6b, [0x2ba8] = 0x7c6c, [0x2ba9] = 0x7c6d,
  [0x2baa] = 0x7c6e, [0x2bab] = 0x7c6f, [0x2bac] = 0x7c70, [0x2bad] = 0x7c71,
  [0x2bae] = 0x7c72, [0x2baf] = 0x7c75, [0x2bb0] = 0x7c76, [0x2bb1] = 0x7c77,
  [0x2bb2] = 0x7c78, [0x2bb3] = 0x7c79, [0x2bb4] = 0x7c7a, [0x2bb5] = 0x7c7e,
  [0x2bb6] = 0x7c7f, [0x2bb7] = 0x7c80, [0x2bb8] = 0x7c81, [0x2bb9] = 0x7c82,
  [0x2bba] = 0x7c83, [0x2bbb] = 0x7c84, [0x2bbc] = 0x7c85, [0x2bbd] = 0x7c86,
  [0x2bbe] = 0x7c87, [0x2bc0] = 0x7c88, [0x2bc1] = 0x7c8a, [0x2bc2] = 0x7c8b,
  [0x2bc3] = 0x7c8c, [0x2bc4] = 0x7c8d, [0x2bc5] = 0x7c8e, [0x2bc6] = 0x7c8f,
  [0x2bc7] = 0x7c90, [0x2bc8] = 0x7c93, [0x2bc9] = 0x7c94, [0x2bca] = 0x7c96,
  [0x2bcb] = 0x7c99, [0x2bcc] = 0x7c9a, [0x2bcd] = 0x7c9b, [0x2bce] = 0x7ca0,
  [0x2bcf] = 0x7ca1, [0x2bd0] = 0x7ca3, [0x2bd1] = 0x7ca6, [0x2bd2] = 0x7ca7,
  [0x2bd3] = 0x7ca8, [0x2bd4] = 0x7ca9, [0x2bd5] = 0x7cab, [0x2bd6] = 0x7cac,
  [0x2bd7] = 0x7cad, [0x2bd8] = 0x7caf, [0x2bd9] = 0x7cb0, [0x2bda] = 0x7cb4,
  [0x2bdb] = 0x7cb5, [0x2bdc] = 0x7cb6, [0x2bdd] = 0x7cb7, [0x2bde] = 0x7cb8,
  [0x2bdf] = 0x7cba, [0x2be0] = 0x7cbb, [0x2be1] = 0x5f27, [0x2be2] = 0x864e,
  [0x2be3] = 0x552c, [0x2be4] = 0x62a4, [0x2be5] = 0x4e92, [0x2be6] = 0x6caa,
  [0x2be7] = 0x6237, [0x2be8] = 0x82b1, [0x2be9] = 0x54d7, [0x2bea] = 0x534e,
  [0x2beb] = 0x733e, [0x2bec] = 0x6ed1, [0x2bed] = 0x753b, [0x2bee] = 0x5212,
  [0x2bef] = 0x5316, [0x2bf0] = 0x8bdd, [0x2bf1] = 0x69d0, [0x2bf2] = 0x5f8a,
  [0x2bf3] = 0x6000, [0x2bf4] = 0x6dee, [0x2bf5] = 0x574f, [0x2bf6] = 0x6b22,
  [0x2bf7] = 0x73af, [0x2bf8] = 0x6853, [0x2bf9] = 0x8fd8, [0x2bfa] = 0x7f13,
  [0x2bfb] = 0x6362, [0x2bfc] = 0x60a3, [0x2bfd] = 0x5524, [0x2bfe] = 0x75ea,
  [0x2bff] = 0x8c62, [0x2c00] = 0x7115, [0x2c01] = 0x6da3, [0x2c02] = 0x5ba6,
  [0x2c03] = 0x5e7b, [0x2c04] = 0x8352, [0x2c05] = 0x614c, [0x2c06] = 0x9ec4,
  [0x2c07] = 0x78fa, [0x2c08] = 0x8757, [0x2c09] = 0x7c27, [0x2c0a] = 0x7687,
  [0x2c0b] = 0x51f0, [0x2c0c] = 0x60f6, [0x2c0d] = 0x714c, [0x2c0e] = 0x6643,
  [0x2c0f] = 0x5e4c, [0x2c10] = 0x604d, [0x2c11] = 0x8c0e, [0x2c12] = 0x7070,
  [0x2c13] = 0x6325, [0x2c14] = 0x8f89, [0x2c15] = 0x5fbd, [0x2c16] = 0x6062,
  [0x2c17] = 0x86d4, [0x2c18] = 0x56de, [0x2c19] = 0x6bc1, [0x2c1a] = 0x6094,
  [0x2c1b] = 0x6167, [0x2c1c] = 0x5349, [0x2c1d] = 0x60e0, [0x2c1e] = 0x6666,
  [0x2c1f] = 0x8d3f, [0x2c20] = 0x79fd, [0x2c21] = 0x4f1a, [0x2c22] = 0x70e9,
  [0x2c23] = 0x6c47, [0x2c24] = 0x8bb3, [0x2c25] = 0x8bf2, [0x2c26] = 0x7ed8,
  [0x2c27] = 0x8364, [0x2c28] = 0x660f, [0x2c29] = 0x5a5a, [0x2c2a] = 0x9b42,
  [0x2c2b] = 0x6d51, [0x2c2c] = 0x6df7, [0x2c2d] = 0x8c41, [0x2c2e] = 0x6d3b,
  [0x2c2f] = 0x4f19, [0x2c30] = 0x706b, [0x2c31] = 0x83b7, [0x2c32] = 0x6216,
  [0x2c33] = 0x60d1, [0x2c34] = 0x970d, [0x2c35] = 0x8d27, [0x2c36] = 0x7978,
  [0x2c37] = 0x51fb, [0x2c38] = 0x573e, [0x2c39] = 0x57fa, [0x2c3a] = 0x673a,
  [0x2c3b] = 0x7578, [0x2c3c] = 0x7a3d, [0x2c3d] = 0x79ef, [0x2c3e] = 0x7b95,
  [0x2c40] = 0x7cbf, [0x2c41] = 0x7cc0, [0x2c42] = 0x7cc2, [0x2c43] = 0x7cc3,
  [0x2c44] = 0x7cc4, [0x2c45] = 0x7cc6, [0x2c46] = 0x7cc9, [0x2c47] = 0x7ccb,
  [0x2c48] = 0x7cce, [0x2c49] = 0x7ccf, [0x2c4a] = 0x7cd0, [0x2c4b] = 0x7cd1,
  [0x2c4c] = 0x7cd2, [0x2c4d] = 0x7cd3, [0x2c4e] = 0x7cd4, [0x2c4f] = 0x7cd8,
  [0x2c50] = 0x7cda, [0x2c51] = 0x7cdb, [0x2c52] = 0x7cdd, [0x2c53] = 0x7cde,
  [0x2c54] = 0x7ce1, [0x2c55] = 0x7ce2, [0x2c56] = 0x7ce3, [0x2c57] = 0x7ce4,
  [0x2c58] = 0x7ce5, [0x2c59] = 0x7ce6, [0x2c5a] = 0x7ce7, [0x2c5b] = 0x7ce9,
  [0x2c5c] = 0x7cea, [0x2c5d] = 0x7ceb, [0x2c5e] = 0x7cec, [0x2c5f] = 0x7ced,
  [0x2c60] = 0x7cee, [0x2c61] = 0x7cf0, [0x2c62] = 0x7cf1, [0x2c63] = 0x7cf2,
  [0x2c64] = 0x7cf3, [0x2c65] = 0x7cf4, [0x2c66] = 0x7cf5, [0x2c67] = 0x7cf6,
  [0x2c68] = 0x7cf7, [0x2c69] = 0x7cf9, [0x2c6a] = 0x7cfa, [0x2c6b] = 0x7cfc,
  [0x2c6c] = 0x7cfd, [0x2c6d] = 0x7cfe, [0x2c6e] = 0x7cff, [0x2c6f] = 0x7d00,
  [0x2c70] = 0x7d01, [0x2c71] = 0x7d02, [0x2c72] = 0x7d03, [0x2c73] = 0x7d04,
  [0x2c74] = 0x7d05, [0x2c75] = 0x7d06, [0x2c76] = 0x7d07, [0x2c77] = 0x7d08,
  [0x2c78] = 0x7d09, [0x2c79] = 0x7d0b, [0x2c7a] = 0x7d0c, [0x2c7b] = 0x7d0d,
  [0x2c7c] = 0x7d0e, [0x2c7d] = 0x7d0f, [0x2c7e] = 0x7d10, [0x2c80] = 0x7d11,
  [0x2c81] = 0x7d12, [0x2c82] = 0x7d13, [0x2c83] = 0x7d14, [0x2c84] = 0x7d15,
  [0x2c85] = 0x7d16, [0x2c86] = 0x7d17, [0x2c87] = 0x7d18, [0x2c88] = 0x7d19,
  [0x2c89] = 0x7d1a, [0x2c8a] = 0x7d1b, [0x2c8b] = 0x7d1c, [0x2c8c] = 0x7d1d,
  [0x2c8d] = 0x7d1e, [0x2c8e] = 0x7d1f, [0x2c8f] = 0x7d21, [0x2c90] = 0x7d23,
  [0x2c91] = 0x7d24, [0x2c92] = 0x7d25, [0x2c93] = 0x7d26, [0x2c94] = 0x7d28,
  [0x2c95] = 0x7d29, [0x2c96] = 0x7d2a, [0x2c97] = 0x7d2c, [0x2c98] = 0x7d2d,
  [0x2c99] = 0x7d2e, [0x2c9a] = 0x7d30, [0x2c9b] = 0x7d31, [0x2c9c] = 0x7d32,
  [0x2c9d] = 0x7d33, [0x2c9e] = 0x7d34, [0x2c9f] = 0x7d35, [0x2ca0] = 0x7d36,
  [0x2ca1] = 0x808c, [0x2ca2] = 0x9965, [0x2ca3] = 0x8ff9, [0x2ca4] = 0x6fc0,
  [0x2ca5] = 0x8ba5, [0x2ca6] = 0x9e21, [0x2ca7] = 0x59ec, [0x2ca8] = 0x7ee9,
  [0x2ca9] = 0x7f09, [0x2caa] = 0x5409, [0x2cab] = 0x6781, [0x2cac] = 0x68d8,
  [0x2cad] = 0x8f91, [0x2cae] = 0x7c4d, [0x2caf] = 0x96c6, [0x2cb0] = 0x53ca,
  [0x2cb1] = 0x6025, [0x2cb2] = 0x75be, [0x2cb3] = 0x6c72, [0x2cb4] = 0x5373,
  [0x2cb5] = 0x5ac9, [0x2cb6] = 0x7ea7, [0x2cb7] = 0x6324, [0x2cb8] = 0x51e0,
  [0x2cb9] = 0x810a, [0x2cba] = 0x5df1, [0x2cbb] = 0x84df, [0x2cbc] = 0x6280,
  [0x2cbd] = 0x5180, [0x2cbe] = 0x5b63, [0x2cbf] = 0x4f0e, [0x2cc0] = 0x796d,
  [0x2cc1] = 0x5242, [0x2cc2] = 0x60b8, [0x2cc3] = 0x6d4e, [0x2cc4] = 0x5bc4,
  [0x2cc5] = 0x5bc2, [0x2cc6] = 0x8ba1, [0x2cc7] = 0x8bb0, [0x2cc8] = 0x65e2,
  [0x2cc9] = 0x5fcc, [0x2cca] = 0x9645, [0x2ccb] = 0x5993, [0x2ccc] = 0x7ee7,
  [0x2ccd] = 0x7eaa, [0x2cce] = 0x5609, [0x2ccf] = 0x67b7, [0x2cd0] = 0x5939,
  [0x2cd1] = 0x4f73, [0x2cd2] = 0x5bb6, [0x2cd3] = 0x52a0, [0x2cd4] = 0x835a,
  [0x2cd5] = 0x988a, [0x2cd6] = 0x8d3e, [0x2cd7] = 0x7532, [0x2cd8] = 0x94be,
  [0x2cd9] = 0x5047, [0x2cda] = 0x7a3c, [0x2cdb] = 0x4ef7, [0x2cdc] = 0x67b6,
  [0x2cdd] = 0x9a7e, [0x2cde] = 0x5ac1, [0x2cdf] = 0x6b7c, [0x2ce0] = 0x76d1,
  [0x2ce1] = 0x575a, [0x2ce2] = 0x5c16, [0x2ce3] = 0x7b3a, [0x2ce4] = 0x95f4,
  [0x2ce5] = 0x714e, [0x2ce6] = 0x517c, [0x2ce7] = 0x80a9, [0x2ce8] = 0x8270,
  [0x2ce9] = 0x5978, [0x2cea] = 0x7f04, [0x2ceb] = 0x8327, [0x2cec] = 0x68c0,
  [0x2ced] = 0x67ec, [0x2cee] = 0x78b1, [0x2cef] = 0x7877, [0x2cf0] = 0x62e3,
  [0x2cf1] = 0x6361, [0x2cf2] = 0x7b80, [0x2cf3] = 0x4fed, [0x2cf4] = 0x526a,
  [0x2cf5] = 0x51cf, [0x2cf6] = 0x8350, [0x2cf7] = 0x69db, [0x2cf8] = 0x9274,
  [0x2cf9] = 0x8df5, [0x2cfa] = 0x8d31, [0x2cfb] = 0x89c1, [0x2cfc] = 0x952e,
  [0x2cfd] = 0x7bad, [0x2cfe] = 0x4ef6, [0x2d00] = 0x7d37, [0x2d01] = 0x7d38,
  [0x2d02] = 0x7d39, [0x2d03] = 0x7d3a, [0x2d04] = 0x7d3b, [0x2d05] = 0x7d3c,
  [0x2d06] = 0x7d3d, [0x2d07] = 0x7d3e, [0x2d08] = 0x7d3f, [0x2d09] = 0x7d40,
  [0x2d0a] = 0x7d41, [0x2d0b] = 0x7d42, [0x2d0c] = 0x7d43, [0x2d0d] = 0x7d44,
  [0x2d0e] = 0x7d45, [0x2d0f] = 0x7d46, [0x2d10] = 0x7d47, [0x2d11] = 0x7d48,
  [0x2d12] = 0x7d49, [0x2d13] = 0x7d4a, [0x2d14] = 0x7d4b, [0x2d15] = 0x7d4c,
  [0x2d16] = 0x7d4d, [0x2d17] = 0x7d4e, [0x2d18] = 0x7d4f, [0x2d19] = 0x7d50,
  [0x2d1a] = 0x7d51, [0x2d1b] = 0x7d52, [0x2d1c] = 0x7d53, [0x2d1d] = 0x7d54,
  [0x2d1e] = 0x7d55, [0x2d1f] = 0x7d56, [0x2d20] = 0x7d57, [0x2d21] = 0x7d58,
  [0x2d22] = 0x7d59, [0x2d23] = 0x7d5a, [0x2d24] = 0x7d5b, [0x2d25] = 0x7d5c,
  [0x2d26] = 0x7d5d, [0x2d27] = 0x7d5e, [0x2d28] = 0x7d5f, [0x2d29] = 0x7d60,
  [0x2d2a] = 0x7d61, [0x2d2b] = 0x7d62, [0x2d2c] = 0x7d63, [0x2d2d] = 0x7d64,
  [0x2d2e] = 0x7d65, [0x2d2f] = 0x7d66, [0x2d30] = 0x7d67, [0x2d31] = 0x7d68,
  [0x2d32] = 0x7d69, [0x2d33] = 0x7d6a, [0x2d34] = 0x7d6b, [0x2d35] = 0x7d6c,
  [0x2d36] = 0x7d6d, [0x2d37] = 0x7d6f, [0x2d38] = 0x7d70, [0x2d39] = 0x7d71,
  [0x2d3a] = 0x7d72, [0x2d3b] = 0x7d73, [0x2d3c] = 0x7d74, [0x2d3d] = 0x7d75,
  [0x2d3e] = 0x7d76, [0x2d40] = 0x7d78, [0x2d41] = 0x7d79, [0x2d42] = 0x7d7a,
  [0x2d43] = 0x7d7b, [0x2d44] = 0x7d7c, [0x2d45] = 0x7d7d, [0x2d46] = 0x7d7e,
  [0x2d47] = 0x7d7f, [0x2d48] = 0x7d80, [0x2d49] = 0x7d81, [0x2d4a] = 0x7d82,
  [0x2d4b] = 0x7d83, [0x2d4c] = 0x7d84, [0x2d4d] = 0x7d85, [0x2d4e] = 0x7d86,
  [0x2d4f] = 0x7d87, [0x2d50] = 0x7d88, [0x2d51] = 0x7d89, [0x2d52] = 0x7d8a,
  [0x2d53] = 0x7d8b, [0x2d54] = 0x7d8c, [0x2d55] = 0x7d8d, [0x2d56] = 0x7d8e,
  [0x2d57] = 0x7d8f, [0x2d58] = 0x7d90, [0x2d59] = 0x7d91, [0x2d5a] = 0x7d92,
  [0x2d5b] = 0x7d93, [0x2d5c] = 0x7d94, [0x2d5d] = 0x7d95, [0x2d5e] = 0x7d96,
  [0x2d5f] = 0x7d97, [0x2d60] = 0x7d98, [0x2d61] = 0x5065, [0x2d62] = 0x8230,
  [0x2d63] = 0x5251, [0x2d64] = 0x996f, [0x2d65] = 0x6e10, [0x2d66] = 0x6e85,
  [0x2d67] = 0x6da7, [0x2d68] = 0x5efa, [0x2d69] = 0x50f5, [0x2d6a] = 0x59dc,
  [0x2d6b] = 0x5c06, [0x2d6c] = 0x6d46, [0x2d6d] = 0x6c5f, [0x2d6e] = 0x7586,
  [0x2d6f] = 0x848b, [0x2d70] = 0x6868, [0x2d71] = 0x5956, [0x2d72] = 0x8bb2,
  [0x2d73] = 0x5320, [0x2d74] = 0x9171, [0x2d75] = 0x964d, [0x2d76] = 0x8549,
  [0x2d77] = 0x6912, [0x2d78] = 0x7901, [0x2d79] = 0x7126, [0x2d7a] = 0x80f6,
  [0x2d7b] = 0x4ea4, [0x2d7c] = 0x90ca, [0x2d7d] = 0x6d47, [0x2d7e] = 0x9a84,
  [0x2d7f] = 0x5a07, [0x2d80] = 0x56bc, [0x2d81] = 0x6405, [0x2d82] = 0x94f0,
  [0x2d83] = 0x77eb, [0x2d84] = 0x4fa5, [0x2d85] = 0x811a, [0x2d86] = 0x72e1,
  [0x2d87] = 0x89d2, [0x2d88] = 0x997a, [0x2d89] = 0x7f34, [0x2d8a] = 0x7ede,
  [0x2d8b] = 0x527f, [0x2d8c] = 0x6559, [0x2d8d] = 0x9175, [0x2d8e] = 0x8f7f,
  [0x2d8f] = 0x8f83, [0x2d90] = 0x53eb, [0x2d91] = 0x7a96, [0x2d92] = 0x63ed,
  [0x2d93] = 0x63a5, [0x2d94] = 0x7686, [0x2d95] = 0x79f8, [0x2d96] = 0x8857,
  [0x2d97] = 0x9636, [0x2d98] = 0x622a, [0x2d99] = 0x52ab, [0x2d9a] = 0x8282,
  [0x2d9b] = 0x6854, [0x2d9c] = 0x6770, [0x2d9d] = 0x6377, [0x2d9e] = 0x776b,
  [0x2d9f] = 0x7aed, [0x2da0] = 0x6d01, [0x2da1] = 0x7ed3, [0x2da2] = 0x89e3,
  [0x2da3] = 0x59d0, [0x2da4] = 0x6212, [0x2da5] = 0x85c9, [0x2da6] = 0x82a5,
  [0x2da7] = 0x754c, [0x2da8] = 0x501f, [0x2da9] = 0x4ecb, [0x2daa] = 0x75a5,
  [0x2dab] = 0x8beb, [0x2dac] = 0x5c4a, [0x2dad] = 0x5dfe, [0x2dae] = 0x7b4b,
  [0x2daf] = 0x65a4, [0x2db0] = 0x91d1, [0x2db1] = 0x4eca, [0x2db2] = 0x6d25,
  [0x2db3] = 0x895f, [0x2db4] = 0x7d27, [0x2db5] = 0x9526, [0x2db6] = 0x4ec5,
  [0x2db7] = 0x8c28, [0x2db8] = 0x8fdb, [0x2db9] = 0x9773, [0x2dba] = 0x664b,
  [0x2dbb] = 0x7981, [0x2dbc] = 0x8fd1, [0x2dbd] = 0x70ec, [0x2dbe] = 0x6d78,
  [0x2dc0] = 0x7d99, [0x2dc1] = 0x7d9a, [0x2dc2] = 0x7d9b, [0x2dc3] = 0x7d9c,
  [0x2dc4] = 0x7d9d, [0x2dc5] = 0x7d9e, [0x2dc6] = 0x7d9f, [0x2dc7] = 0x7da0,
  [0x2dc8] = 0x7da1, [0x2dc9] = 0x7da2, [0x2dca] = 0x7da3, [0x2dcb] = 0x7da4,
  [0x2dcc] = 0x7da5, [0x2dcd] = 0x7da7, [0x2dce] = 0x7da8, [0x2dcf] = 0x7da9,
  [0x2dd0] = 0x7daa, [0x2dd1] = 0x7dab, [0x2dd2] = 0x7dac, [0x2dd3] = 0x7dad,
  [0x2dd4] = 0x7daf, [0x2dd5] = 0x7db0, [0x2dd6] = 0x7db1, [0x2dd7] = 0x7db2,
  [0x2dd8] = 0x7db3, [0x2dd9] = 0x7db4, [0x2dda] = 0x7db5, [0x2ddb] = 0x7db6,
  [0x2ddc] = 0x7db7, [0x2ddd] = 0x7db8, [0x2dde] = 0x7db9, [0x2ddf] = 0x7dba,
  [0x2de0] = 0x7dbb, [0x2de1] = 0x7dbc, [0x2de2] = 0x7dbd, [0x2de3] = 0x7dbe,
  [0x2de4] = 0x7dbf, [0x2de5] = 0x7dc0, [0x2de6] = 0x7dc1, [0x2de7] = 0x7dc2,
  [0x2de8] = 0x7dc3, [0x2de9] = 0x7dc4, [0x2dea] = 0x7dc5, [0x2deb] = 0x7dc6,
  [0x2dec] = 0x7dc7, [0x2ded] = 0x7dc8, [0x2dee] = 0x7dc9, [0x2def] = 0x7dca,
  [0x2df0] = 0x7dcb, [0x2df1] = 0x7dcc, [0x2df2] = 0x7dcd, [0x2df3] = 0x7dce,
  [0x2df4] = 0x7dcf, [0x2df5] = 0x7dd0, [0x2df6] = 0x7dd1, [0x2df7] = 0x7dd2,
  [0x2df8] = 0x7dd3, [0x2df9] = 0x7dd4, [0x2dfa] = 0x7dd5, [0x2dfb] = 0x7dd6,
  [0x2dfc] = 0x7dd7, [0x2dfd] = 0x7dd8, [0x2dfe] = 0x7dd9, [0x2e00] = 0x7dda,
  [0x2e01] = 0x7ddb, [0x2e02] = 0x7ddc, [0x2e03] = 0x7ddd, [0x2e04] = 0x7dde,
  [0x2e05] = 0x7ddf, [0x2e06] = 0x7de0, [0x2e07] = 0x7de1, [0x2e08] = 0x7de2,
  [0x2e09] = 0x7de3, [0x2e0a] = 0x7de4, [0x2e0b] = 0x7de5, [0x2e0c] = 0x7de6,
  [0x2e0d] = 0x7de7, [0x2e0e] = 0x7de8, [0x2e0f] = 0x7de9, [0x2e10] = 0x7dea,
  [0x2e11] = 0x7deb, [0x2e12] = 0x7dec, [0x2e13] = 0x7ded, [0x2e14] = 0x7dee,
  [0x2e15] = 0x7def, [0x2e16] = 0x7df0, [0x2e17] = 0x7df1, [0x2e18] = 0x7df2,
  [0x2e19] = 0x7df3, [0x2e1a] = 0x7df4, [0x2e1b] = 0x7df5, [0x2e1c] = 0x7df6,
  [0x2e1d] = 0x7df7, [0x2e1e] = 0x7df8, [0x2e1f] = 0x7df9, [0x2e20] = 0x7dfa,
  [0x2e21] = 0x5c3d, [0x2e22] = 0x52b2, [0x2e23] = 0x8346, [0x2e24] = 0x5162,
  [0x2e25] = 0x830e, [0x2e26] = 0x775b, [0x2e27] = 0x6676, [0x2e28] = 0x9cb8,
  [0x2e29] = 0x4eac, [0x2e2a] = 0x60ca, [0x2e2b] = 0x7cbe, [0x2e2c] = 0x7cb3,
  [0x2e2d] = 0x7ecf, [0x2e2e] = 0x4e95, [0x2e2f] = 0x8b66, [0x2e30] = 0x666f,
  [0x2e31] = 0x9888, [0x2e32] = 0x9759, [0x2e33] = 0x5883, [0x2e34] = 0x656c,
  [0x2e35] = 0x955c, [0x2e36] = 0x5f84, [0x2e37] = 0x75c9, [0x2e38] = 0x9756,
  [0x2e39] = 0x7adf, [0x2e3a] = 0x7ade, [0x2e3b] = 0x51c0, [0x2e3c] = 0x70af,
  [0x2e3d] = 0x7a98, [0x2e3e] = 0x63ea, [0x2e3f] = 0x7a76, [0x2e40] = 0x7ea0,
  [0x2e41] = 0x7396, [0x2e42] = 0x97ed, [0x2e43] = 0x4e45, [0x2e44] = 0x7078,
  [0x2e45] = 0x4e5d, [0x2e46] = 0x9152, [0x2e47] = 0x53a9, [0x2e48] = 0x6551,
  [0x2e49] = 0x65e7, [0x2e4a] = 0x81fc, [0x2e4b] = 0x8205, [0x2e4c] = 0x548e,
  [0x2e4d] = 0x5c31, [0x2e4e] = 0x759a, [0x2e4f] = 0x97a0, [0x2e50] = 0x62d8,
  [0x2e51] = 0x72d9, [0x2e52] = 0x75bd, [0x2e53] = 0x5c45, [0x2e54] = 0x9a79,
  [0x2e55] = 0x83ca, [0x2e56] = 0x5c40, [0x2e57] = 0x5480, [0x2e58] = 0x77e9,
  [0x2e59] = 0x4e3e, [0x2e5a] = 0x6cae, [0x2e5b] = 0x805a, [0x2e5c] = 0x62d2,
  [0x2e5d] = 0x636e, [0x2e5e] = 0x5de8, [0x2e5f] = 0x5177, [0x2e60] = 0x8ddd,
  [0x2e61] = 0x8e1e, [0x2e62] = 0x952f, [0x2e63] = 0x4ff1, [0x2e64] = 0x53e5,
  [0x2e65] = 0x60e7, [0x2e66] = 0x70ac, [0x2e67] = 0x5267, [0x2e68] = 0x6350,
  [0x2e69] = 0x9e43, [0x2e6a] = 0x5a1f, [0x2e6b] = 0x5026, [0x2e6c] = 0x7737,
  [0x2e6d] = 0x5377, [0x2e6e] = 0x7ee2, [0x2e6f] = 0x6485, [0x2e70] = 0x652b,
  [0x2e71] = 0x6289, [0x2e72] = 0x6398, [0x2e73] = 0x5014, [0x2e74] = 0x7235,
  [0x2e75] = 0x89c9, [0x2e76] = 0x51b3, [0x2e77] = 0x8bc0, [0x2e78] = 0x7edd,
  [0x2e79] = 0x5747, [0x2e7a] = 0x83cc, [0x2e7b] = 0x94a7, [0x2e7c] = 0x519b,
  [0x2e7d] = 0x541b, [0x2e7e] = 0x5cfb, [0x2e80] = 0x7dfb, [0x2e81] = 0x7dfc,
  [0x2e82] = 0x7dfd, [0x2e83] = 0x7dfe, [0x2e84] = 0x7dff, [0x2e85] = 0x7e00,
  [0x2e86] = 0x7e01, [0x2e87] = 0x7e02, [0x2e88] = 0x7e03, [0x2e89] = 0x7e04,
  [0x2e8a] = 0x7e05, [0x2e8b] = 0x7e06, [0x2e8c] = 0x7e07, [0x2e8d] = 0x7e08,
  [0x2e8e] = 0x7e09, [0x2e8f] = 0x7e0a, [0x2e90] = 0x7e0b, [0x2e91] = 0x7e0c,
  [0x2e92] = 0x7e0d, [0x2e93] = 0x7e0e, [0x2e94] = 0x7e0f, [0x2e95] = 0x7e10,
  [0x2e96] = 0x7e11, [0x2e97] = 0x7e12, [0x2e98] = 0x7e13, [0x2e99] = 0x7e14,
  [0x2e9a] = 0x7e15, [0x2e9b] = 0x7e16, [0x2e9c] = 0x7e17, [0x2e9d] = 0x7e18,
  [0x2e9e] = 0x7e19, [0x2e9f] = 0x7e1a, [0x2ea0] = 0x7e1b, [0x2ea1] = 0x7e1c,
  [0x2ea2] = 0x7e1d, [0x2ea3] = 0x7e1e, [0x2ea4] = 0x7e1f, [0x2ea5] = 0x7e20,
  [0x2ea6] = 0x7e21, [0x2ea7] = 0x7e22, [0x2ea8] = 0x7e23, [0x2ea9] = 0x7e24,
  [0x2eaa] = 0x7e25, [0x2eab] = 0x7e26, [0x2eac] = 0x7e27, [0x2ead] = 0x7e28,
  [0x2eae] = 0x7e29, [0x2eaf] = 0x7e2a, [0x2eb0] = 0x7e2b, [0x2eb1] = 0x7e2c,
  [0x2eb2] = 0x7e2d, [0x2eb3] = 0x7e2e, [0x2eb4] = 0x7e2f, [0x2eb5] = 0x7e30,
  [0x2eb6] = 0x7e31, [0x2eb7] = 0x7e32, [0x2eb8] = 0x7e33, [0x2eb9] = 0x7e34,
  [0x2eba] = 0x7e35, [0x2ebb] = 0x7e36, [0x2ebc] = 0x7e37, [0x2ebd] = 0x7e38,
  [0x2ebe] = 0x7e39, [0x2ec0] = 0x7e3a, [0x2ec1] = 0x7e3c, [0x2ec2] = 0x7e3d,
  [0x2ec3] = 0x7e3e, [0x2ec4] = 0x7e3f, [0x2ec5] = 0x7e40, [0x2ec6] = 0x7e42,
  [0x2ec7] = 0x7e43, [0x2ec8] = 0x7e44, [0x2ec9] = 0x7e45, [0x2eca] = 0x7e46,
  [0x2ecb] = 0x7e48, [0x2ecc] = 0x7e49, [0x2ecd] = 0x7e4a, [0x2ece] = 0x7e4b,
  [0x2ecf] = 0x7e4c, [0x2ed0] = 0x7e4d, [0x2ed1] = 0x7e4e, [0x2ed2] = 0x7e4f,
  [0x2ed3] = 0x7e50, [0x2ed4] = 0x7e51, [0x2ed5] = 0x7e52, [0x2ed6] = 0x7e53,
  [0x2ed7] = 0x7e54, [0x2ed8] = 0x7e55, [0x2ed9] = 0x7e56, [0x2eda] = 0x7e57,
  [0x2edb] = 0x7e58, [0x2edc] = 0x7e59, [0x2edd] = 0x7e5a, [0x2ede] = 0x7e5b,
  [0x2edf] = 0x7e5c, [0x2ee0] = 0x7e5d, [0x2ee1] = 0x4fca, [0x2ee2] = 0x7ae3,
  [0x2ee3] = 0x6d5a, [0x2ee4] = 0x90e1, [0x2ee5] = 0x9a8f, [0x2ee6] = 0x5580,
  [0x2ee7] = 0x5496, [0x2ee8] = 0x5361, [0x2ee9] = 0x54af, [0x2eea] = 0x5f00,
  [0x2eeb] = 0x63e9, [0x2eec] = 0x6977, [0x2eed] = 0x51ef, [0x2eee] = 0x6168,
  [0x2eef] = 0x520a, [0x2ef0] = 0x582a, [0x2ef1] = 0x52d8, [0x2ef2] = 0x574e,
  [0x2ef3] = 0x780d, [0x2ef4] = 0x770b, [0x2ef5] = 0x5eb7, [0x2ef6] = 0x6177,
  [0x2ef7] = 0x7ce0, [0x2ef8] = 0x625b, [0x2ef9] = 0x6297, [0x2efa] = 0x4ea2,
  [0x2efb] = 0x7095, [0x2efc] = 0x8003, [0x2efd] = 0x62f7, [0x2efe] = 0x70e4,
  [0x2eff] = 0x9760, [0x2f00] = 0x5777, [0x2f01] = 0x82db, [0x2f02] = 0x67ef,
  [0x2f03] = 0x68f5, [0x2f04] = 0x78d5, [0x2f05] = 0x9897, [0x2f06] = 0x79d1,
  [0x2f07] = 0x58f3, [0x2f08] = 0x54b3, [0x2f09] = 0x53ef, [0x2f0a] = 0x6e34,
  [0x2f0b] = 0x514b, [0x2f0c] = 0x523b, [0x2f0d] = 0x5ba2, [0x2f0e] = 0x8bfe,
  [0x2f0f] = 0x80af, [0x2f10] = 0x5543, [0x2f11] = 0x57a6, [0x2f12] = 0x6073,
  [0x2f13] = 0x5751, [0x2f14] = 0x542d, [0x2f15] = 0x7a7a, [0x2f16] = 0x6050,
  [0x2f17] = 0x5b54, [0x2f18] = 0x63a7, [0x2f19] = 0x62a0, [0x2f1a] = 0x53e3,
  [0x2f1b] = 0x6263, [0x2f1c] = 0x5bc7, [0x2f1d] = 0x67af, [0x2f1e] = 0x54ed,
  [0x2f1f] = 0x7a9f, [0x2f20] = 0x82e6, [0x2f21] = 0x9177, [0x2f22] = 0x5e93,
  [0x2f23] = 0x88e4, [0x2f24] = 0x5938, [0x2f25] = 0x57ae, [0x2f26] = 0x630e,
  [0x2f27] = 0x8de8, [0x2f28] = 0x80ef, [0x2f29] = 0x5757, [0x2f2a] = 0x7b77,
  [0x2f2b] = 0x4fa9, [0x2f2c] = 0x5feb, [0x2f2d] = 0x5bbd, [0x2f2e] = 0x6b3e,
  [0x2f2f] = 0x5321, [0x2f30] = 0x7b50, [0x2f31] = 0x72c2, [0x2f32] = 0x6846,
  [0x2f33] = 0x77ff, [0x2f34] = 0x7736, [0x2f35] = 0x65f7, [0x2f36] = 0x51b5,
  [0x2f37] = 0x4e8f, [0x2f38] = 0x76d4, [0x2f39] = 0x5cbf, [0x2f3a] = 0x7aa5,
  [0x2f3b] = 0x8475, [0x2f3c] = 0x594e, [0x2f3d] = 0x9b41, [0x2f3e] = 0x5080,
  [0x2f40] = 0x7e5e, [0x2f41] = 0x7e5f, [0x2f42] = 0x7e60, [0x2f43] = 0x7e61,
  [0x2f44] = 0x7e62, [0x2f45] = 0x7e63, [0x2f46] = 0x7e64, [0x2f47] = 0x7e65,
  [0x2f48] = 0x7e66, [0x2f49] = 0x7e67, [0x2f4a] = 0x7e68, [0x2f4b] = 0x7e69,
  [0x2f4c] = 0x7e6a, [0x2f4d] = 0x7e6b, [0x2f4e] = 0x7e6c, [0x2f4f] = 0x7e6d,
  [0x2f50] = 0x7e6e, [0x2f51] = 0x7e6f, [0x2f52] = 0x7e70, [0x2f53] = 0x7e71,
  [0x2f54] = 0x7e72, [0x2f55] = 0x7e73, [0x2f56] = 0x7e74, [0x2f57] = 0x7e75,
  [0x2f58] = 0x7e76, [0x2f59] = 0x7e77, [0x2f5a] = 0x7e78, [0x2f5b] = 0x7e79,
  [0x2f5c] = 0x7e7a, [0x2f5d] = 0x7e7b, [0x2f5e] = 0x7e7c, [0x2f5f] = 0x7e7d,
  [0x2f60] = 0x7e7e, [0x2f61] = 0x7e7f, [0x2f62] = 0x7e80, [0x2f63] = 0x7e81,
  [0x2f64] = 0x7e83, [0x2f65] = 0x7e84, [0x2f66] = 0x7e85, [0x2f67] = 0x7e86,
  [0x2f68] = 0x7e87, [0x2f69] = 0x7e88, [0x2f6a] = 0x7e89, [0x2f6b] = 0x7e8a,
  [0x2f6c] = 0x7e8b, [0x2f6d] = 0x7e8c, [0x2f6e] = 0x7e8d, [0x2f6f] = 0x7e8e,
  [0x2f70] = 0x7e8f, [0x2f71] = 0x7e90, [0x2f72] = 0x7e91, [0x2f73] = 0x7e92,
  [0x2f74] = 0x7e93, [0x2f75] = 0x7e94, [0x2f76] = 0x7e95, [0x2f77] = 0x7e96,
  [0x2f78] = 0x7e97, [0x2f79] = 0x7e98, [0x2f7a] = 0x7e99, [0x2f7b] = 0x7e9a,
  [0x2f7c] = 0x7e9c, [0x2f7d] = 0x7e9d, [0x2f7e] = 0x7e9e, [0x2f80] = 0x7eae,
  [0x2f81] = 0x7eb4, [0x2f82] = 0x7ebb, [0x2f83] = 0x7ebc, [0x2f84] = 0x7ed6,
  [0x2f85] = 0x7ee4, [0x2f86] = 0x7eec, [0x2f87] = 0x7ef9, [0x2f88] = 0x7f0a,
  [0x2f89] = 0x7f10, [0x2f8a] = 0x7f1e, [0x2f8b] = 0x7f37, [0x2f8c] = 0x7f39,
  [0x2f8d] = 0x7f3b, [0x2f8e] = 0x7f3c, [0x2f8f] = 0x7f3d, [0x2f90] = 0x7f3e,
  [0x2f91] = 0x7f3f, [0x2f92] = 0x7f40, [0x2f93] = 0x7f41, [0x2f94] = 0x7f43,
  [0x2f95] = 0x7f46, [0x2f96] = 0x7f47, [0x2f97] = 0x7f48, [0x2f98] = 0x7f49,
  [0x2f99] = 0x7f4a, [0x2f9a] = 0x7f4b, [0x2f9b] = 0x7f4c, [0x2f9c] = 0x7f4d,
  [0x2f9d] = 0x7f4e, [0x2f9e] = 0x7f4f, [0x2f9f] = 0x7f52, [0x2fa0] = 0x7f53,
  [0x2fa1] = 0x9988, [0x2fa2] = 0x6127, [0x2fa3] = 0x6e83, [0x2fa4] = 0x5764,
  [0x2fa5] = 0x6606, [0x2fa6] = 0x6346, [0x2fa7] = 0x56f0, [0x2fa8] = 0x62ec,
  [0x2fa9] = 0x6269, [0x2faa] = 0x5ed3, [0x2fab] = 0x9614, [0x2fac] = 0x5783,
  [0x2fad] = 0x62c9, [0x2fae] = 0x5587, [0x2faf] = 0x8721, [0x2fb0] = 0x814a,
  [0x2fb1] = 0x8fa3, [0x2fb2] = 0x5566, [0x2fb3] = 0x83b1, [0x2fb4] = 0x6765,
  [0x2fb5] = 0x8d56, [0x2fb6] = 0x84dd, [0x2fb7] = 0x5a6a, [0x2fb8] = 0x680f,
  [0x2fb9] = 0x62e6, [0x2fba] = 0x7bee, [0x2fbb] = 0x9611, [0x2fbc] = 0x5170,
  [0x2fbd] = 0x6f9c, [0x2fbe] = 0x8c30, [0x2fbf] = 0x63fd, [0x2fc0] = 0x89c8,
  [0x2fc1] = 0x61d2, [0x2fc2] = 0x7f06, [0x2fc3] = 0x70c2, [0x2fc4] = 0x6ee5,
  [0x2fc5] = 0x7405, [0x2fc6] = 0x6994, [0x2fc7] = 0x72fc, [0x2fc8] = 0x5eca,
  [0x2fc9] = 0x90ce, [0x2fca] = 0x6717, [0x2fcb] = 0x6d6a, [0x2fcc] = 0x635e,
  [0x2fcd] = 0x52b3, [0x2fce] = 0x7262, [0x2fcf] = 0x8001, [0x2fd0] = 0x4f6c,
  [0x2fd1] = 0x59e5, [0x2fd2] = 0x916a, [0x2fd3] = 0x70d9, [0x2fd4] = 0x6d9d,
  [0x2fd5] = 0x52d2, [0x2fd6] = 0x4e50, [0x2fd7] = 0x96f7, [0x2fd8] = 0x956d,
  [0x2fd9] = 0x857e, [0x2fda] = 0x78ca, [0x2fdb] = 0x7d2f, [0x2fdc] = 0x5121,
  [0x2fdd] = 0x5792, [0x2fde] = 0x64c2, [0x2fdf] = 0x808b, [0x2fe0] = 0x7c7b,
  [0x2fe1] = 0x6cea, [0x2fe2] = 0x68f1, [0x2fe3] = 0x695e, [0x2fe4] = 0x51b7,
  [0x2fe5] = 0x5398, [0x2fe6] = 0x68a8, [0x2fe7] = 0x7281, [0x2fe8] = 0x9ece,
  [0x2fe9] = 0x7bf1, [0x2fea] = 0x72f8, [0x2feb] = 0x79bb, [0x2fec] = 0x6f13,
  [0x2fed] = 0x7406, [0x2fee] = 0x674e, [0x2fef] = 0x91cc, [0x2ff0] = 0x9ca4,
  [0x2ff1] = 0x793c, [0x2ff2] = 0x8389, [0x2ff3] = 0x8354, [0x2ff4] = 0x540f,
  [0x2ff5] = 0x6817, [0x2ff6] = 0x4e3d, [0x2ff7] = 0x5389, [0x2ff8] = 0x52b1,
  [0x2ff9] = 0x783e, [0x2ffa] = 0x5386, [0x2ffb] = 0x5229, [0x2ffc] = 0x5088,
  [0x2ffd] = 0x4f8b, [0x2ffe] = 0x4fd0, [0x3000] = 0x7f56, [0x3001] = 0x7f59,
  [0x3002] = 0x7f5b, [0x3003] = 0x7f5c, [0x3004] = 0x7f5d, [0x3005] = 0x7f5e,
  [0x3006] = 0x7f60, [0x3007] = 0x7f63, [0x3008] = 0x7f64, [0x3009] = 0x7f65,
  [0x300a] = 0x7f66, [0x300b] = 0x7f67, [0x300c] = 0x7f6b, [0x300d] = 0x7f6c,
  [0x300e] = 0x7f6d, [0x300f] = 0x7f6f, [0x3010] = 0x7f70, [0x3011] = 0x7f73,
  [0x3012] = 0x7f75, [0x3013] = 0x7f76, [0x3014] = 0x7f77, [0x3015] = 0x7f78,
  [0x3016] = 0x7f7a, [0x3017] = 0x7f7b, [0x3018] = 0x7f7c, [0x3019] = 0x7f7d,
  [0x301a] = 0x7f7f, [0x301b] = 0x7f80, [0x301c] = 0x7f82, [0x301d] = 0x7f83,
  [0x301e] = 0x7f84, [0x301f] = 0x7f85, [0x3020] = 0x7f86, [0x3021] = 0x7f87,
  [0x3022] = 0x7f88, [0x3023] = 0x7f89, [0x3024] = 0x7f8b, [0x3025] = 0x7f8d,
  [0x3026] = 0x7f8f, [0x3027] = 0x7f90, [0x3028] = 0x7f91, [0x3029] = 0x7f92,
  [0x302a] = 0x7f93, [0x302b] = 0x7f95, [0x302c] = 0x7f96, [0x302d] = 0x7f97,
  [0x302e] = 0x7f98, [0x302f] = 0x7f99, [0x3030] = 0x7f9b, [0x3031] = 0x7f9c,
  [0x3032] = 0x7fa0, [0x3033] = 0x7fa2, [0x3034] = 0x7fa3, [0x3035] = 0x7fa5,
  [0x3036] = 0x7fa6, [0x3037] = 0x7fa8, [0x3038] = 0x7fa9, [0x3039] = 0x7faa,
  [0x303a] = 0x7fab, [0x303b] = 0x7fac, [0x303c] = 0x7fad, [0x303d] = 0x7fae,
  [0x303e] = 0x7fb1, [0x3040] = 0x7fb3, [0x3041] = 0x7fb4, [0x3042] = 0x7fb5,
  [0x3043] = 0x7fb6, [0x3044] = 0x7fb7, [0x3045] = 0x7fba, [0x3046] = 0x7fbb,
  [0x3047] = 0x7fbe, [0x3048] = 0x7fc0, [0x3049] = 0x7fc2, [0x304a] = 0x7fc3,
  [0x304b] = 0x7fc4, [0x304c] = 0x7fc6, [0x304d] = 0x7fc7, [0x304e] = 0x7fc8,
  [0x304f] = 0x7fc9, [0x3050] = 0x7fcb, [0x3051] = 0x7fcd, [0x3052] = 0x7fcf,
  [0x3053] = 0x7fd0, [0x3054] = 0x7fd1, [0x3055] = 0x7fd2, [0x3056] = 0x7fd3,
  [0x3057] = 0x7fd6, [0x3058] = 0x7fd7, [0x3059] = 0x7fd9, [0x305a] = 0x7fda,
  [0x305b] = 0x7fdb, [0x305c] = 0x7fdc, [0x305d] = 0x7fdd, [0x305e] = 0x7fde,
  [0x305f] = 0x7fe2, [0x3060] = 0x7fe3, [0x3061] = 0x75e2, [0x3062] = 0x7acb,
  [0x3063] = 0x7c92, [0x3064] = 0x6ca5, [0x3065] = 0x96b6, [0x3066] = 0x529b,
  [0x3067] = 0x7483, [0x3068] = 0x54e9, [0x3069] = 0x4fe9, [0x306a] = 0x8054,
  [0x306b] = 0x83b2, [0x306c] = 0x8fde, [0x306d] = 0x9570, [0x306e] = 0x5ec9,
  [0x306f] = 0x601c, [0x3070] = 0x6d9f, [0x3071] = 0x5e18, [0x3072] = 0x655b,
  [0x3073] = 0x8138, [0x3074] = 0x94fe, [0x3075] = 0x604b, [0x3076] = 0x70bc,
  [0x3077] = 0x7ec3, [0x3078] = 0x7cae, [0x3079] = 0x51c9, [0x307a] = 0x6881,
  [0x307b] = 0x7cb1, [0x307c] = 0x826f, [0x307d] = 0x4e24, [0x307e] = 0x8f86,
  [0x307f] = 0x91cf, [0x3080] = 0x667e, [0x3081] = 0x4eae, [0x3082] = 0x8c05,
  [0x3083] = 0x64a9, [0x3084] = 0x804a, [0x3085] = 0x50da, [0x3086] = 0x7597,
  [0x3087] = 0x71ce, [0x3088] = 0x5be5, [0x3089] = 0x8fbd, [0x308a] = 0x6f66,
  [0x308b] = 0x4e86, [0x308c] = 0x6482, [0x308d] = 0x9563, [0x308e] = 0x5ed6,
  [0x308f] = 0x6599, [0x3090] = 0x5217, [0x3091] = 0x88c2, [0x3092] = 0x70c8,
  [0x3093] = 0x52a3, [0x3094] = 0x730e, [0x3095] = 0x7433, [0x3096] = 0x6797,
  [0x3097] = 0x78f7, [0x3098] = 0x9716, [0x3099] = 0x4e34, [0x309a] = 0x90bb,
  [0x309b] = 0x9cde, [0x309c] = 0x6dcb, [0x309d] = 0x51db, [0x309e] = 0x8d41,
  [0x309f] = 0x541d, [0x30a0] = 0x62ce, [0x30a1] = 0x73b2, [0x30a2] = 0x83f1,
  [0x30a3] = 0x96f6, [0x30a4] = 0x9f84, [0x30a5] = 0x94c3, [0x30a6] = 0x4f36,
  [0x30a7] = 0x7f9a, [0x30a8] = 0x51cc, [0x30a9] = 0x7075, [0x30aa] = 0x9675,
  [0x30ab] = 0x5cad, [0x30ac] = 0x9886, [0x30ad] = 0x53e6, [0x30ae] = 0x4ee4,
  [0x30af] = 0x6e9c, [0x30b0] = 0x7409, [0x30b1] = 0x69b4, [0x30b2] = 0x786b,
  [0x30b3] = 0x998f, [0x30b4] = 0x7559, [0x30b5] = 0x5218, [0x30b6] = 0x7624,
  [0x30b7] = 0x6d41, [0x30b8] = 0x67f3, [0x30b9] = 0x516d, [0x30ba] = 0x9f99,
  [0x30bb] = 0x804b, [0x30bc] = 0x5499, [0x30bd] = 0x7b3c, [0x30be] = 0x7abf,
  [0x30c0] = 0x7fe4, [0x30c1] = 0x7fe7, [0x30c2] = 0x7fe8, [0x30c3] = 0x7fea,
  [0x30c4] = 0x7feb, [0x30c5] = 0x7fec, [0x30c6] = 0x7fed, [0x30c7] = 0x7fef,
  [0x30c8] = 0x7ff2, [0x30c9] = 0x7ff4, [0x30ca] = 0x7ff5, [0x30cb] = 0x7ff6,
  [0x30cc] = 0x7ff7, [0x30cd] = 0x7ff8, [0x30ce] = 0x7ff9, [0x30cf] = 0x7ffa,
  [0x30d0] = 0x7ffd, [0x30d1] = 0x7ffe, [0x30d2] = 0x7fff, [0x30d3] = 0x8002,
  [0x30d4] = 0x8007, [0x30d5] = 0x8008, [0x30d6] = 0x8009, [0x30d7] = 0x800a,
  [0x30d8] = 0x800e, [0x30d9] = 0x800f, [0x30da] = 0x8011, [0x30db] = 0x8013,
  [0x30dc] = 0x801a, [0x30dd] = 0x801b, [0x30de] = 0x801d, [0x30df] = 0x801e,
  [0x30e0] = 0x801f, [0x30e1] = 0x8021, [0x30e2] = 0x8023, [0x30e3] = 0x8024,
  [0x30e4] = 0x802b, [0x30e5] = 0x802c, [0x30e6] = 0x802d, [0x30e7] = 0x802e,
  [0x30e8] = 0x802f, [0x30e9] = 0x8030, [0x30ea] = 0x8032, [0x30eb] = 0x8034,
  [0x30ec] = 0x8039, [0x30ed] = 0x803a, [0x30ee] = 0x803c, [0x30ef] = 0x803e,
  [0x30f0] = 0x8040, [0x30f1] = 0x8041, [0x30f2] = 0x8044, [0x30f3] = 0x8045,
  [0x30f4] = 0x8047, [0x30f5] = 0x8048, [0x30f6] = 0x8049, [0x30f7] = 0x804e,
  [0x30f8] = 0x804f, [0x30f9] = 0x8050, [0x30fa] = 0x8051, [0x30fb] = 0x8053,
  [0x30fc] = 0x8055, [0x30fd] = 0x8056, [0x30fe] = 0x8057, [0x3100] = 0x8059,
  [0x3101] = 0x805b, [0x3102] = 0x805c, [0x3103] = 0x805d, [0x3104] = 0x805e,
  [0x3105] = 0x805f, [0x3106] = 0x8060, [0x3107] = 0x8061, [0x3108] = 0x8062,
  [0x3109] = 0x8063, [0x310a] = 0x8064, [0x310b] = 0x8065, [0x310c] = 0x8066,
  [0x310d] = 0x8067, [0x310e] = 0x8068, [0x310f] = 0x806b, [0x3110] = 0x806c,
  [0x3111] = 0x806d, [0x3112] = 0x806e, [0x3113] = 0x806f, [0x3114] = 0x8070,
  [0x3115] = 0x8072, [0x3116] = 0x8073, [0x3117] = 0x8074, [0x3118] = 0x8075,
  [0x3119] = 0x8076, [0x311a] = 0x8077, [0x311b] = 0x8078, [0x311c] = 0x8079,
  [0x311d] = 0x807a, [0x311e] = 0x807b, [0x311f] = 0x807c, [0x3120] = 0x807d,
  [0x3121] = 0x9686, [0x3122] = 0x5784, [0x3123] = 0x62e2, [0x3124] = 0x9647,
  [0x3125] = 0x697c, [0x3126] = 0x5a04, [0x3127] = 0x6402, [0x3128] = 0x7bd3,
  [0x3129] = 0x6f0f, [0x312a] = 0x964b, [0x312b] = 0x82a6, [0x312c] = 0x5362,
  [0x312d] = 0x9885, [0x312e] = 0x5e90, [0x312f] = 0x7089, [0x3130] = 0x63b3,
  [0x3131] = 0x5364, [0x3132] = 0x864f, [0x3133] = 0x9c81, [0x3134] = 0x9e93,
  [0x3135] = 0x788c, [0x3136] = 0x9732, [0x3137] = 0x8def, [0x3138] = 0x8d42,
  [0x3139] = 0x9e7f, [0x313a] = 0x6f5e, [0x313b] = 0x7984, [0x313c] = 0x5f55,
  [0x313d] = 0x9646, [0x313e] = 0x622e, [0x313f] = 0x9a74, [0x3140] = 0x5415,
  [0x3141] = 0x94dd, [0x3142] = 0x4fa3, [0x3143] = 0x65c5, [0x3144] = 0x5c65,
  [0x3145] = 0x5c61, [0x3146] = 0x7f15, [0x3147] = 0x8651, [0x3148] = 0x6c2f,
  [0x3149] = 0x5f8b, [0x314a] = 0x7387, [0x314b] = 0x6ee4, [0x314c] = 0x7eff,
  [0x314d] = 0x5ce6, [0x314e] = 0x631b, [0x314f] = 0x5b6a, [0x3150] = 0x6ee6,
  [0x3151] = 0x5375, [0x3152] = 0x4e71, [0x3153] = 0x63a0, [0x3154] = 0x7565,
  [0x3155] = 0x62a1, [0x3156] = 0x8f6e, [0x3157] = 0x4f26, [0x3158] = 0x4ed1,
  [0x3159] = 0x6ca6, [0x315a] = 0x7eb6, [0x315b] = 0x8bba, [0x315c] = 0x841d,
  [0x315d] = 0x87ba, [0x315e] = 0x7f57, [0x315f] = 0x903b, [0x3160] = 0x9523,
  [0x3161] = 0x7ba9, [0x3162] = 0x9aa1, [0x3163] = 0x88f8, [0x3164] = 0x843d,
  [0x3165] = 0x6d1b, [0x3166] = 0x9a86, [0x3167] = 0x7edc, [0x3168] = 0x5988,
  [0x3169] = 0x9ebb, [0x316a] = 0x739b, [0x316b] = 0x7801, [0x316c] = 0x8682,
  [0x316d] = 0x9a6c, [0x316e] = 0x9a82, [0x316f] = 0x561b, [0x3170] = 0x5417,
  [0x3171] = 0x57cb, [0x3172] = 0x4e70, [0x3173] = 0x9ea6, [0x3174] = 0x5356,
  [0x3175] = 0x8fc8, [0x3176] = 0x8109, [0x3177] = 0x7792, [0x3178] = 0x9992,
  [0x3179] = 0x86ee, [0x317a] = 0x6ee1, [0x317b] = 0x8513, [0x317c] = 0x66fc,
  [0x317d] = 0x6162, [0x317e] = 0x6f2b, [0x3180] = 0x807e, [0x3181] = 0x8081,
  [0x3182] = 0x8082, [0x3183] = 0x8085, [0x3184] = 0x8088, [0x3185] = 0x808a,
  [0x3186] = 0x808d, [0x3187] = 0x808e, [0x3188] = 0x808f, [0x3189] = 0x8090,
  [0x318a] = 0x8091, [0x318b] = 0x8092, [0x318c] = 0x8094, [0x318d] = 0x8095,
  [0x318e] = 0x8097, [0x318f] = 0x8099, [0x3190] = 0x809e, [0x3191] = 0x80a3,
  [0x3192] = 0x80a6, [0x3193] = 0x80a7, [0x3194] = 0x80a8, [0x3195] = 0x80ac,
  [0x3196] = 0x80b0, [0x3197] = 0x80b3, [0x3198] = 0x80b5, [0x3199] = 0x80b6,
  [0x319a] = 0x80b8, [0x319b] = 0x80b9, [0x319c] = 0x80bb, [0x319d] = 0x80c5,
  [0x319e] = 0x80c7, [0x319f] = 0x80c8, [0x31a0] = 0x80c9, [0x31a1] = 0x80ca,
  [0x31a2] = 0x80cb, [0x31a3] = 0x80cf, [0x31a4] = 0x80d0, [0x31a5] = 0x80d1,
  [0x31a6] = 0x80d2, [0x31a7] = 0x80d3, [0x31a8] = 0x80d4, [0x31a9] = 0x80d5,
  [0x31aa] = 0x80d8, [0x31ab] = 0x80df, [0x31ac] = 0x80e0, [0x31ad] = 0x80e2,
  [0x31ae] = 0x80e3, [0x31af] = 0x80e6, [0x31b0] = 0x80ee, [0x31b1] = 0x80f5,
  [0x31b2] = 0x80f7, [0x31b3] = 0x80f9, [0x31b4] = 0x80fb, [0x31b5] = 0x80fe,
  [0x31b6] = 0x80ff, [0x31b7] = 0x8100, [0x31b8] = 0x8101, [0x31b9] = 0x8103,
  [0x31ba] = 0x8104, [0x31bb] = 0x8105, [0x31bc] = 0x8107, [0x31bd] = 0x8108,
  [0x31be] = 0x810b, [0x31c0] = 0x810c, [0x31c1] = 0x8115, [0x31c2] = 0x8117,
  [0x31c3] = 0x8119, [0x31c4] = 0x811b, [0x31c5] = 0x811c, [0x31c6] = 0x811d,
  [0x31c7] = 0x811f, [0x31c8] = 0x8120, [0x31c9] = 0x8121, [0x31ca] = 0x8122,
  [0x31cb] = 0x8123, [0x31cc] = 0x8124, [0x31cd] = 0x8125, [0x31ce] = 0x8126,
  [0x31cf] = 0x8127, [0x31d0] = 0x8128, [0x31d1] = 0x8129, [0x31d2] = 0x812a,
  [0x31d3] = 0x812b, [0x31d4] = 0x812d, [0x31d5] = 0x812e, [0x31d6] = 0x8130,
  [0x31d7] = 0x8133, [0x31d8] = 0x8134, [0x31d9] = 0x8135, [0x31da] = 0x8137,
  [0x31db] = 0x8139, [0x31dc] = 0x813a, [0x31dd] = 0x813b, [0x31de] = 0x813c,
  [0x31df] = 0x813d, [0x31e0] = 0x813f, [0x31e1] = 0x8c29, [0x31e2] = 0x8292,
  [0x31e3] = 0x832b, [0x31e4] = 0x76f2, [0x31e5] = 0x6c13, [0x31e6] = 0x5fd9,
  [0x31e7] = 0x83bd, [0x31e8] = 0x732b, [0x31e9] = 0x8305, [0x31ea] = 0x951a,
  [0x31eb] = 0x6bdb, [0x31ec] = 0x77db, [0x31ed] = 0x94c6, [0x31ee] = 0x536f,
  [0x31ef] = 0x8302, [0x31f0] = 0x5192, [0x31f1] = 0x5e3d, [0x31f2] = 0x8c8c,
  [0x31f3] = 0x8d38, [0x31f4] = 0x4e48, [0x31f5] = 0x73ab, [0x31f6] = 0x679a,
  [0x31f7] = 0x6885, [0x31f8] = 0x9176, [0x31f9] = 0x9709, [0x31fa] = 0x7164,
  [0x31fb] = 0x6ca1, [0x31fc] = 0x7709, [0x31fd] = 0x5a92, [0x31fe] = 0x9541,
  [0x31ff] = 0x6bcf, [0x3200] = 0x7f8e, [0x3201] = 0x6627, [0x3202] = 0x5bd0,
  [0x3203] = 0x59b9, [0x3204] = 0x5a9a, [0x3205] = 0x95e8, [0x3206] = 0x95f7,
  [0x3207] = 0x4eec, [0x3208] = 0x840c, [0x3209] = 0x8499, [0x320a] = 0x6aac,
  [0x320b] = 0x76df, [0x320c] = 0x9530, [0x320d] = 0x731b, [0x320e] = 0x68a6,
  [0x320f] = 0x5b5f, [0x3210] = 0x772f, [0x3211] = 0x919a, [0x3212] = 0x9761,
  [0x3213] = 0x7cdc, [0x3214] = 0x8ff7, [0x3215] = 0x8c1c, [0x3216] = 0x5f25,
  [0x3217] = 0x7c73, [0x3218] = 0x79d8, [0x3219] = 0x89c5, [0x321a] = 0x6ccc,
  [0x321b] = 0x871c, [0x321c] = 0x5bc6, [0x321d] = 0x5e42, [0x321e] = 0x68c9,
  [0x321f] = 0x7720, [0x3220] = 0x7ef5, [0x3221] = 0x5195, [0x3222] = 0x514d,
  [0x3223] = 0x52c9, [0x3224] = 0x5a29, [0x3225] = 0x7f05, [0x3226] = 0x9762,
  [0x3227] = 0x82d7, [0x3228] = 0x63cf, [0x3229] = 0x7784, [0x322a] = 0x85d0,
  [0x322b] = 0x79d2, [0x322c] = 0x6e3a, [0x322d] = 0x5e99, [0x322e] = 0x5999,
  [0x322f] = 0x8511, [0x3230] = 0x706d, [0x3231] = 0x6c11, [0x3232] = 0x62bf,
  [0x3233] = 0x76bf, [0x3234] = 0x654f, [0x3235] = 0x60af, [0x3236] = 0x95fd,
  [0x3237] = 0x660e, [0x3238] = 0x879f, [0x3239] = 0x9e23, [0x323a] = 0x94ed,
  [0x323b] = 0x540d, [0x323c] = 0x547d, [0x323d] = 0x8c2c, [0x323e] = 0x6478,
  [0x3240] = 0x8140, [0x3241] = 0x8141, [0x3242] = 0x8142, [0x3243] = 0x8143,
  [0x3244] = 0x8144, [0x3245] = 0x8145, [0x3246] = 0x8147, [0x3247] = 0x8149,
  [0x3248] = 0x814d, [0x3249] = 0x814e, [0x324a] = 0x814f, [0x324b] = 0x8152,
  [0x324c] = 0x8156, [0x324d] = 0x8157, [0x324e] = 0x8158, [0x324f] = 0x815b,
  [0x3250] = 0x815c, [0x3251] = 0x815d, [0x3252] = 0x815e, [0x3253] = 0x815f,
  [0x3254] = 0x8161, [0x3255] = 0x8162, [0x3256] = 0x8163, [0x3257] = 0x8164,
  [0x3258] = 0x8166, [0x3259] = 0x8168, [0x325a] = 0x816a, [0x325b] = 0x816b,
  [0x325c] = 0x816c, [0x325d] = 0x816f, [0x325e] = 0x8172, [0x325f] = 0x8173,
  [0x3260] = 0x8175, [0x3261] = 0x8176, [0x3262] = 0x8177, [0x3263] = 0x8178,
  [0x3264] = 0x8181, [0x3265] = 0x8183, [0x3266] = 0x8184, [0x3267] = 0x8185,
  [0x3268] = 0x8186, [0x3269] = 0x8187, [0x326a] = 0x8189, [0x326b] = 0x818b,
  [0x326c] = 0x818c, [0x326d] = 0x818d, [0x326e] = 0x818e, [0x326f] = 0x8190,
  [0x3270] = 0x8192, [0x3271] = 0x8193, [0x3272] = 0x8194, [0x3273] = 0x8195,
  [0x3274] = 0x8196, [0x3275] = 0x8197, [0x3276] = 0x8199, [0x3277] = 0x819a,
  [0x3278] = 0x819e, [0x3279] = 0x819f, [0x327a] = 0x81a0, [0x327b] = 0x81a1,
  [0x327c] = 0x81a2, [0x327d] = 0x81a4, [0x327e] = 0x81a5, [0x3280] = 0x81a7,
  [0x3281] = 0x81a9, [0x3282] = 0x81ab, [0x3283] = 0x81ac, [0x3284] = 0x81ad,
  [0x3285] = 0x81ae, [0x3286] = 0x81af, [0x3287] = 0x81b0, [0x3288] = 0x81b1,
  [0x3289] = 0x81b2, [0x328a] = 0x81b4, [0x328b] = 0x81b5, [0x328c] = 0x81b6,
  [0x328d] = 0x81b7, [0x328e] = 0x81b8, [0x328f] = 0x81b9, [0x3290] = 0x81bc,
  [0x3291] = 0x81bd, [0x3292] = 0x81be, [0x3293] = 0x81bf, [0x3294] = 0x81c4,
  [0x3295] = 0x81c5, [0x3296] = 0x81c7, [0x3297] = 0x81c8, [0x3298] = 0x81c9,
  [0x3299] = 0x81cb, [0x329a] = 0x81cd, [0x329b] = 0x81ce, [0x329c] = 0x81cf,
  [0x329d] = 0x81d0, [0x329e] = 0x81d1, [0x329f] = 0x81d2, [0x32a0] = 0x81d3,
  [0x32a1] = 0x6479, [0x32a2] = 0x8611, [0x32a3] = 0x6a21, [0x32a4] = 0x819c,
  [0x32a5] = 0x78e8, [0x32a6] = 0x6469, [0x32a7] = 0x9b54, [0x32a8] = 0x62b9,
  [0x32a9] = 0x672b, [0x32aa] = 0x83ab, [0x32ab] = 0x58a8, [0x32ac] = 0x9ed8,
  [0x32ad] = 0x6cab, [0x32ae] = 0x6f20, [0x32af] = 0x5bde, [0x32b0] = 0x964c,
  [0x32b1] = 0x8c0b, [0x32b2] = 0x725f, [0x32b3] = 0x67d0, [0x32b4] = 0x62c7,
  [0x32b5] = 0x7261, [0x32b6] = 0x4ea9, [0x32b7] = 0x59c6, [0x32b8] = 0x6bcd,
  [0x32b9] = 0x5893, [0x32ba] = 0x66ae, [0x32bb] = 0x5e55, [0x32bc] = 0x52df,
  [0x32bd] = 0x6155, [0x32be] = 0x6728, [0x32bf] = 0x76ee, [0x32c0] = 0x7766,
  [0x32c1] = 0x7267, [0x32c2] = 0x7a46, [0x32c3] = 0x62ff, [0x32c4] = 0x54ea,
  [0x32c5] = 0x5450, [0x32c6] = 0x94a0, [0x32c7] = 0x90a3, [0x32c8] = 0x5a1c,
  [0x32c9] = 0x7eb3, [0x32ca] = 0x6c16, [0x32cb] = 0x4e43, [0x32cc] = 0x5976,
  [0x32cd] = 0x8010, [0x32ce] = 0x5948, [0x32cf] = 0x5357, [0x32d0] = 0x7537,
  [0x32d1] = 0x96be, [0x32d2] = 0x56ca, [0x32d3] = 0x6320, [0x32d4] = 0x8111,
  [0x32d5] = 0x607c, [0x32d6] = 0x95f9, [0x32d7] = 0x6dd6, [0x32d8] = 0x5462,
  [0x32d9] = 0x9981, [0x32da] = 0x5185, [0x32db] = 0x5ae9, [0x32dc] = 0x80fd,
  [0x32dd] = 0x59ae, [0x32de] = 0x9713, [0x32df] = 0x502a, [0x32e0] = 0x6ce5,
  [0x32e1] = 0x5c3c, [0x32e2] = 0x62df, [0x32e3] = 0x4f60, [0x32e4] = 0x533f,
  [0x32e5] = 0x817b, [0x32e6] = 0x9006, [0x32e7] = 0x6eba, [0x32e8] = 0x852b,
  [0x32e9] = 0x62c8, [0x32ea] = 0x5e74, [0x32eb] = 0x78be, [0x32ec] = 0x64b5,
  [0x32ed] = 0x637b, [0x32ee] = 0x5ff5, [0x32ef] = 0x5a18, [0x32f0] = 0x917f,
  [0x32f1] = 0x9e1f, [0x32f2] = 0x5c3f, [0x32f3] = 0x634f, [0x32f4] = 0x8042,
  [0x32f5] = 0x5b7d, [0x32f6] = 0x556e, [0x32f7] = 0x954a, [0x32f8] = 0x954d,
  [0x32f9] = 0x6d85, [0x32fa] = 0x60a8, [0x32fb] = 0x67e0, [0x32fc] = 0x72de,
  [0x32fd] = 0x51dd, [0x32fe] = 0x5b81, [0x3300] = 0x81d4, [0x3301] = 0x81d5,
  [0x3302] = 0x81d6, [0x3303] = 0x81d7, [0x3304] = 0x81d8, [0x3305] = 0x81d9,
  [0x3306] = 0x81da, [0x3307] = 0x81db, [0x3308] = 0x81dc, [0x3309] = 0x81dd,
  [0x330a] = 0x81de, [0x330b] = 0x81df, [0x330c] = 0x81e0, [0x330d] = 0x81e1,
  [0x330e] = 0x81e2, [0x330f] = 0x81e4, [0x3310] = 0x81e5, [0x3311] = 0x81e6,
  [0x3312] = 0x81e8, [0x3313] = 0x81e9, [0x3314] = 0x81eb, [0x3315] = 0x81ee,
  [0x3316] = 0x81ef, [0x3317] = 0x81f0, [0x3318] = 0x81f1, [0x3319] = 0x81f2,
  [0x331a] = 0x81f5, [0x331b] = 0x81f6, [0x331c] = 0x81f7, [0x331d] = 0x81f8,
  [0x331e] = 0x81f9, [0x331f] = 0x81fa, [0x3320] = 0x81fd, [0x3321] = 0x81ff,
  [0x3322] = 0x8203, [0x3323] = 0x8207, [0x3324] = 0x8208, [0x3325] = 0x8209,
  [0x3326] = 0x820a, [0x3327] = 0x820b, [0x3328] = 0x820e, [0x3329] = 0x820f,
  [0x332a] = 0x8211, [0x332b] = 0x8213, [0x332c] = 0x8215, [0x332d] = 0x8216,
  [0x332e] = 0x8217, [0x332f] = 0x8218, [0x3330] = 0x8219, [0x3331] = 0x821a,
  [0x3332] = 0x821d, [0x3333] = 0x8220, [0x3334] = 0x8224, [0x3335] = 0x8225,
  [0x3336] = 0x8226, [0x3337] = 0x8227, [0x3338] = 0x8229, [0x3339] = 0x822e,
  [0x333a] = 0x8232, [0x333b] = 0x823a, [0x333c] = 0x823c, [0x333d] = 0x823d,
  [0x333e] = 0x823f, [0x3340] = 0x8240, [0x3341] = 0x8241, [0x3342] = 0x8242,
  [0x3343] = 0x8243, [0x3344] = 0x8245, [0x3345] = 0x8246, [0x3346] = 0x8248,
  [0x3347] = 0x824a, [0x3348] = 0x824c, [0x3349] = 0x824d, [0x334a] = 0x824e,
  [0x334b] = 0x8250, [0x334c] = 0x8251, [0x334d] = 0x8252, [0x334e] = 0x8253,
  [0x334f] = 0x8254, [0x3350] = 0x8255, [0x3351] = 0x8256, [0x3352] = 0x8257,
  [0x3353] = 0x8259, [0x3354] = 0x825b, [0x3355] = 0x825c, [0x3356] = 0x825d,
  [0x3357] = 0x825e, [0x3358] = 0x8260, [0x3359] = 0x8261, [0x335a] = 0x8262,
  [0x335b] = 0x8263, [0x335c] = 0x8264, [0x335d] = 0x8265, [0x335e] = 0x8266,
  [0x335f] = 0x8267, [0x3360] = 0x8269, [0x3361] = 0x62e7, [0x3362] = 0x6cde,
  [0x3363] = 0x725b, [0x3364] = 0x626d, [0x3365] = 0x94ae, [0x3366] = 0x7ebd,
  [0x3367] = 0x8113, [0x3368] = 0x6d53, [0x3369] = 0x519c, [0x336a] = 0x5f04,
  [0x336b] = 0x5974, [0x336c] = 0x52aa, [0x336d] = 0x6012, [0x336e] = 0x5973,
  [0x336f] = 0x6696, [0x3370] = 0x8650, [0x3371] = 0x759f, [0x3372] = 0x632a,
  [0x3373] = 0x61e6, [0x3374] = 0x7cef, [0x3375] = 0x8bfa, [0x3376] = 0x54e6,
  [0x3377] = 0x6b27, [0x3378] = 0x9e25, [0x3379] = 0x6bb4, [0x337a] = 0x85d5,
  [0x337b] = 0x5455, [0x337c] = 0x5076, [0x337d] = 0x6ca4, [0x337e] = 0x556a,
  [0x337f] = 0x8db4, [0x3380] = 0x722c, [0x3381] = 0x5e15, [0x3382] = 0x6015,
  [0x3383] = 0x7436, [0x3384] = 0x62cd, [0x3385] = 0x6392, [0x3386] = 0x724c,
  [0x3387] = 0x5f98, [0x3388] = 0x6e43, [0x3389] = 0x6d3e, [0x338a] = 0x6500,
  [0x338b] = 0x6f58, [0x338c] = 0x76d8, [0x338d] = 0x78d0, [0x338e] = 0x76fc,
  [0x338f] = 0x7554, [0x3390] = 0x5224, [0x3391] = 0x53db, [0x3392] = 0x4e53,
  [0x3393] = 0x5e9e, [0x3394] = 0x65c1, [0x3395] = 0x802a, [0x3396] = 0x80d6,
  [0x3397] = 0x629b, [0x3398] = 0x5486, [0x3399] = 0x5228, [0x339a] = 0x70ae,
  [0x339b] = 0x888d, [0x339c] = 0x8dd1, [0x339d] = 0x6ce1, [0x339e] = 0x5478,
  [0x339f] = 0x80da, [0x33a0] = 0x57f9, [0x33a1] = 0x88f4, [0x33a2] = 0x8d54,
  [0x33a3] = 0x966a, [0x33a4] = 0x914d, [0x33a5] = 0x4f69, [0x33a6] = 0x6c9b,
  [0x33a7] = 0x55b7, [0x33a8] = 0x76c6, [0x33a9] = 0x7830, [0x33aa] = 0x62a8,
  [0x33ab] = 0x70f9, [0x33ac] = 0x6f8e, [0x33ad] = 0x5f6d, [0x33ae] = 0x84ec,
  [0x33af] = 0x68da, [0x33b0] = 0x787c, [0x33b1] = 0x7bf7, [0x33b2] = 0x81a8,
  [0x33b3] = 0x670b, [0x33b4] = 0x9e4f, [0x33b5] = 0x6367, [0x33b6] = 0x78b0,
  [0x33b7] = 0x576f, [0x33b8] = 0x7812, [0x33b9] = 0x9739, [0x33ba] = 0x6279,
  [0x33bb] = 0x62ab, [0x33bc] = 0x5288, [0x33bd] = 0x7435, [0x33be] = 0x6bd7,
  [0x33c0] = 0x826a, [0x33c1] = 0x826b, [0x33c2] = 0x826c, [0x33c3] = 0x826d,
  [0x33c4] = 0x8271, [0x33c5] = 0x8275, [0x33c6] = 0x8276, [0x33c7] = 0x8277,
  [0x33c8] = 0x8278, [0x33c9] = 0x827b, [0x33ca] = 0x827c, [0x33cb] = 0x8280,
  [0x33cc] = 0x8281, [0x33cd] = 0x8283, [0x33ce] = 0x8285, [0x33cf] = 0x8286,
  [0x33d0] = 0x8287, [0x33d1] = 0x8289, [0x33d2] = 0x828c, [0x33d3] = 0x8290,
  [0x33d4] = 0x8293, [0x33d5] = 0x8294, [0x33d6] = 0x8295, [0x33d7] = 0x8296,
  [0x33d8] = 0x829a, [0x33d9] = 0x829b, [0x33da] = 0x829e, [0x33db] = 0x82a0,
  [0x33dc] = 0x82a2, [0x33dd] = 0x82a3, [0x33de] = 0x82a7, [0x33df] = 0x82b2,
  [0x33e0] = 0x82b5, [0x33e1] = 0x82b6, [0x33e2] = 0x82ba, [0x33e3] = 0x82bb,
  [0x33e4] = 0x82bc, [0x33e5] = 0x82bf, [0x33e6] = 0x82c0, [0x33e7] = 0x82c2,
  [0x33e8] = 0x82c3, [0x33e9] = 0x82c5, [0x33ea] = 0x82c6, [0x33eb] = 0x82c9,
  [0x33ec] = 0x82d0, [0x33ed] = 0x82d6, [0x33ee] = 0x82d9, [0x33ef] = 0x82da,
  [0x33f0] = 0x82dd, [0x33f1] = 0x82e2, [0x33f2] = 0x82e7, [0x33f3] = 0x82e8,
  [0x33f4] = 0x82e9, [0x33f5] = 0x82ea, [0x33f6] = 0x82ec, [0x33f7] = 0x82ed,
  [0x33f8] = 0x82ee, [0x33f9] = 0x82f0, [0x33fa] = 0x82f2, [0x33fb] = 0x82f3,
  [0x33fc] = 0x82f5, [0x33fd] = 0x82f6, [0x33fe] = 0x82f8, [0x3400] = 0x82fa,
  [0x3401] = 0x82fc, [0x3402] = 0x82fd, [0x3403] = 0x82fe, [0x3404] = 0x82ff,
  [0x3405] = 0x8300, [0x3406] = 0x830a, [0x3407] = 0x830b, [0x3408] = 0x830d,
  [0x3409] = 0x8310, [0x340a] = 0x8312, [0x340b] = 0x8313, [0x340c] = 0x8316,
  [0x340d] = 0x8318, [0x340e] = 0x8319, [0x340f] = 0x831d, [0x3410] = 0x831e,
  [0x3411] = 0x831f, [0x3412] = 0x8320, [0x3413] = 0x8321, [0x3414] = 0x8322,
  [0x3415] = 0x8323, [0x3416] = 0x8324, [0x3417] = 0x8325, [0x3418] = 0x8326,
  [0x3419] = 0x8329, [0x341a] = 0x832a, [0x341b] = 0x832e, [0x341c] = 0x8330,
  [0x341d] = 0x8332, [0x341e] = 0x8337, [0x341f] = 0x833b, [0x3420] = 0x833d,
  [0x3421] = 0x5564, [0x3422] = 0x813e, [0x3423] = 0x75b2, [0x3424] = 0x76ae,
  [0x3425] = 0x5339, [0x3426] = 0x75de, [0x3427] = 0x50fb, [0x3428] = 0x5c41,
  [0x3429] = 0x8b6c, [0x342a] = 0x7bc7, [0x342b] = 0x504f, [0x342c] = 0x7247,
  [0x342d] = 0x9a97, [0x342e] = 0x98d8, [0x342f] = 0x6f02, [0x3430] = 0x74e2,
  [0x3431] = 0x7968, [0x3432] = 0x6487, [0x3433] = 0x77a5, [0x3434] = 0x62fc,
  [0x3435] = 0x9891, [0x3436] = 0x8d2b, [0x3437] = 0x54c1, [0x3438] = 0x8058,
  [0x3439] = 0x4e52, [0x343a] = 0x576a, [0x343b] = 0x82f9, [0x343c] = 0x840d,
  [0x343d] = 0x5e73, [0x343e] = 0x51ed, [0x343f] = 0x74f6, [0x3440] = 0x8bc4,
  [0x3441] = 0x5c4f, [0x3442] = 0x5761, [0x3443] = 0x6cfc, [0x3444] = 0x9887,
  [0x3445] = 0x5a46, [0x3446] = 0x7834, [0x3447] = 0x9b44, [0x3448] = 0x8feb,
  [0x3449] = 0x7c95, [0x344a] = 0x5256, [0x344b] = 0x6251, [0x344c] = 0x94fa,
  [0x344d] = 0x4ec6, [0x344e] = 0x8386, [0x344f] = 0x8461, [0x3450] = 0x83e9,
  [0x3451] = 0x84b2, [0x3452] = 0x57d4, [0x3453] = 0x6734, [0x3454] = 0x5703,
  [0x3455] = 0x666e, [0x3456] = 0x6d66, [0x3457] = 0x8c31, [0x3458] = 0x66dd,
  [0x3459] = 0x7011, [0x345a] = 0x671f, [0x345b] = 0x6b3a, [0x345c] = 0x6816,
  [0x345d] = 0x621a, [0x345e] = 0x59bb, [0x345f] = 0x4e03, [0x3460] = 0x51c4,
  [0x3461] = 0x6f06, [0x3462] = 0x67d2, [0x3463] = 0x6c8f, [0x3464] = 0x5176,
  [0x3465] = 0x68cb, [0x3466] = 0x5947, [0x3467] = 0x6b67, [0x3468] = 0x7566,
  [0x3469] = 0x5d0e, [0x346a] = 0x8110, [0x346b] = 0x9f50, [0x346c] = 0x65d7,
  [0x346d] = 0x7948, [0x346e] = 0x7941, [0x346f] = 0x9a91, [0x3470] = 0x8d77,
  [0x3471] = 0x5c82, [0x3472] = 0x4e5e, [0x3473] = 0x4f01, [0x3474] = 0x542f,
  [0x3475] = 0x5951, [0x3476] = 0x780c, [0x3477] = 0x5668, [0x3478] = 0x6c14,
  [0x3479] = 0x8fc4, [0x347a] = 0x5f03, [0x347b] = 0x6c7d, [0x347c] = 0x6ce3,
  [0x347d] = 0x8bab, [0x347e] = 0x6390, [0x3480] = 0x833e, [0x3481] = 0x833f,
  [0x3482] = 0x8341, [0x3483] = 0x8342, [0x3484] = 0x8344, [0x3485] = 0x8345,
  [0x3486] = 0x8348, [0x3487] = 0x834a, [0x3488] = 0x834b, [0x3489] = 0x834c,
  [0x348a] = 0x834d, [0x348b] = 0x834e, [0x348c] = 0x8353, [0x348d] = 0x8355,
  [0x348e] = 0x8356, [0x348f] = 0x8357, [0x3490] = 0x8358, [0x3491] = 0x8359,
  [0x3492] = 0x835d, [0x3493] = 0x8362, [0x3494] = 0x8370, [0x3495] = 0x8371,
  [0x3496] = 0x8372, [0x3497] = 0x8373, [0x3498] = 0x8374, [0x3499] = 0x8375,
  [0x349a] = 0x8376, [0x349b] = 0x8379, [0x349c] = 0x837a, [0x349d] = 0x837e,
  [0x349e] = 0x837f, [0x349f] = 0x8380, [0x34a0] = 0x8381, [0x34a1] = 0x8382,
  [0x34a2] = 0x8383, [0x34a3] = 0x8384, [0x34a4] = 0x8387, [0x34a5] = 0x8388,
  [0x34a6] = 0x838a, [0x34a7] = 0x838b, [0x34a8] = 0x838c, [0x34a9] = 0x838d,
  [0x34aa] = 0x838f, [0x34ab] = 0x8390, [0x34ac] = 0x8391, [0x34ad] = 0x8394,
  [0x34ae] = 0x8395, [0x34af] = 0x8396, [0x34b0] = 0x8397, [0x34b1] = 0x8399,
  [0x34b2] = 0x839a, [0x34b3] = 0x839d, [0x34b4] = 0x839f, [0x34b5] = 0x83a1,
  [0x34b6] = 0x83a2, [0x34b7] = 0x83a3, [0x34b8] = 0x83a4, [0x34b9] = 0x83a5,
  [0x34ba] = 0x83a6, [0x34bb] = 0x83a7, [0x34bc] = 0x83ac, [0x34bd] = 0x83ad,
  [0x34be] = 0x83ae, [0x34c0] = 0x83af, [0x34c1] = 0x83b5, [0x34c2] = 0x83bb,
  [0x34c3] = 0x83be, [0x34c4] = 0x83bf, [0x34c5] = 0x83c2, [0x34c6] = 0x83c3,
  [0x34c7] = 0x83c4, [0x34c8] = 0x83c6, [0x34c9] = 0x83c8, [0x34ca] = 0x83c9,
  [0x34cb] = 0x83cb, [0x34cc] = 0x83cd, [0x34cd] = 0x83ce, [0x34ce] = 0x83d0,
  [0x34cf] = 0x83d1, [0x34d0] = 0x83d2, [0x34d1] = 0x83d3, [0x34d2] = 0x83d5,
  [0x34d3] = 0x83d7, [0x34d4] = 0x83d9, [0x34d5] = 0x83da, [0x34d6] = 0x83db,
  [0x34d7] = 0x83de, [0x34d8] = 0x83e2, [0x34d9] = 0x83e3, [0x34da] = 0x83e4,
  [0x34db] = 0x83e6, [0x34dc] = 0x83e7, [0x34dd] = 0x83e8, [0x34de] = 0x83eb,
  [0x34df] = 0x83ec, [0x34e0] = 0x83ed, [0x34e1] = 0x6070, [0x34e2] = 0x6d3d,
  [0x34e3] = 0x7275, [0x34e4] = 0x6266, [0x34e5] = 0x948e, [0x34e6] = 0x94c5,
  [0x34e7] = 0x5343, [0x34e8] = 0x8fc1, [0x34e9] = 0x7b7e, [0x34ea] = 0x4edf,
  [0x34eb] = 0x8c26, [0x34ec] = 0x4e7e, [0x34ed] = 0x9ed4, [0x34ee] = 0x94b1,
  [0x34ef] = 0x94b3, [0x34f0] = 0x524d, [0x34f1] = 0x6f5c, [0x34f2] = 0x9063,
  [0x34f3] = 0x6d45, [0x34f4] = 0x8c34, [0x34f5] = 0x5811, [0x34f6] = 0x5d4c,
  [0x34f7] = 0x6b20, [0x34f8] = 0x6b49, [0x34f9] = 0x67aa, [0x34fa] = 0x545b,
  [0x34fb] = 0x8154, [0x34fc] = 0x7f8c, [0x34fd] = 0x5899, [0x34fe] = 0x8537,
  [0x34ff] = 0x5f3a, [0x3500] = 0x62a2, [0x3501] = 0x6a47, [0x3502] = 0x9539,
  [0x3503] = 0x6572, [0x3504] = 0x6084, [0x3505] = 0x6865, [0x3506] = 0x77a7,
  [0x3507] = 0x4e54, [0x3508] = 0x4fa8, [0x3509] = 0x5de7, [0x350a] = 0x9798,
  [0x350b] = 0x64ac, [0x350c] = 0x7fd8, [0x350d] = 0x5ced, [0x350e] = 0x4fcf,
  [0x350f] = 0x7a8d, [0x3510] = 0x5207, [0x3511] = 0x8304, [0x3512] = 0x4e14,
  [0x3513] = 0x602f, [0x3514] = 0x7a83, [0x3515] = 0x94a6, [0x3516] = 0x4fb5,
  [0x3517] = 0x4eb2, [0x3518] = 0x79e6, [0x3519] = 0x7434, [0x351a] = 0x52e4,
  [0x351b] = 0x82b9, [0x351c] = 0x64d2, [0x351d] = 0x79bd, [0x351e] = 0x5bdd,
  [0x351f] = 0x6c81, [0x3520] = 0x9752, [0x3521] = 0x8f7b, [0x3522] = 0x6c22,
  [0x3523] = 0x503e, [0x3524] = 0x537f, [0x3525] = 0x6e05, [0x3526] = 0x64ce,
  [0x3527] = 0x6674, [0x3528] = 0x6c30, [0x3529] = 0x60c5, [0x352a] = 0x9877,
  [0x352b] = 0x8bf7, [0x352c] = 0x5e86, [0x352d] = 0x743c, [0x352e] = 0x7a77,
  [0x352f] = 0x79cb, [0x3530] = 0x4e18, [0x3531] = 0x90b1, [0x3532] = 0x7403,
  [0x3533] = 0x6c42, [0x3534] = 0x56da, [0x3535] = 0x914b, [0x3536] = 0x6cc5,
  [0x3537] = 0x8d8b, [0x3538] = 0x533a, [0x3539] = 0x86c6, [0x353a] = 0x66f2,
  [0x353b] = 0x8eaf, [0x353c] = 0x5c48, [0x353d] = 0x9a71, [0x353e] = 0x6e20,
  [0x3540] = 0x83ee, [0x3541] = 0x83ef, [0x3542] = 0x83f3, [0x3543] = 0x83f4,
  [0x3544] = 0x83f5, [0x3545] = 0x83f6, [0x3546] = 0x83f7, [0x3547] = 0x83fa,
  [0x3548] = 0x83fb, [0x3549] = 0x83fc, [0x354a] = 0x83fe, [0x354b] = 0x83ff,
  [0x354c] = 0x8400, [0x354d] = 0x8402, [0x354e] = 0x8405, [0x354f] = 0x8407,
  [0x3550] = 0x8408, [0x3551] = 0x8409, [0x3552] = 0x840a, [0x3553] = 0x8410,
  [0x3554] = 0x8412, [0x3555] = 0x8413, [0x3556] = 0x8414, [0x3557] = 0x8415,
  [0x3558] = 0x8416, [0x3559] = 0x8417, [0x355a] = 0x8419, [0x355b] = 0x841a,
  [0x355c] = 0x841b, [0x355d] = 0x841e, [0x355e] = 0x841f, [0x355f] = 0x8420,
  [0x3560] = 0x8421, [0x3561] = 0x8422, [0x3562] = 0x8423, [0x3563] = 0x8429,
  [0x3564] = 0x842a, [0x3565] = 0x842b, [0x3566] = 0x842c, [0x3567] = 0x842d,
  [0x3568] = 0x842e, [0x3569] = 0x842f, [0x356a] = 0x8430, [0x356b] = 0x8432,
  [0x356c] = 0x8433, [0x356d] = 0x8434, [0x356e] = 0x8435, [0x356f] = 0x8436,
  [0x3570] = 0x8437, [0x3571] = 0x8439, [0x3572] = 0x843a, [0x3573] = 0x843b,
  [0x3574] = 0x843e, [0x3575] = 0x843f, [0x3576] = 0x8440, [0x3577] = 0x8441,
  [0x3578] = 0x8442, [0x3579] = 0x8443, [0x357a] = 0x8444, [0x357b] = 0x8445,
  [0x357c] = 0x8447, [0x357d] = 0x8448, [0x357e] = 0x8449, [0x3580] = 0x844a,
  [0x3581] = 0x844b, [0x3582] = 0x844c, [0x3583] = 0x844d, [0x3584] = 0x844e,
  [0x3585] = 0x844f, [0x3586] = 0x8450, [0x3587] = 0x8452, [0x3588] = 0x8453,
  [0x3589] = 0x8454, [0x358a] = 0x8455, [0x358b] = 0x8456, [0x358c] = 0x8458,
  [0x358d] = 0x845d, [0x358e] = 0x845e, [0x358f] = 0x845f, [0x3590] = 0x8460,
  [0x3591] = 0x8462, [0x3592] = 0x8464, [0x3593] = 0x8465, [0x3594] = 0x8466,
  [0x3595] = 0x8467, [0x3596] = 0x8468, [0x3597] = 0x846a, [0x3598] = 0x846e,
  [0x3599] = 0x846f, [0x359a] = 0x8470, [0x359b] = 0x8472, [0x359c] = 0x8474,
  [0x359d] = 0x8477, [0x359e] = 0x8479, [0x359f] = 0x847b, [0x35a0] = 0x847c,
  [0x35a1] = 0x53d6, [0x35a2] = 0x5a36, [0x35a3] = 0x9f8b, [0x35a4] = 0x8da3,
  [0x35a5] = 0x53bb, [0x35a6] = 0x5708, [0x35a7] = 0x98a7, [0x35a8] = 0x6743,
  [0x35a9] = 0x919b, [0x35aa] = 0x6cc9, [0x35ab] = 0x5168, [0x35ac] = 0x75ca,
  [0x35ad] = 0x62f3, [0x35ae] = 0x72ac, [0x35af] = 0x5238, [0x35b0] = 0x529d,
  [0x35b1] = 0x7f3a, [0x35b2] = 0x7094, [0x35b3] = 0x7638, [0x35b4] = 0x5374,
  [0x35b5] = 0x9e4a, [0x35b6] = 0x69b7, [0x35b7] = 0x786e, [0x35b8] = 0x96c0,
  [0x35b9] = 0x88d9, [0x35ba] = 0x7fa4, [0x35bb] = 0x7136, [0x35bc] = 0x71c3,
  [0x35bd] = 0x5189, [0x35be] = 0x67d3, [0x35bf] = 0x74e4, [0x35c0] = 0x58e4,
  [0x35c1] = 0x6518, [0x35c2] = 0x56b7, [0x35c3] = 0x8ba9, [0x35c4] = 0x9976,
  [0x35c5] = 0x6270, [0x35c6] = 0x7ed5, [0x35c7] = 0x60f9, [0x35c8] = 0x70ed,
  [0x35c9] = 0x58ec, [0x35ca] = 0x4ec1, [0x35cb] = 0x4eba, [0x35cc] = 0x5fcd,
  [0x35cd] = 0x97e7, [0x35ce] = 0x4efb, [0x35cf] = 0x8ba4, [0x35d0] = 0x5203,
  [0x35d1] = 0x598a, [0x35d2] = 0x7eab, [0x35d3] = 0x6254, [0x35d4] = 0x4ecd,
  [0x35d5] = 0x65e5, [0x35d6] = 0x620e, [0x35d7] = 0x8338, [0x35d8] = 0x84c9,
  [0x35d9] = 0x8363, [0x35da] = 0x878d, [0x35db] = 0x7194, [0x35dc] = 0x6eb6,
  [0x35dd] = 0x5bb9, [0x35de] = 0x7ed2, [0x35df] = 0x5197, [0x35e0] = 0x63c9,
  [0x35e1] = 0x67d4, [0x35e2] = 0x8089, [0x35e3] = 0x8339, [0x35e4] = 0x8815,
  [0x35e5] = 0x5112, [0x35e6] = 0x5b7a, [0x35e7] = 0x5982, [0x35e8] = 0x8fb1,
  [0x35e9] = 0x4e73, [0x35ea] = 0x6c5d, [0x35eb] = 0x5165, [0x35ec] = 0x8925,
  [0x35ed] = 0x8f6f, [0x35ee] = 0x962e, [0x35ef] = 0x854a, [0x35f0] = 0x745e,
  [0x35f1] = 0x9510, [0x35f2] = 0x95f0, [0x35f3] = 0x6da6, [0x35f4] = 0x82e5,
  [0x35f5] = 0x5f31, [0x35f6] = 0x6492, [0x35f7] = 0x6d12, [0x35f8] = 0x8428,
  [0x35f9] = 0x816e, [0x35fa] = 0x9cc3, [0x35fb] = 0x585e, [0x35fc] = 0x8d5b,
  [0x35fd] = 0x4e09, [0x35fe] = 0x53c1, [0x3600] = 0x847d, [0x3601] = 0x847e,
  [0x3602] = 0x847f, [0x3603] = 0x8480, [0x3604] = 0x8481, [0x3605] = 0x8483,
  [0x3606] = 0x8484, [0x3607] = 0x8485, [0x3608] = 0x8486, [0x3609] = 0x848a,
  [0x360a] = 0x848d, [0x360b] = 0x848f, [0x360c] = 0x8490, [0x360d] = 0x8491,
  [0x360e] = 0x8492, [0x360f] = 0x8493, [0x3610] = 0x8494, [0x3611] = 0x8495,
  [0x3612] = 0x8496, [0x3613] = 0x8498, [0x3614] = 0x849a, [0x3615] = 0x849b,
  [0x3616] = 0x849d, [0x3617] = 0x849e, [0x3618] = 0x849f, [0x3619] = 0x84a0,
  [0x361a] = 0x84a2, [0x361b] = 0x84a3, [0x361c] = 0x84a4, [0x361d] = 0x84a5,
  [0x361e] = 0x84a6, [0x361f] = 0x84a7, [0x3620] = 0x84a8, [0x3621] = 0x84a9,
  [0x3622] = 0x84aa, [0x3623] = 0x84ab, [0x3624] = 0x84ac, [0x3625] = 0x84ad,
  [0x3626] = 0x84ae, [0x3627] = 0x84b0, [0x3628] = 0x84b1, [0x3629] = 0x84b3,
  [0x362a] = 0x84b5, [0x362b] = 0x84b6, [0x362c] = 0x84b7, [0x362d] = 0x84bb,
  [0x362e] = 0x84bc, [0x362f] = 0x84be, [0x3630] = 0x84c0, [0x3631] = 0x84c2,
  [0x3632] = 0x84c3, [0x3633] = 0x84c5, [0x3634] = 0x84c6, [0x3635] = 0x84c7,
  [0x3636] = 0x84c8, [0x3637] = 0x84cb, [0x3638] = 0x84cc, [0x3639] = 0x84ce,
  [0x363a] = 0x84cf, [0x363b] = 0x84d2, [0x363c] = 0x84d4, [0x363d] = 0x84d5,
  [0x363e] = 0x84d7, [0x3640] = 0x84d8, [0x3641] = 0x84d9, [0x3642] = 0x84da,
  [0x3643] = 0x84db, [0x3644] = 0x84dc, [0x3645] = 0x84de, [0x3646] = 0x84e1,
  [0x3647] = 0x84e2, [0x3648] = 0x84e4, [0x3649] = 0x84e7, [0x364a] = 0x84e8,
  [0x364b] = 0x84e9, [0x364c] = 0x84ea, [0x364d] = 0x84eb, [0x364e] = 0x84ed,
  [0x364f] = 0x84ee, [0x3650] = 0x84ef, [0x3651] = 0x84f1, [0x3652] = 0x84f2,
  [0x3653] = 0x84f3, [0x3654] = 0x84f4, [0x3655] = 0x84f5, [0x3656] = 0x84f6,
  [0x3657] = 0x84f7, [0x3658] = 0x84f8, [0x3659] = 0x84f9, [0x365a] = 0x84fa,
  [0x365b] = 0x84fb, [0x365c] = 0x84fd, [0x365d] = 0x84fe, [0x365e] = 0x8500,
  [0x365f] = 0x8501, [0x3660] = 0x8502, [0x3661] = 0x4f1e, [0x3662] = 0x6563,
  [0x3663] = 0x6851, [0x3664] = 0x55d3, [0x3665] = 0x4e27, [0x3666] = 0x6414,
  [0x3667] = 0x9a9a, [0x3668] = 0x626b, [0x3669] = 0x5ac2, [0x366a] = 0x745f,
  [0x366b] = 0x8272, [0x366c] = 0x6da9, [0x366d] = 0x68ee, [0x366e] = 0x50e7,
  [0x366f] = 0x838e, [0x3670] = 0x7802, [0x3671] = 0x6740, [0x3672] = 0x5239,
  [0x3673] = 0x6c99, [0x3674] = 0x7eb1, [0x3675] = 0x50bb, [0x3676] = 0x5565,
  [0x3677] = 0x715e, [0x3678] = 0x7b5b, [0x3679] = 0x6652, [0x367a] = 0x73ca,
  [0x367b] = 0x82eb, [0x367c] = 0x6749, [0x367d] = 0x5c71, [0x367e] = 0x5220,
  [0x367f] = 0x717d, [0x3680] = 0x886b, [0x3681] = 0x95ea, [0x3682] = 0x9655,
  [0x3683] = 0x64c5, [0x3684] = 0x8d61, [0x3685] = 0x81b3, [0x3686] = 0x5584,
  [0x3687] = 0x6c55, [0x3688] = 0x6247, [0x3689] = 0x7f2e, [0x368a] = 0x5892,
  [0x368b] = 0x4f24, [0x368c] = 0x5546, [0x368d] = 0x8d4f, [0x368e] = 0x664c,
  [0x368f] = 0x4e0a, [0x3690] = 0x5c1a, [0x3691] = 0x88f3, [0x3692] = 0x68a2,
  [0x3693] = 0x634e, [0x3694] = 0x7a0d, [0x3695] = 0x70e7, [0x3696] = 0x828d,
  [0x3697] = 0x52fa, [0x3698] = 0x97f6, [0x3699] = 0x5c11, [0x369a] = 0x54e8,
  [0x369b] = 0x90b5, [0x369c] = 0x7ecd, [0x369d] = 0x5962, [0x369e] = 0x8d4a,
  [0x369f] = 0x86c7, [0x36a0] = 0x820c, [0x36a1] = 0x820d, [0x36a2] = 0x8d66,
  [0x36a3] = 0x6444, [0x36a4] = 0x5c04, [0x36a5] = 0x6151, [0x36a6] = 0x6d89,
  [0x36a7] = 0x793e, [0x36a8] = 0x8bbe, [0x36a9] = 0x7837, [0x36aa] = 0x7533,
  [0x36ab] = 0x547b, [0x36ac] = 0x4f38, [0x36ad] = 0x8eab, [0x36ae] = 0x6df1,
  [0x36af] = 0x5a20, [0x36b0] = 0x7ec5, [0x36b1] = 0x795e, [0x36b2] = 0x6c88,
  [0x36b3] = 0x5ba1, [0x36b4] = 0x5a76, [0x36b5] = 0x751a, [0x36b6] = 0x80be,
  [0x36b7] = 0x614e, [0x36b8] = 0x6e17, [0x36b9] = 0x58f0, [0x36ba] = 0x751f,
  [0x36bb] = 0x7525, [0x36bc] = 0x7272, [0x36bd] = 0x5347, [0x36be] = 0x7ef3,
  [0x36c0] = 0x8503, [0x36c1] = 0x8504, [0x36c2] = 0x8505, [0x36c3] = 0x8506,
  [0x36c4] = 0x8507, [0x36c5] = 0x8508, [0x36c6] = 0x8509, [0x36c7] = 0x850a,
  [0x36c8] = 0x850b, [0x36c9] = 0x850d, [0x36ca] = 0x850e, [0x36cb] = 0x850f,
  [0x36cc] = 0x8510, [0x36cd] = 0x8512, [0x36ce] = 0x8514, [0x36cf] = 0x8515,
  [0x36d0] = 0x8516, [0x36d1] = 0x8518, [0x36d2] = 0x8519, [0x36d3] = 0x851b,
  [0x36d4] = 0x851c, [0x36d5] = 0x851d, [0x36d6] = 0x851e, [0x36d7] = 0x8520,
  [0x36d8] = 0x8522, [0x36d9] = 0x8523, [0x36da] = 0x8524, [0x36db] = 0x8525,
  [0x36dc] = 0x8526, [0x36dd] = 0x8527, [0x36de] = 0x8528, [0x36df] = 0x8529,
  [0x36e0] = 0x852a, [0x36e1] = 0x852d, [0x36e2] = 0x852e, [0x36e3] = 0x852f,
  [0x36e4] = 0x8530, [0x36e5] = 0x8531, [0x36e6] = 0x8532, [0x36e7] = 0x8533,
  [0x36e8] = 0x8534, [0x36e9] = 0x8535, [0x36ea] = 0x8536, [0x36eb] = 0x853e,
  [0x36ec] = 0x853f, [0x36ed] = 0x8540, [0x36ee] = 0x8541, [0x36ef] = 0x8542,
  [0x36f0] = 0x8544, [0x36f1] = 0x8545, [0x36f2] = 0x8546, [0x36f3] = 0x8547,
  [0x36f4] = 0x854b, [0x36f5] = 0x854c, [0x36f6] = 0x854d, [0x36f7] = 0x854e,
  [0x36f8] = 0x854f, [0x36f9] = 0x8550, [0x36fa] = 0x8551, [0x36fb] = 0x8552,
  [0x36fc] = 0x8553, [0x36fd] = 0x8554, [0x36fe] = 0x8555, [0x3700] = 0x8557,
  [0x3701] = 0x8558, [0x3702] = 0x855a, [0x3703] = 0x855b, [0x3704] = 0x855c,
  [0x3705] = 0x855d, [0x3706] = 0x855f, [0x3707] = 0x8560, [0x3708] = 0x8561,
  [0x3709] = 0x8562, [0x370a] = 0x8563, [0x370b] = 0x8565, [0x370c] = 0x8566,
  [0x370d] = 0x8567, [0x370e] = 0x8569, [0x370f] = 0x856a, [0x3710] = 0x856b,
  [0x3711] = 0x856c, [0x3712] = 0x856d, [0x3713] = 0x856e, [0x3714] = 0x856f,
  [0x3715] = 0x8570, [0x3716] = 0x8571, [0x3717] = 0x8573, [0x3718] = 0x8575,
  [0x3719] = 0x8576, [0x371a] = 0x8577, [0x371b] = 0x8578, [0x371c] = 0x857c,
  [0x371d] = 0x857d, [0x371e] = 0x857f, [0x371f] = 0x8580, [0x3720] = 0x8581,
  [0x3721] = 0x7701, [0x3722] = 0x76db, [0x3723] = 0x5269, [0x3724] = 0x80dc,
  [0x3725] = 0x5723, [0x3726] = 0x5e08, [0x3727] = 0x5931, [0x3728] = 0x72ee,
  [0x3729] = 0x65bd, [0x372a] = 0x6e7f, [0x372b] = 0x8bd7, [0x372c] = 0x5c38,
  [0x372d] = 0x8671, [0x372e] = 0x5341, [0x372f] = 0x77f3, [0x3730] = 0x62fe,
  [0x3731] = 0x65f6, [0x3732] = 0x4ec0, [0x3733] = 0x98df, [0x3734] = 0x8680,
  [0x3735] = 0x5b9e, [0x3736] = 0x8bc6, [0x3737] = 0x53f2, [0x3738] = 0x77e2,
  [0x3739] = 0x4f7f, [0x373a] = 0x5c4e, [0x373b] = 0x9a76, [0x373c] = 0x59cb,
  [0x373d] = 0x5f0f, [0x373e] = 0x793a, [0x373f] = 0x58eb, [0x3740] = 0x4e16,
  [0x3741] = 0x67ff, [0x3742] = 0x4e8b, [0x3743] = 0x62ed, [0x3744] = 0x8a93,
  [0x3745] = 0x901d, [0x3746] = 0x52bf, [0x3747] = 0x662f, [0x3748] = 0x55dc,
  [0x3749] = 0x566c, [0x374a] = 0x9002, [0x374b] = 0x4ed5, [0x374c] = 0x4f8d,
  [0x374d] = 0x91ca, [0x374e] = 0x9970, [0x374f] = 0x6c0f, [0x3750] = 0x5e02,
  [0x3751] = 0x6043, [0x3752] = 0x5ba4, [0x3753] = 0x89c6, [0x3754] = 0x8bd5,
  [0x3755] = 0x6536, [0x3756] = 0x624b, [0x3757] = 0x9996, [0x3758] = 0x5b88,
  [0x3759] = 0x5bff, [0x375a] = 0x6388, [0x375b] = 0x552e, [0x375c] = 0x53d7,
  [0x375d] = 0x7626, [0x375e] = 0x517d, [0x375f] = 0x852c, [0x3760] = 0x67a2,
  [0x3761] = 0x68b3, [0x3762] = 0x6b8a, [0x3763] = 0x6292, [0x3764] = 0x8f93,
  [0x3765] = 0x53d4, [0x3766] = 0x8212, [0x3767] = 0x6dd1, [0x3768] = 0x758f,
  [0x3769] = 0x4e66, [0x376a] = 0x8d4e, [0x376b] = 0x5b70, [0x376c] = 0x719f,
  [0x376d] = 0x85af, [0x376e] = 0x6691, [0x376f] = 0x66d9, [0x3770] = 0x7f72,
  [0x3771] = 0x8700, [0x3772] = 0x9ecd, [0x3773] = 0x9f20, [0x3774] = 0x5c5e,
  [0x3775] = 0x672f, [0x3776] = 0x8ff0, [0x3777] = 0x6811, [0x3778] = 0x675f,
  [0x3779] = 0x620d, [0x377a] = 0x7ad6, [0x377b] = 0x5885, [0x377c] = 0x5eb6,
  [0x377d] = 0x6570, [0x377e] = 0x6f31, [0x3780] = 0x8582, [0x3781] = 0x8583,
  [0x3782] = 0x8586, [0x3783] = 0x8588, [0x3784] = 0x8589, [0x3785] = 0x858a,
  [0x3786] = 0x858b, [0x3787] = 0x858c, [0x3788] = 0x858d, [0x3789] = 0x858e,
  [0x378a] = 0x8590, [0x378b] = 0x8591, [0x378c] = 0x8592, [0x378d] = 0x8593,
  [0x378e] = 0x8594, [0x378f] = 0x8595, [0x3790] = 0x8596, [0x3791] = 0x8597,
  [0x3792] = 0x8598, [0x3793] = 0x8599, [0x3794] = 0x859a, [0x3795] = 0x859d,
  [0x3796] = 0x859e, [0x3797] = 0x859f, [0x3798] = 0x85a0, [0x3799] = 0x85a1,
  [0x379a] = 0x85a2, [0x379b] = 0x85a3, [0x379c] = 0x85a5, [0x379d] = 0x85a6,
  [0x379e] = 0x85a7, [0x379f] = 0x85a9, [0x37a0] = 0x85ab, [0x37a1] = 0x85ac,
  [0x37a2] = 0x85ad, [0x37a3] = 0x85b1, [0x37a4] = 0x85b2, [0x37a5] = 0x85b3,
  [0x37a6] = 0x85b4, [0x37a7] = 0x85b5, [0x37a8] = 0x85b6, [0x37a9] = 0x85b8,
  [0x37aa] = 0x85ba, [0x37ab] = 0x85bb, [0x37ac] = 0x85bc, [0x37ad] = 0x85bd,
  [0x37ae] = 0x85be, [0x37af] = 0x85bf, [0x37b0] = 0x85c0, [0x37b1] = 0x85c2,
  [0x37b2] = 0x85c3, [0x37b3] = 0x85c4, [0x37b4] = 0x85c5, [0x37b5] = 0x85c6,
  [0x37b6] = 0x85c7, [0x37b7] = 0x85c8, [0x37b8] = 0x85ca, [0x37b9] = 0x85cb,
  [0x37ba] = 0x85cc, [0x37bb] = 0x85cd, [0x37bc] = 0x85ce, [0x37bd] = 0x85d1,
  [0x37be] = 0x85d2, [0x37c0] = 0x85d4, [0x37c1] = 0x85d6, [0x37c2] = 0x85d7,
  [0x37c3] = 0x85d8, [0x37c4] = 0x85d9, [0x37c5] = 0x85da, [0x37c6] = 0x85db,
  [0x37c7] = 0x85dd, [0x37c8] = 0x85de, [0x37c9] = 0x85df, [0x37ca] = 0x85e0,
  [0x37cb] = 0x85e1, [0x37cc] = 0x85e2, [0x37cd] = 0x85e3, [0x37ce] = 0x85e5,
  [0x37cf] = 0x85e6, [0x37d0] = 0x85e7, [0x37d1] = 0x85e8, [0x37d2] = 0x85ea,
  [0x37d3] = 0x85eb, [0x37d4] = 0x85ec, [0x37d5] = 0x85ed, [0x37d6] = 0x85ee,
  [0x37d7] = 0x85ef, [0x37d8] = 0x85f0, [0x37d9] = 0x85f1, [0x37da] = 0x85f2,
  [0x37db] = 0x85f3, [0x37dc] = 0x85f4, [0x37dd] = 0x85f5, [0x37de] = 0x85f6,
  [0x37df] = 0x85f7, [0x37e0] = 0x85f8, [0x37e1] = 0x6055, [0x37e2] = 0x5237,
  [0x37e3] = 0x800d, [0x37e4] = 0x6454, [0x37e5] = 0x8870, [0x37e6] = 0x7529,
  [0x37e7] = 0x5e05, [0x37e8] = 0x6813, [0x37e9] = 0x62f4, [0x37ea] = 0x971c,
  [0x37eb] = 0x53cc, [0x37ec] = 0x723d, [0x37ed] = 0x8c01, [0x37ee] = 0x6c34,
  [0x37ef] = 0x7761, [0x37f0] = 0x7a0e, [0x37f1] = 0x542e, [0x37f2] = 0x77ac,
  [0x37f3] = 0x987a, [0x37f4] = 0x821c, [0x37f5] = 0x8bf4, [0x37f6] = 0x7855,
  [0x37f7] = 0x6714, [0x37f8] = 0x70c1, [0x37f9] = 0x65af, [0x37fa] = 0x6495,
  [0x37fb] = 0x5636, [0x37fc] = 0x601d, [0x37fd] = 0x79c1, [0x37fe] = 0x53f8,
  [0x37ff] = 0x4e1d, [0x3800] = 0x6b7b, [0x3801] = 0x8086, [0x3802] = 0x5bfa,
  [0x3803] = 0x55e3, [0x3804] = 0x56db, [0x3805] = 0x4f3a, [0x3806] = 0x4f3c,
  [0x3807] = 0x9972, [0x3808] = 0x5df3, [0x3809] = 0x677e, [0x380a] = 0x8038,
  [0x380b] = 0x6002, [0x380c] = 0x9882, [0x380d] = 0x9001, [0x380e] = 0x5b8b,
  [0x380f] = 0x8bbc, [0x3810] = 0x8bf5, [0x3811] = 0x641c, [0x3812] = 0x8258,
  [0x3813] = 0x64de, [0x3814] = 0x55fd, [0x3815] = 0x82cf, [0x3816] = 0x9165,
  [0x3817] = 0x4fd7, [0x3818] = 0x7d20, [0x3819] = 0x901f, [0x381a] = 0x7c9f,
  [0x381b] = 0x50f3, [0x381c] = 0x5851, [0x381d] = 0x6eaf, [0x381e] = 0x5bbf,
  [0x381f] = 0x8bc9, [0x3820] = 0x8083, [0x3821] = 0x9178, [0x3822] = 0x849c,
  [0x3823] = 0x7b97, [0x3824] = 0x867d, [0x3825] = 0x968b, [0x3826] = 0x968f,
  [0x3827] = 0x7ee5, [0x3828] = 0x9ad3, [0x3829] = 0x788e, [0x382a] = 0x5c81,
  [0x382b] = 0x7a57, [0x382c] = 0x9042, [0x382d] = 0x96a7, [0x382e] = 0x795f,
  [0x382f] = 0x5b59, [0x3830] = 0x635f, [0x3831] = 0x7b0b, [0x3832] = 0x84d1,
  [0x3833] = 0x68ad, [0x3834] = 0x5506, [0x3835] = 0x7f29, [0x3836] = 0x7410,
  [0x3837] = 0x7d22, [0x3838] = 0x9501, [0x3839] = 0x6240, [0x383a] = 0x584c,
  [0x383b] = 0x4ed6, [0x383c] = 0x5b83, [0x383d] = 0x5979, [0x383e] = 0x5854,
  [0x3840] = 0x85f9, [0x3841] = 0x85fa, [0x3842] = 0x85fc, [0x3843] = 0x85fd,
  [0x3844] = 0x85fe, [0x3845] = 0x8600, [0x3846] = 0x8601, [0x3847] = 0x8602,
  [0x3848] = 0x8603, [0x3849] = 0x8604, [0x384a] = 0x8606, [0x384b] = 0x8607,
  [0x384c] = 0x8608, [0x384d] = 0x8609, [0x384e] = 0x860a, [0x384f] = 0x860b,
  [0x3850] = 0x860c, [0x3851] = 0x860d, [0x3852] = 0x860e, [0x3853] = 0x860f,
  [0x3854] = 0x8610, [0x3855] = 0x8612, [0x3856] = 0x8613, [0x3857] = 0x8614,
  [0x3858] = 0x8615, [0x3859] = 0x8617, [0x385a] = 0x8618, [0x385b] = 0x8619,
  [0x385c] = 0x861a, [0x385d] = 0x861b, [0x385e] = 0x861c, [0x385f] = 0x861d,
  [0x3860] = 0x861e, [0x3861] = 0x861f, [0x3862] = 0x8620, [0x3863] = 0x8621,
  [0x3864] = 0x8622, [0x3865] = 0x8623, [0x3866] = 0x8624, [0x3867] = 0x8625,
  [0x3868] = 0x8626, [0x3869] = 0x8628, [0x386a] = 0x862a, [0x386b] = 0x862b,
  [0x386c] = 0x862c, [0x386d] = 0x862d, [0x386e] = 0x862e, [0x386f] = 0x862f,
  [0x3870] = 0x8630, [0x3871] = 0x8631, [0x3872] = 0x8632, [0x3873] = 0x8633,
  [0x3874] = 0x8634, [0x3875] = 0x8635, [0x3876] = 0x8636, [0x3877] = 0x8637,
  [0x3878] = 0x8639, [0x3879] = 0x863a, [0x387a] = 0x863b, [0x387b] = 0x863d,
  [0x387c] = 0x863e, [0x387d] = 0x863f, [0x387e] = 0x8640, [0x3880] = 0x8641,
  [0x3881] = 0x8642, [0x3882] = 0x8643, [0x3883] = 0x8644, [0x3884] = 0x8645,
  [0x3885] = 0x8646, [0x3886] = 0x8647, [0x3887] = 0x8648, [0x3888] = 0x8649,
  [0x3889] = 0x864a, [0x388a] = 0x864b, [0x388b] = 0x864c, [0x388c] = 0x8652,
  [0x388d] = 0x8653, [0x388e] = 0x8655, [0x388f] = 0x8656, [0x3890] = 0x8657,
  [0x3891] = 0x8658, [0x3892] = 0x8659, [0x3893] = 0x865b, [0x3894] = 0x865c,
  [0x3895] = 0x865d, [0x3896] = 0x865f, [0x3897] = 0x8660, [0x3898] = 0x8661,
  [0x3899] = 0x8663, [0x389a] = 0x8664, [0x389b] = 0x8665, [0x389c] = 0x8666,
  [0x389d] = 0x8667, [0x389e] = 0x8668, [0x389f] = 0x8669, [0x38a0] = 0x866a,
  [0x38a1] = 0x736d, [0x38a2] = 0x631e, [0x38a3] = 0x8e4b, [0x38a4] = 0x8e0f,
  [0x38a5] = 0x80ce, [0x38a6] = 0x82d4, [0x38a7] = 0x62ac, [0x38a8] = 0x53f0,
  [0x38a9] = 0x6cf0, [0x38aa] = 0x915e, [0x38ab] = 0x592a, [0x38ac] = 0x6001,
  [0x38ad] = 0x6c70, [0x38ae] = 0x574d, [0x38af] = 0x644a, [0x38b0] = 0x8d2a,
  [0x38b1] = 0x762b, [0x38b2] = 0x6ee9, [0x38b3] = 0x575b, [0x38b4] = 0x6a80,
  [0x38b5] = 0x75f0, [0x38b6] = 0x6f6d, [0x38b7] = 0x8c2d, [0x38b8] = 0x8c08,
  [0x38b9] = 0x5766, [0x38ba] = 0x6bef, [0x38bb] = 0x8892, [0x38bc] = 0x78b3,
  [0x38bd] = 0x63a2, [0x38be] = 0x53f9, [0x38bf] = 0x70ad, [0x38c0] = 0x6c64,
  [0x38c1] = 0x5858, [0x38c2] = 0x642a, [0x38c3] = 0x5802, [0x38c4] = 0x68e0,
  [0x38c5] = 0x819b, [0x38c6] = 0x5510, [0x38c7] = 0x7cd6, [0x38c8] = 0x5018,
  [0x38c9] = 0x8eba, [0x38ca] = 0x6dcc, [0x38cb] = 0x8d9f, [0x38cc] = 0x70eb,
  [0x38cd] = 0x638f, [0x38ce] = 0x6d9b, [0x38cf] = 0x6ed4, [0x38d0] = 0x7ee6,
  [0x38d1] = 0x8404, [0x38d2] = 0x6843, [0x38d3] = 0x9003, [0x38d4] = 0x6dd8,
  [0x38d5] = 0x9676, [0x38d6] = 0x8ba8, [0x38d7] = 0x5957, [0x38d8] = 0x7279,
  [0x38d9] = 0x85e4, [0x38da] = 0x817e, [0x38db] = 0x75bc, [0x38dc] = 0x8a8a,
  [0x38dd] = 0x68af, [0x38de] = 0x5254, [0x38df] = 0x8e22, [0x38e0] = 0x9511,
  [0x38e1] = 0x63d0, [0x38e2] = 0x9898, [0x38e3] = 0x8e44, [0x38e4] = 0x557c,
  [0x38e5] = 0x4f53, [0x38e6] = 0x66ff, [0x38e7] = 0x568f, [0x38e8] = 0x60d5,
  [0x38e9] = 0x6d95, [0x38ea] = 0x5243, [0x38eb] = 0x5c49, [0x38ec] = 0x5929,
  [0x38ed] = 0x6dfb, [0x38ee] = 0x586b, [0x38ef] = 0x7530, [0x38f0] = 0x751c,
  [0x38f1] = 0x606c, [0x38f2] = 0x8214, [0x38f3] = 0x8146, [0x38f4] = 0x6311,
  [0x38f5] = 0x6761, [0x38f6] = 0x8fe2, [0x38f7] = 0x773a, [0x38f8] = 0x8df3,
  [0x38f9] = 0x8d34, [0x38fa] = 0x94c1, [0x38fb] = 0x5e16, [0x38fc] = 0x5385,
  [0x38fd] = 0x542c, [0x38fe] = 0x70c3, [0x3900] = 0x866d, [0x3901] = 0x866f,
  [0x3902] = 0x8670, [0x3903] = 0x8672, [0x3904] = 0x8673, [0x3905] = 0x8674,
  [0x3906] = 0x8675, [0x3907] = 0x8676, [0x3908] = 0x8677, [0x3909] = 0x8678,
  [0x390a] = 0x8683, [0x390b] = 0x8684, [0x390c] = 0x8685, [0x390d] = 0x8686,
  [0x390e] = 0x8687, [0x390f] = 0x8688, [0x3910] = 0x8689, [0x3911] = 0x868e,
  [0x3912] = 0x868f, [0x3913] = 0x8690, [0x3914] = 0x8691, [0x3915] = 0x8692,
  [0x3916] = 0x8694, [0x3917] = 0x8696, [0x3918] = 0x8697, [0x3919] = 0x8698,
  [0x391a] = 0x8699, [0x391b] = 0x869a, [0x391c] = 0x869b, [0x391d] = 0x869e,
  [0x391e] = 0x869f, [0x391f] = 0x86a0, [0x3920] = 0x86a1, [0x3921] = 0x86a2,
  [0x3922] = 0x86a5, [0x3923] = 0x86a6, [0x3924] = 0x86ab, [0x3925] = 0x86ad,
  [0x3926] = 0x86ae, [0x3927] = 0x86b2, [0x3928] = 0x86b3, [0x3929] = 0x86b7,
  [0x392a] = 0x86b8, [0x392b] = 0x86b9, [0x392c] = 0x86bb, [0x392d] = 0x86bc,
  [0x392e] = 0x86bd, [0x392f] = 0x86be, [0x3930] = 0x86bf, [0x3931] = 0x86c1,
  [0x3932] = 0x86c2, [0x3933] = 0x86c3, [0x3934] = 0x86c5, [0x3935] = 0x86c8,
  [0x3936] = 0x86cc, [0x3937] = 0x86cd, [0x3938] = 0x86d2, [0x3939] = 0x86d3,
  [0x393a] = 0x86d5, [0x393b] = 0x86d6, [0x393c] = 0x86d7, [0x393d] = 0x86da,
  [0x393e] = 0x86dc, [0x3940] = 0x86dd, [0x3941] = 0x86e0, [0x3942] = 0x86e1,
  [0x3943] = 0x86e2, [0x3944] = 0x86e3, [0x3945] = 0x86e5, [0x3946] = 0x86e6,
  [0x3947] = 0x86e7, [0x3948] = 0x86e8, [0x3949] = 0x86ea, [0x394a] = 0x86eb,
  [0x394b] = 0x86ec, [0x394c] = 0x86ef, [0x394d] = 0x86f5, [0x394e] = 0x86f6,
  [0x394f] = 0x86f7, [0x3950] = 0x86fa, [0x3951] = 0x86fb, [0x3952] = 0x86fc,
  [0x3953] = 0x86fd, [0x3954] = 0x86ff, [0x3955] = 0x8701, [0x3956] = 0x8704,
  [0x3957] = 0x8705, [0x3958] = 0x8706, [0x3959] = 0x870b, [0x395a] = 0x870c,
  [0x395b] = 0x870e, [0x395c] = 0x870f, [0x395d] = 0x8710, [0x395e] = 0x8711,
  [0x395f] = 0x8714, [0x3960] = 0x8716, [0x3961] = 0x6c40, [0x3962] = 0x5ef7,
  [0x3963] = 0x505c, [0x3964] = 0x4ead, [0x3965] = 0x5ead, [0x3966] = 0x633a,
  [0x3967] = 0x8247, [0x3968] = 0x901a, [0x3969] = 0x6850, [0x396a] = 0x916e,
  [0x396b] = 0x77b3, [0x396c] = 0x540c, [0x396d] = 0x94dc, [0x396e] = 0x5f64,
  [0x396f] = 0x7ae5, [0x3970] = 0x6876, [0x3971] = 0x6345, [0x3972] = 0x7b52,
  [0x3973] = 0x7edf, [0x3974] = 0x75db, [0x3975] = 0x5077, [0x3976] = 0x6295,
  [0x3977] = 0x5934, [0x3978] = 0x900f, [0x3979] = 0x51f8, [0x397a] = 0x79c3,
  [0x397b] = 0x7a81, [0x397c] = 0x56fe, [0x397d] = 0x5f92, [0x397e] = 0x9014,
  [0x397f] = 0x6d82, [0x3980] = 0x5c60, [0x3981] = 0x571f, [0x3982] = 0x5410,
  [0x3983] = 0x5154, [0x3984] = 0x6e4d, [0x3985] = 0x56e2, [0x3986] = 0x63a8,
  [0x3987] = 0x9893, [0x3988] = 0x817f, [0x3989] = 0x8715, [0x398a] = 0x892a,
  [0x398b] = 0x9000, [0x398c] = 0x541e, [0x398d] = 0x5c6f, [0x398e] = 0x81c0,
  [0x398f] = 0x62d6, [0x3990] = 0x6258, [0x3991] = 0x8131, [0x3992] = 0x9e35,
  [0x3993] = 0x9640, [0x3994] = 0x9a6e, [0x3995] = 0x9a7c, [0x3996] = 0x692d,
  [0x3997] = 0x59a5, [0x3998] = 0x62d3, [0x3999] = 0x553e, [0x399a] = 0x6316,
  [0x399b] = 0x54c7, [0x399c] = 0x86d9, [0x399d] = 0x6d3c, [0x399e] = 0x5a03,
  [0x399f] = 0x74e6, [0x39a0] = 0x889c, [0x39a1] = 0x6b6a, [0x39a2] = 0x5916,
  [0x39a3] = 0x8c4c, [0x39a4] = 0x5f2f, [0x39a5] = 0x6e7e, [0x39a6] = 0x73a9,
  [0x39a7] = 0x987d, [0x39a8] = 0x4e38, [0x39a9] = 0x70f7, [0x39aa] = 0x5b8c,
  [0x39ab] = 0x7897, [0x39ac] = 0x633d, [0x39ad] = 0x665a, [0x39ae] = 0x7696,
  [0x39af] = 0x60cb, [0x39b0] = 0x5b9b, [0x39b1] = 0x5a49, [0x39b2] = 0x4e07,
  [0x39b3] = 0x8155, [0x39b4] = 0x6c6a, [0x39b5] = 0x738b, [0x39b6] = 0x4ea1,
  [0x39b7] = 0x6789, [0x39b8] = 0x7f51, [0x39b9] = 0x5f80, [0x39ba] = 0x65fa,
  [0x39bb] = 0x671b, [0x39bc] = 0x5fd8, [0x39bd] = 0x5984, [0x39be] = 0x5a01,
  [0x39c0] = 0x8719, [0x39c1] = 0x871b, [0x39c2] = 0x871d, [0x39c3] = 0x871f,
  [0x39c4] = 0x8720, [0x39c5] = 0x8724, [0x39c6] = 0x8726, [0x39c7] = 0x8727,
  [0x39c8] = 0x8728, [0x39c9] = 0x872a, [0x39ca] = 0x872b, [0x39cb] = 0x872c,
  [0x39cc] = 0x872d, [0x39cd] = 0x872f, [0x39ce] = 0x8730, [0x39cf] = 0x8732,
  [0x39d0] = 0x8733, [0x39d1] = 0x8735, [0x39d2] = 0x8736, [0x39d3] = 0x8738,
  [0x39d4] = 0x8739, [0x39d5] = 0x873a, [0x39d6] = 0x873c, [0x39d7] = 0x873d,
  [0x39d8] = 0x8740, [0x39d9] = 0x8741, [0x39da] = 0x8742, [0x39db] = 0x8743,
  [0x39dc] = 0x8744, [0x39dd] = 0x8745, [0x39de] = 0x8746, [0x39df] = 0x874a,
  [0x39e0] = 0x874b, [0x39e1] = 0x874d, [0x39e2] = 0x874f, [0x39e3] = 0x8750,
  [0x39e4] = 0x8751, [0x39e5] = 0x8752, [0x39e6] = 0x8754, [0x39e7] = 0x8755,
  [0x39e8] = 0x8756, [0x39e9] = 0x8758, [0x39ea] = 0x875a, [0x39eb] = 0x875b,
  [0x39ec] = 0x875c, [0x39ed] = 0x875d, [0x39ee] = 0x875e, [0x39ef] = 0x875f,
  [0x39f0] = 0x8761, [0x39f1] = 0x8762, [0x39f2] = 0x8766, [0x39f3] = 0x8767,
  [0x39f4] = 0x8768, [0x39f5] = 0x8769, [0x39f6] = 0x876a, [0x39f7] = 0x876b,
  [0x39f8] = 0x876c, [0x39f9] = 0x876d, [0x39fa] = 0x876f, [0x39fb] = 0x8771,
  [0x39fc] = 0x8772, [0x39fd] = 0x8773, [0x39fe] = 0x8775, [0x3a00] = 0x8777,
  [0x3a01] = 0x8778, [0x3a02] = 0x8779, [0x3a03] = 0x877a, [0x3a04] = 0x877f,
  [0x3a05] = 0x8780, [0x3a06] = 0x8781, [0x3a07] = 0x8784, [0x3a08] = 0x8786,
  [0x3a09] = 0x8787, [0x3a0a] = 0x8789, [0x3a0b] = 0x878a, [0x3a0c] = 0x878c,
  [0x3a0d] = 0x878e, [0x3a0e] = 0x878f, [0x3a0f] = 0x8790, [0x3a10] = 0x8791,
  [0x3a11] = 0x8792, [0x3a12] = 0x8794, [0x3a13] = 0x8795, [0x3a14] = 0x8796,
  [0x3a15] = 0x8798, [0x3a16] = 0x8799, [0x3a17] = 0x879a, [0x3a18] = 0x879b,
  [0x3a19] = 0x879c, [0x3a1a] = 0x879d, [0x3a1b] = 0x879e, [0x3a1c] = 0x87a0,
  [0x3a1d] = 0x87a1, [0x3a1e] = 0x87a2, [0x3a1f] = 0x87a3, [0x3a20] = 0x87a4,
  [0x3a21] = 0x5dcd, [0x3a22] = 0x5fae, [0x3a23] = 0x5371, [0x3a24] = 0x97e6,
  [0x3a25] = 0x8fdd, [0x3a26] = 0x6845, [0x3a27] = 0x56f4, [0x3a28] = 0x552f,
  [0x3a29] = 0x60df, [0x3a2a] = 0x4e3a, [0x3a2b] = 0x6f4d, [0x3a2c] = 0x7ef4,
  [0x3a2d] = 0x82c7, [0x3a2e] = 0x840e, [0x3a2f] = 0x59d4, [0x3a30] = 0x4f1f,
  [0x3a31] = 0x4f2a, [0x3a32] = 0x5c3e, [0x3a33] = 0x7eac, [0x3a34] = 0x672a,
  [0x3a35] = 0x851a, [0x3a36] = 0x5473, [0x3a37] = 0x754f, [0x3a38] = 0x80c3,
  [0x3a39] = 0x5582, [0x3a3a] = 0x9b4f, [0x3a3b] = 0x4f4d, [0x3a3c] = 0x6e2d,
  [0x3a3d] = 0x8c13, [0x3a3e] = 0x5c09, [0x3a3f] = 0x6170, [0x3a40] = 0x536b,
  [0x3a41] = 0x761f, [0x3a42] = 0x6e29, [0x3a43] = 0x868a, [0x3a44] = 0x6587,
  [0x3a45] = 0x95fb, [0x3a46] = 0x7eb9, [0x3a47] = 0x543b, [0x3a48] = 0x7a33,
  [0x3a49] = 0x7d0a, [0x3a4a] = 0x95ee, [0x3a4b] = 0x55e1, [0x3a4c] = 0x7fc1,
  [0x3a4d] = 0x74ee, [0x3a4e] = 0x631d, [0x3a4f] = 0x8717, [0x3a50] = 0x6da1,
  [0x3a51] = 0x7a9d, [0x3a52] = 0x6211, [0x3a53] = 0x65a1, [0x3a54] = 0x5367,
  [0x3a55] = 0x63e1, [0x3a56] = 0x6c83, [0x3a57] = 0x5deb, [0x3a58] = 0x545c,
  [0x3a59] = 0x94a8, [0x3a5a] = 0x4e4c, [0x3a5b] = 0x6c61, [0x3a5c] = 0x8bec,
  [0x3a5d] = 0x5c4b, [0x3a5e] = 0x65e0, [0x3a5f] = 0x829c, [0x3a60] = 0x68a7,
  [0x3a61] = 0x543e, [0x3a62] = 0x5434, [0x3a63] = 0x6bcb, [0x3a64] = 0x6b66,
  [0x3a65] = 0x4e94, [0x3a66] = 0x6342, [0x3a67] = 0x5348, [0x3a68] = 0x821e,
  [0x3a69] = 0x4f0d, [0x3a6a] = 0x4fae, [0x3a6b] = 0x575e, [0x3a6c] = 0x620a,
  [0x3a6d] = 0x96fe, [0x3a6e] = 0x6664, [0x3a6f] = 0x7269, [0x3a70] = 0x52ff,
  [0x3a71] = 0x52a1, [0x3a72] = 0x609f, [0x3a73] = 0x8bef, [0x3a74] = 0x6614,
  [0x3a75] = 0x7199, [0x3a76] = 0x6790, [0x3a77] = 0x897f, [0x3a78] = 0x7852,
  [0x3a79] = 0x77fd, [0x3a7a] = 0x6670, [0x3a7b] = 0x563b, [0x3a7c] = 0x5438,
  [0x3a7d] = 0x9521, [0x3a7e] = 0x727a, [0x3a80] = 0x87a5, [0x3a81] = 0x87a6,
  [0x3a82] = 0x87a7, [0x3a83] = 0x87a9, [0x3a84] = 0x87aa, [0x3a85] = 0x87ae,
  [0x3a86] = 0x87b0, [0x3a87] = 0x87b1, [0x3a88] = 0x87b2, [0x3a89] = 0x87b4,
  [0x3a8a] = 0x87b6, [0x3a8b] = 0x87b7, [0x3a8c] = 0x87b8, [0x3a8d] = 0x87b9,
  [0x3a8e] = 0x87bb, [0x3a8f] = 0x87bc, [0x3a90] = 0x87be, [0x3a91] = 0x87bf,
  [0x3a92] = 0x87c1, [0x3a93] = 0x87c2, [0x3a94] = 0x87c3, [0x3a95] = 0x87c4,
  [0x3a96] = 0x87c5, [0x3a97] = 0x87c7, [0x3a98] = 0x87c8, [0x3a99] = 0x87c9,
  [0x3a9a] = 0x87cc, [0x3a9b] = 0x87cd, [0x3a9c] = 0x87ce, [0x3a9d] = 0x87cf,
  [0x3a9e] = 0x87d0, [0x3a9f] = 0x87d4, [0x3aa0] = 0x87d5, [0x3aa1] = 0x87d6,
  [0x3aa2] = 0x87d7, [0x3aa3] = 0x87d8, [0x3aa4] = 0x87d9, [0x3aa5] = 0x87da,
  [0x3aa6] = 0x87dc, [0x3aa7] = 0x87dd, [0x3aa8] = 0x87de, [0x3aa9] = 0x87df,
  [0x3aaa] = 0x87e1, [0x3aab] = 0x87e2, [0x3aac] = 0x87e3, [0x3aad] = 0x87e4,
  [0x3aae] = 0x87e6, [0x3aaf] = 0x87e7, [0x3ab0] = 0x87e8, [0x3ab1] = 0x87e9,
  [0x3ab2] = 0x87eb, [0x3ab3] = 0x87ec, [0x3ab4] = 0x87ed, [0x3ab5] = 0x87ef,
  [0x3ab6] = 0x87f0, [0x3ab7] = 0x87f1, [0x3ab8] = 0x87f2, [0x3ab9] = 0x87f3,
  [0x3aba] = 0x87f4, [0x3abb] = 0x87f5, [0x3abc] = 0x87f6, [0x3abd] = 0x87f7,
  [0x3abe] = 0x87f8, [0x3ac0] = 0x87fa, [0x3ac1] = 0x87fb, [0x3ac2] = 0x87fc,
  [0x3ac3] = 0x87fd, [0x3ac4] = 0x87ff, [0x3ac5] = 0x8800, [0x3ac6] = 0x8801,
  [0x3ac7] = 0x8802, [0x3ac8] = 0x8804, [0x3ac9] = 0x8805, [0x3aca] = 0x8806,
  [0x3acb] = 0x8807, [0x3acc] = 0x8808, [0x3acd] = 0x8809, [0x3ace] = 0x880b,
  [0x3acf] = 0x880c, [0x3ad0] = 0x880d, [0x3ad1] = 0x880e, [0x3ad2] = 0x880f,
  [0x3ad3] = 0x8810, [0x3ad4] = 0x8811, [0x3ad5] = 0x8812, [0x3ad6] = 0x8814,
  [0x3ad7] = 0x8817, [0x3ad8] = 0x8818, [0x3ad9] = 0x8819, [0x3ada] = 0x881a,
  [0x3adb] = 0x881c, [0x3adc] = 0x881d, [0x3add] = 0x881e, [0x3ade] = 0x881f,
  [0x3adf] = 0x8820, [0x3ae0] = 0x8823, [0x3ae1] = 0x7a00, [0x3ae2] = 0x606f,
  [0x3ae3] = 0x5e0c, [0x3ae4] = 0x6089, [0x3ae5] = 0x819d, [0x3ae6] = 0x5915,
  [0x3ae7] = 0x60dc, [0x3ae8] = 0x7184, [0x3ae9] = 0x70ef, [0x3aea] = 0x6eaa,
  [0x3aeb] = 0x6c50, [0x3aec] = 0x7280, [0x3aed] = 0x6a84, [0x3aee] = 0x88ad,
  [0x3aef] = 0x5e2d, [0x3af0] = 0x4e60, [0x3af1] = 0x5ab3, [0x3af2] = 0x559c,
  [0x3af3] = 0x94e3, [0x3af4] = 0x6d17, [0x3af5] = 0x7cfb, [0x3af6] = 0x9699,
  [0x3af7] = 0x620f, [0x3af8] = 0x7ec6, [0x3af9] = 0x778e, [0x3afa] = 0x867e,
  [0x3afb] = 0x5323, [0x3afc] = 0x971e, [0x3afd] = 0x8f96, [0x3afe] = 0x6687,
  [0x3aff] = 0x5ce1, [0x3b00] = 0x4fa0, [0x3b01] = 0x72ed, [0x3b02] = 0x4e0b,
  [0x3b03] = 0x53a6, [0x3b04] = 0x590f, [0x3b05] = 0x5413, [0x3b06] = 0x6380,
  [0x3b07] = 0x9528, [0x3b08] = 0x5148, [0x3b09] = 0x4ed9, [0x3b0a] = 0x9c9c,
  [0x3b0b] = 0x7ea4, [0x3b0c] = 0x54b8, [0x3b0d] = 0x8d24, [0x3b0e] = 0x8854,
  [0x3b0f] = 0x8237, [0x3b10] = 0x95f2, [0x3b11] = 0x6d8e, [0x3b12] = 0x5f26,
  [0x3b13] = 0x5acc, [0x3b14] = 0x663e, [0x3b15] = 0x9669, [0x3b16] = 0x73b0,
  [0x3b17] = 0x732e, [0x3b18] = 0x53bf, [0x3b19] = 0x817a, [0x3b1a] = 0x9985,
  [0x3b1b] = 0x7fa1, [0x3b1c] = 0x5baa, [0x3b1d] = 0x9677, [0x3b1e] = 0x9650,
  [0x3b1f] = 0x7ebf, [0x3b20] = 0x76f8, [0x3b21] = 0x53a2, [0x3b22] = 0x9576,
  [0x3b23] = 0x9999, [0x3b24] = 0x7bb1, [0x3b25] = 0x8944, [0x3b26] = 0x6e58,
  [0x3b27] = 0x4e61, [0x3b28] = 0x7fd4, [0x3b29] = 0x7965, [0x3b2a] = 0x8be6,
  [0x3b2b] = 0x60f3, [0x3b2c] = 0x54cd, [0x3b2d] = 0x4eab, [0x3b2e] = 0x9879,
  [0x3b2f] = 0x5df7, [0x3b30] = 0x6a61, [0x3b31] = 0x50cf, [0x3b32] = 0x5411,
  [0x3b33] = 0x8c61, [0x3b34] = 0x8427, [0x3b35] = 0x785d, [0x3b36] = 0x9704,
  [0x3b37] = 0x524a, [0x3b38] = 0x54ee, [0x3b39] = 0x56a3, [0x3b3a] = 0x9500,
  [0x3b3b] = 0x6d88, [0x3b3c] = 0x5bb5, [0x3b3d] = 0x6dc6, [0x3b3e] = 0x6653,
  [0x3b40] = 0x8824, [0x3b41] = 0x8825, [0x3b42] = 0x8826, [0x3b43] = 0x8827,
  [0x3b44] = 0x8828, [0x3b45] = 0x8829, [0x3b46] = 0x882a, [0x3b47] = 0x882b,
  [0x3b48] = 0x882c, [0x3b49] = 0x882d, [0x3b4a] = 0x882e, [0x3b4b] = 0x882f,
  [0x3b4c] = 0x8830, [0x3b4d] = 0x8831, [0x3b4e] = 0x8833, [0x3b4f] = 0x8834,
  [0x3b50] = 0x8835, [0x3b51] = 0x8836, [0x3b52] = 0x8837, [0x3b53] = 0x8838,
  [0x3b54] = 0x883a, [0x3b55] = 0x883b, [0x3b56] = 0x883d, [0x3b57] = 0x883e,
  [0x3b58] = 0x883f, [0x3b59] = 0x8841, [0x3b5a] = 0x8842, [0x3b5b] = 0x8843,
  [0x3b5c] = 0x8846, [0x3b5d] = 0x8847, [0x3b5e] = 0x8848, [0x3b5f] = 0x8849,
  [0x3b60] = 0x884a, [0x3b61] = 0x884b, [0x3b62] = 0x884e, [0x3b63] = 0x884f,
  [0x3b64] = 0x8850, [0x3b65] = 0x8851, [0x3b66] = 0x8852, [0x3b67] = 0x8853,
  [0x3b68] = 0x8855, [0x3b69] = 0x8856, [0x3b6a] = 0x8858, [0x3b6b] = 0x885a,
  [0x3b6c] = 0x885b, [0x3b6d] = 0x885c, [0x3b6e] = 0x885d, [0x3b6f] = 0x885e,
  [0x3b70] = 0x885f, [0x3b71] = 0x8860, [0x3b72] = 0x8866, [0x3b73] = 0x8867,
  [0x3b74] = 0x886a, [0x3b75] = 0x886d, [0x3b76] = 0x886f, [0x3b77] = 0x8871,
  [0x3b78] = 0x8873, [0x3b79] = 0x8874, [0x3b7a] = 0x8875, [0x3b7b] = 0x8876,
  [0x3b7c] = 0x8878, [0x3b7d] = 0x8879, [0x3b7e] = 0x887a, [0x3b80] = 0x887b,
  [0x3b81] = 0x887c, [0x3b82] = 0x8880, [0x3b83] = 0x8883, [0x3b84] = 0x8886,
  [0x3b85] = 0x8887, [0x3b86] = 0x8889, [0x3b87] = 0x888a, [0x3b88] = 0x888c,
  [0x3b89] = 0x888e, [0x3b8a] = 0x888f, [0x3b8b] = 0x8890, [0x3b8c] = 0x8891,
  [0x3b8d] = 0x8893, [0x3b8e] = 0x8894, [0x3b8f] = 0x8895, [0x3b90] = 0x8897,
  [0x3b91] = 0x8898, [0x3b92] = 0x8899, [0x3b93] = 0x889a, [0x3b94] = 0x889b,
  [0x3b95] = 0x889d, [0x3b96] = 0x889e, [0x3b97] = 0x889f, [0x3b98] = 0x88a0,
  [0x3b99] = 0x88a1, [0x3b9a] = 0x88a3, [0x3b9b] = 0x88a5, [0x3b9c] = 0x88a6,
  [0x3b9d] = 0x88a7, [0x3b9e] = 0x88a8, [0x3b9f] = 0x88a9, [0x3ba0] = 0x88aa,
  [0x3ba1] = 0x5c0f, [0x3ba2] = 0x5b5d, [0x3ba3] = 0x6821, [0x3ba4] = 0x8096,
  [0x3ba5] = 0x5578, [0x3ba6] = 0x7b11, [0x3ba7] = 0x6548, [0x3ba8] = 0x6954,
  [0x3ba9] = 0x4e9b, [0x3baa] = 0x6b47, [0x3bab] = 0x874e, [0x3bac] = 0x978b,
  [0x3bad] = 0x534f, [0x3bae] = 0x631f, [0x3baf] = 0x643a, [0x3bb0] = 0x90aa,
  [0x3bb1] = 0x659c, [0x3bb2] = 0x80c1, [0x3bb3] = 0x8c10, [0x3bb4] = 0x5199,
  [0x3bb5] = 0x68b0, [0x3bb6] = 0x5378, [0x3bb7] = 0x87f9, [0x3bb8] = 0x61c8,
  [0x3bb9] = 0x6cc4, [0x3bba] = 0x6cfb, [0x3bbb] = 0x8c22, [0x3bbc] = 0x5c51,
  [0x3bbd] = 0x85aa, [0x3bbe] = 0x82af, [0x3bbf] = 0x950c, [0x3bc0] = 0x6b23,
  [0x3bc1] = 0x8f9b, [0x3bc2] = 0x65b0, [0x3bc3] = 0x5ffb, [0x3bc4] = 0x5fc3,
  [0x3bc5] = 0x4fe1, [0x3bc6] = 0x8845, [0x3bc7] = 0x661f, [0x3bc8] = 0x8165,
  [0x3bc9] = 0x7329, [0x3bca] = 0x60fa, [0x3bcb] = 0x5174, [0x3bcc] = 0x5211,
  [0x3bcd] = 0x578b, [0x3bce] = 0x5f62, [0x3bcf] = 0x90a2, [0x3bd0] = 0x884c,
  [0x3bd1] = 0x9192, [0x3bd2] = 0x5e78, [0x3bd3] = 0x674f, [0x3bd4] = 0x6027,
  [0x3bd5] = 0x59d3, [0x3bd6] = 0x5144, [0x3bd7] = 0x51f6, [0x3bd8] = 0x80f8,
  [0x3bd9] = 0x5308, [0x3bda] = 0x6c79, [0x3bdb] = 0x96c4, [0x3bdc] = 0x718a,
  [0x3bdd] = 0x4f11, [0x3bde] = 0x4fee, [0x3bdf] = 0x7f9e, [0x3be0] = 0x673d,
  [0x3be1] = 0x55c5, [0x3be2] = 0x9508, [0x3be3] = 0x79c0, [0x3be4] = 0x8896,
  [0x3be5] = 0x7ee3, [0x3be6] = 0x589f, [0x3be7] = 0x620c, [0x3be8] = 0x9700,
  [0x3be9] = 0x865a, [0x3bea] = 0x5618, [0x3beb] = 0x987b, [0x3bec] = 0x5f90,
  [0x3bed] = 0x8bb8, [0x3bee] = 0x84c4, [0x3bef] = 0x9157, [0x3bf0] = 0x53d9,
  [0x3bf1] = 0x65ed, [0x3bf2] = 0x5e8f, [0x3bf3] = 0x755c, [0x3bf4] = 0x6064,
  [0x3bf5] = 0x7d6e, [0x3bf6] = 0x5a7f, [0x3bf7] = 0x7eea, [0x3bf8] = 0x7eed,
  [0x3bf9] = 0x8f69, [0x3bfa] = 0x55a7, [0x3bfb] = 0x5ba3, [0x3bfc] = 0x60ac,
  [0x3bfd] = 0x65cb, [0x3bfe] = 0x7384, [0x3c00] = 0x88ac, [0x3c01] = 0x88ae,
  [0x3c02] = 0x88af, [0x3c03] = 0x88b0, [0x3c04] = 0x88b2, [0x3c05] = 0x88b3,
  [0x3c06] = 0x88b4, [0x3c07] = 0x88b5, [0x3c08] = 0x88b6, [0x3c09] = 0x88b8,
  [0x3c0a] = 0x88b9, [0x3c0b] = 0x88ba, [0x3c0c] = 0x88bb, [0x3c0d] = 0x88bd,
  [0x3c0e] = 0x88be, [0x3c0f] = 0x88bf, [0x3c10] = 0x88c0, [0x3c11] = 0x88c3,
  [0x3c12] = 0x88c4, [0x3c13] = 0x88c7, [0x3c14] = 0x88c8, [0x3c15] = 0x88ca,
  [0x3c16] = 0x88cb, [0x3c17] = 0x88cc, [0x3c18] = 0x88cd, [0x3c19] = 0x88cf,
  [0x3c1a] = 0x88d0, [0x3c1b] = 0x88d1, [0x3c1c] = 0x88d3, [0x3c1d] = 0x88d6,
  [0x3c1e] = 0x88d7, [0x3c1f] = 0x88da, [0x3c20] = 0x88db, [0x3c21] = 0x88dc,
  [0x3c22] = 0x88dd, [0x3c23] = 0x88de, [0x3c24] = 0x88e0, [0x3c25] = 0x88e1,
  [0x3c26] = 0x88e6, [0x3c27] = 0x88e7, [0x3c28] = 0x88e9, [0x3c29] = 0x88ea,
  [0x3c2a] = 0x88eb, [0x3c2b] = 0x88ec, [0x3c2c] = 0x88ed, [0x3c2d] = 0x88ee,
  [0x3c2e] = 0x88ef, [0x3c2f] = 0x88f2, [0x3c30] = 0x88f5, [0x3c31] = 0x88f6,
  [0x3c32] = 0x88f7, [0x3c33] = 0x88fa, [0x3c34] = 0x88fb, [0x3c35] = 0x88fd,
  [0x3c36] = 0x88ff, [0x3c37] = 0x8900, [0x3c38] = 0x8901, [0x3c39] = 0x8903,
  [0x3c3a] = 0x8904, [0x3c3b] = 0x8905, [0x3c3c] = 0x8906, [0x3c3d] = 0x8907,
  [0x3c3e] = 0x8908, [0x3c40] = 0x8909, [0x3c41] = 0x890b, [0x3c42] = 0x890c,
  [0x3c43] = 0x890d, [0x3c44] = 0x890e, [0x3c45] = 0x890f, [0x3c46] = 0x8911,
  [0x3c47] = 0x8914, [0x3c48] = 0x8915, [0x3c49] = 0x8916, [0x3c4a] = 0x8917,
  [0x3c4b] = 0x8918, [0x3c4c] = 0x891c, [0x3c4d] = 0x891d, [0x3c4e] = 0x891e,
  [0x3c4f] = 0x891f, [0x3c50] = 0x8920, [0x3c51] = 0x8922, [0x3c52] = 0x8923,
  [0x3c53] = 0x8924, [0x3c54] = 0x8926, [0x3c55] = 0x8927, [0x3c56] = 0x8928,
  [0x3c57] = 0x8929, [0x3c58] = 0x892c, [0x3c59] = 0x892d, [0x3c5a] = 0x892e,
  [0x3c5b] = 0x892f, [0x3c5c] = 0x8931, [0x3c5d] = 0x8932, [0x3c5e] = 0x8933,
  [0x3c5f] = 0x8935, [0x3c60] = 0x8937, [0x3c61] = 0x9009, [0x3c62] = 0x7663,
  [0x3c63] = 0x7729, [0x3c64] = 0x7eda, [0x3c65] = 0x9774, [0x3c66] = 0x859b,
  [0x3c67] = 0x5b66, [0x3c68] = 0x7a74, [0x3c69] = 0x96ea, [0x3c6a] = 0x8840,
  [0x3c6b] = 0x52cb, [0x3c6c] = 0x718f, [0x3c6d] = 0x5faa, [0x3c6e] = 0x65ec,
  [0x3c6f] = 0x8be2, [0x3c70] = 0x5bfb, [0x3c71] = 0x9a6f, [0x3c72] = 0x5de1,
  [0x3c73] = 0x6b89, [0x3c74] = 0x6c5b, [0x3c75] = 0x8bad, [0x3c76] = 0x8baf,
  [0x3c77] = 0x900a, [0x3c78] = 0x8fc5, [0x3c79] = 0x538b, [0x3c7a] = 0x62bc,
  [0x3c7b] = 0x9e26, [0x3c7c] = 0x9e2d, [0x3c7d] = 0x5440, [0x3c7e] = 0x4e2b,
  [0x3c7f] = 0x82bd, [0x3c80] = 0x7259, [0x3c81] = 0x869c, [0x3c82] = 0x5d16,
  [0x3c83] = 0x8859, [0x3c84] = 0x6daf, [0x3c85] = 0x96c5, [0x3c86] = 0x54d1,
  [0x3c87] = 0x4e9a, [0x3c88] = 0x8bb6, [0x3c89] = 0x7109, [0x3c8a] = 0x54bd,
  [0x3c8b] = 0x9609, [0x3c8c] = 0x70df, [0x3c8d] = 0x6df9, [0x3c8e] = 0x76d0,
  [0x3c8f] = 0x4e25, [0x3c90] = 0x7814, [0x3c91] = 0x8712, [0x3c92] = 0x5ca9,
  [0x3c93] = 0x5ef6, [0x3c94] = 0x8a00, [0x3c95] = 0x989c, [0x3c96] = 0x960e,
  [0x3c97] = 0x708e, [0x3c98] = 0x6cbf, [0x3c99] = 0x5944, [0x3c9a] = 0x63a9,
  [0x3c9b] = 0x773c, [0x3c9c] = 0x884d, [0x3c9d] = 0x6f14, [0x3c9e] = 0x8273,
  [0x3c9f] = 0x5830, [0x3ca0] = 0x71d5, [0x3ca1] = 0x538c, [0x3ca2] = 0x781a,
  [0x3ca3] = 0x96c1, [0x3ca4] = 0x5501, [0x3ca5] = 0x5f66, [0x3ca6] = 0x7130,
  [0x3ca7] = 0x5bb4, [0x3ca8] = 0x8c1a, [0x3ca9] = 0x9a8c, [0x3caa] = 0x6b83,
  [0x3cab] = 0x592e, [0x3cac] = 0x9e2f, [0x3cad] = 0x79e7, [0x3cae] = 0x6768,
  [0x3caf] = 0x626c, [0x3cb0] = 0x4f6f, [0x3cb1] = 0x75a1, [0x3cb2] = 0x7f8a,
  [0x3cb3] = 0x6d0b, [0x3cb4] = 0x9633, [0x3cb5] = 0x6c27, [0x3cb6] = 0x4ef0,
  [0x3cb7] = 0x75d2, [0x3cb8] = 0x517b, [0x3cb9] = 0x6837, [0x3cba] = 0x6f3e,
  [0x3cbb] = 0x9080, [0x3cbc] = 0x8170, [0x3cbd] = 0x5996, [0x3cbe] = 0x7476,
  [0x3cc0] = 0x8938, [0x3cc1] = 0x8939, [0x3cc2] = 0x893a, [0x3cc3] = 0x893b,
  [0x3cc4] = 0x893c, [0x3cc5] = 0x893d, [0x3cc6] = 0x893e, [0x3cc7] = 0x893f,
  [0x3cc8] = 0x8940, [0x3cc9] = 0x8942, [0x3cca] = 0x8943, [0x3ccb] = 0x8945,
  [0x3ccc] = 0x8946, [0x3ccd] = 0x8947, [0x3cce] = 0x8948, [0x3ccf] = 0x8949,
  [0x3cd0] = 0x894a, [0x3cd1] = 0x894b, [0x3cd2] = 0x894c, [0x3cd3] = 0x894d,
  [0x3cd4] = 0x894e, [0x3cd5] = 0x894f, [0x3cd6] = 0x8950, [0x3cd7] = 0x8951,
  [0x3cd8] = 0x8952, [0x3cd9] = 0x8953, [0x3cda] = 0x8954, [0x3cdb] = 0x8955,
  [0x3cdc] = 0x8956, [0x3cdd] = 0x8957, [0x3cde] = 0x8958, [0x3cdf] = 0x8959,
  [0x3ce0] = 0x895a, [0x3ce1] = 0x895b, [0x3ce2] = 0x895c, [0x3ce3] = 0x895d,
  [0x3ce4] = 0x8960, [0x3ce5] = 0x8961, [0x3ce6] = 0x8962, [0x3ce7] = 0x8963,
  [0x3ce8] = 0x8964, [0x3ce9] = 0x8965, [0x3cea] = 0x8967, [0x3ceb] = 0x8968,
  [0x3cec] = 0x8969, [0x3ced] = 0x896a, [0x3cee] = 0x896b, [0x3cef] = 0x896c,
  [0x3cf0] = 0x896d, [0x3cf1] = 0x896e, [0x3cf2] = 0x896f, [0x3cf3] = 0x8970,
  [0x3cf4] = 0x8971, [0x3cf5] = 0x8972, [0x3cf6] = 0x8973, [0x3cf7] = 0x8974,
  [0x3cf8] = 0x8975, [0x3cf9] = 0x8976, [0x3cfa] = 0x8977, [0x3cfb] = 0x8978,
  [0x3cfc] = 0x8979, [0x3cfd] = 0x897a, [0x3cfe] = 0x897c, [0x3d00] = 0x897d,
  [0x3d01] = 0x897e, [0x3d02] = 0x8980, [0x3d03] = 0x8982, [0x3d04] = 0x8984,
  [0x3d05] = 0x8985, [0x3d06] = 0x8987, [0x3d07] = 0x8988, [0x3d08] = 0x8989,
  [0x3d09] = 0x898a, [0x3d0a] = 0x898b, [0x3d0b] = 0x898c, [0x3d0c] = 0x898d,
  [0x3d0d] = 0x898e, [0x3d0e] = 0x898f, [0x3d0f] = 0x8990, [0x3d10] = 0x8991,
  [0x3d11] = 0x8992, [0x3d12] = 0x8993, [0x3d13] = 0x8994, [0x3d14] = 0x8995,
  [0x3d15] = 0x8996, [0x3d16] = 0x8997, [0x3d17] = 0x8998, [0x3d18] = 0x8999,
  [0x3d19] = 0x899a, [0x3d1a] = 0x899b, [0x3d1b] = 0x899c, [0x3d1c] = 0x899d,
  [0x3d1d] = 0x899e, [0x3d1e] = 0x899f, [0x3d1f] = 0x89a0, [0x3d20] = 0x89a1,
  [0x3d21] = 0x6447, [0x3d22] = 0x5c27, [0x3d23] = 0x9065, [0x3d24] = 0x7a91,
  [0x3d25] = 0x8c23, [0x3d26] = 0x59da, [0x3d27] = 0x54ac, [0x3d28] = 0x8200,
  [0x3d29] = 0x836f, [0x3d2a] = 0x8981, [0x3d2b] = 0x8000, [0x3d2c] = 0x6930,
  [0x3d2d] = 0x564e, [0x3d2e] = 0x8036, [0x3d2f] = 0x7237, [0x3d30] = 0x91ce,
  [0x3d31] = 0x51b6, [0x3d32] = 0x4e5f, [0x3d33] = 0x9875, [0x3d34] = 0x6396,
  [0x3d35] = 0x4e1a, [0x3d36] = 0x53f6, [0x3d37] = 0x66f3, [0x3d38] = 0x814b,
  [0x3d39] = 0x591c, [0x3d3a] = 0x6db2, [0x3d3b] = 0x4e00, [0x3d3c] = 0x58f9,
  [0x3d3d] = 0x533b, [0x3d3e] = 0x63d6, [0x3d3f] = 0x94f1, [0x3d40] = 0x4f9d,
  [0x3d41] = 0x4f0a, [0x3d42] = 0x8863, [0x3d43] = 0x9890, [0x3d44] = 0x5937,
  [0x3d45] = 0x9057, [0x3d46] = 0x79fb, [0x3d47] = 0x4eea, [0x3d48] = 0x80f0,
  [0x3d49] = 0x7591, [0x3d4a] = 0x6c82, [0x3d4b] = 0x5b9c, [0x3d4c] = 0x59e8,
  [0x3d4d] = 0x5f5d, [0x3d4e] = 0x6905, [0x3d4f] = 0x8681, [0x3d50] = 0x501a,
  [0x3d51] = 0x5df2, [0x3d52] = 0x4e59, [0x3d53] = 0x77e3, [0x3d54] = 0x4ee5,
  [0x3d55] = 0x827a, [0x3d56] = 0x6291, [0x3d57] = 0x6613, [0x3d58] = 0x9091,
  [0x3d59] = 0x5c79, [0x3d5a] = 0x4ebf, [0x3d5b] = 0x5f79, [0x3d5c] = 0x81c6,
  [0x3d5d] = 0x9038, [0x3d5e] = 0x8084, [0x3d5f] = 0x75ab, [0x3d60] = 0x4ea6,
  [0x3d61] = 0x88d4, [0x3d62] = 0x610f, [0x3d63] = 0x6bc5, [0x3d64] = 0x5fc6,
  [0x3d65] = 0x4e49, [0x3d66] = 0x76ca, [0x3d67] = 0x6ea2, [0x3d68] = 0x8be3,
  [0x3d69] = 0x8bae, [0x3d6a] = 0x8c0a, [0x3d6b] = 0x8bd1, [0x3d6c] = 0x5f02,
  [0x3d6d] = 0x7ffc, [0x3d6e] = 0x7fcc, [0x3d6f] = 0x7ece, [0x3d70] = 0x8335,
  [0x3d71] = 0x836b, [0x3d72] = 0x56e0, [0x3d73] = 0x6bb7, [0x3d74] = 0x97f3,
  [0x3d75] = 0x9634, [0x3d76] = 0x59fb, [0x3d77] = 0x541f, [0x3d78] = 0x94f6,
  [0x3d79] = 0x6deb, [0x3d7a] = 0x5bc5, [0x3d7b] = 0x996e, [0x3d7c] = 0x5c39,
  [0x3d7d] = 0x5f15, [0x3d7e] = 0x9690, [0x3d80] = 0x89a2, [0x3d81] = 0x89a3,
  [0x3d82] = 0x89a4, [0x3d83] = 0x89a5, [0x3d84] = 0x89a6, [0x3d85] = 0x89a7,
  [0x3d86] = 0x89a8, [0x3d87] = 0x89a9, [0x3d88] = 0x89aa, [0x3d89] = 0x89ab,
  [0x3d8a] = 0x89ac, [0x3d8b] = 0x89ad, [0x3d8c] = 0x89ae, [0x3d8d] = 0x89af,
  [0x3d8e] = 0x89b0, [0x3d8f] = 0x89b1, [0x3d90] = 0x89b2, [0x3d91] = 0x89b3,
  [0x3d92] = 0x89b4, [0x3d93] = 0x89b5, [0x3d94] = 0x89b6, [0x3d95] = 0x89b7,
  [0x3d96] = 0x89b8, [0x3d97] = 0x89b9, [0x3d98] = 0x89ba, [0x3d99] = 0x89bb,
  [0x3d9a] = 0x89bc, [0x3d9b] = 0x89bd, [0x3d9c] = 0x89be, [0x3d9d] = 0x89bf,
  [0x3d9e] = 0x89c0, [0x3d9f] = 0x89c3, [0x3da0] = 0x89cd, [0x3da1] = 0x89d3,
  [0x3da2] = 0x89d4, [0x3da3] = 0x89d5, [0x3da4] = 0x89d7, [0x3da5] = 0x89d8,
  [0x3da6] = 0x89d9, [0x3da7] = 0x89db, [0x3da8] = 0x89dd, [0x3da9] = 0x89df,
  [0x3daa] = 0x89e0, [0x3dab] = 0x89e1, [0x3dac] = 0x89e2, [0x3dad] = 0x89e4,
  [0x3dae] = 0x89e7, [0x3daf] = 0x89e8, [0x3db0] = 0x89e9, [0x3db1] = 0x89ea,
  [0x3db2] = 0x89ec, [0x3db3] = 0x89ed, [0x3db4] = 0x89ee, [0x3db5] = 0x89f0,
  [0x3db6] = 0x89f1, [0x3db7] = 0x89f2, [0x3db8] = 0x89f4, [0x3db9] = 0x89f5,
  [0x3dba] = 0x89f6, [0x3dbb] = 0x89f7, [0x3dbc] = 0x89f8, [0x3dbd] = 0x89f9,
  [0x3dbe] = 0x89fa, [0x3dc0] = 0x89fb, [0x3dc1] = 0x89fc, [0x3dc2] = 0x89fd,
  [0x3dc3] = 0x89fe, [0x3dc4] = 0x89ff, [0x3dc5] = 0x8a01, [0x3dc6] = 0x8a02,
  [0x3dc7] = 0x8a03, [0x3dc8] = 0x8a04, [0x3dc9] = 0x8a05, [0x3dca] = 0x8a06,
  [0x3dcb] = 0x8a08, [0x3dcc] = 0x8a09, [0x3dcd] = 0x8a0a, [0x3dce] = 0x8a0b,
  [0x3dcf] = 0x8a0c, [0x3dd0] = 0x8a0d, [0x3dd1] = 0x8a0e, [0x3dd2] = 0x8a0f,
  [0x3dd3] = 0x8a10, [0x3dd4] = 0x8a11, [0x3dd5] = 0x8a12, [0x3dd6] = 0x8a13,
  [0x3dd7] = 0x8a14, [0x3dd8] = 0x8a15, [0x3dd9] = 0x8a16, [0x3dda] = 0x8a17,
  [0x3ddb] = 0x8a18, [0x3ddc] = 0x8a19, [0x3ddd] = 0x8a1a, [0x3dde] = 0x8a1b,
  [0x3ddf] = 0x8a1c, [0x3de0] = 0x8a1d, [0x3de1] = 0x5370, [0x3de2] = 0x82f1,
  [0x3de3] = 0x6a31, [0x3de4] = 0x5a74, [0x3de5] = 0x9e70, [0x3de6] = 0x5e94,
  [0x3de7] = 0x7f28, [0x3de8] = 0x83b9, [0x3de9] = 0x8424, [0x3dea] = 0x8425,
  [0x3deb] = 0x8367, [0x3dec] = 0x8747, [0x3ded] = 0x8fce, [0x3dee] = 0x8d62,
  [0x3def] = 0x76c8, [0x3df0] = 0x5f71, [0x3df1] = 0x9896, [0x3df2] = 0x786c,
  [0x3df3] = 0x6620, [0x3df4] = 0x54df, [0x3df5] = 0x62e5, [0x3df6] = 0x4f63,
  [0x3df7] = 0x81c3, [0x3df8] = 0x75c8, [0x3df9] = 0x5eb8, [0x3dfa] = 0x96cd,
  [0x3dfb] = 0x8e0a, [0x3dfc] = 0x86f9, [0x3dfd] = 0x548f, [0x3dfe] = 0x6cf3,
  [0x3dff] = 0x6d8c, [0x3e00] = 0x6c38, [0x3e01] = 0x607f, [0x3e02] = 0x52c7,
  [0x3e03] = 0x7528, [0x3e04] = 0x5e7d, [0x3e05] = 0x4f18, [0x3e06] = 0x60a0,
  [0x3e07] = 0x5fe7, [0x3e08] = 0x5c24, [0x3e09] = 0x7531, [0x3e0a] = 0x90ae,
  [0x3e0b] = 0x94c0, [0x3e0c] = 0x72b9, [0x3e0d] = 0x6cb9, [0x3e0e] = 0x6e38,
  [0x3e0f] = 0x9149, [0x3e10] = 0x6709, [0x3e11] = 0x53cb, [0x3e12] = 0x53f3,
  [0x3e13] = 0x4f51, [0x3e14] = 0x91c9, [0x3e15] = 0x8bf1, [0x3e16] = 0x53c8,
  [0x3e17] = 0x5e7c, [0x3e18] = 0x8fc2, [0x3e19] = 0x6de4, [0x3e1a] = 0x4e8e,
  [0x3e1b] = 0x76c2, [0x3e1c] = 0x6986, [0x3e1d] = 0x865e, [0x3e1e] = 0x611a,
  [0x3e1f] = 0x8206, [0x3e20] = 0x4f59, [0x3e21] = 0x4fde, [0x3e22] = 0x903e,
  [0x3e23] = 0x9c7c, [0x3e24] = 0x6109, [0x3e25] = 0x6e1d, [0x3e26] = 0x6e14,
  [0x3e27] = 0x9685, [0x3e28] = 0x4e88, [0x3e29] = 0x5a31, [0x3e2a] = 0x96e8,
  [0x3e2b] = 0x4e0e, [0x3e2c] = 0x5c7f, [0x3e2d] = 0x79b9, [0x3e2e] = 0x5b87,
  [0x3e2f] = 0x8bed, [0x3e30] = 0x7fbd, [0x3e31] = 0x7389, [0x3e32] = 0x57df,
  [0x3e33] = 0x828b, [0x3e34] = 0x90c1, [0x3e35] = 0x5401, [0x3e36] = 0x9047,
  [0x3e37] = 0x55bb, [0x3e38] = 0x5cea, [0x3e39] = 0x5fa1, [0x3e3a] = 0x6108,
  [0x3e3b] = 0x6b32, [0x3e3c] = 0x72f1, [0x3e3d] = 0x80b2, [0x3e3e] = 0x8a89,
  [0x3e40] = 0x8a1e, [0x3e41] = 0x8a1f, [0x3e42] = 0x8a20, [0x3e43] = 0x8a21,
  [0x3e44] = 0x8a22, [0x3e45] = 0x8a23, [0x3e46] = 0x8a24, [0x3e47] = 0x8a25,
  [0x3e48] = 0x8a26, [0x3e49] = 0x8a27, [0x3e4a] = 0x8a28, [0x3e4b] = 0x8a29,
  [0x3e4c] = 0x8a2a, [0x3e4d] = 0x8a2b, [0x3e4e] = 0x8a2c, [0x3e4f] = 0x8a2d,
  [0x3e50] = 0x8a2e, [0x3e51] = 0x8a2f, [0x3e52] = 0x8a30, [0x3e53] = 0x8a31,
  [0x3e54] = 0x8a32, [0x3e55] = 0x8a33, [0x3e56] = 0x8a34, [0x3e57] = 0x8a35,
  [0x3e58] = 0x8a36, [0x3e59] = 0x8a37, [0x3e5a] = 0x8a38, [0x3e5b] = 0x8a39,
  [0x3e5c] = 0x8a3a, [0x3e5d] = 0x8a3b, [0x3e5e] = 0x8a3c, [0x3e5f] = 0x8a3d,
  [0x3e60] = 0x8a3f, [0x3e61] = 0x8a40, [0x3e62] = 0x8a41, [0x3e63] = 0x8a42,
  [0x3e64] = 0x8a43, [0x3e65] = 0x8a44, [0x3e66] = 0x8a45, [0x3e67] = 0x8a46,
  [0x3e68] = 0x8a47, [0x3e69] = 0x8a49, [0x3e6a] = 0x8a4a, [0x3e6b] = 0x8a4b,
  [0x3e6c] = 0x8a4c, [0x3e6d] = 0x8a4d, [0x3e6e] = 0x8a4e, [0x3e6f] = 0x8a4f,
  [0x3e70] = 0x8a50, [0x3e71] = 0x8a51, [0x3e72] = 0x8a52, [0x3e73] = 0x8a53,
  [0x3e74] = 0x8a54, [0x3e75] = 0x8a55, [0x3e76] = 0x8a56, [0x3e77] = 0x8a57,
  [0x3e78] = 0x8a58, [0x3e79] = 0x8a59, [0x3e7a] = 0x8a5a, [0x3e7b] = 0x8a5b,
  [0x3e7c] = 0x8a5c, [0x3e7d] = 0x8a5d, [0x3e7e] = 0x8a5e, [0x3e80] = 0x8a5f,
  [0x3e81] = 0x8a60, [0x3e82] = 0x8a61, [0x3e83] = 0x8a62, [0x3e84] = 0x8a63,
  [0x3e85] = 0x8a64, [0x3e86] = 0x8a65, [0x3e87] = 0x8a66, [0x3e88] = 0x8a67,
  [0x3e89] = 0x8a68, [0x3e8a] = 0x8a69, [0x3e8b] = 0x8a6a, [0x3e8c] = 0x8a6b,
  [0x3e8d] = 0x8a6c, [0x3e8e] = 0x8a6d, [0x3e8f] = 0x8a6e, [0x3e90] = 0x8a6f,
  [0x3e91] = 0x8a70, [0x3e92] = 0x8a71, [0x3e93] = 0x8a72, [0x3e94] = 0x8a73,
  [0x3e95] = 0x8a74, [0x3e96] = 0x8a75, [0x3e97] = 0x8a76, [0x3e98] = 0x8a77,
  [0x3e99] = 0x8a78, [0x3e9a] = 0x8a7a, [0x3e9b] = 0x8a7b, [0x3e9c] = 0x8a7c,
  [0x3e9d] = 0x8a7d, [0x3e9e] = 0x8a7e, [0x3e9f] = 0x8a7f, [0x3ea0] = 0x8a80,
  [0x3ea1] = 0x6d74, [0x3ea2] = 0x5bd3, [0x3ea3] = 0x88d5, [0x3ea4] = 0x9884,
  [0x3ea5] = 0x8c6b, [0x3ea6] = 0x9a6d, [0x3ea7] = 0x9e33, [0x3ea8] = 0x6e0a,
  [0x3ea9] = 0x51a4, [0x3eaa] = 0x5143, [0x3eab] = 0x57a3, [0x3eac] = 0x8881,
  [0x3ead] = 0x539f, [0x3eae] = 0x63f4, [0x3eaf] = 0x8f95, [0x3eb0] = 0x56ed,
  [0x3eb1] = 0x5458, [0x3eb2] = 0x5706, [0x3eb3] = 0x733f, [0x3eb4] = 0x6e90,
  [0x3eb5] = 0x7f18, [0x3eb6] = 0x8fdc, [0x3eb7] = 0x82d1, [0x3eb8] = 0x613f,
  [0x3eb9] = 0x6028, [0x3eba] = 0x9662, [0x3ebb] = 0x66f0, [0x3ebc] = 0x7ea6,
  [0x3ebd] = 0x8d8a, [0x3ebe] = 0x8dc3, [0x3ebf] = 0x94a5, [0x3ec0] = 0x5cb3,
  [0x3ec1] = 0x7ca4, [0x3ec2] = 0x6708, [0x3ec3] = 0x60a6, [0x3ec4] = 0x9605,
  [0x3ec5] = 0x8018, [0x3ec6] = 0x4e91, [0x3ec7] = 0x90e7, [0x3ec8] = 0x5300,
  [0x3ec9] = 0x9668, [0x3eca] = 0x5141, [0x3ecb] = 0x8fd0, [0x3ecc] = 0x8574,
  [0x3ecd] = 0x915d, [0x3ece] = 0x6655, [0x3ecf] = 0x97f5, [0x3ed0] = 0x5b55,
  [0x3ed1] = 0x531d, [0x3ed2] = 0x7838, [0x3ed3] = 0x6742, [0x3ed4] = 0x683d,
  [0x3ed5] = 0x54c9, [0x3ed6] = 0x707e, [0x3ed7] = 0x5bb0, [0x3ed8] = 0x8f7d,
  [0x3ed9] = 0x518d, [0x3eda] = 0x5728, [0x3edb] = 0x54b1, [0x3edc] = 0x6512,
  [0x3edd] = 0x6682, [0x3ede] = 0x8d5e, [0x3edf] = 0x8d43, [0x3ee0] = 0x810f,
  [0x3ee1] = 0x846c, [0x3ee2] = 0x906d, [0x3ee3] = 0x7cdf, [0x3ee4] = 0x51ff,
  [0x3ee5] = 0x85fb, [0x3ee6] = 0x67a3, [0x3ee7] = 0x65e9, [0x3ee8] = 0x6fa1,
  [0x3ee9] = 0x86a4, [0x3eea] = 0x8e81, [0x3eeb] = 0x566a, [0x3eec] = 0x9020,
  [0x3eed] = 0x7682, [0x3eee] = 0x7076, [0x3eef] = 0x71e5, [0x3ef0] = 0x8d23,
  [0x3ef1] = 0x62e9, [0x3ef2] = 0x5219, [0x3ef3] = 0x6cfd, [0x3ef4] = 0x8d3c,
  [0x3ef5] = 0x600e, [0x3ef6] = 0x589e, [0x3ef7] = 0x618e, [0x3ef8] = 0x66fe,
  [0x3ef9] = 0x8d60, [0x3efa] = 0x624e, [0x3efb] = 0x55b3, [0x3efc] = 0x6e23,
  [0x3efd] = 0x672d, [0x3efe] = 0x8f67, [0x3f00] = 0x8a81, [0x3f01] = 0x8a82,
  [0x3f02] = 0x8a83, [0x3f03] = 0x8a84, [0x3f04] = 0x8a85, [0x3f05] = 0x8a86,
  [0x3f06] = 0x8a87, [0x3f07] = 0x8a88, [0x3f08] = 0x8a8b, [0x3f09] = 0x8a8c,
  [0x3f0a] = 0x8a8d, [0x3f0b] = 0x8a8e, [0x3f0c] = 0x8a8f, [0x3f0d] = 0x8a90,
  [0x3f0e] = 0x8a91, [0x3f0f] = 0x8a92, [0x3f10] = 0x8a94, [0x3f11] = 0x8a95,
  [0x3f12] = 0x8a96, [0x3f13] = 0x8a97, [0x3f14] = 0x8a98, [0x3f15] = 0x8a99,
  [0x3f16] = 0x8a9a, [0x3f17] = 0x8a9b, [0x3f18] = 0x8a9c, [0x3f19] = 0x8a9d,
  [0x3f1a] = 0x8a9e, [0x3f1b] = 0x8a9f, [0x3f1c] = 0x8aa0, [0x3f1d] = 0x8aa1,
  [0x3f1e] = 0x8aa2, [0x3f1f] = 0x8aa3, [0x3f20] = 0x8aa4, [0x3f21] = 0x8aa5,
  [0x3f22] = 0x8aa6, [0x3f23] = 0x8aa7, [0x3f24] = 0x8aa8, [0x3f25] = 0x8aa9,
  [0x3f26] = 0x8aaa, [0x3f27] = 0x8aab, [0x3f28] = 0x8aac, [0x3f29] = 0x8aad,
  [0x3f2a] = 0x8aae, [0x3f2b] = 0x8aaf, [0x3f2c] = 0x8ab0, [0x3f2d] = 0x8ab1,
  [0x3f2e] = 0x8ab2, [0x3f2f] = 0x8ab3, [0x3f30] = 0x8ab4, [0x3f31] = 0x8ab5,
  [0x3f32] = 0x8ab6, [0x3f33] = 0x8ab7, [0x3f34] = 0x8ab8, [0x3f35] = 0x8ab9,
  [0x3f36] = 0x8aba, [0x3f37] = 0x8abb, [0x3f38] = 0x8abc, [0x3f39] = 0x8abd,
  [0x3f3a] = 0x8abe, [0x3f3b] = 0x8abf, [0x3f3c] = 0x8ac0, [0x3f3d] = 0x8ac1,
  [0x3f3e] = 0x8ac2, [0x3f40] = 0x8ac3, [0x3f41] = 0x8ac4, [0x3f42] = 0x8ac5,
  [0x3f43] = 0x8ac6, [0x3f44] = 0x8ac7, [0x3f45] = 0x8ac8, [0x3f46] = 0x8ac9,
  [0x3f47] = 0x8aca, [0x3f48] = 0x8acb, [0x3f49] = 0x8acc, [0x3f4a] = 0x8acd,
  [0x3f4b] = 0x8ace, [0x3f4c] = 0x8acf, [0x3f4d] = 0x8ad0, [0x3f4e] = 0x8ad1,
  [0x3f4f] = 0x8ad2, [0x3f50] = 0x8ad3, [0x3f51] = 0x8ad4, [0x3f52] = 0x8ad5,
  [0x3f53] = 0x8ad6, [0x3f54] = 0x8ad7, [0x3f55] = 0x8ad8, [0x3f56] = 0x8ad9,
  [0x3f57] = 0x8ada, [0x3f58] = 0x8adb, [0x3f59] = 0x8adc, [0x3f5a] = 0x8add,
  [0x3f5b] = 0x8ade, [0x3f5c] = 0x8adf, [0x3f5d] = 0x8ae0, [0x3f5e] = 0x8ae1,
  [0x3f5f] = 0x8ae2, [0x3f60] = 0x8ae3, [0x3f61] = 0x94e1, [0x3f62] = 0x95f8,
  [0x3f63] = 0x7728, [0x3f64] = 0x6805, [0x3f65] = 0x69a8, [0x3f66] = 0x548b,
  [0x3f67] = 0x4e4d, [0x3f68] = 0x70b8, [0x3f69] = 0x8bc8, [0x3f6a] = 0x6458,
  [0x3f6b] = 0x658b, [0x3f6c] = 0x5b85, [0x3f6d] = 0x7a84, [0x3f6e] = 0x503a,
  [0x3f6f] = 0x5be8, [0x3f70] = 0x77bb, [0x3f71] = 0x6be1, [0x3f72] = 0x8a79,
  [0x3f73] = 0x7c98, [0x3f74] = 0x6cbe, [0x3f75] = 0x76cf, [0x3f76] = 0x65a9,
  [0x3f77] = 0x8f97, [0x3f78] = 0x5d2d, [0x3f79] = 0x5c55, [0x3f7a] = 0x8638,
  [0x3f7b] = 0x6808, [0x3f7c] = 0x5360, [0x3f7d] = 0x6218, [0x3f7e] = 0x7ad9,
  [0x3f7f] = 0x6e5b, [0x3f80] = 0x7efd, [0x3f81] = 0x6a1f, [0x3f82] = 0x7ae0,
  [0x3f83] = 0x5f70, [0x3f84] = 0x6f33, [0x3f85] = 0x5f20, [0x3f86] = 0x638c,
  [0x3f87] = 0x6da8, [0x3f88] = 0x6756, [0x3f89] = 0x4e08, [0x3f8a] = 0x5e10,
  [0x3f8b] = 0x8d26, [0x3f8c] = 0x4ed7, [0x3f8d] = 0x80c0, [0x3f8e] = 0x7634,
  [0x3f8f] = 0x969c, [0x3f90] = 0x62db, [0x3f91] = 0x662d, [0x3f92] = 0x627e,
  [0x3f93] = 0x6cbc, [0x3f94] = 0x8d75, [0x3f95] = 0x7167, [0x3f96] = 0x7f69,
  [0x3f97] = 0x5146, [0x3f98] = 0x8087, [0x3f99] = 0x53ec, [0x3f9a] = 0x906e,
  [0x3f9b] = 0x6298, [0x3f9c] = 0x54f2, [0x3f9d] = 0x86f0, [0x3f9e] = 0x8f99,
  [0x3f9f] = 0x8005, [0x3fa0] = 0x9517, [0x3fa1] = 0x8517, [0x3fa2] = 0x8fd9,
  [0x3fa3] = 0x6d59, [0x3fa4] = 0x73cd, [0x3fa5] = 0x659f, [0x3fa6] = 0x771f,
  [0x3fa7] = 0x7504, [0x3fa8] = 0x7827, [0x3fa9] = 0x81fb, [0x3faa] = 0x8d1e,
  [0x3fab] = 0x9488, [0x3fac] = 0x4fa6, [0x3fad] = 0x6795, [0x3fae] = 0x75b9,
  [0x3faf] = 0x8bca, [0x3fb0] = 0x9707, [0x3fb1] = 0x632f, [0x3fb2] = 0x9547,
  [0x3fb3] = 0x9635, [0x3fb4] = 0x84b8, [0x3fb5] = 0x6323, [0x3fb6] = 0x7741,
  [0x3fb7] = 0x5f81, [0x3fb8] = 0x72f0, [0x3fb9] = 0x4e89, [0x3fba] = 0x6014,
  [0x3fbb] = 0x6574, [0x3fbc] = 0x62ef, [0x3fbd] = 0x6b63, [0x3fbe] = 0x653f,
  [0x3fc0] = 0x8ae4, [0x3fc1] = 0x8ae5, [0x3fc2] = 0x8ae6, [0x3fc3] = 0x8ae7,
  [0x3fc4] = 0x8ae8, [0x3fc5] = 0x8ae9, [0x3fc6] = 0x8aea, [0x3fc7] = 0x8aeb,
  [0x3fc8] = 0x8aec, [0x3fc9] = 0x8aed, [0x3fca] = 0x8aee, [0x3fcb] = 0x8aef,
  [0x3fcc] = 0x8af0, [0x3fcd] = 0x8af1, [0x3fce] = 0x8af2, [0x3fcf] = 0x8af3,
  [0x3fd0] = 0x8af4, [0x3fd1] = 0x8af5, [0x3fd2] = 0x8af6, [0x3fd3] = 0x8af7,
  [0x3fd4] = 0x8af8, [0x3fd5] = 0x8af9, [0x3fd6] = 0x8afa, [0x3fd7] = 0x8afb,
  [0x3fd8] = 0x8afc, [0x3fd9] = 0x8afd, [0x3fda] = 0x8afe, [0x3fdb] = 0x8aff,
  [0x3fdc] = 0x8b00, [0x3fdd] = 0x8b01, [0x3fde] = 0x8b02, [0x3fdf] = 0x8b03,
  [0x3fe0] = 0x8b04, [0x3fe1] = 0x8b05, [0x3fe2] = 0x8b06, [0x3fe3] = 0x8b08,
  [0x3fe4] = 0x8b09, [0x3fe5] = 0x8b0a, [0x3fe6] = 0x8b0b, [0x3fe7] = 0x8b0c,
  [0x3fe8] = 0x8b0d, [0x3fe9] = 0x8b0e, [0x3fea] = 0x8b0f, [0x3feb] = 0x8b10,
  [0x3fec] = 0x8b11, [0x3fed] = 0x8b12, [0x3fee] = 0x8b13, [0x3fef] = 0x8b14,
  [0x3ff0] = 0x8b15, [0x3ff1] = 0x8b16, [0x3ff2] = 0x8b17, [0x3ff3] = 0x8b18,
  [0x3ff4] = 0x8b19, [0x3ff5] = 0x8b1a, [0x3ff6] = 0x8b1b, [0x3ff7] = 0x8b1c,
  [0x3ff8] = 0x8b1d, [0x3ff9] = 0x8b1e, [0x3ffa] = 0x8b1f, [0x3ffb] = 0x8b20,
  [0x3ffc] = 0x8b21, [0x3ffd] = 0x8b22, [0x3ffe] = 0x8b23, [0x4000] = 0x8b24,
  [0x4001] = 0x8b25, [0x4002] = 0x8b27, [0x4003] = 0x8b28, [0x4004] = 0x8b29,
  [0x4005] = 0x8b2a, [0x4006] = 0x8b2b, [0x4007] = 0x8b2c, [0x4008] = 0x8b2d,
  [0x4009] = 0x8b2e, [0x400a] = 0x8b2f, [0x400b] = 0x8b30, [0x400c] = 0x8b31,
  [0x400d] = 0x8b32, [0x400e] = 0x8b33, [0x400f] = 0x8b34, [0x4010] = 0x8b35,
  [0x4011] = 0x8b36, [0x4012] = 0x8b37, [0x4013] = 0x8b38, [0x4014] = 0x8b39,
  [0x4015] = 0x8b3a, [0x4016] = 0x8b3b, [0x4017] = 0x8b3c, [0x4018] = 0x8b3d,
  [0x4019] = 0x8b3e, [0x401a] = 0x8b3f, [0x401b] = 0x8b40, [0x401c] = 0x8b41,
  [0x401d] = 0x8b42, [0x401e] = 0x8b43, [0x401f] = 0x8b44, [0x4020] = 0x8b45,
  [0x4021] = 0x5e27, [0x4022] = 0x75c7, [0x4023] = 0x90d1, [0x4024] = 0x8bc1,
  [0x4025] = 0x829d, [0x4026] = 0x679d, [0x4027] = 0x652f, [0x4028] = 0x5431,
  [0x4029] = 0x8718, [0x402a] = 0x77e5, [0x402b] = 0x80a2, [0x402c] = 0x8102,
  [0x402d] = 0x6c41, [0x402e] = 0x4e4b, [0x402f] = 0x7ec7, [0x4030] = 0x804c,
  [0x4031] = 0x76f4, [0x4032] = 0x690d, [0x4033] = 0x6b96, [0x4034] = 0x6267,
  [0x4035] = 0x503c, [0x4036] = 0x4f84, [0x4037] = 0x5740, [0x4038] = 0x6307,
  [0x4039] = 0x6b62, [0x403a] = 0x8dbe, [0x403b] = 0x53ea, [0x403c] = 0x65e8,
  [0x403d] = 0x7eb8, [0x403e] = 0x5fd7, [0x403f] = 0x631a, [0x4040] = 0x63b7,
  [0x4041] = 0x81f3, [0x4042] = 0x81f4, [0x4043] = 0x7f6e, [0x4044] = 0x5e1c,
  [0x4045] = 0x5cd9, [0x4046] = 0x5236, [0x4047] = 0x667a, [0x4048] = 0x79e9,
  [0x4049] = 0x7a1a, [0x404a] = 0x8d28, [0x404b] = 0x7099, [0x404c] = 0x75d4,
  [0x404d] = 0x6ede, [0x404e] = 0x6cbb, [0x404f] = 0x7a92, [0x4050] = 0x4e2d,
  [0x4051] = 0x76c5, [0x4052] = 0x5fe0, [0x4053] = 0x949f, [0x4054] = 0x8877,
  [0x4055] = 0x7ec8, [0x4056] = 0x79cd, [0x4057] = 0x80bf, [0x4058] = 0x91cd,
  [0x4059] = 0x4ef2, [0x405a] = 0x4f17, [0x405b] = 0x821f, [0x405c] = 0x5468,
  [0x405d] = 0x5dde, [0x405e] = 0x6d32, [0x405f] = 0x8bcc, [0x4060] = 0x7ca5,
  [0x4061] = 0x8f74, [0x4062] = 0x8098, [0x4063] = 0x5e1a, [0x4064] = 0x5492,
  [0x4065] = 0x76b1, [0x4066] = 0x5b99, [0x4067] = 0x663c, [0x4068] = 0x9aa4,
  [0x4069] = 0x73e0, [0x406a] = 0x682a, [0x406b] = 0x86db, [0x406c] = 0x6731,
  [0x406d] = 0x732a, [0x406e] = 0x8bf8, [0x406f] = 0x8bdb, [0x4070] = 0x9010,
  [0x4071] = 0x7af9, [0x4072] = 0x70db, [0x4073] = 0x716e, [0x4074] = 0x62c4,
  [0x4075] = 0x77a9, [0x4076] = 0x5631, [0x4077] = 0x4e3b, [0x4078] = 0x8457,
  [0x4079] = 0x67f1, [0x407a] = 0x52a9, [0x407b] = 0x86c0, [0x407c] = 0x8d2e,
  [0x407d] = 0x94f8, [0x407e] = 0x7b51, [0x4080] = 0x8b46, [0x4081] = 0x8b47,
  [0x4082] = 0x8b48, [0x4083] = 0x8b49, [0x4084] = 0x8b4a, [0x4085] = 0x8b4b,
  [0x4086] = 0x8b4c, [0x4087] = 0x8b4d, [0x4088] = 0x8b4e, [0x4089] = 0x8b4f,
  [0x408a] = 0x8b50, [0x408b] = 0x8b51, [0x408c] = 0x8b52, [0x408d] = 0x8b53,
  [0x408e] = 0x8b54, [0x408f] = 0x8b55, [0x4090] = 0x8b56, [0x4091] = 0x8b57,
  [0x4092] = 0x8b58, [0x4093] = 0x8b59, [0x4094] = 0x8b5a, [0x4095] = 0x8b5b,
  [0x4096] = 0x8b5c, [0x4097] = 0x8b5d, [0x4098] = 0x8b5e, [0x4099] = 0x8b5f,
  [0x409a] = 0x8b60, [0x409b] = 0x8b61, [0x409c] = 0x8b62, [0x409d] = 0x8b63,
  [0x409e] = 0x8b64, [0x409f] = 0x8b65, [0x40a0] = 0x8b67, [0x40a1] = 0x8b68,
  [0x40a2] = 0x8b69, [0x40a3] = 0x8b6a, [0x40a4] = 0x8b6b, [0x40a5] = 0x8b6d,
  [0x40a6] = 0x8b6e, [0x40a7] = 0x8b6f, [0x40a8] = 0x8b70, [0x40a9] = 0x8b71,
  [0x40aa] = 0x8b72, [0x40ab] = 0x8b73, [0x40ac] = 0x8b74, [0x40ad] = 0x8b75,
  [0x40ae] = 0x8b76, [0x40af] = 0x8b77, [0x40b0] = 0x8b78, [0x40b1] = 0x8b79,
  [0x40b2] = 0x8b7a, [0x40b3] = 0x8b7b, [0x40b4] = 0x8b7c, [0x40b5] = 0x8b7d,
  [0x40b6] = 0x8b7e, [0x40b7] = 0x8b7f, [0x40b8] = 0x8b80, [0x40b9] = 0x8b81,
  [0x40ba] = 0x8b82, [0x40bb] = 0x8b83, [0x40bc] = 0x8b84, [0x40bd] = 0x8b85,
  [0x40be] = 0x8b86, [0x40c0] = 0x8b87, [0x40c1] = 0x8b88, [0x40c2] = 0x8b89,
  [0x40c3] = 0x8b8a, [0x40c4] = 0x8b8b, [0x40c5] = 0x8b8c, [0x40c6] = 0x8b8d,
  [0x40c7] = 0x8b8e, [0x40c8] = 0x8b8f, [0x40c9] = 0x8b90, [0x40ca] = 0x8b91,
  [0x40cb] = 0x8b92, [0x40cc] = 0x8b93, [0x40cd] = 0x8b94, [0x40ce] = 0x8b95,
  [0x40cf] = 0x8b96, [0x40d0] = 0x8b97, [0x40d1] = 0x8b98, [0x40d2] = 0x8b99,
  [0x40d3] = 0x8b9a, [0x40d4] = 0x8b9b, [0x40d5] = 0x8b9c, [0x40d6] = 0x8b9d,
  [0x40d7] = 0x8b9e, [0x40d8] = 0x8b9f, [0x40d9] = 0x8bac, [0x40da] = 0x8bb1,
  [0x40db] = 0x8bbb, [0x40dc] = 0x8bc7, [0x40dd] = 0x8bd0, [0x40de] = 0x8bea,
  [0x40df] = 0x8c09, [0x40e0] = 0x8c1e, [0x40e1] = 0x4f4f, [0x40e2] = 0x6ce8,
  [0x40e3] = 0x795d, [0x40e4] = 0x9a7b, [0x40e5] = 0x6293, [0x40e6] = 0x722a,
  [0x40e7] = 0x62fd, [0x40e8] = 0x4e13, [0x40e9] = 0x7816, [0x40ea] = 0x8f6c,
  [0x40eb] = 0x64b0, [0x40ec] = 0x8d5a, [0x40ed] = 0x7bc6, [0x40ee] = 0x6869,
  [0x40ef] = 0x5e84, [0x40f0] = 0x88c5, [0x40f1] = 0x5986, [0x40f2] = 0x649e,
  [0x40f3] = 0x58ee, [0x40f4] = 0x72b6, [0x40f5] = 0x690e, [0x40f6] = 0x9525,
  [0x40f7] = 0x8ffd, [0x40f8] = 0x8d58, [0x40f9] = 0x5760, [0x40fa] = 0x7f00,
  [0x40fb] = 0x8c06, [0x40fc] = 0x51c6, [0x40fd] = 0x6349, [0x40fe] = 0x62d9,
  [0x40ff] = 0x5353, [0x4100] = 0x684c, [0x4101] = 0x7422, [0x4102] = 0x8301,
  [0x4103] = 0x914c, [0x4104] = 0x5544, [0x4105] = 0x7740, [0x4106] = 0x707c,
  [0x4107] = 0x6d4a, [0x4108] = 0x5179, [0x4109] = 0x54a8, [0x410a] = 0x8d44,
  [0x410b] = 0x59ff, [0x410c] = 0x6ecb, [0x410d] = 0x6dc4, [0x410e] = 0x5b5c,
  [0x410f] = 0x7d2b, [0x4110] = 0x4ed4, [0x4111] = 0x7c7d, [0x4112] = 0x6ed3,
  [0x4113] = 0x5b50, [0x4114] = 0x81ea, [0x4115] = 0x6e0d, [0x4116] = 0x5b57,
  [0x4117] = 0x9b03, [0x4118] = 0x68d5, [0x4119] = 0x8e2a, [0x411a] = 0x5b97,
  [0x411b] = 0x7efc, [0x411c] = 0x603b, [0x411d] = 0x7eb5, [0x411e] = 0x90b9,
  [0x411f] = 0x8d70, [0x4120] = 0x594f, [0x4121] = 0x63cd, [0x4122] = 0x79df,
  [0x4123] = 0x8db3, [0x4124] = 0x5352, [0x4125] = 0x65cf, [0x4126] = 0x7956,
  [0x4127] = 0x8bc5, [0x4128] = 0x963b, [0x4129] = 0x7ec4, [0x412a] = 0x94bb,
  [0x412b] = 0x7e82, [0x412c] = 0x5634, [0x412d] = 0x9189, [0x412e] = 0x6700,
  [0x412f] = 0x7f6a, [0x4130] = 0x5c0a, [0x4131] = 0x9075, [0x4132] = 0x6628,
  [0x4133] = 0x5de6, [0x4134] = 0x4f50, [0x4135] = 0x67de, [0x4136] = 0x505a,
  [0x4137] = 0x4f5c, [0x4138] = 0x5750, [0x4139] = 0x5ea7, [0x4140] = 0x8c38,
  [0x4141] = 0x8c39, [0x4142] = 0x8c3a, [0x4143] = 0x8c3b, [0x4144] = 0x8c3c,
  [0x4145] = 0x8c3d, [0x4146] = 0x8c3e, [0x4147] = 0x8c3f, [0x4148] = 0x8c40,
  [0x4149] = 0x8c42, [0x414a] = 0x8c43, [0x414b] = 0x8c44, [0x414c] = 0x8c45,
  [0x414d] = 0x8c48, [0x414e] = 0x8c4a, [0x414f] = 0x8c4b, [0x4150] = 0x8c4d,
  [0x4151] = 0x8c4e, [0x4152] = 0x8c4f, [0x4153] = 0x8c50, [0x4154] = 0x8c51,
  [0x4155] = 0x8c52, [0x4156] = 0x8c53, [0x4157] = 0x8c54, [0x4158] = 0x8c56,
  [0x4159] = 0x8c57, [0x415a] = 0x8c58, [0x415b] = 0x8c59, [0x415c] = 0x8c5b,
  [0x415d] = 0x8c5c, [0x415e] = 0x8c5d, [0x415f] = 0x8c5e, [0x4160] = 0x8c5f,
  [0x4161] = 0x8c60, [0x4162] = 0x8c63, [0x4163] = 0x8c64, [0x4164] = 0x8c65,
  [0x4165] = 0x8c66, [0x4166] = 0x8c67, [0x4167] = 0x8c68, [0x4168] = 0x8c69,
  [0x4169] = 0x8c6c, [0x416a] = 0x8c6d, [0x416b] = 0x8c6e, [0x416c] = 0x8c6f,
  [0x416d] = 0x8c70, [0x416e] = 0x8c71, [0x416f] = 0x8c72, [0x4170] = 0x8c74,
  [0x4171] = 0x8c75, [0x4172] = 0x8c76, [0x4173] = 0x8c77, [0x4174] = 0x8c7b,
  [0x4175] = 0x8c7c, [0x4176] = 0x8c7d, [0x4177] = 0x8c7e, [0x4178] = 0x8c7f,
  [0x4179] = 0x8c80, [0x417a] = 0x8c81, [0x417b] = 0x8c83, [0x417c] = 0x8c84,
  [0x417d] = 0x8c86, [0x417e] = 0x8c87, [0x4180] = 0x8c88, [0x4181] = 0x8c8b,
  [0x4182] = 0x8c8d, [0x4183] = 0x8c8e, [0x4184] = 0x8c8f, [0x4185] = 0x8c90,
  [0x4186] = 0x8c91, [0x4187] = 0x8c92, [0x4188] = 0x8c93, [0x4189] = 0x8c95,
  [0x418a] = 0x8c96, [0x418b] = 0x8c97, [0x418c] = 0x8c99, [0x418d] = 0x8c9a,
  [0x418e] = 0x8c9b, [0x418f] = 0x8c9c, [0x4190] = 0x8c9d, [0x4191] = 0x8c9e,
  [0x4192] = 0x8c9f, [0x4193] = 0x8ca0, [0x4194] = 0x8ca1, [0x4195] = 0x8ca2,
  [0x4196] = 0x8ca3, [0x4197] = 0x8ca4, [0x4198] = 0x8ca5, [0x4199] = 0x8ca6,
  [0x419a] = 0x8ca7, [0x419b] = 0x8ca8, [0x419c] = 0x8ca9, [0x419d] = 0x8caa,
  [0x419e] = 0x8cab, [0x419f] = 0x8cac, [0x41a0] = 0x8cad, [0x41a1] = 0x4e8d,
  [0x41a2] = 0x4e0c, [0x41a3] = 0x5140, [0x41a4] = 0x4e10, [0x41a5] = 0x5eff,
  [0x41a6] = 0x5345, [0x41a7] = 0x4e15, [0x41a8] = 0x4e98, [0x41a9] = 0x4e1e,
  [0x41aa] = 0x9b32, [0x41ab] = 0x5b6c, [0x41ac] = 0x5669, [0x41ad] = 0x4e28,
  [0x41ae] = 0x79ba, [0x41af] = 0x4e3f, [0x41b0] = 0x5315, [0x41b1] = 0x4e47,
  [0x41b2] = 0x592d, [0x41b3] = 0x723b, [0x41b4] = 0x536e, [0x41b5] = 0x6c10,
  [0x41b6] = 0x56df, [0x41b7] = 0x80e4, [0x41b8] = 0x9997, [0x41b9] = 0x6bd3,
  [0x41ba] = 0x777e, [0x41bb] = 0x9f17, [0x41bc] = 0x4e36, [0x41bd] = 0x4e9f,
  [0x41be] = 0x9f10, [0x41bf] = 0x4e5c, [0x41c0] = 0x4e69, [0x41c1] = 0x4e93,
  [0x41c2] = 0x8288, [0x41c3] = 0x5b5b, [0x41c4] = 0x556c, [0x41c5] = 0x560f,
  [0x41c6] = 0x4ec4, [0x41c7] = 0x538d, [0x41c8] = 0x539d, [0x41c9] = 0x53a3,
  [0x41ca] = 0x53a5, [0x41cb] = 0x53ae, [0x41cc] = 0x9765, [0x41cd] = 0x8d5d,
  [0x41ce] = 0x531a, [0x41cf] = 0x53f5, [0x41d0] = 0x5326, [0x41d1] = 0x532e,
  [0x41d2] = 0x533e, [0x41d3] = 0x8d5c, [0x41d4] = 0x5366, [0x41d5] = 0x5363,
  [0x41d6] = 0x5202, [0x41d7] = 0x5208, [0x41d8] = 0x520e, [0x41d9] = 0x522d,
  [0x41da] = 0x5233, [0x41db] = 0x523f, [0x41dc] = 0x5240, [0x41dd] = 0x524c,
  [0x41de] = 0x525e, [0x41df] = 0x5261, [0x41e0] = 0x525c, [0x41e1] = 0x84af,
  [0x41e2] = 0x527d, [0x41e3] = 0x5282, [0x41e4] = 0x5281, [0x41e5] = 0x5290,
  [0x41e6] = 0x5293, [0x41e7] = 0x5182, [0x41e8] = 0x7f54, [0x41e9] = 0x4ebb,
  [0x41ea] = 0x4ec3, [0x41eb] = 0x4ec9, [0x41ec] = 0x4ec2, [0x41ed] = 0x4ee8,
  [0x41ee] = 0x4ee1, [0x41ef] = 0x4eeb, [0x41f0] = 0x4ede, [0x41f1] = 0x4f1b,
  [0x41f2] = 0x4ef3, [0x41f3] = 0x4f22, [0x41f4] = 0x4f64, [0x41f5] = 0x4ef5,
  [0x41f6] = 0x4f25, [0x41f7] = 0x4f27, [0x41f8] = 0x4f09, [0x41f9] = 0x4f2b,
  [0x41fa] = 0x4f5e, [0x41fb] = 0x4f67, [0x41fc] = 0x6538, [0x41fd] = 0x4f5a,
  [0x41fe] = 0x4f5d, [0x4200] = 0x8cae, [0x4201] = 0x8caf, [0x4202] = 0x8cb0,
  [0x4203] = 0x8cb1, [0x4204] = 0x8cb2, [0x4205] = 0x8cb3, [0x4206] = 0x8cb4,
  [0x4207] = 0x8cb5, [0x4208] = 0x8cb6, [0x4209] = 0x8cb7, [0x420a] = 0x8cb8,
  [0x420b] = 0x8cb9, [0x420c] = 0x8cba, [0x420d] = 0x8cbb, [0x420e] = 0x8cbc,
  [0x420f] = 0x8cbd, [0x4210] = 0x8cbe, [0x4211] = 0x8cbf, [0x4212] = 0x8cc0,
  [0x4213] = 0x8cc1, [0x4214] = 0x8cc2, [0x4215] = 0x8cc3, [0x4216] = 0x8cc4,
  [0x4217] = 0x8cc5, [0x4218] = 0x8cc6, [0x4219] = 0x8cc7, [0x421a] = 0x8cc8,
  [0x421b] = 0x8cc9, [0x421c] = 0x8cca, [0x421d] = 0x8ccb, [0x421e] = 0x8ccc,
  [0x421f] = 0x8ccd, [0x4220] = 0x8cce, [0x4221] = 0x8ccf, [0x4222] = 0x8cd0,
  [0x4223] = 0x8cd1, [0x4224] = 0x8cd2, [0x4225] = 0x8cd3, [0x4226] = 0x8cd4,
  [0x4227] = 0x8cd5, [0x4228] = 0x8cd6, [0x4229] = 0x8cd7, [0x422a] = 0x8cd8,
  [0x422b] = 0x8cd9, [0x422c] = 0x8cda, [0x422d] = 0x8cdb, [0x422e] = 0x8cdc,
  [0x422f] = 0x8cdd, [0x4230] = 0x8cde, [0x4231] = 0x8cdf, [0x4232] = 0x8ce0,
  [0x4233] = 0x8ce1, [0x4234] = 0x8ce2, [0x4235] = 0x8ce3, [0x4236] = 0x8ce4,
  [0x4237] = 0x8ce5, [0x4238] = 0x8ce6, [0x4239] = 0x8ce7, [0x423a] = 0x8ce8,
  [0x423b] = 0x8ce9, [0x423c] = 0x8cea, [0x423d] = 0x8ceb, [0x423e] = 0x8cec,
  [0x4240] = 0x8ced, [0x4241] = 0x8cee, [0x4242] = 0x8cef, [0x4243] = 0x8cf0,
  [0x4244] = 0x8cf1, [0x4245] = 0x8cf2, [0x4246] = 0x8cf3, [0x4247] = 0x8cf4,
  [0x4248] = 0x8cf5, [0x4249] = 0x8cf6, [0x424a] = 0x8cf7, [0x424b] = 0x8cf8,
  [0x424c] = 0x8cf9, [0x424d] = 0x8cfa, [0x424e] = 0x8cfb, [0x424f] = 0x8cfc,
  [0x4250] = 0x8cfd, [0x4251] = 0x8cfe, [0x4252] = 0x8cff, [0x4253] = 0x8d00,
  [0x4254] = 0x8d01, [0x4255] = 0x8d02, [0x4256] = 0x8d03, [0x4257] = 0x8d04,
  [0x4258] = 0x8d05, [0x4259] = 0x8d06, [0x425a] = 0x8d07, [0x425b] = 0x8d08,
  [0x425c] = 0x8d09, [0x425d] = 0x8d0a, [0x425e] = 0x8d0b, [0x425f] = 0x8d0c,
  [0x4260] = 0x8d0d, [0x4261] = 0x4f5f, [0x4262] = 0x4f57, [0x4263] = 0x4f32,
  [0x4264] = 0x4f3d, [0x4265] = 0x4f76, [0x4266] = 0x4f74, [0x4267] = 0x4f91,
  [0x4268] = 0x4f89, [0x4269] = 0x4f83, [0x426a] = 0x4f8f, [0x426b] = 0x4f7e,
  [0x426c] = 0x4f7b, [0x426d] = 0x4faa, [0x426e] = 0x4f7c, [0x426f] = 0x4fac,
  [0x4270] = 0x4f94, [0x4271] = 0x4fe6, [0x4272] = 0x4fe8, [0x4273] = 0x4fea,
  [0x4274] = 0x4fc5, [0x4275] = 0x4fda, [0x4276] = 0x4fe3, [0x4277] = 0x4fdc,
  [0x4278] = 0x4fd1, [0x4279] = 0x4fdf, [0x427a] = 0x4ff8, [0x427b] = 0x5029,
  [0x427c] = 0x504c, [0x427d] = 0x4ff3, [0x427e] = 0x502c, [0x427f] = 0x500f,
  [0x4280] = 0x502e, [0x4281] = 0x502d, [0x4282] = 0x4ffe, [0x4283] = 0x501c,
  [0x4284] = 0x500c, [0x4285] = 0x5025, [0x4286] = 0x5028, [0x4287] = 0x507e,
  [0x4288] = 0x5043, [0x4289] = 0x5055, [0x428a] = 0x5048, [0x428b] = 0x504e,
  [0x428c] = 0x506c, [0x428d] = 0x507b, [0x428e] = 0x50a5, [0x428f] = 0x50a7,
  [0x4290] = 0x50a9, [0x4291] = 0x50ba, [0x4292] = 0x50d6, [0x4293] = 0x5106,
  [0x4294] = 0x50ed, [0x4295] = 0x50ec, [0x4296] = 0x50e6, [0x4297] = 0x50ee,
  [0x4298] = 0x5107, [0x4299] = 0x510b, [0x429a] = 0x4edd, [0x429b] = 0x6c3d,
  [0x429c] = 0x4f58, [0x429d] = 0x4f65, [0x429e] = 0x4fce, [0x429f] = 0x9fa0,
  [0x42a0] = 0x6c46, [0x42a1] = 0x7c74, [0x42a2] = 0x516e, [0x42a3] = 0x5dfd,
  [0x42a4] = 0x9ec9, [0x42a5] = 0x9998, [0x42a6] = 0x5181, [0x42a7] = 0x5914,
  [0x42a8] = 0x52f9, [0x42a9] = 0x530d, [0x42aa] = 0x8a07, [0x42ab] = 0x5310,
  [0x42ac] = 0x51eb, [0x42ad] = 0x5919, [0x42ae] = 0x5155, [0x42af] = 0x4ea0,
  [0x42b0] = 0x5156, [0x42b1] = 0x4eb3, [0x42b2] = 0x886e, [0x42b3] = 0x88a4,
  [0x42b4] = 0x4eb5, [0x42b5] = 0x8114, [0x42b6] = 0x88d2, [0x42b7] = 0x7980,
  [0x42b8] = 0x5b34, [0x42b9] = 0x8803, [0x42ba] = 0x7fb8, [0x42bb] = 0x51ab,
  [0x42bc] = 0x51b1, [0x42bd] = 0x51bd, [0x42be] = 0x51bc, [0x42c0] = 0x8d0e,
  [0x42c1] = 0x8d0f, [0x42c2] = 0x8d10, [0x42c3] = 0x8d11, [0x42c4] = 0x8d12,
  [0x42c5] = 0x8d13, [0x42c6] = 0x8d14, [0x42c7] = 0x8d15, [0x42c8] = 0x8d16,
  [0x42c9] = 0x8d17, [0x42ca] = 0x8d18, [0x42cb] = 0x8d19, [0x42cc] = 0x8d1a,
  [0x42cd] = 0x8d1b, [0x42ce] = 0x8d1c, [0x42cf] = 0x8d20, [0x42d0] = 0x8d51,
  [0x42d1] = 0x8d52, [0x42d2] = 0x8d57, [0x42d3] = 0x8d5f, [0x42d4] = 0x8d65,
  [0x42d5] = 0x8d68, [0x42d6] = 0x8d69, [0x42d7] = 0x8d6a, [0x42d8] = 0x8d6c,
  [0x42d9] = 0x8d6e, [0x42da] = 0x8d6f, [0x42db] = 0x8d71, [0x42dc] = 0x8d72,
  [0x42dd] = 0x8d78, [0x42de] = 0x8d79, [0x42df] = 0x8d7a, [0x42e0] = 0x8d7b,
  [0x42e1] = 0x8d7c, [0x42e2] = 0x8d7d, [0x42e3] = 0x8d7e, [0x42e4] = 0x8d7f,
  [0x42e5] = 0x8d80, [0x42e6] = 0x8d82, [0x42e7] = 0x8d83, [0x42e8] = 0x8d86,
  [0x42e9] = 0x8d87, [0x42ea] = 0x8d88, [0x42eb] = 0x8d89, [0x42ec] = 0x8d8c,
  [0x42ed] = 0x8d8d, [0x42ee] = 0x8d8e, [0x42ef] = 0x8d8f, [0x42f0] = 0x8d90,
  [0x42f1] = 0x8d92, [0x42f2] = 0x8d93, [0x42f3] = 0x8d95, [0x42f4] = 0x8d96,
  [0x42f5] = 0x8d97, [0x42f6] = 0x8d98, [0x42f7] = 0x8d99, [0x42f8] = 0x8d9a,
  [0x42f9] = 0x8d9b, [0x42fa] = 0x8d9c, [0x42fb] = 0x8d9d, [0x42fc] = 0x8d9e,
  [0x42fd] = 0x8da0, [0x42fe] = 0x8da1, [0x4300] = 0x8da2, [0x4301] = 0x8da4,
  [0x4302] = 0x8da5, [0x4303] = 0x8da6, [0x4304] = 0x8da7, [0x4305] = 0x8da8,
  [0x4306] = 0x8da9, [0x4307] = 0x8daa, [0x4308] = 0x8dab, [0x4309] = 0x8dac,
  [0x430a] = 0x8dad, [0x430b] = 0x8dae, [0x430c] = 0x8daf, [0x430d] = 0x8db0,
  [0x430e] = 0x8db2, [0x430f] = 0x8db6, [0x4310] = 0x8db7, [0x4311] = 0x8db9,
  [0x4312] = 0x8dbb, [0x4313] = 0x8dbd, [0x4314] = 0x8dc0, [0x4315] = 0x8dc1,
  [0x4316] = 0x8dc2, [0x4317] = 0x8dc5, [0x4318] = 0x8dc7, [0x4319] = 0x8dc8,
  [0x431a] = 0x8dc9, [0x431b] = 0x8dca, [0x431c] = 0x8dcd, [0x431d] = 0x8dd0,
  [0x431e] = 0x8dd2, [0x431f] = 0x8dd3, [0x4320] = 0x8dd4, [0x4321] = 0x51c7,
  [0x4322] = 0x5196, [0x4323] = 0x51a2, [0x4324] = 0x51a5, [0x4325] = 0x8ba0,
  [0x4326] = 0x8ba6, [0x4327] = 0x8ba7, [0x4328] = 0x8baa, [0x4329] = 0x8bb4,
  [0x432a] = 0x8bb5, [0x432b] = 0x8bb7, [0x432c] = 0x8bc2, [0x432d] = 0x8bc3,
  [0x432e] = 0x8bcb, [0x432f] = 0x8bcf, [0x4330] = 0x8bce, [0x4331] = 0x8bd2,
  [0x4332] = 0x8bd3, [0x4333] = 0x8bd4, [0x4334] = 0x8bd6, [0x4335] = 0x8bd8,
  [0x4336] = 0x8bd9, [0x4337] = 0x8bdc, [0x4338] = 0x8bdf, [0x4339] = 0x8be0,
  [0x433a] = 0x8be4, [0x433b] = 0x8be8, [0x433c] = 0x8be9, [0x433d] = 0x8bee,
  [0x433e] = 0x8bf0, [0x433f] = 0x8bf3, [0x4340] = 0x8bf6, [0x4341] = 0x8bf9,
  [0x4342] = 0x8bfc, [0x4343] = 0x8bff, [0x4344] = 0x8c00, [0x4345] = 0x8c02,
  [0x4346] = 0x8c04, [0x4347] = 0x8c07, [0x4348] = 0x8c0c, [0x4349] = 0x8c0f,
  [0x434a] = 0x8c11, [0x434b] = 0x8c12, [0x434c] = 0x8c14, [0x434d] = 0x8c15,
  [0x434e] = 0x8c16, [0x434f] = 0x8c19, [0x4350] = 0x8c1b, [0x4351] = 0x8c18,
  [0x4352] = 0x8c1d, [0x4353] = 0x8c1f, [0x4354] = 0x8c20, [0x4355] = 0x8c21,
  [0x4356] = 0x8c25, [0x4357] = 0x8c27, [0x4358] = 0x8c2a, [0x4359] = 0x8c2b,
  [0x435a] = 0x8c2e, [0x435b] = 0x8c2f, [0x435c] = 0x8c32, [0x435d] = 0x8c33,
  [0x435e] = 0x8c35, [0x435f] = 0x8c36, [0x4360] = 0x5369, [0x4361] = 0x537a,
  [0x4362] = 0x961d, [0x4363] = 0x9622, [0x4364] = 0x9621, [0x4365] = 0x9631,
  [0x4366] = 0x962a, [0x4367] = 0x963d, [0x4368] = 0x963c, [0x4369] = 0x9642,
  [0x436a] = 0x9649, [0x436b] = 0x9654, [0x436c] = 0x965f, [0x436d] = 0x9667,
  [0x436e] = 0x966c, [0x436f] = 0x9672, [0x4370] = 0x9674, [0x4371] = 0x9688,
  [0x4372] = 0x968d, [0x4373] = 0x9697, [0x4374] = 0x96b0, [0x4375] = 0x9097,
  [0x4376] = 0x909b, [0x4377] = 0x909d, [0x4378] = 0x9099, [0x4379] = 0x90ac,
  [0x437a] = 0x90a1, [0x437b] = 0x90b4, [0x437c] = 0x90b3, [0x437d] = 0x90b6,
  [0x437e] = 0x90ba, [0x4380] = 0x8dd5, [0x4381] = 0x8dd8, [0x4382] = 0x8dd9,
  [0x4383] = 0x8ddc, [0x4384] = 0x8de0, [0x4385] = 0x8de1, [0x4386] = 0x8de2,
  [0x4387] = 0x8de5, [0x4388] = 0x8de6, [0x4389] = 0x8de7, [0x438a] = 0x8de9,
  [0x438b] = 0x8ded, [0x438c] = 0x8dee, [0x438d] = 0x8df0, [0x438e] = 0x8df1,
  [0x438f] = 0x8df2, [0x4390] = 0x8df4, [0x4391] = 0x8df6, [0x4392] = 0x8dfc,
  [0x4393] = 0x8dfe, [0x4394] = 0x8dff, [0x4395] = 0x8e00, [0x4396] = 0x8e01,
  [0x4397] = 0x8e02, [0x4398] = 0x8e03, [0x4399] = 0x8e04, [0x439a] = 0x8e06,
  [0x439b] = 0x8e07, [0x439c] = 0x8e08, [0x439d] = 0x8e0b, [0x439e] = 0x8e0d,
  [0x439f] = 0x8e0e, [0x43a0] = 0x8e10, [0x43a1] = 0x8e11, [0x43a2] = 0x8e12,
  [0x43a3] = 0x8e13, [0x43a4] = 0x8e15, [0x43a5] = 0x8e16, [0x43a6] = 0x8e17,
  [0x43a7] = 0x8e18, [0x43a8] = 0x8e19, [0x43a9] = 0x8e1a, [0x43aa] = 0x8e1b,
  [0x43ab] = 0x8e1c, [0x43ac] = 0x8e20, [0x43ad] = 0x8e21, [0x43ae] = 0x8e24,
  [0x43af] = 0x8e25, [0x43b0] = 0x8e26, [0x43b1] = 0x8e27, [0x43b2] = 0x8e28,
  [0x43b3] = 0x8e2b, [0x43b4] = 0x8e2d, [0x43b5] = 0x8e30, [0x43b6] = 0x8e32,
  [0x43b7] = 0x8e33, [0x43b8] = 0x8e34, [0x43b9] = 0x8e36, [0x43ba] = 0x8e37,
  [0x43bb] = 0x8e38, [0x43bc] = 0x8e3b, [0x43bd] = 0x8e3c, [0x43be] = 0x8e3e,
  [0x43c0] = 0x8e3f, [0x43c1] = 0x8e43, [0x43c2] = 0x8e45, [0x43c3] = 0x8e46,
  [0x43c4] = 0x8e4c, [0x43c5] = 0x8e4d, [0x43c6] = 0x8e4e, [0x43c7] = 0x8e4f,
  [0x43c8] = 0x8e50, [0x43c9] = 0x8e53, [0x43ca] = 0x8e54, [0x43cb] = 0x8e55,
  [0x43cc] = 0x8e56, [0x43cd] = 0x8e57, [0x43ce] = 0x8e58, [0x43cf] = 0x8e5a,
  [0x43d0] = 0x8e5b, [0x43d1] = 0x8e5c, [0x43d2] = 0x8e5d, [0x43d3] = 0x8e5e,
  [0x43d4] = 0x8e5f, [0x43d5] = 0x8e60, [0x43d6] = 0x8e61, [0x43d7] = 0x8e62,
  [0x43d8] = 0x8e63, [0x43d9] = 0x8e64, [0x43da] = 0x8e65, [0x43db] = 0x8e67,
  [0x43dc] = 0x8e68, [0x43dd] = 0x8e6a, [0x43de] = 0x8e6b, [0x43df] = 0x8e6e,
  [0x43e0] = 0x8e71, [0x43e1] = 0x90b8, [0x43e2] = 0x90b0, [0x43e3] = 0x90cf,
  [0x43e4] = 0x90c5, [0x43e5] = 0x90be, [0x43e6] = 0x90d0, [0x43e7] = 0x90c4,
  [0x43e8] = 0x90c7, [0x43e9] = 0x90d3, [0x43ea] = 0x90e6, [0x43eb] = 0x90e2,
  [0x43ec] = 0x90dc, [0x43ed] = 0x90d7, [0x43ee] = 0x90db, [0x43ef] = 0x90eb,
  [0x43f0] = 0x90ef, [0x43f1] = 0x90fe, [0x43f2] = 0x9104, [0x43f3] = 0x9122,
  [0x43f4] = 0x911e, [0x43f5] = 0x9123, [0x43f6] = 0x9131, [0x43f7] = 0x912f,
  [0x43f8] = 0x9139, [0x43f9] = 0x9143, [0x43fa] = 0x9146, [0x43fb] = 0x520d,
  [0x43fc] = 0x5942, [0x43fd] = 0x52a2, [0x43fe] = 0x52ac, [0x43ff] = 0x52ad,
  [0x4400] = 0x52be, [0x4401] = 0x54ff, [0x4402] = 0x52d0, [0x4403] = 0x52d6,
  [0x4404] = 0x52f0, [0x4405] = 0x53df, [0x4406] = 0x71ee, [0x4407] = 0x77cd,
  [0x4408] = 0x5ef4, [0x4409] = 0x51f5, [0x440a] = 0x51fc, [0x440b] = 0x9b2f,
  [0x440c] = 0x53b6, [0x440d] = 0x5f01, [0x440e] = 0x755a, [0x440f] = 0x5def,
  [0x4410] = 0x574c, [0x4411] = 0x57a9, [0x4412] = 0x57a1, [0x4413] = 0x587e,
  [0x4414] = 0x58bc, [0x4415] = 0x58c5, [0x4416] = 0x58d1, [0x4417] = 0x5729,
  [0x4418] = 0x572c, [0x4419] = 0x572a, [0x441a] = 0x5733, [0x441b] = 0x5739,
  [0x441c] = 0x572e, [0x441d] = 0x572f, [0x441e] = 0x575c, [0x441f] = 0x573b,
  [0x4420] = 0x5742, [0x4421] = 0x5769, [0x4422] = 0x5785, [0x4423] = 0x576b,
  [0x4424] = 0x5786, [0x4425] = 0x577c, [0x4426] = 0x577b, [0x4427] = 0x5768,
  [0x4428] = 0x576d, [0x4429] = 0x5776, [0x442a] = 0x5773, [0x442b] = 0x57ad,
  [0x442c] = 0x57a4, [0x442d] = 0x578c, [0x442e] = 0x57b2, [0x442f] = 0x57cf,
  [0x4430] = 0x57a7, [0x4431] = 0x57b4, [0x4432] = 0x5793, [0x4433] = 0x57a0,
  [0x4434] = 0x57d5, [0x4435] = 0x57d8, [0x4436] = 0x57da, [0x4437] = 0x57d9,
  [0x4438] = 0x57d2, [0x4439] = 0x57b8, [0x443a] = 0x57f4, [0x443b] = 0x57ef,
  [0x443c] = 0x57f8, [0x443d] = 0x57e4, [0x443e] = 0x57dd, [0x4440] = 0x8e73,
  [0x4441] = 0x8e75, [0x4442] = 0x8e77, [0x4443] = 0x8e78, [0x4444] = 0x8e79,
  [0x4445] = 0x8e7a, [0x4446] = 0x8e7b, [0x4447] = 0x8e7d, [0x4448] = 0x8e7e,
  [0x4449] = 0x8e80, [0x444a] = 0x8e82, [0x444b] = 0x8e83, [0x444c] = 0x8e84,
  [0x444d] = 0x8e86, [0x444e] = 0x8e88, [0x444f] = 0x8e89, [0x4450] = 0x8e8a,
  [0x4451] = 0x8e8b, [0x4452] = 0x8e8c, [0x4453] = 0x8e8d, [0x4454] = 0x8e8e,
  [0x4455] = 0x8e91, [0x4456] = 0x8e92, [0x4457] = 0x8e93, [0x4458] = 0x8e95,
  [0x4459] = 0x8e96, [0x445a] = 0x8e97, [0x445b] = 0x8e98, [0x445c] = 0x8e99,
  [0x445d] = 0x8e9a, [0x445e] = 0x8e9b, [0x445f] = 0x8e9d, [0x4460] = 0x8e9f,
  [0x4461] = 0x8ea0, [0x4462] = 0x8ea1, [0x4463] = 0x8ea2, [0x4464] = 0x8ea3,
  [0x4465] = 0x8ea4, [0x4466] = 0x8ea5, [0x4467] = 0x8ea6, [0x4468] = 0x8ea7,
  [0x4469] = 0x8ea8, [0x446a] = 0x8ea9, [0x446b] = 0x8eaa, [0x446c] = 0x8ead,
  [0x446d] = 0x8eae, [0x446e] = 0x8eb0, [0x446f] = 0x8eb1, [0x4470] = 0x8eb3,
  [0x4471] = 0x8eb4, [0x4472] = 0x8eb5, [0x4473] = 0x8eb6, [0x4474] = 0x8eb7,
  [0x4475] = 0x8eb8, [0x4476] = 0x8eb9, [0x4477] = 0x8ebb, [0x4478] = 0x8ebc,
  [0x4479] = 0x8ebd, [0x447a] = 0x8ebe, [0x447b] = 0x8ebf, [0x447c] = 0x8ec0,
  [0x447d] = 0x8ec1, [0x447e] = 0x8ec2, [0x4480] = 0x8ec3, [0x4481] = 0x8ec4,
  [0x4482] = 0x8ec5, [0x4483] = 0x8ec6, [0x4484] = 0x8ec7, [0x4485] = 0x8ec8,
  [0x4486] = 0x8ec9, [0x4487] = 0x8eca, [0x4488] = 0x8ecb, [0x4489] = 0x8ecc,
  [0x448a] = 0x8ecd, [0x448b] = 0x8ecf, [0x448c] = 0x8ed0, [0x448d] = 0x8ed1,
  [0x448e] = 0x8ed2, [0x448f] = 0x8ed3, [0x4490] = 0x8ed4, [0x4491] = 0x8ed5,
  [0x4492] = 0x8ed6, [0x4493] = 0x8ed7, [0x4494] = 0x8ed8, [0x4495] = 0x8ed9,
  [0x4496] = 0x8eda, [0x4497] = 0x8edb, [0x4498] = 0x8edc, [0x4499] = 0x8edd,
  [0x449a] = 0x8ede, [0x449b] = 0x8edf, [0x449c] = 0x8ee0, [0x449d] = 0x8ee1,
  [0x449e] = 0x8ee2, [0x449f] = 0x8ee3, [0x44a0] = 0x8ee4, [0x44a1] = 0x580b,
  [0x44a2] = 0x580d, [0x44a3] = 0x57fd, [0x44a4] = 0x57ed, [0x44a5] = 0x5800,
  [0x44a6] = 0x581e, [0x44a7] = 0x5819, [0x44a8] = 0x5844, [0x44a9] = 0x5820,
  [0x44aa] = 0x5865, [0x44ab] = 0x586c, [0x44ac] = 0x5881, [0x44ad] = 0x5889,
  [0x44ae] = 0x589a, [0x44af] = 0x5880, [0x44b0] = 0x99a8, [0x44b1] = 0x9f19,
  [0x44b2] = 0x61ff, [0x44b3] = 0x8279, [0x44b4] = 0x827d, [0x44b5] = 0x827f,
  [0x44b6] = 0x828f, [0x44b7] = 0x828a, [0x44b8] = 0x82a8, [0x44b9] = 0x8284,
  [0x44ba] = 0x828e, [0x44bb] = 0x8291, [0x44bc] = 0x8297, [0x44bd] = 0x8299,
  [0x44be] = 0x82ab, [0x44bf] = 0x82b8, [0x44c0] = 0x82be, [0x44c1] = 0x82b0,
  [0x44c2] = 0x82c8, [0x44c3] = 0x82ca, [0x44c4] = 0x82e3, [0x44c5] = 0x8298,
  [0x44c6] = 0x82b7, [0x44c7] = 0x82ae, [0x44c8] = 0x82cb, [0x44c9] = 0x82cc,
  [0x44ca] = 0x82c1, [0x44cb] = 0x82a9, [0x44cc] = 0x82b4, [0x44cd] = 0x82a1,
  [0x44ce] = 0x82aa, [0x44cf] = 0x829f, [0x44d0] = 0x82c4, [0x44d1] = 0x82ce,
  [0x44d2] = 0x82a4, [0x44d3] = 0x82e1, [0x44d4] = 0x8309, [0x44d5] = 0x82f7,
  [0x44d6] = 0x82e4, [0x44d7] = 0x830f, [0x44d8] = 0x8307, [0x44d9] = 0x82dc,
  [0x44da] = 0x82f4, [0x44db] = 0x82d2, [0x44dc] = 0x82d8, [0x44dd] = 0x830c,
  [0x44de] = 0x82fb, [0x44df] = 0x82d3, [0x44e0] = 0x8311, [0x44e1] = 0x831a,
  [0x44e2] = 0x8306, [0x44e3] = 0x8314, [0x44e4] = 0x8315, [0x44e5] = 0x82e0,
  [0x44e6] = 0x82d5, [0x44e7] = 0x831c, [0x44e8] = 0x8351, [0x44e9] = 0x835b,
  [0x44ea] = 0x835c, [0x44eb] = 0x8308, [0x44ec] = 0x8392, [0x44ed] = 0x833c,
  [0x44ee] = 0x8334, [0x44ef] = 0x8331, [0x44f0] = 0x839b, [0x44f1] = 0x835e,
  [0x44f2] = 0x832f, [0x44f3] = 0x834f, [0x44f4] = 0x8347, [0x44f5] = 0x8343,
  [0x44f6] = 0x835f, [0x44f7] = 0x8340, [0x44f8] = 0x8317, [0x44f9] = 0x8360,
  [0x44fa] = 0x832d, [0x44fb] = 0x833a, [0x44fc] = 0x8333, [0x44fd] = 0x8366,
  [0x44fe] = 0x8365, [0x4500] = 0x8ee5, [0x4501] = 0x8ee6, [0x4502] = 0x8ee7,
  [0x4503] = 0x8ee8, [0x4504] = 0x8ee9, [0x4505] = 0x8eea, [0x4506] = 0x8eeb,
  [0x4507] = 0x8eec, [0x4508] = 0x8eed, [0x4509] = 0x8eee, [0x450a] = 0x8eef,
  [0x450b] = 0x8ef0, [0x450c] = 0x8ef1, [0x450d] = 0x8ef2, [0x450e] = 0x8ef3,
  [0x450f] = 0x8ef4, [0x4510] = 0x8ef5, [0x4511] = 0x8ef6, [0x4512] = 0x8ef7,
  [0x4513] = 0x8ef8, [0x4514] = 0x8ef9, [0x4515] = 0x8efa, [0x4516] = 0x8efb,
  [0x4517] = 0x8efc, [0x4518] = 0x8efd, [0x4519] = 0x8efe, [0x451a] = 0x8eff,
  [0x451b] = 0x8f00, [0x451c] = 0x8f01, [0x451d] = 0x8f02, [0x451e] = 0x8f03,
  [0x451f] = 0x8f04, [0x4520] = 0x8f05, [0x4521] = 0x8f06, [0x4522] = 0x8f07,
  [0x4523] = 0x8f08, [0x4524] = 0x8f09, [0x4525] = 0x8f0a, [0x4526] = 0x8f0b,
  [0x4527] = 0x8f0c, [0x4528] = 0x8f0d, [0x4529] = 0x8f0e, [0x452a] = 0x8f0f,
  [0x452b] = 0x8f10, [0x452c] = 0x8f11, [0x452d] = 0x8f12, [0x452e] = 0x8f13,
  [0x452f] = 0x8f14, [0x4530] = 0x8f15, [0x4531] = 0x8f16, [0x4532] = 0x8f17,
  [0x4533] = 0x8f18, [0x4534] = 0x8f19, [0x4535] = 0x8f1a, [0x4536] = 0x8f1b,
  [0x4537] = 0x8f1c, [0x4538] = 0x8f1d, [0x4539] = 0x8f1e, [0x453a] = 0x8f1f,
  [0x453b] = 0x8f20, [0x453c] = 0x8f21, [0x453d] = 0x8f22, [0x453e] = 0x8f23,
  [0x4540] = 0x8f24, [0x4541] = 0x8f25, [0x4542] = 0x8f26, [0x4543] = 0x8f27,
  [0x4544] = 0x8f28, [0x4545] = 0x8f29, [0x4546] = 0x8f2a, [0x4547] = 0x8f2b,
  [0x4548] = 0x8f2c, [0x4549] = 0x8f2d, [0x454a] = 0x8f2e, [0x454b] = 0x8f2f,
  [0x454c] = 0x8f30, [0x454d] = 0x8f31, [0x454e] = 0x8f32, [0x454f] = 0x8f33,
  [0x4550] = 0x8f34, [0x4551] = 0x8f35, [0x4552] = 0x8f36, [0x4553] = 0x8f37,
  [0x4554] = 0x8f38, [0x4555] = 0x8f39, [0x4556] = 0x8f3a, [0x4557] = 0x8f3b,
  [0x4558] = 0x8f3c, [0x4559] = 0x8f3d, [0x455a] = 0x8f3e, [0x455b] = 0x8f3f,
  [0x455c] = 0x8f40, [0x455d] = 0x8f41, [0x455e] = 0x8f42, [0x455f] = 0x8f43,
  [0x4560] = 0x8f44, [0x4561] = 0x8368, [0x4562] = 0x831b, [0x4563] = 0x8369,
  [0x4564] = 0x836c, [0x4565] = 0x836a, [0x4566] = 0x836d, [0x4567] = 0x836e,
  [0x4568] = 0x83b0, [0x4569] = 0x8378, [0x456a] = 0x83b3, [0x456b] = 0x83b4,
  [0x456c] = 0x83a0, [0x456d] = 0x83aa, [0x456e] = 0x8393, [0x456f] = 0x839c,
  [0x4570] = 0x8385, [0x4571] = 0x837c, [0x4572] = 0x83b6, [0x4573] = 0x83a9,
  [0x4574] = 0x837d, [0x4575] = 0x83b8, [0x4576] = 0x837b, [0x4577] = 0x8398,
  [0x4578] = 0x839e, [0x4579] = 0x83a8, [0x457a] = 0x83ba, [0x457b] = 0x83bc,
  [0x457c] = 0x83c1, [0x457d] = 0x8401, [0x457e] = 0x83e5, [0x457f] = 0x83d8,
  [0x4580] = 0x5807, [0x4581] = 0x8418, [0x4582] = 0x840b, [0x4583] = 0x83dd,
  [0x4584] = 0x83fd, [0x4585] = 0x83d6, [0x4586] = 0x841c, [0x4587] = 0x8438,
  [0x4588] = 0x8411, [0x4589] = 0x8406, [0x458a] = 0x83d4, [0x458b] = 0x83df,
  [0x458c] = 0x840f, [0x458d] = 0x8403, [0x458e] = 0x83f8, [0x458f] = 0x83f9,
  [0x4590] = 0x83ea, [0x4591] = 0x83c5, [0x4592] = 0x83c0, [0x4593] = 0x8426,
  [0x4594] = 0x83f0, [0x4595] = 0x83e1, [0x4596] = 0x845c, [0x4597] = 0x8451,
  [0x4598] = 0x845a, [0x4599] = 0x8459, [0x459a] = 0x8473, [0x459b] = 0x8487,
  [0x459c] = 0x8488, [0x459d] = 0x847a, [0x459e] = 0x8489, [0x459f] = 0x8478,
  [0x45a0] = 0x843c, [0x45a1] = 0x8446, [0x45a2] = 0x8469, [0x45a3] = 0x8476,
  [0x45a4] = 0x848c, [0x45a5] = 0x848e, [0x45a6] = 0x8431, [0x45a7] = 0x846d,
  [0x45a8] = 0x84c1, [0x45a9] = 0x84cd, [0x45aa] = 0x84d0, [0x45ab] = 0x84e6,
  [0x45ac] = 0x84bd, [0x45ad] = 0x84d3, [0x45ae] = 0x84ca, [0x45af] = 0x84bf,
  [0x45b0] = 0x84ba, [0x45b1] = 0x84e0, [0x45b2] = 0x84a1, [0x45b3] = 0x84b9,
  [0x45b4] = 0x84b4, [0x45b5] = 0x8497, [0x45b6] = 0x84e5, [0x45b7] = 0x84e3,
  [0x45b8] = 0x850c, [0x45b9] = 0x750d, [0x45ba] = 0x8538, [0x45bb] = 0x84f0,
  [0x45bc] = 0x8539, [0x45bd] = 0x851f, [0x45be] = 0x853a, [0x45c0] = 0x8f45,
  [0x45c1] = 0x8f46, [0x45c2] = 0x8f47, [0x45c3] = 0x8f48, [0x45c4] = 0x8f49,
  [0x45c5] = 0x8f4a, [0x45c6] = 0x8f4b, [0x45c7] = 0x8f4c, [0x45c8] = 0x8f4d,
  [0x45c9] = 0x8f4e, [0x45ca] = 0x8f4f, [0x45cb] = 0x8f50, [0x45cc] = 0x8f51,
  [0x45cd] = 0x8f52, [0x45ce] = 0x8f53, [0x45cf] = 0x8f54, [0x45d0] = 0x8f55,
  [0x45d1] = 0x8f56, [0x45d2] = 0x8f57, [0x45d3] = 0x8f58, [0x45d4] = 0x8f59,
  [0x45d5] = 0x8f5a, [0x45d6] = 0x8f5b, [0x45d7] = 0x8f5c, [0x45d8] = 0x8f5d,
  [0x45d9] = 0x8f5e, [0x45da] = 0x8f5f, [0x45db] = 0x8f60, [0x45dc] = 0x8f61,
  [0x45dd] = 0x8f62, [0x45de] = 0x8f63, [0x45df] = 0x8f64, [0x45e0] = 0x8f65,
  [0x45e1] = 0x8f6a, [0x45e2] = 0x8f80, [0x45e3] = 0x8f8c, [0x45e4] = 0x8f92,
  [0x45e5] = 0x8f9d, [0x45e6] = 0x8fa0, [0x45e7] = 0x8fa1, [0x45e8] = 0x8fa2,
  [0x45e9] = 0x8fa4, [0x45ea] = 0x8fa5, [0x45eb] = 0x8fa6, [0x45ec] = 0x8fa7,
  [0x45ed] = 0x8faa, [0x45ee] = 0x8fac, [0x45ef] = 0x8fad, [0x45f0] = 0x8fae,
  [0x45f1] = 0x8faf, [0x45f2] = 0x8fb2, [0x45f3] = 0x8fb3, [0x45f4] = 0x8fb4,
  [0x45f5] = 0x8fb5, [0x45f6] = 0x8fb7, [0x45f7] = 0x8fb8, [0x45f8] = 0x8fba,
  [0x45f9] = 0x8fbb, [0x45fa] = 0x8fbc, [0x45fb] = 0x8fbf, [0x45fc] = 0x8fc0,
  [0x45fd] = 0x8fc3, [0x45fe] = 0x8fc6, [0x4600] = 0x8fc9, [0x4601] = 0x8fca,
  [0x4602] = 0x8fcb, [0x4603] = 0x8fcc, [0x4604] = 0x8fcd, [0x4605] = 0x8fcf,
  [0x4606] = 0x8fd2, [0x4607] = 0x8fd6, [0x4608] = 0x8fd7, [0x4609] = 0x8fda,
  [0x460a] = 0x8fe0, [0x460b] = 0x8fe1, [0x460c] = 0x8fe3, [0x460d] = 0x8fe7,
  [0x460e] = 0x8fec, [0x460f] = 0x8fef, [0x4610] = 0x8ff1, [0x4611] = 0x8ff2,
  [0x4612] = 0x8ff4, [0x4613] = 0x8ff5, [0x4614] = 0x8ff6, [0x4615] = 0x8ffa,
  [0x4616] = 0x8ffb, [0x4617] = 0x8ffc, [0x4618] = 0x8ffe, [0x4619] = 0x8fff,
  [0x461a] = 0x9007, [0x461b] = 0x9008, [0x461c] = 0x900c, [0x461d] = 0x900e,
  [0x461e] = 0x9013, [0x461f] = 0x9015, [0x4620] = 0x9018, [0x4621] = 0x8556,
  [0x4622] = 0x853b, [0x4623] = 0x84ff, [0x4624] = 0x84fc, [0x4625] = 0x8559,
  [0x4626] = 0x8548, [0x4627] = 0x8568, [0x4628] = 0x8564, [0x4629] = 0x855e,
  [0x462a] = 0x857a, [0x462b] = 0x77a2, [0x462c] = 0x8543, [0x462d] = 0x8572,
  [0x462e] = 0x857b, [0x462f] = 0x85a4, [0x4630] = 0x85a8, [0x4631] = 0x8587,
  [0x4632] = 0x858f, [0x4633] = 0x8579, [0x4634] = 0x85ae, [0x4635] = 0x859c,
  [0x4636] = 0x8585, [0x4637] = 0x85b9, [0x4638] = 0x85b7, [0x4639] = 0x85b0,
  [0x463a] = 0x85d3, [0x463b] = 0x85c1, [0x463c] = 0x85dc, [0x463d] = 0x85ff,
  [0x463e] = 0x8627, [0x463f] = 0x8605, [0x4640] = 0x8629, [0x4641] = 0x8616,
  [0x4642] = 0x863c, [0x4643] = 0x5efe, [0x4644] = 0x5f08, [0x4645] = 0x593c,
  [0x4646] = 0x5941, [0x4647] = 0x8037, [0x4648] = 0x5955, [0x4649] = 0x595a,
  [0x464a] = 0x5958, [0x464b] = 0x530f, [0x464c] = 0x5c22, [0x464d] = 0x5c25,
  [0x464e] = 0x5c2c, [0x464f] = 0x5c34, [0x4650] = 0x624c, [0x4651] = 0x626a,
  [0x4652] = 0x629f, [0x4653] = 0x62bb, [0x4654] = 0x62ca, [0x4655] = 0x62da,
  [0x4656] = 0x62d7, [0x4657] = 0x62ee, [0x4658] = 0x6322, [0x4659] = 0x62f6,
  [0x465a] = 0x6339, [0x465b] = 0x634b, [0x465c] = 0x6343, [0x465d] = 0x63ad,
  [0x465e] = 0x63f6, [0x465f] = 0x6371, [0x4660] = 0x637a, [0x4661] = 0x638e,
  [0x4662] = 0x63b4, [0x4663] = 0x636d, [0x4664] = 0x63ac, [0x4665] = 0x638a,
  [0x4666] = 0x6369, [0x4667] = 0x63ae, [0x4668] = 0x63bc, [0x4669] = 0x63f2,
  [0x466a] = 0x63f8, [0x466b] = 0x63e0, [0x466c] = 0x63ff, [0x466d] = 0x63c4,
  [0x466e] = 0x63de, [0x466f] = 0x63ce, [0x4670] = 0x6452, [0x4671] = 0x63c6,
  [0x4672] = 0x63be, [0x4673] = 0x6445, [0x4674] = 0x6441, [0x4675] = 0x640b,
  [0x4676] = 0x641b, [0x4677] = 0x6420, [0x4678] = 0x640c, [0x4679] = 0x6426,
  [0x467a] = 0x6421, [0x467b] = 0x645e, [0x467c] = 0x6484, [0x467d] = 0x646d,
  [0x467e] = 0x6496, [0x4680] = 0x9019, [0x4681] = 0x901c, [0x4682] = 0x9023,
  [0x4683] = 0x9024, [0x4684] = 0x9025, [0x4685] = 0x9027, [0x4686] = 0x9028,
  [0x4687] = 0x9029, [0x4688] = 0x902a, [0x4689] = 0x902b, [0x468a] = 0x902c,
  [0x468b] = 0x9030, [0x468c] = 0x9031, [0x468d] = 0x9032, [0x468e] = 0x9033,
  [0x468f] = 0x9034, [0x4690] = 0x9037, [0x4691] = 0x9039, [0x4692] = 0x903a,
  [0x4693] = 0x903d, [0x4694] = 0x903f, [0x4695] = 0x9040, [0x4696] = 0x9043,
  [0x4697] = 0x9045, [0x4698] = 0x9046, [0x4699] = 0x9048, [0x469a] = 0x9049,
  [0x469b] = 0x904a, [0x469c] = 0x904b, [0x469d] = 0x904c, [0x469e] = 0x904e,
  [0x469f] = 0x9054, [0x46a0] = 0x9055, [0x46a1] = 0x9056, [0x46a2] = 0x9059,
  [0x46a3] = 0x905a, [0x46a4] = 0x905c, [0x46a5] = 0x905d, [0x46a6] = 0x905e,
  [0x46a7] = 0x905f, [0x46a8] = 0x9060, [0x46a9] = 0x9061, [0x46aa] = 0x9064,
  [0x46ab] = 0x9066, [0x46ac] = 0x9067, [0x46ad] = 0x9069, [0x46ae] = 0x906a,
  [0x46af] = 0x906b, [0x46b0] = 0x906c, [0x46b1] = 0x906f, [0x46b2] = 0x9070,
  [0x46b3] = 0x9071, [0x46b4] = 0x9072, [0x46b5] = 0x9073, [0x46b6] = 0x9076,
  [0x46b7] = 0x9077, [0x46b8] = 0x9078, [0x46b9] = 0x9079, [0x46ba] = 0x907a,
  [0x46bb] = 0x907b, [0x46bc] = 0x907c, [0x46bd] = 0x907e, [0x46be] = 0x9081,
  [0x46c0] = 0x9084, [0x46c1] = 0x9085, [0x46c2] = 0x9086, [0x46c3] = 0x9087,
  [0x46c4] = 0x9089, [0x46c5] = 0x908a, [0x46c6] = 0x908c, [0x46c7] = 0x908d,
  [0x46c8] = 0x908e, [0x46c9] = 0x908f, [0x46ca] = 0x9090, [0x46cb] = 0x9092,
  [0x46cc] = 0x9094, [0x46cd] = 0x9096, [0x46ce] = 0x9098, [0x46cf] = 0x909a,
  [0x46d0] = 0x909c, [0x46d1] = 0x909e, [0x46d2] = 0x909f, [0x46d3] = 0x90a0,
  [0x46d4] = 0x90a4, [0x46d5] = 0x90a5, [0x46d6] = 0x90a7, [0x46d7] = 0x90a8,
  [0x46d8] = 0x90a9, [0x46d9] = 0x90ab, [0x46da] = 0x90ad, [0x46db] = 0x90b2,
  [0x46dc] = 0x90b7, [0x46dd] = 0x90bc, [0x46de] = 0x90bd, [0x46df] = 0x90bf,
  [0x46e0] = 0x90c0, [0x46e1] = 0x647a, [0x46e2] = 0x64b7, [0x46e3] = 0x64b8,
  [0x46e4] = 0x6499, [0x46e5] = 0x64ba, [0x46e6] = 0x64c0, [0x46e7] = 0x64d0,
  [0x46e8] = 0x64d7, [0x46e9] = 0x64e4, [0x46ea] = 0x64e2, [0x46eb] = 0x6509,
  [0x46ec] = 0x6525, [0x46ed] = 0x652e, [0x46ee] = 0x5f0b, [0x46ef] = 0x5fd2,
  [0x46f0] = 0x7519, [0x46f1] = 0x5f11, [0x46f2] = 0x535f, [0x46f3] = 0x53f1,
  [0x46f4] = 0x53fd, [0x46f5] = 0x53e9, [0x46f6] = 0x53e8, [0x46f7] = 0x53fb,
  [0x46f8] = 0x5412, [0x46f9] = 0x5416, [0x46fa] = 0x5406, [0x46fb] = 0x544b,
  [0x46fc] = 0x5452, [0x46fd] = 0x5453, [0x46fe] = 0x5454, [0x46ff] = 0x5456,
  [0x4700] = 0x5443, [0x4701] = 0x5421, [0x4702] = 0x5457, [0x4703] = 0x5459,
  [0x4704] = 0x5423, [0x4705] = 0x5432, [0x4706] = 0x5482, [0x4707] = 0x5494,
  [0x4708] = 0x5477, [0x4709] = 0x5471, [0x470a] = 0x5464, [0x470b] = 0x549a,
  [0x470c] = 0x549b, [0x470d] = 0x5484, [0x470e] = 0x5476, [0x470f] = 0x5466,
  [0x4710] = 0x549d, [0x4711] = 0x54d0, [0x4712] = 0x54ad, [0x4713] = 0x54c2,
  [0x4714] = 0x54b4, [0x4715] = 0x54d2, [0x4716] = 0x54a7, [0x4717] = 0x54a6,
  [0x4718] = 0x54d3, [0x4719] = 0x54d4, [0x471a] = 0x5472, [0x471b] = 0x54a3,
  [0x471c] = 0x54d5, [0x471d] = 0x54bb, [0x471e] = 0x54bf, [0x471f] = 0x54cc,
  [0x4720] = 0x54d9, [0x4721] = 0x54da, [0x4722] = 0x54dc, [0x4723] = 0x54a9,
  [0x4724] = 0x54aa, [0x4725] = 0x54a4, [0x4726] = 0x54dd, [0x4727] = 0x54cf,
  [0x4728] = 0x54de, [0x4729] = 0x551b, [0x472a] = 0x54e7, [0x472b] = 0x5520,
  [0x472c] = 0x54fd, [0x472d] = 0x5514, [0x472e] = 0x54f3, [0x472f] = 0x5522,
  [0x4730] = 0x5523, [0x4731] = 0x550f, [0x4732] = 0x5511, [0x4733] = 0x5527,
  [0x4734] = 0x552a, [0x4735] = 0x5567, [0x4736] = 0x558f, [0x4737] = 0x55b5,
  [0x4738] = 0x5549, [0x4739] = 0x556d, [0x473a] = 0x5541, [0x473b] = 0x5555,
  [0x473c] = 0x553f, [0x473d] = 0x5550, [0x473e] = 0x553c, [0x4740] = 0x90c2,
  [0x4741] = 0x90c3, [0x4742] = 0x90c6, [0x4743] = 0x90c8, [0x4744] = 0x90c9,
  [0x4745] = 0x90cb, [0x4746] = 0x90cc, [0x4747] = 0x90cd, [0x4748] = 0x90d2,
  [0x4749] = 0x90d4, [0x474a] = 0x90d5, [0x474b] = 0x90d6, [0x474c] = 0x90d8,
  [0x474d] = 0x90d9, [0x474e] = 0x90da, [0x474f] = 0x90de, [0x4750] = 0x90df,
  [0x4751] = 0x90e0, [0x4752] = 0x90e3, [0x4753] = 0x90e4, [0x4754] = 0x90e5,
  [0x4755] = 0x90e9, [0x4756] = 0x90ea, [0x4757] = 0x90ec, [0x4758] = 0x90ee,
  [0x4759] = 0x90f0, [0x475a] = 0x90f1, [0x475b] = 0x90f2, [0x475c] = 0x90f3,
  [0x475d] = 0x90f5, [0x475e] = 0x90f6, [0x475f] = 0x90f7, [0x4760] = 0x90f9,
  [0x4761] = 0x90fa, [0x4762] = 0x90fb, [0x4763] = 0x90fc, [0x4764] = 0x90ff,
  [0x4765] = 0x9100, [0x4766] = 0x9101, [0x4767] = 0x9103, [0x4768] = 0x9105,
  [0x4769] = 0x9106, [0x476a] = 0x9107, [0x476b] = 0x9108, [0x476c] = 0x9109,
  [0x476d] = 0x910a, [0x476e] = 0x910b, [0x476f] = 0x910c, [0x4770] = 0x910d,
  [0x4771] = 0x910e, [0x4772] = 0x910f, [0x4773] = 0x9110, [0x4774] = 0x9111,
  [0x4775] = 0x9112, [0x4776] = 0x9113, [0x4777] = 0x9114, [0x4778] = 0x9115,
  [0x4779] = 0x9116, [0x477a] = 0x9117, [0x477b] = 0x9118, [0x477c] = 0x911a,
  [0x477d] = 0x911b, [0x477e] = 0x911c, [0x4780] = 0x911d, [0x4781] = 0x911f,
  [0x4782] = 0x9120, [0x4783] = 0x9121, [0x4784] = 0x9124, [0x4785] = 0x9125,
  [0x4786] = 0x9126, [0x4787] = 0x9127, [0x4788] = 0x9128, [0x4789] = 0x9129,
  [0x478a] = 0x912a, [0x478b] = 0x912b, [0x478c] = 0x912c, [0x478d] = 0x912d,
  [0x478e] = 0x912e, [0x478f] = 0x9130, [0x4790] = 0x9132, [0x4791] = 0x9133,
  [0x4792] = 0x9134, [0x4793] = 0x9135, [0x4794] = 0x9136, [0x4795] = 0x9137,
  [0x4796] = 0x9138, [0x4797] = 0x913a, [0x4798] = 0x913b, [0x4799] = 0x913c,
  [0x479a] = 0x913d, [0x479b] = 0x913e, [0x479c] = 0x913f, [0x479d] = 0x9140,
  [0x479e] = 0x9141, [0x479f] = 0x9142, [0x47a0] = 0x9144, [0x47a1] = 0x5537,
  [0x47a2] = 0x5556, [0x47a3] = 0x5575, [0x47a4] = 0x5576, [0x47a5] = 0x5577,
  [0x47a6] = 0x5533, [0x47a7] = 0x5530, [0x47a8] = 0x555c, [0x47a9] = 0x558b,
  [0x47aa] = 0x55d2, [0x47ab] = 0x5583, [0x47ac] = 0x55b1, [0x47ad] = 0x55b9,
  [0x47ae] = 0x5588, [0x47af] = 0x5581, [0x47b0] = 0x559f, [0x47b1] = 0x557e,
  [0x47b2] = 0x55d6, [0x47b3] = 0x5591, [0x47b4] = 0x557b, [0x47b5] = 0x55df,
  [0x47b6] = 0x55bd, [0x47b7] = 0x55be, [0x47b8] = 0x5594, [0x47b9] = 0x5599,
  [0x47ba] = 0x55ea, [0x47bb] = 0x55f7, [0x47bc] = 0x55c9, [0x47bd] = 0x561f,
  [0x47be] = 0x55d1, [0x47bf] = 0x55eb, [0x47c0] = 0x55ec, [0x47c1] = 0x55d4,
  [0x47c2] = 0x55e6, [0x47c3] = 0x55dd, [0x47c4] = 0x55c4, [0x47c5] = 0x55ef,
  [0x47c6] = 0x55e5, [0x47c7] = 0x55f2, [0x47c8] = 0x55f3, [0x47c9] = 0x55cc,
  [0x47ca] = 0x55cd, [0x47cb] = 0x55e8, [0x47cc] = 0x55f5, [0x47cd] = 0x55e4,
  [0x47ce] = 0x8f94, [0x47cf] = 0x561e, [0x47d0] = 0x5608, [0x47d1] = 0x560c,
  [0x47d2] = 0x5601, [0x47d3] = 0x5624, [0x47d4] = 0x5623, [0x47d5] = 0x55fe,
  [0x47d6] = 0x5600, [0x47d7] = 0x5627, [0x47d8] = 0x562d, [0x47d9] = 0x5658,
  [0x47da] = 0x5639, [0x47db] = 0x5657, [0x47dc] = 0x562c, [0x47dd] = 0x564d,
  [0x47de] = 0x5662, [0x47df] = 0x5659, [0x47e0] = 0x565c, [0x47e1] = 0x564c,
  [0x47e2] = 0x5654, [0x47e3] = 0x5686, [0x47e4] = 0x5664, [0x47e5] = 0x5671,
  [0x47e6] = 0x566b, [0x47e7] = 0x567b, [0x47e8] = 0x567c, [0x47e9] = 0x5685,
  [0x47ea] = 0x5693, [0x47eb] = 0x56af, [0x47ec] = 0x56d4, [0x47ed] = 0x56d7,
  [0x47ee] = 0x56dd, [0x47ef] = 0x56e1, [0x47f0] = 0x56f5, [0x47f1] = 0x56eb,
  [0x47f2] = 0x56f9, [0x47f3] = 0x56ff, [0x47f4] = 0x5704, [0x47f5] = 0x570a,
  [0x47f6] = 0x5709, [0x47f7] = 0x571c, [0x47f8] = 0x5e0f, [0x47f9] = 0x5e19,
  [0x47fa] = 0x5e14, [0x47fb] = 0x5e11, [0x47fc] = 0x5e31, [0x47fd] = 0x5e3b,
  [0x47fe] = 0x5e3c, [0x4800] = 0x9145, [0x4801] = 0x9147, [0x4802] = 0x9148,
  [0x4803] = 0x9151, [0x4804] = 0x9153, [0x4805] = 0x9154, [0x4806] = 0x9155,
  [0x4807] = 0x9156, [0x4808] = 0x9158, [0x4809] = 0x9159, [0x480a] = 0x915b,
  [0x480b] = 0x915c, [0x480c] = 0x915f, [0x480d] = 0x9160, [0x480e] = 0x9166,
  [0x480f] = 0x9167, [0x4810] = 0x9168, [0x4811] = 0x916b, [0x4812] = 0x916d,
  [0x4813] = 0x9173, [0x4814] = 0x917a, [0x4815] = 0x917b, [0x4816] = 0x917c,
  [0x4817] = 0x9180, [0x4818] = 0x9181, [0x4819] = 0x9182, [0x481a] = 0x9183,
  [0x481b] = 0x9184, [0x481c] = 0x9186, [0x481d] = 0x9188, [0x481e] = 0x918a,
  [0x481f] = 0x918e, [0x4820] = 0x918f, [0x4821] = 0x9193, [0x4822] = 0x9194,
  [0x4823] = 0x9195, [0x4824] = 0x9196, [0x4825] = 0x9197, [0x4826] = 0x9198,
  [0x4827] = 0x9199, [0x4828] = 0x919c, [0x4829] = 0x919d, [0x482a] = 0x919e,
  [0x482b] = 0x919f, [0x482c] = 0x91a0, [0x482d] = 0x91a1, [0x482e] = 0x91a4,
  [0x482f] = 0x91a5, [0x4830] = 0x91a6, [0x4831] = 0x91a7, [0x4832] = 0x91a8,
  [0x4833] = 0x91a9, [0x4834] = 0x91ab, [0x4835] = 0x91ac, [0x4836] = 0x91b0,
  [0x4837] = 0x91b1, [0x4838] = 0x91b2, [0x4839] = 0x91b3, [0x483a] = 0x91b6,
  [0x483b] = 0x91b7, [0x483c] = 0x91b8, [0x483d] = 0x91b9, [0x483e] = 0x91bb,
  [0x4840] = 0x91bc, [0x4841] = 0x91bd, [0x4842] = 0x91be, [0x4843] = 0x91bf,
  [0x4844] = 0x91c0, [0x4845] = 0x91c1, [0x4846] = 0x91c2, [0x4847] = 0x91c3,
  [0x4848] = 0x91c4, [0x4849] = 0x91c5, [0x484a] = 0x91c6, [0x484b] = 0x91c8,
  [0x484c] = 0x91cb, [0x484d] = 0x91d0, [0x484e] = 0x91d2, [0x484f] = 0x91d3,
  [0x4850] = 0x91d4, [0x4851] = 0x91d5, [0x4852] = 0x91d6, [0x4853] = 0x91d7,
  [0x4854] = 0x91d8, [0x4855] = 0x91d9, [0x4856] = 0x91da, [0x4857] = 0x91db,
  [0x4858] = 0x91dd, [0x4859] = 0x91de, [0x485a] = 0x91df, [0x485b] = 0x91e0,
  [0x485c] = 0x91e1, [0x485d] = 0x91e2, [0x485e] = 0x91e3, [0x485f] = 0x91e4,
  [0x4860] = 0x91e5, [0x4861] = 0x5e37, [0x4862] = 0x5e44, [0x4863] = 0x5e54,
  [0x4864] = 0x5e5b, [0x4865] = 0x5e5e, [0x4866] = 0x5e61, [0x4867] = 0x5c8c,
  [0x4868] = 0x5c7a, [0x4869] = 0x5c8d, [0x486a] = 0x5c90, [0x486b] = 0x5c96,
  [0x486c] = 0x5c88, [0x486d] = 0x5c98, [0x486e] = 0x5c99, [0x486f] = 0x5c91,
  [0x4870] = 0x5c9a, [0x4871] = 0x5c9c, [0x4872] = 0x5cb5, [0x4873] = 0x5ca2,
  [0x4874] = 0x5cbd, [0x4875] = 0x5cac, [0x4876] = 0x5cab, [0x4877] = 0x5cb1,
  [0x4878] = 0x5ca3, [0x4879] = 0x5cc1, [0x487a] = 0x5cb7, [0x487b] = 0x5cc4,
  [0x487c] = 0x5cd2, [0x487d] = 0x5ce4, [0x487e] = 0x5ccb, [0x487f] = 0x5ce5,
  [0x4880] = 0x5d02, [0x4881] = 0x5d03, [0x4882] = 0x5d27, [0x4883] = 0x5d26,
  [0x4884] = 0x5d2e, [0x4885] = 0x5d24, [0x4886] = 0x5d1e, [0x4887] = 0x5d06,
  [0x4888] = 0x5d1b, [0x4889] = 0x5d58, [0x488a] = 0x5d3e, [0x488b] = 0x5d34,
  [0x488c] = 0x5d3d, [0x488d] = 0x5d6c, [0x488e] = 0x5d5b, [0x488f] = 0x5d6f,
  [0x4890] = 0x5d5d, [0x4891] = 0x5d6b, [0x4892] = 0x5d4b, [0x4893] = 0x5d4a,
  [0x4894] = 0x5d69, [0x4895] = 0x5d74, [0x4896] = 0x5d82, [0x4897] = 0x5d99,
  [0x4898] = 0x5d9d, [0x4899] = 0x8c73, [0x489a] = 0x5db7, [0x489b] = 0x5dc5,
  [0x489c] = 0x5f73, [0x489d] = 0x5f77, [0x489e] = 0x5f82, [0x489f] = 0x5f87,
  [0x48a0] = 0x5f89, [0x48a1] = 0x5f8c, [0x48a2] = 0x5f95, [0x48a3] = 0x5f99,
  [0x48a4] = 0x5f9c, [0x48a5] = 0x5fa8, [0x48a6] = 0x5fad, [0x48a7] = 0x5fb5,
  [0x48a8] = 0x5fbc, [0x48a9] = 0x8862, [0x48aa] = 0x5f61, [0x48ab] = 0x72ad,
  [0x48ac] = 0x72b0, [0x48ad] = 0x72b4, [0x48ae] = 0x72b7, [0x48af] = 0x72b8,
  [0x48b0] = 0x72c3, [0x48b1] = 0x72c1, [0x48b2] = 0x72ce, [0x48b3] = 0x72cd,
  [0x48b4] = 0x72d2, [0x48b5] = 0x72e8, [0x48b6] = 0x72ef, [0x48b7] = 0x72e9,
  [0x48b8] = 0x72f2, [0x48b9] = 0x72f4, [0x48ba] = 0x72f7, [0x48bb] = 0x7301,
  [0x48bc] = 0x72f3, [0x48bd] = 0x7303, [0x48be] = 0x72fa, [0x48c0] = 0x91e6,
  [0x48c1] = 0x91e7, [0x48c2] = 0x91e8, [0x48c3] = 0x91e9, [0x48c4] = 0x91ea,
  [0x48c5] = 0x91eb, [0x48c6] = 0x91ec, [0x48c7] = 0x91ed, [0x48c8] = 0x91ee,
  [0x48c9] = 0x91ef, [0x48ca] = 0x91f0, [0x48cb] = 0x91f1, [0x48cc] = 0x91f2,
  [0x48cd] = 0x91f3, [0x48ce] = 0x91f4, [0x48cf] = 0x91f5, [0x48d0] = 0x91f6,
  [0x48d1] = 0x91f7, [0x48d2] = 0x91f8, [0x48d3] = 0x91f9, [0x48d4] = 0x91fa,
  [0x48d5] = 0x91fb, [0x48d6] = 0x91fc, [0x48d7] = 0x91fd, [0x48d8] = 0x91fe,
  [0x48d9] = 0x91ff, [0x48da] = 0x9200, [0x48db] = 0x9201, [0x48dc] = 0x9202,
  [0x48dd] = 0x9203, [0x48de] = 0x9204, [0x48df] = 0x9205, [0x48e0] = 0x9206,
  [0x48e1] = 0x9207, [0x48e2] = 0x9208, [0x48e3] = 0x9209, [0x48e4] = 0x920a,
  [0x48e5] = 0x920b, [0x48e6] = 0x920c, [0x48e7] = 0x920d, [0x48e8] = 0x920e,
  [0x48e9] = 0x920f, [0x48ea] = 0x9210, [0x48eb] = 0x9211, [0x48ec] = 0x9212,
  [0x48ed] = 0x9213, [0x48ee] = 0x9214, [0x48ef] = 0x9215, [0x48f0] = 0x9216,
  [0x48f1] = 0x9217, [0x48f2] = 0x9218, [0x48f3] = 0x9219, [0x48f4] = 0x921a,
  [0x48f5] = 0x921b, [0x48f6] = 0x921c, [0x48f7] = 0x921d, [0x48f8] = 0x921e,
  [0x48f9] = 0x921f, [0x48fa] = 0x9220, [0x48fb] = 0x9221, [0x48fc] = 0x9222,
  [0x48fd] = 0x9223, [0x48fe] = 0x9224, [0x4900] = 0x9225, [0x4901] = 0x9226,
  [0x4902] = 0x9227, [0x4903] = 0x9228, [0x4904] = 0x9229, [0x4905] = 0x922a,
  [0x4906] = 0x922b, [0x4907] = 0x922c, [0x4908] = 0x922d, [0x4909] = 0x922e,
  [0x490a] = 0x922f, [0x490b] = 0x9230, [0x490c] = 0x9231, [0x490d] = 0x9232,
  [0x490e] = 0x9233, [0x490f] = 0x9234, [0x4910] = 0x9235, [0x4911] = 0x9236,
  [0x4912] = 0x9237, [0x4913] = 0x9238, [0x4914] = 0x9239, [0x4915] = 0x923a,
  [0x4916] = 0x923b, [0x4917] = 0x923c, [0x4918] = 0x923d, [0x4919] = 0x923e,
  [0x491a] = 0x923f, [0x491b] = 0x9240, [0x491c] = 0x9241, [0x491d] = 0x9242,
  [0x491e] = 0x9243, [0x491f] = 0x9244, [0x4920] = 0x9245, [0x4921] = 0x72fb,
  [0x4922] = 0x7317, [0x4923] = 0x7313, [0x4924] = 0x7321, [0x4925] = 0x730a,
  [0x4926] = 0x731e, [0x4927] = 0x731d, [0x4928] = 0x7315, [0x4929] = 0x7322,
  [0x492a] = 0x7339, [0x492b] = 0x7325, [0x492c] = 0x732c, [0x492d] = 0x7338,
  [0x492e] = 0x7331, [0x492f] = 0x7350, [0x4930] = 0x734d, [0x4931] = 0x7357,
  [0x4932] = 0x7360, [0x4933] = 0x736c, [0x4934] = 0x736f, [0x4935] = 0x737e,
  [0x4936] = 0x821b, [0x4937] = 0x5925, [0x4938] = 0x98e7, [0x4939] = 0x5924,
  [0x493a] = 0x5902, [0x493b] = 0x9963, [0x493c] = 0x9967, [0x493d] = 0x9968,
  [0x493e] = 0x9969, [0x493f] = 0x996a, [0x4940] = 0x996b, [0x4941] = 0x996c,
  [0x4942] = 0x9974, [0x4943] = 0x9977, [0x4944] = 0x997d, [0x4945] = 0x9980,
  [0x4946] = 0x9984, [0x4947] = 0x9987, [0x4948] = 0x998a, [0x4949] = 0x998d,
  [0x494a] = 0x9990, [0x494b] = 0x9991, [0x494c] = 0x9993, [0x494d] = 0x9994,
  [0x494e] = 0x9995, [0x494f] = 0x5e80, [0x4950] = 0x5e91, [0x4951] = 0x5e8b,
  [0x4952] = 0x5e96, [0x4953] = 0x5ea5, [0x4954] = 0x5ea0, [0x4955] = 0x5eb9,
  [0x4956] = 0x5eb5, [0x4957] = 0x5ebe, [0x4958] = 0x5eb3, [0x4959] = 0x8d53,
  [0x495a] = 0x5ed2, [0x495b] = 0x5ed1, [0x495c] = 0x5edb, [0x495d] = 0x5ee8,
  [0x495e] = 0x5eea, [0x495f] = 0x81ba, [0x4960] = 0x5fc4, [0x4961] = 0x5fc9,
  [0x4962] = 0x5fd6, [0x4963] = 0x5fcf, [0x4964] = 0x6003, [0x4965] = 0x5fee,
  [0x4966] = 0x6004, [0x4967] = 0x5fe1, [0x4968] = 0x5fe4, [0x4969] = 0x5ffe,
  [0x496a] = 0x6005, [0x496b] = 0x6006, [0x496c] = 0x5fea, [0x496d] = 0x5fed,
  [0x496e] = 0x5ff8, [0x496f] = 0x6019, [0x4970] = 0x6035, [0x4971] = 0x6026,
  [0x4972] = 0x601b, [0x4973] = 0x600f, [0x4974] = 0x600d, [0x4975] = 0x6029,
  [0x4976] = 0x602b, [0x4977] = 0x600a, [0x4978] = 0x603f, [0x4979] = 0x6021,
  [0x497a] = 0x6078, [0x497b] = 0x6079, [0x497c] = 0x607b, [0x497d] = 0x607a,
  [0x497e] = 0x6042, [0x4980] = 0x9246, [0x4981] = 0x9247, [0x4982] = 0x9248,
  [0x4983] = 0x9249, [0x4984] = 0x924a, [0x4985] = 0x924b, [0x4986] = 0x924c,
  [0x4987] = 0x924d, [0x4988] = 0x924e, [0x4989] = 0x924f, [0x498a] = 0x9250,
  [0x498b] = 0x9251, [0x498c] = 0x9252, [0x498d] = 0x9253, [0x498e] = 0x9254,
  [0x498f] = 0x9255, [0x4990] = 0x9256, [0x4991] = 0x9257, [0x4992] = 0x9258,
  [0x4993] = 0x9259, [0x4994] = 0x925a, [0x4995] = 0x925b, [0x4996] = 0x925c,
  [0x4997] = 0x925d, [0x4998] = 0x925e, [0x4999] = 0x925f, [0x499a] = 0x9260,
  [0x499b] = 0x9261, [0x499c] = 0x9262, [0x499d] = 0x9263, [0x499e] = 0x9264,
  [0x499f] = 0x9265, [0x49a0] = 0x9266, [0x49a1] = 0x9267, [0x49a2] = 0x9268,
  [0x49a3] = 0x9269, [0x49a4] = 0x926a, [0x49a5] = 0x926b, [0x49a6] = 0x926c,
  [0x49a7] = 0x926d, [0x49a8] = 0x926e, [0x49a9] = 0x926f, [0x49aa] = 0x9270,
  [0x49ab] = 0x9271, [0x49ac] = 0x9272, [0x49ad] = 0x9273, [0x49ae] = 0x9275,
  [0x49af] = 0x9276, [0x49b0] = 0x9277, [0x49b1] = 0x9278, [0x49b2] = 0x9279,
  [0x49b3] = 0x927a, [0x49b4] = 0x927b, [0x49b5] = 0x927c, [0x49b6] = 0x927d,
  [0x49b7] = 0x927e, [0x49b8] = 0x927f, [0x49b9] = 0x9280, [0x49ba] = 0x9281,
  [0x49bb] = 0x9282, [0x49bc] = 0x9283, [0x49bd] = 0x9284, [0x49be] = 0x9285,
  [0x49c0] = 0x9286, [0x49c1] = 0x9287, [0x49c2] = 0x9288, [0x49c3] = 0x9289,
  [0x49c4] = 0x928a, [0x49c5] = 0x928b, [0x49c6] = 0x928c, [0x49c7] = 0x928d,
  [0x49c8] = 0x928f, [0x49c9] = 0x9290, [0x49ca] = 0x9291, [0x49cb] = 0x9292,
  [0x49cc] = 0x9293, [0x49cd] = 0x9294, [0x49ce] = 0x9295, [0x49cf] = 0x9296,
  [0x49d0] = 0x9297, [0x49d1] = 0x9298, [0x49d2] = 0x9299, [0x49d3] = 0x929a,
  [0x49d4] = 0x929b, [0x49d5] = 0x929c, [0x49d6] = 0x929d, [0x49d7] = 0x929e,
  [0x49d8] = 0x929f, [0x49d9] = 0x92a0, [0x49da] = 0x92a1, [0x49db] = 0x92a2,
  [0x49dc] = 0x92a3, [0x49dd] = 0x92a4, [0x49de] = 0x92a5, [0x49df] = 0x92a6,
  [0x49e0] = 0x92a7, [0x49e1] = 0x606a, [0x49e2] = 0x607d, [0x49e3] = 0x6096,
  [0x49e4] = 0x609a, [0x49e5] = 0x60ad, [0x49e6] = 0x609d, [0x49e7] = 0x6083,
  [0x49e8] = 0x6092, [0x49e9] = 0x608c, [0x49ea] = 0x609b, [0x49eb] = 0x60ec,
  [0x49ec] = 0x60bb, [0x49ed] = 0x60b1, [0x49ee] = 0x60dd, [0x49ef] = 0x60d8,
  [0x49f0] = 0x60c6, [0x49f1] = 0x60da, [0x49f2] = 0x60b4, [0x49f3] = 0x6120,
  [0x49f4] = 0x6126, [0x49f5] = 0x6115, [0x49f6] = 0x6123, [0x49f7] = 0x60f4,
  [0x49f8] = 0x6100, [0x49f9] = 0x610e, [0x49fa] = 0x612b, [0x49fb] = 0x614a,
  [0x49fc] = 0x6175, [0x49fd] = 0x61ac, [0x49fe] = 0x6194, [0x49ff] = 0x61a7,
  [0x4a00] = 0x61b7, [0x4a01] = 0x61d4, [0x4a02] = 0x61f5, [0x4a03] = 0x5fdd,
  [0x4a04] = 0x96b3, [0x4a05] = 0x95e9, [0x4a06] = 0x95eb, [0x4a07] = 0x95f1,
  [0x4a08] = 0x95f3, [0x4a09] = 0x95f5, [0x4a0a] = 0x95f6, [0x4a0b] = 0x95fc,
  [0x4a0c] = 0x95fe, [0x4a0d] = 0x9603, [0x4a0e] = 0x9604, [0x4a0f] = 0x9606,
  [0x4a10] = 0x9608, [0x4a11] = 0x960a, [0x4a12] = 0x960b, [0x4a13] = 0x960c,
  [0x4a14] = 0x960d, [0x4a15] = 0x960f, [0x4a16] = 0x9612, [0x4a17] = 0x9615,
  [0x4a18] = 0x9616, [0x4a19] = 0x9617, [0x4a1a] = 0x9619, [0x4a1b] = 0x961a,
  [0x4a1c] = 0x4e2c, [0x4a1d] = 0x723f, [0x4a1e] = 0x6215, [0x4a1f] = 0x6c35,
  [0x4a20] = 0x6c54, [0x4a21] = 0x6c5c, [0x4a22] = 0x6c4a, [0x4a23] = 0x6ca3,
  [0x4a24] = 0x6c85, [0x4a25] = 0x6c90, [0x4a26] = 0x6c94, [0x4a27] = 0x6c8c,
  [0x4a28] = 0x6c68, [0x4a29] = 0x6c69, [0x4a2a] = 0x6c74, [0x4a2b] = 0x6c76,
  [0x4a2c] = 0x6c86, [0x4a2d] = 0x6ca9, [0x4a2e] = 0x6cd0, [0x4a2f] = 0x6cd4,
  [0x4a30] = 0x6cad, [0x4a31] = 0x6cf7, [0x4a32] = 0x6cf8, [0x4a33] = 0x6cf1,
  [0x4a34] = 0x6cd7, [0x4a35] = 0x6cb2, [0x4a36] = 0x6ce0, [0x4a37] = 0x6cd6,
  [0x4a38] = 0x6cfa, [0x4a39] = 0x6ceb, [0x4a3a] = 0x6cee, [0x4a3b] = 0x6cb1,
  [0x4a3c] = 0x6cd3, [0x4a3d] = 0x6cef, [0x4a3e] = 0x6cfe, [0x4a40] = 0x92a8,
  [0x4a41] = 0x92a9, [0x4a42] = 0x92aa, [0x4a43] = 0x92ab, [0x4a44] = 0x92ac,
  [0x4a45] = 0x92ad, [0x4a46] = 0x92af, [0x4a47] = 0x92b0, [0x4a48] = 0x92b1,
  [0x4a49] = 0x92b2, [0x4a4a] = 0x92b3, [0x4a4b] = 0x92b4, [0x4a4c] = 0x92b5,
  [0x4a4d] = 0x92b6, [0x4a4e] = 0x92b7, [0x4a4f] = 0x92b8, [0x4a50] = 0x92b9,
  [0x4a51] = 0x92ba, [0x4a52] = 0x92bb, [0x4a53] = 0x92bc, [0x4a54] = 0x92bd,
  [0x4a55] = 0x92be, [0x4a56] = 0x92bf, [0x4a57] = 0x92c0, [0x4a58] = 0x92c1,
  [0x4a59] = 0x92c2, [0x4a5a] = 0x92c3, [0x4a5b] = 0x92c4, [0x4a5c] = 0x92c5,
  [0x4a5d] = 0x92c6, [0x4a5e] = 0x92c7, [0x4a5f] = 0x92c9, [0x4a60] = 0x92ca,
  [0x4a61] = 0x92cb, [0x4a62] = 0x92cc, [0x4a63] = 0x92cd, [0x4a64] = 0x92ce,
  [0x4a65] = 0x92cf, [0x4a66] = 0x92d0, [0x4a67] = 0x92d1, [0x4a68] = 0x92d2,
  [0x4a69] = 0x92d3, [0x4a6a] = 0x92d4, [0x4a6b] = 0x92d5, [0x4a6c] = 0x92d6,
  [0x4a6d] = 0x92d7, [0x4a6e] = 0x92d8, [0x4a6f] = 0x92d9, [0x4a70] = 0x92da,
  [0x4a71] = 0x92db, [0x4a72] = 0x92dc, [0x4a73] = 0x92dd, [0x4a74] = 0x92de,
  [0x4a75] = 0x92df, [0x4a76] = 0x92e0, [0x4a77] = 0x92e1, [0x4a78] = 0x92e2,
  [0x4a79] = 0x92e3, [0x4a7a] = 0x92e4, [0x4a7b] = 0x92e5, [0x4a7c] = 0x92e6,
  [0x4a7d] = 0x92e7, [0x4a7e] = 0x92e8, [0x4a80] = 0x92e9, [0x4a81] = 0x92ea,
  [0x4a82] = 0x92eb, [0x4a83] = 0x92ec, [0x4a84] = 0x92ed, [0x4a85] = 0x92ee,
  [0x4a86] = 0x92ef, [0x4a87] = 0x92f0, [0x4a88] = 0x92f1, [0x4a89] = 0x92f2,
  [0x4a8a] = 0x92f3, [0x4a8b] = 0x92f4, [0x4a8c] = 0x92f5, [0x4a8d] = 0x92f6,
  [0x4a8e] = 0x92f7, [0x4a8f] = 0x92f8, [0x4a90] = 0x92f9, [0x4a91] = 0x92fa,
  [0x4a92] = 0x92fb, [0x4a93] = 0x92fc, [0x4a94] = 0x92fd, [0x4a95] = 0x92fe,
  [0x4a96] = 0x92ff, [0x4a97] = 0x9300, [0x4a98] = 0x9301, [0x4a99] = 0x9302,
  [0x4a9a] = 0x9303, [0x4a9b] = 0x9304, [0x4a9c] = 0x9305, [0x4a9d] = 0x9306,
  [0x4a9e] = 0x9307, [0x4a9f] = 0x9308, [0x4aa0] = 0x9309, [0x4aa1] = 0x6d39,
  [0x4aa2] = 0x6d27, [0x4aa3] = 0x6d0c, [0x4aa4] = 0x6d43, [0x4aa5] = 0x6d48,
  [0x4aa6] = 0x6d07, [0x4aa7] = 0x6d04, [0x4aa8] = 0x6d19, [0x4aa9] = 0x6d0e,
  [0x4aaa] = 0x6d2b, [0x4aab] = 0x6d4d, [0x4aac] = 0x6d2e, [0x4aad] = 0x6d35,
  [0x4aae] = 0x6d1a, [0x4aaf] = 0x6d4f, [0x4ab0] = 0x6d52, [0x4ab1] = 0x6d54,
  [0x4ab2] = 0x6d33, [0x4ab3] = 0x6d91, [0x4ab4] = 0x6d6f, [0x4ab5] = 0x6d9e,
  [0x4ab6] = 0x6da0, [0x4ab7] = 0x6d5e, [0x4ab8] = 0x6d93, [0x4ab9] = 0x6d94,
  [0x4aba] = 0x6d5c, [0x4abb] = 0x6d60, [0x4abc] = 0x6d7c, [0x4abd] = 0x6d63,
  [0x4abe] = 0x6e1a, [0x4abf] = 0x6dc7, [0x4ac0] = 0x6dc5, [0x4ac1] = 0x6dde,
  [0x4ac2] = 0x6e0e, [0x4ac3] = 0x6dbf, [0x4ac4] = 0x6de0, [0x4ac5] = 0x6e11,
  [0x4ac6] = 0x6de6, [0x4ac7] = 0x6ddd, [0x4ac8] = 0x6dd9, [0x4ac9] = 0x6e16,
  [0x4aca] = 0x6dab, [0x4acb] = 0x6e0c, [0x4acc] = 0x6dae, [0x4acd] = 0x6e2b,
  [0x4ace] = 0x6e6e, [0x4acf] = 0x6e4e, [0x4ad0] = 0x6e6b, [0x4ad1] = 0x6eb2,
  [0x4ad2] = 0x6e5f, [0x4ad3] = 0x6e86, [0x4ad4] = 0x6e53, [0x4ad5] = 0x6e54,
  [0x4ad6] = 0x6e32, [0x4ad7] = 0x6e25, [0x4ad8] = 0x6e44, [0x4ad9] = 0x6edf,
  [0x4ada] = 0x6eb1, [0x4adb] = 0x6e98, [0x4adc] = 0x6ee0, [0x4add] = 0x6f2d,
  [0x4ade] = 0x6ee2, [0x4adf] = 0x6ea5, [0x4ae0] = 0x6ea7, [0x4ae1] = 0x6ebd,
  [0x4ae2] = 0x6ebb, [0x4ae3] = 0x6eb7, [0x4ae4] = 0x6ed7, [0x4ae5] = 0x6eb4,
  [0x4ae6] = 0x6ecf, [0x4ae7] = 0x6e8f, [0x4ae8] = 0x6ec2, [0x4ae9] = 0x6e9f,
  [0x4aea] = 0x6f62, [0x4aeb] = 0x6f46, [0x4aec] = 0x6f47, [0x4aed] = 0x6f24,
  [0x4aee] = 0x6f15, [0x4aef] = 0x6ef9, [0x4af0] = 0x6f2f, [0x4af1] = 0x6f36,
  [0x4af2] = 0x6f4b, [0x4af3] = 0x6f74, [0x4af4] = 0x6f2a, [0x4af5] = 0x6f09,
  [0x4af6] = 0x6f29, [0x4af7] = 0x6f89, [0x4af8] = 0x6f8d, [0x4af9] = 0x6f8c,
  [0x4afa] = 0x6f78, [0x4afb] = 0x6f72, [0x4afc] = 0x6f7c, [0x4afd] = 0x6f7a,
  [0x4afe] = 0x6fd1, [0x4b00] = 0x930a, [0x4b01] = 0x930b, [0x4b02] = 0x930c,
  [0x4b03] = 0x930d, [0x4b04] = 0x930e, [0x4b05] = 0x930f, [0x4b06] = 0x9310,
  [0x4b07] = 0x9311, [0x4b08] = 0x9312, [0x4b09] = 0x9313, [0x4b0a] = 0x9314,
  [0x4b0b] = 0x9315, [0x4b0c] = 0x9316, [0x4b0d] = 0x9317, [0x4b0e] = 0x9318,
  [0x4b0f] = 0x9319, [0x4b10] = 0x931a, [0x4b11] = 0x931b, [0x4b12] = 0x931c,
  [0x4b13] = 0x931d, [0x4b14] = 0x931e, [0x4b15] = 0x931f, [0x4b16] = 0x9320,
  [0x4b17] = 0x9321, [0x4b18] = 0x9322, [0x4b19] = 0x9323, [0x4b1a] = 0x9324,
  [0x4b1b] = 0x9325, [0x4b1c] = 0x9326, [0x4b1d] = 0x9327, [0x4b1e] = 0x9328,
  [0x4b1f] = 0x9329, [0x4b20] = 0x932a, [0x4b21] = 0x932b, [0x4b22] = 0x932c,
  [0x4b23] = 0x932d, [0x4b24] = 0x932e, [0x4b25] = 0x932f, [0x4b26] = 0x9330,
  [0x4b27] = 0x9331, [0x4b28] = 0x9332, [0x4b29] = 0x9333, [0x4b2a] = 0x9334,
  [0x4b2b] = 0x9335, [0x4b2c] = 0x9336, [0x4b2d] = 0x9337, [0x4b2e] = 0x9338,
  [0x4b2f] = 0x9339, [0x4b30] = 0x933a, [0x4b31] = 0x933b, [0x4b32] = 0x933c,
  [0x4b33] = 0x933d, [0x4b34] = 0x933f, [0x4b35] = 0x9340, [0x4b36] = 0x9341,
  [0x4b37] = 0x9342, [0x4b38] = 0x9343, [0x4b39] = 0x9344, [0x4b3a] = 0x9345,
  [0x4b3b] = 0x9346, [0x4b3c] = 0x9347, [0x4b3d] = 0x9348, [0x4b3e] = 0x9349,
  [0x4b40] = 0x934a, [0x4b41] = 0x934b, [0x4b42] = 0x934c, [0x4b43] = 0x934d,
  [0x4b44] = 0x934e, [0x4b45] = 0x934f, [0x4b46] = 0x9350, [0x4b47] = 0x9351,
  [0x4b48] = 0x9352, [0x4b49] = 0x9353, [0x4b4a] = 0x9354, [0x4b4b] = 0x9355,
  [0x4b4c] = 0x9356, [0x4b4d] = 0x9357, [0x4b4e] = 0x9358, [0x4b4f] = 0x9359,
  [0x4b50] = 0x935a, [0x4b51] = 0x935b, [0x4b52] = 0x935c, [0x4b53] = 0x935d,
  [0x4b54] = 0x935e, [0x4b55] = 0x935f, [0x4b56] = 0x9360, [0x4b57] = 0x9361,
  [0x4b58] = 0x9362, [0x4b59] = 0x9363, [0x4b5a] = 0x9364, [0x4b5b] = 0x9365,
  [0x4b5c] = 0x9366, [0x4b5d] = 0x9367, [0x4b5e] = 0x9368, [0x4b5f] = 0x9369,
  [0x4b60] = 0x936b, [0x4b61] = 0x6fc9, [0x4b62] = 0x6fa7, [0x4b63] = 0x6fb9,
  [0x4b64] = 0x6fb6, [0x4b65] = 0x6fc2, [0x4b66] = 0x6fe1, [0x4b67] = 0x6fee,
  [0x4b68] = 0x6fde, [0x4b69] = 0x6fe0, [0x4b6a] = 0x6fef, [0x4b6b] = 0x701a,
  [0x4b6c] = 0x7023, [0x4b6d] = 0x701b, [0x4b6e] = 0x7039, [0x4b6f] = 0x7035,
  [0x4b70] = 0x704f, [0x4b71] = 0x705e, [0x4b72] = 0x5b80, [0x4b73] = 0x5b84,
  [0x4b74] = 0x5b95, [0x4b75] = 0x5b93, [0x4b76] = 0x5ba5, [0x4b77] = 0x5bb8,
  [0x4b78] = 0x752f, [0x4b79] = 0x9a9e, [0x4b7a] = 0x6434, [0x4b7b] = 0x5be4,
  [0x4b7c] = 0x5bee, [0x4b7d] = 0x8930, [0x4b7e] = 0x5bf0, [0x4b7f] = 0x8e47,
  [0x4b80] = 0x8b07, [0x4b81] = 0x8fb6, [0x4b82] = 0x8fd3, [0x4b83] = 0x8fd5,
  [0x4b84] = 0x8fe5, [0x4b85] = 0x8fee, [0x4b86] = 0x8fe4, [0x4b87] = 0x8fe9,
  [0x4b88] = 0x8fe6, [0x4b89] = 0x8ff3, [0x4b8a] = 0x8fe8, [0x4b8b] = 0x9005,
  [0x4b8c] = 0x9004, [0x4b8d] = 0x900b, [0x4b8e] = 0x9026, [0x4b8f] = 0x9011,
  [0x4b90] = 0x900d, [0x4b91] = 0x9016, [0x4b92] = 0x9021, [0x4b93] = 0x9035,
  [0x4b94] = 0x9036, [0x4b95] = 0x902d, [0x4b96] = 0x902f, [0x4b97] = 0x9044,
  [0x4b98] = 0x9051, [0x4b99] = 0x9052, [0x4b9a] = 0x9050, [0x4b9b] = 0x9068,
  [0x4b9c] = 0x9058, [0x4b9d] = 0x9062, [0x4b9e] = 0x905b, [0x4b9f] = 0x66b9,
  [0x4ba0] = 0x9074, [0x4ba1] = 0x907d, [0x4ba2] = 0x9082, [0x4ba3] = 0x9088,
  [0x4ba4] = 0x9083, [0x4ba5] = 0x908b, [0x4ba6] = 0x5f50, [0x4ba7] = 0x5f57,
  [0x4ba8] = 0x5f56, [0x4ba9] = 0x5f58, [0x4baa] = 0x5c3b, [0x4bab] = 0x54ab,
  [0x4bac] = 0x5c50, [0x4bad] = 0x5c59, [0x4bae] = 0x5b71, [0x4baf] = 0x5c63,
  [0x4bb0] = 0x5c66, [0x4bb1] = 0x7fbc, [0x4bb2] = 0x5f2a, [0x4bb3] = 0x5f29,
  [0x4bb4] = 0x5f2d, [0x4bb5] = 0x8274, [0x4bb6] = 0x5f3c, [0x4bb7] = 0x9b3b,
  [0x4bb8] = 0x5c6e, [0x4bb9] = 0x5981, [0x4bba] = 0x5983, [0x4bbb] = 0x598d,
  [0x4bbc] = 0x59a9, [0x4bbd] = 0x59aa, [0x4bbe] = 0x59a3, [0x4bc0] = 0x936c,
  [0x4bc1] = 0x936d, [0x4bc2] = 0x936e, [0x4bc3] = 0x936f, [0x4bc4] = 0x9370,
  [0x4bc5] = 0x9371, [0x4bc6] = 0x9372, [0x4bc7] = 0x9373, [0x4bc8] = 0x9374,
  [0x4bc9] = 0x9375, [0x4bca] = 0x9376, [0x4bcb] = 0x9377, [0x4bcc] = 0x9378,
  [0x4bcd] = 0x9379, [0x4bce] = 0x937a, [0x4bcf] = 0x937b, [0x4bd0] = 0x937c,
  [0x4bd1] = 0x937d, [0x4bd2] = 0x937e, [0x4bd3] = 0x937f, [0x4bd4] = 0x9380,
  [0x4bd5] = 0x9381, [0x4bd6] = 0x9382, [0x4bd7] = 0x9383, [0x4bd8] = 0x9384,
  [0x4bd9] = 0x9385, [0x4bda] = 0x9386, [0x4bdb] = 0x9387, [0x4bdc] = 0x9388,
  [0x4bdd] = 0x9389, [0x4bde] = 0x938a, [0x4bdf] = 0x938b, [0x4be0] = 0x938c,
  [0x4be1] = 0x938d, [0x4be2] = 0x938e, [0x4be3] = 0x9390, [0x4be4] = 0x9391,
  [0x4be5] = 0x9392, [0x4be6] = 0x9393, [0x4be7] = 0x9394, [0x4be8] = 0x9395,
  [0x4be9] = 0x9396, [0x4bea] = 0x9397, [0x4beb] = 0x9398, [0x4bec] = 0x9399,
  [0x4bed] = 0x939a, [0x4bee] = 0x939b, [0x4bef] = 0x939c, [0x4bf0] = 0x939d,
  [0x4bf1] = 0x939e, [0x4bf2] = 0x939f, [0x4bf3] = 0x93a0, [0x4bf4] = 0x93a1,
  [0x4bf5] = 0x93a2, [0x4bf6] = 0x93a3, [0x4bf7] = 0x93a4, [0x4bf8] = 0x93a5,
  [0x4bf9] = 0x93a6, [0x4bfa] = 0x93a7, [0x4bfb] = 0x93a8, [0x4bfc] = 0x93a9,
  [0x4bfd] = 0x93aa, [0x4bfe] = 0x93ab, [0x4c00] = 0x93ac, [0x4c01] = 0x93ad,
  [0x4c02] = 0x93ae, [0x4c03] = 0x93af, [0x4c04] = 0x93b0, [0x4c05] = 0x93b1,
  [0x4c06] = 0x93b2, [0x4c07] = 0x93b3, [0x4c08] = 0x93b4, [0x4c09] = 0x93b5,
  [0x4c0a] = 0x93b6, [0x4c0b] = 0x93b7, [0x4c0c] = 0x93b8, [0x4c0d] = 0x93b9,
  [0x4c0e] = 0x93ba, [0x4c0f] = 0x93bb, [0x4c10] = 0x93bc, [0x4c11] = 0x93bd,
  [0x4c12] = 0x93be, [0x4c13] = 0x93bf, [0x4c14] = 0x93c0, [0x4c15] = 0x93c1,
  [0x4c16] = 0x93c2, [0x4c17] = 0x93c3, [0x4c18] = 0x93c4, [0x4c19] = 0x93c5,
  [0x4c1a] = 0x93c6, [0x4c1b] = 0x93c7, [0x4c1c] = 0x93c8, [0x4c1d] = 0x93c9,
  [0x4c1e] = 0x93cb, [0x4c1f] = 0x93cc, [0x4c20] = 0x93cd, [0x4c21] = 0x5997,
  [0x4c22] = 0x59ca, [0x4c23] = 0x59ab, [0x4c24] = 0x599e, [0x4c25] = 0x59a4,
  [0x4c26] = 0x59d2, [0x4c27] = 0x59b2, [0x4c28] = 0x59af, [0x4c29] = 0x59d7,
  [0x4c2a] = 0x59be, [0x4c2b] = 0x5a05, [0x4c2c] = 0x5a06, [0x4c2d] = 0x59dd,
  [0x4c2e] = 0x5a08, [0x4c2f] = 0x59e3, [0x4c30] = 0x59d8, [0x4c31] = 0x59f9,
  [0x4c32] = 0x5a0c, [0x4c33] = 0x5a09, [0x4c34] = 0x5a32, [0x4c35] = 0x5a34,
  [0x4c36] = 0x5a11, [0x4c37] = 0x5a23, [0x4c38] = 0x5a13, [0x4c39] = 0x5a40,
  [0x4c3a] = 0x5a67, [0x4c3b] = 0x5a4a, [0x4c3c] = 0x5a55, [0x4c3d] = 0x5a3c,
  [0x4c3e] = 0x5a62, [0x4c3f] = 0x5a75, [0x4c40] = 0x80ec, [0x4c41] = 0x5aaa,
  [0x4c42] = 0x5a9b, [0x4c43] = 0x5a77, [0x4c44] = 0x5a7a, [0x4c45] = 0x5abe,
  [0x4c46] = 0x5aeb, [0x4c47] = 0x5ab2, [0x4c48] = 0x5ad2, [0x4c49] = 0x5ad4,
  [0x4c4a] = 0x5ab8, [0x4c4b] = 0x5ae0, [0x4c4c] = 0x5ae3, [0x4c4d] = 0x5af1,
  [0x4c4e] = 0x5ad6, [0x4c4f] = 0x5ae6, [0x4c50] = 0x5ad8, [0x4c51] = 0x5adc,
  [0x4c52] = 0x5b09, [0x4c53] = 0x5b17, [0x4c54] = 0x5b16, [0x4c55] = 0x5b32,
  [0x4c56] = 0x5b37, [0x4c57] = 0x5b40, [0x4c58] = 0x5c15, [0x4c59] = 0x5c1c,
  [0x4c5a] = 0x5b5a, [0x4c5b] = 0x5b65, [0x4c5c] = 0x5b73, [0x4c5d] = 0x5b51,
  [0x4c5e] = 0x5b53, [0x4c5f] = 0x5b62, [0x4c60] = 0x9a75, [0x4c61] = 0x9a77,
  [0x4c62] = 0x9a78, [0x4c63] = 0x9a7a, [0x4c64] = 0x9a7f, [0x4c65] = 0x9a7d,
  [0x4c66] = 0x9a80, [0x4c67] = 0x9a81, [0x4c68] = 0x9a85, [0x4c69] = 0x9a88,
  [0x4c6a] = 0x9a8a, [0x4c6b] = 0x9a90, [0x4c6c] = 0x9a92, [0x4c6d] = 0x9a93,
  [0x4c6e] = 0x9a96, [0x4c6f] = 0x9a98, [0x4c70] = 0x9a9b, [0x4c71] = 0x9a9c,
  [0x4c72] = 0x9a9d, [0x4c73] = 0x9a9f, [0x4c74] = 0x9aa0, [0x4c75] = 0x9aa2,
  [0x4c76] = 0x9aa3, [0x4c77] = 0x9aa5, [0x4c78] = 0x9aa7, [0x4c79] = 0x7e9f,
  [0x4c7a] = 0x7ea1, [0x4c7b] = 0x7ea3, [0x4c7c] = 0x7ea5, [0x4c7d] = 0x7ea8,
  [0x4c7e] = 0x7ea9, [0x4c80] = 0x93ce, [0x4c81] = 0x93cf, [0x4c82] = 0x93d0,
  [0x4c83] = 0x93d1, [0x4c84] = 0x93d2, [0x4c85] = 0x93d3, [0x4c86] = 0x93d4,
  [0x4c87] = 0x93d5, [0x4c88] = 0x93d7, [0x4c89] = 0x93d8, [0x4c8a] = 0x93d9,
  [0x4c8b] = 0x93da, [0x4c8c] = 0x93db, [0x4c8d] = 0x93dc, [0x4c8e] = 0x93dd,
  [0x4c8f] = 0x93de, [0x4c90] = 0x93df, [0x4c91] = 0x93e0, [0x4c92] = 0x93e1,
  [0x4c93] = 0x93e2, [0x4c94] = 0x93e3, [0x4c95] = 0x93e4, [0x4c96] = 0x93e5,
  [0x4c97] = 0x93e6, [0x4c98] = 0x93e7, [0x4c99] = 0x93e8, [0x4c9a] = 0x93e9,
  [0x4c9b] = 0x93ea, [0x4c9c] = 0x93eb, [0x4c9d] = 0x93ec, [0x4c9e] = 0x93ed,
  [0x4c9f] = 0x93ee, [0x4ca0] = 0x93ef, [0x4ca1] = 0x93f0, [0x4ca2] = 0x93f1,
  [0x4ca3] = 0x93f2, [0x4ca4] = 0x93f3, [0x4ca5] = 0x93f4, [0x4ca6] = 0x93f5,
  [0x4ca7] = 0x93f6, [0x4ca8] = 0x93f7, [0x4ca9] = 0x93f8, [0x4caa] = 0x93f9,
  [0x4cab] = 0x93fa, [0x4cac] = 0x93fb, [0x4cad] = 0x93fc, [0x4cae] = 0x93fd,
  [0x4caf] = 0x93fe, [0x4cb0] = 0x93ff, [0x4cb1] = 0x9400, [0x4cb2] = 0x9401,
  [0x4cb3] = 0x9402, [0x4cb4] = 0x9403, [0x4cb5] = 0x9404, [0x4cb6] = 0x9405,
  [0x4cb7] = 0x9406, [0x4cb8] = 0x9407, [0x4cb9] = 0x9408, [0x4cba] = 0x9409,
  [0x4cbb] = 0x940a, [0x4cbc] = 0x940b, [0x4cbd] = 0x940c, [0x4cbe] = 0x940d,
  [0x4cc0] = 0x940e, [0x4cc1] = 0x940f, [0x4cc2] = 0x9410, [0x4cc3] = 0x9411,
  [0x4cc4] = 0x9412, [0x4cc5] = 0x9413, [0x4cc6] = 0x9414, [0x4cc7] = 0x9415,
  [0x4cc8] = 0x9416, [0x4cc9] = 0x9417, [0x4cca] = 0x9418, [0x4ccb] = 0x9419,
  [0x4ccc] = 0x941a, [0x4ccd] = 0x941b, [0x4cce] = 0x941c, [0x4ccf] = 0x941d,
  [0x4cd0] = 0x941e, [0x4cd1] = 0x941f, [0x4cd2] = 0x9420, [0x4cd3] = 0x9421,
  [0x4cd4] = 0x9422, [0x4cd5] = 0x9423, [0x4cd6] = 0x9424, [0x4cd7] = 0x9425,
  [0x4cd8] = 0x9426, [0x4cd9] = 0x9427, [0x4cda] = 0x9428, [0x4cdb] = 0x9429,
  [0x4cdc] = 0x942a, [0x4cdd] = 0x942b, [0x4cde] = 0x942c, [0x4cdf] = 0x942d,
  [0x4ce0] = 0x942e, [0x4ce1] = 0x7ead, [0x4ce2] = 0x7eb0, [0x4ce3] = 0x7ebe,
  [0x4ce4] = 0x7ec0, [0x4ce5] = 0x7ec1, [0x4ce6] = 0x7ec2, [0x4ce7] = 0x7ec9,
  [0x4ce8] = 0x7ecb, [0x4ce9] = 0x7ecc, [0x4cea] = 0x7ed0, [0x4ceb] = 0x7ed4,
  [0x4cec] = 0x7ed7, [0x4ced] = 0x7edb, [0x4cee] = 0x7ee0, [0x4cef] = 0x7ee1,
  [0x4cf0] = 0x7ee8, [0x4cf1] = 0x7eeb, [0x4cf2] = 0x7eee, [0x4cf3] = 0x7eef,
  [0x4cf4] = 0x7ef1, [0x4cf5] = 0x7ef2, [0x4cf6] = 0x7f0d, [0x4cf7] = 0x7ef6,
  [0x4cf8] = 0x7efa, [0x4cf9] = 0x7efb, [0x4cfa] = 0x7efe, [0x4cfb] = 0x7f01,
  [0x4cfc] = 0x7f02, [0x4cfd] = 0x7f03, [0x4cfe] = 0x7f07, [0x4cff] = 0x7f08,
  [0x4d00] = 0x7f0b, [0x4d01] = 0x7f0c, [0x4d02] = 0x7f0f, [0x4d03] = 0x7f11,
  [0x4d04] = 0x7f12, [0x4d05] = 0x7f17, [0x4d06] = 0x7f19, [0x4d07] = 0x7f1c,
  [0x4d08] = 0x7f1b, [0x4d09] = 0x7f1f, [0x4d0a] = 0x7f21, [0x4d0b] = 0x7f22,
  [0x4d0c] = 0x7f23, [0x4d0d] = 0x7f24, [0x4d0e] = 0x7f25, [0x4d0f] = 0x7f26,
  [0x4d10] = 0x7f27, [0x4d11] = 0x7f2a, [0x4d12] = 0x7f2b, [0x4d13] = 0x7f2c,
  [0x4d14] = 0x7f2d, [0x4d15] = 0x7f2f, [0x4d16] = 0x7f30, [0x4d17] = 0x7f31,
  [0x4d18] = 0x7f32, [0x4d19] = 0x7f33, [0x4d1a] = 0x7f35, [0x4d1b] = 0x5e7a,
  [0x4d1c] = 0x757f, [0x4d1d] = 0x5ddb, [0x4d1e] = 0x753e, [0x4d1f] = 0x9095,
  [0x4d20] = 0x738e, [0x4d21] = 0x7391, [0x4d22] = 0x73ae, [0x4d23] = 0x73a2,
  [0x4d24] = 0x739f, [0x4d25] = 0x73cf, [0x4d26] = 0x73c2, [0x4d27] = 0x73d1,
  [0x4d28] = 0x73b7, [0x4d29] = 0x73b3, [0x4d2a] = 0x73c0, [0x4d2b] = 0x73c9,
  [0x4d2c] = 0x73c8, [0x4d2d] = 0x73e5, [0x4d2e] = 0x73d9, [0x4d2f] = 0x987c,
  [0x4d30] = 0x740a, [0x4d31] = 0x73e9, [0x4d32] = 0x73e7, [0x4d33] = 0x73de,
  [0x4d34] = 0x73ba, [0x4d35] = 0x73f2, [0x4d36] = 0x740f, [0x4d37] = 0x742a,
  [0x4d38] = 0x745b, [0x4d39] = 0x7426, [0x4d3a] = 0x7425, [0x4d3b] = 0x7428,
  [0x4d3c] = 0x7430, [0x4d3d] = 0x742e, [0x4d3e] = 0x742c, [0x4d40] = 0x942f,
  [0x4d41] = 0x9430, [0x4d42] = 0x9431, [0x4d43] = 0x9432, [0x4d44] = 0x9433,
  [0x4d45] = 0x9434, [0x4d46] = 0x9435, [0x4d47] = 0x9436, [0x4d48] = 0x9437,
  [0x4d49] = 0x9438, [0x4d4a] = 0x9439, [0x4d4b] = 0x943a, [0x4d4c] = 0x943b,
  [0x4d4d] = 0x943c, [0x4d4e] = 0x943d, [0x4d4f] = 0x943f, [0x4d50] = 0x9440,
  [0x4d51] = 0x9441, [0x4d52] = 0x9442, [0x4d53] = 0x9443, [0x4d54] = 0x9444,
  [0x4d55] = 0x9445, [0x4d56] = 0x9446, [0x4d57] = 0x9447, [0x4d58] = 0x9448,
  [0x4d59] = 0x9449, [0x4d5a] = 0x944a, [0x4d5b] = 0x944b, [0x4d5c] = 0x944c,
  [0x4d5d] = 0x944d, [0x4d5e] = 0x944e, [0x4d5f] = 0x944f, [0x4d60] = 0x9450,
  [0x4d61] = 0x9451, [0x4d62] = 0x9452, [0x4d63] = 0x9453, [0x4d64] = 0x9454,
  [0x4d65] = 0x9455, [0x4d66] = 0x9456, [0x4d67] = 0x9457, [0x4d68] = 0x9458,
  [0x4d69] = 0x9459, [0x4d6a] = 0x945a, [0x4d6b] = 0x945b, [0x4d6c] = 0x945c,
  [0x4d6d] = 0x945d, [0x4d6e] = 0x945e, [0x4d6f] = 0x945f, [0x4d70] = 0x9460,
  [0x4d71] = 0x9461, [0x4d72] = 0x9462, [0x4d73] = 0x9463, [0x4d74] = 0x9464,
  [0x4d75] = 0x9465, [0x4d76] = 0x9466, [0x4d77] = 0x9467, [0x4d78] = 0x9468,
  [0x4d79] = 0x9469, [0x4d7a] = 0x946a, [0x4d7b] = 0x946c, [0x4d7c] = 0x946d,
  [0x4d7d] = 0x946e, [0x4d7e] = 0x946f, [0x4d80] = 0x9470, [0x4d81] = 0x9471,
  [0x4d82] = 0x9472, [0x4d83] = 0x9473, [0x4d84] = 0x9474, [0x4d85] = 0x9475,
  [0x4d86] = 0x9476, [0x4d87] = 0x9477, [0x4d88] = 0x9478, [0x4d89] = 0x9479,
  [0x4d8a] = 0x947a, [0x4d8b] = 0x947b, [0x4d8c] = 0x947c, [0x4d8d] = 0x947d,
  [0x4d8e] = 0x947e, [0x4d8f] = 0x947f, [0x4d90] = 0x9480, [0x4d91] = 0x9481,
  [0x4d92] = 0x9482, [0x4d93] = 0x9483, [0x4d94] = 0x9484, [0x4d95] = 0x9491,
  [0x4d96] = 0x9496, [0x4d97] = 0x9498, [0x4d98] = 0x94c7, [0x4d99] = 0x94cf,
  [0x4d9a] = 0x94d3, [0x4d9b] = 0x94d4, [0x4d9c] = 0x94da, [0x4d9d] = 0x94e6,
  [0x4d9e] = 0x94fb, [0x4d9f] = 0x951c, [0x4da0] = 0x9520, [0x4da1] = 0x741b,
  [0x4da2] = 0x741a, [0x4da3] = 0x7441, [0x4da4] = 0x745c, [0x4da5] = 0x7457,
  [0x4da6] = 0x7455, [0x4da7] = 0x7459, [0x4da8] = 0x7477, [0x4da9] = 0x746d,
  [0x4daa] = 0x747e, [0x4dab] = 0x749c, [0x4dac] = 0x748e, [0x4dad] = 0x7480,
  [0x4dae] = 0x7481, [0x4daf] = 0x7487, [0x4db0] = 0x748b, [0x4db1] = 0x749e,
  [0x4db2] = 0x74a8, [0x4db3] = 0x74a9, [0x4db4] = 0x7490, [0x4db5] = 0x74a7,
  [0x4db6] = 0x74d2, [0x4db7] = 0x74ba, [0x4db8] = 0x97ea, [0x4db9] = 0x97eb,
  [0x4dba] = 0x97ec, [0x4dbb] = 0x674c, [0x4dbc] = 0x6753, [0x4dbd] = 0x675e,
  [0x4dbe] = 0x6748, [0x4dbf] = 0x6769, [0x4dc0] = 0x67a5, [0x4dc1] = 0x6787,
  [0x4dc2] = 0x676a, [0x4dc3] = 0x6773, [0x4dc4] = 0x6798, [0x4dc5] = 0x67a7,
  [0x4dc6] = 0x6775, [0x4dc7] = 0x67a8, [0x4dc8] = 0x679e, [0x4dc9] = 0x67ad,
  [0x4dca] = 0x678b, [0x4dcb] = 0x6777, [0x4dcc] = 0x677c, [0x4dcd] = 0x67f0,
  [0x4dce] = 0x6809, [0x4dcf] = 0x67d8, [0x4dd0] = 0x680a, [0x4dd1] = 0x67e9,
  [0x4dd2] = 0x67b0, [0x4dd3] = 0x680c, [0x4dd4] = 0x67d9, [0x4dd5] = 0x67b5,
  [0x4dd6] = 0x67da, [0x4dd7] = 0x67b3, [0x4dd8] = 0x67dd, [0x4dd9] = 0x6800,
  [0x4dda] = 0x67c3, [0x4ddb] = 0x67b8, [0x4ddc] = 0x67e2, [0x4ddd] = 0x680e,
  [0x4dde] = 0x67c1, [0x4ddf] = 0x67fd, [0x4de0] = 0x6832, [0x4de1] = 0x6833,
  [0x4de2] = 0x6860, [0x4de3] = 0x6861, [0x4de4] = 0x684e, [0x4de5] = 0x6862,
  [0x4de6] = 0x6844, [0x4de7] = 0x6864, [0x4de8] = 0x6883, [0x4de9] = 0x681d,
  [0x4dea] = 0x6855, [0x4deb] = 0x6866, [0x4dec] = 0x6841, [0x4ded] = 0x6867,
  [0x4dee] = 0x6840, [0x4def] = 0x683e, [0x4df0] = 0x684a, [0x4df1] = 0x6849,
  [0x4df2] = 0x6829, [0x4df3] = 0x68b5, [0x4df4] = 0x688f, [0x4df5] = 0x6874,
  [0x4df6] = 0x6877, [0x4df7] = 0x6893, [0x4df8] = 0x686b, [0x4df9] = 0x68c2,
  [0x4dfa] = 0x696e, [0x4dfb] = 0x68fc, [0x4dfc] = 0x691f, [0x4dfd] = 0x6920,
  [0x4dfe] = 0x68f9, [0x4e00] = 0x9527, [0x4e01] = 0x9533, [0x4e02] = 0x953d,
  [0x4e03] = 0x9543, [0x4e04] = 0x9548, [0x4e05] = 0x954b, [0x4e06] = 0x9555,
  [0x4e07] = 0x955a, [0x4e08] = 0x9560, [0x4e09] = 0x956e, [0x4e0a] = 0x9574,
  [0x4e0b] = 0x9575, [0x4e0c] = 0x9577, [0x4e0d] = 0x9578, [0x4e0e] = 0x9579,
  [0x4e0f] = 0x957a, [0x4e10] = 0x957b, [0x4e11] = 0x957c, [0x4e12] = 0x957d,
  [0x4e13] = 0x957e, [0x4e14] = 0x9580, [0x4e15] = 0x9581, [0x4e16] = 0x9582,
  [0x4e17] = 0x9583, [0x4e18] = 0x9584, [0x4e19] = 0x9585, [0x4e1a] = 0x9586,
  [0x4e1b] = 0x9587, [0x4e1c] = 0x9588, [0x4e1d] = 0x9589, [0x4e1e] = 0x958a,
  [0x4e1f] = 0x958b, [0x4e20] = 0x958c, [0x4e21] = 0x958d, [0x4e22] = 0x958e,
  [0x4e23] = 0x958f, [0x4e24] = 0x9590, [0x4e25] = 0x9591, [0x4e26] = 0x9592,
  [0x4e27] = 0x9593, [0x4e28] = 0x9594, [0x4e29] = 0x9595, [0x4e2a] = 0x9596,
  [0x4e2b] = 0x9597, [0x4e2c] = 0x9598, [0x4e2d] = 0x9599, [0x4e2e] = 0x959a,
  [0x4e2f] = 0x959b, [0x4e30] = 0x959c, [0x4e31] = 0x959d, [0x4e32] = 0x959e,
  [0x4e33] = 0x959f, [0x4e34] = 0x95a0, [0x4e35] = 0x95a1, [0x4e36] = 0x95a2,
  [0x4e37] = 0x95a3, [0x4e38] = 0x95a4, [0x4e39] = 0x95a5, [0x4e3a] = 0x95a6,
  [0x4e3b] = 0x95a7, [0x4e3c] = 0x95a8, [0x4e3d] = 0x95a9, [0x4e3e] = 0x95aa,
  [0x4e40] = 0x95ab, [0x4e41] = 0x95ac, [0x4e42] = 0x95ad, [0x4e43] = 0x95ae,
  [0x4e44] = 0x95af, [0x4e45] = 0x95b0, [0x4e46] = 0x95b1, [0x4e47] = 0x95b2,
  [0x4e48] = 0x95b3, [0x4e49] = 0x95b4, [0x4e4a] = 0x95b5, [0x4e4b] = 0x95b6,
  [0x4e4c] = 0x95b7, [0x4e4d] = 0x95b8, [0x4e4e] = 0x95b9, [0x4e4f] = 0x95ba,
  [0x4e50] = 0x95bb, [0x4e51] = 0x95bc, [0x4e52] = 0x95bd, [0x4e53] = 0x95be,
  [0x4e54] = 0x95bf, [0x4e55] = 0x95c0, [0x4e56] = 0x95c1, [0x4e57] = 0x95c2,
  [0x4e58] = 0x95c3, [0x4e59] = 0x95c4, [0x4e5a] = 0x95c5, [0x4e5b] = 0x95c6,
  [0x4e5c] = 0x95c7, [0x4e5d] = 0x95c8, [0x4e5e] = 0x95c9, [0x4e5f] = 0x95ca,
  [0x4e60] = 0x95cb, [0x4e61] = 0x6924, [0x4e62] = 0x68f0, [0x4e63] = 0x690b,
  [0x4e64] = 0x6901, [0x4e65] = 0x6957, [0x4e66] = 0x68e3, [0x4e67] = 0x6910,
  [0x4e68] = 0x6971, [0x4e69] = 0x6939, [0x4e6a] = 0x6960, [0x4e6b] = 0x6942,
  [0x4e6c] = 0x695d, [0x4e6d] = 0x6984, [0x4e6e] = 0x696b, [0x4e6f] = 0x6980,
  [0x4e70] = 0x6998, [0x4e71] = 0x6978, [0x4e72] = 0x6934, [0x4e73] = 0x69cc,
  [0x4e74] = 0x6987, [0x4e75] = 0x6988, [0x4e76] = 0x69ce, [0x4e77] = 0x6989,
  [0x4e78] = 0x6966, [0x4e79] = 0x6963, [0x4e7a] = 0x6979, [0x4e7b] = 0x699b,
  [0x4e7c] = 0x69a7, [0x4e7d] = 0x69bb, [0x4e7e] = 0x69ab, [0x4e7f] = 0x69ad,
  [0x4e80] = 0x69d4, [0x4e81] = 0x69b1, [0x4e82] = 0x69c1, [0x4e83] = 0x69ca,
  [0x4e84] = 0x69df, [0x4e85] = 0x6995, [0x4e86] = 0x69e0, [0x4e87] = 0x698d,
  [0x4e88] = 0x69ff, [0x4e89] = 0x6a2f, [0x4e8a] = 0x69ed, [0x4e8b] = 0x6a17,
  [0x4e8c] = 0x6a18, [0x4e8d] = 0x6a65, [0x4e8e] = 0x69f2, [0x4e8f] = 0x6a44,
  [0x4e90] = 0x6a3e, [0x4e91] = 0x6aa0, [0x4e92] = 0x6a50, [0x4e93] = 0x6a5b,
  [0x4e94] = 0x6a35, [0x4e95] = 0x6a8e, [0x4e96] = 0x6a79, [0x4e97] = 0x6a3d,
  [0x4e98] = 0x6a28, [0x4e99] = 0x6a58, [0x4e9a] = 0x6a7c, [0x4e9b] = 0x6a91,
  [0x4e9c] = 0x6a90, [0x4e9d] = 0x6aa9, [0x4e9e] = 0x6a97, [0x4e9f] = 0x6aab,
  [0x4ea0] = 0x7337, [0x4ea1] = 0x7352, [0x4ea2] = 0x6b81, [0x4ea3] = 0x6b82,
  [0x4ea4] = 0x6b87, [0x4ea5] = 0x6b84, [0x4ea6] = 0x6b92, [0x4ea7] = 0x6b93,
  [0x4ea8] = 0x6b8d, [0x4ea9] = 0x6b9a, [0x4eaa] = 0x6b9b, [0x4eab] = 0x6ba1,
  [0x4eac] = 0x6baa, [0x4ead] = 0x8f6b, [0x4eae] = 0x8f6d, [0x4eaf] = 0x8f71,
  [0x4eb0] = 0x8f72, [0x4eb1] = 0x8f73, [0x4eb2] = 0x8f75, [0x4eb3] = 0x8f76,
  [0x4eb4] = 0x8f78, [0x4eb5] = 0x8f77, [0x4eb6] = 0x8f79, [0x4eb7] = 0x8f7a,
  [0x4eb8] = 0x8f7c, [0x4eb9] = 0x8f7e, [0x4eba] = 0x8f81, [0x4ebb] = 0x8f82,
  [0x4ebc] = 0x8f84, [0x4ebd] = 0x8f87, [0x4ebe] = 0x8f8b, [0x4ec0] = 0x95cc,
  [0x4ec1] = 0x95cd, [0x4ec2] = 0x95ce, [0x4ec3] = 0x95cf, [0x4ec4] = 0x95d0,
  [0x4ec5] = 0x95d1, [0x4ec6] = 0x95d2, [0x4ec7] = 0x95d3, [0x4ec8] = 0x95d4,
  [0x4ec9] = 0x95d5, [0x4eca] = 0x95d6, [0x4ecb] = 0x95d7, [0x4ecc] = 0x95d8,
  [0x4ecd] = 0x95d9, [0x4ece] = 0x95da, [0x4ecf] = 0x95db, [0x4ed0] = 0x95dc,
  [0x4ed1] = 0x95dd, [0x4ed2] = 0x95de, [0x4ed3] = 0x95df, [0x4ed4] = 0x95e0,
  [0x4ed5] = 0x95e1, [0x4ed6] = 0x95e2, [0x4ed7] = 0x95e3, [0x4ed8] = 0x95e4,
  [0x4ed9] = 0x95e5, [0x4eda] = 0x95e6, [0x4edb] = 0x95e7, [0x4edc] = 0x95ec,
  [0x4edd] = 0x95ff, [0x4ede] = 0x9607, [0x4edf] = 0x9613, [0x4ee0] = 0x9618,
  [0x4ee1] = 0x961b, [0x4ee2] = 0x961e, [0x4ee3] = 0x9620, [0x4ee4] = 0x9623,
  [0x4ee5] = 0x9624, [0x4ee6] = 0x9625, [0x4ee7] = 0x9626, [0x4ee8] = 0x9627,
  [0x4ee9] = 0x9628, [0x4eea] = 0x9629, [0x4eeb] = 0x962b, [0x4eec] = 0x962c,
  [0x4eed] = 0x962d, [0x4eee] = 0x962f, [0x4eef] = 0x9630, [0x4ef0] = 0x9637,
  [0x4ef1] = 0x9638, [0x4ef2] = 0x9639, [0x4ef3] = 0x963a, [0x4ef4] = 0x963e,
  [0x4ef5] = 0x9641, [0x4ef6] = 0x9643, [0x4ef7] = 0x964a, [0x4ef8] = 0x964e,
  [0x4ef9] = 0x964f, [0x4efa] = 0x9651, [0x4efb] = 0x9652, [0x4efc] = 0x9653,
  [0x4efd] = 0x9656, [0x4efe] = 0x9657, [0x4f00] = 0x9658, [0x4f01] = 0x9659,
  [0x4f02] = 0x965a, [0x4f03] = 0x965c, [0x4f04] = 0x965d, [0x4f05] = 0x965e,
  [0x4f06] = 0x9660, [0x4f07] = 0x9663, [0x4f08] = 0x9665, [0x4f09] = 0x9666,
  [0x4f0a] = 0x966b, [0x4f0b] = 0x966d, [0x4f0c] = 0x966e, [0x4f0d] = 0x966f,
  [0x4f0e] = 0x9670, [0x4f0f] = 0x9671, [0x4f10] = 0x9673, [0x4f11] = 0x9678,
  [0x4f12] = 0x9679, [0x4f13] = 0x967a, [0x4f14] = 0x967b, [0x4f15] = 0x967c,
  [0x4f16] = 0x967d, [0x4f17] = 0x967e, [0x4f18] = 0x967f, [0x4f19] = 0x9680,
  [0x4f1a] = 0x9681, [0x4f1b] = 0x9682, [0x4f1c] = 0x9683, [0x4f1d] = 0x9684,
  [0x4f1e] = 0x9687, [0x4f1f] = 0x9689, [0x4f20] = 0x968a, [0x4f21] = 0x8f8d,
  [0x4f22] = 0x8f8e, [0x4f23] = 0x8f8f, [0x4f24] = 0x8f98, [0x4f25] = 0x8f9a,
  [0x4f26] = 0x8ece, [0x4f27] = 0x620b, [0x4f28] = 0x6217, [0x4f29] = 0x621b,
  [0x4f2a] = 0x621f, [0x4f2b] = 0x6222, [0x4f2c] = 0x6221, [0x4f2d] = 0x6225,
  [0x4f2e] = 0x6224, [0x4f2f] = 0x622c, [0x4f30] = 0x81e7, [0x4f31] = 0x74ef,
  [0x4f32] = 0x74f4, [0x4f33] = 0x74ff, [0x4f34] = 0x750f, [0x4f35] = 0x7511,
  [0x4f36] = 0x7513, [0x4f37] = 0x6534, [0x4f38] = 0x65ee, [0x4f39] = 0x65ef,
  [0x4f3a] = 0x65f0, [0x4f3b] = 0x660a, [0x4f3c] = 0x6619, [0x4f3d] = 0x6772,
  [0x4f3e] = 0x6603, [0x4f3f] = 0x6615, [0x4f40] = 0x6600, [0x4f41] = 0x7085,
  [0x4f42] = 0x66f7, [0x4f43] = 0x661d, [0x4f44] = 0x6634, [0x4f45] = 0x6631,
  [0x4f46] = 0x6636, [0x4f47] = 0x6635, [0x4f48] = 0x8006, [0x4f49] = 0x665f,
  [0x4f4a] = 0x6654, [0x4f4b] = 0x6641, [0x4f4c] = 0x664f, [0x4f4d] = 0x6656,
  [0x4f4e] = 0x6661, [0x4f4f] = 0x6657, [0x4f50] = 0x6677, [0x4f51] = 0x6684,
  [0x4f52] = 0x668c, [0x4f53] = 0x66a7, [0x4f54] = 0x669d, [0x4f55] = 0x66be,
  [0x4f56] = 0x66db, [0x4f57] = 0x66dc, [0x4f58] = 0x66e6, [0x4f59] = 0x66e9,
  [0x4f5a] = 0x8d32, [0x4f5b] = 0x8d33, [0x4f5c] = 0x8d36, [0x4f5d] = 0x8d3b,
  [0x4f5e] = 0x8d3d, [0x4f5f] = 0x8d40, [0x4f60] = 0x8d45, [0x4f61] = 0x8d46,
  [0x4f62] = 0x8d48, [0x4f63] = 0x8d49, [0x4f64] = 0x8d47, [0x4f65] = 0x8d4d,
  [0x4f66] = 0x8d55, [0x4f67] = 0x8d59, [0x4f68] = 0x89c7, [0x4f69] = 0x89ca,
  [0x4f6a] = 0x89cb, [0x4f6b] = 0x89cc, [0x4f6c] = 0x89ce, [0x4f6d] = 0x89cf,
  [0x4f6e] = 0x89d0, [0x4f6f] = 0x89d1, [0x4f70] = 0x726e, [0x4f71] = 0x729f,
  [0x4f72] = 0x725d, [0x4f73] = 0x7266, [0x4f74] = 0x726f, [0x4f75] = 0x727e,
  [0x4f76] = 0x727f, [0x4f77] = 0x7284, [0x4f78] = 0x728b, [0x4f79] = 0x728d,
  [0x4f7a] = 0x728f, [0x4f7b] = 0x7292, [0x4f7c] = 0x6308, [0x4f7d] = 0x6332,
  [0x4f7e] = 0x63b0, [0x4f80] = 0x968c, [0x4f81] = 0x968e, [0x4f82] = 0x9691,
  [0x4f83] = 0x9692, [0x4f84] = 0x9693, [0x4f85] = 0x9695, [0x4f86] = 0x9696,
  [0x4f87] = 0x969a, [0x4f88] = 0x969b, [0x4f89] = 0x969d, [0x4f8a] = 0x969e,
  [0x4f8b] = 0x969f, [0x4f8c] = 0x96a0, [0x4f8d] = 0x96a1, [0x4f8e] = 0x96a2,
  [0x4f8f] = 0x96a3, [0x4f90] = 0x96a4, [0x4f91] = 0x96a5, [0x4f92] = 0x96a6,
  [0x4f93] = 0x96a8, [0x4f94] = 0x96a9, [0x4f95] = 0x96aa, [0x4f96] = 0x96ab,
  [0x4f97] = 0x96ac, [0x4f98] = 0x96ad, [0x4f99] = 0x96ae, [0x4f9a] = 0x96af,
  [0x4f9b] = 0x96b1, [0x4f9c] = 0x96b2, [0x4f9d] = 0x96b4, [0x4f9e] = 0x96b5,
  [0x4f9f] = 0x96b7, [0x4fa0] = 0x96b8, [0x4fa1] = 0x96ba, [0x4fa2] = 0x96bb,
  [0x4fa3] = 0x96bf, [0x4fa4] = 0x96c2, [0x4fa5] = 0x96c3, [0x4fa6] = 0x96c8,
  [0x4fa7] = 0x96ca, [0x4fa8] = 0x96cb, [0x4fa9] = 0x96d0, [0x4faa] = 0x96d1,
  [0x4fab] = 0x96d3, [0x4fac] = 0x96d4, [0x4fad] = 0x96d6, [0x4fae] = 0x96d7,
  [0x4faf] = 0x96d8, [0x4fb0] = 0x96d9, [0x4fb1] = 0x96da, [0x4fb2] = 0x96db,
  [0x4fb3] = 0x96dc, [0x4fb4] = 0x96dd, [0x4fb5] = 0x96de, [0x4fb6] = 0x96df,
  [0x4fb7] = 0x96e1, [0x4fb8] = 0x96e2, [0x4fb9] = 0x96e3, [0x4fba] = 0x96e4,
  [0x4fbb] = 0x96e5, [0x4fbc] = 0x96e6, [0x4fbd] = 0x96e7, [0x4fbe] = 0x96eb,
  [0x4fc0] = 0x96ec, [0x4fc1] = 0x96ed, [0x4fc2] = 0x96ee, [0x4fc3] = 0x96f0,
  [0x4fc4] = 0x96f1, [0x4fc5] = 0x96f2, [0x4fc6] = 0x96f4, [0x4fc7] = 0x96f5,
  [0x4fc8] = 0x96f8, [0x4fc9] = 0x96fa, [0x4fca] = 0x96fb, [0x4fcb] = 0x96fc,
  [0x4fcc] = 0x96fd, [0x4fcd] = 0x96ff, [0x4fce] = 0x9702, [0x4fcf] = 0x9703,
  [0x4fd0] = 0x9705, [0x4fd1] = 0x970a, [0x4fd2] = 0x970b, [0x4fd3] = 0x970c,
  [0x4fd4] = 0x9710, [0x4fd5] = 0x9711, [0x4fd6] = 0x9712, [0x4fd7] = 0x9714,
  [0x4fd8] = 0x9715, [0x4fd9] = 0x9717, [0x4fda] = 0x9718, [0x4fdb] = 0x9719,
  [0x4fdc] = 0x971a, [0x4fdd] = 0x971b, [0x4fde] = 0x971d, [0x4fdf] = 0x971f,
  [0x4fe0] = 0x9720, [0x4fe1] = 0x643f, [0x4fe2] = 0x64d8, [0x4fe3] = 0x8004,
  [0x4fe4] = 0x6bea, [0x4fe5] = 0x6bf3, [0x4fe6] = 0x6bfd, [0x4fe7] = 0x6bf5,
  [0x4fe8] = 0x6bf9, [0x4fe9] = 0x6c05, [0x4fea] = 0x6c07, [0x4feb] = 0x6c06,
  [0x4fec] = 0x6c0d, [0x4fed] = 0x6c15, [0x4fee] = 0x6c18, [0x4fef] = 0x6c19,
  [0x4ff0] = 0x6c1a, [0x4ff1] = 0x6c21, [0x4ff2] = 0x6c29, [0x4ff3] = 0x6c24,
  [0x4ff4] = 0x6c2a, [0x4ff5] = 0x6c32, [0x4ff6] = 0x6535, [0x4ff7] = 0x6555,
  [0x4ff8] = 0x656b, [0x4ff9] = 0x724d, [0x4ffa] = 0x7252, [0x4ffb] = 0x7256,
  [0x4ffc] = 0x7230, [0x4ffd] = 0x8662, [0x4ffe] = 0x5216, [0x4fff] = 0x809f,
  [0x5000] = 0x809c, [0x5001] = 0x8093, [0x5002] = 0x80bc, [0x5003] = 0x670a,
  [0x5004] = 0x80bd, [0x5005] = 0x80b1, [0x5006] = 0x80ab, [0x5007] = 0x80ad,
  [0x5008] = 0x80b4, [0x5009] = 0x80b7, [0x500a] = 0x80e7, [0x500b] = 0x80e8,
  [0x500c] = 0x80e9, [0x500d] = 0x80ea, [0x500e] = 0x80db, [0x500f] = 0x80c2,
  [0x5010] = 0x80c4, [0x5011] = 0x80d9, [0x5012] = 0x80cd, [0x5013] = 0x80d7,
  [0x5014] = 0x6710, [0x5015] = 0x80dd, [0x5016] = 0x80eb, [0x5017] = 0x80f1,
  [0x5018] = 0x80f4, [0x5019] = 0x80ed, [0x501a] = 0x810d, [0x501b] = 0x810e,
  [0x501c] = 0x80f2, [0x501d] = 0x80fc, [0x501e] = 0x6715, [0x501f] = 0x8112,
  [0x5020] = 0x8c5a, [0x5021] = 0x8136, [0x5022] = 0x811e, [0x5023] = 0x812c,
  [0x5024] = 0x8118, [0x5025] = 0x8132, [0x5026] = 0x8148, [0x5027] = 0x814c,
  [0x5028] = 0x8153, [0x5029] = 0x8174, [0x502a] = 0x8159, [0x502b] = 0x815a,
  [0x502c] = 0x8171, [0x502d] = 0x8160, [0x502e] = 0x8169, [0x502f] = 0x817c,
  [0x5030] = 0x817d, [0x5031] = 0x816d, [0x5032] = 0x8167, [0x5033] = 0x584d,
  [0x5034] = 0x5ab5, [0x5035] = 0x8188, [0x5036] = 0x8182, [0x5037] = 0x8191,
  [0x5038] = 0x6ed5, [0x5039] = 0x81a3, [0x503a] = 0x81aa, [0x503b] = 0x81cc,
  [0x503c] = 0x6726, [0x503d] = 0x81ca, [0x503e] = 0x81bb, [0x5040] = 0x9721,
  [0x5041] = 0x9722, [0x5042] = 0x9723, [0x5043] = 0x9724, [0x5044] = 0x9725,
  [0x5045] = 0x9726, [0x5046] = 0x9727, [0x5047] = 0x9728, [0x5048] = 0x9729,
  [0x5049] = 0x972b, [0x504a] = 0x972c, [0x504b] = 0x972e, [0x504c] = 0x972f,
  [0x504d] = 0x9731, [0x504e] = 0x9733, [0x504f] = 0x9734, [0x5050] = 0x9735,
  [0x5051] = 0x9736, [0x5052] = 0x9737, [0x5053] = 0x973a, [0x5054] = 0x973b,
  [0x5055] = 0x973c, [0x5056] = 0x973d, [0x5057] = 0x973f, [0x5058] = 0x9740,
  [0x5059] = 0x9741, [0x505a] = 0x9742, [0x505b] = 0x9743, [0x505c] = 0x9744,
  [0x505d] = 0x9745, [0x505e] = 0x9746, [0x505f] = 0x9747, [0x5060] = 0x9748,
  [0x5061] = 0x9749, [0x5062] = 0x974a, [0x5063] = 0x974b, [0x5064] = 0x974c,
  [0x5065] = 0x974d, [0x5066] = 0x974e, [0x5067] = 0x974f, [0x5068] = 0x9750,
  [0x5069] = 0x9751, [0x506a] = 0x9754, [0x506b] = 0x9755, [0x506c] = 0x9757,
  [0x506d] = 0x9758, [0x506e] = 0x975a, [0x506f] = 0x975c, [0x5070] = 0x975d,
  [0x5071] = 0x975f, [0x5072] = 0x9763, [0x5073] = 0x9764, [0x5074] = 0x9766,
  [0x5075] = 0x9767, [0x5076] = 0x9768, [0x5077] = 0x976a, [0x5078] = 0x976b,
  [0x5079] = 0x976c, [0x507a] = 0x976d, [0x507b] = 0x976e, [0x507c] = 0x976f,
  [0x507d] = 0x9770, [0x507e] = 0x9771, [0x5080] = 0x9772, [0x5081] = 0x9775,
  [0x5082] = 0x9777, [0x5083] = 0x9778, [0x5084] = 0x9779, [0x5085] = 0x977a,
  [0x5086] = 0x977b, [0x5087] = 0x977d, [0x5088] = 0x977e, [0x5089] = 0x977f,
  [0x508a] = 0x9780, [0x508b] = 0x9781, [0x508c] = 0x9782, [0x508d] = 0x9783,
  [0x508e] = 0x9784, [0x508f] = 0x9786, [0x5090] = 0x9787, [0x5091] = 0x9788,
  [0x5092] = 0x9789, [0x5093] = 0x978a, [0x5094] = 0x978c, [0x5095] = 0x978e,
  [0x5096] = 0x978f, [0x5097] = 0x9790, [0x5098] = 0x9793, [0x5099] = 0x9795,
  [0x509a] = 0x9796, [0x509b] = 0x9797, [0x509c] = 0x9799, [0x509d] = 0x979a,
  [0x509e] = 0x979b, [0x509f] = 0x979c, [0x50a0] = 0x979d, [0x50a1] = 0x81c1,
  [0x50a2] = 0x81a6, [0x50a3] = 0x6b24, [0x50a4] = 0x6b37, [0x50a5] = 0x6b39,
  [0x50a6] = 0x6b43, [0x50a7] = 0x6b46, [0x50a8] = 0x6b59, [0x50a9] = 0x98d1,
  [0x50aa] = 0x98d2, [0x50ab] = 0x98d3, [0x50ac] = 0x98d5, [0x50ad] = 0x98d9,
  [0x50ae] = 0x98da, [0x50af] = 0x6bb3, [0x50b0] = 0x5f40, [0x50b1] = 0x6bc2,
  [0x50b2] = 0x89f3, [0x50b3] = 0x6590, [0x50b4] = 0x9f51, [0x50b5] = 0x6593,
  [0x50b6] = 0x65bc, [0x50b7] = 0x65c6, [0x50b8] = 0x65c4, [0x50b9] = 0x65c3,
  [0x50ba] = 0x65cc, [0x50bb] = 0x65ce, [0x50bc] = 0x65d2, [0x50bd] = 0x65d6,
  [0x50be] = 0x7080, [0x50bf] = 0x709c, [0x50c0] = 0x7096, [0x50c1] = 0x709d,
  [0x50c2] = 0x70bb, [0x50c3] = 0x70c0, [0x50c4] = 0x70b7, [0x50c5] = 0x70ab,
  [0x50c6] = 0x70b1, [0x50c7] = 0x70e8, [0x50c8] = 0x70ca, [0x50c9] = 0x7110,
  [0x50ca] = 0x7113, [0x50cb] = 0x7116, [0x50cc] = 0x712f, [0x50cd] = 0x7131,
  [0x50ce] = 0x7173, [0x50cf] = 0x715c, [0x50d0] = 0x7168, [0x50d1] = 0x7145,
  [0x50d2] = 0x7172, [0x50d3] = 0x714a, [0x50d4] = 0x7178, [0x50d5] = 0x717a,
  [0x50d6] = 0x7198, [0x50d7] = 0x71b3, [0x50d8] = 0x71b5, [0x50d9] = 0x71a8,
  [0x50da] = 0x71a0, [0x50db] = 0x71e0, [0x50dc] = 0x71d4, [0x50dd] = 0x71e7,
  [0x50de] = 0x71f9, [0x50df] = 0x721d, [0x50e0] = 0x7228, [0x50e1] = 0x706c,
  [0x50e2] = 0x7118, [0x50e3] = 0x7166, [0x50e4] = 0x71b9, [0x50e5] = 0x623e,
  [0x50e6] = 0x623d, [0x50e7] = 0x6243, [0x50e8] = 0x6248, [0x50e9] = 0x6249,
  [0x50ea] = 0x793b, [0x50eb] = 0x7940, [0x50ec] = 0x7946, [0x50ed] = 0x7949,
  [0x50ee] = 0x795b, [0x50ef] = 0x795c, [0x50f0] = 0x7953, [0x50f1] = 0x795a,
  [0x50f2] = 0x7962, [0x50f3] = 0x7957, [0x50f4] = 0x7960, [0x50f5] = 0x796f,
  [0x50f6] = 0x7967, [0x50f7] = 0x797a, [0x50f8] = 0x7985, [0x50f9] = 0x798a,
  [0x50fa] = 0x799a, [0x50fb] = 0x79a7, [0x50fc] = 0x79b3, [0x50fd] = 0x5fd1,
  [0x50fe] = 0x5fd0, [0x5100] = 0x979e, [0x5101] = 0x979f, [0x5102] = 0x97a1,
  [0x5103] = 0x97a2, [0x5104] = 0x97a4, [0x5105] = 0x97a5, [0x5106] = 0x97a6,
  [0x5107] = 0x97a7, [0x5108] = 0x97a8, [0x5109] = 0x97a9, [0x510a] = 0x97aa,
  [0x510b] = 0x97ac, [0x510c] = 0x97ae, [0x510d] = 0x97b0, [0x510e] = 0x97b1,
  [0x510f] = 0x97b3, [0x5110] = 0x97b5, [0x5111] = 0x97b6, [0x5112] = 0x97b7,
  [0x5113] = 0x97b8, [0x5114] = 0x97b9, [0x5115] = 0x97ba, [0x5116] = 0x97bb,
  [0x5117] = 0x97bc, [0x5118] = 0x97bd, [0x5119] = 0x97be, [0x511a] = 0x97bf,
  [0x511b] = 0x97c0, [0x511c] = 0x97c1, [0x511d] = 0x97c2, [0x511e] = 0x97c3,
  [0x511f] = 0x97c4, [0x5120] = 0x97c5, [0x5121] = 0x97c6, [0x5122] = 0x97c7,
  [0x5123] = 0x97c8, [0x5124] = 0x97c9, [0x5125] = 0x97ca, [0x5126] = 0x97cb,
  [0x5127] = 0x97cc, [0x5128] = 0x97cd, [0x5129] = 0x97ce, [0x512a] = 0x97cf,
  [0x512b] = 0x97d0, [0x512c] = 0x97d1, [0x512d] = 0x97d2, [0x512e] = 0x97d3,
  [0x512f] = 0x97d4, [0x5130] = 0x97d5, [0x5131] = 0x97d6, [0x5132] = 0x97d7,
  [0x5133] = 0x97d8, [0x5134] = 0x97d9, [0x5135] = 0x97da, [0x5136] = 0x97db,
  [0x5137] = 0x97dc, [0x5138] = 0x97dd, [0x5139] = 0x97de, [0x513a] = 0x97df,
  [0x513b] = 0x97e0, [0x513c] = 0x97e1, [0x513d] = 0x97e2, [0x513e] = 0x97e3,
  [0x5140] = 0x97e4, [0x5141] = 0x97e5, [0x5142] = 0x97e8, [0x5143] = 0x97ee,
  [0x5144] = 0x97ef, [0x5145] = 0x97f0, [0x5146] = 0x97f1, [0x5147] = 0x97f2,
  [0x5148] = 0x97f4, [0x5149] = 0x97f7, [0x514a] = 0x97f8, [0x514b] = 0x97f9,
  [0x514c] = 0x97fa, [0x514d] = 0x97fb, [0x514e] = 0x97fc, [0x514f] = 0x97fd,
  [0x5150] = 0x97fe, [0x5151] = 0x97ff, [0x5152] = 0x9800, [0x5153] = 0x9801,
  [0x5154] = 0x9802, [0x5155] = 0x9803, [0x5156] = 0x9804, [0x5157] = 0x9805,
  [0x5158] = 0x9806, [0x5159] = 0x9807, [0x515a] = 0x9808, [0x515b] = 0x9809,
  [0x515c] = 0x980a, [0x515d] = 0x980b, [0x515e] = 0x980c, [0x515f] = 0x980d,
  [0x5160] = 0x980e, [0x5161] = 0x603c, [0x5162] = 0x605d, [0x5163] = 0x605a,
  [0x5164] = 0x6067, [0x5165] = 0x6041, [0x5166] = 0x6059, [0x5167] = 0x6063,
  [0x5168] = 0x60ab, [0x5169] = 0x6106, [0x516a] = 0x610d, [0x516b] = 0x615d,
  [0x516c] = 0x61a9, [0x516d] = 0x619d, [0x516e] = 0x61cb, [0x516f] = 0x61d1,
  [0x5170] = 0x6206, [0x5171] = 0x8080, [0x5172] = 0x807f, [0x5173] = 0x6c93,
  [0x5174] = 0x6cf6, [0x5175] = 0x6dfc, [0x5176] = 0x77f6, [0x5177] = 0x77f8,
  [0x5178] = 0x7800, [0x5179] = 0x7809, [0x517a] = 0x7817, [0x517b] = 0x7818,
  [0x517c] = 0x7811, [0x517d] = 0x65ab, [0x517e] = 0x782d, [0x517f] = 0x781c,
  [0x5180] = 0x781d, [0x5181] = 0x7839, [0x5182] = 0x783a, [0x5183] = 0x783b,
  [0x5184] = 0x781f, [0x5185] = 0x783c, [0x5186] = 0x7825, [0x5187] = 0x782c,
  [0x5188] = 0x7823, [0x5189] = 0x7829, [0x518a] = 0x784e, [0x518b] = 0x786d,
  [0x518c] = 0x7856, [0x518d] = 0x7857, [0x518e] = 0x7826, [0x518f] = 0x7850,
  [0x5190] = 0x7847, [0x5191] = 0x784c, [0x5192] = 0x786a, [0x5193] = 0x789b,
  [0x5194] = 0x7893, [0x5195] = 0x789a, [0x5196] = 0x7887, [0x5197] = 0x789c,
  [0x5198] = 0x78a1, [0x5199] = 0x78a3, [0x519a] = 0x78b2, [0x519b] = 0x78b9,
  [0x519c] = 0x78a5, [0x519d] = 0x78d4, [0x519e] = 0x78d9, [0x519f] = 0x78c9,
  [0x51a0] = 0x78ec, [0x51a1] = 0x78f2, [0x51a2] = 0x7905, [0x51a3] = 0x78f4,
  [0x51a4] = 0x7913, [0x51a5] = 0x7924, [0x51a6] = 0x791e, [0x51a7] = 0x7934,
  [0x51a8] = 0x9f9b, [0x51a9] = 0x9ef9, [0x51aa] = 0x9efb, [0x51ab] = 0x9efc,
  [0x51ac] = 0x76f1, [0x51ad] = 0x7704, [0x51ae] = 0x770d, [0x51af] = 0x76f9,
  [0x51b0] = 0x7707, [0x51b1] = 0x7708, [0x51b2] = 0x771a, [0x51b3] = 0x7722,
  [0x51b4] = 0x7719, [0x51b5] = 0x772d, [0x51b6] = 0x7726, [0x51b7] = 0x7735,
  [0x51b8] = 0x7738, [0x51b9] = 0x7750, [0x51ba] = 0x7751, [0x51bb] = 0x7747,
  [0x51bc] = 0x7743, [0x51bd] = 0x775a, [0x51be] = 0x7768, [0x51c0] = 0x980f,
  [0x51c1] = 0x9810, [0x51c2] = 0x9811, [0x51c3] = 0x9812, [0x51c4] = 0x9813,
  [0x51c5] = 0x9814, [0x51c6] = 0x9815, [0x51c7] = 0x9816, [0x51c8] = 0x9817,
  [0x51c9] = 0x9818, [0x51ca] = 0x9819, [0x51cb] = 0x981a, [0x51cc] = 0x981b,
  [0x51cd] = 0x981c, [0x51ce] = 0x981d, [0x51cf] = 0x981e, [0x51d0] = 0x981f,
  [0x51d1] = 0x9820, [0x51d2] = 0x9821, [0x51d3] = 0x9822, [0x51d4] = 0x9823,
  [0x51d5] = 0x9824, [0x51d6] = 0x9825, [0x51d7] = 0x9826, [0x51d8] = 0x9827,
  [0x51d9] = 0x9828, [0x51da] = 0x9829, [0x51db] = 0x982a, [0x51dc] = 0x982b,
  [0x51dd] = 0x982c, [0x51de] = 0x982d, [0x51df] = 0x982e, [0x51e0] = 0x982f,
  [0x51e1] = 0x9830, [0x51e2] = 0x9831, [0x51e3] = 0x9832, [0x51e4] = 0x9833,
  [0x51e5] = 0x9834, [0x51e6] = 0x9835, [0x51e7] = 0x9836, [0x51e8] = 0x9837,
  [0x51e9] = 0x9838, [0x51ea] = 0x9839, [0x51eb] = 0x983a, [0x51ec] = 0x983b,
  [0x51ed] = 0x983c, [0x51ee] = 0x983d, [0x51ef] = 0x983e, [0x51f0] = 0x983f,
  [0x51f1] = 0x9840, [0x51f2] = 0x9841, [0x51f3] = 0x9842, [0x51f4] = 0x9843,
  [0x51f5] = 0x9844, [0x51f6] = 0x9845, [0x51f7] = 0x9846, [0x51f8] = 0x9847,
  [0x51f9] = 0x9848, [0x51fa] = 0x9849, [0x51fb] = 0x984a, [0x51fc] = 0x984b,
  [0x51fd] = 0x984c, [0x51fe] = 0x984d, [0x5200] = 0x984e, [0x5201] = 0x984f,
  [0x5202] = 0x9850, [0x5203] = 0x9851, [0x5204] = 0x9852, [0x5205] = 0x9853,
  [0x5206] = 0x9854, [0x5207] = 0x9855, [0x5208] = 0x9856, [0x5209] = 0x9857,
  [0x520a] = 0x9858, [0x520b] = 0x9859, [0x520c] = 0x985a, [0x520d] = 0x985b,
  [0x520e] = 0x985c, [0x520f] = 0x985d, [0x5210] = 0x985e, [0x5211] = 0x985f,
  [0x5212] = 0x9860, [0x5213] = 0x9861, [0x5214] = 0x9862, [0x5215] = 0x9863,
  [0x5216] = 0x9864, [0x5217] = 0x9865, [0x5218] = 0x9866, [0x5219] = 0x9867,
  [0x521a] = 0x9868, [0x521b] = 0x9869, [0x521c] = 0x986a, [0x521d] = 0x986b,
  [0x521e] = 0x986c, [0x521f] = 0x986d, [0x5220] = 0x986e, [0x5221] = 0x7762,
  [0x5222] = 0x7765, [0x5223] = 0x777f, [0x5224] = 0x778d, [0x5225] = 0x777d,
  [0x5226] = 0x7780, [0x5227] = 0x778c, [0x5228] = 0x7791, [0x5229] = 0x779f,
  [0x522a] = 0x77a0, [0x522b] = 0x77b0, [0x522c] = 0x77b5, [0x522d] = 0x77bd,
  [0x522e] = 0x753a, [0x522f] = 0x7540, [0x5230] = 0x754e, [0x5231] = 0x754b,
  [0x5232] = 0x7548, [0x5233] = 0x755b, [0x5234] = 0x7572, [0x5235] = 0x7579,
  [0x5236] = 0x7583, [0x5237] = 0x7f58, [0x5238] = 0x7f61, [0x5239] = 0x7f5f,
  [0x523a] = 0x8a48, [0x523b] = 0x7f68, [0x523c] = 0x7f74, [0x523d] = 0x7f71,
  [0x523e] = 0x7f79, [0x523f] = 0x7f81, [0x5240] = 0x7f7e, [0x5241] = 0x76cd,
  [0x5242] = 0x76e5, [0x5243] = 0x8832, [0x5244] = 0x9485, [0x5245] = 0x9486,
  [0x5246] = 0x9487, [0x5247] = 0x948b, [0x5248] = 0x948a, [0x5249] = 0x948c,
  [0x524a] = 0x948d, [0x524b] = 0x948f, [0x524c] = 0x9490, [0x524d] = 0x9494,
  [0x524e] = 0x9497, [0x524f] = 0x9495, [0x5250] = 0x949a, [0x5251] = 0x949b,
  [0x5252] = 0x949c, [0x5253] = 0x94a3, [0x5254] = 0x94a4, [0x5255] = 0x94ab,
  [0x5256] = 0x94aa, [0x5257] = 0x94ad, [0x5258] = 0x94ac, [0x5259] = 0x94af,
  [0x525a] = 0x94b0, [0x525b] = 0x94b2, [0x525c] = 0x94b4, [0x525d] = 0x94b6,
  [0x525e] = 0x94b7, [0x525f] = 0x94b8, [0x5260] = 0x94b9, [0x5261] = 0x94ba,
  [0x5262] = 0x94bc, [0x5263] = 0x94bd, [0x5264] = 0x94bf, [0x5265] = 0x94c4,
  [0x5266] = 0x94c8, [0x5267] = 0x94c9, [0x5268] = 0x94ca, [0x5269] = 0x94cb,
  [0x526a] = 0x94cc, [0x526b] = 0x94cd, [0x526c] = 0x94ce, [0x526d] = 0x94d0,
  [0x526e] = 0x94d1, [0x526f] = 0x94d2, [0x5270] = 0x94d5, [0x5271] = 0x94d6,
  [0x5272] = 0x94d7, [0x5273] = 0x94d9, [0x5274] = 0x94d8, [0x5275] = 0x94db,
  [0x5276] = 0x94de, [0x5277] = 0x94df, [0x5278] = 0x94e0, [0x5279] = 0x94e2,
  [0x527a] = 0x94e4, [0x527b] = 0x94e5, [0x527c] = 0x94e7, [0x527d] = 0x94e8,
  [0x527e] = 0x94ea, [0x5280] = 0x986f, [0x5281] = 0x9870, [0x5282] = 0x9871,
  [0x5283] = 0x9872, [0x5284] = 0x9873, [0x5285] = 0x9874, [0x5286] = 0x988b,
  [0x5287] = 0x988e, [0x5288] = 0x9892, [0x5289] = 0x9895, [0x528a] = 0x9899,
  [0x528b] = 0x98a3, [0x528c] = 0x98a8, [0x528d] = 0x98a9, [0x528e] = 0x98aa,
  [0x528f] = 0x98ab, [0x5290] = 0x98ac, [0x5291] = 0x98ad, [0x5292] = 0x98ae,
  [0x5293] = 0x98af, [0x5294] = 0x98b0, [0x5295] = 0x98b1, [0x5296] = 0x98b2,
  [0x5297] = 0x98b3, [0x5298] = 0x98b4, [0x5299] = 0x98b5, [0x529a] = 0x98b6,
  [0x529b] = 0x98b7, [0x529c] = 0x98b8, [0x529d] = 0x98b9, [0x529e] = 0x98ba,
  [0x529f] = 0x98bb, [0x52a0] = 0x98bc, [0x52a1] = 0x98bd, [0x52a2] = 0x98be,
  [0x52a3] = 0x98bf, [0x52a4] = 0x98c0, [0x52a5] = 0x98c1, [0x52a6] = 0x98c2,
  [0x52a7] = 0x98c3, [0x52a8] = 0x98c4, [0x52a9] = 0x98c5, [0x52aa] = 0x98c6,
  [0x52ab] = 0x98c7, [0x52ac] = 0x98c8, [0x52ad] = 0x98c9, [0x52ae] = 0x98ca,
  [0x52af] = 0x98cb, [0x52b0] = 0x98cc, [0x52b1] = 0x98cd, [0x52b2] = 0x98cf,
  [0x52b3] = 0x98d0, [0x52b4] = 0x98d4, [0x52b5] = 0x98d6, [0x52b6] = 0x98d7,
  [0x52b7] = 0x98db, [0x52b8] = 0x98dc, [0x52b9] = 0x98dd, [0x52ba] = 0x98e0,
  [0x52bb] = 0x98e1, [0x52bc] = 0x98e2, [0x52bd] = 0x98e3, [0x52be] = 0x98e4,
  [0x52c0] = 0x98e5, [0x52c1] = 0x98e6, [0x52c2] = 0x98e9, [0x52c3] = 0x98ea,
  [0x52c4] = 0x98eb, [0x52c5] = 0x98ec, [0x52c6] = 0x98ed, [0x52c7] = 0x98ee,
  [0x52c8] = 0x98ef, [0x52c9] = 0x98f0, [0x52ca] = 0x98f1, [0x52cb] = 0x98f2,
  [0x52cc] = 0x98f3, [0x52cd] = 0x98f4, [0x52ce] = 0x98f5, [0x52cf] = 0x98f6,
  [0x52d0] = 0x98f7, [0x52d1] = 0x98f8, [0x52d2] = 0x98f9, [0x52d3] = 0x98fa,
  [0x52d4] = 0x98fb, [0x52d5] = 0x98fc, [0x52d6] = 0x98fd, [0x52d7] = 0x98fe,
  [0x52d8] = 0x98ff, [0x52d9] = 0x9900, [0x52da] = 0x9901, [0x52db] = 0x9902,
  [0x52dc] = 0x9903, [0x52dd] = 0x9904, [0x52de] = 0x9905, [0x52df] = 0x9906,
  [0x52e0] = 0x9907, [0x52e1] = 0x94e9, [0x52e2] = 0x94eb, [0x52e3] = 0x94ee,
  [0x52e4] = 0x94ef, [0x52e5] = 0x94f3, [0x52e6] = 0x94f4, [0x52e7] = 0x94f5,
  [0x52e8] = 0x94f7, [0x52e9] = 0x94f9, [0x52ea] = 0x94fc, [0x52eb] = 0x94fd,
  [0x52ec] = 0x94ff, [0x52ed] = 0x9503, [0x52ee] = 0x9502, [0x52ef] = 0x9506,
  [0x52f0] = 0x9507, [0x52f1] = 0x9509, [0x52f2] = 0x950a, [0x52f3] = 0x950d,
  [0x52f4] = 0x950e, [0x52f5] = 0x950f, [0x52f6] = 0x9512, [0x52f7] = 0x9513,
  [0x52f8] = 0x9514, [0x52f9] = 0x9515, [0x52fa] = 0x9516, [0x52fb] = 0x9518,
  [0x52fc] = 0x951b, [0x52fd] = 0x951d, [0x52fe] = 0x951e, [0x52ff] = 0x951f,
  [0x5300] = 0x9522, [0x5301] = 0x952a, [0x5302] = 0x952b, [0x5303] = 0x9529,
  [0x5304] = 0x952c, [0x5305] = 0x9531, [0x5306] = 0x9532, [0x5307] = 0x9534,
  [0x5308] = 0x9536, [0x5309] = 0x9537, [0x530a] = 0x9538, [0x530b] = 0x953c,
  [0x530c] = 0x953e, [0x530d] = 0x953f, [0x530e] = 0x9542, [0x530f] = 0x9535,
  [0x5310] = 0x9544, [0x5311] = 0x9545, [0x5312] = 0x9546, [0x5313] = 0x9549,
  [0x5314] = 0x954c, [0x5315] = 0x954e, [0x5316] = 0x954f, [0x5317] = 0x9552,
  [0x5318] = 0x9553, [0x5319] = 0x9554, [0x531a] = 0x9556, [0x531b] = 0x9557,
  [0x531c] = 0x9558, [0x531d] = 0x9559, [0x531e] = 0x955b, [0x531f] = 0x955e,
  [0x5320] = 0x955f, [0x5321] = 0x955d, [0x5322] = 0x9561, [0x5323] = 0x9562,
  [0x5324] = 0x9564, [0x5325] = 0x9565, [0x5326] = 0x9566, [0x5327] = 0x9567,
  [0x5328] = 0x9568, [0x5329] = 0x9569, [0x532a] = 0x956a, [0x532b] = 0x956b,
  [0x532c] = 0x956c, [0x532d] = 0x956f, [0x532e] = 0x9571, [0x532f] = 0x9572,
  [0x5330] = 0x9573, [0x5331] = 0x953a, [0x5332] = 0x77e7, [0x5333] = 0x77ec,
  [0x5334] = 0x96c9, [0x5335] = 0x79d5, [0x5336] = 0x79ed, [0x5337] = 0x79e3,
  [0x5338] = 0x79eb, [0x5339] = 0x7a06, [0x533a] = 0x5d47, [0x533b] = 0x7a03,
  [0x533c] = 0x7a02, [