/* GNU mailutils - a suite of utilities for electronic mail
   Copyright (C) 1999, 2000, 2001 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Library Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/** mailutils' sieve implementation */

/*

Configuration:

  debug level

  print callback and callback pointer

  ticket_t

  "no actions" mode

Basic methods:

  create and configure context

  parse script

  sieve message

Extended methods:

  filter mailbox

  filter mailbox URL

  set ticket_t based on wicket file

*/

#include <errno.h>

#include <mailutils/debug.h>
#include <mailutils/mailer.h>
#include <mailutils/message.h>

/* Sieve specific intepretations of error numbers. */
#define SV_EPARSE ENOEXEC

extern const char* sv_strerror(int e);

typedef struct sv_interp_ctx_t* sv_interp_t;
typedef struct sv_script_ctx_t* sv_script_t;

typedef void (*sv_parse_error_t) (const char *script, int lineno,
				  const char *errmsg);

typedef void (*sv_execute_error_t) (const char *script, message_t msg, int rc,
				    const char *errmsg);

typedef void (*sv_action_log_t) (const char *script, message_t msg,
				 const char *action, const char *fmt,
				 va_list ap);

extern int sv_interp_alloc(sv_interp_t *i,
               sv_parse_error_t pe,
	       sv_execute_error_t ee,
	       sv_action_log_t al);

extern void sv_interp_free(sv_interp_t *i);

extern int sv_script_parse (sv_script_t * s, sv_interp_t i,
			    const char *script);

extern void sv_script_free(sv_script_t *s);

#define SV_FLAG_NO_ACTIONS 0x01

/* Sieve specific debug levels - can be set in the mu_debug_t. */
#define SV_DEBUG_TRACE      0x100
#define SV_DEBUG_HDR_FILL   0x200
#define SV_DEBUG_MSG_QUERY  0x400

extern int sv_script_execute (sv_script_t script, message_t message,
			      ticket_t ticket, mu_debug_t debug,
			      mailer_t mailer, int svflags);

