;;;; -*- scheme -*-
;;;; GNU mailutils - a suite of utilities for electronic mail
;;;; Copyright (C) 2002 Free Software Foundation, Inc.
;;;;
;;;; This program is free software; you can redistribute it and/or modify
;;;; it under the terms of the GNU General Public License as published by
;;;; the Free Software Foundation; either version 2, or (at your option)
;;;; any later version.
;;;; 
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License
;;;; along with this program; if not, write to the Free Software
;;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
;;;;

(define-module (mailutils))

(let ((lib-path "/usr/local/mailutils/lib/"))
  (cond
   ((or (string=? (version) "1.4")
	(string=? (version) "1.4.1"))
    (dynamic-link (string-append lib-path "libmailbox"))
    (dynamic-call "mu_scm_init"
		  (dynamic-link (string-append
				 lib-path
				 "libguile-mailutils-v-0.1.3"))))
   (else
    (load-extension "libguile-mailutils-v-0.1.3" "mu_scm_init"))))

(export mu-package)
(export mu-package-string)
(export mu-version)
(export mu-mailer)
(export mu-debug)
(export mu-path-maildir)
(export mu-path-folder-dir)

(export MU-ATTRIBUTE-ANSWERED)
(export MU-ATTRIBUTE-FLAGGED)
(export MU-ATTRIBUTE-DELETED)
(export MU-ATTRIBUTE-DRAFT)
(export MU-ATTRIBUTE-SEEN)
(export MU-ATTRIBUTE-READ)
(export MU-ATTRIBUTE-MODIFIED)
(export MU-ATTRIBUTE-RECENT)

(export LOG_USER)   
(export LOG_DAEMON)
(export LOG_AUTH)  
(export LOG_LOCAL0)
(export LOG_LOCAL1)
(export LOG_LOCAL2)
(export LOG_LOCAL3)
(export LOG_LOCAL4)
(export LOG_LOCAL5)
(export LOG_LOCAL6)
(export LOG_LOCAL7)
(export LOG_EMERG)    
(export LOG_ALERT)   
(export LOG_CRIT)    
(export LOG_ERR)     
(export LOG_WARNING) 
(export LOG_NOTICE)  
(export LOG_INFO)    
(export LOG_DEBUG)   
(export LOG_CONS)   
(export LOG_NDELAY) 
(export LOG_PID)

(export mu-address-get-personal)
(export mu-address-get-comments)
(export mu-address-get-email)
(export mu-address-get-domain)
(export mu-address-get-local)
(export mu-address-get-count)
(export mu-username->email)

(export mu-body-read-line)
(export mu-body-write)


(export mu-mailbox-open)
(export mu-mailbox-close)
(export mu-mailbox-get-url)
(export mu-mailbox-get-port)
(export mu-mailbox-get-message)
(export mu-mailbox-messages-count)
(export mu-mailbox-expunge)
(export mu-mailbox-url)
(export mu-mailbox-append-message)

(export mu-message-create)
(export mu-message-copy)
(export mu-message-destroy)
(export mu-message-set-header)
(export mu-message-get-size)
(export mu-message-get-lines)
(export mu-message-get-sender)
(export mu-message-get-header)
(export mu-message-get-header-fields)
(export mu-message-set-header-fields)
(export mu-message-delete)
(export mu-message-get-flag)
(export mu-message-set-flag)
(export mu-message-get-user-flag)
(export mu-message-set-user-flag)
(export mu-message-get-port)
(export mu-message-get-body)
(export mu-message-multipart?)
(export mu-message-get-num-parts)
(export mu-message-get-part)
(export mu-message-send)

(export mu-mime-create)
(export mu-mime-multipart?)
(export mu-mime-get-num-parts)
(export mu-mime-get-part)
(export mu-mime-add-part)
(export mu-mime-get-message)

(export mu-openlog)
(export mu-logger)
(export mu-closelog)


(export mu-register-format)

(export mu-getpwuid)



(export mu-address-get-personal)
(export mu-address-get-comments)
(export mu-address-get-email)
(export mu-address-get-domain)
(export mu-address-get-local)
(export mu-address-get-count)
(export mu-username->email)
(export mu-body-read-line)
(export mu-body-write)
(export mu-mailbox-open)
(export mu-mailbox-close)
(export mu-mailbox-get-url)
(export mu-mailbox-get-port)
(export mu-mailbox-get-message)
(export mu-mailbox-messages-count)
(export mu-mailbox-expunge)
(export mu-mailbox-url)
(export mu-mailbox-append-message)
(export mu-message-create)
(export mu-message-copy)
(export mu-message-destroy)
(export mu-message-set-header)
(export mu-message-get-size)
(export mu-message-get-lines)
(export mu-message-get-sender)
(export mu-message-get-header)
(export mu-message-get-header-fields)
(export mu-message-set-header-fields)
(export mu-message-delete)
(export mu-message-get-flag)
(export mu-message-set-flag)
(export mu-message-get-user-flag)
(export mu-message-set-user-flag)
(export mu-message-get-port)
(export mu-message-get-body)
(export mu-message-multipart?)
(export mu-message-get-num-parts)
(export mu-message-get-part)
(export mu-message-send)
(export mu-mime-create)
(export mu-mime-multipart?)
(export mu-mime-get-num-parts)
(export mu-mime-get-part)
(export mu-mime-add-part)
(export mu-mime-get-message)
(export mu-openlog)
(export mu-logger)
(export mu-closelog)
(export mu-register-format)
(export mu-getpwuid)
/* GNU mailutils - a suite of utilities for electronic mail
   Copyright (C) 1999, 2000, 2001 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#if defined(HAVE_CONFIG_H)
# include <config.h>
#endif
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/time.h>
#include <string.h>

#include <mailutils/mailbox.h>
#include <mailutils/message.h>
#include <mailutils/header.h>
#include <mailutils/body.h>
#include <mailutils/registrar.h>
#include <mailutils/error.h>
#include <mailutils/address.h>
#include <mailutils/registrar.h>
#include <mailutils/mutil.h>
#include <mailutils/stream.h>
#include <mailutils/debug.h>
#include <mailutils/attribute.h>
#include <mailutils/mailer.h>
#include <mailutils/envelope.h>
#include <mailutils/url.h>

#include <libguile.h>

#if GUILE_VERSION == 14

# define SCM_STRING_CHARS SCM_CHARS
# define scm_list_1 SCM_LIST1
# define scm_list_2 SCM_LIST2
# define scm_list_3 SCM_LIST3
# define scm_list_4 SCM_LIST4
# define scm_list_5 SCM_LIST5
# define scm_list_n SCM_LISTN
# define scm_c_define scm_sysintern
# define scm_primitive_eval_x scm_eval_x
# define scm_i_big2dbl scm_big2dbl

extern SCM scm_long2num (long val);

#endif

typedef struct
{
  int debug_guile;
  mailbox_t mbox;
  char *user_name;
  int (*init) __P((void *data));
  SCM (*catch_body) __P((void *data, mailbox_t mbox));
  SCM (*catch_handler) __P((void *data, SCM tag, SCM throw_args));
  int (*next) __P((void *data, mailbox_t mbox));
  int (*exit) __P((void *data, mailbox_t mbox));
  void *data;
} guimb_param_t;

extern SCM _mu_scm_mailer;
extern SCM _mu_scm_debug;

extern SCM scm_makenum __P((unsigned long val));
extern void mu_set_variable (const char *name, SCM value);
extern void mu_scm_init __P((void));

extern void mu_scm_mailbox_init __P((void));
extern SCM mu_scm_mailbox_create __P((mailbox_t mbox));
extern int mu_scm_is_mailbox __P((SCM scm));

extern void mu_scm_message_init __P((void));
extern SCM mu_scm_message_create __P((SCM owner, message_t msg));
extern int mu_scm_is_message __P((SCM scm));
extern const message_t mu_scm_message_get __P((SCM MESG));

extern int mu_scm_is_body __P((SCM scm));
extern void mu_scm_body_init __P((void));
extern SCM mu_scm_body_create __P((SCM mesg, body_t body));

extern void mu_scm_address_init __P((void));
extern void mu_scm_logger_init __P((void));

extern void mu_scm_port_init __P((void));
extern SCM mu_port_make_from_stream __P((SCM msg, stream_t stream, long mode));

extern void mu_scm_mime_init __P((void));
extern void mu_scm_message_add_owner __P((SCM MESG, SCM owner));

extern void mu_process_mailbox __P((int argc, char *argv, guimb_param_t *param));

extern void mu_scm_mutil_init __P((void));
