/* testfcgi.c: -*- C -*-  DESCRIPTIVE TEXT. */

/*  Copyright (c) 1996 Brian J. Fox
    Author: Brian J. Fox (bfox@ai.mit.edu) Sat Feb 22 19:44:48 1997.  */

#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <sys/wait.h>
#include "./fcgi/include/fcgi_stdio.h"

extern char **environ;

int
main (int argc, char *argv[])
{
  int times_called = 0;

  while (FCGI_Accept () >= 0)
    {
      pid_t child;

      /* We got called again. */
      times_called++;

      {
	FILE *temp_stream = fopen ("/tmp/foo", "wb");
	fprintf (temp_stream, "Times Called: %d\n", times_called);
	fclose (temp_stream);
      }

      /* So start a child to handle the request. */
      child = fork ();

      if (child != (pid_t) 0)
	{
	  int status;
	  /* In the Parent. */
	  wait (&status);
	}
      else
	{
	  register int i;
	  /* fprintf (stdout, "HTTP/1.0 200 OK\n"); */
	  fprintf (stdout, "Content-type: text/plain\n\n");

	  for (i = 0; environ && environ[i]; i++)
	    fprintf (stdout, "environ[%d] = %s\n", i, environ[i]);

	  fflush (stdout);

	  _exit (0);
	}
    }
  return (0);
}
