/* byte-test.c: -*- C -*-  DESCRIPTIVE TEXT. */

/*  Copyright (c) 1996 Universal Access Inc.
    Author: E. B. Gamble Jr. (ebg@ai.mit.edu) Wed Oct 23 17:23:29 1996.  */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "compile.h"

extern void 
bc_parse_install (void);

extern void
bc_parse_show (bc_parse_t parse);

extern void
bc_expand_install (void);

extern void 
bc_core_show (bc_core_t core);

extern bc_function_t
bc_generate (bc_core_t core, 
	     bc_string_t name);

void
bc_repl (void)
{
  char buf [1024];
  bc_function_t func;
  bc_object_t    result;

  puts ("Dingo Down!\n");

  do 
    {
      puts ("repl: ");
      fflush (stdout);

      if (NULL != gets (buf))
	break;

      /* Through the compiler */
      func = bc_compile (buf);

      /* Disassemble */
      bc_function_disassemble (func, stdout);

      /* And the 'evaluator' */
      result = bc_welcome_to_the_machine (func);

      /*      bc_print (result, stdout); */
    }
  while (1);

  puts ("Dingo Done!\n");
}

/*
 *
 *
 *
 */
#if defined (TEST)

void bc_compile_from_parse (bc_parse_t parse,
			    bc_string_t name,
			    bc_string_t string)
{
  bc_core_t     core;
  bc_function_t func;

  printf ("
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

COMPILE: %s\n  \"%s\"", name, string);

  /* parse = bc_parse (string); */

  printf ("\n\nParse of %s:\n", name);
  bc_parse_show (parse);
  
  core = bc_expand (parse, bc_current_package);

  printf ("\n\nCore of %s:\n", name);
  bc_core_show (core);
  
  core = bc_optimize (core);

  func = bc_generate (core, "TOP-LEVEL");

  /* Disassemble */
  puts ("\n");
  bc_function_disassemble (func, stdout);
  
  {
    bc_object_t object =
      bc_welcome_to_the_machine (func);
  }
}

void
main (void)
{
  struct bc_parse_test *test;

  bc_expand_install ();
  bc_parse_install ();

  for (test = bc_parse_test_array;
       *test->parser;
       test++)
    bc_compile_from_parse ((*test->parser)(),
			   test->name,
			   test->string);
}


#endif /* TEST */

