////////////////////////////////////////////////////////////////////////
//
// Copyright (C) 2011-2025 The Octave Project Developers
//
// See the file COPYRIGHT.md in the top-level directory of this
// distribution or <https://octave.org/copyright/>.
//
// This file is part of Octave.
//
// Octave is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Octave is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Octave; see the file COPYING.  If not, see
// <https://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////

#if ! defined (octave_history_dock_widget_h)
#define octave_history_dock_widget_h 1

#include <QCheckBox>
#include <QComboBox>
#include <QLineEdit>
#include <QListView>
#include <QSortFilterProxyModel>
#include <QStringListModel>

#include "octave-dock-widget.h"

OCTAVE_BEGIN_NAMESPACE(octave)

class history_dock_widget : public octave_dock_widget
{
  Q_OBJECT

public:

  history_dock_widget (QWidget *parent);

  ~history_dock_widget () = default;

Q_SIGNALS:

  //! Signal emitted whenever the user double-clicks a command in the
  //! history.

  void command_double_clicked (const QString& command);

  //! Signal emitted whenever the user selects commands and chooses
  //! "Create script" from the popup menu.

  void command_create_script (const QString& commands);

public Q_SLOTS:

  void set_history (const QStringList& hist);
  void append_history (const QString& hist_entry);
  void clear_history ();
  void save_settings ();
  void notice_settings ();

private Q_SLOTS:

  void update_filter_history ();
  void filter_activate (bool enable);

  void ctxMenu (const QPoint& pos);
  void handle_double_click (QModelIndex modelIndex);
  void handle_contextmenu_copy (bool flag);
  void handle_contextmenu_evaluate (bool flag);
  void handle_contextmenu_create_script (bool flag);
  void handle_contextmenu_filter ();

  void copyClipboard ();
  void pasteClipboard ();
  void selectAll ();

  virtual void handle_visibility (bool visible);

private:

  void construct ();
  void set_filter_focus (bool focus);

  QListView *m_history_list_view;
  QSortFilterProxyModel m_sort_filter_proxy_model;

  //! Stores the current history_model.

  QStringListModel *m_history_model;

  QCheckBox *m_filter_checkbox;
  QComboBox *m_filter;
  QWidget *m_filter_widget;
  bool m_filter_shown;

  enum { MaxFilterHistory = 10 };
};

OCTAVE_END_NAMESPACE(octave)

#endif
