/* wordsplit - a word splitter
   Copyright (C) 2009 Sergey Poznyakoff

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 3 of the License, or (at your
   option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program. If not, see <http://www.gnu.org/licenses/>. */

struct wordsplit
{
  size_t ws_wordc;
  char **ws_wordv;
  size_t ws_offs;
  size_t ws_wordn;
  int ws_flags;
  const char *ws_delim;
  const char *ws_comment;

  const char *ws_input;
  size_t ws_len;
  size_t ws_endp;
};

/* Append  the words found to the array resulting from a previous
   call. */
#define WRDSF_APPEND            0x0001
/* Insert we_offs initial NULLs in the array ws_wordv.
   (These are not counted in the returned ws_wordc.) */
#define WRDSF_DOOFFS            0x0002
/* Don't do command substitution. Reserved for future use. */
#define WRDSF_NOCMD             0x0004
/* The parameter p resulted from a previous call to
   wordsplit(), and wordsplit_free() was not called. Reuse the
   allocated storage. */
#define WRDSF_REUSE             0x0008
/* Print errors */
#define WRDSF_SHOWERR           0x0010
/* Consider it an error if an undefined shell variable
   is expanded. */
#define WRDSF_UNDEF             0x0020

/* Don't do variable expansion. Reserved for future use. */
#define WRDSF_NOVAR             0x0040
/* Abort on ENOMEM error */
#define WRDSF_ENOMEMABRT        0x0080
/* Treat whitespace as delimiters */
#define WRDSF_WS                0x0100
/* Handle quotes and escape directives */
#define WRDSF_QUOTE             0x0200
/* Replace each input sequence of repeated delimiters with a single
   delimiter */
#define WRDSF_SQUEEZE_DELIMS    0x0400
/* Return delimiters */
#define WRDSF_RETURN_DELIMS     0x0800
/* Treat sed expressions as words */
#define WRDSF_SED_EXPR          0x1000
/* ws_delim field is initialized */
#define WRDSF_DELIM             0x2000
/* ws_comment field is initialized */
#define WRDSF_COMMENT           0x4000

#define WRDSF_DEFFLAGS \
  (WRDSF_NOVAR | WRDSF_NOCMD | \
   WRDSF_WS | WRDSF_QUOTE | WRDSF_SQUEEZE_DELIMS)

#define WRDSE_EOF        0
#define WRDSE_QUOTE      1
#define WRDSE_NOSPACE    2

int wordsplit (const char *s, struct wordsplit *p, int flags);
void wordsplit_free (struct wordsplit *p);

int wordsplit_unquote_char (int c);
int wordsplit_quote_char (int c);
size_t wordsplit_quoted_length (const char *str, int quote_hex, int *quote);
void wordsplit_unquote_copy (char *dst, const char *src, size_t n);
void wordsplit_quote_copy (char *dst, const char *src, int quote_hex);


  
