#line 559 "../grecs/build-aux/getopt.m4"
/* -*- buffer-read-only: t -*- vi: set ro:
   THIS FILE IS GENERATED AUTOMATICALLY.  PLEASE DO NOT EDIT.
*/
#line 1 "piesctl-cl.opt"
/* This file is part of GNU Pies. -*- c -*-
   Copyright (C) 2008-2022 Sergey Poznyakoff

   GNU Pies is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Pies is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Pies.  If not, see <http://www.gnu.org/licenses/>. */

char *incpath = DEFAULT_INCLUDE_PATH;

#line 120 "piesctl-cl.opt"
#ifdef HAVE_CONFIG_H
#line 120
# include <config.h>
#line 120
#endif
#line 120
#ifdef HAVE_GETOPT_H
#line 120
# include <getopt.h>
#line 120
#endif
#line 120
#include <unistd.h>
#line 120
#include <stdlib.h>
#line 120
#include <grecs.h>
#line 120
#include <grecs/opt.h>
#line 120
#ifndef EX_USAGE
#line 120
# define EX_USAGE 64
#line 120
#endif
#line 120
/* Option codes */
#line 120
enum {
#line 120
	_OPTION_INIT=255,
#line 38 "piesctl-cl.opt"
	OPTION_CONFIG_HELP,
#line 82 "piesctl-cl.opt"
	OPTION_PREPROCESSOR,
#line 89 "piesctl-cl.opt"
	OPTION_NO_PREPROCESSOR,
#line 101 "piesctl-cl.opt"
	OPTION_NO_INCLUDE,
#line 120 "piesctl-cl.opt"
	OPTION_USAGE,
#line 120 "piesctl-cl.opt"
	MAX_OPTION
#line 120
};
#line 120
#ifdef HAVE_GETOPT_LONG
#line 120
static struct option long_options[] = {
#line 26 "piesctl-cl.opt"
	{ "instance", required_argument, 0, 'i' },
#line 32 "piesctl-cl.opt"
	{ "config-file", required_argument, 0, 'c' },
#line 38 "piesctl-cl.opt"
	{ "config-help", no_argument, 0, OPTION_CONFIG_HELP },
#line 51 "piesctl-cl.opt"
	{ "verbose", no_argument, 0, 'v' },
#line 57 "piesctl-cl.opt"
	{ "dump", no_argument, 0, 'd' },
#line 63 "piesctl-cl.opt"
	{ "url", required_argument, 0, 'u' },
#line 74 "piesctl-cl.opt"
	{ "no-netrc", no_argument, 0, 'N' },
#line 82 "piesctl-cl.opt"
	{ "preprocessor", required_argument, 0, OPTION_PREPROCESSOR },
#line 89 "piesctl-cl.opt"
	{ "no-preprocessor", no_argument, 0, OPTION_NO_PREPROCESSOR },
#line 95 "piesctl-cl.opt"
	{ "include-directory", required_argument, 0, 'I' },
#line 101 "piesctl-cl.opt"
	{ "no-include", no_argument, 0, OPTION_NO_INCLUDE },
#line 107 "piesctl-cl.opt"
	{ "define", required_argument, 0, 'D' },
#line 113 "piesctl-cl.opt"
	{ "undefine", required_argument, 0, 'U' },
#line 120 "piesctl-cl.opt"
	{ "help", no_argument, 0, 'h' },
#line 120 "piesctl-cl.opt"
	{ "usage", no_argument, 0, OPTION_USAGE },
#line 120 "piesctl-cl.opt"
	{ "version", no_argument, 0, 'V' },
#line 120 "piesctl-cl.opt"
	{0, 0, 0, 0}
#line 120
};
#line 120
#endif
#line 120

#line 120
static struct grecs_opthelp opthelp[] = {
#line 28 "piesctl-cl.opt"
	{
#line 28
#ifdef HAVE_GETOPT_LONG
#line 28
	  "-i, --instance",
#line 28
#else
#line 28
	  "-i",
#line 28
#endif
#line 28
				   N_("NAME"), 0, N_("connect to instance NAME") },
#line 34 "piesctl-cl.opt"
	{
#line 34
#ifdef HAVE_GETOPT_LONG
#line 34
	  "-c, --config-file",
#line 34
#else
#line 34
	  "-c",
#line 34
#endif
#line 34
				   N_("FILE"), 0, N_("use FILE instead of the default configuration") },
#line 40 "piesctl-cl.opt"
	{
#line 40
#ifdef HAVE_GETOPT_LONG
#line 40
	  "--config-help",
#line 40
#else
#line 40
	  "",
#line 40
#endif
#line 40
				   NULL, 0, N_("show configuration file summary") },
#line 47 "piesctl-cl.opt"
	{
#line 47
#ifdef HAVE_GETOPT_LONG
#line 47
	  "-E",
#line 47
#else
#line 47
	  "-E",
#line 47
#endif
#line 47
				   NULL, 0, N_("preprocess configuration files and exit") },
#line 53 "piesctl-cl.opt"
	{
#line 53
#ifdef HAVE_GETOPT_LONG
#line 53
	  "-v, --verbose",
#line 53
#else
#line 53
	  "-v",
#line 53
#endif
#line 53
				   NULL, 0, N_("verbose diagnostics") },
#line 59 "piesctl-cl.opt"
	{
#line 59
#ifdef HAVE_GETOPT_LONG
#line 59
	  "-d, --dump",
#line 59
#else
#line 59
	  "-d",
#line 59
#endif
#line 59
				   NULL, 0, N_("dump obtained responses verbatim") },
#line 65 "piesctl-cl.opt"
	{
#line 65
#ifdef HAVE_GETOPT_LONG
#line 65
	  "-u, --url",
#line 65
#else
#line 65
	  "-u",
#line 65
#endif
#line 65
				   N_("URL"), 0, N_("connect to this socket") },
#line 76 "piesctl-cl.opt"
	{
#line 76
#ifdef HAVE_GETOPT_LONG
#line 76
	  "-N, --no-netrc",
#line 76
#else
#line 76
	  "-N",
#line 76
#endif
#line 76
				   NULL, 0, N_("don't read ~/.netrc file") },
#line 80 "piesctl-cl.opt"
	{ NULL, NULL, 0, N_("Preprocessor") },
#line 84 "piesctl-cl.opt"
	{
#line 84
#ifdef HAVE_GETOPT_LONG
#line 84
	  "--preprocessor",
#line 84
#else
#line 84
	  "",
#line 84
#endif
#line 84
				   N_("COMMAND"), 0, N_("use COMMAND instead of the default preprocessor") },
#line 91 "piesctl-cl.opt"
	{
#line 91
#ifdef HAVE_GETOPT_LONG
#line 91
	  "--no-preprocessor",
#line 91
#else
#line 91
	  "",
#line 91
#endif
#line 91
				   NULL, 0, N_("disable preprocessing") },
#line 97 "piesctl-cl.opt"
	{
#line 97
#ifdef HAVE_GETOPT_LONG
#line 97
	  "-I, --include-directory",
#line 97
#else
#line 97
	  "-I",
#line 97
#endif
#line 97
				   N_("DIR"), 0, N_("add include directory") },
#line 103 "piesctl-cl.opt"
	{
#line 103
#ifdef HAVE_GETOPT_LONG
#line 103
	  "--no-include",
#line 103
#else
#line 103
	  "",
#line 103
#endif
#line 103
				   NULL, 0, N_("clear default preprocessor search path") },
#line 109 "piesctl-cl.opt"
	{
#line 109
#ifdef HAVE_GETOPT_LONG
#line 109
	  "-D, --define",
#line 109
#else
#line 109
	  "-D",
#line 109
#endif
#line 109
				   N_("NAME[=VALUE]"), 0, N_("define a preprocessor symbol NAME as having VALUE or empty") },
#line 115 "piesctl-cl.opt"
	{
#line 115
#ifdef HAVE_GETOPT_LONG
#line 115
	  "-U, --undefine",
#line 115
#else
#line 115
	  "-U",
#line 115
#endif
#line 115
				   N_("NAME"), 0, N_("undefine a preprocessor symbol NAME") },
#line 120 "piesctl-cl.opt"
	{ NULL, NULL, 0, N_("Other options") },
#line 120 "piesctl-cl.opt"
	{
#line 120
#ifdef HAVE_GETOPT_LONG
#line 120
	  "-h, --help",
#line 120
#else
#line 120
	  "-h",
#line 120
#endif
#line 120
				   NULL, 0, N_("Give this help list") },
#line 120 "piesctl-cl.opt"
	{
#line 120
#ifdef HAVE_GETOPT_LONG
#line 120
	  "--usage",
#line 120
#else
#line 120
	  "",
#line 120
#endif
#line 120
				   NULL, 0, N_("Give a short usage message") },
#line 120 "piesctl-cl.opt"
	{
#line 120
#ifdef HAVE_GETOPT_LONG
#line 120
	  "-V, --version",
#line 120
#else
#line 120
	  "-V",
#line 120
#endif
#line 120
				   NULL, 0, N_("Print program version") },
#line 120 "piesctl-cl.opt"
};
#line 19 "piesctl-cl.opt"

#line 19

#line 19
#ifndef PACKAGE_URL
#line 19
# define PACKAGE_URL NULL
#line 19
#endif
#line 19
static struct grecs_proginfo proginfo = {
#line 19
	"piesctl", /* progname */
#line 19
	NULL, /* subcommands */
#line 19
	N_("GNU pies control program"), /* docstring */
#line 19
	N_("COMMAND [ARG...]"), /* args_doc */
#line 19
	opthelp, /* opthelp */
#line 19
	sizeof(opthelp)/sizeof(opthelp[0]), /* optcount */
#line 19
	NULL, /* print_help_hook */
#line 19
	NULL, /* print_version_hook */
#line 19
	PACKAGE_NAME,    /* package */
#line 19
	PACKAGE_VERSION, /* version */
#line 19
	NULL, /* license */
#line 19
	"2008-2022",/* copyright_year */
#line 19
	"Sergey Poznyakoff", /* copyright_holder */
#line 19
	NULL, /* *authors */
#line 19
	"<" PACKAGE_BUGREPORT ">", /* bug_address */
#line 19
	PACKAGE_URL, /* url */
#line 19
	NULL  /* epilogue */
#line 19
};
#line 19

#line 120 "piesctl-cl.opt"

#line 120


void
parse_options (int argc, char *argv[], int *index)
{
  
#line 125
 {
#line 125
  int c;
#line 125

#line 125
  optind = 0;
#line 125
#ifdef HAVE_GETOPT_LONG
#line 125
  while ((c = getopt_long(argc, argv, "i:c:Evdu:NI:D:U:hV",
#line 125
			  long_options, NULL)) != EOF)
#line 125
#else
#line 125
  while ((c = getopt(argc, argv, "i:c:Evdu:NI:D:U:hV")) != EOF)
#line 125
#endif
#line 125
    {
#line 125
      switch (c)
#line 125
	{
#line 125
	default:
#line 125
	   	   exit(EX_USAGE);
#line 125
	#line 28 "piesctl-cl.opt"
	 case 'i':
#line 28
	  {
#line 28

  instance = optarg;

#line 30
	     break;
#line 30
	  }
#line 34 "piesctl-cl.opt"
	 case 'c':
#line 34
	  {
#line 34

  config_file = optarg;

#line 36
	     break;
#line 36
	  }
#line 40 "piesctl-cl.opt"
	 case OPTION_CONFIG_HELP:
#line 40
	  {
#line 40

  config_help ();
  exit (0);

#line 43
	     break;
#line 43
	  }
#line 47 "piesctl-cl.opt"
	 case 'E':
#line 47
	  {
#line 47

  preprocess_only = 1;

#line 49
	     break;
#line 49
	  }
#line 53 "piesctl-cl.opt"
	 case 'v':
#line 53
	  {
#line 53

  ++verbose;

#line 55
	     break;
#line 55
	  }
#line 59 "piesctl-cl.opt"
	 case 'd':
#line 59
	  {
#line 59

  ++dump;

#line 61
	     break;
#line 61
	  }
#line 65 "piesctl-cl.opt"
	 case 'u':
#line 65
	  {
#line 65

  if (pies_url_create (&client.url, optarg))
    {
      grecs_error (NULL, 0, _("%s: cannot create URL: %s"),
		   optarg, strerror (errno));
      exit (EX_USAGE);
    }

#line 72
	     break;
#line 72
	  }
#line 76 "piesctl-cl.opt"
	 case 'N':
#line 76
	  {
#line 76

  no_netrc_option = 1;

#line 78
	     break;
#line 78
	  }
#line 84 "piesctl-cl.opt"
	 case OPTION_PREPROCESSOR:
#line 84
	  {
#line 84

    if (DEFAULT_PREPROCESSOR)
        grecs_preprocessor = optarg;

#line 87
	     break;
#line 87
	  }
#line 91 "piesctl-cl.opt"
	 case OPTION_NO_PREPROCESSOR:
#line 91
	  {
#line 91

    grecs_preprocessor = NULL;

#line 93
	     break;
#line 93
	  }
#line 97 "piesctl-cl.opt"
	 case 'I':
#line 97
	  {
#line 97

  pp_add_option ("-I", optarg);

#line 99
	     break;
#line 99
	  }
#line 103 "piesctl-cl.opt"
	 case OPTION_NO_INCLUDE:
#line 103
	  {
#line 103

  incpath = NULL;

#line 105
	     break;
#line 105
	  }
#line 109 "piesctl-cl.opt"
	 case 'D':
#line 109
	  {
#line 109

  pp_add_option ("-D", optarg);

#line 111
	     break;
#line 111
	  }
#line 115 "piesctl-cl.opt"
	 case 'U':
#line 115
	  {
#line 115

  pp_add_option ("-U", optarg);

#line 117
	     break;
#line 117
	  }
#line 120 "piesctl-cl.opt"
	 case 'h':
#line 120
	  {
#line 120

#line 120
		grecs_print_help(&proginfo);
#line 120
		exit(0);
#line 120
	 
#line 120
	     break;
#line 120
	  }
#line 120 "piesctl-cl.opt"
	 case OPTION_USAGE:
#line 120
	  {
#line 120

#line 120
		grecs_print_usage(&proginfo);
#line 120
		exit(0);
#line 120
	 
#line 120
	     break;
#line 120
	  }
#line 120 "piesctl-cl.opt"
	 case 'V':
#line 120
	  {
#line 120

#line 120
	        /* Give version */
#line 120
		grecs_print_version(&proginfo, stdout);
#line 120
		exit(0);
#line 120
	 
#line 120
	     break;
#line 120
	  }

#line 125 "piesctl-cl.opt"
	}
#line 125
    }
#line 125
  *index = optind;
#line 125
 }
#line 125
;
  pp_init (incpath);
  setenv ("PIES_INSTANCE", instance, 1);
}


	      
