/*
	Runtime Engine
		By Craig Kadziolka ( Nov 1999 - Dec 2000 )

	Modifications and copying is permitted providing this header
	is retained
*/

#include "idle.h"
#include "context.h"
#include "ithreads.h"

bool Program_Finished()
{
  int loop;

  /* If we are not the boot cpu, we require a special event
     to tell us to cease execution.
     Otherwise the program would halt immediatly, as it has
     no 'real' threads.
  */

	/* Currently only explicit termination is supported */

  return false;

  
  /* 
     1. Check the run queues
     
     Changed: There will ALWAYS be a listening thread active...

  for (loop = 0; loop < PRIORITY_LEVELS; loop ++)
    {

      if (PQH(loop) != NULL) {
	if (loop != PRIORITY_LEVELS - 1 && loop != DEFAULT_PRIORITY)  
	  return false;
	else
	  if (PQH(loop)->previous != NULL) {
	    return false;
	  }
      }
    }  
 */  
  return true;
  
}

/* ------------------------------------------------------------------
   |                             IDLE                               |
   |  The idle thread is setup with an infinite priority.  It will  |
   |  only be called if all other threads are either sleeping or    |
   |  set to infinite priority also, in which case it is round robin|
   |  scheduling.                                                   |
   |                                                                |
   |  This function resides in the platform dependant section       |
   |  so that we can keep the chip cooler and use platform specific |
   |  idle instructions.                                            |
   ------------------------------------------------------------------ */
void IDLE()
{

  printf("Entering IDLE Loop\n");

 IDLE_LOOP:

  /* Perform some housekeeping - destroy any pending threads */
  Destroy();

  /* It is important to detect here wheither we are in the position where
     all other threads are finished. If this is the case then we must 
     clean up and finish */

  if (Program_Finished()) {
    /* Wind up the runtime */

    ShutdownRuntime();
    
  }

  Sync_Save_Context();

  goto IDLE_LOOP;

}

