#! @AWK@ -f

#######################################################################
#
#   Gtk wrapper creation script (struct declarations)
#
#   $Revision: 1.95.1$
#   $Date: 2000/12/27 10:45:49$
#   $Author: pb$
#
########################################################################


#######################################################################
#
# Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
# Written by Paolo Bonzini and Dragomir Milivojevic
#
# This file is part of the GNU Smalltalk class library.
#
# The GNU Smalltalk class library is free software; you can redistribute it
# and/or modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1, or (at
# your option) any later version.
# 
# The GNU Smalltalk class library is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
# General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public License
# along with the GNU Smalltalk class library; see the file COPYING.LESSER.
# If not, write to the Free Software Foundation, 59 Temple Place - Suite
# 330, Boston, MA 02111-1307, USA.  
#
########################################################################

BEGIN {
  type["void"] = "void"
  type["int"]	= "int"
  type["char"] = "string"
  type["double"] = "double"

  type["gint8"] = "byte"
  type["guint8"] = "ubyte"
  type["gint16"] = "short"
  type["guint16"] = "ushort"
  type["gint32"] = "int"
  type["guint32"] = "uint"

  type["gshort"] = "short"
  type["gushort"] = "ushort"
  type["glong"] = "long"
  type["gulong"] = "ulong"
  type["gint"] = "int"
  type["guint"] = "uint"
  type["gboolean"] = "int"
  type["gfloat"] = "float"
  type["gdouble"] = "double"
}

FNR == 1 {
  className = ""
}

$1 == "#define" && className == "" && $2 !~ /(_IS_|_CLASS|_TYPE_|__)/ {
  # Check structs that are defined as GtkObjects.  They might inherit
  # from something different from CStruct.
  sub(/\(.*\)$/, "", $2)
  className = smalltalkize($2)
}

$0 ~ /^typedef (struct|union) _/ && ($3 ";") != ("_" $4) {
  # Take into account typedefs from a struct named differently.
  # We emit all these at the end, because they're often forward
  # references.
  gsub(/[_;]/, "", $0)
  synonyms[$3] = synonyms[$3] " " $4
}


$1 ~ /^(struct|union)$/ && tolower($2) == tolower("_" className) {
  sub(/^_/, "", $2)
  name = $2

  while ($0 !~ /{/)
    read_next_line()

  read_next_line()

  parent = ($1 ~ /^Gtk/) && ($2 !~ /^*/) && ($1 in processed) ? $1 : "CObject" 
  parse_struct(parent, name)
}

$1 ~ /^(struct|union)$/ && $2 !~ /Class$/ {
  sub(/^_/, "", $2)
  name = $2

  read_next_line()
  parse_struct("CObject", name)
}

END {
  for (i in synonyms) {
    split(synonyms[i], arr)
    for (j in arr)
      emit_struct(i, arr[j])
  }
}

# strips garbage from string
function strip( var )
{
  gsub( /[()\\,;*]/, "", var )
  return var
}

function struct( var, name )
{
  # everything else is '(ptr #{xxx})'
  res = type[var];
  
  if (name ~ /^\*/)
  {
    if (var ~ /^(Gtk|GS?List$)/)
      res = "(ptr #{" var "})"
    else if (var ~ /char/)
      res = "string"
    else
      res = "(ptr char)"

    while (name ~ /^\*\*/)
    {
      res = "(ptr " res ")"
      name = substr(name, 2)
    }
  }
  else if( res != "" ) 
    return "#" res
  else
    return "#int"
}

function smalltalkize( res )
{
  first = substr (res, 1, 1)
  res = tolower( substr (res, 2) )

  while (i = index (res, "_")) {
    first = first substr(res, 1, i - 1) toupper( substr (res, i + 1, 1))
    res = substr (res, i + 2)
  }

  return first res
}

function read_next_line ()
{
  getline
  gsub (/\/\*[^*]*\*\//, "", $0)
  if ($1 == "/*") {
    while ($0 !~ /\*\//)
      getline
  }
}

function emit_struct (parent, name)
{
  printf "%s subclass: #%s\n", parent, name
  print "\tinstanceVariableNames: ''"
  print "\tclassVariableNames: ''"
  print "\tpoolDictionaries: ''"
  print "\tcategory: 'Gtk'!\n"
}

function parse_struct (parent, name)
{
  emit_struct(parent, name)
  processed[name] = ""

  while ($1 != "};")
    read_next_line()
}
