# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000-2001  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


if __name__ == "__main__":
    import sys, os
    if os.path.isdir("soundcard"):
        sys.path.append(".")
    else:
        sys.path.append("..")
    
from soundcard.rat import Rat

class Duration:
    def __init__(self, nh, dots):
        self.m_nh = nh
        self.m_dots = dots
    def get_undotted_value(self):
        return self.m_nh
    def get_rat_value(self):
        d = Rat(1, self.m_nh)
        if self.m_dots > 0:
            d = d + Rat(1, self.m_nh * 2)
        if self.m_dots > 1:
            d = d + Rat(1, self.m_nh * 4)
        return d
    def __str__(self):
        return "(Duration:%s:%idot)" % (self.m_nh, self.m_dots)

if __name__ == "__main__":
    def f(h, d):
        d = Duration(h, d)
        print d, d.__dict__, d.get_undotted_value(), d.get_rat_value()
    f(4, 0)
    f(2, 0)
    f(4, 1)
    f(4, 2)

