# Kannada (kn) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                      | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ---------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987ನೇ                                               | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5ನೇ                                                  | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987ನೇ                                               | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5ನೇ                                                  | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1ನೇ                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2ನೇ                                                  | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | ತ್ರೈ 1                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | ತ್ರೈ 2                                               | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1ನೇ ತ್ರೈಮಾಸಿಕ                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2ನೇ ತ್ರೈಮಾಸಿಕ                                        | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                    | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1ನೇ                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2ನೇ                                                  | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | ತ್ರೈ 1                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | ತ್ರೈ 2                                               | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1ನೇ ತ್ರೈಮಾಸಿಕ                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2ನೇ ತ್ರೈಮಾಸಿಕ                                        | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2ನೇ                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7ನೇ                                                  | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | ಫೆಬ್ರ                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ಜುಲೈ                                                 | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | ಫೆಬ್ರವರಿ                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ಜುಲೈ                                                 | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | ಫೆ                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ಜು                                                   | 2019-07-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2ನೇ                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7ನೇ                                                  | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | ಫೆಬ್ರ                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ಜುಲೈ                                                 | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | ಫೆಬ್ರವರಿ                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ಜುಲೈ                                                 | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | ಫೆ                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ಜು                                                   | 2019-07-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1ನೇ                                                  | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48ನೇ                                                 | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1ನೇ                                                  | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48ನೇ                                                 | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11ನೇ                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28ನೇ                                                 | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42ನೇ                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365ನೇ                                                | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | ಸೋಮ                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ಶುಕ್ರ                                                | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | ಸೋಮ                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ಶುಕ್ರ                                                | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | ಸೋಮ                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ಶುಕ್ರ                                                | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | ಸೋಮವಾರ                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ಶುಕ್ರವಾರ                                             | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | ಸೋ                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ಶು                                                   | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | ಸೋಮ                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ಶುಕ್ರ                                                | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1ನೇ                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5ನೇ                                                  | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | ಸೋಮ                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ಶುಕ್ರ                                                | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | ಸೋಮವಾರ                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ಶುಕ್ರವಾರ                                             | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | ಸೋ                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ಶು                                                   | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | ಸೋಮ                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ಶುಕ್ರ                                                | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1ನೇ                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5ನೇ                                                  | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | ಸೋಮ                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ಶುಕ್ರ                                                | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | ಸೋಮವಾರ                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ಶುಕ್ರವಾರ                                             | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | ಸೋ                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ಶು                                                   | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | ಸೋಮ                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ಶುಕ್ರ                                                | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1ನೇ                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5ನೇ                                                  | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | ಸೋಮ                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ಶುಕ್ರ                                                | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | ಸೋಮವಾರ                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ಶುಕ್ರವಾರ                                             | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | ಸೋ                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ಶು                                                   | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | ಸೋಮ                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ಶುಕ್ರ                                                | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | ಪೂರ್ವಾಹ್ನ                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ಅಪರಾಹ್ನ                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ಅಪರಾಹ್ನ                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ಪೂರ್ವಾಹ್ನ                                            | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | ಪೂರ್ವಾಹ್ನ                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ಅಪರಾಹ್ನ                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ಅಪರಾಹ್ನ                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ಪೂರ್ವಾಹ್ನ                                            | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | ಪೂರ್ವಾಹ್ನ                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ಅಪರಾಹ್ನ                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ಅಪರಾಹ್ನ                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ಪೂರ್ವಾಹ್ನ                                            | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | ಪೂರ್ವಾಹ್ನ                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ಅಪರಾಹ್ನ                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ಅಪರಾಹ್ನ                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ಪೂರ್ವಾಹ್ನ                                            | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | ಪೂ                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ಅ                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ಅ                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ಪೂ                                                   | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | ಪೂರ್ವಾಹ್ನ                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ಅಪರಾಹ್ನ                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ಅಪರಾಹ್ನ                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ಪೂರ್ವಾಹ್ನ                                            | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | ಪೂರ್ವಾಹ್ನ                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ಅಪರಾಹ್ನ                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ಅಪರಾಹ್ನ                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ಪೂರ್ವಾಹ್ನ                                            | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | ಪೂರ್ವಾಹ್ನ                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ಅಪರಾಹ್ನ                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ಅಪರಾಹ್ನ                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ಪೂರ್ವಾಹ್ನ                                            | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | ಪೂರ್ವಾಹ್ನ                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ಅಪರಾಹ್ನ                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ಅಪರಾಹ್ನ                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ಪೂರ್ವಾಹ್ನ                                            | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | ಪೂ                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ಅ                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ಅ                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ಪೂ                                                   | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | ಬೆಳಗ್ಗೆ                                              | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ಮಧ್ಯಾನ್ಹ                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ಸಂಜೆ                                                 | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ರಾತ್ರಿ                                               | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | ಬೆಳಗ್ಗೆ                                              | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ಮಧ್ಯಾನ್ಹ                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ಸಂಜೆ                                                 | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ರಾತ್ರಿ                                               | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | ಬೆಳಗ್ಗೆ                                              | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ಮಧ್ಯಾನ್ಹ                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ಸಂಜೆ                                                 | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ರಾತ್ರಿ                                               | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | ಬೆಳಗ್ಗೆ                                              | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ಮಧ್ಯಾನ್ಹ                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ಸಂಜೆ                                                 | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ರಾತ್ರಿ                                               | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | ಬೆಳಗ್ಗೆ                                              | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ಮಧ್ಯಾನ್ಹ                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ಸಂಜೆ                                                 | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ರಾತ್ರಿ                                               | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11ನೇ                                                 | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11ನೇ                                                 | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11ನೇ                                                 | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23ನೇ                                                 | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11ನೇ                                                 | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11ನೇ                                                 | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11ನೇ                                                 | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23ನೇ                                                 | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1ನೇ                                                  | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55ನೇ                                                 | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1ನೇ                                                  | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55ನೇ                                                 | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11/2/87                                              | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/5/53                                              | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | ಫೆಬ್ರ 11, 1987                                       | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | ಮೇ 29, 1453                                          | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | ಫೆಬ್ರವರಿ 11, 1987                                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | ಮೇ 29, 1453                                          | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | ಬುಧವಾರ, ಫೆಬ್ರವರಿ 11, 1987                            | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | ಭಾನುವಾರ, ಮೇ 29, 1453                                 | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13 ಅಪರಾಹ್ನ                                        | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59 ಅಪರಾಹ್ನ                                        | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14 ಅಪರಾಹ್ನ                                     | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 ಅಪರಾಹ್ನ                                     | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 ಅಪರಾಹ್ನ GMT+0                               | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 ಅಪರಾಹ್ನ GMT+0                               | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 ಅಪರಾಹ್ನ GMT+00:00                           | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 ಅಪರಾಹ್ನ GMT+00:00                           | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11/2/87 12:13 ಅಪರಾಹ್ನ                                | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/5/53 11:59 ಅಪರಾಹ್ನ                                | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | ಫೆಬ್ರ 11, 1987 12:13:14 ಅಪರಾಹ್ನ                      | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | ಮೇ 29, 1453 11:59:59 ಅಪರಾಹ್ನ                         | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | ಫೆಬ್ರವರಿ 11, 1987 12:13:14 ಅಪರಾಹ್ನ GMT+0             | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | ಮೇ 29, 1453 11:59:59 ಅಪರಾಹ್ನ GMT+0                   | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | ಬುಧವಾರ, ಫೆಬ್ರವರಿ 11, 1987 12:13:14 ಅಪರಾಹ್ನ GMT+00:00 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | ಭಾನುವಾರ, ಮೇ 29, 1453 11:59:59 ಅಪರಾಹ್ನ GMT+00:00      | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result              | `includeSeconds: true` | `addSuffix: true`     |
| ------------------------ | ------------------- | ---------------------- | --------------------- |
| 2006-01-01T00:00:00.000Z | ಸುಮಾರು 6 ವರ್ಷಗಳು    | ಸುಮಾರು 6 ವರ್ಷಗಳು       | ಸುಮಾರು 6 ವರ್ಷಗಳಲ್ಲಿ   |
| 2005-01-01T00:00:00.000Z | ಸುಮಾರು 5 ವರ್ಷಗಳು    | ಸುಮಾರು 5 ವರ್ಷಗಳು       | ಸುಮಾರು 5 ವರ್ಷಗಳಲ್ಲಿ   |
| 2004-01-01T00:00:00.000Z | ಸುಮಾರು 4 ವರ್ಷಗಳು    | ಸುಮಾರು 4 ವರ್ಷಗಳು       | ಸುಮಾರು 4 ವರ್ಷಗಳಲ್ಲಿ   |
| 2003-01-01T00:00:00.000Z | ಸುಮಾರು 3 ವರ್ಷಗಳು    | ಸುಮಾರು 3 ವರ್ಷಗಳು       | ಸುಮಾರು 3 ವರ್ಷಗಳಲ್ಲಿ   |
| 2002-01-01T00:00:00.000Z | ಸುಮಾರು 2 ವರ್ಷಗಳು    | ಸುಮಾರು 2 ವರ್ಷಗಳು       | ಸುಮಾರು 2 ವರ್ಷಗಳಲ್ಲಿ   |
| 2001-06-01T00:00:00.000Z | 1 ವರ್ಷದ ಮೇಲೆ        | 1 ವರ್ಷದ ಮೇಲೆ           | 1 ವರ್ಷದ ಮೇಲೆ          |
| 2001-02-01T00:00:00.000Z | ಸುಮಾರು 1 ವರ್ಷ       | ಸುಮಾರು 1 ವರ್ಷ          | ಸುಮಾರು 1 ವರ್ಷದಲ್ಲಿ    |
| 2001-01-01T00:00:00.000Z | ಸುಮಾರು 1 ವರ್ಷ       | ಸುಮಾರು 1 ವರ್ಷ          | ಸುಮಾರು 1 ವರ್ಷದಲ್ಲಿ    |
| 2000-06-01T00:00:00.000Z | 5 ತಿಂಗಳು            | 5 ತಿಂಗಳು               | 5 ತಿಂಗಳುಗಳಲ್ಲಿ        |
| 2000-03-01T00:00:00.000Z | 2 ತಿಂಗಳು            | 2 ತಿಂಗಳು               | 2 ತಿಂಗಳುಗಳಲ್ಲಿ        |
| 2000-02-01T00:00:00.000Z | ಸುಮಾರು 1 ತಿಂಗಳು     | ಸುಮಾರು 1 ತಿಂಗಳು        | ಸುಮಾರು 1 ತಿಂಗಳಲ್ಲಿ    |
| 2000-01-15T00:00:00.000Z | 14 ದಿನಗಳು           | 14 ದಿನಗಳು              | 14 ದಿನಗಳಲ್ಲಿ          |
| 2000-01-02T00:00:00.000Z | 1 ದಿನ               | 1 ದಿನ                  | 1 ದಿನದಲ್ಲಿ            |
| 2000-01-01T06:00:00.000Z | ಸುಮಾರು 6 ಗಂಟೆಗಳು    | ಸುಮಾರು 6 ಗಂಟೆಗಳು       | ಸುಮಾರು 6 ಗಂಟೆಗಳಲ್ಲಿ   |
| 2000-01-01T01:00:00.000Z | ಸುಮಾರು 1 ಗಂಟೆ       | ಸುಮಾರು 1 ಗಂಟೆ          | ಸುಮಾರು 1 ಗಂಟೆಯಲ್ಲಿ    |
| 2000-01-01T00:45:00.000Z | ಸುಮಾರು 1 ಗಂಟೆ       | ಸುಮಾರು 1 ಗಂಟೆ          | ಸುಮಾರು 1 ಗಂಟೆಯಲ್ಲಿ    |
| 2000-01-01T00:30:00.000Z | 30 ನಿಮಿಷಗಳು         | 30 ನಿಮಿಷಗಳು            | 30 ನಿಮಿಷಗಳಲ್ಲಿ        |
| 2000-01-01T00:15:00.000Z | 15 ನಿಮಿಷಗಳು         | 15 ನಿಮಿಷಗಳು            | 15 ನಿಮಿಷಗಳಲ್ಲಿ        |
| 2000-01-01T00:01:00.000Z | 1 ನಿಮಿಷ             | 1 ನಿಮಿಷ                | 1 ನಿಮಿಷದಲ್ಲಿ          |
| 2000-01-01T00:00:25.000Z | 1 ನಿಮಿಷಕ್ಕಿಂತ ಕಡಿಮೆ | ಅರ್ಧ ನಿಮಿಷ             | 1 ನಿಮಿಷಕ್ಕಿಂತ ಕಡಿಮೆ   |
| 2000-01-01T00:00:15.000Z | 1 ನಿಮಿಷಕ್ಕಿಂತ ಕಡಿಮೆ | 20 ಸೆಕೆಂಡ್‌ಗಿಂತ ಕಡಿಮೆ  | 1 ನಿಮಿಷಕ್ಕಿಂತ ಕಡಿಮೆ   |
| 2000-01-01T00:00:05.000Z | 1 ನಿಮಿಷಕ್ಕಿಂತ ಕಡಿಮೆ | 10 ಸೆಕೆಂಡ್‌ಗಿಂತ ಕಡಿಮೆ  | 1 ನಿಮಿಷಕ್ಕಿಂತ ಕಡಿಮೆ   |
| 2000-01-01T00:00:00.000Z | 1 ನಿಮಿಷಕ್ಕಿಂತ ಕಡಿಮೆ | 5 ಸೆಕೆಂಡ್‌ಗಿಂತ ಕಡಿಮೆ   | 1 ನಿಮಿಷಕ್ಕಿಂತ ಕಡಿಮೆ   |
| 1999-12-31T23:59:55.000Z | 1 ನಿಮಿಷಕ್ಕಿಂತ ಕಡಿಮೆ | 10 ಸೆಕೆಂಡ್‌ಗಿಂತ ಕಡಿಮೆ  | 1 ನಿಮಿಷಕ್ಕಿಂತ ಕಡಿಮೆ   |
| 1999-12-31T23:59:45.000Z | 1 ನಿಮಿಷಕ್ಕಿಂತ ಕಡಿಮೆ | 20 ಸೆಕೆಂಡ್‌ಗಿಂತ ಕಡಿಮೆ  | 1 ನಿಮಿಷಕ್ಕಿಂತ ಕಡಿಮೆ   |
| 1999-12-31T23:59:35.000Z | 1 ನಿಮಿಷಕ್ಕಿಂತ ಕಡಿಮೆ | ಅರ್ಧ ನಿಮಿಷ             | 1 ನಿಮಿಷಕ್ಕಿಂತ ಕಡಿಮೆ   |
| 1999-12-31T23:59:00.000Z | 1 ನಿಮಿಷ             | 1 ನಿಮಿಷ                | 1 ನಿಮಿಷದ ಹಿಂದೆ        |
| 1999-12-31T23:45:00.000Z | 15 ನಿಮಿಷಗಳು         | 15 ನಿಮಿಷಗಳು            | 15 ನಿಮಿಷಗಳ ಹಿಂದೆ      |
| 1999-12-31T23:30:00.000Z | 30 ನಿಮಿಷಗಳು         | 30 ನಿಮಿಷಗಳು            | 30 ನಿಮಿಷಗಳ ಹಿಂದೆ      |
| 1999-12-31T23:15:00.000Z | ಸುಮಾರು 1 ಗಂಟೆ       | ಸುಮಾರು 1 ಗಂಟೆ          | ಸುಮಾರು 1 ಗಂಟೆ ಹಿಂದೆ   |
| 1999-12-31T23:00:00.000Z | ಸುಮಾರು 1 ಗಂಟೆ       | ಸುಮಾರು 1 ಗಂಟೆ          | ಸುಮಾರು 1 ಗಂಟೆ ಹಿಂದೆ   |
| 1999-12-31T18:00:00.000Z | ಸುಮಾರು 6 ಗಂಟೆಗಳು    | ಸುಮಾರು 6 ಗಂಟೆಗಳು       | ಸುಮಾರು 6 ಗಂಟೆಗಳ ಹಿಂದೆ |
| 1999-12-30T00:00:00.000Z | 2 ದಿನಗಳು            | 2 ದಿನಗಳು               | 2 ದಿನಗಳ ಹಿಂದೆ         |
| 1999-12-15T00:00:00.000Z | 17 ದಿನಗಳು           | 17 ದಿನಗಳು              | 17 ದಿನಗಳ ಹಿಂದೆ        |
| 1999-12-01T00:00:00.000Z | ಸುಮಾರು 1 ತಿಂಗಳು     | ಸುಮಾರು 1 ತಿಂಗಳು        | ಸುಮಾರು 1 ತಿಂಗಳ ಹಿಂದೆ  |
| 1999-11-01T00:00:00.000Z | 2 ತಿಂಗಳು            | 2 ತಿಂಗಳು               | 2 ತಿಂಗಳುಗಳ ಹಿಂದೆ      |
| 1999-06-01T00:00:00.000Z | 7 ತಿಂಗಳು            | 7 ತಿಂಗಳು               | 7 ತಿಂಗಳುಗಳ ಹಿಂದೆ      |
| 1999-01-01T00:00:00.000Z | ಸುಮಾರು 1 ವರ್ಷ       | ಸುಮಾರು 1 ವರ್ಷ          | ಸುಮಾರು 1 ವರ್ಷದ ಹಿಂದೆ  |
| 1998-12-01T00:00:00.000Z | ಸುಮಾರು 1 ವರ್ಷ       | ಸುಮಾರು 1 ವರ್ಷ          | ಸುಮಾರು 1 ವರ್ಷದ ಹಿಂದೆ  |
| 1998-06-01T00:00:00.000Z | 1 ವರ್ಷದ ಮೇಲೆ        | 1 ವರ್ಷದ ಮೇಲೆ           | 1 ವರ್ಷದ ಮೇಲೆ          |
| 1998-01-01T00:00:00.000Z | ಸುಮಾರು 2 ವರ್ಷಗಳು    | ಸುಮಾರು 2 ವರ್ಷಗಳು       | ಸುಮಾರು 2 ವರ್ಷಗಳ ಹಿಂದೆ |
| 1997-01-01T00:00:00.000Z | ಸುಮಾರು 3 ವರ್ಷಗಳು    | ಸುಮಾರು 3 ವರ್ಷಗಳು       | ಸುಮಾರು 3 ವರ್ಷಗಳ ಹಿಂದೆ |
| 1996-01-01T00:00:00.000Z | ಸುಮಾರು 4 ವರ್ಷಗಳು    | ಸುಮಾರು 4 ವರ್ಷಗಳು       | ಸುಮಾರು 4 ವರ್ಷಗಳ ಹಿಂದೆ |
| 1995-01-01T00:00:00.000Z | ಸುಮಾರು 5 ವರ್ಷಗಳು    | ಸುಮಾರು 5 ವರ್ಷಗಳು       | ಸುಮಾರು 5 ವರ್ಷಗಳ ಹಿಂದೆ |
| 1994-01-01T00:00:00.000Z | ಸುಮಾರು 6 ವರ್ಷಗಳು    | ಸುಮಾರು 6 ವರ್ಷಗಳು       | ಸುಮಾರು 6 ವರ್ಷಗಳ ಹಿಂದೆ |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result        | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ------------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 ವರ್ಷಗಳು     | 6 ವರ್ಷಗಳಲ್ಲಿ      | 52608 ಗಂಟೆಗಳು                  |
| 2005-01-01T00:00:00.000Z | 5 ವರ್ಷಗಳು     | 5 ವರ್ಷಗಳಲ್ಲಿ      | 43848 ಗಂಟೆಗಳು                  |
| 2004-01-01T00:00:00.000Z | 4 ವರ್ಷಗಳು     | 4 ವರ್ಷಗಳಲ್ಲಿ      | 35064 ಗಂಟೆಗಳು                  |
| 2003-01-01T00:00:00.000Z | 3 ವರ್ಷಗಳು     | 3 ವರ್ಷಗಳಲ್ಲಿ      | 26304 ಗಂಟೆಗಳು                  |
| 2002-01-01T00:00:00.000Z | 2 ವರ್ಷಗಳು     | 2 ವರ್ಷಗಳಲ್ಲಿ      | 17544 ಗಂಟೆಗಳು                  |
| 2001-06-01T00:00:00.000Z | 1 ವರ್ಷ        | 1 ವರ್ಷದಲ್ಲಿ       | 12408 ಗಂಟೆಗಳು                  |
| 2001-02-01T00:00:00.000Z | 1 ವರ್ಷ        | 1 ವರ್ಷದಲ್ಲಿ       | 9528 ಗಂಟೆಗಳು                   |
| 2001-01-01T00:00:00.000Z | 1 ವರ್ಷ        | 1 ವರ್ಷದಲ್ಲಿ       | 8784 ಗಂಟೆಗಳು                   |
| 2000-06-01T00:00:00.000Z | 5 ತಿಂಗಳು      | 5 ತಿಂಗಳುಗಳಲ್ಲಿ    | 3648 ಗಂಟೆಗಳು                   |
| 2000-03-01T00:00:00.000Z | 2 ತಿಂಗಳು      | 2 ತಿಂಗಳುಗಳಲ್ಲಿ    | 1440 ಗಂಟೆಗಳು                   |
| 2000-02-01T00:00:00.000Z | 1 ತಿಂಗಳು      | 1 ತಿಂಗಳಲ್ಲಿ       | 744 ಗಂಟೆಗಳು                    |
| 2000-01-15T00:00:00.000Z | 14 ದಿನಗಳು     | 14 ದಿನಗಳಲ್ಲಿ      | 336 ಗಂಟೆಗಳು                    |
| 2000-01-02T00:00:00.000Z | 1 ದಿನ         | 1 ದಿನದಲ್ಲಿ        | 24 ಗಂಟೆಗಳು                     |
| 2000-01-01T06:00:00.000Z | 6 ಗಂಟೆಗಳು     | 6 ಗಂಟೆಗಳಲ್ಲಿ      | 6 ಗಂಟೆಗಳು                      |
| 2000-01-01T01:00:00.000Z | 1 ಗಂಟೆ        | 1 ಗಂಟೆಯಲ್ಲಿ       | 1 ಗಂಟೆ                         |
| 2000-01-01T00:45:00.000Z | 45 ನಿಮಿಷಗಳು   | 45 ನಿಮಿಷಗಳಲ್ಲಿ    | 1 ಗಂಟೆ                         |
| 2000-01-01T00:30:00.000Z | 30 ನಿಮಿಷಗಳು   | 30 ನಿಮಿಷಗಳಲ್ಲಿ    | 1 ಗಂಟೆ                         |
| 2000-01-01T00:15:00.000Z | 15 ನಿಮಿಷಗಳು   | 15 ನಿಮಿಷಗಳಲ್ಲಿ    | 0 ಗಂಟೆಗಳು                      |
| 2000-01-01T00:01:00.000Z | 1 ನಿಮಿಷ       | 1 ನಿಮಿಷದಲ್ಲಿ      | 0 ಗಂಟೆಗಳು                      |
| 2000-01-01T00:00:25.000Z | 25 ಸೆಕೆಂಡುಗಳು | 25 ಸೆಕೆಂಡ್‌ಗಳಲ್ಲಿ | 0 ಗಂಟೆಗಳು                      |
| 2000-01-01T00:00:15.000Z | 15 ಸೆಕೆಂಡುಗಳು | 15 ಸೆಕೆಂಡ್‌ಗಳಲ್ಲಿ | 0 ಗಂಟೆಗಳು                      |
| 2000-01-01T00:00:05.000Z | 5 ಸೆಕೆಂಡುಗಳು  | 5 ಸೆಕೆಂಡ್‌ಗಳಲ್ಲಿ  | 0 ಗಂಟೆಗಳು                      |
| 2000-01-01T00:00:00.000Z | 0 ಸೆಕೆಂಡುಗಳು  | 0 ಸೆಕೆಂಡ್ ಹಿಂದೆ   | 0 ಗಂಟೆಗಳು                      |
| 1999-12-31T23:59:55.000Z | 5 ಸೆಕೆಂಡುಗಳು  | 5 ಸೆಕೆಂಡ್ ಹಿಂದೆ   | 0 ಗಂಟೆಗಳು                      |
| 1999-12-31T23:59:45.000Z | 15 ಸೆಕೆಂಡುಗಳು | 15 ಸೆಕೆಂಡ್ ಹಿಂದೆ  | 0 ಗಂಟೆಗಳು                      |
| 1999-12-31T23:59:35.000Z | 25 ಸೆಕೆಂಡುಗಳು | 25 ಸೆಕೆಂಡ್ ಹಿಂದೆ  | 0 ಗಂಟೆಗಳು                      |
| 1999-12-31T23:59:00.000Z | 1 ನಿಮಿಷ       | 1 ನಿಮಿಷದ ಹಿಂದೆ    | 0 ಗಂಟೆಗಳು                      |
| 1999-12-31T23:45:00.000Z | 15 ನಿಮಿಷಗಳು   | 15 ನಿಮಿಷಗಳ ಹಿಂದೆ  | 0 ಗಂಟೆಗಳು                      |
| 1999-12-31T23:30:00.000Z | 30 ನಿಮಿಷಗಳು   | 30 ನಿಮಿಷಗಳ ಹಿಂದೆ  | 1 ಗಂಟೆ                         |
| 1999-12-31T23:15:00.000Z | 45 ನಿಮಿಷಗಳು   | 45 ನಿಮಿಷಗಳ ಹಿಂದೆ  | 1 ಗಂಟೆ                         |
| 1999-12-31T23:00:00.000Z | 1 ಗಂಟೆ        | 1 ಗಂಟೆ ಹಿಂದೆ      | 1 ಗಂಟೆ                         |
| 1999-12-31T18:00:00.000Z | 6 ಗಂಟೆಗಳು     | 6 ಗಂಟೆಗಳ ಹಿಂದೆ    | 6 ಗಂಟೆಗಳು                      |
| 1999-12-30T00:00:00.000Z | 2 ದಿನಗಳು      | 2 ದಿನಗಳ ಹಿಂದೆ     | 48 ಗಂಟೆಗಳು                     |
| 1999-12-15T00:00:00.000Z | 17 ದಿನಗಳು     | 17 ದಿನಗಳ ಹಿಂದೆ    | 408 ಗಂಟೆಗಳು                    |
| 1999-12-01T00:00:00.000Z | 1 ತಿಂಗಳು      | 1 ತಿಂಗಳ ಹಿಂದೆ     | 744 ಗಂಟೆಗಳು                    |
| 1999-11-01T00:00:00.000Z | 2 ತಿಂಗಳು      | 2 ತಿಂಗಳುಗಳ ಹಿಂದೆ  | 1464 ಗಂಟೆಗಳು                   |
| 1999-06-01T00:00:00.000Z | 7 ತಿಂಗಳು      | 7 ತಿಂಗಳುಗಳ ಹಿಂದೆ  | 5136 ಗಂಟೆಗಳು                   |
| 1999-01-01T00:00:00.000Z | 1 ವರ್ಷ        | 1 ವರ್ಷದ ಹಿಂದೆ     | 8760 ಗಂಟೆಗಳು                   |
| 1998-12-01T00:00:00.000Z | 1 ವರ್ಷ        | 1 ವರ್ಷದ ಹಿಂದೆ     | 9504 ಗಂಟೆಗಳು                   |
| 1998-06-01T00:00:00.000Z | 2 ವರ್ಷಗಳು     | 2 ವರ್ಷಗಳ ಹಿಂದೆ    | 13896 ಗಂಟೆಗಳು                  |
| 1998-01-01T00:00:00.000Z | 2 ವರ್ಷಗಳು     | 2 ವರ್ಷಗಳ ಹಿಂದೆ    | 17520 ಗಂಟೆಗಳು                  |
| 1997-01-01T00:00:00.000Z | 3 ವರ್ಷಗಳು     | 3 ವರ್ಷಗಳ ಹಿಂದೆ    | 26280 ಗಂಟೆಗಳು                  |
| 1996-01-01T00:00:00.000Z | 4 ವರ್ಷಗಳು     | 4 ವರ್ಷಗಳ ಹಿಂದೆ    | 35064 ಗಂಟೆಗಳು                  |
| 1995-01-01T00:00:00.000Z | 5 ವರ್ಷಗಳು     | 5 ವರ್ಷಗಳ ಹಿಂದೆ    | 43824 ಗಂಟೆಗಳು                  |
| 1994-01-01T00:00:00.000Z | 6 ವರ್ಷಗಳು     | 6 ವರ್ಷಗಳ ಹಿಂದೆ    | 52584 ಗಂಟೆಗಳು                  |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                           |
| ------------------------ | -------------------------------- |
| 2000-01-10T00:00:00.000Z | 10/1/00                          |
| 2000-01-05T00:00:00.000Z | ಬುಧವಾರ 12:00 ಪೂರ್ವಾಹ್ನ ಕ್ಕೆ      |
| 2000-01-02T00:00:00.000Z | ನಾಳೆ 12:00 ಪೂರ್ವಾಹ್ನ ಕ್ಕೆ        |
| 2000-01-01T00:00:00.000Z | ಇಂದು 12:00 ಪೂರ್ವಾಹ್ನ ಕ್ಕೆ        |
| 1999-12-31T00:00:00.000Z | ನಿನ್ನೆ 12:00 ಪೂರ್ವಾಹ್ನ ಕ್ಕೆ      |
| 1999-12-27T00:00:00.000Z | ಕಳೆದ ಸೋಮವಾರ 12:00 ಪೂರ್ವಾಹ್ನ ಕ್ಕೆ |
| 1999-12-21T00:00:00.000Z | 21/12/99                         |
