// (c) 2000 Peter Putzer
#include <qscrollbar.h>
#include <qlayout.h>

#include <kdebug.h>
#include <kdialog.h>

#include "kscroller.h"

class KScroller::KScrollerPrivate
{
public:
  KScrollerPrivate ()
    : setCornerWidget (0L)
  {
  }

  ~KScrollerPrivate () {}

  QWidget* setCornerWidget;
};

KScroller::KScroller (QWidget* parent, const char* name)
  : QFrame (parent, name),
    d (new KScrollerPrivate()),
    mVertical (new QScrollBar (QScrollBar::Vertical, this)),
    mHorizontal (new QScrollBar (QScrollBar::Horizontal, this)),
    mCornerWidget (new QWidget (this)),
    mContent (0L),
    mVerticalOld (0),
    mHorizontalOld (0)
{
  mCornerWidget->hide();
  mVertical->hide();
  mHorizontal->hide();

  connect (mVertical, SIGNAL (valueChanged (int)),
           this, SLOT (scrollVertical (int)));
  connect (mHorizontal, SIGNAL (valueChanged (int)),
           this, SLOT (scrollHorizontal (int)));
}

KScroller::~KScroller ()
{
  delete d;
}

void KScroller::setContent (QWidget* content)
{
  delete mContent;

  mContent = content;
  updateScrollBars();
}

void KScroller::setCornerWidget (QWidget* corner)
{
  delete mCornerWidget;

  mCornerWidget = d->setCornerWidget = corner;

  updateScrollBars();
}

QWidget* KScroller::cornerWidget ()
{
  return d->setCornerWidget;
}

void KScroller::resizeEvent (QResizeEvent* e)
{
  QFrame::resizeEvent (e);
 
  updateScrollBars();
}

void KScroller::updateScrollBars ()
{
  mContent->resize (size());

  const int w = width();
  const int h = height();

  setupHorizontal (mContent->width(), mContent->height(), w, h);
  setupVertical (mContent->width(), mContent->height(), w, h);

  setupCornerWidget (w, h);
}

void KScroller::setupHorizontal (int cw, int, int w, int h)
{
  mHorizontal->setValue (0);
  mHorizontalOld = 0;

  if (cw > w)
    {
      mHorizontal->resize (mHorizontal->sizeHint());
      mHorizontal->setRange (0, cw - w);
      mHorizontal->setPageStep (w);
      mHorizontal->setLineStep (25);
      mHorizontal->setGeometry (0, h - mHorizontal->height(), w, mHorizontal->height());

      mContent->resize (w, h - mHorizontal->height());

      mHorizontal->raise();
      mHorizontal->show();
    }
  else
    {
      mHorizontal->hide();
    }
}

void KScroller::setupVertical (int, int ch, int w, int h)
{
  mVertical->setValue (0);
  mVerticalOld = 0;

  if (ch > h)
    {
      int oldH = h;
      if (mHorizontal->isVisible())
        h -= mHorizontal->height();

      mVertical->resize (mVertical->sizeHint());
      mVertical->setRange (0, ch - h);
      mVertical->setPageStep (h);
      mVertical->setLineStep (25);

      mVertical->setGeometry (w - mVertical->width(), 0, mVertical->width(), h);

      mContent->resize (w - mVertical->width(), h);

      mVertical->raise();
      mVertical->show();

      setupHorizontal (mContent->width(), mContent->height(), w - mVertical->width(), oldH);
    }
  else
    {
      mVertical->hide();
    }
}

void KScroller::scrollVertical (int value)
{  
  int amount = value - mVerticalOld;
  mVerticalOld = value;

  mContent->move (mContent->x(), mContent->y() - amount);
}

void KScroller::scrollHorizontal (int value)
{
  int amount = value - mHorizontalOld;
  mHorizontalOld = value;
  
  mContent->move (mContent->x() - amount, mContent->y());
}

void KScroller::setupCornerWidget (int w, int h)
{
  if (mVertical->isVisible() && mHorizontal->isVisible())
    {
      int vw = mVertical->width();
      int hh = mHorizontal->height();

      mCornerWidget->raise();
      mCornerWidget->setGeometry (w - vw, h - hh, vw, hh);

      mCornerWidget->show();
    }
  else
    {
      mCornerWidget->hide();
    }
}

#include "kscroller.moc"
