#include <qrect.h>

static void pyqt_qrect_free( void* ptr )
{
    delete (QRect*)ptr;
}

QRect* pyqt_qrect_toCpp( PyObject* obj )
{
    return (QRect*)getPointer( obj, Rect );
}

PyObject* pyqt_qrect_toPython( const QRect& ptr )
{
    return qobjectToPython( new QRect( ptr ), Rect );
}

static PyObject* pyqt_qrect_left( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
        return Py_BuildValue("i", ((QRect*)ptr)->left() );
    }
    return NULL;
}

static PyObject* pyqt_qrect_setRect( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    int _1param;
    int _2param;
    int _3param;
    if ( PyArg_ParseTuple( arg_tuple, "iiii", &_0param, &_1param, &_2param, &_3param )  )
    {
        ((QRect*)ptr)->setRect(_0param, _1param, _2param, _3param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qrect_moveTopLeft( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    PyObject* _0param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "O", &_0param )  && inherits( _0param, Point ) )
    {
        ((QRect*)ptr)->moveTopLeft(*pyqt_qpoint_toCpp( _0param ));
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qrect_setCoords( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    int _1param;
    int _2param;
    int _3param;
    if ( PyArg_ParseTuple( arg_tuple, "iiii", &_0param, &_1param, &_2param, &_3param )  )
    {
        ((QRect*)ptr)->setCoords(_0param, _1param, _2param, _3param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qrect_coords( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
	int a, b, c, d;
        ((QRect*)ptr)->coords( &a, &b, &c, &d );
	PyObject* l = PyList_New( 4 );
	PyList_SetItem( l, 0, PyInt_FromLong( a ) );
	PyList_SetItem( l, 1, PyInt_FromLong( b ) );
	PyList_SetItem( l, 2, PyInt_FromLong( c ) );	
	PyList_SetItem( l, 3, PyInt_FromLong( d ) );
        return l;
    }
    return NULL;
}

static PyObject* pyqt_qrect_x( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
        return Py_BuildValue("i", ((QRect*)ptr)->x() );
    }
    return NULL;
}

static PyObject* pyqt_qrect_y( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
        return Py_BuildValue("i", ((QRect*)ptr)->y() );
    }
    return NULL;
}

static PyObject* pyqt_qrect_intersect( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    PyObject* _0param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "O", &_0param )  && inherits( _0param, Rect ) )
    {
        return pyqt_qrect_toPython( ((QRect*)ptr)->intersect(*pyqt_qrect_toCpp( _0param )) );
    }
    return NULL;
}

static PyObject* pyqt_qrect_setX( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    if ( PyArg_ParseTuple( arg_tuple, "i", &_0param )  )
    {
        ((QRect*)ptr)->setX(_0param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qrect_isEmpty( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
        return Py_BuildValue("b", (char)((QRect*)ptr)->isEmpty() );
    }
    return NULL;
}

static PyObject* pyqt_qrect_contains( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    PyObject* _0param = 0;
    bool _1param=FALSE;
    if ( PyArg_ParseTuple( arg_tuple, "O|b", &_0param, &_1param )  && inherits( _0param, Point ) )
    {
        return Py_BuildValue("b", (char)((QRect*)ptr)->contains(*pyqt_qpoint_toCpp( _0param ), _1param) );
    }
    PyObject* _2param = 0;
    bool _3param=FALSE;
    if ( PyArg_ParseTuple( arg_tuple, "O|b", &_2param, &_3param )  && inherits( _2param, Rect ) )
    {
	PyErr_Clear();	
        return Py_BuildValue("b", (char)((QRect*)ptr)->contains(*pyqt_qrect_toCpp( _2param ), _3param) );
    }
    return NULL;
}

static PyObject* pyqt_qrect_moveBy( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    int _1param;
    if ( PyArg_ParseTuple( arg_tuple, "ii", &_0param, &_1param )  )
    {
        ((QRect*)ptr)->moveBy(_0param, _1param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qrect_isNull( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
        return Py_BuildValue("b", (char)((QRect*)ptr)->isNull() );
    }
    return NULL;
}

static PyObject* pyqt_qrect_setRight( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    if ( PyArg_ParseTuple( arg_tuple, "i", &_0param )  )
    {
        ((QRect*)ptr)->setRight(_0param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qrect_topRight( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
        return pyqt_qpoint_toPython( ((QRect*)ptr)->topRight() );
    }
    return NULL;
}

static PyObject* pyqt_qrect_moveBottomRight( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    PyObject* _0param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "O", &_0param )  && inherits( _0param, Point ) )
    {
        ((QRect*)ptr)->moveBottomRight(*pyqt_qpoint_toCpp( _0param ));
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qrect_top( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
        return Py_BuildValue("i", ((QRect*)ptr)->top() );
    }
    return NULL;
}

static PyObject* pyqt_qrect_bottom( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
        return Py_BuildValue("i", ((QRect*)ptr)->bottom() );
    }
    return NULL;
}

static PyObject* pyqt_qrect_bottomRight( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
        return pyqt_qpoint_toPython( ((QRect*)ptr)->bottomRight() );
    }
    return NULL;
}

static PyObject* pyqt_qrect_center( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
        return pyqt_qpoint_toPython( ((QRect*)ptr)->center() );
    }
    return NULL;
}

static PyObject* pyqt_qrect_bottomLeft( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
        return pyqt_qpoint_toPython( ((QRect*)ptr)->bottomLeft() );
    }
    return NULL;
}

static PyObject* pyqt_qrect_moveCenter( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    PyObject* _0param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "O", &_0param )  && inherits( _0param, Point ) )
    {
        ((QRect*)ptr)->moveCenter(*pyqt_qpoint_toCpp( _0param ));
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qrect_constructor( void* /* ptr */, PyObject* obj, PyObject* arg_tuple )
{
    if ( !obj )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
        void* ptr = new QRect;
        mapObject( obj, ptr, pyqt_qrect_class, Python );
        Py_INCREF( Py_None );
        return Py_None;
    }
    PyObject* _0param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "O", &_0param )  && inherits( _0param, Rect ) )
    {
        void* ptr = new QRect( *pyqt_qrect_toCpp( _0param ) );
        mapObject( obj, ptr, pyqt_qrect_class, Python );
        Py_INCREF( Py_None );
        return Py_None;
    }
    PyObject* _1param = 0;
    PyObject* _2param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "OO", &_1param, &_2param )  && inherits( _1param, Point ) && inherits( _2param, Point ) )
    {
	PyErr_Clear();	
        void* ptr = new QRect( *pyqt_qpoint_toCpp( _1param ), *pyqt_qpoint_toCpp( _2param ) );
        mapObject( obj, ptr, pyqt_qrect_class, Python );
        Py_INCREF( Py_None );
        return Py_None;
    }
    PyObject* _3param = 0;
    PyObject* _4param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "OO", &_3param, &_4param )  && inherits( _3param, Point ) && inherits( _4param, Size ) )
    {
	PyErr_Clear();	
        void* ptr = new QRect( *pyqt_qpoint_toCpp( _3param ), *pyqt_qsize_toCpp( _4param ) );
        mapObject( obj, ptr, pyqt_qrect_class, Python );
        Py_INCREF( Py_None );
        return Py_None;
    }
    int _5param;
    int _6param;
    int _7param;
    int _8param;
    if ( PyArg_ParseTuple( arg_tuple, "iiii", &_5param, &_6param, &_7param, &_8param )  )
    {
	PyErr_Clear();
        void* ptr = new QRect( _5param, _6param, _7param, _8param );
        mapObject( obj, ptr, pyqt_qrect_class, Python );
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qrect_height( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
        return Py_BuildValue("i", ((QRect*)ptr)->height() );
    }
    return NULL;
}

static PyObject* pyqt_qrect_normalize( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
        return pyqt_qrect_toPython( ((QRect*)ptr)->normalize() );
    }
    return NULL;
}

static PyObject* pyqt_qrect_size( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
        return pyqt_qsize_toPython( ((QRect*)ptr)->size() );
    }
    return NULL;
}

static PyObject* pyqt_qrect_rect( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
	int a, b, c, d;
        ((QRect*)ptr)->rect( &a, &b, &c, &d );
	PyObject* l = PyList_New( 4 );
	PyList_SetItem( l, 0, PyInt_FromLong( a ) );
	PyList_SetItem( l, 1, PyInt_FromLong( b ) );
	PyList_SetItem( l, 2, PyInt_FromLong( c ) );	
	PyList_SetItem( l, 3, PyInt_FromLong( d ) );
        return l;
    }
    return NULL;
}

static PyObject* pyqt_qrect_setY( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    if ( PyArg_ParseTuple( arg_tuple, "i", &_0param )  )
    {
        ((QRect*)ptr)->setY(_0param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qrect_setLeft( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    if ( PyArg_ParseTuple( arg_tuple, "i", &_0param )  )
    {
        ((QRect*)ptr)->setLeft(_0param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qrect_moveBottomLeft( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    PyObject* _0param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "O", &_0param )  && inherits( _0param, Point ) )
    {
        ((QRect*)ptr)->moveBottomLeft(*pyqt_qpoint_toCpp( _0param ));
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qrect_width( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
        return Py_BuildValue("i", ((QRect*)ptr)->width() );
    }
    return NULL;
}

static PyObject* pyqt_qrect_setWidth( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    if ( PyArg_ParseTuple( arg_tuple, "i", &_0param )  )
    {
        ((QRect*)ptr)->setWidth(_0param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qrect_setSize( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    PyObject* _0param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "O", &_0param )  && inherits( _0param, Size ) )
    {
        ((QRect*)ptr)->setSize(*pyqt_qsize_toCpp( _0param ));
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qrect_unite( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    PyObject* _0param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "O", &_0param )  && inherits( _0param, Rect ) )
    {
        return pyqt_qrect_toPython( ((QRect*)ptr)->unite(*pyqt_qrect_toCpp( _0param )) );
    }
    return NULL;
}

static PyObject* pyqt_qrect_intersects( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    PyObject* _0param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "O", &_0param )  && inherits( _0param, Rect ) )
    {
        return Py_BuildValue("b", (char)((QRect*)ptr)->intersects(*pyqt_qrect_toCpp( _0param )) );
    }
    return NULL;
}

static PyObject* pyqt_qrect_setTop( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    if ( PyArg_ParseTuple( arg_tuple, "i", &_0param )  )
    {
        ((QRect*)ptr)->setTop(_0param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qrect_moveTopRight( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    PyObject* _0param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "O", &_0param )  && inherits( _0param, Point ) )
    {
        ((QRect*)ptr)->moveTopRight(*pyqt_qpoint_toCpp( _0param ));
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qrect_isValid( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
        return Py_BuildValue("b", (char)((QRect*)ptr)->isValid() );
    }
    return NULL;
}

static PyObject* pyqt_qrect_setBottom( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    if ( PyArg_ParseTuple( arg_tuple, "i", &_0param )  )
    {
        ((QRect*)ptr)->setBottom(_0param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qrect_setHeight( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    if ( PyArg_ParseTuple( arg_tuple, "i", &_0param )  )
    {
        ((QRect*)ptr)->setHeight(_0param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qrect_right( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
        return Py_BuildValue("i", ((QRect*)ptr)->right() );
    }
    return NULL;
}

static PyObject* pyqt_qrect_topLeft( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
        return pyqt_qpoint_toPython( ((QRect*)ptr)->topLeft() );
    }
    return NULL;
}

static PyQt_Method pyqt_qrect_methods[] = {
    pyqt_qrect_left,
    pyqt_qrect_setRect,
    pyqt_qrect_moveTopLeft,
    pyqt_qrect_setCoords,
    pyqt_qrect_coords,
    pyqt_qrect_x,
    pyqt_qrect_y,
    pyqt_qrect_intersect,
    pyqt_qrect_setX,
    pyqt_qrect_isEmpty,
    pyqt_qrect_contains,
    pyqt_qrect_moveBy,
    pyqt_qrect_isNull,
    pyqt_qrect_setRight,
    pyqt_qrect_topRight,
    pyqt_qrect_moveBottomRight,
    pyqt_qrect_top,
    pyqt_qrect_bottom,
    pyqt_qrect_bottomRight,
    pyqt_qrect_center,
    pyqt_qrect_bottomLeft,
    pyqt_qrect_moveCenter,
    pyqt_qrect_constructor,
    pyqt_qrect_height,
    pyqt_qrect_normalize,
    pyqt_qrect_size,
    pyqt_qrect_rect,
    pyqt_qrect_setY,
    pyqt_qrect_setLeft,
    pyqt_qrect_moveBottomLeft,
    pyqt_qrect_width,
    pyqt_qrect_setWidth,
    pyqt_qrect_setSize,
    pyqt_qrect_unite,
    pyqt_qrect_intersects,
    pyqt_qrect_setTop,
    pyqt_qrect_moveTopRight,
    pyqt_qrect_isValid,
    pyqt_qrect_setBottom,
    pyqt_qrect_setHeight,
    pyqt_qrect_right,
    pyqt_qrect_topLeft,
    0
};

static void pyqt_qrect_init()
{
    if ( pyqt_qrect_class )
        return;

    pyqt_qrect_class = new PyQt_ClassInfo;
    pyqt_qrect_class->freeQt = pyqt_qrect_free;
    pyqt_qrect_class->methods = pyqt_qrect_methods;
    pyqt_qrect_class->methodCount = methodCount( pyqt_qrect_methods );
    pyqt_qrect_class->next = 0;
    pyqt_qrect_class->classid = Rect;
    pyqt_qrect_class->classObject = PyDict_GetItemString( pyqt_qt_dict, "QRect" );
    pyqt_qrect_class->className = "QRect";
    ASSERT( pyqt_qrect_class->classObject );
}


