/***************************************************************************
                            CSSStyleDeclaration.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The <code> CSSStyleDeclaration </code> interface represents a
 single <a href="http://www.w3.org/TR/REC-CSS2/syndata.html#block">
 CSS declaration block </a> . This interface may be used to
 determine the style properties currently set in a block or to set
 style properties explicitly within the block.

  While an implementation may not recognize all CSS properties
 within a CSS declaration block, it is expected to provide access to
 all specified properties through the <code> CSSStyleDeclaration
 </code> interface. Furthermore, implementations that support a
 specific level of CSS should correctly handle <a
 href="http://www.w3.org/TR/REC-CSS2/about.html#shorthand"> CSS
 shorthand </a> properties for that level. For a further discussion
 of shorthand properties, see the <code> CSS2Properties </code>
 interface.

 
 @short 
 The <code> CSSStyleDeclaration </code> interface represents a
 single <a href="http://www.
*/
public class  CSSStyleDeclaration implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected CSSStyleDeclaration(Class dummy){}

	private native void newCSSStyleDeclaration();
	public CSSStyleDeclaration() {
		newCSSStyleDeclaration();
	}
	private native void newCSSStyleDeclaration( CSSStyleDeclaration other);
	public CSSStyleDeclaration( CSSStyleDeclaration other) {
		newCSSStyleDeclaration( other);
	}
//	private native void newCSSStyleDeclaration( CSSStyleDeclarationImpl impl);
//	public CSSStyleDeclaration( CSSStyleDeclarationImpl impl) {
//		newCSSStyleDeclaration( impl);
//	}
	protected native void finalize() throws InternalError;

/** 
 The parsable textual representation of the declaration block
 (including the surrounding curly braces). Setting this
 attribute will result in the parsing of the new value and
 resetting of the properties in the declaration block.

     
*/
	public native String cssText();

/** 
 see {@link cssText}

     
*/
	public native void setCssText( String arg1);

/** 
 The number of properties that have been explicitly set in this
 declaration block.

     
*/
	public native long length();

/** 
 The CSS rule that contains this declaration block.

     
*/
//	public native CSSRule parentRule();

/** 
 Used to retrieve the value of a CSS property if it has been
 explicitly set within this declaration block.

     
*/
	public native String getPropertyValue( String propertyName);

/** 
 Used to retrieve the object representation of the value of a
 CSS property if it has been explicitly set within this
 declaration block. This method returns null if the property is
 a <a href="http://www.w3.org/TR/REC-CSS2/about.html#shorthand">
 shorthand </a> property. Shorthand property values can only be
 accessed and modified as strings, using the <code>
 getPropertyValue </code> and <code> setProperty </code>
 methods.

     
*/
	public native CSSValue getPropertyCSSValue( String propertyName);

/** 
 Used to remove a CSS property if it has been explicitly set
 within this declaration block.

     
*/
	public native String removeProperty( String propertyName);

/** 
 Used to retrieve the priority of a CSS property (e.g. the
 <code> "important" </code> qualifier) if the property has been
 explicitly set in this declaration block.

     
*/
	public native String getPropertyPriority( String propertyName);

/** 
 Used to set a property value and priority within this
 declaration block.

     
*/
	public native void setProperty( String propertyName, String value, String priority);

/** 
 Used to retrieve the properties that have been explicitly set
 in this declaration block. The order of the properties
 retrieved using this method does not have to be the order in
 which they were set. This method can be used to iterate over
 all properties in this declaration block.

     
*/
	public native String item( long index);

/** 

 not part of the DOM
     
*/
//	public native CSSStyleDeclarationImpl handle();
	public native boolean isNull();
}
