/***************************************************************************
                            GUSOut.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Gravis Ultrasound synthesizer output class . This class is used to send midi
 events to synthesizers on GUS cards.

 GUSOut inherits {@link MidiOut} and supports the same simple API.

 The recommended way to use this class is by using a {@link DeviceManager}
 object, and use the {@link DeviceManager#setPatchesToUse} member which will
 call the {@link #setPatchesToUse} member in this class.

 @author Antonio Larrosa Jimenez <larrosa@kde.org>
 
 @version 0.9.5 17/01/2000

 @short Sends MIDI events to GUS synths.
*/
public class GUSOut extends MidiOut  {
	protected GUSOut(Class dummy){super((Class) null);}


/** 
 Constructor. See {@link MidiOut#MidiOut} for more information.
     
*/
	private native void newGUSOut( int d, int total);
	public GUSOut( int d, int total) {
		super((Class) null);
		newGUSOut( d, total);
	}
	private native void newGUSOut();
	public GUSOut() {
		super((Class) null);
		newGUSOut();
	}

/** 
 Destructor.
     
*/
	protected native void finalize() throws InternalError;

/** 
 See {@link MidiOut#openDev}
     
*/
	public native void openDev( int sqfd);

/** 
 See {@link MidiOut#closeDev}
     
*/
	public native void closeDev();

/** 
 See {@link MidiOut#initDev}
     
*/
	public native void initDev();

/** 
 See {@link MidiOut#noteOn}
     
*/
	public native void noteOn( String chn, String note, String vel);

/** 
 See {@link MidiOut#noteOff}
     
*/
	public native void noteOff( String chn, String note, String vel);

/** 
 See {@link MidiOut#keyPressure}
     
*/
	public native void keyPressure( String chn, String note, String vel);

/** 
 See {@link MidiOut#chnPatchChange}
     
*/
	public native void chnPatchChange( String chn, String patch);

/** 
 See {@link MidiOut#chnPressure}
     
*/
	public native void chnPressure( String chn, String vel);

/** 
 See {@link MidiOut#chnPitchBender}
     
*/
	public native void chnPitchBender( String chn, String lsb, String msb);

/** 
 See {@link MidiOut#chnController}
     
*/
	public native void chnController( String chn, String ctl, String v);

/** 
 It's an empty function, as GUS synths don't support System Exclusive
 messages
     
*/
	public native void sysex( String data, long size);

/** 
 See {@link DeviceManager#setPatchesToUse} . All the information about this
 member is explained there because it's (for now) just a simple call to this
 function when the device used is a GUS device, and you're supposed to use
 a DeviceManager object instead of a GUSOut object except in rare ocassions.

*/
	public native void setPatchesToUse( int[] patchesused);

/** 
 Loads a single patch on the synthesizer memory.

*/
	public native int loadPatch( int pgm);

/** 
 Returns p if the patch with number p has been correctly loaded.
 In the case it hasn't been loaded, it returns the number of another patch
 that is loaded and that should be used instead.

*/
	public native int patch( int p);

/** 
 Sets the directory where the GUS patches are stored, that is, where the
 acpiano.pat, ... files can be found.

 It will store a copy of the parameter, so you should delete the memory
 used by the parameter you passed.
     
*/
	public static native void setGUSPatchesDirectory( String dir);
}
