/***************************************************************************
                            KAboutApplication.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class provides the standard "About Application" dialog box that
 is used by {@link KHelpMenu}. It uses the information of the global
 {@link KAboutData} that is specified at the start of you program in
 main(). Normally you should not use this class directly but
 rather the {@link KHelpMenu} class or even better just subclass your
 toplevel window from {@link KMainWindow}. If you do the latter, the help
 menu and thereby this dialog box is available through the
 {@link KMainWindow#helpMenu} function.

 See {@link KAboutApplicationSignals} for signals emitted by KAboutApplication.

 See {@link KAboutApplicationEventHandling} for event handlers to override in subclasses of KAboutApplication.

 @author Waldo Bastian (bastian@kde.org) and Espen Sand (espen@kde.org)

 @version $Id
 
 @short Standard "About Application" dialog box.

*/
public class KAboutApplication extends KAboutDialog  {
	protected KAboutApplication(Class dummy){super((Class) null);}


/** 
 Constructor. Creates a fully featured "About Application" dialog box.
 Note that this dialog is made modeless in the {@link KHelpMenu} class so
 the users may expect a modeless dialog.

*/
	private native void newKAboutApplication( QWidget parent, String name, boolean modal);
	public KAboutApplication( QWidget parent, String name, boolean modal) {
		super((Class) null);
		newKAboutApplication( parent, name, modal);
	}
	private native void newKAboutApplication();
	public KAboutApplication() {
		super((Class) null);
		newKAboutApplication();
	}

/** 
 Constructor. Mostly does the same stuff as the above constructor, except
 that it can take a custom KAboutData object instead of the one specified
 in your main() function. This is especially useful for applications
 which are implemented as (dynamically loaded) libraries, e.g. panel
 applets.

*/
	private native void newKAboutApplication( KAboutData aboutData, QWidget parent, String name, boolean modal);
	public KAboutApplication( KAboutData aboutData, QWidget parent, String name, boolean modal) {
		super((Class) null);
		newKAboutApplication( aboutData, parent, name, modal);
	}
	private native void newKAboutApplication( KAboutData aboutData);
	public KAboutApplication( KAboutData aboutData) {
		super((Class) null);
		newKAboutApplication( aboutData);
	}
	protected native void buildDialog( KAboutData aboutData);
}
