/***************************************************************************
                            KProcess.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Child process invocation, monitoring and control.

This class allows a KDE application to start child processes without having
to worry about UNX signal handling issues and zombie process reaping.

Basically, this class distinguishes three different ways of running
child processes:

Starting a  DontCare child process means that the application is
not interested in any notification to determine whether the
child process has already exited or not.

When the child process exits, the KProcess instance
corresponding to it emits the Qt signal {@link #processExited}.

Since this signal is <em>not</em> emitted from within a UNX
signal handler, arbitrary function calls can be made.

Be aware: When the KProcess objects gets destructed, the child
process will be killed if it is still running!
This means in particular, that you cannot use a KProcess on the stack
with KProcess.NotifyOnExit.

KProcess also provides several functions for determining the exit status
and the pid of the child process it represents.

Furthermore it is possible to supply command-line arguments to the process
in a clean fashion (no null -- terminated stringlists and such...)

A small usage example:
<pre>
KProcess proc;

proc << "my_executable";
proc << "These" << "are" << "the" << "command" << "line" << "args";
QApplication.connect(&proc, SIGNAL("processExited(KProcess )"),
                      pointer_to_my_object, SLOT("my_objects_slot)");
proc.start();
</pre>

This will start "my_executable" with the commandline arguments "These"...

When the child process exits, the respective Qt signal will be emitted.

KProcess supports communication with the child process through
stdin/stdout/stderr.

The following functions are provided for getting data from the child
process or sending data to the child's stdin (For more information,
have a look at the documentation of each function):

 See {@link KProcessSignals} for signals emitted by KProcess.

 See {@link KProcessEventHandling} for event handlers to override in subclasses of KProcess.

 @author Christian Czezakte e9025461@student.tuwien.ac.at

 @short 
 Child process invocation, monitoring and control.
*/
public class KProcess extends QObject  {
	protected KProcess(Class dummy){super((Class) null);}


/**  Constructor 
*/
	private native void newKProcess();
	public KProcess() {
		super((Class) null);
		newKProcess();
	}

/** 
Destructor:

  If the process is running when the destructor for this class
  is called, the child process is killed with a SIGKILL, but
  only if the run mode is not of type <code>DontCare.</code>
  Processes started as <code>DontCare</code> keep running anyway.
  
*/
	protected native void finalize() throws InternalError;

/** 

         The use of this function is now deprecated. -- Please use the
	 "operator<<" instead of "setExecutable".

	 Sets the executable to be started with this KProcess object.
	 Returns false if the process is currently running (in that
	 case the executable remains unchanged.)

  
*/
	public native boolean setExecutable( String proc);

/** 
 Clear a command line argument list that has been set by using
 the "operator<<".
  
*/
	public native void clearArguments();

/**  Start the process.
  For a detailed description of the
  various run modes and communication semantics, have a look at the
  general description of the {@link KProcess} class.

  The following problems could cause {@link KProcess}:start() to
    return <code>false</code>:

*/
	public native boolean start( int runmode, int comm);
	public native boolean start();

/** 
 Stop the process (by sending it a signal).

*/
	public native boolean kill( int signo);
	public native boolean kill();

/** 

*/
	public native boolean isRunning();

/**  Returns the process id of the process.

 If it is called after
 the process has exited, it returns the process id of the last
  child process that was created by this instance of KProcess.

  Calling it before any child process has been started by this
  KProcess instance causes pid() to return 0.

*/
	public native long pid();

/** 
 Use pid().

   
*/
	public native long getPid();

/** 
 Suspend processing of data from stdout of the child process.
   
*/
	public native void suspend();

/** 
 Resume processing of data from stdout of the child process.
   
*/
	public native void resume();

/** 

 Note that you should check {@link KProcess#exitStatus} to determine
 whether the process completed its task successfull or not.
   
*/
	public native boolean normalExit();

/** 
 Retrieve the exit status of the process.

 Please use
 {@link KProcess#normalExit} to check whether the process has exited
 cleanly (i.e., {@link KProcess#normalExit} returns <code>true</code>) before calling
 this function because if the process did not exit normally,
 it does not have a valid exit status.
  
*/
	public native int exitStatus();

/** 
	 Transmit data to the child process's stdin.

 KProcess.writeStdin may return false in the following cases:

 Please note that the data is sent to the client asynchronousely,
 so when this function returns, the data might not have been
 processed by the child process.

 If all the data has been sent to the client, the signal
 {@link #wroteStdin} will be emitted.

 Please note that you must not free "buffer" or call {@link #writeStdin}
 again until either a {@link #wroteStdin} signal indicates that the
 data has been sent or a {@link #processHasExited} signal shows that
 the child process is no longer alive...

*/
	public native boolean writeStdin( String buffer, int buflen);

/** 
 This causes the stdin file descriptor of the child process to be
 closed indicating an "EOF" to the child.

*/
	public native boolean closeStdin();

/** 
 This causes the stdout file descriptor of the child process to be
 closed.

*/
	public native boolean closeStdout();

/** 
 This causes the stderr file descriptor of the child process to be
 closed.

*/
	public native boolean closeStderr();

/** 
 Lets you see what your arguments are for debugging.
   
*/
	public native ArrayList args();

/** 
 Controls whether the started process should drop any
 setuid/segid privileges or whether it should keep them

 The default is <code>false</code> : drop privileges
   
*/
	public native void setRunPrivileged( boolean keepPrivileges);

/** 
 Returns whether the started process will drop any
 setuid/segid privileges or whether it will keep them
   
*/
	public native boolean runPrivileged();

/** 
 Detaches KProcess from child process. All communication is closed.
 No exit notification is emitted any more for the child process.
 Deleting the KProcess will no longer kill the child process.
 Note that the current process remains the parent process of the
 child process.
   
*/
	public native void detach();

/** 
    This function is called from "KProcess.start" right before a "fork" takes
    place. According to
    the "comm" parameter this function has to initialize the "in", "out" and
    "err" data member of KProcess.

    This function should return 0 if setting the needed communication channels
    was successful.

    The default implementation is to create UNIX STREAM sockets for the communication,
    but you could overload this function and establish a TCP/IP communication for
    network communication, for example.
  
*/
	protected native int setupCommunication( int comm);

/** 
     Called right after a (successful) fork on the parent side. This function
     will usually do some communications cleanup, like closing the reading end
     of the "stdin" communication channel.

     Furthermore, it must also create the QSocketNotifiers "innot", "outnot" and
     "errnot" and connect their Qt slots to the respective KProcess member functions.

     For a more detailed explanation, it is best to have a look at the default
     implementation of "setupCommunication" in {@link kprocess#cpp}.
  
*/
	protected native int commSetupDoneP();

/** 
     Called right after a (successful) fork, but before an "exec" on the child
     process' side. It usually just closes the unused communication ends of
     "in", "out" and "err" (like the writing end of the "in" communication
     channel.
  
*/
	protected native int commSetupDoneC();

/** 
     Immediately called after a process has exited. This function normally
     calls commClose to close all open communication channels to this
     process and emits the "processExited" signal (if the process was
     not running in the "DontCare" mode).
  
*/
	protected native void processHasExited( int state);

/** 
     Should clean up the communication links to the child after it has
     exited. Should be called from "processHasExited".
  
*/
	protected native void commClose();

/** 
     Called by "slotChildOutput" this function copies data arriving from the
     child process's stdout to the respective buffer and emits the signal
     "{@link receivedStderr}".
  
*/
	protected native int childOutput( int fdno);

/** 
     Called by "slotChildOutput" this function copies data arriving from the
     child process's stdout to the respective buffer and emits the signal
     "{@link receivedStderr}"
  
*/
	protected native int childError( int fdno);

/** 
   This slot gets activated when data from the child's stdout arrives.
   It usually calls "childOutput"
  
*/
	protected native void slotChildOutput( int fdno);

/** 
   This slot gets activated when data from the child's stderr arrives.
   It usually calls "childError"
  
*/
	protected native void slotChildError( int fdno);

/** 
	Called when another bulk of data can be sent to the child's
	stdin. If there is no more data to be sent to stdin currently
	available, this function must disable the QSocketNotifier "innot".
  
*/
	protected native void slotSendData( int dummy);
	public static final int NoCommunication = 0;
	public static final int Stdin = 1;
	public static final int Stdout = 2;
	public static final int Stderr = 4;
	public static final int AllOutput = 6;
	public static final int All = 7;
	public static final int NoRead = 0;
	public static final int DontCare = 0;
	public static final int NotifyOnExit = 1;
	public static final int Block = 2;
}
