/***************************************************************************
                            KSycoca.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


 Read-only SYstem COnfiguration CAche
 
 See {@link KSycocaSignals} for signals emitted by KSycoca.

 See {@link KSycocaEventHandling} for event handlers to override in subclasses of KSycoca.

 @short 

*/
public class KSycoca extends QObject implements  DCOPObjectInterface {
	protected KSycoca(Class dummy){super((Class) null);}


/** 
 Read-only database
    
*/
	private native void newKSycoca();
	public KSycoca() {
		super((Class) null);
		newKSycoca();
	}
	protected native void finalize() throws InternalError;

/** 

 This is how factories get a stream to an entry
    
*/
	public native QDataStream findEntry( int offset, int type);

/** 

    
*/
	public native QDataStream findFactory( int identifier);

/** 

    
*/
	public native String kfsstnd_prefixes();

/** 

 The database contains all changes made _before_ this time and
 _might_ contain changes made after that.
    
*/
	public native int timeStamp();

/** 

    
*/
	public native void addFactory( int arg1);

/** 

*/
	public native boolean isBuilding();
//	public native k_dcop: /** * internal function for receiving kded/kbuildsycoca's signal, when the sycoca file changes */ void notifyDatabaseChanged( String[] arg1);

/** 
 Get or create the only instance of KSycoca (read-only)
    
*/
	public static native KSycoca self();

/** 
 Determine relative path for a .desktop file from a full path and a resource name
    
*/
	public static native String determineRelativePath( String _fullpath, String _resource);

/** 
 When you receive a "databaseChanged" signal, you can query here if
 a change has occured in a specific resource type.

*/
	public static native boolean isChanged( String type);

/** 

 Building database
    
*/
	private native void newKSycoca( boolean arg1);
	public KSycoca( boolean arg1) {
		super((Class) null);
		newKSycoca( arg1);
	}
	protected native boolean checkVersion( boolean abortOnError);
	protected native boolean checkVersion();
	protected native boolean openDatabase( boolean openDummyIfNotFound);
	protected native boolean openDatabase();
	protected native void closeDatabase();

        // From DCOPObjectInterface
	public native String objId();
/**
 Dispatches a message.

 Usually you want to use an IDL
 compiler to automatically generate an implementation for
 this function.

 If this function returns <code>false</code>, then {@link #processDynamic}
 is called.

 Note to implementators: remember to call the baseclasses
 implementation.

*/
	public native boolean process( String fun, byte[] data, String replyType, byte[] replyData);

/**
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #process} but
 you still want to dispatch some functions dynamically.
 Dynamically means that methods may appear and vanish
 during runtime.

*/
	public native boolean processDynamic( String fun, byte[] data, String replyType, byte[] replyData);

/**
 Returns the names of the interfaces, specific ones last. The
 functions gets reimplemented by the IDL compiler. If you don't
 use the IDL compiler, consider implementing this function
 manually if you want your object to be easily explorable.

*/
	public native ArrayList interfaces();

/**
 Returns the list of functions understood by the object. It gets
 reimplemented by the IDL compiler. If you don't use the IDL
 compiler, consider implementing this function manually if you
 want your object to be easily scriptable.

 Rationale: functions() allows an interpreter to do client-side
 type-casting properly.

 Note to implementators: remember to call the baseclasses
 implementation.

*/
	public native ArrayList functions();

/**
 Emit <code>signal</code> as DCOP signal from this object with <code>data</code> as
 arguments

*/
	public native void emitDCOPSignal( String signal, byte[] data);

/**
 Connect to a DCOP signal

*/
	public native boolean connectDCOPSignal( String sender, String senderObj, String signal, String slot, boolean Volatile);

/**
 Disconnect a DCOP signal

 A special case is when both sender & signal are empty. In this
 case all connections related to this object in the current client
 are disconnected. (Both connections from as well as to this object!)

*/
	public native boolean disconnectDCOPSignal( String sender, String senderObj, String signal, String slot);

/**

 {@link DCOPObjectProxy}

*/
	public static native boolean hasObject( String objId);

/**

 This function does not query the {@link DCOPObjectProxy}.

*/
	public static native DCOPObjectInterface find( String objId);

/**
 Creates an object id for the QObject <code>obj.</code> This is done
 using the {@link QObject#name} function.

*/
	public static native String objectName( QObject obj);

}
