/***************************************************************************
                            KURLRequester.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class is a widget showing a lineedit and a button, which invokes a
 filedialog. File completion is available in the lineedit.

 The defaults for the filedialog are to ask for one existing local file, i.e.
 KFileDialog.setMode( KFile.File | KFile.ExistingOnly | KFile.LocalOnly )
 The default filter is "", i.e. show all files, and the start directory is
 the current working directory, or the last directory where a file has been
 selected.

 You can change this behavior by obtaining a pointer to the dialog
 ({@link #fileDialog}) and calling the appropriate methods.

 See {@link KURLRequesterSignals} for signals emitted by KURLRequester.

 See {@link KURLRequesterEventHandling} for event handlers to override in subclasses of KURLRequester.

 @author Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A widget to request a filename/url from the user.
*/
public class KURLRequester extends QHBox  {
	protected KURLRequester(Class dummy){super((Class) null);}


/** 
 Constructs a KURLRequester widget

*/
	private native void newKURLRequester( QWidget parent, String name, boolean modal);
	public KURLRequester( QWidget parent, String name, boolean modal) {
		super((Class) null);
		newKURLRequester( parent, name, modal);
	}
	private native void newKURLRequester();
	public KURLRequester() {
		super((Class) null);
		newKURLRequester();
	}

/** 
 Constructs a KURLRequester widget with the default URL <code>url</code>

*/
	private native void newKURLRequester( String url, QWidget parent, String name, boolean modal);
	public KURLRequester( String url, QWidget parent, String name, boolean modal) {
		super((Class) null);
		newKURLRequester( url, parent, name, modal);
	}
	private native void newKURLRequester( String url);
	public KURLRequester( String url) {
		super((Class) null);
		newKURLRequester( url);
	}

/** 
 Special constructor, which creates a KURLRequester widget with a custom
 edit-widget. The edit-widget can be either a KComboBox or a KLineEdit
 (or inherited thereof). Note: for geometry management reasons, the
 edit-widget is reparented to have the KURLRequester as parent.

*/
	private native void newKURLRequester( QWidget editWidget, QWidget parent, String name, boolean modal);
	public KURLRequester( QWidget editWidget, QWidget parent, String name, boolean modal) {
		super((Class) null);
		newKURLRequester( editWidget, parent, name, modal);
	}
	private native void newKURLRequester( QWidget editWidget, QWidget parent);
	public KURLRequester( QWidget editWidget, QWidget parent) {
		super((Class) null);
		newKURLRequester( editWidget, parent);
	}

/** 
 Destructs the KURLRequester
     
*/
	protected native void finalize() throws InternalError;

/** 

*/
	public native String url();

/** 
 Enables/disables showing file:/ in the lineedit, when a local file has
 been selected in the filedialog or was set via {@link #setURL}.
 Default is false, not showing file:/

*/
	public native void setShowLocalProtocol( boolean b);

/** 

*/
	public native boolean showLocalProtocol();

/** 

*/
	public native KFileDialog fileDialog();

/** 

 It is provided so that you can e.g. set an own completion object
 (e.g. {@link KShellCompletion}) into it.
     
*/
	public native KLineEdit lineEdit();

/** 

*/
	public native KComboBox comboBox();

/** 

*/
	public native QPushButton button();

/** 

*/
	public native KURLCompletion completionObject();

/** 
 Sets the url in the lineedit to <code>url.</code> Depending on the state of
 {@link #showLocalProtocol}, file:/ on local files will be shown or not.
     
*/
	public native void setURL( String url);

/** 
 Clears the lineedit/combobox.
     
*/
	public native void clear();
	protected native void init();

/** 
 Called when the button is pressed to open the filedialog.
 Also called when {@link KStdAccel#Open} is pressed.
     
*/
	protected native void slotOpenDialog();
}
