/***************************************************************************
                            KWin.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Convenience access to certain properties and features of the
 window manager.

 This class is not supposed to be instantiated.  It exists mostly as
 a namespace for the static member functions.

 In KDE-2.0, communication with the window manger is done with the
 NET-protocol, a common window manager specification designed by
 various authors of X11 window managers (including those of the KDE
 project).  The full specification can be found in
 kdebase/kwin/wm-spec/

 To access features of the NET-protocol, use the classes NETRootInfo
 and NETWinInfo.

 The purpose of this class is to to provide easy access to the
 most-commonly used NET-features with a simpler, KDEish interface.

 In addition, it encapsulates KDE functionality not yet provided by
 the NET hints.  Currently that is invokeContextHelp() and
 setSystemTrayWindowFor() only.

 @author s Matthias Ettrich (ettrich@kde.org)

 @short Class for interaction with the windowmanager.

*/
public class  KWin implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KWin(Class dummy){}


/** 
 Set window win to be the active window.

 This is a request to the window manager. It may or may not be
 obeyed.
    
*/
	public static native void setActiveWindow( int win);

/** 
 Invoke interactive context help.
     
*/
	public static native void invokeContextHelp();

/** 
 Makes <code>trayWin</code> a system tray window for <code>forWin.</code>

 A system tray window serves as an icon replacement. It's
 displayed inside the panel's system tray.
     
*/
	public static native void setSystemTrayWindowFor( int trayWin, int forWin);

/** 
 Retrieves information about window <code>win.</code>
     
*/
	public static native int info( int win);

/** 
 Retrieves an icon for window <code>win.</code>

 If  <code>width</code> and <code>height</code> are specified, the best icon for the requested
 size is returned.

 If <code>scale</code> is true, the icon is smooth-scaled to have exactly
 the requested size.

     
*/
	public static native QPixmap icon( int win, int width, int height, boolean scale);
	public static native QPixmap icon( int win);

/** 
 Sets an <code>icon</code> and a  <code>miniIcon</code> on window <code>win</code>
     
*/
	public static native void setIcons( int win, QPixmap icon, QPixmap miniIcon);

/** 
 Sets the type of window <code>win</code> to <code>windowType.</code>

 Possible values are NET.Normal, NET.Desktop, NET.Dock,
 NET.Tool, NET.Menu, NET.Dialog or NET.Override (== no
 decoration frame)
     
*/
	public static native void setType( int win, int windowType);

/** 
 Sets the state of window <code>win</code> to <code>state.</code>

 Possible values are or'ed combinations of NET.Modal,
 NET.Sticky, NET.MaxVert, NET.MaxHoriz, NET.Shaded,
 NET.SkipTaskbar, NET.StaysOnTop, NET.SkipPager
     
*/
	public static native void setState( int win, long state);

/** 
 Clears the state of window <code>win</code> from <code>state.</code>

 Possible values are or'ed combinations of NET.Modal,
 NET.Sticky, NET.MaxVert, NET.MaxHoriz, NET.Shaded,
 NET.SkipTaskbar, NET.StaysOnTop, NET.SkipPager
     
*/
	public static native void clearState( int win, long state);

/** 
 Sets window <code>win</code> to be present on all virtual desktops if <code>is</code> true. Otherwise the window lives only on one single desktop.
     
*/
	public static native void setOnAllDesktops( int win, boolean b);

/** 
 Move window <code>win</code> to desktop <code>desktop.</code>
     
*/
	public static native void setOnDesktop( int win, int desktop);

/** 
 Sets the strut  of window <code>win</code> to <code>left</code>, @right, @top, @bottom.

     
*/
	public static native void setStrut( int win, int left, int right, int top, int bottom);

/** 
 Convienence function to access the current desktop.  See NETRootInfo.
     
*/
	public static native int currentDesktop();

/** 
 Convienence function to access the number of desktops. See
 NETRootInfo.
     
*/
	public static native int numberOfDesktops();

/** 
 Convienence function to set the current desktop to <code>desktop.</code>
 See NETRootInfo.
     
*/
	public static native void setCurrentDesktop( int desktop);

/** 
 Iconifies a window. Compatible to XIconifyWindow but has an
 additional parameter <code>animation.</code>

 {@link #deIconifyWindow}
     
*/
	public static native void iconifyWindow( int win, boolean animation);
	public static native void iconifyWindow( int win);

/** 
 DeIconifies a window. Compatible to XMapWindow but has an
 additional parameter <code>animation.</code>

 {@link #iconifyWindow}
     
*/
	public static native void deIconifyWindow( int win, boolean animation);
	public static native void deIconifyWindow( int win);

/** 

 Use {@link KStartupInfo#appStarted}
     
*/
	public static native void appStarted();
}
