/***************************************************************************
                            MainWindow.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A KPart-aware main window, whose user interface is described in XML.

 Inherit your main window from this class
 and don't forget to call {@link #setXMLFile} in the inherited constructor.

 It implements all internal interfaces in the case of a
 {@link KMainWindow} as host: the builder and servant interface (for menu
 merging).
 
 See {@link MainWindowSignals} for signals emitted by MainWindow.

 See {@link MainWindowEventHandling} for event handlers to override in subclasses of MainWindow.

 @short 
 A KPart-aware main window, whose user interface is described in XML.
*/
public class MainWindow extends KMainWindow implements  PartBaseInterface {
	protected MainWindow(Class dummy){super((Class) null);}


/** 
 Constructor, same signature as {@link KMainWindow}.
   
*/
	private native void newMainWindow( QWidget parent, String name, int f);
	public MainWindow( QWidget parent, String name, int f) {
		super((Class) null);
		newMainWindow( parent, name, f);
	}
	private native void newMainWindow( QWidget parent);
	public MainWindow( QWidget parent) {
		super((Class) null);
		newMainWindow( parent);
	}

/** 
 Compatibility Constructor, same signature as {@link KTMainWindow}.
   
*/
	private native void newMainWindow( String name, int f);
	public MainWindow( String name, int f) {
		super((Class) null);
		newMainWindow( name, f);
	}
	private native void newMainWindow();
	public MainWindow() {
		super((Class) null);
		newMainWindow();
	}

/** 
 Destructor.
   
*/
	protected native void finalize() throws InternalError;
	protected native void createShellGUI( boolean create);
	protected native void createShellGUI();

/** 
 Create the GUI (by merging the host's and the active part's)

 For this you need to connect this slot to the
 {@link KPartManager#activePartChanged} signal

*/
	protected native void createGUI( Part part);

/** 
 Called when the active part wants to change the statusbar message
 Reimplement if your mainwindow has a complex statusbar
 (with several items)
   
*/
	protected native void slotSetStatusBarText( String arg1);
	
	public native void setPartObject( QObject object);
	public native QObject partObject();

/**
 Set the instance ({@link KInstance}) for this part.

 Call this first in the inherited class constructor,
 because it loads the i18n catalogues.

*/
	public native void setInstance( KInstanceInterface instance);

/**
 Set the instance ({@link KInstance}) for this part.

 Call this first in the inherited class constructor,
 because it loads the i18n catalogues.

*/
	public native void setInstance( KInstanceInterface instance, boolean loadPlugins);
}
