/***************************************************************************
                            Section.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 A Section object manages one section of a configuration database.
  A configuration database consists of sections which in turn 
  consist of other sections (recursive definition) and 
  key-value-pairs. This file declares the Section class. An 
  object of Section manages exactly one section during its 
  lifetime. 
 @short  A Section object manages one section of a configuration database.
*/
public class  Section implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected Section(Class dummy){}


/**  Insert the spaces for indention the lines of this section when saving. 
*/
	protected native void insertIndentSpace( QTextStream file, int level);

/**  Check whether the string (one line of the file currently read) marks the
  beginning of a new subsection (usually [sectionname]). 
*/
	protected native boolean isBeginOfSection( String arg1);

/**  Check whether the string (one line of the file currently read) marks the
  end of a new subsection (usually [END]). 
*/
	protected native boolean isEndOfSection( String arg1);

/**  Extract the name of the section from the string.
  The string must contain the line that starts the section.

*/
	private native void newSection();
	public Section() {
		newSection();
	}

/**  Constructor that fills the keys with the given map entries. 
*/
	private native void newSection( KeyValueMap arg1);
	public Section( KeyValueMap arg1) {
		newSection( arg1);
	}

/**  Add an empty new section. 
*/
	protected native boolean add( String arg1);

/**  Add the section. 
*/
	protected native boolean add( String arg1, Section arg2);

/**  Search for the section, returning an iterator to it. 
*/
//	protected native boolean find( String arg1, StringSectionMap arg2);

/**  Search for the section, returning a pointer to the section object. 
*/
	protected native boolean find( String arg1, Section arg2);

/**  Remove this subsection. 
*/
	protected native boolean remove( String arg1);

/**  Return the key-value-pairs of this (!) section. 
*/
	protected native KeyValueMap getKeys();

/**  Save this section to the given output stream.
  Level is the position in section tree depth (the hierarchy level). 
  It is used for indenting.
   
*/
	protected native boolean save( QTextStream stream, int level);
	protected native boolean save( QTextStream stream);

/**  Read one section from the given input stream.
  The method does not expect the line that marks the begin of the 
  section. If finish is false, the code does also not except the 
  section to be ended with a line like [END]. 
*/
	protected native boolean readSection( QTextStream file, boolean finish);
	protected native boolean readSection( QTextStream file);

/**  Clears both subsections and keys. 
*/
	protected native boolean clear();

/**  Returns whether this section is empty. A section is empty if it has no
  subsections and no key-value-pairs. 
*/
	protected native boolean empty();

/**  Return an iterator to the beginning of the subsections map. 
*/
//	protected native StringSectionMap sectionsBegin();

/**  Return an iterator to the end of the subsections map. 
*/
//	protected native StringSectionMap sectionsEnd();

/**  Return the number of subsections. 
*/
	protected native int noOfSections();

        
}
