/***************************************************************************
                            URLArgs.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 URLArgs is a set of arguments bundled into a structure,
 to allow specifying how a URL should be opened by openURL().
 In other words, this is like arguments to openURL(), but without
 have to change the signature of openURL() (since openURL is a
 generic KParts method).
 The parts (with a browser extension) who care about urlargs will
 use those arguments, others will ignore them.

 This can also be used the other way round, when a part asks
 for a URL to be opened (with openURLRequest or createNewWindow).
 
 @short 
 URLArgs is a set of arguments bundled into a structure,
 to allow specifying how a URL should be opened by openURL().
*/
public class  URLArgs implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected URLArgs(Class dummy){}

	private native void newURLArgs();
	public URLArgs() {
		newURLArgs();
	}
	private native void newURLArgs( URLArgs args);
	public URLArgs( URLArgs args) {
		newURLArgs( args);
	}
	private native void newURLArgs( boolean reload, int xOffset, int yOffset, String serviceType);
	public URLArgs( boolean reload, int xOffset, int yOffset, String serviceType) {
		newURLArgs( reload, xOffset, yOffset, serviceType);
	}
	private native void newURLArgs( boolean reload, int xOffset, int yOffset);
	public URLArgs( boolean reload, int xOffset, int yOffset) {
		newURLArgs( reload, xOffset, yOffset);
	}
	protected native void finalize() throws InternalError;

/** 
 KHTML-specific field, header defining the type of the POST data.
   
*/
	public native void setContentType( String contentType);

/** 
 KHTML-specific field, header defining the type of the POST data.
   
*/
	public native String contentType();

/** 
 KHTML-specific field, whether to do a POST instead of a GET,
 for the next openURL
   
*/
	public native void setDoPost( boolean enable);

/** 
 KHTML-specific field, whether to do a POST instead of a GET,
 for the next openURL
   
*/
	public native boolean doPost();

/** 
 Whether to lock the history when opening the next URL.
 This is used during e.g. a redirection, to avoid a new entry
 in the history
   
*/
	public native void setLockHistory( boolean lock);
	public native boolean lockHistory();
}
