/***************************************************************************
                            KCompletionBox.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A little utility class for "completion-widgets", like KLineEdit or
 KComboBox. KCompletionBox is a listbox, displayed as a rectangle without
 any window-decoration, usually directly under the lineedit or combobox.
 It is filled with all possible matches for a completion, so the user
 can select the one he wants.

 It is used when KGlobalSettings.Completion == CompletionPopup.

 See {@link KCompletionBoxSignals} for signals emitted by KCompletionBox.

 See {@link KCompletionBoxEventHandling} for event handlers to override in subclasses of KCompletionBox.

 @author Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A helper widget for "completion-widgets" (KLineEdit, KComboBox)).
*/
public class KCompletionBox extends KListBox  {
	protected KCompletionBox(Class dummy){super((Class) null);}


/** 
 Constructs a KCompletionBox.

 Notice: the parent needs to be always null,
 so you can't specify it in the constructor. Because of that, Qt's
 auto-deletion does not take place, so you have to explicitly delete
 this widget when you don't need it anymore.

 The parent widget is used to give the focus back when pressing the
 up-button on the very first item.
     
*/
	private native void newKCompletionBox( QWidget parent, String name);
	public KCompletionBox( QWidget parent, String name) {
		super((Class) null);
		newKCompletionBox( parent, name);
	}
	private native void newKCompletionBox( QWidget parent);
	public KCompletionBox( QWidget parent) {
		super((Class) null);
		newKCompletionBox( parent);
	}

/** 
 Destroys the box
     
*/
	protected native void finalize() throws InternalError;
	public native QSize sizeHint();

/** 

*/
	public native ArrayList items();

/** 
 Adjusts the size of the box to fit the width of the parent given in the
 constructor and pops it up at the most appropriate place, relative to
 the parent.

 Depending on the screensize and the position of the parent, this may
 be a different place, however the default is to pop it up and the
 lower left corner of the parent.

 Make sure to hide() the box when appropriate.
     
*/
	public native void popup();

/** 
 Makes this widget (when visible) capture Tab-key events to traverse the
 items in the dropdown list.

 Default off, as it conflicts with the usual behavior of Tab to traverse
 widgets. It is useful for cases like Konqueror's Location Bar, though.

*/
	public native void setTabHandling( boolean enable);

/** 

 Default is false.

*/
	public native boolean isTabHandling();

/** 
 Sets the text to be emitted if the user chooses not to
 pick from the available matches.

 If the cancelled text is not set through this function, the
 {@link userCancelled} signal will not be emitted.

*/
	public native void setCancelledText( String arg1);

/** 

*/
	public native String cancelledText();

/** 
 Move the selection one line down or select the first item if nothing is selected yet.
     
*/
	public native void down();

/** 
 Move the selection one line up or select the first item if nothing is selected yet.
     
*/
	public native void up();

/** 
 Move the selection one page down.
     
*/
	public native void pageDown();

/** 
 Move the selection one page up.
     
*/
	public native void pageUp();

/** 
 Move the selection up to the first item.
     
*/
	public native void home();

/** 
 Move the selection down to the last item.
     
*/
	public native void end();

/** 
 Re-implemented for internal reasons.  API is unaffected.
     
*/
	public native void show();

/** 
 Re-implemented for internal reasons.  API is unaffected.
     
*/
	public native void hide();

/** 
 Reimplemented from KListBox to get events from the viewport (to hide
 this widget on mouse-click, Escape-presses, etc.
     
*/
	public native boolean eventFilter( QObject arg1, QEvent arg2);

/** 
 Called when an item was activated. Emits
 {@link #activated} with the item.
     
*/
	protected native void slotActivated( QListBoxItem arg1);
}
