/***************************************************************************
                            KConfig.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


Copyright (c) 2000 Matthias Elter

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


 See {@link KConfigSignals} for signals emitted by KConfig.

 See {@link KConfigEventHandling} for event handlers to override in subclasses of KConfig.

 @short 

*/
public class KConfig extends KConfigBase  {
	protected KConfig(Class dummy){super((Class) null);}


/** 
 Construct a KConfig object.

*/
	private native void newKConfig( String fileName, boolean bReadOnly, boolean bUseKDEGlobals, String resType);
	public KConfig( String fileName, boolean bReadOnly, boolean bUseKDEGlobals, String resType) {
		super((Class) null);
		newKConfig( fileName, bReadOnly, bUseKDEGlobals, resType);
	}
	private native void newKConfig();
	public KConfig() {
		super((Class) null);
		newKConfig();
	}

/** 
 Destructor.

 Writes back any dirty configuration entries, and destroys
 dynamically created objects.
   
*/
	protected native void finalize() throws InternalError;

/** 
 Clears all entries out of the <code>dirtyEntryMap</code>, so the
 values will not be written to disk on a later call to
 {@link #sync}.

*/
	public native void rollback( boolean bDeep);
	public native void rollback();

/** 

*/
	public native boolean hasGroup( String _pGroup);

/** 
 Retrieve a list of groups that are known.

*/
	public native ArrayList groupList();
	public native boolean hasKey( String pKey);

/** 
 Clear all internal data structures and then reread
 configuration information from disk.
   
*/
	public native void reparseConfiguration();

/** 
 Overloaded public functions.
   
*/
//	public native boolean hasGroup( String _pGroup);
//	public native boolean hasGroup( String _pGroup);
//	public native boolean hasKey( String pKey);

/** 
 Retrieve a map (tree) of the entries in the specified group.

 Do not use this function, the implementation / return type are
 subject to change.

   
*/
//	protected native KEntryMap internalEntryMap( String pGroup);

/** 
 Returns a copy of the internal map used to hold all entries.

 Do not use this function, the implementation / return type are
 subject to change.

   
*/
//	protected native KEntryMap internalEntryMap();

/** 
 Insert a key,value pair into the internal storage mechanism of
 the configuration object.

*/
	protected native void putData( KEntryKey _key, KEntry _data);

/** 
 Look up an entry in the config object's internal structure.

*/
	protected native KEntry lookupData( KEntryKey _key);
}
