/***************************************************************************
                            KEditListBox.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 An editable listbox

 This class provides a editable listbox ;-), this means
 a listbox which is accompanied by a line edit to enter new
 items into the listbox and pushbuttons to add and remove
 items from the listbox and two buttons to move items up and down.
 
 See {@link KEditListBoxSignals} for signals emitted by KEditListBox.

 See {@link KEditListBoxEventHandling} for event handlers to override in subclasses of KEditListBox.

 @short 
 An editable listbox

*/
public class KEditListBox extends QGroupBox  {
	protected KEditListBox(Class dummy){super((Class) null);}


/** 
 Create an editable listbox.

 If <code>checkAtEntering</code> is true, after every character you type
 in the line edit KEditListBox will enable or disable
 the Add-button, depending whether the current content of the
 line edit is already in the listbox. Maybe this can become a
 performance hit with large lists on slow machines.
 If <code>checkAtEntering</code> is false,
 it will be checked if you press the Add-button. It is not
 possible to enter items twice into the listbox.
       
*/
	private native void newKEditListBox( QWidget parent, String name, boolean checkAtEntering, int buttons);
	public KEditListBox( QWidget parent, String name, boolean checkAtEntering, int buttons) {
		super((Class) null);
		newKEditListBox( parent, name, checkAtEntering, buttons);
	}
	private native void newKEditListBox();
	public KEditListBox() {
		super((Class) null);
		newKEditListBox();
	}

/** 
 Create an editable listbox.

 The same as the other constructor, additionally it takes
 @title, which will be the title of the frame around the listbox.
       
*/
	private native void newKEditListBox( String title, QWidget parent, String name, boolean checkAtEntering, int buttons);
	public KEditListBox( String title, QWidget parent, String name, boolean checkAtEntering, int buttons) {
		super((Class) null);
		newKEditListBox( title, parent, name, checkAtEntering, buttons);
	}
	private native void newKEditListBox( String title);
	public KEditListBox( String title) {
		super((Class) null);
		newKEditListBox( title);
	}
	protected native void finalize() throws InternalError;

/** 
 Return a pointer to the embedded QListBox.
       
*/
	public native QListBox listBox();

/** 
 Return a pointer to the embedded QLineEdit.
       
*/
	public native KLineEdit lineEdit();

/** 
 Return a pointer to the Add button
       
*/
	public native QPushButton addButton();

/** 
 Return a pointer to the Remove button
       
*/
	public native QPushButton removeButton();

/** 
 Return a pointer to the Up button
       
*/
	public native QPushButton upButton();

/** 
 Return a pointer to the Down button
       
*/
	public native QPushButton downButton();

/** 
 See {@link QListBox#count}
       
*/
	public native int count();

/** 
 See {@link QListBox#insertStringList}
       
*/
	public native void insertStringList( String[] list, int index);
	public native void insertStringList( String[] list);

/** 
 See {@link QListBox#insertStringList}
       
*/
	public native void insertStrList( String[] list, int index);
	public native void insertStrList( String[] list);

/** 
 See {@link QListBox#insertStrList}
       
*/
//	public native void insertStrList( String[] list, int index);
//	public native void insertStrList( String[] list);

/** 
 See {@link QListBox#insertStrList}
       
*/
	public native void insertStrList( String list, int numStrings, int index);
	public native void insertStrList( String list);

/** 
 See {@link QListBox#insertItem}
       
*/
	public native void insertItem( String text, int index);
	public native void insertItem( String text);

/** 
 Clears both the listbox and the line edit.
       
*/
	public native void clear();

/** 
 See {@link QListBox#text}
       
*/
	public native String text( int index);

/** 
 See {@link QListBox#currentItem}
       
*/
	public native int currentItem();

/** 
 See {@link QListBox#currentText}
       
*/
	public native String currentText();

/** 

*/
	public native ArrayList items();
	protected native void moveItemUp();
	protected native void moveItemDown();
	protected native void addItem();
	protected native void removeItem();
	protected native void enableMoveButtons( int index);
	protected native void enableAddButton( String text);
	public static final int Add = 1;
	public static final int Remove = 2;
	public static final int UpDown = 4;
	public static final int All = Add|Remove|UpDown;
}
