/***************************************************************************
                            KIconView.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This Widget extends the functionality of QIconView to honor the system
 wide settings for Single Click/Double Click mode, Auto Selection and
 Change Cursor over Link.

 There is a new signal executed(). It gets connected to either
 {@link QIconView#clicked} or {@link QIconView#doubleClicked} depending on the KDE
 wide Single Click/Double Click settings. It is strongly recomended that
 you use this signal instead of the above mentioned. This way you dont
 need to care about the current settings.
 If you want to get informed when the user selects something connect to the
 {@link QIconView#selectionChanged} signal.

 See {@link KIconViewSignals} for signals emitted by KIconView.

 See {@link KIconViewEventHandling} for event handlers to override in subclasses of KIconView.

 @short A variant of QIconView that honors KDE's system-wide settings.

*/
public class KIconView extends QIconView  {
	protected KIconView(Class dummy){super((Class) null);}

	private native void newKIconView( QWidget parent, String name, int f);
	public KIconView( QWidget parent, String name, int f) {
		super((Class) null);
		newKIconView( parent, name, f);
	}
	private native void newKIconView();
	public KIconView() {
		super((Class) null);
		newKIconView();
	}
	protected native void finalize() throws InternalError;

/** 
 Sets the mode to Execute or Select.

 Default is Execute.
   
*/
	public native void setMode( int m);

/** 

*/
	public native int mode();

/** 
 Returns the index of <code>item</code> or -1 if <code>item</code> doesn't exist
 in this icon view.
   
*/
	public native int itemIndex( QIconViewItem item);
	protected native void emitExecute( QIconViewItem item, QPoint pos);
	protected native void slotOnItem( QIconViewItem item);
	protected native void slotOnViewport();
	protected native void slotSettingsChanged( int arg1);

/** 
 Auto selection happend.
   
*/
	protected native void slotAutoSelect();
	public static final int Execute = 0;
	public static final int Select = 1;
}
