package org.kde.koala;
import org.kde.qt.*;


/** {@link KShellProcess} emits these signals */
public interface KShellProcessSignals {

/** 
 Emitted after the process has terminated when
 the process was run in the <code>NotifyOnExit</code>  (==default option to
 {@link KShellProcess#start}) or the {@link Block} mode.

*/
	void processExited( KProcess proc );
	void destroyed();

/** 
 Emitted when output from the child process has
 been received on stdout.

 To actually get these signals, the respective communications link 
 (stdout/stderr) has to be turned on in {@link KShellProcess#start} and the 
 <code>NoRead</code> flag should have been passed.

 You will need to explicitly call resume() after your call to start()
 to begin processing data from the child process's stdout.  This is
 to ensure that this signal is not emitted when no one is connected
 to it, otherwise this signal will not be emitted.

 The data still has to be read from file descriptor <code>fd.</code>

*/
	void receivedStdout( int fd, int len );

/** 
 Emitted after all the data that has been
 specified by a prior call to {@link KShellProcess#writeStdin} has actually been
 written to the child process.

*/
	void wroteStdin( KProcess proc );

/** 
 Emitted, when output from the child process has
 been received on stderr.
 To actually get
 these signals, the respective communication link (stdout/stderr)
 has to be turned on in {@link KShellProcess#start}.

 You should copy the information contained in <code>buffer</code> to your private
 data structures before returning from this slot.
  
*/
	void receivedStderr( KProcess proc, String buffer, int buflen );
}

