/*
 *  This file is part of the KDE libraries
 *  Copyright (c) 2001 Michael Goffioul <goffioul@imec.be>
 *
 *  $Id: jobitem.h,v 1.2 2001/03/24 07:27:49 waba Exp $
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 **/

#ifndef JOBITEM_H
#define JOBITEM_H

#include <qlistview.h>
#include "kmobject.h"

class KMJob;

class JobItem : public QListViewItem, public KMObject
{
public:
	JobItem(QListView *parent, KMJob *job = 0);
	void init(KMJob *job);

	int jobID() const;
	KMJob* job() const;

private:
	KMJob	*m_job;
	int	m_ID;
};

inline int JobItem::jobID() const
{ return m_ID; }

inline KMJob* JobItem::job() const
{ return m_job; }

#endif
