#ifndef __KCM_LAYOUT_H__
#define __KCM_LAYOUT_H__


#include <kcmodule.h>
#include <kglobalaccel.h>

#include <qstring.h>
#include <qlistview.h>

#include "rules.h"

class OptionListItem : public QCheckListItem
{
public:

  OptionListItem(  OptionListItem *parent, const QString &text, Type tt,
      const QString &optionName );
  OptionListItem(  QListView *parent, const QString &text, Type tt,
      const QString &optionName );
  ~OptionListItem() {}

  QString optionName() const { return m_OptionName; }

  OptionListItem *findChildItem(  const QString& text );

protected:
  QString m_OptionName;
};

class LayoutConfigWidget;
class LayoutConfig : public KCModule
{
  Q_OBJECT

public:

  LayoutConfig(QWidget *parent = 0L, const char *name = 0L);
  virtual ~LayoutConfig();

  void load();
  void save();
  void defaults();

  void itemStateChanged(); // must be slot?

protected:
  QString createOptionString();

protected slots:

  void moveUp();
  void moveDown();
  void variantChanged();
  void latinChanged();
  void layoutSelChanged(QListViewItem *);
  void ruleChanged();
  void updateLayoutCommand();
  void updateOptionsCommand();
  void add();
  void remove();

  void changed();

private:

  enum SwitchMode { Global, Application, Window } switchMode;

  LayoutConfigWidget* widget;

  QDict<OptionListItem> m_optionGroups;
  QMap<QString, QString> m_variants;
  QDict<char> m_includes;
//  QString m_rule;
  KeyRules *m_rules;

  QWidget* makeOptionsTab();
  void updateStickyLimit();
  
  const QString itemVariant(QListViewItem *item);
};


#endif
