#!/usr/bin/env python

# Qt tutorial 6.

import sys
from qt import *


class LCDRange(QVBox):
    def __init__(self,parent=None,name=None):
        QVBox.__init__(self,parent,name)

        lcd = QLCDNumber(2,self,"lcd")
        slider = QSlider(Qt.Horizontal,self,"slider")
        slider.setRange(0,99)
        slider.setValue(0)
        self.connect(slider,SIGNAL("valueChanged(int)"),lcd,SLOT("display(int)"))


class MyWidget(QVBox):
    def __init__(self,parent=None,name=None):
        QVBox.__init__(self,parent,name)

        quit = QPushButton("Quit",self,"quit")
        quit.setFont(QFont("Times",18,QFont.Bold))

        self.connect(quit,SIGNAL("clicked()"),qApp,SLOT("quit()"))

        grid = QGrid(4,self)

        for c in range(4):
            for r in range(4):
                LCDRange(grid)


a = QApplication(sys.argv)

w = MyWidget()
a.setMainWidget(w)
w.show()
a.exec_loop()
