//Auto-generated by kalyptus. DO NOT EDIT.
namespace Plasma {
    using Plasma;
    using System;
    using Kimono;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  Applet provides several important roles for add-ons widgets in Plasma.
    ///  First, it is the base class for the plugin system and therefore is the
    ///  interface to applets for host applications. It also handles the life time
    ///  management of data engines (e.g. all data engines accessed via
    ///  Applet.DataEngine(string) are properly deref'd on Applet
    ///  destruction), background painting (allowing for consistent and complex
    ///  look and feel in just one line of code for applets), loading and starting
    ///  of scripting support for each applet, providing access to the associated
    ///  plasmoid package (if any) and access to configuration data.
    ///  See techbase.kde.org for tutorial on writing Applets using this class.
    ///   See <see cref="IAppletSignals"></see> for signals emitted by Applet
    /// </remarks>        <short> The base Applet class.</short>
    [SmokeClass("Plasma::Applet")]
    public class Applet : QGraphicsWidget, IDisposable {
        protected Applet(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Applet), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static Applet() {
            staticInterceptor = new SmokeInvocation(typeof(Applet), null);
        }
        /// <remarks>
        ///  Description on how draw a background for the applet
        ///          </remarks>        <short>    Description on how draw a background for the applet          </short>
        public enum BackgroundHint {
            NoBackground = 0,
            StandardBackground = 1,
            TranslucentBackground = 2,
            ShadowedBackground = 4,
            DefaultBackground = StandardBackground|ShadowedBackground,
        }
        public const int Type = (int) Plasma.ItemTypes.AppletType;
        [Q_PROPERTY("bool", "hasConfigurationInterface")]
        public bool HasConfigurationInterface {
            get { return (bool) interceptor.Invoke("hasConfigurationInterface", "hasConfigurationInterface()", typeof(bool)); }
            set { interceptor.Invoke("setHasConfigurationInterface$", "setHasConfigurationInterface(bool)", typeof(void), typeof(bool), value); }
        }
        [Q_PROPERTY("QString", "name")]
        public string Name {
            get { return (string) interceptor.Invoke("name", "name()", typeof(string)); }
        }
        [Q_PROPERTY("QString", "category")]
        public string Category {
            get { return (string) interceptor.Invoke("category", "category()", typeof(string)); }
        }
        [Q_PROPERTY("Plasma::ImmutabilityType", "immutability")]
        public Plasma.ImmutabilityType Immutability {
            get { return (Plasma.ImmutabilityType) interceptor.Invoke("immutability", "immutability()", typeof(Plasma.ImmutabilityType)); }
            set { interceptor.Invoke("setImmutability$", "setImmutability(Plasma::ImmutabilityType)", typeof(void), typeof(Plasma.ImmutabilityType), value); }
        }
        [Q_PROPERTY("bool", "hasFailedToLaunch")]
        public bool HasFailedToLaunch {
            get { return (bool) interceptor.Invoke("hasFailedToLaunch", "hasFailedToLaunch()", typeof(bool)); }
            set { interceptor.Invoke("setFailedToLaunch$", "setFailedToLaunch(bool)", typeof(void), typeof(bool), value); }
        }
        [Q_PROPERTY("bool", "configurationRequired")]
        public bool ConfigurationRequired {
            get { return (bool) interceptor.Invoke("configurationRequired", "configurationRequired()", typeof(bool)); }
            set { interceptor.Invoke("setConfigurationRequired$", "setConfigurationRequired(bool)", typeof(void), typeof(bool), value); }
        }
        [Q_PROPERTY("QRectF", "geometry")]
        public QRectF Geometry {
            get { return (QRectF) interceptor.Invoke("geometry", "geometry()", typeof(QRectF)); }
            set { interceptor.Invoke("setGeometry#", "setGeometry(QRectF)", typeof(void), typeof(QRectF), value); }
        }
        [Q_PROPERTY("bool", "shouldConserveResources")]
        public bool ShouldConserveResources {
            get { return (bool) interceptor.Invoke("shouldConserveResources", "shouldConserveResources()", typeof(bool)); }
        }
        /// <remarks>
        /// </remarks>        <return> the id of this applet
        ///          </return>
        ///         <short>   </short>
        public uint Id() {
            return (uint) interceptor.Invoke("id", "id() const", typeof(uint));
        }
        /// <remarks>
        ///  Returns the KConfigGroup to access the applets configuration.
        ///  This config object will write to an instance
        ///  specific config file named \<appletname\>\<instanceid\>rc
        ///  in the Plasma appdata directory.
        /// </remarks>        <short>    Returns the KConfigGroup to access the applets configuration.</short>
        public KConfigGroup Config() {
            return (KConfigGroup) interceptor.Invoke("config", "config() const", typeof(KConfigGroup));
        }
        /// <remarks>
        ///  Returns a config group with the name provided. This ensures
        ///  that the group name is properly namespaced to avoid collision
        ///  with other applets that may be sharing this config file
        /// <param> name="group" the name of the group to access
        /// </param></remarks>        <short>    Returns a config group with the name provided.</short>
        public KConfigGroup Config(string group) {
            return (KConfigGroup) interceptor.Invoke("config$", "config(const QString&) const", typeof(KConfigGroup), typeof(string), group);
        }
        /// <remarks>
        ///  Saves state information about this applet that will
        ///  be accessed when next instantiated in the restore(KConfigGroup&) method.
        ///  This method does not need to be reimplmented by Applet
        ///  subclasses, but can be useful for Applet specializations
        ///  (such as Containment) to do so.
        ///  Applet subclasses may instead want to reimplement saveState().
        /// </remarks>        <short>    Saves state information about this applet that will  be accessed when next instantiated in the restore(KConfigGroup&) method.</short>
        [SmokeMethod("save(KConfigGroup&) const")]
        public virtual void Save(KConfigGroup group) {
            interceptor.Invoke("save#", "save(KConfigGroup&) const", typeof(void), typeof(KConfigGroup), group);
        }
        /// <remarks>
        ///  Restores state information about this applet saved previously
        ///  in save(KConfigGroup&).
        ///  This method does not need to be reimplmented by Applet
        ///  subclasses, but can be useful for Applet specializations
        ///  (such as Containment) to do so.
        /// </remarks>        <short>    Restores state information about this applet saved previously  in save(KConfigGroup&).</short>
        [SmokeMethod("restore(KConfigGroup&)")]
        public virtual void Restore(KConfigGroup group) {
            interceptor.Invoke("restore#", "restore(KConfigGroup&)", typeof(void), typeof(KConfigGroup), group);
        }
        /// <remarks>
        ///  Returns a KConfigGroup object to be shared by all applets of this
        ///  type.
        ///  This config object will write to an applet-specific config object
        ///  named plasma_\<appletname\>rc in the local config directory.
        ///          </remarks>        <short>    Returns a KConfigGroup object to be shared by all applets of this  type.</short>
        public KConfigGroup GlobalConfig() {
            return (KConfigGroup) interceptor.Invoke("globalConfig", "globalConfig() const", typeof(KConfigGroup));
        }
        /// <remarks>
        ///  Returns the config skeleton object from this applet's package,
        ///  if any.
        /// </remarks>        <return> config skeleton object, or 0 if none
        /// </return>
        ///         <short>    Returns the config skeleton object from this applet's package,  if any.</short>
        public Plasma.ConfigXml ConfigScheme() {
            return (Plasma.ConfigXml) interceptor.Invoke("configScheme", "configScheme() const", typeof(Plasma.ConfigXml));
        }
        /// <remarks>
        ///  Loads the given DataEngine
        ///  Tries to load the data engine given by <code>name.</code>  Each engine is
        ///  only loaded once, and that instance is re-used on all subsequent
        ///  requests.
        ///  If the data engine was not found, an invalid data engine is returned
        ///  (see DataEngine.IsValid()).
        ///  Note that you should <em>not</em> delete the returned engine.
        /// <param> name="name" Name of the data engine to load
        /// </param></remarks>        <return> pointer to the data engine if it was loaded,
        ///          or an invalid data engine if the requested engine
        ///          could not be loaded
        ///          </return>
        ///         <short>    Loads the given DataEngine </short>
        public Plasma.DataEngine DataEngine(string name) {
            return (Plasma.DataEngine) interceptor.Invoke("dataEngine$", "dataEngine(const QString&) const", typeof(Plasma.DataEngine), typeof(string), name);
        }
        /// <remarks>
        ///  Accessor for the associated Package object if any.
        ///  Generally, only Plasmoids come in a Package.
        /// </remarks>        <return> the Package object, or 0 if none
        /// </return>
        ///         <short>    Accessor for the associated Package object if any.</short>
        public Plasma.Package Package() {
            return (Plasma.Package) interceptor.Invoke("package", "package() const", typeof(Plasma.Package));
        }
        /// <remarks>
        ///  Returns the view this widget is visible on
        ///          </remarks>        <short>    Returns the view this widget is visible on          </short>
        public QGraphicsView View() {
            return (QGraphicsView) interceptor.Invoke("view", "view() const", typeof(QGraphicsView));
        }
        /// <remarks>
        ///  Maps a QRect from a view's coordinates to local coordinates.
        /// <param> name="view" the view from which rect should be mapped
        /// </param><param> name="rect" the rect to be mapped
        ///          </param></remarks>        <short>    Maps a QRect from a view's coordinates to local coordinates.</short>
        public QRectF MapFromView(QGraphicsView view, QRect rect) {
            return (QRectF) interceptor.Invoke("mapFromView##", "mapFromView(const QGraphicsView*, const QRect&) const", typeof(QRectF), typeof(QGraphicsView), view, typeof(QRect), rect);
        }
        /// <remarks>
        ///  Maps a QRectF from local coordinates to a view's coordinates.
        /// <param> name="view" the view to which rect should be mapped
        /// </param><param> name="rect" the rect to be mapped
        ///          </param></remarks>        <short>    Maps a QRectF from local coordinates to a view's coordinates.</short>
        public QRect MapToView(QGraphicsView view, QRectF rect) {
            return (QRect) interceptor.Invoke("mapToView##", "mapToView(const QGraphicsView*, const QRectF&) const", typeof(QRect), typeof(QGraphicsView), view, typeof(QRectF), rect);
        }
        /// <remarks>
        ///  Reccomended position for a popup window like a menu or a tooltip
        ///  given its size
        /// <param> name="s" size of the popup
        /// </param></remarks>        <return> reccomended position
        ///          </return>
        ///         <short>    Reccomended position for a popup window like a menu or a tooltip  given its size </short>
        public QPoint PopupPosition(QSize s) {
            return (QPoint) interceptor.Invoke("popupPosition#", "popupPosition(const QSize&) const", typeof(QPoint), typeof(QSize), s);
        }
        /// <remarks>
        ///  Called when any of the geometry constraints have been updated.
        ///  This method calls constraintsEvent, which may be reimplemented,
        ///  once the Applet has been prepared for updating the constraints.
        /// <param> name="constraints" the type of constraints that were updated
        ///          </param></remarks>        <short>    Called when any of the geometry constraints have been updated.</short>
        public void UpdateConstraints(uint constraints) {
            interceptor.Invoke("updateConstraints$", "updateConstraints(Plasma::Constraints)", typeof(void), typeof(uint), constraints);
        }
        public void UpdateConstraints() {
            interceptor.Invoke("updateConstraints", "updateConstraints()", typeof(void));
        }
        /// <remarks>
        ///  Returns the current form factor the applet is being displayed in.
        /// </remarks>        <short>    Returns the current form factor the applet is being displayed in.</short>
        ///         <see> Plasma.FormFactor</see>
        [SmokeMethod("formFactor() const")]
        public virtual Plasma.FormFactor formFactor() {
            return (Plasma.FormFactor) interceptor.Invoke("formFactor", "formFactor() const", typeof(Plasma.FormFactor));
        }
        /// <remarks>
        ///  Returns the location of the scene which is displaying applet.
        /// </remarks>        <short>    Returns the location of the scene which is displaying applet.</short>
        ///         <see> Plasma.Location</see>
        [SmokeMethod("location() const")]
        public virtual Plasma.Location location() {
            return (Plasma.Location) interceptor.Invoke("location", "location() const", typeof(Plasma.Location));
        }
        /// <remarks>
        /// </remarks>        <return> the preferred aspect ratio mode for placement and resizing
        ///          </return>
        ///         <short>   </short>
        public Plasma.AspectRatioMode aspectRatioMode() {
            return (Plasma.AspectRatioMode) interceptor.Invoke("aspectRatioMode", "aspectRatioMode() const", typeof(Plasma.AspectRatioMode));
        }
        /// <remarks>
        ///  Sets the preferred aspect ratio mode for placement and resizing
        ///          </remarks>        <short>    Sets the preferred aspect ratio mode for placement and resizing          </short>
        public void SetAspectRatioMode(Plasma.AspectRatioMode arg1) {
            interceptor.Invoke("setAspectRatioMode$", "setAspectRatioMode(Plasma::AspectRatioMode)", typeof(void), typeof(Plasma.AspectRatioMode), arg1);
        }
        /// <remarks>
        ///  This method is called when the interface should be painted.
        /// <param> name="painter" the QPainter to use to do the paintiner
        /// </param><param> name="option" the style options object
        /// </param><param> name="contentsRect" the rect to paint within; automatically adjusted for
        ///                      the background, if any
        /// </param></remarks>        <short>    This method is called when the interface should be painted.</short>
        [SmokeMethod("paintInterface(QPainter*, const QStyleOptionGraphicsItem*, const QRect&)")]
        public virtual void PaintInterface(QPainter painter, QStyleOptionGraphicsItem option, QRect contentsRect) {
            interceptor.Invoke("paintInterface###", "paintInterface(QPainter*, const QStyleOptionGraphicsItem*, const QRect&)", typeof(void), typeof(QPainter), painter, typeof(QStyleOptionGraphicsItem), option, typeof(QRect), contentsRect);
        }
        /// <remarks>
        /// </remarks>        <return> the font currently set for this widget
        /// </return>
        ///         <short>   </short>
        public new QFont Font() {
            return (QFont) interceptor.Invoke("font", "font() const", typeof(QFont));
        }
        /// <remarks>
        ///  Returns the plugin name for the applet
        ///          </remarks>        <short>    Returns the plugin name for the applet          </short>
        public string PluginName() {
            return (string) interceptor.Invoke("pluginName", "pluginName() const", typeof(string));
        }
        /// <remarks>
        ///  Returns the icon related to this applet
        /// </remarks>        <short>    Returns the icon related to this applet </short>
        public string Icon() {
            return (string) interceptor.Invoke("icon", "icon() const", typeof(string));
        }
        [SmokeMethod("paintWindowFrame(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)")]
        public override void PaintWindowFrame(QPainter painter, QStyleOptionGraphicsItem option, QWidget widget) {
            interceptor.Invoke("paintWindowFrame###", "paintWindowFrame(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)", typeof(void), typeof(QPainter), painter, typeof(QStyleOptionGraphicsItem), option, typeof(QWidget), widget);
        }
        /// <remarks>
        ///  Returns a list of context-related QAction instances.
        ///  This is used e.g. within the \a DesktopView to display a
        ///  contextmenu.
        /// </remarks>        <return> A list of actions. The default implementation returns an
        ///          empty list.
        /// </return>
        ///         <short>    Returns a list of context-related QAction instances.</short>
        [SmokeMethod("contextualActions()")]
        public virtual List<QAction> ContextualActions() {
            return (List<QAction>) interceptor.Invoke("contextualActions", "contextualActions()", typeof(List<QAction>));
        }
        /// <remarks>
        ///  Returns the QAction with the given name from our collection
        ///          </remarks>        <short>    Returns the QAction with the given name from our collection          </short>
        public QAction Action(string name) {
            return (QAction) interceptor.Invoke("action$", "action(QString) const", typeof(QAction), typeof(string), name);
        }
        /// <remarks>
        ///  Adds the action to our collection under the given name
        ///          </remarks>        <short>    Adds the action to our collection under the given name          </short>
        public void AddAction(string name, QAction action) {
            interceptor.Invoke("addAction$#", "addAction(QString, QAction*)", typeof(void), typeof(string), name, typeof(QAction), action);
        }
        /// <remarks>
        ///  Sets the BackgroundHints for this applet @see BackgroundHint
        /// <param> name="hints" the BackgroundHint combination for this applet
        ///          </param></remarks>        <short>    Sets the BackgroundHints for this applet @see BackgroundHint </short>
        public void SetBackgroundHints(uint hints) {
            interceptor.Invoke("setBackgroundHints$", "setBackgroundHints(const Plasma::Applet::BackgroundHints)", typeof(void), typeof(uint), hints);
        }
        /// <remarks>
        /// </remarks>        <return> BackgroundHints flags combination telling if the standard background is shown
        ///          and if it has a drop shadow
        ///          </return>
        ///         <short>   </short>
        public uint BackgroundHints() {
            return (uint) interceptor.Invoke("backgroundHints", "backgroundHints() const", typeof(uint));
        }
        /// <remarks>
        /// </remarks>        <return> true if this Applet is currently being used as a Containment, false otherwise
        ///          </return>
        ///         <short>   </short>
        public bool IsContainment() {
            return (bool) interceptor.Invoke("isContainment", "isContainment() const", typeof(bool));
        }
        /// <remarks>
        /// </remarks>        <return> a rect of the applet in screen coordinates.
        ///          </return>
        ///         <short>   </short>
        public QRect ScreenRect() {
            return (QRect) interceptor.Invoke("screenRect", "screenRect() const", typeof(QRect));
        }
        /// <remarks>
        ///  Reimplemented from QGraphicsItem
        /// </remarks>        <short>    Reimplemented from QGraphicsItem </short>
        [SmokeMethod("type() const")]
        public override int type() {
            return (int) interceptor.Invoke("type", "type() const", typeof(int));
        }
        /// <remarks>
        /// </remarks>        <return> the Containment, if any, this applet belongs to
        /// </return>
        ///         <short>   </short>
        public Plasma.Containment Containment() {
            return (Plasma.Containment) interceptor.Invoke("containment", "containment() const", typeof(Plasma.Containment));
        }
        /// <remarks>
        ///  Sets the global shorcut to associate with this widget.
        ///          </remarks>        <short>    Sets the global shorcut to associate with this widget.</short>
        public void SetGlobalShortcut(KShortcut shortcut) {
            interceptor.Invoke("setGlobalShortcut#", "setGlobalShortcut(const KShortcut&)", typeof(void), typeof(KShortcut), shortcut);
        }
        /// <remarks>
        /// </remarks>        <return> the global shortcut associated with this wiget, or
        ///  an empty shortcut if no global shortcut is associated.
        ///          </return>
        ///         <short>   </short>
        public KShortcut GlobalShortcut() {
            return (KShortcut) interceptor.Invoke("globalShortcut", "globalShortcut() const", typeof(KShortcut));
        }
        /// <remarks>
        ///  associate actions with this widget, including ones added after this call.
        ///  needed to make keyboard shortcuts work.
        ///          </remarks>        <short>    associate actions with this widget, including ones added after this call.</short>
        [SmokeMethod("addAssociatedWidget(QWidget*)")]
        public virtual void AddAssociatedWidget(QWidget widget) {
            interceptor.Invoke("addAssociatedWidget#", "addAssociatedWidget(QWidget*)", typeof(void), typeof(QWidget), widget);
        }
        /// <remarks>
        ///  un-associate actions from this widget, including ones added after this call.
        ///  needed to make keyboard shortcuts work.
        ///          </remarks>        <short>    un-associate actions from this widget, including ones added after this call.</short>
        [SmokeMethod("removeAssociatedWidget(QWidget*)")]
        public virtual void RemoveAssociatedWidget(QWidget widget) {
            interceptor.Invoke("removeAssociatedWidget#", "removeAssociatedWidget(QWidget*)", typeof(void), typeof(QWidget), widget);
        }
        /// <remarks>
        /// <param> name="parent" the QGraphicsItem this applet is parented to
        /// </param><param> name="serviceId" the name of the .desktop file containing the
        ///       information about the widget
        /// </param><param> name="appletId" a unique id used to differentiate between multiple
        ///       instances of the same Applet type
        ///          </param></remarks>        <short>   </short>
        public Applet(IQGraphicsItem parent, string serviceId, uint appletId) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Applet#$$", "Applet(QGraphicsItem*, const QString&, uint)", typeof(void), typeof(IQGraphicsItem), parent, typeof(string), serviceId, typeof(uint), appletId);
        }
        public Applet(IQGraphicsItem parent, string serviceId) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Applet#$", "Applet(QGraphicsItem*, const QString&)", typeof(void), typeof(IQGraphicsItem), parent, typeof(string), serviceId);
        }
        public Applet(IQGraphicsItem parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Applet#", "Applet(QGraphicsItem*)", typeof(void), typeof(IQGraphicsItem), parent);
        }
        public Applet() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Applet", "Applet()", typeof(void));
        }
        /// <remarks>
        ///  Sets the immutability type for this applet (not immutable, user immutable or system immutable)
        ///  @arg immutable the new immutability type of this applet
        ///          </remarks>        <short>    Sets the immutability type for this applet (not immutable, user immutable or system immutable)  @arg immutable the new immutability type of this applet          </short>
        [Q_SLOT("void setImmutability(ImmutabilityType)")]
        public void SetImmutability(Plasma.ImmutabilityType immutable) {
            interceptor.Invoke("setImmutability$", "setImmutability(const Plasma::ImmutabilityType)", typeof(void), typeof(Plasma.ImmutabilityType), immutable);
        }
        /// <remarks>
        ///  Destroys the applet; it will be removed nicely and deleted.
        ///  Its configuration will also be deleted.
        ///          </remarks>        <short>    Destroys the applet; it will be removed nicely and deleted.</short>
        [Q_SLOT("void destroy()")]
        [SmokeMethod("destroy()")]
        public virtual void Destroy() {
            interceptor.Invoke("destroy", "destroy()", typeof(void));
        }
        /// <remarks>
        ///  Lets the user interact with the plasmoid options.
        ///  Called when the user selects the configure entry
        ///  from the context menu.
        ///  Unless there is good reason for overriding this method,
        ///  Applet subclasses should actually override createConfigurationInterface
        ///  instead. A good example of when this isn't plausible is
        ///  when using a dialog prepared by another library, such
        ///  as KPropertiesDialog from libkfile.
        ///          </remarks>        <short>    Lets the user interact with the plasmoid options.</short>
        [Q_SLOT("void showConfigurationInterface()")]
        [SmokeMethod("showConfigurationInterface()")]
        public virtual void ShowConfigurationInterface() {
            interceptor.Invoke("showConfigurationInterface", "showConfigurationInterface()", typeof(void));
        }
        /// <remarks>
        ///  Causes this applet to raise above all other applets.
        ///          </remarks>        <short>    Causes this applet to raise above all other applets.</short>
        [Q_SLOT("void raise()")]
        public void Raise() {
            interceptor.Invoke("raise", "raise()", typeof(void));
        }
        /// <remarks>
        ///  Causes this applet to lower below all the other applets.
        ///          </remarks>        <short>    Causes this applet to lower below all the other applets.</short>
        [Q_SLOT("void lower()")]
        public void Lower() {
            interceptor.Invoke("lower", "lower()", typeof(void));
        }
        /// <remarks>
        ///  Sends all pending contraints updates to the applet. Will usually
        ///  be called automatically, but can also be called manually if needed.
        ///          </remarks>        <short>    Sends all pending contraints updates to the applet.</short>
        [Q_SLOT("void flushPendingConstraintsEvents()")]
        public void FlushPendingConstraintsEvents() {
            interceptor.Invoke("flushPendingConstraintsEvents", "flushPendingConstraintsEvents()", typeof(void));
        }
        /// <remarks>
        ///  This method is called once the applet is loaded and added to a Corona.
        ///  If the applet requires a QGraphicsScene or has an particularly intensive
        ///  set of initialization routines to go through, consider implementing it
        ///  in this method instead of the constructor.
        /// </remarks>        <short>    This method is called once the applet is loaded and added to a Corona.</short>
        [Q_SLOT("void init()")]
        [SmokeMethod("init()")]
        public virtual void Init() {
            interceptor.Invoke("init", "init()", typeof(void));
        }
        /// <remarks>
        ///  This constructor is to be used with the plugin loading systems
        ///  found in KPluginInfo and KService. The argument list is expected
        ///  to have two elements: the KService service ID for the desktop entry
        ///  and an applet ID which must be a base 10 number.
        /// <param> name="parent" a QObject parent; you probably want to pass in 0
        /// </param><param> name="args" a list of strings containing two entries: the service id
        ///       and the applet id
        ///          </param></remarks>        <short>    This constructor is to be used with the plugin loading systems  found in KPluginInfo and KService.</short>
        public Applet(QObject parent, List<QVariant> args) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Applet#?", "Applet(QObject*, const QList<QVariant>&)", typeof(void), typeof(QObject), parent, typeof(List<QVariant>), args);
        }
        /// <remarks>
        ///  Call this method when the applet fails to launch properly. An
        ///  optional reason can be provided.
        ///  Not that all children items will be deleted when this method is
        ///  called. If you have pointers to these items, you will need to
        ///  reset them after calling this method.
        /// <param> name="failed" true when the applet failed, false when it succeeded
        /// </param><param> name="reason" an optional reason to show the user why the applet
        ///                failed to launch
        /// </param></remarks>        <short>    Call this method when the applet fails to launch properly.</short>
        protected void SetFailedToLaunch(bool failed, string reason) {
            interceptor.Invoke("setFailedToLaunch$$", "setFailedToLaunch(bool, const QString&)", typeof(void), typeof(bool), failed, typeof(string), reason);
        }
        protected void SetFailedToLaunch(bool failed) {
            interceptor.Invoke("setFailedToLaunch$", "setFailedToLaunch(bool)", typeof(void), typeof(bool), failed);
        }
        /// <remarks>
        ///  When called, the Applet should write any information needed as part
        ///  of the Applet's running state to the configuration object in config()
        ///  and/or globalConfig().
        ///  Applets that always sync their settings/state with the config
        ///  objects when these settings/states change do not need to reimplement
        ///  this method.
        /// </remarks>        <short>    When called, the Applet should write any information needed as part  of the Applet's running state to the configuration object in config()  and/or globalConfig().</short>
        [SmokeMethod("saveState(KConfigGroup&) const")]
        protected virtual void SaveState(KConfigGroup config) {
            interceptor.Invoke("saveState#", "saveState(KConfigGroup&) const", typeof(void), typeof(KConfigGroup), config);
        }
        /// <remarks>
        ///  When the applet needs to be configured before being usable, this
        ///  method can be called to show a standard interface prompting the user
        ///  to configure the applet
        ///  Not that all children items will be deleted when this method is
        ///  called. If you have pointers to these items, you will need to
        ///  reset them after calling this method.
        /// <param> name="needsConfiguring" true if the applet needs to be configured,
        ///                          or false if it doesn't
        ///          </param></remarks>        <short>    When the applet needs to be configured before being usable, this  method can be called to show a standard interface prompting the user  to configure the applet </short>
        protected void SetConfigurationRequired(bool needsConfiguring, string reason) {
            interceptor.Invoke("setConfigurationRequired$$", "setConfigurationRequired(bool, const QString&)", typeof(void), typeof(bool), needsConfiguring, typeof(string), reason);
        }
        protected void SetConfigurationRequired(bool needsConfiguring) {
            interceptor.Invoke("setConfigurationRequired$", "setConfigurationRequired(bool)", typeof(void), typeof(bool), needsConfiguring);
        }
        /// <remarks>
        ///  Reimplement this method so provide a configuration interface,
        ///  parented to the supplied widget. Ownership of the widgets is passed
        ///  to the parent widget.
        /// <param> name="parent" the dialog which is the parent of the configuration
        ///                widgets
        ///          </param></remarks>        <short>    Reimplement this method so provide a configuration interface,  parented to the supplied widget.</short>
        [SmokeMethod("createConfigurationInterface(KConfigDialog*)")]
        protected virtual void CreateConfigurationInterface(KConfigDialog parent) {
            interceptor.Invoke("createConfigurationInterface#", "createConfigurationInterface(KConfigDialog*)", typeof(void), typeof(KConfigDialog), parent);
        }
        /// <remarks>
        ///  Sets whether or not this Applet is acting as a Containment
        ///          </remarks>        <short>    Sets whether or not this Applet is acting as a Containment          </short>
        protected void SetIsContainment(bool isContainment) {
            interceptor.Invoke("setIsContainment$", "setIsContainment(bool)", typeof(void), typeof(bool), isContainment);
        }
        /// <remarks>
        ///  Called when any of the geometry constraints have been updated.
        ///  This is always called prior to painting and should be used as an
        ///  opportunity to layout the widget, calculate sizings, etc.
        ///  Do not call update() from this method; an update() will be triggered
        ///  at the appropriate time for the applet.
        /// <param> name="constraints" the type of constraints that were updated
        ///  @property constraint
        ///          </param></remarks>        <short>    Called when any of the geometry constraints have been updated.</short>
        [SmokeMethod("constraintsEvent(Plasma::Constraints)")]
        protected virtual void ConstraintsEvent(uint constraints) {
            interceptor.Invoke("constraintsEvent$", "constraintsEvent(Plasma::Constraints)", typeof(void), typeof(uint), constraints);
        }
        /// <remarks>
        ///  Register the widgets that manage mouse clicks but you still want
        ///  to be able to drag the applet around when holding the mouse pointer
        ///  on that widget.
        ///  Calling this results in an eventFilter being places on the widget.
        /// <param> name="item" the item to watch for mouse move
        ///          </param></remarks>        <short>    Register the widgets that manage mouse clicks but you still want  to be able to drag the applet around when holding the mouse pointer  on that widget.</short>
        protected void RegisterAsDragHandle(IQGraphicsItem item) {
            interceptor.Invoke("registerAsDragHandle#", "registerAsDragHandle(QGraphicsItem*)", typeof(void), typeof(IQGraphicsItem), item);
        }
        /// <remarks>
        ///  Unregister a widget registered with registerAsDragHandle.
        /// <param> name="item" the item to unregister
        ///          </param></remarks>        <short>    Unregister a widget registered with registerAsDragHandle.</short>
        protected void UnregisterAsDragHandle(IQGraphicsItem item) {
            interceptor.Invoke("unregisterAsDragHandle#", "unregisterAsDragHandle(QGraphicsItem*)", typeof(void), typeof(IQGraphicsItem), item);
        }
        /// <remarks>
        /// <param> name="item" the item to look for if it is registered or not
        /// </param></remarks>        <return> true if it is registered, false otherwise
        ///          </return>
        ///         <short>   </short>
        protected bool IsRegisteredAsDragHandle(IQGraphicsItem item) {
            return (bool) interceptor.Invoke("isRegisteredAsDragHandle#", "isRegisteredAsDragHandle(QGraphicsItem*)", typeof(bool), typeof(IQGraphicsItem), item);
        }
        /// <remarks>
        /// </remarks>        <short>   </short>
        [SmokeMethod("eventFilter(QObject*, QEvent*)")]
        protected new virtual bool EventFilter(QObject o, QEvent e) {
            return (bool) interceptor.Invoke("eventFilter##", "eventFilter(QObject*, QEvent*)", typeof(bool), typeof(QObject), o, typeof(QEvent), e);
        }
        /// <remarks>
        ///          </remarks>        <short>   </short>
        [SmokeMethod("sceneEventFilter(QGraphicsItem*, QEvent*)")]
        protected override bool SceneEventFilter(IQGraphicsItem watched, QEvent arg2) {
            return (bool) interceptor.Invoke("sceneEventFilter##", "sceneEventFilter(QGraphicsItem*, QEvent*)", typeof(bool), typeof(IQGraphicsItem), watched, typeof(QEvent), arg2);
        }
        /// <remarks>
        ///          </remarks>        <short>   </short>
        [SmokeMethod("mouseMoveEvent(QGraphicsSceneMouseEvent*)")]
        protected override void MouseMoveEvent(QGraphicsSceneMouseEvent arg1) {
            interceptor.Invoke("mouseMoveEvent#", "mouseMoveEvent(QGraphicsSceneMouseEvent*)", typeof(void), typeof(QGraphicsSceneMouseEvent), arg1);
        }
        /// <remarks>
        ///          </remarks>        <short>   </short>
        [SmokeMethod("mousePressEvent(QGraphicsSceneMouseEvent*)")]
        protected override void MousePressEvent(QGraphicsSceneMouseEvent arg1) {
            interceptor.Invoke("mousePressEvent#", "mousePressEvent(QGraphicsSceneMouseEvent*)", typeof(void), typeof(QGraphicsSceneMouseEvent), arg1);
        }
        /// <remarks>
        ///  Reimplemented from QGraphicsItem
        ///          </remarks>        <short>    Reimplemented from QGraphicsItem          </short>
        [SmokeMethod("focusInEvent(QFocusEvent*)")]
        protected override void FocusInEvent(QFocusEvent arg1) {
            interceptor.Invoke("focusInEvent#", "focusInEvent(QFocusEvent*)", typeof(void), typeof(QFocusEvent), arg1);
        }
        /// <remarks>
        ///  Reimplemented from QGraphicsItem
        ///          </remarks>        <short>    Reimplemented from QGraphicsItem          </short>
        [SmokeMethod("resizeEvent(QGraphicsSceneResizeEvent*)")]
        protected override void ResizeEvent(QGraphicsSceneResizeEvent arg1) {
            interceptor.Invoke("resizeEvent#", "resizeEvent(QGraphicsSceneResizeEvent*)", typeof(void), typeof(QGraphicsSceneResizeEvent), arg1);
        }
        /// <remarks>
        ///  Reimplemented from QGraphicsItem
        ///          </remarks>        <short>    Reimplemented from QGraphicsItem          </short>
        [SmokeMethod("itemChange(QGraphicsItem::GraphicsItemChange, const QVariant&)")]
        protected override QVariant ItemChange(QGraphicsItem.GraphicsItemChange change, QVariant value) {
            return (QVariant) interceptor.Invoke("itemChange$#", "itemChange(QGraphicsItem::GraphicsItemChange, const QVariant&)", typeof(QVariant), typeof(QGraphicsItem.GraphicsItemChange), change, typeof(QVariant), value);
        }
        /// <remarks>
        ///  Reimplemented from QGraphicsItem
        ///          </remarks>        <short>    Reimplemented from QGraphicsItem          </short>
        [SmokeMethod("sceneEvent(QEvent*)")]
        protected override bool SceneEvent(QEvent arg1) {
            return (bool) interceptor.Invoke("sceneEvent#", "sceneEvent(QEvent*)", typeof(bool), typeof(QEvent), arg1);
        }
        /// <remarks>
        ///  Reimplemented from QGraphicsItem
        ///          </remarks>        <short>    Reimplemented from QGraphicsItem          </short>
        [SmokeMethod("shape() const")]
        protected new virtual QPainterPath Shape() {
            return (QPainterPath) interceptor.Invoke("shape", "shape() const", typeof(QPainterPath));
        }
        /// <remarks>
        ///  Reimplemented from QGraphicsLayoutItem
        ///          </remarks>        <short>    Reimplemented from QGraphicsLayoutItem          </short>
        [SmokeMethod("sizeHint(Qt::SizeHint, const QSizeF&) const")]
        public override QSizeF SizeHint(Qt.SizeHint which, QSizeF constraint) {
            return (QSizeF) interceptor.Invoke("sizeHint$#", "sizeHint(Qt::SizeHint, const QSizeF&) const", typeof(QSizeF), typeof(Qt.SizeHint), which, typeof(QSizeF), constraint);
        }
        [SmokeMethod("sizeHint(Qt::SizeHint) const")]
        protected override QSizeF SizeHint(Qt.SizeHint which) {
            return (QSizeF) interceptor.Invoke("sizeHint$", "sizeHint(Qt::SizeHint) const", typeof(QSizeF), typeof(Qt.SizeHint), which);
        }
        /// <remarks>
        ///  Reimplemented from QObject
        ///           </remarks>        <short>    Reimplemented from QObject           </short>
        [SmokeMethod("timerEvent(QTimerEvent*)")]
        protected override void TimerEvent(QTimerEvent arg1) {
            interceptor.Invoke("timerEvent#", "timerEvent(QTimerEvent*)", typeof(void), typeof(QTimerEvent), arg1);
        }
        ~Applet() {
            interceptor.Invoke("~Applet", "~Applet()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~Applet", "~Applet()", typeof(void));
        }
        /// <remarks>
        /// </remarks>        <return> a package structure representing a Theme
        ///          </return>
        ///         <short>   </short>
        public static Plasma.PackageStructure PackageStructure() {
            return (Plasma.PackageStructure) staticInterceptor.Invoke("packageStructure", "packageStructure()", typeof(Plasma.PackageStructure));
        }
        /// <remarks>
        ///  Returns a list of all known applets.
        /// <param> name="category" Only applets matchin this category will be returned.
        ///                  Useful in conjunction with knownCategories.
        ///                  If "Misc" is passed in, then applets without a
        ///                  Categories= entry are also returned.
        ///                  If an empty string is passed in, all applets are
        ///                  returned.
        /// </param><param> name="parentApp" the application to filter applets on. Uses the
        ///                   X-KDE-ParentApp entry (if any) in the plugin info.
        ///                   The default value of string() will result in a
        ///                   list containing only applets not specifically
        ///                   registered to an application.
        /// </param></remarks>        <return> list of applets
        /// </return>
        ///         <short>    Returns a list of all known applets.</short>
        public static List<KPluginInfo> ListAppletInfo(string category, string parentApp) {
            return (List<KPluginInfo>) staticInterceptor.Invoke("listAppletInfo$$", "listAppletInfo(const QString&, const QString&)", typeof(List<KPluginInfo>), typeof(string), category, typeof(string), parentApp);
        }
        public static List<KPluginInfo> ListAppletInfo(string category) {
            return (List<KPluginInfo>) staticInterceptor.Invoke("listAppletInfo$", "listAppletInfo(const QString&)", typeof(List<KPluginInfo>), typeof(string), category);
        }
        public static List<KPluginInfo> ListAppletInfo() {
            return (List<KPluginInfo>) staticInterceptor.Invoke("listAppletInfo", "listAppletInfo()", typeof(List<KPluginInfo>));
        }
        /// <remarks>
        ///  Returns a list of all known applets associated with a certain mimetype.
        /// </remarks>        <return> list of applets
        /// </return>
        ///         <short>    Returns a list of all known applets associated with a certain mimetype.</short>
        public static List<KPluginInfo> ListAppletInfoForMimetype(string mimetype) {
            return (List<KPluginInfo>) staticInterceptor.Invoke("listAppletInfoForMimetype$", "listAppletInfoForMimetype(const QString&)", typeof(List<KPluginInfo>), typeof(string), mimetype);
        }
        /// <remarks>
        ///  Returns a list of all the categories used by
        ///  installed applets.
        /// <param> name="parentApp" the application to filter applets on. Uses the
        ///                   X-KDE-ParentApp entry (if any) in the plugin info.
        ///                   The default value of string() will result in a
        ///                   list containing only applets not specifically
        ///                   registered to an application.
        /// </param><param> name="visibleOnly" true if it should only return applets that are marked as visible
        ///          </param></remarks>        <return> list of categories
        /// </return>
        ///         <short>    Returns a list of all the categories used by  installed applets.</short>
        public static List<string> ListCategories(string parentApp, bool visibleOnly) {
            return (List<string>) staticInterceptor.Invoke("listCategories$$", "listCategories(const QString&, bool)", typeof(List<string>), typeof(string), parentApp, typeof(bool), visibleOnly);
        }
        public static List<string> ListCategories(string parentApp) {
            return (List<string>) staticInterceptor.Invoke("listCategories$", "listCategories(const QString&)", typeof(List<string>), typeof(string), parentApp);
        }
        public static List<string> ListCategories() {
            return (List<string>) staticInterceptor.Invoke("listCategories", "listCategories()", typeof(List<string>));
        }
        /// <remarks>
        ///  Attempts to load an applet
        ///  Returns a pointer to the applet if successful.
        ///  The caller takes responsibility for the applet, including
        ///  deleting it when no longer needed.
        /// <param> name="name" the plugin name, as returned by KPluginInfo.PluginName()
        /// </param><param> name="appletId" unique ID to assign the applet, or zero to have one
        ///         assigned automatically.
        /// </param><param> name="args" to send the applet extra arguments
        /// </param></remarks>        <return> a pointer to the loaded applet, or 0 on load failure
        /// </return>
        ///         <short>    Attempts to load an applet </short>
        public static Plasma.Applet Load(string name, uint appletId, List<QVariant> args) {
            return (Plasma.Applet) staticInterceptor.Invoke("load$$?", "load(const QString&, uint, const QList<QVariant>&)", typeof(Plasma.Applet), typeof(string), name, typeof(uint), appletId, typeof(List<QVariant>), args);
        }
        public static Plasma.Applet Load(string name, uint appletId) {
            return (Plasma.Applet) staticInterceptor.Invoke("load$$", "load(const QString&, uint)", typeof(Plasma.Applet), typeof(string), name, typeof(uint), appletId);
        }
        public static Plasma.Applet Load(string name) {
            return (Plasma.Applet) staticInterceptor.Invoke("load$", "load(const QString&)", typeof(Plasma.Applet), typeof(string), name);
        }
        /// <remarks>
        ///  Attempts to load an applet
        ///  Returns a pointer to the applet if successful.
        ///  The caller takes responsibility for the applet, including
        ///  deleting it when no longer needed.
        /// <param> name="info" KPluginInfo object for the desired applet
        /// </param><param> name="appletId" unique ID to assign the applet, or zero to have one
        ///         assigned automatically.
        /// </param><param> name="args" to send the applet extra arguments
        /// </param></remarks>        <return> a pointer to the loaded applet, or 0 on load failure
        /// </return>
        ///         <short>    Attempts to load an applet </short>
        public static Plasma.Applet Load(KPluginInfo info, uint appletId, List<QVariant> args) {
            return (Plasma.Applet) staticInterceptor.Invoke("load#$?", "load(const KPluginInfo&, uint, const QList<QVariant>&)", typeof(Plasma.Applet), typeof(KPluginInfo), info, typeof(uint), appletId, typeof(List<QVariant>), args);
        }
        public static Plasma.Applet Load(KPluginInfo info, uint appletId) {
            return (Plasma.Applet) staticInterceptor.Invoke("load#$", "load(const KPluginInfo&, uint)", typeof(Plasma.Applet), typeof(KPluginInfo), info, typeof(uint), appletId);
        }
        public static Plasma.Applet Load(KPluginInfo info) {
            return (Plasma.Applet) staticInterceptor.Invoke("load#", "load(const KPluginInfo&)", typeof(Plasma.Applet), typeof(KPluginInfo), info);
        }
        /// <remarks>
        ///  Get the category of the given applet
        /// <param> name="applet" a KPluginInfo object for the applet
        ///          </param></remarks>        <short>    Get the category of the given applet </short>
        public static string category(KPluginInfo applet) {
            return (string) staticInterceptor.Invoke("category#", "category(const KPluginInfo&)", typeof(string), typeof(KPluginInfo), applet);
        }
        /// <remarks>
        ///  Get the category of the given applet
        /// <param> name="appletName" the name of the applet
        ///          </param></remarks>        <short>    Get the category of the given applet </short>
        public static string category(string appletName) {
            return (string) staticInterceptor.Invoke("category$", "category(const QString&)", typeof(string), typeof(string), appletName);
        }
        protected new IAppletSignals Emit {
            get { return (IAppletSignals) Q_EMIT; }
        }
    }

    public interface IAppletSignals : IQGraphicsWidgetSignals {
        /// <remarks>
        ///  This signal indicates that an application launch, window
        ///  creation or window focus event was triggered. This is used, for instance,
        ///  to ensure that the Dashboard view in Plasma hides when such an event is
        ///  triggered by an item it is displaying.
        ///          </remarks>        <short>    This signal indicates that an application launch, window  creation or window focus event was triggered.</short>
        [Q_SIGNAL("void releaseVisualFocus()")]
        void ReleaseVisualFocus();
        /// <remarks>
        ///  Emitted whenever the applet makes a geometry change, so that views
        ///  can coordinate themselves with these changes if they desire.
        ///          </remarks>        <short>    Emitted whenever the applet makes a geometry change, so that views  can coordinate themselves with these changes if they desire.</short>
        [Q_SIGNAL("void geometryChanged()")]
        void GeometryChanged();
        /// <remarks>
        ///  Emitted when an applet has changed values in its configuration
        ///  and wishes for them to be saved at the next save point. As this implies
        ///  disk activity, this signal should be used with care.
        ///  @note This does not need to be emitted from saveState by individual
        ///  applets.
        ///          </remarks>        <short>    Emitted when an applet has changed values in its configuration  and wishes for them to be saved at the next save point.</short>
        [Q_SIGNAL("void configNeedsSaving()")]
        void ConfigNeedsSaving();
        /// <remarks>
        ///  Emitted when activation is requested due to, for example, a global
        ///  keyboard shortcut. By default the wiget is given focus.
        ///          </remarks>        <short>    Emitted when activation is requested due to, for example, a global  keyboard shortcut.</short>
        [Q_SIGNAL("void activate()")]
        void Activate();
    }
}
