/*
 * Copyright (C) 2006  Remko Troncon
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef XMPP_HTMLELEMENT_H
#define XMPP_HTMLELEMENT_H

#include <QDomElement>
#include <iris_export.h>

class QString;

namespace XMPP
{
	class IRIS_EXPORT HTMLElement
	{
	public:
		HTMLElement();
		HTMLElement(const QDomElement &body);

		void setBody(const QDomElement &body);
		const QDomElement& body() const;
		QString toString(const QString &rootTagName = "body") const;
		QString text() const;

	private:
		QDomElement body_;
	};
}

#endif
