
/**
 *
 *  This file is part of the kdewebdev package
 *  Copyright (c) 2002 Keith Isdale <keith@kdewebdev.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef XSLDBGCONFIGIMPL_H
#define XSLDBGCONFIGIMPL_H

/**
  *@author Keith Isdale
  */

#include "ui_xsldbgconfig.h"
#include "xsldbgdialogbase.h"
#include <libxsldbg/options.h>

#include <QList>
#include <QWidget>
#include <QStringList>

class XsldbgDebugger;
class XsldbgSettingsModel;
class XsldbgParamModel;

class XsldbgConfigImpl : public QWidget, Ui::XsldbgConfig, public XsldbgDialogBase {
  Q_OBJECT

public:
        explicit XsldbgConfigImpl(QWidget *parent=0);
        ~XsldbgConfigImpl();
        void setModel(XsldbgSettingsModel *theModel);
        void addParam(const QString & name, const QString & value);
        void deleteParam(const QString & name);
        void show();

        bool selectProfile(const QString &profileName);
        QStringList profiles();

	/** return true if all data ok */
	bool isValid();


public slots:
	/** Update changes to xsldbg*/
	void update();

	/** refresh data from source */
	void refresh();

	/**Choose the XSL source file */
	void on_xslSourceButton_clicked();

	/**Choose the XML data file */
	void on_xmlDataButton_clicked();

	/**Choose the output file */
	void on_outputFileButton_clicked();

	/**Choose the working dir */
	void on_workDirButton_clicked();

	/** Configure dialog has request that a param be added */
	void slotAddParam();

	/** Configure dialog has request that a param be deleted */
	void slotDeleteParam();

	/** Apply the changes */
	void slotApply();

	/** Ignore any changes and hide dialog  */
	void slotCancel();

signals:
        void closing();
        void appliedSettings();
        void changed();

private:
	int paramIndex;
        QMap<int, QLineEdit*> lineEdits;
        QMap<int, QCheckBox*> checkBoxes;

        XsldbgSettingsModel *model;
        XsldbgParamModel *paramModel;

        bool updatesDisabled;
};

#endif
