//Auto-generated by kalyptus. DO NOT EDIT.
namespace Plasma {
    using Plasma;
    using System;
    using Kimono;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  @class Service plasma/service.h <Plasma/Service>
    ///  Plasma.Service allows interaction with a "destination", the definition of which
    ///  depends on the Service itself. For a network settings Service this might be a
    ///  profile name ("Home", "Office", "Road Warrior") while a web based Service this
    ///  might be a username ("aseigo", "stranger65").
    ///  A Service provides one or more operations, each of which provides some sort
    ///  of interaction with the destination. Operations are described using config
    ///  XML which is used to create a KConfig object with one group per operation.
    ///  The group names are used as the operation names, and the defined items in
    ///  the group are the parameters available to be set when using that operation.
    ///  A service is started with a KConfigGroup (representing a ready to be serviced
    ///  operation) and automatically deletes itself after completion and signaling
    ///  success or failure. See KJob for more information on this part of the process.
    ///  Services may either be loaded "stand alone" from plugins, or from a DataEngine
    ///  by passing in a source name to be used as the destination.
    ///  Sample use might look like:
    ///  @code
    ///  Plasma.DataEngine twitter = dataEngine("twitter");
    ///  Plasma.Service service = twitter.serviceForSource("aseigo");
    ///  KConfigGroup op = service.OperationDescription("update");
    ///  op.writeEntry("tweet", "Hacking on plasma!");
    ///  Plasma.ServiceJob job = service.StartOperationCall(op);
    ///  connect(job, SIGNAL("finished(KJob)"), this, SLOT("jobCompeted()"));
    ///  @endcode
    ///   See <see cref="IServiceSignals"></see> for signals emitted by Service
    /// </remarks>        <short> This class provides a generic API for write access to settings or services. </short>
    [SmokeClass("Plasma::Service")]
    public abstract class Service : QObject {
        protected Service(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Service), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static Service() {
            staticInterceptor = new SmokeInvocation(typeof(Service), null);
        }
        /// <remarks>
        ///  Sets the destination for this Service to operate on
        ///  @arg destination specific to each Service, this sets which
        ///                   target or address for ServiceJobs to operate on
        ///      </remarks>        <short>    Sets the destination for this Service to operate on </short>
        public void SetDestination(string destination) {
            interceptor.Invoke("setDestination$", "setDestination(const QString&)", typeof(void), typeof(string), destination);
        }
        /// <remarks>
        /// </remarks>        <return> the target destination, if any, that this service is associated with
        ///      </return>
        ///         <short>   </short>
        public string Destination() {
            return (string) interceptor.Invoke("destination", "destination() const", typeof(string));
        }
        /// <remarks>
        /// </remarks>        <return> the possible operations for this profile
        ///      </return>
        ///         <short>   </short>
        public List<string> OperationNames() {
            return (List<string>) interceptor.Invoke("operationNames", "operationNames() const", typeof(List<string>));
        }
        /// <remarks>
        ///  Retrieves the parameters for a given operation
        /// <param> name="operationName" the operation to retrieve parameters for
        /// </param></remarks>        <return> KConfigGroup containing the parameters
        ///      </return>
        ///         <short>    Retrieves the parameters for a given operation </short>
        public KConfigGroup OperationDescription(string operationName) {
            return (KConfigGroup) interceptor.Invoke("operationDescription$", "operationDescription(const QString&)", typeof(KConfigGroup), typeof(string), operationName);
        }
        /// <remarks>
        ///  Called to create a ServiceJob which is associated with a given
        ///  operation and parameter set.
        /// </remarks>        <return> a started ServiceJob; the consumer may connect to relevant
        ///          signals before returning to the event loop
        ///      </return>
        ///         <short>    Called to create a ServiceJob which is associated with a given  operation and parameter set.</short>
        public Plasma.ServiceJob StartOperationCall(KConfigGroup description, QObject parent) {
            return (Plasma.ServiceJob) interceptor.Invoke("startOperationCall##", "startOperationCall(const KConfigGroup&, QObject*)", typeof(Plasma.ServiceJob), typeof(KConfigGroup), description, typeof(QObject), parent);
        }
        public Plasma.ServiceJob StartOperationCall(KConfigGroup description) {
            return (Plasma.ServiceJob) interceptor.Invoke("startOperationCall#", "startOperationCall(const KConfigGroup&)", typeof(Plasma.ServiceJob), typeof(KConfigGroup), description);
        }
        /// <remarks>
        ///  Query to find if an operation is enabled or not.
        /// <param> name="operation" the name of the operation to check
        /// </param></remarks>        <return> true if the operation is enabled, false otherwise
        ///      </return>
        ///         <short>    Query to find if an operation is enabled or not.</short>
        public bool IsOperationEnabled(string operation) {
            return (bool) interceptor.Invoke("isOperationEnabled$", "isOperationEnabled(const QString&) const", typeof(bool), typeof(string), operation);
        }
        /// <remarks>
        ///  The name of this service
        ///      </remarks>        <short>    The name of this service      </short>
        public string Name() {
            return (string) interceptor.Invoke("name", "name() const", typeof(string));
        }
        /// <remarks>
        ///  Assoicates a widget with an operation, which allows the service to
        ///  automatically manage, for example, the enabled state of a widget.
        ///  This will remove any previous associations the widget had with
        ///  operations on this engine.
        /// <param> name="widget" the QWidget to associate with the service
        /// </param><param> name="operation" the operation to associate the widget with
        ///      </param></remarks>        <short>    Assoicates a widget with an operation, which allows the service to  automatically manage, for example, the enabled state of a widget.</short>
        public void AssociateWidget(QWidget widget, string operation) {
            interceptor.Invoke("associateWidget#$", "associateWidget(QWidget*, const QString&)", typeof(void), typeof(QWidget), widget, typeof(string), operation);
        }
        /// <remarks>
        ///  Disassociates a widget if it has been associated with an operation
        ///  on this service.
        ///  This will not change the enabled state of the widget.
        /// <param> name="widget" the QWidget to disassociate.
        ///      </param></remarks>        <short>    Disassociates a widget if it has been associated with an operation  on this service.</short>
        public void DisassociateWidget(QWidget widget) {
            interceptor.Invoke("disassociateWidget#", "disassociateWidget(QWidget*)", typeof(void), typeof(QWidget), widget);
        }
        /// <remarks>
        ///  Assoicates a widget with an operation, which allows the service to
        ///  automatically manage, for example, the enabled state of a widget.
        ///  This will remove any previous associations the widget had with
        ///  operations on this engine.
        /// <param> name="widget" the QGraphicsItem to associate with the service
        /// </param><param> name="operation" the operation to associate the widget with
        ///      </param></remarks>        <short>    Assoicates a widget with an operation, which allows the service to  automatically manage, for example, the enabled state of a widget.</short>
        public void AssociateWidget(QGraphicsWidget widget, string operation) {
            interceptor.Invoke("associateWidget#$", "associateWidget(QGraphicsWidget*, const QString&)", typeof(void), typeof(QGraphicsWidget), widget, typeof(string), operation);
        }
        /// <remarks>
        ///  Disassociates a widget if it has been associated with an operation
        ///  on this service.
        ///  This will not change the enabled state of the widget.
        /// <param> name="widget" the QGraphicsWidget to disassociate.
        ///      </param></remarks>        <short>    Disassociates a widget if it has been associated with an operation  on this service.</short>
        public void DisassociateWidget(QGraphicsWidget widget) {
            interceptor.Invoke("disassociateWidget#", "disassociateWidget(QGraphicsWidget*)", typeof(void), typeof(QGraphicsWidget), widget);
        }
        /// <remarks>
        ///  Default constructor
        ///  @arg parent the parent object for this service
        ///      </remarks>        <short>    Default constructor </short>
        public Service(QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Service#", "Service(QObject*)", typeof(void), typeof(QObject), parent);
        }
        public Service() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Service", "Service()", typeof(void));
        }
        /// <remarks>
        ///  Constructor for plugin loading
        ///      </remarks>        <short>    Constructor for plugin loading      </short>
        public Service(QObject parent, List<QVariant> args) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Service#?", "Service(QObject*, const QList<QVariant>&)", typeof(void), typeof(QObject), parent, typeof(List<QVariant>), args);
        }
        /// <remarks>
        ///  Called when a job should be created by the Service.
        /// <param> name="operation" which operation to work on
        /// </param><param> name="parameters" the parameters set by the user for the operation
        /// </param></remarks>        <return> a ServiceJob that can be started and monitored by the consumer
        ///      </return>
        ///         <short>    Called when a job should be created by the Service.</short>
        [SmokeMethod("createJob(const QString&, QMap<QString,QVariant>&)")]
        protected abstract Plasma.ServiceJob CreateJob(string operation, Dictionary<string, QVariant> parameters);
        /// <remarks>
        ///  By default this is based on the file in plasma/services/name.operations, but can be
        ///  reimplented to use a different mechanism.
        ///  It should result in a call to setOperationsScheme(QIODevice );
        ///      </remarks>        <short>    By default this is based on the file in plasma/services/name.</short>
        [SmokeMethod("registerOperationsScheme()")]
        protected virtual void RegisterOperationsScheme() {
            interceptor.Invoke("registerOperationsScheme", "registerOperationsScheme()", typeof(void));
        }
        /// <remarks>
        ///  Sets the XML used to define the operation schema for
        ///  this Service.
        ///      </remarks>        <short>    Sets the XML used to define the operation schema for  this Service.</short>
        protected void SetOperationsScheme(QIODevice xml) {
            interceptor.Invoke("setOperationsScheme#", "setOperationsScheme(QIODevice*)", typeof(void), typeof(QIODevice), xml);
        }
        /// <remarks>
        ///  Sets the name of the Service; useful for Services not loaded from plugins,
        ///  which use the plugin name for this.
        ///  @arg name the name to use for this service
        ///      </remarks>        <short>    Sets the name of the Service; useful for Services not loaded from plugins,  which use the plugin name for this.</short>
        protected void SetName(string name) {
            interceptor.Invoke("setName$", "setName(const QString&)", typeof(void), typeof(string), name);
        }
        /// <remarks>
        ///  Enables a given service by name
        /// <param> name="operation" the name of the operation to enable or disable
        /// </param><param> name="enable" true if the operation should be enabld, false if disabled
        ///      </param></remarks>        <short>    Enables a given service by name </short>
        protected void SetOperationEnabled(string operation, bool enable) {
            interceptor.Invoke("setOperationEnabled$$", "setOperationEnabled(const QString&, bool)", typeof(void), typeof(string), operation, typeof(bool), enable);
        }
        /// <remarks>
        ///  Used to load a given service from a plugin.
        /// <param> name="name" the plugin name of the service to load
        /// </param><param> name="parent" the parent object, if any, for the service
        /// </param></remarks>        <return> a Service object, guaranteed to be not null.
        ///      </return>
        ///         <short>    Used to load a given service from a plugin.</short>
        public static Plasma.Service Load(string name, QObject parent) {
            return (Plasma.Service) staticInterceptor.Invoke("load$#", "load(const QString&, QObject*)", typeof(Plasma.Service), typeof(string), name, typeof(QObject), parent);
        }
        public static Plasma.Service Load(string name) {
            return (Plasma.Service) staticInterceptor.Invoke("load$", "load(const QString&)", typeof(Plasma.Service), typeof(string), name);
        }
        protected new IServiceSignals Emit {
            get { return (IServiceSignals) Q_EMIT; }
        }
    }

    public interface IServiceSignals : IQObjectSignals {
        /// <remarks>
        ///  Emitted when a job associated with this Service completes its task
        ///      </remarks>        <short>    Emitted when a job associated with this Service completes its task      </short>
        [Q_SIGNAL("void finished(Plasma::ServiceJob*)")]
        void Finished(Plasma.ServiceJob job);
        /// <remarks>
        ///  Emitted when the Service's operations change. For example, a
        ///  media player service may change what operations are available
        ///  in response to the state of the player.
        ///      </remarks>        <short>    Emitted when the Service's operations change.</short>
        [Q_SIGNAL("void operationsChanged()")]
        void OperationsChanged();
    }
}
