//Auto-generated by kalyptus. DO NOT EDIT.
namespace KTextEditor {
    using Kimono;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  \brief Accessor interface for Editor part.
    ///  Topics:
    ///   - \ref editor_intro
    ///   - \ref editor_config
    ///   - \ref editor_notes
    ///   - \ref editor_extensions
    ///  \section editor_intro Introduction
    ///  The Editor part can be accessed via the KTextEditor.Factory or the
    ///  KTextEditor.EditorChooser and provides
    ///  general information and configuration methods for the Editor
    ///  implementation, for example KAboutData by using aboutData().
    ///  The Editor implementation has a list of all opened documents. Get this
    ///  list with documents(). To create a new Document call createDocument(). The
    ///  signal documentCreated() is emitted whenever the Editor created a new
    ///  document.
    ///  \section editor_config Editor Configuration
    ///  If the Editor implementation supports a config dialog
    ///  configDialogSupported() returns \e true, then the config dialog can be
    ///  shown with configDialog(). Instead of using the config dialog, the config
    ///  pages can be embedded into the application's config dialog. To do this,
    ///  configPages() returns the number of
    ///  config pages the Editor implementation provides and configPage() returns
    ///  the requested page. Further, a config page has a short descriptive name,
    ///  get it with configPageName(). You can get more detailed name by using
    ///  configPageFullName(). Also every config page has a pixmap, get it with
    ///  configPagePixmap(). The configuration can be saved and loaded with
    ///  readConfig() and writeConfig().
    ///  <b>Note:<> We recommend to embedd the config pages into the main application's
    ///        config dialog instead of using a separate config dialog, if the config
    ///        dialog does not look cluttered then. This way, all settings are grouped
    ///        together in one place.
    ///  \section editor_notes Implementation Notes
    ///  Usually only one instance of the Editor exists. The Kate Part
    ///  implementation internally uses a static accessor to make sure that only one
    ///  Kate Part Editor object exists. So several factories still use the same
    ///  Editor.
    ///  readConfig() and writeConfig() should be forwarded to all loaded plugins
    ///  as well, see KTextEditor.Plugin.ReadConfig() and
    ///  KTextEditor.Plugin.WriteConfig().
    ///  \section editor_extensions Editor Extension Interfaces
    ///  There is only a single extension interface for the Editor: the
    ///  CommandInterface. With the CommandInterface it is possible to add and
    ///  remove new command line commands which are valid for all documents. Common
    ///  use cases are for example commands like \e find or setting document
    ///  variables. For further details read the detailed descriptions in the class
    ///  KTextEditor.CommandInterface.
    ///  \see KTextEditor.Factory, KTextEditor.Document, KTextEditor.ConfigPage
    ///       KTextEditor.Plugin, KTextEditor.CommandInterface
    ///  \author Christoph Cullmann \<cullmann@kde.org\>
    ///   See <see cref="IEditorSignals"></see> for signals emitted by Editor
    /// </remarks>        <short>    \brief Accessor interface for Editor part.</short>
    [SmokeClass("KTextEditor::Editor")]
    public class Editor : QObject, IDisposable {
        protected Editor(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Editor), this);
        }
        /// <remarks>
        ///  Constructor.
        ///  Create the Editor object with <pre>parent</pre>.
        ///  \param parent parent object
        ///      </remarks>        <short>    Constructor.</short>
        public Editor(QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Editor#", "Editor(QObject*)", typeof(void), typeof(QObject), parent);
        }
        /// <remarks>
        ///  Switch the editor to a simple mode which will hide advanced
        ///  stuff from average user or switch it back to normal mode.
        ///  This mode will only affect documents/views created after the
        ///  change.
        ///  \param on turn simple mode on or not
        ///      </remarks>        <short>    Switch the editor to a simple mode which will hide advanced  stuff from average user or switch it back to normal mode.</short>
        public void SetSimpleMode(bool on) {
            interceptor.Invoke("setSimpleMode$", "setSimpleMode(bool)", typeof(void), typeof(bool), on);
        }
        /// <remarks>
        ///  Query the editor whether simple mode is on or not.
        ///  \return \e true if simple mode is on, otherwise \e false
        ///  \see setSimpleMode()
        ///      </remarks>        <short>    Query the editor whether simple mode is on or not.</short>
        public bool SimpleMode() {
            return (bool) interceptor.Invoke("simpleMode", "simpleMode() const", typeof(bool));
        }
        /// <remarks>
        ///  Create a new document object with <pre>parent</pre>.
        ///  \param parent parent object
        ///  \return new KTextEditor.Document object
        ///  \see documents()
        ///      </remarks>        <short>    Create a new document object with \p parent.</short>
        [SmokeMethod("createDocument(QObject*)")]
        public virtual KTextEditor.Document CreateDocument(QObject parent) {
            return (KTextEditor.Document) interceptor.Invoke("createDocument#", "createDocument(QObject*)", typeof(KTextEditor.Document), typeof(QObject), parent);
        }
        /// <remarks>
        ///  Get a list of all documents of this editor.
        ///  \return list of all existing documents
        ///  \see createDocument()
        ///      </remarks>        <short>    Get a list of all documents of this editor.</short>
        [SmokeMethod("documents()")]
        public virtual List<KTextEditor.Document> Documents() {
            return (List<KTextEditor.Document>) interceptor.Invoke("documents", "documents()", typeof(List<KTextEditor.Document>));
        }
        /// <remarks>
        ///  Get the about data of this Editor part.
        ///  \return about data
        ///      </remarks>        <short>    Get the about data of this Editor part.</short>
        [SmokeMethod("aboutData() const")]
        public virtual KAboutData AboutData() {
            return (KAboutData) interceptor.Invoke("aboutData", "aboutData() const", typeof(KAboutData));
        }
        /// <remarks>
        ///  Read editor configuration from KConfig <pre>config</pre>.
        ///  <b>Note:<> Implementation Notes: If <pre>config</pre> is NULL you should use
        ///        kapp.Config() as a fallback solution. Additionally the
        ///        readConfig() call should be forwarded to every loaded plugin.
        ///  \param config config object
        ///  \see writeConfig()
        ///      </remarks>        <short>    Read editor configuration from KConfig \p config.</short>
        [SmokeMethod("readConfig(KConfig*)")]
        public virtual void ReadConfig(KConfig config) {
            interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
        }
        [SmokeMethod("readConfig()")]
        public virtual void ReadConfig() {
            interceptor.Invoke("readConfig", "readConfig()", typeof(void));
        }
        /// <remarks>
        ///  Write editor configuration to KConfig <pre>config</pre>.
        ///  <b>Note:<> Implementation Notes: If <pre>config</pre> is NULL you should use
        ///        kapp.Config() as a fallback solution. Additionally the
        ///        writeConfig() call should be forwarded to every loaded plugin.
        ///  \param config config object
        ///  \see readConfig()
        ///      </remarks>        <short>    Write editor configuration to KConfig \p config.</short>
        [SmokeMethod("writeConfig(KConfig*)")]
        public virtual void WriteConfig(KConfig config) {
            interceptor.Invoke("writeConfig#", "writeConfig(KConfig*)", typeof(void), typeof(KConfig), config);
        }
        [SmokeMethod("writeConfig()")]
        public virtual void WriteConfig() {
            interceptor.Invoke("writeConfig", "writeConfig()", typeof(void));
        }
        /// <remarks>
        ///  Check, whether this editor has a configuration dialog.
        ///  \return \e true, if the editor has a configuration dialog,
        ///          otherwise \e false
        ///  \see configDialog()
        ///      </remarks>        <short>    Check, whether this editor has a configuration dialog.</short>
        [SmokeMethod("configDialogSupported() const")]
        public virtual bool ConfigDialogSupported() {
            return (bool) interceptor.Invoke("configDialogSupported", "configDialogSupported() const", typeof(bool));
        }
        /// <remarks>
        ///  Show the editor's config dialog, changes will be applied to the
        ///  editor, but not saved anywhere automagically, call <pre>writeConfig</pre>()
        ///  to save them.
        ///  <b>Note:<> Instead of using the config dialog, the config pages can be
        ///        embedded into your own config dialog by using configPages() and
        ///        configPage().
        ///  \param parent parent widget
        ///  \see configDialogSupported()
        ///      </remarks>        <short>    Show the editor's config dialog, changes will be applied to the  editor, but not saved anywhere automagically, call \p writeConfig()  to save them.</short>
        [SmokeMethod("configDialog(QWidget*)")]
        public virtual void ConfigDialog(QWidget parent) {
            interceptor.Invoke("configDialog#", "configDialog(QWidget*)", typeof(void), typeof(QWidget), parent);
        }
        /// <remarks>
        ///  Get the number of available config pages.
        ///  If the editor returns a number < 1, it does not support config pages
        ///  and the embedding application should use configDialog() instead.
        ///  \return number of config pages
        ///  \see configPage(), configDialog()
        ///      </remarks>        <short>    Get the number of available config pages.</short>
        [SmokeMethod("configPages() const")]
        public virtual int ConfigPages() {
            return (int) interceptor.Invoke("configPages", "configPages() const", typeof(int));
        }
        /// <remarks>
        ///  Get the config page with the <pre>number</pre>, config pages from 0 to
        ///  configPages()-1 are available if configPages() > 0.
        ///  \param number index of config page
        ///  \param parent parent widget for config page
        ///  \return created config page or NULL, if the number is out of bounds
        ///  \see configPages()
        ///      </remarks>        <short>    Get the config page with the \p number, config pages from 0 to  configPages()-1 are available if configPages() > 0.</short>
        [SmokeMethod("configPage(int, QWidget*)")]
        public virtual KTextEditor.ConfigPage ConfigPage(int number, QWidget parent) {
            return (KTextEditor.ConfigPage) interceptor.Invoke("configPage$#", "configPage(int, QWidget*)", typeof(KTextEditor.ConfigPage), typeof(int), number, typeof(QWidget), parent);
        }
        /// <remarks>
        ///  Get a readable name for the config page <pre>number</pre>. The name should be
        ///  translated.
        ///  \param number index of config page
        ///  \return name of given page index
        ///  \see configPageFullName(), configPagePixmap()
        ///      </remarks>        <short>    Get a readable name for the config page \p number.</short>
        [SmokeMethod("configPageName(int) const")]
        public virtual string ConfigPageName(int number) {
            return (string) interceptor.Invoke("configPageName$", "configPageName(int) const", typeof(string), typeof(int), number);
        }
        /// <remarks>
        ///  Get a readable full name for the config page \e number. The name
        ///  should be translated.
        ///  Example: If the name is "Filetypes", the full name could be
        ///  "Filetype Specific Settings". For "Shortcuts" the full name would be
        ///  something like "Shortcut Configuration".
        ///  \param number index of config page
        ///  \return full name of given page index
        ///  \see configPageName(), configPagePixmap()
        ///      </remarks>        <short>    Get a readable full name for the config page \e number.</short>
        [SmokeMethod("configPageFullName(int) const")]
        public virtual string ConfigPageFullName(int number) {
            return (string) interceptor.Invoke("configPageFullName$", "configPageFullName(int) const", typeof(string), typeof(int), number);
        }
        /// <remarks>
        ///  Get a pixmap with <pre>size</pre> for the config page <pre>number</pre>.
        ///  \param number index of config page
        ///  \return pixmap for the given page index
        ///  \see configPageName(), configPageFullName()
        ///      </remarks>        <short>    Get a pixmap with \p size for the config page \p number.</short>
        [SmokeMethod("configPageIcon(int) const")]
        public virtual KIcon ConfigPageIcon(int number) {
            return (KIcon) interceptor.Invoke("configPageIcon$", "configPageIcon(int) const", typeof(KIcon), typeof(int), number);
        }
        ~Editor() {
            interceptor.Invoke("~Editor", "~Editor()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~Editor", "~Editor()", typeof(void));
        }
        protected new IEditorSignals Emit {
            get { return (IEditorSignals) Q_EMIT; }
        }
    }

    public interface IEditorSignals : IQObjectSignals {
        /// <remarks>
        ///  The <pre>editor</pre> emits this signal whenever a <pre>document</pre> was successfully
        ///  created.
        ///  \param editor editor which created the new document
        ///  \param document the newly created document instance
        ///  \see createDocument()
        ///      </remarks>        <short>    The \p editor emits this signal whenever a \p document was successfully  created.</short>
        [Q_SIGNAL("void documentCreated(KTextEditor::Editor*, KTextEditor::Document*)")]
        void DocumentCreated(KTextEditor.Editor editor, KTextEditor.Document document);
    }
}
