//Auto-generated by kalyptus. DO NOT EDIT.
namespace KTextEditor {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  \brief KTextEditor Plugin interface.
    ///  Topics:
    ///   - \ref plugin_intro
    ///   - \ref plugin_config
    ///   - \ref plugin_sessions
    ///   - \ref plugin_arch
    ///  \section plugin_intro Introduction
    ///  The Plugin class provides methods to create loadable plugins for all
    ///  KTextEditor implementations. A plugin can handle several documents and
    ///  views. For every document the plugin should handle addDocument() is called
    ///  and for every view addView().
    ///  \section plugin_config Configuration Management
    ///  @todo write docu about config pages
    ///  @todo write docu about save/load settings
    ///  \section plugin_sessions Session Management
    ///  As an extension a Plugin can implement the SessionConfigInterface. This
    ///  interface provides functions to read and write session related settings.
    ///  If you have session dependent data additionally derive your Plugin from
    ///  this interface and implement the session related functions, for example:
    ///  <pre>
    ///  class MyPlugin : public KTextEditor.Plugin,
    ///                   public KTextEditor.SessionConfigInterface
    ///  {
    ///       Q_INTERFACES(KTextEditor.SessionConfigInterface)
    ///    // ...
    ///    void readSessionConfig (KConfig config);
    ///    void writeSessionConfig (KConfig config);
    ///  }
    ///  </pre>
    ///  \section plugin_arch Plugin Architecture
    ///  After the plugin is loaded the editor implementation should first call
    ///  readConfig() with a given KConfig object. After this it will call
    ///  addDocument() and addView() for all documents and views the plugin should
    ///  handle. If your plugin has a GUI it is common to add an extra class, like:
    ///  <pre>
    ///  class PluginView : public QObject, public KXMLGUIClient
    ///  {
    ///       public      // Constructor and other methods
    ///      PluginView( KTextEditor.View view ), KXMLGUIClient( view ), m_view( view )
    ///      { ... }
    ///      // ...
    ///  private:
    ///      KTextEditor.View m_view;
    ///  }
    ///  </pre>
    ///  Your KTextEditor.Plugin derived class then will create a new PluginView
    ///  for every View, i.e. for every call of addView().
    ///  The method removeView() will be called whenever a View is removed/closed.
    ///  If you have a PluginView for every view this is the place to remove it.
    ///  \see KTextEditor.Editor, KTextEditor.Document, KTextEditor.View,
    ///       KTextEditor.SessionConfigInterface
    ///  \author Christoph Cullmann \<cullmann@kde.org\>
    ///  </remarks>        <short>    \brief KTextEditor Plugin interface.</short>
    [SmokeClass("KTextEditor::Plugin")]
    public class Plugin : QObject, IDisposable {
        protected Plugin(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Plugin), this);
        }
        /// <remarks>
        ///  Constructor.
        ///  Create a new plugin.
        ///  \param parent parent object
        ///      </remarks>        <short>    Constructor.</short>
        public Plugin(QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Plugin#", "Plugin(QObject*)", typeof(void), typeof(QObject), parent);
        }
        /// <remarks>
        ///  Add a new <pre>document</pre> to the plugin.
        ///  This method is called whenever the plugin should handle another
        ///  <pre>document</pre>.
        ///  For every call of addDocument() will finally follow a call of
        ///  removeDocument(), i.e. the number of calls are identic.
        ///  \param document new document to handle
        ///  \see removeDocument(), addView()
        ///      </remarks>        <short>    Add a new \p document to the plugin.</short>
        [SmokeMethod("addDocument(KTextEditor::Document*)")]
        public virtual void AddDocument(KTextEditor.Document document) {
            interceptor.Invoke("addDocument#", "addDocument(KTextEditor::Document*)", typeof(void), typeof(KTextEditor.Document), document);
        }
        /// <remarks>
        ///  Remove the <pre>document</pre> from the plugin.
        ///  This method is called whenever the plugin should stop handling
        ///  the <pre>document</pre>.
        ///  For every call of addDocument() will finally follow a call of
        ///  removeDocument(), i.e. the number of calls are identic.
        ///  \param document document to hang the gui out from
        ///  \see addDocument(), removeView()
        ///      </remarks>        <short>    Remove the \p document from the plugin.</short>
        [SmokeMethod("removeDocument(KTextEditor::Document*)")]
        public virtual void RemoveDocument(KTextEditor.Document document) {
            interceptor.Invoke("removeDocument#", "removeDocument(KTextEditor::Document*)", typeof(void), typeof(KTextEditor.Document), document);
        }
        /// <remarks>
        ///  This method is called whenever the plugin should add its GUI to
        ///  <pre>view</pre>.
        ///  The process for the Editor can be roughly described as follows:
        ///    - add documents the plugin should handle via addDocument()
        ///    - for every document \e doc call addView() for \e every view for
        ///      \e doc.
        ///  For every call of addView() will finally follow a call of
        ///  removeView(), i.e. the number of calls are identic.
        ///  <b>Note:<> As addView() is called for \e every view in which the plugin's
        ///        GUI should be visible you must \e not add the GUI by
        ///        iterating over all Document.Views() yourself neither use the
        ///        signal Document.ViewCreated().
        ///  \param view view to hang the gui in
        ///  \see removeView(), addDocument()
        ///      </remarks>        <short>    This method is called whenever the plugin should add its GUI to  \p view.</short>
        [SmokeMethod("addView(KTextEditor::View*)")]
        public virtual void AddView(KTextEditor.View view) {
            interceptor.Invoke("addView#", "addView(KTextEditor::View*)", typeof(void), typeof(KTextEditor.View), view);
        }
        /// <remarks>
        ///  This method is called whenever the plugin should remove its GUI from
        ///  <pre>view</pre>.
        ///  For every call of addView() will finally follow a call of
        ///  removeView(), i.e. the number of calls are identic.
        ///  \param view view to hang the gui out from
        ///  \see addView(), removeDocument()
        ///      </remarks>        <short>    This method is called whenever the plugin should remove its GUI from  \p view.</short>
        [SmokeMethod("removeView(KTextEditor::View*)")]
        public virtual void RemoveView(KTextEditor.View view) {
            interceptor.Invoke("removeView#", "removeView(KTextEditor::View*)", typeof(void), typeof(KTextEditor.View), view);
        }
        ~Plugin() {
            interceptor.Invoke("~Plugin", "~Plugin()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~Plugin", "~Plugin()", typeof(void));
        }
        protected new IPluginSignals Emit {
            get { return (IPluginSignals) Q_EMIT; }
        }
    }

    public interface IPluginSignals : IQObjectSignals {
    }
}
