/*
	Copyright (C) 2003-2006 Cies Breijs <cies AT kde DOT nl>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this program; if not, write to the Free
	Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
	Boston, MA 02110-1301, USA.
*/


#ifndef _ECHOER_H_
#define _ECHOER_H_


#include "executer.h"

#include <kdebug.h>


/**
 * @short Echoes signals to a QTextStream
 *
 * Just echos the signals it gets.
 * Useful for creating UnitTests.
 *
 * @author Cies Breijs
 */
class Echoer : public QObject
{
	Q_OBJECT

	public:
		/**
		 * Default Constructor
		 */
		Echoer(QObject* parent = 0) { setParent(parent); }

		/**
		 * Default Destructor
		 */
		virtual ~Echoer() {}

		/**
		 * Connects all its slots to the signals of the Executer
		 */
		void connectAllSlots(Executer* executer) {
			// these connect calls connect all the Executers signals to this class' slots

//BEGIN GENERATED echoer_connect_h CODE

/* The code between the line that start with "//BEGIN GENERATED" and "//END GENERATED"
 * is generated by "generate.rb" according to the definitions specified in
 * "definitions.rb". Please make all changes in the "definitions.rb" file, since all
 * all change you make here will be overwritten the next time "generate.rb" is run.
 * Thanks for looking at the code!
 */

			connect(executer, SIGNAL(reset()),
				SLOT(reset()));
			connect(executer, SIGNAL(clear()),
				SLOT(clear()));
			connect(executer, SIGNAL(center()),
				SLOT(center()));
			connect(executer, SIGNAL(go(double, double)),
				SLOT(go(double, double)));
			connect(executer, SIGNAL(goX(double)),
				SLOT(goX(double)));
			connect(executer, SIGNAL(goY(double)),
				SLOT(goY(double)));
			connect(executer, SIGNAL(forward(double)),
				SLOT(forward(double)));
			connect(executer, SIGNAL(backward(double)),
				SLOT(backward(double)));
			connect(executer, SIGNAL(direction(double)),
				SLOT(direction(double)));
			connect(executer, SIGNAL(turnLeft(double)),
				SLOT(turnLeft(double)));
			connect(executer, SIGNAL(turnRight(double)),
				SLOT(turnRight(double)));
			connect(executer, SIGNAL(penWidth(double)),
				SLOT(penWidth(double)));
			connect(executer, SIGNAL(penUp()),
				SLOT(penUp()));
			connect(executer, SIGNAL(penDown()),
				SLOT(penDown()));
			connect(executer, SIGNAL(penColor(double, double, double)),
				SLOT(penColor(double, double, double)));
			connect(executer, SIGNAL(canvasColor(double, double, double)),
				SLOT(canvasColor(double, double, double)));
			connect(executer, SIGNAL(canvasSize(double, double)),
				SLOT(canvasSize(double, double)));
			connect(executer, SIGNAL(spriteShow()),
				SLOT(spriteShow()));
			connect(executer, SIGNAL(spriteHide()),
				SLOT(spriteHide()));
			connect(executer, SIGNAL(print(const QString&)),
				SLOT(print(const QString&)));
			connect(executer, SIGNAL(fontSize(double)),
				SLOT(fontSize(double)));

//END GENERATED echoer_connect_h CODE
		}


	public slots:
		// the generated code is a set of slots that are covering all the Executers signals...

//BEGIN GENERATED echoer_slots_h CODE

/* The code between the line that start with "//BEGIN GENERATED" and "//END GENERATED"
 * is generated by "generate.rb" according to the definitions specified in
 * "definitions.rb". Please make all changes in the "definitions.rb" file, since all
 * all change you make here will be overwritten the next time "generate.rb" is run.
 * Thanks for looking at the code!
 */

		void reset() { kDebug(0) << "SIG> " << "reset" << "(" << ")"; }
		void clear() { kDebug(0) << "SIG> " << "clear" << "(" << ")"; }
		void center() { kDebug(0) << "SIG> " << "center" << "(" << ")"; }
		void go(double arg0, double arg1) { kDebug(0) << "SIG> " << "go" << "(" << arg0 << "," << arg1 << ")"; }
		void goX(double arg0) { kDebug(0) << "SIG> " << "goX" << "(" << arg0 << ")"; }
		void goY(double arg0) { kDebug(0) << "SIG> " << "goY" << "(" << arg0 << ")"; }
		void forward(double arg0) { kDebug(0) << "SIG> " << "forward" << "(" << arg0 << ")"; }
		void backward(double arg0) { kDebug(0) << "SIG> " << "backward" << "(" << arg0 << ")"; }
		void direction(double arg0) { kDebug(0) << "SIG> " << "direction" << "(" << arg0 << ")"; }
		void turnLeft(double arg0) { kDebug(0) << "SIG> " << "turnLeft" << "(" << arg0 << ")"; }
		void turnRight(double arg0) { kDebug(0) << "SIG> " << "turnRight" << "(" << arg0 << ")"; }
		void penWidth(double arg0) { kDebug(0) << "SIG> " << "penWidth" << "(" << arg0 << ")"; }
		void penUp() { kDebug(0) << "SIG> " << "penUp" << "(" << ")"; }
		void penDown() { kDebug(0) << "SIG> " << "penDown" << "(" << ")"; }
		void penColor(double arg0, double arg1, double arg2) { kDebug(0) << "SIG> " << "penColor" << "(" << arg0 << "," << arg1 << "," << arg2 << ")"; }
		void canvasColor(double arg0, double arg1, double arg2) { kDebug(0) << "SIG> " << "canvasColor" << "(" << arg0 << "," << arg1 << "," << arg2 << ")"; }
		void canvasSize(double arg0, double arg1) { kDebug(0) << "SIG> " << "canvasSize" << "(" << arg0 << "," << arg1 << ")"; }
		void spriteShow() { kDebug(0) << "SIG> " << "spriteShow" << "(" << ")"; }
		void spriteHide() { kDebug(0) << "SIG> " << "spriteHide" << "(" << ")"; }
		void print(const QString& arg0) { kDebug(0) << "SIG> " << "print" << "(" << qPrintable(arg0) << ")"; }
		void fontSize(double arg0) { kDebug(0) << "SIG> " << "fontSize" << "(" << arg0 << ")"; }

//END GENERATED echoer_slots_h CODE

};

#endif  // _ECHOER_H_


