/*  This file is part of the KDE project
    Copyright (C) 2008 Lukas Appelhans <l.appelhans@gmx.de>
    Copyright (C) 2008 Alessandro Diaferia <alediaferia@gmail.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef PKITEM_H
#define PKITEM_H

#include <KIcon>

#include "abstractitem.h"
#include <polkit/polkit.h>

class Item : public AbstractItem
{
public:
    explicit Item(PolKitPolicyFileEntry* entry, AbstractItem* parent = 0);
    virtual ~Item();

    virtual QVariant data(int column, int datarole = Qt::DisplayRole);
    virtual bool isGroup() {
        return false;
    }
    virtual void setEntry(PolKitPolicyFileEntry *entry);
    virtual QString entryId() {
        return QString(polkit_policy_file_entry_get_id(m_entry));
    }
    PolKitPolicyFileEntry * fileEntry() {
        return m_entry;
    }

private:
    PolKitPolicyFileEntry* m_entry;
    KIcon m_icon;
};

#endif
