# - Try to find OCaml
# Once done this will define
#
#  OCAML_FOUND - system has OCaml
#  OCAML_OCAMLC_EXECUTABLE - the Libfacile include directory
#  OCAML_OCAMLDEP_EXECUTABLE - Link these to use Libfacile
#  OCAML_OCAMLOPT_EXECUTABLE - Compiler switches required for using Libfacile
#  OCAMLC_DIR
#
# Copyright (c) 2006, Carsten Niehaus, <cniehaus@gmx.de>
# Copyright (c) 2006, Montel Laurent, <montel@kde.org>
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.

if ( OCAML_OCAMLC_EXECUTABLE AND OCAML_OCAMLDEP_EXECUTABLE AND OCAML_OCAMLOPT_EXECUTABLE)

  # in cache already
  set(OCAML_FOUND TRUE)

else ( OCAML_OCAMLC_EXECUTABLE AND OCAML_OCAMLDEP_EXECUTABLE AND OCAML_OCAMLOPT_EXECUTABLE)

FIND_PROGRAM(OCAML_OCAMLC_EXECUTABLE NAMES ocamlc)
FIND_PROGRAM(OCAML_OCAMLDEP_EXECUTABLE NAMES ocamldep)
FIND_PROGRAM(OCAML_OCAMLOPT_EXECUTABLE NAMES ocamlopt)

if( OCAML_OCAMLC_EXECUTABLE AND OCAML_OCAMLDEP_EXECUTABLE AND OCAML_OCAMLOPT_EXECUTABLE)
   EXECUTE_PROCESS(COMMAND ${OCAML_OCAMLC_EXECUTABLE} -where OUTPUT_VARIABLE OCAMLC_DIR)
   STRING(REPLACE "\n" "" OCAMLC_DIR "${OCAMLC_DIR}")
   #MESSAGE(STATUS "ocamlc directory <${OCAMLC_DIR}>")

     # show the LIBFACILE_INCLUDE_DIR and LIBFACILE_LIBRARIES variables only in the advanced view
     MARK_AS_ADVANCED(LIBFACILE_INCLUDE_DIR LIBFACILE_LIBRARIES )
 
   set(OCAML_FOUND TRUE)
else( OCAML_OCAMLC_EXECUTABLE AND OCAML_OCAMLDEP_EXECUTABLE AND OCAML_OCAMLOPT_EXECUTABLE)

   if(NOT OCAML_OCAMLC_EXECUTABLE)
      message(STATUS "ocamlc not found.")
   endif(NOT OCAML_OCAMLC_EXECUTABLE)
   if(NOT OCAML_OCAMLDEP_EXECUTABLE)
      message(STATUS "ocamldep not found.")
   endif(NOT OCAML_OCAMLDEP_EXECUTABLE)
   if(NOT OCAML_OCAMLOPT_EXECUTABLE)
      message(STATUS "ocamlopt not found.")
   endif(NOT OCAML_OCAMLOPT_EXECUTABLE)
   set(OCAML_FOUND FALSE)
endif( OCAML_OCAMLC_EXECUTABLE AND OCAML_OCAMLDEP_EXECUTABLE AND OCAML_OCAMLOPT_EXECUTABLE)


IF(OCAML_FOUND)
   IF(NOT OCaml_FIND_QUIETLY)
      MESSAGE(STATUS "Found OCaml: ${OCAML_OCAMLC_EXECUTABLE}")
   ENDIF(NOT OCaml_FIND_QUIETLY)
ELSE(OCAML_FOUND)
   IF(OCaml_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "Could not find OCaml")
   ENDIF(OCaml_FIND_REQUIRED)
ENDIF(OCAML_FOUND)

endif ( OCAML_OCAMLC_EXECUTABLE AND OCAML_OCAMLDEP_EXECUTABLE AND OCAML_OCAMLOPT_EXECUTABLE)

